<?php
/**
 * Filename:       includes/lang/italian.inc.php
 * Function:       Language file.
 * Encoding:       UTF8
 * Author:         The MODx Project Team
 * Date:           27 December 2010
 * MODx version:   Evolution 1.0.5
 * Translation:    Nicola Lambathakis (Banzai), Kudolink, Diego Meozzi, Luigif 
*/
//$modx_textdir = 'rtl'; // uncomment this line for RTL languages
$modx_lang_attribute = 'it'; // Manager HTML/XML Language Attribute see http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'UTF-8';

$_lang["about_msg"] = 'MODx &egrave; un <a href="http://modxcms.com/what-is-modx.html" target="_blank">framework PHP e un sistema di gestione dei contenuti (CMS)</a> su licenza <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'Cos\'&egrave; MODx';
$_lang["access_permission_denied"] = 'Non avete i permessi per accedere alla Risorsa.';
$_lang["access_permission_parent_denied"] = 'Non avete il permesso di creare o spostare qui una Risorsa! Scegliete un\'altra destinazione';
$_lang["access_permissions"] = 'Permessi di accesso';
$_lang["access_permissions_add_resource_group"] = 'Crea un nuovo Gruppo di Risorse';
$_lang["access_permissions_add_user_group"] = 'Crea un nuovo Gruppo di Utenti';
$_lang["access_permissions_docs_collision"] = 'A causa di un conflitto fra il Web User Groups e Manager User Groups del vostro Ruolo, questa Risorsa sar&agrave; pubblica. Contattare un amministratore di sistema per maggiori chiarimenti.';
$_lang["access_permissions_docs_message"] = 'Qui potete selezionare a quali gruppi appartiene la Risorsa';
$_lang["access_permissions_group_link"] = 'Crea un nuovo gruppo';
$_lang["access_permissions_introtext"] = 'Qui potete gestire i Gruppi di Utenti e i Gruppi di Risorse. Per aggiungere un utente a un gruppo, modificate l\'utente e selezionate il gruppo di cui deve fare parte. Per assegnare una Risorsa ad un Gruppo di Utenti, modificate la Risorsa e selezionate i gruppi a cui deve appartenere.';
$_lang["access_permissions_link_to_group"] = 'al Gruppo Risorse';
$_lang["access_permissions_link_user_group"] = 'Link a Gruppo Utenti';
$_lang["access_permissions_links"] = 'Collegamenti Gruppi di Utenti/Risorse';
$_lang["access_permissions_links_tab"] = 'Qui potete specificare a quali Gruppi di Utenti &egrave; permesso l\'accesso ai Gruppi di Risorse (ad es.: possono modificare o creare Risorse). Per collegare un Gruppo di Risorse a un Gruppo di Utenti, selezionatelo dalla lista a tendina, e fate clic su \'Aggiungi gruppo\'. Per rimuovere il collegamento ad un certo gruppo premete \'Rimuovi ->\'. Il collegamento sar&agrave; immediatamente eliminato.';
$_lang["access_permissions_no_resources_in_group"] = 'Nessuno.';
$_lang["access_permissions_no_users_in_group"] = 'Nessuno.';
$_lang["access_permissions_off"] = '<span class=\'warning\'>I permessi di accesso non sono stati attivati.</span> Questo significa che qualsiasi modifica qui eseguita non avr&agrave; alcun effetto finch&egrave; i permessi di accesso non saranno attivati.';
$_lang["access_permissions_resource_groups"] = 'Gruppi di Risorse';
$_lang["access_permissions_resources_in_group"] = '<b>Risorse nel gruppo:</b> ';
$_lang["access_permissions_resources_tab"] = 'Qui potete vedere i Gruppi di Risorse che sono stati impostati. Potete anche crearne di nuovi, rinominarli, eliminarli e vedere quali Risorse sono presenti nei differenti gruppi (posizionate il mouse sull\'id della Risorsa per vederne il nome). Per aggiungere una Risorsa ad un gruppo o per rimuoverla da un gruppo, modificate direttamente la Risorsa.';
$_lang["access_permissions_user_groups"] = 'Gruppi di Utenti';
$_lang["access_permissions_user_message"] = 'Qui potete selezionare a quali Gruppi di Utenti appartiene l\'utente:';
$_lang["access_permissions_users_in_group"] = '<b>Utenti del gruppo:</b> ';
$_lang["access_permissions_users_tab"] = 'Qui potete vedere i Gruppi di Utenti che sono stati impostati. Potete anche crearne di nuovi, rinominarli, eliminarli e vedere quali utenti fanno parte dei differenti gruppi. Per aggiungere un nuovo utente a un gruppo o per rimuoverlo da un gruppo, modificate direttamente l\'utente. Gli amministratori (utenti a cui &egrave; assegnato il ruolo con ID 1) hanno sempre accesso a tutte le Risorse, quindi non hanno necessit&agrave; di essere aggiunti ad alcun gruppo.';
$_lang["account_email"] = 'Indirizzo email';
$_lang["actioncomplete"] = '<b>Azione completata con successo!</b><br />Vi preghiamo di attendere che MODx ripulisca.';
$_lang["activity_message"] = 'Questa lista mostra le ultime Risorse che avete creato o modificato:';
$_lang["activity_title"] = 'Risorse modificate o create di recente';
$_lang["add"] = 'Aggiungi';
$_lang["add_chunk"] = 'Aggiungi Chunk';
$_lang["add_doc"] = 'Aggiungi Risorsa';
$_lang["add_folder"] = 'Nuova cartella';
$_lang["add_plugin"] = 'Aggiungi Plugin';
$_lang["add_resource"] = 'Nuova Risorsa';
$_lang["add_snippet"] = 'Aggiungi Snippet';
$_lang["add_tag"] = 'Aggiungi tag';
$_lang["add_template"] = 'Aggiungi Template';
$_lang["add_tv"] = 'Aggiungi TV';
$_lang["add_weblink"] = 'Nuovo Link Web';
$_lang["administrator_role_message"] = 'Questo Ruolo non pu&ograve; essere modificato o eliminato.';
$_lang["administrators"] = 'Amministratori';
$_lang["after_saving"] = 'Dopo il salvataggio';
$_lang["alert_delete_self"] = 'Non potete eliminare voi stessi!';
$_lang["alias"] = 'Alias';
$_lang["all_doc_groups"] = 'Tutti i Gruppi di Risorse (Pubblico)';
$_lang["all_events"] = 'Tutti gli eventi';
$_lang["all_usr_groups"] = 'Tutti i Gruppi di Utenti (Pubblico)';
$_lang["allow_mgr_access"] = 'Accesso interfaccia di amministrazione';
$_lang["allow_mgr_access_message"] = 'Selezionate questa opzione per abilitare o disabilitare ad accedere alla interfaccia di amministrazione. <b>NOTA: Se questa opzione &egrave; attiva, gli utenti verranno ridiretti alla Interfaccia di amministrazione o alla pagina di inizio del sito.</b>';
$_lang["already_deleted"] = '&egrave; gi&agrave; stato eliminato.';
$_lang["attachment"] = 'Allegato';
$_lang["automatic_alias_message"] = 'Selezionate \'Si\' affinch&egrave; il sistema, al momento del salvataggio, generi automaticamente un alias basato sul titolo della Risorsa.';
$_lang["automatic_alias_title"] = 'Genera automaticamente l\'alias:';
$_lang["backup"] = 'Copia di sicurezza';
$_lang["bk_manager"] = 'Copia di sicurezza';
$_lang["block_message"] = 'L\'utente sar&agrave; bloccato dopo aver salvato i suoi dati!';
$_lang["blocked_minutes_message"] = 'Qui potete inserire per quanti minuti un utente sar&agrave; bloccato dopo aver oltrepassato il limite consentito di login errati. Solo la cifra, senza punti o virgole.';
$_lang["blocked_minutes_title"] = 'Minuti di blocco:';
$_lang["cache_files_deleted"] = 'Sono stati eliminati i seguenti file:';
$_lang["cancel"] = 'Annulla';
$_lang["captcha_code"] = 'Codice di sicurezza';
$_lang["captcha_message"] = 'Abilitatelo per aumentare la sicurezza richiedendo agli utenti di inserire un codice illeggibile per le macchine (e per gli script degli hacker scriptkiddy).';
$_lang["captcha_title"] = 'Usa codici CAPTCHA:';
$_lang["captcha_words_default"] = 'MODx,Access,Better,BitCode,Chunk,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Oscope,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Tattoo,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote';
$_lang["captcha_words_message"] = 'Qui potete inserire una lista di parole CAPTCHA da usare quando CAPTCHA &egrave; abilitato. Separate le parole con virgole. Questo campo &egrave; limitato a 255 caratteri.';
$_lang["captcha_words_title"] = 'Parole CAPTCHA';
$_lang["category_heading"] = 'Categoria';
$_lang["category_msg"] = 'Qui potete vedere tutte le Risorse per categoria.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Cambia nome';
$_lang["change_password"] = 'Cambia password';
$_lang["change_password_confirm"] = 'Conferma password';
$_lang["change_password_message"] = 'Inserite la nuova password e successivamente riscrivetela per conferma. La password deve essere compresa fra 6 e 15 caratteri.';
$_lang["change_password_new"] = 'Nuova password';
$_lang["charset_message"] = 'Selezionate la codifica caratteri che intendete usare nel manager. Da notare che MODx &egrave; stato testato con numerose codifiche, ma non con tutte. Per la maggior parte delle lingue, la codifica ISO-8859-1 impostata di default &egrave; sufficiente.';
$_lang["charset_title"] = 'Codifica carattere:';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Codice Chunk (html)';
$_lang["chunk_multiple_id"] = 'Errore: Diversi Chunks utilizzano lo stesso ID.';
$_lang["chunk_no_exist"] = 'Il Chunk non esiste.';
$_lang["clean_uploaded_filename"] = 'Correggi i nomi dei files caricati';
$_lang["clean_uploaded_filename_message"] = 'Usa la configurazione di default o quella di transalias per eliminare dal nome dei files caricati i caratteri speciali, mantenendo i punti (.)';
$_lang["cleaningup"] = 'Sto ripulendo';
$_lang["clear_log"] = 'Pulisci log';
$_lang["click_to_context"] = 'Cliccate per accedere al menu contestuale';
$_lang["click_to_edit_title"] = 'Cliccate qui per modificare questo record';
$_lang["click_to_view_details"] = 'Cliccate qui per vedere i dettagli';
$_lang["close"] = 'Chiudi';
$_lang["code"] = 'Codice';
$_lang["collapse_tree"] = 'Comprimi struttura ad albero';
$_lang["comment"] = 'Commenti';
$_lang["configcheck_admin"] = 'Vi preghiamo di contattare gli amministratori di sistema e avvisarli di questo messaggio!';
$_lang["configcheck_cache"] = 'cartella cache non scrivibile';
$_lang["configcheck_cache_msg"] = 'MODx non pu&ograve; scrivere nella cartella cache. MODx continuer&agrave; a funzionare come previsto, ma non avverr&agrave; alcuna operazione di caching. Per risolvere, rendete la cartella /_cache/ scrivibile.';
$_lang["configcheck_configinc"] = 'Il file di configurazione (/manager/includes/config.inc.php) &egrave; ancora scrivibile';
$_lang["configcheck_configinc_msg"] = 'Malintenzionati potrebbero combinare guai sul vostro sito e tutto ci&ograve; che &egrave; collegato ad esso. <strong>Sul serio.</strong> Impostate il file di configurazione (/manager/includes/config.inc.php) in sola lettura!';
$_lang["configcheck_default_msg"] = 'E\' stato trovato un avviso non specificato. Che &egrave; sconosciuto.';
$_lang["configcheck_errorpage_unavailable"] = 'La pagina di Errore del vostro sito non &egrave; disponibile.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Ci&ograve; significa che la pagina di Errore non &egrave; accessibile da parte di normali visitatori web oppure non esiste. Questo fatto pu&ograve; portare ad una condizione di loop ricorsivo e generare numerosi errori nel log del vostro sito. Verificate che non ci siano Gruppi di Utenti Web assegnati a questa pagina.';
$_lang["configcheck_errorpage_unpublished"] = 'La pagina di Errore del vostro sito non &egrave; stata pubblicata oppure &egrave; inesistente.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Ci&ograve; significa che la pagina di Errore &egrave; inaccessibile da parte del pubblico. Pubblicate la pagina o selezionate una Risorsa esistente nella struttura ad albero del vostro sito dal menu Strumenti -> Configurazione.';
$_lang["configcheck_hide_warning"] = '<a href="javascript:hideConfigCheckWarning(\'%s\');"><em>Non mostrare ancora il messaggio.</em></a>';
$_lang["configcheck_images"] = 'Cartella immagini non scrivibile';
$_lang["configcheck_images_msg"] = 'La cartella immagini non &egrave; scrivibile o non esiste. Questo significa che il sistema di gestione immagini dell\'editor non funzioner&agrave;!';
$_lang["configcheck_installer"] = 'Installer ancora presente';
$_lang["configcheck_installer_msg"] = 'La cartella install/ contiene l\'installer di MODx. Immaginate cosa pu&ograve; accadere se un malintenzionato trova questa cartella ed esegue l\'installer! Probabilmente non andrebbe troppo lontano perch&grave; dovrebbe fornire alcune informazioni utente per il database, ma &egrave; sempre meglio rimuovere questa cartella dal server.';
$_lang["configcheck_lang_difference"] = 'Numero errato di voci nel file di lingua';
$_lang["configcheck_lang_difference_msg"] = 'La lingua correntemente selezionata ha un differente numero di voci rispetto alla lingua di default. Pur non essendo necessariamente un problema, questo significa che il file di lingua richiede un aggiornamento.';
$_lang["configcheck_notok"] = 'Uno o pi&ugrave; dettagli della configurazione vanno verificati: ';
$_lang["configcheck_ok"] = 'Controllo OK - nessun avviso da riportare.';
$_lang["configcheck_php_gdzip"] = 'Estensioni PHP GD e/o Zip PHP non trovate';
$_lang["configcheck_php_gdzip_msg"] = 'MODx richiede le estensioni PHP GD e Zip. MODx funziona anche senza, ma non potrete utilizzare File Manager, Image Editor e Captcha.';
$_lang["configcheck_register_globals"] = 'Nel vostro file di configurazione php.ini, il valore register_globals &egrave; impostato su ON';
$_lang["configcheck_register_globals_msg"] = 'Questa configurazione rende il vostro sito molto pi&ugrave; suscettibile agli attacchi di Cross Site Scripting (XSS). Contattate il vostro fornitore di hosting per trovare cosa si pu&ograve; fare per disabilitare questa impostazione.';
$_lang["configcheck_templateswitcher_present"] = 'Rilevato il Plugin TemplateSwitcher';
$_lang["configcheck_templateswitcher_present_delete"] = '<a href="javascript:deleteTemplateSwitcher();">Elimina TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_disable"] = '<a href="javascript:disableTemplateSwitcher();">Disabilita TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_msg"] = 'Il plugin TemplateSwitcher puo\' creare problemi di prestazioni e caching, vi consigliamo di utilizzarlo solo se necessario.';
$_lang["configcheck_title"] = 'Controllo configurazione';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'La pagina Non Autorizzato del vostro sito non &egrave; stata pubblicata o &egrave; inesistente';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Ci&ograve; significa che la pagina di Non Autorizzato non &egrave; accessibile da parte di normali visitatori web oppure non esiste. Questo fatto pu&ograve; portare ad una condizione di loop ricorsivo e generare numerosi errori nel log del vostro sito. Verificate che non ci siano Gruppi di Utenti Web assegnati a questa pagina.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'La pagina Non Autorizzato del vostro sito non &egrave; stata pubblicata.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Ci&ograve; significa che la pagina di Non Autorizzato non &egrave; accessibile ai visitatori. Publicate la pagina o selezionate una Risorsa esistente nella struttura ad albero del vostro sito dal menu Strumenti -> Configurazione.';
$_lang["configcheck_validate_referer"] = 'Avviso di Sicurezza: Validazione HTTP Headers';
$_lang["configcheck_validate_referer_msg"] = "L'opzione di <strong>Validazione degli headers HTTP_REFERER?</strong> non &egrave; attivata. Raccomandiamo di attivarla. <a href=\"index.php?a=17\">Vai alle Opzioni di Configurazione</a>";
$_lang["configcheck_warning"] = 'Avviso di configurazione:';
$_lang["configcheck_what"] = 'Che cosa significa?';
$_lang["confirm_block"] = 'Siete sicuri di voler bloccare l\'utente?';
$_lang["confirm_delete_eventlog"] = 'Siete sicuri di voler cancellare questo log?';
$_lang["confirm_delete_file"] = 'Siete sicuri di voler eliminare il file?\n\nQuesto potrebbe impedire al sito di funzionare regolarmente! Eliminatelo solo se avete la certezza che quello che state facendo non pregiudica nulla.';
$_lang["confirm_delete_htmlsnippet"] = 'Siete sicuri di voler eliminare il chunk?';
$_lang["confirm_delete_keywords"] = 'Siete sicuri di voler eliminare le parole chiave?';
$_lang["confirm_delete_module"] = 'Siete sicuri di voler cancellare il modulo?';
$_lang["confirm_delete_plugin"] = 'Siete sicuri di voler eliminare questo plugin?';
$_lang["confirm_delete_record"] = 'Siete sicuri di voler eliminare questo record(s)?';
$_lang["confirm_delete_resource"] = 'Siete sicuri di voler eliminare questa Risorsa?\nSaranno eliminati anche tutte le Risorse in essa contenute.';
$_lang["confirm_delete_role"] = 'Siete sicuri di voler eliminare questo ruolo?';
$_lang["confirm_delete_snippet"] = 'Siete sicuri di voler eliminare lo snippet?';
$_lang["confirm_delete_tags"] = 'Siete sicuri di voler cancellare questo META tag?';
$_lang["confirm_delete_template"] = 'Siete sicuri di voler eliminare il template?';
$_lang["confirm_delete_tmplvars"] = 'Siete sicuri di voler rimuovere la variabile e tutti i suoi valori?';
$_lang["confirm_delete_user"] = 'Siete sicuri di voler eliminare l\'utente?';
$_lang["confirm_duplicate_record"] = 'Siete sicuri di voler duplicare questo record?';
$_lang["confirm_empty_trash"] = 'Volete rimuovere permanentemente tutte le Risorse eliminate?\n\nProcedere?';
$_lang["confirm_load_depends"] = 'Siete sicuri di voler caricare le impostazioni Dipendenze senza salvare le modifiche?';
$_lang["confirm_name_change"] = 'Cambiare nome pu&ograve; avere effetto su altre applicazioni collegate al Sistema di Gestione dei Contenuti. \n\n Siete sicuri di voler cambiare il nome utente?';
$_lang["confirm_publish"] = '\n\nPubblicando ora la Risorsa rimuoverete ogni data di pubblicazione o ritiro che potreste aver impostato. Se invece volete cambiare o mantenere le date di pubblicazione/ritiro, allora scegliete la \'modifica\' della Risorsa.\n\nProcedere?';
$_lang["confirm_remove_locks"] = 'Gli utenti a volte chiudono il browser mentre stanno modificando Risorse, templates, snippets, lasciando con ogni probabilita\' tali oggetti in stato di blocco. Premendo OK potete rimuovere TUTTI i blocchi attualmente presenti.\n\nProcedere?';
$_lang["confirm_resource_duplicate"] = 'Siete sicuri di voler duplicare questa Risorsa/cartella?\nSotto cartelle e Risorse saranno duplicate.\n\n Note: i dati esterni (ad es. parole chiave, variabili di template, ecc.) non saranno duplicati.';
$_lang["confirm_setting_language_change"] = 'Avete modificato il valore di default e si perderanno le modifiche. Procedere?';
$_lang["confirm_unblock"] = 'Siete sicuri di voler sbloccare l\'utente?';
$_lang["confirm_undelete"] = '\n\nTutte le Risorse eliminate insieme alla Risorsa genitore potranno essere recuperati, ma non quelle eliminate in precedenza.';
$_lang["confirm_unpublish"] = '\n\nRitirando ora la Risorsa rimuoverete ogni data di pubblicazione o ritiro che potreste aver impostato. Se invece volete cambiare o mantenere le date di pubblicazione/ritiro, allora scegliete la \'modifica\' della Risorsa.\n\nProcedere?';
$_lang["confirm_unzip_file"] = 'Siete sicuri di voler decomprimere il file?\n\nI file esistenti potrebbero essere sovrascritti.';
$_lang["could_not_find_user"] = 'Utente non trovato';
$_lang["create_folder_here"] = 'Crea una cartella qui';
$_lang["create_resource_here"] = 'Crea una Risorsa qui';
$_lang["create_resource_title"] = 'Crea Risorsa';
$_lang["create_weblink_here"] = 'Crea un Link Web qui';
$_lang["createdon"] = 'Data creazione';
$_lang["credits"] = 'Crediti';
$_lang["credits_shouts_msg"] = '<p>MODx &egrave; gestito e mantenuto su <a href="http://modxcms.com/about/" target="_blank">MODxCMS.com</a>.</p>';
$_lang["custom_contenttype_message"] = 'qui potete impostare il formato del contenuto delle Risorse pubblicate. Per aggiungere un nuovo formato, inserite il tipo di contenuto nel campo e cliccate sul pulsante \'Aggiungi\'.';
$_lang["custom_contenttype_title"] = 'Tipo di Contenuto personalizzato:';
$_lang["database_charset"] = 'Set di Caratteri del Database';
$_lang["database_collation"] = 'Collation del Database';
$_lang["database_name"] = 'Nome del Database';
$_lang["database_overhead"] = '<b style=\'color:#990033\'>Note:</b> L\'Overhead &egrave; lo spazio inutilizzato riservato da MySQL. Per liberare questo spazio, cliccate sulla cifra overhead della tabella.';
$_lang["database_server"] = 'Server del Database';
$_lang["database_table_clickbackup"] = 'per fare una copia di sicurezza e scaricare le tabelle selezionate';
$_lang["database_table_clickhere"] = 'Cliccate qui';
$_lang["database_table_datasize"] = 'Dimensione dei dati';
$_lang["database_table_droptablestatements"] = 'Genera dichiarazioni DROP TABLE.';
$_lang["database_table_effectivesize"] = 'Dimensioni effettive';
$_lang["database_table_indexsize"] = 'Dimensioni indice';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Record';
$_lang["database_table_tablename"] = 'Nome tabella';
$_lang["database_table_totals"] = 'Totali:';
$_lang["database_table_totalsize"] = 'Dimensione totale';
$_lang["database_tables"] = 'Tabelle del Database';
$_lang["database_version"] = 'Versione Database:';
$_lang["date"] = 'Data';
$_lang["datechanged"] = 'Data modificata';
$_lang["datepicker_offset"] = 'Offset del Datepicker: ';
$_lang["datepicker_offset_message"] = 'Il numero di anni nel passato da mostrare nel datepicker.';
$_lang["datetime_format"] = 'Formato Data:';
$_lang["datetime_format_message"] = 'Il formato delle date nel Manager.';
$_lang["default"] = 'Default:'; 
$_lang["defaultcache_message"] = 'Selezionate \'si\' se volete che di default tutte le nuove Risorse siano salvate nella cache.';
$_lang["defaultcache_title"] = 'Inserisci in cache di default';
$_lang["defaultmenuindex_message"] = 'Selezionate \'si\' per attivare di default l\'incremento automatico dell\'indice del menu.';
$_lang["defaultmenuindex_title"] = 'Indicizzazione Menu di default';
$_lang["defaultpublish_message"] = 'Selezionate \'si\' se volete che tutte le nuove Risorse siano pubblicate di default.';
$_lang["defaultpublish_title"] = 'Pubblicato di default';
$_lang["defaultsearch_message"] = 'Selezionate \'si\' se volete che tutte le nuove Risorse siano ricercabili di default.';
$_lang["defaultsearch_title"] = 'Ricercabile di default';
$_lang["defaulttemplate_message"] = 'Selezionate il template di default che desiderate usare per le nuove Risorse. Potete sempre selezionarne uno diverso nell\'editor di Risorse, questa impostazione semplicemente ne preseleziona uno per voi.';
$_lang["defaulttemplate_title"] = 'Template di default';
$_lang["defaulttemplate_logic_title"] = 'Assegnazione Automatica del Template';
$_lang["defaulttemplate_logic_general_message"] = 'Le nuove Risorse avranno i seguenti templates, verranno utilizzati i livelli piu\' alti se non trovati:';
$_lang["defaulttemplate_logic_system_message"] = '<strong>System</strong>: il Template di default del Sistema.';
$_lang["defaulttemplate_logic_parent_message"] = '<strong>Parent</strong>: lo stesso template della cartella.';
$_lang["defaulttemplate_logic_sibling_message"] = '<strong>Sibling</strong>: lo stesso template delle Risorse nella stessa cartella.';
$_lang["delete"] = 'Elimina';
$_lang["delete_resource"] = 'Elimina Risorsa';
$_lang["delete_tags"] = 'Cancella tag';
$_lang["deleting_file"] = 'Eliminazione file `%s`: ';
$_lang["description"] = 'Descrizione';
$_lang["deselect_keywords"] = 'Cancella parole chiave';
$_lang["deselect_metatags"] = 'Cancella META tag';
$_lang["disabled"] = 'Disabilitati';
$_lang["doc_data_title"] = 'Visualizza dati della Risorsa';
$_lang["duplicate"] = 'Duplica';
$_lang["duplicate_alias_found"] = 'La Risorsa \'%s\' utilizza gi&agrave; l\'alias \'%s\'. Inserire un altro alias.';
$_lang["duplicate_alias_message"] = 'Qui potete impostare \'si\' per permettere gli alias duplicati. <b>NOTA: Questa opzione deve essere usata con l\'opzione \'Percorso URL semplici\' attiva per evitare problemi di riferimenti alle Risorse.</b>';
$_lang["duplicate_alias_title"] = 'Permetti alias duplicati:';
$_lang["duplicate_name_found_general"] = 'E\' gi&agrave; presente un %s chiamato \'%s\'. Inserite un nome univoco.';
$_lang["duplicate_name_found_module"] = 'E\' gi&agrave; presente un Modulo chiamato \'%s\'. Inserite un nome univoco.';
$_lang["edit"] = 'Modifica';
$_lang["edit_resource"] = 'Modifica Risorsa';
$_lang["edit_resource_title"] = 'Crea/modifica Risorsa';
$_lang["edit_settings"] = 'Configurazione';
$_lang["editedon"] = 'Data modifica';
$_lang["editing_file"] = 'Modifica file: ';
$_lang["editor_css_path_message"] = 'Inserite il percorso del file CSS che volete usare con l\'editor. Il miglior metodo &egrave; inserire il percorso dalla root del tuo server, ad esempio: /assets/site/style.css. Se non volete caricare lo stile nell\'editor, lasciate vuoto questo campo.';
$_lang["editor_css_path_title"] = 'Percorso del file CSS:';
$_lang["element"] = 'Elemento';
$_lang["element_categories"] = 'Vista Combinata';
$_lang["element_management"] = 'Gestione Elementi';
$_lang["element_name"] = 'Nome Elemento';
$_lang["element_selector_msg"] = 'Selezionate l\'Elemento e cliccate sul pulsante \'Aggiungi\'.';
$_lang["element_selector_title"] = 'Selettore Elementi';
$_lang["elements"] = 'Elementi';
$_lang["email"] = 'Email';
$_lang["email_sent"] = 'Email inviata';
$_lang["emailsender_message"] = 'Qui potete specificare l\'indirizzo e-mail da usare per l\'invio del nome utente e della password agli utenti.';
$_lang["emailsender_title"] = 'Indirizzo e-mail:';
$_lang["emailsubject_default"] = 'Le vostre credenziali per il login';
$_lang["emailsubject_message"] = 'Qui potete specificare l\'oggetto della e-mail di iscrizione.';
$_lang["emailsubject_title"] = 'Oggetto e-mail:';
$_lang["empty_folder"] = 'Questa cartella &egrave; vuota';
$_lang["empty_recycle_bin"] = 'Rimuovi le Risorse eliminate';
$_lang["empty_recycle_bin_empty"] = 'Non sono presenti Risorse eliminate da cancellare.';
$_lang["enable_resource"] = 'Abilita Risorsa.';
$_lang["enable_sharedparams"] = 'Abilita condivisione parametri';
$_lang["enable_sharedparams_msg"] = '<b>NOTE:</b> L\'id unico globale (GUID) sar&agrave; usato per identificare in maniera univoca questo modulo e i suoi parametri condivisi. Il GUID &egrave; anche utilizzato per creare un collegamento tra il modulo ed i plugins o snippets che accedono ai suoi parametri condivisi. ';
$_lang["enabled"] = 'Abilitati';
$_lang["error"] = 'Errore';
$_lang["error_sending_email"] = 'Errore invio mail';
$_lang["errorpage_message"] = 'Inserite l\'ID della Risorsa da mostrare agli utenti che hanno richiesto una Risorsa che in realt&agrave; potrebbe non esistere. <b>NOTA: assicuratevi che l\'ID inserito appartenga a una Risorsa esistente e che sia stata pubblicata!</b>';
$_lang["errorpage_title"] = 'Pagina di errore:';
$_lang["event_id"] = 'Id Evento';
$_lang["eventlog"] = 'Log degli Eventi';
$_lang["eventlog_msg"] = 'Il Log degli Eventi mostra gli avvisi ed i messaggi di errore generati dal sistema di gestione dei contenuti. La colonna \'Sorgente\' mostra la sezione del sistema di gestione dei contenuti in cui il messaggio &egrave; stato mostrato.';
$_lang["eventlog_viewer"] = 'Visualizzazione Log Eventi';
$_lang["everybody"] = 'Tutti';
$_lang["existing_category"] = 'Categoria attuale';
$_lang["expand_tree"] = 'Espandi struttura ad albero';
$_lang["export_site"] = 'Esporta sito in HTML (statico)';
$_lang["export_site_cacheable"] = 'Includi file non inseribili in cache:';
$_lang["export_site_exporting_document"] = 'Esportazione del file <b>%s</b> di <b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = '<span style=\'color:#990000\'>Fallita!</span>';
$_lang["export_site_failed_no_open"] = 'Impossibile aprire il file: ';
$_lang["export_site_failed_no_retrieve"] = 'Impossibile trovare la Risorsa.';
$_lang["export_site_failed_no_write"] = 'Impossibile scrivere il file.';
$_lang["export_site_html"] = 'Esporta sito in HTML';
$_lang["export_site_maxtime"] = 'Tempo massimo di esportazione:';
$_lang["export_site_maxtime_message"] = 'Qui potete specificare il numero massimo di secondi che MODx pu&ograve; impiegare per esportare il sito (escludendo le impostazioni PHP). Inserite 0 per un tempo illimitato. Da notare che &egrave; sconsigliato impostare 0 o un numero veramente alto di secondi in quanto ci&ograve; pu&ograve; causare effetti indesiderati al server.';
$_lang["export_site_message"] = 'Usando questa funzione potete esportare l\'intero sito in HTML. Considerate che cos&igrave; facendo perderete molte funzionalit&agrave; di MODx:<p /><ul><li>Gli accessi ai file esportati non saranno registrati.</li><li>Gli snippet interattivi NON funzionano nei file esportati.</li><li>Solo le normali Risorse saranno esportate, i Link Web non lo saranno.</li><li>Il processo di esportazione potrebbe fallire se le Risorse contengono snippet che inviano headers HTTP di redirezione.</li><li>A seconda di come avete scritto i documenti, i fogli di stile e le immagini, il design del sito potrebbe essere compromesso. Per sistemarlo, potete salvare/spostare i file esportati nella stessa cartella dove risiede il file index.php di MODx.</li></ul><p />Compilate il modulo e premete \'Avvia esportazione\' per avviare il processo. I file creati saranno salvati nel punto specificato usando, ove possibile, gli alias dei documenti come nomi dei file. Nell\'esportare il sito, sarebbe meglio aver attivato gli \'URL semplici\' nella configurazione di MODx. In base alla dimensione del sito, l\'esportazione potrebbe impiegare un po\' di tempo.<p /><b>Ogni file esistente sar&agrave; sovrascritto dai nuovi file se i loro nomi sono identici!</b><p />';
$_lang["export_site_numberdocs"] = '<b>Trovate %s Risorse da esportare...</b><p/>';
$_lang["export_site_prefix"] = 'Prefisso file:';
$_lang["export_site_start"] = 'Avvia esportazione';
$_lang["export_site_success"] = '<span style=\'color:#009900\'>Riuscita!</span>';
$_lang["export_site_success_skip_dir"] = 'Saltare questa directory.';
$_lang["export_site_success_skip_doc"] = 'Saltare questa Risorsa.';
$_lang["export_site_suffix"] = 'Suffisso file:';
$_lang["export_site_target_unwritable"] = 'La cartella target non &egrave; scrivibile. Vi preghiamo di assicurarvi che la cartella sia scrivibile e di riprovare.';
$_lang["export_site_time"] = 'Esportazione terminata. L\'operazione &egrave; stata completata in %s secondi.';
$_lang["failed_login_message"] = 'Qui potete inserire il numero delle volte che &egrave; consentito sbagliare l\'autenticazione prima che l\'account venga bloccato.';
$_lang["failed_login_title"] = 'Autenticazioni errate consentite:';
$_lang["fe_editor_lang_message"] = 'Selezionare il linguaggio dell\'editor quando usato nel front-end.';
$_lang["fe_editor_lang_title"] = 'Linguaggio Front-end Editor:';
$_lang["file_delete_file"] = 'Elimina File';
$_lang["file_delete_folder"] = 'Elimina Cartella';
$_lang["file_deleted"] = 'Riuscita!';
$_lang["file_download_file"] = 'Scarica File';
$_lang["file_download_unzip"] = 'Decomprimi File zip';
$_lang["file_folder_chmod_error"] = 'Impossibile modificare i permessi: dovete effettuare la modifica dei permessi con un programma esterno a MODx.';
$_lang["file_folder_created"] = 'Cartella creata con successo!';
$_lang["file_folder_deleted"] = 'Cartella eliminata con successo!';
$_lang["file_folder_not_created"] = 'Impossibile trovare la cartella';
$_lang["file_folder_not_deleted"] = 'Impossibile eliminare la cartella. Verificare che sia vuota prima di eliminarla!';
$_lang["file_not_deleted"] = 'Fallita!';
$_lang["file_not_saved"] = 'Impossibile salvare il file, assicuratevi che la cartella di destinazione sia scrivibile!';
$_lang["file_saved"] = 'File aggiornato con successo!';
$_lang["file_unzip"] = 'Decompressione cartella effettuata con successo!';
$_lang["file_unzip_fail"] = 'Decompressione cartella fallita!';
$_lang["filemanager_path_message"] = 'IIS spesso non riesce a determinare correttamente la cartella principale usata dal File Manager per determinare ci&ograve; che potete vedere. Se avete problemi nell\'uso del File Manager, assicuratevi che il percorso punti alla root dell\'installazione di MODx.';
$_lang["filemanager_path_title"] = 'Percorso del File Manager:';
$_lang["files_access_denied"] = 'Accesso negato!';
$_lang["files_data"] = 'Dati';
$_lang["files_dir_listing"] = 'Elenco cartelle per:';
$_lang["files_directories"] = 'Cartelle';
$_lang["files_dirwritable"] = 'Cartella scrivibile?';
$_lang["files_editfile"] = 'Modifica file';
$_lang["files_file_type"] = 'Tipo file: ';
$_lang["files_filename"] = 'Nome file';
$_lang["files_fileoptions"] = 'Opzioni';
$_lang["files_files"] = 'File';
$_lang["files_filesize"] = 'Dimensione file';
$_lang["files_filetype_notok"] = 'Non &egrave; consentito il caricamento di questo tipo di file!';
$_lang["files_modified"] = 'Modificato';
$_lang["files_top_level"] = 'Al livello superiore';
$_lang["files_up_level"] = 'Su di un livello';
$_lang["files_upload_copyfailed"] = 'La copia del file nella cartella di destinazione non &egrave; riuscita - caricamento fallito!';
$_lang["files_upload_error"] = 'Errore';
$_lang["files_upload_error0"] = 'Si &egrave; verificato un problema durante il caricamento.';
$_lang["files_upload_error1"] = 'Il file che state provando a caricare &egrave; troppo grande.';
$_lang["files_upload_error2"] = 'Il file che state provando a caricare &egrave; troppo grande.';
$_lang["files_upload_error3"] = 'Il file che state provando a caricare &egrave; stato copiato solo in parte.';
$_lang["files_upload_error4"] = 'Dovete selezionare un file da caricare.';
$_lang["files_upload_error5"] = 'Si &egrave; verificato un problema durante il caricamento.';
$_lang["files_upload_inhibited_msg"] = '<b>Il caricamento file &egrave; inibito</b> - assicuratevi che il caricamento sia supportato e che la cartella sia scrivibile da PHP.<br />';
$_lang["files_upload_ok"] = 'File caricato con successo!';
$_lang["files_upload_permissions_error"] = 'Possibile errore nei permessi di scrittura - la directory deve poter essere scrivibile dal webserver.';
$_lang["files_uploadfile"] = 'Carica file';
$_lang["files_uploadfile_msg"] = 'Selezionate un file da caricare:';
$_lang["files_uploading"] = 'Sto caricando <b>%s</b> in <b>%s/</b><br />';
$_lang["files_viewfile"] = 'Visualizza file';
$_lang["folder"] = 'Cartella';
$_lang["forgot_password_email_fine_print"] = '* L\'indirizzo precedente perde validit&agrave; una volta che avete cambiato password o da domani.';
$_lang["forgot_password_email_instructions"] = 'Da l&igrave; potrete cambiare la vostra password dal menu Il Mio Account.';
$_lang["forgot_password_email_intro"] = 'E\' stata fatta una richiesta per cambiare la password del vostro account.';
$_lang["forgot_password_email_link"] = 'Fate clic qui per completare il processo.';
$_lang["forgot_your_password"] = 'Hai dimenticato la Password?';
$_lang["friday"] = 'Venerd&igrave;';
$_lang["friendly_alias_message"] = 'Se state usando gli URL semplici, e la Risorsa ha un alias, quest\'ultimo avr&agrave; sempre precedenza sull\'URL semplice. Impostando questa opzione su \'si\', il prefisso e il suffisso dell\'URL semplice saranno anche applicati all\'alias. Per esempio, se la Risorsa con l\'ID 1 ha per alias `introduction`, e voi avete impostato un prefisso come `` e un suffisso come `.html`, settando questa opzione su `si` sar&agrave; generato `introduction.html`. Se non ci sono alias, MODx generer&agrave; `1.html` come link.';
$_lang["friendly_alias_title"] = 'Usa alias semplici';
$_lang["friendlyurls_message"] = 'L\'opzione permette di usare gli URL semplici per i motori di ricerca con MODx. Notate che l\'opzione funziona solo per le installazioni di MODx su Apache, e che avete anche bisogno di scrivere un file .htaccess perch&egrave; funzioni. Per maggiori informazioni, guardate il file .htaccess incluso nella distribuzione.';
$_lang["friendlyurls_title"] = 'Usa URL semplici:';
$_lang["friendlyurlsprefix_message"] = 'Qui potete specificare il prefisso da usare con gli URL semplici. Ad esempio, un prefisso impostato su \'pagina\' trasformer&agrave; l\'URL /index.php?id=2 nell\'URL semplice /pagina2.html (assumendo che il suffisso sia impostato su .html). In questo modo potete specificare cosa gli utenti (e i motori di ricerca) vedranno per i links nel sito.';
$_lang["friendlyurlsprefix_title"] = 'Prefisso per gli URL semplici:';
$_lang["friendlyurlsuffix_message"] = 'Qui potete specificare il suffisso delle URL semplici. Specificando \'.html\' sar&agrave; aggiunto .html a tutti gli URL semplici.';
$_lang["friendlyurlsuffix_title"] = 'Suffisso per gli URL semplici:';
$_lang["functionnotimpl"] = 'Spiacente!';
$_lang["functionnotimpl_message"] = 'Questa funzione non &egrave; stata ancora implementata.';
$_lang["go"] = 'Vai';
$_lang["group_access_permissions"] = 'Gruppi di accesso';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Aiuto';
$_lang["help_msg"] = '<p>Se avete bisogno di aiuto nell\'utilizzo di MODx, vi consigliamo di visitare i <a href=\'http://modxcms.com/forums\' target=\'_blank\'>Forum MODx</a>. Inoltre, il sito MODx contiene tutta la <a href=\"http://modxcms.com/documentation\" target=\"_blank\">documentazione</a> riguardo l\'uso di MODx o su come configurarlo, la risposta che state cercando potrebbe essere qui.</p><p>Prevediamo anche di offrire servizi di supporto di tipo commerciale per MODx. Se siete interessati, <a href=\"mailto:modx@vertexworks.com?subject=MODx Commercial Support Inquiry\">inviateci un messaggio email</a>.';
$_lang["help_title"] = 'Aiuto';
$_lang["hide_tree"] = 'Nascondi struttura ad albero';
$_lang["home"] = 'Inizio';
$_lang["htmlsnippet_desc"] = 'Descrizione';
$_lang["htmlsnippet_management_msg"] = 'Qui potete scegliere i chunk da modificare.';
$_lang["htmlsnippet_msg"] = 'Qui potete aggiungere/modificare i chunk. Ricordate, i chunk sono codice HTML \'raw\' (grezzo), quindi qualsiasi codice PHP non verr&agrave; processato.';
$_lang["htmlsnippet_name"] = 'Nome chunk';
$_lang["htmlsnippet_title"] = 'Crea/ modifica chunk';
$_lang["icon"] = 'Icona';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Assegnazione parentela:\n\nLa Risorsa &egrave; un sottodocumento della Risorsa selezionata.';
$_lang["illegal_parent_self"] = 'Assegnazione parentela:\n\nLa Risorsa selezionata non pu&ograve; essere assegnata a se stessa.';
$_lang["import_files_found"] = '<b>Trovate %s Risorse da importare...</b><p/>';
$_lang["import_params"] = 'Importa parametri condivisi modulo';
$_lang["import_params_msg"] = 'Potete importare i parametri e le impostazioni di un modulo selezionando il nome del modulo dalla lista sottostante. <b>NOTE:</b> Per far apparire un modulo del menu , questo plugin/snippet deve essere una parte dell\'elenco di dipendenza del modulo ed il modulo deve avere il parametro di condivisione attivato. ';
$_lang["import_parent_resource"] = 'Risorsa genitore:';
$_lang["import_site"] = 'Importa sito';
$_lang["import_site_failed"] = '<span style=\'color:#990000\'>Fallito!</span>';
$_lang["import_site_failed_db_error"] = 'Si &egrave; verificato un errore del database cercando di duplicare la Risorsa: ';
$_lang["import_site_failed_no_open_dir"] = 'Impossibile aprire la directory: ';
$_lang["import_site_failed_no_retrieve_file"] = 'Impossibile trovare il file: ';
$_lang["import_site_html"] = 'Importa sito da HTML';
$_lang["import_site_importing_document"] = 'Importazione in corso <b>%s</b> ';
$_lang["import_site_maxtime"] = 'Tempo massimo importazione:';
$_lang["import_site_maxtime_message"] = 'Qui potete specificare il numero di secondi che il sistema pu&ograve; impiegare per importare il sito (ignorando le impostazioni PHP). Inserite 0 per un tempo illimitato. Attenzione, un\'impostazione 0 o molto alta pu&ograve; causare un timeout del server, quindi non &egrave; raccomandata.';
$_lang["import_site_message"] = 'Usando questa funzione potete importare nel database un intero sito HTML. Da notare che ci sar&agrave; bisogno di copiare i vostri file html nella cartella assets/import.<p / > Compilate il modulo per avviare il processo di importazione. Gli archivi importati saranno salvati nella posizione selezionata, usando - dove possibile - i nomi dei file come alias della Risorsa, il titolo della pagina come titolo della Risorsa.';
$_lang["import_site_skip"] = '<span style=\'color:#990000\'>Saltato!</span>';
$_lang["import_site_start"] = 'Avvia importazione';
$_lang["import_site_success"] = '<span style=\'color:#009900\'>Effettuato!</span>';
$_lang["import_site_time"] = 'Importazione completata in %s secondi.';
$_lang["inbox"] = 'Inbox';
$_lang["info"] = 'Info';
$_lang["information"] = 'Informazioni';
$_lang["inline"] = 'In linea';
$_lang["insert"] = 'Inserisci';
$_lang["keyword"] = 'Parola chiave';
$_lang["keywords"] = 'Parole chiave';
$_lang["keywords_intro"] = 'Per modificare una parola chiave, digitate semplicemente la nuova parola nel campo di testo a fianco di quella che volete cambiare. Per eliminare una parola chiave, spuntate il box \'Elimina\' per quella parola. Se impostate l\'eliminazione di una parola chiave e allo stesso tempo ne modificate il nome, essa verr&agrave; eliminata vanificando l\'operazione di rinomina!';
$_lang["language_message"] = 'Selezionate la lingua per il sistema di gestione dei contenuti MODx.';
$_lang["language_title"] = 'Lingua:';
$_lang["launch_site"] = 'Mostra sito';
$_lang["link_attributes"] = 'Attributi links';
$_lang["link_attributes_help"] = 'Qui potete inserire gli attributi per i link a questa pagina, come target= o rel=.';
$_lang["list_mode"] = 'Abilita/disabilita modalit&agrave; lista - elencare tutti i record nella griglia.';
$_lang["loading_doc_tree"] = 'Sto caricando la struttura ad albero delle Risorse...';
$_lang["loading_menu"] = 'Sto caricando il menu...';
$_lang["loading_page"] = 'Vi preghiamo di attendere che MODx carichi la pagina...';
$_lang["localtime"] = 'Orario locale';
$_lang["lock_htmlsnippet"] = 'Impedisci modifica chunk';
$_lang["lock_htmlsnippet_msg"] = 'Solo gli amministratori (Ruolo ID 1) possono modificare il chunk.';
$_lang["lock_module"] = 'Impedisci le modifiche al modulo';
$_lang["lock_module_msg"] = 'Solo gli amministratori (Ruolo ID 1) possono modificare questo modulo.';
$_lang["lock_msg"] = '%s sta attualmente modificando %s. Attendete che l\'altro utente finisca e poi riprova.';
$_lang["lock_plugin"] = 'Impedisci la modifica del plugin';
$_lang["lock_plugin_msg"] = 'Solo gli amministratori (Ruolo ID 1) possono modificare questo plugin.';
$_lang["lock_settings_msg"] = '%s sta attualmente modificando queste impostazioni. Attendete che l\'altro utente finisca e poi riprovate.';
$_lang["lock_snippet"] = 'Impedisci modifica snippet';
$_lang["lock_snippet_msg"] = 'Solo gli amministratori (Ruolo ID 1) possono modificare lo snippet.';
$_lang["lock_template"] = 'Impedisci modifica template';
$_lang["lock_template_msg"] = 'Solo gli amministratori (Ruolo ID 1) possono modificare il template.';
$_lang["lock_tmplvars"] = 'Impedisci la modifica della variabile';
$_lang["lock_tmplvars_msg"] = 'Solo gli amministratori (Ruolo ID 1) possono modificare questa variabile';
$_lang["locked"] = 'Bloccato';
$_lang["login_allowed_days"] = 'Giorni consentiti';
$_lang["login_allowed_days_message"] = 'Selezionate i giorni in cui questo utente &egrave; autorizzato ad autenticarsi..';
$_lang["login_allowed_ip"] = 'Indirizzo IP autorizzato';
$_lang["login_allowed_ip_message"] = 'Inserite l\'indirizzo IP autorizzato all\'autenticazione. <b>NB: Separate differenti indirizzi IP con una virgola (,)</b>';
$_lang["login_button"] = 'Accedi';
$_lang["login_cancelled_install_in_progress"] = '<span style="font-weight: bold; color: red;">Installazione o aggiornamento di questo sito in corso. <br />Riprova tra qualche minuto</span><br />';
$_lang["login_cancelled_site_was_updated"] = '<span style="font-weight: bold; color: red;">Installazione o aggiornamento  completata su questo sito, effettuare nuovamente il login!</span><br />';
$_lang["login_captcha_message"] = 'Inserite il codice di sicurezza mostrato all\'interno dell\'immagine grafica. Se avete difficolt&agrave; nel leggere il codice, cliccateci sopra per generarne un altro a caso, oppure contattate l\'amministratore del sito.';
$_lang["login_homepage"] = 'Autenticazione Pagina d\'inizio';
$_lang["login_homepage_message"] = 'Inserite l\'ID della Risorsa da mostrare all\'utente dopo che ha eseguito l\'autenticazione. <b>NOTA: assicuratevi che la Risorsa indicata esista, sia pubblicata e accessibile all\'utente!</b>';
$_lang["login_message"] = 'Inserisci le tue credenziali per effettuare l\'accesso.<br /> Il sistema fa distinzione fra le maiuscole/minuscole del nome utente e della password.';
$_lang["logo_slogan"] = 'Sistema di gestione dei contenuti MODx - \nCreate e fate di pi&ugrave; con meno';
$_lang["logout"] = 'Uscita';
$_lang["long_title"] = 'Titolo esteso';
$_lang["mail_check_timeperiod_message"] = 'Intervallo di tempo dopo il quale controllare se ci sono nuovi messaggi nel Manager, in secondi.';
$_lang["mail_check_timeperiod_title"] = 'Controllo mail a tempo:';
$_lang["manage_depends"] = 'Configurazione Dipendenze';
$_lang["manage_files"] = 'Gestione File';
$_lang["manage_htmlsnippets"] = 'Gestione Chunk';
$_lang["manage_metatags"] = 'Gestione META tag e parole chiave';
$_lang["manage_modules"] = 'Gestione moduli';
$_lang["manage_plugins"] = 'Plugin';
$_lang["manage_snippets"] = 'Snippet';
$_lang["manage_templates"] = 'Gestione Template';
$_lang["manager"] = 'Sistema di gestione';
$_lang["manager_lockout_message"] = 'Siete entrati nel sistema di gestione dei contenuti. Se desiderate uscire dalla sessione, fate clic sul pulsante "Uscita".<p />Per andare alla pagina inziale fate clic sul pulsante "Home".';
$_lang["manager_permissions"] = 'Gestione Permessi';
$_lang["manager_theme"] = 'Tema del sistema di gestione:';
$_lang["manager_theme_message"] = 'Selezionate un tema per il sistema di gestione dei contenuti.';
$_lang["messages"] = 'Messaggi';
$_lang["messages_all"] = 'Tutti';
$_lang["messages_compose"] = 'Componi messaggio';
$_lang["messages_forward"] = 'Inoltra';
$_lang["messages_from"] = 'Da';
$_lang["messages_group"] = 'Un gruppo';
$_lang["messages_inbox"] = 'Inbox';
$_lang["messages_message"] = 'Messaggio';
$_lang["messages_no_messages"] = 'Nessun messaggio nella Inbox.';
$_lang["messages_not_allowed_to_read"] = 'Non siete autorizzati a leggere questo messaggio!';
$_lang["messages_private"] = 'Privato';
$_lang["messages_read_message"] = 'Leggi messaggio';
$_lang["messages_reply"] = 'Rispondi';
$_lang["messages_select_group"] = 'Seleziona un gruppo';
$_lang["messages_select_user"] = 'Seleziona un utente';
$_lang["messages_send"] = 'Invia';
$_lang["messages_send_to"] = 'Invia a';
$_lang["messages_sent"] = 'Inviato il';
$_lang["messages_subject"] = 'Oggetto';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'Messaggi';
$_lang["messages_user"] = 'Un utente';
$_lang["meta_keywords"] = 'META e parole chiave';
$_lang["metatag_intro"] = 'In questa pagina potete eliminare, creare o modificare i META tag e le parole chiave. Per collegare le parole chiave alle Risorse, modificate la Risorsa in questione e selezionate le parole chiave desiderate dalla lista. Per aggiungere una parola chiave digitate la nuova parola e poi cliccate \'Aggiungi tag\'.';
$_lang["metatag_notice"] = 'Per ulteriori informazioni, consultate il sito della <a href="http://www.html-reference.com/META.htm" target="_blank">Guida di Riferimento HTML</a>. Questa non &egrave; una lista completa di tutti i possibili META tag.';
$_lang["metatags"] = 'META tag';
$_lang["mgr_access_permissions"] = 'Gestione permessi di accesso';
$_lang["mgr_login_start"] = 'Gestione accesso autenticazione';
$_lang["mgr_login_start_message"] = 'Inserite l\'ID della Risorsa che volete mostrare agli utenti dopo l\'accesso al sistema di gestione. <b>NOTA: assicuratevi che l\'ID appartenga ad una Risorsa esistente e che sia stata pubblicata!</b>';
$_lang["mgrlog_action"] = 'Azione';
$_lang["mgrlog_actionid"] = 'ID Azione';
$_lang["mgrlog_anyall"] = 'Qualunque/tutti';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() ha restituito false.';
$_lang["mgrlog_datefr"] = 'Data iniziale';
$_lang["mgrlog_dateinvalid"] = 'Formato data errato.';
$_lang["mgrlog_dateto"] = 'Data finale';
$_lang["mgrlog_emptysrch"] = 'La vostra ricerca non ha prodotto risultati.';
$_lang["mgrlog_field"] = 'Campo';
$_lang["mgrlog_itemid"] = 'ID oggetto';
$_lang["mgrlog_itemname"] = 'Nome oggetto';
$_lang["mgrlog_msg"] = 'Messaggio';
$_lang["mgrlog_noquery"] = 'Non &egrave; stata ancora iniziata una ricerca.';
$_lang["mgrlog_qresults"] = 'Risultati ricerca';
$_lang["mgrlog_query"] = 'Selezione dei log di sistema';
$_lang["mgrlog_query_msg"] = 'Per vedere i log, fate una selezione. Potete selezionare un intervallo di date, ma ricordate che le date che immettete non sono entrambe incluse. Ad esempio per selezionare tutti i dati di log del giorno 1 gennaio 2007, impostate \'Data iniziale\' su 01-01-2007 e \'Data finale\' su 02-01-2007.<br /><br />Messaggio ed azione sono in genere coincidenti. Se state cercando un messaggio specifico, &egrave; meglio impostare l\'azione su \'Qualunque/tutti\'.';
$_lang["mgrlog_results"] = 'N. di risultati';
$_lang["mgrlog_searchlogs"] = 'Ricerca log';
$_lang["mgrlog_sortinst"] = 'Potete ordinare la tabella facendo clic sulle intestazioni delle colonne. Se i log dovessero diventare troppo grandi, potete <a href="index.php?a=55">svuotarli</a>. Con ci&ograve; vengono rimossi tutti i dati dei log raccolti fino ad oggi, e questa azione una volta partita non pu&ograve; essere annullata!';
$_lang["mgrlog_time"] = 'Ora';
$_lang["mgrlog_user"] = 'Utente';
$_lang["mgrlog_username"] = 'Nome utente';
$_lang["mgrlog_value"] = 'Valore';
$_lang["mgrlog_view"] = 'Mostra log del sistema di gestione';
$_lang["module_code"] = 'Codice Modulo (php)';
$_lang["module_config"] = 'Configurazione del Modulo';
$_lang["module_desc"] = 'Descrizione';
$_lang["module_disabled"] = 'Modulo disabilitato';
$_lang["module_edit_click_title"] = 'Cliccate qui per modificare il modulo';
$_lang["module_group_access_msg"] = 'Selezionate i gruppi autorizzati ad eseguire il modulo.';
$_lang["module_management"] = 'Gestione Moduli';
$_lang["module_management_msg"] = 'Qui potete scegliere il modulo che desiderate eseguire o modificare. Per eseguire il modulo, fate clic sull\'icona del modulo riportata sulla griglia. Per modificare un modulo, cliccatene il nome.';
$_lang["module_msg"] = 'Qui potete creare o modificare i Moduli. Un Modulo &egrave; un insieme di Elementi che interagiscono fra loro (ad es. plugins, snippets, ecc).';
$_lang["module_name"] = 'Nome del modulo';
$_lang["module_resource_msg"] = 'Qui potete aggiungere o rimuovere Risorse dalle quali dipende questo modulo. Cliccate sul pulsante aggiungi per aggiungere una Risorsa.';
$_lang["module_resource_title"] = 'Dipendenze Moduli';
$_lang["module_title"] = 'Crea/modifica Moduli';
$_lang["module_viewdepend_msg"] = 'Qui potete vedere gli Elementi dai quali dipende il modulo. Cliccate sul pulsante \'Configurazione Dipendenze\' per modificare le dipendenze';
$_lang["modules"] = 'Moduli';
$_lang["modx_news"] ='MODx News Notices';
$_lang["modx_news_tab"] ='Novit&agrave; MODx';
$_lang["modx_news_title"] ='Novit&agrave; MODx';
$_lang["modx_security_notices"] ='Avvisi di Protezione MODx';
$_lang["modx_version"] = "Versione MODx";
$_lang["monday"] = 'Luned&igrave;';
$_lang["move"] = 'Sposta';
$_lang["move_resource"] = 'Sposta Risorsa';
$_lang["move_resource_message"] = 'Potete spostare una Risorsa e tutti i suoi sottodocumenti selezionando un nuovo genitore nella struttura ad albero. Se selezionate una Risorsa che non &egrave; una cartella, essa sar&agrave; trasformato in cartella. Cliccate sulla nuova Risorsa genitore nella struttura ad albero delle Risorse.';
$_lang["move_resource_new_parent"] = 'Vi preghiamo di selezionare una nuova Risorsa genitore nella struttura ad albero delle Risorse.';
$_lang["move_resource_title"] = 'Sposta Risorsa';
$_lang["name"] = 'Nome';
$_lang["new_category"] = 'Nuova Categoria';
$_lang["new_file_permissions_message"] = 'Durante il caricamento di un nuovo file nel sistema di gestione file, il sistema cercher&agrave; di cambiare i permessi del file in modo da conformarsi a quelli selezionati tramite questa impostazione. Questo per&ograve; potrebbe non funzionare con alcune configurazioni, come ad esempio IIS, nel qual caso dovrete procedere ad una modifica manuale dei permessi.';
$_lang["new_file_permissions_title"] = 'Nuovi permessi File';
$_lang["new_folder_permissions_message"] = 'Durante la creazione di una nuova cartella nel sistema di gestione file, il sistema cercher&agrave; di cambiare i permessi della cartella in modo da conformarsi a quelli selezionati tramite questa impostazione. Questo per&ograve; potrebbe non funzionare con alcune configurazioni, come ad esempio IIS, nel qual caso dovrete procedere ad una modifica manuale dei permessi.';
$_lang["new_folder_permissions_title"] = 'Nuovi permessi cartella';
$_lang["new_htmlsnippet"] = 'Nuovo chunk';
$_lang["new_keyword"] = 'Aggiungi nuova parola chiave:';
$_lang["new_module"] = 'Nuovo Modulo';
$_lang["new_parent"] = 'Nuova Risorsa genitore';
$_lang["new_plugin"] = 'Nuovo plugin';
$_lang["new_role"] = 'Crea un nuovo ruolo';
$_lang["new_snippet"] = 'Nuovo snippet';
$_lang["new_template"] = 'Nuovo template';
$_lang["new_tmplvars"] = 'Nuova Variabile di Template';
$_lang["new_user"] = 'Nuovo utente';
$_lang["new_web_user"] = 'Nuovo utente Web';
$_lang["no"] = 'No';
$_lang["no_active_users_found"] = 'Non sono stati trovati utenti attivi.';
$_lang["no_activity_message"] = 'Non avete ancora creato o modificato alcuna Risorsa.';
$_lang["no_category"] = 'senza Categoria';
$_lang["no_docs_pending_publishing"] = 'Nessuna Risorsa in attesa di pubblicazione.';
$_lang["no_docs_pending_pubunpub"] = 'Nessun evento programmato trovato';
$_lang["no_docs_pending_unpublishing"] = 'Nessuna Risorsa in attesa del ritiro dalla pubblicazione.';
$_lang["no_edits_creates"] = 'No edits or creates found.';
$_lang["no_groups_found"] = 'Nessun gruppo trovato.';
$_lang["no_keywords_found"] = 'Non ci sono parole chiave';
$_lang["no_records_found"] = 'Nessun record.';
$_lang["no_results"] = 'Nessun risultato trovato';
$_lang["nologentries_message"] = 'Inserite il numero di voci di log da visualizzare per pagina quando utilizzate Cronistorie.';
$_lang["nologentries_title"] = 'Numero di voci di log:';
$_lang["nomessages_message"] = 'Inserite il numero di messaggi da visualizzare nella inbox quando leggete i messaggi.';
$_lang["nomessages_title"] = 'Numero di messaggi:';
$_lang["none"] = 'Nessuno';
$_lang["noresults_message"] = 'Inserite il numero di risultati da mostrare negli elenchi ed i risultati di ricerca .';
$_lang["noresults_title"] = 'Numero di risultati:';
$_lang["not_deleted"] = 'non &egrave; stato eliminato.';
$_lang["not_set"] = 'Non impostato';
$_lang["offline"] = 'Offline';
$_lang["online"] = 'Online';
$_lang["onlineusers_action"] = 'Azione';
$_lang["onlineusers_actionid"] = 'ID Action';
$_lang["onlineusers_ipaddress"] = 'Indirizzo IP dell\'utente';
$_lang["onlineusers_lasthit"] = 'Ultimo contatto';
$_lang["onlineusers_message"] = 'Questa lista mostra tutti gli utenti attivi negli ultimi 20 minuti (l\'orario attuale &egrave; ';
$_lang["onlineusers_title"] = 'Utenti online';
$_lang["onlineusers_user"] = 'Utente';
$_lang["onlineusers_userid"] = 'ID dell\'utente';
$_lang["optimize_table"] = 'Cliccate qui per ottimizzare questa tabella';
$_lang["page_data_cacheable"] = 'Situabile in cache';
$_lang["page_data_cacheable_help"] = 'Lasciando questo campo selezionato permetterete alla Risorsa di essere salvata nella cache. Se la Risorsa contiene snippeta, assicuratevi che non sia selezionato.';
$_lang["page_data_cached"] = '<b>Sorgente recuperata dalla cache:</b>';
$_lang["page_data_changes"] = 'Modifiche';
$_lang["page_data_contentType"] = 'Tipo contenuto';
$_lang["page_data_contentType_help"] = 'Selezionate il tipo di contenuto della Risorsa. Se non avete idea del tipo di contenuto che la Risorsa deve avere, lasciatelo semplicemente come text/html.';
$_lang["page_data_created"] = 'Creato';
$_lang["page_data_edited"] = 'Modificato';
$_lang["page_data_editor"] = 'Modificato con l\'editor rich text';
$_lang["page_data_folder"] = 'La Risorsa &egrave; una cartella';
$_lang["page_data_general"] = 'Generale';
$_lang["page_data_markup"] = 'Markup/ struttura';
$_lang["page_data_mgr_access"] = 'Accesso del sistema di gestione';
$_lang["page_data_notcached"] = 'Questa Risorsa non &egrave; stata (ancora) inserita nella cache.';
$_lang["page_data_publishdate"] = 'Data di pubblicazione';
$_lang["page_data_publishdate_help"] = 'Se impostate una data di pubblicazione, la Risorsa sar&agrave; pubblicata alla data prescelta. Cliccate sull\'icona del calendario per selezionare una data di pubblicazione o sull\'icona a fianco per rimuoverla. Con questo sistema, la Risorsa non verr&agrave; mai pubblicata automaticamente.';
$_lang["page_data_published"] = 'Pubblicato';
$_lang["page_data_searchable"] = 'Ricercabile';
$_lang["page_data_searchable_help"] = 'Spuntando questa casella permettete alla Risorsa di essere ricercabile. Potete anche usare la casella per altri scopi nei vostri snippet.';
$_lang["page_data_source"] = 'Sorgente';
$_lang["page_data_status"] = 'Stato';
$_lang["page_data_template"] = 'Template usato';
$_lang["page_data_template_help"] = 'Qui potete selezionare il template da usare per la Risorsa.';
$_lang["page_data_title"] = 'Dati pagina';
$_lang["page_data_unpublishdate"] = 'Data ritiro';
$_lang["page_data_unpublishdate_help"] = 'Se impostate una data di ritiro, la Risorsa sar&agrave; ritirata alla data prescelta. Cliccate sull\'icona del calendario per selezionare una data di ritiro o sull\'icona a fianco per rimuoverla. Con questo sistema, la Risorsa non verr&agrave; mai ritirato automaticamente.';
$_lang["page_data_unpublished"] = 'Ritirato';
$_lang["page_data_web_access"] = 'Accesso dal web';
$_lang["pagetitle"] = 'Titolo della Risorsa';
$_lang["pagination_table_first"] = "Primo";
$_lang["pagination_table_gotopage"] = "Vai alla pagina";
$_lang["pagination_table_last"] = "Ultimo";
$_lang["paging_first"] = 'primo';
$_lang["paging_last"] = 'ultimo';
$_lang["paging_next"] = 'successivo';
$_lang["paging_prev"] = 'precedente';
$_lang["paging_showing"] = 'Mostra';
$_lang["paging_to"] = 'a';
$_lang["paging_total"] = 'totale';
$_lang["parameter"] = 'Parametro';
$_lang["password"] = 'Password';
$_lang["password_change_request"] = 'Richiesta di cambio password';
$_lang["password_gen_gen"] = 'Lascia che MODx generi una password.';
$_lang["password_gen_length"] = 'La password dev\'essere lunga almeno 6 caratteri.';
$_lang["password_gen_method"] = 'Come volete creare la password dell\'utente?';
$_lang["password_gen_specify"] = 'Lasciami specificare la password:';
$_lang["password_method"] = 'Come volete notificare la nuova password all\'utente?';
$_lang["password_method_email"] = 'Invia la nuova password per e-mail.';
$_lang["password_method_screen"] = 'Mostra la nuova password sullo schermo.';
$_lang["password_msg"] = 'La nuova password per <b>%s</b> &egrave; <b>%s</b>.';
$_lang["php_version_check"] = 'MODx &egrave; compatibile con PHP versione 4.0.3 o superiore. Si prega di aggiornare l\'installazione di PHP!';
$_lang["plugin"] = 'Plugin';
$_lang["plugin_code"] = 'Codice Plugin (php)';
$_lang["plugin_config"] = 'Configura Plugin';
$_lang["plugin_desc"] = 'Descrizione';
$_lang["plugin_disabled"] = 'Plugin Disabilitato';
$_lang["plugin_event_msg"] = 'Selezionate l\'evento per il plugin';
$_lang["plugin_management_msg"] = 'Qui potete selezionare i plugin da modificare.';
$_lang["plugin_msg"] = 'Qui potete aggiungere/modificare i plugin. I Plugin sono \'puro\'codice PHP  che viene richiamato in seguito ad alcuni eventi di sistema.';
$_lang["plugin_name"] = 'Nome Plugin';
$_lang["plugin_priority"] = 'Modificate l\'ordine di esecuzione dei plugin in base all\'evento';
$_lang["plugin_priority_instructions"] = 'Riordinare i Plugins per ogni Evento. Il primo plugin da eseguire va messo in cima.';
$_lang["plugin_priority_title"] = 'Ordine di esecuzione del Plugin';
$_lang["plugin_title"] = 'Crea/modifica plugin';
$_lang["preview"] = 'Anteprima';
$_lang["preview_msg"] = 'Questa &egrave; l\'anteprima dell\'ultimo salvataggio. Clicca qui <a href=\'javascript://\' onclick="saveRefreshPreview();"><img src=\'media/images/icons/save.gif\' align=\'absmiddle\' height=\'12\'> Salva e Aggiorna</a> le modifiche';
$_lang["preview_resource"] = 'Anteprima Risorsa';
$_lang["private"] = 'Privato';
$_lang["public"] = 'Pubblico';
$_lang["publish_date"] = 'Data di pubblicazione';
$_lang["publish_events"] = 'Eventi di pubblicazione';
$_lang["publish_resource"] = 'Pubblica Risorsa';
$_lang["rb_base_dir_message"] = 'Inserite il percorso fisico alla directory delle Risorse. Questa impostazione &egrave; generata automaticamente. Se state usando IIS, tuttavia, MODx potrebbe non riuscire ad impostare il percorso corretto, inducendo il browser delle Risorse a mostrare un errore. In quel caso, qui potete correggere il percorso alla cartella delle immagini  (il percorso che vedete in Windows Explorer). <b>NOTA:</b> La directory delle Risorse deve contenere le sottocartelle images, files, flash e media affinch&egrave; funzioni correttamente con il Browser di Risorse.';
$_lang["rb_base_dir_title"] = 'Percorso delle Risorse:';
$_lang["rb_base_url_message"] = 'Inserite il percorso virtuale alla directory delle Risorse. Questa impostazione &egrave; generata automaticamente. Se state usando IIS, tuttavia, MODx potrebbe non riuscire ad impostare il percorso corretto, inducendo il browser delle Risorse a mostrare un errore. In quel caso, qui potete correggere il percorso alla cartella delle immagini  (l\'URL che vedete in Internet Explorer).';
$_lang["rb_base_url_title"] = 'URL Risorse:';
$_lang["rb_message"] = 'Selezionate Si se volete abilitare il Browser di Risorse. Questo permetter&agrave; agli utenti di cercare e caricare sul server immagini, file flash e media.';
$_lang["rb_title"] = 'Abilita Browser di Risorse:';
$_lang["rb_webuser_message"] = 'Volete consentire ad un utente web di usare il Browser di Risorse? <b>ATTENZIONE:</b> Consentire agli utenti web di usare il Browser di Risorse rende visibili i files di gestione degli utenti.  Usare questa opzione solo per utenti affidabili.';
$_lang["rb_webuser_title"] = 'Utenti Web?';
$_lang["recent_docs"] = 'Risorse recenti';
$_lang["recommend_setting_change_description"] = 'Il vostro sito non &egrave; configurato per validare gli headers HTTP_REFERER per l\'accesso al Manager. Vi raccomandiamo di abilitare questa impostazione per ridurre i rischi di un attacco CSRF (Cross Site Request Forgery).';
$_lang["recommend_setting_change_title"] = 'Modifiche consigliate';
$_lang["refresh_cache"] = 'Cache: Sono stati trovati <b>%s</b> file nella cartella cache e sono stati eliminati <b>%d</b> file di cache.<p>I nuovi file di cache saranno creati non appena le pagine saranno richieste.';
$_lang["refresh_published"] = '<b>%s</b> Risorse sono state pubblicate.';
$_lang["refresh_site"] = 'Svuota cache';
$_lang["refresh_title"] = 'Aggiorna sito';
$_lang["refresh_tree"] = 'Aggiorna struttura ad albero';
$_lang["refresh_unpublished"] = '<b>%s</b> Risorse sono state ritirate.';
$_lang["release_date"] = 'Data di rilascio';
$_lang["remember_last_tab"] = 'Ricorda i tabs';
$_lang["remember_last_tab_message"] = 'Le pagine del Manager con tabs mostreranno l\'ultimo tab utilizzato anzich&egrave; il primo tab';
$_lang["remember_username"] = 'Ricordami';
$_lang["remove"] = 'Rimuovi ->';
$_lang["remove_date"] = 'Rimuovi data';
$_lang["remove_locks"] = 'Rimuovi blocchi';
$_lang["rename"] = 'Rinomina';
$_lang["reports"] = 'Resoconti';
$_lang["require_tagname"] = 'E\' necessario immettere un nome per il tag';
$_lang["require_tagvalue"] = 'E\' necessario immettere un valore per il tag';
$_lang["reserved_name_warning"] = 'Avete utilizzato un nome riservato.';
$_lang["reset"] = 'Resetta';
$_lang["reset_failedlogins"] = 'reset';
$_lang["resource"] = 'Risorsa';
$_lang["resource_alias"] = 'Alias Risorsa';
$_lang["resource_alias_help"] = 'Qui potete inserire un alias per la Risorsa. Questo render&agrave; la Risorsa accessibile come http://vostroserver/alias. Funziona solo se state usando le URL semplici.';
$_lang["resource_content"] = 'Contenuto Risorsa';
$_lang["resource_description"] = 'Descrizione';
$_lang["resource_description_help"] = 'Qui potete inserire una  descrizione opzionale della Risorsa.';
$_lang["resource_duplicate"] = 'Duplica Risorsa';
$_lang["resource_long_title_help"] = 'Qui potete inserire un titolo esteso per la Risorsa. Questo &egrave; utile per i motori di ricerca e potrebbe descrivere meglio la Risorsa.';
$_lang["resource_metatag_help"] = 'Selezionate i META tag e le parole chiave che volete assegnare alla Risorsa. Tenete premuto il tasto control per selezionare pi&ugrave; tag o parole.';
$_lang["resource_opt_contentdispo"] = 'Pubblicazione del contenuto';
$_lang["resource_opt_contentdispo_help"] = 'Utilizzate il campo pubblicazione contenuto per impostare come il browser avr&agrave; accesso al contenuto della Risorsa. Per file da scaricare selezionare come opzione Allegato.';
$_lang["resource_opt_emptycache"] = 'Svuota cache?';
$_lang["resource_opt_emptycache_help"] = 'Lasciando questo campo selezionato permetterete a MODx di svuotare la cache dopo che avrete salvato la Risorsa. Cos&igrave; i visitatori non vedranno pi&ugrave; la vecchia versione della Risorsa.';
$_lang["resource_opt_folder"] = 'Cartella?';
$_lang["resource_opt_folder_help"] = 'Spuntate la casella se volete che la Risorsa faccia anche da cartella per altre Risorse. Non avete bisogno di preoccuparvi troppo di questo, MODx generalmente si occupa automaticamente delle impostazioni delle cartelle.';
$_lang["resource_opt_menu_index"] = 'Indice menu';
$_lang["resource_opt_menu_index_help"] = 'Indice menu &egrave; un campo che potete usare per ordinare le Risorse nei menu. Potete anche usare il campo per altri scopi nei vostri snippet.';
$_lang["resource_opt_menu_title"] = 'Titolo nel menu';
$_lang["resource_opt_menu_title_help"] = 'Il titolo nel menu &egrave; un campo che potete usare per visualizzare un titolo abbreviato per la Risorsa all\'interno di menu o moduli.';
$_lang["resource_opt_published"] = 'Pubblicato?';
$_lang["resource_opt_published_help"] = 'Spuntate questa casella per pubblicare immediatamente la Risorsa dopo averla salvata.';
$_lang["resource_opt_richtext"] = 'Rich text?';
$_lang["resource_opt_richtext_help"] = 'Lasciate selezionata questa casella se volete usare l\'editor rich text per modificare le Risorse. Se le Risorse contengono JavaScript o forms HTML, deselezionatela e modificateli in modalit&agrave; HTML evitando cos&igrave; che l\'editor ne danneggi il contenuto.';
$_lang["resource_opt_show_menu"] = 'Mostra nel menu';
$_lang["resource_opt_show_menu_help"] = 'Selezionate questa opzione per mostrare la Risorsa nel menu. Attenzione, alcuni script per menu potrebbero ignorare questa opzione.';
$_lang["resource_opt_trackvisit_help"] = 'Registra ogni utente che visita questa pagina';
$_lang["resource_overview"] = 'Dettagli Risorsa';
$_lang["resource_parent"] = 'Risorsa genitore';
$_lang["resource_parent_help"] = 'Selezionate una Risorsa nella struttura ad albero per impostarla come genitore di questa Risorsa.';
$_lang["resource_permissions_error"] = 'Assegnate questa Risorsa ad almeno un Gruppo Risorse al quale avete accesso.';
$_lang["resource_setting"] = 'Impostazioni Risorsa';
$_lang["resource_summary"] = 'Sommario (introtext)';
$_lang["resource_summary_help"] = 'Inserire un breve sommario della Risorsa';
$_lang["resource_title"] = 'Titolo';
$_lang["resource_title_help"] = 'Digitate qui il nome/titolo della Risorsa. Evitate l\'uso del backslash (\) !';
$_lang["resource_to_be_moved"] = 'Risorsa da spostare';
$_lang["resource_type"] = 'Tipo di Risorsa';
$_lang["resource_type_message"] = 'Un Link Web &egrave; un collegamento ad una Risorsa su Internet. Questa Risorsa pu&ograve; essere interna a MODx, una pagina su un altro sito, un\'immagine o un altro file su Internet. I Link Web dovrebbero avere Media Type text/html e Inline Content-Disposition.';
$_lang["resource_type_weblink"] = 'Link Web';
$_lang["resource_type_webpage"] = 'Pagina Web';
$_lang["resource_weblink_help"] = 'Digitate qui l\'indirizzo dell\'oggetto a cui volete collegare questo Link Web.';
$_lang["resources_in_container"] = "Risorse in questo contenitore";
$_lang["resources_in_container_no"] = "Questo contenitore non contiene alcuna Risorsa.";
$_lang["role"] = 'Role';
$_lang["role_about"] = 'Visualizza la pagina About';
$_lang["role_access_persmissions"] = 'Permessi di accesso';
$_lang["role_actionok"] = 'Visualizza la schermata di azione completata';
$_lang["role_bk_manager"] = 'Usa il sistema di gestione delle copie di sicurezza';
$_lang["role_cache_refresh"] = 'Svuota la cache del sito';
$_lang["role_change_password"] = 'Cambia password';
$_lang["role_chunk_management"] = 'Gestione chunks';
$_lang["role_config_management"] = 'Gestione configurazione';
$_lang["role_content_management"] = 'Gestione contenuto';
$_lang["role_create_chunk"] = 'Crea un nuovo chunk';
$_lang["role_create_doc"] = 'Crea nuove Risorse';
$_lang["role_create_plugin"] = 'Crea nuovo plugin';
$_lang["role_create_snippet"] = 'Crea nuovi snippet';
$_lang["role_create_template"] = 'Crea nuovi templates del sito';
$_lang["role_credits"] = 'Visualizza i crediti';
$_lang["role_delete_chunk"] = 'Cancella chunk';
$_lang["role_delete_doc"] = 'Elimina Risorse';
$_lang["role_delete_eventlog"] = 'Cancella Log Eventi';
$_lang["role_delete_module"] = 'Cancella modulo';
$_lang["role_delete_plugin"] = 'Cancella plugin';
$_lang["role_delete_role"] = 'Elimina ruoli';
$_lang["role_delete_snippet"] = 'Elimina snippet';
$_lang["role_delete_template"] = 'Elimina template';
$_lang["role_delete_user"] = 'Elimina utenti';
$_lang["role_delete_web_user"] = 'Cancella utente web';
$_lang["role_edit_chunk"] = 'Modifica chunk';
$_lang["role_edit_doc"] = 'Modifica una Risorsa';
$_lang["role_edit_doc_metatags"] = 'Modifica META tag e parole chiave della Risorsa';
$_lang["role_edit_module"] = 'Modifica modulo';
$_lang["role_edit_plugin"] = 'Modifica plugin';
$_lang["role_edit_role"] = 'Modifica ruoli';
$_lang["role_edit_settings"] = 'Cambia le impostazioni del sito';
$_lang["role_edit_snippet"] = 'Modifica snippet';
$_lang["role_edit_template"] = 'Modifica template del sito';
$_lang["role_edit_user"] = 'Modifica utenti';
$_lang["role_edit_web_user"] = 'Modifica utente web';
$_lang["role_empty_trash"] = 'Elimina in modo permanente le Risorse cancellate';
$_lang["role_errors"] = 'Visualizza i messaggi di errore';
$_lang["role_eventlog_management"] = 'Gestione Log Eventi';
$_lang["role_export_static"] = 'Esporta in HTML statico';
$_lang["role_file_manager"] = 'Usa il sistema di gestione file';
$_lang["role_frames"] = 'Richiama le cornici del sistema di gestione';
$_lang["role_help"] = 'Visualizza le pagine di aiuto';
$_lang["role_home"] = 'Richiama la pagina introduttiva del sistema di gestione';
$_lang["role_import_static"] = 'Importa HTML';
$_lang["role_logout"] = 'Esci dal sistema di gestione';
$_lang["role_manage_metatags"] = 'Gestione META tag e parole chiave';
$_lang["role_management_msg"] = 'Qui potete scegliere il ruolo da modificare.';
$_lang["role_management_title"] = 'Gestione Ruoli';
$_lang["role_messages"] = 'Visualizza ed invia messaggi';
$_lang["role_module_management"] = 'Gestione Moduli';
$_lang["role_name"] = 'Nome ruolo';
$_lang["role_new_module"] = 'Crea nuovo modulo';
$_lang["role_new_role"] = 'Crea nuovi ruoli';
$_lang["role_new_user"] = 'Crea nuovi utenti';
$_lang["role_new_web_user"] = 'Crea nuovo utete web';
$_lang["role_plugin_management"] = 'Gestione Plugin';
$_lang["role_publish_doc"] = 'Pubblica Risorse';
$_lang["role_remove_locks"] = 'Togli i blocchi';
$_lang["role_role_management"] = 'Gestione ruolo';
$_lang["role_run_module"] = 'Esegui modulo';
$_lang["role_save_chunk"] = 'Salva chunk';
$_lang["role_save_doc"] = 'Salva Risorse';
$_lang["role_save_module"] = 'Salva modulo';
$_lang["role_save_password"] = 'Salva password';
$_lang["role_save_plugin"] = 'Salva plugin';
$_lang["role_save_role"] = 'Salva ruoli';
$_lang["role_save_snippet"] = 'Salva snippet';
$_lang["role_save_template"] = 'Salva template';
$_lang["role_save_user"] = 'Salva utenti';
$_lang["role_save_web_user"] = 'Salva utente web';
$_lang["role_snippet_management"] = 'Gestione snippet';
$_lang["role_template_management"] = 'Gestione template';
$_lang["role_title"] = 'Crea/modifica ruolo';
$_lang["role_udperms"] = 'Gestione permessi';
$_lang["role_user_management"] = 'Gestione utente';
$_lang["role_view_docdata"] = 'Visualizza i dati di una Risorsa';
$_lang["role_view_eventlog"] = 'Vedi Log Eventi';
$_lang["role_view_logs"] = 'Visualizza i log di sistema';
$_lang["role_view_unpublished"] = 'Vedi le Risorse non pubblicate';
$_lang["role_web_access_persmissions"] = 'Permessi di accesso Web';
$_lang["role_web_user_management"] = 'Gestione utente web';
$_lang["rss_url_news_default"] = 'http://feeds.feedburner.com/modx-announce';
$_lang["rss_url_news_message"] = 'Inserire l\'URL per il Feed Novit&agrave; MODx.';
$_lang["rss_url_news_title"] = 'RSS News Feed';
$_lang["rss_url_security_default"] = 'http://feeds.feedburner.com/modxsecurity';
$_lang["rss_url_security_message"] = 'Inserire l\'URL per il Feed Avvisi di Protezione MODx.';
$_lang["rss_url_security_title"] = 'RSS Security Feed';
$_lang["run_module"] = 'Esegui modulo';
$_lang["saturday"] = 'Sabato';
$_lang["save"] = 'Salva';
$_lang["save_all_changes"] = 'Salva tutte le modifiche';
$_lang["save_tag"] = 'Salva tag';
$_lang["saving"] = 'Salvataggio in corso, vi preghiamo di attendere...';
$_lang["search"] = 'Ricerca';
$_lang["search_criteria"] = 'Criteri di ricerca';
$_lang["search_criteria_content"] = 'Cerca per contenuto';
$_lang["search_criteria_content_msg"] = 'Trovate tutte le Risorse che hanno questo testo nel loro contenuto.';
$_lang["search_criteria_id"] = 'Cerca per ID';
$_lang["search_criteria_id_msg"] = 'Inserite l\'ID di una Risorsa per individuarla rapidamente.';
$_lang["search_criteria_longtitle"] = 'Cerca per titolo esteso';
$_lang["search_criteria_longtitle_msg"] = 'Trovate tutte le Risorse che nel titolo esteso contengono questo testo.';
$_lang["search_criteria_title"] = 'Cerca per titolo';
$_lang["search_criteria_title_msg"] = 'Trovate tutte le Risorse che nel titolo contengono questo testo.';
$_lang["search_empty"] = 'La ricerca non ha prodotto risultati. Estendete i criteri di ricerca e provate nuovamente.';
$_lang["search_item_deleted"] = 'Questo elemento &egrave; stato eliminato';
$_lang["search_results"] = 'Risultati ricerca';
$_lang["search_results_returned_desc"] = 'Descrizione';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'I criteri di ricerca hanno restituito <b>%s</b> Risorse. Se i risultati sono molti, provate con una ricerca pi&ugrave; specifica. Le due colonne pi&ugrave; a sinistra permettono di trovare la Risorsa nella struttura ad albero o di visualizzarla. Le due colonne pi&ugrave; a destra mostrano, rispettivamente, se una Risorsa &egrave; stata eliminata e qual\'&egrave; il suo stato di pubblicazione.<p />';
$_lang["search_results_returned_title"] = 'Titolo';
$_lang["search_view_docdata"] = 'Visualizza questo elemento';
$_lang["security"] = 'Sicurezza';
$_lang["security_notices_tab"] ='Avvisi di Protezione';
$_lang["security_notices_title"] ='Avvisi di Protezione';
$_lang["select_date"] = 'Seleziona data';
$_lang["send"] = 'Invia';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Specificate se il sito &egrave; su una connessione https.';
$_lang["server_protocol_title"] = 'Tipo server:';
$_lang["serveroffset"] = 'Scostamento orario del server';
$_lang["serveroffset_message"] = 'Selezionate il numero di ore di differenza tra il luogo in cui ti trovi e il luogo in cui risiede il server. L\'ora attuale sul server &egrave; <b>[%s]</b>, con lo scarto orario che avete impostato l\'ora &egrave; <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Scostamento orario del server:';
$_lang["servertime"] = 'Orario del Server';
$_lang["settings_after_install"] = 'Dato che questa &egrave; una nuova installazione, vi preghiamo di controllare queste impostazioni e di cambiare quelle che desiderate. Dopo aver controllato le impostazioni, premete \'Salva\' per aggiornarne la configurazione di sistema.<br /><br />';
$_lang["settings_config"] = 'Configurazione';
$_lang["settings_dependencies"] = 'Dipendenze';
$_lang["settings_events"] = 'Eventi di Sistema';
$_lang["settings_furls"] = 'Impostazioni URL semplici';
$_lang["settings_general"] = 'Generali';
$_lang["settings_misc"] = 'Impostazioni varie';
$_lang["settings_page_settings"] = 'Impostazioni pagina';
$_lang["settings_photo"] = 'Foto';
$_lang["settings_properties"] = 'Propriet&agrave;';
$_lang["settings_site"] = 'Impostazioni sito';
$_lang["settings_strip_image_paths_message"] = 'Se questo valore &egrave; impostato su \'No\', MODx imposter&agrave; il percorso del browser dei file (immagini, file, flash, ecc.) su relativo invece che su assoluto. Questa opzione risulta utile se dovete spostare l\'installazione di MODx (ad esempio da un sito di test ad uno di produzione). Se non avete idea di cosa significa, lasciala impostata su \'si\'.';
$_lang["settings_strip_image_paths_title"] = 'Riscrivere i percorsi immagine?';
$_lang["settings_templvars"] = 'Variabili di Template';
$_lang["settings_title"] = 'Impostazioni MODx';
$_lang["settings_ui"] = 'Impostazioni editor & interfaccia';
$_lang["settings_users"] = 'Impostazioni utente';
$_lang["show_meta"] = 'Mostra le META Keywords';
$_lang["show_meta_message"] = 'Mostra META Keywords (deprecato) quando si modificano le Risorse nel Manager.';
$_lang["show_tree"] = 'Mostra struttura ad albero';
$_lang["showing"] = 'Visualizzo';
$_lang["signupemail_message"] = 'Qui potete impostare il messaggio da inviare agli utenti quando create loro un account e volete che MODx  invii una e-mail contenente nome utente e password. <br /><b>Nota:</b> Il codice %s viene sostituito da MODx all\'invio del messaggio. Il primo %s &egrave; sempre rimpiazzato dal nome utente, il secondo dalla password. <b>Lascia i due codici %s nel corpo della e-mail altrimenti il nome utente e password non saranno inviati e l\'utente non ne verr&agrave; a conoscenza!</b>';
$_lang["signupemail_title"] = 'E-mail per l\'iscrizione:';
$_lang["site"] = 'Sito';
$_lang["site_schedule"] = 'Pianificazione sito';
$_lang["sitename_message"] = 'Inserite qui il nome del sito.';
$_lang["sitename_title"] = 'Nome sito:';
$_lang["sitestart_message"] = 'Inserite l\'ID della Risorsa che volete usare come pagina d\'inizio. <b>NOTA: assicuratevi che l\'ID inserito appartenga a una Risorsa esistente e che sia stata pubblicata!</b>';
$_lang["sitestart_title"] = 'Il sito inizia da:';
$_lang["sitestatus_message"] = 'Selezionate \'Online\' per pubblicare il sito sul web. Se selezionate \'Offline\', i visitatori vedranno il \'Messaggio Sito non disponibile\' e non potranno consultarlo.';
$_lang["sitestatus_title"] = 'Stato del sito:';
$_lang["siteunavailable_message"] = 'Messaggio da visualizzare quando il sito &egrave; offline o si &egrave; verificato un errore.';
$_lang["siteunavailable_message_default"] = 'Questo sito non &egrave; al momento disponibile.';
$_lang["siteunavailable_page_message"] = 'Inserite l\'ID che volete mostrare quando il sito &egrave; offline. <b>NOTA: assicuratevi che l\'ID appartenga ad una Risorsa esistente, e che sia stata pubblicata!</b>';
$_lang["siteunavailable_page_title"] = 'Pagina sito non disponibile:';
$_lang["siteunavailable_title"] = 'Messaggio sito non disponibile:';
$_lang["snippet"] = 'Snippet';
$_lang["snippet_code"] = 'Codice Snippet (php)';
$_lang["snippet_desc"] = 'Descrizione snippet';
$_lang["snippet_execonsave"] = 'Esegui lo snippet dopo il salvataggio.';
$_lang["snippet_management_msg"] = 'Qui potete scegliere gli snippet da modificare.';
$_lang["snippet_msg"] = 'Qui potete aggiungere/ modificare gli snippet. Ricordate che gli snippet sono codice PHP \'raw\' (grezzo), e se prevedete che l\'output venga mostrato in un punto preciso del template, dovete avere una variabile nello snippet che abbia il nome dello snippet stesso - semplicemente, l\'output dello snippet dev\'essere salvato in una variabile che porta il nome dello snippet stesso.';
$_lang["snippet_name"] = 'Nome snippet';
$_lang["snippet_properties"] = 'Propriet&agrave; di default';
$_lang["snippet_title"] = 'Crea/modifica snippet';
$_lang["sort_asc"] = 'Ascendente';
$_lang["sort_desc"] = 'Discendente';
$_lang["sort_tree"] = 'Ordina la struttura ad albero';
$_lang["source"] = 'Sorgente';
$_lang["stay"] = 'Continua modifica dopo il salvataggio';
$_lang["stay_new"] = 'Aggiungi un altro';
$_lang["submit"] = 'Invia';
$_lang["sunday"] = 'Domenica';
$_lang["sys_alert"] = 'Avviso di sistema';
$_lang["sysinfo_activity_message"] = 'Questa lista mostra le Risorse modificate di recente dagli utenti.';
$_lang["sysinfo_userid"] = 'Utente';
$_lang["system_email_signup"] = 'Salve [+uid+] \n\nqui ci sono le credenziali di autenticazione per il sistema di gestione dei contenuti di [+sname+]:\n\nNome utente: [+uid+]\nPassword: [+pwd+]\n\nQuando ti sarai autenticato nel sistema di gestione ([+surl+]), potrai cambiare la tua password.\n\nCordiali Saluti, l\'amministratore del Sito';
$_lang["system_email_webreminder"] = 'Salve [+uid+]\n\nPer attivare la tua password clicca sul link sottostante:\n\n[+surl+]\n\nIn seguito potrai usare la seguente password per accedere:\n\nPassword:[+pwd+]\n\nSe non hai richiesto questa mail, ignorala.\n\nCordiali Saluti, l\'amministratore del Sito';
$_lang["system_email_websignup"] = 'Salve [+uid+] \n\nqui ci sono le credenziali di autenticazione per [+sname+]:\n\nNome utente: [+uid+]\nPassword: [+pwd+]\n\nQuando ti sarai autenticato in [+sname+] ([+surl+]), potrai cambiare la tua password.\n\nCordiali Saluti, l\'amministratore del Sito';
$_lang["table_hoverinfo"] = 'Portate il cursore sopra il nome di una tabella per vedere una breve descrizione della funzione della tabella (non tutte le tabelle hanno dei <i>commenti</i> impostati o tradotti).';
$_lang["table_prefix"] = 'Prefisso Tabella';
$_lang["tag"] = 'Tag';
$_lang["template"] = 'Template';
$_lang["template_assignedtv_tab"] = 'Variabili di Template Assegnate';
$_lang["template_code"] = 'Codice del Template (html)';
$_lang["template_desc"] = 'Descrizione';
$_lang["template_edit_tab"] = 'Modifica Template';
$_lang["template_management_msg"] = 'Qui potete scegliere il template da modificare.';
$_lang["template_msg"] = 'Qui potete creare/modificare i template. I template modificati o nuovi non saranno visibili nelle pagine in cache finch&egrave; la cache stessa non verr&agrave; svuotata. Ad ogni modo, potete usare la funzione di anteprima su una pagina per vedere il template in azione.';
$_lang["template_name"] = 'Nome del template';
$_lang["template_no_tv"] = 'A questo template non sono ancora state assegnate delle Variabili di Template.';
$_lang["template_reset_all"] = 'Impostate il nuovo template di default su tutte le pagine';
$_lang["template_reset_specific"] = 'Impostate il nuovo template di default solo sulle pagine con \'%s\'';
$_lang["template_title"] = 'Crea/modifica template';
$_lang["template_tv_edit"] = 'Modificate l\'ordinamento delle Variabili di Template';
$_lang["template_tv_edit_message"] = 'Trascinare per riordinare le Variabili di Template di questo template.';
$_lang["template_tv_edit_title"] = 'Ordine delle Variabili di Template';
$_lang["template_tv_msg"] = 'Le variabili di template assegnate a questo template sono elencate qui in basso.';
$_lang["thursday"] = 'Gioved&igrave;';
$_lang["tmplvar_access_msg"] = 'Selezionate i Gruppi di Risorse autorizzati a modificare il contenuto o il valore di questa Variabile di Template';
$_lang["tmplvar_change_template_msg"] = 'Cambiando questo template verranno ricaricate le Variabili di Template. Tutte le modifiche non salvate verranno perse.\n\n Siete sicuri di voler modificare il template?';
$_lang["tmplvar_inuse"] = 'Le seguenti Risorse utilizzano questa Variabile di Template. Per confermare la cancellazione, cliccare su elimina. Altrimenti cliccare su cancella.';
$_lang["tmplvar_tmpl_access"] = 'Accesso template';
$_lang["tmplvar_tmpl_access_msg"] = 'Selezionate i templates che possono contere questa variabile';
$_lang["tmplvars"] = 'Variabili di Template';
$_lang["tmplvars_binding_msg"] = 'Questo campo supporta connessioni di sorgenti dati che usano il comando @  ';
$_lang["tmplvars_caption"] = 'Didascalia';
$_lang["tmplvars_default"] = 'Valore di default';
$_lang["tmplvars_description"] = 'Descrizione';
$_lang["tmplvars_elements"] = 'Opzioni valori di ingresso';
$_lang["tmplvars_management_msg"] = 'Qui potete gestire le Variabili di Template aggiuntive per le vostre Risorse.';
$_lang["tmplvars_msg"] = 'Qui potete creare o modificare le Variabili di Template. Le Variabili di Template devono essere assegnate ad un template per poter essere utilizzate da snippets e Risorse.';
$_lang["tmplvars_name"] = 'Nome variabile';
$_lang["tmplvars_novars"] = 'Nessuna Variabile di Template trovata';
$_lang["tmplvars_rank"] = 'Ordinamento';
$_lang["tmplvars_reset_params"] = 'Resetta parametri';
$_lang["tmplvars_title"] = 'Crea/modifica Variable di Template';
$_lang["tmplvars_type"] = 'Tipo di ingresso';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Propriet&agrave; Widget';
$_lang["to"] = 'a';
$_lang["tools"] = 'Strumenti';
$_lang["top_howmany_message"] = 'Nel visualizzare i resoconti, quanto deve essere grande la lista \'I primi ...\'?';
$_lang["top_howmany_title"] = 'Quanti \'I primi\'';
$_lang["total"] = 'totale';
$_lang["track_visitors_message"] = 'La registrazione delle visite vi permette di vedere le statistiche sull\'utilizzo del sito, tuttavia, la registrazione rallenta un po\' il parser del sito. Se non volete essere assillati dalle statistiche sui visitatori, potete tranquillamente disattivarle e godervi l\'aumento di velocit&agrave;.';
$_lang["track_visitors_title"] = 'Registra visite (statistiche)';
$_lang["tree_page_click"] = 'Click su una pagina';
$_lang["tree_page_click_message"] = 'Cosa succede facendo click su una pagina nell\'albero del sito.';
$_lang["tree_show_protected"] = 'Mostra pagine protette';
$_lang["tree_show_protected_message"] = 'Se impostato "No", Le pagine protette (e tutte le pagine figlie) non appariranno nell\'albero delle Risorse. "No" &egrave; l\'impostazione di default di MODx.';
$_lang["truncate_table"] = 'Cliccate qui per troncare questa tabella';
$_lang["tuesday"] = 'Marted&igrave;';
$_lang["tv"] = 'TV';
$_lang["type"] = 'Tipo';
$_lang["udperms_allowroot_message"] = 'Volete permettere agli utenti di creare nuove Risorse e cartelle nella root del sito? ';
$_lang["udperms_allowroot_title"] = 'Permetti root:';
$_lang["udperms_message"] = 'I permessi di accesso vi consentono di specificare quali pagine possono essere modificate dagli utenti. Avete bisogno di assegnare gli utenti ai Gruppi di Utenti, le Risorse ai Gruppi di Risorse, ed infine dovrete specificare quali Gruppi di Utenti hanno accesso a quali Gruppi di Risorse. Appena saranno attivati i permessi, solo gli amministratori potranno modificare qualsiasi Risorsa.';
$_lang["udperms_title"] = 'Usa i permessi di accesso:';
$_lang["unable_set_link"] = 'Impossibile impostare il collegamento!';
$_lang["unable_set_parent"] = 'Impossibile impostare una nuova Risorsa genitore!';
$_lang["unauthorizedpage_message"] = 'Digitate l\'Id della Risorsa che volete mostrare agli utenti che hanno richiesto una Risorsa protetta o non autorizzata. <b>NOTA: assicuratevi che la Risorsa indicata esista, sia pubblicata e accessibile all\'utente!</b>';
$_lang["unauthorizedpage_title"] = 'Pagina non autorizzata:';
$_lang["unblock_message"] = 'L\'utente non sar&agrave; pi&ugrave; bloccato dopo aver salvato i suoi dati.';
$_lang["undelete_resource"] = 'Ripristina Risorsa';
$_lang["unpublish_date"] = 'Data di ritiro dalla pubblicazione';
$_lang["unpublish_events"] = 'Eventi di ritiro dalla pubblicazione';
$_lang["unpublish_resource"] = 'Ritira Risorsa';
$_lang["untitled_resource"] = 'Risorsa senza titolo';
$_lang["untitled_weblink"] = 'Link Web senza titolo';
$_lang["update_params"] = 'Aggiorna parametri di visualizzazione';
$_lang["update_settings_from_language"] = 'Sostituire con:';
$_lang["upload_maxsize_message"] = 'Qui potete inserire le dimensioni massime dei file si possono caricare tramite il sistema di gestione file. Le dimensioni di caricamento devo essere impostate in bytes. <b>NOTE: File troppo grandi impiegano molto tempo per il caricamento!</b>';
$_lang["upload_maxsize_title"] = 'Massima dimensione caricamento';
$_lang["uploadable_files_message"] = 'Qui potete inserire una lista di file che si possono caricare tramite il sistema di gestione file. Inserite le estensioni per i tipi di file separate da virgole.';
$_lang["uploadable_files_title"] = 'Tipi di file caricabili:';
$_lang["uploadable_flash_message"] = 'Qui potete inserire una lista di file che si possono caricare tramite il sistema di gestione file nella cartella \'assets/flash/\'. Inserite le estensioni per i tipi di Flash separate da virgole.';
$_lang["uploadable_flash_title"] = 'Tipi di Flash caricabili:';
$_lang["uploadable_images_message"] = 'Qui potete inserire una lista di file che si possono caricare tramite il sistema di gestione file nella cartella \'assets/images/\'. Inserite le estensioni per i tipi di immagine separate da virgole.';
$_lang["uploadable_images_title"] = 'Tipi di immagini caricabili:';
$_lang["uploadable_media_message"] = 'Qui potete inserire una lista di file che si possono caricare tramite il sistema di gestione file nella cartella \'assets/flash/\'. Inserite le estensioni per i tipi di media separate da virgole.';
$_lang["uploadable_media_title"] = 'Tipi di media caricabili:';
$_lang["use_alias_path_message"] = 'Impostando questa opzione su \'si\' verr&agrave; mostrato il percorso completo alla Risorsa, se la Risorsa ha un alias. Ad esempio, se una Risorsa con un alias \'figlio\' si trova nella cartella con alias \'genitore\', il percorso dell\'alias sar&agrave; \'/genitore/figlio.html\'.<br /><b>NOTA: Impostando questa opzione su \'si\' (attivando il percorso alias), dovete far riferimento a file (come immagini, css, javascript, etc) usando il percorso assoluto:  ad esempio, \'/assets/images\' anzich&egrave; \'assets/images\'. In questo modo impedirete al browser (o web server) di collegare il percorso relativo al percorso dell\'alias.</b>';
$_lang["use_alias_path_title"] = 'Usa i percorsi semplici dell\'alias:';
$_lang["use_editor_message"] = 'Volete abilitare l\'editor rich text? Se reputate pi&ugrave; confortevole scrivere in HTML, con questa impostazione potete disabilitarlo. Da notare che le impostazioni si applicano a tutte le Risorse e a tutti gli utenti!';
$_lang["use_editor_title"] = 'Abilita editor:';
$_lang["user"] = 'Utente';
$_lang["user_block"] = 'Bloccato';
$_lang["user_blockedafter"] = 'Bloccato dopo';
$_lang["user_blockeduntil"] = 'Bloccato fino';
$_lang["user_changeddata"] = 'I vostri dati sono stati modificati. Vi preghiamo di effettuare nuovamente l\'accesso.';
$_lang["user_country"] = 'Nazione';
$_lang["user_dob"] = 'Data di nascita';
$_lang["user_doesnt_exist"] = 'L\'utente non esiste';
$_lang["user_edit_self_msg"] = 'Per aggiornare completamente le vostre informazioni dopo il salvataggio, potreste aver bisogno di scollegarvi e di ricollegarvi nuovamente.</b><br>Inoltre, se avete scelto di generare una nuova password, essa vi verr&agrave; inviata per e-mail.';
$_lang["user_email"] = 'Indirizzo e-mail';
$_lang["user_failedlogincount"] = 'Login falliti';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Femmina';
$_lang["user_full_name"] = 'Nome completo';
$_lang["user_gender"] = 'Sesso';
$_lang["user_is_blocked"] = 'L\'utente &egrave; bloccato!';
$_lang["user_logincount"] = 'Numero di autenticazioni';
$_lang["user_male"] = 'Maschio';
$_lang["user_management_msg"] = 'Qui potete scegliere l\'utente da modificare.';
$_lang["user_management_title"] = 'Gestione Utenti';
$_lang["user_mobile"] = 'Numero di cellulare';
$_lang["user_phone"] = 'Numero di telefono';
$_lang["user_photo"] = 'Foto Utente';
$_lang["user_photo_message"] = 'Inserite l\'url dell\'immagine o caricate l\'immagine sul server.';
$_lang["user_prevlogin"] = 'Ultima autenticazione';
$_lang["user_role"] = 'Ruolo utente';
$_lang["user_state"] = 'Regione';
$_lang["user_title"] = 'Crea/modifica utente';
$_lang["user_upload_message"] = 'Se volete impedire che questo utente possa caricare files di questo tipo, assicuratevi che la casella \'Use Main Configuration Setting\' non sia selezionata e lasciate vuoto il campo.';
$_lang["user_use_config"] = 'Usare le Impostazioni di Sistema';
$_lang["user_zip"] = 'CAP';
$_lang["username"] = 'Nome utente';
$_lang["users"] = 'Sicurezza';
$_lang["validate_referer_message"] = 'Validare gli headers HTTP_REFERER per ridurre il rischio di essere vittime di un attacco CSRF (Cross Site Request Forgery). Alcune configurazioni possono non essere in grado di gestire questa opzione se il server non invia gli headers HTTP_REFERER.';
$_lang["validate_referer_title"] = 'Validare HTTP_REFERER headers?';
$_lang["value"] = 'Valore';
$_lang["view"] = 'Mostra';
$_lang["view_child_resources_in_container"] = "Vedi le Risorse contenute";
$_lang["view_log"] = 'Vedi log';
$_lang["view_logging"] = 'Cronistorie';
$_lang["view_sysinfo"] = 'Informazioni di Sistema';
$_lang["warning"] = 'Attenzione!';
$_lang["warning_not_saved"] = 'Le modifiche che avete effettuato non sono state ancora salvate. Potete scegliere di rimanere sulla pagina corrente per salvarle (\'Annulla\'), oppure potete abbandonarla perdendo ogni modifica che avete fatto (\'OK\').';
$_lang["warning_visibility"] = 'Avvisi di configurazione visibili a';
$_lang["warning_visibility_message"] = 'Controlla la visualizzazione degli avvisi mostrati nella pagina iniziale del Manager';
$_lang["web_access_permissions"] = 'Permessi di accesso Web';
$_lang["web_access_permissions_user_groups"] = 'Gruppi di Utenti Web';
$_lang["web_permissions"] = 'Permessi Web';
$_lang["web_user_management_msg"] = 'Qui potete selezionare l\'utente web da modificare. Gli utenti web sono gli utenti autorizzati ad accedere al sito.';
$_lang["web_user_management_title"] = 'Gestione Utenti Web';
$_lang["web_user_title"] = 'Crea/modifica Utenti Web';
$_lang["web_users"] = 'Utenti web';
$_lang["weblink"] = 'Link Web';
$_lang["webpwdreminder_message"] = 'Inserite il messaggio da inviare in mail, quando gli utenti chiedono una nuova password via email. IL sistema di gestione dei contenuti invier&agrave; loro una e-mail contenente la nuova password e le informazioni di attivazione. <br /><b>Nota:</b> I seguenti segnaposto saranno sostituiti dal sistema di gestione del contenuto quando invier&agrave; il messaggio: <br /><br />[+sname+] - Nome del sito, <br />[+saddr+] - Indirizzo email del sito, <br />[+surl+] - Url del sito, <br />[+uid+] - Login o id dell\'utente, <br />[+pwd+] - Password utente, <br />[+ufn+] - Nome completo dell\'utente. <br /><br /><b>Lasciate [+uid+] e [+pwd+] nella e-mail, altrimenti il nome utente e la password non verranno inviati!<</b>';
$_lang["webpwdreminder_title"] = 'Email recupero dati autenticazione:';
$_lang["websignupemail_message"] = 'Qui potete impostare il messaggio da inviare agli utenti quando creerete loro un account e volete che MODx invii una e-mail contenente nome utente e password. <br />Nota:</b> I seguenti segnaposto saranno sostituiti dal sistema di gestione del contenuto quando invier&agrave; il messaggio: <br /><br />[+sname+] - Nome del sito, <br />[+saddr+] - Indirizzo email del sito, <br />[+surl+] - Url del sito, <br />[+uid+] - Login o id dell\'utente, <br />[+pwd+] - Password utente, <br />[+ufn+] - Nome completo dell\'utente. <br /><br /><b>Lasciate [+uid+] e [+pwd+] nella e-mail, altrimenti il nome utente e la password non verranno inviati!<</b>';
$_lang["websignupemail_title"] = 'Indirizzo E-mail di registrazione:';
$_lang["wednesday"] = 'Mercoled&igrave;';
$_lang["welcome_messages"] = 'La vostra inbox contiene <b>%d</b> messaggi(o), di cui <b>%s</b> non letto/i.';
$_lang["welcome_title"] = 'Benvenuto nel sistema di gestione dei contenuti MODx';
$_lang["which_editor_message"] = 'Qui potete selezionare l\'editor rich text da usare. Potete scaricare ed installare altri RichText editor dal sezione downloads del sito di MODx ';
$_lang["which_editor_title"] = 'Editor da usare:';
$_lang["working"] = 'Sto elaborando...';
$_lang["wrap_lines"] = 'Manda le linee a capo automaticamente';
$_lang["xhtml_urls_message"] = 'Sostituisce la e commerciale (ampersand (&amp;)) negli indirizzi generati da  MODx con l\' entit&agrave; HTML &<!-- -->amp;';
$_lang["xhtml_urls_title"] = 'URL XHTML';
$_lang["yes"] = 'Si';
$_lang["you_got_mail"] = 'Avete una mail';
$_lang["yourinfo_message"] = 'Questa sezione mostra alcune vostre informazioni:';
$_lang["yourinfo_previous_login"] = 'La vostra ultima connessione al sistema:';
$_lang["yourinfo_role"] = 'Il vostro ruolo &egrave;:';
$_lang["yourinfo_title"] = 'Le vostre informazioni';
$_lang["yourinfo_total_logins"] = 'Numero totale di connessioni:';
$_lang["yourinfo_username"] = 'Siete autenticati come:';
?>