<?php
/**
 * Filename:       includes/lang/japanese-utf8.inc.php
 * Function:       Language file.
 * Encoding:       UTF8
 * Author:         eastbind, MEGU, yamamoto
 * Date:           2010/12/19
 * Version:        2.0.7
 * MODx version:   Evolution 1.0.5J
*/
//$modx_textdir = 'rtl'; // uncomment this line for RTL langauges
$modx_lang_attribute = 'ja'; // Manager HTML and XML Language Attribute
$modx_manager_charset = 'UTF-8';

$_lang["about_msg"] = '<p>MODx(モドエックスまたはモッドエックス)は <a href="http://ja.wikipedia.org/wiki/MODx" target="_blank">PHP アプリケーション フレームワーク・コンテンツ管理システム</a>です。<a href="../assets/docs/license.txt">GNU GPL</a> に基づいて使用が許諾されます。</p>';
$_lang["about_title"] = 'MODx について';
$_lang["access_permission_denied"] = 'このリソースにアクセスする権限がありません。';
$_lang["access_permission_parent_denied"] = 'ここにリソースを作成する権限がありません。';
$_lang["access_permissions"] = '所属グループ';
$_lang["access_permissions_add_resource_group"] = 'リソースグループを作成';
$_lang["access_permissions_add_user_group"] = 'ユーザーグループを作成';
$_lang["access_permissions_docs_collision"] = 'ウェブユーザーグループとマネージャーユーザーグループの設定に問題があるため、このリソースは公開されます。詳細については管理者へお問い合わせください。';
$_lang["access_permissions_docs_message"] = 'このリソースを所属させたい<a href="index.php?a=40">リソースグループ</a>を選択してください。グループで制限する必要がなければ「グループ制限なし」にチェックを入れます。または<a href="index.php?a=17">「グローバル設定」</a>の「詳細設定」で「グループ管理機能を使用する」を「いいえ」にします。';
$_lang["access_permissions_group_link"] = 'グループリンクを新規作成';
$_lang["access_permissions_introtext"] = 'ここでユーザーグループまたはリソースグループを作ると、ユーザ編集画面またはリソース編集画面で所属グループを選択できるようになります。グループ機能を利用するためには、ユーザーグループとリソースグループを必ず関連付ける必要があります。また、個別のユーザー及びリソースをそれぞれ直接関連付けることはできません。<br />※<a href="index.php?a=17">グローバル設定</a>の「グループ管理機能を使用する(詳細設定タブ)」を「いいえ」にすると、この画面の設定は無効になります。';
$_lang["access_permissions_link_to_group"] = 'リソースグループ';
$_lang["access_permissions_link_user_group"] = 'ユーザーグループ';
$_lang["access_permissions_links"] = 'グループリンク';
$_lang["access_permissions_links_tab"] = 'リソースグループとユーザーグループを関連付けます(※グループ管理機能を使う場合は必須です)。';
$_lang["access_permissions_no_resources_in_group"] = 'なし';
$_lang["access_permissions_no_users_in_group"] = 'なし';
$_lang["access_permissions_off"] = '<span class="warning">グループ管理機能(グローバル設定 &gt; 詳細設定)が無効になっています。</span>';
$_lang["access_permissions_resource_groups"] = 'リソースグループ';
$_lang["access_permissions_resources_in_group"] = '<strong>グループ内リソース:</strong> ';
$_lang["access_permissions_resources_tab"] = 'IDの上にマウスポインタを重ねるとリソース名を確認できます。リソースをグループに加えるには、リソース編集画面を個別に開いて「所属グループ」タブで設定してください。管理画面とウェブページを区別して扱わないため、両方のグループを作る場合はグループ名を工夫するとよいでしょう。';
$_lang["access_permissions_user_groups"] = 'ユーザーグループ ';
$_lang["access_permissions_user_message"] = 'このユーザーを所属させたいユーザーグループを選択してください。ユーザは所属しているグループに割り当てられたリソースのみを編集できます。';
$_lang["access_permissions_users_in_group"] = '<strong>グループ内ユーザー:</strong> ';
$_lang["access_permissions_users_tab"] = '管理画面を扱うユーザのグループと、ウェブページにアクセスする権限を持つユーザのグループは区別されます。ユーザーをグループに参加させるには、個々のユーザー設定で編集する必要があります。<br />※Administrator(ID=1のロールを持つユーザ)は常に全てのリソースにアクセスすることができるため、Administratorをグループに追加する必要はありません。';
$_lang["account_email"] = 'メールアドレス';
$_lang["actioncomplete"] = '<strong>処理が正常に完了しました。</strong><br /> - クリーンアップ処理中です。お待ちください。';
$_lang["activity_message"] = '自分が編集したリソースの一覧(最新順に10件まで)';
$_lang["activity_title"] = '最近編集したリソース';
$_lang["add"] = '追加';
$_lang["add_chunk"] = 'チャンクの追加';
$_lang["add_doc"] = 'リソースの追加';
$_lang["add_folder"] = 'ディレクトリの作成';
$_lang["add_plugin"] = 'プラグインの追加';
$_lang["add_resource"] = 'リソースの作成';
$_lang["add_snippet"] = 'スニペットの追加';
$_lang["add_tag"] = 'タグ追加';
$_lang["add_template"] = 'テンプレートの追加';
$_lang["add_tv"] = 'テンプレート変数の追加';
$_lang["add_weblink"] = 'ウェブリンクの作成';
$_lang["administrator_role_message"] = '全ての権限を持ちます。このロールは編集・削除できません。';
$_lang["administrators"] = '管理者のみ(Administrator)';
$_lang["after_saving"] = '保存後は';
$_lang["alert_delete_self"] = '自分自身を削除することはできません。';
$_lang["alias"] = 'エイリアス';
$_lang["all_doc_groups"] = 'グループ制限なし(Public)';
$_lang["all_events"] = '全てのイベント';
$_lang["all_usr_groups"] = '全ユーザーグループ(Public)';
$_lang["allow_mgr_access"] = '管理画面へのアクセス';
$_lang["allow_mgr_access_message"] = 'このオプションは管理画面へのアクセスをユーザーに許可するかしないかを選択するものです。<br /><strong>※このオプションを「いいえ」に設定すると、ユーザーは上記の「管理画面ログイン開始ページ」か、それが空白ならサイトスタートのページへリダイレクトされます。</strong>';
$_lang["already_deleted"] = 'はすでに削除されています';
$_lang["attachment"] = 'ファイルとしてダウンロード';
$_lang["automatic_alias_message"] = '「はい」を選択すると、リソースの保存のときリソースのタイトルを元にシステムが自動的にエイリアスを作成します。<br />※日本語環境での使用は推奨しません。';
$_lang["automatic_alias_title"] = 'エイリアス自動生成<br />(日本語環境では推奨しません) ';
$_lang["backup"] = 'バックアップ';
$_lang["bk_manager"] = 'バックアップマネージャー';
$_lang["block_message"] = '更新後、このユーザーのアカウントは休止状態になります。';
$_lang["blocked_minutes_message"] = '上記の「ログイン失敗を許容する回数」で指定した回数ログインに失敗したユーザーのアカウントをロックする時間を分単位で指定します。必ず数字のみを入力してください。カンマやスペースも使えません。';
$_lang["blocked_minutes_title"] = 'アカウントロックの時間 ';
$_lang["cache_files_deleted"] = '次のファイルが削除されました ';
$_lang["cancel"] = 'キャンセル';
$_lang["captcha_code"] = 'セキュリティコード';
$_lang["captcha_message"] = 'ランダムな文字列を画像で表示し、ユーザーに目視させて入力を求めます。これによりセキュリティを強化できます。';
$_lang["captcha_title"] = 'CAPTCHAコードの使用 ';
$_lang["captcha_words_default"] = 'isono,fuguta,sazae,masuo,katsuo,wakame,tarao,namihei,fune,tama,mokuzu,umihei,norisuke,taiko,ikura,sakeo,norio,isasaka,hanazawa,hanako,anago';
$_lang["captcha_words_message"] = '「CAPTCHAコードの使用」を「はい」にした場合に使用されるCAPTCHAワードリストを入力してください。CAPTCHAワードはカンマで区切って入力します。このフィールドには、255文字まで入力することができます。';
$_lang["captcha_words_title"] = 'CAPTCHA用ワード';
$_lang["category_heading"] = 'カテゴリー';
$_lang["category_msg"] = '<h3 style="font-weight:bold;">全エレメントの一覧</h3><p>カテゴリーでグループ化したエレメントを一覧・編集できます。不要なカテゴリーの削除もこちらで。削除されるのはカテゴリー名だけで、エレメントは「カテゴリーなし」に移動します。</p>';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'ログイン名を変更';
$_lang["change_password"] = 'パスワード変更';
$_lang["change_password_confirm"] = 'パスワードをもう一度';
$_lang["change_password_message"] = 'パスワードの文字数は6～15文字です。';
$_lang["change_password_new"] = 'パスワード';
$_lang["charset_message"] = '管理画面で使用したいエンコードを選択できます。すでにUTF-8で運用している場合、EUCを選択すると既存のコンテンツや設定などは文字化けします。事前にphpMyAdminなどを利用して変換し、設定変更後にインポートし直す必要があります。';
$_lang["charset_title"] = 'エンコード ';
$_lang["chunk"] = 'チャンク';
$_lang["chunk_code"] = 'チャンク コード (html)';
$_lang["chunk_multiple_id"] = 'エラー: 複数のチャンクが一つのユニークIDを利用しています。';
$_lang["chunk_no_exist"] = 'チャンクが存在しません。';
$_lang["cleaningup"] = 'クリーンアップ処理中';
$_lang["clean_uploaded_filename"] = 'Use Transliteration for File Uploads';
$_lang["clean_uploaded_filename_message"] = 'Use the default or transalias settings for the file name to clean special characters from uploaded file names, preserving dot-characters (periods)';
$_lang["clear_log"] = 'ログをクリア';
$_lang["click_to_context"] = 'クリックするとコンテキストメニュー';
$_lang["click_to_edit_title"] = '編集はここをクリック';
$_lang["click_to_view_details"] = '詳細を見る';
$_lang["close"] = '閉じる';
$_lang["code"] = 'コード';
$_lang["collapse_tree"] = 'サイトツリーを縮小';
$_lang["comment"] = 'コメント';
$_lang["configcheck_admin"] = 'このメッセージをシステム管理者に報告してください';
$_lang["configcheck_cache"] = 'キャッシュディレクトリに書き込みできません';
$_lang["configcheck_cache_msg"] = 'キャッシュファイルを保存できません。MODxは動作しますが、キャッシュが利用できないため軽快なレスポンスを得られません。キャッシュを有効にするためには /cache/ ディレクトリを書き込み可能にしてください。';
$_lang["configcheck_configinc"] = '設定ファイルがまだ書き込み可能になっています';
$_lang["configcheck_configinc_msg"] = '今の状態では、悪意ある人がこのサイトを壊すことができてしまいます。設定ファイル (/manager/includes/config.inc.php)のパーミッションを404などに設定し、書込み不可にしてください。';
$_lang["configcheck_default_msg"] = '原因不明のエラーが存在します。';
$_lang["configcheck_errorpage_unavailable"] = '設定した「エラーページ」は利用できません';
$_lang["configcheck_errorpage_unavailable_msg"] = '設定した「エラーページ」が一般的なエンドユーザーからアクセスできないページ（private）かあるいは存在しないことを意味しています。この場合、システムがループ状態に陥り、多くのエラーメッセージをエラーログに記録してしまいます。「エラーページ」には存在するページでかつ、公開ページ、かつ「public」なページを指定してください。';
$_lang["configcheck_errorpage_unpublished"] = 'グローバル設定で設定されたエラーページは公開されていません。';
$_lang["configcheck_errorpage_unpublished_msg"] = '設定したエラーページが誰でも見られるようにはなっていないことを意味します。エラーページは全ての人(Public)に公開するようにしてください。';
$_lang["configcheck_hide_warning"] = '<a href="javascript:hideConfigCheckWarning(\'%s\');"><em>Don\'t show this again.</em></a>';
$_lang["configcheck_images"] = 'イメージディレクトリに書き込みできません';
$_lang["configcheck_images_msg"] = 'イメージディレクトリが書き込み可能でないか、ディレクトリ自体が存在していません。エディターの画像管理機能が動作しません';
$_lang["configcheck_installer"] = 'インストーラーが残されています';
$_lang["configcheck_installer_msg"] = '/install/ ディレクトリにMODxのインストーラーが残されています。攻撃を受ける可能性がありますので、すぐに削除してください。';
$_lang["configcheck_lang_difference"] = '言語ファイルのエントリー数が異なります';
$_lang["configcheck_lang_difference_msg"] = '現在選択されている言語ファイルのエントリー数がデフォルト言語ファイル(英語)のエントリー数と異なるため、一部が英語で表示されます。日本語で表示したい場合は、最新の言語ファイルを入手しアップデートする必要があります。';
$_lang["configcheck_notok"] = '動作環境に問題があります。';
$_lang["configcheck_ok"] = '確認OK - 警告はありません。';
$_lang["configcheck_php_gdzip"] = 'GDライブラリが読み込まれてません。';
$_lang["configcheck_php_gdzip_msg"] = 'このサーバでは<a href="http://www.google.com/search?q=gd+%22php.ini%22&lr=lang_ja" target="_blank">GDライブラリ</a>が読み込まれてません。<a href="http://www.google.com/cse?cx=007286147079563201032%3Aigbcdgg0jyo&ie=UTF-8&q=CAPTCHA&sa.x=26&sa.y=8&siteurl=modxcms-jp.com%2Fbb%2F" target="_blank">ログイン時の画像認証機能(CAPTCHA)</a>など画像まわりの処理に制限があります。';
$_lang["configcheck_register_globals"] = '「register_globals」が「ON」に設定されており、セキュリティ上問題があります。';
$_lang["configcheck_register_globals_msg"] = 'クロスサイトスクリプティング攻撃(XSS)を受けやすい脆弱性があります。XSS攻撃はMODx本体に限らず、サードパーティによって開発されるスニペットやプラグインも攻撃対象となります。register_globals on の環境を特に必要としない場合は、.htaccessまたはphp.iniによって OFF にすることを強くおすすめします。';
$_lang["configcheck_title"] = '設定チェック';
$_lang["configcheck_templateswitcher_present"] = 'TemplateSwitcher Plugin detected';
$_lang["configcheck_templateswitcher_present_delete"] = '<a href="javascript:deleteTemplateSwitcher();">Delete TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_disable"] = '<a href="javascript:disableTemplateSwitcher();">Disable TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_msg"] = 'The TemplateSwitcher plugin has been found to cause caching and performance problems, and should be used only the functionality is required in your site.';
$_lang["configcheck_unauthorizedpage_unavailable"] = '「権限外告知のページ」が公開されていないか、存在しません';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = '設定した「権限外告知のページ」が一般的なエンドユーザーからアクセスできないページ（private）かあるいは存在しないことを意味しています。システムがループ状態に陥り、多数のエラーをエラーログに蓄積します。権限フリーの公開ページを「権限外告知のページ」に指定してください。';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'グローバル設定で設定された権限外告知のページは公開されていません。';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = '設定した権限外告知のページが誰でも見られるようにはなっていないことを意味します。権限外告知ページは全ての人「Public」に公開するようにしてください。';
$_lang["configcheck_validate_referer"] = 'セキュリティ警告: 参照元チェックの設定';
$_lang["configcheck_validate_referer_msg"] = '<a href="index.php?a=17">グローバル設定</a>の<strong>「管理画面のリファラチェック」</strong>がオフになっています。セキュリティ強化のためオンにすることをおすすめします。<br /><a href="javascript:hideHeaderVerificationWarning();"><em>今後この警告を表示しない</em></a>';
$_lang["configcheck_warning"] = '警告 ';
$_lang["configcheck_what"] = 'どういう意味ですか?';
$_lang["confirm_block"] = 'このアカウントを休止してもよろしいですか?';
$_lang["confirm_delete_eventlog"] = 'このログエントリーを削除してもよろしいですか?';
$_lang["confirm_delete_file"] = 'このファイルを削除してもよろしいですか?';
$_lang["confirm_delete_htmlsnippet"] = 'このチャンクを削除してもよろしいですか?';
$_lang["confirm_delete_keywords"] = 'これらのキーワードを削除してもよろしいですか?';
$_lang["confirm_delete_module"] = 'このモジュールを削除してもよろしいですか?';
$_lang["confirm_delete_plugin"] = 'このプラグインを削除してもよろしいですか?';
$_lang["confirm_delete_record"] = 'このレコードを削除してもよろしいですか?';
$_lang["confirm_delete_resource"] = 'このリソースを削除してもよろしいですか?\n同時にサブリソースも全て削除されます。';
$_lang["confirm_delete_role"] = 'このロールを削除してもよろしいですか?';
$_lang["confirm_delete_snippet"] = 'このスニペットを削除してもよろしいですか?';
$_lang["confirm_delete_tags"] = 'このMETAタグを削除してもよろしいですか?';
$_lang["confirm_delete_template"] = 'このテンプレートを削除してもよろしいですか?';
$_lang["confirm_delete_tmplvars"] = 'このテンプレート変数と記録されている値を全て削除してもよろしいですか?';
$_lang["confirm_delete_user"] = 'このユーザーを削除してもよろしいですか?';
$_lang["confirm_duplicate_record"] = 'このレコードを複製してもよろしいですか?';
$_lang["confirm_empty_trash"] = '全ての削除済みリソースを完全に消去します。';
$_lang["confirm_load_depends"] = '変更を保存せずに「関連付けの管理」画面をロードしてもよろしいですか?';
$_lang["confirm_name_change"] = 'ログイン名を変更すると、ログイン名にリンクする他のプログラム(スニペット・モジュールなど)に影響が及ぶ場合があります。 \n\n 本当にログイン名を変更してよろしいですか?';
$_lang["confirm_publish"] = '\n\nこの操作で公開すると「公開開始日時」「公開終了日時」の設定は消去されます。公開開始日時を過去の日時に設定することで公開することもできますので、その場合は「リソースの編集」で日時を変更してください。';
$_lang["confirm_remove_locks"] = '他ユーザーが編集操作を正常に終了しなかったため残されたロックを全て解除します。\n\n続けますか?';
$_lang["confirm_resource_duplicate"] = 'このリソースを複製してもよろしいですか？配下のリソースも複製されます。';
$_lang["confirm_setting_language_change"] = '変更を破棄し、システムの既定値に戻します。';
$_lang["confirm_unblock"] = 'このアカウントの休止を解除します。';
$_lang["confirm_undelete"] = '\n\n削除したリソースを復活します。連動して削除されたサブリソースがある場合は、それらもまとめて復活します。\n異なるタイミングで削除したサブリソースは復旧しません。';
$_lang["confirm_unpublish"] = '\n\nこの操作で非公開にすると「公開開始日時」「公開終了日時」の設定は消去されます。公開終了日時を過去の日時に設定することで非公開にすることもできますので、その場合は「リソースの編集」で日時を変更してください。';
$_lang["confirm_unzip_file"] = 'このファイルを解凍してよろしいですか?\n\nすでにあるファイルは上書きされます。';
$_lang["could_not_find_user"] = 'ユーザーが見つかりません';
$_lang["create_folder_here"] = 'コンテナの作成';
$_lang["create_resource_here"] = 'ここに新規作成';
$_lang["create_resource_title"] = 'リソースの作成';
$_lang["create_weblink_here"] = '新規作成 (ウェブリンク)';
$_lang["createdon"] = '作成日時';
$_lang["credits"] = '著作権表示/謝辞';
$_lang["credits_shouts_msg"] = '<p>MODx is managed and maintained at <a href="http://modxcms.com/about/" target="_blank">MODxCMS.com</a>.</p>';
$_lang["custom_contenttype_message"] = 'リソースが使用するコンテントタイプに独自のタイプを追加できます。新しいタイプを追加するにはテキストボックスに入力して「追加」ボタンをクリックします。';
$_lang["custom_contenttype_title"] = 'カスタムコンテントタイプ ';
$_lang["database_charset"] = 'データベース文字コード';
$_lang["database_collation"] = '文字セット照合順序';
$_lang["database_name"] = 'データベース名';
$_lang["database_overhead"] = '<strong style=\'color:#990033\'>注:</strong>オーバーヘッドは、更新処理のため作られる無駄な領域です。オーバーヘッドの数字をクリックすると、この領域を開放します';
$_lang["database_server"] = 'データベースサーバー';
$_lang["database_table_clickbackup"] = '選択したテーブルをバックアップ・ダウンロード';
$_lang["database_table_clickhere"] = 'ここをクリック';
$_lang["database_table_datasize"] = 'データサイズ';
$_lang["database_table_droptablestatements"] = 'DROP文を生成(※推奨)';
$_lang["database_table_effectivesize"] = '有効サイズ';
$_lang["database_table_indexsize"] = 'インデックス';
$_lang["database_table_overhead"] = 'オーバーヘッド';
$_lang["database_table_records"] = '件数';
$_lang["database_table_tablename"] = 'テーブル名';
$_lang["database_table_totals"] = '総計 ';
$_lang["database_table_totalsize"] = '合計サイズ';
$_lang["database_tables"] = 'テーブル一覧';
$_lang["database_version"] = 'データベースのバージョン ';
$_lang["date"] = '日付';
$_lang["datechanged"] = '編集日時';
$_lang["datepicker_offset"] = 'デートピッカーオフセット: ';
$_lang["datepicker_offset_message"] = 'デートピッカー(カレンダー)で参照・選択できる過去年数(※日付情報は手入力で書き換えることもできます)';
$_lang["datetime_format"] = '日時の書式';
$_lang["datetime_format_message"] = '管理画面内で使用する日時の書式を選択してください。';
$_lang["default"] = '既定値 '; 
$_lang["defaultcache_message"] = '新しく作成するリソースのキャッシュ制御をデフォルトで有効にする場合は「はい」を選択してください。';
$_lang["defaultcache_title"] = 'デフォルトでキャッシュを有効';
$_lang["defaultmenuindex_message"] = '「はい」を選択すると、リソースを新規に作成する時にメニューオーダーの値が自動的に増分します。';
$_lang["defaultmenuindex_title"] = 'メニューオーダー<br />自動増分';
$_lang["defaultpublish_message"] = '新しく作成するリソースをデフォルトで公開に設定する場合は「はい」を選択してください。';
$_lang["defaultpublish_title"] = '公開デフォルト';
$_lang["defaultsearch_message"] = '新しく作成するリソースをデフォルトで検索対象とする場合は「はい」を選択してください。';
$_lang["defaultsearch_title"] = '検索可能デフォルト';
$_lang["defaulttemplate_message"] = '新規に作成するリソースのデフォルトテンプレートを指定します。テンプレートはリソース単位で自由に選択できます。';
$_lang["defaulttemplate_title"] = 'デフォルトテンプレート';
$_lang["defaulttemplate_logic_title"] = 'Automatic Template Assignment';
$_lang["defaulttemplate_logic_general_message"] = 'New Resources will have the following templates, falling back to higher levels if not found:';
$_lang["defaulttemplate_logic_system_message"] = '<strong>System</strong>: the System Default Template.';
$_lang["defaulttemplate_logic_parent_message"] = '<strong>Parent</strong>: the same Template as the parent container.';
$_lang["defaulttemplate_logic_sibling_message"] = '<strong>Sibling</strong>: the same Template as other Resources in the same container.';

$_lang["delete"] = '削除';
$_lang["delete_resource"] = '削除する';
$_lang["delete_tags"] = 'タグの削除';
$_lang["deleting_file"] = '「 %s 」の削除: ';
$_lang["description"] = '説明';
$_lang["deselect_keywords"] = 'キーワードの選択解除';
$_lang["deselect_metatags"] = 'METAタグをクリア';
$_lang["disabled"] = '停止';
$_lang["doc_data_title"] = 'リソースの詳細情報';
$_lang["duplicate"] = '複製';
$_lang["duplicate_alias_found"] = 'リソース「%s」が「%s」というエイリアスをすでに使用しています。他のエイリアスを入力してください。';
$_lang["duplicate_alias_message"] = '「はい」を選択すると、同じエイリアス名を持つ複数のリソースを作ることができるようになります。この場合、エイリアス名をURL表現に用いると問題が発生する可能性があるため、ご注意ください。';
$_lang["duplicate_alias_title"] = '重複エイリアスを許可 ';
$_lang["duplicate_name_found_general"] = '%sにはすでに\'%s\'という名前が存在します。重複しない名前を指定してください。';
$_lang["duplicate_name_found_module"] = 'すでに\'%s\'という名前が存在します。重複しない名前を指定してください。';
$_lang["edit"] = '編集';
$_lang["edit_resource"] = '編集する';
$_lang["edit_resource_title"] = 'リソースの作成・編集';
$_lang["edit_settings"] = 'グローバル設定';
$_lang["editedon"] = '編集日時';
$_lang["editing_file"] = 'ファイルの編集: ';
$_lang["editor_css_path_message"] = 'RTE(リッチテキストエディター)で使用するCSSファイルのパスを入力します。例えば「/template/style.css」とします。もしRTEデフォルトの状態でよければ、このフィールドは空白にしておきます。';
$_lang["editor_css_path_title"] = 'CSSファイルへのパス ';
$_lang["element"] = '外部ファイル';
$_lang["element_categories"] = 'エレメント一覧';
$_lang["element_management"] = 'エレメント管理';
$_lang["element_name"] = 'エレメント名';
$_lang["element_selector_msg"] = '下のリストからエレメントを選択して「挿入」ボタンをクリックします。';
$_lang["element_selector_title"] = 'エレメントセレクタ';
$_lang["elements"] = 'エレメント';
$_lang["email"] = 'メールアドレス';
$_lang["email_sent"] = 'パスワード再発行メールを送信しました。';
$_lang["emailsender_message"] = 'このサイトからメールを送信する場合の「送信元メールアドレス」を指定してください。<br />コンフィグ変数：[(emailsender)]';
$_lang["emailsender_title"] = '送信者メールアドレス ';
$_lang["emailsubject_default"] = 'ログイン情報のお知らせ';
$_lang["emailsubject_message"] = 'サインアップメールの件名を指定してください。';
$_lang["emailsubject_title"] = 'メール件名 ';
$_lang["empty_folder"] = 'このコンテナは空です';
$_lang["empty_recycle_bin"] = '削除済みリソースを消去';
$_lang["empty_recycle_bin_empty"] = '消去するための削除済みリソースがありません。';
$_lang["enable_resource"] = '外部ファイルを有効に';
$_lang["enable_sharedparams"] = '共有パラメータを使用';
$_lang["enable_sharedparams_msg"] = '<strong>注意:</strong> 上のglobally unique id (GUID)はこのモジュールとその共有パラメータを一意に識別するために用いられます。GUIDは、モジュールと、共有パラメータにアクセスするプラグインやスニペットとの間のリンクにも用いられます。';
$_lang["enabled"] = '有効';
$_lang["error"] = 'エラー';
$_lang["error_sending_email"] = 'メール送信中にエラー';
$_lang["errorpage_message"] = 'リソースが存在しない場合のエラーページ(404 ページ)として表示する、リソースのIDを入力してください。<br /><strong>※非公開またはウェブユーザ限定のリソースは指定できません。</strong>';
$_lang["errorpage_title"] = 'エラーページ ';
$_lang["event_id"] = 'イベントID';
$_lang["eventlog"] = 'イベントログ';
$_lang["eventlog_msg"] = 'イベントログはMODxのシステムが出力する告知・警告・エラーの各メッセージを記録するものです。';
$_lang["eventlog_viewer"] = 'イベントログ';
$_lang["everybody"] = '全メンバー';
$_lang["existing_category"] = '既存のカテゴリー';
$_lang["expand_tree"] = 'サイトツリーを展開';
$_lang["export_site"] = 'サイトのエクスポート';
$_lang["export_site_cacheable"] = '非キャッシュファイルを含む ';
$_lang["export_site_exporting_document"] = 'エクスポートファイル <strong>%s</strong>個 (<strong>%s</strong>個中)<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = '失敗';
$_lang["export_site_failed_no_open"] = 'ファイルを開けません: ';
$_lang["export_site_failed_no_retrieve"] = 'リソースが見つかりません。';
$_lang["export_site_failed_no_write"] = 'ファイルを書き込めません。';
$_lang["export_site_html"] = 'サイト全体を静的HTMLとしてエクスポート';
$_lang["export_site_maxtime"] = '最大エクスポート時間 ';
$_lang["export_site_maxtime_message"] = 'エクスポート処理の制限時間を秒数で指定してください(<a href="http://www.google.com/search?q=php+set_time_limit&hl=ja&lr=lang_ja" target="_blank">PHPの設定</a>を上書きします)。0を入力すると無制限に設定できますが、通常は制限時間を設定するようおすすめします。';
$_lang["export_site_message"] = '<p>サイト全体をHTMLファイルとしてエクスポート(一括書き出し)できます。書き出したファイルをまとめてサーバ上に転送すれば、通常のサイトと同様の運用が可能です。</p><ul><li>エクスポートファイルは静的なhtmlファイルなので、動的なスニペットは動作しません。</li><li>リソースにリダイレクトヘッダを送信するスニペットが含まれている場合、エクスポートが失敗する場合があります。</li><li>exportディレクトリ内のファイルは処理の直前に全て消去されます。</li></ul><p><a href="index.php?a=17">グローバル設定</a>で「フレンドリーURLの使用」を「はい」にしてください。サイトの規模によっては、エクスポートにしばらく時間を要する場合もあります。</p><p><em>ファイル名が同じ場合、新しいファイルは既存のファイルに上書きされます</em></p>';
$_lang["export_site_numberdocs"] = '<p><strong>%s 個のエクスポート対象リソースが見つかりました。</strong><p/>';
$_lang["export_site_prefix"] = 'ファイル名の接頭辞 ';
$_lang["export_site_start"] = 'エクスポートの開始';
$_lang["export_site_success"] = '成功';
$_lang["export_site_success_skip_dir"] = 'このコンテナをスキップ';
$_lang["export_site_success_skip_doc"] = 'このリソースをスキップ';
$_lang["export_site_suffix"] = 'ファイル名の接尾辞 ';
$_lang["export_site_target_unwritable"] = 'ターゲットディレクトリ内に書き込みができません。ディレクトリが書き込み可能であるか確認して、再度処理を行ってください。';
$_lang["export_site_time"] = 'エクスポートが完了しました。エクスポートに要した時間は %s 秒です。';
$_lang["failed_login_message"] = 'ログイン失敗を許容する回数を設定します。ここで設定した回数を超えると一定時間ロックされログインできなくなります。';
$_lang["failed_login_title"] = 'ログイン失敗を許容する回数';
$_lang["fe_editor_lang_message"] = 'フロントエンドエディターで用いるリッチテキストエディターの言語を選んでください。';
$_lang["fe_editor_lang_title"] = 'フロントエンドエディターの言語 ';
$_lang["file_delete_file"] = 'ファイルの削除';
$_lang["file_delete_folder"] = 'ディレクトリの削除';
$_lang["file_deleted"] = '成功';
$_lang["file_download_file"] = 'ファイルのダウンロード';
$_lang["file_download_unzip"] = 'ファイルの解凍';
$_lang["file_folder_chmod_error"] = 'アクセス権を変更できません。MODx以外の方法でアクセス権を変更してください。';
$_lang["file_folder_created"] = 'ディレクトリを作成しました。';
$_lang["file_folder_deleted"] = 'ディレクトリを削除しました。';
$_lang["file_folder_not_created"] = 'ディレクトリを作成できません';
$_lang["file_folder_not_deleted"] = 'ディレクトリを削除できません。ディレクトリを削除する前に中身が空であることを確認してください。';
$_lang["file_not_deleted"] = '失敗';
$_lang["file_not_saved"] = 'ファイルを保存できません、ターゲットディレクトリが書き込み可能か確認してください。';
$_lang["file_saved"] = 'ファイルを保存しました。';
$_lang["file_unzip"] = '解凍しました。';
$_lang["file_unzip_fail"] = '解凍できません。';
$_lang["filemanager_path_message"] = '<a href="index.php?a=31">「ファイル管理」</a>で扱える範囲を決定します。コンテンツ編集に利用するファイルブラウザと違い、同じサーバ内で権限を持つ領域であればどのディレクトリでも管理できます。ドキュメントルート外の指定も可能です。';
$_lang["filemanager_path_title"] = 'ファイル管理機能の<br />管理対象ディレクトリ<br />[(filemanager_path)] ';
$_lang["files_access_denied"] = 'このアカウントは休止中です。';
$_lang["files_data"] = 'データ';
$_lang["files_dir_listing"] = 'ディレクトリ一覧 ';
$_lang["files_directories"] = 'ディレクトリ';
$_lang["files_dirwritable"] = 'ディレクトリ書き込み可？';
$_lang["files_editfile"] = 'ファイルの編集';
$_lang["files_file_type"] = 'ファイルタイプ: ';
$_lang["files_filename"] = 'ファイル名';
$_lang["files_fileoptions"] = 'オプション';
$_lang["files_files"] = 'ファイル管理';
$_lang["files_filesize"] = 'ファイルサイズ';
$_lang["files_filetype_notok"] = 'この種類のファイルはアップロードできません。';
$_lang["files_modified"] = '編集日時';
$_lang["files_top_level"] = 'トップレベルへ移動';
$_lang["files_up_level"] = '1レベル上へ移動';
$_lang["files_upload_copyfailed"] = 'アップロード失敗 - コピー先ディレクトリへのファイルコピーが失敗しました';
$_lang["files_upload_error"] = 'エラー';
$_lang["files_upload_error0"] = 'アップロードに問題が発生しました。';
$_lang["files_upload_error1"] = 'アップロードしようとしたファイルは大きすぎます。';
$_lang["files_upload_error2"] = 'アップロードしようとしたファイルは大きすぎます。';
$_lang["files_upload_error3"] = 'アップロードしようとしたファイルは一部分のみアップロードされました。';
$_lang["files_upload_error4"] = 'アップロードするファイルを選択してください';
$_lang["files_upload_error5"] = 'アップロード中に問題が発生しました。';
$_lang["files_upload_inhibited_msg"] = '<strong>アップロード機能が使用できません。</strong> - アップロードがサポートされているか、PHPがディレクトリに書込権を持っているかを確認してください。<br />';
$_lang["files_upload_ok"] = 'ファイルのアップロードが完了しました。';
$_lang["files_upload_permissions_error"] = 'パーミッションエラー - ファイルをアップロードするディレクトリを書き込み可能にしてください。';
$_lang["files_uploadfile"] = 'アップロードを実行';
$_lang["files_uploadfile_msg"] = 'アップロードするファイルを選択してください ';
$_lang["files_uploading"] = '<strong>%s</strong>を<strong>%s/</strong>にアップロードしました。<br />';
$_lang["files_viewfile"] = 'ファイルの表示';
$_lang["folder"] = 'ディレクトリ';
$_lang["forgot_password_email_fine_print"] = '注意：上記のURLは、24時間後またはパスワード変更をすると無効になります。';
$_lang["forgot_password_email_instructions"] = 'そのページの「パスワード変更」メニューからパスワードを変更することができます。';
$_lang["forgot_password_email_intro"] = 'アカウントへのパスワード変更リクエストを受け付けました。';
$_lang["forgot_password_email_link"] = '処理を完了するためここをクリックしてください。';
$_lang["forgot_your_password"] = 'パスワードを忘れた場合はこちら';
$_lang["friday"] = '金';
$_lang["friendly_alias_message"] = 'フレンドリーURLを使用して、かつリソースがエイリアスを持つ場合、エイリアスは常にフレンドリーURLに優先します。このオプションを「はい」に設定することで、フレンドリーURLの接頭辞と接尾辞もエイリアスに適用されます。例えば、リソースのIDが1、エイリアスが「introduction」、接頭辞が「」(空白)、接尾辞が「.html」の場合、このオプションを「はい」にすると、URLは「introduction.html」となります。 エイリアスを設定していない場合は、MODxが「1.html」というリンクを生成します。';
$_lang["friendly_alias_title"] = 'フレンドリエイリアス ';
$_lang["friendlyurls_message"] = '静的URI機能（フレンドリーURL）を有効にします。この機能はMODxがApache上で動作している時のみ有効です。この機能を動作させるためにはMODxインストールディレクトリのht.accessファイルを.htaccessにリネームしてください。動作しない場合は.htaccessを開いて、コメントアウトされている「Options +FollowSymlinks」の記述を有効にしてみてください。';
$_lang["friendlyurls_title"] = 'フレンドリーURLの使用 ';
$_lang["friendlyurlsprefix_message"] = 'フレンドリーURLの接頭辞を指定してください。例えば接頭辞を「page」に設定した場合、URLの /index.php?id=2 は、 /page2.htmlというフレンドリーURLに変換されます(接尾辞が .htmlに設定されていると仮定)。';
$_lang["friendlyurlsprefix_title"] = 'フレンドリーURLの接頭辞 ';
$_lang["friendlyurlsuffix_message"] = 'フレンドリーURLの接尾辞を指定してください。例えば「.html」と指定すると、全てのフレンドリーURLの末尾に .htmlを追加します。';
$_lang["friendlyurlsuffix_title"] = 'フレンドリーURLの接尾辞 ';
$_lang["functionnotimpl"] = 'まだ実装されていない機能';
$_lang["functionnotimpl_message"] = 'この機能は、まだ実装されていません';
$_lang["go"] = '実行';
$_lang["group_access_permissions"] = 'ユーザーグループのアクセス';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'ヘルプ';
$_lang["help_msg"] = '<p><a href="http://modxcms-jp.com/bb/" target="_blank">MODx日本公式フォーラム</a>でサポートを得ることができます。 また、逐次執筆が進められている<a href="http://modxcms.com/documentation" target="_blank">MODxドキュメントとガイド（英語）</a>があり、MODx のほぼすべてに関して記されています。</p>';
$_lang["help_title"] = 'サポート';
$_lang["hide_tree"] = 'サイトツリーを非表示';
$_lang["home"] = 'ダッシュボード';
$_lang["htmlsnippet_desc"] = 'チャンクの説明';
$_lang["htmlsnippet_management_msg"] = '<h3 style="font-weight:bold;">チャンクの管理</h3><p>編集したいチャンクを選択してください。チャンクは、パーツ感覚で利用できる「生の」HTMLコードです。 <strong>{{チャンク名}}</strong> と記述するだけで、リソースやテンプレートから手軽に呼び出すことができます。単純な仕組みですが、使い慣れればデザイナーには手放せないものになるでしょう。詳しくは<a href="index.php?a=9">ヘルプ</a>を参照してください。</p>';
$_lang["htmlsnippet_msg"] = '<p>チャンク名には日本語を用いることができます(※スニペット内からは日本語チャンク名では呼び出せないことがあります)。チャンクの使い方については<a href="index.php?a=9">ヘルプ</a>の「Tutorial」を参照してください。</p>';
$_lang["htmlsnippet_name"] = 'チャンク名';
$_lang["htmlsnippet_title"] = 'チャンクの作成/編集';
$_lang["icon"] = 'Icon';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = '親の指定:\n\nリソースは選択リソースのサブリソースです。';
$_lang["illegal_parent_self"] = '親の指定:\n\n自分自身を親に割り当てることはできません。';
$_lang["import_files_found"] = '<b>インポート対象のリソースが %s個あります。</b>';
$_lang["import_params"] = '共有パラメータのインポート';
$_lang["import_params_msg"] = 'ドロップダウンメニューからモジュール名を選択することにより、他のモジュールのパラメータや設定をインポートすることができます。<br /><strong>注意:</strong>メニューにモジュールが表示されるためには、このプラグインやスニペットが該当モジュールの関連付けリストにありモジュールの共有パラメータ使用がONである必要があります。 ';
$_lang["import_parent_resource"] = '親リソース ';
$_lang["import_site"] = 'サイトのインポート';
$_lang["import_site_failed"] = '失敗しました';
$_lang["import_site_failed_db_error"] = 'リソースの複製中にデータベースエラーが発生しました: ';
$_lang["import_site_failed_no_open_dir"] = 'ディレクトリを開けませんでした: ';
$_lang["import_site_failed_no_retrieve_file"] = 'ファイルが見つかりませんでした: ';
$_lang["import_site_html"] = 'HTMLからサイトをインポート';
$_lang["import_site_importing_document"] = 'インポート中のファイル <strong>%s</strong> ';
$_lang["import_site_maxtime"] = 'インポート時間の上限 ';
$_lang["import_site_maxtime_message"] = 'MODxがサイトのインポート処理に使用できる最大秒数を指定します。（<a href="http://www.google.com/search?q=php+set_time_limit&hl=ja&lr=lang_ja" target="_blank">PHPの指定処理秒数</a>を上書きします）「0」を指定すると処理時間を制限しませんが、想定外の負荷が発生する恐れがあるため注意してください。';
$_lang["import_site_message"] = 'HTMLで記述されたサイトを丸ごとデータベースにインポートします。htmlファイルをディレクトリごと /assets/import/ ディレクトリにコピーし、「インポート開始」ボタンをクリックすればスタートします。ファイル名はエイリアスになり、&lt;title&gt;要素はリソース名 [*pagetitle*] になります。</p><p>&lt;body&gt;要素の内側がそのまま取り込まれます。&lt;head&gt;要素は&lt;title&gt;要素のみ取り込みます。<br />左側のサイトツリー上の任意のリソースをクリックすると<b>「親リソース」</b>(インポート先)を変更できます。';
$_lang["import_site_skip"] = '処理をスキップしました';
$_lang["import_site_start"] = 'インポート開始';
$_lang["import_site_success"] = '成功';
$_lang["import_site_time"] = 'インポート終了。インポートには %s 秒かかりました。';
$_lang["inbox"] = '受信トレイ';
$_lang["info"] = '情報';
$_lang["information"] = '情報';
$_lang["inline"] = 'ブラウザ内に通常表示';
$_lang["insert"] = '挿入';
$_lang["keyword"] = 'キーワード';
$_lang["keywords"] = 'キーワード';
$_lang["keywords_intro"] = 'キーワードを編集するには変更したいキーワードの隣のテキストエリアに新しいキーワードを入力するだけです。キーワードを削除するにはキーワードの削除チェックボックスをチェックします。';
$_lang["language_message"] = '管理画面の使用言語を選択してください。必ず「エンコード」の設定と合わせてください。';
$_lang["language_title"] = '言語 ';
$_lang["launch_site"] = 'サイトを表示';
$_lang["link_attributes"] = 'リンク属性';
$_lang["link_attributes_help"] = "このページ内の任意のリンクの属性を管理します。\n\n例：target=&quot;_blank&quot; ・rel=&quot;lightbox&quot;\nリソース変数：[*link_attributes*]\n\n※この変数はリンクの属性を管理するための特別な機能を持っていないので、他の用途に流用することもできます。";
$_lang["list_mode"] = 'リストモードのON/OFF - グリッドに全てのレコードをリストするために使われます。';
$_lang["loading_doc_tree"] = 'サイトツリーのローディング中';
$_lang["loading_menu"] = 'メニューのローディング中';
$_lang["loading_page"] = 'MODxはページをロードしています。お待ちください';
$_lang["localtime"] = 'ローカル時刻';
$_lang["lock_htmlsnippet"] = 'チャンクの編集をロック';
$_lang["lock_htmlsnippet_msg"] = 'Administrator(ロールID 1)のみ編集できます。';
$_lang["lock_module"] = 'モジュールをロック';
$_lang["lock_module_msg"] = 'Administrator(ロールID 1)のみ編集できます。';
$_lang["lock_msg"] = '%s さんが %s を編集中です。作業が終わるまで待つか、ロックを解除してください。';
$_lang["lock_plugin"] = 'プラグインをロック';
$_lang["lock_plugin_msg"] = 'Administrator(ロールID 1)のみ編集できます。';
$_lang["lock_settings_msg"] = '%s が設定を編集中です。他のユーザーが終了するまでしばらくお待ちください。';
$_lang["lock_snippet"] = 'スニペットをロック';
$_lang["lock_snippet_msg"] = 'Administrator(ロールID 1)のみ編集できます。';
$_lang["lock_template"] = 'テンプレートの編集をロック';
$_lang["lock_template_msg"] = 'Administrator(ロールID 1)のみ編集できます。';
$_lang["lock_tmplvars"] = '変数をロック';
$_lang["lock_tmplvars_msg"] = 'Administrator(ロールID 1)のみ編集できます。';
$_lang["locked"] = 'ロック中';
$_lang["login_allowed_days"] = '曜日制限';
$_lang["login_allowed_days_message"] = 'このユーザーがログインできる曜日を選択してください';
$_lang["login_allowed_ip"] = 'IPアドレス制限';
$_lang["login_allowed_ip_message"] = 'このユーザーがログインできるIPアドレスを入力してください。<br /><strong>注意: 複数のIPアドレスの場合はカンマ(,)で区切ってください</strong>';
$_lang["login_button"] = 'ログイン';
$_lang["login_cancelled_install_in_progress"] = 'このサイトは、現在アップデートまたはインストール作業中です。<br />申し訳ありませんが、しばらく経ってからもう一度ログインしてください。<br />※アップデートの失敗が原因の場合は5分後にロックが解除されます。';
$_lang["login_cancelled_site_was_updated"] = 'このサイトは、アップデートまたはインストールが実行されしまた。申し訳ありませんが、もう一度ログインし直してください。<br />';
$_lang["login_captcha_message"] = '画像で表示されるセキュリティコードを入力してください。セキュリティコードが読めない場合は画像をクリックすると画像は再生成されます。もしくはサイト管理者に連絡をお願います。';
$_lang["login_homepage"] = 'ログインするホームページ';
$_lang["login_homepage_message"] = 'ログインしたウェブユーザーに対して表示するリソースのIDを入力してください。<br /><strong>※非公開のリソースは指定できません。また該当ユーザーがアクセス権限をもつリソースに限ります。</strong>';
$_lang["login_message"] = 'MODxへようこそ。ログイン名とパスワードは大文字・小文字を区別します。';
$_lang["logo_slogan"] = 'MODx Content Manager - \nCreate and do more with less';
$_lang["logout"] = 'ログアウト';
$_lang["long_title"] = 'タイトル';
$_lang["mail_check_timeperiod_message"] = '<a href="index.php?a=10">メッセージ機能</a>のメッセージチェックの間隔を「秒」で指定します';
$_lang["mail_check_timeperiod_title"] = 'メッセージチェックの間隔 ';
$_lang["manage_depends"] = '関連付けの管理';
$_lang["manage_files"] = 'ファイル管理';
$_lang["manage_htmlsnippets"] = 'チャンク';
$_lang["manage_metatags"] = 'METAタグとキーワードの管理';
$_lang["manage_modules"] = 'モジュールの管理';
$_lang["manage_plugins"] = 'プラグイン';
$_lang["manage_snippets"] = 'スニペット';
$_lang["manage_templates"] = 'テンプレート';
$_lang["manager"] = '管理画面';
$_lang["manager_lockout_message"] = '管理画面にログインしています。セッションを閉じたいときは「ログアウト」ボタンをクリックしてください。<p />管理画面のホームあるいはスタート画面に行きたいときは「ホーム」ボタンをクリックします。';
$_lang["manager_permissions"] = 'グループ管理';
$_lang["manager_theme"] = '管理画面のテーマ ';
$_lang["manager_theme_message"] = '管理画面で使用するデザインテーマを選択してください。この選択肢を増やすには<a href="http://modxcms.com/extras/repository/packages/?repository=7" target="_blank">MODx開発元の配布ページ</a>から入手して /manager/media/style/ ディレクトリに置く必要があります。';
$_lang["messages"] = 'メッセージ';
$_lang["messages_all"] = '全員';
$_lang["messages_compose"] = 'メッセージの作成';
$_lang["messages_forward"] = '転送';
$_lang["messages_from"] = 'From';
$_lang["messages_group"] = 'グループ';
$_lang["messages_inbox"] = '受信トレイ';
$_lang["messages_message"] = 'メッセージ';
$_lang["messages_no_messages"] = '未読のメッセージはありません。';
$_lang["messages_not_allowed_to_read"] = 'このメッセージを読むことはできません。';
$_lang["messages_private"] = 'プライベート';
$_lang["messages_read_message"] = 'メッセージを読む';
$_lang["messages_reply"] = '返信';
$_lang["messages_select_group"] = 'グループを選択';
$_lang["messages_select_user"] = 'ユーザーを選択';
$_lang["messages_send"] = '送信';
$_lang["messages_send_to"] = '送信先';
$_lang["messages_sent"] = '送信日時';
$_lang["messages_subject"] = '件名';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'メッセージ';
$_lang["messages_user"] = 'ユーザー';
$_lang["meta_keywords"] = 'METAタグ';
$_lang["metatag_intro"] = 'METAタグの作成や削除、編集を行います。リソースとMETAタグをリンクするにはリソースの編集中にMETA キーワードタブをクリックします。そして目的とするMETAタグとキーワードを選択します。新しいタグを追加するには、その名前と値を入力して「タグ追加」ボタンをクリックします。タグを編集するにはデータグリッド中のタグ名をクリックします。';
$_lang["metatag_notice"] = 'METAタグに関しての詳細は<a href="http://www.google.com/search?q=%22META%E3%82%BF%E3%82%B0%22" target="_blank">こちら</a>を参照してください。';
$_lang["metatags"] = 'METAタグ';
$_lang["mgr_access_permissions"] = 'グループ管理(管理操作グループ)';
$_lang["mgr_login_start"] = '管理画面ログイン開始ページ';
$_lang["mgr_login_start_message"] = 'ユーザーが管理画面にログインしたとき、リダイレクトしたいリソースのIDを入力します。<br /><strong>※非公開のリソースは指定できません。また該当ユーザーがアクセス権限をもつリソースに限ります。</strong>';
$_lang["mgrlog_action"] = 'アクション';
$_lang["mgrlog_actionid"] = 'アクションID';
$_lang["mgrlog_anyall"] = '全て';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() で誤りを検出しました。';
$_lang["mgrlog_datefr"] = 'この日付から';
$_lang["mgrlog_dateinvalid"] = '日付の形式が正しくありません。';
$_lang["mgrlog_dateto"] = 'この日付の前';
$_lang["mgrlog_emptysrch"] = 'この問合せの結果は空でした。（マッチするログエントリーが無かったということです）';
$_lang["mgrlog_field"] = '分類';
$_lang["mgrlog_itemid"] = '操作対象';
$_lang["mgrlog_itemname"] = '対象名';
$_lang["mgrlog_msg"] = 'アクション(文字列)';
$_lang["mgrlog_noquery"] = '検索されていません。';
$_lang["mgrlog_qresults"] = '結果';
$_lang["mgrlog_query"] = 'ログの検索';
$_lang["mgrlog_query_msg"] = '管理画面の操作履歴に対する検索条件を指定します。日付の条件指定は、「以上」「未満」です。';
$_lang["mgrlog_results"] = 'ページあたりの表示件数';
$_lang["mgrlog_searchlogs"] = '検索の履歴';
$_lang["mgrlog_sortinst"] = '各列のヘッダをクリックすると表示順を変更できます。ログが溜まってきたときには、<a href="index.php?a=55">empty</a> をクリックすることでログを全部消去できます。 この操作は即実行され元に戻せません。';
$_lang["mgrlog_time"] = '時刻';
$_lang["mgrlog_user"] = 'ユーザー';
$_lang["mgrlog_username"] = 'ユーザー名';
$_lang["mgrlog_value"] = '値';
$_lang["mgrlog_view"] = '管理操作ログを見る';
$_lang["module_code"] = 'モジュール コード(php)';
$_lang["module_config"] = 'モジュール設定';
$_lang["module_desc"] = '説明';
$_lang["module_disabled"] = 'モジュールを停止';
$_lang["module_edit_click_title"] = 'このモジュールを編集';
$_lang["module_group_access_msg"] = '管理画面内でこのモジュールを実行できるユーザーグループを選択してください。';
$_lang["module_management"] = 'モジュール管理';
$_lang["module_management_msg"] = 'アイコンをクリックして操作を選択してください。モジュールは管理画面を拡張する形で機能を追加できます。追加する機能自体はプラグインやスニペットで作り、これをモジュール側のフォームでコントロールする実装を推奨します。';
$_lang["module_msg"] = 'モジュール名には日本語を用いることができます。先頭と末尾の「&lt;?php」「?&gt;」は不要です。モジュールの作り方については<a href="index.php?a=9">ヘルプ</a>の「Tutorial」を参照してください。';
$_lang["module_name"] = 'モジュール名';
$_lang["module_resource_msg"] = 'このモジュールに関連付けるエレメントを追加・削除します。新しいエレメントを追加するには下のボタンのひとつをクリックします。';
$_lang["module_resource_title"] = 'モジュール関連付け';
$_lang["module_title"] = 'モジュールの作成/編集';
$_lang["module_viewdepend_msg"] = 'このモジュールが管理するエレメントの状況を見ることができます。関連付けを変更するには「関連付けの管理」ボタンをクリックします';
$_lang["modules"] = 'モジュール';
$_lang["modx_news"] ='MODxの最新情報';
$_lang["modx_news_tab"] ='MODxの最新情報';
$_lang["modx_news_title"] ='MODxの最新情報';
$_lang["modx_security_notices"] ='MODx セキュリティ情報';
$_lang["modx_version"] = 'MODxバージョン';
$_lang["monday"] = '月';
$_lang["move"] = '移動';
$_lang["move_resource"] = '移動する';
$_lang["move_resource_message"] = 'サイトツリー内の新しい親リソースを選択して、リソースをサブリソースごと移動できます。コンテナではないリソースを親リソースとして選択した場合、リソースはコンテナに変更されます。 サイトツリー内の新しい親リソースをクリックしてください。';
$_lang["move_resource_new_parent"] = '新しい親リソースをサイトツリーから選択してください';
$_lang["move_resource_title"] = 'リソースの移動';
$_lang["name"] = 'ログイン名';
$_lang["new_category"] = 'カテゴリー作成';
$_lang["new_file_permissions_message"] = '管理画面を通じて新しいファイルをアップロードしたとき、ここで設定したパーミッションに変更します。この機能はIIS上など一部の環境では動作しません。';
$_lang["new_file_permissions_title"] = '新規ファイルのパーミッション';
$_lang["new_folder_permissions_message"] = '管理画面を通じて新しいディレクトリを作成したとき、ここで設定したパーミッションに変更します。この機能はIIS上など一部の環境では動作しません。';
$_lang["new_folder_permissions_title"] = '新規ディレクトリのパーミッション';
$_lang["new_htmlsnippet"] = 'チャンクを作成';
$_lang["new_keyword"] = 'キーワードの追加 ';
$_lang["new_module"] = 'モジュールを作成';
$_lang["new_parent"] = '新しい親リソース';
$_lang["new_plugin"] = 'プラグインを作成';
$_lang["new_role"] = 'ロールを作成';
$_lang["new_snippet"] = 'スニペットを作成';
$_lang["new_template"] = 'テンプレートを作成';
$_lang["new_tmplvars"] = 'テンプレート変数を作成';
$_lang["new_user"] = 'ユーザーを作成';
$_lang["new_web_user"] = 'ウェブユーザーを作成';
$_lang["no"] = 'いいえ';
$_lang["no_active_users_found"] = '管理画面にログインしているメンバーはいません。';
$_lang["no_activity_message"] = 'まだリソースを作成または編集していません。';
$_lang["no_category"] = 'カテゴリーなし';
$_lang["no_docs_pending_publishing"] = '公開を予定しているリソースはありません。';
$_lang["no_docs_pending_pubunpub"] = 'イベントはありません';
$_lang["no_docs_pending_unpublishing"] = '公開取り消しを予定しているリソースはありません。';
$_lang["no_edits_creates"] = '最近作成または編集したリソースはありません。';
$_lang["no_groups_found"] = 'グループが見つかりません。';
$_lang["no_keywords_found"] = 'キーワードはありません';
$_lang["no_records_found"] = 'レコードはありません。';
$_lang["no_results"] = '何もありません';
$_lang["nologentries_message"] = '<a href="index.php?a=13">管理操作ログ</a>閲覧時、1ページあたりに表示されるログエントリー数を入力してください。';
$_lang["nologentries_title"] = 'ログエントリー数 ';
$_lang["nomessages_message"] = 'メッセージ閲覧時、受信ボックスに表示されるメッセージ数を入力してください。';
$_lang["nomessages_title"] = 'メッセージ数 ';
$_lang["none"] = 'なし';
$_lang["noresults_message"] = '管理画面内の各機能の検索結果の一覧で、ページあたり何件表示するかを指定してください。';
$_lang["noresults_title"] = '結果の件数 ';
$_lang["not_deleted"] = 'は削除されていません';
$_lang["not_set"] = '設定なし';
$_lang["offline"] = 'メンテナンスモード';
$_lang["online"] = 'オンライン';
$_lang["onlineusers_action"] = 'アクション';
$_lang["onlineusers_actionid"] = 'ID';
$_lang["onlineusers_ipaddress"] = 'IPアドレス';
$_lang["onlineusers_lasthit"] = '最終アクセス';
$_lang["onlineusers_message"] = '現在(直近20分以内)管理画面にログインしているユーザーの一覧です。(現在時刻 ';
$_lang["onlineusers_title"] = 'オンラインユーザー';
$_lang["onlineusers_user"] = 'ユーザー';
$_lang["onlineusers_userid"] = 'ユーザーID';
$_lang["optimize_table"] = 'このテーブルを最適化するにはここをクリック';
$_lang["page_data_cacheable"] = 'キャッシュ制御を行なう';
$_lang["page_data_cacheable_help"] = 'このページ全体をキャッシュ制御の対象とします。ただしリソース中のスニペットコールの記述が[!xxxxx!]形式になっている場合は、その部分はキャッシュを通さず常に動的に処理・出力します。';
$_lang["page_data_cached"] = '<strong>ソース(ページキャッシュの中身です)</strong>';
$_lang["page_data_changes"] = '編集履歴';
$_lang["page_data_contentType"] = 'コンテントタイプ';
$_lang["page_data_contentType_help"] = 'このリソースのコンテントタイプを選択してください。コンテントタイプが分からない場合は、通常のWebページを意味するtext/htmlのままにしてください。';
$_lang["page_data_created"] = '作成日時';
$_lang["page_data_edited"] = '編集日時';
$_lang["page_data_editor"] = 'リッチテキストエディターを使用';
$_lang["page_data_folder"] = 'コンテナ';
$_lang["page_data_general"] = '概要';
$_lang["page_data_markup"] = 'マークアップ/構造';
$_lang["page_data_mgr_access"] = '管理画面からアクセス';
$_lang["page_data_notcached"] = 'このリソースは、まだキャッシュされていません。';
$_lang["page_data_publishdate"] = '公開開始日時';
$_lang["page_data_publishdate_help"] = '公開日時を設定した場合、リソースは公開日時の到来と共に公開されます。この設定は「公開ステータス」よりも優先されます。';
$_lang["page_data_published"] = '公開';
$_lang["page_data_searchable"] = '検索対象に含める';
$_lang["page_data_searchable_help"] = 'このフィールドをチェックすることにより、リソースを検索対象にします。このフィールドをスニペット内で別の目的に使用することもできます。';
$_lang["page_data_source"] = 'ソース';
$_lang["page_data_status"] = 'ステータス';
$_lang["page_data_template"] = '使用テンプレート';
$_lang["page_data_template_help"] = 'このリソースが使用するテンプレートを選択してください。';
$_lang["page_data_title"] = 'ページデータ';
$_lang["page_data_unpublishdate"] = '公開終了日時';
$_lang["page_data_unpublishdate_help"] = '公開終了日時を設定すると、公開終了日時を迎えた時点でリソースが非公開状態に戻ります。この設定は「公開ステータス」よりも優先されます。';
$_lang["page_data_unpublished"] = '非公開';
$_lang["page_data_web_access"] = 'ウェブからアクセス';
$_lang["pagetitle"] = 'リソースタイトル';
$_lang["pagination_table_first"] = '先頭';
$_lang["pagination_table_gotopage"] = 'ページへ';
$_lang["pagination_table_last"] = '最後';
$_lang["paging_first"] = '先頭';
$_lang["paging_last"] = '最後';
$_lang["paging_next"] = '次へ';
$_lang["paging_prev"] = '前へ';
$_lang["paging_showing"] = '表示対象：';
$_lang["paging_to"] = 'から';
$_lang["paging_total"] = '(トータル)';
$_lang["parameter"] = 'パラメータ';
$_lang["password"] = 'パスワード';
$_lang["password_change_request"] = 'パスワード変更リクエスト';
$_lang["password_gen_gen"] = 'パスワードを自動生成する(おすすめ)';
$_lang["password_gen_length"] = 'パスワードは6文字以上の長さにしてください。';
$_lang["password_gen_method"] = 'どのようにパスワードを作成しますか?';
$_lang["password_gen_specify"] = 'パスワードを指定する ';
$_lang["password_method"] = 'どのようにパスワードを通知しますか?';
$_lang["password_method_email"] = '対象ユーザにメールで通知する';
$_lang["password_method_screen"] = '生成したパスワードを次の画面で表示する';
$_lang["password_msg"] = '<strong>%s</strong>のパスワードは<strong>%s</strong>です。';
$_lang["php_version_check"] = 'MODxはPHPバージョン4.0.3またはそれ以上で動作します。インストールされているPHPをアップグレードしてください。';
$_lang["plugin"] = 'プラグイン';
$_lang["plugin_code"] = 'プラグイン コード (php)';
$_lang["plugin_config"] = 'プラグイン設定';
$_lang["plugin_desc"] = '説明';
$_lang["plugin_disabled"] = 'プラグインを停止';
$_lang["plugin_event_msg"] = 'このプラグインが使用するイベントを選択してください。';
$_lang["plugin_management_msg"] = '<h3 style="font-weight:bold;">プラグインの管理</h3><p>プラグインはシステム寄りの拡張機能で、実行するためには任意のシステムイベントに関連付ける必要があります。スニペットほど直感的ではありませんが、管理画面のカスタマイズもできるなど応用幅が広いです。詳しくは<a href="index.php?a=9">ヘルプ</a>をご覧ください。</p>';
$_lang["plugin_msg"] = 'プラグイン名には日本語を用いることができます。先頭と末尾の「&lt;?php」「?&gt;」は不要です。プラグインを実行するためには、必ず任意のシステムイベントと関連付けてください。プラグインの作り方については<a href="index.php?a=9">ヘルプ</a>の「Tutorial」を参照してください。';
$_lang["plugin_name"] = 'プラグイン名';
$_lang["plugin_priority"] = 'イベント発生時のプラグインの実行順を編集';
$_lang["plugin_priority_instructions"] = 'プラグインの実行順を変更するには、各イベント名の下にあるプラグインをドラッグしてください。最初に実行するプラグインは最上位にしてください。';
$_lang["plugin_priority_title"] = 'プラグインの実行順';
$_lang["plugin_title"] = 'プラグインの作成/編集';
$_lang["preview"] = 'プレビュー';
$_lang["preview_msg"] = 'ここには最後に保存した内容をプレビューしています。<a href="#" onclick="saveRefreshPreview();"><img src="media/images/icons/save.gif" align="absmiddle" height="12"> 保存と再描画</a>を行うにはここをクリックしてください。';
$_lang["preview_resource"] = 'プレビュー(別窓)';
$_lang["private"] = 'グループ設定';
$_lang["public"] = 'グループ制限なし';
$_lang["publish_date"] = '公開日付';
$_lang["publish_events"] = '公開を予定しているリソースの一覧';
$_lang["publish_resource"] = '公開する';
$_lang["rb_base_dir_message"] = 'ファイルブラウザディレクトリの物理パスです。デフォルトではassetsディレクトリが指定され、snippets・pluginsディレクトリなどが同じ階層に共存しています。この設定を変更すると、images・files・flash・mediaの4つのディレクトリの参照先が変わります。';
$_lang["rb_base_dir_title"] = 'ファイルブラウザディレクトリの<br />物理パス ';
$_lang["rb_base_url_message"] = 'ファイルブラウザディレクトリ(通常はassetsディレクトリ)のパスです。「ファイルブラウザディレクトリの物理パス」が参照する場所と同じですが、ここではMODx設置ディレクトリを基準とした相対パスを記述します。';
$_lang["rb_base_url_title"] = 'ファイルブラウザディレクトリの<br />相対パス';
$_lang["rb_message"] = '「はい」を選択するとファイルブラウザを使用できます。ファイルブラウザは投稿画面から呼び出します。サーバー上に画像などをアップロードし、投稿画面に貼り付けることができます。この設定はimages・files・flash・mediaの4つのディレクトリを参照します。参照範囲が広い<a href="index.php?a=31">「ファイル管理」</a>と違い、ファイルブラウザは投稿画面との連動を前提としており、主にコンテンツに紐付くファイルのみを扱います。';
$_lang["rb_title"] = 'ファイルブラウザを使用 ';
$_lang["rb_webuser_message"] = '<a href="index.php?a=99">ウェブユーザー</a>にファイルブラウザの利用を許可するかどうかを選択します。';
$_lang["rb_webuser_title"] = 'ウェブユーザーの<br />ファイルブラウザ利用';
$_lang["recent_docs"] = '最近のリソース';
$_lang["recommend_setting_change_title"] = '設定を確認してください。';
$_lang["recommend_setting_change_description"] = 'リファラチェック設定が無効になっているため、意図しない管理画面操作による<a href="http://www.google.com/search?hl=ja&q=csrf" target="_blank">CSRF攻撃 (Cross Site Request Forgery attack)</a>を受ける恐れがあります。グローバル設定をご確認ください。ただしこの設定により管理画面にアクセスできなくなる可能性があります。その場合はパソコン側のセキュリティソフトの設定をチェックするか、他のパソコンからのアクセスを試してみてください。';
$_lang["refresh_cache"] = 'キャッシュ: キャシュディレクトリに <strong>%s</strong>個のキャッシュファイルが見つかりました。<strong>%d</strong>個のキャッシュファイルが削除されました。<p>ページがリクエストされた時点で、新しいキャッシュファイルが生成されます。';
$_lang["refresh_published"] = '<strong>%s</strong>件のリソースが公開されました。';
$_lang["refresh_site"] = 'サイトをリフレッシュ';
$_lang["refresh_title"] = 'サイトをリフレッシュ';
$_lang["refresh_tree"] = 'サイトツリーの再描画';
$_lang["refresh_unpublished"] = '<strong>%s</strong>件のリソースが非公開に戻りました。';
$_lang["release_date"] = 'リリース日';
$_lang["remember_last_tab"] = 'アクティブなタブを記憶する';
$_lang["remember_last_tab_message"] = 'タブ構成のページ(投稿画面・エレメント編集画面・グローバル設定など)において、最後に開いたタブを記憶します。「Stay mode」を選択すると「保存後に続けて編集」を実行した時と一部の管理画面でタブ選択を記憶します。';
$_lang["remember_username"] = 'ログイン状態を保持する';
$_lang["remove"] = '削除';
$_lang["remove_date"] = '日付を削除';
$_lang["remove_locks"] = 'ロックを解除';
$_lang["rename"] = 'リネーム';
$_lang["reports"] = 'レポート';
$_lang["require_tagname"] = 'タグ名が必要です。';
$_lang["require_tagvalue"] = 'タグの値が必要です';
$_lang["reserved_name_warning"] = 'You have used a reserved name.';
$_lang["reset"] = 'リセット';
$_lang["reset_failedlogins"] = 'リセット';
$_lang["resource"] = 'リソース';
$_lang["resource_alias"] = 'エイリアス';
$_lang["resource_alias_help"] = "このリソースのエイリアスを指定することができます。フレンドリーURL機能が有効な場合、次のようにリソースにアクセスできます:\n\nhttp://yourserver/エイリアス\n\nリソース変数：[*alias*]";
$_lang["resource_content"] = '本文[*content*]';
$_lang["resource_description"] = '説明(description)';
$_lang["resource_description_help"] = 'リソースに関する任意の説明をここに入力することができます。リソース変数：[*description*]';
$_lang["resource_duplicate"] = '複製を作る';
$_lang["resource_long_title_help"] = 'ページのタイトルです。titleタグなどで利用します。リソース変数：[*longtitle*]';
$_lang["resource_metatag_help"] = 'このリソースに付加したいMETAタグやキーワードを選択してください。CTRLキーを押しながらクリックすると複数のタグやキーワードを選択できます。選択元とするMETAタグ・キーワードの作成・管理は「エレメント」→<a href="index.php?a=81" target="_self">「METAタグとキーワードの管理」</a>で行ないます。';
$_lang["resource_opt_contentdispo"] = 'リソースの出力';
$_lang["resource_opt_contentdispo_help"] = 'ウェブブラウザがこのリソースをどう扱うかを指定できます。「ファイルとしてダウンロード」を選択するとリソースをダウンロードファイルとみなします。';
$_lang["resource_opt_emptycache"] = '更新時にキャッシュを<br />削除(記憶されません)';
$_lang["resource_opt_emptycache_help"] = 'このオプションのチェックを外すと、キャッシュを削除しません。設定の戻し忘れなどの事故を防ぐために、この設定は記憶されませんので、ご注意ください。';
$_lang["resource_opt_folder"] = 'コンテナとして扱う';
$_lang["resource_opt_folder_help"] = 'このリソースをコンテナとして明示的に扱いたい場合にチェックしてください。通常はサブリソースの有無により自動的に判定されます';
$_lang["resource_opt_menu_index"] = 'メニューオーダー';
$_lang["resource_opt_menu_index_help"] = 'メニューオーダーは、メニュースニペット内でリソースの配置順を指定するために用います。もちろん、スニペット次第で他の目的に使用することもできます。';
$_lang["resource_opt_menu_title"] = 'メニュータイトル';
$_lang["resource_opt_menu_title_help"] = 'メニュータイトルは、スニペットやモジュールで使用できる短いタイトルです。リソース変数：[*menutitle*]';
$_lang["resource_opt_published"] = '公開ステータス';
$_lang["resource_opt_published_help"] = 'このページを公開する場合はチェックしてください。<br />※「公開開始日時」「公開終了日時」の値と連動するためご注意ください。公開開始日時に達していない・公開終了日時を過ぎているなどの理由で、ここにチェックが入っていないと公開されません。';
$_lang["resource_opt_richtext"] = 'リッチテキストで編集';
$_lang["resource_opt_richtext_help"] = '通常の記事を書く場合はここにチェックを入れたままとし、リッチテキストエディターでリソースを編集することをおすすめします。リソースがJavaScriptやフォームを含む場合は、チェックを外してプレーンテキストによる編集を行ってください。';
$_lang["resource_opt_show_menu"] = 'メニューに表示';
$_lang["resource_opt_show_menu_help"] = 'メニューにこのリソースを表示するにはこのオプションをチェックしてください。メニュー作成スニペットにはこのオプションを無視するものもありますのでご注意ください。';
$_lang["resource_opt_trackvisit_help"] = 'このページへの訪問者をログに記録する(対応モジュールが必要)';
$_lang["resource_overview"] = '詳細情報を表示';
$_lang["resource_parent"] = '親リソース';
$_lang["resource_parent_help"] = '上のコンテナアイコンをクリックすると、このリソースの親(コンテナ)を選択できる状態になります。アイコンが変化している状態で、親にしたいリソースをサイトツリー上でクリックしてください。もう一度クリックするともとに戻ります。';
$_lang["resource_permissions_error"] = 'このリソースを、少なくともアクセス可能な一つ以上のリソースグループへ割り当ててください。';
$_lang["resource_setting"] = 'リソース設定';
$_lang["resource_summary"] = '要約(序説)';
$_lang["resource_summary_help"] = 'リソースの要約を入力します。リソース変数：[*introtext*]';
$_lang["resource_title"] = 'リソース名';
$_lang["resource_title_help"] = 'リソースの名称/タイトルを入力してください。バックスラッシュは使用できません。管理画面のサイトツリーで表示されるため短めにするといいでしょう(リソース変数：[*pagetitle*])';
$_lang["resource_to_be_moved"] = '移動対象リソース';
$_lang["resource_type"] = 'リソースタイプ';
$_lang["resource_type_message"] = '「ウェブリンク」は、ネット上のリソース(ウェブページや画像・各種ファイルなど)をMODxのリソースとして扱うものです。これにより、他システムで作った掲示板などをMODx管理下にまとめることができます。コンテントタイプは「text/html」、「リソースの出力」は「ブラウザ内に通常表示」としてください。';
$_lang["resource_type_weblink"] = 'ウェブリンク';
$_lang["resource_type_webpage"] = 'ウェブページ';
$_lang["resource_weblink_help"] = 'ウェブリンクで参照したい対象のURLを入力してください。';
$_lang["resources_in_container"] = 'つのサブリソースがあります。';
$_lang["resources_in_container_no"] = 'サブリソースはありません。';
$_lang["role"] = 'ロール(役割)';
$_lang["role_about"] = '「MODxについて」ページの表示';
$_lang["role_access_persmissions"] = '所属グループ';
$_lang["role_actionok"] = '処理完了ページの表示';
$_lang["role_bk_manager"] = 'バックアップマネージャーの使用';
$_lang["role_cache_refresh"] = 'サイトをリフレッシュ';
$_lang["role_change_password"] = 'パスワード変更';
$_lang["role_chunk_management"] = 'チャンクの管理';
$_lang["role_config_management"] = '設定管理';
$_lang["role_content_management"] = 'コンテンツ管理';
$_lang["role_create_chunk"] = 'チャンクを作成';
$_lang["role_create_doc"] = 'リソースを作成';
$_lang["role_create_plugin"] = 'プラグインを作成';
$_lang["role_create_snippet"] = 'スニペットを作成';
$_lang["role_create_template"] = 'テンプレートを作成';
$_lang["role_credits"] = '著作権表示/謝辞の表示';
$_lang["role_delete_chunk"] = 'チャンクを削除';
$_lang["role_delete_doc"] = 'リソースの削除';
$_lang["role_delete_eventlog"] = 'イベントログを削除';
$_lang["role_delete_module"] = 'モジュールの削除';
$_lang["role_delete_plugin"] = 'プラグインの削除';
$_lang["role_delete_role"] = 'ロールの削除';
$_lang["role_delete_snippet"] = 'スニペットの削除';
$_lang["role_delete_template"] = 'テンプレートの削除';
$_lang["role_delete_user"] = 'ユーザーの削除';
$_lang["role_delete_web_user"] = 'ウェブユーザーの削除';
$_lang["role_edit_chunk"] = 'チャンクを編集';
$_lang["role_edit_doc"] = 'リソースの編集';
$_lang["role_edit_doc_metatags"] = 'METAタグとキーワードの編集';
$_lang["role_edit_module"] = 'モジュールの編集';
$_lang["role_edit_plugin"] = 'プラグインの編集';
$_lang["role_edit_role"] = 'ロールの編集';
$_lang["role_edit_settings"] = 'サイト設定の変更';
$_lang["role_edit_snippet"] = 'スニペットの編集';
$_lang["role_edit_template"] = 'テンプレートの編集';
$_lang["role_edit_user"] = 'ユーザーの編集';
$_lang["role_edit_web_user"] = 'ウェブユーザーの編集';
$_lang["role_empty_trash"] = '全ての削除済みリソースを完全に消去する';
$_lang["role_errors"] = 'エラーダイアログの表示';
$_lang["role_eventlog_management"] = 'イベントログ管理';
$_lang["role_export_static"] = '静的HTMLファイルとして書き出す';
$_lang["role_file_manager"] = 'ファイル管理機能の使用';
$_lang["role_frames"] = '管理画面フレームの要求';
$_lang["role_help"] = 'ヘルプページの表示';
$_lang["role_home"] = '管理画面ホームの要求';
$_lang["role_import_static"] = '静的HTMLファイルをインポート';
$_lang["role_logout"] = '管理画面をログアウト';
$_lang["role_manage_metatags"] = 'サイト全体METAタグとキーワードの管理';
$_lang["role_management_msg"] = 'ロール(役割)ごとに、利用可能な機能を選択・設定します。ロールは役割・役職のようなもので、たとえば、部長・一般社員・アルバイトの3者の異なる権限をシステム的に表現しています。MODxでは、管理画面にアクセスする全てのユーザが何らかのロール(役割)を持ちます。';
$_lang["role_management_title"] = 'ロール管理';
$_lang["role_messages"] = 'メッセージの表示および送信';
$_lang["role_module_management"] = 'モジュール管理';
$_lang["role_name"] = 'ロール名';
$_lang["role_new_module"] = 'モジュールを作成';
$_lang["role_new_role"] = 'ロールを作成';
$_lang["role_new_user"] = 'ユーザーを作成';
$_lang["role_new_web_user"] = 'ウェブユーザーを作成';
$_lang["role_plugin_management"] = 'プラグイン管理';
$_lang["role_publish_doc"] = 'リソースの公開';
$_lang["role_remove_locks"] = 'ロックの解除';
$_lang["role_role_management"] = 'ロール管理';
$_lang["role_run_module"] = 'モジュールの実行';
$_lang["role_save_chunk"] = 'チャンクの保存';
$_lang["role_save_doc"] = 'リソースの保存';
$_lang["role_save_module"] = 'モジュールの保存';
$_lang["role_save_password"] = 'パスワードの保存';
$_lang["role_save_plugin"] = 'プラグインの保存';
$_lang["role_save_role"] = 'ロールの保存';
$_lang["role_save_snippet"] = 'スニペットの保存';
$_lang["role_save_template"] = 'テンプレートの保存';
$_lang["role_save_user"] = 'ユーザーの保存';
$_lang["role_save_web_user"] = 'ウェブユーザーの保存';
$_lang["role_snippet_management"] = 'スニペット管理';
$_lang["role_template_management"] = 'テンプレート管理';
$_lang["role_title"] = 'ロールの作成/編集';
$_lang["role_udperms"] = 'アクセス許可管理';
$_lang["role_user_management"] = 'ユーザー管理';
$_lang["role_view_docdata"] = 'リソースデータの表示';
$_lang["role_view_eventlog"] = 'イベントログを見る';
$_lang["role_view_logs"] = 'システムログの閲覧';
$_lang["role_view_unpublished"] = '未公開のリソースの閲覧';
$_lang["role_web_access_persmissions"] = 'ウェブアクセス許可';
$_lang["role_web_user_management"] = 'ウェブユーザー管理';
$_lang["rss_url_news_default"] = 'http://feeds2.feedburner.com/modxjp';
$_lang["rss_url_news_message"] = '管理画面トップの「MODx News」のフィードURL';
$_lang["rss_url_news_title"] = 'RSS ニュースフィード';
$_lang["rss_url_security_default"] = 'http://feeds2.feedburner.com/modxjpsec';
$_lang["rss_url_security_message"] = '管理画面トップの「MODx Security」のフィードURL';
$_lang["rss_url_security_title"] = 'RSS セキュリティ情報フィード';
$_lang["run_module"] = 'モジュールの実行';
$_lang["saturday"] = '土';
$_lang["save"] = '保存';
$_lang["save_all_changes"] = '全ての変更を更新';
$_lang["save_tag"] = 'タグ保存';
$_lang["saving"] = '保存中です。お待ちください';
$_lang["search"] = '検索';
$_lang["search_criteria"] = '検索 条件';
$_lang["search_criteria_content"] = '内容で検索';
$_lang["search_criteria_content_msg"] = '';
$_lang["search_criteria_id"] = 'IDで検索';
$_lang["search_criteria_id_msg"] = '';
$_lang["search_criteria_longtitle"] = 'タイトルで検索';
$_lang["search_criteria_longtitle_msg"] = '';
$_lang["search_criteria_title"] = 'リソース名で検索';
$_lang["search_criteria_title_msg"] = '';
$_lang["search_empty"] = '指定したデータが見つかりませんでした。検索範囲を広げて再度検索してください。';
$_lang["search_item_deleted"] = 'このアイテムは削除されています';
$_lang["search_results"] = '検索結果';
$_lang["search_results_returned_desc"] = '説明';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = '<strong>%s</strong>件のデータが見つかりました。多くの検索結果が表示される場合は、検索範囲を更に狭くしてください。左側二つのカラムでは、サイトツリーでリソースを探したり、リソースを表示したりすることができます。右側二つのカラムでは、 リソースの削除状態および公開状態が各々表示されます。<p />';
$_lang["search_results_returned_title"] = 'タイトル';
$_lang["search_view_docdata"] = 'このアイテムを表示';
$_lang["security"] = 'ユーザー管理';
$_lang["security_notices_tab"] ='セキュリティ情報';
$_lang["security_notices_title"] ='セキュリティ情報';
$_lang["select_date"] = '日付を選択';
$_lang["send"] = '送信';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'このサイトがSSL接続を使用している場合は、httpsを選択してください。';
$_lang["server_protocol_title"] = 'サーバータイプ ';
$_lang["serveroffset"] = 'サーバーオフセット';
$_lang["serveroffset_message"] = 'サーバー設置場所とあなたの居場所の時差を選択してください。サーバーの現在時刻は<strong>[%s]</strong>です。オフセットを使用したサーバーの現在時刻は<strong>[%s]</strong>です。';
$_lang["serveroffset_title"] = 'サーバーオフセットタイム ';
$_lang["servertime"] = 'サーバー時刻';
$_lang["settings_after_install"] = '<p><strong style="color:red;">アップデートまたは新規インストール直後のため、各種設定を確認し保存する必要があります。設定を確認した後、データベースを更新するために「保存」ボタンをクリックしてください。</strong></p><p>※この設定は後で自由に変更できます(ツール→グローバル設定)。今の時点では公開ステータス(公開・メンテナンス中など)の設定のみ確認しておくといいでしょう。</p>';
$_lang["settings_config"] = '設定';
$_lang["settings_dependencies"] = '関連付け';
$_lang["settings_events"] = 'システムイベント';
$_lang["settings_furls"] = 'フレンドリーURL';
$_lang["settings_general"] = 'メイン';
$_lang["settings_misc"] = 'ファイル管理の設定';
$_lang["settings_page_settings"] = 'ページ設定';
$_lang["settings_photo"] = '写真';
$_lang["settings_properties"] = 'プロパティ';
$_lang["settings_site"] = 'サイト';
$_lang["settings_strip_image_paths_message"] = 'ファイルブラウザで選択したファイルのsrc属性を相対パスで投稿画面に渡します。この設定を「いいえ」にした場合は、httpから始まるフルURLになります。投稿画面で利用するRTEによっては、受け取った値をさらに処理することがあるため、ここでの設定は確実ではありません。<br />また、相対パスで運用する場合はフレンドリーURL設定を有効にすると画像やサイト内リンクなどを正しく参照できないことがあります。そのような場合は<a href="http://www.google.com/search?hl=ja&q=html+base+href" target="_blank">baseタグ</a>を利用してください。';
$_lang["settings_strip_image_paths_title"] = '相対パスを渡す';
$_lang["settings_templvars"] = 'テンプレート変数';
$_lang["settings_title"] = 'グローバル設定';
$_lang["settings_ui"] = 'インターフェースとその他の機能';
$_lang["settings_users"] = '詳細設定';
$_lang["show_meta"] = 'META Keywordsタブを表示';
$_lang["show_meta_message"] = 'リソース編集画面にMETA Keywordsタブを表示します。過去のMODxとの互換性が必要な場合を除き、当設定は使い勝手の問題により推奨しません。';
$_lang["show_tree"] = 'サイトツリーの表示';
$_lang["showing"] = '表示中';
$_lang["signupemail_message"] = 'ユーザ管理画面でユーザーアカウントを作成した時に、ログイン名とパスワードを記載したメールを送信することができます。このメールの内容は変更できます<br /><strong>参考:</strong> 下記の差し込み文字列は送信時に自動的に置き換えられます。<br /><br />[+sname+] - サイトの名前<br />[+saddr+] - サイト管理者のメールアドレス<br />[+surl+] - サイトのURL<br />[+uid+] - ログイン名<br />[+pwd+] - パスワード<br />[+ufn+] - フルネーム ';
$_lang["signupemail_title"] = 'サインアップメール ';
$_lang["site"] = 'メイン';
$_lang["site_schedule"] = '公開状態の一覧';
$_lang["sitename_message"] = 'サイト名を入力してください。title要素などで [*pagetitle*] などと組み合わせて用います。<br />コンフィグ変数： [(site_name)]';
$_lang["sitename_title"] = 'サイト名 ';
$_lang["sitestart_message"] = 'トップページとして使用するリソースのIDを入力してください。<br /><strong>※非公開のリソースは指定できません。</strong>';
$_lang["sitestart_title"] = 'サイトスタート ';
$_lang["sitestatus_message"] = 'このサイトをウェブ上に公開するには「オンライン」を選択してください。「メンテナンスモード」を選択すると、訪問者には「メンテナンス中ページ」または「メンテナンス中メッセージ」が表示されます。';
$_lang["sitestatus_title"] = '公開ステータス ';
$_lang["siteunavailable_message"] = 'サイトがメンテナンスモード中、またはエラー発生時に表示するメッセージです。<br />コンフィグ変数：[(site_unavailable_message)]<br /><strong>※このメッセージはメンテナンス中ページが設定されていないときのみ表示されます。</strong>';
$_lang["siteunavailable_message_default"] = 'ただいま調整中です。しばらくお待ちください。';
$_lang["siteunavailable_page_message"] = 'メンテナンスモード設定時に表示するリソースのIDをここに入力してください。<br /><strong>※非公開またはウェブユーザ限定のリソースは指定できません。</strong>';
$_lang["siteunavailable_page_title"] = 'メンテナンス中ページ ';
$_lang["siteunavailable_title"] = 'メンテナンス中メッセージ ';
$_lang["snippet"] = 'スニペット';
$_lang["snippet_code"] = 'スニペット コード (php)';
$_lang["snippet_desc"] = '説明';
$_lang["snippet_execonsave"] = '保存後にスニペットを実行';
$_lang["snippet_management_msg"] = '<h3 style="font-weight:bold;">スニペットの管理</h3><p>スニペットは主にリソースやテンプレートから呼び出すことを想定した簡易の機能拡張です。リソースまたはテンプレート内の任意の場所に <strong>[[スニペット名]]</strong> または <strong>[!スニペット名!]</strong> (キャッシュ無効)と記述するだけで手軽に呼び出せます。詳しくは<a href="index.php?a=9">ヘルプ</a>をご覧ください。</p>';
$_lang["snippet_msg"] = '<p>スニペット名には日本語を用いることができます。先頭と末尾の「&lt;?php」「?&gt;」は必須です。省略した場合は自動的に追加されます。スニペットの作り方については<a href="index.php?a=9">ヘルプ</a>の「Tutorial」を参照してください。</p>';
$_lang["snippet_name"] = 'スニペット名';
$_lang["snippet_properties"] = '既定のプロパティ';
$_lang["snippet_title"] = 'スニペットの作成/編集';
$_lang["sort_asc"] = '昇順';
$_lang["sort_desc"] = '降順';
$_lang["sort_tree"] = 'サイトツリーのソート';
$_lang["source"] = 'ソース';
$_lang["stay"] = '保存後に続けて編集';
$_lang["stay_new"] = '次の作成';
$_lang["submit"] = '実行';
$_lang["sunday"] = '日';
$_lang["sys_alert"] = 'システム警告';
$_lang["sysinfo_activity_message"] = '最近編集されたリソースの一覧';
$_lang["sysinfo_userid"] = 'ユーザー';
$_lang["system_email_signup"] = "こんにちは [+uid+] さん\n\n「[+sname+] ( [+surl+] )」の管理画面へのログイン情報について下記のとおりお知らせします。\n\nログイン名: [+uid+]\nパスワード: [+pwd+]\n\n管理画面にログインすれば、パスワードを自由に変更できます。\n\n以上、よろしくお願いします。\nサイト管理者より";
$_lang["system_email_webreminder"] = "こんにちは [+uid+] さん\n\nパスワードを有効にするためには、下記のリンクをクリックしてください。\n\n[+surl+]\n\n処理完了後、下記のパスワードをログインに使用できるようになります。\n\nパスワード:[+pwd+]\n\nこのメールに覚えが無いときは無視して下さい。\n\n以上、よろしくお願いします。\nサイト管理者より";
$_lang["system_email_websignup"] = "こんにちは [+uid+] さん\n\n「[+sname+] ([+surl+])」へのログイン情報について下記のとおりお知らせします。\n\nログイン名: [+uid+]\nパスワード: [+pwd+]\n\n [+sname+]へログインすれば、自分のパスワードは自由に変更できます。\n\n以上、よろしくお願いします。\nサイト管理者より";
$_lang["table_hoverinfo"] = 'ここで取得したSQLファイルを用いて、サイトをリストアできます。phpMyAdminなどを用いてSQLファイルをインポートします。「DROP文を生成」にチェックを入れておくと、インポート時にテーブルを作り直すため、より確実にサイトを再現できます。<br /><strong style="color:red;">【注意1】</strong>SQLファイルのサイズが大き過ぎるとリストア(インポート)に失敗しやすくなるためご注意ください。特に_event_logテーブルと_manager_logテーブルが肥大の原因になっていることが多いです。「データサイズ」のリンクをクリックしてログをリセットするか、これら2つのテーブルをバックアップ対象から外すとよいでしょう。それでもまだ大きい場合は<a href="http://www.google.com/search?hl=ja&q=BigDump" target="_blank">BigDump</a>などのツールを試してみてください。<br /><strong style="color:red;">【注意2】</strong> データをリストアする時、リストア元とリストア先のMODxのバージョンが違う場合は注意が必要です。リストアすると、拡張機能のバージョンも元の状態に戻ります。問題を回避するには、MODxのバージョンを揃えてリストアするか、リストア後にもう一度MODxをインストーラを用いて最新状態にアップデートするとよいでしょう。';
$_lang["table_prefix"] = 'テーブル接頭辞';
$_lang["tag"] = 'タグ';
$_lang["template"] = 'テンプレート';
$_lang["template_assignedtv_tab"] = '定義されているテンプレート変数';
$_lang["template_code"] = 'テンプレート コード (html)';
$_lang["template_desc"] = '説明';
$_lang["template_edit_tab"] = 'テンプレートの編集';
$_lang["template_management_msg"] = '<h3 style="font-weight:bold;">テンプレートデザインの管理</h3><p>テンプレートはいくつでも作成でき、各ページ(リソース)ごとに自由に割り当てることができます。カッコ内の数字はテンプレートIDです。</p>';
$_lang["template_msg"] = 'テンプレートを作成/編集します。通常のhtmlに埋め込む独自タグとして、テンプレート変数(リソース変数含む)・コンフィグ変数・リンクタグ・スニペット・チャンク・ベンチマークタグなどを記述できます。詳しくは<a href="index.php?a=9">ヘルプ</a>を参照してください。';
$_lang["template_name"] = 'テンプレート名';
$_lang["template_no_tv"] = 'テンプレート変数は定義されていません。';
$_lang["template_reset_all"] = '全てのリソースに適用する';
$_lang["template_reset_specific"] = '「%s」テンプレートを使用しているリソースに適用する';
$_lang["template_title"] = 'テンプレートの作成/編集';
$_lang["template_tv_edit"] = 'テンプレート変数の順序を書き換える';
$_lang["template_tv_edit_message"] = '投稿画面上の入力フィールド(テンプレート変数)の順序を並べ替えることができます。マウス操作で上下にドラッグし、最後に「保存」をクリックしてください。';
$_lang["template_tv_edit_title"] = 'テンプレート変数のソート順';
$_lang["template_tv_msg"] = 'このテンプレートに定義されているテンプレート変数は下記のリストのとおりです。';
$_lang["thursday"] = '木';
$_lang["tmplvar_access_msg"] = 'この変数に対して内容や値の変更を許可するリソースグループを選択してください。';
$_lang["tmplvar_change_template_msg"] = 'このテンプレートを変更すると、このページのテンプレート変数をリロードします。保存していない変更は失われます。';
$_lang["tmplvar_inuse"] = 'このテンプレート変数は下記のテンプレートで使われています。「削除」または「キャンセル」ボタンをクリックしてください。';
$_lang["tmplvar_tmpl_access"] = 'テンプレートとの関連付け';
$_lang["tmplvar_tmpl_access_msg"] = 'このテンプレート変数を関連付けるテンプレートを選択してください。';
$_lang["tmplvars"] = 'テンプレート変数';
$_lang["tmplvars_binding_msg"] = 'このフィールドはアットバインディングを使って各種のデータソースから値を代入できます。';
$_lang["tmplvars_caption"] = '見出し(入力フィールド名)';
$_lang["tmplvars_default"] = '既定値';
$_lang["tmplvars_description"] = '説明';
$_lang["tmplvars_elements"] = '入力時のオプション<br />選択肢A||選択肢B または<br />選択肢名A==値A||選択肢名B==値B<br />のように区切って書きます。';
$_lang["tmplvars_management_msg"] = '<h3 style="font-weight:bold;">テンプレート変数の管理</h3><p>一般的なCMSでいうところのカスタムフィールドに相当するもので、MODxはこの機能が非常に柔軟・強力です。「タイトル」や「内容」などの既定の項目に加え、投稿画面上に自由に項目を追加できます。テンプレート内の任意の場所に <strong>[*テンプレート変数名*]</strong> と記述すると値を出力できます。詳しくは<a href="index.php?a=9">ヘルプ</a>を参照してください。</p>';
$_lang["tmplvars_msg"] = 'テンプレート変数及び入力フィールドを設定します。テンプレート変数名には日本語を用いることができます。このテンプレート変数を使用するテンプレートを「テンプレートとの関連付け」で関連付けないと使用できないためご注意ください。<br />入力タイプ「Listbox」や「CheckBox」は「入力時のオプション」を設定できます。';
$_lang["tmplvars_name"] = '変数名';
$_lang["tmplvars_novars"] = 'テンプレート変数はありません。';
$_lang["tmplvars_rank"] = '並べ替え順';
$_lang["tmplvars_reset_params"] = 'パラメータのリセット';
$_lang["tmplvars_title"] = 'テンプレート変数を編集';
$_lang["tmplvars_type"] = '入力タイプ';
$_lang["tmplvars_widget"] = 'ウィジェット(出力フィルタ)';
$_lang["tmplvars_widget_prop"] = 'ウィジェットのプロパティ';
$_lang["to"] = '-';
$_lang["tools"] = 'ツール';
$_lang["top_howmany_message"] = '訪問レポートの「トップ ...」に何件表示するか指定します。(※訪問レポートの機能は現在のMODxには実装されていません)';
$_lang["top_howmany_title"] = 'トップ 表示件数';
$_lang["total"] = '合計';
$_lang["track_visitors_message"] = 'このサイトのアクセス解析データを蓄積します(※実際には蓄積されません。対応モジュールが必要)。';
$_lang["track_visitors_title"] = 'アクセスログを記録';
$_lang["tree_page_click"] = 'サイトツリークリック時の動作';
$_lang["tree_page_click_message"] = 'サイトツリーを左クリックした時の既定の動作を設定します。';
$_lang["tree_show_protected"] = '権限のないリソースの表示';
$_lang["tree_show_protected_message"] = 'ログインしているユーザーが操作権限を持たないリソースも全てサイトツリーに表示します。Windowsフォルダオプションの「全てのファイルとフォルダを表示する」に似ています。権限の設定は<a href="index.php?a=40">「グループ管理」</a>で行ないます。';
$_lang["truncate_table"] = 'このテーブルの内容を全削除するにはここをクリック';
$_lang["tuesday"] = '火';
$_lang["tv"] = 'テンプレート変数';
$_lang["type"] = 'タイプ';
$_lang["udperms_allowroot_message"] = 'サイトツリーのルート直下にユーザーがリソースを作成できるようにしますか? ';
$_lang["udperms_allowroot_title"] = 'ルートの使用許可 ';
$_lang["udperms_message"] = '会員制サイトを運用する場合や、編集権限を持つページをグループ単位で制限したい場合に必要となる設定です。グループ管理機能を有効にすると、ユーザーの編集権限をユーザーグループごと・リソースグループごとに割り当てることができます。まず当設定を有効にしたうえで<a href="index.php?a=40" target="_self">グループ管理</a>を開き、ユーザーグループとリソースグループを作ってください。次に、それぞれのユーザーグループとリソースグループを関連付けてください。最後に、個別のユーザーをユーザーグループに、個別のリソースをリソースグループに割り当ててください。この設定を「はい」にした場合、全てのリソースを編集する権限を持つのは初期状態ではAdministrator(のロールが割り当てられているユーザ)のみとなります。';
$_lang["udperms_title"] = 'グループ管理機能を使用する ';
$_lang["unable_set_link"] = 'リンクを設定できません。';
$_lang["unable_set_parent"] = '新しい親リソースを設定できません。';
$_lang["unauthorizedpage_message"] = 'ユーザーがアクセスを許可されていないリソースを要求したとき表示するリソースのIDを入力してください。<br /><strong>※非公開またはウェブユーザ限定のリソースは指定できません。</strong>';
$_lang["unauthorizedpage_title"] = '権限外告知のページ ';
$_lang["unblock_message"] = 'ユーザーデータを保存した後、このアカウントの休止設定は解除されます。';
$_lang["undelete_resource"] = '削除から復活';
$_lang["unpublish_date"] = '公開終了日時';
$_lang["unpublish_events"] = '公開取り消しを予定しているリソースの一覧';
$_lang["unpublish_resource"] = '非公開にする';
$_lang["untitled_resource"] = 'タイトルがありません';
$_lang["untitled_weblink"] = 'タイトルがありません';
$_lang["update_params"] = 'パラメータ表示の更新';
$_lang["update_settings_from_language"] = '置き換え ';
$_lang["upload_maxsize_message"] = '管理画面を通じてアップロード可能なファイルの最大サイズを入力してください。サイズはバイト単位で入力します。<br /><strong>※サーバ側で設けられている上限サイズを超える設定はできません。</strong>';
$_lang["upload_maxsize_title"] = 'アップロードサイズの上限';
$_lang["uploadable_files_message"] = '<a href="index.php?a=31" target="_self">ファイル管理</a>画面でアップロードできるファイルタイプの拡張子を入力してください。カンマで区切って複数指定できます。この設定はファイルブラウザも参照します。';
$_lang["uploadable_files_title"] = 'アップロード可能なファイルタイプ ';
$_lang["uploadable_flash_message"] = 'ファイルブラウザを使用して「assets/flash/ 」にアップロードできるフラッシュファイルの拡張子を入力してください。カンマで区切って複数入力できます。';
$_lang["uploadable_flash_title"] = 'アップロード可能なフラッシュ ';
$_lang["uploadable_images_message"] = 'ファイルブラウザを使用して「assets/images/ 」にアップロードできる画像ファイルの拡張子を入力してください。カンマで区切って複数入力できます。';
$_lang["uploadable_images_title"] = 'アップロード可能な画像タイプ ';
$_lang["uploadable_media_message"] = 'ファイルブラウザを使用して「assets/media/ 」にアップロードできるメディアファイルの拡張子を入力してください。カンマで区切って複数入力できます。';
$_lang["uploadable_media_title"] = 'アップロード可能なメディアタイプ ';
$_lang["use_alias_path_message"] = 'このオプションを「はい」に設定すると、リソースのエイリアスがパスとして表示されます。例えば、「child」というエイリアスを持ったリソース「parent」というエイリアスのリソースの下に配置されていると、エイリアスパスは「/parent/child.html」になります。<br /><strong>注意: このオプションを「はい」にしてエイリアスパスを使用するときは、リソースから参照するものは（画像・CSS・JavaScriptなど）絶対パスで指定する必要があります。例えば、assets/imagesに対しては/assets/imagesと指定します。または、<a href="http://www.google.com/search?hl=ja&q=html+base+href" target="_blank">baseタグ</a>を利用すると、相対パス記述でも正しく参照できます。</strong>';
$_lang["use_alias_path_title"] = 'エイリアスパスを使用 ';
$_lang["use_editor_message"] = 'リッチテキストエディター(RTE)の使用を設定します。「いいえ」を選択するとRTEを利用できなくなります。この設定は全てのリソース・全てのユーザーに影響します。';
$_lang["use_editor_title"] = 'リッチテキストエディターの使用 ';
$_lang["user"] = 'ユーザー';
$_lang["user_block"] = '休止中';
$_lang["user_blockedafter"] = 'この日から休止';
$_lang["user_blockeduntil"] = 'この日まで休止';
$_lang["user_changeddata"] = 'ユーザー情報が変更されました。もう一度ログインし直してください。';
$_lang["user_country"] = '国';
$_lang["user_dob"] = '誕生日';
$_lang["user_doesnt_exist"] = 'ユーザー登録がありません';
$_lang["user_edit_self_msg"] = '<b>ユーザー情報を変更した場合は、変更を管理画面に反映させるためにいったんログアウトしてください。</b>';
$_lang["user_email"] = 'メールアドレス';
$_lang["user_failedlogincount"] = 'ログイン失敗';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = '女性';
$_lang["user_full_name"] = 'フルネーム';
$_lang["user_gender"] = '性別';
$_lang["user_is_blocked"] = 'このアカウントは休止状態になっています。';
$_lang["user_logincount"] = 'ログイン回数';
$_lang["user_male"] = '男性';
$_lang["user_management_msg"] = '管理画面の操作を行なうユーザをここで作成・管理します。ロール管理とグループ管理を併用し、アクセス権限を細かく管理できます。';
$_lang["user_management_title"] = 'ユーザー管理';
$_lang["user_mobile"] = '携帯電話';
$_lang["user_phone"] = '電話番号';
$_lang["user_photo"] = 'ユーザーの写真';
$_lang["user_photo_message"] = 'このユーザーのイメージ画像のURLを入力してください。または、挿入ボタンをクリックしファイルマネージャーでファイルを選択してください。';
$_lang["user_prevlogin"] = '前回のログイン日時';
$_lang["user_role"] = 'ロール(役割)';
$_lang["user_state"] = '住所';
$_lang["user_title"] = 'ユーザーの作成/編集';
$_lang["user_upload_message"] = ' このユーザーに対してこのカテゴリーに含まれるファイルタイプのアップロードを禁じたい場合、「グローバル設定を使用」をチェックせず、このフィールドを空白にしておいてください。';
$_lang["user_use_config"] = 'グローバル設定を使用';
$_lang["user_zip"] = '郵便番号';
$_lang["username"] = 'ログイン名';
$_lang["users"] = '権限管理';
$_lang["validate_referer_message"] = '「はい」を選択すると、リファラチェック(参照元チェック)を行い、不正な参照元からのURLによる要求を拒否します。これにより、管理画面にログイン中に意図しない動作をさせられてしまう脅威 <a href="http://www.google.com/search?hl=ja&q=csrf" target="_blank">(CSRF=Cross Site Request Forgery)</a>をある程度軽減できます。ただしリファラは偽装が可能なため注意が必要です。よりよい回避策が実装されるまでは、管理画面にログイン中は、不用意に外部リンクをクリックしない・こまめにログアウトをするなど習慣づけてください。';
$_lang["validate_referer_title"] = '管理画面操作のリファラチェック';
$_lang["value"] = '値';
$_lang["view"] = 'ここをクリック';
$_lang["view_child_resources_in_container"] = 'サブリソースを表示';
$_lang["view_log"] = 'ログを見る';
$_lang["view_logging"] = '管理操作ログ';
$_lang["view_sysinfo"] = 'システム情報';
$_lang["warning"] = '警告 ';
$_lang["warning_not_saved"] = '変更が保存されていません。変更を保存するためには「キャンセル」をクリックし現在のページに戻ってください。また、「OK」をクリックして全ての変更を破棄することもできます。';
$_lang["warning_visibility"] = 'ダッシュボードの警告表示';
$_lang["warning_visibility_message"] = 'ダッシュボードの警告を表示する<a href="index.php?a=86">対象ロール</a>を設定します。';
$_lang["web_access_permissions"] = 'グループ管理(ウェブ)';
$_lang["web_access_permissions_user_groups"] = 'ウェブユーザーグループ';
$_lang["web_permissions"] = 'グループ管理(ウェブ)';
$_lang["web_user_management_msg"] = '会員制サイトを運用する場合、ここでユーザを作成・管理します。グループ管理(ウェブ)の設定を併用し、アクセス対象を設定してください。グループ管理機能を用いずログイン状態のみ提供するシンプルな運用も可能です。<br />※ここで管理するアカウントは管理画面にアクセスする権限は持ちません。';
$_lang["web_user_management_title"] = 'ウェブユーザー管理';
$_lang["web_user_title"] = 'ウェブユーザーの作成･編集';
$_lang["web_users"] = 'ウェブユーザー管理';
$_lang["weblink"] = 'ウェブリンク';
$_lang["weblink_message"] = 'ウェブリンクは、インターネット上のオブジェクトに対する参照です。オブジェクトは、MODx内のリソース(IDで指定)・他のサイトのページや画像・インターネット上の他のファイル(URLで指定)です。<p>';
$_lang["webpwdreminder_message"] = 'ウェブユーザーからパスワード変更の要求があった時に、MODxは新パスワードとアクティベーション方法を記載したメールを送信することができます。このメールの内容は変更できます。<br /><strong>参考:</strong> 下記の差し込み文字列は送信時に自動的に置き換えられます。<br /><br />[+sname+] - サイトの名前<br />[+saddr+] - サイト管理者のメールアドレス<br />[+surl+] - サイトのURL<br />[+uid+] - ログイン名<br />[+pwd+] - パスワード<br />[+ufn+] - フルネーム';
$_lang["webpwdreminder_title"] = 'パスワード変更<br />リクエストメール ';
$_lang["websignupemail_message"] = 'ユーザー自らがウェブユーザーアカウントを作成した時に、MODxはログイン名とパスワードを記載したメールを送信することができます。このメールの内容は変更できます。<br /><strong>参考:</strong> 下記の差し込み文字列は送信時に自動的に置き換えられます。<br /><br />[+sname+] - サイトの名前<br />[+saddr+] - サイト管理者のメールアドレス<br />[+surl+] - サイトのURL<br />[+uid+] - ログイン名<br />[+pwd+] - パスワード<br />[+ufn+] - フルネーム';
$_lang["websignupemail_title"] = 'ウェブサインアップメール ';
$_lang["wednesday"] = '水';
$_lang["welcome_messages"] = '受信トレイに <strong>%d</strong> 件のメッセージが入っています。<strong>%s</strong> 件が未読です。';
$_lang["welcome_title"] = 'MODxへようこそ';
$_lang["which_editor_message"] = 'デフォルトで使用するリッチテキストエディターを選択してください(※<a href="http://modxcms.com/extras/repository/packages/Content" target="_blank">MODxのダウンロードページ</a>には追加でインストールできるリッチテキストエディターがあります)。';
$_lang["which_editor_title"] = '使用エディター ';
$_lang["working"] = '処理中';
$_lang["wrap_lines"] = '行の折り返し';
$_lang["xhtml_urls_message"] = '「はい」を設定すると、URLに含まれるアンパーサンド (&amp;) を自動的に文字実態参照 (&amp;<!-- -->amp;) に置き換えます。';
$_lang["xhtml_urls_title"] = 'XHTML形式のURL';
$_lang["yes"] = 'はい';
$_lang["you_got_mail"] = 'メッセージが届いています。';
$_lang["yourinfo_message"] = '自分自身に関する情報を表示しています ';
$_lang["yourinfo_previous_login"] = '前回のログイン日時';
$_lang["yourinfo_role"] = '所属ロール(役割) ';
$_lang["yourinfo_title"] = 'あなたの情報';
$_lang["yourinfo_total_logins"] = '合計ログイン回数 ';
$_lang["yourinfo_username"] = 'ログイン名';
?>