<?php
/**
 * Filename:       includes/lang/svenska.inc.php
 * Function:       Swedish language file
 * Author:         Pontus gren (Pont) & Johnny Chadda
 * Date:           2010-05-18
 * Version:        1.0
 * MODx version:   Evolution 1.0.x rev 6804
*/

//$modx_textdir = 'rtl'; // uncomment this line for RTL langauges
$modx_lang_attribute = 'sv'; // Manager HTML/XML Language Attribute see http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'ISO-8859-1';

$_lang["about_msg"] = 'MODx r ett <a href="http://modxcms.com/what-is-modx.html" target="_blank">PHP applikationsramverk och system fr innehllshantering</a> och r licensierat under <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'Om MODx';
$_lang["access_permission_denied"] = 'Du har inte behrighet fr denna resurs.';
$_lang["access_permission_parent_denied"] = 'Du har inte behrighet att skapa en resurs hr eller att flytta en hit! Vlj en annan plats.';
$_lang["access_permissions"] = 'tkomstinstllningar';
$_lang["access_permissions_add_resource_group"] = 'Skapa en ny resursgrupp';
$_lang["access_permissions_add_user_group"] = 'Skapa en ny anvndargrupp';
$_lang["access_permissions_docs_collision"] = 'Den hr resursen kommer att vara publik p grund av att webbanvndargrupperna och hanterarens anvndargrupper r i konflikt fr din roll. Kontakta en av webbplatsens administratrer fr att f ytterligare hjlp.';
$_lang["access_permissions_docs_message"] = 'Vlj vilka resursgrupper denna resurs ska tillhra:';
$_lang["access_permissions_group_link"] = 'Skapa en ny grupplnk';
$_lang["access_permissions_introtext"] = 'Hantera de anvndargrupper och resursgrupper som anvnds fr tkomstkontroll. Fr att lgga till en anvndare i en grupp - redigera anvndaren och vlj de grupper som han/hon ska vara medlem i. Fr att lgga till en resurs till en anvndargrupp - redigera resursen och vlj de grupper som den ska tillhra.';
$_lang["access_permissions_link_to_group"] = 'till resursgrupp';
$_lang["access_permissions_link_user_group"] = 'Lnka anvndargrupp';
$_lang["access_permissions_links"] = 'Anvndar/resursgruppslnkar';
$_lang["access_permissions_links_tab"] = 'Ange vilka anvndargrupper som har behrighet fr de olika resursgrupperna (dvs kan redigera eller skapa underresurser). Fr att lnka en resursgrupp till en anvndargrupp - vlj de lmpliga grupperna frn rullgardinsmenyerna och klicka p "Skicka". Fr att ta bort lnken fr en grupp - klicka p "Ta bort". Detta tar genast bort lnken.';
$_lang["access_permissions_no_resources_in_group"] = 'Inga.';
$_lang["access_permissions_no_users_in_group"] = 'Inga.';
$_lang["access_permissions_off"] = '<span class="warning">tkomstinstllningar r inte aktiverade.</span> Detta betyder att frndringar som grs hr inte kommer att ha ngon effekt frrn tkomstinstllningarna r aktiverade i dina instllningar.';
$_lang["access_permissions_resource_groups"] = 'Resursgrupper';
$_lang["access_permissions_resources_in_group"] = '<b>Resurser i gruppen:</b> ';
$_lang["access_permissions_resources_tab"] = 'Se vilka resursgrupper som har skapats. Det gr ocks att skapa nya eller byta namn p grupper samt se vilka resurser som tillhr de olika grupperna (hll musen ver resursens ID fr att se dess namn). Fr att lgga till eller ta bort en resurs frn en grupp - redigera resursen direkt.';
$_lang["access_permissions_user_groups"] = 'Anvndargrupper';
$_lang["access_permissions_user_message"] = 'Ange vilka anvndargrupper denna anvndare ska tillhra:';
$_lang["access_permissions_users_in_group"] = 'Anvndare i gruppen:';
$_lang["access_permissions_users_tab"] = 'Se de anvndargrupper som har skapats. Du kan ocks skapa nya, byta namn p och ta bort grupper samt se vilka anvndare som r medlemmar i de olika grupperna. Fr att lgga till eller ta bort en anvndare frn en grupp - redigera anvndaren direkt. Administratrer (som har roll-ID 1) har alltid tillgng till alla resurser, s de behver inte lggas till i ngra grupper.';
$_lang["account_email"] = 'Kontots e-post';
$_lang["actioncomplete"] = '<b>tgrden har utfrts!</b><br /> - Vnta medan MODx rensar upp.';
$_lang["activity_message"] = 'Denna lista visar de senaste resurserna som du skapat eller redigerat.';
$_lang["activity_title"] = 'Nyligen skapade/redigerade resurser';
$_lang["add"] = 'Lgg till';
$_lang["add_chunk"] = 'Lgg till chunk';
$_lang["add_doc"] = 'Lgg till resurs';
$_lang["add_folder"] = 'Ny katalog';
$_lang["add_plugin"] = 'Lgg till plugin';
$_lang["add_resource"] = 'Ny resurs';
$_lang["add_snippet"] = 'Lgg till snippet';
$_lang["add_tag"] = 'Lgg till tagg';
$_lang["add_template"] = 'Lgg till mall';
$_lang["add_tv"] = 'Lgg till mallvariabel';
$_lang["add_weblink"] = 'Ny webblnk';
$_lang["administrator_role_message"] = 'Denna roll kan inte redigeras eller tas bort.';
$_lang['administrators'] = 'Administratrer';
$_lang["after_saving"] = 'Efter sparande';
$_lang["alert_delete_self"] = 'Du kan inte ta bort dig sjlv!';
$_lang["alias"] = 'URL-alias';
$_lang["all_doc_groups"] = 'Alla resursgrupper (Offentlig)';
$_lang["all_events"] = 'Alla hndelser';
$_lang["all_usr_groups"] = 'Alla anvndargrupper (Offentlig)';
$_lang["allow_mgr_access"] = 'tkomst till hanterarens grnssnitt';
$_lang["allow_mgr_access_message"] = 'Anvnd den hr instllningen fr att tillta eller frbjuda tkomst till hanterarens grnssnitt.<br /><b>Notera: Om den hr instllningen r satt till "Nej" kommer anvndaren att omdirigeras till inloggningssidan eller webbplatsens startsida.</b>';
$_lang["already_deleted"] = 'har redan tagits bort.';
$_lang["attachment"] = 'Bifogad fil';
$_lang["automatic_alias_message"] = 'Vlj "Ja" fr att lta systemet automatiskt skapa ett URL-alias baserat p resursens titel nr den sparas.';
$_lang["automatic_alias_title"] = 'Generera URL-alias automatiskt';
$_lang["backup"] = 'Skerhetskopiera';
$_lang["bk_manager"] = 'Skerhetskopiering';
$_lang["block_message"] = 'Denna anvndare kommer att blockeras nr anvndarens data sparats!';
$_lang["blocked_minutes_message"] = 'Ange hur mnga minuter en anvndare blir blockerad efter att ha gjort fr mnga misslyckade inloggningsfrsk. Ange vrdet som ett tal (inga kommatecken, mellanslag etc).';
$_lang["blocked_minutes_title"] = 'Blockeringstid';
$_lang["cache_files_deleted"] = 'Fljande filer togs bort:';
$_lang["cancel"] = 'Avbryt';
$_lang["captcha_code"] = 'Skerhetskod';
$_lang["captcha_message"] = 'Anvnd detta fr att strka skerheten genom att lta anvndare skriva in en skerhetskod som r olsbar fr maskiner (och scriptkidsens hackingscript).';
$_lang["captcha_title"] = 'Anvnd CAPTCHA-koder';
$_lang["captcha_words_default"] = 'MODx,Access,Better,BitCode,Chunk,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Oscope,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Tattoo,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote';
$_lang["captcha_words_message"] = 'Skriv en lista med CAPTCHA-ord som anvnds om CAPTCHA r pslaget. Separera orden med kommatecken. Detta textflt r begrnsat till 255 tecken.';
$_lang["captcha_words_title"] = 'CAPTCHA-ord';
$_lang["category_heading"] = 'Kategori';
$_lang["category_msg"] = 'Visa och redigera alla element grupperade i kategorier.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'ndra namn';
$_lang["change_password"] = 'Byt lsenord';
$_lang["change_password_confirm"] = 'Bekrfta lsenord';
$_lang["change_password_message"] = 'Skriv in ditt nya lsenord, och gr det sedan en gng till fr att bekrfta. Ditt lsenord mste vara mellan 6 och 15 tecken lngt.';
$_lang["change_password_new"] = 'Nytt lsenord';
$_lang["charset_message"] = 'Vlj den teckenkodning som ska anvndas som standard fr systemvariabeln [(modx_charset)]. Det hr pverkar inte hanteraren.';
$_lang["charset_title"] = 'Teckenkodning';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Chunk-kod (html)';
$_lang["chunk_multiple_id"] = 'Fel: Flera chunks har samma unika ID.';
$_lang["chunk_no_exist"] = 'Chunken existerar inte.';
$_lang["cleaningup"] = 'Rensar upp';
$_lang["clear_log"] = 'Rensa logg';
$_lang["click_to_context"] = 'Klicka fr att komma t snabbmenyn';
$_lang["click_to_edit_title"] = 'Klicka hr fr att redigera den hr posten';
$_lang["click_to_view_details"] = 'Klicka hr fr att se detaljer';
$_lang["close"] = 'Stng';
$_lang["code"] = 'Kod';
$_lang["collapse_tree"] = 'Fll ihop webbplatstrd';
$_lang["comment"] = 'Kommentar';
$_lang["configcheck_admin"] = 'Kontakta en systemadministratr och varna om detta meddelande!';
$_lang["configcheck_cache"] = 'cache-katalogen r inte skrivbar';
$_lang["configcheck_cache_msg"] = 'MODx kan inte skriva till cache-katalogen. MODx kommer fortfarande att fungera som frvntat, men inga resurser kommer att cachas. Fr att rtta till det hr, gr /_cache/-katalogen skrivbar.';
$_lang["configcheck_configinc"] = 'Konfigurationsfilen r fortfarande skrivbar';
$_lang["configcheck_configinc_msg"] = 'Elaka mnniskor kan orsaka stora skador p din webbplats och allt som hr till den. <strong>P riktigt.</strong> Se till att konfigurationsfilen (/manager/includes/config.inc.php) blir skrivskyddad!';
$_lang["configcheck_default_msg"] = 'En ospecificerad varning hittades, vilket r konstigt.';
$_lang["configcheck_errorpage_unavailable"] = 'Felsidan fr din webbplats r inte tillgnglig.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Detta betyder att din felsida inte r tillgnglig fr vanliga anvndare eller att den inte existerar. Det hr kan leda till att ett tillstnd med upprepande loopar skapas och ger upphov till att mnga fel rapporteras i webbplatsens loggar. Kontrollera att inga webbanvndargrupper r anslutna till sidan.';
$_lang["configcheck_errorpage_unpublished"] = 'Felsidan fr din webbplats r inte publicerad eller existerar inte.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Detta betyder att din felsida inte r tillgnglig fr allmnheten. Publicera sidan eller kontrollera under Verktyg &gt; Konfiguration att den angivna sidan r en existerande resurs i webbplatsens resurstrd.';
$_lang["configcheck_images"] = 'Bildkatalogen r inte skrivbar';
$_lang["configcheck_images_msg"] = 'Bildkatalogen r inte skrivbar eller finns inte. Detta betyder att bildhanteringsfunktionerna i editorn inte kommer att fungera!';
$_lang["configcheck_installer"] = 'Installationsprogrammet r fortfarande kvar';
$_lang["configcheck_installer_msg"] = 'Katalogen /install innehller installationsprogrammet fr MODx. Tnk vad som kan hnda om en elaka mnniskor hittar katalogen och kr installationen! De kommer frhoppningsvis inte s lngt, eftersom databasen krver inloggningsuppgifter, men det r nd bst att ta bort katalogen frn servern.';
$_lang["configcheck_lang_difference"] = 'Fel antal fraser i sprkfilen';
$_lang["configcheck_lang_difference_msg"] = 'Sprket som fr nrvarande r valt har ett annat antal fraser n standardsprket. Detta behver inte vara ett problem, men kan betyda att sprkfilen behver uppdateras.';
$_lang["configcheck_notok"] = 'En eller flera konfigurationsdetaljer r inte korrekta:';
$_lang["configcheck_ok"] = 'Kontrollen utfrd OK - inga varningar att rapportera.';
$_lang["configcheck_php_gdzip"] = 'GD och/eller Zip PHP-tillgg kunde inte hittas';
$_lang["configcheck_php_gdzip_msg"] = 'MODx behver tillggen GD och Zip aktiverade fr PHP. ven om MODx kommer att fungera utan dom, s kommer du inte att kunna utnyttja alla mjligheterna i den inbyggda filhanteraren, bildredigeraren eller captcha fr inloggningar.';
$_lang["configcheck_register_globals"] = 'register_globals r satt till ON i din konfigurationsfil fr php - php.ini';
$_lang["configcheck_register_globals_msg"] = 'Denna konfiguration gr din webbplats betydligt mer srbar fr s kallade serververskridande scriptattacker (Cross Site Scripting eller XSS). Du br ta kontakt med din webbhost och ta reda p vad du kan gra fr att stnga av den hr instllningen.';
$_lang["configcheck_title"] = 'Konfigurationskontroll';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Din webbplats otillten-sida r inte publicerad eller existerar inte.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Detta betyder att din webbplats otillten-sida inte r tillgnglig fr vanliga anvndare eller att den inte existerar. Det hr kan leda till att ett tillstnd med upprepande loopar skapas och ger upphov till att mnga fel rapporteras i webbplatsens loggar. Kontrollera att inga webbanvndargrupper r knutna till sidan.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'Den otillten-sida som angetts i instllningarna r inte publicerad.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Detta betyder att din otillten-sida r otkomlig fr allmnheten. Publicera sidan eller kontrollera under Verktyg &gt; Konfiguration att den angivna sidan r en existerande resurs i webbplatsens resurstrd.';
$_lang["configcheck_validate_referer"] = 'Skerhetsvarning: validering av HTTP-header';
$_lang["configcheck_validate_referer_msg"] = "Konfigurationsinstllningen <strong>Kontrollera HTTP_REFERER-headers?</strong> r inaktiverad. Vi rekommenderar att den aktiveras. <a href=\"index.php?a=17\">G till konfigurationssidan</a><br /><a href=\"javascript:hideHeaderVerificationWarning();\"><em>Visa inte det hr igen.</em></a>";
$_lang["configcheck_warning"] = 'Konfigurationsvarning: ';
$_lang["configcheck_what"] = 'Vad betyder det hr?';
$_lang["confirm_block"] = 'r du sker p att du vill blockera denna anvndare?';
$_lang["confirm_delete_eventlog"] = 'r du sker p att du vill ta bort den hr hndelseloggen?';
$_lang["confirm_delete_file"] = 'r du sker p att du vill ta bort filen?\n\nDetta kan gra att din webbplats slutar fungera! Ta endast bort denna fil om du vet skert att du inte frstr ngot.';
$_lang["confirm_delete_htmlsnippet"] = 'r du sker p att du vill ta bort denna chunk?';
$_lang["confirm_delete_keywords"] = 'r du sker p att du vill ta bort dessa nyckelord?';
$_lang["confirm_delete_module"] = 'r du sker p att du vill ta bort den hr modulen?';
$_lang["confirm_delete_plugin"] = 'r du sker p att du vill ta bort denna plugin?';
$_lang["confirm_delete_record"] = 'r du sker p att du vill ta bort de valda posterna?';
$_lang["confirm_delete_resource"] = 'r du sker p att du vill ta bort denna resurs?\nEventuella underresurser kommer ocks att tas bort.';
$_lang["confirm_delete_role"] = 'r du sker p att du vill ta bort denna roll?';
$_lang["confirm_delete_snippet"] = 'r du sker p att du vill ta bort denna snippet?';
$_lang["confirm_delete_tags"] = 'r du sker p att du vill ta bort de valda META-taggarna?';
$_lang["confirm_delete_template"] = 'Vill du verkligen ta bort denna mall?';
$_lang["confirm_delete_tmplvars"] = 'r du sker p att du vill ta bort denna mallvariabel och alla dess lagrade vrden?';
$_lang["confirm_delete_user"] = 'Vill du verkligen ta bort denna anvndare?';
$_lang["confirm_duplicate_record"] = 'r du sker p att du vill duplicera denna post?';
$_lang["confirm_empty_trash"] = 'Detta kommer att permanent radera ALLA borttagna resurser!\n\nFortstt?';
$_lang["confirm_load_depends"] = 'r du sker p att du vill ladda skrmen "Hantera beroenden" utan att spara dina ndringar?';
$_lang["confirm_name_change"] = 'ndring av anvndarnamnet kan pverka andra program som r lnkade till innehllshanteraren.\n\n r du sker p att du vill ndra detta anvndarnamn?';
$_lang["confirm_publish"] = '\n\nOm du publicerar denna resurs nu, kommer alla eventuella (av)publiceringsdatum att tas bort. Om du vill behlla eller ndra (av)publiceringsdatum, vlj att redigera resursen istllet.\n\nFortstt?';
$_lang["confirm_remove_locks"] = 'Ibland stnger anvndare sin webblsare medan de redigerar resurser, mallar, snippets eller tolkar, vilket kan lmna resursen i frga i ett lst tillstnd. Genom att trycka OK, tar du bort ALLA nuvarande lsningar.\n\nFortstt?';
$_lang["confirm_resource_duplicate"] = 'r du sker p att du vill duplicera denna resurs?\nEventuella underresurser som den innehller kommer ocks att dupliceras.';
$_lang["confirm_setting_language_change"] = 'Du har modifierat standardvrdet och kommer att frlora ndringarna. Fortstt?';
$_lang["confirm_unblock"] = 'r du sker p att du vill avblockera denna anvndare?';
$_lang["confirm_undelete"] = '\n\nEventuella underresurser som togs bort samtidigt som denna resurs kommer ocks att terstllas, men underresurser som tagits bort tidigare kommer fortfarande att vara borttagna.';
$_lang["confirm_unpublish"] = '\n\nOm du avpublicerar denna resurs nu, kommer alla eventuella (av)publiceringsdatum att tas bort. Om du vill behlla eller ndra (av)publiceringsdatum, vlj att redigera resursen istllet.\n\nFortstt?';
$_lang["confirm_unzip_file"] = 'r du sker p att du vill zippa upp denna fil?\n\nExisterande filer kommer att skrivas ver.';
$_lang["could_not_find_user"] = 'Kunde inte hitta anvndaren';
$_lang["create_folder_here"] = 'Skapa behllare hr';
$_lang["create_resource_here"] = 'Skapa resurs hr';
$_lang["create_resource_title"] = 'Skapa resurs';
$_lang["create_weblink_here"] = 'Skapa webblnk hr';
$_lang["createdon"] = 'Skapat datum';
$_lang["credits"] = 'Erknnanden';
$_lang["credits_shouts_msg"] = '<p>MODx frvaltas och underhlls p <a href="http://modxcms.com/about/" target="_blank">MODxCMS.com</a>.</p>';
$_lang["custom_contenttype_message"] = 'Lgg till egna innehllstyper fr resurser. Skriv in innehllstypen i det vre fltet och klicka p "Lgg till" fr att lgga till en ny. Markera den innehllstyp som du vill ta bort i det nedre fltet och klicka p "Ta bort".';
$_lang["custom_contenttype_title"] = 'Egna innehllstyper';
$_lang["database_charset"] = 'Databasens teckenuppsttning';
$_lang["database_collation"] = 'Databasens kollationering';
$_lang["database_name"] = 'Databasens namn'; 
$_lang["database_overhead"] = '<b style="color:#990033;">Notera:</b><br />"Overhead" r oanvnt utrymme reserverat av MySQL. Klicka p ett overhead-belopp fr att frigra utrymmet.';
$_lang["database_server"] = 'Databasens server';
$_lang["database_table_clickbackup"] = 'fr att skerhetskopiera och ladda ner de valda tabellerna.';
$_lang["database_table_clickhere"] = 'Klicka hr';
$_lang["database_table_datasize"] = 'Datastorlek';
$_lang["database_table_droptablestatements"] = 'Generera DROP TABLE kommando.';
$_lang["database_table_effectivesize"] = 'Effektiv storlek';
$_lang["database_table_indexsize"] = 'Indexstorlek';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Poster';
$_lang["database_table_tablename"] = 'Tabellnamn';
$_lang["database_table_totals"] = 'Totalt:';
$_lang["database_table_totalsize"] = 'Total storlek';
$_lang["database_tables"] = 'Databasens tabeller';
$_lang["database_version"] = 'Databasversion';
$_lang["date"] = 'Datum';
$_lang["datechanged"] = 'ndrat datum';
$_lang["datepicker_offset"] = 'Datumvljarens tidsfrskjutning';
$_lang["datepicker_offset_message"] = 'Antal r som visas bakt i tiden i datumvljaren.';
$_lang["datetime_format"] = 'Datumformat';
$_lang["datetime_format_message"] = 'Formatet fr datum i hanteraren.';
$_lang["default"] = 'Standard:';
$_lang["defaultcache_message"] = 'Vlj "Ja" fr att gra alla nya resurser cachebara som standard.';
$_lang["defaultcache_title"] = 'Cachebara som standard';
$_lang["defaultmenuindex_message"] = 'Vlj "Ja" fr att aktivera automatisk kning av menyindex som standard.';
$_lang["defaultmenuindex_title"] = 'Standardvrde fr menyindexering';
$_lang["defaultpublish_message"] = 'Vlj "Ja" fr att gra alla nya resurser publicerade som standard.';
$_lang["defaultpublish_title"] = 'Publicerade som standard';
$_lang["defaultsearch_message"] = 'Vlj "Ja" fr att gra alla nya resurser skbara som standard.';
$_lang["defaultsearch_title"] = 'Skbara som standard';
$_lang["defaulttemplate_message"] = 'Vlj den standarmall du vill anvnda fr nya resurser. Du kan fortfarande vlja en annan mall nr du redigerar resursen. Denna instllning r bara den frvalda.';
$_lang["defaulttemplate_title"] = 'Standardmall';
$_lang["delete"] = 'Ta bort';
$_lang["delete_resource"] = 'Ta bort resurs';
$_lang["delete_tags"] = 'Ta bort taggar';
$_lang["deleting_file"] = 'Tar bort filen `%s`: ';
$_lang["description"] = 'Beskrivning';
$_lang["deselect_keywords"] = 'Rensa nyckelord';
$_lang["deselect_metatags"] = 'Rensa META-taggar';
$_lang["disabled"] = 'Avstngd';
$_lang["doc_data_title"] = 'Visa resursdata';
$_lang["duplicate"] = 'Duplicera';
$_lang["duplicate_alias_found"] = 'Resursen "%s" anvnder redan URL-aliaset "%s". Ange ett unikt URL-alias.';
$_lang["duplicate_alias_message"] = 'Vlj "Ja" fr att tillta att dubletter p URL-alias sparas.<br /><b>Notera: Den hr instllningen br anvndas med "Vnliga URL-aliasskvgar" satt till "Ja" fr att undvika problem med refereringen av resurser.</b>';
$_lang["duplicate_alias_title"] = 'Tillt dubletter p URL-alias';
$_lang["duplicate_name_found_general"] = 'Det finns redan en %s som heter "%s". Ange ett unikt namn.';
$_lang["duplicate_name_found_module"] = 'Det finns redan en modul som heter "%s". Ange ett unikt namn.';
$_lang["edit"] = 'Redigera';
$_lang["edit_resource"] = 'Redigera resurs';
$_lang["edit_resource_title"] = 'Redigera resurs';
$_lang["edit_settings"] = 'Konfiguration';
$_lang["editedon"] = 'Redigerat datum';
$_lang["editing_file"] = 'Redigerar fil: ';
$_lang["editor_css_path_message"] = 'Skriv in skvgen till den CSS-fil du vill anvnda i editorn. Det bsta sttet att ange skvgen r att gra det frn serverns rot, tex /assets/site/style.css. Lmna fltet tomt om du inte vill ladda en stilmall i editorn.';
$_lang["editor_css_path_title"] = 'Skvg till CSS-fil';
$_lang["element"] = 'Element';
$_lang["element_categories"] = 'Kombinerad vy';
$_lang["element_management"] = 'Hantera element';
$_lang["element_name"] = 'Elementnamn';
$_lang["element_selector_msg"] = 'Vlj element i nedanstende lista och klicka p "Lgg till".';
$_lang["element_selector_title"] = 'Elementvljare';
$_lang["elements"] = 'Element';
$_lang["email"] = 'E-post';
$_lang["email_sent"] = 'E-post skickad';
$_lang["emailsender_message"] = 'Ange den e-postadress som anvnds fr att skicka anvndarnamn och lsenord till en anvndare.';
$_lang["emailsender_title"] = 'E-postadress';
$_lang["emailsubject_default"] = 'Dina inloggningsuppgifter';
$_lang["emailsubject_message"] = 'Ange mnet fr e-posten som skickas vid registrering.';
$_lang["emailsubject_title"] = 'mne fr e-post';
$_lang["empty_folder"] = 'Denna behllare r tom';
$_lang["empty_recycle_bin"] = 'Radera borttagna resurser';
$_lang["empty_recycle_bin_empty"] = 'Det finns inga borttagna resurser att radera.';
$_lang["enable_resource"] = 'Anvnd elementfil.';
$_lang["enable_sharedparams"] = 'Anvnd parameterdelning';
$_lang["enable_sharedparams_msg"] = '<b>Notera:</b> Ovanstende globalt unika ID (GUID) kommer att anvndas fr att unikt identifiera denna modul och dess delade parametrar. GUID:t anvnds ocks fr att lnka mellan modulen och de plugins eller snippets som anvnder dess delade parametrar.';
$_lang["enabled"] = 'Aktiverad';
$_lang["error"] = 'Fel';
$_lang["error_sending_email"] = 'Fel vid utskick av e-post';
$_lang["errorpage_message"] = 'Ange ID till en publicerad och offentlig resurs som anvndare kan omdirigeras till nr de frsker n en resurs som inte existerar.';
$_lang["errorpage_title"] = 'Felsida';
$_lang["event_id"] = 'Hndelse-ID';
$_lang["eventlog"] = 'Hndelselogg';
$_lang["eventlog_msg"] = 'Hndelseloggen anvnds fr att visa informations-, varnings- och felmeddelanden genererade av innehllshanteraren. Kllkolumnen visar i vilken del av informationshanteraren hndelsen intrffade.';
$_lang["eventlog_viewer"] = 'Systemhndelser';
$_lang["everybody"] = 'Alla';
$_lang["existing_category"] = 'Existerande kategori';
$_lang["expand_tree"] = 'Veckla ut webbplatstrd';
$_lang["export_site"] = 'Exportera statisk HTML';
$_lang["export_site_cacheable"] = 'Inkludera&nbsp;icke<br />cachebara&nbsp;filer';
$_lang["export_site_exporting_document"] = 'Exporterar fil <b>%s</b> av <b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = 'Misslyckades!';
$_lang["export_site_failed_no_open"] = 'Kan inte ppna fil: ';
$_lang["export_site_failed_no_retrieve"] = 'Kan inte hmta dokument.';
$_lang["export_site_failed_no_write"] = 'Kan inte skriva fil.';
$_lang["export_site_html"] = 'Exportera webbplatsen till HTML';
$_lang["export_site_maxtime"] = 'Max exporttid';
$_lang["export_site_maxtime_message"] = 'Ange hur mnga sekunder MODx har p sig fr att exportera webbplatsen (sidostter PHPs instllningar). Skriv 0 fr obegrnsad tid. Notera att om 0 eller ett vldigt hgt nummer anges, kan det f din server att gra konstiga saker och rekommenderas drfr inte.';
$_lang["export_site_message"] = '<p>Anvnd denna funktion fr att exportera hela webbplatsen till statiska HTML-filer. Kom ihg att du frlorar stora delar av funktionaliteten i MODx om du gr det:</p><ul><li>Sidlsningar p exporterade filer kommer inte att lagras.</li><li>Interaktiva snippets kommer inte att fungera i exporterade filer</li><li>Endast vanliga resurser kommer att exporteras. Webblnkar blir allts inte exporterade.</li><li>Exportprocessen kan misslyckas om dina resurser innehller snippets som skickar omdirigeringsanvisningar.</li><li>Beroende p hur du skrivit dina resurser, kan bilder och stilmallar f fel skvgar. Fixa det hr genom att spara eller flytta dina exporterade filer till samma katalog som index.php fr MODx befinner sig i.</li></ul><p>Fyll i formulret och tryck p "Starta export" fr att starta exportprocessen. Filerna som skapas kommer att sparas i katalogen assets/export, och nr det r mjligt, anvnds resursens URL-alias som filnamn. Nr du ska exporterar din webbplats r det bst att ha MODx  konfigurationsinstllning "Vnliga URL-alias" satt till "Ja". Beroende p storleken p din webbplats, kan exporten ta en del tid.</p><p><em>Redan existerande filer kommer att skrivas ver om de har samma namn som en exporterad fil!</em></p>';
$_lang["export_site_numberdocs"] = '<p><b>Hittade %s resurser att exportera...</b></p>';
$_lang["export_site_prefix"] = 'Filprefix';
$_lang["export_site_start"] = 'Starta export';
$_lang["export_site_success"] = 'Klart!';
$_lang["export_site_success_skip_dir"] = 'Hoppa ver denna katalog.';
$_lang["export_site_success_skip_doc"] = 'Hoppa ver detta dokument.';
$_lang["export_site_suffix"] = 'Filsuffix';
$_lang["export_site_target_unwritable"] = 'Mlkatalogen r inte skrivbar. Se till att katalogen r skrivbar och frsk igen.';
$_lang["export_site_time"] = 'Exporten r klar. Den tog %s sekunder att gra.';
$_lang["failed_login_message"] = 'Ange hur mnga misslyckade inloggningsfrsk som r tilltna innan anvndaren blockeras.';
$_lang["failed_login_title"] = 'Misslyckade inloggningsfrsk';
$_lang["fe_editor_lang_message"] = 'Hr kan du ange sprk fr editorn som anvnds.';
$_lang["fe_editor_lang_title"] = 'Editorns sprk';
$_lang["file_delete_file"] = 'Ta bort fil';
$_lang["file_delete_folder"] = 'Ta bort katalog';
$_lang["file_deleted"] = 'Klart!';
$_lang["file_download_file"] = 'Ladda ner fil';
$_lang["file_download_unzip"] = 'Zippa upp fil';
$_lang["file_folder_chmod_error"] = 'Kunde inte ndra behrigheterna. Du mste sjlv ndra behrigheterna utanfr MODx.';
$_lang["file_folder_created"] = 'Katalog skapad!';
$_lang["file_folder_deleted"] = 'Katalogen togs bort!';
$_lang["file_folder_not_created"] = 'Kunde inte skapa katalog';
$_lang["file_folder_not_deleted"] = 'Kunde inte ta bort katalogen. Se till att den r tom innan borttagning sker.';
$_lang["file_not_deleted"] = 'Misslyckades!';
$_lang["file_not_saved"] = 'Kan inte spara filen. Kontrollera att mlkatalogen r skrivbar!';
$_lang["file_saved"] = 'Filen uppdaterades utan problem!';
$_lang["file_unzip"] = 'Uppzippningen klar!';
$_lang["file_unzip_fail"] = 'Uppzippningen misslyckades!';
$_lang["filemanager_path_message"] = 'IIS fyller oftast inte i instllningarna fr document_root ordentligt, vilket anvnds av filhanteraren fr att bestmma vad du kan se. Om du har problem med filhanteraren, se till s att denna skvg pekar till roten p din MODx-installation.';
$_lang["filemanager_path_title"] = 'Skvg till filhanteraren';
$_lang["files_access_denied"] = 'tkomst nekad!';
$_lang["files_data"] = 'Data';
$_lang["files_dir_listing"] = 'Kataloglista fr:';
$_lang["files_directories"] = 'Kataloger';
$_lang["files_dirwritable"] = 'r katalogen skrivbar?';
$_lang["files_editfile"] = 'Redigera fil';
$_lang["files_file_type"] = 'Filtyp: ';
$_lang["files_filename"] = 'Filnamn';
$_lang["files_fileoptions"] = 'Alternativ';
$_lang["files_files"] = 'Filer';
$_lang["files_filesize"] = 'Filstorlek';
$_lang["files_filetype_notok"] = 'Det r inte tilltet att ladda upp en fil av den hr typen!';
$_lang["files_modified"] = 'ndrad';
$_lang["files_top_level"] = 'Till toppnivn';
$_lang["files_up_level"] = 'Upp en niv';
$_lang["files_upload_copyfailed"] = 'Kunde inte kopiera filen till mlkatalogen - uppladdningen misslyckades!';
$_lang["files_upload_error"] = 'Fel';
$_lang["files_upload_error0"] = 'Ett fel uppstod med din uppladdning.';
$_lang["files_upload_error1"] = 'Filen du frsker ladda upp r fr stor.';
$_lang["files_upload_error2"] = 'Filen du frsker ladda upp r fr stor.';
$_lang["files_upload_error3"] = 'Filen du frsker ladda upp blev endast delvis uppladdad.';
$_lang["files_upload_error4"] = 'Du mste vlja en fil att ladda upp.';
$_lang["files_upload_error5"] = 'Ett fel intrffade vid din uppladdning.';
$_lang["files_upload_inhibited_msg"] = '<b>Uppladdning nekad</b> - se till att uppladdningar stds och att PHP har skrivrttigheter i den aktuella katalogen.';
$_lang["files_upload_ok"] = 'Filen laddades upp!';
$_lang["files_upload_permissions_error"] = 'Mjligt behrighetsproblem - den katalog som du vill ladda upp till behver vara skrivbar fr din webbserver.';
$_lang["files_uploadfile"] = 'Ladda upp fil';
$_lang["files_uploadfile_msg"] = 'Vlj en fil att ladda upp:';
$_lang["files_uploading"] = 'Laddar upp <b>%s</b> till <b>%s/</b>';
$_lang["files_viewfile"] = 'Visa fil';
$_lang["folder"] = 'Mapp';
$_lang["forgot_password_email_fine_print"] = '* URL:en ovan upphr att fungera nr du ndrat ditt lsenord eller nr denna dag r slut.';
$_lang["forgot_password_email_instructions"] = 'Hrifrn kommer du att kunna ndra ditt lsenord via menyn Mitt konto.';
$_lang["forgot_password_email_intro"] = 'En frfrgan om att ndra ditt kontos lsenord har gjorts.';
$_lang["forgot_password_email_link"] = 'Klicka hr fr att fullborda processen.';
$_lang["forgot_your_password"] = 'Glmt ditt lsenord?';
$_lang["friday"] = 'Fredag';
$_lang["friendly_alias_message"] = 'Om vnliga URL:er aktiveras kommer resursens URL-alias att anvndas istllet fr resursens ID. Det betyder att en resurs med ID 1 som har URL-aliaset "introduktion", inget prefix (tomt) och suffixet satt till ".html" vid en aktivering av vnliga URL:er kommer att f adressen "introduktion.html". Om det inte finns ngot URL-alias, kommer MODx att generera adressen "1.html".';
$_lang["friendly_alias_title"] = 'Anvnd vnliga URL-alias';
$_lang["friendlyurls_message"] = 'Anvnd skmotorvnliga adesser p Apache-webbservrar med mod_rewrite eller p IIS-servrar med plugins frn tredje part. Fr mer information, se .htaccess-filen placerad i webbplatsens rot som fljde med i distributionen.';
$_lang["friendlyurls_title"] = 'Anvnd vnliga URL:er';
$_lang["friendlyurlsprefix_message"] = 'Om prefixet "sida" anges, kommer adressen /index.php?id=2 att omvandlas till URL-aliaset "sida2.html" (om suffixet r satt till .html).';
$_lang["friendlyurlsprefix_title"] = 'Prefix fr vnliga URL:er';
$_lang["friendlyurlsuffix_message"] = 'Vilket suffix som helst, ven ett tomt, kommer att fungera. Om du anger ".aspx" kommer .aspx att lggas till i slutet av alla URL-alias.';
$_lang["friendlyurlsuffix_title"] = 'Suffix fr vnliga URL:er';
$_lang["functionnotimpl"] = 'Urskta!';
$_lang["functionnotimpl_message"] = 'Denna funktion har inte implementerats n.';
$_lang["go"] = 'Utfr';
$_lang["group_access_permissions"] = 'Anvndargruppstkomst';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Hjlp';
$_lang["help_msg"] = '<p>Besk <a href="http://modxcms.com/forums/" target="_blank">MODx Forum</a> om du behver hjlp med MODx. Det finns ocks en vxande mngd <a href="http://modxcms.com/documentation" target="blank">dokumentation och guider</a> som berr i stort sett alla aspekter av MODx.</p><p>Vi planerar ocks att erbjuda kommersiella supporttjnster. Snd oss ett <a href="mailto:hello@modxcms.com?subject=MODx Commercial Support Inquiry">e-postmeddelande om du r intresserad</a>.</p>';
$_lang["help_title"] = 'Hjlp';
$_lang["hide_tree"] = 'Dlj webbplatstrd';
$_lang["home"] = 'Hem';
$_lang["htmlsnippet_desc"] = 'Beskrivning';
$_lang["htmlsnippet_management_msg"] = 'Skapa nya chunks eller vlja en redan befintlig fr redigering.';
$_lang["htmlsnippet_msg"] = 'Skapa och redigera chunks. Kom ihg att chunks r "r" HTML-kod, s ingen PHP-kod kommer att tolkas.';
$_lang["htmlsnippet_name"] = 'Chunknamn';
$_lang["htmlsnippet_title"] = 'Skapa/redigera chunk';
$_lang["icon"] = 'Ikon';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Frldraval:\n\nResursen r ett barn till den valda resursen.';
$_lang["illegal_parent_self"] = 'Frldraval:\n\nDen valda resursen kan inte bli tilldelad sig sjlv.';
$_lang["import_files_found"] = '<b>Hittade %s resurser fr import...</b>';
$_lang["import_params"] = 'Importera en moduls delade parametrar';
$_lang["import_params_msg"] = 'Du kan importera parametrarna eller instllningarna frn en modul genom att vlja modulens namn i ovanstende meny.<br /><b>Notera:</b> Fr att moduler ska synas i menyn mste denna plugin/snippet vara med i modulens beroendelista och modulen mste vara instlld fr parameterdelning.';
$_lang["import_parent_resource"] = 'Frldraresurs';
$_lang["import_site"] = 'Importera HTML';
$_lang["import_site_failed"] = 'Misslyckades!';
$_lang["import_site_failed_db_error"] = 'Ett databasfel intrffade nr resursen skulle klonas: ';
$_lang["import_site_failed_no_open_dir"] = 'Kunde inte ppna katalog: ';
$_lang["import_site_failed_no_retrieve_file"] = 'Kunde inte hmta fil: ';
$_lang["import_site_html"] = 'Importera webbplats frn HTML';
$_lang["import_site_importing_document"] = 'Importerar fil <b>%s</b> ';
$_lang["import_site_maxtime"] = 'Max importtid';
$_lang["import_site_maxtime_message"] = 'Ange hur mnga sekunder som innehllshanteraren fr ta i ansprk nr den importerar webbplatsen (sidostter PHPs instllningar). Skriv 0 fr obegrnsad tid. Notera att om 0 eller ett vldigt stort nummer anges, kan det f din server att gra konstiga saker och rekommenderas drfr inte.';
$_lang["import_site_message"] = '<p>Importera en hel HTML-webbplats till din webbplats databas. Notera att du mste kopiera dina html-filer och kataloger till katalogen assets/import.</p><p>Fyll i formulret och klicka p "Starta import" fr att starta importprocessen. Filerna som importeras kommer att sparas till den valda platsen, och dr det r mjligt kommer filnamnet att anvndas som resursens URL-alias, och title-elementet som resursens titel.';
$_lang["import_site_skip"] = 'verhoppad!';
$_lang["import_site_start"] = 'Starta import';
$_lang["import_site_success"] = 'Klart!';
$_lang["import_site_time"] = 'Importen r klar. Den tog %s sekunder att gra.';
$_lang["inbox"] = 'Inkorg';
$_lang["info"] = 'Information';
$_lang["information"] = 'Information';
$_lang["inline"] = 'Inline';
$_lang["insert"] = 'Infoga';
$_lang["keyword"] = 'Nyckelord';
$_lang["keywords"] = 'Nyckelord';
$_lang["keywords_intro"] = 'Fr att ndra ett nyckelord skriver du helt enkelt in det nya nyckelordet i fltet bredvid nyckelordet du vill ndra. Bocka fr "Ta bort" fr det nyckelord du vill ta bort. Om du bockar fr "Ta bort" och dessutom ndrar nyckelordets namn, s kommer namnndringen inte att ske eftersom nyckelordet tas bort!';
$_lang["language_message"] = 'Vlj vilket sprket du vill anvnda i MODx innehllshanterare.';
$_lang["language_title"] = 'Sprk';
$_lang["launch_site"] = 'Visa webbplatsen';
$_lang["link_attributes"] = 'Lnkattribut';
$_lang["link_attributes_help"] = 'Ange frivilliga attribut fr en lnk till denna sida, t.ex. target=&quot;_blank&quot; eller rel=&quot;external&quot;.';
$_lang["list_mode"] = 'Stt p/av listlget - anvnds fr att lista alla poster i tabellen.';
$_lang["loading_doc_tree"] = 'Laddar webbplatstrd...';
$_lang["loading_menu"] = 'Laddar meny...';
$_lang["loading_page"] = 'Vnta medan MODx laddar sidan...';
$_lang["localtime"] = 'Lokal tid';
$_lang["lock_htmlsnippet"] = 'Ls chunk fr redigering';
$_lang["lock_htmlsnippet_msg"] = 'Endast administratrer (roll-ID 1) kan redigera denna chunk.';
$_lang["lock_module"] = 'Ls modulen fr redigering';
$_lang["lock_module_msg"] = 'Endast administratrer (roll-ID 1) kan redigera denna modul.';
$_lang["lock_msg"] = '%s redigerar just nu den/det hr %s. Vnta tills den anvndaren r klar och frsk sedan igen.';
$_lang["lock_plugin"] = 'Ls plugin fr redigering';
$_lang["lock_plugin_msg"] = 'Endast administratrer (roll-ID 1) kan redigera denna plugin.';
$_lang["lock_settings_msg"] = '%s redigerar just nu de hr instllningarna. Vnta tills den anvndaren r klar och frsk sedan igen.';
$_lang["lock_snippet"] = 'Ls snippeten fr redigering';
$_lang["lock_snippet_msg"] = 'Endast administratrer (roll-ID 1) kan redigera denna snippet.';
$_lang["lock_template"] = 'Ls mall fr redigering';
$_lang["lock_template_msg"] = 'Endast administratrer (roll-ID 1) kan redigera denna mall.';
$_lang["lock_tmplvars"] = 'Ls mallvariabel fr redigering';
$_lang["lock_tmplvars_msg"] = 'Endast administratrer (roll-ID 1) kan redigera denna mallvariabel.';
$_lang["locked"] = 'Lst';
$_lang["login_allowed_days"] = 'Tilltna dagar';
$_lang["login_allowed_days_message"] = 'Vlj de dagar som den hr anvndaren fr logga in.';
$_lang["login_allowed_ip"] = 'Tillten IP-adress';
$_lang["login_allowed_ip_message"] = 'Ange de IP-adresser som den hr anvndaren fr logga in frn.<br /><b>Notera: Separera flera IP-adresser med kommatecken (,).</b>';
$_lang["login_button"] = 'Logga in';
$_lang["login_cancelled_install_in_progress"] = 'Installation/uppdatering av den hr webbplatsen pgr. Frsk igen om ett par minuter!';
$_lang["login_cancelled_site_was_updated"] = 'Installationen/uppdateringen av den hr webbplatsen r klar. Nu kan du logga in igen!';
$_lang["login_captcha_message"] = 'Skriv in skerhetskoden som visas i bilden. Om du har problem att lsa koden, s kan du klicka p bilden fr att generera en ny kod eller kontakta webbplatsens administratr.';
$_lang["login_homepage"] = 'Startsida efter inloggning';
$_lang["login_homepage_message"] = 'Ange ID till den resurs du vill skicka anvndaren till efter den har loggat in.<br /><b>OBS: Se till att det ID du anger tillhr en existerande resurs, att den har blivit publicerad och kan kommas t av anvndaren!</b>';
$_lang["login_message"] = 'Fyll i dina inloggningsuppgifter fr att starta din session. Det r skillnad mellan stora och sm bokstver i ditt anvndarnamn och lsenord.';
$_lang["logo_slogan"] = 'Skapa och gr mer med mindre - \nMODx innehllshanterare';
$_lang["logout"] = 'Logga ut';
$_lang["long_title"] = 'Lng titel';
$_lang["mail_check_timeperiod_message"] = 'Anger, i sekunder, hur ofta systemet kontrollerar om ny e-post inkommit till hanteraren.';
$_lang["mail_check_timeperiod_title"] = 'Periodicitet fr kontroll av inkorg';
$_lang["manage_depends"] = 'Hantera beroenden';
$_lang["manage_files"] = 'Hantera filer';
$_lang["manage_htmlsnippets"] = 'Chunks';
$_lang["manage_metatags"] = 'Hantera META-taggar och nyckelord';
$_lang["manage_modules"] = 'Hantera moduler';
$_lang["manage_plugins"] = 'Plugins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Mallar';
$_lang["manager"] = 'Hanterare';
$_lang["manager_lockout_message"] = 'Du r fr nrvarande inloggad i innehllshanteraren. Klicka p "Logga ut" om du vill stnga din session. <p />Klicka p "Hem"-knappen om du vill g till din start- eller hemsida.';
$_lang["manager_permissions"] = 'Rttigheter fr hanteraren';
$_lang["manager_theme"] = 'Tema fr hanteraren';
$_lang["manager_theme_message"] = 'Vlj tema fr innehllshanteraren.';
$_lang["messages"] = 'Meddelanden';
$_lang["messages_all"] = 'Alla';
$_lang["messages_compose"] = 'Skapa ett meddelande';
$_lang["messages_forward"] = 'Vidarebefordra';
$_lang["messages_from"] = 'Frn';
$_lang["messages_group"] = 'En grupp';
$_lang["messages_inbox"] = 'Inkorg';
$_lang["messages_message"] = 'Meddelande';
$_lang["messages_no_messages"] = 'Inga meddelanden i Inkorgen.';
$_lang["messages_not_allowed_to_read"] = 'Du har inte behrighet att lsa detta meddelande!';
$_lang["messages_private"] = 'Privat';
$_lang["messages_read_message"] = 'Ls meddelande';
$_lang["messages_reply"] = 'Svara';
$_lang["messages_select_group"] = 'Vlj en grupp';
$_lang["messages_select_user"] = 'Vlj en anvndare';
$_lang["messages_send"] = 'Skicka';
$_lang["messages_send_to"] = 'Skicka till';
$_lang["messages_sent"] = 'Skickat';
$_lang["messages_subject"] = 'mne';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'Meddelanden';
$_lang["messages_user"] = 'En anvndare';
$_lang["meta_keywords"] = 'META-nyckelord';
$_lang["metatag_intro"] = 'P den hr sidan kan du skapa, redigera eller ta bort META-taggar. Fr att lnka META-taggar till resurser klickar du p fliken fr META-nyckelord nr du redigerar resursen och vljer de nskade META-taggarna och nyckelorden. Om du vill lgga in en ny tagg skriver du in namnet och vrdet och klickar p "Lgg till tagg". Klicka p taggens namn i tabellen fr att redigera den.';
$_lang["metatag_notice"] = 'Anvnd <a href="http://www.html-reference.com/META.asp" target="_blank">HTML-referensguiden</a> fr att f mer information. Det hr r inte en komplett lista med mjliga META-taggar.';
$_lang["metatags"] = 'META-taggar';
$_lang["mgr_access_permissions"] = 'tkomstrttigheter i hanteraren';
$_lang["mgr_login_start"] = 'Startsida efter inloggning i hanteraren';
$_lang["mgr_login_start_message"] = 'Ange ID fr den resurs du vill att anvndaren ska komma till nr den loggat in i hanteraren.<br /><b>Notera: Kontrollera att det ID du valt hr till en existerande resurs, att den r publicerad och att anvndaren har behrighet fr den!</b>';
$_lang["mgrlog_action"] = 'Hndelse';
$_lang["mgrlog_actionid"] = 'Hndelse-ID';
$_lang["mgrlog_anyall"] = 'Alla';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() returnerade false.';
$_lang["mgrlog_datefr"] = 'Datum fr o m';
$_lang["mgrlog_dateinvalid"] = 'Ogiltigt datumformat.';
$_lang["mgrlog_dateto"] = 'Datum t o m';
$_lang["mgrlog_emptysrch"] = 'Din skning gav inga trffar (dvs inga matchande loggdata hittades).';
$_lang["mgrlog_field"] = 'Flt';
$_lang["mgrlog_itemid"] = 'Objekt-ID';
$_lang["mgrlog_itemname"] = 'Objektnamn';
$_lang["mgrlog_msg"] = 'Meddelande';
$_lang["mgrlog_noquery"] = 'Du har inte angivit ngon skfras.';
$_lang["mgrlog_qresults"] = 'Skresultat';
$_lang["mgrlog_query"] = 'Sk i loggen';
$_lang["mgrlog_query_msg"] = 'Vlj ut vad du vill lsa i loggen. Du kan vlja loggposter efter datum, men var medveten om att datumen du anger inte r inkluderande - fr att vlja alla loggposter fr 01-01-2009 s anger du "Datum fr&nbsp;o&nbsp;m" till 01-01-2009 och "Datum t&nbsp;o&nbsp;m" till 02-01-2009.<br /><br />Meddelande och hndelse r vanligen samma sak. Om du sker efter ett specifikt meddelande r det bst att ange hndelsen till "Alla".';
$_lang["mgrlog_results"] = 'Antal trffar';
$_lang["mgrlog_searchlogs"] = 'Sk i loggen';
$_lang["mgrlog_sortinst"] = 'Sortera tabellen genom att klicka p kolumnrubrikerna. Om loggen r fr stor kan du <a href="index.php?a=55">tmma loggfilen</a> fr att ta bort alla loggposter fram till nu. Denna operation kan inte ngras!';
$_lang["mgrlog_time"] = 'Tid';
$_lang["mgrlog_user"] = 'Anvndare';
$_lang["mgrlog_username"] = 'Anvndarnamn';
$_lang["mgrlog_value"] = 'Vrde';
$_lang["mgrlog_view"] = 'Visa loggen fr hanteraren';
$_lang["module_code"] = 'Modul-kod (php)';
$_lang["module_config"] = 'Modulinstllningar';
$_lang["module_desc"] = 'Beskrivning';
$_lang["module_disabled"] = 'Modulen avstngd';
$_lang["module_edit_click_title"] = 'Klicka hr fr att redigera denna modul';
$_lang["module_group_access_msg"] = 'Vlj de anvndargrupper som har tillstnd att kra den hr modulen innifrn innehllshanteraren.';
$_lang["module_management"] = 'Hantera moduler';
$_lang["module_management_msg"] = 'Vlj den modul du vill kra eller ndra. Klicka p ikonen i tabellen fr att kra modulen. Klicka p modulnamnet fr att redigera modulen.';
$_lang["module_msg"] = 'Lgg till och redigera moduler. En modul r en samling element (dvs plugins, snippets etc).';
$_lang["module_name"] = 'Modulnamn';
$_lang["module_resource_msg"] = 'Lgg till eller ta bort element som den hr modulen r beroende av. Klicka p en av "Lgg till"-knapparna nedan fr att lgga till ett nytt element.';
$_lang["module_resource_title"] = 'Modulberoenden';
$_lang["module_title"] = 'Skapa/redigera modul';
$_lang["module_viewdepend_msg"] = 'Se vilka element som den hr modulen r beroende av. Klicka p knappen "Hantera beroenden" fr att ndra beroendena.';
$_lang["modules"] = 'Moduler';
$_lang["modx_news"] = 'MODx Nyhetsnotiser';
$_lang["modx_news_tab"] = 'MODx Nyheter';
$_lang["modx_news_title"] = 'MODx Nyheter';
$_lang["modx_security_notices"] = 'MODx Skerhetsnotiser';
$_lang["modx_version"] = 'MODx-version';
$_lang["monday"] = 'Mndag';
$_lang["move"] = 'Flytta';
$_lang["move_resource"] = 'Flytta resurs';
$_lang["move_resource_message"] = 'Flytta en resurs och alla dess underresurser genom att vlja en ny frlder i webbplatstrdet. Om du vljer en resurs som inte redan r en behllare, kommer den att ndras till en. Klicka p den nya frldern i trdet.';
$_lang["move_resource_new_parent"] = 'Vlj en ny frlder i webbplatstrdet.';
$_lang["move_resource_title"] = 'Flytta resurs';
$_lang["name"] = 'Namn';
$_lang["new_category"] = 'Ny kategori';
$_lang["new_file_permissions_message"] = 'Nr en ny fil laddas upp med Filhanteraren, kommer Filhanteraren att frska ndra filbehrigheterna till dom som anges i denna instllning. Det hr kanske inte fungerar p alla system, t&nbsp;ex IIS, i vilket fall du blir tvungen att ndra behrigheterna manuellt.';
$_lang["new_file_permissions_title"] = 'Behrigheter fr nya filer';
$_lang["new_folder_permissions_message"] = 'Nr en ny katalog skapas i Filhanteraren, kommer Filhanteraren att frska ndra katalogbehrigheterna till dom som anges i denna instllning. Det hr kanske inte fungerar p alla system, t&nbsp;ex IIS, i vilket fall du blir tvungen att ndra behrigheterna manuellt.';
$_lang["new_folder_permissions_title"] = 'Behrigheter fr nya mappar';
$_lang["new_htmlsnippet"] = 'Ny chunk';
$_lang["new_keyword"] = 'Lgg till nytt nyckelord:';
$_lang["new_module"] = 'Ny modul';
$_lang["new_parent"] = 'Ny frlder';
$_lang["new_plugin"] = 'Ny plugin';
$_lang["new_role"] = 'Skapa en ny roll';
$_lang["new_snippet"] = 'Ny snippet';
$_lang["new_template"] = 'Ny mall';
$_lang["new_tmplvars"] = 'Ny mallvariabel';
$_lang["new_user"] = 'Ny anvndare';
$_lang["new_web_user"] = 'Ny webbanvndare';
$_lang["no"] = 'Nej';
$_lang["no_active_users_found"] = 'Inga aktiva anvndare funna.';
$_lang["no_activity_message"] = 'Du har nnu inte skapat eller redigerat ngra resurser.';
$_lang["no_category"] = 'okategoriserade';
$_lang["no_docs_pending_publishing"] = 'Inga resurser vntar p publicering.';
$_lang["no_docs_pending_pubunpub"] = 'Inga hndelser funna';
$_lang["no_docs_pending_unpublishing"] = 'Inga resurser vntar p avpublicering.';
$_lang["no_edits_creates"] = 'Inga redigeringar eller nyskapningar funna.';
$_lang["no_groups_found"] = 'Inga grupper hittade.';
$_lang["no_keywords_found"] = 'Det finns inga nyckelord n.';
$_lang["no_records_found"] = 'Inga poster funna.';
$_lang["no_results"] = 'Inga resultat funna';
$_lang["nologentries_message"] = 'Ange hur mnga loggposter som visas per sida nr du utforskar granskningsloggen.';
$_lang["nologentries_title"] = 'Antal loggposter';
$_lang["nomessages_message"] = 'Ange hur mnga meddelanden som visas i inkorgen.';
$_lang["nomessages_title"] = 'Antal meddelanden';
$_lang["none"] = 'Ingen';
$_lang["noresults_message"] = 'Ange antalet resultat som visas nr listningar och skresultat presenteras.';
$_lang["noresults_title"] = 'Antal resultat';
$_lang["not_deleted"] = 'har inte tagits bort.';
$_lang["not_set"] = 'Ej satt';
$_lang["offline"] = 'Offline';
$_lang["online"] = 'Online';
$_lang["onlineusers_action"] = 'Handling';
$_lang["onlineusers_actionid"] = 'Handlings-ID';
$_lang["onlineusers_ipaddress"] = 'Anvndarens IP-adress';
$_lang["onlineusers_lasthit"] = 'Senaste trff';
$_lang["onlineusers_message"] = 'Denna lista visar alla anvndare som varit aktiva de senaste 20 minuterna (klockan r nu ';
$_lang["onlineusers_title"] = 'Inloggade anvndare';
$_lang["onlineusers_user"] = 'Anvndare';
$_lang["onlineusers_userid"] = 'Anvndarens ID';
$_lang["optimize_table"] = 'Klicka hr fr att optimera den hr tabellen';
$_lang["page_data_cacheable"] = 'Cachebar';
$_lang["page_data_cacheable_help"] = 'Denna instllning tillter resursen att sparas i webbplatsens cache och pverkar alla snippets p denna sida';
$_lang["page_data_cached"] = '<b>Klla hmtad frn cache:</b>';
$_lang["page_data_changes"] = 'ndringar';
$_lang["page_data_contentType"] = 'Internetmediatyp';
$_lang["page_data_contentType_help"] = 'Vlj innehllstyp fr denna resurs. Om du inte r sker p vilken innehllstyp resursen ska ha, lt den st som text/html.';
$_lang["page_data_created"] = 'Skapad';
$_lang["page_data_edited"] = 'Redigerad';
$_lang["page_data_editor"] = 'Redigera med en richtext-editor';
$_lang["page_data_folder"] = 'Resursen r en behllare';
$_lang["page_data_general"] = 'Allmnt';
$_lang["page_data_markup"] = 'Uppmrkning/struktur';
$_lang["page_data_mgr_access"] = 'tkomst till hanteraren';
$_lang["page_data_notcached"] = 'Resursen har inte blivit cachad n.';
$_lang["page_data_publishdate"] = 'Publiceringsdatum';
$_lang["page_data_publishdate_help"] = 'Om du stter ett publiceringsdatum, kommer resursen att publiceras s snart som datumet r ntt. Klicka p kalenderikonen fr att vlja ett datum, eller ikonen bredvid fr att ta bort det. Om datumet tas bort, kommer resursen aldrig att publiceras automatiskt.';
$_lang["page_data_published"] = 'Publicerad';
$_lang["page_data_searchable"] = 'Skbar';
$_lang["page_data_searchable_help"] = 'Om detta flt markeras, kommer resursen att bli skbar. Du kan ocks anvnda det fr andra ndaml i dina snippets.';
$_lang["page_data_source"] = 'Klla';
$_lang["page_data_status"] = 'Status';
$_lang["page_data_template"] = 'Anvnder mall';
$_lang["page_data_template_help"] = 'Vlj mall fr denna resurs.';
$_lang["page_data_title"] = 'Siddata';
$_lang["page_data_unpublishdate"] = 'Avpubliceringsdatum';
$_lang["page_data_unpublishdate_help"] = 'Om du stter ett avpubliceringsdatum, kommer resursen att avpubliceras s snart som datumet r ntt. Klicka p kalenderikonen fr att vlja ett datum, eller ikonen bredvid fr att ta bort det. Om datumet tas bort, kommer resursen aldrig att avpubliceras automatiskt.';
$_lang["page_data_unpublished"] = 'Avpublicerad';
$_lang["page_data_web_access"] = 'Webbtkomst';
$_lang["pagetitle"] = 'Resursens titel';
$_lang["pagination_table_first"] = 'Frsta';
$_lang["pagination_table_gotopage"] = 'G till sidan';
$_lang["pagination_table_last"] = 'Sista';
$_lang["paging_first"] = 'frsta';
$_lang["paging_last"] = 'sista';
$_lang["paging_next"] = 'nsta';
$_lang["paging_prev"] = 'fregende';
$_lang["paging_showing"] = 'Visar';
$_lang["paging_to"] = 'till';
$_lang["paging_total"] = 'totalt';
$_lang["parameter"] = 'Parameter';
$_lang["password"] = 'Lsenord';
$_lang["password_change_request"] = 'Frfrgan om ndrat lsenord';
$_lang["password_gen_gen"] = 'Lt MODx generera ett lsenord';
$_lang["password_gen_length"] = 'Lsenordet du anger mste vara minst 6 tecken lngt.';
$_lang["password_gen_method"] = 'Ny lsenordsmetod';
$_lang["password_gen_specify"] = 'Lt mig ange ett lsenord:';
$_lang["password_method"] = 'Metod fr tillknnagivande av lsenord';
$_lang["password_method_email"] = 'Skicka det nya lsenordet med e-post.';
$_lang["password_method_screen"] = 'Visa det nya lsenordet p skrmen.';
$_lang["password_msg"] = 'Det nya lsenordet fr <b>%s</b> r <b>%s</b>.';
$_lang["php_version_check"] = 'MODx r kompatibelt med PHP version 4.0.3 eller hgre. Du behver uppgradera din installation av PHP!';
$_lang["plugin"] = 'Plugin';
$_lang["plugin_code"] = 'Plugin-kod (php)';
$_lang["plugin_config"] = 'Konfigurera plugin';
$_lang["plugin_desc"] = 'Beskrivning';
$_lang["plugin_disabled"] = 'Pluginen avstngd';
$_lang["plugin_event_msg"] = 'Vlj de hndelser som pluginen ska lyssna till.';
$_lang["plugin_management_msg"] = 'Skapa en ny plugin eller vlja en redan befintlig fr redigering.';
$_lang["plugin_msg"] = 'Skapa och redigera plugins. Plugins anvnder PHP-kod som krs nr valda systemhndelser triggas.';
$_lang["plugin_name"] = 'Pluginnamn';
$_lang["plugin_priority"] = 'Redigera krordningen fr plugins efter hndelse';
$_lang["plugin_priority_instructions"] = 'Dra fr att ndra ordningen p plugins under varje hndelserubrik. Den plugin som ska kras frst ska vara hgst upp.';
$_lang["plugin_priority_title"] = 'Krordning fr plugins';
$_lang["plugin_title"] = 'Skapa/redigera plugin';
$_lang["preview"] = 'Frhandsgranska';
$_lang["preview_msg"] = 'Detta r en frhandsgranskning av dina senast sparade ndringar. Klicka hr fr att <a href="#" onclick="saveRefreshPreview();">spara och ladda om</a> dina nuvarande ndringar';
$_lang["preview_resource"] = 'Frhandsgranska';
$_lang["private"] = 'Privat';
$_lang["public"] = 'Offentlig';
$_lang["publish_date"] = 'Publiceringsdatum';
$_lang["publish_events"] = 'Publicera hndelser';
$_lang["publish_resource"] = 'Publicera resurs';
$_lang["rb_base_dir_message"] = 'Ange den fysiska skvgen till filhanterarens katalog. Den hr instllningen grs vanligen automatiskt, men om du anvnder IIS r det mjligt att MODx inte kan rkna ut skvgen sjlv, vilket orsakar ett felmeddelande i filhanteraren. I s fall kan du skriva in skvgen till bildkatalogen hr (skvgen som den visas i Utforskaren).<br /><b>OBS: Filhanterarens katalog mste innehlla underkatalogerna images, files, flash och media fr att filhanteraren ska fungera korrekt.</b>';
$_lang["rb_base_dir_title"] = 'Skvg till filer';
$_lang["rb_base_url_message"] = 'Ange den virtuella skvgen till filhanterarens katalog. Den hr instllningen grs vanligen automatiskt, men om du anvnder IIS r det mjligt att MODx inte kan rkna ut adressen p egen hand, vilket orsakar ett felmeddelande i filhanteraren. I s fall kan du skriva in adressen till bildkatalogen hr (adressen som du skulle skriva den i Internet Explorer).';
$_lang["rb_base_url_title"] = 'Filhanterarens URL';
$_lang["rb_message"] = 'Vlj "Ja" fr att anvnda filhanteraren. Detta lter dina anvndare lsa och ladda upp filer ssom bilder, flash- och mediafiler till servern.';
$_lang["rb_title"] = 'Anvnd filhanterare';
$_lang["rb_webuser_message"] = 'Vill du tillta att en webbanvndare kan anvnda filhanteraren? <b>Varning:</b> Genom att tillta webbanvndare att anvnda filhanteraren s exponerar man ven filer som r tillgngliga fr anvndare av hanteraren. Anvnda bara den hr instllningen fr betrodda webbanvndare.';
$_lang["rb_webuser_title"] = 'Webbanvndare?';
$_lang["recent_docs"] = 'Senaste resurser';
$_lang["recommend_setting_change_title"] = 'Rekommenderad instllningsndring';
$_lang["recommend_setting_change_description"] = 'Din webbplats r inte konfigurerad fr att validera HTTP_REFERER p inkommande frfrgningar till hanteraren. Vi rekommenderar starkt att du aktiverar den instllningen fr att minska risken fr CSRF-attacker (Cross Site Request Forgery).';
$_lang["refresh_cache"] = 'Cache: Hittade <b>%s</b> filer i cachekatalogen, och tog bort <b>%d</b> cachefiler. <p>Nya cachefiler kommer automatiskt att skapas nr sidorna hmtas.';
$_lang["refresh_published"] = '<b>%s</b> resurser publicerades.';
$_lang["refresh_site"] = 'Rensa cachen';
$_lang["refresh_title"] = 'Uppdatera webbplatsen';
$_lang["refresh_tree"] = 'Uppdatera webbplatstrd';
$_lang["refresh_unpublished"] = '<b>%s</b> resurser avpublicerades.';
$_lang["remember_last_tab"] = 'Kom ihg flikar';
$_lang["remember_last_tab_message"] = 'Sidor i hanteraren som har flikar ppnas p den flik man senast var p, istllet fr p den frsta fliken.';
$_lang["remember_username"] = 'Kom ihg mig';
$_lang["remove"] = 'Ta bort';
$_lang["remove_date"] = 'Ta bort datum';
$_lang["remove_locks"] = 'Ta bort ls';
$_lang["rename"] = 'Byt namn';
$_lang["reports"] = 'Rapporter';
$_lang["require_tagname"] = 'Ett namn p taggen krvs';
$_lang["require_tagvalue"] = 'Ett vrde p taggen krvs';
$_lang["reset"] = 'Rensa';
$_lang["reset_failedlogins"] = 'nollstll';
$_lang["resolve_hostnames_message"] = 'Vill du att MODx ska frska gra namnuppslag p dina beskares vrddatornamn nr de besker din webbplats? Namnuppslag kan skapa extra belastning fr servern, men dina beskare kommer inte att mrka av det p ngot stt.';
$_lang["resolve_hostnames_title"] = 'Gr namnuppslag';
$_lang["resource"] = 'Resurs';
$_lang["resource_alias"] = 'URL-alias';
$_lang["resource_alias_help"] = 'Ange ett URL-alias fr att gra resursen tillgnglig som http://dinserver/alias. Detta fungerar endast om vnliga adresser r aktiverade i webbplatsens konfiguration.';
$_lang["resource_content"] = 'Resursinnehll';
$_lang["resource_description"] = 'Beskrivning';
$_lang["resource_description_help"] = 'Ange en valfri beskrivning av denna resurs.';
$_lang["resource_duplicate"] = 'Duplicera resurs';
$_lang["resource_long_title_help"] = 'Ange en valfri lngre titel fr din resurs. Denna kan anvndas fr automatiska header-taggar fr skmotorer, och beskriver kanske din resurs bttre.';
$_lang["resource_metatag_help"] = 'Vlj de META-taggar och nyckelord som du vill knyta till den hr resursen. Hll ner Ctrl fr att vlja flera nyckelord eller META-taggar.';
$_lang["resource_opt_contentdispo"] = 'Innehllsdisposition';
$_lang["resource_opt_contentdispo_help"] = 'Anvnd innehllsdispositionsfltet fr att specificera hur den hr resursen ska hanteras av webblsaren. Fr filnedladdningar vljer du instllningen "Bifogad fil".';
$_lang["resource_opt_emptycache"] = 'Tm cachen';
$_lang["resource_opt_emptycache_help"] = 'Lmnar du detta flt markerat, kommer MODx att tmma sin cache nr du sparar resursen. Det gr att dina beskare inte kommer att se en gammal version av resursen.';
$_lang["resource_opt_folder"] = 'Behllare';
$_lang["resource_opt_folder_help"] = 'Markera hr om resursen ska fungera som en behllare fr andra resurser. En "behllare" r som en mapp, men den kan ocks ha ett eget innehll.';
$_lang["resource_opt_menu_index"] = 'Menyindex';
$_lang["resource_opt_menu_index_help"] = 'Menyindex r ett flt som kan anvndas fr att kontrollera sorteringen av resurser. Speciellt i snippets som bygger menyer. Du kan ocks anvnda det fr andra ndaml i dina snippets.';
$_lang["resource_opt_menu_title"] = 'Menytitel';
$_lang["resource_opt_menu_title_help"] = 'Menytitel r ett valfritt flt som anvnds fr att visa en kort titel i menysnippets eller moduler.';
$_lang["resource_opt_published"] = 'Publicerad';
$_lang["resource_opt_published_help"] = 'Markera detta flt om resursen ska publiceras direkt nr den sparas.';
$_lang["resource_opt_richtext"] = 'Richtext';
$_lang["resource_opt_richtext_help"] = 'Lmna denna ikryssad fr att anvnda en richtext-editor vid resursredigering. Om dina resurser innehller javascript eller formulr - avmarkera denna fr att redigera i HTML-lge, s editorn inte stkar till i dina resurser.';
$_lang["resource_opt_show_menu"] = 'Visa i meny';
$_lang["resource_opt_show_menu_help"] = 'Vlj den hr instllningen fr att visa resursen i en webbmeny. Notera att vissa menybyggarsnippets kan vlja att strunta i den hr instllningen.';
$_lang["resource_opt_trackvisit_help"] = 'Logga varje beskares besk p den hr sidan';
$_lang["resource_overview"] = 'Resursversikt';
$_lang["resource_parent"] = 'Resursfrlder';
$_lang["resource_parent_help"] = 'Klicka p ikonen fr att aktivera val av frlder fr denna resurs. Klicka sedan p en resurs i webbplatstrdet fr att ange den som ny frlder.';
$_lang["resource_permissions_error"] = 'Tilldela denna resurs till minst en resursgrupp som du kan komma t.';
$_lang["resource_setting"] = 'Resursinstllningar';
$_lang["resource_summary"] = 'Sammanfattning';
$_lang["resource_summary_help"] = 'Skriv en kort sammanfattning av resursen';
$_lang["resource_title"] = 'Titel';
$_lang["resource_title_help"] = 'Skriv namnet/titeln p resursen hr. Undvik omvnda snedstreck i namnet.';
$_lang["resource_to_be_moved"] = 'Resursen som ska flyttas';
$_lang["resource_type"] = 'Resurstyp';
$_lang["resource_type_message"] = 'Webblnkar refererar till resurser p internet, inklusive en annan MODx-resurs, en extern sida, en bild eller en annan fil p internet. Webblnkar ska ha internetmediatypen "text/html" och innehllsdispositionen "inline".';
$_lang["resource_type_weblink"] = 'Webblnk';
$_lang["resource_type_webpage"] = 'Webbsida';
$_lang["resource_weblink_help"] = 'Ange adressen till objektet du vill referera till med denna webblnk.';
$_lang["resources_in_container"] = 'resurser i den hr behllaren';
$_lang["resources_in_container_no"] = 'Den hr behllaren har inga underresurser.';
$_lang["role"] = 'Roll';
$_lang["role_about"] = 'Visa Om-sidan';
$_lang["role_access_persmissions"] = 'tkomstrttigheter';
$_lang["role_actionok"] = 'Visa "tgrd utfrd"-sidan';
$_lang["role_bk_manager"] = 'Anvnda hanteraren fr skerhetskopiering';
$_lang["role_cache_refresh"] = 'Tmma webbplatsens cache';
$_lang["role_change_password"] = 'Byta lsenord';
$_lang["role_chunk_management"] = 'Chunk-hantering';
$_lang["role_config_management"] = 'Konfigurationshantering';
$_lang["role_content_management"] = 'Innehllshantering';
$_lang["role_create_chunk"] = 'Skapa nya chunks';
$_lang["role_create_doc"] = 'Skapa nya resurser';
$_lang["role_create_plugin"] = 'Skapa nya plugins';
$_lang["role_create_snippet"] = 'Skapa nya snippets';
$_lang["role_create_template"] = 'Skapa nya mallar';
$_lang["role_credits"] = 'Visa erknnandesidan';
$_lang["role_delete_chunk"] = 'Ta bort chunks';
$_lang["role_delete_doc"] = 'Ta bort resurser';
$_lang["role_delete_eventlog"] = 'Ta bort hndelselogg';
$_lang["role_delete_module"] = 'Ta bort moduler';
$_lang["role_delete_plugin"] = 'Ta bort plugins';
$_lang["role_delete_role"] = 'Ta bort roller';
$_lang["role_delete_snippet"] = 'Ta bort snippets';
$_lang["role_delete_template"] = 'Ta bort mallar';
$_lang["role_delete_user"] = 'Ta bort anvndare';
$_lang["role_delete_web_user"] = 'Ta bort webbanvndare';
$_lang["role_edit_chunk"] = 'Redigera chunks';
$_lang["role_edit_doc"] = 'Redigera resurser';
$_lang["role_edit_doc_metatags"] = 'Redigera resursers META-taggar och nyckelord';
$_lang["role_edit_module"] = 'Redigera moduler';
$_lang["role_edit_plugin"] = 'Redigera plugins';
$_lang["role_edit_role"] = 'Redigera roller';
$_lang["role_edit_settings"] = 'ndra webbplatsens instllningar';
$_lang["role_edit_snippet"] = 'Redigera snippets';
$_lang["role_edit_template"] = 'Redigera mallar';
$_lang["role_edit_user"] = 'Redigera anvndare';
$_lang["role_edit_web_user"] = 'Redigera webbanvndare';
$_lang["role_empty_trash"] = 'Permanent radera borttagna resurser';
$_lang["role_errors"] = 'Visa feldialog';
$_lang["role_eventlog_management"] = 'Hantera hndelseloggar';
$_lang["role_export_static"] = 'Exportera statisk HTML';
$_lang["role_file_manager"] = 'Anvnda filhanteraren';
$_lang["role_frames"] = 'Ladda innehllshanteraren';
$_lang["role_help"] = 'Visa hjlpsidor';
$_lang["role_home"] = 'Ladda introduktionssidan';
$_lang["role_import_static"] = 'Importera HTML';
$_lang["role_logout"] = 'Logga ut frn innehllshanteraren';
$_lang["role_manage_metatags"] = 'Hantera webbplatsens META-taggar och nyckelord';
$_lang["role_management_msg"] = 'Skapa en ny roll eller vlja en redan befintlig fr redigering.';
$_lang["role_management_title"] = 'Roller';
$_lang["role_messages"] = 'Lsa och skicka meddelanden';
$_lang["role_module_management"] = 'Hantera moduler';
$_lang["role_name"] = 'Rollnamn';
$_lang["role_new_module"] = 'Skapa ny modul';
$_lang["role_new_role"] = 'Skapa nya roller';
$_lang["role_new_user"] = 'Skapa nya anvndare';
$_lang["role_new_web_user"] = 'Skapa nya webbanvndare';
$_lang["role_plugin_management"] = 'Hantera plugins';
$_lang["role_publish_doc"] = 'Publicera resurser';
$_lang['role_remove_locks'] = 'Ta bort ls';
$_lang["role_role_management"] = 'Roller';
$_lang["role_run_module"] = 'Kr modul';
$_lang["role_save_chunk"] = 'Spara chunks';
$_lang["role_save_doc"] = 'Spara resurser';
$_lang["role_save_module"] = 'Spara moduler';
$_lang["role_save_password"] = 'Spara lsenord';
$_lang["role_save_plugin"] = 'Spara plugin';
$_lang["role_save_role"] = 'Spara roller';
$_lang["role_save_snippet"] = 'Spara snippets';
$_lang["role_save_template"] = 'Spara mallar';
$_lang["role_save_user"] = 'Spara anvndare';
$_lang["role_save_web_user"] = 'Spara webbanvndare';
$_lang["role_snippet_management"] = 'Snippethantering';
$_lang["role_template_management"] = 'Mallhantering';
$_lang["role_title"] = 'Skapa/redigera roll';
$_lang["role_udperms"] = 'Behrighetshantering';
$_lang["role_user_management"] = 'Anvndarhantering';
$_lang["role_view_docdata"] = 'Visa resursdata';
$_lang["role_view_eventlog"] = 'Visa hndelselogg';
$_lang["role_view_logs"] = 'Visa systemloggar';
$_lang["role_view_unpublished"] = 'Visa opublicerade resurser';
$_lang["role_web_access_persmissions"] = 'Rttigheter fr webbtkomst';
$_lang["role_web_user_management"] = 'Hantera webbanvndare';
$_lang["rss_url_news_default"] = 'http://feeds.feedburner.com/modx-announce';
$_lang["rss_url_news_message"] = 'Ange URL:en fr MODx nyhetsflde.';
$_lang["rss_url_news_title"] = 'RSS nyhetsflde';
$_lang["rss_url_security_default"] = 'http://feeds.feedburner.com/modxsecurity';
$_lang["rss_url_security_message"] = 'Ange URL:en fr MODx skerhetsflde.';
$_lang["rss_url_security_title"] = 'RSS skerhetsflde';
$_lang["run_module"] = 'Kr modul';
$_lang["saturday"] = 'Lrdag';
$_lang["save"] = 'Spara';
$_lang["save_all_changes"] = 'Spara alla ndringar';
$_lang["save_tag"] = 'Spara tagg';
$_lang["saving"] = 'Sparar, vnta...';
$_lang["search"] = 'Sk';
$_lang["search_criteria"] = 'Skkriterier';
$_lang["search_criteria_content"] = 'Sk efter innehll';
$_lang["search_criteria_content_msg"] = 'Hitta samtliga resurser med sktexten i innehllet.';
$_lang["search_criteria_id"] = 'Sk efter ID';
$_lang["search_criteria_id_msg"] = 'Skriv resursens ID fr att snabbt lokalisera resursen.';
$_lang["search_criteria_longtitle"] = 'Sk efter lng titel';
$_lang["search_criteria_longtitle_msg"] = 'Hitta alla resurser med sktexten i den lnga titeln.';
$_lang["search_criteria_title"] = 'Sk efter titel';
$_lang["search_criteria_title_msg"] = 'Hitta samtliga resurser med sktexten i titeln.';
$_lang["search_empty"] = 'Din skning gav inga resultat. Bredda dina skkriterier och frsk igen.';
$_lang["search_item_deleted"] = 'Denna post har tagits bort';
$_lang["search_results"] = 'Skresultat';
$_lang["search_results_returned_desc"] = 'Beskrivning';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Din skning returnerade <b>%s</b> resurser. Frsk att gra en mer specifik skning om du fr mnga trffar. De tv kolumnerna lngst till vnster lter dig hitta resursen i webbplatstrdet eller visa resursen. De tv kolumnerna till hger visar om resursen har tagits bort och vilken publiceringsstatus den har.<p />';
$_lang["search_results_returned_title"] = 'Titel';
$_lang["search_view_docdata"] = 'Visa denna post';
$_lang["security"] = 'Skerhet';
$_lang["security_notices_tab"] = 'Skerhetsnotiser';
$_lang["security_notices_title"] = 'Skerhetsnotiser';
$_lang["select_date"] = 'Vlj ett datum';
$_lang["send"] = 'Skicka';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Ange om din sida anvnder en http- eller en https-anslutning.';
$_lang["server_protocol_title"] = 'Servertyp';
$_lang["serveroffset"] = 'Serverns tidsskillnad';
$_lang["serveroffset_message"] = 'Vlj det antal timmar som skiljer mellan dig och servern. Nuvarande tid p servern r <b>[%s]</b>, och den nuvarande tiden med modifieraren r <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Serverns tidsfrskjutning';
$_lang["servertime"] = 'Serverns tid';
$_lang["settings_after_install"] = 'Eftersom detta r en ny installation, mste du g igenom dessa instllningar och ndra det du vill. Nr du r klar med kontrollen av alla instllningar, klicka p "Spara" fr att uppdatera instllningsdatabasen.';
$_lang["settings_config"] = 'Konfiguration';
$_lang["settings_dependencies"] = 'Beroenden';
$_lang["settings_events"] = 'Systemhndelse';
$_lang["settings_furls"] = 'Vnliga adresser';
$_lang["settings_general"] = 'Allmnt';
$_lang["settings_misc"] = 'Filhanteraren';
$_lang["settings_page_settings"] = 'Instllningar';
$_lang["settings_photo"] = 'Foto';
$_lang["settings_properties"] = 'Egenskaper';
$_lang["settings_site"] = 'Webbplatsen';
$_lang["settings_strip_image_paths_message"] = 'Om denna instllning stts till "Nej", s kommer MODx att skriva skvgarna till filer i filhanteraren (bilder, filer, flash etc.) som absoluta URL:er. Relativa URL:er r anvndbara om du ska flytta din MODX-installation, t&nbsp;ex frn en testserver till en produktionsserver. Om du inte har ngon aning om vad det hr betyder, s r det bst att lmna instllningen satt till "Ja".';
$_lang["settings_strip_image_paths_title"] = 'Skriv om skvgar till resurser?';
$_lang["settings_templvars"] = 'Mallvariabler';
$_lang["settings_title"] = 'Systeminstllningar';
$_lang["settings_ui"] = 'Grnssnitt &amp; funktioner';
$_lang["settings_users"] = 'Anvndare';
$_lang["show_meta"] = 'Visa fliken META-nyckelord';
$_lang["show_meta_message"] = 'Visa fliken META-nyckelord (som inte anvnds lngre) nr resurser redigeras i hanteraren.';
$_lang["show_tree"] = 'Visa webbplatstrd';
$_lang["showing"] = 'Visande';
$_lang["signupemail_message"] = 'Ange det meddelande som skickas till anvndare med deras anvndarnamn och lsenord nr konton skapas.<br /><b>Notera:</b> Fljande begrepp erstts av innehllshanteraren nr meddelandet snds:<br /><br />[+sname+] - Namnet p din webbplats<br />[+saddr+] - Webbplatsens e-postadress<br />[+surl+] - Webbplatsens adress<br />[+uid+] - Anvndarens login eller ID<br />[+pwd+] - Anvndarens lsenord<br />[+ufn+] - Anvndarens namn<br /><br /><b>Lt [+uid+] och [+pwd+] st kvar i meddelandet, annars innehller mailet inte anvndarnamn och lsenord, vilket gr att dina anvndare inte kan logga in!</b>';
$_lang["signupemail_title"] = 'Registreringsmeddelande';
$_lang["site"] = 'Webbplats';
$_lang["site_schedule"] = 'Schema';
$_lang["sitename_message"] = 'Skriv in namnet p din webbplats hr.';
$_lang["sitename_title"] = 'Webbplatsens namn';
$_lang["sitestart_message"] = 'Ange ID fr den resurs du vill ha som startsida hr.<br /><b>OBS: Se till att detta ID tillhr en existerande resurs, och att den har blivit publicerad!</b>';
$_lang["sitestart_title"] = 'Startsida';
$_lang["sitestatus_message"] = 'Vlj "Online" fr att publicera din webbplats. Vljer du "Offline", kommer dina beskare att se meddelandet fr "Webbplatsen inte tillgnglig" och kommer inte att kunna surfa p webbplatsen.';
$_lang["sitestatus_title"] = 'Webbplatsens status';
$_lang["siteunavailable_message"] = 'Meddelandet som visas nr webbplatsen r offline, eller nr ngot fel har intrffat.<br /><b>OBS: Detta meddelande visas bara om ingen "Webbplatsen inte tillgnglig"-sida bestmts.</b>';
$_lang["siteunavailable_message_default"] = 'Webbplatsen r inte tillgnglig fr tillfllet.';
$_lang["siteunavailable_page_message"] = 'Ange ID fr den resurs du vill anvnda som en offline-sida hr. <br /><b>OBS: Kontrollera att detta ID hr till en existerande resurs och att den blivit publicerad!</b>';
$_lang["siteunavailable_page_title"] = 'Sida fr<br />"Webbplatsen inte tillgnglig"';
$_lang["siteunavailable_title"] = 'Meddelande fr<br />"Webbplatsen inte tillgnglig"';
$_lang["snippet"] = 'Snippet';
$_lang["snippet_code"] = 'Snippet-kod (php)';
$_lang["snippet_desc"] = 'Beskrivning';
$_lang["snippet_execonsave"] = 'Kr snippeten efter att den sparats.';
$_lang["snippet_management_msg"] = 'Skapa nya snippets eller vlja en redan befintlig fr redigering.';
$_lang["snippet_msg"] = 'Skapa och redigera snippets. Kom ihg att snippets r "r" PHP-kod - om du vill att snippeten ska skriva ngot i mallen, s mste du returnera ett vrde frn snippeten.';
$_lang["snippet_name"] = 'Snippetnamn';
$_lang["snippet_properties"] = 'Standardegenskaper';
$_lang["snippet_title"] = 'Skapa/redigera snippet';
$_lang["sort_asc"] = 'Stigande';
$_lang["sort_desc"] = 'Fallande';
$_lang["sort_tree"] = 'Sortera webbplatstrdet';
$_lang["source"] = 'Klla';
$_lang["stay"] = 'Fortstt redigera';
$_lang["stay_new"] = 'Lgg till en till';
$_lang["submit"] = 'Skicka';
$_lang["sunday"] = 'Sndag';
$_lang["sys_alert"] = 'Systemlarm';
$_lang["sysinfo_activity_message"] = 'Denna lista visar vilka resurser som nyligen redigerats av dina anvndare.';
$_lang["sysinfo_userid"] = 'Anvndare';
$_lang["system_email_signup"] = "Hej [+uid+]!\n\nHr kommer dina inloggningsuppgifter fr [+sname+] innehllshanterare.\n\nAnvndarnamn: [+uid+]\nLsenord: [+pwd+]\n\nDu kan ndra ditt lsenord nr du loggat in i innehlshanteraren ([+surl+]).\n\nVnliga hlsningar\nWebmastern";
$_lang["system_email_webreminder"] = "Hej [+uid+]!\n\nKlicka p fljande lnk fr att aktivera ditt nya lsenord:\n\n[+surl+]\n\nOm allt gr bra anvnder du fljande lsenord fr att logga in:\n\nLsenord:[+pwd+]\n\nOm du inte har bett om det hr brevet s kan du strunta i det.\n\nVnliga hlsningar\nWebmastern";
$_lang["system_email_websignup"] = "Hej [+uid+]!\n\nHr kommer dina inloggningsuppgifter fr [+sname+].\n\nAnvndarnamn: [+uid+]\nLsenord: [+pwd+]\n\nDu kan ndra ditt lsenord nr du loggat in i [+sname+] ([+surl+]).\n\nVnliga hlsningar\nWebmastern";
$_lang["table_hoverinfo"] = 'Placera markren ver ett tabellnamn fr att se en kort beskrivning av tabellens funktion (gller dock inte alla tabellnamn).'; 
$_lang["table_prefix"] = 'Tabellprefix';
$_lang["tag"] = 'Tagg';
$_lang["template"] = 'Mall';
$_lang["template_assignedtv_tab"] = 'Tilldelade mallvariabler';
$_lang["template_code"] = 'Mall-kod (html)';
$_lang["template_desc"] = 'Beskrivning';
$_lang["template_edit_tab"] = 'Redigera mall';
$_lang["template_management_msg"] = 'Skapa en ny mall eller vlja en redan befintlig fr redigering.';
$_lang["template_msg"] = 'Skapa och redigera mallar hr. ndrade eller nya mallar kommer inte att synas p din webbplats cachade sidor, frrn cachen har tmts. Du kan dremot anvnda frhandsgranskningen fr att se hur den uppdaterade mallen kommer att se ut.';
$_lang["template_name"] = 'Mallnamn';
$_lang["template_no_tv"] = 'Inga mallvariabler har tilldelats den hr mallen n.';
$_lang["template_reset_all"] = 'terstll alla sidor s de anvnder standardmallen';
$_lang["template_reset_specific"] = 'terstll endast "%s" sidor';
$_lang["template_title"] = 'Skapa/redigera mallar';
$_lang["template_tv_edit"] = 'Redigera mallvariablernas sorteringsordning';
$_lang["template_tv_edit_message"] = 'Dra fr att ndra ordningen p mallvariablerna fr denna mall.';
$_lang["template_tv_edit_title"] = 'Sorteringsordning fr mallvariabler';
$_lang["template_tv_msg"] = 'Mallvariablerna som tilldelats den hr mallen visas nedan.';
$_lang["thursday"] = 'Torsdag';
$_lang["tmplvar_access_msg"] = 'Vlj de resursgrupper som ska kunna modifiera innehllet eller vrdet av denna mallvariabel.';
$_lang["tmplvar_change_template_msg"] = 'ndrar du denna mall, kommer sidan att ladda om alla mallvariabler. Alla icke sparade ndringar kommer att frloras.\n\nr du sker p att du vill ndra denna mall?';
$_lang["tmplvar_inuse"] = 'Fljande resurser anvnder fr nrvarande denna mallvariabel. Fr att fortstta med denna borttagningsoperation, klicka p knappen "Ta bort". Klicka p knappen "Avbryt" fr att avbryta.';
$_lang["tmplvar_tmpl_access"] = 'Malltkomst';
$_lang["tmplvar_tmpl_access_msg"] = 'Vlj de mallar som har behrighet att anvnda denna mallvariabel.';
$_lang["tmplvars"] = 'Mallvariabler';
$_lang["tmplvars_binding_msg"] = 'Detta flt tillter bindning av datakllor med @-kommandon';
$_lang["tmplvars_caption"] = 'Rubrik';
$_lang["tmplvars_default"] = 'Standardvrde';
$_lang["tmplvars_description"] = 'Beskrivning';
$_lang["tmplvars_elements"] = 'Inmatningsvrden';
$_lang["tmplvars_management_msg"] = 'Hantera ytterligare innehllsflt (mallvariabler) fr dina resurser.';
$_lang["tmplvars_msg"] = 'Lgga till och redigera mallvariabeln hr. Den mste tilldelas till en eller flera mallar fr att den ska kunna kommas t frn snippets och resurser.';
$_lang["tmplvars_name"] = 'Mallvariabelnamn';
$_lang["tmplvars_novars"] = 'Inga mallvariabler funna';
$_lang["tmplvars_rank"] = 'Sorteringsordning';
$_lang["tmplvars_reset_params"] = 'terstll parametrar';
$_lang["tmplvars_title"] = 'Skapa/redigera mallvariabel';
$_lang["tmplvars_type"] = 'Inmatningstyp';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Widget-instllningar';
$_lang["to"] = 'till';
$_lang["tools"] = 'Verktyg';
$_lang["top_howmany_message"] = 'Nr rapporter visas, hur lnga ska "Topp..."-listorna vara?';
$_lang["top_howmany_title"] = 'Hur mnga i toppen';
$_lang["total"] = 'totalt';
$_lang["track_visitors_message"] = 'Erbjuder en krok fr analysplugins, fr att t&nbsp;ex flagga om besk till en specifik resurs ska loggas eller inte.';
$_lang["track_visitors_title"] = 'Aktivera insamling av statistik';
$_lang["tree_page_click"] = 'Beteende vid sidklick';
$_lang["tree_page_click_message"] = 'Standardbeteendet nr man klickar p en sida i webbplatstrdet.';
$_lang["tree_show_protected"] = 'Visa skyddade sidor';
$_lang["tree_show_protected_message"] = 'Nr den hr instllningen r satt till "Nej" visas inte skyddade resurser (och deras underresurser) i webbplatstrdet. "Nej" r den traditionella instllningen fr MODx.';
$_lang["truncate_table"] = 'Klicka hr fr att trunkera den hr tabellen';
$_lang["tuesday"] = 'Tisdag';
$_lang["tv"] = 'Mallvariabel';
$_lang["type"] = 'Typ';
$_lang["udperms_allowroot_message"] = 'Tillt anvndare att skapa nya resurser i roten p webbplatsen. ';
$_lang["udperms_allowroot_title"] = 'Tillt rot';
$_lang["udperms_message"] = 'Kontrollera tkomsten till resurser genom anvndargrupper och resursgrupper.';
$_lang["udperms_title"] = 'Anvnd tkomstrttigheter';
$_lang["unable_set_link"] = 'Kunde inte ange lnken!';
$_lang["unable_set_parent"] = 'Kunde inte skapa ny frlder!';
$_lang["unauthorizedpage_message"] = 'Ange ID till en publicerad och offentlig resurs som anvndare kan omdirigeras till nr de frsker n en resurs som r sker eller otillten.';
$_lang["unauthorizedpage_title"] = 'Otillten-sida';
$_lang["unblock_message"] = 'Denna anvndare kommer inte lngre att blockeras nr anvndarens data sparats.';
$_lang["undelete_resource"] = 'terstll resurs';
$_lang["unpublish_date"] = 'Avpubliceringsdatum';
$_lang["unpublish_events"] = 'Avpublicera hndelser';
$_lang["unpublish_resource"] = 'Avpublicera resurs';
$_lang["untitled_resource"] = 'Namnls resurs';
$_lang["untitled_weblink"] = 'Namnls webblnk';
$_lang["update_params"] = 'Uppdatera parametervisningen';
$_lang["update_settings_from_language"] = 'Erstt nuvarande med:';
$_lang["upload_maxsize_message"] = 'Skriv den strsta filstorleken som kan laddas upp via filhanteraren. Storleken mste anges i bytes.<br /><b>OBS: Stora filer kan ta vldigt lng tid att ladda upp!</b>';
$_lang["upload_maxsize_title"] = 'Strsta storlek fr uppladdningar';
$_lang["uploadable_files_message"] = 'Skriv en lista med de typer av filer som kan laddas upp till "assets/files/" med filhanteraren. Ange filtypernas suffix, separerade med kommatecken.';
$_lang["uploadable_files_title"] = 'Uppladdningsbara filtyper';
$_lang["uploadable_flash_message"] = 'Skriv en lista med de typer av flashfiler som kan laddas upp till "assets/flash/" med filhanteraren. Ange flashtypernas suffix, separerade med kommatecken.';
$_lang["uploadable_flash_title"] = 'Uppladdningsbara flashtyper';
$_lang["uploadable_images_message"] = 'Skriv en lista med de typer av bildfiler som kan laddas upp till "assets/images/" med filhanteraren. Ange bildfilernas suffix, separerade med kommatecken.';
$_lang["uploadable_images_title"] = 'Uppladdningsbara bildtyper';
$_lang["uploadable_media_message"] = 'Skriv en lista med de typer av mediafiler som kan laddas upp till "assets/media/" med filhanteraren. Ange mediatypernas suffix, separerade med kommatecken.';
$_lang["uploadable_media_title"] = 'Uppladdningsbara mediatyper';
$_lang["use_alias_path_message"] = 'Med denna instllning aktiverad kommer en virtuell skvg till resursen att genereras. Om exempelvis resursen "barn.html" befinner sig i behllaren "foralder", kommer hela URL-aliasskvgen att bli "/foralder/barn.html".';
$_lang["use_alias_path_title"] = 'Anvnd vnliga URL-aliasskvgar';
$_lang["use_editor_message"] = 'Mjliggr redigering med en richtext-editor. Denna instllning gller fr samtliga resurser, men kan sidosttas i anvndarinstllningarna.';
$_lang["use_editor_title"] = 'Aktivera editor';
$_lang["user"] = 'Anvndare';
$_lang["user_block"] = 'Blockerad';
$_lang["user_blockedafter"] = 'Blockerad efter';
$_lang["user_blockeduntil"] = 'Blockerad till';
$_lang["user_changeddata"] = 'Dina anvndardata har ndrats. Var snll och logga in igen.';
$_lang["user_country"] = 'Land';
$_lang["user_dob"] = 'Fdelsedatum';
$_lang["user_doesnt_exist"] = 'Anvndaren finns inte';
$_lang["user_edit_self_msg"] = '<b>Efter att ha sparat kan du behva logga ut och sedan logga in igen fr att dina instllningar ska uppdateras fullstndigt.</b> Nya lsenord kommer att skickas till din e-postadress eller visas p skrmen.';
$_lang["user_email"] = 'E-postadress';
$_lang["user_failedlogincount"] = 'Misslyckade inloggningar';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Kvinna';
$_lang["user_full_name"] = 'Fullstndigt namn';
$_lang["user_gender"] = 'Kn';
$_lang["user_is_blocked"] = 'Denna anvndare r blockerad!';
$_lang["user_logincount"] = 'Antal inloggningar';
$_lang["user_male"] = 'Man';
$_lang["user_management_msg"] = 'Skapa nya anvndare av innehllshanteraren eller vlj en redan befintlig fr redigering. Dessa anvndare kan logga in i innehllshanteraren.';
$_lang["user_management_title"] = 'Anvndare av hanteraren';
$_lang["user_mobile"] = 'Mobilnummer';
$_lang["user_phone"] = 'Telefonnummer';
$_lang["user_photo"] = 'Anvndarfoto';
$_lang["user_photo_message"] = 'Skriv in skvgen till bilden fr den hr anvndaren, eller anvnd "Infoga"-knappen fr att ppna ett nytt fnster dr du kan vlja en bild och ladda upp den till servern.';
$_lang["user_prevlogin"] = 'Senaste inloggning';
$_lang["user_role"] = 'Anvndarens roll';
$_lang["user_state"] = 'Kommun';
$_lang["user_title"] = 'Skapa/redigera anvndare';
$_lang["user_upload_message"] = ' Om du vill hindra denna anvndare frn att ladda upp ngra filtyper i den hr kategorin, se d till att "Anvnd systemets konfigurationsinstllning" inte r frbockad och lmna fltet blankt.';
$_lang["user_use_config"] = 'Anvnd systemets konfigurationsinstllning';
$_lang["user_zip"] = 'Postnummer';
$_lang["username"] = 'Anvndarnamn';
$_lang["users"] = 'Skerhet';
$_lang["validate_referer_message"] = 'Kontrollera HTTP_REFERER-headers fr att minska risken fr att dina innehllsredaktrer ska kunna luras att utfra oavsiktliga handlingar i redigeraren, pga att de blivit offer fr CSRF-attacker (Cross Site Request Forgery). Det r mjligt att vissa konfigurationer inte kan anvnda denna kontroll om servern inte skickar ngra HTTP_REFERER-headers.';
$_lang["validate_referer_title"] = 'Kontrollera HTTP_REFERER-headers?';
$_lang["value"] = 'Vrde';
$_lang["version_codename"] = 'Versionens kodnamn'; 
$_lang["view"] = 'Visa';
$_lang["view_child_resources_in_container"] = 'Underresurser';
$_lang["view_log"] = 'Visa logg';
$_lang["view_logging"] = 'Aktiviteter i hanteraren';
$_lang["view_sysinfo"] = 'Systeminformation';
$_lang["warning"] = 'Varning!';
$_lang["warning_not_saved"] = 'De ndringar du gjort har nnu inte sparats. Du kan vlja att stanna kvar p den nuvarande sidan och spara ndringarna (\"Avbryt\"), eller s kan du lmna sidan, och frlora alla ndringar du gjort (\"OK\").';
$_lang["warning_visibility"] = 'Konfigurationsvarningar synliga fr';
$_lang["warning_visibility_message"] = 'Kontrollera synligheten p de konfigurationsvarningar som visas p hanterarens vlkomstsida';
$_lang["web_access_permissions"] = 'Rttigheter fr webbtkomst';
$_lang["web_access_permissions_user_groups"] = 'Webbanvndargrupper';
$_lang["web_permissions"] = 'Rttigheter fr webbtkomst';
$_lang["web_user_management_msg"] = 'Skapa nya webbanvndare eller vlj en redan befintlig fr redigering. Webbanvndare r anvndare som endast kan logga in till webbplatsen (inte till innehllshanteraren).';
$_lang["web_user_management_title"] = 'Webbanvndare';
$_lang["web_user_title"] = 'Skapa/redigera webbanvndare';
$_lang["web_users"] = 'Webbanvndare';
$_lang["weblink"] = 'Webblnk';
$_lang["weblink_message"] = 'En webblnk r en referens till ett objekt p internet. Det kan vara en resurs i MODx, en sida p en annan webbplats eller en bild eller en annan fil p internet.';
$_lang["webpwdreminder_message"] = 'Skriv ett meddelande som skickas till dina webbanvndare nr de begrt ett nytt lsenord via e-post. Innehllshanteraren kommer att skicka ett e-postmeddelande med deras nya lsenord och aktiveringsinformation.<br /><b>Notera:</b> Fljande platshllare erstts av innehllshanteraren nr ett meddelande skickas:<br /><br />[+sname+] - Namnet p din webbplats<br />[+saddr+] - E-postadressen till din webbplats<br />[+surl+] - Adressen till din webbplats<br />[+uid+] - Anvndarens inloggningsnamn eller ID<br />[+pwd+] - Anvndarens lsenord<br />[+ufn+] - Anvndarens namn<br /><br /><b>Lmna [+uid+] och [+pwd+] i meddelandet, annars fr inte mottagaren av e-posten reda p sitt nya anvndarnamn och lsenord!</b>';
$_lang["webpwdreminder_title"] = 'E-post fr webbpminnelse';
$_lang["websignupemail_message"] = 'Ange det meddelande som skickas till anvndare med deras anvndarnamn och lsenord nr konton skapas.<br /><b>Notera:</b> Fljande platshllare erstts av innehllshanteraren nr meddelandet skickas:<br /><br />[+sname+] - Namnet p din webbplats<br />[+saddr+] - E-postadressen till din webbplats<br />[+surl+] - Adressen till din webbplats<br />[+uid+] - Anvndarens inloggningsnamn eller ID<br />[+pwd+] - Anvndarens lsenord<br />[+ufn+] - Anvndarens namn<br /><br /><b>Lmna [+uid+] och [+pwd+] i meddelandet, annars fr inte mottagaren av e-posten reda p sitt anvndarnamn och lsenord!</b>';
$_lang["websignupemail_title"] = 'E-post fr webbregistreringar';
$_lang["wednesday"] = 'Onsdag';
$_lang["welcome_messages"] = 'Din Inkorg innehller <b>%d</b> meddelande(n), av vilka <b>%s</b> r olst(a).';
$_lang["welcome_title"] = 'Vlkommen till webbpubliceringsverktyget MODx';
$_lang["which_editor_message"] = 'Vlj vilken richtext-editor du vill anvnda. Du kan ladda ner och installera fler richtext-editorer frn MODx nedladdningssida.';
$_lang["which_editor_title"] = 'Editor att anvnda';
$_lang["working"] = 'Arbetar...';
$_lang["wrap_lines"] = 'Radbryt';
$_lang["xhtml_urls_message"] = 'Erstter et-tecken (&amp;) i URLer som genereras av MODx med den validerande &amp;<!-- -->amp; html-entiteten.';
$_lang["xhtml_urls_title"] = 'XHTML-URL:er';
$_lang["yes"] = 'Ja';
$_lang["you_got_mail"] = 'Du har ftt e-post';
$_lang["yourinfo_message"] = 'Denna sektion visar information om dig.';
$_lang["yourinfo_previous_login"] = 'Din senaste inloggning';
$_lang["yourinfo_role"] = 'Din roll r';
$_lang["yourinfo_title"] = 'Din information';
$_lang["yourinfo_total_logins"] = 'Totalt antal inloggningar';
$_lang["yourinfo_username"] = 'Du r inloggad som';
?>