<?php
/**
 * Filename:       includes/lang/russian-UTF8.inc.php
 * Function:       Russian language file.
 * Encoding:       UTF8
 * Author:         Russian MODx community, gabdullin, Jaroslav Sidorkin, Safronovich Victor, MARDEN
 * Date:           9 May 2010
 * Version:        2.0.5
 * MODx version:   Evolution 1.0.4
*/
$modx_lang_attribute = 'ru'; // Manager HTML/XML Language Attribute see http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'UTF-8';
setlocale (LC_ALL, 'ru_RU.UTF-8');

$_lang["about_msg"] = 'MODx - это <a href="http://modxcms.com/what-is-modx.html" target="_blank">PHP Application Framework и Content Management System</a>, распространяемая по лицензии <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'О MODx';
$_lang["access_permission_denied"] = 'У вас недостаточно прав для просмотра данного ресурса.';
$_lang["access_permission_parent_denied"] = 'У вас недостаточно прав для создания ресурса в данном разделе';
$_lang["access_permissions"] = 'Права доступа';
$_lang["access_permissions_add_resource_group"] = 'Создать новую группу ресурсов';
$_lang["access_permissions_add_user_group"] = 'Создать новую пользовательскую группу';
$_lang["access_permissions_docs_collision"] = 'Так как группы веб-пользователей и менеджеров конфликтуют с вашей ролью, этот ресурс будет доступен для всех.';
$_lang["access_permissions_docs_message"] = 'Здесь вы можете выбрать, к каким группам ресурсов принадлежит этот ресурс.';
$_lang["access_permissions_group_link"] = 'Создать новую связь группы пользователей и группы ресурсов';
$_lang["access_permissions_introtext"] = 'Здесь вы можете управлять доступом групп пользователей к группам ресурсов. Чтобы добавить пользователя в группу, при редактировании его выберите группу, к которой он будет принадлежать. Ресурс также можно добавить в группу при его редактировании.';
$_lang["access_permissions_link_to_group"] = 'с группой ресурсов';
$_lang["access_permissions_link_user_group"] = 'Связать группу пользователей';
$_lang["access_permissions_links"] = 'Связи групп пользователей и групп ресурсов';
$_lang["access_permissions_links_tab"] = 'Здесь можно определить, какие группы пользователей имеют доступ (то есть создавать и редактировать) к группам ресурсов. Чтобы привязать группу ресурсов к пользовательской группе, выберите группу из списка и нажмите \'Выполнить\'. Чтобы удалить привязку к группе, нажмите \'Удалить\'.';
$_lang["access_permissions_no_resources_in_group"] = 'Нет ресурсов.';
$_lang["access_permissions_no_users_in_group"] = 'Нет пользователей.';
$_lang["access_permissions_off"] = '<span class="warning">Права доступа не активированы.</span> Это означает, что никакие изменения не вступят в силу, до тех пор пока вы не измените настройки.';
$_lang["access_permissions_resource_groups"] = 'Группы ресурсов';
$_lang["access_permissions_resources_in_group"] = '<b>ресурсов в группе:</b> ';
$_lang["access_permissions_resources_tab"] = 'Здесь вы можете увидеть все группы ресурсов. Также, здесь вы можете создать, переименовать, удалить группу, просмотреть ресурсы в группе. Для добавления или удаления ресурса из группы редактируйте ресурс непосредственно.';
$_lang["access_permissions_user_groups"] = 'Группы пользователей';
$_lang["access_permissions_user_message"] = 'Здесь вы можете выбрать, к какой пользовательской группе принадлежит этот пользователь:';
$_lang["access_permissions_users_in_group"] = 'Пользователей в группе:';
$_lang["access_permissions_users_tab"] = 'Здесь вы можете увидеть все группы пользователей. Также, здесь вы можете создать, переименовать, удалить группу, просмотреть членов группы. Для добавления или удаления пользователя из группы редактируйте пользователя непосредственно. Менеджеры всегда имеют доступ ко всем ресурсам.';
$_lang["account_email"] = 'E-mail учетной записи';
$_lang["actioncomplete"] = '<b>Действие успешно завершено</b><br />Пожалуйста, подождите, пока MODx произведет очистку.';
$_lang["activity_message"] = 'Этот список показывает недавно созданные или отредактированные ресурсы:';
$_lang["activity_title"] = 'Недавно созданные/отредактированные ресурсы';
$_lang["add"] = 'Создать';
$_lang["add_chunk"] = 'Чанк';
$_lang["add_doc"] = 'Ресурс';
$_lang["add_folder"] = 'Новая папка';
$_lang["add_plugin"] = 'Плагин';
$_lang["add_resource"] = 'Новый ресурс';
$_lang["add_snippet"] = 'Сниппет';
$_lang["add_tag"] = 'Создать тег';
$_lang["add_template"] = 'Шаблон';
$_lang["add_tv"] = 'Параметр (TV)';
$_lang["add_weblink"] = 'Новая ссылка';
$_lang["administrator_role_message"] = 'Эту роль невозможно редактировать или удалить.';
$_lang["administrators"] = 'Администраторам';
$_lang["after_saving"] = 'После сохранения';
$_lang["alert_delete_self"] = 'Вы не можете удалить себя :)';
$_lang["alias"] = 'Псевдоним';
$_lang["all_doc_groups"] = 'Без группы (доступен для всех)';
$_lang["all_events"] = 'Все события';
$_lang["all_usr_groups"] = 'Все группы (доступен для всех)';
$_lang["allow_mgr_access"] = 'Доступ к интерфейсу системы управления сайтом';
$_lang["allow_mgr_access_message"] = 'Выберите этот параметр для разрешения / запрета доступа к системе управления сайтом. <b>ПРИМЕЧАНИЕ:</b> если параметр отключен, пользователь будет направлен на стартовую страницу системы управления или на начальную страницу сайта.';
$_lang["already_deleted"] = 'уже удален.';
$_lang["attachment"] = 'Прикрепленное';
$_lang["automatic_alias_message"] = 'Выберите \'Да\' для того, чтобы система автоматически генерировала псевдонимы на основе заголовков страниц (для транслитерации русских символов настройте плагин TransAlias).';
$_lang["automatic_alias_title"] = 'Автоматически генерировать псевдоним:';
$_lang["backup"] = 'Резервное копирование';
$_lang["bk_manager"] = 'Резервное копирование';
$_lang["block_message"] = 'После сохранения пользователь будет заблокирован.';
$_lang["blocked_minutes_message"] = 'Здесь вы можете ввести время в минутах, на которое пользователь будет заблокирован, если он достигнет максимального количества разрешенных неудачных попыток входа в систему. Пожалуйста, введите это значение как число (не используйте знаков препинания, пробелов и т.д.)';
$_lang["blocked_minutes_title"] = 'Время блокирования:';
$_lang["cache_files_deleted"] = 'Следующие файлы были удалены:';
$_lang["cancel"] = 'Отмена';
$_lang["captcha_code"] = 'Код подтверждения';
$_lang["captcha_message"] = 'Включите для усиления безопасности. Для авторизации необходимо будет ввести код, нераспознаваемый разного рода скриптами (показанный в виде графического изображения).';
$_lang["captcha_title"] = 'Использовать код CAPTCHA:';
$_lang["captcha_words_default"] = 'MODx,Access,Better,BitCode,Chunk,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Oscope,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Tattoo,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote';
$_lang["captcha_words_message"] = 'Здесь вы можете задать список слов для генерирования кода CAPTCHA. Слова в списке должны разделяться запятыми.';
$_lang["captcha_words_title"] = 'Слова для генерации CAPTCHA-кодов:';
$_lang["category_heading"] = 'Категория';
$_lang["category_msg"] = 'Здесь вы можете просматривать и редактировать все элементы, сгруппированные по категориям.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Изменить имя';
$_lang["change_password"] = 'Изменить пароль';
$_lang["change_password_confirm"] = 'Подтвердить пароль';
$_lang["change_password_message"] = 'Введите новый пароль, затем введите его еще раз для подтверждения. Длина пароля должна составлять от 6 до 15 символов.';
$_lang["change_password_new"] = 'Новый пароль';
$_lang["charset_message"] = 'Выберите кодировку страниц сайта. Помните, что MODx тестировался не на всех кодировках. Для большинства языков подходит кодировка ISO-8859-1.';
$_lang["charset_title"] = 'Кодировка:';
$_lang["chunk"] = 'Чанк (HTML-элемент шаблона)';
$_lang["chunk_code"] = 'Код чанка (HTML)';
$_lang["chunk_multiple_id"] = 'Ошибка: Несколько чанков имеют одинаковый идентификатор.';
$_lang["chunk_no_exist"] = 'Чанк не найден.';
$_lang["cleaningup"] = 'Очистка...';
$_lang["clear_log"] = 'Очистить протокол';
$_lang["click_to_context"] = 'Контекстное меню';
$_lang["click_to_edit_title"] = 'Редактировать запись';
$_lang["click_to_view_details"] = 'Детали';
$_lang["close"] = 'Закрыть';
$_lang["code"] = 'Код';
$_lang["collapse_tree"] = 'Свернуть дерево';
$_lang["comment"] = 'Комментарий';
$_lang["configcheck_admin"] = 'Пожалуйста, свяжитесь с системным администратором и сообщите об этой ошибке';
$_lang["configcheck_cache"] = 'невозможна запись в папку кэширования';
$_lang["configcheck_cache_msg"] = 'MODx не в состоянии записывать данные в папку кэширования. Система будет работать нормально, но кэширования происходить не будет. Для решения проблемы разрешите запись в папку <b>/assets/cache<b>.';
$_lang["configcheck_configinc"] = 'Файл конфигурации все еще доступен для записи';
$_lang["configcheck_configinc_msg"] = 'Злоумышленники потенциально могут нанести вред вашему сайту. <strong>Серьёзно.</strong> Пожалуйста, установите права доступа к файлу конфигурации (/manager/includes/config.inc.php) в режим \'Только для чтения\'';
$_lang["configcheck_default_msg"] = 'Неопределенная ошибка.';
$_lang["configcheck_errorpage_unavailable"] = 'Страница сообщения об ошибке, указанная в конфигурации сайта, недоступна.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Это означает, что она не существует или недоступна обычным посетителям сайта. Это может привести к циклическому вызову функции \'сообщения об ошибке\' и большому количеству записей в журнале сайта. Убедитесь, что нет групп веб-пользователей, которым назначена эта страница.';
$_lang["configcheck_errorpage_unpublished"] = 'Страница сообщения об ошибке, указанная в конфигурации сайта, не опубликована.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Это означает, что она недоступна посетителям сайта. Необходимо опубликовать страницу сообщения об ошибке, чтобы эта функция работала правильно.';
$_lang["configcheck_images"] = 'Папка изображений (images) недоступна для записи';
$_lang["configcheck_images_msg"] = 'Папка изображений (images) недоступна для записи или не существует на сервере. Из этого следует, что управление изображениями работать не будет';
$_lang["configcheck_installer"] = 'Не удалена папка с файлами, использовавшимися в процессе установки';
$_lang["configcheck_installer_msg"] = 'Папка /install содержит инсталляционные файлы системы MODx. Злоумышленники могут воспользоваться этими файлами для взлома/повреждения сайта, так что лучше удалить папку с сервера.';
$_lang["configcheck_lang_difference"] = 'Неверное количество записей в языковом пакете.';
$_lang["configcheck_lang_difference_msg"] = 'Текущий языковой пакет имеет количество записей, отличное от требуемого. Несмотря на то, что система будет работать нормально, возможно, языковой пакет нуждается в доработке.';
$_lang["configcheck_notok"] = 'Конфигурация содержит ошибки.';
$_lang["configcheck_ok"] = 'Конфигурация не содержит ошибок.';
$_lang["configcheck_php_gdzip"] = 'GD и/или Zip PHP расширения не найдены';
$_lang["configcheck_php_gdzip_msg"] = 'Для нормальной работы MODx необходимо, чтобы были разрешены GD и Zip расширения для PHP. MODx будет работать и без этих расширений, но вы не сможете использовать все возможности встроенного файл-менеджера, редактора изображений или код CAPTCHA для авторизации.'; 
$_lang["configcheck_register_globals"] = 'Параметр \'register_globals\' имеет значение \'ON\' в конфигурационном файле \'php.ini\'.';
$_lang["configcheck_register_globals_msg"] = 'Такая конфигурация делает ваш сайт значительно более уязвимым для Cross Site Scripting (XSS) атак. Обратитесь в службу поддержки вашего хостинга за информацией, каким образом выключить этот параметр.';
$_lang["configcheck_title"] = 'Проверка конфигурации';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Страница сообщения об ограниченном доступе, указанная в конфигурации сайта, не опубликована или не существует.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Это означает, что она не существует или недоступна обычным посетителям сайта. Это может привести к рекурсивному вызову функции \'сообщения об ошибке\' и большому количеству записей в журнале сайта. Убедитесь, что нет групп веб-пользователей, которым назначена эта страница.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'Страница сообщения об ограниченном доступе, указанная в конфигурации сайта, не опубликована.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Это означает, что она недоступна посетителям сайта. Необходимо опубликовать страницу сообщения об ограничении доступа, чтобы эта функция работала правильно.';
$_lang["configcheck_validate_referer"] = 'Предупреждение безопасности: проверка заголовка HTTP';
$_lang["configcheck_validate_referer_msg"] = "В конфигурации параметр <strong>Проверять серверные заголовки HTTP_REFERER?</strong> отключен. Мы рекомендуем ее включить. <a href=\"index.php?a=17\">Перейти к настройке конфигурации</a><br /><a href=\"javascript:hideHeaderVerificationWarning();\"><em>Не показывать больше это сообщение.</em></a>";
$_lang["configcheck_warning"] = 'Ошибка конфигурации:';
$_lang["configcheck_what"] = 'Что это значит?';
$_lang["confirm_block"] = 'Вы уверены, что хотите заблокировать пользователя?';
$_lang["confirm_delete_eventlog"] = 'Вы уверены, что хотите удалить протокол событий?';
$_lang["confirm_delete_file"] = 'Вы уверены, что хотите удалить файл? \n\nЭто может вызвать проблемы с работой сайта. Удаляйте файл, только если вы на 100% уверены, что работа сайта не пострадает.';
$_lang["confirm_delete_htmlsnippet"] = 'Вы уверены, что хотите удалить этот чанк?';
$_lang["confirm_delete_keywords"] = 'Вы уверены, что хотите удалить эти ключевые слова?';
$_lang["confirm_delete_module"] = 'Вы уверены, что хотите удалить этот модуль?';
$_lang["confirm_delete_plugin"] = 'Вы уверены, что хотите удалить этот плагин?';
$_lang["confirm_delete_record"] = 'Вы уверены, что хотите удалить эти записи?';
$_lang["confirm_delete_resource"] = 'Вы уверены, что хотите удалить этот ресурс? \nВсе дочерние ресурсы будут также удалены.';
$_lang["confirm_delete_role"] = 'Вы уверены, что хотите удалить эту роль?';
$_lang["confirm_delete_snippet"] = 'Вы уверены, что хотите удалить этот сниппет?';
$_lang["confirm_delete_tags"] = 'Вы уверены, что хотите удалить выбранные META-теги?';
$_lang["confirm_delete_template"] = 'Вы уверены, что хотите удалить этот шаблон?';
$_lang["confirm_delete_tmplvars"] = 'Вы уверены, что хотите удалить этот параметр (TV) и все сохраненные в нем данные?';
$_lang["confirm_delete_user"] = 'Вы уверены, что хотите удалить этого пользователя?';
$_lang["confirm_duplicate_record"] = 'Вы уверены, что хотите сделать копию этой записи?';
$_lang["confirm_empty_trash"] = 'Удалить ВСЕ помеченные на удаление файлы навсегда? \n\nПродолжить?';
$_lang["confirm_load_depends"] = 'Вы уверены, что хотите загрузить панель Управления зависимостями без сохранения изменений?';
$_lang["confirm_name_change"] = 'Изменение имени пользователя может повлиять на работу некоторых дополнений системы MODx. \n\nВы уверены, что хотите изменить имя пользователя?';
$_lang["confirm_publish"] = '\n\nПубликация этого ресурса сейчас удалит все предустановленные расписания публикации. Если вы хотите установить новое расписание или оставить старое – выберите пункт \'Редактировать\'.\n\nПродолжить?';
$_lang["confirm_remove_locks"] = 'Пользователи иногда закрывают браузер в процессе редактирования ресурсов, шаблонов, сниппетов и т.д., оставляя их заблокированными. Нажимая \'ОК\', вы удаляете все текущие блокировки. \n\nПродолжить?';
$_lang["confirm_resource_duplicate"] = 'Вы уверены, что хотите сделать копию этого ресурса? \nВсе дочерние ресурсы будут также скопированы.';
$_lang["confirm_setting_language_change"] = 'Вы изменили значение по умолчанию, выполненные ранее исправления будут утеряны. Продолжить?';
$_lang["confirm_unblock"] = 'Вы уверены, что хотите разблокировать этого пользователя?';
$_lang["confirm_undelete"] = '\n\nВсе дочерние ресурсы, удаленные вместе с этим ресурсом, будут восстановлены. Однако ресурсы, удаленные ранее, не будут восстановлены.';
$_lang["confirm_unpublish"] = '\n\nОтмена публикации этого ресурса сейчас удалит все предустановленные расписания публикации. Если вы хотите установить новое расписание или оставить старое - выберите пункт \'Редактировать\'.\n\nПродолжить?';
$_lang["confirm_unzip_file"] = 'Вы уверены, что хотите распаковать архив? \n\nСуществующие файлы будут перезаписаны.';
$_lang["could_not_find_user"] = 'Не могу найти пользователя';
$_lang["create_folder_here"] = 'Дочерний контейнер';
$_lang["create_resource_here"] = 'Дочерний ресурс';
$_lang["create_resource_title"] = 'Создать ресурс';
$_lang["create_weblink_here"] = 'Дочерняя ссылка';
$_lang["createdon"] = 'Дата создания';
$_lang["credits"] = 'MODx использует';
$_lang["credits_shouts_msg"] = '<p>MODx поддерживается на сайте <a href="http://modxcms.com/about/" target="_blank">MODxCMS.com</a>.</p>';
$_lang["custom_contenttype_message"] = 'Здесь вы можете добавить типы содержимого (Content-Type) для сайта. Для этого введите тип содержимого и нажмите \'Добавить\'.';
$_lang["custom_contenttype_title"] = 'Типы содержимого (Content-Type):';
$_lang["database_charset"] = 'Кодировка базы данных';
$_lang["database_collation"] = 'Сопоставление базы данных';
$_lang["database_name"] = 'Имя базы данных';
$_lang["database_overhead"] = '<b style="color:#990033;">ПРИМЕЧАНИЕ:</b> \'перерасход\' – это неиспользуемое, но зарезервированное MySQL пространство. Чтобы освободить это место, нажмите \'Перерасход\' в таблице (таблицах).';
$_lang["database_server"] = 'Сервер базы данных';
$_lang["database_table_clickbackup"] = ' чтобы создать и загрузить резервную копию выбранных таблиц';
$_lang["database_table_clickhere"] = 'Нажмите здесь,';
$_lang["database_table_datasize"] = 'Объём данных';
$_lang["database_table_droptablestatements"] = 'Включать в дамп инструкцию \'DROP TABLE\'';
$_lang["database_table_effectivesize"] = 'Занимаемый объём';
$_lang["database_table_indexsize"] = 'Объём индекса';
$_lang["database_table_overhead"] = 'Перерасход';
$_lang["database_table_records"] = 'Записи';
$_lang["database_table_tablename"] = 'Название таблицы';
$_lang["database_table_totals"] = 'Всего:';
$_lang["database_table_totalsize"] = 'Общий объём';
$_lang["database_tables"] = 'Таблицы базы данных';
$_lang["database_version"] = 'Версия базы данных:';
$_lang["date"] = 'Дата';
$_lang["datechanged"] = 'Дата изменения';
$_lang["datepicker_offset"] = 'Смещение лет: ';
$_lang["datepicker_offset_message"] = 'Число прошлых лет, которое будет показано в окне выбора даты.';
$_lang["datetime_format"] = 'Формат даты:';
$_lang["datetime_format_message"] = 'Выберите формат даты, который будет использован в системе управления.';
$_lang["default"] = 'По умолчанию:';
$_lang["defaultcache_message"] = 'Выберите \'Да\', чтобы новые ресурсы после создания кэшировались по умолчанию.';
$_lang["defaultcache_title"] = '\'Кэшируемый\' по умолчанию:';
$_lang["defaultmenuindex_message"] = 'Выберите \'Да\', чтобы включить автоматическое добавление пункта в меню.';
$_lang["defaultmenuindex_title"] = '\'Добавить в меню\' по умолчанию:';
$_lang["defaultpublish_message"] = 'Выберите \'Да\', чтобы новые ресурсы после создания публиковались по умолчанию.';
$_lang["defaultpublish_title"] = '\'Публиковать\' по умолчанию:';
$_lang["defaultsearch_message"] = 'Выберите \'Да\', чтобы новые ресурсы после создания были доступны для поиска по умолчанию.';
$_lang["defaultsearch_title"] = '\'Доступен для поиска\' по умолчанию:';
$_lang["defaulttemplate_message"] = 'Выберите шаблон, который будет применяться к новым ресурсам по умолчанию. При редактировании ресурса вы можете установить любой шаблон.';
$_lang["defaulttemplate_title"] = 'Шаблон по умолчанию:';
$_lang["delete"] = 'Удалить';
$_lang["delete_resource"] = 'Удалить';
$_lang["delete_tags"] = 'Удалить теги';
$_lang["deleting_file"] = 'Удаляется файл `%s`: ';
$_lang["description"] = 'Описание';
$_lang["deselect_keywords"] = 'Удалить ключевые слова';
$_lang["deselect_metatags"] = 'Удалить META-теги';
$_lang["disabled"] = 'Отключен';
$_lang["doc_data_title"] = 'Обзор ресурса';
$_lang["duplicate"] = 'Сделать копию';
$_lang["duplicate_alias_found"] = 'Ресурс \'%s\' уже использует псевдоним \'%s\'. Введите уникальный псевдоним.';
$_lang["duplicate_alias_message"] = 'Выберите \'Да\', чтобы разрешить повторение псевдонимов. <b>ПРИМЕЧАНИЕ:</b> этот параметр должна использоваться вместе с включенной функцией \'Использовать вложенные URL\'.';
$_lang["duplicate_alias_title"] = 'Разрешить повторяющиеся псевдонимы:';
$_lang["duplicate_name_found_general"] = 'Объект %s с именем \'%s\' уже существует. Пожайлуста, введите другое имя.';
$_lang["duplicate_name_found_module"] = 'Модуль с именем \'%s\' уже существует. Пожайлуста, введите другое имя.';
$_lang["edit"] = 'Редактировать';
$_lang["edit_resource"] = 'Редактировать';
$_lang["edit_resource_title"] = 'Создать / редактировать ресурс';
$_lang["edit_settings"] = 'Конфигурация';
$_lang["editedon"] = 'Дата редактирования';
$_lang["editing_file"] = 'Редактируемый файл: ';
$_lang["editor_css_path_message"] = 'Введите путь к файлу CSS, который вы хотите использовать для редактора. Рекомендуется вводить путь от корня сайта, например: /assets/site/style.css. Если вы не хотите использовать CSS-файл для редактора, оставьте это поле пустым.';
$_lang["editor_css_path_title"] = 'Путь к CSS файлу:';
$_lang["element"] = 'Элемент';
$_lang["element_categories"] = 'Общий просмотр';
$_lang["element_management"] = 'Управление элементами';
$_lang["element_name"] = 'Название элемента';
$_lang["element_selector_msg"] = 'Выберите элемент(ы) из списка внизу и нажмите кнопку "Вставить".';
$_lang["element_selector_title"] = 'Выбор элемента';
$_lang["elements"] = 'Элементы';
$_lang["email"] = 'E-mail';
$_lang["email_sent"] = 'Письмо отправлено';
$_lang["emailsender_message"] = 'Укажите адрес e-mail, который будет отображен в письме подтверждения регистрации в поле \'От\'.';
$_lang["emailsender_title"] = 'Обратный адрес e-mail:';
$_lang["emailsubject_default"] = 'Данные для авторизации';
$_lang["emailsubject_message"] = 'Укажите текст, который будет отображен в письме подтверждения регистрации в поле \'Тема\'.';
$_lang["emailsubject_title"] = 'Тема письма подтверждения регистрации:';
$_lang["empty_folder"] = 'Папка пуста';
$_lang["empty_recycle_bin"] = 'Очистить корзину';
$_lang["empty_recycle_bin_empty"] = 'Нет ресурсов, помеченных на удаление.';
$_lang["enable_resource"] = 'Подключить файл элементов.';
$_lang["enable_sharedparams"] = 'Включить \'общие\' параметры';
$_lang["enable_sharedparams_msg"] = '<b>ПРИМЕЧАНИЕ:</b> вышеуказанный уникальный глобальный идентификатор (GUID) будет использован для идентификации этого модуля и общих параметров. GUID также используется для формирования связи модуля, плагинов или сниппетов, которые используют его общие параметры.';
$_lang["enabled"] = 'Включено';
$_lang["error"] = 'Ошибка';
$_lang["error_sending_email"] = 'Ошибка отправки e-mail';
$_lang["errorpage_message"] = 'Введите ID ресурса, который вы хотите использовать как страницу ошибки (404 - ресурс не найден). <b>ПРИМЕЧАНИЕ:</b> убедитесь, что этот ID принадлежит существующему ресурсу, и что этот ресурс опубликован';
$_lang["errorpage_title"] = 'Страница ошибки \'404\':';
$_lang["event_id"] = 'ID события';
$_lang["eventlog"] = 'Протокол событий';
$_lang["eventlog_msg"] = 'Протокол событий используется для отображения системных информационных сообщений, предупреждений и сообщений об ошибках. В колонке \'Код\' показан раздел системы управления, где произошло событие.';
$_lang["eventlog_viewer"] = 'Просмотр событий';
$_lang["everybody"] = 'Всем';
$_lang["existing_category"] = 'Существующие категории';
$_lang["expand_tree"] = 'Раскрыть дерево';
$_lang["export_site"] = 'Экспортировать сайт';
$_lang["export_site_cacheable"] = 'Экспортировать некэшируемые ресурсы:';
$_lang["export_site_exporting_document"] = 'Экспортируется файл <b>%s</b> из <b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = 'Ошибка';
$_lang["export_site_failed_no_open"] = 'Невозможно открыть файл:';
$_lang["export_site_failed_no_retrieve"] = 'Невозможно извлечь ресурс.';
$_lang["export_site_failed_no_write"] = 'Невозможно записать в файл.';
$_lang["export_site_html"] = 'Экспортировать сайт в HTML';
$_lang["export_site_maxtime"] = 'Максимальное время экспорта:';
$_lang["export_site_maxtime_message"] = 'Укажите максимальное количество секунд, в течение которых будет выполняться процесс экспорта сайта (пренебрегая настройками PHP). Введите 0 для неограниченного времени. Имейте в виду, что 0 или очень большое количество времени, заданные для процесса экспорта, могут привести к неадекватной работе сервера, поэтому такие значения задавать не рекомендуется.';
$_lang["export_site_message"] = '<p>Эта функция позволяет экспортировать сайт в HTML файлы целиком. Имейте в виду, что статический HTML-сайт имеет очень ограниченные возможности по сравнению с MODx-сайтом:</p><ul><li>не будет записываться статистика посещений;</li><li>интерактивные сниппеты работать не будут;</li><li>веб-ссылки экспортированы не будут;</li> <li>процесс экспорта может не удастся, если ресурсы содержат сниппеты с перенаправлением;</li><li>возможна неправильная работа дизайна шаблона вашего сайта. Во избежание этого экспортированные файлы должны находиться в корневой папке (там же, где и файл index.php системы MODx).</li></ul><p /><p>Пожалуйста, заполните форму и нажмите \'Начать экспорт\'. Файлы будут записаны в папку /assets/export, используя, где возможно, псевдонимы в качестве имен. При экспорте сайта рекомендуется в конфигурации MODx включить функцию \'Использовать псевдонимы в URL\'. Время экспорта зависит от размеров вашего сайта.</p><p><b>Существующие файлы с совпадающими именами будут заменены новыми.</b></p>';
$_lang["export_site_numberdocs"] = '<p><b>Найдено %s ресурсов для экспорта...</b></p>';
$_lang["export_site_prefix"] = 'Префикс файлов:';
$_lang["export_site_start"] = 'Начать экспорт';
$_lang["export_site_success"] = 'Экспорт завершен';
$_lang["export_site_success_skip_dir"] = 'Пропустить эту папку.';
$_lang["export_site_success_skip_doc"] = 'Пропустить этот ресурс.';
$_lang["export_site_suffix"] = 'Суффикс файлов:';
$_lang["export_site_target_unwritable"] = 'Папка экспорта недоступна для записи. Исправьте это и попробуйте снова.';
$_lang["export_site_time"] = 'Экспорт завершен. Процесс занял %s секунд.';
$_lang["failed_login_message"] = 'Здесь вы можете ввести количество неудачных попыток входа в систему, которые разрешены, прежде чем пользователь будет заблокирован.';
$_lang["failed_login_title"] = 'Лимит неудачных попыток входа в систему:';
$_lang["fe_editor_lang_message"] = 'Выберите язык редактора, который будет использоваться во фронтенде.';
$_lang["fe_editor_lang_title"] = 'Язык фронтенд-редактора:';
$_lang["file_delete_file"] = 'Удалить файл';
$_lang["file_delete_folder"] = 'Удалить папку';
$_lang["file_deleted"] = 'Удалено';
$_lang["file_download_file"] = 'Скачать файл';
$_lang["file_download_unzip"] = 'Распаковать файл';
$_lang["file_folder_chmod_error"] = 'Не удалось изменить права, необходимо установить нужные права вне MODx.';
$_lang["file_folder_created"] = 'Папка успешно создана';
$_lang["file_folder_deleted"] = 'Папка успешно удалена';
$_lang["file_folder_not_created"] = 'Невозможно создать папку';
$_lang["file_folder_not_deleted"] = 'Невозможно удалить папку. Убедитесь в том, что она пуста';
$_lang["file_not_deleted"] = 'Ошибка';
$_lang["file_not_saved"] = 'Невозможно сохранить файл';
$_lang["file_saved"] = 'Файл сохранен';
$_lang["file_unzip"] = 'Архив успешно распакован';
$_lang["file_unzip_fail"] = 'Архив не удалось распаковать';
$_lang["filemanager_path_message"] = 'Часто IIS неправильно выводит параметр document_root, который используется файл-менеджером. Установите правильный путь во избежание проблем с файл-менеджером.';
$_lang["filemanager_path_title"] = 'Путь для файл-менеджера:';
$_lang["files_access_denied"] = 'Доступ запрещен';
$_lang["files_data"] = 'Суммарный объём';
$_lang["files_dir_listing"] = 'Список файлов в папке: ';
$_lang["files_directories"] = 'Папки';
$_lang["files_dirwritable"] = 'Разрешена запись в папку?';
$_lang["files_editfile"] = 'Редактировать файл';
$_lang["files_file_type"] = 'Тип файла: ';
$_lang["files_filename"] = 'Имя файла';
$_lang["files_fileoptions"] = 'Параметры';
$_lang["files_files"] = 'Файлы';
$_lang["files_filesize"] = 'Размер файла';
$_lang["files_filetype_notok"] = 'Загрузка файлов такого типа запрещена';
$_lang["files_modified"] = 'Изменен';
$_lang["files_top_level"] = 'На корневой уровень';
$_lang["files_up_level"] = 'На уровень выше';
$_lang["files_upload_copyfailed"] = 'Не удалось скопировать файл в нужную папку - загрузка прервана!';
$_lang["files_upload_error"] = 'Ошибка';
$_lang["files_upload_error0"] = 'Возникла проблема во время загрузки.';
$_lang["files_upload_error1"] = 'Файл, который вы пытаетесь загрузить, слишком велик.';
$_lang["files_upload_error2"] = 'Файл, который вы пытаетесь загрузить, слишком велик.';
$_lang["files_upload_error3"] = 'Файл, который вы пытались загрузить, загружен лишь частично.';
$_lang["files_upload_error4"] = 'Вы должны выбрать файл для загрузки.';
$_lang["files_upload_error5"] = 'Возникли проблемы с загрузкой.';
$_lang["files_upload_inhibited_msg"] = '<b>Функция загрузки файлов на сервер файлов недоступна</b> - убедитесь, что папка доступна PHP для записи.';
$_lang["files_upload_ok"] = 'Файл успешно загружен';
$_lang["files_upload_permissions_error"] = 'Возможно ошибка прав доступа - папка, в которую вы хотите загрузить данные, не доступна для записи на вашем сервере.';
$_lang["files_uploadfile"] = 'Загрузить';
$_lang["files_uploadfile_msg"] = 'Выберите файлы для загрузки:';
$_lang["files_uploading"] = 'Загружается файл <b>%s</b> в <b>%s/</b><br />';
$_lang["files_viewfile"] = 'Просмотр файла';
$_lang["folder"] = 'Папка';
$_lang["forgot_password_email_fine_print"] = '* Указанный адрес станет недействительным, как только вы поменяете пароль (или автоматически послезавтра).';
$_lang["forgot_password_email_instructions"] = 'Оттуда вы сможете изменить свой пароль, редактируя учетную запись.';
$_lang["forgot_password_email_intro"] = 'Был сделан запрос на изменение пароля вашей учетной записи.';
$_lang["forgot_password_email_link"] = 'Нажмите здесь для завершения процесса.';
$_lang["forgot_your_password"] = 'Забыли свой пароль?';
$_lang["friday"] = 'Пятница';
$_lang["friendly_alias_message"] = 'Если сайт использует дружественные URL, и ресурс имеет псевдоним, то при включении этого параметра URL ресурса будет иметь вид: \'http://mysite.com/псевдоним\'. Если определены суффикс (например \'.html\') и/или префикс (например \'page-\') дружественных URL, адрес страницы будет следующий: \'http://mysite.com/page-псевдоним.html\'. Если не заданы псевдонимы, суффиксы и префиксы, MODx сгенерирует такой URL: \'http://mysite.com/2\', где 2 - ID ресурса.';
$_lang["friendly_alias_title"] = 'Использовать псевдонимы в URL:';
$_lang["friendlyurls_message"] = 'Данный параметр позволяет разрешить использование дружественных URL на сайте. Помните, что данная возможность доступна лишь тогда, когда MODx работает на сервере Apache с установленным mod_rewrite; кроме того, необходимо изменить файл .htaccess. Для информации по подробным настройкам посмотрите файл .htaccess, входящий в дистрибутив MODx.';
$_lang["friendlyurls_title"] = 'Использовать дружественные URL:';
$_lang["friendlyurlsprefix_message"] = 'Здесь вы можете указать особый префикс для дружественных URL. Например, если в качестве такого префикса вы укажете слово \'page\', то URL типа /index.php?id=2 будет преобразован в /page2.html (в качестве суффикса URL здесь выступает \'.html\').';
$_lang["friendlyurlsprefix_title"] = 'Префикс для дружественных URL:';
$_lang["friendlyurlsuffix_message"] = 'Здесь вы можете указать суффикс для дружественных URL. Указав \'.html\', вы добавите .html ко всем дружественным URL.';
$_lang["friendlyurlsuffix_title"] = 'Суффикс для дружественных URL:';
$_lang["functionnotimpl"] = 'Увы';
$_lang["functionnotimpl_message"] = 'Эта функция еще не используется данной версией MODx.';
$_lang["go"] = 'Перейти';
$_lang["group_access_permissions"] = 'Доступ групп пользователей';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Помощь';
$_lang["help_msg"] = '<p>Вы можете получить бесплатную помощь сообщества MODx <a href="http://modxcms.com/forums" target="_blank">на форумах MODx</a>. Смотрите также <a href="http://modxcms.com/documentation" target="_blank">\'Документация и уроки по MODx\'</a>, где подробно описан каждый аспект системы.</p>';
$_lang["help_title"] = 'Помощь';
$_lang["hide_tree"] = 'Спрятать дерево';
$_lang["home"] = 'Главная';
$_lang["htmlsnippet_desc"] = 'Описание';
$_lang["htmlsnippet_management_msg"] = '<b>Чанки</b> - это куски (X)HTML-кода, используемые в неизменном виде в нескольких местах. Чтобы иметь возможность централизованно редактировать повторяющийся код, вынесите его в чанк. Чанки не могут прямо содержать исполняемый код, однако могут включать в себя вызовы <i>сниппетов</i> и/или  <i>параметров (TV)</i>, обеспечивающих динамическую логику.</p><p><b>Использование:</b> вставьте <code>{{chunkName}}</code> где-либо в <i>шаблоне</i>, в <i>области контента</i>, в коде другого чанка или в <i>параметре (TV)</i>.</p><p><b>Вызов через MODx API:</b> <code>$modx->getChunk(\'chunkName\'); $modx->putChunk(\'chunkName\');</code></p><p><br />Выберите чанк для редактирования или создайте новый.';
$_lang["htmlsnippet_msg"] = 'Здесь вы можете создать / отредактировать чанк. <br /> Помните, чанки – чистый HTML-код, и любые php-скрипты выполняться в них не будут. <br /><br /> ';
$_lang["htmlsnippet_name"] = 'Название чанка';
$_lang["htmlsnippet_title"] = 'Создать / редактировать чанк';
$_lang["icon"] = 'Значок';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Смена родительского ресурса: \n\nресурс является дочерним к выбранному.';
$_lang["illegal_parent_self"] = 'Смена родительского ресурса: \n\nвыбранный ресурс не может быть присвоен как родитель самому себе.';
$_lang["import_files_found"] = '<b>Найдено %s ресурсов для импорта...</b>';
$_lang["import_params"] = 'Импортировать общие параметры модуля';
$_lang["import_params_msg"] = 'Вы можете импортировать параметры и установки модуля, выбрав его название из списка вверху. <b>ПРИМЕЧАНИЕ:</b> для того, чтобы модули отображались в меню, этот плагин/сниппет должен быть одной из зависимостей модуля и у модуля должны быть включены общие параметры.';
$_lang["import_parent_resource"] = 'Родительский ресурс:';
$_lang["import_site"] = 'Импортировать сайт';
$_lang["import_site_failed"] = 'Ошибка';
$_lang["import_site_failed_db_error"] = 'Во время копирования ресурса произошла ошибка в базе данных: ';
$_lang["import_site_failed_no_open_dir"] = 'Невозможно открыть папку: ';
$_lang["import_site_failed_no_retrieve_file"] = 'Невозможно извлечь файл: ';
$_lang["import_site_html"] = 'Импортировать сайт из HTML';
$_lang["import_site_importing_document"] = 'Импортируется файл <b>%s</b>';
$_lang["import_site_maxtime"] = 'Максимальное время импорта:';
$_lang["import_site_maxtime_message"] = 'Здесь вы можете указать, сколько секунд может занять процесс импорта (переопределение установок PHP). Введите 0, чтобы задать неограниченное время. Имейте в виду, что 0 или очень большой промежуток времени, заданные для процесса импорта, могут привести к неадекватной работе сервера, поэтому такие значения задавать не рекомендуется.';
$_lang["import_site_message"] = 'Используя эту функцию, вы можете импортировать сайт из HTML в базу данных. Учтите, что все HTML-файлы нужно скопировать в папку \'assets/import\'. <br /><br />Заполните форму, выберите родительский ресурс в дереве сайта и нажмите \'Начать импорт\' для начала процесса. Файлы будут скопированы в указанное место, используя, где возможно, имена файлов как псевдонимы и заголовки страниц как названия ресурсов. <br /><br />';
$_lang["import_site_skip"] = 'Пропущен';
$_lang["import_site_start"] = 'Начать импорт';
$_lang["import_site_success"] = 'Успешно';
$_lang["import_site_time"] = 'Импорт завершен. Процесс занял %s секунд.';
$_lang["inbox"] = 'Входящие';
$_lang["info"] = 'Информация';
$_lang["information"] = 'Информация';
$_lang["inline"] = 'Отображаемое';
$_lang["insert"] = 'Вставить';
$_lang["keyword"] = 'Ключевое слово';
$_lang["keywords"] = 'Ключевые слова';
$_lang["keywords_intro"] = 'Для редактирования ключевого слова просто введите новое значение рядом с существующим. Для удаления - поставьте галочку в поле \'удалить\'.';
$_lang["language_message"] = 'Выберите язык системы управления сайтом.';
$_lang["language_title"] = 'Язык системы управления:';
$_lang["launch_site"] = 'Запустить сайт';
$_lang["link_attributes"] = 'Атрибуты ссылки';
$_lang["link_attributes_help"] = 'Здесь вы можете ввести атрибуты ссылки для этой страницы, например target=&quot;_blank&quot; или rel=&quot;external&quot;.';
$_lang["list_mode"] = 'Включить/выключить режим списка - используется для вывода списка записей.';
$_lang["loading_doc_tree"] = 'Загружается дерево сайта...';
$_lang["loading_menu"] = 'Загружается меню...';
$_lang["loading_page"] = 'Пожалуйста, подождите...';
$_lang["localtime"] = 'Местное время';
$_lang["lock_htmlsnippet"] = 'Ограничить доступ к редактированию чанка';
$_lang["lock_htmlsnippet_msg"] = 'Только администраторы (ID роли - 1) могут редактировать этот чанк.';
$_lang["lock_module"] = 'Ограничить доступ к редактированию модуля';
$_lang["lock_module_msg"] = 'Только администраторы (ID роли - 1) могут редактировать этот модуль.';
$_lang["lock_msg"] = '%s сейчас редактирует %s. Пожалуйста, подождите, пока другой пользователь закончит с редактированием, и попробуйте снова.';
$_lang["lock_plugin"] = 'Ограничить доступ к редактированию плагина';
$_lang["lock_plugin_msg"] = 'Только администраторы (ID роли - 1) имеют право редактировать этот плагин.';
$_lang["lock_settings_msg"] = '%s сейчас редактирует системные установки. Пожалуйста, подождите, пока другой пользователь закончит редактирование, и попробуйте снова.';
$_lang["lock_snippet"] = 'Ограничить доступ к редактированию сниппета';
$_lang["lock_snippet_msg"] = 'Только администраторы (ID роли - 1) могут редактировать этот сниппет.';
$_lang["lock_template"] = 'Ограничить доступ к редактированию шаблона';
$_lang["lock_template_msg"] = 'Только администраторы (ID роли - 1) могут редактировать этот шаблон.';
$_lang["lock_tmplvars"] = 'Ограничить доступ к редактированию параметра';
$_lang["lock_tmplvars_msg"] = 'Только администраторы (ID роли - 1) могут редактировать этот параметр.';
$_lang["locked"] = 'Заблокирован';
$_lang["login_allowed_days"] = 'Разрешенные дни';
$_lang["login_allowed_days_message"] = 'Выберите дни, в которые этот пользователь может входить.';
$_lang["login_allowed_ip"] = 'Разрешенный IP-адрес';
$_lang["login_allowed_ip_message"] = 'Введите IP-адрес, с которого разрешено заходить этому пользователю. <b>ПРИМЕЧАНИЕ:</b> несколько IP-адресов разделяйте запятыми (,)';
$_lang["login_button"] = 'Войти';
$_lang["login_cancelled_install_in_progress"] = 'В данный момент выполняется установка/обновление сайта. <br />Повторите попытку через пару минут!<br />';
$_lang["login_cancelled_site_was_updated"] = 'Процесс установки/обновления сайта завершен успешно. Требуется повторная авторизация в системе!<br />';
$_lang["login_captcha_message"] = 'Введите код подтверждения. \n\nЕсли у вас возникли трудности с прочтением кода, нажмите на него, чтобы сгенерировать новый вариант.';
$_lang["login_homepage"] = 'Страница успешной авторизации';
$_lang["login_homepage_message"] = 'Введите ID ресурса, который загрузится после успешной авторизации пользователя. <b>ПРИМЕЧАНИЕ:</b> убедитесь, что этот ID принадлежит существующему ресурсу, что этот ресурс опубликован и что он доступен для данного пользователя';
$_lang["login_message"] = 'Введите ваше имя пользователя и пароль. Обратите внимание - строчные и прописные буквы различаются.';
$_lang["logo_slogan"] = 'Создавайте больше с меньшими усилиями - \nСистема управления сайтом MODx';
$_lang["logout"] = 'Выйти';
$_lang["long_title"] = 'Расширенный заголовок';
$_lang["mail_check_timeperiod_message"] = 'Как часто проверять наличие новых сообщений в системе управления, (сек).';
$_lang["mail_check_timeperiod_title"] = 'Период проверки почты:';
$_lang["manage_depends"] = 'Управление зависимостями';
$_lang["manage_files"] = 'Управление файлами';
$_lang["manage_htmlsnippets"] = 'Чанки';
$_lang["manage_metatags"] = 'Управление META-тегами и ключевыми словами';
$_lang["manage_modules"] = 'Управление модулями';
$_lang["manage_plugins"] = 'Плагины';
$_lang["manage_snippets"] = 'Сниппеты';
$_lang["manage_templates"] = 'Шаблоны';
$_lang["manager"] = 'Менеджер';
$_lang["manager_lockout_message"] = 'В данный момент вы находитесь в режиме управления сайтом. Чтобы закончить сеанс администрирования, нажмите кнопку \'Выйти\'. <p />Чтобы перейти на главную или стартовую страницу, нажмите кнопку \'Домой\'.';
$_lang["manager_permissions"] = 'Права менеджеров';
$_lang["manager_theme"] = 'Шаблон системы управления:';
$_lang["manager_theme_message"] = 'Выберите шаблон для системы управления.';
$_lang["messages"] = 'Сообщения';
$_lang["messages_all"] = 'Всем';
$_lang["messages_compose"] = 'Написать сообщение';
$_lang["messages_forward"] = 'Переслать';
$_lang["messages_from"] = 'От';
$_lang["messages_group"] = 'Группа';
$_lang["messages_inbox"] = 'Почтовый ящик';
$_lang["messages_message"] = 'Сообщение';
$_lang["messages_no_messages"] = 'Почтовый ящик пуст.';
$_lang["messages_not_allowed_to_read"] = 'Вам запрещено читать эти сообщения';
$_lang["messages_private"] = 'Приватное';
$_lang["messages_read_message"] = 'Читать сообщение';
$_lang["messages_reply"] = 'Ответить';
$_lang["messages_select_group"] = 'Выберите группу';
$_lang["messages_select_user"] = 'Выберите пользователя';
$_lang["messages_send"] = 'Отправить';
$_lang["messages_send_to"] = 'Кому';
$_lang["messages_sent"] = 'Отправлено';
$_lang["messages_subject"] = 'Тема';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'Сообщения';
$_lang["messages_user"] = 'Пользователь';
$_lang["meta_keywords"] = 'Ключевые слова';
$_lang["metatag_intro"] = 'На этой странице вы можете создавать/редактировать/удалять META-теги. Чтобы привязать META-теги к ресурсам, нажмите на вкладку <u>Ключевые слова</u>, когда редактируете ресурс, и выберите нужные ключевые слова и META-теги. Для создания нового тега введите его имя и значение и нажмите \'Создать тэг\'. Для редактирования нажмите на название тега.';
$_lang["metatag_notice"] = 'Это <b>не полный</b> список возможных мета-тегов. Подробную информацию по использованию мета-тегов вы можете получить здесь: <a href="http://www.html-reference.com/META.asp" target="_blank">HTML Reference Guide</a>.';
$_lang["metatags"] = 'META-теги';
$_lang["mgr_access_permissions"] = 'Права доступа менеджеров';
$_lang["mgr_login_start"] = 'Авторизация менеджера сайта';
$_lang["mgr_login_start_message"] = 'Введите ID ресурса, который вы хотите послать пользователю после авторизации в системе управления сайтом. <b>ПРИМЕЧАНИЕ:</b> убедитесь в том, что ID принадлежит существующему ресурсу, который опубликован и доступен этому пользователю';
$_lang["mgrlog_action"] = 'Действие:';
$_lang["mgrlog_actionid"] = 'ID действия:';
$_lang["mgrlog_anyall"] = 'Любое / Все';
$_lang["mgrlog_datecheckfalse"] = 'Функция checkdate() вернула значение false.';
$_lang["mgrlog_datefr"] = 'Начиная с даты:';
$_lang["mgrlog_dateinvalid"] = 'Ошибочный формат даты.';
$_lang["mgrlog_dateto"] = 'Заканчивая датой:';
$_lang["mgrlog_emptysrch"] = 'По вашему запросу ничего не найдено (нет записей, соответствующих заданным критериям).';
$_lang["mgrlog_field"] = 'Поле';
$_lang["mgrlog_itemid"] = 'ID ресурса:';
$_lang["mgrlog_itemname"] = 'Название ресурса:';
$_lang["mgrlog_msg"] = 'Сообщение:';
$_lang["mgrlog_noquery"] = 'Вы не ввели запрос. Укажите критерии запроса.';
$_lang["mgrlog_qresults"] = 'Результаты запроса';
$_lang["mgrlog_query"] = 'Протокол запросов к базе';
$_lang["mgrlog_query_msg"] = 'Пожалуйста, задайте критерии просмотра записей.</p><p><b>ВНИМАНИЕ:</b> указанный диапазон дат не включает результаты за дату, указанную в поле \'Заканчивая датой\'. Например, чтобы сделать выборку за 03-12-2009, укажите в поле \'Начиная с даты\' значение 03-12-2009, а в поле \'Заканчивая датой\' - значение 03-12-2009.</p><p>Сообщение и действие обычно одинаковы. Если вы хотите найти какое-то конкретное сообщение, обычно лучше всего установить действие \'Любое / Все\'.';
$_lang["mgrlog_results"] = 'Отображать результаты порциями по:';
$_lang["mgrlog_searchlogs"] = 'Найти записи протокола';
$_lang["mgrlog_sortinst"] = 'Вы можете отсортировать таблицу, выбрав мышью заголовок любой колонки. Если записей станет слишком много, вы можете <a href="index.php?a=55">очистить протокол</a>. <i>ВНИМАНИЕ: это приведёт к удалению всех записей протокола по сегодняшний момент!</i>';
$_lang["mgrlog_time"] = 'Время';
$_lang["mgrlog_user"] = 'Пользователь';
$_lang["mgrlog_username"] = 'Имя пользователя';
$_lang["mgrlog_value"] = 'Значение';
$_lang["mgrlog_view"] = 'Просмотр записей протокола системы управления сайтом';
$_lang["module_code"] = 'Код модуля (php)';
$_lang["module_config"] = 'Конфигурация модуля';
$_lang["module_desc"] = 'Описание';
$_lang["module_disabled"] = 'Модуль отключен';
$_lang["module_edit_click_title"] = 'Нажмите для редактирования модуля';
$_lang["module_group_access_msg"] = 'Выберите группы пользователей, которые могут запускать этот модуль.';
$_lang["module_management"] = 'Управление модулями';
$_lang["module_management_msg"] = '<b>Модуль</b> - это приложение, основанное на архитектуре MODx и расширяющее возможности системы управления. Модуль может группировать набор элементов (<i>сниппеты</i>, <i>чанки</i>, <i>данные</i>), реализуя принцип инкапсуляции через разделение интерфейса и реализации.</p><p>Выберите модуль, который вы хотите запустить или изменить, или создайте новый модуль. Для запуска модуля нажмите на значок рядом с его именем, для редактирования модуля нажмите на его название.';
$_lang["module_msg"] = 'Здесь вы можете создавать / редактировать модули. Модуль - это набор элементов (плагинов, сниппетов и т. д.).';
$_lang["module_name"] = 'Название модуля';
$_lang["module_resource_msg"] = 'Здесь вы можете добавить / удалить элементы, от которых зависит этот модуль. Чтобы добавить новый элемент, нажмите одну из кнопок внизу.';
$_lang["module_resource_title"] = 'Зависимости модуля';
$_lang["module_title"] = 'Создать / редактировать модуль';
$_lang["module_viewdepend_msg"] = 'Здесь вы можете просмотреть, от каких элементов зависит этот модуль. Чтобы изменить зависимости, нажмите на \'Управление зависимостями\'.';
$_lang["modules"] = 'Модули';
$_lang["modx_news"] = 'Новости MODx';
$_lang["modx_news_tab"] = 'Новости MODx';
$_lang["modx_news_title"] = 'Новости MODx';
$_lang["modx_security_notices"] = 'Уведомления безопасности MODx';
$_lang["modx_version"] = 'Версия MODx';
$_lang["monday"] = 'Понедельник';
$_lang["move"] = 'Переместить';
$_lang["move_resource"] = 'Переместить';
$_lang["move_resource_message"] = 'Вы можете переместить ресурс и все его дочерние ресурсы, выбрав новый \'родительский\' ресурс. Если вы выберете в качестве родительского ресурс, не являющийся папкой, MODx автоматически сделает его папкой. Выберите новый \'родительский ресурс\' в дереве сайта слева.';
$_lang["move_resource_new_parent"] = 'Выберите новый \'родительский\' ресурс в дереве сайта слева.';
$_lang["move_resource_title"] = 'Переместить';
$_lang["name"] = 'Название';
$_lang["new_category"] = 'Новая категория';
$_lang["new_file_permissions_message"] = 'При загрузке нового файла с помощью файл-менеджера будет сделана попытка установить права на файл в соответствии с указанным здесь значением. На некоторых системах автоматическая установка прав может быть недоступна (в частности, при использовании IIS) - в таком случае необходимо будет установить соответствующие права вручную.';
$_lang["new_file_permissions_title"] = 'Права на новый файл:';
$_lang["new_folder_permissions_message"] = 'При создании новой папки с помощью файл-менеджера будет сделана попытка установить права на папку в соответствии с указанным здесь значением. На некоторых системах автоматическая установка прав может быть недоступна (в частности, при использовании IIS) - в таком случае необходимо будет установить соответствующие права вручную.';
$_lang["new_folder_permissions_title"] = 'Права на новую папку:';
$_lang["new_htmlsnippet"] = 'Новый чанк';
$_lang["new_keyword"] = 'Добавить ключевое слово:';
$_lang["new_module"] = 'Новый модуль';
$_lang["new_parent"] = 'Новый родительский ресурс';
$_lang["new_plugin"] = 'Создать плагин';
$_lang["new_role"] = 'Создать новую роль';
$_lang["new_snippet"] = 'Новый сниппет';
$_lang["new_template"] = 'Новый шаблон';
$_lang["new_tmplvars"] = 'Новый параметр (TV)';
$_lang["new_user"] = 'Новый пользователь';
$_lang["new_web_user"] = 'Создать веб-пользователя';
$_lang["no"] = 'Нет';
$_lang["no_active_users_found"] = 'Не найдено активных пользователей.';
$_lang["no_activity_message"] = 'Вы не создали или не отредактировали ни одного ресурса.';
$_lang["no_category"] = 'Без категории';
$_lang["no_docs_pending_publishing"] = 'Нет ресурсов, ожидающих публикации.';
$_lang["no_docs_pending_pubunpub"] = 'События не найдены.';
$_lang["no_docs_pending_unpublishing"] = 'Нет ресурсов, ожидающих отмены публикации.';
$_lang["no_edits_creates"] = 'Созданных или отредактированных ресурсов не обнаружено.';
$_lang["no_groups_found"] = 'Групп не найдено.';
$_lang["no_keywords_found"] = 'Ключевых слов нет.';
$_lang["no_records_found"] = 'Не найдено записей.';
$_lang["no_results"] = 'Ничего не найдено';
$_lang["nologentries_message"] = 'Выберите количество записей протокола на странице при его просмотре.';
$_lang["nologentries_title"] = 'Количество записей протокола:';
$_lang["nomessages_message"] = 'Выберите количество сообщений на странице при их просмотре.';
$_lang["nomessages_title"] = 'Количество сообщений:';
$_lang["none"] = 'Нет';
$_lang["noresults_message"] = 'Введите количество элементов, отображаемых в списках и результатах поиска.';
$_lang["noresults_title"] = 'Количество результатов:';
$_lang["not_deleted"] = 'не был удален.';
$_lang["not_set"] = 'нет данных';
$_lang["offline"] = 'Оффлайн';
$_lang["online"] = 'Онлайн';
$_lang["onlineusers_action"] = 'Действие';
$_lang["onlineusers_actionid"] = 'ID действия';
$_lang["onlineusers_ipaddress"] = 'IP-адрес посетителя сайта';
$_lang["onlineusers_lasthit"] = 'Момент последнего действия';
$_lang["onlineusers_message"] = 'Этот список показывает всех пользователей, активных за последние 20 минут (текущее время - ';
$_lang["onlineusers_title"] = 'Пользователи онлайн';
$_lang["onlineusers_user"] = 'Пользователь';
$_lang["onlineusers_userid"] = 'ID пользователя';
$_lang["optimize_table"] = 'Нажмите для оптимизации таблицы';
$_lang["page_data_cacheable"] = 'Кэшируемый';
$_lang["page_data_cacheable_help"] = 'Отметьте для того, чтобы разрешить кэширование ресурса. Будьте внимательны в том случае, если ресурс содержит вызовы сниппетов - возможно, лучше отменить кэширование.';
$_lang["page_data_cached"] = '<b>Код взят из кэша:</b>';
$_lang["page_data_changes"] = 'Создание и изменение';
$_lang["page_data_contentType"] = 'Тип содержимого';
$_lang["page_data_contentType_help"] = 'Выберите тип содержимого для ресурса. Если вы не уверены в том, какой тип данных должен быть у ресурса, оставьте text/html.';
$_lang["page_data_created"] = 'Создан';
$_lang["page_data_edited"] = 'Редактировался';
$_lang["page_data_editor"] = 'Использовать HTML-редактор';
$_lang["page_data_folder"] = 'Ресурс является контейнером';
$_lang["page_data_general"] = 'Общие';
$_lang["page_data_markup"] = 'Разметка/структура';
$_lang["page_data_mgr_access"] = 'Менеджерский доступ';
$_lang["page_data_notcached"] = 'Ресурс еще не кэшировался.';
$_lang["page_data_publishdate"] = 'Дата публикации';
$_lang["page_data_publishdate_help"] = 'Если вы установите дату публикации, ресурс будет опубликован по наступлению этой даты. Нажмите на значок календаря, чтобы выбрать дату, либо на значок рядом, чтобы удалить дату публикации. Это будет означать, что ресурс не будет публиковаться автоматически.';
$_lang["page_data_published"] = 'Опубликован';
$_lang["page_data_searchable"] = 'Доступен для поиска';
$_lang["page_data_searchable_help"] = 'Отметьте для того, чтобы разрешить поиск в содержимом этого ресурса (внутренней поисковой машиной). Этот параметр можно также использовать в разработке сниппетов.';
$_lang["page_data_source"] = 'Код';
$_lang["page_data_status"] = 'Статус';
$_lang["page_data_template"] = 'Шаблон';
$_lang["page_data_template_help"] = 'Здесь вы можете указать, какой шаблон должен использовать ресурс. Выберите (blank), если хотите, чтобы ресурс не использовал никаких шаблонов (рекомендуется для пустых ресурсов, выполняющих только роль контейнера).';
$_lang["page_data_title"] = 'Данные ресурса (страницы)';
$_lang["page_data_unpublishdate"] = 'Дата отмены публикации';
$_lang["page_data_unpublishdate_help"] = 'Если вы установите дату отмены публикации, ресурс будет снят с публикации по наступлению этой даты. Нажмите на значок календаря, чтобы выбрать дату, либо на значок рядом, чтобы удалить дату отмены публикации. Это будет означать, что ресурс не будет снят с публикации автоматически.';
$_lang["page_data_unpublished"] = 'Не опубликован';
$_lang["page_data_web_access"] = 'Веб-доступ';
$_lang["pagetitle"] = 'Заголовок ресурса';
$_lang["pagination_table_first"] = 'Первый';
$_lang["pagination_table_gotopage"] = 'Перейти на';
$_lang["pagination_table_last"] = 'Последний';
$_lang["paging_first"] = 'В начало';
$_lang["paging_last"] = 'В конец';
$_lang["paging_next"] = 'Дальше';
$_lang["paging_prev"] = 'Назад';
$_lang["paging_showing"] = 'Отображаются записи с';
$_lang["paging_to"] = 'по';
$_lang["paging_total"] = 'всего';
$_lang["parameter"] = 'Параметр';
$_lang["password"] = 'Пароль';
$_lang["password_change_request"] = 'Запрос на смену пароля';
$_lang["password_gen_gen"] = 'Позволить MODx сгенерировать пароль.';
$_lang["password_gen_length"] = 'Пароль должен содержать минимум 6 символов.';
$_lang["password_gen_method"] = 'Способ задания нового пароля';
$_lang["password_gen_specify"] = 'Я сам задам пароль:';
$_lang["password_method"] = 'Способ уведомления о новом пароле';
$_lang["password_method_email"] = 'Послать новый пароль по e-mail.';
$_lang["password_method_screen"] = 'Показать новый пароль на экране.';
$_lang["password_msg"] = 'Для пользователя <b>%s</b> задан новый пароль - <b>%s</b>.';
$_lang["php_version_check"] = 'Система MODx работает с PHP версии 4.0.3 или выше. Пожалуйста, обновите PHP';
$_lang["plugin"] = 'Плагин';
$_lang["plugin_code"] = 'Код плагина (php)';
$_lang["plugin_config"] = 'Конфигурация плагина';
$_lang["plugin_desc"] = 'Описание';
$_lang["plugin_disabled"] = 'Плагин отключен';
$_lang["plugin_event_msg"] = 'Выберите события, которые должен отслеживать плагин.';
$_lang["plugin_management_msg"] = '<b>Плагины</b> - это интерактивные PHP-скрипты, запускающиеся при наступлении события, которое они отслеживают.</p><p>Выберите плагин для редактирования или создайте новый. Также вы можете задать порядок вызова плагинов при наступлении событий, которые они обрабатывают.';
$_lang["plugin_msg"] = 'Здесь вы можете создать / отредактировать плагин.';
$_lang["plugin_name"] = 'Название плагина';
$_lang["plugin_priority"] = 'Редактировать порядок вызова плагинов при наступлении события';
$_lang["plugin_priority_instructions"] = 'Перетащите мышью для определения порядка выполнения плагинов для каждого события. Сначала выполняется первый в списке плагин.';
$_lang["plugin_priority_title"] = 'Порядок вызова плагинов';
$_lang["plugin_title"] = 'Создать / редактировать плагин';
$_lang["preview"] = 'Просмотр';
$_lang["preview_msg"] = 'Предпросмотр последних изменений. <a href="#" onclick="saveRefreshPreview();">Сохранить и обновить</a> последние изменения';
$_lang["preview_resource"] = 'Просмотр';
$_lang["private"] = 'Личный';
$_lang["public"] = 'Доступен для всех';
$_lang["publish_date"] = 'Дата публикации';
$_lang["publish_events"] = 'События, связанные с публикацией ресурсов.';
$_lang["publish_resource"] = 'Опубликовать';
$_lang["rb_base_dir_message"] = 'Введите физический путь к папке файлов. Обычно этот путь устанавливается автоматически. Если вы используете сервер IIS, этого может и не произойти. В таком случае введите путь, как он отображается в адресной строке Internet Explorer.<b>ПРИМЕЧАНИЕ:</b> для корректной работы браузера папка файлов должна содержать вложенные папки: images, files, flash и media.';
$_lang["rb_base_dir_title"] = 'Путь к файлам:';
$_lang["rb_base_url_message"] = 'Введите адрес (URL) папки файлов. Обычно этот путь устанавливается автоматически. Если вы используете сервер IIS, этого может и не произойти. В таком случае введите путь, как он отображается в Internet Explorer.';
$_lang["rb_base_url_title"] = 'URL к файлам:';
$_lang["rb_message"] = 'Выберите \'Да\', чтобы включить браузер файлов. Это позволит менеджерам загружать файлы (изображения, медиа-файлы) на сервер.';
$_lang["rb_title"] = 'Включить файл-менеджер:';
$_lang["rb_webuser_message"] = 'Хотите ли вы, чтобы web-пользователи использовали файл-менеджер? <b>Предупреждение:</b> Позволяя web-пользователям использовать файл-менеджер, вы делаете доступ для всех файлов, которые доступны менеджерам. Используйте эту настройку только для проверенных web-пользователей.';
$_lang["rb_webuser_title"] = 'Web-пользователи?';
$_lang["recent_docs"] = 'Последние изменения';
$_lang["recommend_setting_change_title"] = 'Рекомендуемое изменение настройки';
$_lang["recommend_setting_change_description"] = 'Ваш сайт не настроен на проверку серверных заголовков HTTP_REFERER во входящих запросах в систему управления. Мы настоятельно рекомендуем включить этот параметр, чтобы снизить риск CSRF (Cross Site Request Forgery - подделка межсайтовых запросов) атак.';
$_lang["refresh_cache"] = 'Кэш: найдено <b>%s</b> файлов в папке кэширования и удалено <b>%d</b> кэш-файлов.<p>Новые кэш-файлы будут созданы при запросах страниц.';
$_lang["refresh_published"] = '<b>%s</b> ресурсов опубликовано.';
$_lang["refresh_site"] = 'Очистить кэш';
$_lang["refresh_title"] = 'Обновить сайт';
$_lang["refresh_tree"] = 'Обновить дерево';
$_lang["refresh_unpublished"] = '<b>%s</b> ресурсов снято с публикации.';
$_lang["remember_last_tab"] = 'Запоминать вкладки';
$_lang["remember_last_tab_message"] = 'Открывается не первая вкладка, а используемая при последнем посещении';
$_lang["remember_username"] = 'Запомнить меня';
$_lang["remove"] = 'Удалить';
$_lang["remove_date"] = 'Удалить дату';
$_lang["remove_locks"] = 'Удалить блокировки';
$_lang["rename"] = 'Переименовать';
$_lang["reports"] = 'Отчеты';
$_lang["require_tagname"] = 'Название тега обязательно';
$_lang["require_tagvalue"] = 'Значение тега обязательно';
$_lang["reset"] = 'Сброс';
$_lang["reset_failedlogins"] = 'сброс';
$_lang["resolve_hostnames_message"] = 'Включите эту функцию, чтобы MODx распознавал имена хостов посетителей. Имейте в виду, что эта функция несколько увеличит нагрузку на сервер, однако посетители ее не заметят.';
$_lang["resolve_hostnames_title"] = 'Распознавать имена хостов';
$_lang["resource"] = 'Ресурс';
$_lang["resource_alias"] = 'Псевдоним';
$_lang["resource_alias_help"] = "Здесь вы можете выбрать псевдоним для ресурса. Псевдоним позволяет обращаться к ресурсу по адресу: http://example.com/псевдоним. Внимание: функция будет работать только при включенных 'дружественных URL'."; 
$_lang["resource_content"] = 'Содержимое ресурса';
$_lang["resource_description"] = 'Описание';
$_lang["resource_description_help"] = 'Здесь вы можете ввести описание ресурса.';
$_lang["resource_duplicate"] = 'Сделать копию';
$_lang["resource_long_title_help"] = 'Здесь вы можете ввести расширенный заголовок вашего ресурса, что может быть полезно для поисковых систем.';
$_lang["resource_metatag_help"] = 'Выберите META-теги и ключевые слова, которые вы хотите присвоить этому ресурсу. Для выбора нескольких ключевых слов или МЕТА-тегов нажимайте на них мышью, удерживая Ctrl.';
$_lang["resource_opt_contentdispo"] = 'Местонахождение содержимого';
$_lang["resource_opt_contentdispo_help"] = 'Этот параметр определяет, как браузер должен обработать ресурс. Для того, чтобы ресурс стал доступным для скачивания, а не отображался в окне браузера, выберите \'Прикрепленное\'.';
$_lang["resource_opt_emptycache"] = 'Очистить кэш';
$_lang["resource_opt_emptycache_help"] = 'Отметьте для того, чтобы очистить кэш после сохранения изменений этого ресурса. В этом случае посетители увидят свежую версию ресурса.';
$_lang["resource_opt_folder"] = 'Контейнер (содержит дочерние ресурсы)';
$_lang["resource_opt_folder_help"] = 'Отметьте, чтобы ресурс выполнял также роль папки (родителя) для других ресурсов. Не стоит особо заострять внимание на этом параметре – MODx автоматически установит для ресурса режим папки, если внутри него начнут создаваться ресурсы.';
$_lang["resource_opt_menu_index"] = 'Позиция в меню';
$_lang["resource_opt_menu_index_help"] = 'Позиция (индекс) в меню - это порядковый номер ресурса в меню. Эту величину можно также использовать в разработке сниппетов.';
$_lang["resource_opt_menu_title"] = 'Пункт меню';
$_lang["resource_opt_menu_title_help"] = 'Пункт меню - это параметр, который можно использовать для отображения краткого заголовка ресурса в меню.';
$_lang["resource_opt_published"] = 'Публиковать';
$_lang["resource_opt_published_help"] = 'Отметьте, чтобы опубликовать ресурс сразу после сохранения.';
$_lang["resource_opt_richtext"] = 'Использовать HTML-редактор';
$_lang["resource_opt_richtext_help"] = 'Отметьте, чтобы для редактирования ресурса использовался HTML-редактор. Если ресурс содержит JavaScript или формы - снимите галочку, чтобы редактировать его в режиме HTML-кода (чтобы HTML-редактор не вносил никаких изменений в код).';
$_lang["resource_opt_show_menu"] = 'Показывать в меню';
$_lang["resource_opt_show_menu_help"] = 'Включите этот параметр для отображения ресурса в каком-либо меню сайта. Имейте в виду, некоторые сниппеты могут игнорировать этот параметр.';
$_lang["resource_opt_trackvisit_help"] = 'Регистрировать каждое посещение';
$_lang["resource_overview"] = 'Обзор ресурса';
$_lang["resource_parent"] = 'Папка';
$_lang["resource_parent_help"] = 'Щелкните мышью на значке контейнера вверху, чтобы включить (выключить) режим выбора родительского ресурса, затем выберите его в дереве сайта слева.';
$_lang["resource_permissions_error"] = 'Свяжите этот ресурс по крайней мере с одной группой ресурсов, к которой у Вас есть доступ.';
$_lang["resource_setting"] = 'Настройки ресурса';
$_lang["resource_summary"] = 'Аннотация (введение)';
$_lang["resource_summary_help"] = 'Введите краткое описание ресурса';
$_lang["resource_title"] = 'Заголовок';
$_lang["resource_title_help"] = 'Введите имя/заголовок ресурса. Нежелательно использовать при этом обратный слэш (\\)';
$_lang["resource_to_be_moved"] = 'Перемещаемый ресурс';
$_lang["resource_type"] = 'Тип ресурса';
$_lang["resource_type_message"] = 'Веб-ссылка на ресурс в интернете, включая другие ресурсы MODx, внешние веб-страницы, изображения или другие файлы в интернете. Для ресурса должен быть задан тип содержимого text/html, а в местонахождении содержимого - отображаемое.';
$_lang["resource_type_weblink"] = 'Веб-ссылка';
$_lang["resource_type_webpage"] = 'Веб-страница';
$_lang["resource_weblink_help"] = 'Введите адрес (URI) объекта в сети, на который должна указывать вэб-ссылка.';
$_lang["resources_in_container"] = '- количество ресурсов в контейнере';
$_lang["resources_in_container_no"] = 'Текущий контейнер не содержит дочерних ресурсов.';
$_lang["role"] = 'Роль';
$_lang["role_about"] = 'Просмотр информации о системе';
$_lang["role_access_persmissions"] = 'Менеджерский доступ';
$_lang["role_actionok"] = 'Просмотр страницы подтверждения завершения действия';
$_lang["role_bk_manager"] = 'Использовать резервное копирование';
$_lang["role_cache_refresh"] = 'Очистка кэша';
$_lang["role_change_password"] = 'Смена пароля';
$_lang["role_chunk_management"] = 'Управление чанками';
$_lang["role_config_management"] = 'Изменение конфигурации';
$_lang["role_content_management"] = 'Управление содержимым';
$_lang["role_create_chunk"] = 'Создание новых чанков';
$_lang["role_create_doc"] = 'Создание новых ресурсов';
$_lang["role_create_plugin"] = 'Создание новых плагинов';
$_lang["role_create_snippet"] = 'Создание новых сниппетов';
$_lang["role_create_template"] = 'Создание новых шаблонов';
$_lang["role_credits"] = 'Просмотр списка разработчиков';
$_lang["role_delete_chunk"] = 'Удаление чанков';
$_lang["role_delete_doc"] = 'Удаление ресурсов';
$_lang["role_delete_eventlog"] = 'Удаление протокола событий';
$_lang["role_delete_module"] = 'Удаление модулей';
$_lang["role_delete_plugin"] = 'Удаление плагинов';
$_lang["role_delete_role"] = 'Удаление ролей';
$_lang["role_delete_snippet"] = 'Удаление сниппетов';
$_lang["role_delete_template"] = 'Удаление шаблонов';
$_lang["role_delete_user"] = 'Удаление пользователей';
$_lang["role_delete_web_user"] = 'Удаление веб-пользователей';
$_lang["role_edit_chunk"] = 'Редактирование чанков';
$_lang["role_edit_doc"] = 'Редактирование ресурсов';
$_lang["role_edit_doc_metatags"] = 'Редактировать META-теги и ключевые слова';
$_lang["role_edit_module"] = 'Редактирование модулей';
$_lang["role_edit_plugin"] = 'Редактирование плагинов';
$_lang["role_edit_role"] = 'Редактирование ролей';
$_lang["role_edit_settings"] = 'Изменять конфигурацию сайта';
$_lang["role_edit_snippet"] = 'Редактирование сниппетов';
$_lang["role_edit_template"] = 'Редактирование шаблонов';
$_lang["role_edit_user"] = 'Редактирование пользователей';
$_lang["role_edit_web_user"] = 'Редактирование веб-пользователей';
$_lang["role_empty_trash"] = 'Очищение корзины';
$_lang["role_errors"] = 'Просмотр диалога ошибки';
$_lang["role_eventlog_management"] = 'Управление протоколом событий';
$_lang["role_export_static"] = 'Экспорт статических страниц в HTML';
$_lang["role_file_manager"] = 'Использование файл-менеджера';
$_lang["role_frames"] = 'Запрос менеджерских фреймов';
$_lang["role_help"] = 'Просмотр страниц помощи';
$_lang["role_home"] = 'Запрос входной страницы менеджера';
$_lang["role_import_static"] = 'Импорт HTML';
$_lang["role_logout"] = 'Выход из системы управления';
$_lang["role_manage_metatags"] = 'Управление META-тегами и ключевыми словами';
$_lang["role_management_msg"] = '<b>Роль</b> - это набор прав совершать определённые действия. Роли назначаются пользователям. Типичные роли:</p> <ul> <li><b>Администраторы сайта</b> - управляют пользователями и общими настройками;</li> <li><b>Разработчики</b> - пишут код и, соответственно, имеют набор прав на создание / редактирование / удаление <i>модулей</i>, <i>плагинов</i>, <i>сниппетов</i>, <i>чанков</i>, <i>параметров (TV)</i>;</li> <li><b>Дизайнеры</b> - отвечают за внешний вид и вёрстку страниц сайта, имеют набор прав на создание / редактирование / удаление <i>шаблонов</i> и <i>чанков</i>;</li> <li><b>Редакторы</b> - отвечают за содержание страниц сайта, создают, редактируют и удаляют ресурсы;</li> <li><b>Корректоры</b> - читают и корректируют ресурсы, но не имеют прав на их создание и удаление;</li> <li><b>Главный редактор</b> - принимает решение о публикации новых ресурсов, управляет расписанием публикации.</li> </ul><br /><p>Выберите роль для редактирования или создайте новую роль.';
$_lang["role_management_title"] = 'Управление ролями';
$_lang["role_messages"] = 'Читать и отправлять сообщения';
$_lang["role_module_management"] = 'Управление модулями';
$_lang["role_name"] = 'Название роли';
$_lang["role_new_module"] = 'Создание новых модулей';
$_lang["role_new_role"] = 'Создание новых ролей';
$_lang["role_new_user"] = 'Создание новых пользователей';
$_lang["role_new_web_user"] = 'Создание веб-пользователей';
$_lang["role_plugin_management"] = 'Управление плагинами';
$_lang["role_publish_doc"] = 'Публикация ресурсов';
$_lang["role_remove_locks"] = 'Удалить блокировки';
$_lang["role_role_management"] = 'Управление ролями';
$_lang["role_run_module"] = 'Запуск модулей';
$_lang["role_save_chunk"] = 'Сохранение чанков';
$_lang["role_save_doc"] = 'Сохранение ресурсов';
$_lang["role_save_module"] = 'Сохранение модулей';
$_lang["role_save_password"] = 'Сохранение пароля';
$_lang["role_save_plugin"] = 'Сохранение плагинов';
$_lang["role_save_role"] = 'Сохранение ролей';
$_lang["role_save_snippet"] = 'Сохранение сниппетов';
$_lang["role_save_template"] = 'Сохранение шаблонов';
$_lang["role_save_user"] = 'Сохранение пользователей';
$_lang["role_save_web_user"] = 'Сохранение веб-пользователей';
$_lang["role_snippet_management"] = 'Управление сниппетами';
$_lang["role_template_management"] = 'Управление шаблонами';
$_lang["role_title"] = 'Создать / редактировать роль';
$_lang["role_udperms"] = 'Управление доступом';
$_lang["role_user_management"] = 'Управление пользователями';
$_lang["role_view_docdata"] = 'Просмотр информации о ресурсе';
$_lang["role_view_eventlog"] = 'Просмотр протокола событий';
$_lang["role_view_logs"] = 'Просмотр системного протокола';
$_lang["role_view_unpublished"] = 'Просмотр неопубликованных ресурсов';
$_lang["role_web_access_persmissions"] = 'Права веб-доступа';
$_lang["role_web_user_management"] = 'Управление веб-пользователями';
$_lang["rss_url_news_default"] = 'http://feeds.feedburner.com/modx-announce';
$_lang["rss_url_news_message"] = 'Введите адрес (URL) RSS-ленты новостей MODx.';
$_lang["rss_url_news_title"] = 'Лента RSS новостей';
$_lang["rss_url_security_default"] = 'http://feeds.feedburner.com/modxsecurity';
$_lang["rss_url_security_message"] = 'Введите адрес (URL) RSS-ленты безопасности MODx.';
$_lang["rss_url_security_title"] = 'Лента RSS безопасности';
$_lang["run_module"] = 'Запуск модуля';
$_lang["saturday"] = 'Суббота';
$_lang["save"] = 'Сохранить';
$_lang["save_all_changes"] = 'Сохранить изменения';
$_lang["save_tag"] = 'Сохранить тег';
$_lang["saving"] = 'Сохранение ресурса, подождите пожалуйста...';
$_lang["search"] = 'Поиск';
$_lang["search_criteria"] = 'Критерий поиска';
$_lang["search_criteria_content"] = 'Искать в содержимом';
$_lang["search_criteria_content_msg"] = 'Найти все ресурсы, содержащие введенный текст в своем теле.';
$_lang["search_criteria_id"] = 'Искать по ID';
$_lang["search_criteria_id_msg"] = 'Введите ID ресурса, чтобы быстро найти его.';
$_lang["search_criteria_longtitle"] = 'Искать в расширенных заголовках';
$_lang["search_criteria_longtitle_msg"] = 'Найти все ресурсы, содержащие текст в расширенных заголовках.';
$_lang["search_criteria_title"] = 'Искать в заголовках';
$_lang["search_criteria_title_msg"] = 'Найти все ресурсы, содержащие введенный текст в заголовке.';
$_lang["search_empty"] = 'По вашему запросу ничего не найдено. Попробуйте расширить критерий поиска.';
$_lang["search_item_deleted"] = 'Удалено';
$_lang["search_results"] = 'Результаты поиска';
$_lang["search_results_returned_desc"] = 'Описание';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'По вашему запросу найдено <b>%s</b> ресурсов. Если найдено слишком много ресурсов, попробуйте сформировать более специфический запрос. Две крайние колонки слева позволят найти ресурс в дереве сайта либо просмотреть ресурс. Две крайние колонки справа показывают, соответственно, был ли ресурс помечен на удаление и опубликован ли он.';
$_lang["search_results_returned_title"] = 'Заголовок';
$_lang["search_view_docdata"] = 'Просмотреть';
$_lang["security"] = 'Менеджеры';
$_lang["security_notices_tab"] = 'Уведомления безопасности';
$_lang["security_notices_title"] = 'Уведомления безопасности';
$_lang["select_date"] = 'Выбрать дату';
$_lang["send"] = 'Отправить';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Если ваш сайт использует https-соединения, укажите это здесь.';
$_lang["server_protocol_title"] = 'Тип сервера:';
$_lang["serveroffset"] = 'Поправка ко времени на сервере';
$_lang["serveroffset_message"] = 'Выберите поправку (количество часов) между временем на месте вашего пребывания и на месте нахождения сервера. Текущее время на сервере - <b>[%s]</b>, текущее время на сервере с учетом временной поправки - <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Разница во времени:';
$_lang["servertime"] = 'Время на сервере';
$_lang["settings_after_install"] = 'Так как вы только что установили систему, следует задать основные настройки. Внесите желаемые изменения и нажмите \'Сохранить\' для вступления изменений в силу.<br /><br />';
$_lang["settings_config"] = 'Конфигурация';
$_lang["settings_dependencies"] = 'Зависимости';
$_lang["settings_events"] = 'Системные события';
$_lang["settings_furls"] = 'Дружественные URL';
$_lang["settings_general"] = 'Общие';
$_lang["settings_misc"] = 'Файл-менеджер';
$_lang["settings_page_settings"] = 'Настройка страницы';
$_lang["settings_photo"] = 'Фото';
$_lang["settings_properties"] = 'Свойства';
$_lang["settings_site"] = 'Сайт';
$_lang["settings_strip_image_paths_message"] = 'Если установлено значение \'Нет\', MODx будет использовать абсолютные ссылки для изображений, файлов, анимация и тому подобного. Относительные ссылки удобнее, если вы в будущем собираетесь переместить свой сайт, например, с тестового сервера на конечный. Если вы не знаете, о чем речь, оставьте значение \'Да\'.';
$_lang["settings_strip_image_paths_title"] = 'Переписывать пути для браузера?';
$_lang["settings_templvars"] = 'Параметры (TV)';
$_lang["settings_title"] = 'Системная конфигурация';
$_lang["settings_ui"] = 'Интерфейс и представление';
$_lang["settings_users"] = 'Пользователи';
$_lang["show_meta"] = 'Показывать вкладку с META-тегами и ключевыми словами';
$_lang["show_meta_message"] = 'Показывать нерекомендуемую вкладку с META-тегами и ключевыми словами при редактировании ресурсов.';
$_lang["show_tree"] = 'Показать дерево';
$_lang["showing"] = 'Показано';
$_lang["signupemail_message"] = 'Здесь вы можете создать сообщение, которое будет отсылаться менеджерам, когда создается учетная запись нового менеджера. Письмо должно содержать имя пользователя и пароль. <br /><b>ПРИМЕЧАНИЕ.</b> Следующие \'поля вывода\' отобразят соответствующие данные при отправлении письма: <br /><br />[+sname+] - название сайта, <br />[+saddr+] - e-mail адрес сайта, <br />[+surl+] - адрес (URL) сайта, <br />[+uid+] – имя пользователя или id пользователя, <br />[+pwd+] - пароль пользователя, <br />[+ufn+] - полное имя пользователя. <br /><br /><b>Убедитесь, что в сообщении присутствуют поля [+uid+] и [+pwd+], иначе пользователь не узнает свои имя пользователя и пароль</b>';
$_lang["signupemail_title"] = 'Регистрация менеджера:';
$_lang["site"] = 'Сайт';
$_lang["site_schedule"] = 'Расписание сайта';
$_lang["sitename_message"] = 'Введите заголовок вашего сайта.';
$_lang["sitename_title"] = 'Заголовок сайта:';
$_lang["sitestart_message"] = 'Введите ID ресурса, который вы хотите использовать как стартовую (домашнюю) страницу. <b>ПРИМЕЧАНИЕ:</b> убедитесь, что этот ID принадлежит существующему ресурсу, и что этот ресурс опубликован';
$_lang["sitestart_title"] = 'Первая страница:';
$_lang["sitestatus_message"] = 'Выберите \'Онлайн\' для опубликования вашего сайта. Если вы выберете \'Оффлайн\', посетители сайта увидят сообщение о недоступности сайта и не смогут  просмотреть сам сайт.';
$_lang["sitestatus_title"] = 'Статус сайта:';
$_lang["siteunavailable_message"] = 'Сообщение, выводимое в случае недоступности сайта (когда выбран статус \'Оффлайн\') или в случае возникновения ошибки. <b>ПРИМЕЧАНИЕ:</b> это сообщение выводится только в том случае, когда не выбрана страница \'Сайт недоступен\'.';
$_lang["siteunavailable_message_default"] = 'В настоящее время сайт недоступен.';
$_lang["siteunavailable_page_message"] = 'Введите ID ресурса, который должны будут увидеть посетители, если попытаются зайти на сайт, когда он недоступен. <b>ПРИМЕЧАНИЕ:</b> убедитесь, что этот ID принадлежит существующему ресурсу, и что этот ресурс опубликован';
$_lang["siteunavailable_page_title"] = 'Страница \'Сайт недоступен\':';
$_lang["siteunavailable_title"] = 'Сообщение о недоступности сайта:';
$_lang["snippet"] = 'Сниппет';
$_lang["snippet_code"] = 'Код сниппета (php)';
$_lang["snippet_desc"] = 'Описание';
$_lang["snippet_execonsave"] = 'Выполнить сниппет после сохранения';
$_lang["snippet_management_msg"] = '<b>Сниппеты</b> - это чистый PHP-код, обеспечивающий динамическую логику. Сниппеты позволяют отделить бизнес-логику от структуры и представления данных на веб-странице. Они могут использоваться для генерации динамических меню, вывода контента из базы данных по некоему условию (например, только для зарегистрированных пользователей), вообще, для любых действий, доступных через MODx API. Сниппеты могут (но не обязаны) принимать параметры и выводить какой-либо результат (например, генерировать HTML-код).<p/><p><b>Использование:</b> вставьте <code>[[snippetName]]</code> или <code>[!snippetName!]</code> где-либо в <i>шаблоне</i>, в <i>области контента</i>, в <i>чанке</i> или в <i>параметре (TV)</i>. Формат <code>[[snippetName]]</code> разрешает кэширование результатов выполнения сниппета, если для страницы включено кэширование. Формат <code>[!snippetName!]</code> используется для исполнения PHP-кода сниппета при каждом просмотре страницы, даже если для страницы разрешено кэширование. Чтобы при вызове PHP-кода сниппета передать в него параметры, используйте формат <code>[[snippetName? &amp;param1=\'value1\' &amp;param2=\'value2\' .. &amp;paramN=\'valueN\']]</code> (или <code>[!snippetName? &amp;param1=\'value1\' &amp;param2=\'value2\' .. &amp;paramN=\'valueN\'!]</code>). В качестве параметров вызова сниппета можно использовать вызов других сниппетов (также с параметрами) или <i>чанков</i>.</p><p><b>Вызов через MODx API:</b> <code>$modx->runSnippet(\'snippetName\');</code></p><p><br /> Выберите сниппет для редактирования или создайте новый.';
$_lang["snippet_msg"] = '<p>Здесь вы можете создать или отредактировать сниппет. Код сниппета должен начинаться с <code>&lt;?php</code> и заканчиваться <code>?&gt;</code></p> <p>Помните, сниппеты - это чистый PHP-код, и если вы хотите вывести данные сниппета в определенном месте в шаблоне, вам необходимо возвращать данные из самого сниппета.</p>';
$_lang["snippet_name"] = 'Название сниппета';
$_lang["snippet_properties"] = 'Параметры по умолчанию';
$_lang["snippet_title"] = 'Создать / редактировать сниппет';
$_lang["sort_asc"] = 'Возрастание';
$_lang["sort_desc"] = 'По убыванию';
$_lang["sort_tree"] = 'Сортировать дерево';
$_lang["source"] = 'Код';
$_lang["stay"] = 'Продолжить';
$_lang["stay_new"] = 'Создать новый';
$_lang["submit"] = 'Выполнить';
$_lang["sunday"] = 'Воскресенье';
$_lang["sys_alert"] = 'Системное предупреждение';
$_lang["sysinfo_activity_message"] = 'Этот список показывает последние созданные/отредактированные ресурсы.';
$_lang["sysinfo_userid"] = 'Пользователь';
$_lang["system_email_signup"] = "Здравствуйте, [+uid+]!\n\nВаши данные для авторизации в системе управления сайтом [+sname+]:\n\nИмя пользователя: [+uid+]\nПароль: [+pwd+]\n\nПосле успешной авторизации в системе управления сайтом ([+surl+]), вы сможете изменить свой пароль.\n\nС уважением, Администрация";
$_lang["system_email_webreminder"] = "Здравствуйте, [+uid+]!\n\nЧтобы активировать ваш новый пароль, перейдите по следующей ссылке:\n\n[+surl+]\n\nПозже вы сможете использовать следующий пароль для авторизации: [+pwd+]\n\nЕсли это письмо пришло к вам по ошибке, пожалуйста, проигнорируйте его.\n\nС уважением, Администрация";
$_lang["system_email_websignup"] = "Здравствуйте, [+uid+]!\n\nВаши данные для авторизации на [+sname+]:\n\nИмя пользователя: [+uid+]\nПароль: [+pwd+]\n\nПосле успешной авторизации на [+sname+] ([+surl+]), вы сможете изменить свой пароль.\n\nС уважением, Администрация";
$_lang["table_hoverinfo"] = 'Задержите указатель мыши над строкой таблицы, чтобы увидеть короткое пояснение предназначения таблицы (комментарии есть не у всех таблиц).';
$_lang["table_prefix"] = 'Префикс таблиц базы данных';
$_lang["tag"] = 'Тег';
$_lang["template"] = 'Шаблон';
$_lang["template_assignedtv_tab"] = 'Назначенные параметры (TV)';
$_lang["template_code"] = 'Код шаблона (HTML)';
$_lang["template_desc"] = 'Описание';
$_lang["template_edit_tab"] = 'Редактировать шаблон';
$_lang["template_management_msg"] = '<b>Шаблоны</b> - это (X)HTML-разметка страниц сайта. Шаблон описывает структуру и дизайн отображения элементов страницы (статичных и генерируемых). Шаблон может содержать вызовы <i>сниппетов</i>, <i>чанков</i>, <i>параметров (TV)</i>, а также ссылки на CSS-файлы и другие объекты, определяющие визуальное отображение страницы и её элементов.<p><b>Использование:</b> назначьте шаблон какому-либо ресурсу.</p><p><br />Выберите шаблон для редактирования или создайте новый.'; 
$_lang["template_msg"] = 'Здесь вы можете создать / отредактировать шаблон.';
$_lang["template_name"] = 'Имя шаблона';
$_lang["template_no_tv"] = 'Этому шаблону не присвоены никакие параметры (TV).';
$_lang["template_reset_all"] = 'Сбросить все шаблоны (будет установлен шаблон по умолчанию)';
$_lang["template_reset_specific"] = 'Сбросить только страницы с шаблоном \'%s\'';
$_lang["template_title"] = 'Создать / редактировать шаблон';
$_lang["template_tv_edit"] = 'Редактировать порядок сортировки параметров (TV) шаблона';
$_lang["template_tv_edit_message"] = 'Перетащите мышью для изменения порядка параметров (TV) для этого шаблона.';
$_lang["template_tv_edit_title"] = 'Порядок сортировки параметров (TV)';
$_lang["template_tv_msg"] = 'Ниже выводятся параметры (TV), назначенные этому шаблону.';
$_lang["thursday"] = 'Четверг';
$_lang["tmplvar_access_msg"] = 'Выберите группы ресурсов, в которых разрешена смена этого Дополнительного Параметра (TV)';
$_lang["tmplvar_change_template_msg"] = 'Смена шаблона повлечет перезагрузку страницы. Все несохраненные изменения будут утеряны. \n\nВы уверены в том, что хотите сменить шаблон?';
$_lang["tmplvar_inuse"] = 'Этот Параметр (TV) используют следующие шаблоны. Чтобы продолжить процесс удаления, нажмите \'Удалить\', для отмены - нажмите \'Отмена\'.';
$_lang["tmplvar_tmpl_access"] = 'Доступ шаблонов';
$_lang["tmplvar_tmpl_access_msg"] = 'Укажите шаблоны, которые могут использовать этот Параметр (TV)';
$_lang["tmplvars"] = 'Параметры (TV)';
$_lang["tmplvars_binding_msg"] = 'Это поле поддерживает привязку данных с использованием @-команд';
$_lang["tmplvars_caption"] = 'Заголовок';
$_lang["tmplvars_default"] = 'Значение по умолчанию';
$_lang["tmplvars_description"] = 'Описание';
$_lang["tmplvars_elements"] = 'Возможные значения';
$_lang["tmplvars_management_msg"] = '<b>Параметры (TV)</b> - это динамические элементы шаблона, которые получают своё значение из некоего <i>источника данных</i>. Существуют также параметры, предопределённые для каждого конкретного ресурса (например, предопределённый параметр <code>[*pagetitle*]</code> содержит заголовок страницы). Параметры могут иметь различный тип данных и разное значение на различных страницах сайта.<p><b>Использование:</b> вставьте где-либо в <i>шаблоне</i> или в <i>области контента</i> выражение <code>[*tvName*]</code></p> <p><b>Вызов через MODx API:</b> <code>$modx-&gt;documentObject[\'variable-name\']</code></p><p><br />Выберите параметр для редактирования или создайте новый.';
$_lang["tmplvars_msg"] = 'Здесь вы можете создать / отредактировать параметр (TV). <br /> Помните, параметры должны быть доступны для выбранных шаблонов, чтобы их можно было использовать. <br /><br /> ';
$_lang["tmplvars_name"] = 'Имя параметра';
$_lang["tmplvars_novars"] = 'Параметров (TV) не найдено';
$_lang["tmplvars_rank"] = 'Порядок в списке';
$_lang["tmplvars_reset_params"] = 'Сбросить параметры';
$_lang["tmplvars_title"] = 'Создать / редактировать параметр (TV)';
$_lang["tmplvars_type"] = 'Тип ввода';
$_lang["tmplvars_widget"] = 'Визуальный компонент';
$_lang["tmplvars_widget_prop"] = 'Свойства компонента (widget)';
$_lang["to"] = 'к';
$_lang["tools"] = 'Инструменты';
$_lang["top_howmany_message"] = 'Количество лучших показателей в отчетах статистики. Например, \'10 самых популярных...\'';
$_lang["top_howmany_title"] = 'Количество лучших показателей:';
$_lang["total"] = 'всего';
$_lang["track_visitors_message"] = 'Предоставляет данные для плагина аналитики, например, флажок, определяющий, учитывать ли просмотры конкретного ресурса.';
$_lang["track_visitors_title"] = 'Регистрировать посещения:';
$_lang["tree_page_click"] = 'Режим щелчка мышью на ресурсе';
$_lang["tree_page_click_message"] = 'Действие по умолчанию при щелчке мышью на ресурсе в дереве сайта.';
$_lang["tree_show_protected"] = 'Показывать защищенные ресурсы в дереве сайта:';
$_lang["tree_show_protected_message"] = 'Если включено \'Нет\', то защищенные ресурсы (включая их дочерние ресурсы) не будут отображаться в дереве сайта.';
$_lang["truncate_table"] = 'Нажмите для усечения таблицы (TRUNCATE)';
$_lang["tuesday"] = 'Вторник';
$_lang["tv"] = 'Параметр (TV)';
$_lang["type"] = 'Тип';
$_lang["udperms_allowroot_message"] = 'Разрешить пользователям создавать ресурсы в корневой папке.';
$_lang["udperms_allowroot_title"] = 'Разрешить доступ к корневой папке:';
$_lang["udperms_message"] = 'Права доступа позволяют вам определить, какие страницы могут редактировать пользователи. Для этого необходимо, чтобы пользователи принадлежали к группе пользователей, а ресурсы к группе ресурсов, и далее вы можете выбрать, какие группы ресурсов может редактировать та или иная группа пользователей. При первом включении этой функции редактировать ресурсы могут только менеджеры.';
$_lang["udperms_title"] = 'Использовать права доступа:';
$_lang["unable_set_link"] = 'Невозможно установить ссылку';
$_lang["unable_set_parent"] = 'Невозможно установить новый родительский ресурс';
$_lang["unauthorizedpage_message"] = 'Введите ID ресурса, который должны будут увидеть посетители, если попытаются зайти на закрытую страницу (403 – доступ запрещен). <b>ПРИМЕЧАНИЕ:</b> убедитесь, что этот ID принадлежит существующему ресурсу, и что этот ресурс опубликован';
$_lang["unauthorizedpage_title"] = 'Страница \'Доступ запрещен\':';
$_lang["unblock_message"] = 'После сохранения пользователь будет разблокирован.';
$_lang["undelete_resource"] = 'Восстановить';
$_lang["unpublish_date"] = 'Дата отмены публикации';
$_lang["unpublish_events"] = 'События, связанные с отменой публикации ресурсов.';
$_lang["unpublish_resource"] = 'Отменить публикацию';
$_lang["untitled_resource"] = 'Новый ресурс';
$_lang["untitled_weblink"] = 'Новая ссылка';
$_lang["update_params"] = 'Обновить параметры';
$_lang["update_settings_from_language"] = 'Изменить на:';
$_lang["upload_maxsize_message"] = 'Задайте максимальный размер загружаемых файлов. Значение должно быть в байтах. <b>ПРИМЕЧАНИЕ:</b> большие файлы загружаются, как правило, ОЧЕНЬ долго';
$_lang["upload_maxsize_title"] = 'Максимальный размер загрузки:';
$_lang["uploadable_files_message"] = 'Здесь вы можете указать, какие типы файлов могут быть загружены на сервер через файл-менеджер. Задайте список расширений через запятую.';
$_lang["uploadable_files_title"] = 'Разрешенные к загрузке файлы:';
$_lang["uploadable_flash_message"] = 'Здесь вы можете ввести список файлов, которые могут быть загружены в \'assets/flash/\' с помощью файл-менеджера. Введите расширения разрешенных типов флэш-файлов, разделяя их запятыми.';
$_lang["uploadable_flash_title"] = 'Разрешенные к загрузке flash-файлы:';
$_lang["uploadable_images_message"] = 'Здесь вы можете ввести список файлов, которые могут быть загружены в \'assets/images/\' с помощью файл-менеджера. Введите расширения разрешенных типов графических файлов, разделяя их запятыми.';
$_lang["uploadable_images_title"] = 'Разрешенные к загрузке изображения:';
$_lang["uploadable_media_message"] = 'Здесь вы можете ввести список файлов, которые могут быть загружены в \'assets/media/\' с помощью файл-менеджера. Введите расширения разрешенных типов медиа-файлов, разделяя их запятыми.';
$_lang["uploadable_media_title"] = 'Разрешенные к загрузке медиа-файлы:';
$_lang["use_alias_path_message"] = 'Включив эту функцию, вы получите вложенную структуру URL. Например, если дочерний ресурс называется \'дочерний\', а родительский ресурс называется \'родительский\', мы получим URL такого типа: http://example.com/родительский/дочерний.<br /><b>Внимание:</b> если эта функция включена, убедитесь, что все пути к изображениям, css, java-скриптам имеют путь типа \'/assets/images/...\', а не \'assets/images/...\', либо вы всегда можете использовать приставку [(site_url)] для правильного понимания сервером пути, например, \'[(site_url)]assets/images/...\'. Также можно использовать HTML-тег &lt;base href=\'[(site_url)]\'&gt; в HEAD-секции <i>каждой</i> страницы сайта, тогда все относительные пути будут работать правильно.';
$_lang["use_alias_path_title"] = 'Использовать вложенные URL:';
$_lang["use_editor_message"] = 'Хотите использовать HTML-редактор? Если вы привыкли писать HTML-теги вручную, отключите данную функцию. Имейте в виду, что эта настройка применяется ко всем ресурсам для всех менеджеров';
$_lang["use_editor_title"] = 'Использовать HTML-редактор:';
$_lang["user"] = 'Пользователь';
$_lang["user_block"] = 'Заблокирован';
$_lang["user_blockedafter"] = 'Заблокирован после';
$_lang["user_blockeduntil"] = 'Заблокирован до';
$_lang["user_changeddata"] = 'Данные вашей регистрации изменены. Пожалуйста, заново авторизуйтесь в системе.';
$_lang["user_country"] = 'Страна';
$_lang["user_dob"] = 'Дата рождения';
$_lang["user_doesnt_exist"] = 'Пользователь не существует';
$_lang["user_edit_self_msg"] = '<b>Рекомендуется выйти и снова авторизоваться для того, чтобы все изменения вступили в силу.</b><br />Также, если вы решили сгенерировать новый пароль для себя, он будет отослан вам по e-mail.';
$_lang["user_email"] = 'Адрес e-mail';
$_lang["user_failedlogincount"] = 'Отказы авторизации';
$_lang["user_fax"] = 'Факс';
$_lang["user_female"] = 'Женский';
$_lang["user_full_name"] = 'Полное имя';
$_lang["user_gender"] = 'Пол';
$_lang["user_is_blocked"] = 'Этот пользователь заблокирован';
$_lang["user_logincount"] = 'Количество авторизаций';
$_lang["user_male"] = 'Мужской';
$_lang["user_management_msg"] = '<b>Менеджеры</b> - это пользователи с правом авторизации в системе управления сайтом. <br /><br /> Выберите менеджера, настройки которого вы хотите редактировать, или создайте нового менеджера.';
$_lang["user_management_title"] = 'Управление менеджерами';
$_lang["user_mobile"] = 'Номер мобильного телефона';
$_lang["user_phone"] = 'Номер телефона';
$_lang["user_photo"] = 'Фото пользователя';
$_lang["user_photo_message"] = 'Введите адрес (URL) изображения для этого пользователя или нажмите кнопку вставки, чтобы загрузить его на сервер.';
$_lang["user_prevlogin"] = 'Последняя авторизация';
$_lang["user_role"] = 'Роль пользователя';
$_lang["user_state"] = 'регион/провинция/область/район';
$_lang["user_title"] = 'Создать / редактировать пользователя';
$_lang["user_upload_message"] = 'Если вы хотите запретить этому пользователю загрузку любых файлов данной категории, убедитесь, что флажок \'Использовать общие настройки\' не установлен, и оставьте это поле пустым.';
$_lang["user_use_config"] = 'Использовать системные настройки';
$_lang["user_zip"] = 'Почтовый индекс';
$_lang["username"] = 'Пользователь';
$_lang["users"] = 'Пользователи';
$_lang["validate_referer_message"] = 'Проверять серверные заголовки HTTP_REFERER для защиты от уязвимостей CSRF (Cross Site Request Forgery). Если сервер не использует заголовки HTTP_REFERER данная функция не будет работать.';
$_lang["validate_referer_title"] = 'Проверять серверные заголовки HTTP_REFERER?';
$_lang["value"] = 'Значение';
$_lang["version_codename"] = 'Кодовое имя версии';
$_lang["view"] = 'Просмотр';
$_lang["view_child_resources_in_container"] = 'Просмотр дочерних ресурсов';
$_lang["view_log"] = 'Просмотреть протокол';
$_lang["view_logging"] = 'Протокол системы управления';
$_lang["view_sysinfo"] = 'Системная информация';
$_lang["warning"] = 'Предупреждение';
$_lang["warning_not_saved"] = 'Изменения не были сохранены. Вы можете остаться на этой странице для того, чтобы сохранить изменения (\'Отмена\'), либо покинуть ее, утеряв все изменения (\'OK\').';
$_lang["warning_visibility"] = 'Показывать предупреждения';
$_lang["warning_visibility_message"] = 'Показывать отчет о проверке конфигурации на странице приветствия менеджера';
$_lang["web_access_permissions"] = 'Права доступа для веб-пользователей';
$_lang["web_access_permissions_user_groups"] = 'Группы веб-пользователей';
$_lang["web_permissions"] = 'Права веб-пользователей';
$_lang["web_user_management_msg"] = '<b>Веб-пользователи</b> - это зарегистрированные посетители сайта (не менеджеры). <br /><br />Выберите веб-пользователя, настройки которого вы хотите редактировать, или создайте нового веб-пользователя.';
$_lang["web_user_management_title"] = 'Управление веб-пользователями';
$_lang["web_user_title"] = 'Создать / редактировать веб-пользователя';
$_lang["web_users"] = 'Веб-пользователи';
$_lang["weblink"] = 'Веб-ссылка';
$_lang["webpwdreminder_message"] = 'Здесь вы можете создать сообщение, которое будет отсылаться пользователям, когда они запрашивают напоминание пароля. Письмо должно содержать имя пользователя и пароль. <br /><b>ПРИМЕЧАНИЕ.</b> Следующие \'поля вывода\' отобразят соответствующие данные при отправлении письма: <br /><br />[+sname+] - название сайта, <br />[+saddr+] - e-mail адрес сайта, <br />[+surl+] - адрес (URL) сайта, <br />[+uid+] - имя пользователя или id пользователя, <br />[+pwd+] - пароль пользователя, <br />[+ufn+] - полное имя пользователя. <br /><br /><b>Убедитесь, что в сообщении присутствуют поля [+uid+] и [+pwd+], иначе пользователь не узнает свои имя пользователя и пароль</b>';
$_lang["webpwdreminder_title"] = 'Напоминание пароля:';
$_lang["websignupemail_message"] = 'Здесь вы можете создать сообщение, которое будет отсылаться веб-пользователям, когда создается учетная запись нового веб-пользователя. Письмо должно содержать имя пользователя и пароль. <br /><b>ПРИМЕЧАНИЕ.</b> Следующие \'поля вывода\' отобразят соответствующие данные при отправлении письма: <br /><br />[+sname+] - название сайта, <br />[+saddr+] - e-mail адрес сайта, <br />[+surl+] - URL сайта, <br />[+uid+] - имя пользователя или id пользователя, <br />[+pwd+] - пароль пользователя, <br />[+ufn+] - полное имя пользователя. <br /><br /><b>Убедитесь, что в сообщении присутствуют поля [+uid+] и [+pwd+], иначе пользователь не узнает свои имя пользователя и пароль</b>';
$_lang["websignupemail_title"] = 'Регистрация веб-пользователя:';
$_lang["wednesday"] = 'Среда';
$_lang["welcome_messages"] = 'В вашем ящике <strong>%d</strong> сообщений, из которых <strong>%s</strong> не прочитаны.';
$_lang["welcome_title"] = 'Добро пожаловать в систему управления сайтом MODx';
$_lang["which_editor_message"] = 'Выберите HTML-редактор. вы также можете загрузить и установить редакторы из списка доступных на сайте MODx.';
$_lang["which_editor_title"] = 'Редактор:';
$_lang["working"] = 'Обработка данных...';
$_lang["wrap_lines"] = 'Переносить строки по ширине окна';
$_lang["xhtml_urls_message"] = 'Если включен этот параметр, то все амперсанды (&) в ссылках будут заменены на конструкцию &<!-- -->amp; в соответствии с форматом XHTML.';
$_lang["xhtml_urls_title"] = 'Ссылки в формате XHTML:';
$_lang["yes"] = 'Да';
$_lang["you_got_mail"] = 'Новое сообщение';
$_lang["yourinfo_message"] = 'Этот раздел содержит некоторые данные о вас:';
$_lang["yourinfo_previous_login"] = 'Последняя авторизация:';
$_lang["yourinfo_role"] = 'Ваша роль:';
$_lang["yourinfo_title"] = 'Информация о вас';
$_lang["yourinfo_total_logins"] = 'Всего авторизаций:';
$_lang["yourinfo_username"] = 'Вы авторизованы как:';
?>