<?php
/**
 * Filename:       includes/lang/nederlands.inc.php
 * Function:       Dutch language file.
 * Author:         The MODx Project Team
 *                 Stefan van Zanden (21-03-2009 Update to 0.9.6.3 + large amount of typo / consistency / translation fixes)
 *                 Stefan van Zanden (23-06-2009 Update to Evolution 1.0.0rc1)
 *                 Gauke Pieter Sietzema - Sterc.nl (25-06-2009 typo's and naming of features)
 *                 Stefan van Zanden (18-07-2009 Additional fixes for the Evolution 1.0.0rc2)
 *                 Stefan van Zanden with help of Gauke Pieter Sietzema - Sterc.nl (25-07-2009 Update to Evolution 1.0.0rc3)
 *                 Gauke Pieter Sietzema - Sterc.nl + small changes from Stefan van Zanden (28-07-2009 Additional fixes in translation for Evolution 1.0)
 *                 Stefan van Zanden (29-07-2009 Small fix pointed out by user octoris)
 *                 Stefan van Zanden (30-07-2009 Added 2 missing datetime fields)
 * Date:           30 July 2009
 * Version:        2.0.3
 * MODx version:   Evolution 1.0
*/
$modx_lang_attribute = 'nl'; // Manager HTML and XML Language Attribute
$modx_manager_charset = 'iso-8859-1';

$_lang["about_msg"] = 'MODx is een <a href="http://modxcms.com/what-is-modx.html" target="_blank">PHP Applicatie Framework en Content Management Systeem</a> gelicentieerd onder de <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'Over MODx';
$_lang["access_permission_denied"] = 'U heeft niet de juiste toegangsrechten voor deze Pagina.';
$_lang["access_permission_parent_denied"] = 'U heeft niet genoeg toegangsrechten om hier een Pagina aan te maken of te verplaatsen! Kies a.u.b. een andere locatie.';
$_lang["access_permissions"] = 'Toegangsrechten';
$_lang["access_permissions_add_resource_group"] = 'Maak een nieuwe Paginagroep';
$_lang["access_permissions_add_user_group"] = 'Maak een nieuwe Gebruikersgroep';
$_lang["access_permissions_docs_collision"] = 'Omdat de Webgebruikersgroepen en Gebruikersgroepen conflicteren voor uw Rol, zal deze Pagina onbeveiligd zijn. Neem contact op met uw website beheerder voor meer hulp.';
$_lang["access_permissions_docs_message"] = 'Geef aan tot welke Paginagroepen deze Pagina behoort';
$_lang["access_permissions_group_link"] = 'Maak een nieuwe groep koppeling';
$_lang["access_permissions_introtext"] = 'Dit is de beheermodule van Gebruikers- en Paginagroepen die worden gebruikt in het toegangsbeheer. Om een Gebruiker toe te voegen aan een groep, volstaat het deze te bewerken en de groepen te kiezen waartoe deze moet behoren. Om een Pagina toe te wijzen aan een Gebruikersgroep, kiest u tijdens het bewerken van de Pagina voor de groepen waartoe de Pagina moet behoren.';
$_lang["access_permissions_link_to_group"] = 'aan Paginagroep';
$_lang["access_permissions_link_user_group"] = 'Koppel Gebruikersgroep';
$_lang["access_permissions_links"] = 'Gebruikersgroep of Paginagroep koppelingen';
$_lang["access_permissions_links_tab"] = 'Geef aan welke Gebruikersgroepen toegang hebben tot bepaalde Paginagroepen (m.a.w. welke groepen Subpagina\'s kunnen maken of bewerken). Om een Pagina toe te wijzen aan een groep kiest u de Pagina uit de lijst en klikt u daarna op \'Verzenden\'. Om een Pagina uit een groep te halen klikt u op \'Verwijder\'.';
$_lang["access_permissions_no_resources_in_group"] = 'Geen.';
$_lang["access_permissions_no_users_in_group"] = 'Geen.';
$_lang["access_permissions_off"] = '<span class="warning">Toegangsbeheer is niet geactiveerd.</span> Dit betekent dat wijzigingen die hier worden gemaakt geen effect hebben zolang toegangsbeheer niet is geactiveerd in uw Configuratie.';
$_lang["access_permissions_resource_groups"] = 'Paginagroepen';
$_lang["access_permissions_resources_in_group"] = '<b>Pagina\'s in deze groep:</b> ';
$_lang["access_permissions_resources_tab"] = 'Bekijk hier de Paginagroepen. U kunt ook nieuwe groepen maken, bestaande bewerken of verwijderen of nagaan welke Pagina deel uitmaakt van een groep. Door met de muis over de ID van de Pagina te bewegen, ziet u de naam ervan. Door de Pagina te bewerken kunt u de groepsrechten wijzigen.';
$_lang["access_permissions_user_groups"] = 'Gebruikersgroepen';
$_lang["access_permissions_user_message"] = 'Geef aan tot welke groepen deze Gebruiker behoort:';
$_lang["access_permissions_users_in_group"] = 'Gebruikers in deze groep: ';
$_lang["access_permissions_users_tab"] = 'Bekijk de Gebruikersgroepen. U kunt ook nieuwe groepen maken, bestaande bewerken of verwijderen, of nagaan wie deel uitmaakt van een groep. Om een Gebruiker uit een groep te halen of aan een groep toe te wijzen, wijzigt u de gegevens van de Gebruiker. Beheerders (dit zijn Gebruikers met profiel ID 1) hebben altijd toegang tot alle Pagina\'s dus hoeft u hen niet toe te voegen aan een groep.';
$_lang["account_email"] = 'E-mail account';
$_lang["actioncomplete"] = '<b>De bewerking is succesvol uitgevoerd!</b><br /> - Een moment geduld a.u.b. MODx is bezig met opschonen.';
$_lang["activity_message"] = 'Deze lijst toont de laatst bewerkte/gemaakte Pagina\'s:';
$_lang["activity_title"] = 'Recent gemaakte/bewerkte Pagina\'s';
$_lang["add"] = 'Toevoegen';
$_lang["add_chunk"] = 'Chunk toevoegen';
$_lang["add_doc"] = 'Pagina toevoegen';
$_lang["add_folder"] = 'Nieuwe Map';
$_lang["add_plugin"] = 'Plug-in toevoegen';
$_lang["add_resource"] = 'Nieuwe Pagina';
$_lang["add_snippet"] = 'Snippet toevoegen';
$_lang["add_tag"] = 'Tag toevoegen';
$_lang["add_template"] = 'Template toevoegen';
$_lang["add_tv"] = 'TV toevoegen';
$_lang["add_weblink"] = 'Nieuwe Weblink';
$_lang["administrator_role_message"] = 'Dit profiel kan niet worden bewerkt of verwijderd.';
$_lang["after_saving"] = 'Na opslaan';
$_lang["alert_delete_self"] = 'U kunt uzelf niet verwijderen!';
$_lang["alias"] = 'Alias';
$_lang["all_doc_groups"] = 'Alle Paginagroepen (onbeveiligd)';
$_lang["all_events"] = 'Alle gebeurtenissen';
$_lang["all_usr_groups"] = 'Alle Gebruikersgroepen (onbeveiligd)';
$_lang["allow_mgr_access"] = 'Toegang tot het Content Management Systeem';
$_lang["allow_mgr_access_message"] = 'Deze optie geeft de Gebruiker toegang tot het Content Management Systeem. <b>NB: \'Nee\' betekent dat de Gebruiker wordt doorverwezen naar de login Pagina of de eerste Pagina van de website.</b>';
$_lang["already_deleted"] = 'is reeds verwijderd.';
$_lang["attachment"] = 'Bijlage';
$_lang["automatic_alias_message"] = 'Kies \'Ja\' om het systeem automatisch een alias op basis van de titel van de Pagina te laten genereren wanneer de Pagina wordt opgeslagen.';
$_lang["automatic_alias_title"] = 'Genereer automatisch een alias:';
$_lang["backup"] = 'Backup';
$_lang["bk_manager"] = 'Backup';
$_lang["block_message"] = 'Deze Gebruiker zal geblokkeerd worden na het opslaan van zijn Gebruikersgegevens!';
$_lang["blocked_minutes_message"] = 'Geef hier het aantal minuten op dat een Gebruiker geblokkeerd zal worden als hij zijn maximaal aantal toegestane aanmeldpogingen heeft bereikt. A.u.b. alleen getallen gebruiken (geen komma\'s, spaties etc.)';
$_lang["blocked_minutes_title"] = 'Minuten geblokkeerd:';
$_lang["cache_files_deleted"] = 'Deze bestanden werden verwijderd:';
$_lang["cancel"] = 'Annuleren';
$_lang["captcha_code"] = 'Beveiligingscode';
$_lang["captcha_message"] = 'Door CAPTCHA aan te zetten, worden Gebruikers verplicht een beveiligingscode over te typen. Deze code is in een Afbeelding verwerkt en is daardoor onleesbaar voor machines en automatische programma\'s die erop uit zijn in te breken op uw website.';
$_lang["captcha_title"] = 'CAPTCHA codes gebruiken:';
$_lang["captcha_words_default"] = 'MODx,Access,Better,BitCode,Chunk,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Oscope,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Tattoo,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote';
$_lang["captcha_words_message"] = 'Vul hier een lijst van woorden in, van elkaar gescheiden door komma\'s, die gebruikt zal worden indien CAPTCHA is ingeschakeld. Het veld kan maximaal 255 tekens bevatten.';
$_lang["captcha_words_title"] = 'CAPTCHA woorden:';
$_lang["category_heading"] = 'Categorie';
$_lang["category_msg"] = 'Bekijk en wijzig hier alle Elementen gegroepeerd per categorie.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Naam wijzigen';
$_lang["change_password"] = 'Wachtwoord wijzigen';
$_lang["change_password_confirm"] = 'Wachtwoord bevestigen';
$_lang["change_password_message"] = 'Voer a.u.b. uw nieuwe wachtwoord in en voer het dan ter bevestiging nogmaals in. Uw wachtwoord moet tussen de 6 en 15 tekens lang zijn.';
$_lang["change_password_new"] = 'Nieuw wachtwoord';
$_lang["charset_message"] = 'Kies de standaard karakterset codering voor de [(modx_charset)] systeem variabele. Dit be&iuml;nvloed niet het Content Management Systeem.';
$_lang["charset_title"] = 'Karakterset codering:';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Chunk code (html)';
$_lang["chunk_multiple_id"] = 'Fout: Meerdere Chunks delen dezelfde unieke ID.';
$_lang["chunk_no_exist"] = 'Chunk bestaat niet.';
$_lang["cleaningup"] = 'Opschonen';
$_lang["clear_log"] = 'Logboek leegmaken';
$_lang["click_to_context"] = 'Klik om het context menu te openen';
$_lang["click_to_edit_title"] = 'Klik hier om deze regel te bewerken';
$_lang["click_to_view_details"] = 'Klik hier voor details';
$_lang["close"] = 'Sluiten';
$_lang["collapse_tree"] = 'Website boomstructuur inklappen';
$_lang["comment"] = 'Opmerking';
$_lang["configcheck_admin"] = 'Neem a.u.b. contact op met een systeembeheerder en geef deze melding door!';
$_lang["configcheck_cache"] = 'Kan niet schrijven in de cache Map';
$_lang["configcheck_cache_msg"] = 'MODx kan niet naar de cache Map schrijven. MODx blijft normaal functioneren, maar er zal geen caching plaatsvinden. Om dit probleem op te lossen dient u de /_cache/ Map schrijfrechten te geven.';
$_lang["configcheck_configinc"] = 'Configuratiebestand heeft nog schrijfrechten';
$_lang["configcheck_configinc_msg"] = 'Slechtwillenden zouden mogelijk schade aan uw website kunnen toebrengen met alle gevolgen van dien. <strong>Echt waar.</strong> Zet a.u.b. uw configuratiebestand (/manager/includes/config.inc.php) op alleen-lezen!';
$_lang["configcheck_default_msg"] = 'Er is een ongedefinieerde waarschuwing gevonden. Dit is zeer vreemd.';
$_lang["configcheck_errorpage_unavailable"] = 'Er is geen \'Fout\'-pagina voor uw website beschikbaar.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Dit houdt in dat uw \'Fout\'-pagina niet toegankelijk is voor normale Webgebruikers of niet bestaat. Dit kan leiden tot een oneindige lus en veel foutmeldingen in uw logbestand. Zorg ervoor dat de Pagina niet aan een Webgebruikersgroep is toegewezen.';
$_lang["configcheck_errorpage_unpublished"] = 'De \'Fout\'-pagina voor uw website is niet gepubliceerd of bestaat niet.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Dit houdt in dat uw \'Fout\'-pagina niet toegankelijk is voor bezoekers. Publiceer de Pagina of zorg ervoor dat het is toegewezen aan een bestaande Pagina in de inhoudsopgave van uw website met het Beheer &gt; Configuratie menu.';
$_lang["configcheck_images"] = 'De Map images is niet schrijfbaar';
$_lang["configcheck_images_msg"] = 'De Map images is niet schrijfbaar of bestaat niet. Dit betekent dat de Afbeeldingen beheer opties in de teksteditor niet werken!';
$_lang["configcheck_installer"] = 'De installer is nog niet verwijderd';
$_lang["configcheck_installer_msg"] = 'De \'/install\'-Map bevat de installer voor MODx. Probeert u eens in te denken wat een vervelend persoon zou kunnen doen als hij de installer zou vinden! We raden u aan om de \'install\'-Map van uw server te verwijderen, om zo uw website veilig te houden.';
$_lang["configcheck_lang_difference"] = 'Ongeldig aantal regels in het vertaalbestand';
$_lang["configcheck_lang_difference_msg"] = 'De taal die u heeft geselecteerd (Nederlands) heeft een verschillend aantal eenheden ten opzichte van de standaardtaal. Dit hoeft niet tot problemen te leiden, maar het is wel aan te raden om het huidige vertaalbestand te updaten.';
$_lang["configcheck_notok"] = '&Eacute;&eacute;n of meer configuratie opties zijn onjuist gebleken: ';
$_lang["configcheck_ok"] = 'Controle is geslaagd - er zijn geen onjuistheden gevonden.';
$_lang["configcheck_register_globals"] = 'register_globals staat op ON in uw php.ini configuratiebestand';
$_lang["configcheck_register_globals_msg"] = 'Deze instelling maakt uw website veel gevoeliger voor Cross Site Scripting (XSS) aanvallen. Neem contact op met uw host over hoe u deze instelling kunt uitzetten.';
$_lang["configcheck_title"] = 'Configuratietest';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Uw \'Niet Gemachtigd\'-pagina is niet gepubliceerd of bestaat niet.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Dit houdt in dat uw \'Niet Gemachtigd\'-pagina niet toegankelijk is voor normale Webgebruikers of niet bestaat. Dit kan leiden tot een oneindige lus en veel foutmeldingen in uw logbestand. Zorg ervoor dat de Pagina niet aan een Webgebruikersgroep is toegewezen.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'De \'Niet Gemachtigd\'-pagina die in de configuratie instellingen is aangegeven is niet gepubliceerd.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Dit houdt in dat uw \'Niet Gemachtigd\'-pagina niet toegankelijk is voor bezoekers. Publiceer de Pagina of zorg ervoor dat het is toegewezen aan een bestaande Pagina in de inhoudsopgave van uw website met het Beheer &gt; Configuratie menu.';
$_lang["configcheck_warning"] = 'Configuratie waarschuwing:';
$_lang["configcheck_what"] = 'Wat betekent dit?';
$_lang["confirm_block"] = 'Weet u zeker dat u deze Gebruiker wilt blokkeren?';
$_lang["confirm_delete_eventlog"] = 'Weet u zeker dat u het logboek (events) wilt leegmaken?';
$_lang["confirm_delete_file"] = 'Weet u zeker dat u dit bestand wilt verwijderen?\n\nHet zou kunnen dat hierdoor uw website niet meer werkt! Verwijder dit bestand uitsluitend indien u zeker bent dat u hiermee niks stuk maakt.';
$_lang["confirm_delete_htmlsnippet"] = 'Weet u zeker dat u deze Chunk wilt verwijderen?';
$_lang["confirm_delete_keywords"] = 'Weet u zeker dat u deze keywords wilt verwijderen?';
$_lang["confirm_delete_module"] = 'Weet u zeker dat u deze Module wilt verwijderen?';
$_lang["confirm_delete_plugin"] = 'Weet u zeker dat u deze Plug-in wilt verwijderen?';
$_lang["confirm_delete_record"] = 'Weet u zeker dat u de geselecteerde regels wilt verwijderen?';
$_lang["confirm_delete_resource"] = 'Weet u zeker dat u deze Pagina wilt verwijderen?\nDan worden tevens alle Subpagina\'s verwijderd.';
$_lang["confirm_delete_role"] = 'Weet u zeker dat u deze Rol wilt verwijderen?';
$_lang["confirm_delete_snippet"] = 'Weet u zeker dat u deze Snippet wilt verwijderen?';
$_lang["confirm_delete_tags"] = 'Weet u zeker dat u de geselecteerde \'META tags\' wilt verwijderen?';
$_lang["confirm_delete_template"] = 'Weet u zeker dat u deze Template wilt verwijderen?';
$_lang["confirm_delete_tmplvars"] = 'Weet u zeker dat u deze Template Variabele en alle opgeslagen waarden wilt verwijderen?';
$_lang["confirm_delete_user"] = 'Weet u zeker dat u deze Gebruiker wilt verwijderen?';
$_lang["confirm_duplicate_record"] = 'Weet u zeker dat u deze regel wilt dupliceren?';
$_lang["confirm_empty_trash"] = 'Als u de prullenbak leegmaakt worden alle gemarkeerde Pagina\'s permanent verwijderd!\n\nDoorgaan?';
$_lang["confirm_load_depends"] = 'Weet u zeker dat u dit scherm wilt verlaten? De afhankelijkheden van deze Module gaan daarbij verloren!';
$_lang["confirm_name_change"] = 'Het veranderen van de Gebruikersnaam kan invloed hebben op gekoppelde applicaties.\n\n Weet u zeker dat u de Gebruikersnaam wilt veranderen?';
$_lang["confirm_publish"] = '\n\nAls u deze Pagina nu publiceert, dan zal eventuele data van deze publicatie verloren gaan. Als u data t.a.v. (geen) publicatie wilt instellen of behouden, bewerk dan het bestand via de optie \'bewerken\'.\n\nDoorgaan?';
$_lang["confirm_remove_locks"] = 'Soms sluiten Gebruikers hun browservenster gedurende het bewerken van Pagina\'s, Templates, Snippets of parsers. Het gevolg hiervan is dat het item waaraan ze aan het werken waren, geblokkeerd worden voor andere gebruikers. Door op OK te drukken worden alle blokkeringen opgeheven.\n\nDoorgaan?';
$_lang["confirm_resource_duplicate"] = 'Weet u zeker dat u deze Pagina wilt dupliceren?\nSubmappen en Pagina\'s zullen ook gedupliceerd worden.\n\n NB: Externe gegevens (bijv. keywords, aangepaste Template Variabelen, enz...) worden niet gedupliceerd.';
$_lang["confirm_setting_language_change"] = 'U heeft de standaard waarde gewijzigd en zal de wijzigingen verliezen. Doorgaan?';
$_lang["confirm_unblock"] = 'Weet u zeker dat u voor deze Gebruiker de blokkering wilt opheffen?';
$_lang["confirm_undelete"] = '\n\nVan alle Subpagina\'s die gelijktijdig met deze Pagina verwijderd zijn, zal de verwijdering ongedaan worden gemaakt! Alle Subpagina\'s die eerder verwijderd zijn zullen verwijderd blijven.';
$_lang["confirm_unpublish"] = '\n\nAls u de publicatie van deze Pagina ongedaan wilt maken, dan zal eventuele data van deze publicatie verloren gaan. Als u data van deze publicatie wilt behouden, bewerk dan het bestand met de optie \'bewerken\'.\n\nDoorgaan?';
$_lang["confirm_unzip_file"] = 'Weet u zeker dat dit bestand uitgepakt moet worden?\n\nBestaande bestanden zullen overschreven worden.';
$_lang["could_not_find_user"] = 'Gebruiker niet gevonden';
$_lang["create_folder_here"] = 'Nieuwe Map hier aanmaken';
$_lang["create_resource_here"] = 'Nieuwe Pagina';
$_lang["create_resource_title"] = 'Nieuw Element';
$_lang["create_weblink_here"] = 'Nieuwe Weblink';
$_lang["createdon"] = 'Datum aangemaakt';
$_lang["credits"] = 'Dankwoord';
$_lang["credits_shouts_msg"] = '<ul><li><b>Raymond Irving, Ryan Thrash</b> - Oprichters Project</li><li><b>Jason Coward, Victor Brilon, Adam Crownoble, Jeff Whitfield, Remon Sijrier</b> - Core Architecture &amp; Design</li></ul>';
$_lang["custom_contenttype_message"] = 'Voeg eigen \'content types\' toe. Vul een nieuw type in en klik op de knop \'Toevoegen\' om een nieuw type toe te voegen';
$_lang["custom_contenttype_title"] = 'Toegevoegde \'content types\':';
$_lang["database_charset"] = 'Database Karakterset';
$_lang["database_collation"] = 'Database Collatie Karakterset';
$_lang["database_name"] = 'Database naam';
$_lang["database_overhead"] = '<b style="color:#990033;">Opmerking:</b> Overhead is ongebruikte ruimte gereserveerd door MySQL. Om deze ruimte vrij te maken klikt u op de link in de kolom Overhead van de tabel.';
$_lang["database_server"] = 'Database server';
$_lang["database_table_clickbackup"] = 'om de geselecteerde tabellen te backuppen &amp; te downloaden';
$_lang["database_table_clickhere"] = 'Klik hier';
$_lang["database_table_datasize"] = 'Bestandsgrootte';
$_lang["database_table_droptablestatements"] = 'Genereer DROP TABLE commando\'s.';
$_lang["database_table_effectivesize"] = 'Effectieve grootte';
$_lang["database_table_indexsize"] = 'Index grootte';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Rijen';
$_lang["database_table_tablename"] = 'Tabel naam';
$_lang["database_table_totals"] = 'Totalen:';
$_lang["database_table_totalsize"] = 'Totale grootte';
$_lang["database_tables"] = 'Database tabellen';
$_lang["database_version"] = 'Database Versie:';
$_lang["date"] = 'Datum';
$_lang["datechanged"] = 'Wijzigingsdatum';
$_lang["datepicker_offset"] = 'Kalender verschil: ';
$_lang["datepicker_offset_message"] = 'Het aantal jaar in het verleden dat getoond dient te worden in de kalender.';
$_lang["datetime_format"] = 'Datum formaat:';
$_lang["datetime_format_message"] = 'Het formaat van de datums in het Content Management Systeem.';
$_lang["defaultcache_message"] = 'Kies \'Ja\' om alle nieuwe Pagina\'s standaard cachebaar te maken.';
$_lang["defaultcache_title"] = 'Standaard cachebaar:';
$_lang["defaultmenuindex_message"] = 'Kies \'Ja\' om automatisch verhogen van de menu-index standaard te maken.';
$_lang["defaultmenuindex_title"] = 'Standaard menu indexering:';
$_lang["defaultpublish_message"] = 'Kies \'Ja\' om alle nieuwe Pagina\'s standaard te publiceren.';
$_lang["defaultpublish_title"] = 'Standaard publiceren:';
$_lang["defaultsearch_message"] = 'Kies \'Ja\' om alle nieuwe Pagina\'s standaard doorzoekbaar te maken.';
$_lang["defaultsearch_title"] = 'Standaard doorzoekbaar:';
$_lang["defaulttemplate_message"] = 'Kies hier de standaard Template voor nieuwe Pagina\'s. In de Pagina-editor kunt u eventueel een andere Template kiezen; de keuze die u hier maakt bepaalt louter welke template standaard ingesteld staat.';
$_lang["defaulttemplate_title"] = 'Standaard Template:';
$_lang["delete"] = 'Verwijderen';
$_lang["delete_resource"] = 'Verwijder Pagina';
$_lang["delete_tags"] = 'Tags verwijderen';
$_lang["deleting_file"] = 'Verwijderen bestand `%s`: ';
$_lang["description"] = 'Beschrijving';
$_lang["deselect_keywords"] = 'Deselecteer keywords';
$_lang["deselect_metatags"] = 'Verwijder \'META tags\'';
$_lang["disabled"] = 'Uitgeschakeld';
$_lang["doc_data_title"] = 'Paginadata weergeven';
$_lang["duplicate"] = 'Dupliceren';
$_lang["duplicate_alias_found"] = 'Pagina \'%s\' heeft de alias \'%s\' al in gebruik. Kies een unieke alias voor deze Pagina.';
$_lang["duplicate_alias_message"] = 'Kies \'Ja\' om dubbele aliassen toe te staan wanneer een Pagina wordt opgeslagen. <b>NB: Deze optie kan niet worden gebruikt in combinatie met \'Zoekmachine vriendelijke URL\'s\'.</b>';
$_lang["duplicate_alias_title"] = 'Dubbele aliassen toestaan:';
$_lang["duplicate_name_found_general"] = 'Er is al een %s genaamd \'%s\'. Geef a.u.b. een unieke naam op.';
$_lang["duplicate_name_found_module"] = 'Er is al een Module genaamd \'%s\'. Geef a.u.b. een unieke naam op.';
$_lang["edit"] = 'Bewerk';
$_lang["edit_resource"] = 'Bewerk Pagina';
$_lang["edit_resource_title"] = 'Maak/wijzig Pagina';
$_lang["edit_settings"] = 'Configuratie';
$_lang["editedon"] = 'Datum wijziging';
$_lang["editing_file"] = 'Bewerken bestand: ';
$_lang["editor_css_path_message"] = 'Geef het pad op naar het CSS-bestand dat u wilt gebruiken binnen de teksteditor. De beste manier om dit pad op te geven is vanaf de \'root\' (basismap) van de server, bijvoorbeeld: /assets/site/style.css. Laat dit veld leeg indien u geen CSS-bestand wilt gebruiken in de teksteditor.';
$_lang["editor_css_path_title"] = 'Pad naar CSS-bestand:';
$_lang["element"] = 'Element';
$_lang["element_categories"] = 'Gecombineerde weergave';
$_lang["element_management"] = 'Elementen beheren';
$_lang["element_name"] = 'Element naam';
$_lang["element_selector_msg"] = 'Selecteer de Element(en) uit onderstaande lijst en klik op de knop \'Toevoegen\'.';
$_lang["element_selector_title"] = 'Selecteer een Element';
$_lang["elements"] = 'Elementen';
$_lang["email"] = 'E-mail adres';
$_lang["email_sent"] = 'E-mail verzonden';
$_lang["emailsender_message"] = 'Specificeer het e-mail adres wat gebruikt wordt wanneer Gebruikers hun Gebruikersnaam en wachtwoord krijgen toegezonden.';
$_lang["emailsender_title"] = 'E-mail adres:';
$_lang["emailsubject_default"] = 'Uw inloggegevens';
$_lang["emailsubject_message"] = 'Specificeer het onderwerp van de aanmeldings e-mail.';
$_lang["emailsubject_title"] = 'Onderwerp e-mail:';
$_lang["empty_folder"] = 'Deze Map is leeg';
$_lang["empty_recycle_bin"] = 'Prullenbak leegmaken';
$_lang["empty_recycle_bin_empty"] = 'Er zijn geen verwijderde Pagina\'s om permanent te verwijderen.';
$_lang["enable_resource"] = 'Elementen inschakelen';
$_lang["enable_sharedparams"] = 'Delen van parameters inschakelen';
$_lang["enable_sharedparams_msg"] = '<b>NB:</b> Bovenstaande \'Globally Unique ID (GUID)\' wordt gebruikt om deze Module en de gedeelde parameters uniek te identificeren. De GUID wordt ook gebruikt om een link te cre&#235;eren tussen de Module en Plug-ins of Snippets die de gedeelde parameters gebruiken. ';
$_lang["enabled"] = 'Ingeschakeld';
$_lang["error"] = 'Fout';
$_lang["error_sending_email"] = 'Fout bij verzenden e-mail';
$_lang["errorpage_message"] = 'Vul hier een gepubliceerde en publiek toegankelijke Pagina ID in waar u Gebruikers naar wilt doorsturen als ze een niet-bestaande Pagina willen bekijken.';
$_lang["errorpage_title"] = 'Fout Pagina:';
$_lang["event_id"] = 'Gebeurtenis (event) Id';
$_lang["eventlog"] = 'Logboek (gebeurtenissen)';
$_lang["eventlog_msg"] = 'In het logboek voor gebeurtenissen worden informatie, waarschuwingen en foutmeldingen opgeslagen van het \'Content Management Systeem\'. De kolom \'bron\' geeft het onderdeel van het \'Content Management Systeem\' waarop het bericht betrekking heeft.';
$_lang["eventlog_viewer"] = 'Systeem gebeurtenissen';
$_lang["existing_category"] = 'Bestaande categorie';
$_lang["expand_tree"] = 'Website boomstructuur uitklappen';
$_lang["export_site"] = 'Exporteer Website';
$_lang["export_site_cacheable"] = 'Ook niet-cachebare bestanden:';
$_lang["export_site_exporting_document"] = 'Export bestand <b>%s</b> van <b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = 'Mislukt!';
$_lang["export_site_failed_no_open"] = 'Kan bestand niet openen: ';
$_lang["export_site_failed_no_retrieve"] = 'Kan Pagina niet ophalen.';
$_lang["export_site_failed_no_write"] = 'Kan niet naar bestand schrijven.';
$_lang["export_site_html"] = 'Exporteer website naar HTML';
$_lang["export_site_maxtime"] = 'Maximale export tijd:';
$_lang["export_site_maxtime_message"] = 'Specificeer hoeveel seconden MODx mag spenderen aan het exporteren van de website, onafhankelijk van de PHP instelling. Geef 0 in voor een onbeperkt aantal seconden. Let op dat 0 of een erg hoog nummer rare dingen kan veroorzaken op uw webserver en dat dit daarom niet aanbevolen is.';
$_lang["export_site_message"] = '<p>Gebruik dit om de volledige website te exporteren naar HTML bestanden. Daardoor verliest u dan wel een heel aantal voordelen van MODx:</p><ul><li>Bezoekersstatistieken worden NIET meer bijgehouden.</li><li>Interactieve Snippets werken niet meer.</li><li>Enkel gewone Pagina\'s worden ge&euml;xporteerd, gelinkte Pagina\'s niet.</li><li>Het exporteren kan mislukken indien uw Pagina\'s Snippets bevatten die \'redirection headers\' sturen.</li><li>Afhankelijk van hoe uw Pagina\'s, style sheets en Afbeeldingen werden gemaakt, kan de layout van uw website wijzigen. Om dit op te lossen kunt u de ge&euml;xporteerde bestanden verhuizen naar de Map waar de basis MODx index.php staat.</li></ul><p>Vul het formulier in en klik op \'Start export\'. De bestanden zullen bewaard worden op de plaats die u opgeeft. Waar mogelijk zal het bestand als naam de alias van de Pagina krijgen. Daarom is het beter om in de MODx configuratie de optie \'zoekmachine vriendelijke URL\'s\' aan te zetten. De export kan een tijdje duren, afhankelijk van de grootte van uw website.</p><p><em>Bestaande bestanden met dezelfde naam worden overschreven!</em></p>';
$_lang["export_site_numberdocs"] = '<p><b>%s Pagina\'s gevonden om te exporteren ...</b></p>';
$_lang["export_site_prefix"] = 'Bestands voorvoegsel:';
$_lang["export_site_start"] = 'Start exporteren';
$_lang["export_site_success"] = 'Gelukt!';
$_lang["export_site_success_skip_dir"] = 'Sla deze Map over.';
$_lang["export_site_success_skip_doc"] = 'Sla deze Pagina over.';
$_lang["export_site_suffix"] = 'Bestands achtervoegsel:';
$_lang["export_site_target_unwritable"] = 'De Map waarnaar u wilt exporteren is niet toegankelijk. Verzeker uzelf ervan dat u schrijfrechten in deze Map heeft, en probeer het daarna opnieuw.';
$_lang["export_site_time"] = 'Exporteren gereed. Het exporteren duurde %s seconden.';
$_lang["failed_login_message"] = 'Geef het maximum aantal aanmeldpogingen op voordat een Gebruiker geblokkeerd wordt.';
$_lang["failed_login_title"] = 'Mislukte aanmeldpogingen:';
$_lang["fe_editor_lang_message"] = 'Kies een taal die de editor gebruikt als front-end editor taal.';
$_lang["fe_editor_lang_title"] = 'Front-end editor taal:';
$_lang["file_delete_file"] = 'Verwijder bestand';
$_lang["file_delete_folder"] = 'Verwijder Map';
$_lang["file_deleted"] = 'Gelukt!';
$_lang["file_download_file"] = 'Bestand downloaden';
$_lang["file_download_unzip"] = 'Bestand uitpakken';
$_lang["file_folder_chmod_error"] = 'Wijzigen toegangsrechten mislukt. U dient de toegangsrechten buiten MODx om aan te passen.';
$_lang["file_folder_created"] = 'Map is aangemaakt!';
$_lang["file_folder_deleted"] = 'Map is verwijderd!';
$_lang["file_folder_not_created"] = 'Kan Map niet aanmaken';
$_lang["file_folder_not_deleted"] = 'Map kan niet verwijderd worden. Zorg ervoor dat de Map leeg is alvorens deze te verwijderen!';
$_lang["file_not_deleted"] = 'Mislukt!';
$_lang["file_not_saved"] = 'Het bestand kan niet worden bewaard. Verzeker uzelf ervan dat u schijfrechten in deze Map heeft!';
$_lang["file_saved"] = 'Bestand succesvol bewaard!';
$_lang["file_unzip"] = 'Uitpakken is gelukt!';
$_lang["file_unzip_fail"] = 'Uitpakken is mislukt!';
$_lang["filemanager_path_message"] = 'IIS kan het pad naar de MODx installatie dikwijls niet vinden. Dit pad wordt gebruikt door het bestandsbeheer om te bepalen wat u te zien krijgt. Indien u problemen ondervindt met het bestandsbeheer, controleer dan of dit pad juist staat.';
$_lang["filemanager_path_title"] = 'Pad naar de MODx installatie:';
$_lang["files_access_denied"] = 'Toegang geweigerd!';
$_lang["files_data"] = 'Gegevens';
$_lang["files_dir_listing"] = 'Bestandenlijst voor:';
$_lang["files_directories"] = 'Mappen';
$_lang["files_dirwritable"] = 'Map schrijfbaar?';
$_lang["files_editfile"] = 'Bestand bewerken';
$_lang["files_file_type"] = 'Bestandstype: ';
$_lang["files_filename"] = 'Bestandsnaam';
$_lang["files_fileoptions"] = 'Opties';
$_lang["files_files"] = 'Bestanden';
$_lang["files_filesize"] = 'Bestandsgrootte';
$_lang["files_filetype_notok"] = 'Het uploaden van dergelijke bestanden is niet toegestaan!';
$_lang["files_modified"] = 'Gewijzigd';
$_lang["files_top_level"] = 'Naar het hoogste niveau';
$_lang["files_up_level"] = 'Een niveau omhoog';
$_lang["files_upload_copyfailed"] = 'Het bestand kon niet naar de gewenste Map gekopieerd worden - uploaden mislukt!';
$_lang["files_upload_error"] = 'Fout';
$_lang["files_upload_error0"] = 'Er was een probleem bij het uploaden.';
$_lang["files_upload_error1"] = 'Het bestand dat u probeert te uploaden is te groot.';
$_lang["files_upload_error2"] = 'Het bestand dat u probeert te uploaden is te groot.';
$_lang["files_upload_error3"] = 'Het bestand dat u probeert te uploaden is slechts gedeeltelijk geupload.';
$_lang["files_upload_error4"] = 'Selecteer een bestand om te uploaden.';
$_lang["files_upload_error5"] = 'Er was een probleem bij het uploaden.';
$_lang["files_upload_inhibited_msg"] = '<b>Upload optie niet toegelaten</b> - controleer of uploaden ondersteund wordt en of de Map voor PHP schrijfbaar is.';
$_lang["files_upload_ok"] = 'Het uploaden van het bestand is succesvol verlopen!';
$_lang["files_upload_permissions_error"] = 'Mogelijk rechten probleem - de Map waar u naartoe wilt uploaden heeft schrijfrechten nodig van uw webserver.';
$_lang["files_uploadfile"] = 'Bestand uploaden';
$_lang["files_uploadfile_msg"] = 'Selecteer een bestand om te uploaden:';
$_lang["files_uploading"] = '<b>%s</b> naar <b>%s/</b> uploaden.';
$_lang["files_viewfile"] = 'Bestand weergeven';
$_lang["folder"] = 'Map';
$_lang["forgot_password_email_fine_print"] = '* De URL hierboven verloopt als u uw wachtwoord verandert of na vandaag.';
$_lang["forgot_password_email_instructions"] = 'Daar kunt u uw wachtwoord wijzigen via de menu-optie Mijn Profiel.';
$_lang["forgot_password_email_intro"] = 'Er is een verzoek gedaan om het wachtwoord van uw account te wijzigen.';
$_lang["forgot_password_email_link"] = 'Klik hier om het proces af te ronden.';
$_lang["forgot_your_password"] = 'Wachtwoord vergeten?';
$_lang["friday"] = 'Vrijdag';
$_lang["friendly_alias_message"] = 'Indien u zoekmachine vriendelijke URL\'s gebruikt en de Pagina heeft een alias, dan zal deze alias gebruikt worden in plaats van de zoekmachine vriendelijke URL. Door deze optie aan te zetten wordt het voor- en achtervoegsel ook toegepast op de alias. Bijvoorbeeld, een Pagina met ID 1 en als alias \'introductie\', zal met voorvoegsel \'\' en achtervoegsel \'.html\' vertaald worden naar \'introdcutie.html\'. Indien de Pagina geen alias heeft zal MODx de link vertalen naar \'1.html\'.';
$_lang["friendly_alias_title"] = 'Gebruik zoekmachine vriendelijke URL\'s:';
$_lang["friendlyurls_message"] = 'Gebruik zoekmachine vriendelijke URL\'s op Apache webservers met mod_rewrite of IIS met externe Plug-ins. Zie voor meer informatie het bij de distributie toegevoegde .htaccess bestand.';
$_lang["friendlyurls_title"] = 'Zoekmachine vriendelijke URL\'s:';
$_lang["friendlyurlsprefix_message"] = 'Een voorvoegsel van \'pagina\' zorgt ervoor dat de normale URL /index.php?id=2 naar de zoekmachine vriendelijke URL /pagina2.html wordt omgezet (ervan uitgaande dat het achtervoegsel op .html staat ingesteld!).';
$_lang["friendlyurlsprefix_title"] = 'Voorvoegsel zoekmachine vriendelijke URL\'s:';
$_lang["friendlyurlsuffix_message"] = 'Elk achtervoegsel die u invoert zal werken, inclusief een leeg achtervoegsel. Bijvoorbeeld \'.html\' zorgt ervoor dat er achter alle zoekmachine vriendelijke URL\'s \'.html\' wordt toegevoegd.';
$_lang["friendlyurlsuffix_title"] = 'Achtervoegsel zoekmachine vriendelijke URL\'s:';
$_lang["functionnotimpl"] = 'Sorry!';
$_lang["functionnotimpl_message"] = 'Deze functie is nog niet ontwikkeld.';
$_lang["go"] = 'Start';
$_lang["group_access_permissions"] = 'Groepstoegang';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Help';
$_lang["help_msg"] = '<p>Voor ondersteuning door de MODx gemeenschap kunt u terecht op de <a href="http://modxcms.com/forums" target="_blank">MODx Forums</a>. Op de MODx website kunt u ook <a href="http://modxcms.com/documentation" target="_blank">documentatie</a> vinden over MODx.</p><p>In de toekomst zal er commerci&#235;le ondersteuning mogelijk zijn voor MODx. Stuur een <a href=\'mailto:hello@modxcms.com?subject=MODx Commercial Support Inquiry\'>e-mail</a> als u interesse heeft.</p>';
$_lang["help_title"] = 'Help';
$_lang["hide_tree"] = 'Website boomstructuur verbergen';
$_lang["home"] = 'Start';
$_lang["htmlsnippet_desc"] = 'Beschrijving';
$_lang["htmlsnippet_management_msg"] = 'Hier kunt u Chunks toevoegen en bewerken.';
$_lang["htmlsnippet_msg"] = 'Chunk toevoegen of bewerken. Denk eraan, Chunks zijn stukjes HTML code en kunnen geen PHP code bevatten.';
$_lang["htmlsnippet_name"] = 'Naam Chunk';
$_lang["htmlsnippet_title"] = 'Maak/wijzig Chunk';
$_lang["icon"] = 'Icoon';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Hoofdpagina toekenning:\n\nPagina is een kind van de geselecteerde Pagina.';
$_lang["illegal_parent_self"] = 'Hoofdpagina toekenning::\n\nDe geselecteerde Pagina kan niet zijn eigen Hoofdpagina zijn.';
$_lang["import_files_found"] = '<b>%s Pagina\'s gevonden om te importeren...</b>';
$_lang["import_params"] = 'Gedeelde Module parameters importeren';
$_lang["import_params_msg"] = 'De parameters en instellingen van een Module kunnen worden ge&iuml;mporteerd door de naam van de Module te selecteren uit het bovenstaande menu. <b>NB:</b> Modules verschijnen in het menu wanneer de Module is ingesteld voor het \'delen van parameters\' en wanneer bij de Module is opgegeven dat de Module afhankelijk is van deze Snippet/Plug-in.';
$_lang["import_parent_resource"] = 'Hoofdpagina:';
$_lang["import_site"] = 'Importeer Website';
$_lang["import_site_failed"] = 'Fout!';
$_lang["import_site_failed_db_error"] = 'Een database fout trad op tijdens het klonen van de Pagina: ';
$_lang["import_site_failed_no_open_dir"] = 'Kon de Map niet openen: ';
$_lang["import_site_failed_no_retrieve_file"] = 'Kon bestand niet ophalen: ';
$_lang["import_site_html"] = 'Importeer website vanuit HTML';
$_lang["import_site_importing_document"] = 'Bestand importeren <b>%s</b> ';
$_lang["import_site_maxtime"] = 'Maximum tijd voor importeren:';
$_lang["import_site_maxtime_message"] = 'Hier kunt u de maximale tijd specificeren die het Content Management Systeem mag gebruiken om de website te importeren (dit heeft voorrang op de PHP instellingen). Gebruik 0 voor \'oneindige\' tijd. Let op: door 0 of een erg lange tijd in te stellen kunnen er vreemde dingen gebeuren met uw server en wordt derhalve niet aanbevolen.';
$_lang["import_site_message"] = 'Importeer een volledige HTML website naar uw database. Let op: De bestanden die ge&iuml;mporteerd moeten worden moeten in de \'assets/import\' Map geplaatst worden.</p><p>Vul het formulier in en kies \'Importeer\' om het process te starten. De ge&iuml;mporteerde bestanden worden in de geselecteerde locatie opgeslagen waarbij (indien mogelijk) gebruik gemaakt wordt van de bestandsnamen voor Pagina aliassen waar mogelijk en de Paginatitel tag voor de Paginatitel.';
$_lang["import_site_skip"] = 'Overgeslagen!';
$_lang["import_site_start"] = 'Start importeren';
$_lang["import_site_success"] = 'OK!';
$_lang["import_site_time"] = 'Importeren gereed. Het importeren duurde %s seconden.';
$_lang["inbox"] = 'Inbox';
$_lang["info"] = 'Info';
$_lang["information"] = 'Informatie';
$_lang["inline"] = 'Ge&iuml;ntegreerd';
$_lang["insert"] = 'Invoegen';
$_lang["keyword"] = 'Keyword';
$_lang["keywords"] = 'Keywords (sleutelwoorden)';
$_lang["keywords_intro"] = 'Een keyword kan worden veranderd door in het invulveld naast het keyword de nieuwe waarde op te geven. Vink \'verwijder keyword\' aan om een keyword te verwijderen. Let erop dat verwijderen voorrang heeft op bewerken.';
$_lang["language_message"] = 'U kunt hier de taal voor het MODx Content Management Systeem selecteren.';
$_lang["language_title"] = 'Taal:';
$_lang["launch_site"] = 'Website bekijken';
$_lang["link_attributes"] = 'Link attributen';
$_lang["link_attributes_help"] = 'Hier kunt u attributen opgeven voor de link naar deze Pagina, zoals target=&quot;_blank&quot; of rel=&quot;external&quot;.';
$_lang["list_mode"] = 'Lijst weergave aan/uit - geeft alle rijen in de tabel weer.';
$_lang["loading_doc_tree"] = 'Website boomstructuur wordt geladen...';
$_lang["loading_menu"] = 'Menu wordt geladen...';
$_lang["loading_page"] = 'Een moment geduld a.u.b., MODx is de Pagina aan het laden...';
$_lang["localtime"] = 'Lokale tijd';
$_lang["lock_htmlsnippet"] = 'Blokkeer Chunk wijzigingen.';
$_lang["lock_htmlsnippet_msg"] = 'Alleen beheerders (profiel ID 1) kunnen deze Chunk wijzigen.';
$_lang["lock_module"] = 'Blokkeer Module wijzigingen.';
$_lang["lock_module_msg"] = 'Alleen beheerders (profiel ID 1) kunnen deze Module bewerken.';
$_lang["lock_msg"] = '%s bewerkt nu %s. Bewerking is niet mogelijk totdat deze Gebruiker klaar is.';
$_lang["lock_plugin"] = 'Blokkeer Plug-in wijzigingen.';
$_lang["lock_plugin_msg"] = 'Alleen beheerders (profiel ID 1) kunnen deze Plug-in wijzigen.';
$_lang["lock_settings_msg"] = '%s is deze instellingen aan het bewerken. Bewerking is niet mogelijk totdat deze Gebruiker klaar is.';
$_lang["lock_snippet"] = 'Blokkeer Snippet wijzigingen.';
$_lang["lock_snippet_msg"] = 'Alleen beheerders (profiel ID 1) kunnen deze Snippet wijzigen.';
$_lang["lock_template"] = 'Blokkeer Template wijzigingen.';
$_lang["lock_template_msg"] = 'Alleen beheerders (profiel ID 1) kunnen deze Template wijzigen.';
$_lang["lock_tmplvars"] = 'Blokkeer Template Variabele wijzigingen.';
$_lang["lock_tmplvars_msg"] = 'Alleen beheerders (profiel ID 1) kunnen deze Template Variabele wijzigen.';
$_lang["locked"] = 'Geblokkeerd';
$_lang["login_allowed_days"] = 'Toegestane dagen';
$_lang["login_allowed_days_message"] = 'Selecteer de dagen dat deze Gebruiker mag inloggen.';
$_lang["login_allowed_ip"] = 'Toegestane IP Adressen';
$_lang["login_allowed_ip_message"] = 'Voer de IP adressen in waarop deze Gebruiker zich mag aanmelden. <b>NB: Meerdere IP adressen worden gescheiden met een komma (,)</b>';
$_lang["login_button"] = 'Aanmelden';
$_lang["login_cancelled_install_in_progress"] = 'Installatie / update van deze website is momenteel in gang gezet. Probeer het a.u.b. nogmaals over een paar minuten!';
$_lang["login_cancelled_site_was_updated"] = 'Installatie / update op deze website is uitgevoerd, meld u a.u.b. nogmaals aan!';
$_lang["login_captcha_message"] = ' De beheerder heeft de Captcha validatie ingeschakeld. Dit betekent dat u deze beveiligingscode hier moet ingeven.\n\nIndien de code slecht leesbaar is, kan u op de code zelf klikken om een nieuwe code te laten aanmaken.';
$_lang["login_homepage"] = 'Login Startpagina';
$_lang["login_homepage_message"] = 'Voer de ID in van de Pagina waarnaar Gebruikers worden verwezen als ze aangemeld zijn. <b>NB: Zorg ervoor dat de ID dat u invoert een bestaand, gepubliceerd en voor deze Gebruiker toegankelijke Pagina is!</b>';
$_lang["login_message"] = 'Om MODx te gebruiken dient u zich eerst aan te melden. Let op: hierbij wordt onderscheid gemaakt tussen hoofd- en kleine letters!';
$_lang["logo_slogan"] = 'MODx Content Management Systeem - \nCre&#235;er en doe meer met minder';
$_lang["logout"] = 'Afmelden';
$_lang["long_title"] = 'Uitgebreide titel';
$_lang["mail_check_timeperiod_message"] = 'Hoe vaak in het Content Management Systeem gecontroleerd wordt op nieuwe berichten, in seconden.';
$_lang["mail_check_timeperiod_title"] = 'Controleer e-mail tijdsinterval:';
$_lang["manage_depends"] = 'Beheer afhankelijkheden';
$_lang["manage_files"] = 'Bestandsbeheer';
$_lang["manage_htmlsnippets"] = 'Chunks';
$_lang["manage_metatags"] = 'Beheer META tags en keywords';
$_lang["manage_modules"] = 'Modulebeheer';
$_lang["manage_plugins"] = 'Plug-ins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Templates';
$_lang["manager"] = 'Content Management Systeem';
$_lang["manager_lockout_message"] = 'U bent momenteel aangemeld bij het Content Management Systeem. Als u uw sessie wilt sluiten, klik dan a.u.b. op de knop "Afmelden". <p />Wilt u naar uw start- of homepage klik dan op de knop "Start".';
$_lang["manager_permissions"] = 'Toegangsbeheer';
$_lang["manager_theme"] = 'Content Management Systeem thema:';
$_lang["manager_theme_message"] = 'Selecteer een thema voor het Content Management Systeem.';
$_lang["messages"] = 'Berichten';
$_lang["messages_all"] = 'Iedereen';
$_lang["messages_compose"] = 'Bericht opstellen';
$_lang["messages_forward"] = 'Doorsturen';
$_lang["messages_from"] = 'Van';
$_lang["messages_group"] = 'Een groep';
$_lang["messages_inbox"] = 'Inbox';
$_lang["messages_message"] = 'Bericht';
$_lang["messages_no_messages"] = 'Er zijn geen berichten in de Inbox.';
$_lang["messages_not_allowed_to_read"] = 'U bent niet bevoegd om dit bericht te lezen!';
$_lang["messages_private"] = 'Priv&#233;';
$_lang["messages_read_message"] = 'Bericht lezen';
$_lang["messages_reply"] = 'Beantwoord';
$_lang["messages_select_group"] = 'Selecteer een groep';
$_lang["messages_select_user"] = 'Selecteer een Gebruiker';
$_lang["messages_send"] = 'Verzenden';
$_lang["messages_send_to"] = 'Verzend aan';
$_lang["messages_sent"] = 'Verstuurd op';
$_lang["messages_subject"] = 'Onderwerp';
$_lang["messages_system_user"] = '[Systeem]';
$_lang["messages_title"] = 'Berichten';
$_lang["messages_user"] = 'Een Gebruiker';
$_lang["meta_keywords"] = 'META keywords';
$_lang["metatag_intro"] = 'Op deze Pagina kunt u \'META tags\' toevoegen, verwijderen en bewerken. De \'META tags\' kunt u aan Pagina\'s toevoegen op de <u>META keywords</u> tab bij het bewerken van een Pagina. Vul een naam en een waarde in voor een nieuwe tag en klik op de \'Tag toevoegen\' knop om een nieuwe \'tag\' toe te voegen. Klik op de naam van een \'tag\' om deze te bewerken.';
$_lang["metatag_notice"] = 'Misschien wilt u een <a href="http://www.html-reference.com/META.asp" target="_blank">HTML Reference Guide</a> raadplegen voor meer informatie. Dit is geen complete lijst van mogelijke Meta Tags.';
$_lang["metatags"] = 'META tags';
$_lang["mgr_access_permissions"] = 'Content Management Systeem toegangsbeheer';
$_lang["mgr_login_start"] = 'Content Management Systeem Login Startpagina';
$_lang["mgr_login_start_message"] = 'Geef de ID van de Pagina dat wordt getoond nadat een Gebruiker is ingelogd. <b>NB: Let erop dat de ID bestaat, dat de Pagina gepubliceerd is en dat de Pagina toegankelijk is voor de Gebruiker!</b>';
$_lang["mgrlog_action"] = 'Handeling';
$_lang["mgrlog_actionid"] = 'Handeling ID';
$_lang["mgrlog_anyall"] = 'Enkele/Alles';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() retourneerde \'false\'.';
$_lang["mgrlog_datefr"] = 'Datum van';
$_lang["mgrlog_dateinvalid"] = 'Onjuiste datumindeling.';
$_lang["mgrlog_dateto"] = 'Datum tot';
$_lang["mgrlog_emptysrch"] = 'Uw zoekopdracht gaf geen resultaten (d.w.z. geen overeenkomstige loggegevens gevonden).';
$_lang["mgrlog_field"] = 'Veld';
$_lang["mgrlog_itemid"] = 'Item ID';
$_lang["mgrlog_itemname"] = 'Item naam';
$_lang["mgrlog_msg"] = 'Bericht';
$_lang["mgrlog_noquery"] = 'Nog geen zoekopdracht opgegeven.';
$_lang["mgrlog_qresults"] = 'Zoekresultaten';
$_lang["mgrlog_query"] = 'Zoek loggegevens';
$_lang["mgrlog_query_msg"] = 'Maak a.u.b. een selectie om de logboeken te bekijken. U kunt log regels op datum selecteren, maar let erop dat de ingegeven einddatums niet inbegrepen zijn - om elke log regel te selecteren van 01-01-2004, vul bij \'datum van\' 01-01-2004 in en bij \'datum tot\' 02-01-2004.<br /><br />Melding en aktie zijn meestal hetzelfde. Als u een specifieke melding zoekt, kunt u het beste de aktie op \'Enkele/Alles\' zetten.';
$_lang["mgrlog_results"] = 'Aantal gevonden';
$_lang["mgrlog_searchlogs"] = 'Logboeken doorzoeken';
$_lang["mgrlog_sortinst"] = 'Sorteer de tabel door op de kolom-kop te klikken. Als de logboeken te groot worden, <a href="index.php?a=55">leeg de logfile</a> om alle huidige loggegevens te wissen. Dit kan niet ongedaan gemaakt worden!';
$_lang["mgrlog_time"] = 'Tijd';
$_lang["mgrlog_user"] = 'Gebruiker';
$_lang["mgrlog_username"] = 'Gebruikersnaam';
$_lang["mgrlog_value"] = 'waarde';
$_lang["mgrlog_view"] = 'Bekijk Content Management Systeem logboeken';
$_lang["module_code"] = 'Module code (php)';
$_lang["module_config"] = 'Module configuratie';
$_lang["module_desc"] = 'Beschrijving';
$_lang["module_disabled"] = 'Module uitgeschakeld';
$_lang["module_edit_click_title"] = 'Klik hier om de Module te bewerken';
$_lang["module_group_access_msg"] = 'Selecteer de Gebruikersgroepen die deze Module binnen het Content Management Systeem mogen uitvoeren.';
$_lang["module_management"] = 'Modulebeheer';
$_lang["module_management_msg"] = 'Hier kunt u Modules toevoegen, bewerken en uitvoeren.<br />Klik op het icoon van de Module om de Module uit te voeren. Klik op de naam van de Module om de Module te bewerken.';
$_lang["module_msg"] = 'Module toevoegen of bewerken. Een Module is een verzameling van Elementen zoals Plug-ins, Snippets, etc.';
$_lang["module_name"] = 'Modulenaam';
$_lang["module_resource_msg"] = 'Elementen waarvan deze Module afhankelijk is kunnen hier worden aangepast. Kies de knop \'toevoegen\' hieronder om een Element toe te voegen.';
$_lang["module_resource_title"] = 'Module afhankelijkheden';
$_lang["module_title"] = 'Modules bewerken/toevoegen';
$_lang["module_viewdepend_msg"] = 'Een Module is afhankelijk van bepaalde Elementen. Klik op de knop \'Beheer afhankelijkheden\' om deze te bewerken.';
$_lang["modules"] = 'Modules';
$_lang["modx_news"] = 'MODx nieuws waarschuwingen';
$_lang["modx_news_tab"] = 'MODx nieuws';
$_lang["modx_news_title"] = 'MODx nieuws';
$_lang["modx_security_notices"] = 'MODx beveiligingswaarschuwingen';
$_lang["modx_version"] = 'MODx versie';
$_lang["monday"] = 'Maandag';
$_lang["move"] = 'Verplaatsen';
$_lang["move_resource"] = 'Verplaats Pagina';
$_lang["move_resource_message"] = 'Verplaats een Pagina inclusief Subpagina\'s door een nieuw Hoofdpagina in de Website boomstructuur te selecteren. Als de geselecteerde Pagina geen Map is, wordt er een Map van gemaakt. Selecteer een nieuw Hoofdpagina in de Website boomstructuur.';
$_lang["move_resource_new_parent"] = 'Selecteer een nieuwe Hoofdpagina in de Website boomstructuur.';
$_lang["move_resource_title"] = 'Pagina verplaatsen';
$_lang["name"] = 'Naam';
$_lang["new_category"] = 'Nieuwe categorie';
$_lang["new_file_permissions_message"] = 'Bij het uploaden van een nieuw bestand in het Bestandsbeheer, zal het Bestandsbeheer proberen de bestandsrechten aan te passen volgens de instellingen die hier zijn opgegeven. Het kan zijn dat dit niet met alle installaties werkt, zoals met IIS, in welk geval u de rechten handmatig moet instellen.';
$_lang["new_file_permissions_title"] = 'Nieuwe bestandsrechten:';
$_lang["new_folder_permissions_message"] = 'Als u een nieuwe Map aanmaakt in het Bestandsbeheer, zal het Bestandsbeheer proberen de Maprechten aan te passen volgens de instellingen die hier zijn opgegeven. Het kan zijn dat dit niet met alle installaties werkt, zoals met IIS, in welk geval u de rechten handmatig moet instellen.';
$_lang["new_folder_permissions_title"] = 'Nieuwe Maprechten:';
$_lang["new_htmlsnippet"] = 'Nieuwe Chunk toevoegen';
$_lang["new_keyword"] = 'Voeg een keyword toe:';
$_lang["new_module"] = 'Nieuwe Module toevoegen';
$_lang["new_parent"] = 'Nieuwe Hoofdpagina toevoegen';
$_lang["new_plugin"] = 'Nieuwe Plug-in toevoegen';
$_lang["new_role"] = 'Rol toevoegen';
$_lang["new_snippet"] = 'Nieuwe Snippet toevoegen';
$_lang["new_template"] = 'Nieuwe Template toevoegen';
$_lang["new_tmplvars"] = 'Nieuwe Template Variabele toevoegen';
$_lang["new_user"] = 'Nieuwe Gebruiker toevoegen';
$_lang["new_web_user"] = 'Nieuwe Webgebruiker toevoegen';
$_lang["no"] = 'Nee';
$_lang["no_active_users_found"] = 'Geen actieve Gebruikers gevonden.';
$_lang["no_activity_message"] = 'U heeft nog geen Pagina\'s gemaakt/gewijzigd.';
$_lang["no_category"] = 'Niet gecategoriseerd';
$_lang["no_docs_pending_publishing"] = 'Geen Pagina\'s om te publiceren.';
$_lang["no_docs_pending_pubunpub"] = 'Geen gebeurtenissen gevonden.';
$_lang["no_docs_pending_unpublishing"] = 'Geen Pagina\'s om publicatie te be&#235;indigen.';
$_lang["no_edits_creates"] = 'Geen wijzigingen of toevoegingen gevonden.';
$_lang["no_groups_found"] = 'Geen groepen gevonden.';
$_lang["no_keywords_found"] = 'Er zijn momenteel geen keywords.';
$_lang["no_records_found"] = 'Geen resultaten gevonden.';
$_lang["no_results"] = 'Geen resultaten gevonden.';
$_lang["nologentries_message"] = 'Voer hier het aantal logresultaten in dat per Pagina in het logboek moet worden weergegeven.';
$_lang["nologentries_title"] = 'Aantal logresultaten:';
$_lang["nomessages_message"] = 'U kunt hier het aantal berichten instellen dat bij het bekijken van berichten in de inbox moet worden weergegeven.';
$_lang["nomessages_title"] = 'Aantal berichten:';
$_lang["none"] = 'Geen';
$_lang["noresults_message"] = 'Het aantal regels dat wordt weergegeven in lijsten met bijvoorbeeld zoekresultaten';
$_lang["noresults_title"] = 'Aantal regels:';
$_lang["not_deleted"] = 'is niet verwijderd!';
$_lang["not_set"] = 'Niet ingesteld';
$_lang["offline"] = 'Offline';
$_lang["online"] = 'Online';
$_lang["onlineusers_action"] = 'Handeling';
$_lang["onlineusers_actionid"] = 'Handeling ID';
$_lang["onlineusers_ipaddress"] = 'IP adres Gebruiker';
$_lang["onlineusers_lasthit"] = 'Laatste bezoek';
$_lang["onlineusers_message"] = 'In deze lijst vindt u de actieve Gebruikers van de laatste 20 minuten (De huidige tijd is ';
$_lang["onlineusers_title"] = 'Gebruikers online';
$_lang["onlineusers_user"] = 'Gebruiker';
$_lang["onlineusers_userid"] = 'Gebruikers ID';
$_lang["optimize_table"] = 'Klik hier om deze tabel te optimaliseren';
$_lang["page_data_cacheable"] = 'Cache-baar';
$_lang["page_data_cacheable_help"] = 'Dit zorgt ervoor dat deze Pagina in de cache opgeslagen kan worden. Zorg dat deze optie niet aangevinkt is als uw Pagina Snippets bevat!';
$_lang["page_data_cached"] = '<b>Bron uit cache gehaald:</b>';
$_lang["page_data_changes"] = 'Veranderingen';
$_lang["page_data_contentType"] = 'Soort inhoud';
$_lang["page_data_contentType_help"] = 'Kies de soort van inhoud voor deze Pagina. Bent u hierover onzeker, laat dan de keuze op text/html.';
$_lang["page_data_created"] = 'Gemaakt';
$_lang["page_data_edited"] = 'Gewijzigd';
$_lang["page_data_editor"] = 'Bewerk met de geavanceerde teksteditor';
$_lang["page_data_folder"] = 'Pagina is een Map';
$_lang["page_data_general"] = 'Algemeen';
$_lang["page_data_markup"] = 'Opmaak/structuur';
$_lang["page_data_mgr_access"] = 'Content Management Systeem toegang';
$_lang["page_data_notcached"] = 'Deze Pagina is (nog) niet gecached.';
$_lang["page_data_publishdate"] = 'Publicatiedatum';
$_lang["page_data_publishdate_help"] = 'Als u een publicatiedatum instelt, wordt de Pagina vanaf deze datum gepubliceerd. Klik op het kalenderpictogram om een datum te selecteren, of op het pictogram ernaast om de publicatiedatum te verwijderen. Dit houdt in dat de Pagina niet automatisch wordt gepubliceerd.';
$_lang["page_data_published"] = 'Gepubliceerd';
$_lang["page_data_searchable"] = 'Doorzoekbaar';
$_lang["page_data_searchable_help"] = 'U kunt deze optie aanvinken om het doorzoeken van de Pagina toe te staan. U kunt het ook voor andere doeleinden gebruiken in uw Snippets.';
$_lang["page_data_source"] = 'Bron';
$_lang["page_data_status"] = 'Status';
$_lang["page_data_template"] = 'Template';
$_lang["page_data_template_help"] = 'Hier kunt u de Template voor de Pagina selecteren.';
$_lang["page_data_title"] = 'Pagina gegevens';
$_lang["page_data_unpublishdate"] = 'Datum einde publicatie';
$_lang["page_data_unpublishdate_help"] = 'Als u een datum einde publicatie instelt, wordt vanaf deze datum de publicatie be&#235;indigd. Klik op het kalenderpictogram om een datum te selecteren, of op het pictogram ernaast om de datum waarop de publicatie be&#235;indigd wordt, te verwijderen. Dit houdt in dat de publicatie van de Pagina niet automatisch be&#235;indigd wordt.';
$_lang["page_data_unpublished"] = 'Niet-gepubliceerd';
$_lang["page_data_web_access"] = 'Webtoegang';
$_lang["pagetitle"] = 'Titel van de Pagina';
$_lang["pagination_table_first"] = 'Eerste';
$_lang["pagination_table_gotopage"] = 'Ga naar Pagina';
$_lang["pagination_table_last"] = 'Laatste';
$_lang["paging_first"] = 'eerste';
$_lang["paging_last"] = 'laatste';
$_lang["paging_next"] = 'volgende';
$_lang["paging_prev"] = 'vorige';
$_lang["paging_showing"] = 'Toon';
$_lang["paging_to"] = 'tot';
$_lang["paging_total"] = 'totaal';
$_lang["parameter"] = 'Parameter';
$_lang["password"] = 'Wachtwoord';
$_lang["password_change_request"] = 'Verzoek wachtwoord wijzigen';
$_lang["password_gen_gen"] = 'Laat MODx het wachtwoord genereren.';
$_lang["password_gen_length"] = 'Het wachtwoord moet minstens 6 karakters lang zijn.';
$_lang["password_gen_method"] = 'Hoe wilt u het wachtwoord voor deze Gebruiker aanmaken?';
$_lang["password_gen_specify"] = 'Laat mij het wachtwoord specificeren:';
$_lang["password_method"] = 'Hoe wilt u deze Gebruiker op de hoogte stellen van het nieuwe wachtwoord?';
$_lang["password_method_email"] = 'Verstuur het nieuwe wachtwoord via e-mail.';
$_lang["password_method_screen"] = 'Geef het nieuwe wachtwoord op het beeldscherm weer.';
$_lang["password_msg"] = 'Het nieuwe wachtwoord voor <b>%s</b> is <b>%s</b>.';
$_lang["php_version_check"] = 'MODx is geschikt voor PHP versie 4.0.3 en hoger. U dient uw PHP distributie te upgraden!';
$_lang["plugin"] = 'Plug-in';
$_lang["plugin_code"] = 'Plug-in code (php)';
$_lang["plugin_config"] = 'Plug-in configuratie';
$_lang["plugin_desc"] = 'Beschrijving';
$_lang["plugin_disabled"] = 'Plug-in uitgeschakeld';
$_lang["plugin_event_msg"] = 'Selecteer de gebeurtenissen (events) waar deze Plug-in op moet reageren.';
$_lang["plugin_management_msg"] = 'Hier kunt u Plug-ins toevoegen of bewerken.';
$_lang["plugin_msg"] = 'Hier kunt u Plug-ins toevoegen of bewerken. Plug-ins zijn \'ruwe\' PHP instructies die uitgevoerd worden als de geselecteerde systeemgebeurtenissen (events) optreden.';
$_lang["plugin_name"] = 'Naam Plug-in';
$_lang["plugin_priority"] = 'Wijzig de uitvoer-volgorde van Plug-ins op basis van gebeurtenissen (events).';
$_lang["plugin_priority_instructions"] = 'Om de volgorde van de Plug-ins te veranderen versleep onder elke gebeurtenis (event) de titel. De eerste Plug-in die uitgevoerd dient te worden dient bovenaan te staan.';
$_lang["plugin_priority_title"] = 'Plug-in uitvoer volgorde';
$_lang["plugin_title"] = 'Aanmaken/bewerken Plug-in';
$_lang["preview"] = 'Voorbeeld';
$_lang["preview_msg"] = 'Dit is een voorbeeld van de laatst opgeslagen veranderingen. Klik op de link om veranderingen op te slaan en het voorbeeld te vernieuwen. <a href="#" onclick="saveRefreshPreview();">Opslaan en vernieuwen</a>';
$_lang["preview_resource"] = 'Pagina voorbeeld';
$_lang["private"] = 'Gesloten';
$_lang["public"] = 'Open';
$_lang["publish_date"] = 'Publicatiedatum';
$_lang["publish_events"] = 'Publiceer gebeurtenissen';
$_lang["publish_resource"] = 'Publiceer Pagina';
$_lang["rb_base_dir_message"] = 'Het fysieke pad naar de Map met bestanden. Normaal gesproken wordt dit automatisch gegenereerd. Helaas komt het bij het gebruik van IIS voor dat MODx niet in staat is om het pad automatisch te genereren. In dat geval kan hier het pad naar de Map worden opgegeven (dit is het pad dat u ziet in Windows Verkenner). <b>NB:</b> Voor een juiste werking van het bestandsbeheer moet de hier opgegeven Map de volgende submappen bevatten: images, files, flash en media.';
$_lang["rb_base_dir_title"] = 'Pad naar de bestanden:';
$_lang["rb_base_url_message"] = 'Het virtuele pad naar de bestanden. Normaal gesproken wordt dit automatisch gegenereerd. Helaas komt het bij het gebruik van IIS voor dat MODx niet in staat is om het pad automatisch te genereren. In dat geval kan hier het pad naar de Map worden opgegeven (dit is het pad dat u ziet in uw web browser)';
$_lang["rb_base_url_title"] = 'URL naar de bestanden:';
$_lang["rb_message"] = 'Kies \'ja\' om de bestandsbeheer in te schakelen. Met bestandsbeheer is het voor Gebruikers eenvoudig mogelijk om bestanden zoals afbeeldingen, flash en media op de server te plaatsen.';
$_lang["rb_title"] = 'Bestandsbeheer inschakelen:';
$_lang["rb_webuser_message"] = 'Wilt u de Webgebruikers toestaan de bestanden op de server te beheren? <b>WAARSCHUWING:</b> Door dit toe te staan kunnen Webgebruikers dezelfde bestanden beheren als de website beheerder(s). Gebruik dit alleen voor Webgebruikers die u vertrouwd.';
$_lang["rb_webuser_title"] = 'Webgebruikers:';
$_lang["recent_docs"] = 'Recente Pagina\'s';
$_lang["refresh_cache"] = 'Cache: <b>%s</b> bestanden in cache-map gevonden en <b>%d</b> bestanden verwijderd.<p>Nieuwe cache-bestanden worden aangemaakt wanneer Pagina\'s worden opgevraagd.';
$_lang["refresh_published"] = '<b>%s</b> Pagina\'s zijn gepubliceerd.';
$_lang["refresh_site"] = 'Cache legen';
$_lang["refresh_title"] = 'Website vernieuwen';
$_lang["refresh_tree"] = 'Website boomstructuur vernieuwen';
$_lang["refresh_unpublished"] = '<b>%s</b> Pagina\'s zijn niet gepubliceerd.';
$_lang["remember_username"] = 'Gebruikersnaam onthouden';
$_lang["remove"] = 'Verwijder';
$_lang["remove_date"] = 'Verwijder datum';
$_lang["remove_locks"] = 'Blokkeringen opheffen';
$_lang["rename"] = 'Hernoem';
$_lang["reports"] = 'Rapportage';
$_lang["require_tagname"] = 'Een naam voor de \'tag\' is vereist.';
$_lang["require_tagvalue"] = 'Een waarde voor de \'tag\' is vereist.';
$_lang["reset"] = 'Reset';
$_lang["reset_failedlogins"] = 'Reset';
$_lang["resolve_hostnames_message"] = 'Moet MODx de hostnames (computernamen) van uw bezoekers trachten te vertalen? Dit kan de belasting van uw server iets verhogen, maar de bezoekers zullen hier niets van merken.';
$_lang["resolve_hostnames_title"] = 'Vertaal hostnames (computernamen)';
$_lang["resource"] = 'Pagina';
$_lang["resource_alias"] = 'Pagina alias';
$_lang["resource_alias_help"] = 'Hier kunt u voor deze Pagina een alias invoeren. Dit zal de Pagina toegangelijk maken als u gebruik maakt van http://uwsite.nl/alias. Dit werkt alleen als u gebruik maakt van zoekmachine vriendelijke URL\'s.';
$_lang["resource_content"] = 'Paginainhoud';
$_lang["resource_description"] = 'Beschrijving';
$_lang["resource_description_help"] = 'Geef een eventuele beschrijving op van deze Pagina.';
$_lang["resource_duplicate"] = 'Dupliceer Pagina';
$_lang["resource_long_title_help"] = 'Geef een langere titel op van deze Pagina. Dit kan handig zijn voor zoekmachines en is misschien ook een betere beschrijving van uw Pagina.';
$_lang["resource_metatag_help"] = 'Selecteer de \'META tags\' of keywords die u aan de Pagina wilt toekennen. Met de CTRL-toets (cmd in Mac OS) kunnen meerdere META tags worden geselecteerd';
$_lang["resource_opt_contentdispo"] = 'Content-Disposition';
$_lang["resource_opt_contentdispo_help"] = 'Gebruik \'Content-Disposition\' om aan te geven hoe de Pagina wordt behandeld door de webbrowser. Gebruik \'Bijlage\' voor separate bestanden.';
$_lang["resource_opt_emptycache"] = 'Cache leegmaken?';
$_lang["resource_opt_emptycache_help"] = 'Laat dit aangevinkt zodat MODx de cache leegmaakt na het opslaan van de Pagina. Dit zorgt ervoor dat uw bezoekers geen oude versie van de Pagina te zien krijgen.';
$_lang["resource_opt_folder"] = 'Map?';
$_lang["resource_opt_folder_help"] = 'U kunt deze optie aanvinken om deze Pagina als een Map voor andere Pagina\'s te gebruiken. U hoeft hier niet te veel aandacht aan te besteden, aangezien MODx Mapinstellingen over het algemeen automatisch verzorgt.';
$_lang["resource_opt_menu_index"] = 'Menu index';
$_lang["resource_opt_menu_index_help"] = 'De menu-index is een veld waarmee u het sorteren van Pagina\'s kunt be&iuml;nvloeden, voornamelijk in menu\'s en opsommingen. U kunt het ook voor andere doeleinden gebruiken in uw Snippets.';
$_lang["resource_opt_menu_title"] = 'Menu titel';
$_lang["resource_opt_menu_title_help"] = 'De menu titel is een optioneel veld dat gebruikt wordt om een korte titel te tonen in menu Snippet(s) of Modules.';
$_lang["resource_opt_published"] = 'Gepubliceerd?';
$_lang["resource_opt_published_help"] = 'Vink deze optie aan zodat uw Pagina automatisch gepubliceerd wordt na het opslaan.';
$_lang["resource_opt_richtext"] = 'Teksteditor gebruiken?';
$_lang["resource_opt_richtext_help"] = 'Laat dit aangevinkt staan om de teksteditor voor geavanceerde tekstopmaak bij het bewerken Pagina\'s te gebruiken. Als uw Pagina Javascript code of formulieren bevat is het verstandig om deze optie uit te zetten, zodat u in HTML-modus kunt werken. Dit zorgt ervoor dat uw Pagina correct wordt weergegeven.';
$_lang["resource_opt_show_menu"] = 'Zichtbaar in menu';
$_lang["resource_opt_show_menu_help"] = 'Gebruikt door een aantal Plug-ins/Modules om deze Pagina niet te tonen in een menu.';
$_lang["resource_opt_trackvisit_help"] = 'Sla elke bezoeker op deze Pagina op in het logboek.';
$_lang["resource_overview"] = 'Pagina overzicht';
$_lang["resource_parent"] = 'Hoofdpagina';
$_lang["resource_parent_help"] = 'Selecteer een Pagina in de Website boomstructuur om het als Hoofdpagina van deze Pagina in te stellen.';
$_lang["resource_permissions_error"] = 'Koppel deze Pagina aan tenminste 1 Paginagroep waar u toegang tot heeft.';
$_lang["resource_setting"] = 'Pagina instellingen';
$_lang["resource_summary"] = 'Samenvatting (introductietekst)';
$_lang["resource_summary_help"] = 'Typ een korte beschrijving van de Pagina.';
$_lang["resource_title"] = 'Titel';
$_lang["resource_title_help"] = 'U kunt hier de titel van de Pagina opgeven. Vermijdt het gebruik van backslashes in de naam!';
$_lang["resource_to_be_moved"] = 'De te verplaatsen Pagina';
$_lang["resource_weblink_help"] = 'Typ hier het adres van het object waarnaar u wilt verwijzen met deze Weblink.';
$_lang["resources_in_container"] = 'Pagina\'s in deze Map';
$_lang["resources_in_container_no"] = 'Deze Map bevat geen Subpagina\'s.';
$_lang["role"] = 'Rol';
$_lang["role_about"] = 'Infopagina weergeven';
$_lang["role_access_persmissions"] = 'Toegangsrechten';
$_lang["role_actionok"] = '\'Bewerking is voltooid\'-scherm weergeven';
$_lang["role_bk_manager"] = 'Backupbeheer gebruiken';
$_lang["role_cache_refresh"] = 'De cache van de website leegmaken';
$_lang["role_change_password"] = 'Wachtwoord wijzigen';
$_lang["role_chunk_management"] = 'Chunkbeheer';
$_lang["role_config_management"] = 'Configuratiebeheer';
$_lang["role_content_management"] = 'Inhoudbeheer';
$_lang["role_create_chunk"] = 'Nieuwe Chunks maken';
$_lang["role_create_doc"] = 'Nieuwe Pagina\'s maken';
$_lang["role_create_plugin"] = 'Nieuwe Plug-ins maken';
$_lang["role_create_snippet"] = 'Nieuwe Snippets maken';
$_lang["role_create_template"] = 'Nieuwe website Templates maken';
$_lang["role_credits"] = 'Dankwoord weergeven';
$_lang["role_delete_chunk"] = 'Chunks verwijderen';
$_lang["role_delete_doc"] = 'Pagina\'s verwijderen';
$_lang["role_delete_eventlog"] = 'Verwijder logboek (events)';
$_lang["role_delete_module"] = 'Module verwijderen';
$_lang["role_delete_plugin"] = 'Plug-ins verwijderen';
$_lang["role_delete_role"] = 'Rollen verwijderen';
$_lang["role_delete_snippet"] = 'Snippets verwijderen';
$_lang["role_delete_template"] = 'Templates verwijderen';
$_lang["role_delete_user"] = 'Gebruikers verwijderen';
$_lang["role_delete_web_user"] = 'Webgebruikers verwijderen';
$_lang["role_edit_chunk"] = 'Chunks bewerken';
$_lang["role_edit_doc"] = 'Een Pagina bewerken';
$_lang["role_edit_doc_metatags"] = '\'META tags\' en keywords van Pagina bewerken';
$_lang["role_edit_module"] = 'Module bewerken';
$_lang["role_edit_plugin"] = 'Plug-ins bewerken';
$_lang["role_edit_role"] = 'Rollen bewerken';
$_lang["role_edit_settings"] = 'Website instellingen veranderen';
$_lang["role_edit_snippet"] = 'Snippets bewerken';
$_lang["role_edit_template"] = 'Website Templates bewerken';
$_lang["role_edit_user"] = 'Gebruikers bewerken';
$_lang["role_edit_web_user"] = 'Webgebruikers bewerken';
$_lang["role_empty_trash"] = 'Verwijderde Pagina\'s permanent verwijderen';
$_lang["role_errors"] = 'Waarschuwingsvenster weergeven';
$_lang["role_eventlog_management"] = 'Logboek beheer (events)';
$_lang["role_export_static"] = 'Exporteer statische HTML';
$_lang["role_file_manager"] = 'Bestandsbeheer gebruiken';
$_lang["role_frames"] = 'Verzoek om Content Management Systeem venster';
$_lang["role_help"] = 'Help Pagina\'s weergeven';
$_lang["role_home"] = 'Verzoek om Content Management Systeem Intropagina';
$_lang["role_import_static"] = 'Importeer HTML';
$_lang["role_logout"] = 'Afmelden uit de beheerder';
$_lang["role_manage_metatags"] = 'Beheer \'META tags\' en keywords';
$_lang["role_management_msg"] = 'Hier kunt u kiezen welke Rol u wenst te wijzigen.';
$_lang["role_management_title"] = 'Rollen';
$_lang["role_messages"] = 'Berichten weergeven/versturen';
$_lang["role_module_management"] = 'Modulebeheer';
$_lang["role_name"] = 'Naam Rol';
$_lang["role_new_module"] = 'Nieuwe Module maken';
$_lang["role_new_role"] = 'Nieuwe Rollen maken';
$_lang["role_new_user"] = 'Nieuwe Gebruikers toevoegen';
$_lang["role_new_web_user"] = 'Webgebruikers toevoegen';
$_lang["role_plugin_management"] = 'Plug-inbeheer';
$_lang["role_publish_doc"] = 'Pagina\'s publiceren';
$_lang["role_role_management"] = 'Rollen';
$_lang["role_run_module"] = 'Module uitvoeren';
$_lang["role_save_chunk"] = 'Chunks opslaan';
$_lang["role_save_doc"] = 'Pagina\'s opslaan';
$_lang["role_save_module"] = 'Module opslaan';
$_lang["role_save_password"] = 'Wachtwoord opslaan';
$_lang["role_save_plugin"] = 'Plug-ins opslaan';
$_lang["role_save_role"] = 'Rollen opslaan';
$_lang["role_save_snippet"] = 'Snippets opslaan';
$_lang["role_save_template"] = 'Templates opslaan';
$_lang["role_save_user"] = 'Gebruikers opslaan';
$_lang["role_save_web_user"] = 'Webgebruikers opslaan';
$_lang["role_snippet_management"] = 'Snippetbeheer';
$_lang["role_template_management"] = 'Templatebeheer';
$_lang["role_title"] = 'Rol aanmaken/bewerken';
$_lang["role_udperms"] = 'Toegangsrechtenbeheer';
$_lang["role_user_management"] = 'Gebruikersbeheer';
$_lang["role_view_docdata"] = 'Paginagegevens weergeven';
$_lang["role_view_eventlog"] = 'Bekijk logboek (events)';
$_lang["role_view_logs"] = 'Systeemlogboek weergeven';
$_lang["role_view_unpublished"] = 'Bekijk niet gepubliceerde Pagina\'s';
$_lang["role_web_access_persmissions"] = 'Webtoegangsbeheer';
$_lang["role_web_user_management"] = 'Webgebruikersbeheer';
$_lang["rss_url_news_default"] = 'http://feeds.feedburner.com/modx-announce';
$_lang["rss_url_news_message"] = 'Geef hier de URL voor de MODx Nieuws Feed.';
$_lang["rss_url_news_title"] = 'RSS Nieuws Feed:';
$_lang["rss_url_security_default"] = 'http://feeds.feedburner.com/modxsecurity';
$_lang["rss_url_security_message"] = 'Geef hier de URL voor de MODx Beveiligings Feed.';
$_lang["rss_url_security_title"] = 'RSS Beveiligings Feed:';
$_lang["run_module"] = 'Module uitvoeren';
$_lang["saturday"] = 'Zaterdag';
$_lang["save"] = 'Opslaan';
$_lang["save_all_changes"] = 'Bewaar alle wijzigingen';
$_lang["save_tag"] = 'Tag opslaan';
$_lang["saving"] = 'Bezig met opslaan, een moment geduld a.u.b...';
$_lang["search"] = 'Zoeken';
$_lang["search_criteria"] = 'Zoekcriteria';
$_lang["search_criteria_content"] = 'Op inhoud zoeken';
$_lang["search_criteria_content_msg"] = 'Zoek alle Pagina\'s met de ingevoerde tekst in de inhoud.';
$_lang["search_criteria_id"] = 'Op ID zoeken';
$_lang["search_criteria_id_msg"] = 'Voer de ID van de Pagina in om de Pagina snel te vinden.';
$_lang["search_criteria_longtitle"] = 'Zoek op uitgebreide titel';
$_lang["search_criteria_longtitle_msg"] = 'Zoek alle Pagina\'s met de ingevoerde tekst in hun uitgebreide titel.';
$_lang["search_criteria_title"] = 'Op titel zoeken';
$_lang["search_criteria_title_msg"] = 'Zoek alle Pagina\'s met de ingevoerde tekst in hun titel.';
$_lang["search_empty"] = 'Uw zoekopdracht heeft geen resultaten opgeleverd. Verruim uw zoekcriteria en probeer het nogmaals.';
$_lang["search_item_deleted"] = 'Dit item is verwijderd';
$_lang["search_results"] = 'Zoekresultaten';
$_lang["search_results_returned_desc"] = 'Beschrijving';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Uw zoekcriteria hebben <b>%s</b> Pagina\'s opgeleverd. Als het teveel resultaten heeft opgeleverd, probeer dan een specifiekere zoekopdracht. Met de twee linker kolommen kunt u het bestand in de Website boomstructuur vinden of de Pagina bekijken. De twee meest rechtse kolommen geven aan of een Pagina verwijderd is en wat de publicatiestatus is.<p />';
$_lang["search_results_returned_title"] = 'Titel';
$_lang["search_view_docdata"] = 'Geef dit item weer';
$_lang["security"] = 'Beveiliging';
$_lang["security_notices_tab"] = 'Beveiligingswaarschuwingen';
$_lang["security_notices_title"] = 'Beveiligingswaarschuwingen';
$_lang["select_date"] = 'Selecteer een datum';
$_lang["send"] = 'Verzenden';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Geef hier aan of uw website gebruik maakt van een https verbinding.';
$_lang["server_protocol_title"] = 'Server type:';
$_lang["serveroffset"] = 'Server verschil';
$_lang["serveroffset_message"] = 'Selecteer hier het aantal uren tijdsverschil tussen uw huidige locatie en de servertijd. De huidige tijd op de server is <b>[%s]</b>, de huidige tijd op de server rekening houdend met het op dit moment opgeslagen tijdsverschil is <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Server tijdsverschil:';
$_lang["servertime"] = 'Server tijd';
$_lang["settings_after_install"] = 'Indien dit een nieuwe installatie betreft, moet u deze instellingen controleren en wijzigen waar nodig. Na controle klikt u op \'Opslaan\' om de wijzigingen in het bestand op te slaan.';
$_lang["settings_config"] = 'Configuratie';
$_lang["settings_dependencies"] = 'Afhankelijkheden';
$_lang["settings_events"] = 'Systeemgebeurtenissen';
$_lang["settings_furls"] = 'Zoekmachine vriendelijke URL\'s';
$_lang["settings_general"] = 'Algemeen';
$_lang["settings_misc"] = 'Overige';
$_lang["settings_page_settings"] = 'Pagina instellingen';
$_lang["settings_photo"] = 'Foto';
$_lang["settings_properties"] = 'Instellingen';
$_lang["settings_site"] = 'Website';
$_lang["settings_strip_image_paths_message"] = 'Als dit op \'Nee\' is gezet zal MODx de locaties van Afbeeldingen / Bestanden / Flash e.d. uit de bestandsbeheer browser omzetten naar absolute paden. Relatieve URL\'s zijn handig als u uw MODx installatie wilt verhuizen van bijvoorbeeld een test naar productie website. Als u geen idee heeft wat dit betekend laat u deze optie het beste op \'Ja\' staan.';
$_lang["settings_strip_image_paths_title"] = 'Bestandslokaties relatief:';
$_lang["settings_templvars"] = 'Template Variabelen';
$_lang["settings_title"] = 'Systeem configuratie';
$_lang["settings_ui"] = 'Interface &amp; mogelijkheden';
$_lang["settings_users"] = 'Gebruiker';
$_lang["show_tree"] = 'Website boomstructuur weergeven';
$_lang["showing"] = 'Weergeven';
$_lang["signupemail_message"] = 'Hier kunt u het bericht instellen die naar uw Gebruikers verstuurd wordt wanneer u voor hun een account heeft aangemaakt en MODx een e-mail laat sturen met hun Gebruikersnaam en wachtwoord. <br /><br /><b>NB:</b> De volgende codes worden door MODx vervangen als het bericht verstuurd wordt: <br /><br /> [+sname+] - Naam van uw website, <br />[+saddr+] - E-mail adres van uw website, <br />[+surl+] - Adres van de website, <br />[+uid+] - Gebruikersnaam of id, <br />[+pwd+] - Wachtwoord, <br />[+ufn+] - Volledige naam. <br /><br /><b>Laat de [+uid+] en [+pwd+] codes in de e-mail staan, omdat de Gebruikersnaam en het wachtwoord anders niet in de e-mail komen te staan en uw Gebruikers daardoor hun aanmeldgegevens niet ontvangen!</b>';
$_lang["signupemail_title"] = 'Registratie e-mail:';
$_lang["site"] = 'Website';
$_lang["site_schedule"] = 'Website planning';
$_lang["sitename_message"] = 'Vul hier de naam van uw website in.';
$_lang["sitename_title"] = 'Naam website:';
$_lang["sitestart_message"] = 'Vul hier de ID van de Pagina in dat u als startpagina wilt gebruiken. <br /><b>NB: Let op dat dit de ID van een bestaande Pagina is en het tevens gepubliceerd is!</b>';
$_lang["sitestart_title"] = 'Startpagina website:';
$_lang["sitestatus_message"] = 'Kies \'Online\' om uw website op het web te publiceren. Als u de optie \'Offline\' selecteerd, dan zullen uw bezoekers de \'Website niet beschikbaar\' bericht te zien krijgen. Ze kunnen uw website dan niet bekijken!';
$_lang["sitestatus_title"] = 'Website status:';
$_lang["siteunavailable_message"] = 'Dit bericht krijgen Gebruikers te zien als de website offline is of als er een fout mocht optreden. <b>NB: Dit bericht wordt enkel getoond indien de \'Website niet beschikbaar\'-pagina niet is ingesteld</b>.';
$_lang["siteunavailable_message_default"] = 'Deze website is momenteel niet beschikbaar.';
$_lang["siteunavailable_page_message"] = 'Geef de ID van de Pagina dat wordt weergegeven wanneer de website niet beschikbaar (offline) is. <b>NB: Let erop dat de ID bestaat en dat de Pagina gepubliceerd is!</b>';
$_lang["siteunavailable_page_title"] = 'Website niet beschikbaar Pagina:';
$_lang["siteunavailable_title"] = 'Website niet beschikbaar bericht:';
$_lang["snippet"] = 'Snippet';
$_lang["snippet_code"] = 'Snippet code (php)';
$_lang["snippet_desc"] = 'Beschrijving';
$_lang["snippet_execonsave"] = 'Snippet uitvoeren na opslaan.';
$_lang["snippet_management_msg"] = 'Hier kunt u Snippets toevoegen en bewerken.';
$_lang["snippet_msg"] = 'Snippet toevoegen of bewerken. LET OP, Snippets zijn \'ruwe\' PHP code, en als u verwacht dat de output van de Snippet op een specifiek punt binnen uw Template wordt getoond, dient u een waarde te retourneren binnen deze Snippet.';
$_lang["snippet_name"] = 'Naam Snippet';
$_lang["snippet_properties"] = 'Standaard instellingen';
$_lang["snippet_title"] = 'Maak/wijzig Snippet';
$_lang["sort_asc"] = 'Oplopend';
$_lang["sort_desc"] = 'Aflopend';
$_lang["sort_tree"] = 'Sorteer de Website boomstructuur';
$_lang["source"] = 'Bron';
$_lang["stay"] = 'Doorgaan met bewerken';
$_lang["stay_new"] = 'Nog &eacute;&eacute;n toevoegen';
$_lang["submit"] = 'Verzenden';
$_lang["sunday"] = 'Zondag';
$_lang["sys_alert"] = 'Systeem waarschuwing';
$_lang["sysinfo_activity_message"] = 'Deze lijst toont de Pagina\'s die recent door uw Gebruikers werden gewijzigd.';
$_lang["sysinfo_userid"] = 'Gebruiker';
$_lang["system_email_signup"] = "Hallo [+uid+]\n\nHier zijn uw inloggegevens voor [+sname+] Content Management Systeem ([+surl+]):\n\nGebruikersnaam: [+uid+]\nWachtwoord: [+pwd+]\n\nNadat u ingelogd bent in het Content Management Systeem, kunt u uw wachtwoord wijzigen.\n\nMet vriendelijke groet,\nUw Website Beheerder";
$_lang["system_email_webreminder"] = "Hallo [+uid+]\n\nOm uw wachtwoord te activeren klikt u op de volgende link:\n\n[+surl+]\n\nWanneer dit succesvol is kunt u met het volgende wachtwoord inloggen:\n\nWachtwoord:[+pwd+]\n\nWanneer u niet om deze mail gevraagd heeft kunt u deze e-mail verwijderen zonder aktie te ondernemen.\n\nMet vriendelijke groet,\nUw Website Beheerder";
$_lang["system_email_websignup"] = "Hallo [+uid+]\n\nHier zijn uw inloggegevens voor [+sname+] ([+surl+]):\n\nGebruikersnaam: [+uid+]\nWachtwoord: [+pwd+]\n\nNa dat u ingelogd bent in [+sname+], kunt u uw wachtwoord wijzigen.\nMet vriendelijke groet,\nUw Website Beheerder";
$_lang["table_hoverinfo"] = 'Beweeg de muiscursor over een tabelnaam om een korte beschrijving te zien van de funktie van de tabel (niet voor alle tabellen is <i>informatie</i> beschikbaar).';
$_lang["table_prefix"] = 'Tabel voorvoegsel (prefix)';
$_lang["tag"] = 'Tag';
$_lang["template"] = 'Template';
$_lang["template_assignedtv_tab"] = 'Toegekende Template Variabelen';
$_lang["template_code"] = 'Template code (html)';
$_lang["template_desc"] = 'Beschrijving';
$_lang["template_edit_tab"] = 'Wijzig Template';
$_lang["template_management_msg"] = 'Hier kunt u Templates toevoegen en bewerken.';
$_lang["template_msg"] = 'Template toevoegen of bewerken. Gewijzigde/nieuwe Templates zullen niet zichtbaar zijn in de gecachte Pagina\'s van uw website totdat de cache is leeggemaakt. U kunt echter de voorbeeldfunctie op een Pagina gebruiken om de Template te bekijken.';
$_lang["template_name"] = 'Naam Template';
$_lang["template_no_tv"] = 'Er zijn nog geen Template Variabelen aan deze Template toegewezen.';
$_lang["template_reset_all"] = 'Geef alle Pagina\'s het standaard Template';
$_lang["template_reset_specific"] = 'Geef alleen \'%s\' Pagina\'s het standaard Template:';
$_lang["template_title"] = 'Maak/wijzig Template';
$_lang["template_tv_edit"] = 'Wijzig de sorteervolgorde van de Template Variabelen';
$_lang["template_tv_edit_message"] = 'Versleep om de volgorde van de Template Variabelen van deze Template te veranderen.';
$_lang["template_tv_edit_title"] = 'Template Variabele volgorde';
$_lang["template_tv_msg"] = 'De aan deze Template toegewezen Template Variabelen staan hieronder vermeld.';
$_lang["thursday"] = 'Donderdag';
$_lang["tmplvar_access_msg"] = 'Selecteer de Paginagroepen die de inhoud van deze Template Variabele mogen aanpassen';
$_lang["tmplvar_change_template_msg"] = 'Door het aanpassen van deze Template zal deze Pagina de Template Variabelen opnieuw moeten inlezen. Alle niet opgeslagen veranderingen zullen verloren gaan.\n\n Weet u zeker dat u deze Template aan wilt passen?';
$_lang["tmplvar_inuse"] = 'De volgende Pagina\'s gebruiken deze Template Variabele. Om door te gaan met het verwijderen van de Template Variabele klik op de knop Verwijderen, anders klik op Annuleren.';
$_lang["tmplvar_tmpl_access"] = 'Template toegang';
$_lang["tmplvar_tmpl_access_msg"] = 'Selecteer de Templates die deze Template Variabele mogen gebruiken';
$_lang["tmplvars"] = 'Template Variabelen';
$_lang["tmplvars_binding_msg"] = 'Dit veld ondersteund datasource bindings met behulp van @ commandos';
$_lang["tmplvars_caption"] = 'Titel';
$_lang["tmplvars_default"] = 'Standaard waarde';
$_lang["tmplvars_description"] = 'Beschrijving';
$_lang["tmplvars_elements"] = 'Invoer optie waarden';
$_lang["tmplvars_management_msg"] = 'Beheer extra eigen content velden (Template Variabelen) voor uw Pagina\'s.';
$_lang["tmplvars_msg"] = 'Template Variabelen toevoegen of bewerken. De Template Variabelen moeten aan een Template toegekend worden om ze vanuit Snippets en Pagina\'s te kunnen benaderen net als andere content Variabelen.';
$_lang["tmplvars_name"] = 'Template Variabele naam';
$_lang["tmplvars_novars"] = 'Geen Template Variabelen gevonden.';
$_lang["tmplvars_rank"] = 'Sorteer volgorde';
$_lang["tmplvars_reset_params"] = 'Reset parameters';
$_lang["tmplvars_type"] = 'Invoer type';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Widget instellingen';
$_lang["to"] = 'naar';
$_lang["tools"] = 'Beheer';
$_lang["top_howmany_message"] = 'Wanneer u de statistieken bekijkt, hoe lang wilt u de \'Top ...\' lijst hebben?';
$_lang["top_howmany_title"] = 'Top \'hoeveel\':';
$_lang["total"] = 'totaal';
$_lang["track_visitors_message"] = 'Deze optie zorgt voor een aanhechtingspunt voor analytische Plug-ins (bezoekersstatistieken). Het kan worden gebruikt om te be&iuml;nvloeden of website bezoeken worden gelogd.';
$_lang["track_visitors_title"] = 'Bezoeken loggen:';
$_lang["tree_show_protected"] = 'Toon beschermde Pagina\'s:';
$_lang["tree_show_protected_message"] = 'Als dit op "Nee" staat, worden beschermde Pagina\'s en al hun afstammelingen niet getoond in de Website boomstructuur. "Nee" is de legacy (erfenis) instelling van MODx.';
$_lang["truncate_table"] = 'Klik hier om deze tabel in te korten';
$_lang["tuesday"] = 'Dinsdag';
$_lang["tv"] = 'TV';
$_lang["type"] = 'Soort';
$_lang["udperms_allowroot_message"] = 'Sta Gebruikers toe om nieuwe Pagina\'s en Mappen in de \'root\' (basismap) van de website te maken.';
$_lang["udperms_allowroot_title"] = 'Root (basismap) toestaan:';
$_lang["udperms_message"] = 'Be&iuml;nvloed toegangsrechten tot Pagina\'s via Gebruikersgroepen en Paginagroepen.';
$_lang["udperms_title"] = 'Toegangsrechten gebruiken:';
$_lang["unable_set_link"] = 'Niet mogelijk de link te maken!';
$_lang["unable_set_parent"] = 'Het Hoofdpagina kon niet worden aangemaakt!';
$_lang["unauthorizedpage_message"] = 'Voer een gepubliceerde en publiek toegankelijke Pagina ID in waarnaar Gebruikers worden doorgestuurd wanneer ze een beveiligde/ongeautoriseerde Pagina opvragen.';
$_lang["unauthorizedpage_title"] = 'Niet toegankelijk-pagina:';
$_lang["unblock_message"] = 'Deze Gebruiker zal niet geblokkeerd zijn na het opslaan van zijn Gebruikersgegevens.';
$_lang["undelete_resource"] = 'Herstel Pagina';
$_lang["unpublish_date"] = 'Niet-publiceren datum';
$_lang["unpublish_events"] = 'Niet-publiceren gebeurtenissen';
$_lang["unpublish_resource"] = 'Publicatie Pagina ongedaan maken';
$_lang["untitled_resource"] = 'Naamloze Pagina';
$_lang["untitled_weblink"] = 'Naamloze Weblink';
$_lang["update_params"] = 'Parameter weergave bijwerken';
$_lang["update_settings_from_language"] = 'Vervang huidige met:';
$_lang["upload_maxsize_message"] = 'Voer de maximale bestandsgrootte in voor bestanden die via Bestandsbeheer geupload kunnen worden. De bestandsgrootte wordt opgegeven in bytes. <br /><b>NB: Het kan enige tijd duren om grote bestanden te uploaden!</b>';
$_lang["upload_maxsize_title"] = 'Maximale bestandsgrootte:';
$_lang["uploadable_files_message"] = 'Hier kunt u een lijst van bestanden opgeven die geupload kunnen worden naar \'assets/files/\' vanuit Bestandsbeheer. Voer de bestandsextensies in, gescheiden door een komma. ';
$_lang["uploadable_files_title"] = 'Toegestane bestandstypes:';
$_lang["uploadable_flash_message"] = 'Hier kunt u een lijst van bestanden opgeven die geupload kunnen worden naar \'assets/flash/\' vanuit Bestandsbeheer. Voer de bestandsextensies in voor de Flash types, van elkaar gescheiden door een komma. ';
$_lang["uploadable_flash_title"] = 'Te uploaden Flash soorten:';
$_lang["uploadable_images_message"] = 'Hier kunt u een lijst van bestanden opgeven die ge-upload kunnen worden naar \'assets/images/\' vanuit Bestandsbeheer. Voer de bestandsextensies in voor de Afbeelding types, van elkaar gescheiden door een komma. ';
$_lang["uploadable_images_title"] = 'Te uploaden Afbeelding soorten:';
$_lang["uploadable_media_message"] = 'Hier kunt u een lijst van bestanden opgeven die ge-upload kunnen worden naar \'assets/media/\' vanuit Bestandsbeheer. Voer de bestandsextensies in voor de media types, van elkaar gescheiden door een komma. ';
$_lang["uploadable_media_title"] = 'Te uploaden Media soorten:';
$_lang["use_alias_path_message"] = 'Door \'Ja\' te selecteren wordt er een virtueel pad gegenereerd naar de Pagina. Bijvoorbeeld, als een Pagina "kind.html" in de Container "ouder" staat, dan wordt de volledige zoekmachine vriendelijke URL "/ouder/kind.html".';
$_lang["use_alias_path_title"] = 'Gebruik gebruiksvriendelijke alias paden:';
$_lang["use_editor_message"] = 'Bewerken met de geavanceerde teksteditor aanzetten. Deze setting geld voor alle Pagina\'s, maar kan worden overschreven in de instellingen van de Gebruiker.';
$_lang["use_editor_title"] = 'Teksteditor aanzetten:';
$_lang["user"] = 'Gebruiker';
$_lang["user_block"] = 'Geblokkeerd';
$_lang["user_blockedafter"] = 'Geblokkeerd na';
$_lang["user_blockeduntil"] = 'Geblokkeerd tot';
$_lang["user_changeddata"] = 'Uw gegevens zijn gewijzigd. A.u.b. opnieuw aanmelden.';
$_lang["user_country"] = 'Land';
$_lang["user_dob"] = 'Geboortedatum';
$_lang["user_doesnt_exist"] = 'Gebruiker bestaat niet';
$_lang["user_edit_self_msg"] = '<b>Wellicht dient u na het opslaan eerst af te melden en dan weer aan te melden om uw gegevens volledig te actualiseren.</b><br />Nieuwe wachtwoorden worden via e-mail toegezonden of op het scherm getoond.';
$_lang["user_email"] = 'E-mail adres';
$_lang["user_failedlogincount"] = 'Aantal mislukte aanmeldpogingen';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Vrouw';
$_lang["user_full_name"] = 'Volledige naam';
$_lang["user_gender"] = 'Geslacht';
$_lang["user_is_blocked"] = 'Deze Gebruiker is geblokkeerd!';
$_lang["user_logincount"] = 'Aantal keren aangemeld';
$_lang["user_male"] = 'Man';
$_lang["user_management_msg"] = 'Hier kunt u Gebruikers toevoegen en bewerken.';
$_lang["user_management_title"] = 'Gebruikers beheren';
$_lang["user_mobile"] = 'Mobiel telefoonnummer';
$_lang["user_phone"] = 'Telefoonnummer';
$_lang["user_photo"] = 'Pasfoto';
$_lang["user_photo_message"] = 'Voer een url voor de foto van deze Gebruiker in of gebruik de \'Invoegen\' knop om een foto te selecteren of te uploaden.';
$_lang["user_prevlogin"] = 'Laatste keer aangemeld';
$_lang["user_role"] = 'Rol';
$_lang["user_state"] = 'Provincie';
$_lang["user_title"] = 'Gebruiker toevoegen of bewerken';
$_lang["user_upload_message"] = 'Als u wilt voorkomen dat deze Gebruiker bestanden in deze categorie kan uploaden, Zorg dan dat \'Gebruik Systeem Configuratie Instellingen\' niet is aangevinkt en laat het veld leeg.';
$_lang["user_use_config"] = 'Gebruik Systeem Configuratie Instellingen';
$_lang["user_zip"] = 'Postcode';
$_lang["username"] = 'Gebruikersnaam';
$_lang["users"] = 'Beveiliging';
$_lang["validate_referer_message"] = 'Valideer de HTTP_REFERER headers om het risico te verkleinen dat uw website beheerders bedonderd worden door een CSRF (Cross Site Request Forgery) aanval. Soms is dit echter niet mogelijk als uw server geen HTTP_REFERER headers verzend.';
$_lang["validate_referer_title"] = 'Valideer HTTP_REFERER headers:';
$_lang["value"] = 'Waarde';
$_lang["version_codename"] = 'Versie codenaam';
$_lang["view"] = 'Bekijken';
$_lang["view_child_resources_in_container"] = 'Bekijk Subpagina\'s in Map';
$_lang["view_log"] = 'Bekijk logboek';
$_lang["view_logging"] = 'CMS logboek';
$_lang["view_sysinfo"] = 'Systeem Info';
$_lang["warning"] = 'Waarschuwing!';
$_lang["warning_not_saved"] = 'U heeft de wijzigingen nog niet opgeslagen! U kunt op deze Pagina blijven om de wijzigingen op te slaan (\'Annuleren\'), of u kunt deze Pagina verlaten, waardoor eventuele wijzigingen verloren gaan (\'OK\').';
$_lang["web_access_permissions"] = 'Webgebruiker toegangsrechten';
$_lang["web_access_permissions_user_groups"] = 'Webgebruikers groepen';
$_lang["web_permissions"] = 'Toegangsbeheer (web)';
$_lang["web_user_management_msg"] = 'Hier kunt u kiezen welke Webgebruiker u wilt bewerken. Webgebruikers zijn Gebruikers die alleen op de website kunnen aanmelden (en dus niet op het Content Management Systeem)';
$_lang["web_user_management_title"] = 'Webgebruikers';
$_lang["web_user_title"] = 'Aanmaken/bewerken Webgebruiker';
$_lang["web_users"] = 'Webgebruikers';
$_lang["weblink"] = 'Weblink';
$_lang["weblink_message"] = 'Een Weblink is een referentie aan een object op het internet. Het kan dus een link naar een Pagina in MODx zijn, of een Pagina/Afbeelding/ander soort bestand op een andere website op het internet.';
$_lang["webpwdreminder_message"] = 'Hier kunt u de boodschap instellen die naar uw Gebruikers verstuurd wordt als zij een nieuw wachtwoord aanvragen per e-mail. MODx zal een e-mail sturen met het nieuwe wachtwoord en activerings informatie.<br /><br /><b>NB:</b> De volgende codes worden door MODx vervangen als het bericht verstuurd wordt: <br /><br /> [+sname+] - Naam van uw website, <br />[+saddr+] - E-mail adres van uw website, <br />[+surl+] - Adres van de website, <br />[+uid+] - Aanmeld naam of id, <br />[+pwd+] - Wachtwoord, <br />[+ufn+] - Volledige naam. <br /><br /><b>Laat de [+uid+] en [+pwd+] codes in de e-mail staan, omdat de Gebruikersnaam en het wachtwoord anders niet in de e-mail komen te staan en uw Gebruikers daardoor hun aanmeldgevens niet ontvangen!</b>';
$_lang["webpwdreminder_title"] = 'Herinnerings e-mail:<br />(Webgebruiker)';
$_lang["websignupemail_message"] = 'Hier kunt u de boodschap instellen die naar uw Gebruikers verstuurd wordt wanneer u voor hen een webaccount heeft aangemaakt en MODx een e-mail laat sturen met hun Gebruikersnaam en wachtwoord. <br /><br /><b>NB:</b> De volgende codes worden door MODx vervangen als het bericht verstuurd wordt: <br /><br /> [+sname+] - Naam van uw website, <br />[+saddr+] - E-mail adres van uw website, <br />[+surl+] - Adres van de website, <br />[+uid+] - Aanmeld naam of id, <br />[+pwd+] - Wachtwoord, <br />[+ufn+] - Volledige naam. <br /><br /><b>Laat de [+uid+] en [+pwd+] codes in de e-mail staan, omdat de Gebruikersnaam en het wachtwoord anders niet in de e-mail komen te staan en uw Gebruikers daardoor hun aanmeldgegevens niet ontvangen!</b>';
$_lang["websignupemail_title"] = 'Bevestiging e-mail bij aanmelding:<br />(Webgebruiker)';
$_lang["wednesday"] = 'Woensdag';
$_lang["welcome_messages"] = 'In uw inbox staan <b>%d</b> bericht(en), waarvan <b>%s</b> ongelezen.';
$_lang["welcome_title"] = 'Welkom bij uw MODx Content Management Systeem';
$_lang["which_editor_message"] = 'Hier kiest u welke teksteditor u wenst te gebruiken. TinyMCE en FCKeditor werken goed maar zijn nog niet uitgebreid getest met MODx. Xihna (gabaseerd op HTMLArea) is minder geschikt voor strikte, op CCS gebaseerde ontwerpen, maar heeft meer functies.';
$_lang["which_editor_title"] = 'Kies uw teksteditor:';
$_lang["working"] = 'Wordt verwerkt...';
$_lang["wrap_lines"] = 'Regels afbreken';
$_lang["xhtml_urls_message"] = 'Vervangt ampersand (&amp;) tekens in urls die zijn gegenereerd door MODx met de validerende &amp;<!-- -->amp; html entiteit';
$_lang["xhtml_urls_title"] = 'XHTML URL\'s:';
$_lang["yes"] = 'Ja';
$_lang["you_got_mail"] = 'U heeft een nieuw bericht';
$_lang["yourinfo_message"] = 'In deze sectie wordt uw persoonlijke informatie weergegeven:';
$_lang["yourinfo_previous_login"] = 'De laatste keer dat u zich heeft aangemeld:';
$_lang["yourinfo_role"] = 'Uw Rol is:';
$_lang["yourinfo_title"] = 'Uw info';
$_lang["yourinfo_total_logins"] = 'Het totaal aantal keren dat u zich heeft aangemeld:';
$_lang["yourinfo_username"] = 'U bent aangemeld als:';
?>