<?php
/**
 * Filename: includes/lang/german.inc.php
 * Function: Language file.
 * Author: The MODx Project Team
 * Änderungen und Ergänzungen für MODx 0.9.5 Deutsch durch Rainer Bachmaier und Marc Hinse
 * Korrekturen und Ergänzungen für MODx 0.9.6.3 durch Bogdan Günther
 * Anpassungen für MODx 1.0 durch Bogdan Günther
 * Date: 2009/07/26
 * Version: 3.0
 * MODx version: 1.0
*/
$modx_lang_attribute = 'de'; // Manager HTML and XML Language Attribute
$modx_manager_charset = 'UTF-8';

$_lang["about_msg"] = 'MODx ist ein <a href="http://modxcms.com/what-is-modx.html" target="_blank">PHP-Framework und Content Management System</a> und unter der <a href="../assets/docs/license.txt">GNU-GPL-Lizenz</a> veröffentlicht.';
$_lang["about_title"] = 'Über MODx';
$_lang["access_permission_denied"] = 'Sie haben nicht die notwendige Zugriffsberechtigung für diese Ressource.';
$_lang["access_permission_parent_denied"] = 'Sie haben nicht die notwendige Zugriffsberechtigung, um eine Ressource an dieser Stelle zu erstellen oder hierher zu verschieben.';
$_lang["access_permissions"] = 'Zugriffsberechtigung';
$_lang["access_permissions_add_resource_group"] = 'Eine neue Ressourcen-Gruppe erstellen';
$_lang["access_permissions_add_user_group"] = 'Eine neue Benutzergruppe erstellen';
$_lang["access_permissions_docs_collision"] = 'Durch einen Konflikt zwischen Web-Benutzergruppen und Manager-Benutzergruppen für diese Rolle, ist diese Ressource öffentlich zugänglich. Kontaktieren Sie Ihren Seiten-Administrator für weitere Hilfe.';
$_lang["access_permissions_docs_message"] = 'Wählen Sie aus welchen Ressourcen-Gruppe diese Ressource zugeordnet ist';
$_lang["access_permissions_group_link"] = 'Einen neuen Gruppen-Link erstellen';
$_lang["access_permissions_introtext"] = 'Hier können Sie Benutzer- und Ressourcen-Gruppen für die Zugriffsberechtigung bearbeiten. Um einen Benutzer einer Benutzergruppe zuzuordnen, bearbeiten Sie den Benutzer und wählen die zugehörige(n) Gruppe(n). Um eine Ressource einer Benutzergruppe zuzuordnen, bearbeiten Sie die Ressource und wählen die zugehörige(n) Gruppe(n).';
$_lang["access_permissions_link_to_group"] = 'zur Ressourcen-Gruppe';
$_lang["access_permissions_link_user_group"] = 'Benutzergruppe verlinken';
$_lang["access_permissions_links"] = 'Benutzer- / Ressourcen-Gruppen-Links';
$_lang["access_permissions_links_tab"] = 'Hier legen Sie fest welche Benutzergruppen auf die Ressourcen-Gruppen Zugriffsrechte haben (z.B. Ressourcen bearbeiten oder anlegen). Um eine Ressourcen-Gruppe mit einer Benutzergruppe zu verknüpfen, wählen Sie die entsprechende Gruppe aus dem Dropdown-Menü und klicken anschließend auf „Absenden“. Um einen Link für eine bestimmte Gruppe zu entfernen, klicken Sie auf „Entfernen“. Die Verknüpfung wird sofort gelöscht.';
$_lang["access_permissions_no_resources_in_group"] = 'Keine.';
$_lang["access_permissions_no_users_in_group"] = 'Keine.';
$_lang["access_permissions_off"] = '<span class="warning">Zugriffsberechtigungen wurden nicht aktiviert.</span> Sämtliche Einstellungen, die Sie hier vornehmen bleiben wirkungslos, bis die Zugriffsberechtigungen wieder aktiviert werden.';
$_lang["access_permissions_resource_groups"] = 'Ressourcen-Gruppen';
$_lang["access_permissions_resources_in_group"] = '<b>Ressourcen in Gruppe:</b> ';
$_lang["access_permissions_resources_tab"] = 'Hier sehen Sie die angelegten Ressourcen-Gruppen. Sie können auch neue Gruppen anlegen, Gruppen umbenennen, Gruppen löschen und sehen welche Ressourcen in den unterschiedlichen Gruppen enthalten sind (den Namen der Ressource sehen Sie, in dem Sie mit der Maus über die ID fahren). Um eine Ressource zu einer Gruppe hinzuzufügen oder von einer Gruppe zu entfernen, ändern Sie die entsprechende Ressource direkt.';
$_lang["access_permissions_user_groups"] = 'Benutzergruppen';
$_lang["access_permissions_user_message"] = 'Hier können Sie auswählen welcher Benutzergruppe dieser Benutzer zugeordnet ist:';
$_lang["access_permissions_users_in_group"] = 'Benutzer in Gruppe:';
$_lang["access_permissions_users_tab"] = 'Hier sehen Sie die angelegten Benutzergruppen. Sie können auch neue Gruppen anlegen, Gruppen umbenennen, Gruppen löschen und die Zugehörigkeit der Benutzer zu Gruppen sehen. Um ein Benutzer zu einer Gruppe hinzuzufügen oder zu entfernen, bearbeiten Sie direkt den entsprechenden Benutzer. Administratoren (Benutzer mit der Rollen ID 1) haben immer Zugriff auf alle Ressourcen und müssen keiner speziellen Gruppen angehören.';
$_lang["account_email"] = 'E-Mail-Adresse';
$_lang["actioncomplete"] = '<b>Aktion war erfolgreich!</b><br />Bitte warten Sie, bis MODx sich neu aufgebaut hat.';
$_lang["activity_message"] = 'Diese Liste zeigt alle Ressourcen, die zuletzt bearbeitet oder erstellt wurden:';
$_lang["activity_title"] = 'Kürzlich bearbeitete oder erstellte Ressourcen';
$_lang["add"] = 'Hinzufügen';
$_lang["add_chunk"] = 'Chunk hinzufügen';
$_lang["add_doc"] = 'Ressource hinzufügen';
$_lang["add_folder"] = 'Ordner hinzufügen';
$_lang["add_plugin"] = 'Plugin hinzufügen';
$_lang["add_resource"] = 'Ressource hinzufügen';
$_lang["add_snippet"] = 'Snippet hinzufügen';
$_lang["add_tag"] = 'Tag hinzufügen';
$_lang["add_template"] = 'Template hinzufügen';
$_lang["add_tv"] = 'Template-Variable hinzufügen';
$_lang["add_weblink"] = 'Web-Link hinzufügen';
$_lang["administrator_role_message"] = 'Diese Rolle kann nicht gelöscht oder bearbeitet werden.';
$_lang["after_saving"] = 'Nach dem Speichern';
$_lang["alert_delete_self"] = 'Sie können sich nicht selber löschen!';
$_lang["alias"] = 'Alias';
$_lang["all_doc_groups"] = 'Alle Ressourcen-Gruppen (öffentlich)';
$_lang["all_events"] = 'Alle Ereignisse';
$_lang["all_usr_groups"] = 'Alle Benutzergruppen (öffentlich)';
$_lang["allow_mgr_access"] = 'Manager-Zugriff';
$_lang["allow_mgr_access_message"] = 'Wählen Sie diese Option, um den Zugriff auf den Manager aktivieren oder zu deaktivieren. <b>Hinweis:</b> Wenn diese Option gesetzt ist, wird der Benutzer zur Manager-Anmeldung oder auf die Startseite weitergeleitet.';
$_lang["already_deleted"] = 'wurde schon gelöscht.';
$_lang["attachment"] = 'Anhang';
$_lang["automatic_alias_message"] = 'Wählen Sie „ja“, damit das System beim Sichern automatisch einen eindeutigen Alias basierend auf den Seitentitel der Ressource vergibt.';
$_lang["automatic_alias_title"] = 'Automatisch erstellter Alias:';
$_lang["backup"] = 'Backup';
$_lang["bk_manager"] = 'Backup';
$_lang["block_message"] = 'Dieser Benutzer wird gesperrt sein, nachdem Sie die Benutzerdaten gespeichert haben!';
$_lang["blocked_minutes_message"] = 'Hier können Sie einstellen, wie viele Minuten ein Benutzer gesperrt wird, wenn er die maximale Anzahl von fehlgeschlagenen Anmeldeversuchen erreicht hat. Bitte geben Sie nur Zahlen ein, keine Kommas oder Leerstellen.';
$_lang["blocked_minutes_title"] = 'Sperrzeit in Minuten:';
$_lang["cache_files_deleted"] = 'Die folgenden Dateien wurden gelöscht:';
$_lang["cancel"] = 'Abbrechen';
$_lang["captcha_code"] = 'Sicherheits-Code';
$_lang["captcha_message"] = 'Aktivieren Sie Captcha-Validierung, um die Sicherheit zu erhöhen.';
$_lang["captcha_title"] = 'Captcha aktivieren:';
$_lang["captcha_words_default"] = 'MODx,Access,Better,BitCode,Chunk,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Oscope,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Tattoo,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote';
$_lang["captcha_words_message"] = 'Wenn Captcha aktiviert ist können Sie eine Liste von Captcha-Wörter eingeben. Trennen Sie die Wörter mit Kommas. Das Eingabe Feld ist mit 255 Zeichen beschränkt.';
$_lang["captcha_words_title"] = 'Captcha-Wörter';
$_lang["category_heading"] = 'Kategorie';
$_lang["category_msg"] = 'Hier können Sie alle Elemente nach Kategorien sortiert bearbeiten.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Name ändern';
$_lang["change_password"] = 'Passwort ändern';
$_lang["change_password_confirm"] = 'Passwort bestätigen';
$_lang["change_password_message"] = 'Bitte geben Sie Ihr neues Passwort ein und bestätigen Sie dieses durch erneute Eingabe. Das Passwort muss zwischen 6 und 15 Zeichen lang sein.';
$_lang["change_password_new"] = 'Neues Passwort';
$_lang["charset_message"] = 'Wählen Sie die Zeichenkodierung für die [(modx_charset)]-Systemvariable. Diese Einstellung beeinflusst nicht den Manager.';
$_lang["charset_title"] = 'Zeichenkodierung:';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Chunk-Code (HTML)';
$_lang["chunk_multiple_id"] = 'Fehler: Mehrere Chunks benutzen die selbe ID.';
$_lang["chunk_no_exist"] = 'Chunk existiert nicht.';
$_lang["cleaningup"] = 'Aufräumen';
$_lang["clear_log"] = 'Protokoll löschen';
$_lang["click_to_context"] = 'Klicken Sie hier, für das Kontextmenü';
$_lang["click_to_edit_title"] = 'Klicken Sie hier, um den Eintrag zu bearbeiten';
$_lang["click_to_view_details"] = 'Hier klicken, um die Details anzuzeigen';
$_lang["close"] = 'Schließen';
$_lang["collapse_tree"] = 'Baum einklappen';
$_lang["comment"] = 'Kommentar';
$_lang["configcheck_admin"] = 'Bitte kontaktieren Sie einen Systemadministrator und informieren Sie Ihn über diese Nachricht!';
$_lang["configcheck_cache"] = 'Das Cache-Verzeichnis ist nicht beschreibbar';
$_lang["configcheck_cache_msg"] = 'MODx kann das Cache-Verzeichnis nicht beschreiben. MODx wird wie erwartet funktionieren, das Caching ist jedoch deaktiviert. Um das Problem zu beheben, machen Sie das Verzeichnis „cache“ im Verzeichnis „assets“ beschreibbar.';
$_lang["configcheck_configinc"] = 'Die Konfigurationsdatei ist weiterhin beschreibbar';
$_lang["configcheck_configinc_msg"] = 'Böswillige Menschen könnten möglicherweise verheerende Schäden an Ihrer Website und allem was damit verbunden ist anrichten. <b>Wichtig:</b> Bitte ändern Sie die Zugriffsrechte der Konfigurationsdatei (/manager/includes/config.inc.php) auf nur-lesen!';
$_lang["configcheck_default_msg"] = 'Eine nicht spezifizierte Warnung wurde ermittelt, was seltsam ist.';
$_lang["configcheck_errorpage_unavailable"] = 'Die Fehlerseite Ihres Webauftrittes ist nicht verfügbar.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Ihre Fehlerseite ist für normale Besucher nicht abrufbar oder existiert nicht. Dies kann zu einer Endlosschleife und vielen Fehlermeldungen in Ihren Webserver-Statistiken führen. Stellen Sie sicher, dass der Seite keine Benutzergruppen zugeordnet sind.';
$_lang["configcheck_errorpage_unpublished"] = 'Die Fehlerseite Ihres Webauftrittes wurde nicht veröffentlicht oder noch nicht erstellt.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Ihre Fehlerseite ist der Allgemeinheit nicht zugänglich. Veröffentlichen Sie die Seite oder stellen Sie sicher, dass in der Konfiguration eine vorhandene Seite aus dem Ressourcen-Baum ausgewählt ist.';
$_lang["configcheck_images"] = 'Das Bilderverzeichnis ist nicht beschreibbar';
$_lang["configcheck_images_msg"] = 'Das Verzeichnis /images/ ist nicht beschreibbar. Die Funktionen des Bilder-Managers im Editor werden nicht funktionieren!';
$_lang["configcheck_installer"] = 'Installationsverzeichnis ist noch vorhanden';
$_lang["configcheck_installer_msg"] = 'Das Installationsverzeichnis enthält die Installationsroutinen von MODx. Um zu verhindern, dass eine nicht berechtigte Person die Installationsroutine möglicherweise nochmals starten kann, sollten Sie den Ordner /install jetzt vom Server löschen.';
$_lang["configcheck_lang_difference"] = 'Die Sprachdatei enthält eine falsche Anzahl an Einträgen';
$_lang["configcheck_lang_difference_msg"] = 'Die zur Zeit ausgewählte Sprache (Deutsch) enthält nicht die gleiche Anzahl an Einträgen wie die Standardsprache (Englisch). Dies stellt kein Problem für die Arbeit mit MODx dar, bedeutet jedoch, dass Sie die Sprachdatei aktualisieren sollten.';
$_lang["configcheck_notok"] = 'Eine oder mehrere Optionen der Konfiguration sind nicht in Ordnung: ';
$_lang["configcheck_ok"] = 'Überprüfung bestanden – keine Warnungen vorhanden.';
$_lang["configcheck_php_gdzip"] = 'PHP-Erweiterungen GD und / oder ZIP wurden nicht gefunden';
$_lang["configcheck_php_gdzip_msg"] = 'MODx benötigt die GD- und ZIP-PHP-Erweiterungen. MODx funktioniert zwar auch ohne diese Erweiterungen, aber Sie werden nicht das volle Potential des eingebauten Datei-Managers, Image-Editors oder Captchas für die Anmeldung ausschöpfen können.';
$_lang["configcheck_register_globals"] = 'register_globals ist in Ihrer php.ini Konfigurationsdatei auf ON gesetzt';
$_lang["configcheck_register_globals_msg"] = 'Diese Konfiguration macht Ihre Website wesentlich anfälliger für Cross-Site-Scripting-Attacken (XSS). Sie sollten Ihren Web-Hosting-Provider kontaktieren, um herauszufinden wie Sie diese Einstellung ändern können.';
$_lang["configcheck_title"] = 'Konfigurationsprüfung';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Die Seite für unautorisierte Zugriffe wurde nicht veröffentlicht oder existiert nicht.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Die Seite für unautorisierte Zugriffe ist für normale Besucher nicht abrufbar oder existiert nicht. Dies kann zu einer Endlosschleife und vielen Fehlermeldungen in Ihren Webserver-Statistiken führen. Stellen Sie sicher, dass der Seite keine Benutzergruppen zugeordnet sind.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'Die Seite für unautorisierte Zugriffe aus den Einstellungen Ihrer Konfiguration ist nicht veröffentlicht.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Die Seite unautorisierte Zugriffe ist der Allgemeinheit nicht zugänglich. Veröffentlichen Sie die Seite oder stellen Sie sicher, dass in der Konfiguration eine vorhandene Seite aus dem Ressourcen-Baum ausgewählt ist.';
$_lang["configcheck_warning"] = 'Konfigurationswarnung:';
$_lang["configcheck_what"] = 'Was bedeutet das?';
$_lang["confirm_block"] = 'Sind Sie sicher, dass Sie diesen Benutzer sperren wollen?';
$_lang["confirm_delete_eventlog"] = 'Wollen Sie das Ereignisprotokoll wirklich löschen?';
$_lang["confirm_delete_file"] = 'Sind Sie sicher, dass Sie diese Datei löschen wollen?\n\nDas könnte könnte dazu führen, dass Ihre Seite nicht mehr richtig funktioniert. Löschen Sie diese Datei nur, wenn Sie genau wissen was sie tun!';
$_lang["confirm_delete_htmlsnippet"] = 'Sind Sie sicher, dass Sie diesen Chunk löschen möchten?';
$_lang["confirm_delete_keywords"] = 'Sind Sie sicher dass Sie diese Schlüsselwörter löschen wollen?';
$_lang["confirm_delete_module"] = 'Sind Sie sicher, dass Sie dieses Modul löschen möchten?';
$_lang["confirm_delete_plugin"] = 'Sind Sie sicher, dass Sie dieses Plugin löschen möchten?';
$_lang["confirm_delete_record"] = 'Sind Sie sicher, dass Sie die ausgewählten Einträge löschen möchten?';
$_lang["confirm_delete_resource"] = 'Sind Sie sicher, das Sie diese Ressource löschen möchten?\nAlle Unter-Ressourcen werden ebenfalls gelöscht.';
$_lang["confirm_delete_role"] = 'Sind Sie sicher, dass Sie diese Rolle löschen möchten?';
$_lang["confirm_delete_snippet"] = 'Sind Sie sicher, das Sie dieses Snippet löschen möchten?';
$_lang["confirm_delete_tags"] = 'Sind Sie sicher, dass Sie die ausgewählten Meta-Tags löschen möchten?';
$_lang["confirm_delete_template"] = 'Sind Sie sicher, dass Sie dieses Template löschen möchten?';
$_lang["confirm_delete_tmplvars"] = 'Sind Sie sicher, dass Sie diese Variable inklusive der gespeicherten Inhalte löschen möchten?';
$_lang["confirm_delete_user"] = 'Sind Sie sicher, dass Sie diesen Benutzer löschen möchten?';
$_lang["confirm_duplicate_record"] = 'Sind Sie sicher, dass Sie diesen Eintrag duplizieren möchten?';
$_lang["confirm_empty_trash"] = 'Beim leeren des Mülleimers werden alle gelöschten Ressourcen dauerhaft entfernt.\n\nFortfahren?';
$_lang["confirm_load_depends"] = 'Sind Sie sicher, dass Sie das „Abhängigkeiten-verwalten“-Fenster öffnen wollen ohne Ihre Anpassungen zu sichern?';
$_lang["confirm_name_change"] = 'Die Änderung des Benutzernamens kann möglicherweise Auswirkungen auf die Funktion von Anwendungen Dritter haben, die Daten von MODx verwenden.\n\nSind Sie sicher, dass Sie den Benutzernamen ändern wollen?';
$_lang["confirm_publish"] = '\n\nDie Veröffentlichung der Ressource löscht alle Veröffentlichungsdaten die eventuell gesetzt wurden. Wenn Sie die Daten beibehalten möchten, wählen Sie stattdessen „Ressource bearbeiten“.\n\nFortfahren?';
$_lang["confirm_remove_locks"] = 'Manchmal schließen Benutzer ihren Browser während sie Ressourcen oder Elemente bearbeiten. Dabei bleiben diese dann in einem gesperrten Zustand. Wenn Sie OK klicken werden alle Sperren entfernt.\n\nFortfahren?';
$_lang["confirm_resource_duplicate"] = 'Sind Sie sicher, dass Sie diese Ressource duplizieren möchten?\nAlle enthaltenen Unter-Ressourcen werden ebenfalls dupliziert.';
$_lang["confirm_setting_language_change"] = 'Sie haben den Standardwert verändert, Änderungen werden nicht gesichert. Fortfahren?';
$_lang["confirm_unblock"] = 'Sind Sie sicher, dass Sie diesen Benutzer freischalten möchten?';
$_lang["confirm_undelete"] = '\n\nAlle gelöschten Ressourcen werden wieder hergestellt. Ressourcen die vorher aus dem Papierkorb entfernt wurden, werden nicht wiederhergestellt.';
$_lang["confirm_unpublish"] = '\n\nDas Zurückziehen der Ressource entfernt alle Veröffentlichungsdaten. Wenn Sie die Daten beibehalten möchten, wählen Sie „Ressource bearbeiten“.\n\nFortfahren?';
$_lang["confirm_unzip_file"] = 'Sind Sie sicher, dass Sie diese Datei entpacken möchten?\n\nBestehende Dateien werden überschrieben.';
$_lang["could_not_find_user"] = 'Benutzer konnte nicht gefunden werden.';
$_lang["create_folder_here"] = 'Container hier erstellen';
$_lang["create_resource_here"] = 'Ressource hier erstellen';
$_lang["create_resource_title"] = 'Ressource erstellen';
$_lang["create_weblink_here"] = 'Web-Link hier erstellen';
$_lang["createdon"] = 'Erstellungsdatum';
$_lang["credits"] = 'Danksagungen';
$_lang["credits_shouts_msg"] = '<p>Informationen zum MODx-Team und zur Geschichte und Weiterentwicklung von MODx finden Sie unter: <a href="http://modxcms.com/about/" target="_blank">modxcms.com/about/</a>.</p>';
$_lang["custom_contenttype_message"] = 'Hier können Sie eigene Inhalts-Typen hinzufügen. Geben Sie hierzu den Typ ein und klicken dann auf hinzufügen.';
$_lang["custom_contenttype_title"] = 'Eigene Inhaltstypen:';
$_lang["database_charset"] = 'Datenbank-Zeichensatz';
$_lang["database_collation"] = 'Datenbank-Kollations-Zeichensatz';
$_lang["database_name"] = 'Datenbank-Name';
$_lang["database_overhead"] = '<b>Hinweis:</b> Der Overhead ist von MySQL reservierter Speicher, der nicht verwendet wird. Sie können diesen Speicher freigeben, indem Sie auf die Overhead-Angabe der jeweiligen Tabelle klicken.';
$_lang["database_server"] = 'Datenbank-Server';
$_lang["database_table_clickbackup"] = 'um ein Backup zu erstellen und die ausgewählten Tabellen herunter zu laden';
$_lang["database_table_clickhere"] = 'Hier klicken';
$_lang["database_table_datasize"] = 'Datenmenge';
$_lang["database_table_droptablestatements"] = 'Erzeuge DROP TABLE Anweisungen.';
$_lang["database_table_effectivesize"] = 'Effektive Größe';
$_lang["database_table_indexsize"] = 'Index-Größe';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Datensätze';
$_lang["database_table_tablename"] = 'Tabellenname';
$_lang["database_table_totals"] = 'Summen:';
$_lang["database_table_totalsize"] = 'Gesamtgröße';
$_lang["database_tables"] = 'Datenbank-Tabellen';
$_lang["database_version"] = 'Datenbank-Version:';
$_lang["date"] = 'Datum';
$_lang["datechanged"] = 'Änderungsdatum';
$_lang["datepicker_offset"] = 'Zeitspanne Datumswähler: ';
$_lang["datepicker_offset_message"] = 'Die Anzahl der vergangenen Jahre die der Datumswähler anzeigen soll.';
$_lang["datetime_format"] = 'Datumsformat:';
$_lang["datetime_format_message"] = 'Das Format für Datumsangaben im Manager.';
$_lang["default"] = 'Default:';
$_lang["defaultcache_message"] = 'Wählen Sie „Ja“, um alle neuen Ressourcen voreingestellt als cachebar anzulegen.';
$_lang["defaultcache_title"] = 'Voreinstellung Cache';
$_lang["defaultmenuindex_message"] = 'Wählen Sie „Ja“, um den Menüindex bei neuen Ressourcen automatisch zu erhöhen.';
$_lang["defaultmenuindex_title"] = 'Voreinstellung Menüindex-Inkrementierung';
$_lang["defaultpublish_message"] = 'Wählen Sie „Ja“, um alle neuen Ressourcen voreingestellt als veröffentlicht anzulegen.';
$_lang["defaultpublish_title"] = 'Voreinstellung Veröffentlichung';
$_lang["defaultsearch_message"] = 'Wählen Sie „Ja“, um alle neuen Ressourcen voreingestellt als durchsuchbar anzulegen.';
$_lang["defaultsearch_title"] = 'Voreinstellung Durchsuchbar';
$_lang["defaulttemplate_message"] = 'Wählen Sie das Standard-Template das Sie für neue Ressourcen verwenden möchten. Sie können auch andere Templates im Ressourcen-Editor auswählen, diese Einstellung betrefft nur die Standardeinstellung.';
$_lang["defaulttemplate_title"] = 'Standard-Template';
$_lang["delete"] = 'Löschen';
$_lang["delete_resource"] = 'Ressource Löschen';
$_lang["delete_tags"] = 'Tag löschen';
$_lang["deleting_file"] = 'Löschen der Datei „%s“: ';
$_lang["description"] = 'Beschreibung';
$_lang["deselect_keywords"] = 'Keyword-Auswahl aufheben';
$_lang["deselect_metatags"] = 'Metatag-Auswahl aufheben';
$_lang["disabled"] = 'Deaktiviert';
$_lang["doc_data_title"] = 'Daten der Ressource anzeigen';
$_lang["duplicate"] = 'Duplizieren';
$_lang["duplicate_alias_found"] = 'Die Ressource „%s“ verwendet bereits den Alias „%s“. Bitte geben Sie einen eindeutigen Alias ein.';
$_lang["duplicate_alias_message"] = 'Wählen Sie „ja“, um zweideutige Alias-Namen zu erlauben. <b>Hinweis:</b> Diese Option sollte zusammen mit der Option „Benutzerfreundliche URLs“ verwendet werden, um etwaige Probleme bei der Ressourcen-Referenzierung zu vermeiden.';
$_lang["duplicate_alias_title"] = 'Doppelte Aliase zulassen:';
$_lang["duplicate_name_found_general"] = 'Es existiert bereits ein %s mit dem Namen „%s“. Bitte geben Sie einen eindeutigen Namen ein.';
$_lang["duplicate_name_found_module"] = 'Es existiert bereits ein Modul mit dem Namen „%s“. Bitte geben Sie einen eindeutigen Namen ein.';
$_lang["edit"] = 'Bearbeiten';
$_lang["edit_resource"] = 'Ressource Bearbeiten';
$_lang["edit_resource_title"] = 'Ressource erstellen/bearbeiten';
$_lang["edit_settings"] = 'Konfiguration';
$_lang["editedon"] = 'Änderungsdatum';
$_lang["editing_file"] = 'zu ändernde Datei: ';
$_lang["editor_css_path_message"] = 'Geben Sie hier den Pfad zur CSS-Datei an, die Sie im Editor verwenden möchten. Falls Sie keine CSS-Datei verwenden möchten, lassen Sie das Feld leer.';
$_lang["editor_css_path_title"] = 'Pfad zur CSS-Datei:';
$_lang["element"] = 'Element';
$_lang["element_categories"] = 'Alle Elemente';
$_lang["element_management"] = 'Elemente-Verwaltung';
$_lang["element_name"] = 'Element-Namen';
$_lang["element_selector_msg"] = 'Wählen Sie die entsprechenden Elemente aus und klicken anschließend auf „einfügen“.';
$_lang["element_selector_title"] = 'Elemente-Auswahl';
$_lang["elements"] = 'Elemente';
$_lang["email"] = 'E-Mail';
$_lang["email_sent"] = 'E-Mail erfolgreich gesendet.';
$_lang["emailsender_message"] = 'Hier können Sie die E-Mail-Adresse angeben, die als Absendeadresse genutzt wird.';
$_lang["emailsender_title"] = 'E-Mail-Adresse:';
$_lang["emailsubject_default"] = 'Ihre Anmeldedaten';
$_lang["emailsubject_message"] = 'Hier können Sie den Inhalt des Betreffs eingeben.';
$_lang["emailsubject_title"] = 'E-Mail-Betreff:';
$_lang["empty_folder"] = 'Dieser Container ist leer';
$_lang["empty_recycle_bin"] = 'Papierkorb leeren';
$_lang["empty_recycle_bin_empty"] = 'Es sind keine gelöschten Ressourcen zum Entfernen vorhanden.';
$_lang["enable_resource"] = 'Element-Datei aktivieren.';
$_lang["enable_sharedparams"] = 'Gemeinsame Parameter aktivieren';
$_lang["enable_sharedparams_msg"] = '<b>Hinweis:</b> Diese eindeutige Identifikationsnummer (GUID) wird dazu benutzt, um das Modul eindeutig zu identifizieren und entsprechende Verknüpfungen zwischen Modulen und Plugins, Snippets und gemeinsamen Parametern zu gewährleisten. ';
$_lang["enabled"] = 'Aktiviert';
$_lang["error"] = 'Fehler';
$_lang["error_sending_email"] = 'E-Mail konnte nicht gesendet werden';
$_lang["errorpage_message"] = 'Geben Sie die ID der Ressource ein, welche aufgerufen wird, wenn eine Seite angefordert wird die nicht vorhanden ist. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist!';
$_lang["errorpage_title"] = 'Fehlerseite:';
$_lang["event_id"] = 'Ereignis-ID';
$_lang["eventlog"] = 'Systemereignisprotokoll';
$_lang["eventlog_msg"] = 'Informations-, Warn- und Fehlermeldungen des MODx-Managers werden im Systemereignisprotokoll gespeichert. Unter „Quelle“ ist das jeweils verursachende Modul angegeben.';
$_lang["eventlog_viewer"] = 'Systemereignisse';
$_lang["existing_category"] = 'Bestehende Kategorie';
$_lang["expand_tree"] = 'Baum aufklappen';
$_lang["export_site"] = 'Seite exportieren';
$_lang["export_site_cacheable"] = 'Inklusive nicht gecachter Dateien:';
$_lang["export_site_exporting_document"] = 'Exportiere <b>%s</b> von <b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = 'Fehlgeschlagen!';
$_lang["export_site_failed_no_open"] = 'Datei kann nicht geöffnet werden: ';
$_lang["export_site_failed_no_retrieve"] = 'Dokument kann nicht aufgerufen werden.';
$_lang["export_site_failed_no_write"] = 'Datei kann nicht geschrieben werden.';
$_lang["export_site_html"] = 'Seite nach HTML exportieren';
$_lang["export_site_maxtime"] = 'Maximale Export-Zeit:';
$_lang["export_site_maxtime_message"] = 'Hier können Sie festlegen wie lange MODx brauchen darf, um die Site zu exportieren (überschreibt die PHP-Voreinstellungen). 0 für unbegrenzt. <b>Achtung:</b> 0 ist eine sehr hohe Einstellung und kann die Performance Ihres Servers beeinflussen.';
$_lang["export_site_message"] = '<p>Diese Funktion exportiert die gesamte Seite in HTML-Dateien. Allerdings verlieren Sie viel von der gesamten MODx-Funktionalität:</p> <ul><li>Seitenzugriffe auf der exportierten Site werden nicht aufgezeichnet</li><li>Interaktive Snippets arbeiten nicht in der exportierten Site</li><li>Nur reguläre Ressourcen werden exportiert – Links werden nicht exportiert.</li><li>Der Exportprozess könnte abbrechen wenn Snippets enthalten sind die eine Header-Weiterleitung vornehmen</li><li>Abhängig davon wie Sie Ihre Ressourcen, Style Sheets und Bilder verknüpft haben, könnte das Design zerstört werden. Um dieses Problem zu lösen können Sie die exportierten Dateien in das gleiche Verzeichnis kopieren, in dem die Datei index.php liegt.</li></ul><p>Bitte füllen Sie das Formular aus und klicken auf „Export“ um den Export zu starten. Die Dateien werden am angegebenen Ort gespeichert. Es werden wenn möglich die Alias-Namen als Dateinamen verwendet. Während des Exports der Seite ist es ratsam die Einstellung „Benutzerfreundliche URLs“ auf „Ja“ zu setzen. Je nach Größe der Seite wird der Export eine Weile dauern.</p><p><b>Wichtig:</b> Bestehende Dateien werden bei Namensgleichheit überschrieben!</p>';
$_lang["export_site_numberdocs"] = '<p><b>%s Ressourcen für den Export gefunden.</b></p>';
$_lang["export_site_prefix"] = 'Datei-Präfix:';
$_lang["export_site_start"] = 'Export starten';
$_lang["export_site_success"] = 'Erfolgreich!';
$_lang["export_site_success_skip_dir"] = 'Dieses Verzeichnis überspringen.';
$_lang["export_site_success_skip_doc"] = 'Dieses Dokument überspringen.';
$_lang["export_site_suffix"] = 'Datei-Suffix:';
$_lang["export_site_target_unwritable"] = 'Datei kann nicht gespeichert werden – Überprüfen Sie den Schreibzugriff im Zielverzeichnis und versuchen Sie es erneut!';
$_lang["export_site_time"] = 'Export beendet. Dauer für den Export %s Sekunden';
$_lang["failed_login_message"] = 'Hier können Sie die Anzahl fehlgeschlagener Anmeldeversuche einstellen, die erlaubt sind bevor ein Benutzer gesperrt wird.';
$_lang["failed_login_title"] = 'Fehlgeschlagene Anmeldeversuche:';
$_lang["fe_editor_lang_message"] = 'Wählen Sie die Sprache, die für den Frontend-Editor verwendet werden soll.';
$_lang["fe_editor_lang_title"] = 'Sprache des Frontend-Editors:';
$_lang["file_delete_file"] = 'Datei löschen';
$_lang["file_delete_folder"] = 'Ordner löschen';
$_lang["file_deleted"] = 'Erfolgreich!';
$_lang["file_download_file"] = 'Datei-Download';
$_lang["file_download_unzip"] = 'Datei entpacken';
$_lang["file_folder_chmod_error"] = 'Die Rechte können nicht verändert werden. Sie müssen die Rechte außerhalb von MODx ändern.';
$_lang["file_folder_created"] = 'Ordnererstellung erfolgreich!';
$_lang["file_folder_deleted"] = 'Ordner erfolgreich gelöscht!';
$_lang["file_folder_not_created"] = 'Ordnererstellung nicht möglich';
$_lang["file_folder_not_deleted"] = 'Ordner kann nicht gelöscht werden. Stellen Sie sicher, dass der Ordner leer ist.';
$_lang["file_not_deleted"] = 'Nicht erfolgreich!';
$_lang["file_not_saved"] = 'Datei kann nicht gespeichert werden. Überprüfen Sie den Schreibzugriff im Zielverzeichnis!';
$_lang["file_saved"] = 'Datei erfolgreich aktualisiert!';
$_lang["file_unzip"] = 'Unzip erfolgreich!';
$_lang["file_unzip_fail"] = 'Unzip fehlgeschlagen!';
$_lang["filemanager_path_message"] = 'Unter Umständen erkennt Ihr Webserver (z.B. IIS) den Pfad nicht immer korrekt, überprüfen Sie deshalb diese Einstellung.';
$_lang["filemanager_path_title"] = 'Datei-Manager-Pfad:';
$_lang["files_access_denied"] = 'Zugriff verweigert!';
$_lang["files_data"] = 'Größe';
$_lang["files_dir_listing"] = 'Verzeichnisübersicht für:';
$_lang["files_directories"] = 'Verzeichnisse';
$_lang["files_dirwritable"] = 'Verzeichnis beschreibbar?';
$_lang["files_editfile"] = 'Datei bearbeiten';
$_lang["files_file_type"] = 'Dateityp: ';
$_lang["files_filename"] = 'Dateiname';
$_lang["files_fileoptions"] = 'Optionen';
$_lang["files_files"] = 'Dateien';
$_lang["files_filesize"] = 'Dateigröße';
$_lang["files_filetype_notok"] = 'Das Hochladen einer Datei von diesem Typ ist nicht erlaubt!';
$_lang["files_modified"] = 'Datum';
$_lang["files_top_level"] = 'Zum Hauptverzeichnis';
$_lang["files_up_level"] = 'Ein Verzeichnis nach oben wechseln';
$_lang["files_upload_copyfailed"] = 'Upload fehlgeschlagen. Das Kopieren der Datei in den Zielordner ist nicht möglich!';
$_lang["files_upload_error"] = 'Fehler';
$_lang["files_upload_error0"] = 'Ein Problem beim Upload ist aufgetreten.';
$_lang["files_upload_error1"] = 'Die Datei ist für einen Upload zu groß.';
$_lang["files_upload_error2"] = 'Die Datei ist für einen Upload zu groß.';
$_lang["files_upload_error3"] = 'Die Datei wurde nur teilweise übertragen.';
$_lang["files_upload_error4"] = 'Sie müssen eine Datei für den Upload auswählen.';
$_lang["files_upload_error5"] = 'Beim Upload ist ein Problem aufgetreten.';
$_lang["files_upload_inhibited_msg"] = '<b>Datei-Upload fehlgeschlagen.</b> Stellen Sie sicher, dass der Upload unterstützt wird und PHP in dieses Verzeichnis schreiben darf.';
$_lang["files_upload_ok"] = 'Upload erfolgreich!';
$_lang["files_upload_permissions_error"] = 'Mögliche Probleme mit den Zugriffsrechten: das Upload-Verzeichnis muss auf dem Web-Server beschreibbar sein.';
$_lang["files_uploadfile"] = 'Datei hochladen';
$_lang["files_uploadfile_msg"] = 'Datei zum Hochladen wählen:';
$_lang["files_uploading"] = 'Upload <b>%s</b> in Verzeichnis <b>%s/</b>';
$_lang["files_viewfile"] = 'Datei anzeigen';
$_lang["folder"] = 'Ordner';
$_lang["forgot_password_email_fine_print"] = '* Die oben angegebene URL verliert nach Änderung Ihres Kennworts oder spätestens nach einem Tag ihre Gültigkeit.';
$_lang["forgot_password_email_instructions"] = 'Anschließend können Sie Ihr Kennwort im Benutzermenü der Zugangsverwaltung ändern.';
$_lang["forgot_password_email_intro"] = 'Es wurde ein neues Kennwort für Ihren Zugang angefordert.';
$_lang["forgot_password_email_link"] = 'Klicken Sie hier, um ein neues Kennwort zu erstellen.';
$_lang["forgot_your_password"] = 'Kennwort vergessen?';
$_lang["friday"] = 'Freitag';
$_lang["friendly_alias_message"] = 'Wenn Sie benutzerfreundliche URLs verwenden, und die Ressource einen Alias-Eintrag hat, wird das Alias als benutzerfreundliche URL verwendet.  Falls Sie keine benutzerfreundliche URLs verwenden verwenden, generiert MODx den Link mit einer durchlaufenden Nummerierung.';
$_lang["friendly_alias_title"] = 'Aliasnamen:';
$_lang["friendlyurls_message"] = 'Diese Option erlaubt Ihnen die Benutzung benutzerfreundlicher URLs auf Apache-Webservern mit aktiviertem mod_rewrite oder auf dem IIS-Webserver mit entsprechenden Modulen. Öffnen sie bei MODx enthaltene .htaccess-Datei im Root-Verzeichnis für mehr Informationen.';
$_lang["friendlyurls_title"] = 'Benutzerfreundliche URLs nutzen:';
$_lang["friendlyurlsprefix_message"] = 'Hier können Sie ein Präfix für die benutzerfreundlichen URLs angeben. Wenn Sie z.B. „page“ als Präfix angeben, wird die URL /index.php?id=2 in /page2.html umgewandelt (vorausgesetzt das Suffix wurde auf .html gesetzt).';
$_lang["friendlyurlsprefix_title"] = 'Präfix für benutzerfreundliche URLs:';
$_lang["friendlyurlsuffix_message"] = 'Hier können Sie ein Suffix angeben.';
$_lang["friendlyurlsuffix_title"] = 'Suffix für benutzerfreundliche URLs:';
$_lang["functionnotimpl"] = 'Sorry!';
$_lang["functionnotimpl_message"] = 'Diese Funktion ist noch nicht implementiert';
$_lang["go"] = 'Los';
$_lang["group_access_permissions"] = 'Benutzergruppenberechtigungen';
$_lang["guid"] = 'Eindeutige Identifikationsnummer (GUID)';
$_lang["help"] = 'Hilfe';
$_lang["help_msg"] = 'Wenn Sie Hilfe bei der Nutzung von MODx benötigen besuchen Sie am besten das deutsche <a href="http://modxcms.de/forum/" target="_blank">MODx-Forum</a>. Falls Sie dort keine Lösung zu Ihrem Problem oder Ihrer Frage finden, stellen Sie Ihre Frage in dem entsprechendem Unterforum. Das Team wird versuchen Ihre Frage so schnell wie möglich zu beantworten.';
$_lang["help_title"] = 'Hilfe';
$_lang["hide_tree"] = 'Baum verbergern';
$_lang["home"] = 'Start';
$_lang["htmlsnippet_desc"] = 'Chunk-Beschreibung';
$_lang["htmlsnippet_management_msg"] = 'Hier können Sie das zu bearbeitende Chunk auswählen';
$_lang["htmlsnippet_msg"] = 'Hier können Sie Chunks hinzufügen oder bearbeiten. Achtung, Chunks bestehen aus reinem HTML-Code – PHP-Code wird nicht verarbeitet.';
$_lang["htmlsnippet_name"] = 'Chunk-Name';
$_lang["htmlsnippet_title"] = 'Chunk erstellen/bearbeiten ';
$_lang["icon"] = 'Symbol';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Container-Zuweisung:\n\nDie Ressource ist dem gewählten Container zugehörig.';
$_lang["illegal_parent_self"] = 'Container-Zuweisung:\n\nDie Ressource kann nicht sich selbst zugewiesen werden.';
$_lang["import_files_found"] = '<b>%s Ressourcen für den Import gefunden …</b><p />';
$_lang["import_params"] = 'Importieren von gemeinsamen Parametern';
$_lang["import_params_msg"] = 'Sie können die Parameter und Einstellungen mittels obiger Auswahlliste importieren. <b>Hinweis:</b> Damit Module in dieser Liste erscheinen, muss das jeweilige Plugin/Snippet in der Abhängigkeitsliste des Moduls stehen und das Modul muss die Option „Gemeinsame Parameter“ aktiviert haben. ';
$_lang["import_parent_resource"] = 'Container:';
$_lang["import_site"] = 'Seite importieren';
$_lang["import_site_failed"] = 'Fehler!';
$_lang["import_site_failed_db_error"] = 'Ein Datenbank-Fehler ist aufgetreten beim Versuch das Dokument zu kopieren: ';
$_lang["import_site_failed_no_open_dir"] = 'Das Verzeichnis konnte nicht geöffnet werden: ';
$_lang["import_site_failed_no_retrieve_file"] = 'Die Datei konnte nicht geöffnet werden: ';
$_lang["import_site_html"] = 'Website aus HTML-Dateien importieren';
$_lang["import_site_importing_document"] = 'Importiere Datei <b>%s</b> ';
$_lang["import_site_maxtime"] = 'Maximale Importdauer:';
$_lang["import_site_maxtime_message"] = 'Hier können Sie die Dauer (in Sekunden) angeben, die das System für einen Import maximal benötigen darf. Nach Ablauf dieser Zeit wird der Import abgebrochen. Von der Angabe von 0 Sekunden oder einen extrem hohen Zeitspanne wird dringend abgeraten, da dies zu Komplikationen mit Ihrem Webserver führen kann.';
$_lang["import_site_message"] = '<p>Mit dieser Importfunktion können Sie eine bestehende Website im HTML-Format in das MODx-System importieren. Die zu importierenden HTML-Dateien bzw. Verzeichnisse müssen unter „assets/import“ abgelegt werden.</p><p>Nach dem ausfüllen des unten stehenden Formulars können Sie den Import starten. Die importierten Daten werden im ausgewählten Ort gesichert. Soweit möglich, werden Dateinamen als Ressourcen-Titel und der HTML-Titel als Seitentitel verwendet.</p>';
$_lang["import_site_skip"] = 'ausgelassen';
$_lang["import_site_start"] = 'Import starten';
$_lang["import_site_success"] = 'OK';
$_lang["import_site_time"] = 'Import in %s Sekunden durchgeführt.';
$_lang["inbox"] = 'Inbox';
$_lang["info"] = 'Info';
$_lang["information"] = 'Information';
$_lang["inline"] = 'Browser-Fenster';
$_lang["insert"] = 'Einfügen';
$_lang["keyword"] = 'Schlüsselwort';
$_lang["keywords"] = 'Schlüsselwörter';
$_lang["keywords_intro"] = 'Hier legen Sie die Schlüsselwörter fest, die Ihrem Ressource zugewiesen werden können.';
$_lang["language_message"] = 'Wählen Sie die Sprache für den MODx-Manager.';
$_lang["language_title"] = 'Sprache:';
$_lang["launch_site"] = 'Anzeigen';
$_lang["link_attributes"] = 'Link-Attribute';
$_lang["link_attributes_help"] = 'Hier können Sie HTML-Attribute für den Link angeben (z.B. target= oder rel=).';
$_lang["list_mode"] = 'Listenmodus ein/aus – alle Einträge anzeigen.';
$_lang["loading_doc_tree"] = 'Laden der Ressourcen-Baums …';
$_lang["loading_menu"] = 'Laden des Menüs …';
$_lang["loading_page"] = 'Bitte warten Sie während MODx die Seite lädt …';
$_lang["localtime"] = 'Ortszeit';
$_lang["lock_htmlsnippet"] = 'Chunk für Bearbeitung sperren';
$_lang["lock_htmlsnippet_msg"] = 'Nur Administratoren (Rollen-ID 1) können diesen Chunk bearbeiten.';
$_lang["lock_module"] = 'Modul für die Bearbeitung sperren';
$_lang["lock_module_msg"] = 'Nur Administratoren (Rollen-ID 1) können dieses Modul bearbeiten.';
$_lang["lock_msg"] = 'Der Benutzer %s bearbeitet gerade die Ressource %s. Bitte warten Sie bis dieser Benutzer seine Arbeit beendet und die Ressource wieder freigegeben hat.';
$_lang["lock_plugin"] = 'Plugin für die Bearbeitung sperren';
$_lang["lock_plugin_msg"] = 'Nur Administratoren (Rollen-ID 1) können dieses Plugin bearbeiten.';
$_lang["lock_settings_msg"] = 'Der Benutzer %s bearbeitet gerade diese Einstellungen. Bitte warten Sie bis dieser seine Arbeit beendet und die Ressource wieder freigegeben hat.';
$_lang["lock_snippet"] = 'Snippet für die Bearbeitung sperren.';
$_lang["lock_snippet_msg"] = 'Nur Administratoren (Rollen-ID 1) können dieses Snippet bearbeiten.';
$_lang["lock_template"] = 'Template für die Bearbeitung sperren.';
$_lang["lock_template_msg"] = 'Nur Administratoren (Rollen-ID 1) können dieses Template bearbeiten.';
$_lang["lock_tmplvars"] = 'Variable gegen Bearbeitung sperren';
$_lang["lock_tmplvars_msg"] = 'Nur Administratoren (Rollen-ID 1) können diese Variable bearbeiten.';
$_lang["locked"] = 'Gesperrt';
$_lang["login_allowed_days"] = 'Wochentagsbeschränkung';
$_lang["login_allowed_days_message"] = 'Wählen Sie die Wochentage aus, an denen der Benutzer Zugriff erhält.';
$_lang["login_allowed_ip"] = 'IP-Adressbeschränkung';
$_lang["login_allowed_ip_message"] = 'Geben Sie hier die IP-Adressen an, von denen aus der Benutzer eine Zugriffsberechtigung erhält. <b>Hinweis: Mehrere IP-Adressen können mit einem Komma getrennt werden.</b>';
$_lang["login_button"] = 'Anmelden';
$_lang["login_cancelled_install_in_progress"] = 'Installation/Update der Site läuft. <br />Bitte versuchen Sie es in einigen Minuten erneut!<br />';
$_lang["login_cancelled_site_was_updated"] = 'Installation/Update der Site wurde abgeschlossen. Bitte melden Sie sich erneut an!<br />';
$_lang["login_captcha_message"] = ' Der Administrator hat die Captcha-Validierung aktiviert, Sie müssen daher auch den Sicherheits-Code eingeben. \n\nWenn der Sicherheits-Code schlecht lesbar ist, klicken Sie bitte auf den Code, damit ein neuer Code generiert wird.';
$_lang["login_homepage"] = 'Anmeldeseite';
$_lang["login_homepage_message"] = 'Geben Sie die Ressource-ID an, zu welcher der Web-Benutzer nach einer erfolgreichen Anmeldung weitergeleitet wird. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist und der entsprechende Web-Benutzer die notwendigen Zugriffsberechtigungen besitzt um darauf zuzugreifen!';
$_lang["login_message"] = 'Bitte melden Sie sich an, um mit MODx zu arbeiten.<br />Beachten Sie bei Ihrer Eingabe die Groß- und Kleinschreibung.';
$_lang["logo_slogan"] = 'MODx-Content-Manager – \n\nCreate and do more with less';
$_lang["logout"] = 'Abmelden';
$_lang["long_title"] = 'Langer Titel';
$_lang["mail_check_timeperiod_message"] = 'Wie oft soll nach neuen Nachrichten im Manager gesucht werden (Angabe in Sekunden)?';
$_lang["mail_check_timeperiod_title"] = 'Nachrichten-Überprüfungsfrequenz:';
$_lang["manage_depends"] = 'Abhängigkeiten verwalten';
$_lang["manage_files"] = 'Datei-Manager';
$_lang["manage_htmlsnippets"] = 'Chunks';
$_lang["manage_metatags"] = 'Meta-Angaben verwalten';
$_lang["manage_modules"] = 'Module verwalten';
$_lang["manage_plugins"] = 'Plugins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Template-Verwaltung';
$_lang["manager"] = 'Manager';
$_lang["manager_lockout_message"] = '<p>Sie sind gegenwärtig im MODx-Manager angemeldet. Wenn Sie Ihre Login-Session beenden wollen, klicken Sie bitte den Abmelden-Button.</p><p>Um zu Ihrer Start- oder Home-Seite zu gelangen, klicken Sie bitte den Start-Button.';
$_lang["manager_permissions"] = 'Manager-Zugriffberechtigungen';
$_lang["manager_theme"] = 'Manager-Template:';
$_lang["manager_theme_message"] = 'Wählen Sie das Template für den MODx-Manager aus.';
$_lang["messages"] = 'Nachrichten';
$_lang["messages_all"] = 'alle';
$_lang["messages_compose"] = 'Nachricht verfassen';
$_lang["messages_forward"] = 'Weiterleiten';
$_lang["messages_from"] = 'Von';
$_lang["messages_group"] = 'eine Gruppe';
$_lang["messages_inbox"] = 'Posteingang';
$_lang["messages_message"] = 'Nachricht';
$_lang["messages_no_messages"] = 'Sie haben keine Nachrichten.';
$_lang["messages_not_allowed_to_read"] = 'Sie sind nicht berechtigt, diese Nachricht zu lesen!';
$_lang["messages_private"] = 'Privat';
$_lang["messages_read_message"] = 'Nachrichten lesen';
$_lang["messages_reply"] = 'Antworten';
$_lang["messages_select_group"] = 'Gruppe wählen';
$_lang["messages_select_user"] = 'Benutzer wählen';
$_lang["messages_send"] = 'Senden';
$_lang["messages_send_to"] = 'Senden an';
$_lang["messages_sent"] = 'gesendet am';
$_lang["messages_subject"] = 'Betreff';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'Nachrichten';
$_lang["messages_user"] = 'ein Benutzer';
$_lang["meta_keywords"] = 'Meta-Angaben';
$_lang["metatag_intro"] = 'In diesem Bereich verwalten Sie Meta-Angaben, die Ihren Ressourcenn beim Bearbeiten zugewiesen werden können.';
$_lang["metatag_notice"] = 'Im HTML-Nachschlagewerk <a href="http://de.selfhtml.org/html/kopfdaten/meta.htm" target="_blank">SELFHTML</a> finden Sie eine Zusammenstellung geläufiger Meta-Angaben, sowie Hinweise zu deren Anwendung.';
$_lang["metatags"] = 'Meta-Angaben';
$_lang["mgr_access_permissions"] = 'Manager-Zugriffsberechtigungen';
$_lang["mgr_login_start"] = 'Benutzer-Startbildschirm';
$_lang["mgr_login_start_message"] = 'Geben Sie die Ressource-ID an, zu welcher der Web-Benutzer nach einer erfolgreichen Anmeldung weitergeleitet werden soll. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist und der entsprechende Web-Benutzer die notwendigen Zugriffsberechtigungen besitzt um darauf zuzugreifen!';
$_lang["mgrlog_action"] = 'Aktion';
$_lang["mgrlog_actionid"] = 'Aktions-ID';
$_lang["mgrlog_anyall"] = 'Einzelne/Alle';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() gibt „false“ zurück.';
$_lang["mgrlog_datefr"] = 'Datum von';
$_lang["mgrlog_dateinvalid"] = 'Ungültiges Datumsformat.';
$_lang["mgrlog_dateto"] = 'Datum bis';
$_lang["mgrlog_emptysrch"] = 'Ihre Suchanfrage ergab keine Treffer.';
$_lang["mgrlog_field"] = 'Feld';
$_lang["mgrlog_itemid"] = 'Element-ID';
$_lang["mgrlog_itemname"] = 'Elementname';
$_lang["mgrlog_msg"] = 'Nachricht';
$_lang["mgrlog_noquery"] = 'Es wurde noch keine Suchanfrage eingegeben.';
$_lang["mgrlog_qresults"] = 'Suchergebnisse';
$_lang["mgrlog_query"] = 'Suchabfragen loggen';
$_lang["mgrlog_query_msg"] = 'Bitte treffen Sie eine Auswahl, um die Protokoll-Einträge anzusehen. Sie können Einträge innerhalb eines bestimmten Zeitraums durchsuchen. Aber berücksichtigen Sie, dass das eingegebene Datum nicht inklusive ist – um alle Einträge für den 01-01-2009 auszuwählen, setzen Sie „Datum von“ auf den 01-01-2009 und „Datum bis“ auf den 02-01-2009.<br /><br />Eine Nachricht und eine Aktion sind üblicherweise dasselbe. Wenn Sie nach einer bestimmten Nachricht suchen, ist es am besten die Aktion „Einzelne/Alle“ auszuwählen.';
$_lang["mgrlog_results"] = 'Anzahl der Ergebnisse';
$_lang["mgrlog_searchlogs"] = 'Such-Protokoll';
$_lang["mgrlog_sortinst"] = 'Sie können die Tabelle sortieren, indem Sie auf die Spaltenüberschriften klicken. Sollten die Protokolldateien zu groß werden, können Sie diese <a href="index.php?a=55">löschen</a>. Dadurch werden alle Protokolleinträge bis zum heutigen Tag entfernt – das Löschen der Protokolleinträge kann nicht rückgängig gemacht werden!';
$_lang["mgrlog_time"] = 'Zeit';
$_lang["mgrlog_user"] = 'Benutzer';
$_lang["mgrlog_username"] = 'Benutzername';
$_lang["mgrlog_value"] = 'Wert';
$_lang["mgrlog_view"] = 'Benutzerprotokolle anzeigen';
$_lang["module_code"] = 'Modul-Code (PHP)';
$_lang["module_config"] = 'Modul Konfiguration';
$_lang["module_desc"] = 'Beschreibung';
$_lang["module_disabled"] = 'Modul deaktivieren';
$_lang["module_edit_click_title"] = 'Klicken Sie hier, um das Modul zu bearbeiten';
$_lang["module_group_access_msg"] = 'Wählen Sie die Benutzergruppen aus, die dieses Modul innerhalb des MODx-Managers ausführen dürfen.';
$_lang["module_management"] = 'Modul-Verwaltung';
$_lang["module_management_msg"] = 'In dieser Übersicht können Sie Module ausführen und bearbeiten. Um ein Modul zu starten, klicken Sie auf das Symbol des Moduls, für die Bearbeitung auf den Namen.';
$_lang["module_msg"] = 'Hier können Sie Module verwalten und bearbeiten. Ein Modul ist eine Zusammenfassung von Elementen wie Plugins, Snippets, usw.';
$_lang["module_name"] = 'Modulname';
$_lang["module_resource_msg"] = 'Hier können Sie die Ressourcen verwalten, die dieses Modul benötigt. Benutzen Sie die entsprechenden Buttons.';
$_lang["module_resource_title"] = 'Modulabhängigkeiten';
$_lang["module_title"] = 'Modul erstellen/bearbeiten';
$_lang["module_viewdepend_msg"] = 'Hier können Sie die Abhängigkeiten dieses Moduls bearbeiten und verwalten.';
$_lang["modules"] = 'Module';
$_lang["modx_news"] = 'MODx-Nachrichten';
$_lang["modx_news_tab"] = 'MODx-Nachrichten';
$_lang["modx_news_title"] = 'MODx-Nachrichten';
$_lang["modx_security_notices"] = 'MODx-Sicherheitshinweise';
$_lang["modx_version"] = 'MODx-Version';
$_lang["monday"] = 'Montag';
$_lang["move"] = 'Verschieben';
$_lang["move_resource"] = 'Ressource Verschieben';
$_lang["move_resource_message"] = 'Sie können diese Ressource und alle Unter-Ressourcen durch die Wahl eines neuen Containers verschieben. Wenn Sie eine Ressource wählen, die kein Container ist, wird diese Ressource automatisch in einen Container umgewandelt. Bitte wählen Sie einen neuen Container aus dem Ressourcen-Baum aus.';
$_lang["move_resource_new_parent"] = 'Bitte wählen Sie einen neuen Container aus dem Ressourcen-Baum aus.';
$_lang["move_resource_title"] = 'Ressource verschieben';
$_lang["name"] = 'Name';
$_lang["new_category"] = 'Neue Kategorie';
$_lang["new_file_permissions_message"] = 'Wenn Sie eine neue Datei mit dem Datei-Manager hochladen, wird versucht die Dateirechte wie hier angegeben zu setzen. In manchen Installationen (zum Beispiel in Microsofts IIS), ist dies nicht möglich. In diesem Fall Dann müssen Sie die Rechte der Datei manuell setzen.';
$_lang["new_file_permissions_title"] = 'Neue Dateirechte';
$_lang["new_folder_permissions_message"] = 'Wenn Sie eine neues Verzeichnis mit dem Datei-Manager erstellen, wird versucht die Verzeichnisrechte wie hier angegeben zu setzen. In manchen Installationen (zum Beispiel in Microsofts IIS), ist dies nicht möglich. In diesem Fall Dann müssen Sie die Rechte der Datei manuell setzen.';
$_lang["new_folder_permissions_title"] = 'Neue Verzeichnis-Zugriffsrechte';
$_lang["new_htmlsnippet"] = 'Neues Chunk';
$_lang["new_keyword"] = 'Neues Schlüsselwort:';
$_lang["new_module"] = 'Neues Modul ';
$_lang["new_parent"] = 'Neues Überelement';
$_lang["new_plugin"] = 'Neue Plugin';
$_lang["new_role"] = 'Neue Rolle';
$_lang["new_snippet"] = 'Neues Snippet';
$_lang["new_template"] = 'Neues Template';
$_lang["new_tmplvars"] = 'Neue Template-Variable';
$_lang["new_user"] = 'Neuer Benutzer';
$_lang["new_web_user"] = 'Neuer Web-Benutzer';
$_lang["no"] = 'Nein';
$_lang["no_active_users_found"] = 'Keine aktiven Benutzer gefunden.';
$_lang["no_activity_message"] = 'Sie haben bis jetzt noch keine Ressourcen bearbeitet oder erstellt.';
$_lang["no_category"] = 'nicht kategorisiert';
$_lang["no_docs_pending_publishing"] = 'Es stehen keine Ressourcen zum zeitgesteuerten Veröffentlichen an.';
$_lang["no_docs_pending_pubunpub"] = 'Keine Ereignisse.';
$_lang["no_docs_pending_unpublishing"] = 'Es stehen keine Ressourcen zum zeitgesteuerten Zurückziehen an.';
$_lang["no_edits_creates"] = 'No edits or creates found.';
$_lang["no_groups_found"] = 'Keine Gruppen gefunden.';
$_lang["no_keywords_found"] = 'Keine Keywords vorhanden.';
$_lang["no_records_found"] = 'Keine Einträge gefunden.';
$_lang["no_results"] = 'Es wurden keine Ergebnisse gefunden';
$_lang["nologentries_message"] = 'Geben Sie die Anzahl der Einträge an, die im Protokoll angezeigt werden sollen.';
$_lang["nologentries_title"] = 'Anzahl der Log-Einträge:';
$_lang["nomessages_message"] = 'Geben Sie wie viele Nachrichten im Posteingang angezeigt werden sollen.';
$_lang["nomessages_title"] = 'Anzahl der Nachrichten:';
$_lang["none"] = 'Keine';
$_lang["noresults_message"] = 'Anzahl der anzuzeigenden Ergebnisse in Listen und Suchergebnissen.';
$_lang["noresults_title"] = 'Ergebnisse';
$_lang["not_deleted"] = 'wurde nicht gelöscht.';
$_lang["not_set"] = 'Nicht gesetzt';
$_lang["offline"] = 'Offline';
$_lang["online"] = 'Online';
$_lang["onlineusers_action"] = 'Aktion';
$_lang["onlineusers_actionid"] = 'Aktions-ID';
$_lang["onlineusers_ipaddress"] = 'IP-Adresse des Benutzers';
$_lang["onlineusers_lasthit"] = 'Letzte Aktion';
$_lang["onlineusers_message"] = 'Diese Liste zeigt Ihnen die aktiven Benutzer der letzten 20 Minuten an. (Zur Zeit ist es ';
$_lang["onlineusers_title"] = 'Folgende Benutzer sind online';
$_lang["onlineusers_user"] = 'Benutzer';
$_lang["onlineusers_userid"] = 'Benutzer-ID';
$_lang["optimize_table"] = 'Klicken Sie hier, um die Tabelle zu optimieren';
$_lang["page_data_cacheable"] = 'Cache aktiv';
$_lang["page_data_cacheable_help"] = 'Markieren Sie diese Option, falls Ihre Ressource cachebar sein soll. Falls Ihre Ressource Snippets nutzt, muss diese Option deaktiviert sein.';
$_lang["page_data_cached"] = '<b>Quelltext aus dem Cache:</b>';
$_lang["page_data_changes"] = 'Änderungen';
$_lang["page_data_contentType"] = 'Inhaltstyp';
$_lang["page_data_contentType_help"] = 'Wählen Sie den Inhaltstyp für diese Ressource. Wenn Sie sich nicht sicher sind welchen Typ die Ressource haben soll, lassen Sie die Einstellung auf „text/html“.';
$_lang["page_data_created"] = 'Erstellt';
$_lang["page_data_edited"] = 'Bearbeitet';
$_lang["page_data_editor"] = 'Rich-Text-Editor benutzen';
$_lang["page_data_folder"] = 'Ressource ist ein Container';
$_lang["page_data_general"] = 'Allgemein';
$_lang["page_data_markup"] = 'Auszeichnung / Struktur';
$_lang["page_data_mgr_access"] = 'Manager-Zugriff';
$_lang["page_data_notcached"] = 'Diese Ressource wurde noch nicht gecached.';
$_lang["page_data_publishdate"] = 'Veröffentlichen am';
$_lang["page_data_publishdate_help"] = 'Falls Sie ein Datum setzen, wird die Ressource zum angegebenen Zeitpunkt veröffentlicht.';
$_lang["page_data_published"] = 'Veröffentlicht';
$_lang["page_data_searchable"] = 'Durchsuchbar';
$_lang["page_data_searchable_help"] = 'Ist diese Option aktiv, kann die Ressource durchsucht werden. Sie können dieses Feld auch für jede andere Aktion in Ihren Snippets nutzen.';
$_lang["page_data_source"] = 'Quelltext';
$_lang["page_data_status"] = 'Status';
$_lang["page_data_template"] = 'Template';
$_lang["page_data_template_help"] = 'Hier können Sie das Template für die Ressource wählen.';
$_lang["page_data_title"] = 'Daten der Ressource';
$_lang["page_data_unpublishdate"] = 'Zurückziehen am';
$_lang["page_data_unpublishdate_help"] = 'Falls Sie ein Datum setzen, wird die Ressource zum angegebenen Zeitpunkt zurückgezogen.';
$_lang["page_data_unpublished"] = 'Unveröffentlicht';
$_lang["page_data_web_access"] = 'Web-Zugriff';
$_lang["pagetitle"] = 'Ressource-Titel';
$_lang["pagination_table_first"] = 'Anfang';
$_lang["pagination_table_gotopage"] = 'Gehe zu Seite';
$_lang["pagination_table_last"] = 'Ende';
$_lang["paging_first"] = 'Anfang';
$_lang["paging_last"] = 'Ende';
$_lang["paging_next"] = 'Vor';
$_lang["paging_prev"] = 'Zurück';
$_lang["paging_showing"] = 'Zeige';
$_lang["paging_to"] = 'von';
$_lang["paging_total"] = 'insgesamt';
$_lang["parameter"] = 'Parameter';
$_lang["password"] = 'Passwort';
$_lang["password_change_request"] = 'Neues Passwort angefordert';
$_lang["password_gen_gen"] = 'MODx soll ein Passwort generieren.';
$_lang["password_gen_length"] = 'Das Passwort muss mindestes 6 Zeichen lang sein.';
$_lang["password_gen_method"] = 'Wie möchten Sie das Passwort erzeugen?';
$_lang["password_gen_specify"] = 'Das Passwort wird von mir eingegeben:';
$_lang["password_method"] = 'Wie möchten Sie den Benutzer über sein neues Passwort benachrichtigen?';
$_lang["password_method_email"] = 'Neues Passwort per E-Mail senden.';
$_lang["password_method_screen"] = 'Neues Passwort am Bildschirm ausgeben.';
$_lang["password_msg"] = 'Das neue Passwort für <b>%s</b> ist <b>%s</b>.';
$_lang["php_version_check"] = 'MODx ist kompatibel mit PHP 4.0.3 und höher. Bitte installieren Sie eine neuere Version von PHP.';
$_lang["plugin"] = 'Plugin';
$_lang["plugin_code"] = 'Plugin-Code (PHP)';
$_lang["plugin_config"] = 'Plugin-Konfiguration';
$_lang["plugin_desc"] = 'Beschreibung';
$_lang["plugin_disabled"] = 'Plugin deaktiviert';
$_lang["plugin_event_msg"] = 'Wählen Sie hier die Systemereignisse aus, bei denen dieses Plugin ausgeführt werden soll.';
$_lang["plugin_management_msg"] = 'Hier können Sie auswählen welches Plugin Sie bearbeiten möchten.';
$_lang["plugin_msg"] = 'Hier können Sie Plugins erstellen und bearbeiten. Plugins bestehen aus PHP-Quellcode und werden aufgrund von definierten Systemereignissen ausgeführt.';
$_lang["plugin_name"] = 'Plugin-Name';
$_lang["plugin_priority"] = 'Ausführungsreihenfolge festlegen';
$_lang["plugin_priority_instructions"] = 'Hier können Sie durch Drag & Drop die Plugins unter jedem Event-Titel neu anordnen. Das erste Plugin das ausgeführt werden soll, muss ganz oben platziert werden.';
$_lang["plugin_priority_title"] = 'Reihenfolge der Ausführung der Plugns';
$_lang["plugin_title"] = 'Plugin erstellen/bearbeiten';
$_lang["preview"] = 'Vorschau';
$_lang["preview_msg"] = 'Dies ist eine Vorschau der zuletzt gespeicherten Änderungen. Klicken Sie hier zum <a href="#" onclick="saveRefreshPreview();">Speichern und Aktualisieren</a>.';
$_lang["preview_resource"] = 'Ressource-Vorschau';
$_lang["private"] = 'Privat';
$_lang["public"] = 'Öffentlich';
$_lang["publish_date"] = 'Veröffentlichungstermin';
$_lang["publish_events"] = 'Veröffentlichungen';
$_lang["publish_resource"] = 'Veröffentlichen';
$_lang["rb_base_dir_message"] = 'Geben Sie den physischen Pfad auf dem Web-Server zu Ihrem Datei-Verzeichnis ein. Abhängig von Ihrem Webserver ist diese Einstellung im Normalfall automatisch vorausgefüllt. <b>Hinweis:</b> Für die korrekte Funktion muss das Datei-Verzeichnis die Unterverzeichnisse „images“, „docs“, „flash“ und „media“ beinhalten.';
$_lang["rb_base_dir_title"] = 'Datei-Basispfad';
$_lang["rb_base_url_message"] = 'Geben Sie den virtuellen Pfad zum Datei-Basispfad an. Der virtuelle Pfad ist identisch mit der URL in Ihrem Web-Browser.';
$_lang["rb_base_url_title"] = 'Datei-URL:';
$_lang["rb_message"] = 'Wählen Sie „Ja“, um den Datei-Browser zu aktivieren. Der Datei-Browser ermöglicht Benutzern, allgemeine Dateien wie Bilder, Animationen oder Mediendateien auf den Server zu laden und zu verwalten.';
$_lang["rb_title"] = 'Datei-Browser aktivieren:';
$_lang["rb_webuser_message"] = 'Soll ein Web-Benutzer den Datei-Browser verwenden dürfen? <b>Hinweis:</b> Wenn Web-Benutzer den Datei-Browser verwenden dürfen, können sie alle Dateien einsehen auf die Manager-Benutzer Zugriff haben. Diese Möglichkeit sollte daher nur vertrauenswürdigen Web-Benutzern eingeräumt werden.';
$_lang["rb_webuser_title"] = 'Web-Benutzer?';
$_lang["recent_docs"] = 'Kürzlich bearbeitet';
$_lang["recent_docs"] = 'Kürzlich bearbeitete Ressourcen';
$_lang["refresh_cache"] = 'Cache: <b>%s</b> Dateien wurden im Cache-Verzeichnis gefunden. Gelöschte Dateien <b>%d</b>.<p>Der Cache wird erneuert, sobald die Seiten das erste mal aufgerufen werden.';
$_lang["refresh_published"] = '<b>%s</b> Ressourcen wurden veröffentlicht.';
$_lang["refresh_site"] = 'Cache leeren';
$_lang["refresh_title"] = 'Website aktualisieren, Cache leeren';
$_lang["refresh_tree"] = 'Ressourcen-Baum aktualisieren';
$_lang["refresh_unpublished"] = '<b>%s</b> Ressourcen wurden zurückgezogen.';
$_lang["remember_username"] = 'Benutzername merken';
$_lang["remove"] = 'Entfernen';
$_lang["remove_date"] = 'Datum löschen';
$_lang["remove_locks"] = 'Sperren entfernen';
$_lang["rename"] = 'Umbenennen';
$_lang["reports"] = 'Berichte';
$_lang["require_tagname"] = 'Ein Tag-Name ist zwingend erforderlich';
$_lang["require_tagvalue"] = 'Ein Tag-Wert ist zwingend erforderlich';
$_lang["reset"] = 'Zurücksetzen';
$_lang["reset_failedlogins"] = 'Zurücksetzen';
$_lang["resolve_hostnames_message"] = 'Wollen Sie, dass MODx die Host-Namen der Besucher ermittelt? Die Ermittlung der Host-Namen benötigt mehr CPU-Leistung von Ihrem Server.';
$_lang["resolve_hostnames_title"] = 'Host-Namen ermitteln';
$_lang["resource"] = 'Ressource';
$_lang["resource_alias"] = 'Ressource-Alias';
$_lang["resource_alias_help"] = 'Hier können Sie die URL der Ressource angeben um diese auch über http://beispiel.de/alias verfügbar zu machen. Funktioniert nur bei aktivierten benutzerfreundlichen URLs.';
$_lang["resource_content"] = 'Inhalt der Ressource';
$_lang["resource_description"] = 'Beschreibung';
$_lang["resource_description_help"] = 'Sie können hier eine optionale Beschreibung der Ressource eingeben.';
$_lang["resource_duplicate"] = 'Ressource duplizieren';
$_lang["resource_long_title_help"] = 'Hier können Sie einen längeren Titel für die Ressource eingeben. Der Langtitel kann für Header-Tags verwendet werden, nützlich für die Suchmaschinen-Indizierung sein und aussagekräftig Ihre Seite beschreiben.';
$_lang["resource_metatag_help"] = 'Wählen Sie jene Meta-Tags und Schlüsselwörter aus, die dieser Ressource zugeordnet werden sollen. Für eine Mehrfachauswahl halten Sie die STRG- / CTRL-Taste gedrückt.';
$_lang["resource_opt_contentdispo"] = 'Inhaltstyp';
$_lang["resource_opt_contentdispo_help"] = 'Mit diesem Feld können Sie festlegen, ob der Browser diese Ressource wie üblich im Browser-Fenster darstellt oder als Datei-Download anbietet.';
$_lang["resource_opt_emptycache"] = 'Cache leeren';
$_lang["resource_opt_emptycache_help"] = 'Eine Markierung dieses Feldes löscht den Cache für diese Ressource nach dem Speichern.';
$_lang["resource_opt_folder"] = 'Container';
$_lang["resource_opt_folder_help"] = 'Markieren Sie diese Einstellung, wenn diese Ressource als Container für andere Ressourcen zur Verfügung stehen soll. Ein Container ist wie ein Ordner für weitere Ressourcen, kann selbst aber auch Inhalte enthalten.';
$_lang["resource_opt_menu_index"] = 'Menüindex';
$_lang["resource_opt_menu_index_help"] = 'Der Menüindex kann in Menü-Snippets die Position der Ressource in Menülisten bestimmen oder auch für jeden anderen Zweck in Snippets verwendet werden.';
$_lang["resource_opt_menu_title"] = 'Menütitel';
$_lang["resource_opt_menu_title_help"] = 'Im Menütitel kann optional ein kurzer Titel angegeben werden, der für Links zu dieser Ressource in Menü-Snippets verwendet wird.';
$_lang["resource_opt_published"] = 'Veröffentlicht';
$_lang["resource_opt_published_help"] = 'Markieren Sie diese Option, wenn Ihr Ressource direkt nach dem speichern veröffentlicht werden soll.';
$_lang["resource_opt_richtext"] = 'Rich-Text';
$_lang["resource_opt_richtext_help"] = 'Markieren Sie diese Option, wenn Sie zum Bearbeiten der Ressource den Rich-Text-Editor nutzen möchten. Fall Ihr Ressource Javascript oder Formulare beinhalten soll, deaktivieren Sie diese Option, damit der HTML-Editor Ihr Ressource nicht zerstört.';
$_lang["resource_opt_show_menu"] = 'Im Menü anzeigen';
$_lang["resource_opt_show_menu_help"] = 'Aktivieren Sie diese Option um die Ressource in Menülisten anzuzeigen. Setzt voraus, dass Ihre Menü-Snippets diese Angabe interpretieren.';
$_lang["resource_opt_trackvisit_help"] = 'Besucherzugriffe auf dieser Seite protokollieren';
$_lang["resource_overview"] = 'Ressourcen-Übersicht';
$_lang["resource_parent"] = 'Container';
$_lang["resource_parent_help"] = 'Klicken Sie auf eine Ressource im Baum, um diese als übergeordnete Ressource zu wählen.';
$_lang["resource_permissions_error"] = 'Weisen Sie diese Resource mindestens einer Ressourcen-Gruppe zu, zu der Sie Zugriff haben.';
$_lang["resource_setting"] = 'Ressourcen-Eigenschaften';
$_lang["resource_summary"] = 'Zusammenfassung';
$_lang["resource_summary_help"] = 'Geben Sie eine kurze inhaltliche Zusammenfassung der Ressource ein.';
$_lang["resource_title"] = 'Titel';
$_lang["resource_title_help"] = 'Geben Sie hier den Namen/Titel der Ressource ein. Vermeiden Sie die Benutzung von Backslashes im Namen!';
$_lang["resource_to_be_moved"] = 'Ressource die verschoben werden soll';
$_lang["resource_weblink_help"] = 'Geben Sie hier die Adresse des Objekts ein, auf welches Sie verlinken möchten.';
$_lang["resources_in_container"] = 'Ressourcen in diesem Container.';
$_lang["resources_in_container_no"] = 'Dieser Container enthält keine Unter-Ressourcen.';
$_lang["role"] = 'Rolle';
$_lang["role_about"] = 'Anzeige der „Über“-Seite';
$_lang["role_access_persmissions"] = 'Zugriffsberechtigungen';
$_lang["role_actionok"] = 'Ausgeführte Aktionen anzeigen';
$_lang["role_bk_manager"] = 'Backup-Manager benutzen';
$_lang["role_cache_refresh"] = 'Seitencache leeren';
$_lang["role_change_password"] = 'Passwort ändern';
$_lang["role_chunk_management"] = 'Chunk-Management';
$_lang["role_config_management"] = 'Konfigurations-Verwaltung';
$_lang["role_content_management"] = 'Inhalts-Verwaltung';
$_lang["role_create_chunk"] = 'Neue Chunks erstellen';
$_lang["role_create_doc"] = 'Neue Ressourcen erstellen';
$_lang["role_create_plugin"] = 'Neue Plugins erstellen';
$_lang["role_create_snippet"] = 'Neue Snippets erstellen';
$_lang["role_create_template"] = 'Neue Templates erstellen';
$_lang["role_credits"] = 'Danksagungen';
$_lang["role_delete_chunk"] = 'Chunks löschen';
$_lang["role_delete_doc"] = 'Ressourcen löschen';
$_lang["role_delete_eventlog"] = 'Ereignisprotokoll löschen';
$_lang["role_delete_module"] = 'Module löschen';
$_lang["role_delete_plugin"] = 'Plugins löschen';
$_lang["role_delete_role"] = 'Rollen löschen';
$_lang["role_delete_snippet"] = 'Snippets löschen';
$_lang["role_delete_template"] = 'Templates löschen';
$_lang["role_delete_user"] = 'Benutzer löschen';
$_lang["role_delete_web_user"] = 'Web-Benutzer löschen';
$_lang["role_edit_chunk"] = 'Chunks bearbeiten';
$_lang["role_edit_doc"] = 'Ressourcen bearbeiten';
$_lang["role_edit_doc_metatags"] = 'Meta-Tags und Schlüsselwörter bearbeiten';
$_lang["role_edit_module"] = 'Module bearbeiten';
$_lang["role_edit_plugin"] = 'Plugins bearbeiten';
$_lang["role_edit_role"] = 'Rollen bearbeiten';
$_lang["role_edit_settings"] = 'Konfiguration bearbeiten';
$_lang["role_edit_snippet"] = 'Snippets bearbeiten';
$_lang["role_edit_template"] = 'Templates bearbeiten';
$_lang["role_edit_user"] = 'Benutzer bearbeiten';
$_lang["role_edit_web_user"] = 'Web-Benutzer bearbeiten';
$_lang["role_empty_trash"] = 'Gelöschte Ressourcen endgültig entfernen';
$_lang["role_errors"] = 'Fehlerdialoge anzeigen';
$_lang["role_eventlog_management"] = 'Ereignisverwaltung';
$_lang["role_export_static"] = 'Statisches HTML exportieren';
$_lang["role_file_manager"] = 'Datei-Manager benutzen';
$_lang["role_frames"] = 'Manager-Frames ermitteln';
$_lang["role_help"] = 'Anzeigen der Hilfeseiten';
$_lang["role_home"] = 'Manager Startseite ermitteln';
$_lang["role_import_static"] = 'HTML importieren';
$_lang["role_logout"] = 'Abmeldung aus dem MODx-Manager';
$_lang["role_manage_metatags"] = 'Meta-Tags und Schlüsselwörter verwalten';
$_lang["role_management_msg"] = 'Hier können Sie eine Rolle zum Bearbeiten wählen.';
$_lang["role_management_title"] = 'Rollen';
$_lang["role_messages"] = 'Nachrichten anzeigen und senden';
$_lang["role_module_management"] = 'Modul-Verwaltung';
$_lang["role_name"] = 'Rollenname';
$_lang["role_new_module"] = 'Neues Modul erstellen';
$_lang["role_new_role"] = 'Neue Rolle erstellen';
$_lang["role_new_user"] = 'Neuen Benutzer erstellen';
$_lang["role_new_web_user"] = 'Neuen Web-Benutzer erstellen';
$_lang["role_plugin_management"] = 'Plugin-Verwaltung';
$_lang["role_publish_doc"] = 'Ressource veröffentlichen';
$_lang["role_role_management"] = 'Rollenverwaltung';
$_lang["role_run_module"] = 'Module ausführen';
$_lang["role_save_chunk"] = 'Chunks speichern';
$_lang["role_save_doc"] = 'Ressource speichern';
$_lang["role_save_module"] = 'Modul speichern';
$_lang["role_save_password"] = 'Passwort speichern';
$_lang["role_save_plugin"] = 'Plugins speichern';
$_lang["role_save_role"] = 'Rollen speichern';
$_lang["role_save_snippet"] = 'Snippet speichern';
$_lang["role_save_template"] = 'Template speichern';
$_lang["role_save_user"] = 'Benutzer speichern';
$_lang["role_save_web_user"] = 'Web-Benutzer speichern';
$_lang["role_snippet_management"] = 'Snippet-Verwaltung';
$_lang["role_template_management"] = 'Template-Verwaltung';
$_lang["role_title"] = 'Rolle erzeugen/bearbeiten';
$_lang["role_udperms"] = 'Rechteverwaltung';
$_lang["role_user_management"] = 'Benutzerverwaltung';
$_lang["role_view_docdata"] = 'Ressource-Daten anzeigen';
$_lang["role_view_eventlog"] = 'Ereignisprotokoll anzeigen';
$_lang["role_view_logs"] = 'Systemlogs anzeigen';
$_lang["role_view_unpublished"] = 'Zeige unveröffentlichte Ressourcen';
$_lang["role_web_access_persmissions"] = 'Web-Benutzer-Zugriffskontrolle';
$_lang["role_web_user_management"] = 'Web-Benutzerverwaltung';
$_lang["rss_url_news_default"] = 'http://feeds.feedburner.com/modx-announce';
$_lang["rss_url_news_message"] = 'URL des MODx-News-Feeds eintragen.';
$_lang["rss_url_news_title"] = 'RSS-News-Feed';
$_lang["rss_url_security_default"] = 'http://feeds.feedburner.com/modxsecurity';
$_lang["rss_url_security_message"] = 'URL des MODx-Security-Feeds eintragen.';
$_lang["rss_url_security_title"] = 'RSS-Security-Feed';
$_lang["run_module"] = 'Modul starten';
$_lang["saturday"] = 'Samstag';
$_lang["save"] = 'Speichern';
$_lang["save_all_changes"] = 'Änderungen speichern';
$_lang["save_tag"] = 'Tag speichern';
$_lang["saving"] = 'Speichern, bitte warten …';
$_lang["search"] = 'Suchen';
$_lang["search_criteria"] = 'Suchkriterium';
$_lang["search_criteria_content"] = 'Suche im Inhalt';
$_lang["search_criteria_content_msg"] = 'Findet alle Ressource in deren Inhalt der eingegebene Text vorkommt.';
$_lang["search_criteria_id"] = 'Suche nach ID';
$_lang["search_criteria_id_msg"] = 'Findet die Ressource dessen ID mit der eingegebenen übereinstimmt.';
$_lang["search_criteria_longtitle"] = 'Suche nach Langtitel';
$_lang["search_criteria_longtitle_msg"] = 'Findet alle Ressource in deren Langtitel der eingegebene Text vorkommt.';
$_lang["search_criteria_title"] = 'Suche nach Titel';
$_lang["search_criteria_title_msg"] = 'Findet alle Ressourcen in deren Titel der eingegebene Text vorkommt.';
$_lang["search_empty"] = 'Ihre Suche ergab keine Treffer. Bitte ändern Sie Ihre Suchanfrage und versuchen Sie es noch einmal.';
$_lang["search_item_deleted"] = 'Diese Ressource wurde gelöscht';
$_lang["search_results"] = 'Suchergebnisse';
$_lang["search_results_returned_desc"] = 'Beschreibung';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Ihre Suchanfrage ergab <b>%s</b> Treffer. Wenn zu viele Ergebnisse gefunden wurden, versuchen Sie die Suche zu verfeinern. Das erste Symbol in jeder Spalte zeigt Ihnen die Ressource-Postion im Baum an. Ganz rechts können Sie den Ressource-Status ablesen.';
$_lang["search_results_returned_title"] = 'Titel';
$_lang["search_view_docdata"] = 'Diese Ressource anzeigen';
$_lang["security"] = 'Sicherheit';
$_lang["security_notices_tab"] = 'Sicherheitsmeldungen';
$_lang["security_notices_title"] = 'Sicherheitsmeldungen';
$_lang["select_date"] = 'Datum auswählen';
$_lang["send"] = 'Senden';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Falls Sie eine https-Verbindung nutzen möchten, geben Sie dies hier an.';
$_lang["server_protocol_title"] = 'Servertyp:';
$_lang["serveroffset"] = 'Server-Zeitverschiebung';
$_lang["serveroffset_message"] = 'Wählen Sie die Anzahl der Stunden, die zwischen der Server-Zeit und Ihrer Ortszeit liegen. Die derzeitige Server-Zeit ist <b>[%s]</b>, die derzeitige Server-Zeit bei Nutzung der Zeitverschiebung ist <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Server-Zeitverschiebung:';
$_lang["servertime"] = 'Server-Zeit';
$_lang["settings_after_install"] = 'Da es sich um eine neue Installation handelt wird Ihnen empfohlen, die Einstellungen zu überprüfen und gegebenenfalls zu ändern.<br /><br />';
$_lang["settings_config"] = 'Konfiguration';
$_lang["settings_dependencies"] = 'Abhängigkeiten';
$_lang["settings_events"] = 'Systemereignisse';
$_lang["settings_furls"] = 'Benutzerfreundliche URL';
$_lang["settings_general"] = 'Allgemein';
$_lang["settings_misc"] = 'Sonstiges';
$_lang["settings_page_settings"] = 'Seiteneinstellungen';
$_lang["settings_photo"] = 'Foto';
$_lang["settings_properties"] = 'Eigenschaften';
$_lang["settings_site"] = 'Seiten';
$_lang["settings_strip_image_paths_message"] = 'Mit dieser Einstellung werden die Bildpfade relativ statt absolut gesetzt. Das ist sehr empfehlenswert wenn die Installation umgezogen wird (z.B. von der Entwicklungsseite zur Produktionsseite). Wenn Sie nicht wissen was gemeint ist – lassen Sie die Einstellung auf „Nein“.';
$_lang["settings_strip_image_paths_title"] = 'Bild-Pfade zurückschreiben?';
$_lang["settings_templvars"] = 'Template-Variablen';
$_lang["settings_title"] = 'MODx-Konfiguration';
$_lang["settings_ui"] = 'Benutzeroberfläche';
$_lang["settings_users"] = 'Benutzerverwaltung';
$_lang["show_tree"] = 'Baum anzeigen';
$_lang["showing"] = 'Anzeige';
$_lang["signupemail_message"] = 'Hier können Sie die Vorlage der E-Mail eingeben, die das System automatisch an Ihre Benutzer schickt, wenn die entsprechenden Benutzerkonten erstellt werden. Folgende Platzhalter werden vom System ersetzt, wenn die Nachricht versendet wird:<br /> <br />[+sname+] – Name dieser Website<br />[+saddr+] – E-Mail-Adresse des Webmasters<br />[+surl+] – URL der Website<br />[+uid+] – Name des Benutzerkontos<br />[+pwd+] – Passwort des Benutzerkontos<br />[+ufn+] – Name des Benutzers<br /><br /><b>Hinweis:</b>Sie sollten auf jeden Fall [+uid+] und [+pwd+] in der Vorlage anführen, damit Ihre Benutzer auch die entsprechenden Anmeldedaten erhalten.';
$_lang["signupemail_title"] = 'Aktivierungs-E-Mail:';
$_lang["site"] = 'Website';
$_lang["site_schedule"] = 'Terminplan';
$_lang["sitename_message"] = 'Geben Sie den Namen Ihrer Website ein.';
$_lang["sitename_title"] = 'Website-Name:';
$_lang["sitestart_message"] = 'Geben Sie die ID der Ressource ein, welche die Startseite sein soll. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist!';
$_lang["sitestart_title"] = 'Startseite:';
$_lang["sitestatus_message"] = 'Wählen Sie „Online“, um Ihre Seite zu veröffentlichen. Wenn Sie „Offline“ wählen wird den Besuchern Ihrer Seite die „Seite zur Zeit nicht erreichbar“ angezeigt.';
$_lang["sitestatus_title"] = 'Status der Seite:';
$_lang["siteunavailable_message"] = 'Diese Nachricht wird angezeigt, wenn Sie Ihre Seite „Offline“ geschaltet haben oder ein Fehler auftritt.';
$_lang["siteunavailable_message_default"] = 'Diese Seite ist derzeit nicht verfügbar.';
$_lang["siteunavailable_page_message"] = 'Geben Sie die Ressource-ID der Ressource ein, die beim Status „Offline“ angezeigt werden soll. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist!';
$_lang["siteunavailable_page_title"] = 'Offline-Seite:';
$_lang["siteunavailable_title"] = 'Seite nicht erreichbar:';
$_lang["snippet"] = 'Snippet';
$_lang["snippet_code"] = 'Snippet-Code (PHP)';
$_lang["snippet_desc"] = 'Snippet-Beschreibung';
$_lang["snippet_execonsave"] = 'Snippet nach dem Speichern ausführen.';
$_lang["snippet_management_msg"] = 'Hier können Sie ein Snippet wählen, das Sie bearbeiten möchten.';
$_lang["snippet_msg"] = 'Hier können Sie Snippets anlegen und bearbeiten. Beachten Sie, dass Snippets reiner PHP-Code sind. Wenn das Snippet einen Wert in einem Template oder einer Ressource ausgeben soll, müssen Sie diesen wert innerhalb des Snippets mit PHP ausgeben.';
$_lang["snippet_name"] = 'Snippet-Name';
$_lang["snippet_properties"] = 'Standardeigenschaften';
$_lang["snippet_title"] = 'Snippet erstellen/bearbeiten';
$_lang["sort_asc"] = 'Aufsteigend';
$_lang["sort_desc"] = 'Absteigend';
$_lang["sort_tree"] = 'Baum sortieren';
$_lang["source"] = 'Quelle';
$_lang["stay"] = 'Bearbeitung fortsetzen';
$_lang["stay_new"] = 'Weiter hinzufügen';
$_lang["submit"] = 'Absenden';
$_lang["sunday"] = 'Sonntag';
$_lang["sys_alert"] = 'Systemalarm';
$_lang["sysinfo_activity_message"] = 'Die Liste zeigt Ihnen die zuletzt bearbeiteten Dateien.';
$_lang["sysinfo_userid"] = 'Benutzer';
$_lang["system_email_signup"] = 'Hallo [+uid+]! \n\nHier sind Ihre Anmeldendaten für [+sname+] MODx-Manager: \n\nBenutzername: [+uid+] \nPasswort: [+pwd+] \n\nSobald Sie sich in Ihrem Account ([+surl+]) angemeldet haben, können Sie Ihr Passwort ändern.\n\nMit freundlichen Grüßen \n\nIhr Website-Administrator';
$_lang["system_email_webreminder"] = 'Hallo [+uid+]! \n\nUm Ihr neues Passwort zu aktivieren, klicken Sie bitte auf folgenden Link \n\n[+surl+] \n\nWenn alles erfolgreich war, können Sie danach das folgende Passwort zum Anmelden verwenden: \n\nPasswort:[+pwd+] \n\nWenn Sie diese E-Mail unverlangt bekommen, ignorieren Sie sie bitte einfach. \n\nMit freundlichen Grüßen \nIhr Website-Administrator';
$_lang["system_email_websignup"] = 'Hallo [+uid+], \n\nHier sind Ihre Anmeldedetails für [+sname+]: \n\nBenutzername: [+uid+] \nPasswort: [+pwd+] \n\nSobald Sie sich auf [+sname+] ([+surl+]) angemeldet haben, könne Sie Ihr Passwort ändern. \n\nMit freundlichen Grüßen \nIhr Website-Administrator';
$_lang["table_hoverinfo"] = 'Wenn Sie mit dem Mauszeiger über einen Tabellennamen fahren, wird Ihnen (sofern verfügbar) eine kurze Beschreibung der Funktion dieser Tabelle angezeigt.';
$_lang["table_prefix"] = 'Tabellen-Präfix';
$_lang["tag"] = 'Tag';
$_lang["template"] = 'Template';
$_lang["template_assignedtv_tab"] = 'Zugewiesene Template-Variablen';
$_lang["template_code"] = 'Template-Code (HTML)';
$_lang["template_desc"] = 'Template-Beschreibung';
$_lang["template_edit_tab"] = 'Template bearbeiten';
$_lang["template_management_msg"] = 'Hier können Sie ein Template wählen, das Sie bearbeiten möchten.';
$_lang["template_msg"] = 'Hier können Sie Templates anlegen und bearbeiten. Die Änderung an einem Template wird nur angezeigt, wenn Sie den Cache leeren. Sie können aber die Vorschaufunktion nutzen, um das Template anzuzeigen.';
$_lang["template_name"] = 'Template-Name';
$_lang["template_no_tv"] = 'Diesem Template wurden noch keine Template-Variablen zugewiesen.';
$_lang["template_reset_all"] = 'Alle Ressourcen auf das Standard-Template zurücksetzen';
$_lang["template_reset_specific"] = 'Template nur bei Ressourcen mit dem aktuellen Template „%s“ setzen';
$_lang["template_title"] = 'Template erstellen/bearbeiten';
$_lang["template_tv_edit"] = 'Reihenfolge der Template-Variablen bearbeiten';
$_lang["template_tv_edit_message"] = 'Reihenfolge der Template-Variablen für dieses Template durch Drag & Drop sortieren.';
$_lang["template_tv_edit_title"] = 'Reihenfolge Template-Variablen';
$_lang["template_tv_msg"] = 'Liste der Template-Variablen, die diesem Template zugeordnet wurden.';
$_lang["thursday"] = 'Donnerstag';
$_lang["tmplvar_access_msg"] = 'Wählen Sie jene Ressourcen-Gruppen aus, die diese Template-Variable bearbeiten dürfen.';
$_lang["tmplvar_change_template_msg"] = 'Wenn Sie das Template ändern, werden die Template-Variablen neu geladen. Achtung: alle nicht gespeicherten Änderungen gehen hierbei verloren!\n\nSind Sie sicher, dass Sie das Template ändern möchten?';
$_lang["tmplvar_inuse"] = 'Folgende Ressourcen verwenden derzeit diese Template-Variable. Wollen Sie mit dem Löschen fortfahren?';
$_lang["tmplvar_tmpl_access"] = 'Template-Berechtigungen';
$_lang["tmplvar_tmpl_access_msg"] = 'Wählen Sie hier jene Templates aus, die diese Variable verarbeiten dürfen.';
$_lang["tmplvars"] = 'Template-Variablen';
$_lang["tmplvars_binding_msg"] = 'Dieses Feld unterstützt Datenbindung mittels des @ Befehls';
$_lang["tmplvars_caption"] = 'Bezeichnung';
$_lang["tmplvars_default"] = 'Standardwert';
$_lang["tmplvars_description"] = 'Beschreibung';
$_lang["tmplvars_elements"] = 'Eingabeoptionswerte';
$_lang["tmplvars_management_msg"] = 'Hier können Sie Ihre Template-Variablen bearbeiten.';
$_lang["tmplvars_msg"] = 'Hier können Sie Template-Variablen erstellen und bearbeiten. Die Template-Variablen müssen für die jeweiligen Templates aktiviert werden, damit Snippets und Ressourcen darauf wie normale Variablen zugreifen können.';
$_lang["tmplvars_name"] = 'Name der Variablen';
$_lang["tmplvars_novars"] = 'Keine Template-Variablen gefunden';
$_lang["tmplvars_rank"] = 'Sortierung';
$_lang["tmplvars_reset_params"] = 'Parameter zurücksetzen';
$_lang["tmplvars_type"] = 'Eingabetyp';
$_lang["tmplvars_widget"] = 'Objektauswahl';
$_lang["tmplvars_widget_prop"] = 'Objekt Eigenschaften';
$_lang["to"] = 'bis';
$_lang["tools"] = 'Werkzeuge';
$_lang["top_howmany_message"] = 'Die Länge der Top Liste. Zum Beispiel: Top 10 Liste.';
$_lang["top_howmany_title"] = 'Top Liste';
$_lang["total"] = 'insgesamt';
$_lang["track_visitors_message"] = 'Die Protokollierung der Besucher ermöglicht die Erstellung einer Besucherstatistik, es verlangsamt allerdings die Darstellung der Seite ein wenig .';
$_lang["track_visitors_title"] = 'Besucherprotokollierung';
$_lang["tree_show_protected"] = 'Zeige geschützte Ressourcen';
$_lang["tree_show_protected_message"] = 'Wenn auf „Nein“ gesetzt, erscheinen geschützte Ressourcen (inklusive der Unter-Ressourcen) nicht im Strukturbaum, das heißt Manager-Benutzer ohne Berechtigung diese Ressourcen zu bearbeiten sehen sie nicht. „Nein“ ist die Standardeinstellung.';
$_lang["truncate_table"] = 'Klicken Sie hier, um die Tabelle zu schließen';
$_lang["tuesday"] = 'Dienstag';
$_lang["tv"] = 'TV';
$_lang["type"] = 'Typ';
$_lang["udperms_allowroot_message"] = 'Möchten Sie Ihren Benutzern die Erstellung von Ressourcen im Hauptverzeichnis der Seite erlauben? ';
$_lang["udperms_allowroot_title"] = 'Hauptverzeichnis-Erlaubnis:';
$_lang["udperms_message"] = 'Die Zugriffskontrolle erlaubt Ihnen festzulegen, welche Seiten von welchem Benutzer bearbeitet werden können. Diese Funktion ist noch in Arbeit und ziemlich fehlerbehaftet. Aus diesem Grund ist dies Option deaktiviert.';
$_lang["udperms_title"] = 'Benutzerzugriffskontrolle:';
$_lang["unable_set_link"] = 'Der Link konnte nicht gesetzt werden!';
$_lang["unable_set_parent"] = 'Setzen des neuen Containers nicht möglich!';
$_lang["unauthorizedpage_message"] = 'Geben Sie die ID der Ressource an, zu welchem Benutzer bei einem unautorisierten Zugriff weitergeleitet werden. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist!';
$_lang["unauthorizedpage_title"] = 'unautorisierter Zugriff:';
$_lang["unblock_message"] = 'Dieser Benutzer wird freigeschaltet sein, nachdem Sie die Benutzerdaten gespeichert haben.';
$_lang["undelete_resource"] = 'Wiederherstellen';
$_lang["unpublish_date"] = 'Termin zum Zurückziehen';
$_lang["unpublish_events"] = 'Zurückziehungen';
$_lang["unpublish_resource"] = 'Zurückziehen';
$_lang["untitled_resource"] = 'Unbenannte Ressource';
$_lang["untitled_weblink"] = 'Unbenannter Web-Link';
$_lang["update_params"] = 'Parameteranzeige aktualisieren';
$_lang["update_settings_from_language"] = 'Aktuelle ersetzen durch:';
$_lang["upload_maxsize_message"] = 'Geben Sie hier die maximale Dateigröße für den Datei-Upload mit dem Datei-Manager an. Die Größenangabe ist in Bytes. <b>Achtung: je größer die Datei desto länger dauert der Upload!</b>';
$_lang["upload_maxsize_title"] = 'Maximale Upload-Größe:';
$_lang["uploadable_files_message"] = 'Hier können Sie angeben welche Dateitypen über den Filemanager hochgeladen werden können. Bitte geben Sie die Dateierweiterungen mit Komma getrennt ein.';
$_lang["uploadable_files_title"] = 'Hochladbare Dateitypen:';
$_lang["uploadable_flash_message"] = 'Datei-Upload nach „assets/flash/“ mit dem Datei-Browser. Mehrere Dateien bitte mit Komma trennen.';
$_lang["uploadable_flash_title"] = 'Hochladbare Flash-Dateien:';
$_lang["uploadable_images_message"] = 'Bilder-Upload nach „assets/images/“ mit dem Datei-Browser. Mehrere Dateien bitte mit Komma trennen.';
$_lang["uploadable_images_title"] = 'Hochladbare Bildformate:';
$_lang["uploadable_media_message"] = 'Medien-Upload nach „assets/media/“ mit dem Datei-Browser. Mehrere Dateien bitte mit Komma trennen.';
$_lang["uploadable_media_title"] = 'Hochladbare Medien-Formate:';
$_lang["use_alias_path_message"] = 'Wenn Sie diese Option mit „Ja“ einstellen, werden Ihre Ressourcen mit den vollen Pfadangaben angezeigt, falls Ihre Ressourcen ein Alias eingetragen haben. Beispiel: Eine Ressource mit dem Alias „Kind“ ist innerhalb des Containers mit dem Alias „Eltern“ abgelegt. Die URL für diese Ressource würde nun http://beispiel.de/Eltern/Kind.html lauten.';
$_lang["use_alias_path_title"] = 'Benutze benutzerfreundliche Alias-Pfadangaben:';
$_lang["use_editor_message"] = 'Möchten Sie den Rich-Text-Editor benutzen? Wenn Sie HTML schreiben möchten, deaktivieren Sie diese Einstellung. Diese Einstellung gilt für alle Benutzer und Ressourcen.';
$_lang["use_editor_title"] = 'Editor aktivieren:';
$_lang["user"] = 'Benutzer';
$_lang["user_block"] = 'Deaktiviert';
$_lang["user_blockedafter"] = 'Gesperrt ab';
$_lang["user_blockeduntil"] = 'Gesperrt bis';
$_lang["user_changeddata"] = 'Ihre Daten wurden geändert. Bitte melden Sie sich erneut an.';
$_lang["user_country"] = 'Land';
$_lang["user_dob"] = 'Geburtsdatum';
$_lang["user_doesnt_exist"] = 'Benutzer existiert nicht.';
$_lang["user_edit_self_msg"] = 'Eventuell müssen Sie sich ab- und wieder anmelden, nachdem Sie Ihre Daten geädert haben.';
$_lang["user_email"] = 'E-Mail-Adresse';
$_lang["user_failedlogincount"] = 'Fehlgeschlagene Anmeldungen';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'weiblich';
$_lang["user_full_name"] = 'Name';
$_lang["user_gender"] = 'Geschlecht';
$_lang["user_is_blocked"] = 'Dieser Benutzer ist deaktiviert!';
$_lang["user_logincount"] = 'Anzahl der Anmeldungen';
$_lang["user_male"] = 'männlich';
$_lang["user_management_msg"] = 'Hier können Sie einen Benutzer zur Bearbeitung auswählen.';
$_lang["user_management_title"] = 'Manager-Benutzer';
$_lang["user_mobile"] = 'Handynummer';
$_lang["user_phone"] = 'Telefonnummer';
$_lang["user_photo"] = 'Benutzerfoto';
$_lang["user_photo_message"] = 'Geben Sie wahlweise eine URL an oder einen lokalen Pfad für Datei-Upload an.';
$_lang["user_prevlogin"] = 'Letzte Anmeldung';
$_lang["user_role"] = 'Benutzerrolle';
$_lang["user_state"] = 'Region';
$_lang["user_title"] = 'Benutzer erstellen/bearbeiten';
$_lang["user_upload_message"] = 'Wenn Sie diesem Benutzer das Hochladen jeglicher Dateitypen untersagen wollen, stellen Sie sicher, dass die „Einstellungen der Systemkonfiguration benutzen“-Checkbox nicht ausgewählt ist und lassen Sie das Feld leer.';
$_lang["user_use_config"] = 'Einstellungen der Systemkonfiguration benutzen';
$_lang["user_zip"] = 'PLZ';
$_lang["username"] = 'Benutzername';
$_lang["users"] = 'Sicherheit';
$_lang["validate_referer_message"] = 'Die HTTP_REFERER-Header können überprüft werden um das Risiko zu verringern, dass Inhaltsredakteure Opfer eines CSRF-Angriffs (Cross Site Request Forgery) werden und unbeabsichtigte Aktionen im Manager durchführen. Einige Konfigurationen unterstützen diese Option nicht, wenn der Server keine HTTP_REFERER-Header sendet.';
$_lang["validate_referer_title"] = 'HTTP_REFERER-Header überprüfen?';
$_lang["value"] = 'Wert';
$_lang["version_codename"] = 'Versions-Codename';
$_lang["view"] = 'Ansehen';
$_lang["view_child_resources_in_container"] = 'Ressourcen in Container anzeigen';
$_lang["view_log"] = 'Protokoll anzeigen';
$_lang["view_logging"] = 'Benutzerprotokoll';
$_lang["view_sysinfo"] = 'Systeminfo';
$_lang["warning"] = 'Warnung!';
$_lang["warning_not_saved"] = 'Die Änderungen an Ihrer Ressource wurden bis jetzt nicht gespeichert. Sie können zur vorherigen Ansicht zurück wechseln oder die Ansicht verlassen. Ihre geänderten Daten gehen dann verloren.';
$_lang["web_access_permissions"] = 'Web-Benutzer-Zugriffsberechtigungen';
$_lang["web_access_permissions_user_groups"] = 'Web-Benutzergruppen';
$_lang["web_permissions"] = 'Web-Berechtigungen';
$_lang["web_user_management_msg"] = 'Hier können Sie auswählen, welche Web-Benutzer Sie bearbeiten möchten. Web-Benutzer können sich nur an der Website anmelden, nicht jedoch im MODx-Manager.';
$_lang["web_user_management_title"] = 'Web-Benutzer';
$_lang["web_user_title"] = 'Web-Benutzer erstellen/bearbeiten';
$_lang["web_users"] = 'Web-Benutzer';
$_lang["weblink"] = 'Web-Link';
$_lang["weblink_message"] = 'Ein Web-Link ist eine Referenz zu einem Objekt im Internet. Dies kann eine Ressource in MODx, ein Link auf eine andere Seite, ein Bild oder eine andere Datei im Web sein.';
$_lang["webpwdreminder_message"] = 'Definieren Sie hier die Vorlage der E-Mail, die Ihre Web-Benutzer erhalten wenn sie ein neues Passwort anfordern. Folgende Platzhalter werden vom System ersetzt, wenn die Nachricht versendet wird:<br /><br />[+sname+] – Name dieser Website<br />[+saddr+] – E-Mail-Adresse des Website Verwalters<br />[+surl+] – URL der Website<br />[+uid+] – Name des Benutzerkontos<br />[+pwd+] – Passwort des Benutzerkontos<br />[+ufn+] – Name des Benutzers<br /><br /><b>Hinweis:</b>Sie sollten auf jeden Fall [+uid+] und [+pwd+] in der Vorlage anführen, damit Ihre Web-Benutzer auch die entsprechenden Anmeldedaten erhalten!';
$_lang["webpwdreminder_title"] = 'Erinnerungs-E-Mail:';
$_lang["websignupemail_message"] = 'Hier können Sie die Nachricht definieren, die an Ihre Benutzer geschickt wird, wenn sie sich anmelden. Folgende Platzhalter werden vom System ersetzt, wenn die Nachricht versendet wird:<br /><br />[+sname+] – Name dieser Website<br />[+saddr+] – E-Mail-Adresse des Website Verwalters<br />[+surl+] – URL der Website<br />[+uid+] – Name des Benutzerkontos<br />[+pwd+] – Passwort des Benutzerkontos<br />[+ufn+] – Name des Benutzers<br /><br /><b>Hinweis:</b> Sie sollten auf jedenfall [+uid+] und [+pwd+] in der Vorlage anführen, damit Ihre Web-Benutzer auch die entsprechenden Anmeldedaten erhalten!';
$_lang["websignupemail_title"] = 'Registrierungsbestätigung:';
$_lang["wednesday"] = 'Mittwoch';
$_lang["welcome_messages"] = 'Ihr Posteingang enthält <b>%d</b> Nachricht(en). <b>%s</b> davon sind ungelesen.';
$_lang["welcome_title"] = 'Willkommen bei MODx';
$_lang["which_editor_message"] = 'Hier legen Sie fest welchen Rich-Text-Editor Sie verwenden wollen.';
$_lang["which_editor_title"] = 'Eingesetzter Editor:';
$_lang["working"] = 'Arbeite …';
$_lang["wrap_lines"] = 'Automatischer Zeilenumbruch';
$_lang["xhtml_urls_message"] = 'Ersetzt „&amp;“-Zeichen in URLs, die von MODx erzeugt werden mit validen &<!-- -->amp; HTML-Entities.';
$_lang["xhtml_urls_title"] = 'XHTML-URLs';
$_lang["yes"] = 'Ja';
$_lang["you_got_mail"] = 'Sie haben eine E-Mail erhalten';
$_lang["yourinfo_message"] = 'Dieser Bereich zeigt Ihnen einige Informationen über Sie:';
$_lang["yourinfo_previous_login"] = 'Ihre letzte Anmeldung:';
$_lang["yourinfo_role"] = 'Ihre Rolle ist:';
$_lang["yourinfo_title"] = 'Ihre Informationen';
$_lang["yourinfo_total_logins"] = 'Anzahl der Anmeldungen:';
$_lang["yourinfo_username"] = 'Sie sind angemeldet als:';
?>