<?php
/**
 * Filename:       includes/lang/english.inc.php
 * Function:       Language file.
 * Encoding:       UTF8
 * Author:         The MODx Project Team
 * Date:           1 October 2009
 * Version:        2.0.4
 * MODx version:   Evolution 1.0.1
*/
//$modx_textdir = 'rtl'; // uncomment this line for RTL langauges
$modx_lang_attribute = 'en'; // Manager HTML/XML Language Attribute see http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'UTF-8';

$_lang["about_msg"] = 'MODx is a <a href="http://modxcms.com/what-is-modx.html" target="_blank">PHP Application Framework and Content Management System</a> licensed under the <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'About MODx';
$_lang["access_permission_denied"] = 'You do not have the correct permissions for this Resource.';
$_lang["access_permission_parent_denied"] = 'You do not have permission to create or move a Resource here! Please choose another location.';
$_lang["access_permissions"] = 'Access permissions';
$_lang["access_permissions_add_resource_group"] = 'Create a new Resource Group';
$_lang["access_permissions_add_user_group"] = 'Create a new User Group';
$_lang["access_permissions_docs_collision"] = 'Because the Web User Groups and Manager User Groups conflict for your Role, this Resource will be public. Contact a site administrator for further help.';
$_lang["access_permissions_docs_message"] = 'Select which Resource Groups this Resource belongs to';
$_lang["access_permissions_group_link"] = 'Create a new group link';
$_lang["access_permissions_introtext"] = 'Manage the User Groups and Resource Groups used for access permissions. To add a user to a User Group, edit the user and select the groups (s)he should be a member of. To add a Resource to a User Group, edit the Resource and select the groups it should belong to.';
$_lang["access_permissions_link_to_group"] = 'to Resource Group';
$_lang["access_permissions_link_user_group"] = 'Link User Group';
$_lang["access_permissions_links"] = 'User/Resource Group links';
$_lang["access_permissions_links_tab"] = 'Specify which User Groups are given access (i.e. can edit or create children) to the Resource Groups. To link a Resource Group to a User Group, select the appropriate groups from the drop down menus, and click on \'Submit\'. To remove the link for a certain group, press \'Remove\'. This will immediately remove the link.';
$_lang["access_permissions_no_resources_in_group"] = 'None.';
$_lang["access_permissions_no_users_in_group"] = 'None.';
$_lang["access_permissions_off"] = '<span class="warning">Access Permissions are not activated.</span> This means any changes made here will not have any effect until Access Permissions are activated in your Configuration.';
$_lang["access_permissions_resource_groups"] = 'Resource Groups';
$_lang["access_permissions_resources_in_group"] = '<b>Resources in group:</b> ';
$_lang["access_permissions_resources_tab"] = 'See which Resource Groups have been created. Also create new groups, rename groups, delete groups and see which Resources are in the different groups (hover over the id of the Resource to see it\'s name). To add a Resource to a group or remove a Resource from a group, edit the Resource directly.';
$_lang["access_permissions_user_groups"] = 'User groups';
$_lang["access_permissions_user_message"] = 'Select which User Groups this user belongs to:';
$_lang["access_permissions_users_in_group"] = 'Users in group:';
$_lang["access_permissions_users_tab"] = 'View the User Groups that have been created. You can also create new groups, rename groups, delete groups and see which users are members of the different groups. To add a new user to a group or to remove a user from a group, edit the user directly. Administrators (users who have been assigned the role with ID 1) always have access to all Resources, so they don\'t need to be added to any groups.';
$_lang["account_email"] = 'Account email';
$_lang["actioncomplete"] = '<b>Action was completed successfully!</b><br /> - Please wait while MODx cleans up.';
$_lang["activity_message"] = 'This list shows the last Resources you created or edited:';
$_lang["activity_title"] = 'Recently edited/created Resources';
$_lang["add"] = 'Add';
$_lang["add_chunk"] = 'Add Chunk';
$_lang["add_doc"] = 'Add Resource';
$_lang["add_folder"] = 'New Directory';
$_lang["add_plugin"] = 'Add Plugin';
$_lang["add_resource"] = 'New Resource';
$_lang["add_snippet"] = 'Add Snippet';
$_lang["add_tag"] = 'Add tag';
$_lang["add_template"] = 'Add Template';
$_lang["add_tv"] = 'Add TV';
$_lang["add_weblink"] = 'New Weblink';
$_lang["administrator_role_message"] = 'This role cannot be edited or deleted.';
$_lang["after_saving"] = 'After saving';
$_lang["alert_delete_self"] = 'You can\'t delete yourself!';
$_lang["alias"] = 'URL alias';
$_lang["all_doc_groups"] = 'All Resource Groups (Public)';
$_lang["all_events"] = 'All Events';
$_lang["all_usr_groups"] = 'All User Groups (Public)';
$_lang["allow_mgr_access"] = 'Manager Interface Access';
$_lang["allow_mgr_access_message"] = 'Select this option to enable or disable access to the manager interface. <b>NOTE: If this option is set to no then the user will be redirected to the Manager Login Startup or Site Start web page.</b>';
$_lang["already_deleted"] = 'has already been deleted.';
$_lang["attachment"] = 'Attachment';
$_lang["automatic_alias_message"] = 'Select \'yes\' to have the system automatically generate a URL alias based on the Resource\'s page title when saving.';
$_lang["automatic_alias_title"] = 'Automatically generate URL alias';
$_lang["backup"] = 'Backup';
$_lang["bk_manager"] = 'Backup';
$_lang["block_message"] = 'This user will be blocked after saving the user\'s data!';
$_lang["blocked_minutes_message"] = 'Enter the number of minutes that a user will be blocked for if they reach their maximum number of allowed failed login attempts. Please enter this value as numbers only (no commas, spaces etc.)';
$_lang["blocked_minutes_title"] = 'Blocked Minutes';
$_lang["cache_files_deleted"] = 'The following files were deleted:';
$_lang["cancel"] = 'Cancel';
$_lang["captcha_code"] = 'Security code';
$_lang["captcha_message"] = 'Enable this to strengthen security by requiring users to enter a code which is unreadable by machines (and script-kiddy hacking scripts).';
$_lang["captcha_title"] = 'Use CAPTCHA codes';
$_lang["captcha_words_default"] = 'MODx,Access,Better,BitCode,Chunk,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Oscope,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Tattoo,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote';
$_lang["captcha_words_message"] = 'Enter a list of CAPTCHA words to use if CAPTCHA is enabled. Separate the words with commas. This input field is limited to 255 characters.';
$_lang["captcha_words_title"] = 'CAPTCHA Words';
$_lang["category_heading"] = 'Category';
$_lang["category_msg"] = 'View and edit all Elements grouped by category.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Change name';
$_lang["change_password"] = 'Change Password';
$_lang["change_password_confirm"] = 'Confirm password';
$_lang["change_password_message"] = 'Please enter your new password, and then enter it again to confirm. Your password needs to be between 6 and 15 characters long.';
$_lang["change_password_new"] = 'New password';
$_lang["charset_message"] = 'Select the default character encoding for the [(modx_charset)] system variable. This does not affect the Manager.';
$_lang["charset_title"] = 'Character encoding';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Chunk code (html)';
$_lang["chunk_multiple_id"] = 'Error: Multiple Chunks share the same unique ID.';
$_lang["chunk_no_exist"] = 'Chunk does not exist.';
$_lang["cleaningup"] = 'Cleaning up';
$_lang["clear_log"] = 'Clear log';
$_lang["click_to_context"] = 'Click to access context menu';
$_lang["click_to_edit_title"] = 'Click here to edit this record';
$_lang["click_to_view_details"] = 'Click here to view details';
$_lang["close"] = 'Close';
$_lang["code"] = 'Code';
$_lang["collapse_tree"] = 'Collapse Site Tree';
$_lang["comment"] = 'Comment';
$_lang["configcheck_admin"] = 'Please contact a systems administrator and warn them about this message!';
$_lang["configcheck_cache"] = 'cache directory not writable';
$_lang["configcheck_cache_msg"] = 'MODx cannot write to the cache directory. MODx will still function as expected, but no caching will take place. To solve this, make the /_cache/ directory writable.';
$_lang["configcheck_configinc"] = 'Config file still writable';
$_lang["configcheck_configinc_msg"] = 'Very naughty people could potentially wreak some havoc on your site and everything associated with it. <strong>Really.</strong> Please make your config file  (/manager/includes/config.inc.php) read only!';
$_lang["configcheck_default_msg"] = 'An unspecified warning was found. Which is strange.';
$_lang["configcheck_errorpage_unavailable"] = 'Your site\'s Error page is not available.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'This means that your Error page is not accessible to normal web surfers or does not exist. This can lead to a recursive looping condition and many errors in your site logs. Make sure there are no Webuser Groups assigned to the page.';
$_lang["configcheck_errorpage_unpublished"] = 'Your site\'s Error page is not published or does not exist.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'This means that your Error page is inaccessible to the general public. Publish the page or make sure it is assigned to an existing Resource in your Site Tree in the Tools &gt; Configuration menu.';
$_lang["configcheck_images"] = 'Images directory not writable';
$_lang["configcheck_images_msg"] = 'The images directory isn\'t writable, or doesn\'t exist. This means the Image Manager functions in the editor will not work!';
$_lang["configcheck_installer"] = 'Installer still present';
$_lang["configcheck_installer_msg"] = 'The /install directory contains the installer for MODx. Just imagine what might happen if an evil person finds this folder and runs the installer! They\'d probably not get too far, because they need to enter some user information for the database, but it is still best to remove this folder from your server.';
$_lang["configcheck_lang_difference"] = 'Incorrect number of entries in language file';
$_lang["configcheck_lang_difference_msg"] = 'The currently selected language has a different number of entries than the default language. While not necessarily a problem, this may mean the language file needs to be updated.';
$_lang["configcheck_notok"] = 'One or more configuration details didn\'t check out OK:';
$_lang["configcheck_ok"] = 'Check passed OK - no warnings to report.';
$_lang["configcheck_php_gdzip"] = 'GD and/or Zip PHP extensions not found';
$_lang["configcheck_php_gdzip_msg"] = 'MODx needs the GD and Zip extension enabled for PHP. While MODx will work without them, you will not be able to take full advantage of the built-in File Manager, Image Editor or Captcha for logins.';
$_lang["configcheck_register_globals"] = 'register_globals is set to ON in your php.ini configuration file';
$_lang["configcheck_register_globals_msg"] = 'This configuration makes your site much more susceptible to Cross Site Scripting (XSS) attacks. You should speak to your host about what you can do to disable this setting.';
$_lang["configcheck_title"] = 'Configuration check';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Your site\'s Unauthorized page is not published or does not exist.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'This means that your Unauthorized page is not accessible to normal web surfers or does not exist. This can lead to a recursive looping condition and many errors in your site logs. Make sure there are no Webuser Groups assigned to the page.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'The Unauthorized page defined in the site configuration settings is not published.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'This means that your Unauthorized page is inaccessible to the general public. Publish the page or make sure it is assigned to an existing Resource in your Site Tree in the Tools &gt; Configuration menu.';
$_lang["configcheck_validate_referer"] = 'Security Warning: HTTP Header Validation';
$_lang["configcheck_validate_referer_msg"] = "The configuration setting <strong>Validate HTTP_REFERER headers?</strong> is Off. We recommend turning it On. <a href=\"index.php?a=17\">Go to Configuration options</a><br /><a href=\"javascript:hideHeaderVerificationWarning();\"><em>Don't show this again.</em></a>";
$_lang["configcheck_warning"] = 'Configuration warning: ';
$_lang["configcheck_what"] = 'What does this mean?';
$_lang["confirm_block"] = 'Are you sure you want to block this user?';
$_lang["confirm_delete_eventlog"] = 'Are you sure you want to delete this event log?';
$_lang["confirm_delete_file"] = 'Are you sure you want to delete the file?\n\nThis may stop your site from working properly! Only delete this file if you know for certain what you are doing will not break anything.';
$_lang["confirm_delete_htmlsnippet"] = 'Are you sure you want to delete this Chunk?';
$_lang["confirm_delete_keywords"] = 'Are you sure you want to delete these keywords?';
$_lang["confirm_delete_module"] = 'Are you sure you want to delete this Module?';
$_lang["confirm_delete_plugin"] = 'Are you sure you want to delete this Plugin?';
$_lang["confirm_delete_record"] = 'Are you sure you want to delete the selected record(s)?';
$_lang["confirm_delete_resource"] = 'Are you sure you want to delete this Resource?\nAny children Resources will also be deleted.';
$_lang["confirm_delete_role"] = 'Are you sure you want to delete this role?';
$_lang["confirm_delete_snippet"] = 'Are you sure you want to delete this Snippet?';
$_lang["confirm_delete_tags"] = 'Are you sure you want to delete the selected META tags?';
$_lang["confirm_delete_template"] = 'Are you sure you want to delete this Template?';
$_lang["confirm_delete_tmplvars"] = 'Are you sure you want to remove this Template Variable and all stored values?';
$_lang["confirm_delete_user"] = 'Are you sure you want to delete this User?';
$_lang["confirm_duplicate_record"] = 'Are you sure you want to duplicate this record?';
$_lang["confirm_empty_trash"] = 'This will permanently remove ALL deleted Resources?\n\nProceed?';
$_lang["confirm_load_depends"] = 'Are you sure you want to load the Manage Dependencies screen without saving your modifications?';
$_lang["confirm_name_change"] = 'Changing the user name can affect other applications that are linked to the Content Manager.\n\nAre you sure you want to change this user name?';
$_lang["confirm_publish"] = '\n\nPublishing this Resource now will remove any (un)publishing dates that may have been set. If you wish to set or keep publish or unpublish dates, please choose to \'edit\' the Resource instead.\n\nProceed?';
$_lang["confirm_remove_locks"] = 'Users sometimes close their browser while editing Resources, Templates, Snippets or parsers, possibly leaving the item they were editing in locked state. By pressing OK you can remove ALL locks currently in place.\n\nProceed?';
$_lang["confirm_resource_duplicate"] = 'Are you sure you want to duplicate this Resource? Any item(s) it contains will also be duplicated.';
$_lang["confirm_setting_language_change"] = 'You have modified the default value and will lose the changes. Proceed?';
$_lang["confirm_unblock"] = 'Are you sure you want to unblock this user?';
$_lang["confirm_undelete"] = '\n\nAny children Resources deleted at the same time as this Resource will also be undeleted, but children Resources deleted at an earlier time will still be deleted.';
$_lang["confirm_unpublish"] = '\n\nUn-publishing this Resource now will remove any (un)publishing dates that may have been set. If you wish to set or keep publish or unpublish dates, please choose to \'edit\' the Resource instead.\n\nProceed?';
$_lang["confirm_unzip_file"] = 'Are you sure you want to unzip this file?\n\nExisting files will be overwritten.';
$_lang["could_not_find_user"] = 'Could not find user';
$_lang["create_folder_here"] = 'Create Container here';
$_lang["create_resource_here"] = 'Create Resource here';
$_lang["create_resource_title"] = 'Create Resource';
$_lang["create_weblink_here"] = 'Create Weblink here';
$_lang["createdon"] = 'Creation date';
$_lang["credits"] = 'Credits';
$_lang["credits_shouts_msg"] = '<p>MODx is managed and maintained at <a href="http://modxcms.com/about/" target="_blank">MODxCMS.com</a>.</p>';
$_lang["custom_contenttype_message"] = 'Add custom content types for Resources. To add a new entry, enter the content type in the text box then click the \'Add\' button.';
$_lang["custom_contenttype_title"] = 'Custom content types';
$_lang["database_charset"] = 'Database Charset';
$_lang["database_collation"] = 'Database Collation Charset';
$_lang["database_name"] = 'Database name';
$_lang["database_overhead"] = '<b style="color:#990033;">Note:</b> Overhead is unused space reserved by MySQL. To free up this space, click on the table\'s overhead figure.';
$_lang["database_server"] = 'Database server';
$_lang["database_table_clickbackup"] = 'to backup &amp; download the selected tables';
$_lang["database_table_clickhere"] = 'Click here';
$_lang["database_table_datasize"] = 'Data size';
$_lang["database_table_droptablestatements"] = 'Generate DROP TABLE statements.';
$_lang["database_table_effectivesize"] = 'Effective size';
$_lang["database_table_indexsize"] = 'Index size';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Records';
$_lang["database_table_tablename"] = 'Table name';
$_lang["database_table_totals"] = 'Totals';
$_lang["database_table_totalsize"] = 'Total size';
$_lang["database_tables"] = 'Database tables';
$_lang["database_version"] = 'Database Version';
$_lang["date"] = 'Date';
$_lang["datechanged"] = 'Date changed';
$_lang["datepicker_offset"] = 'Datepicker offset';
$_lang["datepicker_offset_message"] = 'The number of years to show in the past on the datepicker.';
$_lang["datetime_format"] = 'Date format';
$_lang["datetime_format_message"] = 'The format for dates in the Manager.';
$_lang["default"] = 'Default:'; 
$_lang["defaultcache_message"] = 'Select \'Yes\' to make all new Resources cacheable by default.';
$_lang["defaultcache_title"] = 'Cacheable default';
$_lang["defaultmenuindex_message"] = 'Select \'Yes\' to turn on automatic menu index incrementing by default.';
$_lang["defaultmenuindex_title"] = 'Menu indexing default';
$_lang["defaultpublish_message"] = 'Select \'Yes\' to make all new Resources published by default.';
$_lang["defaultpublish_title"] = 'Published default';
$_lang["defaultsearch_message"] = 'Select \'Yes\' to make all new Resources searchable by default.';
$_lang["defaultsearch_title"] = 'Searchable default';
$_lang["defaulttemplate_message"] = 'Select the default Template you wish to use for new Resources. You can still select a different Template in the Resource editor, this setting just pre-selects one of your Templates for you.';
$_lang["defaulttemplate_title"] = 'Default Template';
$_lang["delete"] = 'Delete';
$_lang["delete_resource"] = 'Delete Resource';
$_lang["delete_tags"] = 'Delete tags';
$_lang["deleting_file"] = 'Deleting file `%s`: ';
$_lang["description"] = 'Description';
$_lang["deselect_keywords"] = 'Clear keywords';
$_lang["deselect_metatags"] = 'Clear META tags';
$_lang["disabled"] = 'Disabled';
$_lang["doc_data_title"] = 'View Resource data';
$_lang["duplicate"] = 'Duplicate';
$_lang["duplicate_alias_found"] = 'Resource \'%s\' is already using the URL alias \'%s\'. Please enter a unique URL alias.';
$_lang["duplicate_alias_message"] = 'Select \'yes\' to allow duplicate URL aliases to be saved. <b>NOTE: This option should be used with \'Friendly URL alias path\' option set to \'Yes\' in order to avoid problems when referencing a Resource.</b>';
$_lang["duplicate_alias_title"] = 'Allow duplicate URL aliases';
$_lang["duplicate_name_found_general"] = 'There is already a %s named \'%s\'. Please enter a unique name.';
$_lang["duplicate_name_found_module"] = 'There is already a Module named \'%s\'. Please enter a unique name.';
$_lang["edit"] = 'Edit';
$_lang["edit_resource"] = 'Edit Resource';
$_lang["edit_resource_title"] = 'Edit Resource';
$_lang["edit_settings"] = 'Configuration';
$_lang["editedon"] = 'Edit date';
$_lang["editing_file"] = 'Editing file: ';
$_lang["editor_css_path_message"] = 'Enter the path to your CSS file that you wish to use within the editor. The best way to enter the path is to enter the path from the root of your server, for example: /assets/site/style.css. If you do not wish to load a style sheet into the editor, leave this field blank.';
$_lang["editor_css_path_title"] = 'Path to CSS file';
$_lang["element"] = 'Element';
$_lang["element_categories"] = 'Combined View';
$_lang["element_management"] = 'Manage Elements';
$_lang["element_name"] = 'Element name';
$_lang["element_selector_msg"] = 'Select the Elements(s) from the list below and click the \'Insert\' button.';
$_lang["element_selector_title"] = 'Element Selector';
$_lang["elements"] = 'Elements';
$_lang["email"] = 'Email';
$_lang["email_sent"] = 'Email sent';
$_lang["emailsender_message"] = 'Specify the e-mail address used when sending users their usernames and passwords.';
$_lang["emailsender_title"] = 'E-mail address';
$_lang["emailsubject_default"] = 'Your login details';
$_lang["emailsubject_message"] = 'Specify the value of the subject of the signup e-mail.';
$_lang["emailsubject_title"] = 'E-mail subject';
$_lang["empty_folder"] = 'This Container is empty';
$_lang["empty_recycle_bin"] = 'Purge deleted Resources';
$_lang["empty_recycle_bin_empty"] = 'There are no deleted Resources to purge.';
$_lang["enable_resource"] = 'Enable Element file.';
$_lang["enable_sharedparams"] = 'Enable parameter sharing';
$_lang["enable_sharedparams_msg"] = '<b>NOTE:</b> The above globally unique id (GUID) will be used to uniquely identify this Module and it\'s shared parameters. The GUID is also used to form a link between the Module and the Plugins or Snippets accessing the it\'s shared parameters. ';
$_lang["enabled"] = 'Enabled';
$_lang["error"] = 'Error';
$_lang["error_sending_email"] = 'Error sending email';
$_lang["errorpage_message"] = 'Enter a published and publicly accessible Resource ID to redirect users to when requesting a non-existing Resource.';
$_lang["errorpage_title"] = 'Error page';
$_lang["event_id"] = 'Event Id';
$_lang["eventlog"] = 'Event log';
$_lang["eventlog_msg"] = 'The event log is used to display information, warning and error messages generated by the content manager. The \'source\' column shows the section of the content manager where the message occurred.';
$_lang["eventlog_viewer"] = 'System Events';
$_lang["existing_category"] = 'Existing Category';
$_lang["expand_tree"] = 'Expand Site Tree';
$_lang["export_site"] = 'Export Static HTML';
$_lang["export_site_cacheable"] = 'Include non-cacheable files:';
$_lang["export_site_exporting_document"] = 'Exporting file <b>%s</b> of <b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = 'Failed!';
$_lang["export_site_failed_no_open"] = 'Cannot open file: ';
$_lang["export_site_failed_no_retrieve"] = 'Cannot retrieve document.';
$_lang["export_site_failed_no_write"] = 'Cannot write file.';
$_lang["export_site_html"] = 'Export site to HTML';
$_lang["export_site_maxtime"] = 'Max export time:';
$_lang["export_site_maxtime_message"] = 'Specify the number of seconds MODx can take to export the site (overriding PHP settings). Enter 0 for unlimited time. Please note, setting 0 or a really high number can do weird things to your server and is not recommended.';
$_lang["export_site_message"] = '<p>Use this to export the entire site to static HTML files. Please note, however, that you will lose a lot of the MODx functionality should you do so:</p><ul><li>Page reads on the exported files will not be recorded.</li><li>Interactive Snippets will NOT work in exported files</li><li>Only regular Resources will be exported, Weblinks will not be exported.</li><li>The export process may fail if your Resources contain Snippets which send redirection headers.</li><li>Depending on how you\'ve written your Resources, style sheets and images, the design of your site may be broken. To fix this, save/move your exported files to the same directory where the main MODx index.php file is located.</li></ul><p>Please fill out the form and press \'Export\' to start the export process. The files created will be saved in the /assets/export directory, using the Resources\' URL aliases as filenames when possible. While exporting your site, it\'s best to have the MODx configuration item \'Friendly URL aliases\' set to \'yes\'. Depending on the size of your site, the export may take a while.</p><p><em>Any existing files will be overwritten by the new files if their names are identical!</em></p>';
$_lang["export_site_numberdocs"] = '<p><b>Found %s Resources to export...</b></p>';
$_lang["export_site_prefix"] = 'File prefix:';
$_lang["export_site_start"] = 'Start export';
$_lang["export_site_success"] = 'Success!';
$_lang["export_site_success_skip_dir"] = 'Skip this directory.';
$_lang["export_site_success_skip_doc"] = 'Skip this document.';
$_lang["export_site_suffix"] = 'File suffix:';
$_lang["export_site_target_unwritable"] = 'Target directory isn\'t writable. Please ensure the directory is writable, and try again.';
$_lang["export_site_time"] = 'Export finished. Export took %s seconds to complete.';
$_lang["failed_login_message"] = 'Enter the number of failed login attempts allowed before blocking a user.';
$_lang["failed_login_title"] = 'Failed Login Attempts';
$_lang["fe_editor_lang_message"] = 'Choose a language for the editor to use when used as a front-end editor.';
$_lang["fe_editor_lang_title"] = 'Front-end Editor Language';
$_lang["file_delete_file"] = 'Delete file';
$_lang["file_delete_folder"] = 'Delete directory';
$_lang["file_deleted"] = 'Success!';
$_lang["file_download_file"] = 'Download File';
$_lang["file_download_unzip"] = 'Unzip File';
$_lang["file_folder_chmod_error"] = 'Unable to change permissions, you will need to change permissions outside of MODx.';
$_lang["file_folder_created"] = 'Directory created successfully!';
$_lang["file_folder_deleted"] = 'Directory was successfully deleted!';
$_lang["file_folder_not_created"] = 'Unable to create directory';
$_lang["file_folder_not_deleted"] = 'Unable to delete directory. Make sure it is empty before deleting.';
$_lang["file_not_deleted"] = 'Failed!';
$_lang["file_not_saved"] = 'Cannot save file, please ensure target directory is writable!';
$_lang["file_saved"] = 'File updated successfully!';
$_lang["file_unzip"] = 'Unzip was successful!';
$_lang["file_unzip_fail"] = 'Unzip Failed!';
$_lang["filemanager_path_message"] = 'IIS often does not populate the document_root setting properly, which is used by the file manager to determine what you can see. If you are having problems using the file manager, make sure this path points to the root of your MODx installation.';
$_lang["filemanager_path_title"] = 'File Manager path';
$_lang["files_access_denied"] = 'Access denied!';
$_lang["files_data"] = 'Data';
$_lang["files_dir_listing"] = 'Directory listing for:';
$_lang["files_directories"] = 'Directories';
$_lang["files_dirwritable"] = 'Directory writable?';
$_lang["files_editfile"] = 'Edit file';
$_lang["files_file_type"] = 'File type: ';
$_lang["files_filename"] = 'Filename';
$_lang["files_fileoptions"] = 'Options';
$_lang["files_files"] = 'Files';
$_lang["files_filesize"] = 'File size';
$_lang["files_filetype_notok"] = 'Uploading of this kind of file is not allowed!';
$_lang["files_modified"] = 'Modified';
$_lang["files_top_level"] = 'To top level';
$_lang["files_up_level"] = 'Up one level';
$_lang["files_upload_copyfailed"] = 'Failed to copy file to destination directory - upload failed!';
$_lang["files_upload_error"] = 'Error';
$_lang["files_upload_error0"] = 'There was a problem with your upload.';
$_lang["files_upload_error1"] = 'The file you are trying to upload is too big.';
$_lang["files_upload_error2"] = 'The file you are trying to upload is too big.';
$_lang["files_upload_error3"] = 'The file you are trying upload was only partially uploaded.';
$_lang["files_upload_error4"] = 'You must select a file for upload.';
$_lang["files_upload_error5"] = 'There was a problem with your upload.';
$_lang["files_upload_inhibited_msg"] = '<b>Upload feature inhibited</b> - make sure uploads are supported and the directory is writable for PHP.';
$_lang["files_upload_ok"] = 'File uploaded successfully!';
$_lang["files_upload_permissions_error"] = 'Possible permission problems - the directory you want to upload to needs to be writable by your webserver.';
$_lang["files_uploadfile"] = 'Upload file';
$_lang["files_uploadfile_msg"] = 'Select a file to upload:';
$_lang["files_uploading"] = 'Uploading <b>%s</b> to <b>%s/</b>';
$_lang["files_viewfile"] = 'View file';
$_lang["folder"] = 'Folder';
$_lang["forgot_password_email_fine_print"] = '* The URL above will expire once you change your password or after today.';
$_lang["forgot_password_email_instructions"] = 'From there you will be able to change your password from the My Account menu.';
$_lang["forgot_password_email_intro"] = 'A request has been made to change the password on your account.';
$_lang["forgot_password_email_link"] = 'Click here to complete the process.';
$_lang["forgot_your_password"] = 'Forgot your password?';
$_lang["friday"] = 'Friday';
$_lang["friendly_alias_message"] = 'With Friendly URLs enabled, a Resource URL alias will be used when present instead of the Resource ID. E.g., if a Resource with ID 1 has an URL alias of "introduction", no prefix set (empty) and a suffix of ".html", enabling this option would generate an URL alias of  "introduction.html". If there is no URL alias set, MODx generates "1.html".';
$_lang["friendly_alias_title"] = 'Use Friendly URL aliases';
$_lang["friendlyurls_message"] = 'Use Search Engine Friendly URLs on Apache webservers with mod_rewrite or IIS with third-party plugins. See the .htaccess file in the site root of the distribution for more info.';
$_lang["friendlyurls_title"] = 'Use FriendlyURLs';
$_lang["friendlyurlsprefix_message"] = 'A prefix setting of "page" will turn the URL /index.php?id=2 to the URL alias "page2.html" (assuming the suffix is set to .html).';
$_lang["friendlyurlsprefix_title"] = 'Friendly URL Prefix';
$_lang["friendlyurlsuffix_message"] = 'Any suffix you choose will work, including no suffix at all. E.g., ".aspx" will append .aspx to all URL aliases.';
$_lang["friendlyurlsuffix_title"] = 'Friendly URL Suffix';
$_lang["functionnotimpl"] = 'Sorry!';
$_lang["functionnotimpl_message"] = 'This function has not been implemented yet.';
$_lang["go"] = 'Go';
$_lang["group_access_permissions"] = 'User group access';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Help';
$_lang["help_msg"] = '<p>You can obtain free community support by <a href="http://modxcms.com/forums" target="_blank">visiting the MODx Forums</a>. There is also a growing body of <a href="http://modxcms.com/documentation" target="_blank">MODx Documentation and Guides</a> that touch on virtually every aspect of MODx.</p><p>We are planning to offer commercial support services for MODx as well. Please <a href="mailto:hello@modxcms.com?subject=MODx Commercial Support Inquiry">email us if you\'re interested</a>.</p>';
$_lang["help_title"] = 'Help';
$_lang["hide_tree"] = 'Hide Site Tree';
$_lang["home"] = 'Home';
$_lang["htmlsnippet_desc"] = 'Description';
$_lang["htmlsnippet_management_msg"] = 'Select the Chunk you wish to edit.';
$_lang["htmlsnippet_msg"] = 'Add and edit Chunks. Remember, Chunks are \'raw\' HTML code, so any PHP code won\'t be processed.';
$_lang["htmlsnippet_name"] = 'Chunk name';
$_lang["htmlsnippet_title"] = 'Create/edit Chunk';
$_lang["icon"] = 'Icon';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Parent Assignment:\n\nResource is a child of the selected Resource.';
$_lang["illegal_parent_self"] = 'Parent Assignment:\n\nThe selected Resource cannot be assigned to itself.';
$_lang["import_files_found"] = '<b>Found %s Resources for import...</b><p />';
$_lang["import_params"] = 'Import Module shared parameters';
$_lang["import_params_msg"] = 'You can import the parameters or settings of a Module by selecting the name of the Module from the above drop down menu. <b>NOTE:</b> In order for Modules to appear inside the menu, this Plugin/Snippet must be a part of the Module\'s dependency listing and the Module must have parameter sharing enabled. ';
$_lang["import_parent_resource"] = 'Parent Resource:';
$_lang["import_site"] = 'Import HTML';
$_lang["import_site_failed"] = 'Failed!';
$_lang["import_site_failed_db_error"] = 'A database error occured while trying to clone Resource: ';
$_lang["import_site_failed_no_open_dir"] = 'Could not open directory: ';
$_lang["import_site_failed_no_retrieve_file"] = 'Could not retrieve file: ';
$_lang["import_site_html"] = 'Import site from HTML';
$_lang["import_site_importing_document"] = 'Importing file <b>%s</b> ';
$_lang["import_site_maxtime"] = 'Max import time:';
$_lang["import_site_maxtime_message"] = 'Specify the number of seconds allowed for the Content Manager to import the site (overriding PHP settings). Enter 0 for unlimited time. Please note, setting 0 or a really high number can do weird things to your server and is not recommended.';
$_lang["import_site_message"] = '<p>Import an entire HTML site into your site database. Please note that you will need to copy your html files and/or folders into the /assets/import directory.</p><p>Please fill out the form and press \'Import\' to start the import process. The files imported will be saved into the selected location, using the files name as the Resource\'s URL aliases where possible, and the Resource title tag as the pagetitle.';
$_lang["import_site_skip"] = 'Skipped!';
$_lang["import_site_start"] = 'Start Import';
$_lang["import_site_success"] = 'Success!';
$_lang["import_site_time"] = 'Import finished. Import took %s seconds to complete.';
$_lang["inbox"] = 'Inbox';
$_lang["info"] = 'Info';
$_lang["information"] = 'Information';
$_lang["inline"] = 'Inline';
$_lang["insert"] = 'Insert';
$_lang["keyword"] = 'Keyword';
$_lang["keywords"] = 'Keywords';
$_lang["keywords_intro"] = 'To edit a keyword, simply type in the new keyword in the text field next to the keyword you wish to change. To delete a keyword, check the \'delete\' box for that keyword. If you check the keyword\'s delete box, and also change it\'s name, it will be deleted, and the renaming of the keyword will not take place!';
$_lang["language_message"] = 'Select the language for the MODx Content Manager.';
$_lang["language_title"] = 'Language';
$_lang["launch_site"] = 'View Site';
$_lang["link_attributes"] = 'Link Attributes';
$_lang["link_attributes_help"] = 'Enter optional attributes for a link for this page, such as target=&quot;_blank&quot; or rel=&quot;external&quot;.';
$_lang["list_mode"] = 'Turn on/off list mode - used to list all records in the grid.';
$_lang["loading_doc_tree"] = 'Loading Site Tree...';
$_lang["loading_menu"] = 'Loading menu...';
$_lang["loading_page"] = 'Please wait while MODx loads the page...';
$_lang["localtime"] = 'Local Time';
$_lang["lock_htmlsnippet"] = 'Lock Chunk for editing';
$_lang["lock_htmlsnippet_msg"] = 'Only Administrators (Role ID 1) can edit this Chunk.';
$_lang["lock_module"] = 'Lock Module for editing';
$_lang["lock_module_msg"] = 'Only Administrators (Role ID 1) can edit this Module.';
$_lang["lock_msg"] = '%s is currently editing this %s. Please wait until the other user has finished and try again.';
$_lang["lock_plugin"] = 'Lock Plugin for editing';
$_lang["lock_plugin_msg"] = 'Only Administrators (Role ID 1) can edit this Plugin.';
$_lang["lock_settings_msg"] = '%s is currently editing these settings. Please wait until the other user has finished and try again.';
$_lang["lock_snippet"] = 'Lock Snippet for editing';
$_lang["lock_snippet_msg"] = 'Only Administrators (Role ID 1) can edit this Snippet.';
$_lang["lock_template"] = 'Lock Template for editing';
$_lang["lock_template_msg"] = 'Only Administrators (Role ID 1) can edit this Template.';
$_lang["lock_tmplvars"] = 'Lock Template Variable for editing';
$_lang["lock_tmplvars_msg"] = 'Only Administrators (Role ID 1) can edit this Template Variable.';
$_lang["locked"] = 'Locked';
$_lang["login_allowed_days"] = 'Allowed Days';
$_lang["login_allowed_days_message"] = 'Select the days that this user is allowed to login.';
$_lang["login_allowed_ip"] = 'Allowed IP Address';
$_lang["login_allowed_ip_message"] = 'Enter the IP addresses that this user is allowed to login from. <b>NOTE: Separate multiple IP addresses with a comma (,)</b>';
$_lang["login_button"] = 'Login';
$_lang["login_cancelled_install_in_progress"] = 'Install/update of this site is currently in progress. Please retry in a couple of minutes!';
$_lang["login_cancelled_site_was_updated"] = 'Install/update on this site was executed, please login again!';
$_lang["login_captcha_message"] = 'Please enter the security code shown in the graphic. If you can\'t read the code, click the image to generate a new one or contact your site admin.';
$_lang["login_homepage"] = 'Login Home Page';
$_lang["login_homepage_message"] = 'Enter the ID of the Resource you want to send user to after he/she has logged in. <b>NOTE: make sure the ID you enter belongs to an existing Resource, and that it has been published and is accessible by this user!</b>';
$_lang["login_message"] = 'Please enter your login credentials to start your Manager session. Your username and password are case-sensitive, so please enter them carefully!';
$_lang["logo_slogan"] = 'MODx Content Manager - \nCreate and do more with less';
$_lang["logout"] = 'Logout';
$_lang["long_title"] = 'Long title';
$_lang["mail_check_timeperiod_message"] = 'How often to check for new mail messages in the Manager, in seconds.';
$_lang["mail_check_timeperiod_title"] = 'Mail Check Time Period';
$_lang["manage_depends"] = 'Manage Dependencies';
$_lang["manage_files"] = 'Manage Files';
$_lang["manage_htmlsnippets"] = 'Chunks';
$_lang["manage_metatags"] = 'Manage META tags and Keywords';
$_lang["manage_modules"] = 'Manage Modules';
$_lang["manage_plugins"] = 'Plugins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Templates';
$_lang["manager"] = 'Manager';
$_lang["manager_lockout_message"] = 'You are currently logged into the Content Manager. If you would like to close your login session please click the "Logout" button. <p />To go to your startup or home page click the "Home" button.';
$_lang["manager_permissions"] = 'Manager Permissions';
$_lang["manager_theme"] = 'Manager Theme';
$_lang["manager_theme_message"] = 'Select the Theme for the Content Manager.';
$_lang["messages"] = 'Messages';
$_lang["messages_all"] = 'Everyone';
$_lang["messages_compose"] = 'Compose a message';
$_lang["messages_forward"] = 'Forward';
$_lang["messages_from"] = 'From';
$_lang["messages_group"] = 'A group';
$_lang["messages_inbox"] = 'Inbox';
$_lang["messages_message"] = 'Message';
$_lang["messages_no_messages"] = 'No messages in Inbox.';
$_lang["messages_not_allowed_to_read"] = 'You\'re not allowed to read this message!';
$_lang["messages_private"] = 'Private';
$_lang["messages_read_message"] = 'Read message';
$_lang["messages_reply"] = 'Reply';
$_lang["messages_select_group"] = 'Select a group';
$_lang["messages_select_user"] = 'Select a user';
$_lang["messages_send"] = 'Send';
$_lang["messages_send_to"] = 'Send to';
$_lang["messages_sent"] = 'Sent on';
$_lang["messages_subject"] = 'Subject';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'Messages';
$_lang["messages_user"] = 'A user';
$_lang["meta_keywords"] = 'META Keywords';
$_lang["metatag_intro"] = 'On this page you can delete, create or edit META tags. To link META tags to Resources, click on the <u>META Keywords</u> tab when editing the Resource, and select the desired META tags and keywords. To add a new tag enter the name and value and click the \'Add tag\' button. To edit the tag click on the name of the tag from within the data grid.';
$_lang["metatag_notice"] = 'You may wish to reference the <a href="http://www.html-reference.com/META.asp" target="_blank">HTML Reference Guide</a> site for more information. This is not a complete list of possible Meta Tags.';
$_lang["metatags"] = 'META tags';
$_lang["mgr_access_permissions"] = 'Manager access permissions';
$_lang["mgr_login_start"] = 'Manager Login Startup';
$_lang["mgr_login_start_message"] = 'Enter the ID of the Resource you want to send the user to after he/she has logged into the manager. <b>NOTE: make sure the ID you\'ve enter belongs to an existing Resource, and that it has been published and is accessible by this user!</b>';
$_lang["mgrlog_action"] = 'Action';
$_lang["mgrlog_actionid"] = 'Action ID';
$_lang["mgrlog_anyall"] = 'Any/All';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() returned false.';
$_lang["mgrlog_datefr"] = 'Date from';
$_lang["mgrlog_dateinvalid"] = 'Invalid date format.';
$_lang["mgrlog_dateto"] = 'Date to';
$_lang["mgrlog_emptysrch"] = 'Your search query returned an empty result set (i.e. not matching logs found).';
$_lang["mgrlog_field"] = 'Field';
$_lang["mgrlog_itemid"] = 'Item ID';
$_lang["mgrlog_itemname"] = 'Item name';
$_lang["mgrlog_msg"] = 'Message';
$_lang["mgrlog_noquery"] = 'No search query entered yet.';
$_lang["mgrlog_qresults"] = 'Query results';
$_lang["mgrlog_query"] = 'Query logging';
$_lang["mgrlog_query_msg"] = 'Please make a selection for viewing the logs. You can select log entries by date, but be aware that the dates you enter are not inclusive - to select every log entry for 01-01-2004, set \'date from\' to 01-01-2004 and \'date to\' to 02-01-2004.<br /><br />Message and action are usually the same. If you\'re searching for a specific message, it\'s best to set action to \'Any/All\'.';
$_lang["mgrlog_results"] = 'No. of results';
$_lang["mgrlog_searchlogs"] = 'Search logs';
$_lang["mgrlog_sortinst"] = 'Sort the table by clicking on the column headers. If the logs are too large, <a href="index.php?a=55">empty the log file</a> to remove all log entries up to now. This cannot be undone!';
$_lang["mgrlog_time"] = 'Time';
$_lang["mgrlog_user"] = 'User';
$_lang["mgrlog_username"] = 'Username';
$_lang["mgrlog_value"] = 'Value';
$_lang["mgrlog_view"] = 'View manager logs';
$_lang["module_code"] = 'Module code (php)';
$_lang["module_config"] = 'Module configuration';
$_lang["module_desc"] = 'Description';
$_lang["module_disabled"] = 'Module disabled';
$_lang["module_edit_click_title"] = 'Click here to edit this Module';
$_lang["module_group_access_msg"] = 'Select the User Groups that are allowed to execute this Module from within the Content Manager.';
$_lang["module_management"] = 'Manage Modules';
$_lang["module_management_msg"] = 'Choose the Module you would like to execute or modify. To run the Module click on the icon in the grid. To modify the Module click on the name of the Module.';
$_lang["module_msg"] = 'Add/edit Modules. A Module is a collection of Elements (e.g. Plugins, Snippets, etc).';
$_lang["module_name"] = 'Module name';
$_lang["module_resource_msg"] = 'Add or remove Elements upon which this Module depends. To add a new Element click on the one of the add buttons below.';
$_lang["module_resource_title"] = 'Module Dependencies';
$_lang["module_title"] = 'Create/edit Module';
$_lang["module_viewdepend_msg"] = 'View the assigned Elements on which this Module depends. Click on the "Manager Dependencies" button to modify the dependencies';
$_lang["modules"] = 'Modules';
$_lang["modx_news"] = 'MODx News Notices';
$_lang["modx_news_tab"] = 'MODx News';
$_lang["modx_news_title"] = 'MODx News';
$_lang["modx_security_notices"] = 'MODx Security Notices';
$_lang["modx_version"] = 'MODx version';
$_lang["monday"] = 'Monday';
$_lang["move"] = 'Move';
$_lang["move_resource"] = 'Move Resource';
$_lang["move_resource_message"] = 'Move a Resource and all its children by selecting a new parent in the Site Tree. If you select a Resource that is not already a Container, it will be changed into one. Please click on the new parent in the Site Tree.';
$_lang["move_resource_new_parent"] = 'Please select a new parent in the Site Tree.';
$_lang["move_resource_title"] = 'Move Resource';
$_lang["name"] = 'Name';
$_lang["new_category"] = 'New Category';
$_lang["new_file_permissions_message"] = 'When uploading a new file in the File Manager, the File Manager will attempt to change the file permissions to those entered in this setting. This may not work on some setups, such as IIS, in which case you will need to manually change the permissions.';
$_lang["new_file_permissions_title"] = 'New File Permissions';
$_lang["new_folder_permissions_message"] = 'When creating a new directory in the File Manager, the File Manager will attempt to change the directory permissions to those entered in this setting. This may not work on some setups, such as IIS, in which case you will need to manually change the permissions.';
$_lang["new_folder_permissions_title"] = 'New Directory Permissions';
$_lang["new_htmlsnippet"] = 'New Chunk';
$_lang["new_keyword"] = 'Add new keyword:';
$_lang["new_module"] = 'New Module';
$_lang["new_parent"] = 'New parent';
$_lang["new_plugin"] = 'New Plugin';
$_lang["new_role"] = 'Create a new Role';
$_lang["new_snippet"] = 'New Snippet';
$_lang["new_template"] = 'New Template';
$_lang["new_tmplvars"] = 'New Template Variable';
$_lang["new_user"] = 'New User';
$_lang["new_web_user"] = 'New Web User';
$_lang["no"] = 'No';
$_lang["no_active_users_found"] = 'No active users found.';
$_lang["no_activity_message"] = 'You have not yet created or edited any Resources.';
$_lang["no_category"] = 'uncategorized';
$_lang["no_docs_pending_publishing"] = 'No Resources pending publishing.';
$_lang["no_docs_pending_pubunpub"] = 'No Events Found';
$_lang["no_docs_pending_unpublishing"] = 'No Resources pending unpublishing.';
$_lang["no_edits_creates"] = 'No edits or creates found.';
$_lang["no_groups_found"] = 'No groups found.';
$_lang["no_keywords_found"] = 'There are currently no keywords.';
$_lang["no_records_found"] = 'No records found.';
$_lang["no_results"] = 'No results found';
$_lang["nologentries_message"] = 'Enter the number of log entries shown per page when you browse the Audit trail.';
$_lang["nologentries_title"] = 'Number of log entries';
$_lang["nomessages_message"] = 'Enter the number of messages to show in inbox when viewing messages.';
$_lang["nomessages_title"] = 'Number of messages';
$_lang["none"] = 'None';
$_lang["noresults_message"] = 'Enter the number of results to show in the data grid when viewing listings and search results.';
$_lang["noresults_title"] = 'Number of Results';
$_lang["not_deleted"] = 'has not been deleted.';
$_lang["not_set"] = 'Not set';
$_lang["offline"] = 'Offline';
$_lang["online"] = 'Online';
$_lang["onlineusers_action"] = 'Action';
$_lang["onlineusers_actionid"] = 'Action-ID';
$_lang["onlineusers_ipaddress"] = 'User\'s IP address';
$_lang["onlineusers_lasthit"] = 'Last hit';
$_lang["onlineusers_message"] = 'This list shows all users active within the last 20 minutes (current time is ';
$_lang["onlineusers_title"] = 'Online users';
$_lang["onlineusers_user"] = 'User';
$_lang["onlineusers_userid"] = 'User\'s ID';
$_lang["optimize_table"] = 'Click here to optimize this table';
$_lang["page_data_cacheable"] = 'Cacheable';
$_lang["page_data_cacheable_help"] = 'This allows the Resource to be saved to the site cache, and affects all Snippets on the page.';
$_lang["page_data_cached"] = '<b>Source retrieved from cache:</b>';
$_lang["page_data_changes"] = 'Changes';
$_lang["page_data_contentType"] = 'Internet Media Type';
$_lang["page_data_contentType_help"] = 'Select the content type for this Resource. If you\'re not sure which content type the Resource should have, just leave it as text/html.';
$_lang["page_data_created"] = 'Created';
$_lang["page_data_edited"] = 'Edited';
$_lang["page_data_editor"] = 'Edit using rich text editor';
$_lang["page_data_folder"] = 'Resource is Container';
$_lang["page_data_general"] = 'General';
$_lang["page_data_markup"] = 'Markup/structure';
$_lang["page_data_mgr_access"] = 'Manager access';
$_lang["page_data_notcached"] = 'This Resource has not yet been cached.';
$_lang["page_data_publishdate"] = 'Publish date';
$_lang["page_data_publishdate_help"] = 'If you set a publish date, the Resource will be published as soon as the publish date is reached. Click on the calender icon to select a date, or on the icon next to it to remove the publish date. This will then mean the Resource is never automatically published.';
$_lang["page_data_published"] = 'Published';
$_lang["page_data_searchable"] = 'Searchable';
$_lang["page_data_searchable_help"] = 'Checking this field will allow the Resource to be searched. You can also use this field for other purposes in your Snippets.';
$_lang["page_data_source"] = 'Source';
$_lang["page_data_status"] = 'Status';
$_lang["page_data_template"] = 'Uses Template';
$_lang["page_data_template_help"] = 'Select the Template for this Resource.';
$_lang["page_data_title"] = 'Page data';
$_lang["page_data_unpublishdate"] = 'Un-publish date';
$_lang["page_data_unpublishdate_help"] = 'If you set an unpublish date, the Resource will be unpublished as soon as the unpublish date is reached. Click on the calender icon to select a date, or on the icon next to it to remove the unpublish date. This will then mean the Resource is never automatically unpublished.';
$_lang["page_data_unpublished"] = 'Un-published';
$_lang["page_data_web_access"] = 'Web access';
$_lang["pagetitle"] = 'Resource\'s title';
$_lang["pagination_table_first"] = 'First';
$_lang["pagination_table_gotopage"] = 'Go to page';
$_lang["pagination_table_last"] = 'Last';
$_lang["paging_first"] = 'first';
$_lang["paging_last"] = 'last';
$_lang["paging_next"] = 'next';
$_lang["paging_prev"] = 'prev';
$_lang["paging_showing"] = 'Showing';
$_lang["paging_to"] = 'to';
$_lang["paging_total"] = 'total';
$_lang["parameter"] = 'Parameter';
$_lang["password"] = 'Password';
$_lang["password_change_request"] = 'Password change request';
$_lang["password_gen_gen"] = 'Let MODx generate a password.';
$_lang["password_gen_length"] = 'The password you specify needs to be at least 6 characters long.';
$_lang["password_gen_method"] = 'New password method';
$_lang["password_gen_specify"] = 'Let me specify the password:';
$_lang["password_method"] = 'Password notification method';
$_lang["password_method_email"] = 'Send the new password by e-mail.';
$_lang["password_method_screen"] = 'Show the new password on screen.';
$_lang["password_msg"] = 'The new password for <b>%s</b> is <b>%s</b>.';
$_lang["php_version_check"] = 'MODx is compatible with PHP version 4.0.3 and higher. Please upgrade your PHP installation!';
$_lang["plugin"] = 'Plugin';
$_lang["plugin_code"] = 'Plugin code (php)';
$_lang["plugin_config"] = 'Plugin configuration';
$_lang["plugin_desc"] = 'Description';
$_lang["plugin_disabled"] = 'Plugin Disabled';
$_lang["plugin_event_msg"] = 'Select the events that you would like this Plugin to listen to.';
$_lang["plugin_management_msg"] = 'Choose which Plugin you wish to edit.';
$_lang["plugin_msg"] = 'Add/edit Plugins. Plugins use PHP code that is invoked whenever specific System Events trigger.';
$_lang["plugin_name"] = 'Plugin name';
$_lang["plugin_priority"] = 'Edit Plugin Execution Order by Event';
$_lang["plugin_priority_instructions"] = 'Drag to reorder the Plugins under each Event header. The first plugin to execute should go at the top.';
$_lang["plugin_priority_title"] = 'Plugin Execution Order';
$_lang["plugin_title"] = 'Create/edit Plugin';
$_lang["preview"] = 'Preview';
$_lang["preview_msg"] = 'This is a preview of your last saved changes. Click here to <a href="#" onclick="saveRefreshPreview();">Save and Refresh</a> your current changes';
$_lang["preview_resource"] = 'Preview Resource';
$_lang["private"] = 'Private';
$_lang["public"] = 'Public';
$_lang["publish_date"] = 'Publish Date';
$_lang["publish_events"] = 'Publish Events';
$_lang["publish_resource"] = 'Publish Resource';
$_lang["rb_base_dir_message"] = 'Enter the physical path to the File Browser directory. This setting is usually automatically generated. If you\'re using IIS, however, MODx may not be able to work the path out on its own, causing the File Browser to show an error. In that case, you can enter the path to the images directory here (the path as you\'d see it in Windows Explorer). <b>NOTE:</b> The File Browser directory must contain the subfolders images, files, flash and media in order for the file browser to function correctly.';
$_lang["rb_base_dir_title"] = 'File base path';
$_lang["rb_base_url_message"] = 'Enter the virtual path to files directory. This setting is usually automatically generated. If you\'re using IIS, however, MODx may not be able to work the URL out on it\'s own, causing the File Browser to show an error. In that case, you can enter the URL to the images directory here (the URL as you\'d enter it on Internet Explorer).';
$_lang["rb_base_url_title"] = 'File Browser URL';
$_lang["rb_message"] = 'Select yes to enable the File Browser. This will allow your users to browse and upload files such as images, flash and media files on the server.';
$_lang["rb_title"] = 'Enable File Browser';
$_lang["rb_webuser_message"] = 'Do you want to allow a web user the ability to use the file browser? <b>WARNING:</b> Allowing web users the use of the file browser exposes the files available to manager users.  Only use this option for trusted web users.';
$_lang["rb_webuser_title"] = 'Web Users?';
$_lang["recent_docs"] = 'Recent Resources';
$_lang["recommend_setting_change_title"] = 'Recommended Setting Change';
$_lang["recommend_setting_change_description"] = 'Your site is not configured to validate the HTTP_REFERER of incoming requests to the Manager. We strongly recommend enabling this setting to reduce the risk of a CSRF (Cross Site Request Forgery) attack.';
$_lang["refresh_cache"] = 'Cache: Found <b>%s</b> files in cache directory and deleted <b>%d</b> cache files.<p>New cache files will be created when pages are requested.';
$_lang["refresh_published"] = '<b>%s</b> Resources were published.';
$_lang["refresh_site"] = 'Clear Cache';
$_lang["refresh_title"] = 'Refresh site';
$_lang["refresh_tree"] = 'Refresh Site Tree';
$_lang["refresh_unpublished"] = '<b>%s</b> Resources were unpublished.';
$_lang["remember_username"] = 'Remember me';
$_lang["remove"] = 'Remove';
$_lang["remove_date"] = 'Remove date';
$_lang["remove_locks"] = 'Remove Locks';
$_lang["rename"] = 'Rename';
$_lang["reports"] = 'Reports';
$_lang["require_tagname"] = 'A tag name is required';
$_lang["require_tagvalue"] = 'A tag value is required';
$_lang["reset"] = 'Reset';
$_lang["reset_failedlogins"] = 'reset';
$_lang["resolve_hostnames_message"] = 'Do you want MODx to try to resolve your visitors\' hostnames when they visit your site? Resolving hostnames may create some extra server load, although your visitors won\'t notice this in any way.';
$_lang["resolve_hostnames_title"] = 'Resolve hostnames';
$_lang["resource"] = 'Resource';
$_lang["resource_alias"] = 'URL alias';
$_lang["resource_alias_help"] = 'Set the URL alias to make the Resource accessible as http://example.com/weburl. This only works Friendly URLs are enabled in the site configuration.';
$_lang["resource_content"] = 'Resource content';
$_lang["resource_description"] = 'Description';
$_lang["resource_description_help"] = 'Enter an optional description of this Resource.';
$_lang["resource_duplicate"] = 'Duplicate Resource';
$_lang["resource_long_title_help"] = 'Enter an optional longer title for your Resource. This can be used for automatic Resource header tags for search engines, and might be more descriptive for your Resource.';
$_lang["resource_metatag_help"] = 'Select the META tags or keywords you wish to assign to this Resource. Hold down the CTRL key to select multiple keywords or meta tags.';
$_lang["resource_opt_contentdispo"] = 'Content-Disposition';
$_lang["resource_opt_contentdispo_help"] = 'Use the content disposition field to specify how this Resource will be handled by the web browser. For file downloads select the Attachment option.';
$_lang["resource_opt_emptycache"] = 'Empty cache';
$_lang["resource_opt_emptycache_help"] = 'Leaving this field checked will make MODx empty the cache after you save the Resource. This way your visitors will not see an older version of the Resource.';
$_lang["resource_opt_folder"] = 'Container';
$_lang["resource_opt_folder_help"] = 'Check this to make the Resource also act as a Container for other Resources. A \'Container\' is like a folder, only it can also have content.';
$_lang["resource_opt_menu_index"] = 'Menu index';
$_lang["resource_opt_menu_index_help"] = 'Menu Index is a field that can control sorting Resources, particularly in menu Snippet(s). You can also use it for any other purpose in your Snippets.';
$_lang["resource_opt_menu_title"] = 'Menu title';
$_lang["resource_opt_menu_title_help"] = 'Menu title is an optional field used to display a short title in menu Snippet(s) or Modules.';
$_lang["resource_opt_published"] = 'Published';
$_lang["resource_opt_published_help"] = 'Check this field to have the Resource published immediately after saving it.';
$_lang["resource_opt_richtext"] = 'Rich text';
$_lang["resource_opt_richtext_help"] = 'Leave this checked to use the rich text editor for editing Resources. If your Resources contain JavaScript and forms, uncheck this to edit in HTML mode to prevent the editor from incorrectly changing your Resources.';
$_lang["resource_opt_show_menu"] = 'Show in menu';
$_lang["resource_opt_show_menu_help"] = 'Select this option to show Resource inside a web menu. Please note that some Menu Builders might choose to ignore this option.';
$_lang["resource_opt_trackvisit_help"] = 'Log each visitor\'s visit to this page';
$_lang["resource_overview"] = 'Resource overview';
$_lang["resource_parent"] = 'Resource parent';
$_lang["resource_parent_help"] = 'Click the icon to enable setting a Resource parent, then click a Resource in the Site Tree to set a new parent.';
$_lang["resource_permissions_error"] = 'Assign this Resource to at least one Resource Group to which you have access.';
$_lang["resource_setting"] = 'Resource setting';
$_lang["resource_summary"] = 'Summary (introtext)';
$_lang["resource_summary_help"] = 'Type a brief summary of the Resource';
$_lang["resource_title"] = 'Title';
$_lang["resource_title_help"] = 'Enter the name/title of the Resource. Avoid using backslashes in the name.';
$_lang["resource_to_be_moved"] = 'Resource to be moved';
$_lang["resource_type"] = 'Resource Type';
$_lang["resource_type_message"] = 'Weblinks reference Resources on the Internet including another MODx Resource, an external page, or an image or other file on the Internet. Weblinks should have a text/html Internet Media Type and Inline Content-Disposition.';
$_lang["resource_type_weblink"] = 'Weblink';
$_lang["resource_type_webpage"] = 'Web page';
$_lang["resource_weblink_help"] = 'Type the address of the object you wish to reference with this Weblink here.';
$_lang["resources_in_container"] = 'Resources in this Container';
$_lang["resources_in_container_no"] = 'This Container does not have child-Resources.';
$_lang["role"] = 'Role';
$_lang["role_about"] = 'View the about page';
$_lang["role_access_persmissions"] = 'Access permissions';
$_lang["role_actionok"] = 'View action completed screen';
$_lang["role_bk_manager"] = 'Use the Backup Manager';
$_lang["role_cache_refresh"] = 'Empty the site\'s cache';
$_lang["role_change_password"] = 'Change password';
$_lang["role_chunk_management"] = 'Chunk management';
$_lang["role_config_management"] = 'Configuration management';
$_lang["role_content_management"] = 'Content management';
$_lang["role_create_chunk"] = 'Create new Chunks';
$_lang["role_create_doc"] = 'Create new Resources';
$_lang["role_create_plugin"] = 'Create new Plugins';
$_lang["role_create_snippet"] = 'Create new Snippets';
$_lang["role_create_template"] = 'Create new site Templates';
$_lang["role_credits"] = 'View credits';
$_lang["role_delete_chunk"] = 'Delete Chunks';
$_lang["role_delete_doc"] = 'Delete Resources';
$_lang["role_delete_eventlog"] = 'Delete event log';
$_lang["role_delete_module"] = 'Delete Module';
$_lang["role_delete_plugin"] = 'Delete Plugins';
$_lang["role_delete_role"] = 'Delete roles';
$_lang["role_delete_snippet"] = 'Delete Snippets';
$_lang["role_delete_template"] = 'Delete Templates';
$_lang["role_delete_user"] = 'Delete users';
$_lang["role_delete_web_user"] = 'Delete web users';
$_lang["role_edit_chunk"] = 'Edit Chunks';
$_lang["role_edit_doc"] = 'Edit a Resource';
$_lang["role_edit_doc_metatags"] = 'Edit Resource META tags and keywords';
$_lang["role_edit_module"] = 'Edit Module';
$_lang["role_edit_plugin"] = 'Edit Plugins';
$_lang["role_edit_role"] = 'Edit roles';
$_lang["role_edit_settings"] = 'Change site settings';
$_lang["role_edit_snippet"] = 'Edit Snippets';
$_lang["role_edit_template"] = 'Edit site Templates';
$_lang["role_edit_user"] = 'Edit users';
$_lang["role_edit_web_user"] = 'Edit web users';
$_lang["role_empty_trash"] = 'Permanently purge deleted Resources';
$_lang["role_errors"] = 'View error dialog';
$_lang["role_eventlog_management"] = 'Event log management';
$_lang["role_export_static"] = 'Export Static HTML';
$_lang["role_file_manager"] = 'Use the file manager';
$_lang["role_frames"] = 'Request manager frames';
$_lang["role_help"] = 'View help pages';
$_lang["role_home"] = 'Request manager intro page';
$_lang["role_import_static"] = 'Import HTML';
$_lang["role_logout"] = 'Log out of the manager';
$_lang["role_manage_metatags"] = 'Manage site META tags and keywords';
$_lang["role_management_msg"] = 'Choose the role you wish to edit.';
$_lang["role_management_title"] = 'Roles';
$_lang["role_messages"] = 'View and send messages';
$_lang["role_module_management"] = 'Module management';
$_lang["role_name"] = 'Role name';
$_lang["role_new_module"] = 'Create new Module';
$_lang["role_new_role"] = 'Create new roles';
$_lang["role_new_user"] = 'Create new users';
$_lang["role_new_web_user"] = 'Create new web users';
$_lang["role_plugin_management"] = 'Plugin management';
$_lang["role_publish_doc"] = 'Publish Resources';
$_lang["role_role_management"] = 'Roles';
$_lang["role_run_module"] = 'Run Module';
$_lang["role_save_chunk"] = 'Save Chunks';
$_lang["role_save_doc"] = 'Save Resources';
$_lang["role_save_module"] = 'Save Module';
$_lang["role_save_password"] = 'Save password';
$_lang["role_save_plugin"] = 'Save Plugins';
$_lang["role_save_role"] = 'Save roles';
$_lang["role_save_snippet"] = 'Save Snippets';
$_lang["role_save_template"] = 'Save Templates';
$_lang["role_save_user"] = 'Save users';
$_lang["role_save_web_user"] = 'Save web users';
$_lang["role_snippet_management"] = 'Snippet management';
$_lang["role_template_management"] = 'Template management';
$_lang["role_title"] = 'Create/edit role';
$_lang["role_udperms"] = 'Permissions management';
$_lang["role_user_management"] = 'User management';
$_lang["role_view_docdata"] = 'View a Resource\'s data';
$_lang["role_view_eventlog"] = 'View event log';
$_lang["role_view_logs"] = 'View system logs';
$_lang["role_view_unpublished"] = 'View Unpublished Resources';
$_lang["role_web_access_persmissions"] = 'Web access permissions';
$_lang["role_web_user_management"] = 'Web user management';
$_lang["rss_url_news_default"] = 'http://feeds.feedburner.com/modx-announce';
$_lang["rss_url_news_message"] = 'Enter the URL for the MODx News Feed.';
$_lang["rss_url_news_title"] = 'RSS News Feed';
$_lang["rss_url_security_default"] = 'http://feeds.feedburner.com/modxsecurity';
$_lang["rss_url_security_message"] = 'Enter the URL for the MODx Security Feed.';
$_lang["rss_url_security_title"] = 'RSS Security Feed';
$_lang["run_module"] = 'Run Module';
$_lang["saturday"] = 'Saturday';
$_lang["save"] = 'Save';
$_lang["save_all_changes"] = 'Save all changes';
$_lang["save_tag"] = 'Save tag';
$_lang["saving"] = 'Saving, please wait...';
$_lang["search"] = 'Search';
$_lang["search_criteria"] = 'Search criteria';
$_lang["search_criteria_content"] = 'Search by content';
$_lang["search_criteria_content_msg"] = 'Find all Resources with the entered text in their content.';
$_lang["search_criteria_id"] = 'Search by ID';
$_lang["search_criteria_id_msg"] = 'Enter a Resource\'s ID to quickly locate that Resource.';
$_lang["search_criteria_longtitle"] = 'Search by long title';
$_lang["search_criteria_longtitle_msg"] = 'Find all Resources with the entered text in their long title.';
$_lang["search_criteria_title"] = 'Search by title';
$_lang["search_criteria_title_msg"] = 'Find all Resources with the entered text in their title.';
$_lang["search_empty"] = 'Your search returned no results. Please broaden your search criteria and try again.';
$_lang["search_item_deleted"] = 'This item has been deleted';
$_lang["search_results"] = 'Search results';
$_lang["search_results_returned_desc"] = 'Description';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Your search criteria returned <b>%s</b> Resources. If a lot of results are being returned, try to enter a more specific search. The two left-most columns will allow you to find the Resource in the Site Tree or view the Resource. The two right most columns show, respectively, if a Resource has been deleted and what it\'s published status is.<p />';
$_lang["search_results_returned_title"] = 'Title';
$_lang["search_view_docdata"] = 'View this item';
$_lang["security"] = 'Security';
$_lang["security_notices_tab"] = 'Security Notices';
$_lang["security_notices_title"] = 'Security Notices';
$_lang["select_date"] = 'Select a date';
$_lang["send"] = 'Send';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'If your site is on a https connection, please specify so here.';
$_lang["server_protocol_title"] = 'Server type';
$_lang["serveroffset"] = 'Server offset';
$_lang["serveroffset_message"] = 'Select the number of hours time difference between where you are and where the server is. Current time on server is <b>[%s]</b>, current time on server using the currently saved offset is <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Server offset time';
$_lang["servertime"] = 'Server Time';
$_lang["settings_after_install"] = 'As this is a new install, you are required to control these settings, and change any that you may wish to. After you\'ve controlled the settings, press \'Save\' to update the settings database.';
$_lang["settings_config"] = 'Configuration';
$_lang["settings_dependencies"] = 'Dependencies';
$_lang["settings_events"] = 'System Events';
$_lang["settings_furls"] = 'Friendly URLs';
$_lang["settings_general"] = 'General';
$_lang["settings_misc"] = 'File Manager';
$_lang["settings_page_settings"] = 'Settings';
$_lang["settings_photo"] = 'Photo';
$_lang["settings_properties"] = 'Properties';
$_lang["settings_site"] = 'Site';
$_lang["settings_strip_image_paths_message"] = 'If this is set to \'No\', MODx  will write file browser src\'s (images, files, flash, etc.) as absolute URLs. Relative URLs are helpful should you wish to move your MODx install, e.g., from a staging site to a production site. If you have no idea what this means, it\'s best just to leave it set to \'Yes\'.';
$_lang["settings_strip_image_paths_title"] = 'Rewrite browser paths?';
$_lang["settings_templvars"] = 'Template Variables';
$_lang["settings_title"] = 'System configuration';
$_lang["settings_ui"] = 'Interface &amp; Features';
$_lang["settings_users"] = 'User';
$_lang["show_meta"] = 'Show META Keywords tab';
$_lang["show_meta_message"] = 'Show the deprecated META Keywords tab when editing Resources in the Manager.';
$_lang["show_tree"] = 'Show Site Tree';
$_lang["showing"] = 'Showing';
$_lang["signupemail_message"] = 'Set the email message sent to users when creating accounts including their username and password.<br /><b>Note:</b> The following Placeholders are replaced by the Content Manager when the message is sent: <br /><br />[+sname+] - Name of your web site, <br />[+saddr+] - Your web site email address, <br />[+surl+] - Your site url, <br />[+uid+] - User\'s Login name or id, <br />[+pwd+] - User\'s password, <br />[+ufn+] - User\'s full name. <br /><br /><b>Leave the [+uid+] and [+pwd+] in the e-mail, or else the username and password won\'t be sent in the mail and your users won\'t know their username or password!</b>';
$_lang["signupemail_title"] = 'Signup e-mail';
$_lang["site"] = 'Site';
$_lang["site_schedule"] = 'Schedule';
$_lang["sitename_message"] = 'Enter the name of your site here.';
$_lang["sitename_title"] = 'Site name';
$_lang["sitestart_message"] = 'Enter the ID of the Resource you want to use as homepage here. <b>NOTE: make sure this ID you enter belongs to an existing Resource, and that it has been published!</b>';
$_lang["sitestart_title"] = 'Site start';
$_lang["sitestatus_message"] = 'Select \'Online\' to publish your site on the web. If you select \'Offline\', your visitors will see the \'Site unavailable message\', and won\'t be able to browse the site.';
$_lang["sitestatus_title"] = 'Site status';
$_lang["siteunavailable_message"] = 'Message to show when the site is offline or if an error occurs. <b>Note: This message will only be displayed if the Site unavailable page option is not set.</b>';
$_lang["siteunavailable_message_default"] = 'The site is currently unavailable.';
$_lang["siteunavailable_page_message"] = 'Enter the ID of the Resource you want to use as an offline page here. <b>NOTE: make sure this ID you enter belongs to an existing Resource, and that it has been published!</b>';
$_lang["siteunavailable_page_title"] = 'Site unavailable page';
$_lang["siteunavailable_title"] = 'Site unavailable message';
$_lang["snippet"] = 'Snippet';
$_lang["snippet_code"] = 'Snippet code (php)';
$_lang["snippet_desc"] = 'Description';
$_lang["snippet_execonsave"] = 'Execute Snippet after saving.';
$_lang["snippet_management_msg"] = 'Choose the Snippet you wish to edit.';
$_lang["snippet_msg"] = 'Add/edit Snippets. Remember, Snippets are \'raw\' PHP code, and if you expect the output of the Snippet to be shown at a certain point within the Template, you need to return a value from within the Snippet.';
$_lang["snippet_name"] = 'Snippet name';
$_lang["snippet_properties"] = 'Default Properties';
$_lang["snippet_title"] = 'Create/edit Snippet';
$_lang["sort_asc"] = 'Ascending';
$_lang["sort_desc"] = 'Descending';
$_lang["sort_tree"] = 'Sort the Site Tree';
$_lang["source"] = 'Source';
$_lang["stay"] = 'Continue editing';
$_lang["stay_new"] = 'Add another';
$_lang["submit"] = 'Submit';
$_lang["sunday"] = 'Sunday';
$_lang["sys_alert"] = 'System Alert';
$_lang["sysinfo_activity_message"] = 'This list show which Resources have been recently edited by your users.';
$_lang["sysinfo_userid"] = 'User';
$_lang["system_email_signup"] = "Hello [+uid+] \n\nHere are your login details for [+sname+] Content Manager:\n\nUsername: [+uid+]\nPassword: [+pwd+]\n\nOnce you log into the Content Manager ([+surl+]), you can change your password.\n\nRegards,\nSite Administrator";
$_lang["system_email_webreminder"] = "Hello [+uid+]\n\nTo activate your new password click the following link:\n\n[+surl+]\n\nIf successful you can use the following password to login:\n\nPassword:[+pwd+]\n\nIf you did not request this email then please ignore it.\n\nRegards,\nSite Administrator";
$_lang["system_email_websignup"] = "Hello [+uid+]\n\nHere are your login details for [+sname+]:\n\nUsername: [+uid+]\nPassword: [+pwd+]\n\nOnce you log into [+sname+] ([+surl+]), you can change your password.\n\nRegards,\nSite Administrator";
$_lang["table_hoverinfo"] = 'Hover the mouse cursor over a table\'s name to see a short description of the table\'s function (not all tables have <i>comments</i> set).';
$_lang["table_prefix"] = 'Table prefix';
$_lang["tag"] = 'Tag';
$_lang["template"] = 'Template';
$_lang["template_assignedtv_tab"] = 'Assigned Template Variables';
$_lang["template_code"] = 'Template code (html)';
$_lang["template_desc"] = 'Description';
$_lang["template_edit_tab"] = 'Edit Template';
$_lang["template_management_msg"] = 'Choose which Template you wish to edit.';
$_lang["template_msg"] = 'Create and edit Templates. Changed or new Templates won\'t be visible in your site\'s cached pages until the cache is emptied, however, you can use the preview function on a page to see the Template in action.';
$_lang["template_name"] = 'Template name';
$_lang["template_no_tv"] = 'No Template Variables have been assigned to this Template yet.';
$_lang["template_reset_all"] = 'Reset all pages to use Default Template';
$_lang["template_reset_specific"] = 'Reset only \'%s\' pages';
$_lang["template_title"] = 'Create/edit Template';
$_lang["template_tv_edit"] = 'Edit the TV sort order';
$_lang["template_tv_edit_message"] = 'Drag to reorder the Template Variables for this template.';
$_lang["template_tv_edit_title"] = 'Template Variable Sort Order';
$_lang["template_tv_msg"] = 'The Template Variables assigned to this Template are listed below.';
$_lang["thursday"] = 'Thursday';
$_lang["tmplvar_access_msg"] = 'Select the Resource Groups that are allowed to modify the content or value of this Template Variable';
$_lang["tmplvar_change_template_msg"] = 'Changing this Template will cause the page to reload the Template Variables, losing any unsaved changes.\n\n Are you sure you want to change this Template?';
$_lang["tmplvar_inuse"] = 'The following Resource(s) are currently using this Template Variable. To continue with the delete operation click the Delete button otherwise click the Cancel button.';
$_lang["tmplvar_tmpl_access"] = 'Template Access';
$_lang["tmplvar_tmpl_access_msg"] = 'Select the Templates that are allowed to access/process this Template Variable';
$_lang["tmplvars"] = 'Template Variables';
$_lang["tmplvars_binding_msg"] = 'This field supports data source bindings using the @ commands';
$_lang["tmplvars_caption"] = 'Caption';
$_lang["tmplvars_default"] = 'Default Value';
$_lang["tmplvars_description"] = 'Description';
$_lang["tmplvars_elements"] = 'Input Option Values';
$_lang["tmplvars_management_msg"] = 'Manage additional Template Variables for your Resources.';
$_lang["tmplvars_msg"] = 'Add or edit Template Variables here. Template Variables must be assigned to Templates in order to access them from Snippets and Resources.';
$_lang["tmplvars_name"] = 'Template Variable Name';
$_lang["tmplvars_novars"] = 'No Template Variables found';
$_lang["tmplvars_rank"] = 'Sort Order';
$_lang["tmplvars_reset_params"] = 'Reset parameters';
$_lang["tmplvars_title"] = 'Create/edit Template Variable';
$_lang["tmplvars_type"] = 'Input Type';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Widget Properties';
$_lang["to"] = 'to';
$_lang["tools"] = 'Tools';
$_lang["top_howmany_message"] = 'When viewing reports, how large should the \'Top ...\' lists be?';
$_lang["top_howmany_title"] = 'Top how many';
$_lang["total"] = 'total';
$_lang["track_visitors_message"] = 'Provides a hook for analytics Plugins, for example to flag whether or not visits to a specific Resource are logged.';
$_lang["track_visitors_title"] = 'Enable Stats Tracking';
$_lang["tree_show_protected"] = 'Show protected pages';
$_lang["tree_show_protected_message"] = 'When set to "No", Protected Resources (and all their child-Resources) do not appear in the Site Tree menu. "No" is the legacy setting for MODx.';
$_lang["truncate_table"] = 'Click here to truncate this table';
$_lang["tuesday"] = 'Tuesday';
$_lang["tv"] = 'TV';
$_lang["type"] = 'Type';
$_lang["udperms_allowroot_message"] = 'Allow Users to create new Resources in the site root. ';
$_lang["udperms_allowroot_title"] = 'Allow root';
$_lang["udperms_message"] = 'Control access to Resources via User Groups and Resource Groups.';
$_lang["udperms_title"] = 'Use access permissions';
$_lang["unable_set_link"] = 'Unable to set the link!';
$_lang["unable_set_parent"] = 'Unable to set new parent!';
$_lang["unauthorizedpage_message"] = 'Enter a published and publicly accessible Resource ID to redirect Users to when requesting a secured/unauthorized Resource.';
$_lang["unauthorizedpage_title"] = 'Unauthorized page';
$_lang["unblock_message"] = 'This User will not be blocked after saving the User\'s data.';
$_lang["undelete_resource"] = 'Undelete Resource';
$_lang["unpublish_date"] = 'Unpublish Date';
$_lang["unpublish_events"] = 'Un-publish Events';
$_lang["unpublish_resource"] = 'Un-publish Resource';
$_lang["untitled_resource"] = 'Untitled Resource';
$_lang["untitled_weblink"] = 'Untitled Weblink';
$_lang["update_params"] = 'Update parameter display';
$_lang["update_settings_from_language"] = 'Replace current with:';
$_lang["upload_maxsize_message"] = 'Enter the maximum file size that can be uploaded via the file manager. Upload file size must be entered in bytes. <b>NOTE: Large files can take a very long time to upload!</b>';
$_lang["upload_maxsize_title"] = 'Maximum upload size';
$_lang["uploadable_files_message"] = 'Enter a list of files that can be uploaded into \'assets/files/\' using the File Browser. Please enter the extensions for the filetypes, separated by commas.';
$_lang["uploadable_files_title"] = 'Uploadable File Types';
$_lang["uploadable_flash_message"] = 'Enter a list of files that can be uploaded into \'assets/flash/\' using the File Browser. Please enter the extensions for the flash types, separated by commas.';
$_lang["uploadable_flash_title"] = 'Uploadable Flash Types';
$_lang["uploadable_images_message"] = 'Enter a list of files that can be uploaded into \'assets/images/\' using the File Browser. Please enter the extensions for the image types, separated by commas.';
$_lang["uploadable_images_title"] = 'Uploadable Image Types';
$_lang["uploadable_media_message"] = 'Enter a list of files that can be uploaded into \'assets/media/\' using the File Browser. Please enter the extensions for the media types, separated by commas.';
$_lang["uploadable_media_title"] = 'Uploadable Media Types';
$_lang["use_alias_path_message"] = 'Enabling this option generates a virtual path to the Resource. E.g., if a Resource "child.html" is located in a Container Resource "parent", then the full URL alias path URL will be "/parent/child.html".';
$_lang["use_alias_path_title"] = 'Use Friendly URL alias path';
$_lang["use_editor_message"] = 'Enable editing with a Rich Text Editor (RTE). This setting applies to all Resources, but can be overridden in the User settings.';
$_lang["use_editor_title"] = 'Enable editor';
$_lang["user"] = 'User';
$_lang["user_block"] = 'Blocked';
$_lang["user_blockedafter"] = 'Blocked After';
$_lang["user_blockeduntil"] = 'Blocked Until';
$_lang["user_changeddata"] = 'Your data has been changed. Please log in again.';
$_lang["user_country"] = 'Country';
$_lang["user_dob"] = 'Date of birth';
$_lang["user_doesnt_exist"] = 'User does not exist';
$_lang["user_edit_self_msg"] = '<b>You may need to log out and log in again after saving to fully update your information.</b> New passwords will be sent to your e-mail address or shown onscreen.';
$_lang["user_email"] = 'E-mail address';
$_lang["user_failedlogincount"] = 'Failed logins';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Female';
$_lang["user_full_name"] = 'Full name';
$_lang["user_gender"] = 'Gender';
$_lang["user_is_blocked"] = 'This User is blocked!';
$_lang["user_logincount"] = 'Number of logins';
$_lang["user_male"] = 'Male';
$_lang["user_management_msg"] = 'Choose the Content Manager to edit. Content Manager Users are those Users who are allowed to log into the Content Manager';
$_lang["user_management_title"] = 'Manager Users';
$_lang["user_mobile"] = 'Mobile phone number';
$_lang["user_phone"] = 'Phone number';
$_lang["user_photo"] = 'User Photo';
$_lang["user_photo_message"] = 'Enter the image url for the this User or use the insert button to selected or upload an image file on the server.';
$_lang["user_prevlogin"] = 'Last login';
$_lang["user_role"] = 'User\'s role';
$_lang["user_state"] = 'State';
$_lang["user_title"] = 'Create/Edit User';
$_lang["user_upload_message"] = ' If you wish to stop this User uploading any filetypes in this category, make sure that the \'Use Main Configuration Setting\' checkbox is not ticked and leave the field blank.';
$_lang["user_use_config"] = 'Use System Configuration Setting';
$_lang["user_zip"] = 'Zip';
$_lang["username"] = 'Username';
$_lang["users"] = 'Security';
$_lang["validate_referer_message"] = 'Validate the HTTP_REFERER headers to reduce the risk of your content editors being tricked into performing unintended actions in the manager as victims of a CSRF (Cross Site Request Forgery) attack. Some configurations may not be able to use this option if the server is not sending HTTP_REFERER headers.';
$_lang["validate_referer_title"] = 'Validate HTTP_REFERER headers?';
$_lang["value"] = 'Value';
$_lang["version_codename"] = 'Version codename';
$_lang["view"] = 'View';
$_lang["view_child_resources_in_container"] = 'View children';
$_lang["view_log"] = 'View log';
$_lang["view_logging"] = 'Manager Actions';
$_lang["view_sysinfo"] = 'System Info';
$_lang["warning"] = 'Warning!';
$_lang["warning_not_saved"] = 'The changes you have made have not been saved yet. You can choose to stay on the current page in order to save the changes (\'Cancel\'), or you can leave this page, losing any changes you have made (\'OK\').';
$_lang["web_access_permissions"] = 'Web access permissions';
$_lang["web_access_permissions_user_groups"] = 'Web User groups';
$_lang["web_permissions"] = 'Web Permissions';
$_lang["web_user_management_msg"] = 'Choose the web User you wish to edit. Web Users are those Users who are only allowed to log into the web site';
$_lang["web_user_management_title"] = 'Web Users';
$_lang["web_user_title"] = 'Create/edit Web User';
$_lang["web_users"] = 'Web Users';
$_lang["weblink"] = 'Weblink';
$_lang["weblink_message"] = 'A weblink is a reference to an object on the internet. This could be a Resource within MODx, a page on another site or an image or other file on the internet.';
$_lang["webpwdreminder_message"] = 'Enter a message to be sent to your Web Users whenever they request a new password via email. The Content Manager will send an e-mail containing their new password and activation information. <br /><b>Note:</b> The following Placeholders are replaced by the Content Manager when the message is sent: <br /><br />[+sname+] - Name of your web site, <br />[+saddr+] - Your web site email address, <br />[+surl+] - Your site url, <br />[+uid+] - User\'s Login name or id, <br />[+pwd+] - User\'s password, <br />[+ufn+] - User\'s full name. <br /><br /><b>Leave the [+uid+] and [+pwd+] in the e-mail, or else the username and password won\'t be sent in the mail and your Users won\'t know their username or password!</b>';
$_lang["webpwdreminder_title"] = 'Web Reminder Email';
$_lang["websignupemail_message"] = 'Set the email message sent to Users when creating accounts including their username and password<br /><b>Note:</b> The following Placeholders are replaced by the Content Manager when the message is sent: <br /><br />[+sname+] - Name of your web site, <br />[+saddr+] - Your web site email address, <br />[+surl+] - Your site url, <br />[+uid+] - User\'s Login name or id, <br />[+pwd+] - User\'s password, <br />[+ufn+] - User\'s full name. <br /><br /><b>Leave the [+uid+] and [+pwd+] in the e-mail, or else the username and password won\'t be sent in the mail and your Users won\'t know their username or password!</b>';
$_lang["websignupemail_title"] = 'Web Signup e-mail';
$_lang["wednesday"] = 'Wednesday';
$_lang["welcome_messages"] = 'Your Inbox contains <strong>%d</strong> message(s), of which <strong>%s</strong> are unread.';
$_lang["welcome_title"] = 'Welcome to your MODx Content Manager';
$_lang["which_editor_message"] = 'Select the rich text editor (RTE). You can download and install additional RTEs from the MODx download page.';
$_lang["which_editor_title"] = 'Editor to use';
$_lang["working"] = 'Working...';
$_lang["wrap_lines"] = 'Wrap lines';
$_lang["xhtml_urls_message"] = 'Replaces ampersand (&amp;) characters in urls that are generated by MODx with the validating &amp;<!-- -->amp; htmlentity';
$_lang["xhtml_urls_title"] = 'XHTML URLs';
$_lang["yes"] = 'Yes';
$_lang["you_got_mail"] = 'You got mail';
$_lang["yourinfo_message"] = 'This section shows some information about you:';
$_lang["yourinfo_previous_login"] = 'Your last login:';
$_lang["yourinfo_role"] = 'Your role is:';
$_lang["yourinfo_title"] = 'Your info';
$_lang["yourinfo_total_logins"] = 'Total number of logins:';
$_lang["yourinfo_username"] = 'You are logged in as:';
?>