<?php
/**
 * Filename:       includes/lang/spanish.inc.php
 * Function:       Language file.
 * Author:         The MODx Project Team
 * Date:           28 Julio 2009
 * Version:        2.0.3
 * MODx version:   Evolution 1.0
 *
*/
$modx_lang_attribute = 'es'; // Manager HTML/XML Language Attribute see http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'iso-8859-1';
setlocale (LC_ALL, 'es_MX');

$_lang["about_msg"] = 'MODx es un <a href="http://modxcms.com/what-is-modx.html" target="_blank">Sistema de Administracin de Contenido y Esquema de PHP</a> bajo licencia <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'Acerca de MODx';
$_lang["access_permission_denied"] = 'No tienes los permisos correctos para este documento.';
$_lang["access_permission_parent_denied"] = 'No tienes permiso para crear o mover un documento aqu! Por favor elije otro lugar.';
$_lang["access_permissions"] = 'Permisos de acceso';
$_lang["access_permissions_add_resource_group"] = 'Crear un grupo de documentos nuevo';
$_lang["access_permissions_add_user_group"] = 'Crear un grupo de usuarios nuevo';
$_lang["access_permissions_docs_collision"] = 'Debido a que existe un conflicto entre los Grupos de Usuarios Web y los Grupos de Usuarios del Admin para tu Rol, este documento ser pblico.  Contacta a un admin del sitio para obtener ms ayuda.';
$_lang["access_permissions_docs_message"] = 'Aqu puedes seleccionar a qu grupos de documentos pertenece este documento';
$_lang["access_permissions_group_link"] = 'Crear un enlace de grupo nuevo';
$_lang["access_permissions_introtext"] = 'Aqu puedes administrar los grupos de usuarios y documentos usados para los permisos de acceso. Para aadir un usuario a un grupo de usuarios, edita el usuario y selecciona los grupos a los que el usuario debe ser miembro. Para aadir un documento a un grupo de usuarios, edita el documento y selecciona los grupos a los que debe de pertenecer.';
$_lang["access_permissions_link_to_group"] = 'al Grupo de Documentos';
$_lang["access_permissions_link_user_group"] = 'Enlazar Grupo de Usuarios';
$_lang["access_permissions_links"] = 'Enlaces de los grupos de usuarios/documentos';
$_lang["access_permissions_links_tab"] = 'Aqu es donde especificas que grupos de usuarios tienen acceso (por ej. pueden editar o crear hijos) para los grupos de documentos. Para enlazar un grupo de documentos a un grupo de usuarios, selecciona los grupos apropiados del men desplegable y has clic en \'Enviar\'. Para remover el enlace de cierto grupo, presiona \'Remover\'. Esto remover el enlace inmediatamente.';
$_lang["access_permissions_no_resources_in_group"] = 'Ninguno.';
$_lang["access_permissions_no_users_in_group"] = 'Ninguno.';
$_lang["access_permissions_off"] = '<span class="warning">Los Permisos de Acceso no estn activados.</span> Esto significa que cualquiera de los cambios aqu realizados no tendrn ningn efecto hasta que los Permisos de Acceso estn activados en tu Configuracin. ';
$_lang["access_permissions_resource_groups"] = 'Grupos de Documentos';
$_lang["access_permissions_resources_in_group"] = '<b>Documentos en el grupo:</b> ';
$_lang["access_permissions_resources_tab"] = 'Aqu puedes ver qu grupos de documentos han sido configurados. Tambin puedes crear nuevos grupos, renombrarlos, borrarlos y ver qu documentos estn en los diferentes grupos (pon el mouse sobre el ID del documento para ver su nombre).  Para aadir un documento a un grupo, o removerlo de un grupo, edita el documento directamente.';
$_lang["access_permissions_user_groups"] = 'Grupos de usuarios';
$_lang["access_permissions_user_message"] = 'Aqu puedes seleccionar a qu grupos de usuarios pertenece este usuario:';
$_lang["access_permissions_users_in_group"] = 'Usuarios en Grupo:';
$_lang["access_permissions_users_tab"] = 'Aqu puedes ver que grupos de usuarios han sido configurados. Tambin puedes crear nuevos grupos, renombrarlos, borrarlos y ver qu usuarios son miembros de los diferentes grupos. Para aadir un nuevo usuario a un grupo, o removerlo de uno, edita el usuario directamente. Los Administradores (usuarios a los que se les ha asignado un rol con ID 1) siempre tienen acceso a todos los documentos, por lo que no necesitan ser aadidos a ningn grupo.';
$_lang["account_email"] = 'Email de la cuenta';
$_lang["actioncomplete"] = '<b>La accin fue completada satisfactoriamente!</b><br /> - Por favor, espera mientras MODx hace limpieza.';
$_lang["activity_message"] = 'Esta lista muestra los ltimos documentos que creaste o editaste:';
$_lang["activity_title"] = 'Documentos recientemente editados/creados';
$_lang["add"] = 'Aadir';
$_lang["add_chunk"] = 'Aadir Chunk';
$_lang["add_doc"] = 'Aadir documento';
$_lang["add_folder"] = 'Carpeta Nueva';
$_lang["add_plugin"] = 'Aadir Plugin';
$_lang["add_resource"] = 'Documento Nuevo';
$_lang["add_snippet"] = 'Aadir Snippet';
$_lang["add_tag"] = 'Aadir etiqueta';
$_lang["add_template"] = 'Aadir Template';
$_lang["add_tv"] = 'Aadir TV';
$_lang["add_weblink"] = 'Enlace Web Nuevo';
$_lang["administrator_role_message"] = 'Este rol no puede ser editado o borrado.';
$_lang["after_saving"] = 'Despus de guardar';
$_lang["alert_delete_self"] = 'No lo puedes borrar t!';
$_lang["alias"] = 'Alias';
$_lang["all_doc_groups"] = 'Todos los Grupos de Documentos (Pblicos)';
$_lang["all_events"] = 'Todos los Eventos';
$_lang["all_usr_groups"] = 'Todos los Grupos de Usuarios (Pblicos)';
$_lang["allow_mgr_access"] = 'Acceso a la Interfase del Administrador';
$_lang["allow_mgr_access_message"] = 'Selecciona esta opcin para habilitar o deshabilitar el acceso a la interfase del Administrador. <b>NOTA: El usuario ser redirigido a la pagina de ingreso del Administrador, o al inicio del sitio web, si esta opcin es configurada como no.</b>';
$_lang["already_deleted"] = 'ya ha sido borrado.';
$_lang["attachment"] = 'Adjunto';
$_lang["automatic_alias_message"] = 'Selecciona \'si\' para que el sistema genere automticamente un alias basado en el ttulo de la pgina del documento al guardarlo.';
$_lang["automatic_alias_title"] = 'Generar automticamente un alias:';
$_lang["backup"] = 'Respaldo';
$_lang["bk_manager"] = 'Respaldo';
$_lang["block_message"] = 'Este usuario ser bloqueado despus de guardar los datos de usuario!';
$_lang["blocked_minutes_message"] = 'Escribe el nmero de minutos que un usuario ser bloqueado si alcanza su nmero mximo de ingresos fallidos permitidos. Por favor, ingresa este valor solamente como nmeros (sin comas, espacios, etc.)';
$_lang["blocked_minutes_title"] = 'Minutos de Bloqueo:';
$_lang["cache_files_deleted"] = 'Los siguientes archivos fueron borrados:';
$_lang["cancel"] = 'Cancelar';
$_lang["captcha_code"] = 'Cdigo de seguridad';
$_lang["captcha_message"] = 'Activa esto para aumentar la seguridad al requerir a los usuarios el ingreso de un cdigo no legible por maquinas (y scriptkiddy hacking scripts).';
$_lang["captcha_title"] = 'Usar cdigos CAPTCHA:';
$_lang["captcha_words_default"] = 'MODx,Aceso,Mejor,BitCode,Chunk,Cache,Desc,Diseno,Excel,Disfruta,URLs,TechView,Gerald,Griff,Humphrey,Vacacion,Intel,Integracion,Joystick,Join(),Oscope,Genetico,Luz,Parecido,Marit,Maaike,Nicho,Holanda,Ordinancia,Oscillo,Parser,Fusion,Query,Pregunta,Regalia,Correcto,Snippet,Sentinela,Template,Thespian,Unidad,Enterprise,Verily,Tatuaje,Veri,Website,WideWeb,Yap,Amarillo,Zebra,Zigoto';
$_lang["captcha_words_message"] = 'Ingresa una lista de palabras CAPTCHA para  usarse si el CAPTCHA est activado. Separa las palabras con comas. Este campo de entrada est limitado a 255 caracteres.';
$_lang["captcha_words_title"] = 'Palabras CAPTCHA';
$_lang["category_heading"] = 'Categora';
$_lang["category_msg"] = 'Aqu puedes ver y editar todos los Elementos agrupados por categora.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Cambiar nombre';
$_lang["change_password"] = 'Cambiar Contrasea';
$_lang["change_password_confirm"] = 'Confirmar Contrasea';
$_lang["change_password_message"] = 'Por favor, ingresa tu nueva contrasea, e ingrsala nuevamente para confirmarla. Tu contrasea debe de tener entre 6 y 15 caracteres.';
$_lang["change_password_new"] = 'Nueva contrasea';
$_lang["charset_message"] = 'Por favor, selecciona qu codificacin de caracteres deseas utilizar en el Admin.  Por favor nota que MODx ha sido probado con un buen nmero de estas codificacin, pero no con todas ellas. Para la mayora de los idiomas, la configuracin prefijada a UTF-8 es la preferible.';
$_lang["charset_title"] = 'Codificacin del caracteres:';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Cdigo de Chunk (html)';
$_lang["chunk_multiple_id"] = 'Error: Varios Chunks comparten la misma ID nica.';
$_lang["chunk_no_exist"] = 'El Chunk no existe.';
$_lang["cleaningup"] = 'Limpiando';
$_lang["clear_log"] = 'Limpiar Bitcora';
$_lang["click_to_context"] = 'Haz clic para acceder al men contextual';
$_lang["click_to_edit_title"] = 'Haz clic aqu para editar este registro';
$_lang["click_to_view_details"] = 'Haz clic aqu para ver detalles';
$_lang["close"] = 'Cerrar';
$_lang["collapse_tree"] = 'Colapsar rbol';
$_lang["comment"] = 'Comentario';
$_lang["configcheck_admin"] = 'Por favor Contacta al administrador del sistema y advirtele sobre este mensaje!';
$_lang["configcheck_cache"] = 'el directorio cache no es escribible';
$_lang["configcheck_cache_msg"] = 'MODx no puede escribir en el directorio cache. MODx continuar funcionando como es esperado, pero no realizar ningn cache. Para solucionar esto, haz el directorio /_cache/ escribible.';
$_lang["configcheck_configinc"] = 'El archivo de configuracin todava es escribible';
$_lang["configcheck_configinc_msg"] = 'Personas muy malintencionadas podran potencialmente probocar algunos problemas en tu sitio y todo lo asociado con l. <strong>En serio.</strong> Por favor Haz tu archivo de configuracin  (/manager/includes/config.inc.php) de slo lectura!';
$_lang["configcheck_default_msg"] = 'Una alerta no especificada ha sido encontrada. Lo cual es extrao.';
$_lang["configcheck_errorpage_unavailable"] = 'La pgina de error de tu sitio no est disponible.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Esto significa que tu pgina de Error no es accesible para navegantes normales de internet o que no existe. Esto puede provocar un estado de circulo cerrado y varios errores en la bitcora de tu sitio. Asegrate de que nohaya grupos de usuarios asignados a la pgina.';
$_lang["configcheck_errorpage_unpublished"] = 'La pgina de Error de tu sitio no est publicada o no existe.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Esto significa que tu pgina de Error no es accesible para el pblico en general. Publica la pgina o asegrate de que est asignada a un documento existente en el rbol de tu sitio en el men Herramientas &gt; Configuracin.';
$_lang["configcheck_images"] = 'El directorio de imgenes no es escribible';
$_lang["configcheck_images_msg"] = 'El directorio de imgenes no es escribible, o no existe. Esto significa que las funciones del Admin de Imgenes en el editor no funcionar.';
$_lang["configcheck_installer"] = 'El instalador todava est presente';
$_lang["configcheck_installer_msg"] = 'El directorio install/ contiene el instalador de MODx. Slo imagina lo que puede pasar si una persona maligna encuentra esta carpeta y ejecuta el instalador!  Probablemente no llegue muy lejos, porque deber ingresar cierta informacin de usuario para la base de datos, pero es mejor borrar esta carpeta de tu servidor.';
$_lang["configcheck_lang_difference"] = 'Nmero incorrecto de entradas en el archivo de idioma';
$_lang["configcheck_lang_difference_msg"] = 'El idioma actualmente seleccionado tiene un nmero diferente de entradas que el idioma prefijado.  Mientras no es necesariamente un problema, esto puede significar que el archivo de idioma necesita ser actualizado.';
$_lang["configcheck_notok"] = 'Uno o ms detalles de configuracin no estn bien: ';
$_lang["configcheck_ok"] = 'El chequeo pas OK - sin advertencias que reportar.';
$_lang["configcheck_register_globals"] = 'register_globals est configurado como ON en tu archivo de configuracin php.ini';
$_lang["configcheck_register_globals_msg"] = 'Esta configuracin hace tu sitio mucho ms propenso a sufrir ataques Cross Site Scripting (XSS). Deberas hablar con tu proveedor de hospedaje acerca de qu puede hacer para deshabilitar esta configuracin.';
$_lang["configcheck_title"] = 'Chequeo de configuracin';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Tu pgina de acceso no autorizado no est publicada o no existe.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Esto significa que tu pgina de acceso no autorizado no es accesible para navegantes normales de internet o que no existe.  Esto puede provocar un estado de crculo cerrado y varios errores en la bitcora de tu sitio.  Asegrate de que no haya grupos de usuarios web asignados a la pgina.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'La pgina de acceso no autorizado definida en la configuracin del sitio no est publicada.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Esto significa que tu pgina de acceso no autorizado no es accesible para el pblico en general. Publica la pgina o asegrate de que est asignada a un documento existente en el rbol de tu sitio en en menu Herramientas &gt; Configuracin.';
$_lang["configcheck_warning"] = 'Advertencia de configuracin:';
$_lang["configcheck_what"] = 'Qu significa esto?';
$_lang["confirm_block"] = 'Ests seguro de que quieres bloquear a este usuario?';
$_lang["confirm_delete_eventlog"] = 'Ests seguro de que quieres borrar esta bitcora de eventos?';
$_lang["confirm_delete_file"] = 'Ests segura de que quieres borrar el archivo?\n\nEsto puede hacer que tu sitio deje de funcionar correctamente! Slo borra este archivo si sabes con seguridad que lo que ests haciendo no va a romper nada.';
$_lang["confirm_delete_htmlsnippet"] = 'Ests seguro de que quieres borrar este chunk?';
$_lang["confirm_delete_keywords"] = 'Ests segura de que quieres borrar estas palabras claves?';
$_lang["confirm_delete_module"] = 'Ests seguro de que quieres borrar este mdulo?';
$_lang["confirm_delete_plugin"] = 'Ests segura de que quieres borrar este plugin?';
$_lang["confirm_delete_record"] = 'Ests seguro de que quieres borrar los registros seleccionados?';
$_lang["confirm_delete_resource"] = 'Ests segura de que quieres borrar este documento?\nCualquier documento hijo tambin ser borrado.';
$_lang["confirm_delete_role"] = 'Ests segura de que quieres borrar este rol?';
$_lang["confirm_delete_snippet"] = 'Ests seguro de que quieres borrar este snippet?';
$_lang["confirm_delete_tags"] = 'Ests segura que de desea quieres las etiquetas META seleccionadas?';
$_lang["confirm_delete_template"] = 'Ests seguro de que quieres borrar este template?';
$_lang["confirm_delete_tmplvars"] = 'Ests segura de que quieres remover esta variable y todos sus valores guardados?';
$_lang["confirm_delete_user"] = 'Ests seguro que de quieres borrar este usuario?';
$_lang["confirm_duplicate_record"] = 'Ests seguro de que quieres duplicar este registro?';
$_lang["confirm_empty_trash"] = 'Esto remover permanentemente TODOS tus documentos borrados.\n\nDeseas continuar?';
$_lang["confirm_load_depends"] = 'Ests segura que de quieres cargar la pantalla del Administrar Dependencias sin guardar tus modificaciones?';
$_lang["confirm_name_change"] = 'Cambiar el nombre de usuario puede afectar otras aplicaciones que estn relacionadas con el Administrador de Contenidos.\n\nEsts seguro de que quieres cambiar este nombre de usuario?';
$_lang["confirm_publish"] = '\n\nLa publicacin de este documento remover cualquier fecha de (des)publicacin que haya sido configurada. Si deseas configurar o mantener las fechas de publicacin o (des)publicacin, por favor selecciona \'editar\' el documento en vez de publicar.\n\nContinuar publicacin?';
$_lang["confirm_remove_locks"] = 'Los usuarios a veces cierran sus navegadores mientras editan documentos, templates, snippets, o parsers, posiblemente dejando el artculo que estaban editando en estado cerrado. Al presionar OK puedes remover TODOS los estados cerrados que estn configurados actualmente.\n\nContinuar?';
$_lang["confirm_resource_duplicate"] = 'Ests segura de que quieres duplicar este documento? Cualquier artculo que contenga tambin ser duplicado.';
$_lang["confirm_setting_language_change"] = 'Has modificado el valor prefijado y perders los cambios. Proceder?';
$_lang["confirm_unblock"] = 'Ests seguro de que quieres desbloquear este usuario?';
$_lang["confirm_undelete"] = '\n\nCualquier documento hijo borrado al mismo tiempo que este documento tambin ser recuperado, pero los documentos hijos borrados con anterioridad se mantendrn borrados.';
$_lang["confirm_unpublish"] = '\n\nDespublicar este documento remover cualquier fecha de (des)publicacin que haya sido configurada. Si deseas configurar o mantener las fechas de (des)publicacin, por favor elige \'editar\' el documento.\n\nContinuar?';
$_lang["confirm_unzip_file"] = 'Ests seguro de que quieres descomprimir este archivo?\n\nLos archivos existentes sern sobrescritos.';
$_lang["could_not_find_user"] = 'No se puede encontrar el usuario';
$_lang["create_folder_here"] = 'Crear carpeta aqu';
$_lang["create_resource_here"] = 'Crear documento aqu';
$_lang["create_resource_title"] = 'Crear Recurso';
$_lang["create_weblink_here"] = 'Crear enlace web aqu';
$_lang["createdon"] = 'Fecha de creacin';
$_lang["credits"] = 'Crditos';
$_lang["credits_shouts_msg"] = '<p>MODx es administrado y mantenido en <a href="http://modxcms.com/about/" target="_blank">MODxCMX.com</a>.</p>';
$_lang["custom_contenttype_message"] = 'Aqu puedes aadir tipos de contenido personalizados para ser usados en tus documentos. Para aadir una nueva entrada, ingresa el tipo de contenido y presione el botn de \'Aadir\'.';
$_lang["custom_contenttype_title"] = 'Tipos de contenido personalizados:';
$_lang["database_charset"] = 'Conjunto de Caracteres de la Base de Datos';
$_lang["database_collation"] = 'Conjunto de Caracteres de Colacin de la Base de Datos';
$_lang["database_name"] = 'Nombre de la base de datos';
$_lang["database_overhead"] = '<b style="color:#990033;">Nota:</b> Overhead es un espacio no usado reservado por MySQL. Para liberar este espacio, haz clic en la figura overhead de las tablas.';
$_lang["database_server"] = 'Servidor de BD';
$_lang["database_table_clickbackup"] = 'para respaldar &amp; descargar las tablas seleccionadas';
$_lang["database_table_clickhere"] = 'Haz Clic aqu';
$_lang["database_table_datasize"] = 'Tamao de datos';
$_lang["database_table_droptablestatements"] = 'Generar ordenes DROP TABLE.';
$_lang["database_table_effectivesize"] = 'Tamao efectivo';
$_lang["database_table_indexsize"] = 'Tamao de indexado';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Registros';
$_lang["database_table_tablename"] = 'Nombre de la tabla';
$_lang["database_table_totals"] = 'Totales:';
$_lang["database_table_totalsize"] = 'Tamao total';
$_lang["database_tables"] = 'Tablas de BD';
$_lang["database_version"] = 'Versin de BD:';
$_lang["date"] = 'Fecha';
$_lang["datechanged"] = 'Fecha de cambio';
$_lang["datepicker_offset"] = 'Offset del Selector de Fecha: ';
$_lang["datepicker_offset_message"] = 'El nmero de aos a mostrar en el pasado en el Selector de Fecha.';
$_lang["defaultcache_message"] = 'Selecciona \'Si\' para hacer todos los documentos nuevos cacheables en forma prefijada.';
$_lang["defaultcache_title"] = 'Cacheable prefijado';
$_lang["defaultmenuindex_message"] = 'Selecciona \'Si\' para activar el incremento automtico del indexado de menu en forma prefijada.';
$_lang["defaultmenuindex_title"] = 'Indexado de Men prefijado';
$_lang["defaultpublish_message"] = 'Selecciona \'Si\' para hacer todos los documentos nuevos publicados en forma prefijada.';
$_lang["defaultpublish_title"] = 'Publicado prefijado';
$_lang["defaultsearch_message"] = 'Selecciona \'Si\' para hacer todos los documentos nuevos buscables en forma prefijada.';
$_lang["defaultsearch_title"] = 'Buscable prefijado';
$_lang["defaulttemplate_message"] = 'Selecciona que template prefijado deseas utilizar para los documentos nuevos. Todava puedes seleccionar uno diferente en el editor de documentos, esta configuracin slo preselecciona uno de tus templates para t.';
$_lang["defaulttemplate_title"] = 'Template prefijado';
$_lang["delete"] = 'Borrar';
$_lang["delete_resource"] = 'Borrar documento';
$_lang["delete_tags"] = 'Borrar etiquetas';
$_lang["deleting_file"] = 'Borrando archivo `%s`: ';
$_lang["description"] = 'Descripcin';
$_lang["deselect_keywords"] = 'Limpiar palabras clave';
$_lang["deselect_metatags"] = 'Limpiar etiquetas META';
$_lang["disabled"] = 'Deshabilitado';
$_lang["doc_data_title"] = 'Ver datos del documento';
$_lang["duplicate"] = 'Duplicar';
$_lang["duplicate_alias_found"] = 'El documento \'%s\' ya est usando el alias \'%s\'. Por favor, ingresa un alias nico.';
$_lang["duplicate_alias_message"] = 'Aqu puedes seleccionar \'si\' para permitir guardar alias duplicados. <b>NOTA: Esta opcin debe de ser usada con la opcin \'Direccin Alias Amigable\' configurada a \'Si\' para as evitar problemas referenciando el documento.</b>';
$_lang["duplicate_alias_title"] = 'Permitir alias duplicados:';
$_lang["duplicate_name_found_general"] = 'Ya existe un %s nombrado \'%s\'. Favor de ingresar un nombre nico.';
$_lang["duplicate_name_found_module"] = 'Ya existe un Mdulo nombrado \'%s\'. Favor de ingresar un nombre nico.';
$_lang["edit"] = 'Editar';
$_lang["edit_resource"] = 'Editar documento';
$_lang["edit_resource_title"] = 'Crear/editar documento';
$_lang["edit_settings"] = 'Configuracin';
$_lang["editedon"] = 'Fecha de Edicin';
$_lang["editing_file"] = 'Editando el archivo: ';
$_lang["editor_css_path_message"] = 'Ingresa la direccin a tu archivo CSS que deseas utilizar dentro del editor.  La mejor forma de ingresar la direccin es ingresar la direccin desde la raz de tu servidor, por ejemplo: /assets/site/style.css. Si no deseas cargar una hoja de estilos en el editor, deja este campo en blanco.';
$_lang["editor_css_path_title"] = 'Direccin del archivo CSS:';
$_lang["element"] = 'Elemento';
$_lang["element_categories"] = 'Vista combinada';
$_lang["element_management"] = 'Administrar Elementos';
$_lang["element_name"] = 'Nombre de Elemento';
$_lang["element_selector_msg"] = 'Selecciona el o los Elemento(s) de la lista aqu abajo y haz clic en el botn \'Insertar\'.';
$_lang["element_selector_title"] = 'Selector de Elemento';
$_lang["elements"] = 'Elementos';
$_lang["email"] = 'Email';
$_lang["email_sent"] = 'Correo electrnico enviado';
$_lang["emailsender_message"] = 'Aqu puedes especificar el email usado cuando se le enve los nombres de usuario y las contraseas a los usuarios.';
$_lang["emailsender_title"] = 'Direccin de correo electrnico:';
$_lang["emailsubject_default"] = 'Tus detalles de entrada';
$_lang["emailsubject_message"] = 'Aqu puedes especificar el valor del Asunto para el correo electrnico de bienvenida.';
$_lang["emailsubject_title"] = 'Asunto del correo electrnico:';
$_lang["empty_folder"] = 'Esta carpeta est vaca';
$_lang["empty_recycle_bin"] = 'Purgar los documentos borrados';
$_lang["empty_recycle_bin_empty"] = 'No hay documentos borrados para purgar.';
$_lang["enable_resource"] = 'Habilitar archivo de Elementos.';
$_lang["enable_sharedparams"] = 'Habilitar compartir parmetros';
$_lang["enable_sharedparams_msg"] = '<b>NOTA:</b> El id global nico (GUID) ser usado para identificar inequvocamente este modulo y sus parmetros compartidos.  El GUID es usado tambin como una forma de enlace entre el mdulo y los plugins o snippets que acceden a sus parmetros compartidos. ';
$_lang["enabled"] = 'Habilitado';
$_lang["error"] = 'Error';
$_lang["error_sending_email"] = 'Error enviando correo electrnico';
$_lang["errorpage_message"] = 'Ingresa el ID del documento que quieres enviar a los usuarios si solicitan un documento que no existe actualmente. <b>NOTA: asegrate de que este ID pertenece a un documento existente y que ha sido publicado!</b>';
$_lang["errorpage_title"] = 'Pgina de error:';
$_lang["event_id"] = 'Id del evento';
$_lang["eventlog"] = 'Bitcora del evento';
$_lang["eventlog_msg"] = 'La bitcora del evento es usada para mostrar informacin, advertencias y mensajes de error generados por el admin de contenido.  La columna \'fuente\' muestra la seccin del admin de contenido donde ocurri el mensaje.';
$_lang["eventlog_viewer"] = 'Eventos del sistema';
$_lang["existing_category"] = 'Categora existente';
$_lang["expand_tree"] = 'Expandir rbol';
$_lang["export_site"] = 'Exportar HTML esttico';
$_lang["export_site_cacheable"] = 'Incluir archivos no cacheables:';
$_lang["export_site_exporting_document"] = 'Exportando archivo <b>%s</b> de <b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = 'Fall!';
$_lang["export_site_failed_no_open"] = 'No se puede abrir el archivo: ';
$_lang["export_site_failed_no_retrieve"] = 'No se puede traer el documento.';
$_lang["export_site_failed_no_write"] = 'No se puede escribir el archivo.';
$_lang["export_site_html"] = 'Exportar sitio a HTML';
$_lang["export_site_maxtime"] = 'Tiempo mximo de exportacin:';
$_lang["export_site_maxtime_message"] = 'Aqu puedes especificar el nmero de segundos que MODX puede tardarse en exportar el sitio (por sobre los valores de PHP).  Ingresa 0 para tiempo ilimitado.  Favor de notar, un valor de 0 o un numero realmente alto pueden hacer cosas extraas a tu servidor y no es recomendado.';
$_lang["export_site_message"] = '<p>Usando esta funcin puedes exportar el sitio completo a archivos HTML. Favor de notar, sin embargo, que perders mucha funcionalidad de MODx si lo haces:</p><ul><li>Las lecturas de los archivos exportados no sern guardadas.</li><li>Snippets interactivos NO funcionarn en archivos exportados</li><li>Slo documentos normales sern exportados, los enlaces web no sern exportados.</li><li>El proceso de exportacin puede fallar si tus documentos contienen snippets que envan cabeceras de redireccin.</li><li>Dependiendo de cmo has escrito tus documentos, hojas de estilo e imagenes, el diseo de tu sitio puede estar daado.  Para arreglar esto, puedes guardar/mover tus archivos exportados al mismo directorio donde se encuentra el archivo principal de MODx index.php.</li></ul><p>Por favor llena la forma y presiona \'Exportar\' para comenzar el proceso de exportacin.  Los archivos creados sern guardados en la ubicacin que especifiques, usando, cuando sea posible, los alias de documentos como nombres de archivo.  Mientras se exporta tu sitio, es mejor configurar la opcin de MODx  \'Alias Amigables\' como \'si\'. Dependiendo del tamao de tu sitio, la exportacin puede demorar un tiempo.</p> <p><em>Cualquier archivo existente ser sobrescrito por los nuevos si sus nombres son identicos!</em></p>';
$_lang["export_site_numberdocs"] = '<p><b>Se encontraron %s documentos para exportar...</b></p>';
$_lang["export_site_prefix"] = 'Prefijo de archivo:';
$_lang["export_site_start"] = 'Comenzar exportacin';
$_lang["export_site_success"] = 'xito!';
$_lang["export_site_success_skip_dir"] = 'Saltar este directorio.';
$_lang["export_site_success_skip_doc"] = 'Saltar este documento.';
$_lang["export_site_suffix"] = 'Sufijo de archivo:';
$_lang["export_site_target_unwritable"] = 'El directorio objetivo no es escribible.  Favor de asegurarte que el directorio sea escribible e intntalo otra vez.';
$_lang["export_site_time"] = 'Exportacin finalizada. Ha tomado %s segundos en completarse.';
$_lang["failed_login_message"] = 'Ingresa el nmero de ingresos fallidos permitidos antes de bloquear a un usuario.';
$_lang["failed_login_title"] = 'Intentos de ingreso fallidos:';
$_lang["fe_editor_lang_message"] = 'Seleccione un idioma para el editor, para cuando sea usado como editor frontal.';
$_lang["fe_editor_lang_title"] = 'Idioma del editor frontal:';
$_lang["file_delete_file"] = 'Borrar archivo';
$_lang["file_delete_folder"] = 'Borrar carpeta';
$_lang["file_deleted"] = 'xito!';
$_lang["file_download_file"] = 'Descargar archivo';
$_lang["file_download_unzip"] = 'Descomprimir archivo';
$_lang["file_folder_chmod_error"] = 'No es posible cambiar los permisos, necesitars cambiar los permisos fuera de MODx.';
$_lang["file_folder_created"] = 'Carpeta creada con xito!';
$_lang["file_folder_deleted"] = 'La carpeta fue borrada con xito!';
$_lang["file_folder_not_created"] = 'No es posible crear la carpeta';
$_lang["file_folder_not_deleted"] = 'No es posible borrar la carpeta. Por favor asegrate de que la carpeta est vaca antes de borrarla!';
$_lang["file_not_deleted"] = 'Fall!';
$_lang["file_not_saved"] = 'No se puede guardar el archivo, por favor asegrate de que el directorio objetivo es escribible!';
$_lang["file_saved"] = 'Archivo actualizado con xito!';
$_lang["file_unzip"] = 'La descompresin fue exitosa!';
$_lang["file_unzip_fail"] = 'La descompresin fall!';
$_lang["filemanager_path_message"] = 'IIS a menudo no actualiza la configuracin de document_root correctamente, que es usado por el administrador de archivos para determinar qu puedes ver. Si ests teniendo problemas usando el administrador de archivos, asegrate de que esta direccin apunta a la raz de tu instalacin MODx.';
$_lang["filemanager_path_title"] = 'Direccin del administrador de archivos:';
$_lang["files_access_denied"] = 'Acceso denegado!';
$_lang["files_data"] = 'Datos';
$_lang["files_dir_listing"] = 'Listando del directorio para:';
$_lang["files_directories"] = 'Directorios';
$_lang["files_dirwritable"] = 'Directorio escribible?';
$_lang["files_editfile"] = 'Editar archivo';
$_lang["files_file_type"] = 'Tipo de archivo: ';
$_lang["files_filename"] = 'Nombre de archivo';
$_lang["files_fileoptions"] = 'Opciones';
$_lang["files_files"] = 'Archivos';
$_lang["files_filesize"] = 'Tamao de archivo';
$_lang["files_filetype_notok"] = 'La subida de este tipo de archivo no est permitida!';
$_lang["files_modified"] = 'Modificado';
$_lang["files_top_level"] = 'Al nivel superior';
$_lang["files_up_level"] = 'Un nivel arriba';
$_lang["files_upload_copyfailed"] = 'Fallo el copiar el archivo al directorio de destino La subida fall!';
$_lang["files_upload_error"] = 'Error';
$_lang["files_upload_error0"] = 'Hubo un problema con tu subida.';
$_lang["files_upload_error1"] = 'El archivo que ests tratando de subir es demasiado grande.';
$_lang["files_upload_error2"] = 'El archivo que ests tratando de subir es demasiado grande.';
$_lang["files_upload_error3"] = 'El archivo que ests tratando de subir fue slo parcialmente subido.';
$_lang["files_upload_error4"] = 'Debes seleccionar un archivo a subir.';
$_lang["files_upload_error5"] = 'Hubo un problema con tu subida.';
$_lang["files_upload_inhibited_msg"] = '<b>Caracterstica de subida deshabilitada</b> - asegrate de que las subidas estn soportadas y que el directorio es escribible por PHP.<br />';
$_lang["files_upload_ok"] = 'Archivo subido con xito!';
$_lang["files_upload_permissions_error"] = 'Posibles problemas de permiso - el directorio al que quieres subir necesita ser escribible por tu servidor web.';
$_lang["files_uploadfile"] = 'Subir archivo';
$_lang["files_uploadfile_msg"] = 'Selecciona archivo a subir:';
$_lang["files_uploading"] = 'Subiendo <b>%s</b> a <b>%s/</b><br />';
$_lang["files_viewfile"] = 'Ver archivo';
$_lang["folder"] = 'Carpeta';
$_lang["forgot_password_email_fine_print"] = '* La URL anterior expirar una vez que cambies tu contrasea o despus de hoy.';
$_lang["forgot_password_email_instructions"] = 'Desde all podrs cambiar tu contrasea desde el men de Mi Cuenta.';
$_lang["forgot_password_email_intro"] = 'Se ha hecho una solicitud para cambiar la contrasea de su cuenta.';
$_lang["forgot_password_email_link"] = 'Haz clic aqu para completar el proceso.';
$_lang["forgot_your_password"] = 'Se te olvid tu contrasea?';
$_lang["friday"] = 'Viernes';
$_lang["friendly_alias_message"] = 'Si ests utilizando URLs amigables, y el documento tiene un alias, el alias siempre tiene preferencia sobre la URL amigable.  Configurando esta opcin a \'si\', el prefijo y sufijo de URL amigable tambin ser aplicado al alias.  Por ejemplo, si tu documento con ID 1 tiene un alias de `introduccin`, y has configurado un prefijo de `` y un sufijo de `.html`, configurando esta opcin a `si` generar `introduccion.html`.  Si no hay un alias, MODx generar `1.html` como enlace.';
$_lang["friendly_alias_title"] = 'Utilizar alias amigables:';
$_lang["friendlyurls_message"] = 'Esto te permite usar URLs amigables para los buscadores con MODx.  Favor de notar, que esto slo funciona en instalaciones MODx corriendo sobre Apache, y que debers escribir un archivo .htaccess para que esto funcione.  Ve el archivo .htaccess incluido en la distribucin para ms informacin.';
$_lang["friendlyurls_title"] = 'Usar URLs amigas:';
$_lang["friendlyurlsprefix_message"] = 'Aqu puedes especificar  el prefijo a usar por las URLs amigables.  Por ejemplo, una configuracin de prefijo \'page\' cambiar el URL /index.php?id=2 al URL amigable /page2.html (asumiendo que el sufijo est configurado a .html).  De esta forma puedes especificar lo qu tus usuarios (y buscadores) ven como enlaces en tu sitio.';
$_lang["friendlyurlsprefix_title"] = 'Prefijo para URLs amigables:';
$_lang["friendlyurlsuffix_message"] = 'Aqu puedes especificar el sufijo para las URLs amigables.  Especificando \'.html\' agregar .html a todas tus URLs amigables.';
$_lang["friendlyurlsuffix_title"] = 'Sufijo para URLs amigables:';
$_lang["functionnotimpl"] = 'Lo sentimos!';
$_lang["functionnotimpl_message"] = 'Esta funcin no ha sido implementada todava.';
$_lang["go"] = 'Ir';
$_lang["group_access_permissions"] = 'Acceso de grupo de usuarios';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Ayuda';
$_lang["help_msg"] = '<p>Puede obtener soporte gratuito de la comunidad <a href="http://modxcms.com/forums" target="_blank">visitando los foros de MODx</a>.  Tambin hay un cumulo creciente de <a href="http://modxcms.com/documentation" target="_blank">Documentacin y Guas MODx</a> que tocan virtualmente todos los aspectos de MODx.</p><p>Estamos planeando ofrecer servicios de soporte comercial para MODx. Por favor, <a href="mailto:modx@vertexworks.com?subject=MODx Commercial Support Inquiry">envenos un mensaje si est interesado</a>.';
$_lang["help_title"] = 'Ayuda';
$_lang["hide_tree"] = 'Ocultar rbol';
$_lang["home"] = 'Inicio';
$_lang["htmlsnippet_desc"] = 'Descripcin';
$_lang["htmlsnippet_management_msg"] = 'Aqu puedes seleccionar qu chunk deseas editar.';
$_lang["htmlsnippet_msg"] = 'Aqu puedes aadir/editar chunks.  Recuerda, los chunks son cdigo HTML \'plano\', por lo que cualquier cdigo PHP no ser procesado.';
$_lang["htmlsnippet_name"] = 'Nombre del chunk';
$_lang["htmlsnippet_title"] = 'Crear/editar chunk';
$_lang["icon"] = 'Icono';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Asignacin de padre:\n\nEl documento es un hijo del documento seleccionado.';
$_lang["illegal_parent_self"] = 'Asignacin de padre:\n\nEl documento seleccionado no puede ser asignado a s mismo.';
$_lang["import_files_found"] = '<b>Se encontraron %s documentos para importar...</b>';
$_lang["import_params"] = 'Parmetros compartidos del modulo de importacin';
$_lang["import_params_msg"] = 'Puedes importar los parmetros, o configuraciones de un mdulo seleccionando el nombre del mdulo en el siguiente men desplegable. <b>NOTA:</b> Para que los mdulos aparezcan dentro del men, este plugin/snippet debe ser parte del listado de dependencias del mdulo y el mdulo debe tener habilitado el compartir parametros. ';
$_lang["import_parent_resource"] = 'Documento padre:';
$_lang["import_site"] = 'Importar HTML';
$_lang["import_site_failed"] = 'Fall!';
$_lang["import_site_failed_db_error"] = 'Un error de base de datos ocurri mientras se trataba de clonar el documento: ';
$_lang["import_site_failed_no_open_dir"] = 'No se pudo abrir el directorio: ';
$_lang["import_site_failed_no_retrieve_file"] = 'No se pudo traer el archivo: ';
$_lang["import_site_html"] = 'Importar sitio desde HTML';
$_lang["import_site_importing_document"] = 'Importando archivo <b>%s</b> ';
$_lang["import_site_maxtime"] = 'Mximo tiempo de importacin:';
$_lang["import_site_maxtime_message"] = 'Aqu puedes especificar el nmero de segundos permitidos por el Administrador de Contenidos para importar el sitio (sobrepasando la configuracin de PHP). Ingresa 0 para un tiempo ilimitado.  Por favor nota, que usar un tiempo 0, o un nmero realmente grande, pueden provocar cosas extraas en tu servidor y no es recomendado.';
$_lang["import_site_message"] = 'Usando esta funcin puedes importar un sitio HTML completo a la base de datos.  Por favor nota que necesitars copiar tus archivos html y/o carpetas dentro de la carpeta assets/import.<p />Por favor llena la forma y presiona \'Importar\' para comenzar el proceso de importacin.  Los archivos importados sern guardados en el lugar seleccionada, utilizando, cuando sea posible, el nombre de archivo como el  alias del documento y el ttulo de pgina como el ttulo del documento.';
$_lang["import_site_skip"] = 'Saltado!';
$_lang["import_site_start"] = 'Comenzar importacin';
$_lang["import_site_success"] = 'xito!';
$_lang["import_site_time"] = 'Importacin finalizada.  Ha tomado %s segundos para completarse.';
$_lang["inbox"] = 'Bandeja de entrada';
$_lang["info"] = 'Info';
$_lang["information"] = 'Informacin';
$_lang["inline"] = 'En linea';
$_lang["insert"] = 'Insertar';
$_lang["keyword"] = 'Palabra clave';
$_lang["keywords"] = 'Palabras clave';
$_lang["keywords_intro"] = 'Para editar una palabra clave, simplemente escribe la nueva palabra clave en el campo de texto adyacente a la palabra clave que desees cambiar.  Para borrar una palabra clave, selecciona la caja \'borrar\' para esa palabra clave.  Si seleccionas la caja de borrar de la palabra clave, y tambin le cambias su nombre, ser borrada y el renombrado de la palabra clave no tendr efecto!';
$_lang["language_message"] = 'Seleccione el idioma para el Administrador de Contenido de MODx.';
$_lang["language_title"] = 'Idioma:';
$_lang["launch_site"] = 'Ver el sitio';
$_lang["link_attributes"] = 'Atributos de enlace';
$_lang["link_attributes_help"] = 'Ingresa atributos opcionales para un enlace para esta pgina, tal como "target=" o "rel=".';
$_lang["list_mode"] = 'Habilitar o deshabilitar el modo de listado - usado para listar todos los registros en el cuadriculado.';
$_lang["loading_doc_tree"] = 'Cargando rbol de documentos...';
$_lang["loading_menu"] = 'Cargando men...';
$_lang["loading_page"] = 'Por favor espera mientras MODx carga la pgina...';
$_lang["localtime"] = 'Tiempo local';
$_lang["lock_htmlsnippet"] = 'Bloquear edicin de chunk';
$_lang["lock_htmlsnippet_msg"] = 'Solamente administradores (Rol ID 1) pueden editar este chunk.';
$_lang["lock_module"] = 'Bloquear edicin de modulo';
$_lang["lock_module_msg"] = 'Solamente administradores (Rol ID 1) pueden editar este modulo.';
$_lang["lock_msg"] = '%s est actualmente editando este %s. Por favor, espera hasta que el otro usuario haya terminado e intenta nuevamente.';
$_lang["lock_plugin"] = 'Bloquear edicin del plugin';
$_lang["lock_plugin_msg"] = 'Solamente administradores (Rol ID 1) pueden editar este plugin.';
$_lang["lock_settings_msg"] = '%s est actualmente editando esta configuracin. Por favor, espera hasta que el otro usuario haya terminado e intenta nuevamente.';
$_lang["lock_snippet"] = 'Bloquear edicin del snippet';
$_lang["lock_snippet_msg"] = 'Solamente administradores (Rol ID 1) pueden editar este snippet.';
$_lang["lock_template"] = 'Bloquear edicin del template';
$_lang["lock_template_msg"] = 'Solamente administradores (Rol ID 1) pueden editar este template.';
$_lang["lock_tmplvars"] = 'Bloquear edicin de la variable';
$_lang["lock_tmplvars_msg"] = 'Solamente administradores (Rol ID 1) pueden editar esta variable.';
$_lang["locked"] = 'Bloqueado';
$_lang["login_allowed_days"] = 'Das permitidos';
$_lang["login_allowed_days_message"] = 'Selecciona los das en los que este usuario est permitido a iniciar una sesin.';
$_lang["login_allowed_ip"] = 'Direccin IP permitida';
$_lang["login_allowed_ip_message"] = 'Ingresa las direcciones IP con las que este usuario tiene permitido iniciar sesin. <b>NOTA: Separa mltiples direcciones de IP mediante comas (,)</b>';
$_lang["login_button"] = 'Entrar';
$_lang["login_cancelled_install_in_progress"] = 'Este sitio est en el proceso de instalacin/actualizacin. <br />Favor de volver a intentarlo en un par de minutos!.<br />';
$_lang["login_cancelled_site_was_updated"] = 'Se acaba de ejecutar una instalacin/actualizacin de este sitio. Favor de volver a entrar.<br />';
$_lang["login_captcha_message"] = 'Por favor, ingresa el cdigo de seguridad mostrado en la grfica.  Si no puedes leer el cdigo, haz clic en la imagen para generar una nueva o contacta a tu administrador del sitio.';
$_lang["login_homepage"] = 'Pgina de entrada';
$_lang["login_homepage_message"] = 'Ingresa el ID del documento al que quieres enviar al usuario despus que haya entrado. <b>NOTA: asegrate de que el ID que ingreses pertenezca a un documento existente, que ha sido publicado y que es accesible por el usuario.</b>';
$_lang["login_message"] = 'Por favor ingresa tus credenciales de entrada para comenzar tu sesin en el Administrador.  Tu nombre de usuario y contrasea son sensitivas a las maysculas, por favor ingrsalas con cuidado.';
$_lang["logo_slogan"] = 'Administrador de Contenido MODx - \nCrea y haz ms con menos';
$_lang["logout"] = 'Salir';
$_lang["long_title"] = 'Ttulo largo';
$_lang["mail_check_timeperiod_message"] = 'Que tan frecuente checar por mensajes de correo nuevos en el Admin, en segundos.';
$_lang["mail_check_timeperiod_title"] = 'Perodo de chequeo del correo:';
$_lang["manage_depends"] = 'Admin Dependencias';
$_lang["manage_files"] = 'Admin Archivos';
$_lang["manage_htmlsnippets"] = 'Chunks';
$_lang["manage_metatags"] = 'Admin etiquetas META y Palabras claves';
$_lang["manage_modules"] = 'Admin Modulos';
$_lang["manage_plugins"] = 'Plugins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Templates';
$_lang["manager"] = 'Administrador';
$_lang["manager_lockout_message"] = 'Ests actualmente dentro del Administrador de Contenido.  Si deseas cerrar tu sesin por favor haz clic en el botn de "Salir". <p />Para ir a tu pgina de inicio o pgina principal, haz clic en el botn de "Inicio".';
$_lang["manager_permissions"] = 'Permisos del Administrador';
$_lang["manager_theme"] = 'Tema del Administrador:';
$_lang["manager_theme_message"] = 'Selecciona el tema para el Administrador de Contenido.';
$_lang["messages"] = 'Mensajes';
$_lang["messages_all"] = 'Todos';
$_lang["messages_compose"] = 'Escribe un mensaje';
$_lang["messages_forward"] = 'Reenviar';
$_lang["messages_from"] = 'Desde';
$_lang["messages_group"] = 'Un grupo';
$_lang["messages_inbox"] = 'Bandeja de entrada';
$_lang["messages_message"] = 'Mensaje';
$_lang["messages_no_messages"] = 'No hay mensajes en la bandeja de entrada.';
$_lang["messages_not_allowed_to_read"] = 'No tienes permitido leer este mensaje!';
$_lang["messages_private"] = 'Privado';
$_lang["messages_read_message"] = 'Leer mensaje';
$_lang["messages_reply"] = 'Responder';
$_lang["messages_select_group"] = 'Selecciona un grupo';
$_lang["messages_select_user"] = 'Selecciona un usuario';
$_lang["messages_send"] = 'Enviar';
$_lang["messages_send_to"] = 'Enviar a';
$_lang["messages_sent"] = 'Enviar en';
$_lang["messages_subject"] = 'Asunto';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'Mensajes';
$_lang["messages_user"] = 'Un usuario';
$_lang["meta_keywords"] = 'Palabras Clave META';
$_lang["metatag_intro"] = 'En esta pgina puedes borrar, crear o editar Etiquetas META (METAtags).  Para enlazar etiquetas META a documentos haz clic en la pestaa <u>Palabras Clave META</u> cuando edites el documento y selecciona las etiquetas META y las Palabras Clave deseadas.  Para aadir una etiqueta nueva ingresa el nombre y valor y haz clic en el botn \'Agregar etiqueta\'.  Para editar la etiqueta haz clic en el nombre de la etiqueta dentro de la cuadrcula de datos.';
$_lang["metatag_notice"] = 'Quiz quieras ver la <a href="http://www.html-reference.com/META.asp" target="_blank">Gua de Referencia HTML</a> para ms informacin.  Esta no es una lista completa de posibles etiquetas Meta.</a>';
$_lang["metatags"] = 'Etiquetas META';
$_lang["mgr_access_permissions"] = 'Permisos de acceso al Administrador';
$_lang["mgr_login_start"] = 'Inicio de Entrada al Administrador';
$_lang["mgr_login_start_message"] = 'Ingresa el ID del documento al que quieres enviar al usuario despus de que haya salido del Administrador.  <b>NOTA: asegrate de que el ID ingresado pertenece a un documento existente, y que ha sido publicado y es accesible por el usuario!</b>';
$_lang["mgrlog_action"] = 'Accin';
$_lang["mgrlog_actionid"] = 'ID de accin';
$_lang["mgrlog_anyall"] = 'Cualquiera/Todos';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() regres falso.';
$_lang["mgrlog_datefr"] = 'Fecha de';
$_lang["mgrlog_dateinvalid"] = 'Formato de fecha no vlido.';
$_lang["mgrlog_dateto"] = 'Fecha para';
$_lang["mgrlog_emptysrch"] = 'Tu consulta de bsqueda ha obtenido un conjunto de resultados vaco (por ej. no hay coincidencias de registros encontrados).';
$_lang["mgrlog_field"] = 'Campo';
$_lang["mgrlog_itemid"] = 'ID del Artculo';
$_lang["mgrlog_itemname"] = 'Nombre del Artculo';
$_lang["mgrlog_msg"] = 'Mensaje';
$_lang["mgrlog_noquery"] = 'No se ha ingresado una consulta de bsqueda todava.';
$_lang["mgrlog_qresults"] = 'Resultados de Consulta';
$_lang["mgrlog_query"] = 'Bitcora de Consultas';
$_lang["mgrlog_query_msg"] = 'Por favor haz una seleccin para ver la bitcora.  Puedes seleccionar entradas en la bitcora por fecha, pero est alerta de que las fechas que ingreses no sean inclusivas - para seleccionar todos las entradas a la bitcora del 01-01-2004, configura \'fecha de\' como 01-01-2004 y \'fecha a\' como 02-01-2004.<br /><br />El mensaje y la accin son generalmente lo mismo.  Si ests buscando por un mensaje especfico, es mejor configurar accin como \'Cualquiera/Todos\'.';
$_lang["mgrlog_results"] = 'No. de resultados';
$_lang["mgrlog_searchlogs"] = 'Registro de bsquedas';
$_lang["mgrlog_sortinst"] = 'Puedes ordenar las tablas haciendo clic en los encabezados de columna. Si las bitcoras estn llegando a ser muy grandes, puedes <a href="index.php?a=55">vaciar</a> las bitcoras. Esto remover todas las entradas de la bitcora hasta ahora y no puede ser deshecho!';
$_lang["mgrlog_time"] = 'Tiempo';
$_lang["mgrlog_user"] = 'Usuario';
$_lang["mgrlog_username"] = 'Nombre de usuario';
$_lang["mgrlog_value"] = 'Valor';
$_lang["mgrlog_view"] = 'Ver registros del Administrador';
$_lang["module_code"] = 'Cdigo de mdulo (php)';
$_lang["module_config"] = 'Configuracin de modulo';
$_lang["module_desc"] = 'Descripcin';
$_lang["module_disabled"] = 'Modulo deshabilitado';
$_lang["module_edit_click_title"] = 'Haz clic aqu para editar este mdulo';
$_lang["module_group_access_msg"] = 'Selecciona los grupos de usuarios que tienen permitido ejecutar este mdulo desde el Administrador de Contenido.';
$_lang["module_management"] = 'Administrar Mdulos';
$_lang["module_management_msg"] = 'Elige el mdulo que quisieras ejecutar o modificar. Para correr el mdulo haz clic en el icono en la cuadrcula. Para modificarlo haz clic en el nombre del mdulo.';
$_lang["module_msg"] = 'Aadir/editar Mdulos. Un Mdulo es una coleccin de Elementos (ej. plugins, snippets, etc).';
$_lang["module_name"] = 'Nombre del mdulo';
$_lang["module_resource_msg"] = 'Aade o remueve Elementos de los que depende este mdulo. Para aadir un Elemento nuevo haz clic en uno de los botones de aadir aqu debajo.';
$_lang["module_resource_title"] = 'Dependencias del mdulo';
$_lang["module_title"] = 'Crear/editar Mdulo';
$_lang["module_viewdepend_msg"] = 'Ve los Elementos asignados de los que depende este mdulo.  Haz clic en el botn "Dependencias del Admin" para modificar las dependencias';
$_lang["modules"] = 'Mdulos';
$_lang["modx_news"] ='Noticias de MODx';
$_lang["modx_news_tab"] ='Noticias de MODx';
$_lang["modx_news_title"] ='Noticias de MODx';
$_lang["modx_security_notices"] ='Notas de Seguridad de MODx';
$_lang["modx_version"] = "Versin de MODx";
$_lang["monday"] = 'Lunes';
$_lang["move"] = 'Mover';
$_lang["move_resource"] = 'Mover documento';
$_lang["move_resource_message"] = 'Puedes mover el documento y todos sus hijos seleccionando un nuevo padre en el rbol.  Si seleccionas un documento que no es un contenedor, ser combiado a uno.  Por favor, haz clic en el nuevo padre en el rbol.';
$_lang["move_resource_new_parent"] = 'Por favor selecciona un nuevo padre en el rbol de documentos.';
$_lang["move_resource_title"] = 'Mover documento';
$_lang["name"] = 'Nombre';
$_lang["new_category"] = 'Categora Nueva';
$_lang["new_file_permissions_message"] = 'Cuando se est subiendo un  archivo nuevo en el Administrador de Archivos, este intentar cambiar los permisos a los ingresados en esta configuracin.  Esto puede que no funcione en algunas configuraciones, tales como en IIS, en cuyo caso necesitars cambiar manualmente los permisos.';
$_lang["new_file_permissions_title"] = 'Permisos del Archivo Nuevo';
$_lang["new_folder_permissions_message"] = 'Cuando se est creando una  carpeta nueva en el Administrador de Archivos, este intentar cambiar los permisos a los ingresados en esta configuracin.  Esto puede que no funcione en algunas configuraciones, tales como en IIS, en cuyo caso necesitars cambiar manualmente los permisos.';
$_lang["new_folder_permissions_title"] = 'Permisos de la Carpeta Nueva';
$_lang["new_htmlsnippet"] = 'Chunk nuevo';
$_lang["new_keyword"] = 'Aadir palabra clave nueva:';
$_lang["new_module"] = 'Mdulo nuevo';
$_lang["new_parent"] = 'Padre nuevo';
$_lang["new_plugin"] = 'Plugin nuevo';
$_lang["new_role"] = 'Crear un rol nuevo';
$_lang["new_snippet"] = 'Snippet nuevo';
$_lang["new_template"] = 'Template nuevo';
$_lang["new_tmplvars"] = 'Variable de template nueva';
$_lang["new_user"] = 'Usuario nuevo';
$_lang["new_web_user"] = 'Usuario Web nuevo ';
$_lang["no"] = 'No';
$_lang["no_active_users_found"] = 'No se encontraron usuarios activos.';
$_lang["no_activity_message"] = 'No has creado o editado algn documento todava.';
$_lang["no_category"] = 'no categorizado';
$_lang["no_docs_pending_publishing"] = 'No hay documentos con publicacin pendiente.';
$_lang["no_docs_pending_pubunpub"] = 'No se encontraron Eventos';
$_lang["no_docs_pending_unpublishing"] = 'No hay documentos con despublicacin pendiente.';
$_lang["no_edits_creates"] = 'No se encontraron ediciones o creaciones.';
$_lang["no_groups_found"] = 'No se encontraron Grupos.';
$_lang["no_keywords_found"] = 'Actualmente no hay palabras clave.';
$_lang["no_records_found"] = 'No se encontraron registros.';
$_lang["no_results"] = 'No se encontraron resultados';
$_lang["nologentries_message"] = 'Ingresa el nmero de entradas de bitcora  mostradas por pgina cuando navegue por la Auditora.';
$_lang["nologentries_title"] = 'Nmero de entradas de registro:';
$_lang["nomessages_message"] = 'Ingresa el nmero de mensajes a mostrar en la bandeja de entrada cuando veas mensajes.';
$_lang["nomessages_title"] = 'Nmero de mensajes:';
$_lang["none"] = 'Ninguno';
$_lang["noresults_message"] = 'Ingresa el nmero de resultados a mostrar en la cuadrcula de datos cuando veas listados y resultados de bsqueda.';
$_lang["noresults_title"] = 'Nmero de Resultados:';
$_lang["not_deleted"] = 'no ha sido borrado.';
$_lang["not_set"] = 'No configurado';
$_lang["offline"] = 'Fuera de lnea';
$_lang["online"] = 'En lnea';
$_lang["onlineusers_action"] = 'Accin';
$_lang["onlineusers_actionid"] = 'ID-de-Accin';
$_lang["onlineusers_ipaddress"] = 'Direccin IP del usuario';
$_lang["onlineusers_lasthit"] = 'ltima visita';
$_lang["onlineusers_message"] = 'Esta lista muestra todos los usuarios activos durante los ltimos 20 minutos (la hora actual es ';
$_lang["onlineusers_title"] = 'Usuarios en lnea';
$_lang["onlineusers_user"] = 'Usuario';
$_lang["onlineusers_userid"] = 'ID de usuario';
$_lang["optimize_table"] = 'Haz clic aqu para optimizar esta tabla';
$_lang["page_data_cacheable"] = 'Cacheable';
$_lang["page_data_cacheable_help"] = 'Dejando este campo seleccionado permitir que el documento sea guardado en el cache.  Si tu documento contiene snippets, asegrate de que este campo no est seleccionado.';
$_lang["page_data_cached"] = '<b>Fuente obtenida desde el cache:</b>';
$_lang["page_data_changes"] = 'Cambios';
$_lang["page_data_contentType"] = 'Tipo de Contenido';
$_lang["page_data_contentType_help"] = 'Selecciona el tipo de contenido para  este documento.  Si no ests seguro de qu tipo de contenido debe de tener el documento, simplemente djalo como text/html.';
$_lang["page_data_created"] = 'Creado';
$_lang["page_data_edited"] = 'Editado';
$_lang["page_data_editor"] = 'Editar usando el editor de texto formateado';
$_lang["page_data_folder"] = 'El documento es contenedor';
$_lang["page_data_general"] = 'General';
$_lang["page_data_markup"] = 'Marcado/estructura';
$_lang["page_data_mgr_access"] = 'Acceso del Administrador';
$_lang["page_data_notcached"] = 'Este documento (todava) no ha sido cacheado.';
$_lang["page_data_publishdate"] = 'Fecha de publicacin';
$_lang["page_data_publishdate_help"] = 'Si configuras una fecha de publicacin, el documento serpa publicado tan pronto como la fecha de publicacin sea efectiva.  Haz clic en el icono de calendario para seleccionar una fecha, o en el icono junto al mismo para remover la fecha de publicacin.  Esto significar que el documento nunca ser automticamente publicado.';
$_lang["page_data_published"] = 'Publicado';
$_lang["page_data_searchable"] = 'Buscable';
$_lang["page_data_searchable_help"] = 'Checando este campo permitir al documento ser buscado.  Tambin puedes usar este campo para otros propsitos en tus snippets.';
$_lang["page_data_source"] = 'Fuente';
$_lang["page_data_status"] = 'Estado';
$_lang["page_data_template"] = 'Usar template';
$_lang["page_data_template_help"] = 'Seleccionar template para este documento.';
$_lang["page_data_title"] = 'Datos de la Pgina';
$_lang["page_data_unpublishdate"] = 'Fecha de despublicacin';
$_lang["page_data_unpublishdate_help"] = 'Si configuras una fecha de despublicacin, el documento ser despublicado tan pronto como la fecha de despublicacn sea efectiva.  Haz clic en el icono de calendario para seleccionar una fecha, o en el icono junto al mismo para remover la fecha de despublicacin.  Esto significar que el documento nunca ser automticamente despublicado.';
$_lang["page_data_unpublished"] = 'Despublicado';
$_lang["page_data_web_access"] = 'Acceso web';
$_lang["pagetitle"] = 'Ttulo del documento';
$_lang["pagination_table_first"] = "Primero";
$_lang["pagination_table_gotopage"] = "Ir a la pgina";
$_lang["pagination_table_last"] = "ltimo";
$_lang["paging_first"] = 'primero';
$_lang["paging_last"] = 'ltimo';
$_lang["paging_next"] = 'siguiente';
$_lang["paging_prev"] = 'previo';
$_lang["paging_showing"] = 'Mostrando';
$_lang["paging_to"] = 'a';
$_lang["paging_total"] = 'total';
$_lang["parameter"] = 'Parmetro';
$_lang["password"] = 'Contrasea';
$_lang["password_change_request"] = 'Solicitud de cambio de contrasea';
$_lang["password_gen_gen"] = 'Deja que MODx genere una contrasea.';
$_lang["password_gen_length"] = 'La contrasea que especificaste necesita  tener al menos 6 caracteres.';
$_lang["password_gen_method"] = 'Mtodo de contrasea nuevo';
$_lang["password_gen_specify"] = 'Djame especificar la contrasea:';
$_lang["password_method"] = 'Mtodo de notificacin de contrasea';
$_lang["password_method_email"] = 'Enviar la contrasea nueva por email.';
$_lang["password_method_screen"] = 'Mostrar la contrasea nueva en la pantalla.';
$_lang["password_msg"] = 'La contrasea nueva para <b>%s</b> es <b>%s</b>.';
$_lang["php_version_check"] = 'MODx es compatible con PHP Versin 5.0.0 y superior.  Por favor actualiza tu instalacin de PHP!';
$_lang["plugin"] = 'Plugin';
$_lang["plugin_code"] = 'Cdigo de plugin(php)';
$_lang["plugin_config"] = 'Configuracin de plugin';
$_lang["plugin_desc"] = 'Descripcin';
$_lang["plugin_disabled"] = 'Plugin deshabilitado';
$_lang["plugin_event_msg"] = 'Selecciona los eventos que quisieras que este plugin escuchara.';
$_lang["plugin_management_msg"] = 'Elige qu plugin quieres editar.';
$_lang["plugin_msg"] = 'Aadir/editar plugins.  Los plugins usan cdigo PHP que es invocado cuando los dispara un Evento del Sistema especfico.';
$_lang["plugin_name"] = 'Nombre del plugin';
$_lang["plugin_priority"] = 'Editar el orden de Ejecucin de Plugins por Evento';
$_lang["plugin_priority_instructions"] = 'Arrastra para re-ordenar los Plugins bajo cada encabezado de Eventos.  El primer plugin en ejecutarse deber ir hasta arriba.';
$_lang["plugin_priority_title"] = 'Orden de Ejecucin de Plugins';
$_lang["plugin_title"] = 'Crear/editar Plugin';
$_lang["preview"] = 'Previsualizar';
$_lang["preview_msg"] = 'Esta es una previsualizacin de tus ltimos cambios guardados.  Haz clic aqu para <a href="#" onclick="saveRefreshPreview();">Guardar y Recargar</a> tus cambios actuales';
$_lang["preview_resource"] = 'Previsualizar documento';
$_lang["private"] = 'Privado';
$_lang["public"] = 'Pblico';
$_lang["publish_date"] = 'Fecha de publicacin';
$_lang["publish_events"] = 'Publicar eventos';
$_lang["publish_resource"] = 'Publicar documento';
$_lang["rb_base_dir_message"] = 'Ingresa la direccin fsica del directorio del Navegador de Archivos.  Esta configuracin es normalmente generada automticamente.  Si ests usando IIS, sin embargo, MODx tal vez no pueda encontrar la direccin por si mismo, causando que el Navegador de Archivos muestre un error.  En este caso, puedes ingresar la direccin al directorio de imgenes aqu (la direccin como la ves en el Explorador de Windows). <b>NOTA:</b> El directorio del Navegador de Archivos debe contener las  imgenes, archivos, flash y medios de los subdirectorios para que el Navegador de Archivos funcione correctamente.';
$_lang["rb_base_dir_title"] = 'Direccin Base de Archivos:';
$_lang["rb_base_url_message"] = 'Ingresa la direccin virtual al directorio de archivos.  Esta configuracin es normalmente generada automticamente.  Si ests usando IIS, MODx tal vez no pueda encontrar la direccin por si mismo, causando que el Navegador de Archivos muestre un error.  En este caso, puede ingresar la direccin al directorio de imgenes aqu (la direccin como la ves en el Explorador de Windows).';
$_lang["rb_base_url_title"] = 'URL del Navegador de Archivos:';
$_lang["rb_message"] = 'Selecciona si para habilitar el Navegador de Archivos.  Esto permitir a tus usuarios navegar y subir archivos como imgenes, flash y medios al servidor.';
$_lang["rb_title"] = 'Habilitar el Navegador de Archivos:';
$_lang["rb_webuser_message"] = 'Quieres permitir a un usuario web la habilidad de usar el Navegador de Archivos? <b>ADVERTENCIA:</b> Permitiendo a los usuarios web el uso del navegador de archivos expone los archivos disponibles a los usuarios administrativos.  Slo usa esta opcin para usuarios web confiables.';
$_lang["rb_webuser_title"] = 'Usuarios Web?';
$_lang["recent_docs"] = 'Documentos recientes';
$_lang["refresh_cache"] = 'Cache: Se encontraron <b>%s</b> archivos en el directorio cache y se borraron <b>%d</b> archivos cacheados.<p>Los nuevos archivos cacheados sern creados cuando las pginas sean solicitadas.';
$_lang["refresh_published"] = '<b>%s</b> documentos fueron publicados.';
$_lang["refresh_site"] = 'Limpiar cache';
$_lang["refresh_title"] = 'Recargar sitio';
$_lang["refresh_tree"] = 'Recargar rbol';
$_lang["refresh_unpublished"] = '<b>%s</b> documentos fueron despublicados.';
$_lang["remember_username"] = 'Recordarme';
$_lang["remove"] = 'Remover';
$_lang["remove_date"] = 'Remover fecha';
$_lang["remove_locks"] = 'Remover Bloqueos';
$_lang["rename"] = 'Renombrar';
$_lang["reports"] = 'Reportes';
$_lang["require_tagname"] = 'Un nombre de etiqueta es requerido';
$_lang["require_tagvalue"] = 'Un valor para la etiqueta es requeridos';
$_lang["reset"] = 'Reajustar';
$_lang["reset_failedlogins"] = 'reajustar';
$_lang["resource"] = 'Documento';
$_lang["resource_alias"] = 'Alias del documento';
$_lang["resource_alias_help"] = 'Configura el alias del URL para hacer el documento accesible como http://ejemplo.com/alias.  Esto slo funciona si los URLs amigables estn habilitados en la configuracin del sitio.';
$_lang["resource_content"] = 'Contenido del documento';
$_lang["resource_description"] = 'Descripcin';
$_lang["resource_description_help"] = 'Puedes escribir una descripcin opcional del documento.';
$_lang["resource_duplicate"] = 'Duplicar Documento';
$_lang["resource_long_title_help"] = 'Escribe un ttulo ms largo para tu documento.  Esto es bueno para los buscadores, y puede ser ms descriptivo para tu documento.';
$_lang["resource_metatag_help"] = 'Selecciona las etiquetas META o palabras clave que desea asignar a este documento. Mantn presionada la tecla CTRL para seleccionar mltiples palabras clave o etiquetas META.';
$_lang["resource_opt_contentdispo"] = 'Disposicin del contenido';
$_lang["resource_opt_contentdispo_help"] = 'Usa el campo de disposicin del contenido para especificar cmo debe ser manejado este documento por el navegador. Para descarga de archivos selecciona la opcin de Adjunto.';
$_lang["resource_opt_emptycache"] = 'Vaciar Cache?';
$_lang["resource_opt_emptycache_help"] = 'Dejando marcado este campo har que MODx vace el cache despus de que guardes el documento. De esta forma tus visitantes no vern una versin vieja del documento.';
$_lang["resource_opt_folder"] = 'Contenedor?';
$_lang["resource_opt_folder_help"] = 'Selecciona esto para hacer que el documento tambin acte como un contenedor de otros documentos. Un \'contenedor\' es como una carpeta, slo que tambin puede tener contenido.';
$_lang["resource_opt_menu_index"] = 'Indice del men';
$_lang["resource_opt_menu_index_help"] = 'El Indice del men es un campo que puedes usar para ordenar los documentos en tus snippet(s) de men. Tambin puedes usarlo para cualquier otro propsito en tus snippets.';
$_lang["resource_opt_menu_title"] = 'Ttulo del men';
$_lang["resource_opt_menu_title_help"] = 'El Ttulo del men es un campo que puedes usar para mostrar un ttulo corto para el documento dentro de tus snippet(s) de men o mdulos.';
$_lang["resource_opt_published"] = 'Publicado?';
$_lang["resource_opt_published_help"] = 'Selecciona este campo para publicar el documento inmediatamente despus de guardarlo.';
$_lang["resource_opt_richtext"] = 'Texto Formateado?';
$_lang["resource_opt_richtext_help"] = 'Deja este campo seleccionado para utilizar el editor de texto formateado para editar documentos. Si tus documentos contienen JavaScript y formas, deselecciona esto para editarlos en modo HTML y as el editor no deshace tus documentos.';
$_lang["resource_opt_show_menu"] = 'Mostrar en men';
$_lang["resource_opt_show_menu_help"] = 'Selecciona esta opcin para mostrar el documento dentro de un men web. Por favor nota que algunos constructores de mens pueden elegir ignorar esta opcin.';
$_lang["resource_opt_trackvisit_help"] = 'Registrar cada visita del visitante a esta pgina';
$_lang["resource_overview"] = 'Vista general del documento';
$_lang["resource_parent"] = 'Padre del documento';
$_lang["resource_parent_help"] = 'Haz clic en el icono de arriba para habilitar (o deshabilitar) seleccionar el padre de este documento. Luego, haz clic en un documento del rbol para seleccionar su nuevo padre.';
$_lang["resource_permissions_error"] = 'Asigna este Documento a por lo menos un Grupo de Documentos al que puedas acceder.';
$_lang["resource_setting"] = 'Configuracin de documento';
$_lang["resource_summary"] = 'Resumen (introtext)';
$_lang["resource_summary_help"] = 'Escribe un resumen corto del documento';
$_lang["resource_title"] = 'Ttulo';
$_lang["resource_title_help"] = 'Escribe aqu el nombre/ttulo del documento. Trata de evitar el uso de barras diagonales en el nombre!';
$_lang["resource_to_be_moved"] = 'Documento a mover';
$_lang["resource_weblink_help"] = 'Escribe la direccin del objeto que deseas referenciar con este enlace web aqu.';
$_lang["resources_in_container"] = "documentos en este contenedor";
$_lang["resources_in_container_no"] = "Este contenedor no tiene documentos-hijos.";
$_lang["role"] = 'Rol';
$_lang["role_about"] = 'Ver la pgina Nosotros';
$_lang["role_access_persmissions"] = 'Permisos de acceso';
$_lang["role_actionok"] = 'Ver la pantalla de accin completada';
$_lang["role_bk_manager"] = 'Usar el Administrador de Respaldo';
$_lang["role_cache_refresh"] = 'Vaciar la cache del sitio';
$_lang["role_change_password"] = 'Cambiar la contrasea';
$_lang["role_chunk_management"] = 'Administracin de Chunks';
$_lang["role_config_management"] = 'Administracin de la configuracin';
$_lang["role_content_management"] = 'Administracin de contenido';
$_lang["role_create_chunk"] = 'Crear chunks nuevos';
$_lang["role_create_doc"] = 'Crear documentos nuevos';
$_lang["role_create_plugin"] = 'Crear plugins nuevos';
$_lang["role_create_snippet"] = 'Crear snippets nuevos';
$_lang["role_create_template"] = 'Crear templates del sitio nuevos';
$_lang["role_credits"] = 'Ver los crditos';
$_lang["role_delete_chunk"] = 'Borrar chunks';
$_lang["role_delete_doc"] = 'Borrar documentos';
$_lang["role_delete_eventlog"] = 'Borrar bitcora de eventos';
$_lang["role_delete_module"] = 'Borrar mdulo';
$_lang["role_delete_plugin"] = 'Borrar plugins';
$_lang["role_delete_role"] = 'Borrar roles';
$_lang["role_delete_snippet"] = 'Borrar snippets';
$_lang["role_delete_template"] = 'Borrar templates';
$_lang["role_delete_user"] = 'Borrar usuarios';
$_lang["role_delete_web_user"] = 'Borrar usuarios web';
$_lang["role_edit_chunk"] = 'Editar chunks';
$_lang["role_edit_doc"] = 'Editar un documento';
$_lang["role_edit_doc_metatags"] = 'Editar las etiquetas META y palabras clave del documento';
$_lang["role_edit_module"] = 'Editar modulo';
$_lang["role_edit_plugin"] = 'Editar plugins';
$_lang["role_edit_role"] = 'Editar roles';
$_lang["role_edit_settings"] = 'Cambiar la configuracin del sitio';
$_lang["role_edit_snippet"] = 'Editar snippets';
$_lang["role_edit_template"] = 'Editar templates del sitio';
$_lang["role_edit_user"] = 'Editar usuarios';
$_lang["role_edit_web_user"] = 'Editar usuarios web';
$_lang["role_empty_trash"] = 'Purgar permanentemente documentos borrados';
$_lang["role_errors"] = 'Ver dilogo de error';
$_lang["role_eventlog_management"] = 'Administracin del bitcora de eventos';
$_lang["role_export_static"] = 'Exportar HTML Esttico';
$_lang["role_file_manager"] = 'Usar el administrador de archivos';
$_lang["role_frames"] = 'Solicitar marcos del administrador';
$_lang["role_help"] = 'Ver las pginas de ayuda';
$_lang["role_home"] = 'Solicitar pgina de inicio del administrador';
$_lang["role_import_static"] = 'Importar HTML';
$_lang["role_logout"] = 'Salir del administrador';
$_lang["role_manage_metatags"] = 'Administrar las etiquetas META y las Palabras clave del sitio';
$_lang["role_management_msg"] = 'Elige el rol que deseas editar.';
$_lang["role_management_title"] = 'Roles';
$_lang["role_messages"] = 'Ver y enviar mensajes';
$_lang["role_module_management"] = 'Administracin de Mdulos';
$_lang["role_name"] = 'Nombre de rol';
$_lang["role_new_module"] = 'Crear un mdulo nuevo';
$_lang["role_new_role"] = 'Crear roles nuevos';
$_lang["role_new_user"] = 'Crear usuarios nuevos';
$_lang["role_new_web_user"] = 'Crear usuarios web nuevos';
$_lang["role_plugin_management"] = 'Administracin de Plugins';
$_lang["role_publish_doc"] = 'Publicar documentos';
$_lang["role_role_management"] = 'Roles';
$_lang["role_run_module"] = 'Correr mdulo';
$_lang["role_save_chunk"] = 'Guardar chunks';
$_lang["role_save_doc"] = 'Guardar documentos';
$_lang["role_save_module"] = 'Guardar mdulo';
$_lang["role_save_password"] = 'Guardar contrasea';
$_lang["role_save_plugin"] = 'Guardar plugins';
$_lang["role_save_role"] = 'Guardar roles';
$_lang["role_save_snippet"] = 'Guardar snippets';
$_lang["role_save_template"] = 'Guardar templates';
$_lang["role_save_user"] = 'Guardar usuarios';
$_lang["role_save_web_user"] = 'Guardar usuarios web';
$_lang["role_snippet_management"] = 'Administracin de snippets';
$_lang["role_template_management"] = 'Administracin de templates';
$_lang["role_title"] = 'Crear/editar rol';
$_lang["role_udperms"] = 'Administracin de permisos';
$_lang["role_user_management"] = 'Administracin de usuarios';
$_lang["role_view_docdata"] = 'Ver los datos de un documento';
$_lang["role_view_eventlog"] = 'Ver la bitcora de eventos';
$_lang["role_view_logs"] = 'Ver la bitcora del sistema';
$_lang["role_view_unpublished"] = 'Ver Documentos No Publicados';
$_lang["role_web_access_persmissions"] = 'Permisos de acceso web';
$_lang["role_web_user_management"] = 'Administracin de usuarios web';
$_lang["rss_url_news_default"] = 'http://feeds.feedburner.com/modx-announce';
$_lang["rss_url_news_message"] = 'Ingresa el URL del Feed de Noticias de MODx.';
$_lang["rss_url_news_title"] = 'Feed RSS de Noticias';
$_lang["rss_url_security_default"] = 'http://feeds.feedburner.com/modxsecurity';
$_lang["rss_url_security_message"] = 'Ingresa el URL para el Feed de Seguridad MODx.';
$_lang["rss_url_security_title"] = 'Feed RSS de Seguridad';
$_lang["run_module"] = 'Correr mdulo';
$_lang["saturday"] = 'Sbado';
$_lang["save"] = 'Guardar';
$_lang["save_all_changes"] = 'Guardar todos los cambios';
$_lang["save_tag"] = 'Guardar etiquetas';
$_lang["saving"] = 'Guardando,favor de esperar...';
$_lang["search"] = 'Buscar';
$_lang["search_criteria"] = 'Criterio de bsqueda';
$_lang["search_criteria_content"] = 'Buscar por contenido';
$_lang["search_criteria_content_msg"] = 'Encontrar todos los documentos con el texto ingresado en su contenido.';
$_lang["search_criteria_id"] = 'Buscar por ID';
$_lang["search_criteria_id_msg"] = 'Ingresar el ID de un documento para encontrar rpidamente ese documento.';
$_lang["search_criteria_longtitle"] = 'Buscar por ttulo largo';
$_lang["search_criteria_longtitle_msg"] = 'Buscar todos los documentos con el texto ingresado en su ttulo largo.';
$_lang["search_criteria_title"] = 'Buscar por ttulo';
$_lang["search_criteria_title_msg"] = 'Encontrar todos los documentos con el texto ingresado en su ttulo.';
$_lang["search_empty"] = 'Tu bsqueda no ha regresado resultados. Por favor  ampla tus criterios de bsqueda e intntalo nuevamente.';
$_lang["search_item_deleted"] = 'Este artculo ha sido borrado';
$_lang["search_results"] = 'Resultados de la bsqueda';
$_lang["search_results_returned_desc"] = 'Descripcin';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Tu criterio de bsqueda regres <b>%s</b> documentos.  Si se han encontrado demasiados resultados, intenta ingresar una bsqueda ms especifica.  Las dos columnas a la izquierda te  permiten encontrar el documento en el rbol o ver el documento. Las dos columnas a la derecha muestran, respectivamente, si un documento ha sido borrado y cul es su estado de publicacin.<p />';
$_lang["search_results_returned_title"] = 'Ttulo';
$_lang["search_view_docdata"] = 'Ver este artculo';
$_lang["security"] = 'Seguridad';
$_lang["security_notices_tab"] ='Notas de Seguridad';
$_lang["security_notices_title"] ='Notas de Seguridad';
$_lang["select_date"] = 'Selecciona una fecha';
$_lang["send"] = 'Enviar';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Si tu sitio est en una conexin https, por favor especifcalo aqu.';
$_lang["server_protocol_title"] = 'Tipo de servidor:';
$_lang["serveroffset"] = 'Offset del servidor';
$_lang["serveroffset_message"] = 'Selecciona el nmero de horas de diferencia entre donde te encuentras y donde est el servidor.  La hora  actual del servidor es <b>[%s]</b>, la hora actual del servidor usando el offset guardado actual es <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Hora offset del servidor:';
$_lang["servertime"] = 'Hora del servidor';
$_lang["settings_after_install"] = 'Como esta es una nueva instalacin, te requiere que controles estas configuraciones, y cambies cualquiera que desees.  Despus de que hayas controlado la configuracin, presiona \'Guardar\' para actualizar la base de datos de configuracin.<br /><br />';
$_lang["settings_config"] = 'Configuracin';
$_lang["settings_dependencies"] = 'Dependencias';
$_lang["settings_events"] = 'Eventos del Sistema';
$_lang["settings_furls"] = 'URLs amigables';
$_lang["settings_general"] = 'General';
$_lang["settings_misc"] = 'Administrador de Archivos';
$_lang["settings_page_settings"] = 'Configuracin de Pgina';
$_lang["settings_photo"] = 'Foto';
$_lang["settings_properties"] = 'Propiedades';
$_lang["settings_site"] = 'Sitio';
$_lang["settings_strip_image_paths_message"] = 'Si esto est configurado \'No\', MODx escribir las fuentes del navegador de archivos (imgenes, archivos, flash, etc.) como URLs absolutas.  Las URLs relativas son de ayuda si deseas mover tu instalacin de MODx, p.ej. de un servidor de trabajo a uno de produccin.  Si no tienes idea de qu significa esto, ser mejor lo dejes seleccionado en \'Si\'.';
$_lang["settings_strip_image_paths_title"] = 'Re-escribir las direcciones del navegador?';
$_lang["settings_templvars"] = 'Variables de Template';
$_lang["settings_title"] = 'Configuracin de sistema';
$_lang["settings_ui"] = 'Interfase y Caractersticas';
$_lang["settings_users"] = 'Usuario';
$_lang["show_tree"] = 'Mostrar rbol';
$_lang["showing"] = 'Mostrando';
$_lang["signupemail_message"] = 'Configurar el mensaje de email enviado a los usuarios cuando se les cree una cuenta  incluyendo su nombre de usuario y su contrasea. <br /><b>Nota:</b> Los siguiente placeholders son remplazados por el Administrador de Contenido cuando el mensaje es enviado: <br /><br />[+sname+] - Nombre de tu sitio web, <br />[+saddr+] - La direccin electrnica de tu sitio web, <br />[+surl+] - La direccin url de tu sitio, <br />[+uid+] - El nombre o id del usuario, <br />[+pwd+] - La contrasea del usuario, <br />[+ufn+] - El nombre completo del usuario. <br /><br /><b>Deja el [+uid+] y [+pwd+] en el email, o el nombre de usuario y la contrasea no sern enviados en el email y tus usuarios no los conocern!</b>';
$_lang["signupemail_title"] = 'Correo electrnico de inicio de sesin:';
$_lang["site"] = 'Sitio';
$_lang["site_schedule"] = 'Horario';
$_lang["sitename_message"] = 'Ingresa el nombre de tu sitio aqu.';
$_lang["sitename_title"] = 'Nombre del sitio:';
$_lang["sitestart_message"] = 'Ingresa el ID del documento que quieres usar como pgina principal aqu. <b>NOTA: Asegrate de que el ID ingresado pertenece a un documento existente y de que ha sido publicado!</b>';
$_lang["sitestart_title"] = 'Inicio del sitio:';
$_lang["sitestatus_message"] = 'Selecciona \'En Lnea\' para publicar tu sitio en la red.  Si seleccionas \'Fuera de Lnea\', tus visitantes vern el mensaje de \'Sitio No Disponible\', y no podrn navegar por el mismo.';
$_lang["sitestatus_title"] = 'Estado del sitio:';
$_lang["siteunavailable_message"] = 'Mensaje a mostrar cuando el sitio est fuera de lnea o cuando ocurra un error. <b>Nota: Este mensaje slo ser mostrado si no est activa la pgina de Sitio no disponible.</b>';
$_lang["siteunavailable_message_default"] = 'Este sitio no est disponible en este momento.';
$_lang["siteunavailable_page_message"] = 'Ingresa el ID del documento que quieres usar como pgina fuera de lnea. <b>NOTA: Asegrate de que el ID ingresado pertenece a un documento existente y que ha sido publicado!</b>';
$_lang["siteunavailable_page_title"] = 'Pgina de sitio no disponible:';
$_lang["siteunavailable_title"] = 'Mensaje de sitio no disponible:';
$_lang["snippet"] = 'Snippet';
$_lang["snippet_code"] = 'Cdigo de snippet (php)';
$_lang["snippet_desc"] = 'Descripcin';
$_lang["snippet_execonsave"] = 'Ejecutar el snippet despus de guardarlo.';
$_lang["snippet_management_msg"] = 'Elige el snippet que deseas editar.';
$_lang["snippet_msg"] = 'Aadir/editar snippets. Recuerda, los snippets son cdigo PHP \'plano\', y si esperas que la salida del snippet sea mostrada en algn momento dentro de un template, necesitars regresar el valor desde dentro del snippet.';
$_lang["snippet_name"] = 'Nombre de snippet';
$_lang["snippet_properties"] = 'Propiedades prefijadas';
$_lang["snippet_title"] = 'Crear/editar snippet';
$_lang["sort_asc"] = 'Ascendente';
$_lang["sort_desc"] = 'Descendente';
$_lang["sort_tree"] = 'Ordenar el rbol';
$_lang["source"] = 'Fuente';
$_lang["stay"] = 'Continuar editando';
$_lang["stay_new"] = 'Aadir otro';
$_lang["submit"] = 'Enviar';
$_lang["sunday"] = 'Domingo';
$_lang["sys_alert"] = 'Alerta de Sistema';
$_lang["sysinfo_activity_message"] = 'Esta lista muestra qu documentos han sido editados recientemente por tus usuarios.';
$_lang["sysinfo_userid"] = 'Usuario';
$_lang["system_email_signup"] = "Hola [+uid+] \n\nAqu tienes los detalles de inicio de sesin para el Administrador de Contenido de [+sname+]:\n\nNombre de usuario: [+uid+]\nContrasea: [+pwd+]\n\nUna vez que has ingresado al Administrador de Contenido de ([+surl+]), puedes cambiar tu contrasea.\n\nSaludos,\nEl Administrador";
$_lang["system_email_webreminder"] = "Hola [+uid+]\n\nPara activar tu contrasea nueva haz clic en el siguiente enlace:\n\n[+surl+]\n\nSi tienes xito puedes usar la siguiente contrasea para ingresar:\n\nContrasea:[+pwd+]\n\nSi no solicitaste este email entonces por favor ignralo.\n\nSaludos,\nEl Administrador";
$_lang["system_email_websignup"] = "Hola [+uid+] \n\nAqu tienes los detalles de ingreso para [+sname+]:\n\nNombre de usuario: [+uid+]\nContrasea: [+pwd+]\n\nUna vez que ingreses a [+sname+] ([+surl+]), puedes cambiar tu contrasea.\n\nSaludos,\nEl Administrador";
$_lang["table_hoverinfo"] = 'Pasa el ratn sobre el nombre de la tabla para ver una corta descripcin de su funcin (no todas las tablas tienen <i>comentarios</i> configurados).';
$_lang["table_prefix"] = 'Prefijo de tabla';
$_lang["tag"] = 'Etiqueta';
$_lang["template"] = 'Template';
$_lang["template_assignedtv_tab"] = 'Variables de Template Asignadas';
$_lang["template_code"] = 'Cdigo de template (html)';
$_lang["template_desc"] = 'Descripcin';
$_lang["template_edit_tab"] = 'Editar template';
$_lang["template_management_msg"] = 'Elige qu template deseas editar.';
$_lang["template_msg"] = 'Crea y edita templates.  Los templates nuevos o  modificados no sern visibles en las pginas cacheadas de tu sitio hasta que el cache sea vaciado , sin embargo, puedes usar la funcin de previsualizacin en una pgina para ver el template en accin.';
$_lang["template_name"] = 'Nombre del template';
$_lang["template_no_tv"] = 'Todava no se han asignado variables de template a este template.';
$_lang["template_reset_all"] = 'Reajusta todas las pginas a usar el template prefijado';
$_lang["template_reset_specific"] = 'Reajusta solamente \'%s\' pginas';
$_lang["template_title"] = 'Crear/editar template';
$_lang["template_tv_edit"] = 'Editar el orden de clasificacin de las variables de template';
$_lang["template_tv_edit_message"] = 'Arrastra para re-ordenar las Variables de Template para este template.';
$_lang["template_tv_edit_title"] = 'Orden de Clasificacin de las Variables de Template';
$_lang["template_tv_msg"] = 'Las variables de template asignadas a este template estn listadas aqu abajo.';
$_lang["thursday"] = 'Jueves';
$_lang["tmplvar_access_msg"] = 'Selecciona los grupos de documentos que tienen permitido modificar el contenido o el valor de esta variable';
$_lang["tmplvar_change_template_msg"] = 'Cambiando este template causar que la pgina recargue las Variables de Template, perdiendo cualquier cambio que no haya sido guardado.\n\n Ests seguro de que quieres cambiar este template?';
$_lang["tmplvar_inuse"] = 'Los siguientes documentos estn usando esta Variable de Template actualmente. Para continuar con la operacin de borrado haz clic en el botn de Borrar de otra manera haz clic en el botn de Cancelar.';
$_lang["tmplvar_tmpl_access"] = 'Acceso a Template';
$_lang["tmplvar_tmpl_access_msg"] = 'Selecciona los templates que tienen permitido acceder/procesar esta variable';
$_lang["tmplvars"] = 'Variables de Template';
$_lang["tmplvars_binding_msg"] = 'Este campo soporta vnculos de fuente de datos usando comandos @';
$_lang["tmplvars_caption"] = 'Subttulo';
$_lang["tmplvars_default"] = 'Valor Prefijado';
$_lang["tmplvars_description"] = 'Descripcin';
$_lang["tmplvars_elements"] = 'Valores de Opcin de Ingreso';
$_lang["tmplvars_management_msg"] = 'Administrar campos de contenido personalizados adicionales (Variables de Template) para tus documentos.';
$_lang["tmplvars_msg"] = 'Aade o edita variables de template aqu. Las variables de template deben ser asignadas a templates para poder acceder a ellas desde snippets y documentos.';
$_lang["tmplvars_name"] = 'Nombre de Variable';
$_lang["tmplvars_novars"] = 'No se encontraron Variables de Template';
$_lang["tmplvars_rank"] = 'Orden de Clasificacin';
$_lang["tmplvars_reset_params"] = 'Reajustar parmetros';
$_lang["tmplvars_type"] = 'Tipo de Entrada';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Propiedades de Widget';
$_lang["to"] = 'a';
$_lang["tools"] = 'Herramientas';
$_lang["top_howmany_message"] = 'Cuando ests viendo reportes qu tan largas deben de ser las listas de \'Mejores...\'?';
$_lang["top_howmany_title"] = 'Cuntos mejores';
$_lang["total"] = 'total';
$_lang["track_visitors_message"] = 'Esta configuracin no tendr efecto hasta que tengas un programa de seguimiento de visitantes o de estadsticas instalado que lo soporte. Registrar a las visitas te permitir ver las estadsticas de uso de tu sitio web.';
$_lang["track_visitors_title"] = 'Bitcora de visitas (estadsticas)';
$_lang["tree_show_protected"] = 'Mostrar pginas protegidas';
$_lang["tree_show_protected_message"] = 'Si configurado a "No", las Pginas Protegidas (y todos sus documentos hijos) no aparecen en el rbol de documentos. "No" es la configuracin anterior de MODx.';
$_lang["truncate_table"] = 'Haz clic aqu para truncar esta tabla';
$_lang["tuesday"] = 'Martes';
$_lang["tv"] = 'TV';
$_lang["type"] = 'Tipo';
$_lang["udperms_allowroot_message"] = 'Quieres permitir que tus usuarios puedan crear documentos nuevos en la raz de tu sitio? ';
$_lang["udperms_allowroot_title"] = 'Permitir raz:';
$_lang["udperms_message"] = 'Los permisos de acceso te permiten especificar qu pginas tienen permitido editar tus usuarios.  Necesitars asignar tus usuarios a grupos de usuario, tus documentos a grupos de documento, y despus debers especificar qu grupos de usuarios tienen permitido editar qu grupos de documentos.  Slo los Administradores tendrn permitido editar documentos cuando actives esto por primera vez.';
$_lang["udperms_title"] = 'Usar permisos de acceso:';
$_lang["unable_set_link"] = 'No es posible configurar el enlace!';
$_lang["unable_set_parent"] = 'No es posible configurar padre nuevo!';
$_lang["unauthorizedpage_message"] = 'Ingresa el ID del documento al que quieres enviar a los usuarios si han solicitado un documento seguro o no autorizado. <b>NOTA: asegrate de que el ID ingresado pertenece a un documento existente y que ha sido publicado y es pblicamente accesible!</b>';
$_lang["unauthorizedpage_title"] = 'Pgina no autorizada:';
$_lang["unblock_message"] = 'Este usuario no ser bloqueado despus de guardar los datos del usuario.';
$_lang["undelete_resource"] = 'Recuperar documento';
$_lang["unpublish_date"] = 'Fecha de despublicacin';
$_lang["unpublish_events"] = 'Despublicar Eventos';
$_lang["unpublish_resource"] = 'Despublicar documento';
$_lang["untitled_resource"] = 'Documento sin ttulo';
$_lang["untitled_weblink"] = 'Enlace web sin ttulo';
$_lang["update_params"] = 'Actualizar la muestra de parmetros';
$_lang["update_settings_from_language"] = 'Reemplazar el actual con:';
$_lang["upload_maxsize_message"] = 'Ingresa el tamao mximo de archivo a ser subido por el Administrador de archivos. El tamao de archivo a subir debe de ser ingresado en bytes. <b>NOTA: Archivos grandes pueden demorar mucho tiempo para subir!</b>';
$_lang["upload_maxsize_title"] = 'Tamao mximo de subida';
$_lang["uploadable_files_message"] = 'Ingresa una lista de archivos que pueden ser subidos a \'assets/files/\' usando el Navegador de Archivos. Por favor ingresa las extensiones para los tipos de archivos, separados por comas.';
$_lang["uploadable_files_title"] = 'Tipos de Archivos subibles:';
$_lang["uploadable_flash_message"] = 'Ingresa la lista de archivos que pueden ser subidos a \'assets/flash/\' usando el Administrador de Archivos. Por favor ingresa las extensiones para tipos de archivos flash, separados por comas.';
$_lang["uploadable_flash_title"] = 'Tipos de Archivos Flash subibles:';
$_lang["uploadable_images_message"] = 'Ingresa una lista de archivos que pueden ser subidos a \'assets/images/\' usando el Administrador de Archivos. Por favor ingresa las extensiones para tipos de imgenes, separados por comas.';
$_lang["uploadable_images_title"] = 'Tipos de Imgenes subibles:';
$_lang["uploadable_media_message"] = 'Ingresa una lista de archivos que pueden ser subidos a \'assets/media/\' usando el Administrador de Archhivos. Por favor ingresa las extensiones para tipos de archivos media, separados por comas.';
$_lang["uploadable_media_title"] = 'Tipos de Archivo Media subibles:';
$_lang["use_alias_path_message"] = 'Configurando esta opcin a \'si\' mostrar la direccin completa al documento si el documento tiene un alias. Por ejemplo, si un documento con un alias llamado \'hijo\' est ubicado dentro de un documento contenedor con un alias llamado \'padre\', entonces la direccin alias completa al documento ser \'/padre/hijo.html\'.<br /><b>NOTA: Cuando se configura esta opcin a \'Si\' (activando direccin alias), referencia a los artculos (como imgenes, css, javascripts, etc) utilizando su direccin absoluta: por ej., \'/assets/images\' en vez de  \'assets/images\'. Haciendo esto prevendrs que el navegador (o servidor web) agregue la direccin relativa al alias.</b>';
$_lang["use_alias_path_title"] = 'Usar direccin alias amigable:';
$_lang["use_editor_message"] = 'Quieres habilitar el editor de contenido formateado?  Si ests ms cmodo escribiendo HTML, entonces puedes deshabilitarlo usando esta configuracin. Nota que sta configuracin aplica a todos los documentos y todos los usuarios!';
$_lang["use_editor_title"] = 'Habilitar editor:';
$_lang["user"] = 'Usuario';
$_lang["user_block"] = 'Bloqueado';
$_lang["user_blockedafter"] = 'Bloqueado despus';
$_lang["user_blockeduntil"] = 'Bloqueado antes';
$_lang["user_changeddata"] = 'Tus datos han sido cambiados. Por favor ingresa nuevamente.';
$_lang["user_country"] = 'Pas';
$_lang["user_dob"] = 'Fecha de nacimiento';
$_lang["user_doesnt_exist"] = 'El usuario no existe';
$_lang["user_edit_self_msg"] = '<b>Necesitas cerrar la sesin e iniciarla nuevamente despus de actualizar completamente tu informacin.</b><br>Tambin, si eliges generar una contrasea nueva para t, te ser enviada en un email.';
$_lang["user_email"] = 'Direccin de correo electrnico';
$_lang["user_failedlogincount"] = 'Ingresos fallidos';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Femenino';
$_lang["user_full_name"] = 'Nombre completo';
$_lang["user_gender"] = 'Gnero';
$_lang["user_is_blocked"] = 'Este usuario est bloqueado!';
$_lang["user_logincount"] = 'Nmero de ingresos';
$_lang["user_male"] = 'Masculino';
$_lang["user_management_msg"] = 'Elige el Administrador de Contenido a editar. Los usuarios del Administrador de Contenido son esos usuarios que tienen permitido ingresar al Administrador de Contenido';
$_lang["user_management_title"] = 'Usuarios Administradores';
$_lang["user_mobile"] = 'Celular';
$_lang["user_phone"] = 'Telfono';
$_lang["user_photo"] = 'Foto del usuario';
$_lang["user_photo_message"] = 'Ingresa el url de la imagen para este usuario o usa el botn de insertar para seleccionar o subir una imagen al servidor.';
$_lang["user_prevlogin"] = 'ltimo ingreso';
$_lang["user_role"] = 'Rol del usuario';
$_lang["user_state"] = 'Estado o Provincia';
$_lang["user_title"] = 'Crear/Editar usuario';
$_lang["user_upload_message"] = ' Si deseas evitar que este usuario suba cualquier tipo de archivos en esta categora, asegrate de que la caja de seleccin \'Usar Configuracin Principal\' no est seleccionada y deja vaco el campo.';
$_lang["user_use_config"] = 'Usar Configuracin Principal';
$_lang["user_zip"] = 'Cdigo postal';
$_lang["username"] = 'Nombre de usuario';
$_lang["users"] = 'Seguridad';
$_lang["validate_referer_message"] = 'Validar el encabezado de HTTP_REFERER para reducir el riesgo de que tus editores de contenido sean engaados a efectuar acciones no intencionadas en el administrador como vctimas de un ataque CSRF (Cross Site Request Forgery -- Solicitud de Sitio Cruzada Falsa).  Algunas configuraciones no podrn usar esta opcin si el servidor no est enviando los encabezados HTTP_REFERER.';
$_lang["validate_referer_title"] = 'Validar encabezados HTTP_REFERER?';
$_lang["value"] = 'Valor';
$_lang["version_codename"] = "Nombre del cdigo de la Versin";
$_lang["view"] = 'Ver';
$_lang["view_child_resources_in_container"] = "Ver hijos";
$_lang["view_log"] = 'Ver bitcora';
$_lang["view_logging"] = 'Acciones del Administrador';
$_lang["view_sysinfo"] = 'Informacin del sistema';
$_lang["warning"] = 'Advertencia!';
$_lang["warning_not_saved"] = 'Los cambios que has realizado todava no han sido guardados.  Puedes elegir quedarte en la pgina actual para guardar los cambios (\'Cancelar\'), o puedes dejar esta pgina, perdiendo cualquier cambio que hayas realizado (\'OK\').';
$_lang["web_access_permissions"] = 'Permisos de acceso web';
$_lang["web_access_permissions_user_groups"] = 'Grupo de Usuarios Web:';
$_lang["web_permissions"] = 'Permisos Web';
$_lang["web_user_management_msg"] = 'Elige qu usuario web deseas editar. Los usuarios web son aquellos usuarios que slo tienen permitido ingresar en el sitio web';
$_lang["web_user_management_title"] = 'Usuarios Web';
$_lang["web_user_title"] = 'Crear/editar usuario web';
$_lang["web_users"] = 'Usuarios web';
$_lang["weblink"] = 'Enlace web';
$_lang["webpwdreminder_message"] = 'Ingresa un mensaje a ser enviado a tus usuarios web cuando soliciten una contrasea nueva va email. El Administrador de Contenido enviar un email conteniendo su nueva contrasea y la informacin de activacin. <br /><b>Nota:</b> Los siguientes placeholders son reemplazados por el Administrador de Contenidos cuando el mensaje es enviado: <br /><br />[+sname+] - Nombre de tu sitio web, <br />[+saddr+] - La direccin de correo electrnico de tu sitio, <br />[+surl+] - La direccin url de tu sitio, <br />[+uid+] - El nombre o id de ingreso del usuario, <br />[+pwd+] - Contrasea del usuario, <br />[+ufn+] - Nombre completo del usuario. <br /><br /><b>Deja [+uid+] y [+pwd+] en el mensaje, de otro modo el nombre de usuario y la contrasea no sern enviadas en el mensaje y tus usuarios no la conocern!</b>';
$_lang["webpwdreminder_title"] = 'Email de Recordatorio Web:';
$_lang["websignupemail_message"] = 'Configura el mensaje de email enviado a los usuarios cuando creen una cuenta incluyendo su nombre de usuario y su contrasea. <br /><b>Nota:</b> Los siguientes placeholders son reemplazados por el Administrador de Contenidos cuando el mensaje es enviado: <br /><br />[+sname+] - Nombre de tu sitio web, <br />[+saddr+] - La direccin de correo electrnico de tu sitio, <br />[+surl+] - La direccin url de tu sitio, <br />[+uid+] - El nombre o id de ingreso del usuario, <br />[+pwd+] - la Contrasea del usuario, <br />[+ufn+] - Nombre completo del usuario. <br /><br /><b>Deja [+uid+] y [+pwd+] en el mensaje, de otro modo el nombre de usuario y la contrasea no sern enviadas en el mensaje y tus usuarios no lo conocern!</b>';
$_lang["websignupemail_title"] = 'Email de Registro Web:';
$_lang["wednesday"] = 'Mircoles';
$_lang["welcome_messages"] = 'Tu Bandeja de Entrada contiene <strong>%d</strong> mensaje(s), de los cuales <strong>%s</strong> no han sido ledos.';
$_lang["welcome_title"] = 'Bienvenido a tu Administrador de Contenido MODx';
$_lang["which_editor_message"] = 'Selecciona el editor de texto formateado.  Puedes descargar e instalar editores de texto formateado adicionales desde la pgina de descargas de MODx.';
$_lang["which_editor_title"] = 'Editor a usar:';
$_lang["working"] = 'Trabajando...';
$_lang["wrap_lines"] = 'Encapsular lneas (wrap)';
$_lang["xhtml_urls_message"] = 'Reemplaza los signos & (&amp;) en los URLs generados por MODx con el htmlentity &amp<!-- -->amp; que es XHTML vlido.';
$_lang["xhtml_urls_title"] = 'URLs XHTML';
$_lang["yes"] = 'Si';
$_lang["you_got_mail"] = 'Tienes Email';
$_lang["yourinfo_message"] = 'Esta seccin muestra alguna informacin acerca de t:';
$_lang["yourinfo_previous_login"] = 'Tu ltimo ingreso:';
$_lang["yourinfo_role"] = 'Tu rol es:';
$_lang["yourinfo_title"] = 'Tu informacin';
$_lang["yourinfo_total_logins"] = 'Nmero total de ingresos:';
$_lang["yourinfo_username"] = 'Ests ingresado como:';
?>