<?php
/**
 * MODX Manager language file
 *
 * @version 1.0.15
 * @date 2014/02/24
 * @author Mikko Lammi, www.maagit.fi, Kari Söderholm
 *
 * @language Finnish
 * @package modx
 * @subpackage manager
 *
 * Please commit your language changes on Transifex (https://www.transifex.com/projects/p/modx-evolution/) or on GitHub (https://github.com/modxcms/evolution).
 */
//$modx_textdir = 'rtl'; // uncomment this line for RTL langauges
$modx_lang_attribute = 'fi'; // Manager HTML/XML Language Attribute see http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'UTF-8';

$_lang["about_msg"] = 'MODX on <a href="https://evo.im/" target="_blank">PHP-sovelluskehys ja sisällönhallintajärjestelmä</a>, jonka lisenssinä on avoimen lähdekoodin <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'Tietoa MODX:stä';
$_lang["access_permission_denied"] = 'Ei käyttöoikeuksia tähän sivuun.';
$_lang["access_permission_parent_denied"] = 'Ei käyttöoikeuksia luoda sivua tähän!';
$_lang["access_permissions"] = 'Käyttöoikeudet';
$_lang["access_permissions_add_resource_group"] = 'Uusi sivuryhmä';
$_lang["access_permissions_add_user_group"] = 'Uusi käyttäjäryhmä';
$_lang["access_permissions_docs_collision"] = 'Web-käyttöoikeudet ja ylläpidon käyttöoikeudet ovat ristiriidassa käyttäjäroolisi kanssa, joten tämä sivu julkaistaan normaalisti. Ota yhteyttä sivuston pääkäyttäjään selvittääksesi asian.';
$_lang["access_permissions_docs_message"] = 'Valitse sivun käyttöoikeudet:';
$_lang["access_permissions_group_link"] = 'Luo uusi yhteys';
$_lang["access_permissions_introtext"] = 'Muokkaa käyttäjä- ja sivuryhmiä.';
$_lang["access_permissions_link_to_group"] = 'sivuryhmään';
$_lang["access_permissions_link_user_group"] = 'Yhdistä käyttäjäryhmä';
$_lang["access_permissions_links"] = 'Käyttäjä- ja sivuryhmien yhteydet';
$_lang["access_permissions_links_tab"] = 'Yhdistä käyttäjäryhmät ja sivuryhmät toisiinsa. Määrittele käyttäjäryhmien oikeudet lisäämällä kunkin käyttäjäryhmän alaisuuteen tarvittavat sivuryhmät.';
$_lang["access_permissions_no_resources_in_group"] = 'Ei yhtään.';
$_lang["access_permissions_no_users_in_group"] = 'Ei yhtään.';
$_lang["access_permissions_off"] = '<span class="warning">Käyttöoikeuksia ei ole aktivoitu.</span> Tämän vuoksi yhdelläkään tässä tehdyllä ei ole vaikutusta ennenkuin käyttöoikeudet on aktivoitu.';
$_lang["access_permissions_resource_groups"] = 'Sivuryhmät';
$_lang["access_permissions_resources_in_group"] = '<strong>Sivut ryhmässä:</strong> ';
$_lang["access_permissions_resources_tab"] = 'Muokkaa sivuryhmiä. Lisää yksittäinen sivu ryhmään tai poista yksittäinen sivu ryhmästä muokkaamalla suoraan kyseistä sivua.';
$_lang["access_permissions_user_groups"] = 'Ylläpidon käyttäjäryhmät';
$_lang["access_permissions_user_message"] = 'Valitse käyttäjän käyttäjäryhmät:';
$_lang["access_permissions_users_in_group"] = '<strong>Käyttäjiä ryhmässä:</strong> ';
$_lang["access_permissions_users_tab"] = 'Muokkaa käyttäjäryhmiä. Lisää yksittäinen käyttäjä ryhmään tai poista yksittäinen käyttäjä ryhmästä muokkaamalla suoraan kyseistä käyttäjää. Käyttäjillä, joiden rooli on pääkäyttäjä (Adminstrator), on aina oikeudet kaikkiin sivuihin.';
$_lang["account_email"] = 'Käyttäjän sähköpostiosoite';
$_lang["actioncomplete"] = '<strong>Toiminto onnistui!</strong><br /> - Odota hetki...';
$_lang["activity_message"] = 'Lista viimeksi luoduista tai muokatuista sivuista';
$_lang["activity_title"] = 'Viimeisimmät sivut';
$_lang["add"] = 'Lisää';
$_lang["add_chunk"] = 'Lisää HTML-palanen';
$_lang["add_doc"] = 'Lisää sivu';
$_lang["add_folder"] = 'Uusi kansio';
$_lang["add_plugin"] = 'Lisää liitännäinen';
$_lang["add_resource"] = 'Uusi sivu';
$_lang["add_snippet"] = 'Lisää PHP-palanen';
$_lang["add_tag"] = 'Lisää metatieto';
$_lang["add_template"] = 'Lisää sivupohja';
$_lang["add_tv"] = 'Lisää sivupohjan muuttuja';
$_lang["add_weblink"] = 'Uusi hyperlinkki';
$_lang["administrator_role_message"] = 'Pääkäyttäjän roolia ei voi muokata tai poistaa.';
$_lang["administrators"] = 'Pääkäyttäjät';
$_lang["after_saving"] = 'Tallennuksen jälkeen';
$_lang["alert_delete_self"] = 'Et voi poistaa itseäsi!';
$_lang["alias"] = 'Alias';
$_lang["all_doc_groups"] = 'Kaikki sivuryhmät (julkinen sivu)';
$_lang["all_events"] = 'Kaikki tapahtumat';
$_lang["all_usr_groups"] = 'Kaikki käyttäjäryhmät';
$_lang["allow_mgr_access"] = 'Pääsy ylläpitoon';
$_lang["allow_mgr_access_message"] = 'Sallitaanko käyttäjälle pääsy ylläpitoon vai vain sivuston muokkaaminen esikatselutilassa. <strong>HUOMAA:</strong> Jos pääsyä ylläpitoon ei ole, käyttäjä ohjataan aloitussivulle.';
$_lang["already_deleted"] = 'on jo poistettu.';
$_lang["attachment"] = 'Liite';
$_lang["automatic_alias_message"] = 'Sivun alias voidaan luoda automaattisesti sivun otsikon perusteella tallennuksen yhteydessä.';
$_lang["automatic_alias_title"] = 'Luo sivun alias automaattisesti:';
$_lang["backup"] = 'Varmuuskopiointi';
$_lang["bk_manager"] = 'Varmuuskopiointi';
$_lang["block_message"] = 'Tämä käyttäjä estetään käyttäjätietojen tallennuksen jälkeen!';
$_lang["blocked_minutes_message"] = 'Kuinka moneksi minuutiksi käyttäjän tunnus lukitaan, kun epäonnistuneita kirjautumisyrityksiä tulee likaa. Anna arvo pelkkinä numeroina, ei pilkkuja, pisteitä tms.';
$_lang["blocked_minutes_title"] = 'Lukittu minuuteiksi:';
$_lang["cache_files_deleted"] = 'Seuraavat tiedostot poistettiin:';
$_lang["cancel"] = 'Peruuta';
$_lang["captcha_code"] = 'Varmistuskoodi';
$_lang["captcha_message"] = 'Ota varmistuskoodit (CAPTCHA) käyttöön turvallisuuden parantamiseksi. Tällöin ylläpitoon kirjautumisen yhteydessä on syötettävä myös kuvassa näkyvä varmistukoodi.';
$_lang["captcha_title"] = 'Käytä varmistuskoodeja:';
$_lang["captcha_words_default"] = 'MODX,Todellisuus,Oikeus,Turvallisuus,Koodi,Palanen,Parempi,Kuvaus,Voitto,Edistynyt,Nauti,Osoite,Ohjain,Geneettinen,Valo,Kevyt,Mukavuus,Suomi,Internet,Kysely,Sivupohja,Usein,Nettisivut,Tatuointi,Keltainen,Punainen,Sininen,Ruskea,Musta,Valkoinen,Oranssi,Nauru,Mukana,Laskuvarjo,Uinti,Fantasia,Palindromi,Rehellisyys,Nopea,Ihminen,Tietokone,Palapeli,Monitori,Ikkuna,Valinta,Painike';
$_lang["captcha_words_message"] = 'Lista varmistuskoodeina (CAPTCHA) käytetävistä sanoista. Erottele sanat pilkuilla. Kenttään mahtuu enintään 255 merkkiä.';
$_lang["captcha_words_title"] = 'Varmistuskoodi -sanat (CAPTCHA):';
$_lang["category_heading"] = 'Kategoria';
$_lang["category_msg"] = 'Muokkaa elementtejä.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Muuta nimi';
$_lang["change_password"] = 'Muuta salasana';
$_lang["change_password_confirm"] = 'Varmista salasana';
$_lang["change_password_message"] = 'Syötä uusi salasana ja varmista salasana (uusi salasana toiseen kertaan). Salasanan tulee olla 6-15 merkkiä pitkä.';
$_lang["change_password_new"] = 'Uusi salasana';
$_lang["charset_message"] = 'Valitse käytettävä merkistö [(modx_charset)] asetukselle. Tällä valinnalla ei ole merkitystä MODX ylläpidon merkistökoodaukseen. Monet kolmannen osapuolen resurssit käyttävät [(modx_charset)] asetusta oletusmerkistönä.';
$_lang["charset_title"] = 'Merkistö:';
$_lang["chunk"] = 'Palanen';
$_lang["chunk_code"] = 'Lähdekoodi (html)';
$_lang["chunk_multiple_id"] = 'Virhe: Usealla HTML-palasella on sama yksilötunnus (ID).';
$_lang["chunk_no_exist"] = 'HTML-palasta ei ole.';
$_lang["cleaningup"] = 'Odota hetki...';
$_lang["clean_uploaded_filename"] = 'Use Transliteration for File Uploads';
$_lang["clean_uploaded_filename_message"] = 'Use the default or transalias settings for the file name to clean special characters from uploaded file names, preserving dot-characters (periods)';
$_lang["clear_log"] = 'Tyhjennä loki';
$_lang["click_to_context"] = 'Napsauta päästäksesi kontekstivalikkoon';
$_lang["click_to_edit_title"] = 'Muokkaa napsauttamalla tästä';
$_lang["click_to_view_details"] = 'Näytä yksityiskohdat napsauttamalla tästä';
$_lang["close"] = 'Sulje';
$_lang["code"] = 'Lähdekoodi';
$_lang["collapse_tree"] = 'Kutista';
$_lang["comment"] = 'Kommentti';
$_lang["configcheck_admin"] = 'Ole ystävällinen ja ota yhteyttä sivuston pääkäyttäjään ja varoita häntä tästä viestistä!';
$_lang["configcheck_cache"] = 'Välimuisti-kansioon (cache) ei voi kirjoittaa';
$_lang["configcheck_cache_msg"] = 'MODX ei voi kirjoittaa välimuistikansioon (cache). MODX toimii yhä kuten pitääkin, mutta mitään ei ladata välimuistiin. Ratkaise ongelma antamalla /_cache/ kansioon kirjoitusoikeudet.';
$_lang["configcheck_configinc"] = 'Asetustiedostoon voi yhä kirjoittaa';
$_lang["configcheck_configinc_msg"] = 'Pahantahtoiset henkilöt voivat hyödyntää tätä murtautuakseen sivustollesi. Korjaa ongelma poistamalla tiedostosta (/[+MGR_DIR+]/includes/config.inc.php) kirjoitusoikeudet!';
$_lang["configcheck_default_msg"] = 'Määrittelemätön varoitus on löytynyt. Outoa.';
$_lang["configcheck_errorpage_unavailable"] = 'Virhesivua ei ole saatavilla.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Virhesivulle ei ole käyttöoikeutta tai sitä ei ole olemassa. Tämä voi aiheuttaa ongelmia sivustolla. Varmista, ettei sivulle ole määritetty web-käyttäjäryhmää.';
$_lang["configcheck_errorpage_unpublished"] = 'Virhesivua ei ole julkaistu tai se ei ole olemassa.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Virhesivulle ei ole käyttöoikeutta. Julkaise kyseinen sivu ja/tai varmista, että sivun ID on järjestelmän asetuksissa oikein.';
$_lang["configcheck_hide_warning"] = '<a href="javascript:hideConfigCheckWarning(\'%s\');"><em>Don\'t show this again.</em></a>';
$_lang["configcheck_images"] = 'Images-kansioon ei voi kirjoittaa';
$_lang["configcheck_images_msg"] = 'Images-kansioon ei voi kirjoittaa tai kansiota ei ole olemassa. Tämä tarkoittaa sitä, että kuvanhallintatoiminnot eivät toimi!';
$_lang["configcheck_installer"] = 'asennusohjelma on yhä tallella';
$_lang["configcheck_installer_msg"] = 'Install-kansio sisältää MODX:n asennusohjelman. Kuvittele, mitä voi tapahtua, jos pahantahtoinen henkilö löytää kansion ja ajaa asennusohjelman! Korjaa ongelma poistamalla kansio palvelimeltasi.';
$_lang["configcheck_lang_difference"] = 'Virheellinen määrä merkintöjä kielitiedostossa';
$_lang["configcheck_lang_difference_msg"] = 'Tällä hetkellä valittuna oleva kieli sisältää eri määrän merkintöjä kuin oletuskieli. Tämä ei välttämättä ole ongelma, mutta voi tarkoittaa sitä, että kielitiedosto pitäisi päivittää.';
$_lang["configcheck_notok"] = 'Varoitukset: ';
$_lang["configcheck_ok"] = 'Tarkistus onnistui - ei varoituksia.';
$_lang["configcheck_php_gdzip"] = 'GD ja/tai Zip PHP-laajennuksia ei löytynyt';
$_lang["configcheck_php_gdzip_msg"] = 'MODX vaatii GD ja Zip PHP-laajennukset toimiakseen täydellisesti. MODX toimii ilmankin kyseisiä laajennuksia, mutta tiedostoselaimen, kuvaeditorin ja Captcha -varmistuskoodien kaikki ominaisuudet eivät ole käytettävissä.';
$_lang["configcheck_register_globals"] = 'Palvelimen php.ini-tiedossa register_globals on asetettu päälle ';
$_lang["configcheck_register_globals_msg"] = 'Tämä asetus tekee sivuston alttiiksi Cross Site Scripting- eli XSS-hyökkäyksille. Kysy palveluntarjoajaltasi, miten asia voitaisiin ratkaista.';
$_lang["configcheck_title"] = 'Asetusten tarkistus';
$_lang["configcheck_templateswitcher_present"] = 'TemplateSwitcher Plugin detected';
$_lang["configcheck_templateswitcher_present_delete"] = '<a href="javascript:deleteTemplateSwitcher();">Delete TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_disable"] = '<a href="javascript:disableTemplateSwitcher();">Disable TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_msg"] = 'The TemplateSwitcher plugin has been found to cause caching and performance problems, and should be used only the functionality is required in your site.';
$_lang["configcheck_unauthorizedpage_unavailable"] = '"Pääsy kielletty" -sivua ei ole julkaistu.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = '"Pääsy kielletty" -sivulle ei joko päästä tai sitä ei ole olemassa. Tämä voi johtaa ongelmiin sivustollasi. Varmista, ettei sivulle ole määritetty web-käyttäjäryhmää.';
$_lang["configcheck_unauthorizedpage_unpublished"] = '"Pääsy kielletty" -sivua ei ole julkaistu.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = '"Pääsy kielletty" -sivu ei ole julkinen. Varmista, että sivu on julkaistu ja sivun ID-tunnus on oikein.';
$_lang["configcheck_validate_referer"] = 'Tietoturvavaroitus: HTTP Header Validation';
$_lang["configcheck_validate_referer_msg"] = 'Järjestelmän asetus <strong>Tarkasta HTTP_REFERER tunnisteet?</strong> on poissa päältä. On suositeltavaa ottaa asetus käyttöön. <a href="index.php?a=17">Järjestelmän asetukset</a><br /><a href="javascript:hideHeaderVerificationWarning();"><em>Älä näytä tätä ilmoitusta uudelleen.</em></a>';
$_lang["configcheck_warning"] = 'Varoitus:';
$_lang["configcheck_what"] = 'Mitä tämä tarkoittaa?';
$_lang["confirm_block"] = 'Haluatko varmasti estää käyttäjän?';
$_lang["confirm_delete_eventlog"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_file"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_htmlsnippet"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_keywords"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_module"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_plugin"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_record"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_resource"] = 'Haluatko varmasti poistaa?\nKaikki sivun (kansion) alasivut poistetaan myös.';
$_lang["confirm_delete_role"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_snippet"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_tags"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_template"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_tmplvars"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_delete_user"] = 'Haluatko varmasti poistaa?';
$_lang["confirm_duplicate_record"] = 'Haluatko varmasti tehdä kopion?';
$_lang["confirm_empty_trash"] = 'Tämä tuhoaa pysyvästi KAIKKI poistetut sivut. \n\nJatka?';
$_lang["confirm_load_depends"] = 'Haluatko varmasti ladata hallitse riippuvaisuuksia näkymän tallentamatta tehtyjä muutoksia?';
$_lang["confirm_name_change"] = 'Käyttäjänimen muuttaminen voi vaikuttaa muiden sisällönhallintajärjestelmään yhdistettyjen ohjelmien toimintaan. \n\n Oletko varma että haluat muuttaa tätä käyttäjänimeä?';
$_lang["confirm_publish"] = '\n\Sivun julkaiseminen poistaa kaikki sivuun asetetut julkaisu- ja piilotuspäiväykset. \n\nJatka?';
$_lang["confirm_remove_locks"] = 'Joskus käyttäjät sulkevat selaimensa esimerkiksi kesken sivun muokkaamisen. Tällöin muokattava kohde saattaa jäädä lukittuun tilaan. Poista kaikki lukot napsauttamalla OK.\n\nJatka?';
$_lang["confirm_resource_duplicate"] = 'Haluatko varmasti tehdä kopion?';
$_lang["confirm_setting_language_change"] = 'Olet vaihtanut oletusarvoa ja muutokset menetetään, jatketaanko?';
$_lang["confirm_unblock"] = 'Haluatko varmasti poistaa käyttäjän eston?';
$_lang["confirm_undelete"] = '\n\nMyös jokainen sivun kanssa yhtä aikaa poistettu alasivu palautetaan.';
$_lang["confirm_unpublish"] = '\n\nSivun piilottaminen poistaa myös kaikki sivuun asetetut julkaisu- ja piilotuspäiväykset.\n\nJatka?';
$_lang["confirm_unzip_file"] = 'Haluatko varmasti purkaa tiedoston??\n\nOlemassa olevat tiedostot tullaan ylikirjoittamaan.';
$_lang["could_not_find_user"] = 'Käyttäjää ei löytynyt';
$_lang["create_folder_here"] = 'Uusi kansio tähän';
$_lang["create_resource_here"] = 'Uusi sivu tähän';
$_lang["create_resource_title"] = 'Uusi sivu';
$_lang["create_weblink_here"] = 'Uusi hyperlinkki tähän';
$_lang["createdon"] = 'Luonti päivämäärä';
$_lang["credits"] = 'Kunniamaininnat';
$_lang["credits_shouts_msg"] = '<p>MODX:n kehittäjät ja ylläpitäjät: <a href="https://evo.im/" target="_blank">modx.com</a>.</p>';
$_lang["custom_contenttype_message"] = 'Muokkaa sivuissa käytettäviä sisältötyyppejä.';
$_lang["custom_contenttype_title"] = 'Sisältötyypit:';
$_lang["database_charset"] = 'Tietokannan merkistö';
$_lang["database_collation"] = 'Tietokannan koontimerkistö (collation charset)';
$_lang["database_name"] = 'Tietokannan nimi';
$_lang["database_overhead"] = '<strong>Huomaa:</strong> Hukkatila on tietokannan varaamaa tyhjää tilaa. Vapauta tyhjä tila napsauttamalla taulun Hukkatila-sarakkeen linkkiä.';
$_lang["database_server"] = 'Tietokantapalvelin';
$_lang["database_table_clickbackup"] = ' <strong>Valitse ensin varmuuskopioitavat tietokannan taulut. Voit valita kaikki taulut rastittamalla valinnan "Taulun nimi".</strong>';
$_lang["database_table_clickhere"] = 'Aloita varmuuskopionti.';
$_lang["database_table_datasize"] = 'Tietojen koko';
$_lang["database_table_droptablestatements"] = 'Lisää myös taulujen poistokomennot (DROP TABLE).';
$_lang["database_table_effectivesize"] = 'Todellinen koko';
$_lang["database_table_indexsize"] = 'Indeksin koko';
$_lang["database_table_overhead"] = 'Hukkatila';
$_lang["database_table_records"] = 'Tietueita';
$_lang["database_table_tablename"] = 'Taulun nimi';
$_lang["database_table_totals"] = 'Yhteensä:';
$_lang["database_table_totalsize"] = 'Kokonaiskoko';
$_lang["database_tables"] = 'Tietokannan taulut';
$_lang["database_version"] = 'Tietokannan versio:';
$_lang["date"] = 'Päiväys';
$_lang["datechanged"] = 'Päiväys muuttui';
$_lang["datepicker_offset"] = 'Päivämäärävalinnan rajat: ';
$_lang["datepicker_offset_message"] = 'Kuinka monta vuotta näytetään taaksepäin kalentereissa, kun valitaan päivämääriä.';
$_lang["datetime_format"] = 'Päivämäärän muoto:';
$_lang["datetime_format_message"] = 'Päivämäärien muoto ylläpidossa.';
$_lang["default"] = 'Oletus:';
$_lang["defaultcache_message"] = 'Määrittele tallennetaanko uudet sivut oletusarvoisesti välimuistiin.';
$_lang["defaultcache_title"] = 'Välimuisti -oletus:';
$_lang["defaultmenuindex_message"] = 'Määrittele annetaanko uusille sivuille automaattisesti kasvava valikon järjestysnumero.';
$_lang["defaultmenuindex_title"] = 'Valikon oletusjärjestys:';
$_lang["defaultpublish_message"] = 'Määrittele ovatko uudet sivut oletusarvoisesti julkaistu vai piilotettu.';
$_lang["defaultpublish_title"] = 'Julkaistu -oletus:';
$_lang["defaultsearch_message"] = 'Määrittele ovatko uudet sivut oletusrvoisesti haettavissa sivuston sisäisellä haulla.';
$_lang["defaultsearch_title"] = 'Haettavissa -oletus:';
$_lang["defaulttemplate_message"] = 'Valitse oletussivupohja uusille sivuille. Käytettävän sivupohjan voi vaihtaa sivun luomisen tai muokkaamisen yhteydessä. Oletussivupohja vain esivalitsee yhden sivupohjan.';
$_lang["defaulttemplate_title"] = 'Oletussivupohja:';
$_lang["defaulttemplate_logic_title"] = 'Automatic Template Assignment';
$_lang["defaulttemplate_logic_general_message"] = 'New Resources will have the following templates, falling back to higher levels if not found:';
$_lang["defaulttemplate_logic_system_message"] = '<strong>System</strong>: the System Default Template.';
$_lang["defaulttemplate_logic_parent_message"] = '<strong>Parent</strong>: the same Template as the parent container.';
$_lang["defaulttemplate_logic_sibling_message"] = '<strong>Sibling</strong>: the same Template as other Resources in the same container.';
$_lang["delete"] = 'Poista';
$_lang["delete_resource"] = 'Poista';
$_lang["delete_tags"] = 'Poista metatiedot';
$_lang["deleting_file"] = 'Poistaa tiedostoa `%s`: ';
$_lang["description"] = 'Kuvaus';
$_lang["deselect_keywords"] = 'Tyhjennä avainsanat';
$_lang["deselect_metatags"] = 'Tyhjennä metatiedot';
$_lang["disabled"] = 'Estetty';
$_lang["doc_data_title"] = 'Sivu';
$_lang["duplicate"] = 'Tee kopio';
$_lang["duplicate_alias_found"] = 'Sivu nimeltä \'%s\' käyttää jo aliasta \'%s\'. Anna sivulle jokin muu alias.';
$_lang["duplicate_alias_message"] = 'Sallitaanko saman nimisten aliaksien käyttö useassa eri sivuissa. <strong>HUOMAA:</strong> Asetuksen käyttö on turvallista vain jos samanaikaisesti käytetään myös selkokielisiä aliaspolkuja.';
$_lang["duplicate_alias_title"] = 'Salli saman nimiset aliakset:';
$_lang["duplicate_name_found_general"] = 'Kohde %s nimeltä \'%s\' on jo olemassa. Anna jokin toinen nimi.';
$_lang["duplicate_name_found_module"] = 'Moduuli nimeltä \'%s\' on jo olemassa. Anna jokin toinen nimi.';
$_lang["edit"] = 'Muokkaa';
$_lang["edit_resource"] = 'Muokkaa';
$_lang["edit_resource_title"] = 'Muokkaa';
$_lang["edit_settings"] = 'Järjestelmän asetukset';
$_lang["editedon"] = 'Muokkaa päivämäärä';
$_lang["editing_file"] = 'Muokataan tiedostoa: ';
$_lang["editor_css_path_message"] = 'Syötä polku sisältöeditorissa käyttämääsi CSS-tiedostoon. Paras tapa syöttää polku on käyttää polkua palvelimen juuresta lähtien, esim: /assets/site/style.css. Jos et halua ladata tyylisivua editoriin, jätä kenttä tyhjäkäksi.';
$_lang["editor_css_path_title"] = 'Polku CSS-tiedostoon:';
$_lang["element"] = 'Elementti';
$_lang["element_categories"] = 'Yhdistetty näkymä';
$_lang["element_management"] = 'Elementit';
$_lang["element_name"] = 'Elementin nimi';
$_lang["element_selector_msg"] = 'Valitse elementit alapuolella olevasta listasta ja paina \'Tuo\' painiketta.';
$_lang["element_selector_title"] = 'Elementinvalitsin';
$_lang["elements"] = 'Elementit';
$_lang["email"] = 'Sähköposti';
$_lang["email_sent"] = 'Sähköposti lähetetty';
$_lang["emailsender_message"] = 'Määrittele sähköpostiosoite, jota käytetään käyttäjien käyttäjänimen ja salasanan lähettämisen yhteydessä.';
$_lang["emailsender_title"] = 'Sähköpostiosoite:';
$_lang["emailsubject_default"] = 'Kirjautumistietosi';
$_lang["emailsubject_message"] = 'Määrittele uusille käyttäjille lähetettävän liittymissähköpostin aihe.';
$_lang["emailsubject_title"] = 'Liittymissähköpostin aihe:';
$_lang["empty_folder"] = 'Kansio on tyhjä';
$_lang["empty_recycle_bin"] = 'Tyhjennä roskakori';
$_lang["empty_recycle_bin_empty"] = 'Poistettavia sivuja ei ole.';
$_lang["enable_resource"] = 'Ota käyttöön elementtitiedosto.';
$_lang["enable_sharedparams"] = 'Mahdollista parametrien jako';
$_lang["enable_sharedparams_msg"] = '<strong>HUOMAA:</strong> Globaalia yksilöllinen ID-tunnusta (GUID) käytetään moduulin tunnistautumiseen ja jaettuihin parametreihin. ';
$_lang["enabled"] = 'Käytössä';
$_lang["error"] = 'Virhe';
$_lang["error_sending_email"] = 'Virhe sähköpostin lähetyksessä';
$_lang["errorpage_message"] = 'Syötä virhesivuna käytettävän sivun ID. Virhesivu näytetään, jos pyydettyä sivua ei syystä tai toisesta löydy. <strong>HUOMAA:</strong> Varmista, että ID on olemassa ja, että kyseinen sivu on julkaistu!';
$_lang["errorpage_title"] = 'Virhesivu:';
$_lang["event_id"] = 'Tapahtuman ID';
$_lang["eventlog"] = 'Tapahtumaloki';
$_lang["eventlog_msg"] = 'Tapahtumaloki sisältää sisällönhallintajärjestelmän luomia merkintöjä sekä varoitus- ja virheilmoituksia.';
$_lang["eventlog_viewer"] = 'Tapahtumaloki';
$_lang["everybody"] = 'Kaikki';
$_lang["existing_category"] = 'Kategoria';
$_lang["expand_tree"] = 'Laajenna';
$_lang["failed_login_message"] = 'Kuinka monen epäonnistuneen kirjautumisyrityksen jälkeen käyttäjätunnus lukitaan.';
$_lang["failed_login_title"] = 'Epäonnistuneita kirjautumisia:';
$_lang["fe_editor_lang_message"] = 'Valitse esikatselutilassa käytettävän sisältöeditorin kieli.';
$_lang["fe_editor_lang_title"] = 'Esikatselutilan sisältöeditorin kieli:';
$_lang["file_delete_file"] = 'Poista tiedosto';
$_lang["file_delete_folder"] = 'Poista kansio';
$_lang["file_deleted"] = 'Onnistui!';
$_lang["file_download_file"] = 'Lataa tiedosto';
$_lang["file_download_unzip"] = 'Pura tiedosto';
$_lang["file_folder_chmod_error"] = 'Tiedoston oikeuksien vaihto ei onnistunut, joudut tekemään sen ModX:n ulkopuolella.';
$_lang["file_folder_created"] = 'Kansion luonti onnistui!';
$_lang["file_folder_deleted"] = 'Kansion poisto onnistui!';
$_lang["file_folder_not_created"] = 'Kansiota ei voida luoda';
$_lang["file_folder_not_deleted"] = 'Kansiota ei voida poistaa. Varmista että kansio on tyhjä ennen sen poistamista!';
$_lang["file_not_deleted"] = 'Epäonnistui!';
$_lang["file_not_saved"] = 'Tiedostoa ei voi tallentaa, varmista että kohde hakemistoon voidaan kirjoittaa!';
$_lang["file_saved"] = 'Tiedoston päivitys onnistui!';
$_lang["file_unzip"] = 'Purku onnistui!';
$_lang["file_unzip_fail"] = 'Purku epäonnistui!';
$_lang["filemanager_path_message"] = 'IIS ei useinkaan muokkaa tiedostonhallintajärjestelmän käyttämää document_root asetusta oikein. Tätä asetusta käytetään määrittämään, mitä tiedostoja käyttäjä voi katsella. Jos tiedostonhallintajärjestelmän käytössä on vaikeuksia, huolehdi siitä, että polku osoittaa MODX-asennuksen juureen.';
$_lang["filemanager_path_title"] = 'Ylläpidon tiedostoselaimen polku:';
$_lang["files_access_denied"] = 'Pääsy estetty!';
$_lang["files_data"] = 'Ominaisuudet';
$_lang["files_dir_listing"] = 'Kansio:';
$_lang["files_directories"] = 'Kansiot';
$_lang["files_dirwritable"] = 'Voiko kansioon kirjoittaa? ';
$_lang["files_editfile"] = 'Muokkaa tiedostoa';
$_lang["files_file_type"] = 'Tiedostotyyppi: ';
$_lang["files_filename"] = 'Nimi';
$_lang["files_fileoptions"] = 'Toiminnot';
$_lang["files_files"] = 'Tiedostot';
$_lang["files_filesize"] = 'Koko';
$_lang["files_filetype_notok"] = 'Tämän tyyppisen tiedoston siirtoa ei ole sallittu!';
$_lang["files_modified"] = 'Muokattu';
$_lang["files_top_level"] = 'Päätasolle';
$_lang["files_up_level"] = 'Yksi taso ylöspäin';
$_lang["files_upload_copyfailed"] = 'Tiedoston siirtäminen kohdekansioon ei onnistunut!';
$_lang["files_upload_error"] = 'Virhe';
$_lang["files_upload_error0"] = 'Ongelma tiedoston siirrossa.';
$_lang["files_upload_error1"] = 'Tiedosto, jota yrität siirtää, on liian suuri.';
$_lang["files_upload_error2"] = 'Tiedosto, jota yrität siirtää, on liian suuri.';
$_lang["files_upload_error3"] = 'Tiedosto, jota yritit siirtää, ei siirtynyt kokonaan.';
$_lang["files_upload_error4"] = 'Valitse siirrettävä tiedosto.';
$_lang["files_upload_error5"] = 'Ongelma tiedoston siirrossa.';
$_lang["files_upload_inhibited_msg"] = '<strong>Siirto-oikeuksia rajoitettu</strong>. Varmista tiedoston siirtojen tuki ja tarkista kansion kirjoitusoikeudet.';
$_lang["files_upload_ok"] = 'Tiedoston siirto onnistui!';
$_lang["files_upload_permissions_error"] = 'Mahdollinen käyttöoikeusongelma - palvelimella on oltava kirjoitusoikeudet kansioon, johon haluat ladata tiedostoja.';
$_lang["files_uploadfile"] = 'Siirrä';
$_lang["files_uploadfile_msg"] = 'Valitse kansioon siirrettävä tiedosto:';
$_lang["files_uploading"] = 'Siirtää <strong>%s</strong> kohteeseen <strong>%s/</strong>';
$_lang["files_viewfile"] = 'Näytä tiedosto';
$_lang["folder"] = 'Kansio';
$_lang["forgot_password_email_fine_print"] = '* Ylläoleva linkki vanhenee heti, kun olet vaihtanut salasanasi tai vuorokauden vaihtuessa.';
$_lang["forgot_password_email_instructions"] = 'Voit vaihtaa salasanasi oman käyttäjänimesi kohdalta.';
$_lang["forgot_password_email_intro"] = 'Vastaanotettiin pyyntö vaihtaa tilisi salasana.';
$_lang["forgot_password_email_link"] = 'Napsauta tähän jatkaaksesi salasanan vaihtoa.';
$_lang["forgot_your_password"] = 'Unohtuiko salasana?';
$_lang["friday"] = 'Perjantai';
$_lang["friendly_alias_message"] = 'Jos käytät selkokielisiä osoitteita, alias on aina etusijalla. Selkokielisten osoitteiden etu- ja takaliitteitä käytetään myös aliaksessa. Esim. sivun ID on 1 ja alias on "esittely". Lisäksi takaliitteeksi on asetettu ".html" ja etuliite on jätetty tyhjäksi. Tällöin asetuksen ollessa "kyllä" luodaan aliaksen perusteella osoite "esittely.html". Jos asetus on "ei", luodaan sivun ID:n perusteella osoite "1.html".';
$_lang["friendly_alias_title"] = 'Käytä selkokielisiä aliaksia:';
$_lang["friendlyurls_message"] = 'Ihmisille selkeät ja hakukoneille ystävälliset osoitteet. Toimii ilman ylimääräistä säätämistä ainoastaan Apache-palvelimella. Vaatii .htaccess -tiedoston käyttöönoton, joka löytyy sivuston juuresta nimellä ht.access.';
$_lang["friendlyurls_title"] = 'Käytä selkokielisiä osoitteita:';
$_lang["friendlyurlsprefix_message"] = 'Määrittele selkokielisten osoitteiden etuliite. Esim. etuliite "sivu" muuttaa osoitteen /index.php?id=2 selkokieliseksi osoitteeksi /sivu2.';
$_lang["friendlyurlsprefix_title"] = 'Etuliite selkokielisille osoitteille:';
$_lang["friendlyurlsuffix_message"] = 'Määrittele tiedostopääte selkokielisille osoitteille. Esim. tiedostopääte ".html" lisää kaikkien selkokielisten osoitteiden perään html-päätteen.';
$_lang["friendlyurlsuffix_title"] = 'Tiedostopääte selkokielisille osoitteille:';
$_lang["functionnotimpl"] = 'Anteeksi!';
$_lang["functionnotimpl_message"] = 'Tätä funktiota ei ole vielä toteutettu.';
$_lang["go"] = 'OK';
$_lang["group_access_permissions"] = 'Käyttäjäryhmän oikeudet';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Ohjeet';
$_lang["help_donate_msg"] = 'Osta kahvia Evolution CMS -kehittäjille. <a href="https://ko-fi.com/evolutioncms" target="_blank">ko-fi.com/evolutioncms ☕</a> Ryhdy Evolution CMS:n faniksi jo tänään! ❤️ Ko-fi antaa sinun tukea rakastamiamme tekijöitä ilman lahjoitusmaksuja.';
$_lang["help_donate_title"] = 'Evolution CMS:n kehittämiseen';
$_lang["help_msg"] = '<p>Ongelmatilanteissa tutustu <a href="http://forums.modx.com" target="_blank">MODX:n keskustelufoorumeihin</a>. Lisäksi kannattaa tutustua <a href="http://rtfm.modx.com/evolution/1.0" target="_blank">MODX:n ohjeisiin ja oppaisiin</a> sekä <a href="http://wiki.modx.com/index.php/Main_Page" target="_blank">MODX Wikiin</a>.</p><p>Suunnitteilla on myös kaupallisen MODX-tuen tarjoaminen - ota <a href="mailto:hello@modx.com?subject=MODX Commercial Support Inquiry">yhteyttä</a>, jos olet kiinnostunut.</p>';
$_lang["help_title"] = 'Ohjeet';
$_lang["hide_tree"] = 'Piilota sivukartta';
$_lang["home"] = 'Alkuun';
$_lang["htmlsnippet_desc"] = 'Kuvaus';
$_lang["htmlsnippet_management_msg"] = 'Muokkaa HTML-palasia (chunk).';
$_lang["htmlsnippet_msg"] = 'Muokkaa HTML-palasta (chunk). Huomaa, että HTML-palaset voivat sisältää muutakin kuin pelkkää HTML-koodia, mutta PHP-koodia ei kuitenkaan käsitellä mitenkään.';
$_lang["htmlsnippet_name"] = 'Nimi';
$_lang["htmlsnippet_title"] = 'HTML-palanen';
$_lang["icon"] = 'Kuvake';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Pääryhmäluokitus:\n\nSivu on valitun sivun alasivu.';
$_lang["illegal_parent_self"] = 'Pääryhmäluokitus:\n\nValittu sivu ei voi olla itsensä alasivu.';
$_lang["import_files_found"] = '<strong>Löytyi %s sivua tuotavaksi...</strong><p/>';
$_lang["import_params"] = 'Tuo jaetut parametrit';
$_lang["import_params_msg"] = 'Tuotavat parametrit tai moduulin asetukset. <strong>HUOMAA:</strong> Moduulit ovat valittavissa vain, jos liitännäinen / PHP-palanen on osa moduulin riippuvuuslistaa ja moduulin parametrien jako on käytössä. ';
$_lang["import_parent_resource"] = 'Pääryhmän sivu:';
$_lang["update_tree"] = 'Rakenna puu uudelleen';
$_lang["inbox"] = 'Viestit';
$_lang["info"] = 'Info';
$_lang["information"] = 'Informaatio';
$_lang["inline"] = 'Normaali';
$_lang["insert"] = 'Selaa';
$_lang["maxImageWidth"] = 'Maximum image width';
$_lang["maxImageHeight"] = 'Maximum image height';
$_lang["thumbWidth"] = 'Maximum thumbnail width';
$_lang["thumbHeight"] = 'Maximum thumbnail height';
$_lang["thumbsDir"] = 'Thumbnails directory location';
$_lang["jpegQuality"] = 'JPEG compression';
$_lang["denyZipDownload"] = 'Disable zip-archives downloading';
$_lang["denyExtensionRename"] = 'Disable renaming of file extensions';
$_lang["maxImageWidth_message"] = 'If uploaded image resolution exceeds this setting it will be automatically resized. Set 0 to avoid.';
$_lang["maxImageHeight_message"] = 'If uploaded image resolution exceeds this setting it will be automatically resized. Set 0 to avoid.';
$_lang["thumbWidth_message"] = 'Maximum thumbnail width.';
$_lang["thumbHeight_message"] = 'Maximum thumbnail height.';
$_lang["thumbsDir_message"] = 'The name of previews folder.';
$_lang["jpegQuality_message"] = 'JPEG compression quality of thumbnails and resized images';
$_lang["showHiddenFiles"] = 'Show hidden files in file browser';
$_lang["keyword"] = 'Avainsana';
$_lang["keywords"] = 'Avainsanat';
$_lang["keywords_intro"] = 'Muokkaa avainsanoja (keyword). Lisää uusi avainsana syöttämällä se uuden avainsanan kenttään. Muokkaa avainsanaa kirjoittamalla korvaava avainsana. Poista avainsanoja valitsemalla poistettavat sanat.';
$_lang["language_message"] = 'Valitse ylläpidon oletuskieli.';
$_lang["language_title"] = 'Kieli:';
$_lang["launch_site"] = 'Avaa sivusto';
$_lang["link_attributes"] = 'Linkki';
$_lang["link_attributes_help"] = 'Linkin ominaisuudet, esim. target=&quot;_blank&quot; tai rel=&quot;external&quot;.';
$_lang["list_mode"] = 'Näytä kaikki tiedot / Näytä tiedot jaettuina sivuihin';
$_lang["loading_doc_tree"] = 'Lataa sivukarttaa...';
$_lang["loading_menu"] = 'Lataa valikkoa...';
$_lang["loading_page"] = 'Lataa sivua...';
$_lang["localtime"] = 'Paikallinen aika';
$_lang["lock_htmlsnippet"] = 'Lukitse muokkaamisen ajaksi.';
$_lang["lock_htmlsnippet_msg"] = 'Vain pääkäyttäjät (Administrator) voivat muokata tätä.';
$_lang["lock_module"] = 'Lukitse muokkaamisen ajaksi.';
$_lang["lock_module_msg"] = 'Vain pääkäyttäjät (Administrator) voivat muokata tätä.';
$_lang["lock_msg"] = 'Toinen käyttäjä muokkaa tätä sivua parhaillaan. Odota kunnes käyttäjä lopettaa muokkaamisen ja yritä sitten uudelleen.';
$_lang["lock_plugin"] = 'Lukitse muokkaamisen ajaksi.';
$_lang["lock_plugin_msg"] = 'Vain pääkäyttäjät (Administrator) voivat muokata tätä.';
$_lang["lock_settings_msg"] = '%s muokkaa näitä asetuksia parhaillaan. Odota kunnes käyttäjä lopettaa muokkaamisen ja yritä sitten uudelleen.';
$_lang["lock_snippet"] = 'Lukitse muokkaamisen ajaksi.';
$_lang["lock_snippet_msg"] = 'Vain pääkäyttäjät (Administrator) voivat muokata tätä.';
$_lang["lock_template"] = 'Lukitse muokkaamisen ajaksi.';
$_lang["lock_template_msg"] = 'Vain pääkäyttäjät (Administrator) voivat muokata tätä.';
$_lang["lock_tmplvars"] = 'Lukitse muokkaamisen ajaksi.';
$_lang["lock_tmplvars_msg"] = 'Vain pääkäyttäjät (Administrator) voivat muokata tätä.';
$_lang["locked"] = 'Lukittu';
$_lang["login_allowed_days"] = 'Sallitut päivät';
$_lang["login_allowed_days_message"] = 'Valitse päivät, jolloin käytäjällä on lupa kirjautua sisään.';
$_lang["login_allowed_ip"] = 'Sallitut IP-osoitteet';
$_lang["login_allowed_ip_message"] = 'Syötä IP-osoitteet, joista käyttäjällä on lupa kirjautua sisään. <strong>HUOMAA:</strong> Erottele useammat IP-osoitteet pilkuilla (,).';
$_lang["login_button"] = 'Kirjaudu sisään';
$_lang["login_cancelled_install_in_progress"] = 'Sivuston asennus / päivitys on edelleen käynnissä. Koita uudelleen parin minuutin kuluttua!';
$_lang["login_cancelled_site_was_updated"] = 'Sivustolle on suoritettu asennus / päivitys. Ole hyvä ja kirjaudu sisään uudelleen!';
$_lang["login_captcha_message"] = '<strong>Syötä kuvassa näkyvä varmistuskoodi.</strong> Jos et jostain syystä näe kuvaa kunnolla, napsauta kuvan päällä, niin saat uuden varmistuskoodin.';
$_lang["login_homepage"] = 'Aloitussivu';
$_lang["login_homepage_message"] = 'Anna sen sivun ID-tunnus, joka näytetään automaattisesti ensimmäisenä käyttäjän kirjauduttua sisään. <strong>HUOMAA:</strong> Tarkista, että ID on olemassa ja kyseisen käyttäjän käytettävissä.';
$_lang["login_message"] = 'Kirjaudu ylläpitoon. Isoilla ja pienillä kirjaimilla on merkitystä, joten kirjoita käyttäjänimi ja salasana huolella.';
$_lang["logo_slogan"] = 'MODX Sisällönhallintajärjestelmä - \nLuo ja tee enemmän vähemmällä';
$_lang["logout"] = 'Kirjaudu ulos';
$_lang["long_title"] = 'Pitkä otsikko';
$_lang["mail_check_timeperiod_message"] = 'Kuinka usein uusia posteja tarkistetaan, aika sekunneissa.';
$_lang["mail_check_timeperiod_title"] = 'Postien tarkistusväli:';
$_lang["manage_depends"] = 'Muokkaa riippuvuuksia';
$_lang["manage_files"] = 'Tiedostot';
$_lang["manage_htmlsnippets"] = 'HTML-palaset';
$_lang["manage_metatags"] = 'Metatiedot ja avainsanat';
$_lang["manage_modules"] = 'Moduulit';
$_lang["manage_plugins"] = 'Liitännäiset';
$_lang["manage_snippets"] = 'PHP-palaset';
$_lang["manage_templates"] = 'Sivupohjat';
$_lang["manager"] = 'Ylläpito';
$_lang["manager_lockout_message"] = 'Olet kirjautuneena ylläpitoon. Jos haluat kirjautua ulos, napsauta "Kirjaudu ulos" -painiketta.<p />';
$_lang["manager_permissions"] = 'Ylläpidon käyttöoikeudet';
$_lang["manager_theme"] = 'Ylläpidon ulkoasu:';
$_lang["manager_theme_message"] = 'Valitse ylläpidon ulkoasu.';
$_lang["meta_keywords"] = 'Metatiedot ja avainsanat';
$_lang["metatag_intro"] = 'Muokkaa metatietoja (META-tag). Lisää metatietoja sivuihin napsauttamalla <u>Metatiedot ja avainsanat</u> -välilehteä sivun muokkaamisen yhteydessä. Valitse välilehdeltä sivuun liitettävät metatiedot ja avainsanat. Lisää uusi metatieto syöttämällä nimi ja arvo sekä valitsemalla metatiedon tyyppi. Muokkaa metatietoa napsauttamalla metatiedon nimeä. Poista metatietoja valitsemalla poistettavat tiedot.';
$_lang["metatag_notice"] = 'Ohjeita metatiedoista: <a href="http://www.html-reference.com/META.asp" target="_blank">HTML Reference Guide</a>.';
$_lang["metatags"] = 'Metatiedot';
$_lang["mgr_access_permissions"] = 'Ylläpidon käyttöoikeudet';
$_lang["mgr_login_start"] = 'Aloitussivu';
$_lang["mgr_login_start_message"] = 'Anna sen sivun ID-tunnus, joka näytetään automaattisesti ensimmäisenä käyttäjän kirjautuessa ylläpitoon. <strong>HUOMAA:</strong> Tarkista, että ID on olemassa ja kyseisen käyttäjän käytettävissä.';
$_lang["mgrlog_action"] = 'Toiminto';
$_lang["mgrlog_actionid"] = 'Toiminnon ID';
$_lang["mgrlog_anyall"] = 'Kaikki';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() on epätosi.';
$_lang["mgrlog_datefr"] = 'Alkamispäivä';
$_lang["mgrlog_dateinvalid"] = 'Ajan muoto ei kelpaa.';
$_lang["mgrlog_dateto"] = 'Päättymispäivä';
$_lang["mgrlog_emptysrch"] = 'Haku ei tuottanut tuloksia.';
$_lang["mgrlog_field"] = 'Kenttä';
$_lang["mgrlog_itemid"] = 'Kohteen ID';
$_lang["mgrlog_itemname"] = 'Kohteen nimi';
$_lang["mgrlog_msg"] = 'Viesti';
$_lang["mgrlog_noquery"] = 'Ei hakutuloksia.';
$_lang["mgrlog_qresults"] = 'Hakutulokset';
$_lang["mgrlog_query"] = 'Toimintojen jäljitys';
$_lang["mgrlog_query_msg"] = 'Jäljitä tehtyjä toimintoja lokitiedostosta. HUOM! Jos haluat hakea toimintoja yhdeltä päivältä, on päättymispäiväksi annettava haettavaa päivää seuraava päivä.';
$_lang["mgrlog_results"] = 'Tulosten lukumäärä';
$_lang["mgrlog_searchlogs"] = 'Hae lokeista';
$_lang["mgrlog_sortinst"] = 'Järjestä hakutulokset uudelleen napsauttamalla sarakkeen otsikkoa. Tyhjennä kaikki lokitiedot välittömästi <a href="index.php?a=55">napsauttamalla tästä</a>.';
$_lang["mgrlog_time"] = 'Aika';
$_lang["mgrlog_user"] = 'Käyttäjä';
$_lang["mgrlog_username"] = 'Käyttäjänimi';
$_lang["mgrlog_value"] = 'Arvo';
$_lang["mgrlog_view"] = 'Toimintojen jäljitys lokitiedostoista';
$_lang["module_code"] = 'Lähdekoodi (php)';
$_lang["module_config"] = 'Moduulin kokoonpano';
$_lang["module_desc"] = 'Kuvaus';
$_lang["module_disabled"] = 'Ota moduuli pois käytöstä';
$_lang["module_edit_click_title"] = 'Muokkaa moduulia napsauttamalla tästä';
$_lang["module_group_access_msg"] = 'Valitse käyttäjäryhmät, joilla on oikeus suorittaa moduuli ylläpidosta käsin.';
$_lang["module_management"] = 'Moduulit';
$_lang["module_management_msg"] = 'Valitse suoritettava tai muokattava moduuli. Suorita, muokkaa, tee kopio tai poista moduuli napsauttamalla moduulin kuvaketta. Muokkaa moduulia napsauttamalla sen nimeä.';
$_lang["module_msg"] = 'Muokkaa moduulia. Moduuli on kokoelma elementtejä (esim. liitännäisiä, PHP-palasia jne.).';
$_lang["module_name"] = 'Moduulin nimi';
$_lang["module_resource_msg"] = 'Lisää tai poista elementtejä, joista moduuli on riippuvainen. Lisää uusi elementti, napsauttamalla yhtä alapuolella olevista lisää -painikkeista.';
$_lang["module_resource_title"] = 'Moduulin Riippuvuudet';
$_lang["module_title"] = 'Muokkaa moduulia';
$_lang["module_viewdepend_msg"] = 'Moduulista riippuvaiset elementit.';
$_lang["modules"] = 'Moduulit';
$_lang["modx_news"] = 'MODX Uutiset';
$_lang["modx_news_tab"] = 'Uutiset';
$_lang["modx_news_title"] = 'MODX Uutiset';
$_lang["modx_security_notices"] = 'MODX Tietoturvatiedotteet';
$_lang["modx_version"] = 'MODX:n versio';
$_lang["monday"] = 'Maanantai';
$_lang["move"] = 'Siirrä';
$_lang["move_resource"] = 'Siirrä';
$_lang["move_resource_message"] = 'Siirrä sivu ja sivun kaikki alasivut uuteen paikkaan napsauttamlla haluttua kohtaa sivukartasta. Siirrettävät sivun sijoitetaan valitun sivun alle.';
$_lang["move_resource_new_parent"] = 'Valitse sivukartasta uusi paikka.';
$_lang["move_resource_title"] = 'Siirrä';
$_lang["name"] = 'Nimi';
$_lang["new_category"] = 'Uusi kategoria';
$_lang["new_file_permissions_message"] = 'Tiedostoselaimen kautta tuotavalle tiedostolle asetettavat luku- ja kirjoitusoikeudet. Asetus ei toimi automaattisesti kaikissa järjestelmissä, esim. IIS:ssä.';
$_lang["new_file_permissions_title"] = 'Uusien tiedostojen oikeudet';
$_lang["new_folder_permissions_message"] = 'Tiedostoselaimen kautta luotavalle kansiolle asetettavat luku- ja kirjoitusoikeudet. Asetus ei toimi automaattisesti kaikissa järjestelmissä, esim. IIS:ssä.';
$_lang["new_folder_permissions_title"] = 'Uusien kansioiden oikeudet';
$_lang["new_htmlsnippet"] = 'Uusi HTML-palanen';
$_lang["new_keyword"] = 'Lisää uusi avainsana:';
$_lang["new_module"] = 'Uusi moduuli';
$_lang["new_parent"] = 'Uusi pääryhmä';
$_lang["new_plugin"] = 'Uusi liitännäinen';
$_lang["new_role"] = 'Uusi rooli';
$_lang["new_snippet"] = 'Uusi PHP-palanen';
$_lang["new_template"] = 'Uusi sivupohja';
$_lang["new_tmplvars"] = 'Uusi sivupohjan muuttuja';
$_lang["new_user"] = 'Uusi ylläpidon käyttäjä';
$_lang["new_web_user"] = 'Uusi web-käyttäjä';
$_lang["new_resource"] = 'Uusi sivu';
$_lang["no"] = 'Ei';
$_lang["no_active_users_found"] = 'Ei aktiivisia käyttäjiä.';
$_lang["no_activity_message"] = 'Ei luotu tai muokattu yhtään sivua.';
$_lang["no_category"] = 'luokittelematon';
$_lang["no_docs_pending_publishing"] = 'Ei julkaisua odottavia sivuja.';
$_lang["no_docs_pending_pubunpub"] = 'Ei löytynyt tapahtumia';
$_lang["no_docs_pending_unpublishing"] = 'Ei piilottamista odottavia sivuja.';
$_lang["no_edits_creates"] = 'Ei luonteja tai muokkauksia.';
$_lang["no_groups_found"] = 'Ei ryhmiä.';
$_lang["no_keywords_found"] = 'Avainsanoja ei vielä ole.';
$_lang["no_records_found"] = 'Ei merkintöjä.';
$_lang["no_results"] = 'Ei tuloksia';
$_lang["nologentries_message"] = 'Näytettävien lokimerkintöjen lukumäärä toimintoja jäljitettäessä.';
$_lang["nologentries_title"] = 'Lokitietomerkintöjen lukumäärä:';
$_lang["nomessages_message"] = 'Viesteissä kerralla näkyvien viestien lukumäärä.';
$_lang["nomessages_title"] = 'Viestien lukumäärä:';
$_lang["none"] = 'Ei yhtään';
$_lang["noresults_message"] = 'Tuloksien lukumäärä listauksia ja hakutuloksia selatessa.';
$_lang["noresults_title"] = 'Tulosten lukumäärä:';
$_lang["not_deleted"] = 'ei ole poistettu.';
$_lang["not_set"] = 'Ei asetettu';
$_lang["offline"] = 'Poissa käytöstä';
$_lang["online"] = 'Käytössä';
$_lang["onlineusers_action"] = 'Toiminto';
$_lang["onlineusers_actionid"] = 'Toiminnon ID';
$_lang["onlineusers_ipaddress"] = 'Käyttäjän IP-osoite';
$_lang["onlineusers_lasthit"] = 'Kello';
$_lang["onlineusers_message"] = 'Lista käyttäjistä jotka ovat olleet aktiivisia viimeisen 20 minuutin aikana (kello on nyt ';
$_lang["onlineusers_title"] = 'Kirjautuneet käyttäjät';
$_lang["onlineusers_user"] = 'Käyttäjä';
$_lang["onlineusers_userid"] = 'Käyttäjän ID';
$_lang["optimize_table"] = 'Optimoi taulu';
$_lang["page_data_cacheable"] = 'Välimuistiin?';
$_lang["page_data_cacheable_help"] = 'Tallennetaanko sivu välimuistiin?';
$_lang["page_data_cached"] = '<strong>Välimuistista haettu lähdekoodi:</strong>';
$_lang["page_data_changes"] = 'Muutokset';
$_lang["page_data_contentType"] = 'Sisältötyyppi';
$_lang["page_data_contentType_help"] = 'Määrittelee sivun sisältötyypin. Jos et ole varma, mikä sisältötyypi sivulla tulisi olla, jätä se arvoon text/html.';
$_lang["page_data_created"] = 'Luotu';
$_lang["page_data_edited"] = 'Muokattu';
$_lang["page_data_editor"] = 'Muokkaus sisältöeditorilla';
$_lang["page_data_folder"] = 'Sivu on kansio';
$_lang["page_data_general"] = 'Yleiset';
$_lang["page_data_markup"] = 'Rakenne';
$_lang["page_data_mgr_access"] = ' Ylläpito-käyttöoikeus';
$_lang["page_data_notcached"] = 'Sivua ei ole (vielä) haettu välimuistiin.';
$_lang["page_data_publishdate"] = 'Julkaisupäiväys';
$_lang["page_data_publishdate_help"] = 'Julkaisupäiväys määrittelee, koska sivu julkaistaan. Valitse julkaisupäiväys napsauttamalla kalenteri-kuvaketta. Poista julkaisupäiväys napsauttamalla kalenterikielto-kuvaketta. Jätä julkaisupäiväys tyhjäksi, jos haluat julkaista sivun heti.';
$_lang["page_data_published"] = 'Julkaistu';
$_lang["page_data_searchable"] = 'Haettavissa?';
$_lang["page_data_searchable_help"] = 'Onko sivu löydettävissä sivuston omalla hakukoneella?';
$_lang["page_data_source"] = 'Lähdekoodi';
$_lang["page_data_status"] = 'Tila';
$_lang["page_data_template"] = 'Sivupohja';
$_lang["page_data_template_help"] = 'Sivun käyttämä sivupohja.';
$_lang["page_data_title"] = 'Sivun tiedot';
$_lang["page_data_unpublishdate"] = 'Piiloituspäiväys';
$_lang["page_data_unpublishdate_help"] = 'Julkaisun piiloituspäiväys määrittelee, koska sivu piiloitetaan eli otetaan pois julkaisusta. Valitse piiloituspäiväys napsauttamalla kalenteri-kuvaketta. Poista piiloituspäiväys napsauttamalla kalenterikielto-kuvaketta. Jätä piiloituspäiväys tyhjäksi, jos haluat, että sivua ei piiloiteta automaattisesti.';
$_lang["page_data_unpublished"] = 'Julkaisematon / piiloitettu';
$_lang["page_data_web_access"] = ' Web-käyttöoikeus';
$_lang["pagetitle"] = 'Sivun otsikko';
$_lang["pagination_table_first"] = 'Ensimmäinen';
$_lang["pagination_table_gotopage"] = 'Siirry sivulle';
$_lang["pagination_table_last"] = 'Viimeinen';
$_lang["paging_first"] = 'ensimmäinen';
$_lang["paging_last"] = 'viimeinen';
$_lang["paging_next"] = 'seuraava';
$_lang["paging_prev"] = 'edellinen';
$_lang["paging_showing"] = 'Näytetään';
$_lang["paging_to"] = '-';
$_lang["paging_total"] = 'yhteensä';
$_lang["parameter"] = 'Parametri';
$_lang["password"] = 'Salasana';
$_lang["password_change_request"] = 'Pyydä salasanan vaihtamista';
$_lang["password_gen_gen"] = 'Luo salasana automaattisesti.';
$_lang["password_gen_length"] = 'Salasanan täytyy olla vähintään 6 merkkiä pitkä. Salasana ei saa sisältää ääkkösiä eikä erikoismerkkejä (+, -, ? jne.).';
$_lang["password_gen_method"] = 'Uusi salasana';
$_lang["password_gen_specify"] = 'Anna salasana itse:';
$_lang["password_method"] = 'Salasanan tiedonanto';
$_lang["password_method_email"] = 'Lähetä uusi salasana sähköpostilla.';
$_lang["password_method_screen"] = 'Näytä uusi salasana ruudulla.';
$_lang["password_msg"] = 'Uusi salasana käyttäjälle <strong>:username</strong> on <strong>:password</strong><br>';
$_lang["php_version_check"] = 'MODX on yhteensopiva PHP versio 7.4 tai paremman kanssa. Ole hyvä ja päivitä PHP asennuksesi!';
$_lang["plugin"] = 'Liitännäinen';
$_lang["plugin_code"] = 'Lähdekoodi (php)';
$_lang["plugin_config"] = 'Liitännäisen asetukset';
$_lang["plugin_desc"] = 'Kuvaus';
$_lang["plugin_disabled"] = 'Ota liitännäinen pois käytöstä';
$_lang["plugin_event_msg"] = 'Valitse järjestelmätapahtumat, jotka aktivoivat liitännäisen suorittamisen.';
$_lang["plugin_management_msg"] = 'Muokkaa liitännäisiä (plugin).';
$_lang["plugin_msg"] = 'Muokkaa liitännäistä (plugin). Liitännäiset ovat PHP-koodia, jotka aktivoituvat valittujen järjestelmätapahtumien yhteydessä.';
$_lang["plugin_name"] = 'Nimi';
$_lang["plugin_priority"] = 'Muokkaa liitännäisten suorittamisjärjestystä';
$_lang["plugin_priority_instructions"] = 'Muuta liitännäisten järjestystä vetämällä. Ensimmäisenä suoritettavan liitännäisen tulee olla ylimpänä.';
$_lang["plugin_priority_title"] = 'Liitännäisten suorittamisjärjestys';
$_lang["plugin_title"] = 'Liitännäinen';
$_lang["preview"] = 'Esikatselu';
$_lang["preview_msg"] = 'Esikatselunäkymä viimeksi tallennetuista muutoksista. Napsauta <a href="javascript:;" onclick="saveRefreshPreview();">tästä tallentaaksesi ja päivittääksesi</a> tämän hetkiset muutokset';
$_lang["preview_resource"] = 'Esikatsele';
$_lang["private"] = 'Yksityinen';
$_lang["public"] = 'Julkinen';
$_lang["publish_date"] = 'Julkaisupäiväys';
$_lang["publish_events"] = 'Julkaistavien sivujen aikataulu';
$_lang["publish_resource"] = 'Julkaise';
$_lang["rb_base_dir_message"] = 'Syötä tiedostoselaimen kansion todellinen (physical path) osoite. Osoite luodaan yleensä automaattisesti. Poikkeuksena on esim. IIS. Jos MODX ei onnistu löytämään oikeaa osoitetta ilman apua ja tiedostoselain ilmoittaa virheestä, korjaa virhe syöttämällä images-kansion osoite. <strong>HUOMAA:</strong> Tiedostoselaimen kansion täytyy sisältää alikansiot: images, files, flash ja media, jotta tiedostoselain toimii oikein.';
$_lang["rb_base_dir_title"] = 'Tiedostoselaimen osoite:';
$_lang["rb_base_url_message"] = 'Syötä tiedostoselaimen kansion suhteellinen (virtual path) osoite. Osoite luodaan yleensä automaattisesti. Poikkeuksena on esim. IIS. Jos MODX ei onnistu löytämään oikeaa osoitetta ilman apua ja tiedostoselain ilmoittaa virheestä, korjaa virhe syöttämällä images-kansion osoite.';
$_lang["rb_base_url_title"] = 'Tiedostoselaimen osoite (URL):';
$_lang["rb_message"] = 'Tiedostoselain antaa käyttäjille mahdollisuuden selata ja siirtää palvelimelle tiedostoja kuten kuvia, flash- ja muita mediatiedostoja.';
$_lang["rb_title"] = 'Ota käyttöön tiedostoselain:';
$_lang["rb_webuser_message"] = 'Sallitaanko web-käyttäjille tiedostoselaimen käyttö? <b>VAROITUS:</b>Käytön salliminen mahdollistaa normaalisti vain ylläpidon käyttäjille tarkoitettujen tiedostojen hallinnan. Käytä vain, jos luotat varmasti web-käyttäjiin.';
$_lang["rb_webuser_title"] = 'Web-käyttäjät?';
$_lang["recent_docs"] = 'Viimeisimmät sivut';
$_lang["recommend_setting_change_title"] = 'Suositeltava asetusten muutos';
$_lang["recommend_setting_change_description"] = 'Sivustolla ei ole käytössä ylläpidon HTTP_REFERER tunnisteiden tarkistusta. On suositeltavaa ottaa tarkistus käyttöön CSFR-verkkohyökkäysten (Cross Site Request Forgery) estämiseksi.';
$_lang["refresh_cache"] = 'Välimuisti: Välimuistikansiosta löytyi <strong>%s</strong> tiedostoa ja <strong>%d</strong> välimuistitiedostoa.<p>Uudet välimuistisivut luodaan sivujen lataamisen yhteydessä.';
$_lang["refresh_published"] = '<strong>%s</strong> sivua julkaistiin.';
$_lang["refresh_site"] = 'Tyhjennä välimuisti';
$_lang["refresh_title"] = 'Välimuisti tyhjennetty';
$_lang["refresh_tree"] = 'Päivitä';
$_lang["refresh_unpublished"] = '<strong>%s</strong> sivua piilotettiin.';
$_lang["release_date"] = 'Release date';
$_lang["remember_last_tab"] = 'Muista välilehdet';
$_lang["remember_last_tab_message"] = 'Viimeksi käytetty välilehti latautuu ensin oletuksena ensimmäisenä olevan välilehden sijaan.';
$_lang["remember_username"] = 'Muista minut';
$_lang["remove"] = 'Poista';
$_lang["remove_date"] = 'Poista päiväys';
$_lang["remove_locks"] = 'Poista lukot';
$_lang["rename"] = 'Nimeä uudelleen';
$_lang["reports"] = 'Raportit';
$_lang["require_tagname"] = 'Metatiedon nimi on välttämätön';
$_lang["require_tagvalue"] = 'Metatiedon arvo on välttämätön';
$_lang["reserved_name_warning"] = 'You have used a reserved name.';
$_lang["reset"] = 'Tyhjennä';
$_lang["reset_failedlogins"] = 'tyhjennä';
$_lang["resource"] = 'Sivu';
$_lang["resource_alias"] = 'Alias';
$_lang["resource_alias_help"] = 'Määrittelee sivun internet-selaimen osoitekentässä näkyvän osoitteen viimeisen osan, esim. http://www.kotisivu.fi/sivun-alias. HUOM! Sivun alias luodaan automaattisesti sivun otsikon perusteella, jos jätät aliaksen tyhjäksi.';
$_lang["resource_content"] = 'Sivun sisältö';
$_lang["resource_description"] = 'Kuvaus';
$_lang["resource_description_help"] = 'Vapaaehtoinen sivun kuvaus.';
$_lang["resource_duplicate"] = 'Tee kopio';
$_lang["resource_long_title_help"] = 'Sivun sisältöä paremmin kuvaava pitkä otsikko on hyödyllinen hakukoneille.';
$_lang["resource_metatag_help"] = 'Valitse sivun metatiedot ja avainsanat. Voit valita useita metatietoja ja avainsanoja pitämällä CTRL-näppäintä pohjassa.';
$_lang["resource_opt_contentdispo"] = 'Sisällön esitystapa';
$_lang["resource_opt_contentdispo_help"] = 'Sisällön luonne määrittelee, miten selain käsittelee sivua. Esim. tiedoston latauksia varten valitse Liite -valinta.';
$_lang["resource_opt_emptycache"] = 'Tyhjennä välimuisti?';
$_lang["resource_opt_emptycache_help"] = 'Määrittelee tyhjennetäänkö välimuisti sivun tallennuksen yhteydessä. Jos välimuistia ei tyhjennetä, muuttunut sisältö ei välttämättä näy vierailijoille.';
$_lang["resource_opt_folder"] = 'Kansio?';
$_lang["resource_opt_folder_help"] = 'Määrittele sivu kansioksi. Tästä ei normaalisti tarvitse huolehtia ollenkaan, koska sivu muuttuu automaattisesti kansioksi, jos sen alle lisätään toinen sivu.';
$_lang["resource_opt_menu_index"] = ' Järjestysnumero valikossa';
$_lang["resource_opt_menu_index_help"] = 'Sivujen keskinäinen järjestys valikoissa, esim. järjestys sivuston navigaatiovalikossa.';
$_lang["resource_opt_menu_title"] = 'Otsikko valikossa';
$_lang["resource_opt_menu_title_help"] = 'Sivun valikoissa näkyvä sivun otsikko. Jos valikon otsikko on tyhjä, valikoissa käytetään otsikkona sivun otsikkoa ';
$_lang["resource_opt_published"] = 'Julkaistu?';
$_lang["resource_opt_published_help"] = 'Julkaistaanko sivu heti tallennuksen jälkeen?';
$_lang["resource_opt_richtext"] = 'Sisältöeditori?';
$_lang["resource_opt_richtext_help"] = 'Määrittelee käytetäänko tekstinkäsittelyohjelmaa muistuttavaa sisältöeditoria (rich text editor) sivun siällön muokkaamiseen. Jos sivu sisältää JavaScriptiä tai lomakkeita, sisältöeditorin käyttäminen voi sotkea sisältöä.';
$_lang["resource_opt_show_menu"] = ' Näytä valikossa';
$_lang["resource_opt_show_menu_help"] = 'Näytetäänkö sivu valikoissa, esim. sivuston naviaatiovalikossa?';
$_lang["resource_opt_trackvisit_help"] = 'Kirjaa kävijöiden vierailut sivulla.';
$_lang["resource_overview"] = 'Yhteenveto';
$_lang["resource_parent"] = 'Sivun paikka';
$_lang["resource_parent_help"] = 'Napsauta ensin yllä olevaa kansiokuvaketta ja sitten sivukartasta sitä sivua, jonka alle tämä sivu sijoitetaan.';
$_lang["resource_permissions_error"] = 'Sijoita tämä sivu vähintään yhteen sivuryhmään, johon myös itselläsi on käyttöoikeudet.';
$_lang["resource_setting"] = 'Sivun asetukset';
$_lang["resource_summary"] = 'Yhteenveto';
$_lang["resource_summary_help"] = 'Sivun yhteenveto.';
$_lang["resource_title"] = 'Otsikko';
$_lang["resource_title_help"] = 'Sivun otsikko. Vältä kenoviivoja otsikon nimessä.';
$_lang["resource_to_be_moved"] = 'Siirrettävä sivu';
$_lang["resource_type"] = 'Sivun tyyppi';
$_lang["resource_type_message"] = 'Hyperlinkki on sivu, joka ei sisällä muuta kuin suoran linkin johonkin toiseen verkkosivuun, kuvaan tai muuhun tiedostoon.';
$_lang["resource_type_weblink"] = 'Hyperlinkki';
$_lang["resource_type_webpage"] = 'Sivu';
$_lang["resource_weblink_help"] = 'Hyperlinkin osoite, esim. www-sivun osoite. Voit myös valita hyperlinkiksi jonkin sivun napsauttamalla kansio-kuvaketta ja napsauttamalla tämän jälkeen sivukartasta haluamaasi sivua.';
$_lang["resources_in_container"] = 'Alasivut';
$_lang["resources_in_container_no"] = 'Sivulla ei ole yhtään alasivua.';
$_lang["role"] = 'Rooli';
$_lang["role_about"] = 'Näytä ohjeet';
$_lang["role_access_persmissions"] = 'Käyttöoikeudet';
$_lang["role_actionok"] = 'Näytä "toiminto suoritettu" -viestit';
$_lang["role_bk_manager"] = 'Käytä varmuuskopiointia';
$_lang["role_cache_refresh"] = 'Tyhjennä sivuston välimuisti';
$_lang["role_change_password"] = 'Muuta salasana';
$_lang["role_change_resourcetype"] = 'Muuta Materiaalityyppi';
$_lang["role_chunk_management"] = 'HTML-palasten hallinta';
$_lang["role_config_management"] = 'Asetusten hallinta';
$_lang["role_content_management"] = 'Sisällönhallinta';
$_lang["role_create_chunk"] = 'Luo uusi HTML-palanen';
$_lang["role_create_doc"] = 'Luo uusi sivu';
$_lang["role_create_plugin"] = 'Luo uusi liitännäinen';
$_lang["role_create_snippet"] = 'Luo uusi PHP-palanen';
$_lang["role_create_template"] = 'Luo uusi sivupohja';
$_lang["role_credits"] = 'Näytä kunniamaininnat';
$_lang["role_delete_chunk"] = 'Poista HTML-palanen';
$_lang["role_delete_doc"] = 'Poista sivu';
$_lang["role_delete_eventlog"] = 'Tyhjennä tapahtumaloki';
$_lang["role_delete_module"] = 'Poista moduuli';
$_lang["role_delete_plugin"] = 'Poista liitännäinen';
$_lang["role_delete_role"] = 'Poista rooli';
$_lang["role_delete_snippet"] = 'Poista PHP-palanen';
$_lang["role_delete_template"] = 'Poista sivupohja';
$_lang["role_delete_user"] = 'Poista käyttäjä';
$_lang["role_delete_web_user"] = 'Poista web-käyttäjä';
$_lang["role_edit_chunk"] = 'Muokkaa HTML-palasta';
$_lang["role_edit_doc"] = 'Muokkaa sivua';
$_lang["role_edit_doc_metatags"] = 'Muokkaa sivun metatietoja ja avainsanoja';
$_lang["role_edit_module"] = 'Muokkaa moduulia';
$_lang["role_edit_plugin"] = 'Muokkaa liitännäisiä';
$_lang["role_edit_role"] = 'Muokkaa roolia';
$_lang["role_edit_settings"] = 'Muuta sivuston asetuksia';
$_lang["role_edit_snippet"] = 'Muokkaa PHP-palasta';
$_lang["role_edit_template"] = 'Muokkaa sivupohjaa';
$_lang["role_edit_user"] = 'Muokkaa käyttäjää';
$_lang["role_edit_web_user"] = 'Muokkaa web-käyttäjää';
$_lang["role_empty_trash"] = 'Poista pysyvästi poistetut sivut';
$_lang["role_errors"] = 'Näytä virheilmoitukset';
$_lang["role_eventlog_management"] = 'Tapahtumalokin hallinta';
$_lang["role_export_static"] = 'Vie staattinen HTML';
$_lang["role_file_manager"] = 'Käytä tiedostoselainta';
$_lang["role_frames"] = 'Näytä ylläpito';
$_lang["role_help"] = 'Näytä ohjesivut';
$_lang["role_home"] = 'Näytä aloitussivu';
$_lang["role_import_static"] = 'Tuo HTML';
$_lang["role_logout"] = 'Kirjaudu ulos ylläpidosta';
$_lang["role_manage_metatags"] = 'Hallitse sivuston metatietoja ja avainsanoja';
$_lang["role_management_msg"] = 'Muokkaa rooleja.';
$_lang["role_management_title"] = 'Roolit';
$_lang["role_messages"] = 'Lue ja lähetä viestejä';
$_lang["role_module_management"] = 'Moduulien hallinta';
$_lang["role_name"] = 'Nimi';
$_lang["role_new_module"] = 'Luo uusi moduuli';
$_lang["role_new_role"] = 'Luo uusi rooli';
$_lang["role_new_user"] = 'Luo uusi käyttää';
$_lang["role_new_web_user"] = 'Luo uusi web-käyttäjä';
$_lang["role_plugin_management"] = 'Liitännäisten hallinta';
$_lang["role_publish_doc"] = 'Julkaise sivu';
$_lang["role_remove_locks"] = 'Poista lukot';
$_lang["role_role_management"] = 'Roolien hallinta';
$_lang["role_run_module"] = 'Suorita moduuli';
$_lang["role_save_chunk"] = 'Tallenna HTML-palanen';
$_lang["role_save_doc"] = 'Tallenna sivu';
$_lang["role_save_module"] = 'Tallenna moduuli';
$_lang["role_save_password"] = 'Tallenna salasana';
$_lang["role_save_plugin"] = 'Tallenna liitännäisiä';
$_lang["role_save_role"] = 'Tallenna roolit';
$_lang["role_save_snippet"] = 'Tallenna PHP-palanen';
$_lang["role_save_template"] = 'Tallenna sivupohja';
$_lang["role_save_user"] = 'Tallenna käyttäjät';
$_lang["role_save_web_user"] = 'Tallenna web-käyttäjä';
$_lang["role_snippet_management"] = 'PHP-palasten hallinta';
$_lang["role_template_management"] = 'Sivupohjien hallinta';
$_lang["role_title"] = 'Muokkaa roolia';
$_lang["role_udperms"] = 'Käyttöoikeuksien hallinta';
$_lang["role_user_management"] = 'Käyttäjähallinta';
$_lang["role_view_docdata"] = 'Näytä sivun tiedot';
$_lang["role_view_eventlog"] = 'Näytä tapahtumaloki';
$_lang["role_view_logs"] = 'Näytä järjestelmän lokit';
$_lang["role_view_unpublished"] = 'Näytä julkaisemattomat / piilotetut sivut';
$_lang["role_web_access_persmissions"] = 'Web-käyttöoikeudet';
$_lang["role_web_user_management"] = 'Web-käyttäjän hallinta';
$_lang["rss_url_news_default"] = 'https://feeds.feedburner.com/evocms-release-news';
$_lang["rss_url_news_message"] = 'Anna MODX-uutisten osoite (RSS-syöte).';
$_lang["rss_url_news_title"] = 'RSS / Uutiset';
$_lang["rss_url_security_default"] = 'https://feeds.feedburner.com/evocms-security-news';
$_lang["rss_url_security_message"] = 'Anna MODX-tietoturvatiedotteiden osoite (RSS-syöte).';
$_lang["rss_url_security_title"] = 'RSS / Tietoturvatiedotteet';
$_lang["run_module"] = 'Suorita moduuli';
$_lang["saturday"] = 'Lauantai';
$_lang["save"] = 'Tallenna';
$_lang["save_all_changes"] = 'Tallenna kaikki muutokset';
$_lang["save_tag"] = 'Tallenna metatieto';
$_lang["saving"] = 'Tallentaa, odota hetki...';
$_lang["search"] = 'Haku';
$_lang["search_criteria"] = 'Hakuehto';
$_lang["search_criteria_content"] = 'Sisältö';
$_lang["search_criteria_content_msg"] = 'Hae sivut, joiden sisällöstä löytyy syötetty teksti.';
$_lang["search_criteria_id"] = 'ID';
$_lang["search_criteria_id_msg"] = 'Hae sivu ID-tunnuksella.';
$_lang["search_criteria_template_id"] = 'Sivupohjan ID';
$_lang["search_criteria_template_id_msg"] = 'Hae sivut, jotka käyttävät annettua sivupohjaa.';
$_lang["search_criteria_longtitle"] = 'Pitkä otsikko';
$_lang["search_criteria_longtitle_msg"] = 'Hae sivut, joiden pitkästä otsikosta löytyy syötetty teksti.';
$_lang["search_criteria_title"] = 'Otsikko';
$_lang["search_criteria_title_msg"] = 'Hae sivut, joiden otsikosta löytyy syötetty teksti.';
$_lang["search_empty"] = 'Hakusi ei tuottanut tulosta. Laajenna hakuehtoja ja yritä uudelleen.';
$_lang["search_item_deleted"] = 'Tämä kohde on poistettu';
$_lang["search_results"] = 'Haun tulokset';
$_lang["search_results_returned_desc"] = 'Kuvaus';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Haulla löytyi <strong>%s</strong> sivua. Jos hakutuloksia on paljon, yritä käyttää tarkempia hakuehtoja. <p />';
$_lang["search_results_returned_title"] = 'Otsikko';
$_lang["search_view_docdata"] = 'Näytä tämä kohde';
$_lang["security"] = 'Käyttäjät';
$_lang["security_notices_tab"] = 'Tietoturvatiedotteet';
$_lang["security_notices_title"] = 'MODX Tietoturvatiedotteet';
$_lang["select_date"] = 'Valitse päiväys';
$_lang["send"] = 'Lähetä';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Määrittele käytetäänkö salattua https-yhteyttä.';
$_lang["server_protocol_title"] = 'Palvelimen tyyppi:';
$_lang["serveroffset"] = 'Palvelimen aikaero';
$_lang["serveroffset_message"] = 'Valitse sivuston käyttäjien ja palvelimen välinen aikaero tunneissa. Nykyinen aika palvelimella on  <strong>[%s]</strong> ja nykyinen palvelimen aika tämän hetkistä aikaeroa käyttäen on <strong>[%s]</strong>.';
$_lang["serveroffset_title"] = 'Palvelimen aikaero:';
$_lang["servertime"] = 'Palvelimen aika';
$_lang["settings_after_install"] = 'Koska tämä on uusi asennus, tulee tarkistaa nämä asetukset ja muuttaa niitä tarpeesi mukaan. Kun olet tarkistanut asetukset, paina "Tallenna" päivittääksesi muutokset tietokantaan.';
$_lang["settings_config"] = 'Asetukset';
$_lang["settings_dependencies"] = 'Riippuvuudet';
$_lang["settings_events"] = 'Järjestelmätapahtumat';
$_lang["settings_furls"] = 'Selkokieliset osoitteet';
$_lang["settings_general"] = 'Yleiset';
$_lang["settings_misc"] = 'Sekalaiset asetukset';
$_lang["settings_KC"] = 'File Browser';
$_lang["settings_page_settings"] = 'Julkaisuasetukset';
$_lang["settings_photo"] = 'Kuva';
$_lang["settings_properties"] = 'Asetukset';
$_lang["settings_site"] = 'Sivuston asetukset';
$_lang["settings_strip_image_paths_message"] = 'Mahdollistaa tiedostojen osoitteiden (kuvat, flash ja muut tiedostot) uudelleenkirjoittamisen. Asetus "Ei" jättää osoitteen kiinteäksi. Osoitteiden uudellenkirjoittaminen on erittäin kätevää, jos sivusto on tarkoitus siirtää palvelimelta toiselle (esim. testisivustolta tuotantosivustolle). Jos et tiedä mitä tämä asetus oikeastaan tekee, on parasta jättää valinta kohtaan "Kyllä".';
$_lang["settings_strip_image_paths_title"] = 'Uudelleenkirjoita tiedostojen polut?';
$_lang["settings_templvars"] = 'Sivun sisältö (sivupohjan muokattavat kohdat)';
$_lang["settings_title"] = 'Järjestelmän asetukset';
$_lang["settings_ui"] = 'Käyttöliittymän ja editorin asetukset';
$_lang["settings_users"] = 'Käyttäjäasetukset';
$_lang["show_meta"] = 'Näytä META-avainsanat välilehti';
$_lang["show_meta_message"] = 'Näytä META-avainsanat välilehti sivujen muokkaamisen yhteydessä.';
$_lang["show_tree"] = 'Näytä sivukartta';
$_lang["showing"] = 'Näytetään';
$_lang["signupemail_message"] = 'Määrittele uusille käyttäjille lähetettävän liittymissähköpostin sisältö, esim. uuden käyttäjän käyttäjänimi ja salasana. <br /><strong>HUOMAA:</strong> Sisällönhallintajärjestelmä korvaa seuraavat kohdat, kun viesti on lähetetty: <br /><br />[+sname+] - Sivuston nimi, <br />[+saddr+] - Sivuston sähköpostiosoite, <br />[+surl+] - Sivuston osoite, <br />[+uid+] - Käyttäjän kirjautumisnimi tai id, <br />[+pwd+] - Käyttäjän salasana, <br />[+ufn+] - Käyttäjän koko nimi. <br /><br /><strong>Jätä ainakin [+uid+] ja [+pwd+] sähköpostiviestiin, koska muuten käyttäjä ei saa tietoonsa omaa käyttäjänimeään ja salasanaa!</strong>';
$_lang["signupemail_title"] = 'Liittymissähköposti:';
$_lang["site"] = 'Sivusto';
$_lang["site_schedule"] = 'Sivuston aikataulu';
$_lang["sitename_message"] = 'Anna sivustolle nimi. Nimeä käytetään mm. kirjautumisen yhteydessä';
$_lang["sitename_title"] = 'Sivuston nimi:';
$_lang["sitestart_message"] = 'Syötä aloitussivuna käytettävän sivun ID. <strong>HUOMAA:</strong> Varmista, että ID on olemassa ja, että kyseinen sivu on julkaistu!';
$_lang["sitestart_title"] = 'Aloitussivu:';
$_lang["sitestatus_message"] = 'Jos sivusto on käytössä, kaikki voivat selata sivustoa normaalisti. Jos sivusto on poissa käytöstä (esim. huoltokatko tms.), tavalliset käyttäjät näkevät ainoastaan "sivusto poissa käytössä" -viestin. Ylläpitoon kirjautuneet käyttäjät voivat edelleen selata sivustoa normaalisti.';
$_lang["sitestatus_title"] = 'Sivuston tila:';
$_lang["siteunavailable_message"] = 'Viesti näytetään, kun sivusto on poissa käytöstä. <strong>HUOMAA:</strong> Viesti näytetään vain jos "Sivusto poissa käytöstä" -sivua ei ole asetettu.';
$_lang["siteunavailable_message_default"] = 'Sivusto on tällähetkellä poissa käytöstä.';
$_lang["siteunavailable_page_message"] = 'Syötä sivusto poissa käytöstä -sivuna käytettävän sivun ID. Sivu näytetään, jos sivuston tila on poissa käytöstä. <strong>HUOMAA:</strong> Varmista, että ID on olemassa ja, että kyseinen sivu on julkaistu!';
$_lang["siteunavailable_page_title"] = 'Sivusto poissa käytöstä -sivu:';
$_lang["siteunavailable_title"] = 'Sivusto poissa käytöstä -viesti:';
$_lang["snippet"] = 'PHP-palanen';
$_lang["snippet_code"] = 'Lähdekoodi (php)';
$_lang["snippet_desc"] = 'Kuvaus';
$_lang["snippet_execonsave"] = 'Suorita PHP-palanen tallennuksen jälkeen.';
$_lang["snippet_management_msg"] = 'Muokkaa PHP-palasia (snippet).';
$_lang["snippet_msg"] = 'Muokkaa PHP-palasta (snippet). Muista, että PHP-palaset  ovat PHP-koodia ja niitä käsitellään sen mukaisesti. PHP-palasen lopputulos täytyy siis myös muistaa palauttaa, esim. return $output;';
$_lang["snippet_name"] = 'Nimi';
$_lang["snippet_properties"] = 'Oletusasetukset';
$_lang["snippet_title"] = 'PHP-palanen';
$_lang["sort_asc"] = 'Nouseva';
$_lang["sort_desc"] = 'Laskeva';
$_lang["sort_tree"] = 'Järjestä';
$_lang["source"] = 'Lähde';
$_lang["stay"] = 'Jatka muokkausta';
$_lang["stay_new"] = 'Lisää toinen';
$_lang["submit"] = 'OK';
$_lang["sunday"] = 'Sunnuntai';
$_lang["sys_alert"] = 'Järjestelmähälytys';
$_lang["sysinfo_activity_message"] = 'Lista viimeksi muokatuista sivuista.';
$_lang["sysinfo_userid"] = 'Käyttäjä';
$_lang["system_email_signup"] = 'Hei [+uid+]

Tässä ovat kirjautumistiedot henkilölle [+sname+] Sisällönhallintajärjestelmä:

Käyttäjänimi: [+uid+]
Salasana: [+pwd+]

Kun olet kirjautunut Sisällönhallintajärjestelmään, voit muuttaa salasanasi.

Terveisin,
Sivuston Ylläpitäjä';
$_lang["system_email_webreminder"] = 'Hei [+uid+]

Aktivoidaksesi uuden salasanasi, napsauta linkkiä:

[+surl+]

Jos toiminto onnistuu, voit käyttää seuraavaa salasanaa kirjautuaksesi sisään:

Salasana:[+pwd+]
Jos et tilannut tätä sähköpostiviestiä, älä HUOMAAi tätä.

Terveisin,
Sivuston Ylläpitäjä';
$_lang["system_email_websignup"] = 'Hei [+uid+]

Tässä ovat kirjautumistiedot henkilölle [+sname+]:

Käyttäjänimi: [+uid+]
Salasana: [+pwd+]

Kun olet kirjautunut Sisällönhallintajärjestelmään, voit muuttaa salasanasi.

Terveisin,
Sivuston Ylläpitäjä';
$_lang["table_hoverinfo"] = 'Katso taulun tarkempi selitysteksti viemällä hiiren osoitin taulun nimen päälle. Kaikissa tauluissa ei ole selitystekstiä.';
$_lang["table_prefix"] = 'Taulun etuliite';
$_lang["tag"] = 'Metatiedon tyyppi';
$_lang["template"] = 'Sivupohja';
$_lang["template_assignedtv_tab"] = 'Määritetyt sivupohjan muuttujat';
$_lang["template_code"] = 'Lähdekoodi (html)';
$_lang["template_desc"] = 'Kuvaus';
$_lang["template_edit_tab"] = 'Muokkaa sivupohjaa';
$_lang["template_management_msg"] = 'Muokkaa sivupohjia (template).';
$_lang["template_msg"] = 'Muokkaa sivupohjaa (template). Muokatut sivupohjat otetaan käyttöön vasta, kun välimuisti on tyhjennetty. Tätä ennen voit tarkastella muokattua sivupohjaa käytössä sivun esikatselutoiminnon avulla.';
$_lang["template_name"] = 'Nimi';
$_lang["template_no_tv"] = 'Tähän sivupohjaan ei ole määritelty muuttujia.';
$_lang["template_reset_all"] = 'Aseta kaikki sivut käyttämään oletussivupohjaa';
$_lang["template_reset_specific"] = 'Aseta vain oletussivupohjaa \'%s\' käyttävät sivut';
$_lang["template_assigned_blade_file"] = 'Vastaava blade-tiedosto';
$_lang["template_create_blade_file"] = 'Luo mallitiedosto tallennettaessa';
$_lang["template_title"] = 'Sivupohja';
$_lang["template_tv_edit"] = 'Muokkaa muuttujien järjestystä';
$_lang["template_tv_edit_message"] = 'Muuta sivupohjan muuttujien järjestystä vetämällä.';
$_lang["template_tv_edit_title"] = 'Sivupohjan muuttujien järjestys';
$_lang["template_tv_msg"] = 'Sivupohjaan liitetyt muuttujat.';
$_lang["thursday"] = 'Torstai';
$_lang["tmplvar_access_msg"] = 'Valitse sivuryhmät, joilla on oikeus muuttaa sivupohjan muuttujan sisältöä tai arvoa.';
$_lang["tmplvar_change_template_msg"] = 'Sivupohjan muuttaminen aiheuttaa muuttujien lataamisen uudelleen. Kaikki tallentamattomat muutokset menetetään.\n\n Haluatko varmasti muuttaa käytettävän sivupohjan?';
$_lang["tmplvar_inuse"] = 'Seuraavat sivut käyttävät parhaillaan sivupohjan muuttujaa. Jatka poistamista napsauttamalla Poista -painiketta tai peruuta Peruuta -painikkeesta.';
$_lang["tmplvar_tmpl_access"] = 'Sivupohjat';
$_lang["tmplvar_tmpl_access_msg"] = 'Valitse sivupohjat, joissa muuttuja on käytössä.';
$_lang["tmplvars"] = 'Sivupohjan muuttujat';
$_lang["tmplvars_binding_msg"] = 'Tietolähteiden tuonti / sitominen (bindings) on mahdollista @ -komennolla.';
$_lang["tmplvars_caption"] = 'Otsikko';
$_lang["tmplvars_default"] = 'Oletusarvo';
$_lang["tmplvars_description"] = 'Kuvaus';
$_lang["tmplvars_elements"] = 'Arvovaihtoehdot';
$_lang["tmplvars_inherited"] = 'Value inherited';
$_lang["tmplvars_management_msg"] = 'Muokkaa sivupohjan muuttujia (template variable).';
$_lang["tmplvars_msg"] = 'Muokkaa sivupohjan muuttujaa (template variable). Muista, että muuttujat täytyy yhdistää haluttuihin sivupohjiin.';
$_lang["tmplvars_name"] = 'Nimi';
$_lang["tmplvars_novars"] = 'Sivupohjan muuttujia ei löytynyt';
$_lang["tmplvars_rank"] = 'Järjestysnumero';
$_lang["tmplvars_reset_params"] = 'Tyhjennä parametrit';
$_lang["tmplvars_title"] = 'Luo/muokkaa sivupohjan muuttuja';
$_lang["tmplvars_type"] = 'Tyyppi';
$_lang["tmplvars_widget"] = 'Toiminto (widget)';
$_lang["tmplvars_widget_prop"] = 'Toimintoasetukset (widget)';
$_lang["to"] = '-';
$_lang["tools"] = 'Työkalut';
$_lang["top_howmany_message"] = 'Aseta "Top..." -listojen pituus.';
$_lang["top_howmany_title"] = 'Top-listat:';
$_lang["total"] = 'yhteensä';
$_lang["track_visitors_message"] = 'MODX ei sisällä oletuksena kävijäseurantaa, joten valinnalla ei ole vaikutusta ellei erillistä kävijäseurantaa ole asennettu.';
$_lang["track_visitors_title"] = 'Kävijäseuranta:';
$_lang["tree_page_click"] = 'Sivun napsautus';
$_lang["tree_page_click_message"] = 'Oletustoiminto napsautettaessa sivua sivukartassa.';
$_lang["tree_show_protected"] = 'Näytä suojatut sivut:';
$_lang["tree_show_protected_message"] = 'Näytetäänkö suojatut sivut (ja kaikki alisivut) sivukartassa.';
$_lang["truncate_table"] = 'Tyhjää taulukko napsauttamalla';
$_lang["tuesday"] = 'Tiistai';
$_lang["tv"] = 'Sivupohjan muuttuja';
$_lang["type"] = 'Tyyppi';
$_lang["udperms_allowroot_message"] = 'Sallitaanko käyttäjille mahdollisuus luoda uusia sivuja sivuston juureen? ';
$_lang["udperms_allowroot_title"] = 'Salli juuri:';
$_lang["udperms_message"] = 'Käyttöoikeudet määrittävät mm. mitä sivuja käyttäjillä on mahdollisuus muokata. Käyttöoikeudet määritellään käyttäjä- ja sivuryhmien avulla. Käyttäjäryhmille annetaan tarvittavat oikeudet sivuryhmiin. Pääkäytttäjillä (Administrator) on käyttöoikeuksista riippumatta aina täydet oikeudet kaikkiin sivuihin.';
$_lang["udperms_title"] = 'Käytä käyttöoikeuksia:';
$_lang["unable_set_link"] = 'Linkin asettaminen ei onnistunut!';
$_lang["unable_set_parent"] = 'Uuden pääryhmän asettaminen epäonnistui!';
$_lang["unauthorizedpage_message"] = 'Syötä pääsy kielletty -sivuna käytettävän sivun ID. Sivu näytetään, jos käyttäjä yrittää päästä käyttöoikeuksiltaan rajoitettuun sivuun, johon kyseisellä käyttäjälle ei ole oikeuksia. <strong>HUOMAA:</strong> Varmista, että ID on olemassa ja, että kyseinen sivu on julkaistu!';
$_lang["unauthorizedpage_title"] = 'Pääsy kielletty -sivu:';
$_lang["unblock_message"] = 'Tämä käyttäjä ei ole estetty käyttäjätietojen tallentamisen jälkeen.';
$_lang["undelete_resource"] = 'Palauta';
$_lang["unpublish_date"] = 'Piilotuspäiväys';
$_lang["unpublish_events"] = 'Piilotettavien sivujen aikataulu';
$_lang["unpublish_resource"] = 'Piilota';
$_lang["untitled_resource"] = 'Nimetön sivu';
$_lang["untitled_weblink"] = 'Nimetön hyperlinkki';
$_lang["update_params"] = 'Päivitä parametrit';
$_lang["update_settings_from_language"] = 'Korvaa nykyinen:';
$_lang["upload_maxsize_message"] = 'Enimmäiskoko tiedostoselaimen kautta siirrettäville tiedostoille. Tiedostokoko tulee ilmoittaa tavuina. <strong>HUOMAA:</strong> Suurien tiedostojen siirrossa voi kestää erittäin kauan!';
$_lang["upload_maxsize_title"] = 'Siirrettävän tiedoston enimmäiskoko';
$_lang["uploadable_files_message"] = 'Lista tiedostoista joita voidaan siirtää palvelimelle tiedostoselaimella. Erottele tiedostomuotojen päätteet pilkuilla.';
$_lang["uploadable_files_title"] = 'Siirrettävät tiedostot:';
$_lang["uploadable_flash_message"] = 'Luettele tiedostomuodot, joita käyttäjä voi ladata kansioon "assets/flash/". Erottele tunnisteet pilkuilla.';
$_lang["uploadable_flash_title"] = 'Ladattavat Flash-tiedostot:';
$_lang["uploadable_images_message"] = 'Luettele tiedostomuodot, joita käyttäjä voi ladata kansioon "assets/images/". Erottele tunnisteet pilkuilla.';
$_lang["uploadable_images_title"] = 'Ladattavat kuvatiedostot:';
$_lang["uploadable_media_message"] = 'Luettele tiedostomuodot, joita käyttäjä voi ladata kansioon "assets/media/". Erottele tunnisteet pilkuilla.';
$_lang["uploadable_media_title"] = 'Ladattavat mediatiedostot:';
$_lang["use_alias_path_message"] = 'Näyttää koko polun sivuun jos sivulla on alias. Esim. sivun alias on "alaryhma" ja se sijaitsee kansiossa, jonka alias on "ylaryhma". Tällöin aliaspoluksi luodaan "/ylaryhma/alaryhma.html".<br /><strong>HUOMAA:</strong> Jos selkokieliset aliaspolut ovat käytössä, kohteisiin (kuten kuvat, css, javaskriptit jne.) täytyy viitata käyttämällä todellista osoitetta:  esim. "/assets/images" ei "assets/images". Näin estetään selainta (tai palvelinta) lisäämästä suhteellista polkua aliaspolkuun.';
$_lang["use_alias_path_title"] = 'Käytä selkokielistä aliaspolkua:';
$_lang["use_editor_message"] = 'Käytetäänkö teksinkäsittelyohjelmaa muistuttavaa sisältöeditoria (rich text editor)? Jos kirjoitat mieluummin suoraan HTML:ää, poista editori käytöstä. Valinta kohdistuu kaikkiin sivuihin ja käyttäjiin!';
$_lang["use_editor_title"] = 'Käytä sisältöeditoria:';
$_lang["user"] = 'Käyttäjä';
$_lang["user_block"] = 'Kirjautuminen estetty';
$_lang["user_blockedafter"] = 'Kirjautumisen esto alkaa';
$_lang["user_blockeduntil"] = 'Kirjautumisen esto loppuu';
$_lang["user_changeddata"] = 'Tietojasi on muutettu. Kirjaudu uudestaan sisään.';
$_lang["user_country"] = 'Maa';
$_lang["user_dob"] = 'Syntymäaika';
$_lang["user_doesnt_exist"] = 'Käyttäjää ei ole olemassa';
$_lang["user_edit_self_msg"] = 'Omien tietojen muuttamisen jälkeen saatat joutua kirjautumaan uudestaan ylläpitoon.</b>';
$_lang["user_email"] = 'Sähköpostiosoite';
$_lang["user_failedlogincount"] = 'Epäonnistuneet kirjautumiset';
$_lang["user_fax"] = 'Faksi';
$_lang["user_female"] = 'Nainen';
$_lang["user_full_name"] = 'Koko nimi';
$_lang["user_gender"] = 'Sukupuoli';
$_lang["user_is_blocked"] = 'Tämä käyttäjä on estetty!';
$_lang["user_logincount"] = 'Sisäänkirjautumisten lukumäärä';
$_lang["user_male"] = 'Mies';
$_lang["user_management_msg"] = 'Muokkaa ylläpidon käyttäjiä. Kaikilla ylläpidon käyttäjillä on oikeus kirjautua sisällönhallintajärjestelmän ylläpitoon (mutta ei kuitenkaan välttämättä käyttää ylläpitoa).';
$_lang["user_management_title"] = 'Ylläpidon käyttäjät';
$_lang["user_mobile"] = 'Matkapuhelimen numero';
$_lang["user_phone"] = 'Puhelinnumero';
$_lang["user_photo"] = 'Käyttäjän kuva';
$_lang["user_photo_message"] = 'Valitse kuva.';
$_lang["user_prevlogin"] = 'Viimeksi kirjautunut';
$_lang["user_role"] = 'Käyttäjän rooli';
$_lang["user_state"] = 'Lääni / alue';
$_lang["user_title"] = 'Muokkaa ylläpidon käyttäjää';
$_lang["user_upload_message"] = ' Jos käyttäjältä halutaan estää kategoriaan kuuluvien tiedostojen lataaminen, ota valinta pois kohdasta "Käytä järjestelmän asetusta". ';
$_lang["user_use_config"] = 'Käytä järjestelmän asetusta';
$_lang["user_zip"] = 'Postinumero';
$_lang["username"] = 'Käyttäjänimi';
$_lang["users"] = 'Turvallisuus';
$_lang["valid_hostnames_message"] = 'Auta estämään site_url järjestelmäasetusta hyväksikäyttäviä XSS haavoittuvuuksia antamalla pilkuilla eroteltu lista hyväksytyistä palvelimen nimistä (hostname) tälle asennukselle. Tämä on tärkeää tietyn tyyppisissä jaetuissa palvelinympäristöissä tai palvelimilla joita voidaan käyttää myös suoraan IP-osoitteen avulla. Jos HTTP_HOST arvo ei täsmää mihinkään hyväksyttyyn nimeen, käytetään listan ensimmäistä nimeä.';
$_lang["valid_hostnames_title"] = 'Hyväksytyt palvelimen nimet (hostname)';
$_lang["validate_referer_message"] = 'Tarkasta HTTP_REFERER tunnisteet vähentääksesi mahdollisuutta, että ylläpidon käyttäjiä huijataan suorittamaan tietämättään ei-toivottuja toimintoja (Cross Site Request Forgery Attack). Asetusta ei mahdollisesti voida käyttää, jos palvelin ei lähetä HTTP_REFERER tunnistetta.';
$_lang["validate_referer_title"] = 'Tarkasta HTTP_REFERER tunnisteet?';
$_lang["value"] = 'Arvo';
$_lang["view"] = 'Näytä';
$_lang["view_child_resources_in_container"] = 'Näytä alasivut';
$_lang["view_log"] = 'Näytä loki';
$_lang["view_logging"] = 'Toimintojen jäljitys';
$_lang["view_sysinfo"] = 'Järjestelmän tiedot';
$_lang["warning"] = 'Varoitus!';
$_lang["warning_not_saved"] = 'Muutoksia ei ole vielä tallennettu. Voit pysyä nykyisellä sivulla ja tallentaa muutokset (\'Peruuta\'), tai voit lähteä tältä sivulta, menettäen kaikki tekemäsi muutokset (\'OK\')';
$_lang["warning_visibility"] = 'Ylläpidon asetusvaroitusten näkyvyys';
$_lang["warning_visibility_message"] = 'Muuta ylläpidon asetusvaroitusten näkyvyyttä ylläpidon Tervetuloa -sivulla.';
$_lang["web_access_permissions"] = 'Web-käyttöoikeudet';
$_lang["web_access_permissions_user_groups"] = 'Web-käyttäjäryhmät';
$_lang["web_permissions"] = 'Web-käyttöoikeudet';
$_lang["web_user_management_msg"] = 'Muokkaa Web-käyttäjiä. Web-käyttäjillä ei ole oikeuksia kirjautua sisällönhallintajärjestelmän ylläpitoon. Web-käyttäjät voivat kuitenkin kirjautua sivuston suojatuille sivuille, esim. asiakassivut, extranet jne.';
$_lang["web_user_management_title"] = 'Web-käyttäjät';
$_lang["web_user_title"] = 'Muokkaa web-käyttäjää';
$_lang["web_users"] = 'Web-käyttäjät';
$_lang["weblink"] = 'Hyperlinkki';
$_lang["webpwdreminder_message"] = 'Määrittele muistutuksena (esim. unohtunut salasana) käyttäjille lähetettävän liittymissähköpostin sisältö, esim. käyttäjän käyttäjänimi ja salasana. <br /><strong>HUOMAA:</strong> Sisällönhallintajärjestelmä korvaa seuraavat kohdat, kun viesti on lähetetty: <br /><br />[+sname+] - Sivuston nimi, <br />[+saddr+] - Sivuston sähköpostiosoite, <br />[+surl+] - Sivuston osoite, <br />[+uid+] - Käyttäjän kirjautumisnimi tai id, <br />[+pwd+] - Käyttäjän salasana, <br />[+ufn+] - Käyttäjän koko nimi. <br /><br /><strong>Jätä ainakin [+uid+] ja [+pwd+] sähköpostiviestiin, koska muuten käyttäjä ei saa tietoonsa omaa käyttäjänimeään ja salasanaa!</strong>';
$_lang["webpwdreminder_title"] = 'Muistutussähköposti:';
$_lang["websignupemail_message"] = 'Määrittele uusille web-käyttäjille lähetettävän liittymissähköpostin sisältö, esim. uuden käyttäjän käyttäjänimi ja salasana. <br /><strong>HUOMAA:</strong> Sisällönhallintajärjestelmä korvaa seuraavat kohdat, kun viesti on lähetetty: <br /><br />[+sname+] - Sivuston nimi, <br />[+saddr+] - Sivuston sähköpostiosoite, <br />[+surl+] - Sivuston osoite, <br />[+uid+] - Käyttäjän kirjautumisnimi tai id, <br />[+pwd+] - Käyttäjän salasana, <br />[+ufn+] - Käyttäjän koko nimi. <br /><br /><strong>Jätä ainakin [+uid+] ja [+pwd+] sähköpostiviestiin, koska muuten käyttäjä ei saa tietoonsa omaa käyttäjänimeään ja salasanaa!</strong>';
$_lang["websignupemail_title"] = 'Web-liittymissähköposti:';
$_lang["wednesday"] = 'Keskiviikko';
$_lang["welcome_messages"] = '<strong>%d</strong> viestiä, joista <strong>%s</strong> on lukematta.';
$_lang["welcome_title"] = 'Tervetuloa!';
$_lang["which_editor_message"] = 'Valitse käytettävä sisältöeditori (rich text editor).';
$_lang["which_editor_title"] = 'Käytettävä sisältöeditori:';
$_lang["working"] = 'Odota hetki...';
$_lang["wrap_lines"] = 'Automaattinen rivitys';
$_lang["xhtml_urls_message"] = 'Korvaa MODX:n luomat &amp; -merkkijonot osoitteissa validilla &amp;<!-- -->amp; html-entiteetillä';
$_lang["xhtml_urls_title"] = 'XHTML-osoitteet';
$_lang["yes"] = 'Kyllä';
$_lang["you_got_mail"] = 'Sinulle on viesti / viestejä';
$_lang["yourinfo_message"] = 'Olet kirjautuneena sisään seuraavilla tiedoilla:';
$_lang["yourinfo_previous_login"] = 'Viimeisin sisäänkirjautuminen:';
$_lang["yourinfo_role"] = 'Rooli:';
$_lang["yourinfo_title"] = 'Info';
$_lang["yourinfo_total_logins"] = 'Sisäänkirjautumisia yhteensä:';
$_lang["yourinfo_username"] = 'Käyttäjänimi:';

$_lang["a17_error_reporting_title"] = 'Detection level of the PHP error';
$_lang["a17_error_reporting_msg"] = 'Set the detection level of the PHP error.';
$_lang["a17_error_reporting_opt0"] = 'Ignore all';
$_lang["a17_error_reporting_opt1"] = 'Ignore the warning of a slight notice level(<a href="https://www.google.com/search?q=E_DEPRECATED+E_NOTICE" target="_blank">E_ALL & ~E_NOTICE & ~E_DEPRECATED</a>)';
$_lang["a17_error_reporting_opt2"] = 'Detect all errors except E_NOTICE and E_USER_DEPRECATED';
$_lang["a17_error_reporting_opt99"] = 'Detect all except E_USER_DEPRECATED';
$_lang["a17_error_reporting_opt199"] = 'Detect all';

$_lang["pwd_hash_algo_title"] = 'Hash algorithm';
$_lang["pwd_hash_algo_message"] = 'Password hash algorithm.';

$_lang["enable_bindings_title"] = 'Enable @Bindings commands';
$_lang["enable_bindings_message"] = 'Prevents the execution of PHP functions through TV @Bindings. Useful if you have Manager users who should not be able to create PHP code but need to be able to create or edit TVs. The output of any TV with an @Binding will be "@Bindings disabled".';

$_lang["enable_filter_phx_warning"] = 'Kun PHX laajennusta asennettuna, sisäänrakennettu suodattimet ovat oletuksena poissa käytöstä';
$_lang["bkmgr_alert_mkdir"] = 'A file cannot be created in a directory.  Please check the permission of [+snapshot_path+]';
$_lang["bkmgr_restore_msg"] = '<p>A site can be restore using an SQL file. </p>';
$_lang["bkmgr_restore_title"] = 'Restore';
$_lang["bkmgr_import_ok"] = 'SQL recovery was performed normally.';
$_lang["bkmgr_snapshot_ok"] = 'The snapshot was saved normally.';
$_lang["bkmgr_run_sql_file_label"] = 'Execute by sql file';
$_lang["bkmgr_run_sql_direct_label"] = 'Direct execute SQL command strings';
$_lang["bkmgr_run_sql_submit"] = 'Execute restore';
$_lang["bkmgr_run_sql_result"] = 'Result';
$_lang["bkmgr_snapshot_title"] = 'Snapshot save and recovery';
$_lang["bkmgr_snapshot_msg"] = '<p>The contents of the database are saved and restored to a server.<br />Preservation place : [+snapshot_path+] ($modx->config[\'snapshot_path\'])</p>';
$_lang["bkmgr_snapshot_submit"] = 'Add snapshot';
$_lang["bkmgr_snapshot_list_title"] = 'List of snapshot';
$_lang["bkmgr_restore_submit"] = 'Palauta näyttölaite';
$_lang["bkmgr_restore_confirm"] = 'Oletko varma, että haluat palauttaa varmuuskopion\n[+filename+] ?';
$_lang["bkmgr_snapshot_nothing"] = 'No snapshot';

$_lang["files.dynamic.php1"] = 'create text file';
$_lang["files.dynamic.php2"] = 'This directory cannot be displayed.';
$_lang["files.dynamic.php3"] = 'There is a problem in a file name.';
$_lang["files.dynamic.php4"] = 'The text file was created.';
$_lang["files_dynamic_new_folder_name"] = 'Syötä uuden hakemiston nimi:';
$_lang["files_dynamic_new_file_name"] = 'Syötä uusi tiedostonimi:';
$_lang["not_readable_dir"] = 'Can not read this directory.';
$_lang["confirm_delete_dir"] = 'Are you sure you want to delete the directory?';
$_lang["confirm_delete_dir_recursive"] = 'Are you sure you want to delete the directory?\n\nAny children files will also be deleted.';

$_lang["make_folders_title"] = 'Make end slash URL at the container';
$_lang["make_folders_message"] = 'The slash to append to Resources set as containers when using FURLs.';

$_lang["check_files_onlogin_title"] = 'Check core files on login';
$_lang["check_files_onlogin_message"] = 'By enabling this option, important system files will be checked for modification typical of scripted website attacks. While not a foolproof guarantee, it may alert you to a compromised MODX system file and website.';

$_lang["configcheck_sysfiles_mod"] = 'Important System Files have been modified.';
$_lang["configcheck_sysfiles_mod_msg"] = 'You have enabled the setting to check important system files to detect possible website script attacks. This doesn\'t necessarily mean that your site has been compromised, however, you should review the changed files.(index.php, .htaccess, [+MGR_DIR+]/index.php, [+MGR_DIR+]/includes/config.inc.php)';

$_lang['email_method_title'] = 'Sendmail method';
$_lang['email_method_mail'] = 'mail() PHP function';
$_lang['email_method_smtp'] = 'SMTP Server';
$_lang['smtp_auth_title'] = 'SMTP－AUTH';
$_lang['smtp_autotls_title'] = 'SMTPAutoTLS';
$_lang['smtp_host_title'] = 'SMTP host';
$_lang['smtp_secure_title'] = 'Encrypted SMTP';
$_lang['smtp_username_title'] = 'SMTP user name';
$_lang['smtp_password_title'] = 'SMTP password';
$_lang['smtp_port_title'] = 'SMTP port';

$_lang["setting_resource_tree_node_name"] = 'The node name of a resource tree';
$_lang["setting_resource_tree_node_name_desc"] = 'Specify the Resource field to use when rendering the nodes in the Resource Tree. Defaults to pagetitle, although any Resource field can be used, such as menutitle, alias.';

$_lang["resource_opt_alvisibled"] = 'Käytä nykyistä aliasta aliaspolussa';
$_lang["resource_opt_alvisibled_help"] = 'Sivun alias tulee osaksi osoitteen selkokielistä aliaspolkua';
$_lang['resource_opt_is_published'] = 'Julkaistu';
$_lang["docid_incrmnt_method_title"] = 'Tapa jonka mukaan uuden sivun ID numero määräytyy';
$_lang["docid_incrmnt_method_0"] = 'Tietokantajärjestelmän automaattinen ID numeron kasvatus (auto increment)';
$_lang["docid_incrmnt_method_1"] = 'Pienin vapaana oleva luku';
$_lang["docid_incrmnt_method_2"] = 'Suurin käytössä oleva ID numero + 1';

$_lang["cache_type_title"] = 'Document caching type';
$_lang["cache_type_1"] = 'Cache is based only on document id (standard)';
$_lang["cache_type_2"] = 'Cache is based on document id and $_GET parameters';
$_lang["seostrict_title"] = 'Use SEO Strict URLs';
$_lang["seostrict_message"] = 'Enforces the use of strict URLs to prevent duplicate content if needed';

$_lang["settings_friendlyurls_alert"] = 'It is necessary to rename the ht.access file of a MODX installation directory at .htaccess to use the Friendly URL function.';
$_lang["settings_friendlyurls_alert2"] = 'Since it has installed in a subdirectory, it is necessary to change the contents of .htaccess.';

$_lang["user_street"] = 'Street';
$_lang["user_city"] = 'City';
$_lang["user_other"] = 'Other';

$_lang["mutate_settings.dynamic.php6"] = 'Lähetä sähköpostia kun MODX kohtaa virheen';
$_lang["mutate_settings.dynamic.php7"] = 'älä huomauta';
$_lang["mutate_settings.dynamic.php8"] = 'MODX virheen sattuessa, tieto virheen alkuperä lähetetään sähköpostilla vastaanottajalle [(emailsender)] ([+emailsender+]). Virheen yksityiskohdat voidaan nähdä MODX järjestelmän tapahtumalokista.';

$_lang["error_no_privileges"]         = "Sinulla ei ole tarvittavia käyttöoikeuksia tämän toiminnon suorittamiseksi!";
$_lang["error_no_optimise_tablename"] = "Pyynnöstä puuttui optimoitavaksi valittu taulukko!";
$_lang["error_no_truncate_tablename"] = "Pyynnöstä puuttui tyhjennettäväksi valittu taulukko!";
$_lang["error_double_action"]         = "Toiminto annettu kahteen kertaan (GET & POST)!";
$_lang["error_no_id"]                 = "Pyynnöstä puuttuu ID numero!";
$_lang["error_id_nan"]                = "Pyyntöön sisältyvä ID ei ole numeerinen!";
$_lang["error_no_parent"]             = "Ylemmän tason sivunimeä ei löytynyt!";
$_lang["error_many_results"]          = "Tietokanta palautti liikaa tuloksia!";
$_lang["error_no_results"]            = "Tietokanta palautti liian vähän tai ei ollenkaan tuloksia!";
$_lang["error_no_user_selected"]      = "Yhtään käyttäjää ei valittu tämän viestin vastaanottajaksi!";
$_lang["error_no_group_selected"]     = "Yhtään ryhmää ei valittu tämän viestin vastaanottajaksi!";
$_lang["error_movedocument1"]         = "Sivua ei voi asettaa itsensä alle!";
$_lang["error_movedocument2"]         = "Pyynnöstä puuttui sivun ID numero!";
$_lang["error_movedocument3"]         = "Pyynnöstä puuttui uuden ylätason/pääryhmän valinta!";

$_lang["login_processor_unknown_user"]       = "Virheellinen käyttäjätunnus tai salasana!";
$_lang["login_processor_wrong_password"]     = "Virheellinen käyttäjätunnus tai salasana!";
$_lang["login_processor_many_failed_logins"] = "Kirjautumisesi on estetty liian monen epäonnistuneen kirjautumisyrityksen johdosta!";
$_lang["login_processor_blocked1"]           = "Et voi kirjautua sisään, koska kirjautumisesi on estetty!";
$_lang["login_processor_blocked2"]           = "Et voi kirjautua sisään, koska kirjautumisesi on estetty! Ole hyvä ja yritä myöhemmin uudelleen.";
$_lang["login_processor_blocked3"]           = "You are blocked automatic after a specified date and you cannot log in anymore!";
$_lang["login_processor_bad_code"]           = "Syöttämäsi varmistuskoodi oli virheellinen! Ole hyvä ja yritä uudelleen!";
$_lang["login_processor_remotehost_ip"]      = "Your hostname doesn't point back to your IP!";
$_lang["login_processor_remote_ip"]          = "You are not allowed to login from this location.";
$_lang["login_processor_date"]               = "You are not allowed to login at this time. Please try again later.";
$_lang["login_processor_captcha_config"]     = "Captcha is not configured properly.";

$_lang["dp_dayNames"]   = "['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']";
$_lang["dp_monthNames"] = "['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']";
$_lang["dp_startDay"]   = "1";

$_lang["check_all"] = "Select all";
$_lang["check_none"] = "Select none";
$_lang["check_toggle"] = "Toggle selection";

$_lang["role_no_tv"] = 'No Variables have been assigned to this Role yet.';
$_lang["role_notassigned_tv"] = 'These Variables are available for assigning.';
$_lang["role_tv_msg"] = 'The Variables assigned to this Role are listed below.';
$_lang["tmplvar_roles_access_msg"] = 'Select the Roles that are allowed to access/process this Template Variable';

$_lang["setting_from_file"] = '<strong class="text-danger">Parameter value is defined in core/custom/confic/cms/settings</strong>';

return $_lang;
