<?php
/**
 * EVO Manager language file
 *
 * @author Gafar Akhmedov
 * @version 3.1.x
 * @date 16/02/2025
 *
 * @language Azerbaijani
 * @package modx
 * @subpackage manager
 *
 * Please commit your language changes on Transifex (https://www.transifex.com/projects/p/modx-evolution/) or on GitHub (https://github.com/modxcms/evolution).
 */
//$modx_textdir = 'rtl'; // uncomment this line for RTL languages
$modx_lang_attribute = 'az'; // Menecer HTML/XML Dil Atributu, bax: http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'UTF-8';

$_lang["about_msg"] = 'Evolution CMS, <a href="https://evo-cms.com/" target="_blank">PHP Tətbiq Çərçivəsi və Məzmun İdarəetmə Sistemi</a> olub, <a href="https://www.gnu.org/licenses/gpl-3.0.html">GNU GPL</a> lisenziyası altında yayımlanır.';
$_lang["about_title"] = 'Evolution CMS haqqında';

// günlər
$_lang["monday"] = 'Bazar ertəsi';
$_lang["tuesday"] = 'Çərşənbə axşamı';
$_lang["wednesday"] = 'Çərşənbə';
$_lang["thursday"] = 'Cümə axşamı';
$_lang["friday"] = 'Cümə';
$_lang["saturday"] = 'Şənbə';
$_lang["sunday"] = 'Bazar';

// şablonlar
$_lang["template"] = 'Şablon';
$_lang["templates"] = 'Şablonlar';
$_lang['templatecontroller'] = 'Şablon Nəzarətçisi';
$_lang["template_assignedtv_tab"] = 'Təyin olunmuş Şablon Dəyişənləri';
$_lang["template_code"] = 'Şablon kodu (html)';
$_lang["template_desc"] = 'Təsvir';
$_lang["template_edit_tab"] = 'Şablonu redaktə et';
$_lang["template_inuse"] = 'Bu şablon istifadə olunur. Xahiş edirik, bu şablondan istifadə edən sənədləri başqa bir şablona keçirin. Bu şablondan istifadə edən sənədlər:';
$_lang["template_management_msg"] = 'Redaktə etmək istədiyiniz Şablonu seçin.';
$_lang["template_msg"] = 'Şablonlar yaradın və redaktə edin. Dəyişdirilmiş və ya yeni Şablonlar, saytınızın keşlənmiş səhifələrində yalnız keşi boşaltdıqdan sonra görünəcək, lakin, səhifə önizləmə funksiyasından istifadə edərək Şablonu yoxlaya bilərsiniz.';
$_lang["template_name"] = 'Şablon adı';
$_lang["template_no_tv"] = 'Bu Şablona hələ Şablon Dəyişənləri təyin olunmayıb.';
$_lang["template_notassigned_tv"] = 'Bu Şablon Dəyişənləri təyin oluna bilər.';
$_lang["template_reset_all"] = 'Bütün səhifələri Standart Şablona qaytar';
$_lang["template_reset_specific"] = 'Yalnız \'%s\' səhifələrini yenidən təyin et';
$_lang["template_assigned_blade_file"] = 'Uyğun blade faylı';
$_lang["template_create_blade_file"] = 'Saxlayarkən şablon faylı yarat';
$_lang["template_selectable"] = 'Resurs yaradılarkən və ya redaktə edilərkən Şablon seçilə bilər.';
$_lang["template_title"] = 'Şablon yarat/redaktə et';
$_lang["template_tv_edit"] = 'TV sıralama qaydasını redaktə et';
$_lang["template_tv_edit_message"] = 'Bu şablon üçün Şablon Dəyişənlərini yenidən sıralamaq üçün sürüşdürün.';
$_lang["template_tv_edit_title"] = 'Şablon Dəyişənlərinin Sıralama Qaydası';
$_lang["template_tv_msg"] = 'Bu Şablona təyin olunmuş Şablon Dəyişənləri aşağıda göstərilmişdir.';

// tmplvars
$_lang["tv"] = 'TV';
$_lang["tmplvar"] = 'Şablon Dəyişəni';
$_lang["tmplvars"] = 'Şablon Dəyişənləri';
$_lang["tmplvar_access_msg"] = 'Bu Şablon Dəyişəninin məzmununu və ya dəyərini dəyişməyə icazə verilən Resurs Qruplarını seçin';
$_lang["tmplvar_change_template_msg"] = 'Bu Şablonu dəyişmək səhifənin yenidən yüklənməsinə və Şablon Dəyişənlərinin yenilənməsinə səbəb olacaq, saxlanmamış dəyişikliklər itiriləcək.\n\n Şablonu dəyişmək istədiyinizə əminsinizmi?';
$_lang["tmplvar_inuse"] = 'Aşağıdakı Resurs(lar) hazırda bu Şablon Dəyişənindən istifadə edir. Silmə əməliyyatına davam etmək üçün "Sil" düyməsini, ləğv etmək üçün "İmtina et" düyməsini basın.';
$_lang["tmplvar_tmpl_access"] = 'Şablona Giriş';
$_lang["tmplvar_tmpl_access_msg"] = 'Bu Şablon Dəyişəninə giriş və emal etmək hüququ olan Şablonları seçin';
$_lang["tmplvars_binding_msg"] = 'Bu sahə @ əmrlərindən istifadə edərək məlumat mənbəyi bağlantılarını dəstəkləyir';
$_lang["tmplvars_caption"] = 'Başlıq';
$_lang["tmplvars_default"] = 'Standart Dəyər';
$_lang["tmplvars_description"] = 'Təsvir';
$_lang["tmplvars_elements"] = 'Daxil Etmə Seçim Dəyərləri';
$_lang["tmplvars_inherited"] = 'Dəyər miras alınıb';
$_lang["tmplvars_management_msg"] = 'Resurslarınız üçün əlavə Şablon Dəyişənlərini idarə edin.';
$_lang["tmplvars_msg"] = 'Burada Şablon Dəyişənlərini əlavə edin və ya redaktə edin. Şablon Dəyişənlərinin Snippet və Resurslardan istifadə edilə bilməsi üçün onlar müvafiq Şablonlara təyin olunmalıdır.';
$_lang["tmplvars_name"] = 'Şablon Dəyişəninin Adı';
$_lang["tmplvars_novars"] = 'Şablon Dəyişənləri tapılmadı';
$_lang["tmplvars_rank"] = 'Sıralama';
$_lang["tmplvars_rank_edit_message"] = 'Şablon Dəyişənlərinin sırasını dəyişmək üçün sürüşdürün.';
$_lang["tmplvars_reset_params"] = 'Parametrləri sıfırla';
$_lang["tmplvars_title"] = 'Şablon Dəyişənini yarat/redaktə et';
$_lang["tmplvars_type"] = 'Daxil Etmə Növü';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Widget Xüsusiyyətləri';
$_lang["role_no_tv"] = 'Bu Rol üçün hələ dəyişənlər təyin olunmayıb.';
$_lang["role_notassigned_tv"] = 'Təyin edilə bilən dəyişənlər.';
$_lang["role_tv_msg"] = 'Bu Rola təyin olunmuş dəyişənlər aşağıda göstərilib.';
$_lang["tmplvar_roles_access_msg"] = 'Bu Şablon Dəyişəninə giriş və emal hüququ olan Rolları seçin.';

// snippets
$_lang["snippet"] = 'Snippet';
$_lang["snippets"] = 'Snippetlər';
$_lang["snippet_code"] = 'Snippet kodu (PHP)';
$_lang["snippet_desc"] = 'Təsvir';
$_lang["snippet_execonsave"] = 'Saxladıqdan sonra Snippet-i icra et.';
$_lang["snippet_management_msg"] = 'Redaktə etmək istədiyiniz Snippet-i seçin.';
$_lang["snippet_msg"] = 'Snippet əlavə edin/redaktə edin. Unutmayın, Snippetlər "xam" PHP kodudur və əgər Snippet-in çıxışının müəyyən bir nöqtədə göstərilməsini istəyirsinizsə, Snippet daxilində bir dəyər qaytarmalısınız.';
$_lang["snippet_name"] = 'Snippet adı';
$_lang["snippet_properties"] = 'Standart Xüsusiyyətlər';
$_lang["snippet_title"] = 'Snippet yarat/redaktə et';

// chunks
$_lang["htmlsnippet"] = 'Chunk';
$_lang["htmlsnippets"] = 'Chunklar';
$_lang["htmlsnippet_desc"] = 'Təsvir';
$_lang["htmlsnippet_management_msg"] = 'Redaktə etmək istədiyiniz Chunk-i seçin.';
$_lang["htmlsnippet_msg"] = 'Chunklar əlavə edin və redaktə edin. Unutmayın, Chunklar "xam" HTML kodudur, yəni içərisindəki PHP kodları icra olunmayacaq.';
$_lang["htmlsnippet_name"] = 'Chunk adı';
$_lang["htmlsnippet_title"] = 'Chunk yarat/redaktə et';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Chunk kodu (HTML)';
$_lang["chunk_multiple_id"] = 'Xəta: Bir neçə Chunk eyni unikal ID ilə paylaşılır.';
$_lang["chunk_no_exist"] = 'Chunk mövcud deyil.';

// plugins
$_lang["plugin"] = 'Plaqin';
$_lang["plugins"] = 'Plaqinlər';
$_lang["plugin_code"] = 'Plaqin kodu (PHP)';
$_lang["plugin_config"] = 'Plaqin konfiqurasiyası';
$_lang["plugin_desc"] = 'Təsvir';
$_lang["plugin_disabled"] = 'Plaqin deaktiv edilib';
$_lang["plugin_event_msg"] = 'Bu Plaqinin dinləməli olduğu hadisələri seçin.';
$_lang["plugin_management_msg"] = 'Redaktə etmək istədiyiniz Plaqini seçin.';
$_lang["plugin_msg"] = 'Plaqinlər əlavə edin/redaktə edin. Plaqinlər, müəyyən Sistem Hadisələri işə düşdükdə icra olunan PHP kodlarından istifadə edir.';
$_lang["plugin_name"] = 'Plaqin adı';
$_lang["plugin_priority"] = 'Plaqinlərin Hadisələrə görə İcra Sırasını Redaktə Et';
$_lang["plugin_priority_instructions"] = 'Hər Hadisə başlığı altında Plaqinləri sürüşdürərək sıralayın. İlk icra olunacaq Plugin yuxarıda olmalıdır.';
$_lang["plugin_priority_title"] = 'Plaqin İcra Sırası';
$_lang["purge_plugin"] = 'Köhnəlmiş Plaqinləri sil';
$_lang["purge_plugin_confirm"] = 'Köhnəlmiş plaqinnləri silmək istədiyinizə əminsiniz?';
$_lang["plugin_title"] = 'Plaqin yarat/redaktə et';

// categories
$_lang["category"] = 'Kateqoriya';
$_lang["categories"] = 'Kateqoriyalar';
$_lang["category_heading"] = 'Kateqoriya';
$_lang["category_manager"] = 'Kateqoriya Meneceri';
$_lang["category_management"] = 'Kateqoriya idarəetməsi';
$_lang["category_msg"] = 'Bütün Elementləri kateqoriya üzrə qruplaşdırılmış şəkildə baxın və redaktə edin.';

// file
$_lang["file_delete_file"] = 'Faylı sil';
$_lang["file_delete_folder"] = 'Qovluğu sil';
$_lang["file_deleted"] = 'Uğurlu əməliyyat!';
$_lang["file_download_file"] = 'Faylı yüklə';
$_lang["file_download_unzip"] = 'Faylı aç (unzip)';
$_lang["file_folder_chmod_error"] = 'İcazələri dəyişmək mümkün olmadı, icazələri Evolution CMS xaricində dəyişməlisiniz.';
$_lang["file_folder_created"] = 'Qovluq uğurla yaradıldı!';
$_lang["file_folder_deleted"] = 'Qovluq uğurla silindi!';
$_lang["file_folder_not_created"] = 'Qovluq yaradılmadı';
$_lang["file_folder_not_deleted"] = 'Qovluğu silmək mümkün deyil. Silmədən əvvəl onun boş olduğundan əmin olun.';
$_lang["file_not_deleted"] = 'Xəta baş verdi!';
$_lang["file_not_saved"] = 'Fayl saxlanıla bilmədi, hədəf qovluğun yazıla bilən olduğuna əmin olun!';
$_lang["file_saved"] = 'Fayl uğurla yeniləndi!';
$_lang["file_unzip"] = 'Arxiv uğurla açıldı!';
$_lang["file_unzip_fail"] = 'Arxivin açılması uğursuz oldu!';

// files
$_lang["files"] = 'Fayllar';
$_lang["files_files"] = 'Fayllar';
$_lang["files_access_denied"] = 'Giriş qadağandır!';
$_lang["files_data"] = 'Məlumat';
$_lang["files_dir_listing"] = 'Bu qovluğun siyahısı:';
$_lang["files_directories"] = 'Qovluqlar';
$_lang["files_directory_is_empty"] = 'Bu qovluq boşdur.';
$_lang["files_dirwritable"] = 'Qovluq yazıla biləndirmi?';
$_lang["files_editfile"] = 'Faylı redaktə et';
$_lang["files_file_type"] = 'Fayl növü: ';
$_lang["files_filename"] = 'Fayl adı';
$_lang["files_fileoptions"] = 'Seçimlər';
$_lang["files_filesize"] = 'Fayl ölçüsü';
$_lang["files_filetype_notok"] = 'Bu növ fayl yükləməyə icazə verilmir!';
$_lang["files_management"] = 'Faylları idarə et';
$_lang["files_management_no_permission"] = 'Bu faylları görmək və ya redaktə etmək üçün kifayət qədər icazəniz yoxdur. Administratorla əlaqə saxlayaraq <b>%s</b> qovluğuna giriş icazəsi istəyin.';
$_lang["files_modified"] = 'Dəyişdirilib';
$_lang["files_top_level"] = 'Əsas qovluğa qayıt';
$_lang["files_up_level"] = 'Bir səviyyə yuxarı';
$_lang["files_upload_copyfailed"] = 'Faylın təyinat qovluğuna kopyalanması alınmadı - yükləmə uğursuz oldu!';
$_lang["files_upload_error"] = 'Xəta';
$_lang["files_upload_error0"] = 'Yükləmə zamanı problem yarandı.';
$_lang["files_upload_error1"] = 'Yükləməyə çalışdığınız fayl çox böyükdür.';
$_lang["files_upload_error2"] = 'Yükləməyə çalışdığınız fayl çox böyükdür.';
$_lang["files_upload_error3"] = 'Yükləməyə çalışdığınız fayl yalnız qismən yüklənib.';
$_lang["files_upload_error4"] = 'Yükləmək üçün fayl seçməlisiniz.';
$_lang["files_upload_error5"] = 'Yükləmə zamanı problem yarandı.';
$_lang["files_upload_inhibited_msg"] = '<b>Yükləmə funksiyası məhdudlaşdırılıb</b> - yükləmələrin dəstəkləndiyinə və qovluğun PHP üçün yazıla bilən olduğuna əmin olun.';
$_lang["files_upload_ok"] = 'Fayl uğurla yükləndi!';
$_lang["files_upload_permissions_error"] = 'İcazə problemi ola bilər - yükləmək istədiyiniz qovluq veb-serveriniz tərəfindən yazıla bilən olmalıdır.';
$_lang["files_uploadfile"] = 'Fayl yüklə';
$_lang["files_uploadfile_msg"] = 'Yükləmək üçün fayl seçin:';
$_lang["files_uploading"] = '<b>%s</b> faylı <b>%s/</b> qovluğuna yüklənir';
$_lang["files_viewfile"] = 'Faylı görüntülə';

// modules
$_lang["module"] = 'Modul';
$_lang["modules"] = 'Modullar';
$_lang["module_code"] = 'Modul kodu (PHP)';
$_lang["module_config"] = 'Modul konfiqurasiyası';
$_lang["module_desc"] = 'Təsvir';
$_lang["module_disabled"] = 'Modul deaktiv edilib';
$_lang["module_edit_click_title"] = 'Bu Modulu redaktə etmək üçün buraya klikləyin';
$_lang["module_group_access_msg"] = 'Bu Modulu İdarəetmə Panelində icra edə biləcək İstifadəçi Qruplarını seçin.';
$_lang["module_management"] = 'Modulları idarə et';
$_lang["module_management_msg"] = 'İcra etmək və ya dəyişdirmək istədiyiniz Modulu seçin. Modulu işə salmaq üçün şəbəkədəki ikona klikləyin. Modulu redaktə etmək üçün onun adına klikləyin.';
$_lang["module_msg"] = 'Modullar əlavə edin/redaktə edin. Modul, Elementlərdən (məsələn, Plaqinlər, Snippetlər və s.) ibarət bir toplusudur.';
$_lang["module_name"] = 'Modul adı';
$_lang["module_resource_msg"] = 'Bu Modulun asılı olduğu Elementləri əlavə edin və ya silin. Yeni bir Element əlavə etmək üçün aşağıdakı düymələrdən birinə klikləyin.';
$_lang["module_resource_title"] = 'Modul Asılılıqları';
$_lang["module_title"] = 'Modul yarat/redaktə et';
$_lang["module_viewdepend_msg"] = 'Bu Modulun asılı olduğu təyin olunmuş Elementləri görüntüləyin. Asılılıqları dəyişdirmək üçün "Asılılıqları idarə et" düyməsinə klikləyin.';

// elements
$_lang["element"] = 'Element';
$_lang["elements"] = 'Elementlər';
$_lang["element_categories"] = 'Birləşdirilmiş Görünüş';
$_lang["element_filter_msg"] = 'Siyahını süzgəcdən keçirmək üçün buraya yazın';
$_lang["element_management"] = 'Elementləri idarə et';
$_lang["element_name"] = 'Element adı';
$_lang["element_selector_msg"] = 'Aşağıdakı siyahıdan Element(lər)i seçin və "Daxil et" düyməsinə klikləyin.';
$_lang["element_selector_title"] = 'Element Seçici';

// resource
$_lang["resource"] = 'Resurs';
$_lang["resource_alias"] = 'URL aliası';
$_lang["resource_alias_help"] = 'Resurs üçün URL aliasını təyin edin ki, o, http://example.com/weburl kimi əlçatan olsun. Bu, yalnız saytın konfiqurasiyasında Friendly URL-lər aktiv olduqda işləyir.';
$_lang["resource_content"] = 'Resurs məzmunu';
$_lang["resource_description"] = 'Təsvir';
$_lang["resource_description_help"] = 'Bu resurs üçün isteğe bağlı təsvir daxil edin.';
$_lang["resource_duplicate"] = 'Resursu dublikat et';
$_lang["resource_long_title_help"] = 'Resurs üçün isteğe bağlı uzun başlıq daxil edin. Bu, axtarış motorları üçün avtomatik başlıqlarda istifadə edilə bilər və resursunuzu daha ətraflı təsvir edə bilər.';
$_lang["resource_metatag_help"] = 'Bu resursa təyin etmək istədiyiniz META teqləri və açar sözləri seçin. Bir neçə açar söz və ya meta teq seçmək üçün CTRL düyməsini basıb saxlayın.';
$_lang["resource_opt_contentdispo"] = 'Məzmunun təqdim edilməsi';
$_lang["resource_opt_contentdispo_help"] = 'Bu sahədən istifadə edərək, resursun veb-brauzer tərəfindən necə təqdim ediləcəyini müəyyən edə bilərsiniz. Fayl yükləmələri üçün "Əlavə (Attachment)" seçimini seçin.';
$_lang["resource_opt_emptycache"] = 'Keşi təmizlə';
$_lang["resource_opt_emptycache_help"] = 'Bu seçimi aktiv saxlasanız, Evolution CMS resursu yaddaşa verdikdən sonra keşini təmizləyəcək. Bununla, ziyarətçilər köhnə versiyanı görməyəcək.';
$_lang["resource_opt_folder"] = 'Qovluq';
$_lang["resource_opt_folder_help"] = 'Bu seçimi aktiv edin ki, resurs digər resurslar üçün qovluq kimi davransın. "Qovluq" adi bir qovluq kimidir, lakin eyni zamanda məzmun da ehtiva edə bilər.';
$_lang["resource_opt_menu_index"] = 'Menyu indeksi';
$_lang["resource_opt_menu_index_help"] = 'Menyu indeksi, resursların sıralanmasını idarə edən bir sahədir, xüsusilə menyu Snippet-lərində istifadə olunur. Bundan digər məqsədlər üçün də istifadə edə bilərsiniz.';
$_lang["resource_opt_menu_title"] = 'Menyu başlığı';
$_lang["resource_opt_menu_title_help"] = 'Menyu Snippet-lərində və ya modullarda qısa başlıq göstərmək üçün istifadə olunan isteğe bağlı sahə.';
$_lang["resource_opt_published"] = 'Dərc edilib';
$_lang["resource_opt_published_help"] = 'Bu seçimi aktiv edin ki, resurs saxlanıldıqdan sonra dərhal yayımlansın.';
$_lang["resource_opt_richtext"] = 'Zəngin mətn';
$_lang["resource_opt_richtext_help"] = 'Resursları redaktə etmək üçün zəngin mətn redaktorundan istifadə etmək üçün bunu aktiv saxlayın. Resurslarınız JavaScript və ya formalar ehtiva edirsə, HTML rejimində düzəliş etmək üçün bu seçimi deaktiv edin.';
$_lang["resource_opt_show_menu"] = 'Menyuda göstər';
$_lang["resource_opt_show_menu_help"] = 'Resursu veb menyuda göstərmək üçün bu seçimi aktiv edin. Lakin bəzi menyu generatorları bu seçimi nəzərə almaya bilər.';
$_lang["resource_opt_trackvisit_help"] = 'Bu səhifəyə edilən hər bir ziyarəti qeyd et';
$_lang["resource_overview"] = 'Resurs icmalı';
$_lang["resource_parent"] = 'Ana resurs';
$_lang["resource_parent_help"] = 'Ana resursu təyin etmək üçün ikona klikləyin, sonra Sayt Ağacında bir resurs seçərək yeni ana resurs təyin edin.';
$_lang["resource_permissions_error"] = 'Bu resursu, daxil ola bildiyiniz ən azı bir resurs qrupuna təyin edin.';
$_lang["resource_setting"] = 'Resurs ayarı';
$_lang["resource_summary"] = 'Qısa məzmun (giriş mətni)';
$_lang["resource_summary_help"] = 'Resurs üçün qısa xülasə daxil edin';
$_lang["resource_title"] = 'Başlıq';
$_lang["resource_title_help"] = 'Resursun adını/başlığını daxil edin. Adın içində tərs əyilmiş (\\) işarəsindən istifadə etməyin.';
$_lang["resource_to_be_moved"] = 'Köçürüləcək resurs';
$_lang["resource_type"] = 'Resurs növü';
$_lang["resource_type_message"] = 'Web bağlantıları Evolution CMS-də başqa bir resursa, xarici səhifəyə və ya internetdəki hər hansı bir fayla istinad edə bilər. Web bağlantılar üçün məzmun tipi "text/html" və təqdimat metodu "Inline" olmalıdır.';
$_lang["resource_type_weblink"] = 'Web bağlantı';
$_lang["resource_type_webpage"] = 'Veb səhifə';
$_lang["resource_weblink_help"] = 'Bu web bağlantının istinad edəcəyi ünvanı daxil edin. Alternativ olaraq, Fayl Menecerindən seçə və ya sayt ağacından resurs seçmək üçün link ikonundan istifadə edə bilərsiniz.';
$_lang["resources_in_container"] = 'Bu qovluqdakı resurslar';
$_lang["resources_in_container_no"] = 'Bu qovluqda heç bir resurs yoxdur.';

// rol
$_lang["role"] = 'Rol';
$_lang["role_about"] = 'Haqqında səhifəsinə bax';
$_lang["role_actionok"] = 'Tamamlanmış əməliyyat ekranına bax';
$_lang["role_assets_images"] = 'Şəkilləri idarə et';
$_lang["role_assets_files"] = 'Faylları idarə et';
$_lang["role_bk_manager"] = 'Ehtiyat nüsxə menecerindən istifadə et';
$_lang["role_cache_refresh"] = 'Sayt keşini təmizlə';
$_lang["role_category_manager"] = 'Kateqoriya menecerindən istifadə et';
$_lang["role_change_password"] = 'Şifrəni dəyiş';
$_lang["role_change_resourcetype"] = 'Resurs növünü dəyiş';
$_lang["role_chunk_management"] = 'Chunk idarəetməsi';
$_lang["role_config_management"] = 'Konfiqurasiya idarəetməsi';
$_lang["role_content_management"] = 'Məzmun idarəetməsi';
$_lang["role_create_chunk"] = 'Yeni Chunk yarat';
$_lang["role_create_doc"] = 'Yeni resurs yarat';
$_lang["role_create_plugin"] = 'Yeni Plaqin yarat';
$_lang["role_create_snippet"] = 'Yeni Snippet yarat';
$_lang["role_create_template"] = 'Yeni şablon yarat';
$_lang["role_credits"] = 'Kreditlər səhifəsinə bax';
$_lang["role_delete_chunk"] = 'Chunk sil';
$_lang["role_delete_doc"] = 'Resurs sil';
$_lang["role_delete_eventlog"] = 'Hadisə jurnalını sil';
$_lang["role_delete_module"] = 'Modul sil';
$_lang["role_delete_plugin"] = 'Plaqin sil';
$_lang["role_delete_role"] = 'Rol sil';
$_lang["role_delete_snippet"] = 'Snippet sil';
$_lang["role_delete_template"] = 'Şablon sil';
$_lang["role_delete_user"] = 'İstifadəçi sil';
$_lang["role_delete_web_user"] = 'Veb istifadəçi sil';
$_lang["role_edit_chunk"] = 'Chunk redaktə et';
$_lang["role_edit_doc"] = 'Resurs redaktə et';
$_lang["role_edit_doc_metatags"] = 'Resursun META teqlərini və açar sözlərini redaktə et';
$_lang["role_edit_module"] = 'Modulu redaktə et';
$_lang["role_edit_plugin"] = 'Plaqin redaktə et';
$_lang["role_edit_role"] = 'Rol redaktə et';
$_lang["role_edit_settings"] = 'Sayt ayarlarını dəyiş';
$_lang["role_edit_snippet"] = 'Snippet redaktə et';
$_lang["role_edit_template"] = 'Şablon redaktə et';
$_lang["role_edit_user"] = 'İstifadəçi redaktə et';
$_lang["role_edit_web_user"] = 'Veb istifadəçi redaktə et';
$_lang["role_empty_trash"] = 'Silinmiş resursları qalıcı olaraq sil';
$_lang["role_errors"] = 'Xəta dialoquna baxış';
$_lang["role_eventlog_management"] = 'Hadisə jurnalının idarə edilməsi';
$_lang["role_export_static"] = 'Statik HTML ixracı';
$_lang["role_file_management"] = 'Fayl idarəetməsi';
$_lang["role_file_manager"] = 'Fayl menecerindən istifadə (tam root girişi)';
$_lang["role_frames"] = 'Menecer çərçivələrini tələb et';
$_lang["role_help"] = 'Kömək səhifələrinə baxış';
$_lang["role_home"] = 'Menecerin giriş səhifəsinə keçid';
$_lang["role_import_static"] = 'HTML idxalı';
$_lang["role_logout"] = 'Menecerdən çıxış';
$_lang["role_list_module"] = 'Modulların siyahısı';
$_lang["role_manage_metatags"] = 'Saytın META teqlərini və açar sözlərini idarə et';
$_lang["role_management_msg"] = 'Redaktə etmək istədiyiniz rolu seçin.';
$_lang["role_management_title"] = 'Rollar';
$_lang["role_messages"] = 'Mesajlara baxış və mesaj göndərmə';
$_lang["role_module_management"] = 'Modul idarəetməsi';
$_lang["role_name"] = 'Rolun adı';
$_lang["role_new_module"] = 'Yeni modul yarat';
$_lang["role_new_role"] = 'Yeni rol yarat';
$_lang["role_new_user"] = 'Yeni menecer istifadəçisi yarat';
$_lang["role_new_web_user"] = 'Yeni veb istifadəçi yarat';
$_lang["role_plugin_management"] = 'Plaqin idarəetməsi';
$_lang["role_publish_doc"] = 'Resursları dərc et';
$_lang["role_remove_locks"] = 'Bloklamaları sil';
$_lang["role_role_management"] = 'Rollar';
$_lang["role_run_module"] = 'Modulu işə sal';
$_lang["role_save_chunk"] = 'Chunk-ları yadda saxla';
$_lang["role_save_doc"] = 'Resursları yadda saxla';
$_lang["role_save_module"] = 'Modulu yadda saxla';
$_lang["role_save_password"] = 'Şifrəni yadda saxla';
$_lang["role_save_plugin"] = 'Plaqinləri yadda saxla';
$_lang["role_save_role"] = 'Rolları yadda saxla';
$_lang["role_save_snippet"] = 'Snippet-ləri yadda saxla';
$_lang["role_save_template"] = 'Şablonları yadda saxla';
$_lang["role_save_user"] = 'İstifadəçiləri yadda saxla';
$_lang["role_save_web_user"] = 'Veb istifadəçiləri yadda saxla';
$_lang["role_snippet_management"] = 'Snippet idarəetməsi';
$_lang["role_template_management"] = 'Şablon idarəetməsi';
$_lang["role_title"] = 'Rol yarat/redaktə et';
$_lang["role_udperms"] = 'İcazələrin idarə edilməsi';
$_lang["role_user_management"] = 'Menecer istifadəçilərinin idarə edilməsi';
$_lang["role_view_docdata"] = 'Resurs məlumatlarına baxış';
$_lang["role_view_eventlog"] = 'Hadisə jurnalına baxış';
$_lang["role_view_logs"] = 'Sistem jurnallarına baxış';
$_lang["role_view_unpublished"] = 'Dərc olunmamış resurslara baxış';
$_lang["role_web_access_persmissions"] = 'Veb girişi icazələri';
$_lang["role_web_user_management"] = 'Veb istifadəçilərinin idarə edilməsi';

// user
$_lang["user"] = 'İstifadəçi';
$_lang["users"] = 'İstifadəçilər';
$_lang["user_block"] = 'Bloklanıb';
$_lang["user_blockedafter"] = 'Bu tarixdən sonra bloklanıb';
$_lang["user_blockeduntil"] = 'Bu tarixə qədər bloklanıb';
$_lang["user_changeddata"] = 'Məlumatlarınız dəyişdirildi. Zəhmət olmasa, yenidən daxil olun.';
$_lang["user_country"] = 'Ölkə';
$_lang["user_dob"] = 'Doğum tarixi';
$_lang["user_doesnt_exist"] = 'İstifadəçi mövcud deyil';
$_lang["user_edit_self_msg"] = '<b>Məlumatlarınızı tam yeniləmək üçün yadda saxladıqdan sonra çıxıb yenidən daxil olmalı ola bilərsiniz.</b> Yeni şifrələr e-poçt ünvanınıza göndəriləcək və ya ekranda göstəriləcək.';
$_lang["user_email"] = 'E-poçt ünvanı';
$_lang["user_failedlogincount"] = 'Uğursuz giriş cəhdləri';
$_lang["user_fax"] = 'Faks';
$_lang["user_female"] = 'Qadın';
$_lang["user_full_name"] = 'Tam ad';
$_lang["user_first_name"] = 'Ad';
$_lang["user_last_name"] = 'Soyad';
$_lang["user_middle_name"] = 'Ata adı';
$_lang["user_gender"] = 'Cins';
$_lang["user_is_blocked"] = 'Bu istifadəçi bloklanıb!';
$_lang["user_logincount"] = 'Giriş sayı';
$_lang["user_male"] = 'Kişi';
$_lang["user_management_msg"] = 'Redaktə etmək üçün məzmun menecerini seçin. Məzmun menecerləri, məzmun menecer sisteminə daxil olmağa icazəsi olan istifadəçilərdir.';
$_lang["user_management_title"] = 'Menecer istifadəçiləri';
$_lang["user_mobile"] = 'Mobil nömrə';
$_lang["user_phone"] = 'Telefon nömrəsi';
$_lang["user_photo"] = 'İstifadəçi şəkli';
$_lang["user_photo_message"] = 'Bu istifadəçi üçün şəkil URL-sini daxil edin və ya serverə şəkil yükləmək və ya seçmək üçün "Daxil et" düyməsindən istifadə edin.';
$_lang["user_prevlogin"] = 'Son giriş';
$_lang["user_role"] = 'İstifadəçinin rolu';
$_lang["no_user_role"] = 'İstifadəçi rolu yoxdur';
$_lang["user_state"] = 'Ştat/Bölgə';
$_lang["user_title"] = 'Menecer istifadəçisini yarat/redaktə et';
$_lang["user_upload_message"] = 'Bu istifadəçinin bu kateqoriyaya aid faylları yükləməsinin qarşısını almaq istəyirsinizsə, "Əsas Konfiqurasiya Ayarını İstifadə et" qutusunu işarələməyin və sahəni boş saxlayın.';
$_lang["user_use_config"] = 'Sistem konfiqurasiyasını istifadə et';
$_lang["user_verification"] = 'İstifadəçi təsdiqlənib';
$_lang["user_zip"] = 'Poçt indeksi';
$_lang["username"] = 'İstifadəçi adı';
$_lang["username_unique"] = 'Bu istifadəçi adı artıq istifadə olunur!';
$_lang["user_street"] = 'Küçə';
$_lang["user_city"] = 'Şəhər';
$_lang["user_other"] = 'Digər';

// əlavə et
$_lang["add"] = 'Əlavə et';
$_lang["add_chunk"] = 'Chunk əlavə et';
$_lang["add_doc"] = 'Resurs əlavə et';
$_lang["add_folder"] = 'Yeni qovluq';
$_lang["add_plugin"] = 'Plaqin əlavə et';
$_lang["add_resource"] = 'Yeni resurs';
$_lang["add_snippet"] = 'Snippet əlavə et';
$_lang["add_tag"] = 'Etiket əlavə et';
$_lang["add_template"] = 'Şablon əlavə et';
$_lang["add_tv"] = 'TV əlavə et';
$_lang["add_weblink"] = 'Yeni veb-keçid';

// yeni
$_lang["new_category"] = 'Yeni kateqoriya';
$_lang["new_file_permissions_message"] = 'Fayl menecerində yeni fayl yükləyərkən, sistem fayl icazələrini burada daxil edilən parametrlərə uyğun dəyişməyə çalışacaq. Bu, bəzi serverlərdə (məsələn, IIS) işləməyə bilər və icazələri əl ilə dəyişməlisiniz.';
$_lang["new_file_permissions_title"] = 'Yeni fayl icazələri';
$_lang["new_folder_permissions_message"] = 'Fayl menecerində yeni qovluq yaradarkən, sistem qovluq icazələrini burada daxil edilən parametrlərə uyğun dəyişməyə çalışacaq. Bu, bəzi serverlərdə (məsələn, IIS) işləməyə bilər və icazələri əl ilə dəyişməlisiniz.';
$_lang["new_folder_permissions_title"] = 'Yeni qovluq icazələri';
$_lang["new_permission"] = 'Yeni icazə';
$_lang["new_htmlsnippet"] = 'Yeni Chunk';
$_lang["new_keyword"] = 'Yeni açar söz əlavə et:';
$_lang["new_module"] = 'Yeni modul';
$_lang["new_parent"] = 'Yeni ana resurs';
$_lang["new_plugin"] = 'Yeni plaqin';
$_lang["new_role"] = 'Yeni rol';
$_lang["new_snippet"] = 'Yeni Snippet';
$_lang["new_template"] = 'Yeni şablon';
$_lang["new_tmplvars"] = 'Yeni şablon dəyişəni';
$_lang["new_user"] = 'Yeni menecer istifadəçisi';
$_lang["new_web_user"] = 'Yeni istifadəçi';
$_lang["new_resource"] = 'Yeni resurs';

// idarə et
$_lang["manage_categories"] = 'Kateqoriyaları idarə et';
$_lang["manage_depends"] = 'Asılılıqları idarə et';
$_lang["manage_files"] = 'Faylları idarə et';
$_lang["manage_htmlsnippets"] = 'Chunk-ları idarə et';
$_lang["manage_metatags"] = 'META teqləri və açar sözləri idarə et';
$_lang["manage_modules"] = 'Modulları idarə et';
$_lang["manage_plugins"] = 'Plaqinləri idarə et';
$_lang["manage_snippets"] = 'Snippetləri idarə et';
$_lang["manage_templates"] = 'Şablonları idarə et';
$_lang["manage_documents"] = 'Sənədləri idarə et';
$_lang["manage_permission"] = 'İcazələri idarə et';

// köçür
$_lang["move"] = 'Köçür';
$_lang["move_resource"] = 'Resursu köçür';
$_lang["move_resource_message"] = 'Resursu və onun bütün alt resurslarını yeni bir ana resursa köçürmək üçün sayt ağacından yeni ana resurs seçin. Seçdiyiniz resurs konteyner deyilsə, o avtomatik konteynerə çevriləcək. Zəhmət olmasa, yeni ana resursu seçin.';
$_lang["move_resource_new_parent"] = 'Zəhmət olmasa, sayt ağacında yeni ana resursu seçin.';
$_lang["move_resource_title"] = 'Resursu köçür';

$_lang["access_permissions"] = 'Giriş icazələri';
$_lang["access_permission_denied"] = 'Bu resursa giriş icazəniz yoxdur.';
$_lang["access_permission_parent_denied"] = 'Burada resurs yaratmaq və ya köçürmək icazəniz yoxdur! Zəhmət olmasa, başqa bir yer seçin.';
$_lang["access_permissions_add_resource_group"] = 'Yeni resurs qrupu yarat';
$_lang["access_permissions_add_user_group"] = 'Yeni istifadəçi qrupu yarat';
$_lang["access_permissions_docs_message"] = 'Bu resursun aid olduğu resurs qruplarını seçin';
$_lang["access_permissions_group_link"] = 'Yeni qrup bağlantısı yarat';
$_lang["access_permissions_introtext"] = 'İstifadəçi və resurs qruplarını idarə edin. İstifadəçini bir qrupa əlavə etmək üçün onu redaktə edin və daxil olmalı olduğu qrupları seçin. Bir resursu qrupa əlavə etmək üçün isə həmin resursu redaktə edin və aid olduğu qrupları seçin.';
$_lang["access_permissions_link_to_group"] = 'Resurs qrupuna qoşul';
$_lang["access_permissions_context"] = 'kontekstdə';
$_lang["access_permissions_link_user_group"] = 'İstifadəçi qrupunu bağla';
$_lang["access_permissions_links"] = 'İstifadəçi/Resurs qrup bağlantıları';
$_lang["access_permissions_links_tab"] = 'İstifadəçi qruplarına hansı resurs qruplarına giriş verildiyini müəyyən edin. Bir resurs qrupunu bir istifadəçi qrupuna bağlamaq üçün müvafiq qrupları seçin və "Təsdiqlə" düyməsinə klikləyin. Bağlantını silmək üçün isə "Sil" düyməsini basın. Bu dərhal bağlantını siləcək.';
$_lang["access_permissions_no_resources_in_group"] = 'Heç biri.';
$_lang["access_permissions_no_users_in_group"] = 'Heç biri.';
$_lang["access_permissions_off"] = '<span class="warning">Giriş icazələri aktiv deyil.</span> Bu, o deməkdir ki, burada edilən dəyişikliklər icazələr aktivləşdirilməyənə qədər heç bir təsir göstərməyəcək.';
$_lang["access_permissions_resource_groups"] = 'Resurs qrupları';
$_lang["access_permissions_resources_in_group"] = '<b>Qrupdakı resurslar:</b> ';
$_lang["access_permissions_resources_tab"] = 'Mövcud resurs qruplarını görün. Yeni qruplar yaradın, adlarını dəyişin, qrupları silin və resursların hansı qruplara aid olduğunu görün (resursun ID-nin üzərinə gəldikdə adı görünəcək). Resursu qrupa əlavə etmək və ya qrupdan çıxarmaq üçün onu birbaşa redaktə edin.';
$_lang["access_permissions_user_toggle"] = 'Giriş icazələrini dəyiş';
$_lang["access_permissions_user_groups"] = 'İstifadəçi qrupları';
$_lang["access_permissions_user_message"] = 'Bu istifadəçinin aid olduğu istifadəçi qruplarını seçin:';
$_lang["access_permissions_users_in_group"] = 'Qrupdakı istifadəçilər:';
$_lang["access_permissions_users_tab"] = 'Mövcud istifadəçi qruplarını görün. Yeni qruplar yaradın, adlarını dəyişin, qrupları silin və hansı istifadəçilərin hansı qruplara aid olduğunu görün. İstifadəçini qrupa əlavə etmək və ya çıxarmaq üçün onu birbaşa redaktə edin. Administratorlar (ID-si 1 olan rol təyin edilmiş istifadəçilər) bütün resurslara avtomatik giriş əldə edirlər və onlara xüsusi qruplar təyin etməyə ehtiyac yoxdur.';

$_lang["users_list"] = 'İstifadəçilərin siyahısı';
$_lang["documents_list"] = 'Resursların siyahısı';

$_lang["account_email"] = 'Hesab e-poçtu';
$_lang["actioncomplete"] = '<b>Əməliyyat uğurla tamamlandı!</b><br /> - Zəhmət olmasa, Evolution CMS-in təmizlənməsini gözləyin.';
$_lang["activity_message"] = 'Bu siyahı, son yaratdığınız və ya redaktə etdiyiniz resursları göstərir:';
$_lang["activity_title"] = 'Son redaktə olunan/yaradılan resurslar';

$_lang["administrator_role_message"] = 'Bu rol redaktə edilə və ya silinə bilməz.';
$_lang["administrators"] = 'Administratorlar';
$_lang["after_saving"] = 'Yadda saxladıqdan sonra';
$_lang["alert_delete_self"] = 'Özünüzü silə bilməzsiniz!';
$_lang["alias"] = 'URL aliası';
$_lang["all_doc_groups"] = 'Bütün Resurs Qrupları (İctimai)';
$_lang["all_events"] = 'Bütün Hadisələr';
$_lang["all_usr_groups"] = 'Bütün İstifadəçi Qrupları (İctimai)';
$_lang["allow_mgr_access"] = 'İdarəçi İnterfeysinə Giriş';
$_lang["allow_mgr_access_message"] = 'İdarəçi interfeysinə giriş icazəsini aktivləşdirmək və ya söndürmək üçün bu seçimi seçin. <b>QEYD: Əgər bu seçim "xeyr" olaraq təyin edilərsə, istifadəçi İdarəçi Giriş Başlanğıc səhifəsinə və ya Saytın Başlanğıc səhifəsinə yönləndiriləcək.</b>';
$_lang["already_deleted"] = 'artıq silinib.';
$_lang["attachment"] = 'Əlavə';
$_lang["author_infos"] = 'Müəllif məlumatları';
$_lang["automatic_alias_message"] = 'Resursun səhifə başlığı əsasında avtomatik olaraq URL aliası yaratmaq üçün "bəli" seçin.';
$_lang["automatic_alias_title"] = 'Avtomatik URL aliası yarat';
$_lang["backup"] = 'Ehtiyat nüsxə';
$_lang["bk_manager"] = 'Ehtiyat nüsxə';
$_lang["block_message"] = 'Bu istifadəçi məlumatları saxlandıqdan sonra bloklanacaq!';
$_lang["blocked_minutes_message"] = 'İstifadəçi icazə verilən maksimum uğursuz giriş cəhdlərinin sayına çatdıqda neçə dəqiqə bloklanacağını daxil edin. Bu dəyəri yalnız rəqəmlərlə yazın (vergül, boşluq və s. olmadan).';
$_lang["blocked_minutes_title"] = 'Bloklanma müddəti (dəqiqə)';
$_lang["cache_files_deleted"] = 'Aşağıdakı fayllar silindi:';
$_lang["cancel"] = 'Ləğv et';
$_lang["captcha_code"] = 'Təhlükəsizlik kodu';
$_lang["captcha_message"] = 'İstifadəçilərin maşınlar (və avtomatik hacking skriptləri) tərəfindən oxuna bilməyən bir kod daxil etməsini tələb edərək təhlükəsizliyi gücləndirmək üçün bunu aktiv edin.';
$_lang["captcha_title"] = 'CAPTCHA kodlarından istifadə et';
$_lang["captcha_words_default"] = 'EVO,Access,Better,BitCode,Chunk,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Oscope,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Tattoo,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote';
$_lang["captcha_words_message"] = 'Əgər CAPTCHA aktivdirsə, istifadə olunacaq CAPTCHA sözlərinin siyahısını daxil edin. Sözləri vergüllə ayırın. Bu sahə maksimum 255 simvol ola bilər.';
$_lang["captcha_words_title"] = 'CAPTCHA Sözləri';

$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';

$_lang["change_name"] = 'İstifadəçi adını dəyiş';
$_lang["change_password"] = 'Şifrəni dəyiş';
$_lang["change_password_confirm"] = 'Şifrəni təsdiqlə';
$_lang["change_password_message"] = 'Zəhmət olmasa, yeni şifrənizi daxil edin və təsdiqləmək üçün bir daha yazın. Şifrəniz ən azı 6 simvol uzunluğunda olmalıdır.';
$_lang["change_password_new"] = 'Yeni şifrə';
$_lang["charset_message"] = '[(modx_charset)] sistem dəyişəni üçün standart simvol kodlaşdırmasını seçin. Bu, İdarəçi interfeysinə təsir etməyəcək.';
$_lang["charset_title"] = 'Simvol kodlaşdırması';

$_lang["cleaningup"] = 'Təmizlənir';
$_lang["clean_uploaded_filename"] = 'Yüklənən fayllar üçün transliterasiyadan istifadə et';
$_lang["clean_uploaded_filename_message"] = 'Yüklənən faylların adlarını xüsusi simvollardan təmizləmək üçün standart və ya transalias ayarlarını istifadə edin, nöqtəli simvollar (nöqtələr) qorunacaq.';
$_lang["clear_log"] = 'Jurnalı təmizlə';
$_lang["click_to_context"] = 'Kontekst menyusuna daxil olmaq üçün klikləyin';
$_lang["click_to_edit_title"] = 'Bu qeydi redaktə etmək üçün bura klikləyin';
$_lang["click_to_view_details"] = 'Ətraflı məlumat üçün bura klikləyin';
$_lang["close"] = 'Bağla';
$_lang["code"] = 'Kod';
$_lang["collapse_tree"] = 'Sayt ağacını yığ';
$_lang["comment"] = 'Şərh';

$_lang["configcheck_admin"] = 'Zəhmət olmasa, sistem administratoru ilə əlaqə saxlayın və onu bu mesaj haqqında məlumatlandırın!';
$_lang["configcheck_cache"] = 'keş qovluğu yazıla bilən deyil';
$_lang["configcheck_cache_msg"] = 'Evolution CMS keş qovluğuna yaza bilmir. Evolution CMS işləməyə davam edəcək, lakin keşləmə aktiv olmayacaq. Bunu həll etmək üçün "cache" qovluğunu yazıla bilən edin.';
$_lang["configcheck_configinc"] = 'Konfiqurasiya faylı hələ də yazıla biləndir';
$_lang["configcheck_configinc_msg"] = 'Zərərli şəxslər saytınıza və ona bağlı olan hər şeyə ciddi ziyan vura bilər. <strong>Ciddi şəkildə.</strong> Konfiqurasiya faylını (/ [+MGR_DIR+]/includes/config.inc.php) yalnız oxunabilən edin!';
$_lang["configcheck_default_msg"] = 'Təyin olunmamış xəbərdarlıq aşkarlandı. Bu, qəribədir.';
$_lang["configcheck_errorpage_unavailable"] = 'Saytınızın Xəta səhifəsi mövcud deyil.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Bu o deməkdir ki, Xəta səhifəniz adi istifadəçilər üçün əlçatan deyil və ya mövcud deyil. Bu, sonsuz dövriyyə probleminə və sayt jurnalında çoxlu xətalara səbəb ola bilər. Səhifəyə heç bir Vebistifadəçi Qrupu təyin edilmədiyinə əmin olun.';
$_lang["configcheck_errorpage_unpublished"] = 'Saytınızın Xəta səhifəsi dərc olunmayıb və ya mövcud deyil.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Bu o deməkdir ki, Xəta səhifəniz ümumi istifadəçilər üçün əlçatan deyil. Səhifəni dərc edin və ya Alətlər &gt; Konfiqurasiya menyusunda mövcud bir resursa təyin olunduğuna əmin olun.';
$_lang["configcheck_filemanager_path"] = 'Hazırda təyin olunmuş <a href="index.php?a=17&tab=4">Fayl Meneceri yolu</a> səhv görünür.';
$_lang["configcheck_filemanager_path_msg"] = 'Bu, məsələn, quraşdırmanızı başqa bir qovluğa və ya serverə köçürdükdə baş verə bilər. Evolution CMS konfiqurasiyanızı yoxlayın və yeniləyin.';
$_lang["configcheck_hide_warning"] = '<a href="javascript:hideConfigCheckWarning(\'%s\');"><em>Bu xəbərdarlığı bir daha göstərmə.</em></a>';
$_lang["configcheck_images"] = 'Şəkillər qovluğu yazıla bilən deyil';
$_lang["configcheck_images_msg"] = 'Şəkillər qovluğu yazıla bilən deyil və ya mövcud deyil. Bu o deməkdir ki, redaktorda Şəkil Meneceri funksiyaları işləməyəcək!';
$_lang["configcheck_installer"] = 'Quraşdırıcı hələ də mövcuddur';
$_lang["configcheck_installer_msg"] = '/install qovluğu Evolution CMS-in quraşdırıcısını ehtiva edir. Əgər zərərli bir şəxs bu qovluğu tapıb quraşdırıcını işə salsa, təsəvvür edin nə baş verə bilər! Onlar çox irəliləyə bilməzlər, çünki verilənlər bazası üçün istifadəçi məlumatlarını daxil etməlidirlər, lakin yenə də bu qovluğu serverinizdən silmək ən yaxşı seçimdir.';
$_lang["configcheck_lang_difference"] = 'Dil faylında girişlərin sayı uyğunsuzdur';
$_lang["configcheck_lang_difference_msg"] = 'Hazırda seçilmiş dildə girişlərin sayı standart dildən fərqlidir. Bu, mütləq problem deyil, lakin dil faylının yenilənməli olduğu mənasına gələ bilər.';
$_lang["configcheck_notok"] = 'Bir və ya daha çox konfiqurasiya detalı düzgün deyil:';
$_lang["configcheck_ok"] = 'Yoxlama uğurla keçdi - xəbərdarlıq yoxdur.';
$_lang["configcheck_php_gdzip"] = 'GD və ya Zip PHP genişləndirmələri tapılmadı';
$_lang["configcheck_php_gdzip_msg"] = 'Evolution CMS-in PHP üçün GD və Zip genişləndirmələrinin aktiv olması tələb olunur. Evolution CMS bu genişləndirmələr olmadan işləsə də, Fayl Meneceri, Şəkil Redaktoru və giriş üçün Captcha funksiyalarının tam imkanlarından yararlana bilməyəcəksiniz.';
$_lang["configcheck_rb_base_dir"] = 'Hazırda təyin olunmuş <a href="index.php?a=17&tab=5">Fayl əsas yolu</a> səhv görünür.';
$_lang["configcheck_rb_base_dir_msg"] = 'Bu, məsələn, quraşdırmanızı başqa bir qovluğa və ya serverə köçürdükdə baş verə bilər. Evolution CMS konfiqurasiyanızı yoxlayın və yeniləyin.';
$_lang["configcheck_register_globals"] = 'register_globals sizin php.ini konfiqurasiya faylınızda AÇIQ olaraq təyin edilib';
$_lang["configcheck_register_globals_msg"] = 'Bu ayar saytınızı Çarpaz Sayt Skriptləmə (XSS) hücumlarına daha həssas edir. Bunun necə söndürüləcəyi barədə hosting təminatçınızla danışmalısınız.';
$_lang["configcheck_title"] = 'Konfiqurasiya yoxlaması';
$_lang["configcheck_templateswitcher_present"] = 'TemplateSwitcher plaqini aşkarlandı';
$_lang["configcheck_templateswitcher_present_delete"] = '<a href="javascript:deleteTemplateSwitcher();">TemplateSwitcher-i sil</a>';
$_lang["configcheck_templateswitcher_present_disable"] = '<a href="javascript:disableTemplateSwitcher();">TemplateSwitcher-i deaktiv et</a>';
$_lang["configcheck_templateswitcher_present_msg"] = 'TemplateSwitcher plagininin keş və performans problemlərinə səbəb olduğu müəyyən edilmişdir və yalnız lazım olduqda istifadə edilməlidir.';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Saytınızın İcazəsiz səhifəsi dərc olunmayıb və ya mövcud deyil.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Bu o deməkdir ki, İcazəsiz səhifəniz adi istifadəçilər üçün əlçatan deyil və ya mövcud deyil. Bu, sonsuz dövriyyə probleminə və sayt jurnalında çoxlu xətalara səbəb ola bilər. Səhifəyə heç bir Vebistifadəçi Qrupu təyin edilmədiyinə əmin olun.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'Sayt konfiqurasiya ayarlarında təyin olunmuş İcazəsiz səhifə dərc olunmayıb.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Bu o deməkdir ki, İcazəsiz səhifəniz ümumi istifadəçilər üçün əlçatan deyil. Səhifəni dərc edin və ya Alətlər &gt; Konfiqurasiya menyusunda mövcud bir resursa təyin olunduğuna əmin olun.';
$_lang["configcheck_validate_referer"] = 'Təhlükəsizlik xəbərdarlığı: HTTP Başlıq Doğrulaması';
$_lang["configcheck_validate_referer_msg"] = 'Konfiqurasiya ayarı <strong>HTTP_REFERER başlıqlarını yoxlayın?</strong> Söndürülüb. Onu aktiv etməyi tövsiyə edirik. <a href="index.php?a=17">Konfiqurasiya seçimlərinə keçin</a>';
$_lang["configcheck_warning"] = 'Konfiqurasiya xəbərdarlığı:';
$_lang["configcheck_what"] = 'Bu nə deməkdir?';

$_lang["safe_mode_warning"] = 'Təhlükəsiz rejim aktivdir. İdarəetmə funksionallığı məhdudlaşdırılıb.';

$_lang["confirm_block"] = 'Bu istifadəçini bloklamaq istədiyinizə əminsiniz?';
$_lang["confirm_delete_category"] = 'Bu kateqoriyanı silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_eventlog"] = 'Bu hadisə jurnalını silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_file"] = 'Bu faylı silmək istədiyinizə əminsiniz?\n\nBu, saytınızın düzgün işləməməsinə səbəb ola bilər! Yalnız bu faylı silməyin saytınıza zərər verməyəcəyindən tam əminsinizsə, davam edin.';
$_lang["confirm_delete_group"] = 'Bu qrupu silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_htmlsnippet"] = 'Bu Çanki silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_keywords"] = 'Bu açar sözləri silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_module"] = 'Bu Modulu silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_plugin"] = 'Bu Plaqini silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_record"] = 'Seçilmiş qeydləri silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_resource"] = 'Bu Resursu silmək istədiyinizə əminsiniz?\nBütün alt resurslar da silinəcək.';
$_lang["confirm_delete_role"] = 'Bu rolu silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_snippet"] = 'Bu Snippeti silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_tags"] = 'Seçilmiş META teqlərini silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_template"] = 'Bu Şablonu silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_tmplvars"] = 'Bu Şablon Dəyişənini və onun bütün saxlanılan dəyərlərini silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_user"] = 'Bu İstifadəçini silmək istədiyinizə əminsiniz?';

$_lang["delete_yourself"] = 'Özünüzü silə bilməzsiniz';
$_lang["delete_last_admin"] = 'Sonuncu administratoru silə bilməzsiniz';

$_lang["confirm_delete_permission"] = 'Bu icazəni silmək istədiyinizə əminsiniz?';
$_lang["confirm_duplicate_record"] = 'Bu qeydi təkrarlamaq istədiyinizə əminsiniz?';
$_lang["confirm_empty_trash"] = 'Bu, BÜTÜN silinmiş Resursları qalıcı olaraq siləcəkdir?\n\nDavam edilsin?';
$_lang["confirm_load_depends"] = 'Dəyişikliklərinizi saxlamadan Asılılıqları İdarəetmə ekranını yükləmək istədiyinizə əminsiniz?';
$_lang["confirm_name_change"] = 'İstifadəçi adını dəyişdirmək Məzmun İdarəetmə Sisteminə qoşulmuş digər tətbiqlərə təsir göstərə bilər.\n\nİstifadəçi adını dəyişdirmək istədiyinizə əminsiniz?';
$_lang["confirm_publish"] = '\n\nBu Resursu indi dərc etmək bütün təyin olunmuş dərc/nəşrdən çıxarma tarixlərini siləcək. Əgər müəyyən tarixlər təyin etmək və ya saxlamaq istəyirsinizsə, bunun əvəzinə Resursu \'redaktə\' etməyi seçin.\n\nDavam edilsin?';
$_lang["confirm_remove_locks"] = 'İstifadəçilər bəzən Resursları, Şablonları, Snippetləri və ya analizatorları redaktə edərkən brauzeri bağlayırlar, bu da həmin obyektin kilidlənmiş vəziyyətdə qalmasına səbəb ola bilər. \'ОК\' düyməsini basaraq, hazırda mövcud olan BÜTÜN kilidləri silə bilərsiniz.\n\nDavam edilsin?';
$_lang["confirm_reset_sort_order"] = 'Bütün siyahıya alınmış elementlərin "sıralama qaydasını/indeksini" 0-a sıfırlamaq istədiyinizə əminsiniz?';
$_lang["confirm_resource_duplicate"] = 'Bu Resursu təkrarlamaq istədiyinizə əminsiniz? Onun tərkibində olan bütün obyektlər də təkrarlanacaq.';
$_lang["confirm_setting_language_change"] = 'Defolt dəyəri dəyişdirmisiniz və dəyişikliklər itiriləcək. Davam edilsin?';
$_lang["confirm_unblock"] = 'Bu istifadəçini blokdan çıxarmaq istədiyinizə əminsiniz?';
$_lang["confirm_undelete"] = '\n\nBu Resurs ilə eyni vaxtda silinən alt resurslar da bərpa olunacaq, lakin daha əvvəl silinmiş alt resurslar yenə də silinmiş qalacaq.';
$_lang["confirm_unpublish"] = '\n\nBu Resursu indi dərcdən çıxarmaq bütün təyin olunmuş dərc/nəşrdən çıxarma tarixlərini siləcək. Əgər müəyyən tarixlər təyin etmək və ya saxlamaq istəyirsinizsə, bunun əvəzinə Resursu \'redaktə\' etməyi seçin.\n\nDavam edilsin?';
$_lang["confirm_unzip_file"] = 'Bu faylı açmaq istədiyinizə əminsiniz?\n\nMövcud fayllar yenidən yazılacaq.';

$_lang["could_not_find_user"] = 'İstifadəçi tapılmadı';

$_lang["create_folder_here"] = 'Burada Qovluq yarat';
$_lang["create_resource_here"] = 'Burada Resurs yarat';
$_lang["create_resource_title"] = 'Resurs yarat';
$_lang["create_weblink_here"] = 'Burada Veb-link yarat';
$_lang["createdon"] = 'Yaradılma tarixi';
$_lang["create_new"] = 'Yeni yarat';

$_lang["credits"] = 'Təşəkkürlər';
$_lang["credits_shouts_msg"] = '<p>Evolution CMS <a href="https://evo-cms.com/" target="_blank">evo-cms.com</a> tərəfindən idarə edilir və saxlanılır.</p>';
$_lang["custom_contenttype_message"] = 'Resurslar üçün xüsusi məzmun tipləri əlavə edin. Yeni giriş əlavə etmək üçün məzmun növünü mətn qutusuna daxil edin və sonra "Əlavə et" düyməsini basın.';
$_lang["custom_contenttype_title"] = 'Xüsusi məzmun tipləri';

$_lang["database_charset"] = 'Verilənlər bazası Şrift Dəsti';
$_lang["database_collation"] = 'Verilənlər bazası Sıralama Şrift Dəsti';
$_lang["database_name"] = 'Verilənlər bazasının adı';
$_lang["database_overhead"] = '<b style="color:#990033;">Qeyd:</b> Overhead MySQL tərəfindən ayrılmış, lakin istifadə olunmayan boş sahədir. Bu sahəni azad etmək üçün cədvəlin overhead rəqəminə klikləyin.';
$_lang["database_server"] = 'Verilənlər bazası serveri';
$_lang["database_table_clickbackup"] = 'Seçilmiş cədvəlləri yedəklə və yüklə';
$_lang["database_table_clickhere"] = 'Buraya klikləyin';
$_lang["database_table_datasize"] = 'Məlumat həcmi';
$_lang["database_table_droptablestatements"] = 'DROP TABLE ifadələrini yarat.';
$_lang["database_table_effectivesize"] = 'Effektiv ölçü';
$_lang["database_table_indexsize"] = 'İndeks ölçüsü';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Qeydlər';
$_lang["database_table_tablename"] = 'Cədvəl adı';
$_lang["database_table_totals"] = 'Cəmi';
$_lang["database_table_totalsize"] = 'Ümumi ölçü';
$_lang["database_tables"] = 'Verilənlər bazası cədvəlləri';
$_lang["database_version"] = 'Verilənlər bazası versiyası';

$_lang["date"] = 'Tarix';
$_lang["datechanged"] = 'Tarix dəyişdirildi';
$_lang["datepicker_offset"] = 'Tarix seçici kompensasiyası';
$_lang["datepicker_offset_message"] = 'Tarix seçicidə keçmişdə göstəriləcək illərin sayı.';
$_lang["datetime_format"] = 'Tarix formatı';
$_lang["datetime_format_message"] = 'İdarəetmə panelində tarixlər üçün format.';

$_lang["default"] = 'Standart:';
$_lang["defaultcache_message"] = 'Bütün yeni Resursların standart olaraq keşlənə bilən olmasını istəyirsinizsə, "Bəli" seçin.';
$_lang["defaultcache_title"] = 'Keşlənə bilən standart';
$_lang["defaultmenuindex_message"] = 'Bütün yeni Resurslar üçün avtomatik menyu indeks artımını aktiv etmək üçün "Bəli" seçin.';
$_lang["defaultmenuindex_title"] = 'Standart menyu indekslənməsi';
$_lang["defaultpublish_message"] = 'Bütün yeni Resursların standart olaraq nəşr olunmasını istəyirsinizsə, "Bəli" seçin.';
$_lang["defaultpublish_title"] = 'Standart nəşr olunmuş';
$_lang["defaultsearch_message"] = 'Bütün yeni Resursların standart olaraq axtarışa açıq olmasını istəyirsinizsə, "Bəli" seçin.';
$_lang["defaultsearch_title"] = 'Standart axtarıla bilən';
$_lang["defaulttemplate_message"] = 'Yeni Resurslar üçün sistemin standart Şablonu olaraq istifadə etmək istədiyiniz Şablonu seçin. Siz Resurs redaktorunda fərqli bir Şablon seçə bilərsiniz, bu seçim yalnız ilkin olaraq bir Şablonu seçir.';
$_lang["defaulttemplate_title"] = 'Sistem Standart Şablonu';
$_lang["defaulttemplate_logic_title"] = 'Avtomatik Şablon Təyini';
$_lang["defaulttemplate_logic_general_message"] = 'Yeni Resurslar üçün aşağıdakı şablonlar təyin ediləcək, əgər tapılmazsa, daha yüksək səviyyəyə keçəcək:';
$_lang["defaulttemplate_logic_system_message"] = '<strong>Sistem</strong>: Sistem Standart Şablonu.';
$_lang["defaulttemplate_logic_parent_message"] = '<strong>Valideyn</strong>: Valideyn konteynerin istifadə etdiyi eyni Şablon.';
$_lang["defaulttemplate_logic_sibling_message"] = '<strong>Qardaş</strong>: Eyni konteynerdə olan digər Resursların istifadə etdiyi eyni Şablon.';

$_lang["delete"] = 'Sil';
$_lang["delete_resource"] = 'Resursu sil';
$_lang["delete_tags"] = 'Teqləri sil';
$_lang["deleting_file"] = 'Fayl silinir `%s`: ';
$_lang["description"] = 'Təsvir';
$_lang["deselect_keywords"] = 'Açar sözləri sil';
$_lang["deselect_metatags"] = 'META teqlərini sil';
$_lang["disabled"] = 'Deaktiv';
$_lang["doc_data_title"] = 'Resurs məlumatlarını göstər';
$_lang["documentation"] = 'Sənədləşmə';

$_lang["duplicate"] = 'Dublikat yarat';
$_lang["duplicate_alias_found"] = 'Resurs \'%s\' artıq URL aliası \'%s\' istifadə edir. Xahiş olunur unikal URL aliası daxil edin.';
$_lang["duplicate_template_alias_found"] = 'Şablon \'%s\' artıq URL aliası \'%s\' istifadə edir. Xahiş olunur unikal alias daxil edin.';
$_lang["duplicate_alias_message"] = 'Eyni URL aliaslarının saxlanılmasına icazə vermək üçün "bəli" seçin. <b>Qeyd: Bu seçim "Dost URL" seçimində "bəli" seçilibsə, problemlərin qarşısını almağa kömək edəcək.</b>';
$_lang["duplicate_alias_title"] = 'Dublikat URL aliaslarına icazə ver';
$_lang["duplicate_name_found_general"] = '\'%s\' adlı %s artıq mövcuddur. Xahiş olunur unikal ad daxil edin.';
$_lang["duplicate_name_found_module"] = '\'%s\' adlı Modul artıq mövcuddur. Xahiş olunur unikal ad daxil edin.';
$_lang["duplicated_el_suffix"] = 'Dublikat';

$_lang["edit"] = 'Redaktə et';
$_lang["edit_resource"] = 'Resursu redaktə et';
$_lang["edit_resource_title"] = 'Resursu redaktə et';
$_lang["edit_settings"] = 'Konfiqurasiya';
$_lang["editedon"] = 'Dəyişdirilmə tarixi';
$_lang["editing_file"] = 'Fayl redaktə edilir: ';
$_lang["editor_css_path_message"] = 'Redaktorda istifadə etmək istədiyiniz CSS faylının yolunu daxil edin. Məsələn: /assets/site/style.css. Əgər redaktora stil faylı yükləmək istəmirsinizsə, bu sahəni boş saxlayın.';
$_lang["editor_css_path_title"] = 'CSS faylının yolu';

$_lang["email"] = 'E-poçt';
$_lang["email_sent"] = 'E-poçt göndərildi';
$_lang["email_unique"] = 'Bu e-poçt artıq istifadə olunur!';
$_lang["emailsender_message"] = 'Sayt administratorunun e-poçt ünvanı. Sistem bildirişlərinin göndərilməsi üçün istifadə olunacaq.';
$_lang["emailsender_title"] = 'E-poçt ünvanı';
$_lang["emailsubject_default"] = 'Daxil olma məlumatlarınız';
$_lang["emailsubject_message"] = 'Qeydiyyat e-poçtunun mövzusunu təyin edin.';
$_lang["emailsubject_title"] = 'E-poçt mövzusu';

$_lang["empty_folder"] = 'Bu qovluq boşdur';
$_lang["empty_recycle_bin"] = 'Silinmiş resursları tam təmizlə';
$_lang["empty_recycle_bin_empty"] = 'Təmizlənəcək silinmiş resurs yoxdur.';
$_lang["enable_resource"] = 'Element faylını aktiv et.';
$_lang["enable_sharedparams"] = 'Parametrlərin paylaşılmasını aktiv et';
$_lang["enable_sharedparams_msg"] = '<b>Qeyd:</b> Yuxarıda göstərilən qlobal unikal identifikator (GUID) bu Modul və onun paylaşılmış parametrlərini unikal şəkildə müəyyənləşdirəcək. Bu GUID Modul ilə ona qoşulmuş Plaqin və Snippetlər arasında əlaqə yaratmaq üçün istifadə olunacaq.';
$_lang["enabled"] = 'Aktiv';
$_lang["error"] = 'Xəta';
$_lang["error_sending_email"] = 'E-poçt göndərilmə xətası';
$_lang["errorpage_message"] = 'Mövcud olmayan bir resurs istənildikdə yönləndiriləcək səhifənin ID-sini daxil edin.';
$_lang["errorpage_title"] = 'Xəta səhifəsi';
$_lang["event_id"] = 'Hadisə ID';
$_lang["eventlog"] = 'Hadisə jurnalı';
$_lang["eventlog_msg"] = 'Hadisə jurnalı sistemdə baş verən məlumat, xəbərdarlıq və xəta mesajlarını göstərir. "Mənbə" sütunu bu mesajın hansı hissədən gəldiyini göstərir.';
$_lang["eventlog_viewer"] = 'Sistem hadisələri';
$_lang["everybody"] = 'Hər kəs';
$_lang["existing_category"] = 'Mövcud kateqoriya';
$_lang["expand_tree"] = 'Sayt ağacını genişləndir';
$_lang["failed_login_message"] = 'İstifadəçinin bloklanmasından əvvəl icazə verilən uğursuz giriş cəhdlərinin sayını daxil edin.';
$_lang["failed_login_title"] = 'Uğursuz giriş cəhdləri';
$_lang["fe_editor_lang_message"] = 'Ön tərəf redaktoru üçün istifadə ediləcək dili seçin.';
$_lang["fe_editor_lang_title"] = 'Ön tərəf redaktorunun dili';

$_lang["filemanager_path_message"] = 'IIS serverində document_root ayarı düzgün təyin olunmaya bilər, bu da fayl menecerinin işləməsinə təsir edə bilər. Əgər fayl menecerində problemlər yaşayırsa, bu yolun Evolution CMS quraşdırılmasının kökünə yönəldildiyinə əmin olun.';
$_lang["filemanager_path_title"] = 'Fayl menecerinin yolu';

$_lang["folder"] = 'Qovluq';
$_lang["forgot_password_email_fine_print"] = '* Yuxarıdakı keçid parolunuzu dəyişdirdikdən sonra və ya bu günün sonunda etibarsız olacaq.';
$_lang["forgot_password_email_instructions"] = 'Buradan "Mənim Hesabım" menyusu vasitəsilə parolunuzu dəyişə biləcəksiniz.';
$_lang["forgot_password_email_intro"] = 'Hesabınızın parolunu dəyişdirmək üçün bir sorğu göndərilib.';
$_lang["forgot_password_email_link"] = 'Prosesi tamamlamaq üçün buraya klikləyin.';
$_lang["forgot_your_password"] = 'Parolunuzu unutmusunuz?';
$_lang["friendly_alias_message"] = 'Dost URL-lər aktiv olduqda, resursun URL aliası varsa, o, resurs ID-si əvəzinə istifadə ediləcək. Məsələn, əgər ID-si 1 olan bir resursun URL aliası "introduction" olarsa və sonluq ".html" kimi təyin edilibsə, bu seçim aktiv olduqda URL "introduction.html" olacaq. Əgər URL aliası təyin edilməyibsə, Evolution CMS avtomatik olaraq "1.html" yaradacaq.';
$_lang["friendly_alias_title"] = 'Dost URL aliaslarını istifadə et';
$_lang["friendlyurls_message"] = 'Apache web-serverlərində mod_rewrite və ya IIS üçün üçüncü tərəf plaginlərdən istifadə edərək axtarış sistemlərinə uyğun URL-lərdən istifadə edin. Ətraflı məlumat üçün quraşdırma faylında olan .htaccess faylına baxın.';
$_lang["friendlyurls_title"] = 'Dost URL-ləri istifadə et';
$_lang["friendlyurlsprefix_message"] = 'Məsələn, əgər prefiks "page" olaraq təyin edilibsə, "/index.php?id=2" URL-si "page2.html" şəklində çevriləcək (əgər sonluq ".html" olaraq təyin edilibsə).';
$_lang["friendlyurlsprefix_title"] = 'Dost URL prefiksi';
$_lang["friendlyurlsuffix_message"] = 'İstənilən sonluğu seçə bilərsiniz, hətta heç bir sonluq istifadə etmədən. Məsələn, ".aspx" seçilərsə, bütün URL-lər "sayfa.aspx" formatında olacaq.';
$_lang["friendlyurlsuffix_title"] = 'Dost URL sonluğu';
$_lang["functionnotimpl"] = 'Bağışlayın!';
$_lang["functionnotimpl_message"] = 'Bu funksiya hələ həyata keçirilməyib.';
$_lang["further_info"] = 'Əlavə məlumat';
$_lang["global_tabs"] = 'Qlobal Tablar';
$_lang["go"] = 'Davam et';
$_lang["group_access_permissions"] = 'İstifadəçi qrupu giriş icazələri';
$_lang['group_tvs'] = 'TV qrupları';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Kömək';
$_lang["help_donate_msg"] = 'Evolution CMS tərtibatçıları üçün qəhvə alın <a href="https://ko-fi.com/evolutioncms" target="_blank">ko-fi.com/evolutioncms ☕</a>. Bu gün Evolution CMS ❤️ dəstəkçisi olun!';
$_lang["help_donate_title"] = 'Evolution CMS-in inkişafı üçün';
$_lang["help_msg"] = '<p>Pulsuz icma dəstəyini <a href="http://forums.modx.com/" target="_blank">Evolution CMS Forumlarında</a> əldə edə bilərsiniz. Həmçinin, <a href="http://evolution-docs.com" target="_blank">Evolution CMS sənədləri və təlimatları</a> mövcuddur.</p><p>Biz Evolution CMS üçün kommersiya dəstək xidmətləri təklif etməyi planlaşdırırıq. Əgər maraqlanırsınızsa, <a href="mailto:dmi3yy@evo.im?subject=Evolution CMS Commercial Support Inquiry">bizimlə əlaqə saxlayın</a>.</p>';
$_lang["help_title"] = 'Kömək';
$_lang["hide_tree"] = 'Sayt ağacını gizlət';
$_lang["home"] = 'İdarəetmə paneli';

$_lang["icon"] = 'İkon';
$_lang["icon_description"] = 'CSS sinif dəyəri. Məsələn, fa&nbsp;fa-star';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Valideyn təyinatı:\n\nResurs seçilmiş resursun övladıdır.';
$_lang["illegal_parent_self"] = 'Valideyn təyinatı:\n\nSeçilmiş resurs özünə valideyn olaraq təyin edilə bilməz.';
$_lang["images_management"] = 'Şəkilləri idarə et';
$_lang["import_files_found"] = '<b>%s resurs idxal üçün tapıldı...</b>';
$_lang["import_params"] = 'Modulun paylaşılmış parametrlərini idxal et';
$_lang["import_params_msg"] = 'Yuxarıdakı menyudan modulun adını seçərək onun parametrlərini və ya ayarlarını idxal edə bilərsiniz. <b>Qeyd:</b> Modulların menyuda görünməsi üçün bu plagin/snippet həmin modulun asılı siyahısında olmalı və modulda parametr paylaşımı aktiv olmalıdır.';
$_lang["import_parent_resource"] = 'Əsas resurs:';
$_lang["update_tree"] = 'Ağacı yenilə';
$_lang["update_tree_description"] = '<ul>
<li>Sənəd ağacı ilə işləməyi daha rahat və sürətli edən Closure table verilənlər bazası dizaynı nümunəsi</li>
<li>Əgər ağacdakı məlumatlar modellər vasitəsilə yenilənmirsə, o zaman verilənlər bazasında sənədlərin səhv əlaqələndirilməsi ehtimalı var</li>
<li>Bu əməliyyat, site_content model vasitəsilə (saxla, yarat) yenilənmədikdə və əlaqələr (Closure table) yenilənmədikdə problemi həll edir</li>
<li>Bu əməliyyatı CLI rejimində \'php artisan closuretable:rebuild\' əmri ilə də yerinə yetirmək mümkündür</li>
</ul>';
$_lang["update_tree_danger"] = 'Əgər 1000-dən çox resursunuz varsa, bu əməliyyatı CLI rejimində \'php artisan closuretable:rebuild\' əmri ilə yerinə yetirmək daha yaxşıdır';
$_lang["update_tree_time"] = 'Ağacın yenidən qurulması tamamlandı. Emal edilən sənədlər: <b>%s</b><br>İdxal prosesi <b>%s</b> saniyə çəkdi.';
$_lang["info"] = 'Məlumat';
$_lang["information"] = 'İnformasiya';
$_lang["inline"] = 'Sətirdaxili';
$_lang["insert"] = 'Daxil et';
$_lang["maxImageWidth"] = 'Maksimum şəkil eni';
$_lang["maxImageHeight"] = 'Maksimum şəkil hündürlüyü';
$_lang["clientResize"] = 'Şəkilləri müştəri tərəfində ölçüləndir';
$_lang["clientResize_message"] = 'Əgər aktiv edilibsə, şəkillər serverə yüklənməzdən əvvəl brauzer tərəfindən ölçüləndiriləcək';
$_lang["noThumbnailsRecreation"] = 'Yalnız yükləmə zamanı kiçik şəkillər yaradın';
$_lang["noThumbnailsRecreation_message"] = 'Fayl meneceri yalnız yükləmə zamanı kiçik şəkillər yaradacaq; əgər bəzi şəkillər üçün kiçik şəkillər yoxdursa, onlar yaradılmayacaq';
$_lang["thumbWidth"] = 'Maksimum kiçik şəkil eni';
$_lang["thumbHeight"] = 'Maksimum kiçik şəkil hündürlüyü';
$_lang["thumbsDir"] = 'Kiçik şəkil qovluğu yeri';
$_lang["jpegQuality"] = 'JPEG sıxılma keyfiyyəti';
$_lang["denyZipDownload"] = 'ZIP arxivlərinin yüklənməsini qadağan et';
$_lang["denyExtensionRename"] = 'Fayl uzantılarının adını dəyişdirməyi qadağan et';
$_lang["maxImageWidth_message"] = 'Əgər yüklənmiş şəkil bu dəyərdən böyükdürsə, avtomatik olaraq ölçüsü dəyişdiriləcək. Qarşısını almaq üçün 0 təyin edin.';
$_lang["maxImageHeight_message"] = 'Əgər yüklənmiş şəkil bu dəyərdən böyükdürsə, avtomatik olaraq ölçüsü dəyişdiriləcək. Qarşısını almaq üçün 0 təyin edin.';
$_lang["thumbWidth_message"] = 'Maksimum kiçik şəkil eni.';
$_lang["thumbHeight_message"] = 'Maksimum kiçik şəkil hündürlüyü.';
$_lang["thumbsDir_message"] = 'Kiçik şəkillər üçün qovluğun adı.';
$_lang["jpegQuality_message"] = 'Kiçik şəkillər və ölçüsü dəyişdirilmiş şəkillər üçün JPEG sıxılma keyfiyyəti';
$_lang["showHiddenFiles"] = 'Fayl menecerində gizli faylları göstər';
$_lang["keyword"] = 'Açar söz';
$_lang["keywords"] = 'Açar sözlər';
$_lang["keywords_intro"] = 'Açar sözü redaktə etmək üçün, sadəcə həmin açar sözün yanında yeni açar söz yazın. Açar sözü silmək üçün, "sil" qutusunu işarələyin. Əgər həm açar sözü dəyişdirsəniz, həm də silmə qutusunu işarələsəniz, o zaman açar söz silinəcək və yeni ad tətbiq edilməyəcək!';
$_lang["language_message"] = 'Evolution CMS üçün dili seçin.';
$_lang["language_title"] = 'İdarəetmə panelinin dili';
$_lang["last_update"] = 'Son yeniləmə';
$_lang["launch_site"] = 'Sayta bax';
$_lang["license"] = 'Lisenziya';
$_lang["link_attributes"] = 'Keçid xüsusiyyətləri';
$_lang["link_attributes_help"] = 'Bu səhifə üçün keçidə əlavə xüsusiyyətlər daxil edin, məsələn, target="_blank" və ya rel="external".';
$_lang["list_mode"] = 'Siyahı rejimini aktivləşdir/deaktiv et - bu, bütün qeydləri cədvəldə göstərmək üçün istifadə olunur.';
$_lang["loading_doc_tree"] = 'Sayt ağacı yüklənir...';
$_lang["loading_menu"] = 'Menyu yüklənir...';
$_lang["loading_page"] = 'Zəhmət olmasa gözləyin, Evolution CMS səhifəni yükləyir...';
$_lang["localtime"] = 'Yerli vaxt';

$_lang["lock_htmlsnippet"] = 'Çankın redaktəsini kilidlə';
$_lang["lock_htmlsnippet_msg"] = 'Yalnız Administratorlar (Rol ID 1) bu Çankı redaktə edə bilər.';
$_lang["lock_module"] = 'Modulun redaktəsini kilidlə';
$_lang["lock_module_msg"] = 'Yalnız Administratorlar (Rol ID 1) bu Modulu redaktə edə bilər.';
$_lang["lock_msg"] = '%s hazırda bu %s üzərində işləyir. Zəhmət olmasa digər istifadəçi işini bitirənə qədər gözləyin və yenidən cəhd edin.';
$_lang["lock_plugin"] = 'Pluginin redaktəsini kilidlə';
$_lang["lock_plugin_msg"] = 'Yalnız Administratorlar (Rol ID 1) bu Plaqini redaktə edə bilər.';
$_lang["lock_settings_msg"] = '%s hazırda bu parametrləri redaktə edir. Zəhmət olmasa digər istifadəçi işini bitirənə qədər gözləyin və yenidən cəhd edin.';
$_lang["lock_snippet"] = 'Snippetin redaktəsini kilidlə';
$_lang["lock_snippet_msg"] = 'Yalnız Administratorlar (Rol ID 1) bu Snippeti redaktə edə bilər.';
$_lang["lock_template"] = 'Şablonun redaktəsini kilidlə';
$_lang["lock_template_msg"] = 'Yalnız Administratorlar (Rol ID 1) bu Şablonu redaktə edə bilər.';
$_lang["lock_tmplvars"] = 'Şablon dəyişəninin redaktəsini kilidlə';
$_lang["lock_tmplvars_msg"] = 'Yalnız Administratorlar (Rol ID 1) bu Şablon Dəyişənini redaktə edə bilər.';
$_lang["locked"] = 'Kilidləndi';

$_lang["login_allowed_days"] = 'İcazə verilən günlər';
$_lang["login_allowed_days_message"] = 'Bu istifadəçinin daxil ola biləcəyi günləri seçin.';
$_lang["login_allowed_ip"] = 'İcazə verilən IP ünvanı';
$_lang["login_allowed_ip_message"] = 'Bu istifadəçinin daxil ola biləcəyi IP ünvanlarını daxil edin. <b>Qeyd: Birdən çox IP ünvanını vergül (,) ilə ayırın</b>';
$_lang["login_button"] = 'Giriş';
$_lang["login_cancelled_install_in_progress"] = 'Saytın quraşdırılması və ya yenilənməsi davam edir. Bir neçə dəqiqədən sonra yenidən cəhd edin!';
$_lang["login_cancelled_site_was_updated"] = 'Saytda quraşdırma və ya yeniləmə aparılıb, zəhmət olmasa yenidən daxil olun!';
$_lang["login_captcha_message"] = 'Zəhmət olmasa, şəkildə göstərilən təhlükəsizlik kodunu daxil edin. Əgər kodu oxuya bilmirsinizsə, yeni birini yaratmaq üçün şəklin üzərinə klikləyin və ya sayt inzibatçısı ilə əlaqə saxlayın.';
$_lang["login_homepage"] = 'Giriş Ana Səhifəsi';
$_lang["login_homepage_message"] = 'İstifadəçi daxil olduqdan sonra yönləndiriləcəyi resursun ID-sini daxil edin. <b>Qeyd: Göstərilən ID mövcud və dərc olunmuş bir resursa aid olmalıdır!</b>';
$_lang["login_message"] = 'Zəhmət olmasa, idarəetmə panelinə daxil olmaq üçün giriş məlumatlarınızı daxil edin. İstifadəçi adı və şifrə böyük-kiçik hərf həssaslığına malikdir!';
$_lang["logo_slogan"] = 'Evolution CMS - \nDaha az resursla daha çox yaradın və inkişaf etdirin';
$_lang["logout"] = 'Çıxış';
$_lang["long_title"] = 'Uzun başlıq';

$_lang["manager"] = 'İdarəetmə paneli';
$_lang["manager_lockout_message"] = 'Hazırda Məzmun Menecerinə daxil olmusunuz. Sessiyanı bağlamaq üçün "Çıxış" düyməsinə klikləyin. <p />Başlanğıc və ya ana səhifəyə keçmək üçün "Ana səhifə" düyməsinə klikləyin.';
$_lang["manager_permissions"] = 'İdarəetmə icazələri';
$_lang["manager_theme"] = 'İdarəetmə paneli şablonu';
$_lang["manager_theme_message"] = 'İdarəetmə paneli üçün şablon seçin.';
$_lang["manager_theme_mode"] = 'Rəng sxemi:';
$_lang["manager_theme_mode1"] = 'hər şey açıq rəngdədir';
$_lang["manager_theme_mode2"] = 'yalnız başlıq tünd rəngdədir';
$_lang["manager_theme_mode3"] = 'başlıq və yan panel tünd rəngdədir';
$_lang["manager_theme_mode4"] = 'hər şey tünd rəngdədir';
$_lang['manager_theme_mode_message'] = 'Bu ayar "standart" kimi istifadə olunur və idarəetmə panelində resurs ağacındakı mövzu rəng rejimi keçid düyməsi ilə dəyişdirilə bilər: <i class="fa fa-lg fa-adjust"></i>';
$_lang['manager_theme_mode_title'] = 'Mövzu rəng rejimi keçidi';

$_lang["meta_keywords"] = 'META açar sözlər';
$_lang["metatag_intro"] = 'Bu səhifədə META teqlərini silə, yarada və ya redaktə edə bilərsiniz. META teqlərini resurslara bağlamaq üçün, resursu redaktə edərkən <u>META açar sözləri</u> sekmesine keçin və istədiyiniz açar sözləri seçin. Yeni bir teq əlavə etmək üçün adını və dəyərini daxil edin, sonra "Teqi əlavə et" düyməsini basın. Teqi redaktə etmək üçün, məlumat cədvəlində teqin adına klikləyin.';
$_lang["metatag_notice"] = 'Ətraflı məlumat üçün <a href="http://www.html-reference.com/META.asp" target="_blank">HTML İstinad Bələdçisi</a> saytına baxa bilərsiniz. Bu, mümkün olan bütün META teqlərinin tam siyahısı deyil.';
$_lang["metatags"] = 'META teqlər';
$_lang["mgr_access_permissions"] = 'İdarəetmə giriş icazələri';
$_lang["mgr_login_start"] = 'İdarəetmə Paneli Giriş Başlanğıcı';
$_lang["mgr_login_start_message"] = 'İstifadəçi idarəetmə panelinə daxil olduqdan sonra yönləndiriləcəyi resursun ID-sini daxil edin. <b>Qeyd: Göstərilən ID mövcud və dərc olunmuş bir resursa aid olmalıdır!</b>';

$_lang["mgrlog_action"] = 'Əməliyyat';
$_lang["mgrlog_actionid"] = 'Əməliyyat ID-si';
$_lang["mgrlog_anyall"] = 'Hər hansı/Bütün';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() funksiyası yalnış nəticə qaytardı.';
$_lang["mgrlog_datefr"] = 'Tarixdən';
$_lang["mgrlog_dateinvalid"] = 'Yanlış tarix formatı.';
$_lang["mgrlog_dateto"] = 'Tarixə qədər';
$_lang["mgrlog_emptysrch"] = 'Axtarışınız boş nəticə qaytardı (uyğun qeyd tapılmadı).';
$_lang["mgrlog_field"] = 'Sahə';
$_lang["mgrlog_itemid"] = 'Element ID-si';
$_lang["mgrlog_itemname"] = 'Element adı';
$_lang["mgrlog_msg"] = 'Mesaj';
$_lang["mgrlog_noquery"] = 'Hələ heç bir axtarış sorğusu daxil edilməyib.';
$_lang["mgrlog_qresults"] = 'Sorğu nəticələri';
$_lang["mgrlog_query"] = 'Sorğu qeydləri';
$_lang["mgrlog_query_msg"] = 'Zəhmət olmasa, logları görmək üçün seçim edin.';
$_lang["mgrlog_results"] = 'Nəticə sayı';
$_lang["mgrlog_searchlogs"] = 'Loglarda axtarış';
$_lang["mgrlog_sortinst"] = 'Cədvəli sütun başlıqlarına klikləyərək sırala.';
$_lang["mgrlog_time"] = 'Vaxt';
$_lang["mgrlog_user"] = 'İstifadəçi';
$_lang["mgrlog_username"] = 'İstifadəçi adı';
$_lang["mgrlog_value"] = 'Dəyər';
$_lang["mgrlog_view"] = 'İdarəetmə loglarına bax';

$_lang["modx_news"] = 'Evolution CMS Xəbərləri';
$_lang["modx_news_tab"] = 'Evolution CMS Xəbərlər';
$_lang["modx_news_title"] = 'Evolution CMS Xəbərlər';
$_lang["modx_security_notices"] = 'Evolution CMS Təhlükəsizlik Bildirişləri';
$_lang["modx_version"] = 'Evolution CMS versiyası';

$_lang["name"] = 'İstifadəçi adı';

$_lang["no"] = 'Xeyr';
$_lang["no_active_users_found"] = 'Aktiv istifadəçi tapılmadı.';
$_lang["no_activity_message"] = 'Hələ heç bir resurs yaratmamısınız və ya redaktə etməmisiniz.';
$_lang["no_category"] = 'kateqoriyasız';
$_lang["no_docs_pending_publishing"] = 'Dərc olunmasını gözləyən resurs yoxdur.';
$_lang["no_docs_pending_pubunpub"] = 'Hadisə tapılmadı';
$_lang["no_docs_pending_unpublishing"] = 'Dərcdən çıxarılmasını gözləyən resurs yoxdur.';
$_lang["no_edits_creates"] = 'Düzəliş və ya yaradılma qeydə alınmayıb.';
$_lang["no_groups_found"] = 'Heç bir qrup tapılmadı.';
$_lang["no_keywords_found"] = 'Hazırda açar sözlər mövcud deyil.';
$_lang["no_records_found"] = 'Heç bir qeyd tapılmadı.';
$_lang["no_results"] = 'Heç bir nəticə tapılmadı.';
$_lang["nologentries_message"] = 'Audit qeydlərini nəzərdən keçirərkən səhifə başına göstəriləcək log qeydlərinin sayını daxil edin.';
$_lang["nologentries_title"] = 'Log qeydlərinin sayı';
$_lang["none"] = 'Heç biri';
$_lang["noresults_message"] = 'Siyahıları və axtarış nəticələrini göstərərkən verilənlər cədvəlində göstəriləcək nəticələrin sayını daxil edin.';
$_lang["noresults_title"] = 'Nəticələrin sayı';
$_lang["not_deleted"] = 'silinmədi.';
$_lang["not_set"] = 'Təyin olunmayıb';

$_lang["offline"] = 'Oflayn';

$_lang["online"] = 'Onlayn';
$_lang["onlineusers_action"] = 'Əməliyyat';
$_lang["onlineusers_actionid"] = 'Əməliyyat ID-si';
$_lang["onlineusers_ipaddress"] = 'IP ünvanı';
$_lang["onlineusers_lasthit"] = 'Son ziyarət';
$_lang["onlineusers_message"] = 'Bu siyahı son 20 dəqiqə ərzində aktiv olan istifadəçiləri göstərir (cari vaxt ';
$_lang["onlineusers_title"] = 'Onlayn istifadəçilər';
$_lang["onlineusers_user"] = 'İstifadəçi adı';
$_lang["onlineusers_userid"] = 'İstifadəçi ID-si';

$_lang["optimize_table"] = 'Bu cədvəli optimallaşdırmaq üçün buraya klikləyin';

$_lang["page_data_alias"] = 'Alias';
$_lang["page_data_cacheable"] = 'Keşlənə bilən';
$_lang["page_data_cacheable_help"] = 'Bu, resursun saytın keşinə yazılmasına imkan verir və səhifədəki bütün Snippet-lərə təsir edir.';
$_lang["page_data_cached"] = '<b>Mənbə keşdən əldə edildi:</b>';
$_lang["page_data_changes"] = 'Dəyişikliklər';
$_lang["page_data_contentType"] = 'İnternet Media Növü';
$_lang["page_data_contentType_help"] = 'Bu resurs üçün məzmun növünü seçin. Hansı məzmun növü istifadə edəcəyinizi bilmirsinizsə, sadəcə text/html olaraq saxlayın.';
$_lang["page_data_created"] = 'Yaradıldı';
$_lang["page_data_edited"] = 'Düzəliş edildi';
$_lang["page_data_editor"] = 'Rich text redaktoru ilə redaktə et';
$_lang["page_data_folder"] = 'Resurs Qovluqdur';
$_lang["page_data_general"] = 'Ümumi';
$_lang["page_data_markup"] = 'İşarələmə/Struktur';
$_lang["page_data_mgr_access"] = 'Menecer girişi';
$_lang["page_data_notcached"] = 'Bu resurs hələ keşlənməyib.';
$_lang["page_data_publishdate"] = 'Dərc tarixi';
$_lang["page_data_publishdate_help"] = 'Dərc tarixi təyin etsəniz, bu tarixə çatanda resurs avtomatik dərc olunacaq. Tarixi seçmək üçün təqvim ikonuna klikləyin və ya silmək üçün yanındakı ikonaya klikləyin.';
$_lang["page_data_published"] = 'Dərc olunub';
$_lang["page_data_searchable"] = 'Axtarıla bilən';
$_lang["page_data_searchable_help"] = 'Bu sahəni işarələsəniz, resurs axtarışlarda görünəcək. Həmçinin bu sahəni Snippet-lərdə digər məqsədlər üçün istifadə edə bilərsiniz.';
$_lang["page_data_source"] = 'Mənbə';
$_lang["page_data_status"] = 'Status';
$_lang["page_data_template"] = 'Şablondan istifadə edir';
$_lang["page_data_template_help"] = 'Bu resurs üçün istifadə ediləcək şablonu seçin.';
$_lang["page_data_title"] = 'Səhifə məlumatları';
$_lang["page_data_unpublishdate"] = 'Dərcdən çıxarma tarixi';
$_lang["page_data_unpublishdate_help"] = 'Dərcdən çıxarma tarixi təyin etsəniz, bu tarixə çatanda resurs avtomatik dərcdən çıxarılacaq. Tarixi seçmək üçün təqvim ikonuna klikləyin və ya silmək üçün yanındakı ikonaya klikləyin.';
$_lang["page_data_unpublished"] = 'Dərc olunmayıb';
$_lang["page_data_web_access"] = 'Veb girişi';

$_lang["pagetitle"] = 'Resursun başlığı';
$_lang["pagination_table_first"] = 'Birinci';
$_lang["pagination_table_gotopage"] = 'Səhifəyə keç';
$_lang["pagination_table_last"] = 'Sonuncu';
$_lang["paging_first"] = 'birinci';
$_lang["paging_last"] = 'sonuncu';
$_lang["paging_next"] = 'növbəti';
$_lang["paging_prev"] = 'əvvəlki';
$_lang["paging_showing"] = 'Göstərilir';
$_lang["paging_to"] = 'ilə';
$_lang["paging_total"] = 'ümumi';
$_lang["parameter"] = 'Parametr';
$_lang["parse_docblock"] = 'DocBlock-u təhlil et';
$_lang["parse_docblock_msg"] = 'Diqqət (!): <b>Mövcud ad, konfiqurasiya, təsvir və kateqoriyanı</b> mənbə koduna əsasən quraşdırma standartlarına uyğun olaraq sıfırlayır.';

$_lang["password"] = 'Şifrə';
$_lang["password_change_request"] = 'Şifrə dəyişmə sorğusu';
$_lang["password_confirmed"] = 'Şifrələr uyğun gəlmir';
$_lang["password_gen_gen"] = 'Evolution CMS-in şifrə yaratmasına icazə verin.';
$_lang["password_gen_length"] = 'Daxil etdiyiniz şifrə ən azı 6 simvol uzunluğunda olmalıdır.';
$_lang["password_gen_method"] = 'Yeni şifrə metodu';
$_lang["password_gen_specify"] = 'Şifrəni mən təyin edim:';
$_lang["password_method"] = 'Şifrə bildiriş metodu';
$_lang["password_method_email"] = 'Yeni şifrəni e-poçt vasitəsilə göndər.';
$_lang["password_method_screen"] = 'Yeni şifrəni ekranda göstər.';
$_lang["password_msg"] = 'Yeni şifrə <b>:username</b> üçün <b>:password</b><br>';

$_lang["php_version_check"] = 'Evolution CMS PHP 7.4 və daha yüksək versiyalarla uyğundur. Bu server %s% versiyasını istifadə edir. PHP qurğusunu yeniləyin!';

$_lang["preview"] = 'Önizləmə';
$_lang["preview_msg"] = 'Bu, son saxlanılan dəyişikliklərinizin önizləməsidir. Buraya klikləyin: <a href="javascript:;" onclick="saveRefreshPreview();">Saxla və Yenilə</a> cari dəyişikliklərinizi.';
$_lang["preview_resource"] = 'Resursun önizləməsi';

$_lang["private"] = 'Şəxsi';
$_lang["public"] = 'İctimai';
$_lang["publish_date"] = 'Dərc tarixi';
$_lang["publish_events"] = 'Dərc hadisələri';
$_lang["publish_resource"] = 'Resursu dərc et';

$_lang["rb_base_dir_message"] = 'Fayl brauzerinin fiziki yolunu daxil edin. Bu ayar adətən avtomatik yaradılır. Əgər IIS istifadə edirsinizsə, Evolution CMS yolu avtomatik müəyyən edə bilməyə bilər və nəticədə fayl brauzerində xəta göstərə bilər. Belə olduqda, şəkillər qovluğunun yolunu buraya daxil edin (Windows Explorer-də görəcəyiniz yol). <b>QEYD:</b> Fayl brauzeri düzgün işləməsi üçün "images", "files", "flash" və "media" alt qovluqlarına malik olmalıdır.';
$_lang["rb_base_dir_title"] = 'Fayl əsas yolu';
$_lang["rb_base_url_message"] = 'Fayllar qovluğunun virtual yolunu daxil edin. Bu ayar adətən avtomatik yaradılır. Əgər IIS istifadə edirsinizsə, Evolution CMS URL-ni avtomatik müəyyən edə bilməyə bilər və nəticədə fayl brauzerində xəta göstərə bilər. Belə olduqda, şəkillər qovluğunun URL-ni buraya daxil edin (Internet Explorer-də daxil edəcəyiniz URL).';
$_lang["rb_base_url_title"] = 'Fayl brauzerinin URL-si';
$_lang["rb_message"] = 'Fayl brauzerini aktivləşdirmək üçün "bəli" seçin. Bu, istifadəçilərə şəkillər, flash və media fayllarını serverə yükləməyə və baxmağa imkan verəcək.';
$_lang["rb_title"] = 'Fayl brauzerini aktivləşdir';
$_lang["rb_webuser_message"] = 'Veb istifadəçilərin fayl brauzerindən istifadə etməsinə icazə vermək istəyirsinizmi? <b>XƏBƏRDARLIQ:</b> Veb istifadəçilərə fayl brauzerindən istifadə icazəsi vermək, menecer istifadəçilərinə açıq olan faylları görməyə imkan yaradır. Bu ayarı yalnız etibarlı veb istifadəçilər üçün aktiv edin.';
$_lang["rb_webuser_title"] = 'Veb istifadəçilər?';
$_lang["recent_docs"] = 'Son resurslar';
$_lang["recommend_setting_change_title"] = 'Tövsiyə olunan ayar dəyişikliyi';
$_lang["recommend_setting_change_description"] = 'Saytınız menecerə daxil olan sorğuların HTTP_REFERER doğrulamasını aparmaq üçün tənzimlənməyib. CSRF (Cross Site Request Forgery) hücumlarının riskini azaltmaq üçün bu ayarın aktiv edilməsini tövsiyə edirik.';
$_lang["references"] = 'İstinadlar';
$_lang["refresh_cache"] = 'Keş: Keş qovluğunda <b>%s</b> fayl tapıldı və <b>%d</b> keş faylı silindi.<p>Yeni keş faylları səhifələr sorğulananda yaradılacaq.';
$_lang["refresh_published"] = '<b>%s</b> resurs dərc edildi.';
$_lang["refresh_site"] = 'Keşi təmizlə';
$_lang["refresh_title"] = 'Saytı yenilə';
$_lang["refresh_tree"] = 'Sayt ağacını yenilə';
$_lang["refresh_unpublished"] = '<b>%s</b> resurs dərcdən çıxarıldı.';
$_lang["release_date"] = 'Buraxılış tarixi';
$_lang["remember_last_tab"] = 'Sonuncu nişanı yadda saxla';
$_lang["remember_last_tab_message"] = 'Menecer səhifələri son baxılan nişan ilə yüklənəcək, əks halda birinci nişan açılacaq';
$_lang["remember_username"] = 'Məni yadda saxla';
$_lang["remove"] = 'Sil';
$_lang["remove_date"] = 'Tarixi sil';
$_lang["remove_locks"] = 'Bloklamaları sil';
$_lang["rename"] = 'Adı dəyiş';
$_lang["reports"] = 'Hesabatlar';
$_lang["report_issues"] = 'Problemləri bildir';
$_lang["required_field"] = 'Sahə :field tələb olunur';
$_lang["require_tagname"] = 'Etiket adı tələb olunur';
$_lang["require_tagvalue"] = 'Etiket dəyəri tələb olunur';
$_lang["reserved_name_warning"] = 'Qorunan ad istifadə etdiniz.';
$_lang["reset"] = 'Sıfırla';
$_lang["reset_failedlogins"] = 'sıfırla';
$_lang["reset_sort_order"] = 'Sıralama qaydasını sıfırla';

$_lang["manager_access_permissions"] = 'Menecerin giriş icazələri';
$_lang["manage_groups"] = 'Sənəd və istifadəçi qruplarını idarə et';
$_lang["manage_document_permissions"] = 'Sənəd icazələrini idarə et';
$_lang["manage_module_permissions"] = 'Modul icazələrini idarə et';
$_lang["manage_tv_permissions"] = 'TV icazələrini idarə et';

$_lang["rss_url_news_default"] = 'https://github.com/evocms-community/evolution/releases.atom';
$_lang["rss_url_news_message"] = 'Evolution CMS Xəbərlər Lentinin URL ünvanını daxil edin.';
$_lang["rss_url_news_title"] = 'RSS Xəbərlər Lenti';
$_lang["rss_url_security_default"] = 'https://github.com/extras-evolution/security-fix/releases.atom';
$_lang["rss_url_security_message"] = 'Evolution CMS Təhlükəsizlik Lentinin URL ünvanını daxil edin.';
$_lang["rss_url_security_title"] = 'RSS Təhlükəsizlik Xəbər Lenti';

$_lang["run_module"] = 'Modulu işə sal';
$_lang["save"] = 'Yadda saxla';
$_lang["save_all_changes"] = 'Bütün dəyişiklikləri yadda saxla';
$_lang["save_tag"] = 'Etiketi yadda saxla';
$_lang["saving"] = 'Yadda saxlanılır, gözləyin...';

$_lang["search"] = 'Axtar';
$_lang["search_criteria"] = 'Axtarış meyarları';
$_lang["search_criteria_content"] = 'Məzmun üzrə axtar';
$_lang["search_criteria_content_msg"] = 'Daxil edilən mətnin məzmununda olduğu bütün resursları tapın.';
$_lang["search_criteria_id"] = 'ID üzrə axtar';
$_lang["search_criteria_id_msg"] = 'Resursun ID-sini daxil edərək onu tez tapın.';
$_lang["search_criteria_top"] = 'Əsas sahələrdə axtar';
$_lang["search_criteria_top_msg"] = 'Səhifə başlığı, Uzun başlıq, Qısa ad, ID';
$_lang["search_criteria_template_id"] = 'Şablon ID üzrə axtar';
$_lang["search_criteria_template_id_msg"] = 'Göstərilən şablondan istifadə edən bütün resursları tapın.';
$_lang["search_criteria_url_msg"] = 'Dəqiq URL-ə görə resurs tapın.';
$_lang["search_criteria_longtitle"] = 'Uzun başlığa görə axtar';
$_lang["search_criteria_longtitle_msg"] = 'Daxil edilən mətnin uzun başlıqda olduğu bütün resursları tapın.';
$_lang["search_criteria_title"] = 'Başlığa görə axtar';
$_lang["search_criteria_title_msg"] = 'Daxil edilən mətnin başlıqda olduğu bütün resursları tapın.';
$_lang["search_empty"] = 'Axtarışınıza uyğun nəticə tapılmadı. Axtarış meyarlarını genişləndirərək yenidən cəhd edin.';
$_lang["search_item_deleted"] = 'Bu element silinib';
$_lang["search_results"] = 'Axtarış nəticələri';
$_lang["search_results_returned_desc"] = 'Təsvir';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Axtarış meyarlarınıza uyğun <b>%s</b> resurs tapıldı. Əgər çox nəticə çıxarsa, daha dəqiq axtarış etməyə çalışın.';
$_lang["search_results_returned_title"] = 'Başlıq';
$_lang["search_view_docdata"] = 'Bu elementi görüntülə';

$_lang["security"] = 'İstifadəçilər';
$_lang["security_notices_tab"] = 'Təhlükəsizlik Bildirişləri';
$_lang["security_notices_title"] = 'Təhlükəsizlik Bildirişləri';

$_lang["select_date"] = 'Tarix seçin';
$_lang["send"] = 'Göndər';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Əgər saytınız https bağlantısı üzərindədirsə, bunu burada göstərin.';
$_lang["server_protocol_title"] = 'Server növü';
$_lang["serveroffset"] = 'Server saat fərqi';
$_lang["serveroffset_message"] = 'Sizin olduğunuz yer ilə server arasındakı saat fərqini seçin. Serverdə cari vaxt <b>[%s]</b>, saxlanılmış saat fərqi ilə cari vaxt isə <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Server saat fərqi';
$_lang["servertime"] = 'Server vaxtı';
$_lang["set_automatic"] = 'Avtomatik təyin et';
$_lang["set_default"] = 'Standart olaraq təyin et';
$_lang["set_default_all"] = 'Bütün standartları təyin et';

$_lang["settings_after_install"] = 'Bu, yeni bir quraşdırma olduğuna görə, bu parametrləri nəzərdən keçirməli və istədiklərinizi dəyişməlisiniz. Parametrləri nəzərdən keçirdikdən sonra, onları yeniləmək üçün "Yadda saxla" düyməsinə basın.';
$_lang["settings_config"] = 'Konfiqurasiya';
$_lang["settings_dependencies"] = 'Asılılıqlar';
$_lang["settings_events"] = 'Sistem hadisələri';
$_lang["settings_furls"] = 'Dost URL-lər';
$_lang["settings_general"] = 'Ümumi';
$_lang["settings_group_tv_message"] = 'Resursu redaktə edərkən Şablon Dəyişənlərinin bölmələrdə və ya tablarda (TV kateqoriyasına görə adlandırılmış) qruplaşdırılıb-qruplaşdırılmayacağını seçin.';
$_lang["settings_group_tv_options"] = 'Xeyr, Ümumi tabında bölmələr, Ümumi tabında tablar, Yeni tabda bölmələr, Yeni tabda tablar, Yeni tablar';
$_lang["settings_misc"] = 'Fayl meneceri';
$_lang["settings_security"] = 'Təhlükəsizlik';
$_lang["settings_KC"] = 'Fayl brauzeri';
$_lang["settings_page_settings"] = 'Ayarlar';
$_lang["settings_photo"] = 'Şəkil';
$_lang["settings_properties"] = 'Xüsusiyyətlər';
$_lang["settings_site"] = 'Sayt';
$_lang["settings_strip_image_paths_message"] = 'Əgər bu "Xeyr" olaraq təyin edilərsə, Evolution CMS fayl brauzerinin mənbələrini (şəkillər, fayllar, flash və s.) tam URL-lərlə yazacaq. Nisbətən URL-lər, Evolution CMS-i başqa bir yerə köçürmək istəyirsinizsə faydalıdır. Əgər bu termin sizə məlum deyilsə, onu "Bəli" olaraq saxlamaq daha yaxşıdır.';
$_lang["settings_strip_image_paths_title"] = 'Brauzer yollarını yenidən yazılsın?';
$_lang["settings_templvars"] = 'Şablon dəyişənləri';
$_lang["settings_title"] = 'Sistem konfiqurasiyası';
$_lang["settings_ui"] = 'İnterfeys və xüsusiyyətlər';
$_lang["settings_users"] = 'İstifadəçi';
$_lang["settings_email_templates"] = 'E-mail və şablonlar';

$_lang["show_fullscreen_btn_message"] = 'Menyu tam ekran açma düyməsini göstər';
$_lang["show_newresource_btn_message"] = 'Menyu Yeni Resurs düyməsini göstər';
$_lang["settings_show_picker_message"] = 'Menecer mövzusunu fərdiləşdirin və localstorage-ə yadda saxlayın';
$_lang["show_fullscreen_btn"] = 'Tam ekran açma düyməsi';
$_lang["show_newresource_btn"] = 'Yeni resurs düyməsi';

$_lang["show_meta"] = 'META açar sözlər tabını göstər';
$_lang["show_meta_message"] = 'Resursları redaktə edərkən köhnəlmiş META açar sözlər tabını göstər.';
$_lang["show_tree"] = 'Sayt ağacını göstər';
$_lang["show_picker"] = 'Rəng dəyişdiricini göstər';
$_lang["showing"] = 'Göstərilir';
$_lang["signupemail_message"] = 'İstifadəçilərə hesab yaradıldıqda göndərilən e-mail mesajını təyin edin, daxilində istifadəçi adı və şifrə olsun.<br /><b>Qeyd:</b> Aşağıdakı dəyişənlər mesaj göndərildikdə avtomatik dəyişdirilir: <br /><br />[+sname+] - Saytınızın adı, <br />[+saddr+] - Saytınızın e-mail ünvanı, <br />[+surl+] - Saytınızın URL-i, <br />[+uid+] - İstifadəçinin giriş adı və ya ID-si, <br />[+pwd+] - İstifadəçinin şifrəsi, <br />[+ufn+] - İstifadəçinin tam adı, <br />[+u_first_name+] - İstifadəçinin adı, <br />[+u_last_name+] - İstifadəçinin soyadı, <br />[+u_middle_name+] - İstifadəçinin ata adı. <br /> <br /><b>[+uid+] və [+pwd+] dəyişənlərini mesajdan çıxarmayın, əks halda istifadəçilər giriş məlumatlarını bilməyəcəklər!</b>';
$_lang["signupemail_title"] = 'Qeydiyyat e-maili';
$_lang["site"] = 'Sayt';
$_lang["site_schedule"] = 'Cədvəl';
$_lang["sitename_message"] = 'Burada saytınızın adını daxil edin.';
$_lang["sitename_title"] = 'Saytın adı';
$_lang["sitestart_message"] = 'Burada ana səhifə kimi istifadə etmək istədiyiniz resursun ID-sini daxil edin. <b>QEYD: Bu ID-nin mövcud bir resursa aid olduğuna və dərc edildiyinə əmin olun!</b>';
$_lang["sitestart_title"] = 'Sayt başlanğıcı';
$_lang["sitestatus_message"] = 'Saytınızı internetdə dərc etmək üçün "Onlayn" seçin. Əgər "Offline" seçsəniz, ziyarətçilər "Sayt mövcud deyil" mesajını görəcəklər və saytı gəzə bilməyəcəklər.';
$_lang["sitestatus_title"] = 'Sayt statusu';
$_lang["siteunavailable_message"] = 'Sayt oflayn olduqda və ya bir səhv baş verdikdə göstərilən mesaj. <b>Qeyd: Bu mesaj yalnız "Sayt mövcud deyil" səhifəsi təyin edilmədikdə göstərilir.</b>';
$_lang["siteunavailable_message_default"] = 'Sayt hal-hazırda işləmir.';
$_lang["siteunavailable_page_message"] = 'Burada oflayn səhifə kimi istifadə etmək istədiyiniz resursun ID-sini daxil edin. <b>QEYD: Bu ID-nin mövcud bir resursa aid olduğuna və dərc edildiyinə əmin olun!</b>';
$_lang["siteunavailable_page_title"] = '\'Sayt işləmir\' səhifəsi';
$_lang["siteunavailable_title"] = '\'Sayt işləmir\' mesajı';
$_lang["controller_namespace"] = 'Kontroller Namespase';
$_lang["controller_namespace_message"] = 'Kontrollerlərin götürülməli olduğu tam Namespase-i göstərin, məsələn: <b>EvolutionCMS\\Main\\Controllers\\</b>';
$_lang["update_repository"] = 'GitHub repozitoriya yolu';
$_lang["update_repository_message"] = 'GitHub repozitoriya yolunu daxil edin, məsələn: <b>evocms-community/evolution</b>';

$_lang["sort_alphabetically"] = 'Əlifba sırası ilə sırala';
$_lang["sort_asc"] = 'Artan sıra';
$_lang["sort_desc"] = 'Azalan sıra';
$_lang["sort_menuindex"] = 'Menyu indeksinə görə sırala';
$_lang["sort_tree"] = 'Sayt ağacını sırala';
$_lang['sort_updating'] = 'Yenilənir...';
$_lang['sort_updated'] = 'Yeniləndi!';
$_lang['sort_nochildren'] = 'Valideynin heç bir övladı yoxdur';
$_lang["sort_elements_msg"] = 'Elementləri yenidən sıralamaq üçün sürükləyin.';

$_lang["source"] = 'Mənbə';
$_lang["stay"] = 'Redaktəyə davam et';
$_lang["stay_new"] = 'Başqa birini əlavə et';
$_lang["submit"] = 'Təsdiqlə';
$_lang["sys_alert"] = 'Sistem Xəbərdarlığı';
$_lang["sysinfo_activity_message"] = 'Bu siyahı istifadəçilərinizin son redaktə etdiyi resursları göstərir.';
$_lang["sysinfo_userid"] = 'İstifadəçi';
$_lang["system"] = 'Sistem';
$_lang["system_email_signup"] = 'Salam, [+uid+]

Bu, [+sname+] məzmun meneceri üçün giriş məlumatlarınızdır:

İstifadəçi adı: [+uid+]
Şifrə: [+pwd+]

Məzmun Menecerinə ([+surl+]) daxil olduqdan sonra şifrənizi dəyişə bilərsiniz.

Hörmətlə,  
Sayt Administratoru';
$_lang["system_email_webreminder"] = 'Salam, [+uid+]

Yeni şifrənizi aktivləşdirmək üçün aşağıdakı linkə keçid edin:

[+surl+]

Əgər uğurlu olarsa, aşağıdakı şifrə ilə daxil ola bilərsiniz:

Şifrə: [+pwd+]

Əgər bu e-poçtu siz istəməmisinizsə, sadəcə onu nəzərə almayın.

Hörmətlə,  
Sayt Administratoru';
$_lang["system_email_websignup"] = 'Salam, [+uid+]

Bu, [+sname+] üçün giriş məlumatlarınızdır:

İstifadəçi adı: [+uid+]
Şifrə: [+pwd+]

[+sname+] ([+surl+]) sisteminə daxil olduqdan sonra şifrənizi dəyişə bilərsiniz.

Hörmətlə,  
Sayt Administratoru';
$_lang["table_hoverinfo"] = 'Cədvəl adının üzərinə gedərək onun funksiyası haqqında qısa məlumatı görə bilərsiniz (bütün cədvəllərdə <i>şərhlər</i> mövcud deyil).';
$_lang["table_prefix"] = 'Cədvəl prefiksi';
$_lang["tag"] = 'Etiket';

$_lang["to"] = 'ilə';
$_lang["toggle_fullscreen"] = 'Tam ekrana keçid';
$_lang["tools"] = 'Alətlər';
$_lang["top_howmany_message"] = 'Hesabatlara baxarkən "Ən yaxşı ..." siyahıları neçə elementdən ibarət olmalıdır?';
$_lang["top_howmany_title"] = 'Ən yaxşı neçə';
$_lang["total"] = 'ümumi';
$_lang["track_visitors_message"] = 'Sənəd ağacında alt resursları göstərmək üçün işarələyin';
$_lang["track_visitors_title"] = 'Alt resursları göstər';
$_lang["tree_page_click"] = 'Səhifə klik davranışı';
$_lang["tree_page_click_message"] = 'Sayt ağacında səhifəyə klikləyərkən standart davranış.';
$_lang["use_breadcrumbs"] = 'Naviqasiyanı göstər';
$_lang["use_breadcrumbs_message"] = 'İdarəetmə panelində resurs yaradarkən və ya redaktə edərkən naviqasiyanı göstər';
$_lang["tree_show_protected"] = 'Qorunan səhifələri göstər';
$_lang["tree_show_protected_message"] = '"Xeyr" olaraq təyin edildikdə, qorunan resurslar (və onların bütün alt resursları) sayt ağacında görünməyəcək. "Xeyr" Evolution CMS üçün standart ayardır.';
$_lang["truncate_table"] = 'Bu cədvəli sıfırlamaq üçün buraya klikləyin';
$_lang["type"] = 'Növ';
$_lang["udperms_allowroot_message"] = 'İstifadəçilərə saytın kök qovluğunda yeni resurslar yaratmağa icazə verin.';
$_lang["udperms_allowroot_title"] = 'Kök qoğvuğa müdaxilə etmək üçün icazə ver';
$_lang["udperms_message"] = 'İstifadəçilərin Resurslara girişini İstifadəçi Qrupları və Resurs Qrupları vasitəsilə idarə edin.';
$_lang["udperms_title"] = 'Giriş icazələrindən istifadə et';
$_lang["unable_set_link"] = 'Bağlantını təyin etmək mümkün olmadı!';
$_lang["unable_set_parent"] = 'Yeni valideyn təyin etmək mümkün olmadı!';
$_lang["unauthorizedpage_message"] = 'İstifadəçilər qorunan/qeyri-avtorizasiya olunmuş resursa daxil olduqda onları yönləndirmək üçün dərc olunmuş və açıq bir resursun ID-sini daxil edin.';
$_lang["unauthorizedpage_title"] = 'İcazəsiz səhifə';
$_lang["unblock_message"] = 'Bu istifadəçi məlumatları yadda saxlandıqdan sonra bloklanmayacaq.';
$_lang["undelete_resource"] = 'Resursu bərpa et';
$_lang["unpublish_date"] = 'Dərc edilmə tarixi';
$_lang["unpublish_events"] = 'Dərc edilməmiş hadisələr';
$_lang["unpublish_resource"] = 'Resursu dərc etməyi dayandır';
$_lang["untitled_resource"] = 'Adsız Resurs';
$_lang["untitled_weblink"] = 'Adsız Veb bağlantı';
$_lang["update_params"] = 'Parametrlərin görünüşünü yenilə';
$_lang["update_settings_from_language"] = 'Cari dili bununla əvəz et:';

$_lang["upload_maxsize_message"] = 'Fayl meneceri vasitəsilə yüklənə bilən maksimum fayl ölçüsünü daxil edin. Yüklənəcək fayl ölçüsü baytlarda göstərilməlidir. <b>QEYD: Böyük faylların yüklənməsi çox uzun çəkə bilər!</b>';
$_lang["upload_maxsize_title"] = 'Maksimum yükləmə ölçüsü';
$_lang["uploadable_files_message"] = '\'assets/files/\' qovluğuna Fayl Brauzeri vasitəsilə yüklənə bilən faylların siyahısını daxil edin. Fayl tiplərinin uzantılarını vergüllə ayıraraq yazın.';
$_lang["uploadable_files_title"] = 'Yüklənə bilən fayl tipləri';
$_lang["uploadable_flash_message"] = '\'assets/flash/\' qovluğuna Fayl Brauzeri vasitəsilə yüklənə bilən flash faylların siyahısını daxil edin. Flash fayl tiplərinin uzantılarını vergüllə ayıraraq yazın.';
$_lang["uploadable_flash_title"] = 'Yüklənə bilən Flash tipləri';
$_lang["uploadable_images_message"] = '\'assets/images/\' qovluğuna Fayl Brauzeri vasitəsilə yüklənə bilən şəkil fayllarının siyahısını daxil edin. Şəkil tiplərinin uzantılarını vergüllə ayıraraq yazın.';
$_lang["uploadable_images_title"] = 'Yüklənə bilən Şəkil tipləri';
$_lang["uploadable_media_message"] = '\'assets/media/\' qovluğuna Fayl Brauzeri vasitəsilə yüklənə bilən media fayllarının siyahısını daxil edin. Media tiplərinin uzantılarını vergüllə ayıraraq yazın.';
$_lang["uploadable_media_title"] = 'Yüklənə bilən Media tipləri';
$_lang["use_alias_path_message"] = 'Bu seçim aktivləşdirildikdə, Resursa virtual yol yaradılır. Məsələn, əgər "child.html" Resursu "parent" adlı Konteyner Resursun içindədirsə, onda tam URL alias yolu "/parent/child.html" olacaq.';
$_lang["use_alias_path_title"] = 'Dost URL alias yolundan istifadə et';
$_lang["use_editor_message"] = 'Mətnin Redaktor (RTE) ilə redaktəsini aktiv edin. Bu parametr bütün Resurslar üçün keçərlidir, lakin İstifadəçi ayarlarında dəyişdirilə bilər.';
$_lang["use_editor_title"] = 'Redaktoru aktiv et';
$_lang["use_global_tabs"] = 'Qlobal Tab-lardan istifadə et';

$_lang["valid_hostnames_message"] = 'Saytın "site_url" ayarını səhv istifadədən qorumaq üçün etibarlı host adlarını vergüllə ayıraraq daxil edin. Bu, bəzi ortaq hostlar və ya birbaşa IP vasitəsilə əldə edilə bilən hostlar üçün vacibdir. Siyahıda ilk hostname, HTTP_HOST heç bir etibarlı hostname ilə uyğun gəlmədikdə istifadə olunur.';
$_lang["valid_hostnames_title"] = 'Etibarlı host adları';
$_lang["validate_referer_message"] = 'Menecerdə məzmun redaktorlarının CSRF (Cross Site Request Forgery) hücumlarının qurbanına çevrilməsinin qarşısını almaq üçün HTTP_REFERER başlıqlarını doğrulayın. Bəzi server ayarları bu seçimdən istifadə edə bilməyə bilər, əgər HTTP_REFERER başlıqları göndərilmirsə.';
$_lang["validate_referer_title"] = 'HTTP_REFERER başlıqlarını doğrula?';
$_lang["value"] = 'Dəyər';
$_lang["version"] = 'Versiya';
$_lang["view"] = 'Baxış';
$_lang["view_child_resources_in_container"] = 'Alt resurslara bax';
$_lang["view_log"] = 'Jurnala bax';
$_lang["view_logging"] = 'Menecer Fəaliyyətləri';
$_lang["view_sysinfo"] = 'Sistem Məlumatı';
$_lang["warning"] = 'Xəbərdarlıq!';
$_lang["warning_not_saved"] = 'Dəyişiklikləriniz hələ saxlanılmayıb. Dəyişiklikləri saxlamaq üçün cari səhifədə qala (\'Ləğv et\'), və ya səhifəni tərk edərək dəyişiklikləri itirə bilərsiniz (\'OK\').';
$_lang["warning_visibility"] = 'Konfiqurasiya xəbərdarlıqlarını kimlər görəcək';
$_lang["warning_visibility_message"] = 'Menecerin giriş səhifəsində göstərilən konfiqurasiya xəbərdarlıqlarının görünüşünü idarə edin';
$_lang["web_access_permissions"] = 'Giriş icazələri';
$_lang["web_access_permissions_user_groups"] = 'İstifadəçi qrupları';
$_lang["web_permissions"] = 'İcazələr';
$_lang["web_user_management_msg"] = 'Redaktə etmək istədiyiniz İstifadəçini seçin. İstifadəçilər sayta və menecerə daxil ola bilən şəxslərdir.';
$_lang["web_user_management_title"] = 'İstifadəçilər';
$_lang["web_user_management_select_role"] = 'Bütün rollar';
$_lang["web_user_title"] = 'İstifadəçi yarat/redaktə et';
$_lang["web_users"] = 'İstifadəçilər';
$_lang["weblink"] = 'Weblink';
$_lang["webpwdreminder_message"] = 'İstifadəçilər yeni şifrə tələb etdikdə göndəriləcək mesajı daxil edin. Menecer istifadəçinin yeni şifrəsi və aktivasiya məlumatlarını göndərəcək.<br /><b>Qeyd:</b> Aşağıdakı dəyişənlər mesaj göndərilərkən avtomatik əvəzlənir:<br /><br />[+sname+] - Saytın adı, <br />[+saddr+] - Saytın e-poçt ünvanı, <br />[+surl+] - Saytın URL-i, <br />[+uid+] - İstifadəçinin giriş adı və ya ID-si, <br />[+pwd+] - İstifadəçinin şifrəsi, <br />[+ufn+] - İstifadəçinin tam adı. <br />[+u_first_name+] - İstifadəçinin adı. <br />[+u_last_name+] - İstifadəçinin soyadı. <br />[+u_middle_name+] - İstifadəçinin ata adı. <br /><br /><b>[+uid+] və [+pwd+] dəyişənlərini e-poçtda saxlayın, əks halda istifadəçilər öz giriş adlarını və şifrələrini bilməyəcəklər!</b>';
$_lang["webpwdreminder_title"] = 'Veb Xatırlatma E-poçtu';
$_lang["websignupemail_message"] = 'İstifadəçi hesabı yaradıldıqda istifadəçilərə göndərilən mesajı daxil edin.<br /><b>Qeyd:</b> Aşağıdakı dəyişənlər mesaj göndərilərkən avtomatik əvəzlənir:<br /><br />[+sname+] - Saytın adı, <br />[+saddr+] - Saytın e-poçt ünvanı, <br />[+surl+] - Saytın URL-i, <br />[+uid+] - İstifadəçinin giriş adı və ya ID-si, <br />[+pwd+] - İstifadəçinin şifrəsi, <br />[+ufn+] - İstifadəçinin tam adı.<br /><br /><b>[+uid+] və [+pwd+] dəyişənlərini e-poçtda saxlayın, əks halda istifadəçilər öz giriş adlarını və şifrələrini bilməyəcəklər!</b>';
$_lang["websignupemail_title"] = 'Veb Qeydiyyat E-poçtu';
$_lang["allow_multiple_emails_title"] = 'Təkrarlanan Veb İstifadəçi e-poçtu';
$_lang["allow_multiple_emails_message"] = 'Veb İstifadəçilərin eyni e-poçt ünvanını paylaşmasına icazə verin. <br/>Qeyd: Şifrə xatırlatma və qeydiyyat prosesləri bu seçimə uyğunlaşdırılmalıdır.';
$_lang["welcome_title"] = 'Evolution CMS Menecerinə xoş gəldiniz';
$_lang["which_editor_message"] = 'İstifadə olunacaq mətn redaktorunu seçin.';
$_lang["which_editor_title"] = 'İstifadə ediləcək redaktor';
$_lang["working"] = 'İşlənir...';
$_lang["wrap_lines"] = 'Sətirləri bük';
$_lang["xhtml_urls_message"] = 'Evolution CMS tərəfindən yaradılan URL-lərdə ampersand (&) işarəsini &amp;<!-- -->amp; ilə əvəz edin.';
$_lang["xhtml_urls_title"] = 'XHTML URL-lər';
$_lang["yes"] = 'Bəli';
$_lang["you_got_mail"] = 'Sizə məktub gəldi';

$_lang["yourinfo_message"] = 'Bu bölmə sizin haqqınızda bəzi məlumatları göstərir:';
$_lang["yourinfo_previous_login"] = 'Son girişiniz:';
$_lang["yourinfo_role"] = 'Rolunuz:';
$_lang["yourinfo_title"] = 'Məlumatınız';
$_lang["yourinfo_total_logins"] = 'Ümumi giriş sayı:';
$_lang["yourinfo_username"] = 'Siz daxil olmusunuz:';

$_lang["a17_error_reporting_title"] = 'PHP səhv aşkarlama səviyyəsi';
$_lang["a17_error_reporting_msg"] = 'PHP səhvlərinin aşkarlama səviyyəsini təyin edin.';
$_lang["a17_error_reporting_opt0"] = 'Bütün səhvləri görməzlikdən gəl';
$_lang["a17_error_reporting_opt1"] = 'Yüngül xəbərdarlıqları nəzərə alma (<a href="https://www.google.com/search?q=E_DEPRECATED+E_STRICT" target="_blank">E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT</a>)';
$_lang["a17_error_reporting_opt2"] = 'E_NOTICE və E_USER_DEPRECATED istisna olmaqla bütün səhvləri aşkarlayın';
$_lang["a17_error_reporting_opt99"] = 'E_USER_DEPRECATED istisna olmaqla bütün səhvləri aşkarlayın';
$_lang["a17_error_reporting_opt199"] = 'Bütün səhvləri aşkarlayın';

$_lang["pwd_hash_algo_title"] = 'Şifrələmə alqoritmi';
$_lang["pwd_hash_algo_message"] = 'Şifrə üçün istifadə edilən şifrələmə alqoritmi.';

$_lang["enable_bindings_title"] = '@Bindings əmrlərini aktiv et';
$_lang["enable_bindings_message"] = 'TV @Bindings vasitəsilə PHP funksiyalarının icrasını qarşısını alır. Bu, PHP kodu yaratmağa icazə verilməyən, lakin TV-ləri yaratmaq və redaktə etmək imkanına malik olan idarəçilər üçün faydalıdır. @Binding olan istənilən TV-nin çıxışı "@Bindings deaktiv edilib" olacaq.';
$_lang["enable_filter_title"] = 'Filtrləri aktiv et';
$_lang["enable_filter_message"] = 'Filtrlər, verilənlərin təqdim edilmə və ya emal olunma tərzini dəyişməyə imkan verir. Onlar şablonlarınızda dəyərləri dəyişdirməyə imkan yaradır. Bu, PHx-ə bənzəyir. <a href="https://github.com/modxcms/evolution/issues/623" target="ext_help">Ətraflı məlumat</a>';
$_lang["enable_filter_phx_warning"] = 'PHx plaqini aktiv olduqda, daxili filtrlər standart olaraq deaktiv edilir.';

$_lang["enable_at_syntax_title"] = '&lt;@SYNTAX&gt; aktiv et';
$_lang["enable_at_syntax_message"] = '&lt;@SYNTAX&gt; (at işarəsi sintaksisi) sadə və yüngül çəkiyə malik şablon sintaksisidir. Bu, HTML teqləri və məzmun sətirləri ilə birgə istifadəni nəzərə alaraq hazırlanmışdır.';

$_lang["bkmgr_alert_mkdir"] = 'Fayl müvafiq qovluqda yaradılmadı. Lütfən, [+snapshot_path+] qovluğunun icazələrini yoxlayın.';
$_lang["bkmgr_restore_msg"] = '<p>Verilənlər bazası cədvəlləri SQL ilə bərpa edilə bilər:</p>';
$_lang["bkmgr_restore_title"] = 'Bərpa et';
$_lang["bkmgr_import_ok"] = 'SQL bərpa prosesi uğurla başa çatdı.';
$_lang["bkmgr_snapshot_ok"] = 'Sürətli yaddaş (snapshot) uğurla yadda saxlanıldı.';
$_lang["bkmgr_run_sql_file_label"] = 'SQL faylı ilə icra et';
$_lang["bkmgr_run_sql_direct_label"] = 'Birbaşa SQL əmrlərini icra et';
$_lang["bkmgr_run_sql_submit"] = 'Bərpa əməliyyatını icra et';
$_lang["bkmgr_run_sql_result"] = 'Nəticə';
$_lang["bkmgr_snapshot_title"] = 'Sürətli yaddaş (snapshot) saxlama və bərpa';
$_lang["bkmgr_snapshot_msg"] = '<p>Verilənlər bazasının məzmunu server qovluğunda saxlanılır və oradan bərpa olunur.<br />Yerləşmə yeri: [+snapshot_path+] ($modx->config[\'snapshot_path\'])</p>';
$_lang["bkmgr_snapshot_submit"] = 'Sürətli yaddaş əlavə et';
$_lang["bkmgr_snapshot_list_title"] = 'Sürətli yaddaşların siyahısı';
$_lang["bkmgr_restore_submit"] = 'Bu məlumatları bərpa et';
$_lang["bkmgr_restore_confirm"] = 'Siz həqiqətən backup-u bərpa etmək istəyirsiniz?\n[+filename+] ?';
$_lang["bkmgr_snapshot_nothing"] = 'Mövcud sürətli yaddaş (snapshot) yoxdur.';

$_lang["files.dynamic.php1"] = 'Yeni fayl';
$_lang["files.dynamic.php2"] = 'Bu qovluq göstərilə bilmir.';
$_lang["files.dynamic.php3"] = 'Fayl adında problem var.';
$_lang["files.dynamic.php4"] = 'Mətn faylı yaradıldı.';
$_lang["files.dynamic.php5"] = 'Fayl dublikat edilə bilmədi.';
$_lang["files.dynamic.php6"] = 'Fayl və ya qovluq dəyişdirilə bilmədi.';
$_lang["files_dynamic_new_folder_name"] = 'Yeni qovluq adını daxil edin:';
$_lang["files_dynamic_new_file_name"] = 'Yeni fayl adını daxil edin:';
$_lang["not_readable_dir"] = 'Bu qovluq oxuna bilmir.';
$_lang["confirm_delete_dir"] = 'Bu qovluğu silmək istədiyinizə əminsiniz?';
$_lang["confirm_delete_dir_recursive"] = 'Bu qovluğu həqiqətən silmək istəyirsiniz?\n\nBu qovluğun içindəki bütün fayllar da silinəcəkdir.';

$_lang["make_folders_title"] = 'Konteyner URL-lərini sonuna slash əlavə et';
$_lang["make_folders_message"] = 'Friendly URLs istifadə edərkən konteyner kimi təyin olunmuş Resurslara slash əlavə et.';

$_lang["check_files_onlogin_title"] = 'Daxil olduqda əsas faylları yoxla';
$_lang["check_files_onlogin_message"] = 'Bu seçimi aktiv etdikdə, əsas sistem faylları zərərli hücumların olub-olmaması üçün yoxlanacaq. Bu, tam qoruma təmin etməsə də, Evolution CMS fayllarında və veb saytınızda dəyişikliklər olub-olmadığını xəbərdar edə bilər.';

$_lang["configcheck_sysfiles_mod"] = 'Əsas sistem fayllarında dəyişiklik edilib.';
$_lang["configcheck_sysfiles_mod_msg"] = 'Siz Evolution CMS-i əsas sistem fayllarını yoxlamaq üçün konfiqurasiya etmisiniz. Bu xəbərdarlıq mütləq saytınıza müdaxilə edildiyini göstərmir, lakin quraşdırmadakı izlənilən faylları nəzərdən keçirməlisiniz (Sistem konfiqurasiyası -> İstifadəçi -> Daxil olarkən əsas faylları yoxla). Əgər dəyişikliklər administratorlar tərəfindən edilmişsə, bu bildirişi ləğv etmək üçün Sistem Konfiqurasiyasına gedib parametrləri yenidən qeyd edin. Aşağıdakı fayllarda dəyişikliklər tapıldı:';

$_lang['email_method_title'] = 'E-poçt göndərmə metodu';
$_lang['email_method_mail'] = 'PHP mail() funksiyası';
$_lang['email_method_smtp'] = 'SMTP Server';
$_lang['smtp_auth_title'] = 'SMTP-AUTH';
$_lang['smtp_autotls_title'] = 'SMTPAutoTLS';
$_lang['smtp_host_title'] = 'SMTP host';
$_lang['smtp_secure_title'] = 'Şifrəli SMTP';
$_lang['smtp_username_title'] = 'SMTP istifadəçi adı';
$_lang['smtp_password_title'] = 'SMTP şifrəsi';
$_lang['smtp_port_title'] = 'SMTP portu';

$_lang["setting_resource_tree_node_name"] = 'Resurs ağacında göstərilən ad';
$_lang["setting_resource_tree_node_name_desc"] = 'Resurs ağacında Resurs adını göstərmək üçün Resurs sahəsini seçin. Standart ayar "səhifə adı"dır.';
$_lang["setting_resource_tree_node_name_desc_add"] = 'Qeyd: Evolution CMS 1.1-dən etibarən bu göstərilən adı Resurs ağacında çeşidləmə seçimi vasitəsilə dəyişə bilərsiniz. Bu ayar, "Resurs ağacında göstərilən ad" "Standart" olaraq təyin edildikdə istifadə olunur.';

$_lang["resource_opt_alvisibled"] = 'Cari aliası alias yolunda istifadə et';
$_lang["resource_opt_alvisibled_help"] = 'Bu resursun aliası Dost URL alias yoluna daxil edilir.';
$_lang['resource_opt_is_published'] = 'Nəşr olunub';

$_lang["enable_cache_title"] = 'Sənəd keşi';
$_lang["disable_chunk_cache_title"] = 'Chunk keşini deaktiv et';
$_lang["disable_snippet_cache_title"] = 'Snippet keşini deaktiv et';
$_lang["disable_plugins_cache_title"] = 'Plaqin keşini deaktiv et';
$_lang["disabled_at_login"] = 'Giriş zamanı deaktiv edilir';

$_lang["cache_type_title"] = 'Sənəd keşi növü';
$_lang["cache_type_1"] = 'Keş yalnız Resurs ID-si əsasında aparılır (standart)';
$_lang["cache_type_2"] = 'Keş Resurs ID-si və $_GET parametrləri əsasında aparılır';
$_lang["seostrict_title"] = 'SEO Sərt URL-lərdən istifadə et';
$_lang["seostrict_message"] = 'Dublikat məzmunun qarşısını almaq üçün sərt URL-lərdən istifadəni məcbur edir (lazım gələrsə).';

$_lang["alias_listing_title"] = 'AliasListing keşini istifadə et';
$_lang["alias_listing_message"] = 'Səhifə aliaslarını keşləmək, əgər saytda çoxlu resurs varsa, deaktiv edilməlidir. "Deaktiv edildi" seçimi, saytda çox sayda resurs olduqda yaddaş istifadəsini azaldır.';
$_lang["alias_listing_disabled"] = 'Deaktiv edildi';
$_lang["alias_listing_folders"] = 'Yalnız qovluqlar üçün';
$_lang["alias_listing_enabled"] = 'Aktiv edildi';

$_lang["settings_friendlyurls_alert"] = 'Dost URL funksiyasını istifadə etmək üçün Evolution CMS quraşdırma qovluğundakı "ht.access" faylını ".htaccess" olaraq dəyişmək lazımdır.';
$_lang["settings_friendlyurls_alert2"] = 'Evolution CMS alt qovluqda quraşdırıldığı üçün, ".htaccess" məzmununu dəyişdirmək lazımdır.';

$_lang["mutate_settings.dynamic.php6"] = 'Evolution CMS xətalarına dair e-poçt göndər';
$_lang["mutate_settings.dynamic.php7"] = 'Bildirmə';
$_lang["mutate_settings.dynamic.php8"] = 'Əgər Evolution CMS xətası baş verərsə, [(emailsender)] ([+emailsender+]) ünvanına səhvin mənbəyi barədə e-poçt göndəriləcək. Xətanın detalları Evolution CMS hadisələr jurnalında görülə bilər.';

$_lang["error_no_privileges"] = "Bu əməliyyat üçün kifayət qədər səlahiyyətiniz yoxdur!";
$_lang["error_no_optimise_tablename"] = "Optimallaşdırılacaq cədvəl sorğuda tapılmadı!";
$_lang["error_no_truncate_tablename"] = "Boşaldılacaq cədvəl sorğuda tapılmadı!";
$_lang["error_double_action"] = "İkiqat əməliyyat (GET & POST) göndərildi!";
$_lang["error_no_id"] = "Sorğuda ID göndərilməyib!";
$_lang["error_id_nan"] = "Sorğuda göndərilən ID rəqəm deyil!";
$_lang["error_parent_deleted"] = "Əməliyyat uğursuz oldu, çünki resursun üst resursu silinib!";
$_lang["error_no_parent"] = "Üst resursun adını tapmaq mümkün olmadı!";
$_lang["error_many_results"] = "Məlumat bazasından çoxlu nəticə qaytarıldı!";
$_lang["error_no_results"] = "Məlumat bazasından kifayət qədər nəticə qaytarılmadı!";
$_lang["error_no_user_selected"] = "Bu mesaj üçün istifadəçi seçilməyib!";
$_lang["error_no_group_selected"] = "Bu mesaj üçün qrup seçilməyib!";
$_lang["error_movedocument1"] = "Sənəd özünün üst resursu ola bilməz!";
$_lang["error_movedocument2"] = "Sənədin ID-si sorğuda göndərilməyib!";
$_lang["error_movedocument3"] = "Yeni üst resurs sorğuda təyin edilməyib!";
$_lang["error_internet_connection"] = "Server əlçatan deyil. İnternet bağlantınızı yoxlayın!";

$_lang["login_processor_unknown_user"] = "Daxil edilən istifadəçi adı və ya şifrə yanlışdır!";
$_lang["login_processor_wrong_password"] = "Daxil edilən istifadəçi adı və ya şifrə yanlışdır!";
$_lang["login_processor_many_failed_logins"] = "Çox uğursuz giriş cəhdinə görə hesabınız bloklanıb!";
$_lang["login_processor_verified"] = "İstifadəçi doğrulaması tələb olunur!";
$_lang["login_processor_blocked1"] = "Siz bloklandınız və giriş edə bilməzsiniz!";
$_lang["login_processor_blocked2"] = "Siz bloklandınız və giriş edə bilməzsiniz! Zəhmət olmasa, sonra yenidən cəhd edin.";
$_lang["login_processor_blocked3"] = "Təyin olunmuş tarixdən sonra avtomatik olaraq bloklandınız və artıq giriş edə bilməzsiniz!";
$_lang["login_processor_bad_code"] = "Daxil etdiyiniz təhlükəsizlik kodu düzgün deyil! Zəhmət olmasa, yenidən giriş etməyə çalışın!";
$_lang["login_processor_remotehost_ip"] = "Host adınız IP adresinizə uyğun gəlmir!";
$_lang["login_processor_remote_ip"] = "Bu yerdən giriş etməyə icazəniz yoxdur.";
$_lang["login_processor_date"] = "Bu vaxtda giriş etməyə icazəniz yoxdur. Zəhmət olmasa, sonra yenidən cəhd edin.";
$_lang["login_processor_captcha_config"] = "Captcha düzgün konfiqurasiya edilməyib.";

$_lang["dp_dayNames"] = "['Bazar', 'Bazar ertəsi', 'Çərşənbə axşamı', 'Çərşənbə', 'Cümə axşamı', 'Cümə', 'Şənbə']";
$_lang["dp_monthNames"] = "['Yanvar', 'Fevral', 'Mart', 'Aprel', 'May', 'İyun', 'İyul', 'Avqust', 'Sentyabr', 'Oktyabr', 'Noyabr', 'Dekabr']";
$_lang["dp_startDay"] = "1";

$_lang["check_all"] = "Hamısını seç";
$_lang["check_none"] = "Heç birini seçmə";
$_lang["check_toggle"] = "Seçimi dəyiş";

$_lang["version_notices"] = "Versiya Bildirişləri";

$_lang["em_button_shift"] = " (Bir neçə pəncərəni açmaq üçün Shift+siçan klikləyin)";

$_lang["reset_sysfiles_checksum_button"] = "Nəzarət məbləğini yenidən qur";
$_lang["reset_sysfiles_checksum_alert"] = "Sistem fayllarının nəzarət məbləğini sıfırlamaq istədiyinizə əminsinizmi?";

$_lang["file_browser_disabled_msg"] = "Fayl Brauzeri funksiyası aktiv deyil.";
$_lang["which_browser_default_title"] = "Standart Fayl Brauzeri";
$_lang["which_browser_default_msg"] = "İstifadə etmək istədiyiniz standart fayl brauzerini seçin. İstifadəçi parametrlərində hər bir istifadəçi üçün fərdi brauzer təyin edə bilərsiniz və ya \"standart\" olaraq buraxa bilərsiniz.";
$_lang["which_browser_title"] = "Fayl Brauzeri";
$_lang["which_browser_msg"] = "Bu istifadəçi üçün fərdi fayl brauzeri seçə bilərsiniz. Sistem brauzerindən istifadə etmək üçün \"Standart\" seçimini buraxın.";
$_lang["option_default"] = "Standart";
$_lang["position"] = "Mövqe";
$_lang["are_you_sure"] = "Əminsinizmi?";

$_lang['evo_downloads_title'] = "Evolution CMS Yükləmələri";
$_lang['help_translating_title'] = "Evolution CMS-in tərcüməsinə kömək edin";
$_lang['download'] = "Yüklə";
$_lang['downloads'] = "Yükləmələr";
$_lang["previous_releases"] = "Əvvəlki Buraxılışlar";
$_lang["extras"] = "Əlavələr";

$_lang["display_locks"] = "Bloklamaları göstər";
$_lang["role_display_locks"] = "Bloklamaları göstər";
$_lang["session_timeout"] = "Sessiya vaxtı bitməsi";
$_lang["session_timeout_msg"] = "Evolution CMS serverə siqnal göndərəcək, əgər son siqnal bu parametri keçərsə, müvafiq sessiya etibarsız hesab ediləcək və bütün əlaqəli bloklar avtomatik silinəcəkdir. Dəyəri dəqiqələrlə təyin edin (>2 dəq, standart 15 dəq).";
$_lang["unlock_element_id_warning"] = "Bu [+element_type+] (ID [+id+]) kilidini açmaq istədiyinizə əminsinizmi?";
$_lang["lock_element_type_1"] = "Şablon";
$_lang["lock_element_type_2"] = "Şablon Dəyişəni";
$_lang["lock_element_type_3"] = "Chunk";
$_lang["lock_element_type_4"] = "Snippet";
$_lang["lock_element_type_5"] = "Plaqin";
$_lang["lock_element_type_6"] = "Modul";
$_lang["lock_element_type_7"] = "Resurs";
$_lang["lock_element_type_8"] = "Rol";
$_lang["lock_element_editing"] = "Siz bu [+element_type+] üzərində redaktə edirsiniz\n[+lasthit_df+] tarixindən bəri";
$_lang["lock_element_locked_by"] = "Bu [+element_type+] istifadəçi tərəfindən bloklanıb\n[+username+] tarixindən bəri [+lasthit_df+]";

$_lang["minifyphp_incache_title"] = 'PHP kodunu saytın keşində sıxlaşdır';
$_lang["minifyphp_incache_message"] = 'PHP kodunu (snippet və plaqinlər) sıxlaşdır və sayt keş faylında saxla, ref:<a href="https://github.com/modxcms/evolution/issues/938" target="_blank">#938</a>';

$_lang["logout_reminder_msg"] = "Xəbərdarlıq: [+date+] tarixində çıxış etməyi unutduğunuz görünür. Zəhmət olmasa, gələcəkdə buna diqqət edin və işinizi bitirdikdən sonra çıxış edin.";

$_lang["allow_eval_title"] = "Snippet çağırışlarında PHP kodunu icra et";
$_lang["allow_eval_msg"] = "Tərtibatçılar üçün: Zəhmət olmasa, \$modx-&gt;safeEval() istifadə edin.";
$_lang["allow_eval_with_scan"] = "Yalnız icazə verilən funksiyaları icra et";
$_lang["allow_eval_with_scan_at_post"] = "Hamısını icra et, lakin POST zamanı yalnız icazə verilən funksiyalar";
$_lang["allow_eval_everytime_eval"] = "Limitsiz (yalnız debugging üçün istifadə edin)";
$_lang["allow_eval_dont_eval"] = "Bütün funksiyaları icra etməyə icazə vermə";

$_lang["safe_functions_at_eval_title"] = "Eval üçün icazə verilən funksiyalar";
$_lang["safe_functions_at_eval_msg"] = "Vergüllə ayrılmış siyahı";

$_lang["multiple_sessions_msg"] = "Məlumat: <b>[+username+]</b> istifadəçisinin bir neçə aktiv sessiyası (cəmi [+total+]) tapıldı.";
$_lang["iconv_not_available"] = "Iconv genişlənməsinin quraşdırılması / aktiv edilməsi vacibdir. Aktivləşdirmə qaydasını bilmirsinizsə, host xidmətinizlə əlaqə saxlayın.";

$_lang["cm_create_new_category"] = "Yeni kateqoriya yaradın";
$_lang["cm_category_name"] = "Kateqoriya adı";
$_lang["cm_category_position"] = "Kateqoriya mövqeyi";
$_lang["cm_no_x_assigned"] = "%s təyin edilməyib";
$_lang["cm_save_categorization"] = "Kateqoriyanı yadda saxla";
$_lang["cm_update_categories"] = "Kateqoriyaları yenilə";
$_lang["cm_assigned_elements"] = "Təyin edilmiş elementlər";
$_lang["cm_edit_name"] = "Adı redaktə et";
$_lang["cm_mark_for_deletion"] = "Silinmə üçün işarələyin";
$_lang["cm_delete_now"] = "İndi sil";
$_lang["cm_delete_element_x_now"] = "&quot;%s&quot;-ni dərhal sil";
$_lang["cm_select_element_group"] = "Element qrupunu seçin";
$_lang["cm_global_messages"] = "Qlobal Mesajlar";
$_lang["cm_add_new_category"] = "Yeni kateqoriya əlavə et";
$_lang["cm_edit_categories"] = "Kateqoriyaları redaktə et";
$_lang["cm_sort_categories"] = "Kateqoriyaları sıralayın";
$_lang["cm_categorize_elements"] = "Elementləri kateqoriyaya ayırın";
$_lang["cm_translation"] = "Tərcümə";
$_lang["cm_translations"] = "Tərcümələr";
$_lang["cm_categorize_x"] = "<span class=\"highlight\">%s</span>-ni kateqoriyaya ayırın";
$_lang["cm_unknown_error"] = "Bir problem baş verdi.";
$_lang["cm_x_assigned_to_category_y"] = "<span class=\"highlight\">%s(%s)</span> kateqoriyasına <span class=\"highlight\">%s(%s)</span> təyin edildi";
$_lang["cm_no_categorization"] = "Kateqoriyaya ayırma yoxdur.";
$_lang["cm_no_changes"] = "Dəyişiklik yoxdur, ona görə də heç bir dəyişiklik edilmədi.";
$_lang["cm_x_changes_made"] = "<span class=\"highlight\">%s</span> dəyişiklik edilib";
$_lang["cm_enter_name_for_category"] = "Zəhmət olmasa, yeni kateqoriya üçün ad daxil edin.";
$_lang["cm_category_x_exists"] = "Kateqoriya <span class=\"highlight\">%s</span> artıq mövcuddur.";
$_lang["cm_category_x_saved_at_position_y"] = "Yeni kateqoriya <span class=\"highlight\">%s</span> mövqeyində <span class=\"highlight\">%s</span> yadda saxlanıldı.";
$_lang["cm_category_x_moved_to_position_y"] = "Kateqoriya <span class=\"highlight\">%s</span> mövqeyinə <span class=\"highlight\">%s</span> köçürüldü";
$_lang["cm_category_x_deleted"] = "Kateqoriya <span class=\"highlight\">%s</span> silindi";
$_lang["cm_category_x_renamed_to_y"] = "Kateqoriya <span class=\"highlight\">%s</span> <span class=\"highlight\">%s</span> olaraq adlandırıldı";
$_lang["cm_translation_for_x_empty"] = "<span class=\"highlight\">%s</span> üçün tərcümə boşdur";
$_lang["cm_translation_for_x_to_y_success"] = "<span class=\"highlight\">%s</span>-nin <span class=\"highlight\">%s</span>-ə tərcüməsi uğurla yadda saxlanıldı";
$_lang["cm_save_new_sorting"] = "Yeni sıralamayı yadda saxla";
$_lang["cm_translate_phrases"] = "İfadələri tərcümə et";
$_lang["cm_translate_module_phrases"] = "Modul ifadələrini tərcümə et";
$_lang["cm_native_phrase"] = "Yerli ifadə";

$_lang["btn_view_options"] = 'Seçimləri Görüntüləyin';
$_lang["view_options_msg"] = 'Elementlərin göstərilməsi və siyahısı "Seçimlər" düyməsi ilə özelleştirilebilir. Parametrlər HTML5-in localStorage istifadə edərək brauzerə görə saxlanılır və bərpa olunur.';
$_lang["viewopts_title"] = 'Seçimlər';
$_lang["viewopts_cb_buttons"] = 'Düymələr';
$_lang["viewopts_cb_descriptions"] = 'Təsvirlər';
$_lang["viewopts_cb_icons"] = 'İkonlar';
$_lang["viewopts_radio_list"] = 'Siyahı';
$_lang["viewopts_radio_inline"] = 'Sıra ilə';
$_lang["viewopts_radio_flex"] = 'Flex';
$_lang["viewopts_fontsize"] = 'Şrift ölçüsü';
$_lang["viewopts_cb_alltabs"] = 'Bütün tablar';

$_lang['email_sender_method'] = 'Mesajın göndərən ünvani';
$_lang['auto'] = 'Avtomatik tanıma';
$_lang['use_emailsender'] = '[(emailsender)] dəyərini istifadə et';
$_lang['email_sender_method_message'] = 'Mesajın göndərən ünvani. Bu, adətən alınan tərəf tərəfindən Return-Path başlığına çevriləcək və geri dönən mesajlar bu ünvana göndəriləcək. Avtomatik tanıma əksər hallarda işləyir.';

$_lang['login_form_position_title'] = 'Daxil olma forması mövqeyi';
$_lang['login_form_position_left'] = 'sol';
$_lang['login_form_position_center'] = 'mərkəz';
$_lang['login_form_position_right'] = 'sağ';
$_lang["login_form_style"] = 'Daxil olma forması üslubu:';
$_lang["login_form_style_dark"] = 'qaranlıq';
$_lang["login_form_style_light"] = 'açıq';
$_lang['login_logo_title'] = 'Daxil olma səhifəsi loqosu';
$_lang['login_logo_message'] = 'Tövsiyə olunan daxil olma loqosu şəkil eni: 360px, tip .png';
$_lang['login_bg_title'] = 'Daxil olma səhifəsinin fon şəkli';
$_lang['login_bg_message'] = 'Tövsiyə olunan daxil olma səhifəsi fon şəkli eni: 1920px';

$_lang['manager_menu_position_title'] = 'Əsas menyu mövqeyi';
$_lang['manager_menu_position_top'] = 'yuxarı';
$_lang['manager_menu_position_left'] = 'sol';

$_lang['invalid_event_response'] = '%s hadisəsinin etibarsız çıxışı var';

$_lang['chunk_processor'] = 'Chunk-ların emalı sinfi';

$_lang["permission_title"] = 'İcazə yarat / redaktə et';
$_lang["groups_permission_title"] = 'Kateqoriya yarat / redaktə et';
$_lang["lang_key_desc"] = '$_lang massivindən dil açarı';
$_lang["key_desc"] = 'Seçilmiş icazə üçün açar';

$_lang["setting_from_file"] = '<strong class="text-danger">Parametr dəyəri core/custom/config/cms/settings-də müəyyən edilib</strong>';
$_lang['disable'] = 'Deaktiv et';
$_lang['enable'] = 'Aktiv et';

return $_lang;
