<?php
/**
 * MODX Manager language file
 *
 * @version 1.0.15
 * @date 2014/02/24
 * @author modxcms.cz
 *
 * @language Czech
 * @package modx
 * @subpackage manager
 *
 * Please commit your language changes on Transifex (https://www.transifex.com/projects/p/modx-evolution/) or on GitHub (https://github.com/modxcms/evolution).
 */
//$modx_textdir = 'rtl'; // uncomment this line for RTL languages
$modx_lang_attribute = 'cs'; // Manager HTML/XML Language Attribute see http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'UTF-8';

$_lang["about_msg"] = 'MODX je <a href="https://evo.im/" target="_blank">PHP Application Framework and Content Management System</a> licencovaný pod <a href="http://www.gnu.cz/article/32/">GNU GPL</a>.';
$_lang["about_title"] = 'O MODX';
$_lang["access_permission_denied"] = 'Nemáte potřebná oprávnění pro tento dokument.';
$_lang["access_permission_parent_denied"] = 'Nemáte oprávnění pro vytvoření nebo přesun dokumentu na toto místo! Vyberte jiné umístění.';
$_lang["access_permissions"] = 'Přístupová práva';
$_lang["access_permissions_add_resource_group"] = 'Vytvořit skupinu dokumentů';
$_lang["access_permissions_add_user_group"] = 'Vytvořit skupinu uživatelů';
$_lang["access_permissions_docs_collision"] = 'Vzhledem ke konfliktu uživatelského a manažerského účtu, bude tento dokument publikován. Pro další pomoc se obraťte na správce stránek.';
$_lang["access_permissions_docs_message"] = 'Tady můžete vybrat, ke kterým skupinám dokumentů bude tento dokument patřit';
$_lang["access_permissions_group_link"] = 'Vytvořit propojení skupin';
$_lang["access_permissions_introtext"] = 'Tady můžete vytvářet skupiny uživatelů, dokumentů používaných pro definici přístupových práv. Můžete přidat uživatele do uživatelské skupiny, upavit ji nebo vytvořit novou prázdnou skupinu. Uživatelské skupině můžete přidělit nebo odebrat dokument nebo vybrat skupinu uživatelů, kterým by měl dokument patřit.';
$_lang["access_permissions_link_to_group"] = 'do skupiny dokumentů';
$_lang["access_permissions_link_user_group"] = 'Skupiny návštěvníků';
$_lang["access_permissions_links"] = 'Propojení obou skupin';
$_lang["access_permissions_links_tab"] = 'Tady určujete, která skupina užívatelů bude mít přístup, ke které skupině dokumentů (např. můžete měnit nebo vytvořit sdílené dokumenty - potomky). Propojit skupinu dokumentů se skupinou uživatelů uděláte výběrem skupiny z roletového menu a stlačením \'Přidat\'. Tlačítkem \'Odebrat ->\' propojení obou skupín odstraníte.';
$_lang["access_permissions_no_resources_in_group"] = 'Žádný.';
$_lang["access_permissions_no_users_in_group"] = 'Žádný.';
$_lang["access_permissions_off"] = '<span class="warning">Přístupová práva nejsou aktivována.</span> To znamená, že žádné změny nebudou mít efekt, jestliže přístupová práva v nastavení MODX neaktivujete.';
$_lang["access_permissions_resource_groups"] = 'Skupiny dokumentů';
$_lang["access_permissions_resources_in_group"] = '<b>Dokumenty ve skupině:</b> ';
$_lang["access_permissions_resources_tab"] = 'Tady můžete vidět, které skupiny dokumentů jsou nastavené. Můžete vytvářet nové skupiny, přejmenovávat je, mazat je a procházet, které dokumenty se nacházejí, v kterých skupinách (po přesunu kurzoru myši na ID dokumentu se zobrazí jeho název). Přidat dokument do skupiny nebo ho odstranit se da jen prímou změnou v samotném dokumentu.';
$_lang["access_permissions_user_groups"] = 'Skupiny návštěvníků';
$_lang["access_permissions_user_message"] = 'Tady můžete zvolit, který uživatel patří, do které skupiny:';
$_lang["access_permissions_users_in_group"] = '<b>Uživatelé ve skupině:</b> ';
$_lang["access_permissions_users_tab"] = 'Tady můžete vidět, které skupiny uživatelů jsou nastavené. Můžete vytvářet nové skupiny, přejmenovávat je a prohlížet, kteří uživatelé jsou ve skupinách registrováni. Jestliže chcete přidat nového uživatele do skupiny nebo ho odstranit, musíte upravit nastavení konkrétního uživatele ve "Správě uživatelů". Administrátoři (užívatelé s přiděleným ID 1) mají vždy přístup ke všem dokumentům a není potřeba je přidávat do kterékoli skupiny.';
$_lang["account_email"] = 'Email účtu';
$_lang["actioncomplete"] = '<b>Akce byla úspešně dokončena!</b><br /> - Počkejte prosím, MODX se čistí.';
$_lang["activity_message"] = 'Tento seznam vypisuje poslední vytvořené nebo upravené dokumenty.';
$_lang["activity_title"] = 'Naposledy vytvořené nebo upravené dokumenty';
$_lang["add"] = 'Přidat skupinu';
$_lang["add_chunk"] = 'Přidat chunk';
$_lang["add_doc"] = 'Přidat dokument';
$_lang["add_folder"] = 'Nová složka';
$_lang["add_plugin"] = 'Přidat Plugin';
$_lang["add_resource"] = 'Nový dokument';
$_lang["add_snippet"] = 'Přidat snippet';
$_lang["add_tag"] = 'Přidat tag (značku)';
$_lang["add_template"] = 'Přidat šablonu';
$_lang["add_tv"] = 'Přidat TV';
$_lang["add_weblink"] = 'Nový odkaz';
$_lang["administrator_role_message"] = 'S vašemi pravomocemi nemůžete upravovat ani mazat.';
$_lang["administrators"] = 'Administrátoři';
$_lang["after_saving"] = 'Po uložení';
$_lang["alert_delete_self"] = 'Nemůžete odstranit sám sebe!';
$_lang["alias"] = 'Alias';
$_lang["all_doc_groups"] = 'Všechny skupiny dokumentů (Veřejné)';
$_lang["all_events"] = 'Všechny události';
$_lang["all_usr_groups"] = 'Všechny skupiny uživatelů (Veřejné)';
$_lang["allow_mgr_access"] = 'Správce přístupového rozhraní';
$_lang["allow_mgr_access_message"] = 'Zvolením tohoto výběru umožníte nebo znemožníte přístup do správcovského rozhraní. <b>POZNÁMKA: Jestliže je v této volbě nastaveno NE, potom uživatel bude přesměrován do Správce úvodního přihlášení nebo na úvodní stránku.</b>';
$_lang["already_deleted"] = 'už byl vymazán.';
$_lang["attachment"] = 'Příloha';
$_lang["automatic_alias_message"] = 'Volbou \'ano\' je systémem automaticky generován alias založený na nadpisu stránky dokumentu, když je uložen.';
$_lang["automatic_alias_title"] = 'Automaticky vytvořený alias:';
$_lang["backup"] = 'Záloha';
$_lang["bk_manager"] = 'Záloha';
$_lang["block_message"] = 'Tento uživatel bude po uložení dat zablokován.';
$_lang["blocked_minutes_message"] = 'Zde můžete zadat dobu (počet minut), po kterou bude uživatel blokován, pokud přesáhne maximálního počtu chybných přihlášení. Prosím zadejte pouze číselnou hodnotu (bez čárek, mezer atd.).';
$_lang["blocked_minutes_title"] = 'Blokované minuty:';
$_lang["cache_files_deleted"] = 'Následující soubory jsou smazány:';
$_lang["cancel"] = 'Zrušit';
$_lang["captcha_code"] = 'Bezpečnostní kód';
$_lang["captcha_message"] = 'Zapnutím zvýšíte bezpečnost, protože požadujete po uživatelích opsání kódu, který je strojově nečitelný (slouží jako ochrana před roboty, scriptkiddies nebo hackerskými útoky).';
$_lang["captcha_title"] = 'Použít generovaný obrázkový<br /> (CAPTCHA) kód:';
$_lang["captcha_words_default"] = 'MODX,Access,Better,BitCode,Chunk,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Oscope,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Tattoo,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote';
$_lang["captcha_words_message"] = 'Zde můžete zadat seznam CAPTCHA slov, které se používají při povolené CAPTCHA. Oddělte slova čárkami. Toto pole je limitované max. počtem 255 znaků.';
$_lang["captcha_words_title"] = 'CAPTCHA slova';
$_lang["category_heading"] = 'Kategorie';
$_lang["category_msg"] = 'Tady můžete zobrazit a upravit všechny zdroje seskupené do kategorií.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Změna jména';
$_lang["change_password"] = 'Změna hesla';
$_lang["change_password_confirm"] = 'Potvrzení hesla';
$_lang["change_password_message"] = 'Vložte prosím Vaše nové heslo a v následujícím řádku heslo zopakujte znovu z důvodu kontroly překlepu. Heslo by mělo mít délku 6 - 15 znaků.';
$_lang["change_password_new"] = 'Nové heslo';
$_lang["charset_message"] = 'Vyberte výchozí kódování znaků pro [(modx_charset)] systemové proměnné. Volba nemá vliv na Manager.';
$_lang["charset_title"] = 'Kódování znaků:';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Kód chunku (html)';
$_lang["chunk_multiple_id"] = 'Chyba: Více Chunků sdílí unikátní ID.';
$_lang["chunk_no_exist"] = 'Chunk neexistuje.';
$_lang["cleaningup"] = 'Čistím / Odstraňuji';
$_lang["clean_uploaded_filename"] = 'Přepisovat názvy nahrávaných souborů';
$_lang["clean_uploaded_filename_message"] = 'Je-li aktivní bude využito výchozího nastavení nebo nastavení pro transalias, které odstraní speciální znaky (např. diakritiku, ...) z názvů nahrávaných souborů, tečky budou zachovány.';
$_lang["clear_log"] = 'Vyčistit výpis';
$_lang["click_to_context"] = 'Kliknutím získáte přístup do kontextového menu';
$_lang["click_to_edit_title"] = 'Zde klikněte pro úpravu tohoto záznamu';
$_lang["click_to_view_details"] = 'Zde klikněte pro zobrazení detailů';
$_lang["close"] = 'Uzavřít';
$_lang["code"] = 'Kód';
$_lang["collapse_tree"] = 'Sbalit';
$_lang["comment"] = 'Poznámka';
$_lang["configcheck_admin"] = 'Kontaktujte prosím administrátora systému a upozorněte ho na tuto zprávu!';
$_lang["configcheck_cache"] = 'Adresář cache není nastavený pro zápis.';
$_lang["configcheck_cache_msg"] = 'MODX nemůže zapisovat do adresáře cache. Systém bude fungovat správně, ale nebude dostupná funkce zásobníku. Prosím nastavte povolení pro zápis do adresáře cache.';
$_lang["configcheck_configinc"] = 'Do konfiguračního souboru je stále možno zapisovat.';
$_lang["configcheck_configinc_msg"] = 'Velmi neslušní lidé mohou potenciálně způsobit pěkný nepořádek na vašich stránkách a čemkoli spojeném s nimi. <strong>Opravdu.</strong> Prosím nastavte váš konfigurační soubor (/[+MGR_DIR+]/includes/config.inc.php) jen pro čtení!';
$_lang["configcheck_default_msg"] = 'Byla nalezena nespecifikovaná výstraha. Pro další postup použíjte křišťálovou kouli. :-)';
$_lang["configcheck_errorpage_unavailable"] = 'Vaše Chybová stránka (error 404) není dostupná.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'To znamená, že vaše Chybová stránka není dostupná normálním internetovým uživatelům nebo neexistuje. To může vést k mnoha chybovým zápisům do logů. Ujistěte se zda žádná ze skupin návštěvníků nemá přístup k této stránce.';
$_lang["configcheck_errorpage_unpublished"] = 'Vaše Chybová stránka (error 404) není publikována nebo neexistuje.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'To znamená, že vaše Chybová stránka je nedostupná širolé veřejnosti. Publikujte stránku nebo se přesvědčte, že stránka existuje a je umístěna ve stromu dokumentů v Nástrojích &gt; Konfigurační menu';
$_lang["configcheck_hide_warning"] = '<a href="javascript:hideConfigCheckWarning(\'%s\');"><em>Tuto zprávu již nezobrazovat.</em></a>';
$_lang["configcheck_images"] = 'Do adresáře pro obrázky nelze zapisovat';
$_lang["configcheck_images_msg"] = 'Adresář pro obrázky neexistuje nebo nemá povoleno právo k zápisu. Je potřeba pro funkčnost WYSIWYG editoru.';
$_lang["configcheck_installer"] = 'Instalátor nebyl smazán.';
$_lang["configcheck_installer_msg"] = 'Adresář /install/ obsahuje instalátor systému MODX. Pomocí něj může nepovolaná osoba vymazat databázi. Prosím kontaktujte administrátora, aby urychleně odstránil tento problém.';
$_lang["configcheck_lang_difference"] = 'Nesprávný počet položek v souboru jazykové lokalizace.';
$_lang["configcheck_lang_difference_msg"] = 'Právě vybraný jazyk má rozdílný počet položek než výchozí jazyk (angličtina). Pravděpodobně používate zastaralý nebo nekorektně upravený lokalizační soubor. I když se neobjeví problémy, bude asi potřeba udělat jeho aktualizaci.';
$_lang["configcheck_notok"] = 'Byly nalezeny následující problémy: ';
$_lang["configcheck_ok"] = 'Kontola proběhla úspěšně - žádná varovavání nejsou třeba.';
$_lang["configcheck_php_gdzip"] = 'GD a/nebo Zip PHP extenze nenalezena';
$_lang["configcheck_php_gdzip_msg"] = 'MODX potřebuje aktivní extenzi GD a Zip v PHP. Dokud bude MODX bežet bez nich, nebude možno používat všech výhod vestavěného správce souborů, editoru obrázků nebo captcha.';
$_lang["configcheck_register_globals"] = 'register_globals je nastaven na zapnuto (ON) v konfiguračním souboru php.ini';
$_lang["configcheck_register_globals_msg"] = 'Tato konfigurace dělá Vaše stránky více citlivé na útoky typu Cross Site Scripting (XSS). ';
$_lang["configcheck_title"] = 'Kontrola konfigurace';
$_lang["configcheck_templateswitcher_present"] = 'Detekován plugin TemplateSwitcher';
$_lang["configcheck_templateswitcher_present_delete"] = '<a href="javascript:deleteTemplateSwitcher();">Odstranit TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_disable"] = '<a href="javascript:disableTemplateSwitcher();">Vypnout TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_msg"] = 'Bylo zjištěno, že plugin zapříčiňuje problémy s ukládáním do vyrovnávací paměti a způsobuje problémy s výkonem, měli by jste využít pouze funkcionalit nutných pro chod stránek.';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Stránka o neautorizovaném přístupu není publikována nebo neexistuje.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'To znamená, že Stránka o neautorizovaném přístupu není dostupná normálním internetovým uživatelům nebo neexistuje. To může vést k mnoha chybovým zápisům do logů. Ujistěte se zda žádná ze skupin návštěvníků nemá přístup k této stránce.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'Stránka o neautorizovaném přístupu definovaná v nastavení webu není publikována.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'To znamená, že vaše Stránka o neautorizovaném přístupu je nedostupná širolé veřejnosti. Publikujte stránku nebo se přesvědčte, že stránka existuje a je umístěna ve stromu dokumentů v Nástrojích &gt; Konfigurační menu.';
$_lang["configcheck_validate_referer"] = 'Bezpečnostní upozornění: Validace HTTP hlaviček';
$_lang["configcheck_validate_referer_msg"] = 'Nastavení <strong>Ověřit hlavičky HTTP_REFERER</strong> v konfiguraci systému je vypnuté. Doporučujeme jej zapnout. <a href="index.php?a=17">Přejít na konfiguraci systému</a><br /><a href="javascript:hideHeaderVerificationWarning();"><em>Nezobrazovat to znovu.</em></a>';
$_lang["configcheck_warning"] = 'Výstraha konfigurace:';
$_lang["configcheck_what"] = 'Co to znamená?';
$_lang["confirm_block"] = 'Opravdu chcete zablokovat tohoto uživatele?';
$_lang["confirm_delete_eventlog"] = 'Skutečně chcete smazat tento výpis událostí?';
$_lang["confirm_delete_file"] = 'Jste si jistí, že chcete odstranit soubor?\n\nMůže to narušit činnost stránek! Soubor odstraňte jen tehdy, jestliže víte, na co slouží a jste si jistý, že jeho odstranění nemůže ohrozit nebo narušit činnost stránky.';
$_lang["confirm_delete_htmlsnippet"] = 'Jste si jistí, že chcete odstranit chunk?';
$_lang["confirm_delete_keywords"] = 'Jste si jisti, že chcete smazat tato klíčová slova?';
$_lang["confirm_delete_module"] = 'Opravdu chcete tento modul smazat?';
$_lang["confirm_delete_plugin"] = 'Jste si jisti, že chcete smazat tento plugin?';
$_lang["confirm_delete_record"] = 'Opravdu chcete smazat vybraný záznam/vybrané záznamy?';
$_lang["confirm_delete_resource"] = 'Skutečně chcete smazat tento dokument?\nPotomci tohto dokumentu budu také smazáni!';
$_lang["confirm_delete_role"] = 'Skutečně chcete odstranit toto oprávnění?';
$_lang["confirm_delete_snippet"] = 'Opravdu chcete odstranit tento snippet?';
$_lang["confirm_delete_tags"] = 'Opravdu chcete smazat vybrané META tagy?';
$_lang["confirm_delete_template"] = 'Opravdu chcete odstranit tuto šablonu?';
$_lang["confirm_delete_tmplvars"] = 'Opravdu chcete odstranit tuto proměnnou a všechny uložené hodnoty?';
$_lang["confirm_delete_user"] = 'Opravdu chcete odstranit tohoto uživatele?';
$_lang["confirm_duplicate_record"] = 'Opravdu chcete zkopírovat tento záznam?';
$_lang["confirm_empty_trash"] = 'Chcete trvale odstranit všechny vymazané dokumenty?\n\nPokračovat?';
$_lang["confirm_load_depends"] = 'Opravdu chcete nahrát Správu závislostí bez uložení vašich změn?';
$_lang["confirm_name_change"] = 'Změna uživatelského jména může ovlivnit jiné aplikace, které jsou provázané se Správcem obsahu. \n\n Skutečně chcete změnit toto uživatelské jméno?';
$_lang["confirm_publish"] = '\n\nPublikováním tohoto dokumentu odstraníte nastavené datumy ukončení publikování. Jestli chcete nastavené datum začátku nebo ukončení publikace zachovat, zvolte prosím místo této volby \'Upravit dokument\'.\n\nPokračovať?';
$_lang["confirm_remove_locks"] = 'Užívatelé někdy vypnou svůj prohlížeč v průběhu úprav dokumentů, šablon, snippetů nebo opustí složku, případně příspěvek v uzamknutém stavu v průběhu úpravy. Stisknutím OK můžete odstranit VŠECHNY zámky, které jsou aktivovní.\n\nPokračovat?';
$_lang["confirm_resource_duplicate"] = 'Opravdu chcete zkopírovat tento dokument/složku?\nPodsložky a dokumenty budou také zkopírovány.';
$_lang["confirm_setting_language_change"] = 'Změnili jste výchozí hodnotu a přijdete o provedené změny. Pokračovat?';
$_lang["confirm_unblock"] = 'Opravdu chcete odblokovat tohoto uživatele?';
$_lang["confirm_undelete"] = '\n\nPotomci tohoto dokumentu budou obnoveni zároveň s tímto dokumentem. Sdílené dokumenty, smazané dříve než rodičovský dokument, zůstanou smazány.';
$_lang["confirm_unpublish"] = '\n\nUkončením publikace tohoto dokumentu odstraníte data začátku publikace a ukončení publikace tohoto dokumentu. Jestli chcete nastavené datum začátku nebo ukončení publikace zachovat, zvolte prosím místo této volby \'Upravit dokument\'.\n\nPokračovat?';
$_lang["confirm_unzip_file"] = 'Opravdu chcete rozbalit tento soubor?\n\nExistující soubory budou přepsány.';
$_lang["could_not_find_user"] = 'Nemohu nalézt uživatele';
$_lang["create_folder_here"] = 'Zde vytvoř složku';
$_lang["create_resource_here"] = 'Zde vytvořit dokument';
$_lang["create_resource_title"] = 'Vytvořit dokument';
$_lang["create_weblink_here"] = 'Zde vytvořit link';
$_lang["createdon"] = 'Vytvořeno dne:';
$_lang["credits"] = 'Poděkování';
$_lang["credits_shouts_msg"] = '<p>MODX je spravován a udržován na <a href="https://evo.im/" target="_blank">modx.com</a>.</p>';
$_lang["custom_contenttype_message"] = 'Tady můžete přidat uživatelské typy obsahu užité ve vašich dokumentech. Pro přidání nového vstupu, zadejte typ obsahu v textovém poli, potom klikněte na tlačítko \'Přidat\'.';
$_lang["custom_contenttype_title"] = 'Uživatelské typy obsahu:';
$_lang["database_charset"] = 'Znaková sada databáze';
$_lang["database_collation"] = 'Výchozí znaková sada porovnávání';
$_lang["database_name"] = 'Jméno databáze';
$_lang["database_overhead"] = '<b style="color:#990033;">Poznámka:</b> Navíc je nevyužité místo rezervované MySQL. Pro uvolnění místa klikněte v tabulce na číslo v sloupci Navíc.';
$_lang["database_server"] = 'Databázový server';
$_lang["database_table_clickbackup"] = 'pro zálohu a stažení vybraných tabulek';
$_lang["database_table_clickhere"] = 'Klikněte zde';
$_lang["database_table_datasize"] = 'Velikost dat';
$_lang["database_table_droptablestatements"] = 'Generuj příkaz DROP TABLE.';
$_lang["database_table_effectivesize"] = 'Skutečná velikost';
$_lang["database_table_indexsize"] = 'Velikost indexu';
$_lang["database_table_overhead"] = 'Navíc';
$_lang["database_table_records"] = 'Záznamy';
$_lang["database_table_tablename"] = 'Jméno tabulky';
$_lang["database_table_totals"] = 'Celkem:';
$_lang["database_table_totalsize"] = 'Celková velikost';
$_lang["database_tables"] = 'Databázové tabulky';
$_lang["database_version"] = 'Verze databáze:';
$_lang["date"] = 'Datum';
$_lang["datechanged"] = 'Datum bylo změněno';
$_lang["datepicker_offset"] = 'Počet let v minulosti: ';
$_lang["datepicker_offset_message"] = 'Kolik předchozích let má být zobrazeno ve výběru data.';
$_lang["datetime_format"] = 'Format datumu';
$_lang["datetime_format_message"] = 'Formát datumu v Manager.';
$_lang["default"] = 'Výchozí:';
$_lang["defaultcache_message"] = 'Označte \'Ano\' pro předvolené načtení dokumentů do zásobníku.';
$_lang["defaultcache_title"] = 'Ukládání do zásobníku';
$_lang["defaultmenuindex_message"] = 'Volbou \'Ano\' zapnete automatický menu index přidaný do jádra (základu).';
$_lang["defaultmenuindex_title"] = 'Přednastavený menu indexing';
$_lang["defaultpublish_message"] = 'Označte \'Ano\' pro předvolené automatické publikování nových dokumentů.';
$_lang["defaultpublish_title"] = 'Přednastavené publikování';
$_lang["defaultsearch_message"] = 'Označte \'Ano\' pro předvolené vyhledávání v nových dokumentech.';
$_lang["defaultsearch_title"] = 'Přednastavené vyhledávání';
$_lang["defaulttemplate_message"] = 'Vyberte přednastavenou šablonu, kterou chcete používat v nových dokumentech. Stále můžete vybrat odlišnou šablonu v editoru dokumentů, toto nastavení definuje jednu ze šablon jako výchozí.';
$_lang["defaulttemplate_title"] = 'Přednastavená šablona';
$_lang["defaulttemplate_logic_title"] = 'Automatické nastavování šablon';
$_lang["defaulttemplate_logic_general_message"] = 'Novým dokumentům budou přiřazovány šablony dle následujících pravidel, pokud to nebude možné použije se šablona jako v nadřazeném dokumentu:';
$_lang["defaulttemplate_logic_system_message"] = '<strong>Systémová</strong>: výchozí šablona systému.';
$_lang["defaulttemplate_logic_parent_message"] = '<strong>Nadřazená</strong>: stejná šablona jako u nadřazeného dokumentu.';
$_lang["defaulttemplate_logic_sibling_message"] = '<strong>Sourozenecká</strong>: stejná šablona jako ostatní dokumenty na dané úrovni.';
$_lang["delete"] = 'Smazat';
$_lang["delete_resource"] = 'Smazat dokument';
$_lang["delete_tags"] = 'Smazat tagy';
$_lang["deleting_file"] = 'Odstraňuji soubor `%s`: ';
$_lang["description"] = 'Popis';
$_lang["deselect_keywords"] = 'Smazat klíčová slova';
$_lang["deselect_metatags"] = 'Smazat META tagy';
$_lang["disabled"] = 'Zakázaný';
$_lang["doc_data_title"] = 'Náhled na data dokumentu';
$_lang["duplicate"] = 'Kopírovat';
$_lang["duplicate_alias_found"] = 'Dokument \'%s\' již používá alias \'%s\'. Prosím zadejte jednoznačný alias.';
$_lang["duplicate_alias_message"] = 'Zde můžete zvolit \'ano\' k povolení duplicity aliasů, které byly uloženy. <b>POZNÁMKA: Tato volba by měla být použita s volbou "Cesta ke zjednodušenému aliasu" nastavenou na \'Ano\', aby se vyhnulo problémům při odkazování na dokument.</b>';
$_lang["duplicate_alias_title"] = 'Povolit duplicitu aliasů:';
$_lang["duplicate_name_found_general"] = '%s s názvem \'%s\' již existuje. Zadejte ještě nepoužitý název.';
$_lang["duplicate_name_found_module"] = 'Modul s názvem \'%s\' již existuje. Zadejte ještě nepoužitý název.';
$_lang["edit"] = 'Upravit';
$_lang["edit_resource"] = 'Upravit dokument';
$_lang["edit_resource_title"] = 'Upravit dokument';
$_lang["edit_settings"] = 'Konfigurace systému';
$_lang["editedon"] = 'Datum úprav';
$_lang["editing_file"] = 'Úprava souboru: ';
$_lang["editor_css_path_message"] = 'Zadejte cestu k Vašemu CSS souboru, jestliže si přejete ho používat editorem. Nejlepší ke vložení cesty k rootu vašeho serveru, např.: /assets/site/style.css. Jestliže si nepřejete nahrát kaskádový styl do editoru, nechejte pole prázdné.';
$_lang["editor_css_path_title"] = 'Cesta k CSS souboru:';
$_lang["element"] = 'Zdroj';
$_lang["element_categories"] = 'Všechny zdroje a moduly';
$_lang["element_management"] = 'Správa zdrojů';
$_lang["element_name"] = 'Název zdroje';
$_lang["element_selector_msg"] = 'Vyberte zdroj(e) z níže uvedeného seznamu a klikněte na tlačítko \'Vložit\'.';
$_lang["element_selector_title"] = 'Volič zdrojů';
$_lang["elements"] = 'Zdroje';
$_lang["email"] = 'Email';
$_lang["email_sent"] = 'Email poslán';
$_lang["emailsender_message"] = 'Zde můžete zadat emailovu adresu použitou při odesílání uživatelských jmén a hesel.';
$_lang["emailsender_title"] = 'Emailová adresa:';
$_lang["emailsubject_default"] = 'Vaše přihlašovací údaje';
$_lang["emailsubject_message"] = 'Zde můžete zadat předmět odesílaného emailu.';
$_lang["emailsubject_title"] = 'Předmět emailu:';
$_lang["empty_folder"] = 'Tato složka je prázdná';
$_lang["empty_recycle_bin"] = 'Odstranit smazané dokumenty';
$_lang["empty_recycle_bin_empty"] = 'Nejsou žádné smazané dokumenty na odstranění.';
$_lang["enable_resource"] = 'Povolit zdrojový soubor.';
$_lang["enable_sharedparams"] = 'Umožnit sdílení parametru';
$_lang["enable_sharedparams_msg"] = '<b>POZNÁMKA:</b> celkově jedinečné id (GUID) bude použito pro jedinečnou identifikaci tohoto modulu a jeho sdílených parametrů. GUID je také používáno k vytvoření odkazu mezi modulem a pluginy nebo snippety přistupujícími ke sdíleným parametrům.';
$_lang["enabled"] = 'Povoleno';
$_lang["error"] = 'Chyba';
$_lang["error_sending_email"] = 'Chyba při odesílání emailu';
$_lang["errorpage_message"] = 'Zde zadejte ID dokumentu, který se bude zobrazovat uživatelům, když budou chtít zobrazit stránku, která neexistuje. <b>Poznámka: Je nutné vložit ID existujícího dokumentu, který musí být publikován!</b>';
$_lang["errorpage_title"] = 'Chybová stránka:';
$_lang["event_id"] = 'ID události';
$_lang["eventlog"] = 'Zápis událostí';
$_lang["eventlog_msg"] = 'Zápis událostí je používán k zobrazení informativních, varovných a chybových zpráv vytvořených správcem obsahu. Sloupec "zdroj" zobrazuje část správce obsahu, kde zpráva nastala.';
$_lang["eventlog_viewer"] = 'Prohlížeč událostí';
$_lang["everybody"] = 'Všichni';
$_lang["existing_category"] = 'Existující kategorie';
$_lang["expand_tree"] = 'Rozbalit';
$_lang["failed_login_message"] = 'Zde můžete zadat počet špatných pokusů přihlášení, které budou předcházet před zablokováním uživatele.';
$_lang["failed_login_title"] = 'Špatné pokusy přihlášení:';
$_lang["fe_editor_lang_message"] = 'Vyberte jazyk editoru, který bude používán v WYSIWYG editoru.';
$_lang["fe_editor_lang_title"] = 'Jazyk WYSIWYG editoru:';
$_lang["file_delete_file"] = 'Smazat soubor';
$_lang["file_delete_folder"] = 'Smazat složku';
$_lang["file_deleted"] = 'Proběhlo úspěšně!';
$_lang["file_download_file"] = 'Stáhnout soubor';
$_lang["file_download_unzip"] = 'Rozbalit soubor';
$_lang["file_folder_chmod_error"] = 'Není možné změnit práva, musíte změnit práva mimo MODX.';
$_lang["file_folder_created"] = 'Složka byla úspěšně vytvořena!';
$_lang["file_folder_deleted"] = 'Složka byla úspěšně smazána!';
$_lang["file_folder_not_created"] = 'Nebylo možné vytvořit složku';
$_lang["file_folder_not_deleted"] = 'Nebylo možné smazat složku. Ujistěte se, že je složka prázdná!';
$_lang["file_not_deleted"] = 'Selhalo!';
$_lang["file_not_saved"] = 'Nebylo možné uložit soubor, nastavte prosím přístupová práva, aby bylo možné do cílového adresáře zapisovat!';
$_lang["file_saved"] = 'Soubor byl úspěšně aktualizován!';
$_lang["file_unzip"] = 'Rozbalení bylo úspěšné!';
$_lang["file_unzip_fail"] = 'Rozbalení selhalo!';
$_lang["filemanager_path_message"] = 'IIS občas nedokáže správně pracovat s nastaveným koreňovým adresářem dokumentů, který používá souborový správce. Jestliže máte problémy s jeho používaním, nadefinujte tuto cestu do kořenového adresáře ve vaší instalaci MODX.';
$_lang["filemanager_path_title"] = 'Umístění souborového správce:';
$_lang["files_access_denied"] = 'Přístup zamítnutý!';
$_lang["files_data"] = 'Data';
$_lang["files_dir_listing"] = 'Výpis adresáře:';
$_lang["files_directories"] = 'Adresáře';
$_lang["files_dirwritable"] = 'Zápis povolen?';
$_lang["files_editfile"] = 'Upravit soubor';
$_lang["files_file_type"] = 'Typ souboru: ';
$_lang["files_filename"] = 'Název';
$_lang["files_fileoptions"] = 'Možnosti';
$_lang["files_files"] = 'Soubory';
$_lang["files_filesize"] = 'Velikost souboru';
$_lang["files_filetype_notok"] = 'Nahrání tohoto typu souboru není povoleno!';
$_lang["files_modified"] = 'Změněno';
$_lang["files_top_level"] = 'Domovský adresář';
$_lang["files_up_level"] = 'Nadřazený adresář';
$_lang["files_upload_copyfailed"] = 'Chyba při kopírování do cílového adresáře - nahrání selhalo!';
$_lang["files_upload_error"] = 'Chyba';
$_lang["files_upload_error0"] = 'Vyskytnul se problém při nahrávání souboru.';
$_lang["files_upload_error1"] = 'Soubor je příliš velký.';
$_lang["files_upload_error2"] = 'Soubor je příliš velký.';
$_lang["files_upload_error3"] = 'Soubor byl nahrán jen částečně.';
$_lang["files_upload_error4"] = 'Nebyl zvolen soubor pro nahrání.';
$_lang["files_upload_error5"] = 'Vyskytnul se problém při nahrávání souboru.';
$_lang["files_upload_inhibited_msg"] = '<b>Do tohoto adresáře se nedají nahrávat soubory</b> - presvěčte se, zda jsou do tohoto adresáře nastavená práva pro zápis.<br />';
$_lang["files_upload_ok"] = 'Soubor byl úspěšně nahrán!';
$_lang["files_upload_permissions_error"] = 'Možný problém s oprávněním - adresář, do kterého chcete nahrávat soubory musí mít povoleno zapisování servrem.';
$_lang["files_uploadfile"] = 'Nahrát soubor';
$_lang["files_uploadfile_msg"] = 'Vybrat soubor pro nahrání:';
$_lang["files_uploading"] = 'Soubor <b>%s</b> nahrávám do adresáře <b>%s/</b><br />';
$_lang["files_viewfile"] = 'Zobrazit soubor';
$_lang["folder"] = 'Složka';
$_lang["forgot_password_email_fine_print"] = '* Uvedená URL expiruje dnes nebo po prvním pokusu změnit heslo.';
$_lang["forgot_password_email_instructions"] = 'Odtud můžete změnit heslo v menu Můj účet.';
$_lang["forgot_password_email_intro"] = 'Požadavek na změnu hesla k vašemu účtu.';
$_lang["forgot_password_email_link"] = 'Klikněte sem pro dokončení procesu.';
$_lang["forgot_your_password"] = 'Zapomněli jste heslo?';
$_lang["friday"] = 'Pátek';
$_lang["friendly_alias_message"] = 'Jestliže používáte zjednodušené URL, a dokument má nadefinovaný alias, bude mít vždy přednost před zjednodušenou URL. Jestliže nastavíte volbu na `Ano`, předpona a přípona zjednodušených url budou také aplikované na aliasy. Například když Váš dokument s ID 1 má alias `uvod`, máte nastavenou předponu na `` a příponu na `.html`, a nastavíte tuto volbu na `Ano` bude generovaný dokument `uvod.html`. Jestliže alias nemáte definován, MODX bude generovat dokument `1.html` jako odkaz.';
$_lang["friendly_alias_title"] = 'Použít zjednodušené aliasy:';
$_lang["friendlyurls_message"] = 'Tato volba vám umožní používat jednoduché URL adresy v MODX. Pamatujte prosím, že tato funkce funguje jen v instalaci bežící na Apache serveru. Pro bezchybnou funkci ještě potřebujete mít nastavenou možnost zápisu do souboru .htaccess. Pro více informací si prohlédněte soubor .htaccess obsáhnutý ve vaší distribuci.';
$_lang["friendlyurls_title"] = 'Jednoduché URL adresy:';
$_lang["friendlyurlsprefix_message"] = 'Zde můžete nastavit předponu pro použití jednoduchých URL adres. Například, předponu nastavte na \'stranka\', což způsobí, že URL adresa /index.php?id=2 se změní na zjednodušenou adresu /stranka2.html (za předpokladu, že přípona je nastavená na .html). Pro odkazy na vaší stránce takto můžete specifikovat, co Vaši užívatelé (a vyhledávače) uvidí.';
$_lang["friendlyurlsprefix_title"] = 'Předpona jednoduchých URL:';
$_lang["friendlyurlsuffix_message"] = 'Zde můžete nastavit příponu pro jednoduché URL adresy. Zadaním \'.html\' se přidá přípona .html ke všem vašim zjednodušeným URL.';
$_lang["friendlyurlsuffix_title"] = 'Přípona jednoduchých URL:';
$_lang["functionnotimpl"] = 'Sakrblééé?!';
$_lang["functionnotimpl_message"] = 'Tato funkce ještě nebyla implementovaná';
$_lang["go"] = 'Hledej';
$_lang["group_access_permissions"] = 'Přístupová práva skupiny uživatelů';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Pomoc';
$_lang["help_msg"] = 'Jestliže potřebujete pomoc při používaní systému MODX, uděláte nejlépe, když navštívíte <a href="http://www.modxcms.cz/" target="_blank">české MODX fórum</a>. Najdete tam: návody, dokumentaci používání a nastavení MODX. Jestliže pošlete svoji otázku na fórum, budeme se snažit odpovědět, co nejdříve.';
$_lang["help_title"] = 'Pomoc';
$_lang["hide_tree"] = 'Skrýt';
$_lang["home"] = 'Domů';
$_lang["htmlsnippet_desc"] = 'Popis';
$_lang["htmlsnippet_management_msg"] = 'Zde můžete zvolit chunk, který chcete upravit.';
$_lang["htmlsnippet_msg"] = 'Zde můžete přidávat nebo upravovat chunky. Pamatujte, chunk je \'surový\' HTML kód  nebo též část PHP kódu, který není možné samostatně spustit.';
$_lang["htmlsnippet_name"] = 'Název chunku';
$_lang["htmlsnippet_title"] = 'Tvorba/úprava chunku';
$_lang["icon"] = 'Ikona';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Nadřazení:\n\nDokument je potomek vybraného dokumentu.';
$_lang["illegal_parent_self"] = 'Nadřazení:\n\nVybraný dokument nemůže být podřízen sám sobě.';
$_lang["import_files_found"] = '<b>Nalezeno %s dokument(y/ů) k importu...</b>';
$_lang["import_params"] = 'Importovat sdílené parametry modulu';
$_lang["import_params_msg"] = 'Můžete importovat parametery nebo nastavení modulu výběrem jména modulu z menu. <b>POZNÁMKA:</b> Aby se moduly objevily v menu, musí být tento plugin/snippet součástí seznam závislostí modulu a modul musí mít povolen parametr sdílení. ';
$_lang["import_parent_resource"] = 'Nadřízený dokument:';
$_lang["update_tree"] = 'Přestavět strom';
$_lang["inbox"] = 'Příchozí pošta';
$_lang["info"] = 'Informace';
$_lang["information"] = 'Informace';
$_lang["inline"] = 'V řadě';
$_lang["insert"] = 'Vložit';
$_lang["maxImageWidth"] = 'Maximum image width';
$_lang["maxImageHeight"] = 'Maximum image height';
$_lang["thumbWidth"] = 'Maximum thumbnail width';
$_lang["thumbHeight"] = 'Maximum thumbnail height';
$_lang["thumbsDir"] = 'Thumbnails directory location';
$_lang["jpegQuality"] = 'JPEG compression';
$_lang["denyZipDownload"] = 'Disable zip-archives downloading';
$_lang["denyExtensionRename"] = 'Disable renaming of file extensions';
$_lang["maxImageWidth_message"] = 'If uploaded image resolution exceeds this setting it will be automatically resized. Set 0 to avoid.';
$_lang["maxImageHeight_message"] = 'If uploaded image resolution exceeds this setting it will be automatically resized. Set 0 to avoid.';
$_lang["thumbWidth_message"] = 'Maximum thumbnail width.';
$_lang["thumbHeight_message"] = 'Maximum thumbnail height.';
$_lang["thumbsDir_message"] = 'The name of previews folder.';
$_lang["jpegQuality_message"] = 'JPEG compression quality of thumbnails and resized images';
$_lang["showHiddenFiles"] = 'Show hidden files in file browser';
$_lang["keyword"] = 'Klíčové slovo';
$_lang["keywords"] = 'Klíčová slova';
$_lang["keywords_intro"] = 'Pro úpravu klíčového slova, jednoduše napište do textového pole vedle původního slova nové klíčové slovo. Pro smazání klíčového slova, označte \'vymazávací\' box před klíčovým slovem. Jestliže označíte vymazávací pole a také změníte jeho název, klíčové slovo bude smazáno a přejmenování klíčového slova nebude uskutečněno!';
$_lang["language_message"] = 'Vyberte jazyk, který chcete používat v administrační části MODX.';
$_lang["language_title"] = 'Jazyk:';
$_lang["launch_site"] = 'Spustit stránky';
$_lang["link_attributes"] = 'Vlastnosti odkazu';
$_lang["link_attributes_help"] = 'Zde můžete zadat vlastnosti odkazu pro tuto stránku, jako target= nebo rel=.';
$_lang["list_mode"] = 'Zapnutí/vypnutí seznam režimu - používate-li seznam všech záznamů v tabulce.';
$_lang["loading_doc_tree"] = 'Načítám strukturu...';
$_lang["loading_menu"] = 'Načítám menu...';
$_lang["loading_page"] = 'Čekejte prosím, než MODX načte stránku...';
$_lang["localtime"] = 'Místní čas';
$_lang["lock_htmlsnippet"] = 'Zamknout chunk pro úpravu';
$_lang["lock_htmlsnippet_msg"] = 'Jen Administrátor (uživatel s ID 1) může upravovat tento chunk.';
$_lang["lock_module"] = 'Zamknout modul pro úpravu';
$_lang["lock_module_msg"] = 'Jen Administrátor (uživatel s ID 1) může upravovat tento modul.';
$_lang["lock_msg"] = '%s právě upravuje tento %s. Prosím počkejte dokud jiný uživatel práci neskončí a zkuste to znovu.';
$_lang["lock_plugin"] = 'Zamknout plugin pro úpravu';
$_lang["lock_plugin_msg"] = 'Jen Administrátor (uživatel s ID 1) může upravovat tento snippet.';
$_lang["lock_settings_msg"] = '%s právě upravuje tato nastavení. Prosím počkejte dokud jiný uživatel práci neskončí a zkuste to znovu.';
$_lang["lock_snippet"] = 'Zamknout snippet pro úpravu';
$_lang["lock_snippet_msg"] = 'Jen Administrátor (uživatel s ID 1) může upravovat tento snippet.';
$_lang["lock_template"] = 'Zamknout šablonu proti úpravě';
$_lang["lock_template_msg"] = 'Jen Administrátor (uživatel s ID 1) může upravovat tuto šablonu.';
$_lang["lock_tmplvars"] = 'Uzamčení proměnné pro úpravu';
$_lang["lock_tmplvars_msg"] = 'Pouze Administrátoři (Role ID 1) můžou měnit tuto proměnnou.';
$_lang["locked"] = 'Uzamčen';
$_lang["login_allowed_days"] = 'Povolené dny';
$_lang["login_allowed_days_message"] = 'Vyberte dny, kdy se může uživatel přihlásit.';
$_lang["login_allowed_ip"] = 'Povolená IP adresa';
$_lang["login_allowed_ip_message"] = 'Zadejte IP adresy, ze kterých může uživatel přistupovat. <b>POZNÁMKA: Více IP adres oddělujte čárkou (,).</b>';
$_lang["login_button"] = 'Přihlásit';
$_lang["login_cancelled_install_in_progress"] = 'Právě probíhá instalace/aktualizace této stránky. <br />Prosím zkuste to za chvíli znovu!<br />';
$_lang["login_cancelled_site_was_updated"] = 'Instalace/aktualizace této stránky byla dokončena, prosím přihlašte se znovu!<br />';
$_lang["login_captcha_message"] = 'Prosím vložte bezpečnostní kód zobrazený v kresbě. Jestliže nemůžete kód přečíst, klepněte obrázek s kódem a bude vygenerovát nový nebo kontaktujte administrátora webu.';
$_lang["login_homepage"] = 'Domovská přihlašovací stránka';
$_lang["login_homepage_message"] = 'Zadejte ID dokumentu, který chcete uživaleti zobrazit po jeho přihlášení. <b>POZNÁMKA: Ujistěte se,že ID dokumentu, které zadáte, patří existojícímu dokumentu, a že byli publikovány a jsou přístupné tomuto uživateli!</b>';
$_lang["login_message"] = 'Vložte prosím své přihlasovací jméno a heslo pro vstup do administrační části. Vaše jméno a heslo je citlivé na velikost písmen a na případné nepřesné zadání anebo překlepy, proto je vložte pozorně!';
$_lang["logo_slogan"] = 'EVO Content Manager - \nCreate and do more with less';
$_lang["logout"] = 'Odhlásit';
$_lang["long_title"] = 'Dlouhý název';
$_lang["mail_check_timeperiod_message"] = 'Jak často kontrolovat nové zprávy v poště, v sekundách.';
$_lang["mail_check_timeperiod_title"] = 'Perioda kontroly pošty:';
$_lang["manage_depends"] = 'Správa závislostí';
$_lang["manage_files"] = 'Správa souborů';
$_lang["manage_htmlsnippets"] = 'Chunky';
$_lang["manage_metatags"] = 'Správa META tagů a klíčových slov';
$_lang["manage_modules"] = 'Správa modulů';
$_lang["manage_plugins"] = 'Pluginy';
$_lang["manage_snippets"] = 'Snippety';
$_lang["manage_templates"] = 'Šablony';
$_lang["manager"] = 'Správce';
$_lang["manager_lockout_message"] = 'Jste přihlášen do Správce obsahu. Pokud chcete opustit MODX, klikněte na tlačítko "Ohlásit".</p>Pro spuštění nebo přechod na domovskou stránku klikněte na tlačítko "Domů".';
$_lang["manager_permissions"] = 'Správa přístupových práv';
$_lang["manager_theme"] = 'Vzhled správce:';
$_lang["manager_theme_message"] = 'Zvolit vzhled Správce obsahu.';
$_lang["meta_keywords"] = 'META klíčová slova';
$_lang["metatag_intro"] = 'Na této stránce můžete mazat, tvořit nebo měnit META tagy. K propojení META tagů s dokumenty, klikněte na tabulku <u>META klíčová slova</u>, když upravujete dokument, a vybíráte požadované META tagy a klíčová slova. Pro přidání nového tagu zadejte název a hodnotu a klikněte na tlačítko \'Přidat tag\'. Pro úpravu tagu klikněte na název tagu v tabulce.';
$_lang["metatag_notice"] = 'Můžete si prohlédnout stránku <a href="http://www.html-reference.com/META.htm" target="_blank">HTML referenční příručka</a> a získat více informací. Toto není kompletní výčet možných Meta Tagů.';
$_lang["metatags"] = 'META tagy';
$_lang["mgr_access_permissions"] = 'Správce přístupových práv';
$_lang["mgr_login_start"] = 'Správce úvodního přihlášení';
$_lang["mgr_login_start_message"] = 'Zadejte ID dokumentu, který chcete uživateli zobrazit po jeho přihlášení do správce. <b>POZNÁMKA: ujistěte se, že zadané ID náleží existujícímu dokument a že byl publikován a je přístupný tomuto uživateli!</b>';
$_lang["mgrlog_action"] = 'Proces';
$_lang["mgrlog_actionid"] = 'ID procesu';
$_lang["mgrlog_anyall"] = 'Jakékoliv/Vše';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() vrací chybu.';
$_lang["mgrlog_datefr"] = 'Datováno od';
$_lang["mgrlog_dateinvalid"] = 'Chybný formát data.';
$_lang["mgrlog_dateto"] = 'Datováno do';
$_lang["mgrlog_emptysrch"] = 'Váš hledaný dotaz vrátil prázdnou sadu výsledků (např. žádný záznam nebyl nalezen).';
$_lang["mgrlog_field"] = 'Pole';
$_lang["mgrlog_itemid"] = 'ID položky';
$_lang["mgrlog_itemname"] = 'Název položky';
$_lang["mgrlog_msg"] = 'Zpráva';
$_lang["mgrlog_noquery"] = 'Žádný hledaný dotaz nebyl dosud zadán.';
$_lang["mgrlog_qresults"] = 'Výsledky dotazu';
$_lang["mgrlog_query"] = 'Zaznamenávání dotazu';
$_lang["mgrlog_query_msg"] = 'Prosím vyberte možnost, jak znázornit záznamy. Můžete vybrat záznam položek podle data, ale uvědomte si, že vložená data nejsou zahrnuta - pro zvolení každého záznamu z 01-01-2004, nastavte \'datováno od\' na 01-01-2004 a \'datováno do\' na 02-01-2004.<br /><br />Zpráva a událost jsou obvykle stejné. Jestliže hledáte určitou zprávu, je nejlepší nastavit proces na \'Jakýkoli / Všechno\'.';
$_lang["mgrlog_results"] = 'Počet výsledků';
$_lang["mgrlog_searchlogs"] = 'Hledej záznamy';
$_lang["mgrlog_sortinst"] = 'Tabulku můžete setřídit kliknutím na hlavičky sloupců. Jestliže je mnoho záznamů, můžete záznamy <a href="index.php?a=55">smazat</a>. To odstraní všechny záznamy, které nemohou být uvolněny!';
$_lang["mgrlog_time"] = 'Čas';
$_lang["mgrlog_user"] = 'Uživatel';
$_lang["mgrlog_username"] = 'Uživatelské jméno';
$_lang["mgrlog_value"] = 'Hodnota';
$_lang["mgrlog_view"] = 'Správce zobrazení záznamů';
$_lang["module_code"] = 'Kód modulu (php)';
$_lang["module_config"] = 'Konfigurace modulu ';
$_lang["module_desc"] = 'Popis';
$_lang["module_disabled"] = 'Modul je zakázaný';
$_lang["module_edit_click_title"] = 'Pro úpravu tohoto modulu klikněte zde';
$_lang["module_group_access_msg"] = 'Zvolte skupiny uživatelů, které mají oprávnění spustit tento modul ve Správci obsahu.';
$_lang["module_management"] = 'Správa modulů';
$_lang["module_management_msg"] = 'Zde můžete zvolit modul, který byste chtěli spustit nebo upravit. Ke spuštění modulu klikněte na ikonu kostky. Pro úpravu modulu klikněte na název modulu.';
$_lang["module_msg"] = 'Zde můžete přidávat/upravovat moduly. Modul je sbírka zdrojů (např. pluginů, snippetů, atd.).';
$_lang["module_name"] = 'Název modulu';
$_lang["module_resource_msg"] = 'Zde můžete přidat nebo odebrat zdroje, na který tento modul závisí. Pro přidání nových zdrojů klikněte na tlačítko přidat.';
$_lang["module_resource_title"] = 'Závislosti modulu';
$_lang["module_title"] = 'Vytvořit/upravit modul';
$_lang["module_viewdepend_msg"] = 'Zde si můžete prohlédnout přiřazené zdroje, které modul požaduje. Klikněte na tlačítko \'Správce závislostí\' k úpravě závislostí';
$_lang["modules"] = 'Moduly';
$_lang["modx_news"] = 'Oznamování MODX novinek';
$_lang["modx_news_tab"] = 'MODX novinky';
$_lang["modx_news_title"] = 'MODX novinky';
$_lang["modx_security_notices"] = 'MODX bezpečnostní oznámení';
$_lang["modx_version"] = 'MODX verze';
$_lang["monday"] = 'Pondělí';
$_lang["move"] = 'Přesunout';
$_lang["move_resource"] = 'Přesunout dokument';
$_lang["move_resource_message"] = 'Můžete přesunout dokument a všechny jeho potomky do nového umístění v adresářovém stromu. Jestliže vyberete dokument, který není složkou, bude změněn na složku. Klikněte na nové umístění v adresářovém stromu.';
$_lang["move_resource_new_parent"] = 'Vyberte nové umístění v adresářovém stromu';
$_lang["move_resource_title"] = 'Přesunout dokument';
$_lang["name"] = 'Název';
$_lang["new_category"] = 'Nová kategorie';
$_lang["new_file_permissions_message"] = 'Jestliže nahráváte nový soubor ve Správci souborů, bude se Správce souborů snažit změnit atributy souboru podle tohoto nastavení. Toto nastavevní nemusí fungovat v některých případech. Např. u IIS, zde musíte práva nastavit ručně.';
$_lang["new_file_permissions_title"] = 'Atributy nového souboru';
$_lang["new_folder_permissions_message"] = 'Jestliže zakládáte novou složku ve Správci souborů, bude se Správce souborů snažit změnit atributy souboru podle tohoto nastavení. Toto nastavevní nemusí fungovat v některých případech. Např. u IIS, zde musíte práva nastavit ručně.';
$_lang["new_folder_permissions_title"] = 'Atributy nové složky';
$_lang["new_htmlsnippet"] = 'Nový chunk';
$_lang["new_keyword"] = 'Přidat nové klíčové slovo:';
$_lang["new_module"] = 'Nový modul';
$_lang["new_parent"] = 'Nový rodič';
$_lang["new_plugin"] = 'Nový plugin';
$_lang["new_role"] = 'Vytvořit nové oprávnění';
$_lang["new_snippet"] = 'Nový snippet';
$_lang["new_template"] = 'Nová šablona';
$_lang["new_tmplvars"] = 'Nová Template Variable';
$_lang["new_user"] = 'Nový uživatel';
$_lang["new_web_user"] = 'Nový návštěvník';
$_lang["new_resource"] = 'Nový dokument';
$_lang["no"] = 'Ne';
$_lang["no_active_users_found"] = 'Nenalezeni aktivní uživatelé.';
$_lang["no_activity_message"] = 'Ještě jste nevytvořil ani neupravil žádný dokument.';
$_lang["no_category"] = 'nezařazeno';
$_lang["no_docs_pending_publishing"] = 'Žádný dokument nečeká na publikování.';
$_lang["no_docs_pending_pubunpub"] = 'Žádné události nebyly nalezeny.';
$_lang["no_docs_pending_unpublishing"] = 'Žádný dokument nečeká na ukončení publikování.';
$_lang["no_edits_creates"] = 'Nenalezeny žádné změny.';
$_lang["no_groups_found"] = 'Nebyla nalezena žádná skupina.';
$_lang["no_keywords_found"] = 'Nejsou zde žádná klíčová slova.';
$_lang["no_records_found"] = 'Žádný záznam nenalezen.';
$_lang["no_results"] = 'Nebyli nalezeny žádné výsledky.';
$_lang["nologentries_message"] = 'Zadejte počet záznamů na stránce při Výpisu akcí.';
$_lang["nologentries_title"] = 'Počet záznamů:';
$_lang["nomessages_message"] = 'Zadejte počet zpráv, které se mají zobrazit ve schránce při jejich prohlížení.';
$_lang["nomessages_title"] = 'Počet zpráv:';
$_lang["none"] = 'Žádný';
$_lang["noresults_message"] = 'Zadejte počet výsledků, které se zobrazí v tabulce, když prohlížíte výpisy a hledáte výsledky.';
$_lang["noresults_title"] = 'Počet výsledků:';
$_lang["not_deleted"] = 'nebyl smazán';
$_lang["not_set"] = 'Nenastaveno';
$_lang["offline"] = 'Offline';
$_lang["online"] = 'Online';
$_lang["onlineusers_action"] = 'Činnost';
$_lang["onlineusers_actionid"] = 'ID činnosti';
$_lang["onlineusers_ipaddress"] = 'IP adresa uživatele';
$_lang["onlineusers_lasthit"] = 'Poslední přihlášení';
$_lang["onlineusers_message"] = 'Zde jsou vypsaní všichni aktívní užívatelé v průběhu 20-ti minut (aktuální čas je ';
$_lang["onlineusers_title"] = 'Uživatelé online';
$_lang["onlineusers_user"] = 'Uživatel';
$_lang["onlineusers_userid"] = 'ID uživatele';
$_lang["optimize_table"] = 'Klikněte zde pro optimalizaci této tabulky.';
$_lang["page_data_cacheable"] = 'Ukládání do zásobníku (cache)';
$_lang["page_data_cacheable_help"] = 'Zatrhněte tuto položku, jestliže budete chtít povolit ukládání dokumentů do zásobníku. Jestliže váš dokument obsahuje snippety, nechejte tuto položku neoznačenou.';
$_lang["page_data_cached"] = '<b>Zdroj vyvolaný ze zásobníku:</b>';
$_lang["page_data_changes"] = 'Změny';
$_lang["page_data_contentType"] = 'Typ obsahu';
$_lang["page_data_contentType_help"] = 'Zvolte typ obsahu dokumentu. Pokud si nejste jistí, jaký bude obsah dokumentu, zvolte "text/html".';
$_lang["page_data_created"] = 'Vytvořené';
$_lang["page_data_edited"] = 'Upravené';
$_lang["page_data_editor"] = 'Upravit pomocí rozšířeného WYSIWYG editoru';
$_lang["page_data_folder"] = 'Dokument je složkou';
$_lang["page_data_general"] = 'Všeobecné';
$_lang["page_data_markup"] = 'Označení/struktura';
$_lang["page_data_mgr_access"] = 'Správce přístupů';
$_lang["page_data_notcached"] = 'Tento dokument není (doposud) uložen v zásobníku.';
$_lang["page_data_publishdate"] = 'Datum publikování';
$_lang["page_data_publishdate_help"] = 'Jestliže nastavíte datum publikování, dokument bude publikovaný až od určitého datumu. Pro výběr data klikněte na ikonku kalendáře, pro odstranění data na vedlejší ikonku. Jestliže použijete tuto možnost, publikování určujete vy - tzn. dokument nemůže být publikovaný automaticky.';
$_lang["page_data_published"] = 'Publikovaný';
$_lang["page_data_searchable"] = 'Vyhledávání';
$_lang["page_data_searchable_help"] = 'Zatrhněte tuto volbu, jestliže budete chtít umožnit vyhledávání v dokumentu. Dá sa také použít pro další účely, jestliže je budou vaše snippety podporovat.';
$_lang["page_data_source"] = 'Zdroj';
$_lang["page_data_status"] = 'Stav';
$_lang["page_data_template"] = 'Použitá šablona';
$_lang["page_data_template_help"] = 'Zde můžete vybrat šablonu, která bude v dokumentu použitá.';
$_lang["page_data_title"] = 'Data stránky';
$_lang["page_data_unpublishdate"] = 'Datum ukončení publikování';
$_lang["page_data_unpublishdate_help"] = 'Jestliže nastavíte datum ukončení publikování dokumentu, jeho zveřejnění bude ukončené k určitému datu. Pro výběr data klikněte na ikonku kalendáře, pro odstranění data na ikonku vedle. Jestliže použijete tuto možnost, ukončení publikování dokumentu určujete vy - publikování nemůže být ukončené automaticky.';
$_lang["page_data_unpublished"] = 'Ukončení publikování';
$_lang["page_data_web_access"] = 'Přístup z webu';
$_lang["pagetitle"] = 'Název dokumentu';
$_lang["pagination_table_first"] = 'První';
$_lang["pagination_table_gotopage"] = 'Jdi na stranu';
$_lang["pagination_table_last"] = 'Poslední';
$_lang["paging_first"] = 'první';
$_lang["paging_last"] = 'poslední';
$_lang["paging_next"] = 'následující';
$_lang["paging_prev"] = 'předcházející';
$_lang["paging_showing"] = 'Zobrazuji';
$_lang["paging_to"] = 'až';
$_lang["paging_total"] = 'celkem';
$_lang["parameter"] = 'Parametr';
$_lang["password"] = 'Heslo';
$_lang["password_change_request"] = 'Požadována změna hesla';
$_lang["password_gen_gen"] = 'Nechat MODX vygenerovat heslo.';
$_lang["password_gen_length"] = 'Heslo, které zadáváte musí být delší jak 6 znaků.';
$_lang["password_gen_method"] = 'Způsob tvorby nového hesla';
$_lang["password_gen_specify"] = 'Zde zadejte své heslo:';
$_lang["password_method"] = 'Způsob oznámení hesla';
$_lang["password_method_email"] = 'Poslat nové heslo emailem.';
$_lang["password_method_screen"] = 'Zobrazit nové heslo na monitoru.';
$_lang["password_msg"] = 'Nové heslo pro <b>:username</b> je <b>:password</b><br>';
$_lang["php_version_check"] = 'MODX je kompatibilní jen s verzí PHP 7.4 a vyšší. Aktualizujte prosím svou PHP instalaci!';
$_lang["plugin"] = 'Plugin';
$_lang["plugin_code"] = 'Kód pluginu (php)';
$_lang["plugin_config"] = 'Nastavení pluginu';
$_lang["plugin_desc"] = 'Popis';
$_lang["plugin_disabled"] = 'Plugin nepovolen';
$_lang["plugin_event_msg"] = 'Vyberte události, kterým bude tento plugin naslouchat.';
$_lang["plugin_management_msg"] = 'Zde si můžete vybrat, který plugin si přejete upravit.';
$_lang["plugin_msg"] = 'Zde můžete můžete přidat/upravit pluginy. Pluginy jsou "surové" PHP kódy, které se spouštějí při určitých Systémových událostech.';
$_lang["plugin_name"] = 'Název pluginu';
$_lang["plugin_priority"] = 'Upravit pořadí provedení pluginů podle události';
$_lang["plugin_priority_instructions"] = 'Pro změnu pořadí spouštěných Pluginů pro každou událost jej v rámci události přetáhněte. První spouštěný Plugin by měl být nahoře.';
$_lang["plugin_priority_title"] = 'Pořadí spouštěných Pluginů';
$_lang["plugin_title"] = 'Vytvořit/upravit plugin';
$_lang["preview"] = 'Náhled';
$_lang["preview_msg"] = 'Tohle je náhled na vaše poslední uložené změny. Kliknutím zde na <a href="javascript:;" onclick="saveRefreshPreview();">Uložit a obnovit</a> uložíte vaše současné změny';
$_lang["preview_resource"] = 'Náhled dokumentu';
$_lang["private"] = 'Soukromý';
$_lang["public"] = 'Veřejný';
$_lang["publish_date"] = 'Datum publikování';
$_lang["publish_events"] = 'Události - publikování';
$_lang["publish_resource"] = 'Publikovat dokument';
$_lang["rb_base_dir_message"] = 'Zadejte fyzickou cestu ke zdrojovému adresáři. Toto nastavení je obvykle generováno automaticky. Jestliže používate IIS, MODX může zpracovat cestu nesprávně, což může způsobit, že prohlížeč zdrojů zobrazí chybu. V takovéto případě můžete vložit cestu k adresáři obrázků sem (cesta, kterou byste viděli ve Windows Exploreru). <b>Poznámka:</b> Zdrojový adresář musí obsahovat podsložky images, files, flash a media, aby prohlížeč zdrojů fungoval správně.';
$_lang["rb_base_dir_title"] = 'Cesta ke zdrojům:';
$_lang["rb_base_url_message"] = 'Zadejte virtuální cestu ke zdrojovému adresáři. Toto nastavení je obvykle vytvořeno automaticky. Jestliže používate IIS, MODX může zpracovat URL nesprávně, což může způsobit, že prohlížeč zdrojů zobrazí chybu. V takovéto případě můžete vložit URL k adresáři obrázků sem (URL, kterou byste viděli ve Internet Exploreru).';
$_lang["rb_base_url_title"] = 'URL zdrojů:';
$_lang["rb_message"] = 'Vyberte Ano k povolení prohlížeče zdrojů. Toto nastavení povolí uživatelům prohlížet a nahrávat zdroje jako obrázky, flash a ostatní soubory na server.';
$_lang["rb_title"] = 'Povolit prohlížeč zdrojů:';
$_lang["rb_webuser_message"] = 'Chcete návětevníkům povolit používat Správce souborů? <b>POZOR:</b> Povolením Návštěvníkům používat Správce souborů vystavujete Vaše soubory bezpečnostnímu riziku. Tuto volbu zvolte pouze pro důvěryhodné Návštěvníky.';
$_lang["rb_webuser_title"] = 'Návštěvník?';
$_lang["recent_docs"] = 'Poslední dokumenty';
$_lang["recommend_setting_change_title"] = 'Doporučena změna nastavení';
$_lang["recommend_setting_change_description"] = 'Váš web není nastaven pro ověřování HTTP_REFERER příchozích dotazů do Manager. Doporučejeme Vám zapnutí tohoto nastavení, předejdete tím možnému CSRF (Cross Site Request Forgery) útoku.';
$_lang["refresh_cache"] = 'Vyrovnávací paměť (cache): Počet souborů umístěných v adresáři cache <b>%s</b> a smazáno <b>%d</b> vyrovnávacích souborů.<p>Nové vyrovnávací soubory budou vytvořeny až to budou stránky vyžadovat.';
$_lang["refresh_published"] = 'Počet publikovaných dokumentů: <b>%s</b>';
$_lang["refresh_site"] = 'Vyrovnávací paměť';
$_lang["refresh_title"] = 'Obnovení stránek';
$_lang["refresh_tree"] = 'Obnovit adresářový strom';
$_lang["refresh_unpublished"] = 'Počet dokumentů s ukončenou dobou publikování: <b>%s</b>';
$_lang["release_date"] = 'Datum vydání';
$_lang["remember_last_tab"] = 'Pamatovat záložky';
$_lang["remember_last_tab_message"] = 'Stránky manažeru se záložkami se budou nahrávat s naposledy otevřenými záložkami, normálně se zobrazuje první záložka.';
$_lang["remember_username"] = 'Zapamatovat si heslo';
$_lang["remove"] = 'Odstranit';
$_lang["remove_date"] = 'Odstranit datum';
$_lang["remove_locks"] = 'Odstranit zámky';
$_lang["rename"] = 'Přejmenovat';
$_lang["reports"] = 'Hlášení';
$_lang["require_tagname"] = 'Je požadován název značky';
$_lang["require_tagvalue"] = 'Je požadována hodnota tagu';
$_lang["reserved_name_warning"] = 'Tento název nelze použít. Jedná se o název, který je vyhrazen systému.';
$_lang["reset"] = 'Vymazat';
$_lang["reset_failedlogins"] = 'reset';
$_lang["resource"] = 'Dokument';
$_lang["resource_alias"] = 'Zástupce dokumentu';
$_lang["resource_alias_help"] = 'Zde můžete zvolit zástupce pro tento dokument. Pro lehčí přístup k dokumentu použijte:

http://vase_domena/zastupce

Zástupce bude pracovat jen při aktivování funkce zjednodušených url adres.';
$_lang["resource_content"] = 'Obsah';
$_lang["resource_description"] = 'Popis';
$_lang["resource_description_help"] = 'Sem můžete zadat podrobný popis dokumentu.';
$_lang["resource_duplicate"] = 'Duplikovat dokument';
$_lang["resource_long_title_help"] = 'Zde můžete vložit dlouhý název vašeho dokumentu. Je to vhodné kvůli vyhledávání a mohl by víc charakterizovat váš dokument.';
$_lang["resource_metatag_help"] = 'Vyberte META tagy nebo klíčová slova, která si přejete přiřadit k tomuto dokumentu. Při výběru více klíčových slov nebo META tagů držte zmáčknutou klávesu CTRL.';
$_lang["resource_opt_contentdispo"] = 'Obsah uspořádání';
$_lang["resource_opt_contentdispo_help"] = 'Použít pole \'obsah uspořádání\' k bližšímu určení, jak tento dokument bude ovládán webovým prohlížečem. Pro stažení souboru vyberte volbu Příloha.';
$_lang["resource_opt_emptycache"] = 'Vyprázdnit zásobník?';
$_lang["resource_opt_emptycache_help"] = 'Vyberte tuto položku, jestliže chcete, aby MODX vyprázdnil zásobník po uložení dokumentu. Vaši návštěvníci tak neuvidí starší verze tohoto dokumentu.';
$_lang["resource_opt_folder"] = 'Složka?';
$_lang["resource_opt_folder_help"] = 'Určete, zda se tento vytvořený dokument bude chovat jako složka dokumentů nebo jako dokument. \'Složka\' může také mít obsah.';
$_lang["resource_opt_menu_index"] = 'Index&nbsp;(řazení)';
$_lang["resource_opt_menu_index_help"] = 'Řazení je funkce, kterou můžete použít pro řazení dokumentů ve Vašem snippetu, vytvářejícím menu. Můžete ho použít i pro další účely, jestliže je bude Váš snippet podporovat.';
$_lang["resource_opt_menu_title"] = 'Nadpis menu';
$_lang["resource_opt_menu_title_help"] = 'Nadpis menu je pole, které mužete použít ke znázornění krátkého nadpisu pro dokumet umístěný ve vašem snipettu menu nebo modulech.';
$_lang["resource_opt_published"] = 'Publikovat?';
$_lang["resource_opt_published_help"] = 'Zatržením této volby bude dokument publikovaný hned po uložení.';
$_lang["resource_opt_richtext"] = 'Externí editor?';
$_lang["resource_opt_richtext_help"] = 'Nechte tuto volbu zatrženou pro použití externího editoru k úpravě dokumentů. Jestliže vaše dokumenty obsahují Javaskripty anebo formuláře, zrušte označení a můžete upravovat dokument v HTML módu.';
$_lang["resource_opt_show_menu"] = 'Zobrazit v menu';
$_lang["resource_opt_show_menu_help"] = 'Výběr této volby zobrazuje dokument v menu. Prosím poznamenejte si, že některé snippety typu Menu Builders mohou mít nastavení, která ignoruje tuto volbu.';
$_lang["resource_opt_trackvisit_help"] = 'Zapisuj přístup každého návštěvníka na tuto stránku';
$_lang["resource_overview"] = 'Přehled dokumentu';
$_lang["resource_parent"] = 'Umístění dokumentu';
$_lang["resource_parent_help"] = 'Klikněte v adresářovém stromě na ikonku složky pro jeho otevření (zavření), a potom na dokument v stromu, který chcete nastavit jako umístění dokumentu.';
$_lang["resource_permissions_error"] = 'Přiřaďte tento dokument alespoň do jedné skupiny dokumentů, kterou můžete používat.';
$_lang["resource_setting"] = 'Nastavení dokumentu';
$_lang["resource_summary"] = 'Souhrn (introtext)';
$_lang["resource_summary_help"] = 'Model stručného souhrnu dokumentu';
$_lang["resource_title"] = 'Nadpis';
$_lang["resource_title_help"] = 'Sem napíšte název anebo titulek dokumentu. Pokuste se vyvarovat použití zpětných lomítek v názvu!';
$_lang["resource_to_be_moved"] = 'Dokument bude přesunut';
$_lang["resource_type"] = 'Typ zdroje';
$_lang["resource_type_message"] = 'Webové odkazy odkazují na internetové zdroje jako MODX stránky, externí stránky, obrázky nebo jiné soubory na internetu. Webové odkazy by měli obsahovat text/html Internet Media Type a Inline Content-Disposition.';
$_lang["resource_type_weblink"] = 'Webový odkaz';
$_lang["resource_type_webpage"] = 'Webová stránka';
$_lang["resource_weblink_help"] = 'Vložte adresu objektu, na který chcete odkazovat.';
$_lang["resources_in_container"] = 'dokumenty v této složce';
$_lang["resources_in_container_no"] = 'Tato složka nemá potomky';
$_lang["role"] = 'Role';
$_lang["role_about"] = 'Zobrazení informací o stránkách';
$_lang["role_access_persmissions"] = 'Přístupová práva';
$_lang["role_actionok"] = 'Prohlížení dokončené akce na obrazovce';
$_lang["role_bk_manager"] = 'Použít správce zálohy';
$_lang["role_cache_refresh"] = 'Vyprázdnit zásobník stránek (cache)';
$_lang["role_change_password"] = 'Změna hesla';
$_lang["role_change_resourcetype"] = 'Změnit typ zdroje';
$_lang["role_chunk_management"] = 'Správa chunků';
$_lang["role_config_management"] = 'Správa nastavení';
$_lang["role_content_management"] = 'Správa obsahu';
$_lang["role_create_chunk"] = 'Vytvořit nové chunky';
$_lang["role_create_doc"] = 'Vytvořit nové dokumenty';
$_lang["role_create_plugin"] = 'Vytvořit nové pluginy';
$_lang["role_create_snippet"] = 'Vytvořit nové snippety';
$_lang["role_create_template"] = 'Vytvořit novou šablonu stránek';
$_lang["role_credits"] = 'Zobrazení poděkování';
$_lang["role_delete_chunk"] = 'Smazat chunky';
$_lang["role_delete_doc"] = 'Smazat dokumenty';
$_lang["role_delete_eventlog"] = 'Smazat výpisy událostí';
$_lang["role_delete_module"] = 'Smazat modul';
$_lang["role_delete_plugin"] = 'Smazat pluginy';
$_lang["role_delete_role"] = 'Smazat oprávnění';
$_lang["role_delete_snippet"] = 'Smazat snippety';
$_lang["role_delete_template"] = 'Smazat šablony';
$_lang["role_delete_user"] = 'Smazat uživatele';
$_lang["role_delete_web_user"] = 'Smazat návštěvníka';
$_lang["role_edit_chunk"] = 'Upravit chunky';
$_lang["role_edit_doc"] = 'Upravit dokument';
$_lang["role_edit_doc_metatags"] = 'Upravit META tagy a klíčové slova dokumentu';
$_lang["role_edit_module"] = 'Upravit modul';
$_lang["role_edit_plugin"] = 'Upravit pluginy';
$_lang["role_edit_role"] = 'Upravit oprávnění';
$_lang["role_edit_settings"] = 'Změnit nastavení stránek';
$_lang["role_edit_snippet"] = 'Upravit snippety';
$_lang["role_edit_template"] = 'Upravit šablony stránek';
$_lang["role_edit_user"] = 'Upravit uživatele';
$_lang["role_edit_web_user"] = 'Upravit návštěvníky';
$_lang["role_empty_trash"] = 'Permanentně odstranit smazané dokumenty';
$_lang["role_errors"] = 'Zobrazit chybová hlášení';
$_lang["role_eventlog_management"] = 'Správa výpisu událostí';
$_lang["role_export_static"] = 'Exportovat statické HTML';
$_lang["role_file_manager"] = 'Použít správce souborů';
$_lang["role_frames"] = 'Použít rámy správce';
$_lang["role_help"] = 'Zobrazit pomocníka';
$_lang["role_home"] = 'Použít správce úvodní stránky';
$_lang["role_import_static"] = 'Importovat HTML';
$_lang["role_logout"] = 'Odhlásit se ze správce';
$_lang["role_manage_metatags"] = 'Upravit META tagy a klíčové slova celého webu';
$_lang["role_management_msg"] = 'Zde můžete zvolit oprávnění, které chcete upravit.';
$_lang["role_management_title"] = 'Oprávnění';
$_lang["role_messages"] = 'Číst a posílat zprávy';
$_lang["role_module_management"] = 'Správa modulů';
$_lang["role_name"] = 'Název oprávnění';
$_lang["role_new_module"] = 'Vytvořit nový modul';
$_lang["role_new_role"] = 'Vytvořit nová oprávnění';
$_lang["role_new_user"] = 'Vytvořit nové užívatele';
$_lang["role_new_web_user"] = 'Vytvořit nového návštěvníka';
$_lang["role_plugin_management"] = 'Správa pluginů';
$_lang["role_publish_doc"] = 'Publikované dokumenty';
$_lang["role_remove_locks"] = 'Odstranit zámky';
$_lang["role_role_management"] = 'Oprávnění';
$_lang["role_run_module"] = 'Spustit modul';
$_lang["role_save_chunk"] = 'Uložit chunky';
$_lang["role_save_doc"] = 'Uložit dokumenty';
$_lang["role_save_module"] = 'Uložit modul';
$_lang["role_save_password"] = 'Uložit heslo';
$_lang["role_save_plugin"] = 'Uložit pluginy';
$_lang["role_save_role"] = 'Uložit oprávnění';
$_lang["role_save_snippet"] = 'Uložit snippety';
$_lang["role_save_template"] = 'Uložit šablony';
$_lang["role_save_user"] = 'Uložit uživatele';
$_lang["role_save_web_user"] = 'Uložit návštěvníky';
$_lang["role_snippet_management"] = 'Správa snippetů';
$_lang["role_template_management"] = 'Správa šablon';
$_lang["role_title"] = 'Tvorba/úprava oprávnění';
$_lang["role_udperms"] = 'Správa práv';
$_lang["role_user_management"] = 'Správa užívatelů';
$_lang["role_view_docdata"] = 'Zobrazit data dokumentu';
$_lang["role_view_eventlog"] = 'Zobrazit výpis událostí';
$_lang["role_view_logs"] = 'Zobrazit systémové výpisy';
$_lang["role_view_unpublished"] = 'Zobrazit nepublikované dokumenty';
$_lang["role_web_access_persmissions"] = 'Webová přístupová práva';
$_lang["role_web_user_management"] = 'Správa návštěvníků';
$_lang["rss_url_news_default"] = 'https://feeds.feedburner.com/evocms-release-news';
$_lang["rss_url_news_message"] = 'Zadejte URL adresu pro načítání MODX RSS novinek.';
$_lang["rss_url_news_title"] = 'RSS novinky';
$_lang["rss_url_security_default"] = 'https://feeds.feedburner.com/evocms-security-news';
$_lang["rss_url_security_message"] = 'Zadejte URL adresu pro načítání MODX bezpečnostních zpráv.';
$_lang["rss_url_security_title"] = 'RSS bezpečnostní zprávy';
$_lang["run_module"] = 'Spustit modul';
$_lang["saturday"] = 'Sobota';
$_lang["save"] = 'Uložit';
$_lang["save_all_changes"] = 'Uložit všechny změny';
$_lang["save_tag"] = 'Uložit tag';
$_lang["saving"] = 'Ukládám, prosím čekejte...';
$_lang["search"] = 'Hledat';
$_lang["search_criteria"] = 'Vyhledávací kritéria';
$_lang["search_criteria_content"] = 'Hledat v obsahu';
$_lang["search_criteria_content_msg"] = 'Najít všechny dokumenty obsahující zadaný text.';
$_lang["search_criteria_id"] = 'Hledat podle ID';
$_lang["search_criteria_id_msg"] = 'Zadajte ID dokumentu rychlého vyhledávání.';
$_lang["search_criteria_template_id"] = 'Search by template ID';
$_lang["search_criteria_template_id_msg"] = 'Find all Resources using the specified template.';
$_lang["search_criteria_longtitle"] = 'Hledat podle dlouhého názvu';
$_lang["search_criteria_longtitle_msg"] = 'Najít všechny dokumenty s vloženým textem v dlouhém názvu.';
$_lang["search_criteria_title"] = 'Hledat podle názvu';
$_lang["search_criteria_title_msg"] = 'Najít všechny dokumenty se zadaným textem v nadpise.';
$_lang["search_empty"] = 'Zadaným vyhledávacím kritériům neodpovídá žádný dokument.';
$_lang["search_item_deleted"] = 'Tento dokument byl smazán';
$_lang["search_results"] = 'Výsledky vyhledávání';
$_lang["search_results_returned_desc"] = 'Popis';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Vaše vyhledávací kritéria vrací <b>%s</b> dokumentů. Jestliže máte mnoho výsledků, zkuste vložit více specifické slovo. ';
$_lang["search_results_returned_title"] = 'Nadpis';
$_lang["search_view_docdata"] = 'Zobrazit tuto položku';
$_lang["security"] = 'Zabezpečení';
$_lang["security_notices_tab"] = 'Bezpečnostní oznámení';
$_lang["security_notices_title"] = 'Bezpečnostní oznámení';
$_lang["select_date"] = 'Vybrat datum';
$_lang["send"] = 'Poslat';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Jestliže vaše stránky používají zabezpečený přístup https, zde můžete tento způsob zadat.';
$_lang["server_protocol_title"] = 'Typ serveru:';
$_lang["serveroffset"] = 'Časový posun oproti serveru';
$_lang["serveroffset_message"] = 'Vyberte hodnotu rozdílu času mezi vaším časovým pásmem s pásmem nastaveným na serveru. Současný čas na serveru je <b>[%s]</b>, čas na serveru po použití a uložení kompenzace je <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Časový posun oproti serveru:';
$_lang["servertime"] = 'Čas serveru';
$_lang["settings_after_install"] = 'Protože jde o novou instalaci, bude potřeba zkontrolovat nastavení MODX nebo ho upravit. Po kontrole nastavení kliněte na \'Uložit\' pro aktulizaci nastavení v databázi.<br /><br />';
$_lang["settings_config"] = 'Konfigurace';
$_lang["settings_dependencies"] = 'Závislosti';
$_lang["settings_events"] = 'Systemové události';
$_lang["settings_furls"] = 'Zjednodušené URL';
$_lang["settings_general"] = 'Všeobecné';
$_lang["settings_misc"] = 'Správce souborů';
$_lang["settings_KC"] = 'File Browser';
$_lang["settings_page_settings"] = 'Nastavení stránky';
$_lang["settings_photo"] = 'Foto';
$_lang["settings_properties"] = 'Vlastnosti';
$_lang["settings_site"] = 'Web';
$_lang["settings_strip_image_paths_message"] = 'Jestliže nastavíte \'Ne\', MODX zapíše cestu ke zdroji (obrázek, soubor, flash atd.) jako absolutní. Relativní adresy jsou dobré, jestliže budete přesouvat vaši instalaci MODX. Jestliže si nejste jistí, co to znamená, je nejlepší nastavit volbu na \'Ano\'.';
$_lang["settings_strip_image_paths_title"] = 'Přepsat cestu k obrázkům?';
$_lang["settings_templvars"] = 'Template Variables';
$_lang["settings_title"] = 'Konfigurace systému';
$_lang["settings_ui"] = 'Rozhraní & vzhled';
$_lang["settings_users"] = 'Uživatel';
$_lang["show_meta"] = 'Zobrazit záložku META klíčových slov';
$_lang["show_meta_message"] = 'Zobrazit zastaralou editaci META klíčových slov při editaci dokumentu v Manager.';
$_lang["show_tree"] = 'Ukázat strom dokumentů';
$_lang["showing"] = 'Zobrazení';
$_lang["signupemail_message"] = 'Zde můžete nastavit zprávu odesílanou uživatelům po vytvoření účtu. MODX potom odešle email obsahujíci jejich uživatelské jméno a heslo. <b>Poznámka:</b> Následující rezervovaná místa (placeholders) budou nahrazena Správcem obsahu, když pošle zprávu: <br /><br />[+sname+] - Jméno Vaší webové stránky, <br />[+saddr+] - Emailová adresa Vašich stránek, <br />[+surl+] - URL Vašich stránek, <br />[+uid+] - Uživatelské přihlašovací jméno nebo id, <br />[+pwd+] - Uživatelské heslo, <br />[+ufn+] - Celé uživatelovo jméno. <br /><br /><b>Vynecháním [+uid+] a [+pwd+] v emailu způsobíte, že se uživatel nedozví své uživatelské jméno a heslo!</b>';
$_lang["signupemail_title"] = 'Obsah emailu:';
$_lang["site"] = 'Web';
$_lang["site_schedule"] = 'Program';
$_lang["sitename_message"] = 'Zde zadejte název Vašich stránek.';
$_lang["sitename_title"] = 'Název stránky:';
$_lang["sitestart_message"] = 'Zde zadejte ID dokumentu, který budete chtít použít jako svojí úvodní stránku webu. <b>Poznámka: Je nutné vložit ID existujícího dokumentu, který musí být publikován!</b>';
$_lang["sitestart_title"] = 'Úvodní stránka:';
$_lang["sitestatus_message"] = 'Vyberte \'Online\' pro publikování vašich stránek na webu. Jestliže vyberete \'Offline\', návštěvníci uvidí pouze nadpis stránky \'Stránky jsou nedostupné\' a nebudou moci si je prohlížet.';
$_lang["sitestatus_title"] = 'Status webu:';
$_lang["siteunavailable_message"] = 'Tato zpráva se objeví, když jsou stránky ve stavu offline, anebo když dojde k chybě. <b>Poznámka: Tato zpráva se zobrazí jen tehdy, když není nastavena chybová stránka.</b>';
$_lang["siteunavailable_message_default"] = 'Stránky jsou v současné chvíli nedostupné.';
$_lang["siteunavailable_page_message"] = 'Zadejte ID dokumentu, který chcete zobrazit, když jsou stránky offline. <b>POZNÁMKA: Ujistěte se, že ID dokumentu patří existujícímu dokumentu, a že je publikován!</b>';
$_lang["siteunavailable_page_title"] = 'Stránka při nedosažitelnosti webu:';
$_lang["siteunavailable_title"] = 'Stránky jsou nedostupné:';
$_lang["snippet"] = 'Snippet';
$_lang["snippet_code"] = 'Kód snippetu (php)';
$_lang["snippet_desc"] = 'Popis';
$_lang["snippet_execonsave"] = 'Provést snippet po uložení.';
$_lang["snippet_management_msg"] = 'Zde můžete zvolit snippet, který chcete upravit.';
$_lang["snippet_msg"] = 'Zde můžete přidávat anebo upravovat snippety. Pamatujte, že snippety jsou \'surové\' php skripty a když očekáváte výstup ze snippetu, který bude ukazovat na některé místo v šabloně, musí vracet hodnutu ze snippetu.';
$_lang["snippet_name"] = 'Název snippetu';
$_lang["snippet_properties"] = 'Výchozí vlastnosti';
$_lang["snippet_title"] = 'Vytvořit/upravit snippet';
$_lang["sort_asc"] = 'Vzestupně';
$_lang["sort_desc"] = 'Sestupně';
$_lang["sort_tree"] = 'Uspořádat strom';
$_lang["source"] = 'Zdroj';
$_lang["stay"] = 'Pokračovat v úpravách';
$_lang["stay_new"] = 'Přidat další';
$_lang["submit"] = 'Potvrdit';
$_lang["sunday"] = 'Neděle';
$_lang["sys_alert"] = 'Výstraha systému';
$_lang["sysinfo_activity_message"] = 'Tento výpis informuje, které dokumenty byli nedávno upravované uživateli.';
$_lang["sysinfo_userid"] = 'Uživatel';
$_lang["system_email_signup"] = 'Dobrý den [+uid+]

Zde jsou podrobnosti k vašemu přihlášení pro [+sname+] do správce obsahu:

Uživatel: [+uid+]
Heslo: [+pwd+]

Při prvním přihlášení si můžete změnit heslo.

S pozdravem,
správce stránek';
$_lang["system_email_webreminder"] = 'Dobrý den [+uid+]

K aktivaci nového hesla klikněte na následující odkaz:

[+surl+]

Jestliže vše proběhlo v pořádku, můžete užívat následující heslo k přihlášení:

Heslo:[+pwd+]

Jestliže jste si tento e-mail nevyžádali, tak ho prosím ignorujte.

S pozdravem,
správce stránek';
$_lang["system_email_websignup"] = 'Dobrý den [+uid+]

Zde jsou podrobnosti k vašemu přihlášení do [+sname+]:

Uživatel: [+uid+]
Heslo: [+pwd+]

Při prvním přihlášení do [+sname+] si můžete změnit heslo.

S pozdravem,
správce stránek';
$_lang["table_hoverinfo"] = 'Zastavením kurzoru myši nad jménem tabulky zobrazí se krátký popis funkce tabulky (ne všechny tabulky mají nastaveny <i>komentáře</i>).';
$_lang["table_prefix"] = 'Předpona tabulek';
$_lang["tag"] = 'Značka';
$_lang["template"] = 'Šablona';
$_lang["template_assignedtv_tab"] = 'Přiřazené Template Variables';
$_lang["template_code"] = 'Kód šablony (html)';
$_lang["template_desc"] = 'Popis';
$_lang["template_edit_tab"] = 'Upravit šablonu';
$_lang["template_management_msg"] = 'Zde můžete zvolit šablonu, kterou chcete upravit.';
$_lang["template_msg"] = 'Zde můžete vytvářet/upravovat šablony. Nové anebo upravené šablony nebudou viditelné ve stránkach uložených v zásobníku až do jeho vyprázdnění. Můžete použít náhled stránek pro prohlédnutí šablony v činnosti.';
$_lang["template_name"] = 'Název šablony';
$_lang["template_no_tv"] = 'Žádná Template Variables nebyla přiřazena této šabloně.';
$_lang["template_reset_all"] = 'Vymazat všechny stránky pro použití základní šablony';
$_lang["template_reset_specific"] = 'Vymazat jen "%s" stránky';
$_lang["template_assigned_blade_file"] = 'Odpovídající soubor blade';
$_lang["template_create_blade_file"] = 'Po uložení vytvořte soubor šablony';
$_lang["template_title"] = 'Vytvořit/upravit šablonu';
$_lang["template_tv_edit"] = 'Upravit uspořádání Template Variables';
$_lang["template_tv_edit_message"] = 'Změnu pořadí Template Variables pro tuto šablonu je možné určit přetažením.';
$_lang["template_tv_edit_title"] = 'Pořadí Template Variable';
$_lang["template_tv_msg"] = 'Template Variables přiřazené této šabloně jsou uspořádány níže';
$_lang["thursday"] = 'Čtvrtek';
$_lang["tmplvar_access_msg"] = 'Vyberte skupinu dokumentů, kterým bude povoleno měnit obsah nebo hodnotu této proměnné';
$_lang["tmplvar_change_template_msg"] = 'Změna této šablony zapříčiní znovunačtení Template Variables. Všechny neuložené změny budou ztraceny.\n\n Opravdu chcete změnit šablonu?';
$_lang["tmplvar_inuse"] = 'Následující dokument(y) používá(jí) tuto Template Variable. Pro pokračování smazání klikněte na tlačítko Smazat, zrušit mazání můžete pomocí tlačítka Zrušit.';
$_lang["tmplvar_tmpl_access"] = 'Přístup k šabloně';
$_lang["tmplvar_tmpl_access_msg"] = 'Vyberte šablony, které budou přístupné této proměnné';
$_lang["tmplvars"] = 'Template Variables';
$_lang["tmplvars_binding_msg"] = 'Toto pole podporuje zdroj dat vázaný na užití @ příkazů';
$_lang["tmplvars_caption"] = 'Hlavička';
$_lang["tmplvars_default"] = 'Původní hodnota';
$_lang["tmplvars_description"] = 'Popis';
$_lang["tmplvars_elements"] = 'Volba hodnoty vstupu';
$_lang["tmplvars_inherited"] = 'Value inherited';
$_lang["tmplvars_management_msg"] = 'Spravovat přidaná pole uživatelského obsahu (Template Variables) vašich dokumentů.';
$_lang["tmplvars_msg"] = 'Zde můžete přidávat a upravovat Template Variables. Každá Template Variable musí být zpřístupněna pro danou šablonu, aby mohla být přístupná, mj. z aktivních prvků a dokumentů, stejně jako jiné proměnné.';
$_lang["tmplvars_name"] = 'Jméno proměnné';
$_lang["tmplvars_novars"] = 'Žádné Template Variables nenalezeny';
$_lang["tmplvars_rank"] = 'Uspořádání';
$_lang["tmplvars_reset_params"] = 'Resetovat parametery';
$_lang["tmplvars_title"] = 'Vytvořit/upravit Template Variable';
$_lang["tmplvars_type"] = 'Typ vstupu';
$_lang["tmplvars_widget"] = 'Výstup';
$_lang["tmplvars_widget_prop"] = 'Možnosti výstupu';
$_lang["to"] = 'do';
$_lang["tools"] = 'Nástroje';
$_lang["top_howmany_message"] = 'Když prohlížíte výpisy ve statistikách, určujete počet položek zobrazených v seznamech "Nejlepších ..."?';
$_lang["top_howmany_title"] = 'Kolik "Nejlepších ...." položek';
$_lang["total"] = 'celkem';
$_lang["track_visitors_message"] = 'Toto nastavení nemá žádný efekt, pokud máte nainstalováno sledování návštěvníků nebo statistiky, které podporují toto nastavení. Logování návštěv vám umožní zobrazit uživatelské statistiky vašich stránek.';
$_lang["track_visitors_title"] = 'Logování návštěv (statistiky)';
$_lang["tree_page_click"] = 'Chování stránky při kliknutí';
$_lang["tree_page_click_message"] = 'Výchozí chování při kliknutí na stránku ve stromu dokumentů.';
$_lang["tree_show_protected"] = 'Ukázat chráněné stránky';
$_lang["tree_show_protected_message"] = 'Pokud nastavíte "Ne", chráněné stránky (a žádní jejich potomci) se nezobrazí ve stromu dokumentů. "Ne" je výchozím nastavením MODX.';
$_lang["truncate_table"] = 'Klikněte sem pro vyprázdnění této tabulky';
$_lang["tuesday"] = 'Úterý';
$_lang["tv"] = 'TV';
$_lang["type"] = 'Typ';
$_lang["udperms_allowroot_message"] = 'Chcete povolit Vašim užívatelům vytvářet nové dokumenty/složky v kořenovém adresáři stránek? Bez tohoto povolení nebudou moci dokument/složku vytvořit!';
$_lang["udperms_allowroot_title"] = 'Povolit kořenový adresář (root):';
$_lang["udperms_message"] = 'Pomocí přístupových oprávnění určujete stránky, které Vaši uživatelé můžou editovat. Bude potřeba přidělit Vašim uživatelům uživatelské skupiny a dokumentům skupiny dokumentů. Dál musíte určit, kterým užívatelským skupinám povolíte přístup do stanovených skupin dokumentů. Jestliže poprvé tuto funkci zapnete, jen administrátor bude moci upravovat dokumenty.';
$_lang["udperms_title"] = 'Přístupová práva:';
$_lang["unable_set_link"] = 'Nemožné nastavit odkaz!';
$_lang["unable_set_parent"] = 'Není možné nastavit novou nadřazenou složku!';
$_lang["unauthorizedpage_message"] = 'Zadejte ID dokumentu, který chcete zobrazit uživatelům, jestliže požadujete zabezpečený nebo neautorizovaný dokument. <b>POZNÁMKA: Ujistěte se, že zadané ID dokumentu náleží existujícímu dokumentu, a že je publikován a veřejně přístupný!</b>';
$_lang["unauthorizedpage_title"] = 'Stránka neautorizovaného přístupu:';
$_lang["unblock_message"] = 'Tento uživatel nebude zablokován po uložení jeho dat.';
$_lang["undelete_resource"] = 'Obnovit dokument';
$_lang["unpublish_date"] = 'Datum ukončení publikování';
$_lang["unpublish_events"] = 'Události - ukončení publikování';
$_lang["unpublish_resource"] = 'Ukončit publikaci';
$_lang["untitled_resource"] = 'Dokument bez názvu';
$_lang["untitled_weblink"] = 'Odkaz bez názvu';
$_lang["update_params"] = 'Aktualizovat parametr zobrazení';
$_lang["update_settings_from_language"] = 'Nahradit současný s:';
$_lang["upload_maxsize_message"] = 'Zadejte maximální velikost souboru, který může být nahrán prostřednictvím souborového správce. Velikost nahraného souboru musí být zadána v bajtech. <b>POZNÁMKA: Velké soubory se můžou nahrávat velmi dlohou dobu!</b>';
$_lang["upload_maxsize_title"] = 'Maximální velikost nahrávaného souboru';
$_lang["uploadable_files_message"] = 'Zde můžete zadat seznam souborů, které mohou být načtené do \'assets/files/\' použitím souborového správce. Přípony prosím oddělte čárkou.';
$_lang["uploadable_files_title"] = 'Typy souborů, které je možno nahrávat:';
$_lang["uploadable_flash_message"] = 'Zde můžete zadat seznam souborů, které mohou být načtené do \'assets/flash/\' použitím souborového správce. Přípony prosím oddělte čárkou.';
$_lang["uploadable_flash_title"] = 'Typy flash souborů, které je možno nahrávat:';
$_lang["uploadable_images_message"] = 'Zde můžete zadat seznam souborů, které mohou být načtené do \'assets/images/\' použitím souborového správce. Přípony prosím oddělte čárkou.';
$_lang["uploadable_images_title"] = 'Typy obrázků, které je možno nahrávat:';
$_lang["uploadable_media_message"] = 'Zde můžete zadat seznam souborů, které mohou být načtené do \'assets/media/\' použitím souborového správce. Přípony prosím oddělte čárkou.';
$_lang["uploadable_media_title"] = 'Typy médií, které je možno nahrávat:';
$_lang["use_alias_path_message"] = 'Nastavení této volby na \'Ano\' znázorní celou cestu k dokumentu, jestliže dokument má alias. Například, když dokument s aliasem \'podřízený\' je umístěn ve složce s aliasem \'nadřízený\', potom úplá cesta k dokumentu bude znázorněna jako \'/nadřízený/podřížený.html\'.<br /><b>Poznámka: Jestliže nastavíte tuto volbu na \'Ano\' (zapnete cestu k aliasu), musíte pro odkazované věci (jako obrázky, css, javascripty, atd.) používat absolutní cestu:  např., \'/assets/images\' oproti \'assets/images\'.</b>';
$_lang["use_alias_path_title"] = 'Cesta ke zjednodušenému aliasu:';
$_lang["use_editor_message"] = 'Chcete umožnit používání rozšíreného kontextového editoru? Můžete pohodlně navrhovat stránky v režimu WYSIWYG, anebo psát kód HTML. Také můžete editor střídavě vypínat výběrem této volby. Pamatujte, že toto nastavení je použité pro všechnu dokumenty a všechny uživatele!';
$_lang["use_editor_title"] = 'Povolit editor';
$_lang["user"] = 'Uživatel';
$_lang["user_block"] = 'Blokované';
$_lang["user_blockedafter"] = 'Zablokováno od';
$_lang["user_blockeduntil"] = 'Zablokováno do';
$_lang["user_changeddata"] = 'Vaše data byla změněna. Prosím přihlašte se znovu.';
$_lang["user_country"] = 'Země';
$_lang["user_dob"] = 'Datum narození';
$_lang["user_doesnt_exist"] = 'Uživatel neexistuje';
$_lang["user_edit_self_msg"] = '<b>Pravděpodobně se budete muset odhlásit a přihlásit znovu kvůli kompletní aktualizaci vaších informací.</b><br />Také byste si měli nechat vygenerovat nové heslo a nechat si ho poslat e-mailem.';
$_lang["user_email"] = 'Emailová adresa';
$_lang["user_failedlogincount"] = 'Chybná přihlášení';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Žena';
$_lang["user_full_name"] = 'Jméno a příjmení';
$_lang["user_gender"] = 'Pohlaví';
$_lang["user_is_blocked"] = 'Tento uživatel byl zablokován!';
$_lang["user_logincount"] = 'Počet přihlášení';
$_lang["user_male"] = 'Muž';
$_lang["user_management_msg"] = 'Zde můžete zvolit uživatele Správce obsahu, kterého chcete upravit. Uživatelé Správce obsahu jsou takový uživatelé, kteří mají povolené přihlášení do administrační části.';
$_lang["user_management_title"] = 'Správa uživatelů';
$_lang["user_mobile"] = 'Mobil';
$_lang["user_phone"] = 'Telefonní číslo';
$_lang["user_photo"] = 'Fotografie uživatele';
$_lang["user_photo_message"] = 'Vložte URL obrázku uživatele nebo použijte tlačítko "Vložit" k výběru nebo uploadu souboru s obrázkem na server.';
$_lang["user_prevlogin"] = 'Poslední přihlášení';
$_lang["user_role"] = 'Uživatelské oprávnění';
$_lang["user_state"] = 'Kraj';
$_lang["user_title"] = 'Vytvořit/upravit uživatele';
$_lang["user_upload_message"] = 'Jestliže si přejete zastavit uživatele v nahrávání jakéhokoli typu souborů v této kategorii, ujistěte se, že zaškrtávací políčko v \'Užít hlavní konfigurační nastavení\' není zatrženo a nechte pole prázdné.';
$_lang["user_use_config"] = 'Užít hlavní konfigurační nastavení';
$_lang["user_zip"] = 'PSČ';
$_lang["username"] = 'Uživatel';
$_lang["users"] = 'Zabezpečení';
$_lang["valid_hostnames_message"] = 'Help prevent XSS exploits misusing the site_url system setting by providing a comma separated list of valid hostnames for this installation. This is important for some types of shared hosts or hosts direct accessible via an IP address. First hostname in the list is used if the HTTP_HOST does not match any valid hostname.';
$_lang["valid_hostnames_title"] = 'Valid hostnames';
$_lang["validate_referer_message"] = 'Ověření hlaviček HTTP_REFERER z důvodů snížení nebezpečí, že by Váš editor mohl způsobit neúmyslé postupy ve správci jako oběť CSRF (Cross Site Request Forgery) útoku. Některé nastavení nemusí být použitelné pokud servr neposílá HTTP_REFERER hlavičky.';
$_lang["validate_referer_title"] = 'Ověřit hlavičky HTTP_REFERER';
$_lang["value"] = 'Hodnota';
$_lang["view"] = 'Zobrazit';
$_lang["view_child_resources_in_container"] = 'Zobrazit potomky';
$_lang["view_log"] = 'Zobrazit výpis';
$_lang["view_logging"] = 'Správce procesů';
$_lang["view_sysinfo"] = 'Systémové informace';
$_lang["warning"] = 'Varování!';
$_lang["warning_not_saved"] = 'Změny, které jste v dokumentu provedli, nebudou uložené. Můžete zvolit zda chcete na stránce setrvat a uložit změny (\'Storno\'), nebo stránku opustit a ztratit všechny změny, které jste udělali (\'OK\').';
$_lang["warning_visibility"] = 'Varování konfigurace viditelné pro';
$_lang["warning_visibility_message"] = 'Ovladač viditelnosti varování konfigurace zobrazeného na úvodní stránce manageru';
$_lang["web_access_permissions"] = 'Webová přístupová práva';
$_lang["web_access_permissions_user_groups"] = 'Skupiny návštěvníků';
$_lang["web_permissions"] = 'Webová práva';
$_lang["web_user_management_msg"] = 'Zde si můžete vybrat, kterého webového uživatele si přejete upravit. Pouze weboví uživatelé uvedení zde budou mít přístup do zabezpečené části webových stránek.';
$_lang["web_user_management_title"] = 'Návštěvníci';
$_lang["web_user_title"] = 'Vytvořit/upravit návštěvníka';
$_lang["web_users"] = 'Návštěvníci';
$_lang["weblink"] = 'Hypertextový odkaz';
$_lang["webpwdreminder_message"] = 'Zde napište zprávu, která bude odeslána vašim uživatelům, kteří požádají o přidělení nového hesla e-mailem. Správce obsahu odešle e-mail obsahující nové heslo a aktivační informace. <br /><b>Poznámka:</b> Následující značky (placeholders) budou nahrazeny při odesílání nahrazeny Správcem obsahu: <br /><br />[+sname+] - Jméno vaší webové stránky, <br />[+saddr+] - E-mailová adresa vašich stránek, <br />[+surl+] - URL vašich stránek, <br />[+uid+] - Uživatelské přihlašovací jméno nebo id, <br />[+pwd+] - Uživatelské heslo, <br />[+ufn+] - Celé uživatelovo jméno. <br /><br /><b>Vynecháním [+uid+] a [+pwd+] v e-mailu způsobíte, že se uživatel své uživatelské jméno a heslo!</b>';
$_lang["webpwdreminder_title"] = 'Nastavení emailu při zapomenutém hesle:';
$_lang["websignupemail_message"] = 'Zde můžete nastavit zprávu, která bude zaslána vašim uživatelům webu, když jim vytvoříte webový účet a necháte Správce obsahuzaslat jim e-mail obsahující jejich přístupové jméno a heslo. <br /><b>Poznámka:</b> Následující značky (placeholders) budou nahrazeny při odesílání nahrazeny Správcem obsahu: <br /><br />[+sname+] - Jméno vaší webové stránky, <br />[+saddr+] - E-mailová adresa vašich stránek, <br />[+surl+] - URL vašich stránek, <br />[+uid+] - Uživatelské přihlašovací jméno nebo id, <br />[+pwd+] - Uživatelské heslo, <br />[+ufn+] - Celé uživatelovo jméno. <br /><br /><b>Vynecháním [+uid+] a [+pwd+] v e-mailu způsobíte, že se uživatel své uživatelské jméno a heslo!</b>';
$_lang["websignupemail_title"] = 'Nastavení emailu pro webové přihlášení:';
$_lang["wednesday"] = 'Středa';
$_lang["welcome_messages"] = 'Vaše schránka obsahuje <b>%d</b> zpráv(y), z toho <b>%s</b> nepřečtených.';
$_lang["welcome_title"] = 'Vítejte v MODX správci obsahu';
$_lang["which_editor_message"] = 'Zde můžete zvolit, který rozšířený textový editor chcete používat. Můžete si stáhnout a nainstalovat další editory ze stránek MODX.';
$_lang["which_editor_title"] = 'Použít editor:';
$_lang["working"] = 'Pracuji...';
$_lang["wrap_lines"] = 'Zalomit řádky';
$_lang["xhtml_urls_message"] = 'Nahradí znak ampersand (&amp;) v URL adresách, které jsou generovány MODX za jejich validní zápis &amp;<!-- -->amp;';
$_lang["xhtml_urls_title"] = 'XHTML URL adresy';
$_lang["yes"] = 'Ano';
$_lang["you_got_mail"] = 'Dostali jste poštu';
$_lang["yourinfo_message"] = 'Toto místo zobrazí informace o Vaší osobě';
$_lang["yourinfo_previous_login"] = 'Vaše poslední přihlášení:';
$_lang["yourinfo_role"] = 'Vaše oprávnění je:';
$_lang["yourinfo_title"] = 'Vaše informace';
$_lang["yourinfo_total_logins"] = 'Celkový počet přihlášení:';
$_lang["yourinfo_username"] = 'Jste přihlášen jako:';

$_lang["a17_error_reporting_title"] = 'Detection level of the PHP error';
$_lang["a17_error_reporting_msg"] = 'Set the detection level of the PHP error.';
$_lang["a17_error_reporting_opt0"] = 'Ignore all';
$_lang["a17_error_reporting_opt1"] = 'Ignore the warning of a slight notice level(<a href="https://www.google.com/search?q=E_DEPRECATED+E_STRICT" target="_blank">E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT</a>)';
$_lang["a17_error_reporting_opt2"] = 'Detect all errors except E_NOTICE and E_USER_DEPRECATED';
$_lang["a17_error_reporting_opt99"] = 'Detect all except E_USER_DEPRECATED';
$_lang["a17_error_reporting_opt199"] = 'Detect all';

$_lang["pwd_hash_algo_title"] = 'Hash algorithm';
$_lang["pwd_hash_algo_message"] = 'Password hash algorithm.';

$_lang["enable_bindings_title"] = 'Enable @Bindings commands';
$_lang["enable_bindings_message"] = 'Prevents the execution of PHP functions through TV @Bindings. Useful if you have Manager users who should not be able to create PHP code but need to be able to create or edit TVs. The output of any TV with an @Binding will be "@Bindings disabled".';

$_lang["enable_filter_phx_warning"] = 'Pokud je povoleno PHX plugin, vestavěné filtry jsou ve výchozím nastavení zakázány';
$_lang["bkmgr_alert_mkdir"] = 'A file cannot be created in a directory.  Please check the permission of [+snapshot_path+]';
$_lang["bkmgr_restore_msg"] = '<p>A site can be restore using an SQL file. </p>';
$_lang["bkmgr_restore_title"] = 'Restore';
$_lang["bkmgr_import_ok"] = 'SQL recovery was performed normally.';
$_lang["bkmgr_snapshot_ok"] = 'The snapshot was saved normally.';
$_lang["bkmgr_run_sql_file_label"] = 'Execute by sql file';
$_lang["bkmgr_run_sql_direct_label"] = 'Direct execute SQL command strings';
$_lang["bkmgr_run_sql_submit"] = 'Execute restore';
$_lang["bkmgr_run_sql_result"] = 'Result';
$_lang["bkmgr_snapshot_title"] = 'Snapshot save and recovery';
$_lang["bkmgr_snapshot_msg"] = '<p>The contents of the database are saved and restored to a server.<br />Preservation place : [+snapshot_path+] ($modx->config[\'snapshot_path\'])</p>';
$_lang["bkmgr_snapshot_submit"] = 'Add snapshot';
$_lang["bkmgr_snapshot_list_title"] = 'List of snapshot';
$_lang["bkmgr_restore_submit"] = 'Vrátit tato data';
$_lang["bkmgr_restore_confirm"] = 'Jste si jisti, že chcete vrátit zálohu\n[+filename+] ?';
$_lang["bkmgr_snapshot_nothing"] = 'No snapshot';

$_lang["files.dynamic.php1"] = 'create text file';
$_lang["files.dynamic.php2"] = 'This directory cannot be displayed.';
$_lang["files.dynamic.php3"] = 'There is a problem in a file name.';
$_lang["files.dynamic.php4"] = 'The text file was created.';
$_lang["files_dynamic_new_folder_name"] = 'Enter new directory name:';
$_lang["files_dynamic_new_file_name"] = 'Enter new file name:';
$_lang["not_readable_dir"] = 'Can not read this directory.';
$_lang["confirm_delete_dir"] = 'Are you sure you want to delete the directory?';
$_lang["confirm_delete_dir_recursive"] = 'Are you sure you want to delete the directory?\n\nAny children files will also be deleted.';

$_lang["make_folders_title"] = 'Make end slash URL at the container';
$_lang["make_folders_message"] = 'The slash to append to Resources set as containers when using FURLs.';

$_lang["check_files_onlogin_title"] = 'Check core files on login';
$_lang["check_files_onlogin_message"] = 'By enabling this option, important system files will be checked for modification typical of scripted website attacks. While not a foolproof guarantee, it may alert you to a compromised MODX system file and website.';

$_lang["configcheck_sysfiles_mod"] = 'Important System Files have been modified.';
$_lang["configcheck_sysfiles_mod_msg"] = 'You have enabled the setting to check important system files to detect possible website script attacks. This doesn\'t necessarily mean that your site has been compromised, however, you should review the changed files.(index.php, .htaccess, [+MGR_DIR+]/index.php, [+MGR_DIR+]/includes/config.inc.php)';

$_lang['email_method_title'] = 'Sendmail method';
$_lang['email_method_mail'] = 'mail() PHP function';
$_lang['email_method_smtp'] = 'SMTP Server';
$_lang['smtp_auth_title'] = 'SMTP－AUTH';
$_lang['smtp_autotls_title'] = 'SMTPAutoTLS';
$_lang['smtp_host_title'] = 'SMTP host';
$_lang['smtp_secure_title'] = 'Encrypted SMTP';
$_lang['smtp_username_title'] = 'SMTP user name';
$_lang['smtp_password_title'] = 'SMTP password';
$_lang['smtp_port_title'] = 'SMTP port';

$_lang["setting_resource_tree_node_name"] = 'The node name of a resource tree';
$_lang["setting_resource_tree_node_name_desc"] = 'Specify the Resource field to use when rendering the nodes in the Resource Tree. Defaults to pagetitle, although any Resource field can be used, such as menutitle, alias.';

$_lang["resource_opt_alvisibled"] = 'Use current alias in alias path';
$_lang["resource_opt_alvisibled_help"] = 'The alias of this Resource is inserted in Friendly URL alias path';
$_lang['resource_opt_is_published'] = 'Publikovat';
$_lang["docid_incrmnt_method_title"] = 'Increment Resource ID method';
$_lang["docid_incrmnt_method_0"] = 'DB auto increment';
$_lang["docid_incrmnt_method_1"] = 'Minimum missed ID';
$_lang["docid_incrmnt_method_2"] = 'Maximal ID + 1';

$_lang["cache_type_title"] = 'Document caching type';
$_lang["cache_type_1"] = 'Cache is based only on document id (standard)';
$_lang["cache_type_2"] = 'Cache is based on document id and $_GET parameters';
$_lang["seostrict_title"] = 'Use SEO Strict URLs';
$_lang["seostrict_message"] = 'Enforces the use of strict URLs to prevent duplicate content if needed';

$_lang["settings_friendlyurls_alert"] = 'It is necessary to rename the ht.access file of a MODX installation directory at .htaccess to use the Friendly URL function.';
$_lang["settings_friendlyurls_alert2"] = 'Since it has installed in a subdirectory, it is necessary to change the contents of .htaccess.';

$_lang["user_street"] = 'Street';
$_lang["user_city"] = 'City';
$_lang["user_other"] = 'Other';

$_lang["mutate_settings.dynamic.php6"] = 'Send mail on MODX errors';
$_lang["mutate_settings.dynamic.php7"] = 'not notify';
$_lang["mutate_settings.dynamic.php8"] = 'A mail with the error source will be sent to [(emailsender)] ([+emailsender+]) if a MODX error occurs. The details of the error could be seen in the MODX system events log.';

$_lang["error_no_privileges"]         = "You don't have enough privileges for this action!";
$_lang["error_no_optimise_tablename"] = "Table to optimise not found in request!";
$_lang["error_no_truncate_tablename"] = "Table to truncate not found in request!";
$_lang["error_double_action"]         = "Double action (GET & POST) posted!";
$_lang["error_no_id"]                 = "ID not passed in request!";
$_lang["error_id_nan"]                = "ID passed in request is NaN!";
$_lang["error_no_parent"]             = "Couldn't find parent document's name!";
$_lang["error_many_results"]          = "Too many results returned from database!";
$_lang["error_no_results"]            = "Not enough/ no results returned from database!";
$_lang["error_no_user_selected"]      = "No user selected as recipient of this message!";
$_lang["error_no_group_selected"]     = "No group selected as recipient of this message!";
$_lang["error_movedocument1"]         = "Document cannot be it's own parent!";
$_lang["error_movedocument2"]         = "Document's ID not passed in request!";
$_lang["error_movedocument3"]         = "New parent not set in request!";

$_lang["login_processor_unknown_user"]       = "Incorrect username or password entered!";
$_lang["login_processor_wrong_password"]     = "Incorrect username or password entered!";
$_lang["login_processor_many_failed_logins"] = "Due to too many failed logins, you have been blocked!";
$_lang["login_processor_blocked1"]           = "You are blocked and cannot log in!";
$_lang["login_processor_blocked2"]           = "You are blocked and cannot log in! Please try again later.";
$_lang["login_processor_blocked3"]           = "You are blocked automatic after a specified date and you cannot log in anymore!";
$_lang["login_processor_bad_code"]           = "The security code you entered didn't validate! Please try to login again!";
$_lang["login_processor_remotehost_ip"]      = "Your hostname doesn't point back to your IP!";
$_lang["login_processor_remote_ip"]          = "You are not allowed to login from this location.";
$_lang["login_processor_date"]               = "You are not allowed to login at this time. Please try again later.";
$_lang["login_processor_captcha_config"]     = "Captcha is not configured properly.";

$_lang["dp_dayNames"]   = "['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']";
$_lang["dp_monthNames"] = "['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']";
$_lang["dp_startDay"]   = "1";

$_lang["check_all"] = "Select all";
$_lang["check_none"] = "Select none";
$_lang["check_toggle"] = "Toggle selection";

$_lang["role_no_tv"] = 'No Variables have been assigned to this Role yet.';
$_lang["role_notassigned_tv"] = 'These Variables are available for assigning.';
$_lang["role_tv_msg"] = 'The Variables assigned to this Role are listed below.';
$_lang["tmplvar_roles_access_msg"] = 'Select the Roles that are allowed to access/process this Template Variable';

$_lang["setting_from_file"] = '<strong class="text-danger">Parameter value is defined in core/custom/confic/cms/settings</strong>';

return $_lang;
