<?php
/**
 * EVO Manager language file
 *
 * @version 1.0.15
 * @date 2014/02/24
 * @author The EVO Project Team
 *
 * @language English
 * @package modx
 * @subpackage manager
 *
 * Please commit your language changes on Transifex (https://www.transifex.com/projects/p/modx-evolution/) or on GitHub (https://github.com/modxcms/evolution).
 */
//$modx_textdir = 'rtl'; // uncomment this line for RTL languages
$modx_lang_attribute = 'es'; // Manager HTML/XML Language Attribute see http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'UTF-8';

$_lang["about_msg"] = 'Evolution CMS es <a href="https://evo-cms.com/" target="_blank">un marco de aplicación PHP y un sistema de gestión de contenido</a> con la licencia <a href="https://www.gnu.org/licenses/gpl-3.0.html">GNU GPL</a>.';
$_lang["about_title"] = 'Aprender sobre el Evolution CMS';
$_lang["access_permission_denied"] = 'No tiene usted unos permisos correctos para este recurso.';
$_lang["access_permission_parent_denied"] = '¡No tiene un permiso para crear o mover el recurso aquí! Por favor elija otra ubicación.';
$_lang["access_permissions"] = 'Permisos de acceso';
$_lang["access_permissions_add_resource_group"] = 'Crear un grupo de recursos nuevo';
$_lang["access_permissions_add_user_group"] = 'Crear un grupo de usuarios nuevo';
$_lang["access_permissions_docs_message"] = 'Seleccionar a qué grupos de recursos pertenece este recurso';
$_lang["access_permissions_group_link"] = 'Crear un enlace de grupo nuevo';
$_lang["access_permissions_introtext"] = 'Administre usted los grupos de usuarios y los grupos de recursos utilizados para los permisos de acceso.
Para añadir un usuario al grupo de usuarios, abra usted el usuario y seleccione usted los grupos a que el usuario debe pertenecer.
Para añadir un recurso al grupo de usuarios, abra usted el recurso y seleccione usted los grupos a que el recurso debe pertenecer.';
$_lang["access_permissions_link_to_group"] = 'al grupo de recursos';
$_lang["access_permissions_context"] = 'en contexto';
$_lang["access_permissions_link_user_group"] = 'Enlazar el grupo de usuarios';
$_lang["access_permissions_links"] = 'Los enlaces de grupos de usuarios/recursos';
$_lang["access_permissions_links_tab"] = 'Especifique qué grupos de usuarios tienen acceso (es decir, pueden editar o crear recursos secondarios) a los grupos de recursos.
Para enlazar un grupo de recursos a un grupo de usuarios, seleccione usted los grupos apropiados del menú desplegable y haga usted clic en \'Enviar\'.
Para remover un enlace de cierto grupo, presione usted \'Remover\', esto removerá el enlace inmediatamente.';
$_lang["access_permissions_no_resources_in_group"] = 'Ninguno.';
$_lang["access_permissions_no_users_in_group"] = 'Ninguno.';
$_lang["access_permissions_off"] = '<span class="warning">Los permisos de acceso no están activados.</span> Esto significa que cualquiera de los cambios aquí realizados no tendrán ningún efecto hasta que los permisos de acceso estén activados en la configuración.';
$_lang["access_permissions_resource_groups"] = 'Grupos de recursos';
$_lang["access_permissions_resources_in_group"] = '<b>Los recursos en el grupo:</b> ';
$_lang["access_permissions_resources_tab"] = 'Vea que grupos de recursos se han creado. También cree los grupos nuevos, cambie los nombres de los grupos, elimine los grupos y vea que recursos están en los diferentes grupos (pase el cursor sobre la ID del recurso para ver su nombre).
Para añadir un recurso a un grupo o removerlo edite el recurso directamente.';
$_lang["access_permissions_user_toggle"] = 'Toggle access permissions';
$_lang["access_permissions_user_groups"] = 'Grupos de usuarios';
$_lang["access_permissions_user_message"] = 'Seleccione a que grupos de usuarios pertenece este usuario:';
$_lang["access_permissions_users_in_group"] = 'Usuarios en el grupo:';
$_lang["access_permissions_users_tab"] = 'Vea los grupos de usuarios creados. También puede crear grupos nuevos, renombrarlos, borrarlos y ver usuarios cuales son miembros de los grupos diferentes.
Para añadir un usuario nuevo a un grupo o removerlo, edite el usuario directamente. Los administradores (usuarios a los que se les ha asignado el rol con ID 1) siempre tienen acceso a todos los recursos por lo que no necesitan ser añadidos a ningún grupo.';
$_lang["account_email"] = 'Correo electrónico de cuenta';
$_lang["actioncomplete"] = '<b>¡La acción se completó con exito!</b><br /> - Espere mientras Evolution CMS hace limpieza.';
$_lang["activity_message"] = 'Esta lista muestra los últimos recursos que creó o editó:';
$_lang["activity_title"] = 'Recursos recien editados/creados';
$_lang["add"] = 'Añadir';
$_lang["add_chunk"] = 'Añadir un trozo (chunk)';
$_lang["add_doc"] = 'Añadir un recurso';
$_lang["add_folder"] = 'Carpeta nueva';
$_lang["add_plugin"] = 'Añadir una extensión (plugin)';
$_lang["add_resource"] = 'Recurso nuevo';
$_lang["add_snippet"] = 'Añadir un fragmento (snippet)';
$_lang["add_tag"] = 'Añadir una etiqueta (tag)';
$_lang["add_template"] = 'Añadir una plantilla (template)';
$_lang["add_tv"] = 'Añadir una variable de plantilla (TV)';
$_lang["add_weblink"] = 'Enlace web nuevo';
$_lang["administrator_role_message"] = 'Este rol no puede ser editado o borrado.';
$_lang["administrators"] = 'Administradores';
$_lang["after_saving"] = 'Después de guardar';
$_lang["alert_delete_self"] = '¡No puede borrar su usuario!';
$_lang["alias"] = 'Alias URL';
$_lang["all_doc_groups"] = 'Todos los grupos de recursos (públicos)';
$_lang["all_events"] = 'Todos los eventos';
$_lang["all_usr_groups"] = 'Todos los grupos de usuarios (públicos)';
$_lang["allow_mgr_access"] = 'Acceso a la interfaz de administrador';
$_lang["allow_mgr_access_message"] = 'Seleccione esta opción para habilitar o deshabilitar el acceso a la interfaz de administrador.
<b>Nota:</b> Si esta opción está configurada como NO el usuario será redirigido a la página de ingreso de administrador o al Inicio de sitio.';
$_lang["already_deleted"] = 'ha sido borrado ya.';
$_lang["attachment"] = 'Adjunto';
$_lang["author_infos"] = 'Información del autor';
$_lang["automatic_alias_message"] = 'Seleccione SÍ para que el sistema genere automáticamente un alias URL basado del título de recurso al guardarlo.';
$_lang["automatic_alias_title"] = 'Generar automáticamente un alias URL:';
$_lang["backup"] = 'Copia de seguridad';
$_lang["bk_manager"] = 'Copia de seguridad';
$_lang["block_message"] = '¡Este usuario será bloqueado después de guardar los datos de usuario!';
$_lang["blocked_minutes_message"] = 'Escriba la cantidad de minutos durante cuales un usuario será bloqueado si ha alcanzado su número máximo de ingresos fallidos permitidos. Por favor, escriba los números solo (sin comas, espacios, etc.)';
$_lang["blocked_minutes_title"] = 'Minutos de bloqueo:';
$_lang["cache_files_deleted"] = 'Archivos siguientes fueron borrados:';
$_lang["cancel"] = 'Cancelar';
$_lang["captcha_code"] = 'Código de seguridad';
$_lang["captcha_message"] = 'Habilite esto para fortalecer la seguridad al requerir que los usuarios ingresen un código que las máquinas no pueden leer (y los scripts de piratería de script-kiddy).';
$_lang["captcha_title"] = 'Usar los códigos CAPTCHA:';
$_lang["captcha_words_default"] = 'EVO,Aceso,Mejor,BitCode,Chunk,Cache,Desc,Diseno,Excel,Disfruta,URLs,TechView,Gerald,Griff,Humphrey,Vacacion,Intel,Integracion,Joystick,Join(),Oscope,Genetico,Luz,Parecido,Marit,Maaike,Nicho,Holanda,Ordinancia,Oscillo,Parser,Fusion,Query,Pregunta,Regalia,Correcto,Snippet,Sentinela,Template,Thespian,Unidad,Enterprise,Verily,Tatuaje,Veri,Website,WideWeb,Yap,Amarillo,Zebra,Zigoto';
$_lang["captcha_words_message"] = 'Ingrese usted una lista de palabras CAPTCHA para usarlas si el CAPTCHA está activado. Las palabras tienen que estar separadas con las comas. Este campo de entrada está limitado a los 255 caracteres.';
$_lang["captcha_words_title"] = 'Palabras de CAPTCHA';
$_lang["category"] = 'Category';
$_lang["categories"] = 'Categories';
$_lang["category_heading"] = 'Categoría';
$_lang["category_manager"] = 'Administrador de categorías';
$_lang["category_management"] = 'Gestión para las categorías';
$_lang["category_msg"] = 'Aquí puede ver y editar todos los elementos agrupados por la categoría.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Cambiar el nombre de usuario';
$_lang["change_password"] = 'Cambiar la contraseña';
$_lang["change_password_confirm"] = 'Confirmar la contraseña';
$_lang["change_password_message"] = 'Por favor, ingrese su contraseña nueva y después confirmarla. Su contraseña debe tener entre 6 y 15 carácteres.';
$_lang["change_password_new"] = 'La contraseña nueva';
$_lang["charset_message"] = 'Seleccione la codificación de caracteres predeterminada para la variable del sistema [(modx_charset)]. Esto no afecta al administrador.';
$_lang["charset_title"] = 'La codificación del caracteres:';
$_lang["chunk"] = 'Trozo (chunk)';
$_lang["chunk_code"] = 'Texto de trozo (chunk) (html)';
$_lang["chunk_multiple_id"] = 'Error: los trozos (chunk) varios comparten la misma ID.';
$_lang["chunk_no_exist"] = 'Trozo (chunk) no existe.';
$_lang["cleaningup"] = 'Está limpiando';
$_lang["clean_uploaded_filename"] = 'Usar la transliteración para cargar archivos';
$_lang["clean_uploaded_filename_message"] = 'Usar el defecto o las opciones de TransAlias para limpiar los nombres de archivos cargados con la preservación de caracteres de punto';
$_lang["clear_log"] = 'Borrar el registro';
$_lang["click_to_context"] = 'Haga clic para acceder al menú contextual';
$_lang["click_to_edit_title"] = 'Haga clic para editar este registro';
$_lang["click_to_view_details"] = 'Haga clic para ver las detalles';
$_lang["close"] = 'Cerrar';
$_lang["code"] = 'Código';
$_lang["collapse_tree"] = 'Colapsar el árbol';
$_lang["comment"] = 'Comentario';
$_lang["configcheck_admin"] = 'Por favor, ¡contacte al administrador de sistema y adviértale usted sobre este mensaje!';
$_lang["configcheck_cache"] = 'directorio de caché no se puede escribir';
$_lang["configcheck_cache_msg"] = 'Evolution CMS no puede escribir en el directorio caché. Evolution CMS continuará funcionando como es esperado pero no realizará ningún caché. Para solucionarlo haga usted el directorio /_cache/ escribible.';
$_lang["configcheck_configinc"] = 'El archivo de configuración aún se puede escribir';
$_lang["configcheck_configinc_msg"] = 'Personas muy malintencionadas podrían potencialmente probocar algunos problemas en tu sitio y todo lo asociado con él. <strong>En serio.</strong> Por favor ¡haga su archivo de configuración  (/[+MGR_DIR+]/includes/config.inc.php) de sólo lectura!';
$_lang["configcheck_default_msg"] = 'Una alerta no especificada ha sido encontrada. Lo cual es extraño.';
$_lang["configcheck_errorpage_unavailable"] = 'La página de error de sitio no está disponible.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Esto significa que su página de Error no está accesible para navegantes normales de Internet o que no existe. Esto puede provocar un estado de circulo cerrado y varios errores en el archivo de registro. Asegúrese que no hay los grupos de usuarios asignados a la página.';
$_lang["configcheck_errorpage_unpublished"] = 'La página de error de sitio no está publicada o no existe.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Esto significa que la página de error no está accesible para el público en general. Publique la página o asegúrese usted que está asignada a un documento existente en el árbol de sitio en el menú Herramientas &gt; Configuración.';
$_lang["configcheck_filemanager_path"] = 'El estado de la dirección <a href="/[+MGR_DIR+]/?a=17&amp;tab=4">Administrador de archivos</a> parece incorrecto.';
$_lang["configcheck_filemanager_path_msg"] = 'Esto puede suceder, por ejemplo, al mover la instalación a un directorio o servidor diferente. Verifique y actualice usted su configuración de Evolution CMS.';
$_lang["configcheck_hide_warning"] = '<a href="javascript:hideConfigCheckWarning(\'%s\');"><em>No vuelvas a mostrar esto.</em></a>';
$_lang["configcheck_images"] = 'El directorio de imágenes no está escribible';
$_lang["configcheck_images_msg"] = 'El directorio de imágenes no está escribible o no existe. Esto significa que las funciones del Administrador de imágenes en el editor no funcionará.';
$_lang["configcheck_installer"] = 'El instalador todavía está presente';
$_lang["configcheck_installer_msg"] = 'El directorio install/ contiene el instalador de Evolution CMS. Sólo imagine usted lo que puede pasar si una persona maligna encuentra esta carpeta y ¡ejecuta el instalador! Él no llegue muy lejos probablemente, porque deberá ingresar cierta información de usuario de la base de datos, pero será mejor borrar esta carpeta de su servidor.';
$_lang["configcheck_lang_difference"] = 'El número incorrecto de entradas en el archivo de idioma';
$_lang["configcheck_lang_difference_msg"] = 'El idioma seleccionado actualmente tiene un número diferente de entradas que el idioma prefijado.  Mientras no es el problema pero esto puede significar que el archivo de idioma debe ser actualizado.';
$_lang["configcheck_notok"] = 'Uno o más detalles de la configuración no están bien: ';
$_lang["configcheck_ok"] = 'El chequeo pasó OK - sin advertencias para reportar.';
$_lang["configcheck_php_gdzip"] = 'GD y/o Zip PHP extensiones no fueron encontrados.';
$_lang["configcheck_php_gdzip_msg"] = 'Evolution CMS necesita GS y ZIp extenciones habilitadas para PHP. Aunque Evolution CMS continua su funccionamiento sin ellos, no será posible usar las funcciones de Administrador de archivos, de Editor de Imagenes o de Captcha.';
$_lang["configcheck_rb_base_dir"] = 'El estado de la dirección <a href="/[+MGR_DIR+]/?a=17&amp;tab=5">Base de Files</a> parece incorrecto.';
$_lang["configcheck_rb_base_dir_msg"] = 'Esto puede suceder, por ejemplo, al mover la instalación a un directorio o servidor diferente. Verifique y actualice usted su configuración de Evolution CMS.';
$_lang["configcheck_register_globals"] = 'register_globals está configurado como ON en la configuración php.ini';
$_lang["configcheck_register_globals_msg"] = 'Esta configuración hace su sitio mucho más vulnerable a los ataques Cross Site Scripting (XSS). Tiene que hablar con su proveedor de hospedaje para deshabilitar esta configuración.';
$_lang["configcheck_title"] = 'Chequeo de configuración';
$_lang["configcheck_templateswitcher_present"] = 'El TemplateSwitch extensión (plugin) está encontrado.';
$_lang["configcheck_templateswitcher_present_delete"] = '<a href="javascript:deleteTemplateSwitcher();">Borrar TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_disable"] = '<a href="javascript:disableTemplateSwitcher();">Deshabilitar TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_msg"] = 'Se ha descubierto que TemplateSwitcher causa problemas de almacenamiento de caché y de rendimiento, y tiene que usar solo con la funcionalidad requerida en su sitio.';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'La página \'No Autorizado\' de sitio no está publicada o no existe.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Esto significa que la página \'No Autorizado\' no es accesible para navegantes normales de internet o que no existe. Esto puede provocar un estado de círculo cerrado y varios errores en el archivo de registro. Asegúrese que no hay los grupos de usuarios web asignados a la página.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'La página \'No Autorizado\' definida en la configuración de sitio no está publicada.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Esto significa que la página \'No Autorizado\' no está accesible para el público en general. Publique la página o asegúrese que está asignada a un documento existente en el árbol del sitio en el menú Herramientas &gt; Configuración.';
$_lang["configcheck_validate_referer"] = 'Advertencia de seguridad: validación de encabezado HTTP';
$_lang["configcheck_validate_referer_msg"] = 'La opción de configuración <strong>Validar encabezados HTTP_REFERER</strong> esta apagado. Recomendamos encenderlo. Ir a las <a href="index.php?a=17">Opciones de configuración</a>';
$_lang["configcheck_warning"] = 'La advertencia de configuración:';
$_lang["configcheck_what"] = '¿Qué significa esto?';
$_lang["safe_mode_warning"] = 'El modo seguro está habilitado. La funcionalidad del administrador está limitada.';
$_lang["confirm_block"] = '¿Está seguro que quiere bloquear a este usuario?';
$_lang["confirm_delete_category"] = '¿Está seguro que quiere borrar esta categoría?';
$_lang["confirm_delete_eventlog"] = '¿Está seguro que quiere borrar este registro?';
$_lang["confirm_delete_file"] = '¿Está seguro que quiere usted borrar el archivo? ¡Esto puede hacer que el sitio deje de funcionar correctamente! Sólo borra este archivo si sabe usted seguramente lo que está haciendo no va a romper nada.';
$_lang["confirm_delete_group"] = '¿Está seguro que quiere borrar este grupo?';
$_lang["confirm_delete_htmlsnippet"] = '¿Está seguro que quiere borrar este trozo (chunk)?';
$_lang["confirm_delete_keywords"] = '¿Está seguro que quiere borrar estas palabras claves?';
$_lang["confirm_delete_module"] = '¿Está seguro que quiere borrar este módulo?';
$_lang["confirm_delete_plugin"] = '¿Está seguro que quiere borrar este extensión (plugin)?';
$_lang["confirm_delete_record"] = '¿Está seguro que quiere borrar los registros seleccionados?';
$_lang["confirm_delete_resource"] = '¿Está seguro que quiere borrar este recurso? Cualquier recurso secundario también será borrado.';
$_lang["confirm_delete_role"] = '¿Está seguro que quiere borrar este rol?';
$_lang["confirm_delete_snippet"] = '¿Está seguro que quiere borrar este fragmento (snippet)?';
$_lang["confirm_delete_tags"] = '¿Está seguro que quiere borrar las etiquetas META seleccionadas?';
$_lang["confirm_delete_template"] = '¿Está seguro que quiere borrar esta plantilla?';
$_lang["confirm_delete_tmplvars"] = '¿Está seguro que quiere remover este variable y todos sus valores guardados?';
$_lang["confirm_delete_user"] = '¿Está seguro que quiere borrar este usuario?';
$_lang["delete_yourself"] = 'No puede borrar su propio usuario';
$_lang["delete_last_admin"] = 'No puede borrar el último usuario de administración';
$_lang["confirm_delete_permission"] = '¿Está seguro que quiere borrar esta permisión?';
$_lang["confirm_duplicate_record"] = '¿Está seguro que quiere duplicar este registro?';
$_lang["confirm_empty_trash"] = 'Esto removerá permanentemente TODOS los registros borrados. ¿Desea continuar?';
$_lang["confirm_load_depends"] = '¿Está seguro que quiere cargar la pantalla del Administrar Dependencias sin guardar sus modificaciones?';
$_lang["confirm_name_change"] = 'El cambio del nombre de usuario puede afectar otras aplicaciones que están relacionadas con su nombre. ¿Está seguro que quiere cambiar este nombre de usuario?';
$_lang["confirm_publish"] = 'La publicación de este recurso removerá cualquier fecha de la (des)publicación que haya sido configurada. Si desea configurar o mantener las fechas de la (des)publicación, seleccione \'Editar el recurso\' en vez de publicar.\n\n¿Continuar publicación?';
$_lang["confirm_remove_locks"] = 'Los usuarios a veces cierran sus navegadores mientras editan recursos, plantillas, fragmentos (snippets) o parsers, posiblemente dejando el artículo que estaban editando en estado cerrado. Al presionar OK puede remover TODOS los estados cerrados que están configurados actualmente.\n\n¿Continuar?';
$_lang["confirm_reset_sort_order"] = '¿Está seguro que quiere reiniciar \'clasificar order/index\' de todos elementos al cero?';
$_lang["confirm_resource_duplicate"] = '¿Está seguro que quiere duplicar este recurso? Cualquier artículo que contenga también será duplicado.';
$_lang["confirm_setting_language_change"] = 'Ha modificado el valor prefijado y perderá los cambios.\n\n¿Proceder?';
$_lang["confirm_unblock"] = '¿Está seguro que quiere desbloquear este usuario?';
$_lang["confirm_undelete"] = 'Cualquier recurso secundario borrado al mismo tiempo que este recurtso también será recuperado pero los recursos secundarios borrados anterioramente se mantendrán borrados.';
$_lang["confirm_unpublish"] = 'La despublicación de este recurso removerá cualquier fecha de (des)publicación que haya sido configurada. Si desea configurar o mantener las fechas de (des)publicación, por favor elige usted \'Editar el recurso\'.\n\n¿Continuar?';
$_lang["confirm_unzip_file"] = '¿Está seguro que quiere descomprimir este archivo? Los archivos existentes serán sobrescritos.';
$_lang["could_not_find_user"] = 'No se puede encontrar el usuario';
$_lang["create_folder_here"] = 'Crear una carpeta aquí';
$_lang["create_resource_here"] = 'Crear un recurso aquí';
$_lang["create_resource_title"] = 'Crear un recurso';
$_lang["create_weblink_here"] = 'Crear un enlace web aquí';
$_lang["createdon"] = 'Fecha de creación';
$_lang["create_new"] = 'Crear nuevo';
$_lang["credits"] = 'Créditos';
$_lang["credits_shouts_msg"] = '<p>Eolution CMS es administrado y desarrolado en <a href="https://evo-cms.com/" target="_blank">evo-cms.com</a>.</p>';
$_lang["custom_contenttype_message"] = 'Aquí puede añadir los tipos de contenido personalizados para usarlas en los recursos. Para añadir una nueva entrada, ingrese el tipo de contenido y presiona usted el botón \'Añadir\'.';
$_lang["custom_contenttype_title"] = 'Los tipos de contenido personalizados:';
$_lang["database_charset"] = 'Conjunto de caracteres de la base de datos';
$_lang["database_collation"] = 'Conjunto de caracteres de colación de la base de datos';
$_lang["database_name"] = 'Nombre de la base de datos';
$_lang["database_overhead"] = '<b style="color:#990033;">Nota:</b> La sobrecarga es el espacio no utilizado reservado por MySQL. Para liberar este espacio, haga clic en la figura superior de la mesa.';
$_lang["database_server"] = 'El servidor de la base de datos';
$_lang["database_table_clickbackup"] = 'Haga la copia de seguridad y descarguela';
$_lang["database_table_clickhere"] = 'Haga clic aquí';
$_lang["database_table_datasize"] = 'Tamaño de datos';
$_lang["database_table_droptablestatements"] = 'Generar los ordenes de DROP TABLE.';
$_lang["database_table_effectivesize"] = 'Tamaño efectivo';
$_lang["database_table_indexsize"] = 'Tamaño indexado';
$_lang["database_table_overhead"] = 'La sobrecarga';
$_lang["database_table_records"] = 'Registros';
$_lang["database_table_tablename"] = 'Nombre de la tabla';
$_lang["database_table_totals"] = 'Totales:';
$_lang["database_table_totalsize"] = 'Tamaño total';
$_lang["database_tables"] = 'Tablas de la base de datos';
$_lang["database_version"] = 'Versión de la base de datos';
$_lang["date"] = 'Fecha';
$_lang["datechanged"] = 'Fecha de cambio';
$_lang["datepicker_offset"] = 'Desplazamiento del selector de fecha: ';
$_lang["datepicker_offset_message"] = 'El número de años para mostrar en el pasado en el selector de fecha.';
$_lang["datetime_format"] = 'Formato de fecha';
$_lang["datetime_format_message"] = 'Formato de fecha para usar en el administrador';
$_lang["default"] = 'Predeterminado:';
$_lang["defaultcache_message"] = 'Seleccione \'SÍ\' para hacer todos los recursos nuevos cacheables por el defecto.';
$_lang["defaultcache_title"] = 'Cacheable por el defecto';
$_lang["defaultmenuindex_message"] = 'Seleccione \'SÍ\' para activar el incremento automático de los indexes de menú por el defecto.';
$_lang["defaultmenuindex_title"] = 'El menú está indexado por el defecto';
$_lang["defaultpublish_message"] = 'Seleccione \'SÍ\' para hacer todos los recursos nuevos publicados por el defecto.';
$_lang["defaultpublish_title"] = 'Está publicado por el defecto';
$_lang["defaultsearch_message"] = 'Seleccione \'SÍ\' para hacer todos los recursos nuevos buscables por el defecto.';
$_lang["defaultsearch_title"] = 'Está buscable por el defecto';
$_lang["defaulttemplate_message"] = 'Seleccione que la plantilla (template) por el defecto será usado para los recursos nuevos. Todavía puede seleccionar uno diferente en el editor de recursos, esta configuración sólo preselecciona uno de las plantillas.';
$_lang["defaulttemplate_title"] = 'Plantilla (template) por el defecto';
$_lang["defaulttemplate_logic_title"] = 'Asignación automática de plantillas';
$_lang["defaulttemplate_logic_general_message"] = 'Los recursos nuevos tendrán las plantillas siguientes, retrocediendo a los niveles más altos si no se encuentran:';
$_lang["defaulttemplate_logic_system_message"] = '<strong>System:</strong> la plantilla (template) por el defecto del sistema.';
$_lang["defaulttemplate_logic_parent_message"] = '<strong>Parent:</strong> la plantilla (template) igual del padre.';
$_lang["defaulttemplate_logic_sibling_message"] = '<strong>Sibling:</strong> la misma plantilla (template) que otros recursos en el mismo contenedor.';
$_lang["delete"] = 'Borrar';
$_lang["delete_resource"] = 'Borrar el recurso';
$_lang["delete_tags"] = 'Borrar las etiquetas';
$_lang["deleting_file"] = 'Está borrando el archivo `%s`: ';
$_lang["description"] = 'Descripción';
$_lang["deselect_keywords"] = 'Limpiar las palabras clave';
$_lang["deselect_metatags"] = 'Limpiar las etiquetas META';
$_lang["disabled"] = 'Está deshabilitado';
$_lang["doc_data_title"] = 'Ver los datos de recurso';
$_lang["documentation"] = 'Documentatión';
$_lang["duplicate"] = 'Duplicar';
$_lang["duplicate_alias_found"] = 'El recurso \'%s\' está usando ya el alias \'%s\'. Por favor, ingrese un alias único.';
$_lang["duplicate_template_alias_found"] = 'La plantilla (template) \'%s\' está usando ya el alias \'%s\'. Por favor, entre un alias único.';
$_lang["duplicate_alias_message"] = 'Aquí puede seleccionar \'SÍ\' para permitir guardar los aliases duplicados.
<b>Nota:</b> Esta opción debe ser usada con la opción "Dirección Alias Amigable" configurada a "SÍ" para así evitar problemas referenciando el recurso.';
$_lang["duplicate_alias_title"] = 'Permitir los aliases duplicados:';
$_lang["duplicate_name_found_general"] = 'Ya existe un %s nombrado \'%s\'. Por favor, ingrese un nombre único.';
$_lang["duplicate_name_found_module"] = 'Ya existe un Módulo nombrado \'%s\'. Por favor, ingrese un nombre único.';
$_lang["duplicated_el_suffix"] = 'Duplicar';
$_lang["edit"] = 'Editar';
$_lang["edit_resource"] = 'Editar el recurso';
$_lang["edit_resource_title"] = 'Crear/editar el recurso';
$_lang["edit_settings"] = 'Configuración';
$_lang["editedon"] = 'Fecha de edición';
$_lang["editing_file"] = 'Editando el archivo: ';
$_lang["editor_css_path_message"] = 'Ingrese la dirección a su archivo CSS que desea utilizar dentro del editor. La mejor forma de ingresar la dirección es ingresar la dirección desde la raíz de tu servidor, por ejemplo: /assets/site/style.css. Si no desea cargar una hoja de estilos en el editor, deja este campo en blanco.';
$_lang["editor_css_path_title"] = 'Dirección del archivo CSS:';
$_lang["element"] = 'Elemento';
$_lang["element_categories"] = 'Vista combinada';
$_lang["element_filter_msg"] = 'Entre aquí para filtrar el listo';
$_lang["element_management"] = 'Administrar los elementos';
$_lang["element_name"] = 'Nombre del elemento';
$_lang["element_selector_msg"] = 'Seleccione él o los elemento(s) de lista aquí abajo y haga clic en el botón \'Insertar\'.';
$_lang["element_selector_title"] = 'Selector de elemento';
$_lang["elements"] = 'Elementos';
$_lang["email"] = 'Correo electrónico';
$_lang["email_sent"] = 'Correo electrónico fue enviado';
$_lang["email_unique"] = 'Correo eléctronico está en uso ya';
$_lang["emailsender_message"] = 'El correo electrónico de administrador de sitio. Por ejemplo, este correo electrónico se utilizará como destino del correo electrónico de notificación de sistema, etc.';
$_lang["emailsender_title"] = 'Correo electrónico:';
$_lang["emailsubject_default"] = 'Sus detalles de entrada';
$_lang["emailsubject_message"] = 'Aquí puede especificar el valor del asunto para el correo electrónico de bienvenida.';
$_lang["emailsubject_title"] = 'Asunto del correo electrónico:';
$_lang["empty_folder"] = 'Esta contenedor está vacío';
$_lang["empty_recycle_bin"] = 'Purgar los recursos borrados';
$_lang["empty_recycle_bin_empty"] = 'No hay recursos borrados para purgar.';
$_lang["enable_resource"] = 'Habilitar el archivo de elementos.';
$_lang["enable_sharedparams"] = 'Habilitar compartir parámetros';
$_lang["enable_sharedparams_msg"] = '<b>Nota:</b> El GUID (id global único) será usado para identificar inequívocamente este modulo y sus parámetros compartidos. El GUID es usado también como una forma de enlace entre el módulo y los plugines o los snippetes que acceden a sus parámetros compartidos. ';
$_lang["enabled"] = 'Está habilitado';
$_lang["error"] = 'Error';
$_lang["error_sending_email"] = 'Error enviando correo electrónico';
$_lang["errorpage_message"] = 'Ingrese el ID del documento que quiere usted enviar a los usuarios si solicitan un documento que no existe actualmente.
<b>Nota:</b> asegúrese que este ID pertenece a un recurso existente y ¡que ha sido publicado!';
$_lang["errorpage_title"] = 'Página de error:';
$_lang["event_id"] = 'ID de evento';
$_lang["eventlog"] = 'Archivo de registros';
$_lang["eventlog_msg"] = 'El archivo de registros está usado para mostrar información, advertencias y mensajes de error generados para el admin de contenido. La columna \'fuente\' muestra la sección de administrador de contenido donde ocurrió el mensaje.';
$_lang["eventlog_viewer"] = 'Eventos de sistema';
$_lang["everybody"] = 'Toda la gente';
$_lang["existing_category"] = 'Categoría existente';
$_lang["expand_tree"] = 'Expandir el árbol';
$_lang["failed_login_message"] = 'Ingrese el número de ingresos fallidos permitidos antes de bloquear a un usuario.';
$_lang["failed_login_title"] = 'Intentos de ingreso fallidos:';
$_lang["fe_editor_lang_message"] = 'Seleccione el idioma para el editor, para cuando sea usado como editor frontal.';
$_lang["fe_editor_lang_title"] = 'Idioma de editor frontal:';
$_lang["file_delete_file"] = 'Borrar el archivo';
$_lang["file_delete_folder"] = 'Borrar la carpeta';
$_lang["file_deleted"] = '¡Éxito!';
$_lang["file_download_file"] = 'Descargar el archivo';
$_lang["file_download_unzip"] = 'Descomprimir el archivo';
$_lang["file_folder_chmod_error"] = 'No es posible cambiar los permisos, necesitará usted cambiar los permisos fuera de Evolution CMS.';
$_lang["file_folder_created"] = '¡La carpeta fue creada con éxito!';
$_lang["file_folder_deleted"] = '¡La carpeta fue borrada con éxito!';
$_lang["file_folder_not_created"] = 'No es posible crear la carpeta';
$_lang["file_folder_not_deleted"] = 'No es posible borrar la carpeta. Por favor ¡asegúrese que la carpeta está vacía antes de borrarla!';
$_lang["file_not_deleted"] = '¡Falló!';
$_lang["file_not_saved"] = 'No se puede guardar el archivo, por favor ¡asegúrese que el directorio objetivo es escribible!';
$_lang["file_saved"] = '¡El archivo fue actualizado con éxito!';
$_lang["file_unzip"] = '¡La descompresión fue exitosa!';
$_lang["file_unzip_fail"] = '¡La descompresión falló!';
$_lang["filemanager_path_message"] = 'IIS a menudo no actualiza la configuración de document_root correctamente, que es usado por el administrador de archivos para determinar qué puedes ver. Si está teniendo algunas problemas usando el administrador de archivos, asegúrese que esta dirección apunta a la raíz de la instalación Evolution CMS.';
$_lang["filemanager_path_title"] = 'Dirección del administrador de archivos:';
$_lang["files"] = 'Files';
$_lang["files_access_denied"] = '¡El acceso fue denegado!';
$_lang["files_data"] = 'Datos';
$_lang["files_dir_listing"] = 'Lista de carpeta para:';
$_lang["files_directories"] = 'Carpetas';
$_lang["files_directory_is_empty"] = 'Esta carpeta está vacía';
$_lang["files_dirwritable"] = '¿La carpeta está escribible?';
$_lang["files_editfile"] = 'Editar el archivo';
$_lang["files_file_type"] = 'Tipo de archivo: ';
$_lang["files_filename"] = 'Nombre de archivo';
$_lang["files_fileoptions"] = 'Opciones';
$_lang["files_files"] = 'Archivos';
$_lang["files_filesize"] = 'Tamaño de archivo';
$_lang["files_filetype_notok"] = '¡La subida de este tipo de archivo no está permitida!';
$_lang["files_management"] = 'Administrar los archivos';
$_lang["files_management_no_permission"] = 'No tiene bastante permisos para ver o editar estos artchivos. Pida al administrador la permision de acceso al <b>%s</b>.';
$_lang["files_modified"] = 'Modificado';
$_lang["files_top_level"] = 'Al nivel superior';
$_lang["files_up_level"] = 'Un nivel arriba';
$_lang["files_upload_copyfailed"] = 'Falló de copiar el archivo al directorio de destino, ¡la subida falló!';
$_lang["files_upload_error"] = 'Error';
$_lang["files_upload_error0"] = 'Hubo un problema con su carga.';
$_lang["files_upload_error1"] = 'El archivo que intenta cargar es demasiado grande.';
$_lang["files_upload_error2"] = 'El archivo que intenta cargar es demasiado grande.';
$_lang["files_upload_error3"] = 'El archivo que está intentando cargar solo se cargó parcialmente.';
$_lang["files_upload_error4"] = 'Tiene que seleccionar un archivo para cargar.';
$_lang["files_upload_error5"] = 'Hubo un problema con su carga.';
$_lang["files_upload_inhibited_msg"] = '<b>Característica de cargada deshabilitada</b> - asegúrese que las cargadas están soportadas y que el directorio es escribible por PHP.<br />';
$_lang["files_upload_ok"] = '¡El archivo ha cargado con éxito!';
$_lang["files_upload_permissions_error"] = 'Problemas posibles de permiso - el directorio al que quiere cargar necesita ser escribible por el servidor web.';
$_lang["files_uploadfile"] = 'Cargar el archivo';
$_lang["files_uploadfile_msg"] = 'Seleccione el archivo para cargar:';
$_lang["files_uploading"] = 'Está cagando <b>%s</b> a <b>%s/</b><br />';
$_lang["files_viewfile"] = 'Ver el archivo';
$_lang["folder"] = 'Carpeta';
$_lang["forgot_password_email_fine_print"] = '* La URL anterior expirará una vez que cambie su contraseña o al día que viene.';
$_lang["forgot_password_email_instructions"] = 'Desde allí podrá cambiar su contraseña desde el menú de Mi Cuenta.';
$_lang["forgot_password_email_intro"] = 'Se ha hecho una solicitud para cambiar la contraseña de su cuenta.';
$_lang["forgot_password_email_link"] = 'Haga clic aquí para completar el proceso.';
$_lang["forgot_your_password"] = '¿Se le olvidó su contraseña?';
$_lang["friday"] = 'Viernes';
$_lang["friendly_alias_message"] = 'Con las URL amigables habilitadas, se usará un alias de URL de recurso en vez del ID de recurso.
Por ejemplo, si un Recurso con ID 1 tiene \'introducción\' como el alias de URL sin prefijo establecido (vacío) y un sufijo de \'.html\', habilitar esta opción generará \'introducción.html\' como el alias de URL.
Si no hay un alias de URL establecido, Evolution CMS generará \'1.html\'.';
$_lang["friendly_alias_title"] = 'Utilizar las aliases URL amigables:';
$_lang["friendlyurls_message"] = 'Usar URL aliases compartibles con motores de búsqueda en servidores web Apache con mod_rewrite o IIS con los plugins. Consulte el archivo .htaccess en la raíz del sitio para obtener más información.';
$_lang["friendlyurls_title"] = 'Usar URLs amigables:';
$_lang["friendlyurlsprefix_message"] = 'La configuración de prefijo de \'page\' convertirá la URL /index.php?id=2 en el alias de URL \'page2.html\' (suponiendo que el sufijo esté configurado en \'.html\').';
$_lang["friendlyurlsprefix_title"] = 'Prefijo para URLs amigables:';
$_lang["friendlyurlsuffix_message"] = 'Aquí puede especificar el sufijo para las URLs amigables. Especificando \'.html\' agregará .html a todas los URLs.';
$_lang["friendlyurlsuffix_title"] = 'El sufijo para URLs amigables:';
$_lang["functionnotimpl"] = '¡Lo siento!';
$_lang["functionnotimpl_message"] = 'Esta función no ha sido implementada todavía.';
$_lang["further_info"] = 'Más información';
$_lang["global_tabs"] = 'Las pestañas globales';
$_lang["go"] = 'Ir';
$_lang["group_access_permissions"] = 'El acceso de grupo de usuarios';
$_lang['group_tvs'] = 'El grupo de variables de plantilla (TV)';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Ayuda';
$_lang["help_msg"] = '<p>Puede obtener soporte gratuito de la comunidad <a href="http://forums.modx.com" target="_blank">visitando los foros de Evolution CMS</a>.  También hay un cumulo creciente de <a href="http://evolution-docs.com" target="_blank">Documentación y Guías EVO</a> que tocan virtualmente todos los aspectos de EVO.</p><p>Estamos planeando ofrecer servicios de soporte comercial para Evolution CMS. Por favor, <a href="mailto:hello@modx.com?subject=MODX Commercial Support Inquiry">envíenos usted un mensaje si está interesado</a>.';
$_lang["help_title"] = 'Ayuda';
$_lang["hide_tree"] = 'Ocultar el árbol';
$_lang["home"] = 'Cuadro de mando';
$_lang["htmlsnippet"] = 'Trozo (chunk)';
$_lang["htmlsnippets"] = 'Trozos (chunks)';
$_lang["htmlsnippet_desc"] = 'Descripción';
$_lang["htmlsnippet_management_msg"] = 'Seleccione que trozo (chunk) desea editar.';
$_lang["htmlsnippet_msg"] = 'Aquí puede añadir/editar los trozos (chunks).  Recuerda que los trozos (chunks) son los códigos HTML \'plano\' por eso cualquier código PHP no será procesado.';
$_lang["htmlsnippet_name"] = '{{nombre_de_trozo}}';
$_lang["htmlsnippet_title"] = 'Crear/editar el trozo (chunk)';
$_lang["icon"] = 'Icono';
$_lang["icon_description"] = 'El valor de clase de CSS,  por ejemplo \'fa fa-star\'';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'La asignación de principal: el recurso es un secundario del recurso seleccionado.';
$_lang["illegal_parent_self"] = 'La asignación de principal: el recurso seleccionado no puede ser asignado a sí mismo.';
$_lang["images_management"] = 'Administrar los imágenes';
$_lang["import_files_found"] = '<b>Se encontraron %s recursos para importar...</b>';
$_lang["import_params"] = 'Parámetros compartidos del módulo para importar';
$_lang["import_params_msg"] = 'Puede importar los parámetros o la configuración del módulo con la seleccion su nombre en el menú desplegable arriba.
<b>Nota:</b> Para asegurar que los módulos aparezcan dentro del menú este plugin/snippet debe ser la parte de la lista de dependencias del módulo y el módulo debe tener habilitado el compartir parametros.';
$_lang["import_parent_resource"] = 'El principal de recurso:';
$_lang["update_tree"] = 'Reconstruir el árbol';
$_lang["update_tree_description"] = '<ul>
<li>Closure table es el diseño de la base de datos que hace el trabajo con el árbol de recursos más conveniente y rápido</li>
<li>Si los datos en el árbol no se actualizan a través de modelos, entonces existe la posibilidad de una vinculación incorrecta de recursos en la base de datos.</li>
<li>Esta operación soluciona el problema cuando el contenido del sitio no se actualiza a través del modelo (guardar, crear) y los enlaces (Closure table) no se actualizan</li>
<li>También es posible realizar esta operación en modo CLI a través del comando \'php artisan closuretable:rebuild\'</li>
</ul>';
$_lang["update_tree_danger"] = 'Si tiene más que mil recursos será mejor hacer esta operación en CLI a través del comando \'php artisan closuretable:rebuild\' command';
$_lang["update_tree_time"] = 'La reconstrucción del árbol está terminada. <b>%s</b><br>La importación tardó <b>%s</b> segundos hasta completar.';
$_lang["info"] = 'Info';
$_lang["information"] = 'Información';
$_lang["inline"] = 'En linea';
$_lang["insert"] = 'Insertar';
$_lang["maxImageWidth"] = 'Ancho máximo de la imagen';
$_lang["maxImageHeight"] = 'Altura máxima de la imagen';
$_lang["clientResize"] = 'Cambiar el tamaño de imagenes en le lado de cliente';
$_lang["clientResize_message"] = 'Si está habilitado el navegador cambiará el tamaño de las imágenes antes de cargarlas al servidor';
$_lang["noThumbnailsRecreation"] = 'Crear miniaturas solo al cargar';
$_lang["noThumbnailsRecreation_message"] = 'El navegador de archivos creará miniaturas solo al cargar; si no hay miniaturas para algunas imágenes, no se crearán';
$_lang["thumbWidth"] = 'Ancho máximo de la miniatura';
$_lang["thumbHeight"] = 'Altura máxima de la miniatura';
$_lang["thumbsDir"] = 'Ubicación del directorio de miniaturas';
$_lang["jpegQuality"] = 'La compresión de JPEG';
$_lang["denyZipDownload"] = 'Deshabilitar la descarga de archivos zip';
$_lang["denyExtensionRename"] = 'Deshabilitar el cambio de nombres de extensiones de archivos';
$_lang["maxImageWidth_message"] = 'Si la resolución de la imagen cargada supera esta configuración se cambiará de tamaño automáticamente. Establezca 0 para evitarlo.';
$_lang["maxImageHeight_message"] = 'Si la resolución de la imagen cargada supera esta configuración, se cambiará de tamaño automáticamente. Establezca 0 para evitar.';
$_lang["thumbWidth_message"] = 'Ancho máximo de la miniatura.';
$_lang["thumbHeight_message"] = 'Altura máxima de la miniatura.';
$_lang["thumbsDir_message"] = 'Nombre del directorio de miniaturas.';
$_lang["jpegQuality_message"] = 'Calidad de compresión de JPEG de miniaturas e imágenes redimensionadas';
$_lang["showHiddenFiles"] = 'Mostrar archivos ocultos en el buscador de archivos';
$_lang["keyword"] = 'Palabra clave';
$_lang["keywords"] = 'Palabras clave';
$_lang["keywords_intro"] = 'Para editar una palabra clave simplemente escriba la palabra clave nueva en el campo de texto junto a la palabra clave que desea usted cambiar.
Para borrar una palabra clave seleccione usted la caja \'borrar\' para esa palabra clave.
Si selecciona la caja de borrar de la palabra clave y también le cambia usted su nombre será borrada ¡y el renombrado de la palabra clave no tendrá efecto!';
$_lang["language_message"] = 'Seleccione usted el idioma para el administrador de contenido de Evolution CMS.';
$_lang["language_title"] = 'Idioma de administrador:';
$_lang["last_update"] = 'Actualización última ';
$_lang["launch_site"] = 'Ver el sitio';
$_lang["license"] = 'Licencia';
$_lang["link_attributes"] = 'Atributos de enlace';
$_lang["link_attributes_help"] = 'Ingrese los atributos opcionales para un enlace de esta página, tal como \'target=&quot;_blank&quot;\' o \'rel=&quot;external&quot;\'.';
$_lang["list_mode"] = 'Habilitar o deshabilitar el modo de la lista - está usado para listar todos los registros en el cuadriculado.';
$_lang["loading_doc_tree"] = 'Cargando el árbol de recursos...';
$_lang["loading_menu"] = 'Preparando el menú...';
$_lang["loading_page"] = 'Por favor espere mientras Evolution CMS carga la página...';
$_lang["localtime"] = 'Tiempo local';
$_lang["lock_htmlsnippet"] = 'Bloquear la edición del trozo (chunk)';
$_lang["lock_htmlsnippet_msg"] = 'Solamente los administradores (col el rol ID 1) pueden editar este trozo (chunk).';
$_lang["lock_module"] = 'Bloquear la edición del módulo';
$_lang["lock_module_msg"] = 'Solamente los administradores (con el rol ID 1) pueden editar este módulo.';
$_lang["lock_msg"] = '%s está actualmente editando este %s. Por favor espere hasta que el otro usuario haya terminado e intente usted de nuevo.';
$_lang["lock_plugin"] = 'Bloquear la edición de la extensión (plugin)';
$_lang["lock_plugin_msg"] = 'Solamente los administradores (col el rol ID 1) pueden editar esta extensión (plugin).';
$_lang["lock_settings_msg"] = '%s está actualmente editando esta configuración. Por favor espere hasta que el otro usuario haya terminado e intenta de nuevo.';
$_lang["lock_snippet"] = 'Bloquear la edición del fragmento (snippet)';
$_lang["lock_snippet_msg"] = 'Solamente los administradores (con el rol ID 1) pueden editar este fragmento (snippet).';
$_lang["lock_template"] = 'Bloquear la edición de la plantilla (template)';
$_lang["lock_template_msg"] = 'Solamente los administradores (con el rol ID 1) pueden editar esta plantilla (template).';
$_lang["lock_tmplvars"] = 'Bloquear la edición de la variable de plantilla (TV)';
$_lang["lock_tmplvars_msg"] = 'Solamente los administradores (con el rol ID 1) pueden editar esta variable de plantilla (TV).';
$_lang["locked"] = 'Bloqueado';
$_lang["login_allowed_days"] = 'Días permitidos';
$_lang["login_allowed_days_message"] = 'Seleccione los días en los que este usuario está permitido a iniciar una sesión.';
$_lang["login_allowed_ip"] = 'Dirección IP permitida';
$_lang["login_allowed_ip_message"] = 'Ingrese las direcciones IP con las que este usuario tiene las permisión iniciar una sesión.
<b>Nota:</b> separe los direcciones de IP múltiples con las comas (,)';
$_lang["login_button"] = 'Entrar';
$_lang["login_cancelled_install_in_progress"] = 'La instalación/actualización de este sitio está actualmente en curso.  <br />¡Vuelva a intentarlo en un par de minutos.!<br />';
$_lang["login_cancelled_site_was_updated"] = 'Se ejecutó la instalación/actualización en este sitio, ¡inicie sesión nuevamente!';
$_lang["login_captcha_message"] = 'Por favor ingrese el código de seguridad mostrado en la gráfica. Si no puede leer el código, haga clic en la imagen para generar una nueva o contacte usted al administrador del sitio.';
$_lang["login_homepage"] = 'Página de entrada';
$_lang["login_homepage_message"] = 'Ingrese el ID de recurso al que quiere usted enviar al usuario después que haya entrado.
<b>Nota: asegúrese que el ID que ingresa usted pertenezca a un recurso existente que ha sido publicado y que es accesible por el usuario.</b>';
$_lang["login_message"] = 'Por favor ingrese sus credenciales de entrada para comenzar su sesión en el administrador. Su nombre de usuario y la contraseña son sensitivas a las mayúsculas, por favor ingréselas con cuidado.';
$_lang["logo_slogan"] = 'El administrador de contenido de Evolution CMS - cree y haga más con menos';
$_lang["logout"] = 'Salir';
$_lang["long_title"] = 'Título largo';
$_lang["manage_categories"] = 'Gestionar las categorías';
$_lang["manage_depends"] = 'Administrar las dependencias';
$_lang["manage_files"] = 'Administrar los archivos';
$_lang["manage_htmlsnippets"] = 'Manage Chunks';
$_lang["manage_metatags"] = 'Administrar las etiquetas META y las palabras claves';
$_lang["manage_modules"] = 'Administrar los módulos';
$_lang["manage_plugins"] = 'Manage Plugins';
$_lang["manage_snippets"] = 'Manage Snippets';
$_lang["manage_templates"] = 'Manage Templates';
$_lang["manage_documents"] = 'Manage Documents';
$_lang["manage_permission"] = 'Manage Permissions';
$_lang["manager"] = 'El administrador';
$_lang["manager_lockout_message"] = 'Está actualmente dentro del administrador de contenido. Si desea cerrar su sesión haga clic en el botón \'Salir\'. Para ir a su página de inicio o la página principal haga clic en el botón \'Inicio\'.';
$_lang["manager_permissions"] = 'Permisos de administrador';
$_lang["manager_theme"] = 'Tema de administrador:';
$_lang["manager_theme_message"] = 'Seleccione el tema para el administrador de contenido.';
$_lang["manager_theme_mode"] = 'Esquema de colores:';
$_lang["manager_theme_mode1"] = 'todo está claro';
$_lang["manager_theme_mode2"] = 'el encabezado está oscuro';
$_lang["manager_theme_mode3"] = 'el encabezado y la barra lateral están oscuros';
$_lang["manager_theme_mode4"] = 'todo está oscuro';
$_lang['manager_theme_mode_message'] = 'Esta configuración se usa como "predeterminada" y el administrador puede anularla cuando se usa el botón de cambio de modo de color del tema en el árbol de recursos:<i class="fa fa-lg fa-adjust"></i>';
$_lang['manager_theme_mode_title'] = 'El cambio de modo de colores del tema';
$_lang["meta_keywords"] = 'Palabras META clave';
$_lang["metatag_intro"] = 'Esta página permita eliminar, crear o editar las etiquetas META. Para vincular las etiquetas META a los recursos, haga usted clic en la pestaña Palabras clave META al editar el recurso y seleccione usted las etiquetas META y las palabras clave deseadas. Para agregar una nueva etiqueta, ingrese usted el nombre y el valor y haga usted clic en el botón \'Agregar etiqueta\'. Para editar la etiqueta, haga usted clic en el nombre de la etiqueta dentro de la cuadrícula de datos.';
$_lang["metatag_notice"] = 'Quizá quiera ver la <a href="http://www.html-reference.com/META.asp" target="_blank">Guía de Referencia HTML</a> para obtener más información. Esta lista no es una lista completa de posibles etiquetas Meta.</a>';
$_lang["metatags"] = 'Etiquetas META';
$_lang["mgr_access_permissions"] = 'Permisos de acceso de administrador';
$_lang["mgr_login_start"] = 'Inicio de entrada al administrador';
$_lang["mgr_login_start_message"] = 'Ingrese el ID del recurso al que quieres enviar al usuario después de que haya salido del Administrador.
<b>Nota:</b> asegúrese que el ID ingresado pertenece a un recurso existente y que ha sido publicado ¡y es accesible por el usuario!';
$_lang["mgrlog_action"] = 'La acción';
$_lang["mgrlog_actionid"] = 'ID de acción';
$_lang["mgrlog_anyall"] = 'Cualquiera/Todos';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() ha regresado con el falso.';
$_lang["mgrlog_datefr"] = 'La fecha desde';
$_lang["mgrlog_dateinvalid"] = 'El formato de fecha no está válido.';
$_lang["mgrlog_dateto"] = 'La fecha hasta';
$_lang["mgrlog_emptysrch"] = 'Su consulta de búsqueda arrojó un conjunto de resultados vacío (es decir, no se encontraron registros coincidentes).';
$_lang["mgrlog_field"] = 'Campo';
$_lang["mgrlog_itemid"] = 'ID de elemento';
$_lang["mgrlog_itemname"] = 'Nombre de elemento';
$_lang["mgrlog_msg"] = 'Mensaje';
$_lang["mgrlog_noquery"] = 'No se ha ingresado una consulta de búsqueda todavía.';
$_lang["mgrlog_qresults"] = 'Resultados de consulta';
$_lang["mgrlog_query"] = 'Registros de consultas';
$_lang["mgrlog_query_msg"] = 'Haga una selección para ver los registros. Puede seleccionar las entradas de registro por fecha, pero tenga usted en cuenta que las fechas que ingresa no son inclusivas: para seleccionar cada entrada de registro para el 01-01-2004, establezca usted \'fecha desde\' en 01-01-2004 y \'fecha hasta\' en 02-01-2004. El mensaje y las acción suelen ser los mismos. Si está buscando un mensaje específico, es mejor configurar la acción en \'Cualquiera/Todo\'.';
$_lang["mgrlog_results"] = 'Cantidad de resultados';
$_lang["mgrlog_searchlogs"] = 'Registro de búsquedas';
$_lang["mgrlog_sortinst"] = 'Puede ordenar las tablas haciendo clic en los encabezados de columnas. Si los registros son muy grandes, puede <a href="index.php?a=55">vaciar</a> el archivo de registros. Esto removerá todas las entradas del archiivo hasta ahora y ¡no puede ser deshecho!';
$_lang["mgrlog_time"] = 'Tiempo';
$_lang["mgrlog_user"] = 'Usuario';
$_lang["mgrlog_username"] = 'Nombre de usuario';
$_lang["mgrlog_value"] = 'Valor';
$_lang["mgrlog_view"] = 'Ver registros de administrador';
$_lang["module_code"] = 'Código de módulo (php)';
$_lang["module_config"] = 'Configuración de modulo';
$_lang["module_desc"] = 'Descripción';
$_lang["module_disabled"] = 'El módulo está deshabilitado';
$_lang["module_edit_click_title"] = 'Haga clic aquí para editar este módulo';
$_lang["module_group_access_msg"] = 'Seleccione los grupos de usuarios que tienen el permiso ejecutar este módulo desde el administrador de contenido.';
$_lang["module_management"] = 'Administrar los módulos';
$_lang["module_management_msg"] = 'Elija el módulo que quisiera usted ejecutar o modificar. Para ejecutar el módulo haga clic en el icono en la cuadrícula. Para modificarlo haga clic en el nombre del módulo.';
$_lang["module_msg"] = 'Añadir/editar los módulos. Cada módulo es una colección de elementos (ej. plugins, snippets, etc).';
$_lang["module_name"] = 'Nombre del módulo';
$_lang["module_resource_msg"] = 'Añada o remueva los elementos dependientes de este módulo. Para añadir un elemento nuevo haha clic en uno de los botones de añadir aquí debajo.';
$_lang["module_resource_title"] = 'Dependencias del módulo';
$_lang["module_title"] = 'Crear/editar el módulo';
$_lang["module_viewdepend_msg"] = 'Ver los elementos asignados que depende de este módulo. Haga clic en el botón \'Administrar dependencias\' para modificar las dependencias';
$_lang["modules"] = 'Módulos';
$_lang["modx_news"] = 'Anuncios de noticias de Evolution CMS';
$_lang["modx_news_tab"] = 'Noticias de Evolution CMS';
$_lang["modx_news_title"] = 'Noticias de Evolution CMS';
$_lang["modx_security_notices"] = 'Notas de seguridad de Evolution CMS';
$_lang["modx_version"] = 'Versión de Evolution CMS';
$_lang["monday"] = 'Lunes';
$_lang["move"] = 'Mover';
$_lang["move_resource"] = 'Mover el recurso';
$_lang["move_resource_message"] = 'Mueva un recurso y todos sus elementos secundarios seleccionando un elemento principal nuevo en el árbol del sitio. Si selecciona un recurso que aún no es un contenedor se convertirá en uno. Haga clic en el nuevo padre en el árbol del sitio.';
$_lang["move_resource_new_parent"] = 'Seleccione un principal nuevo en el árbol de recursos.';
$_lang["move_resource_title"] = 'Mover el recurso';
$_lang["name"] = 'Nombre de usuario';
$_lang["new_category"] = 'Una categoría nueva';
$_lang["new_file_permissions_message"] = 'Al cargar un archivo nuevo en el administrador de archivos, el administrador de archivos intentará cambiar los permisos del archivo a los ingresados en esta configuración. Es posible que esto no funcione en algunas configuraciones, como IIS, en cuyo caso deberá cambiar manualmente los permisos.';
$_lang["new_file_permissions_title"] = 'Permisos de archivo nuevo';
$_lang["new_folder_permissions_message"] = 'Al crear un nuevo directorio en el administrador de archivos, el administrador de archivos intentará cambiar los permisos del directorio a los ingresados en esta configuración. Es posible que esto no funcione en algunas configuraciones, como IIS, en cuyo caso deberá cambiar manualmente los permisos.';
$_lang["new_folder_permissions_title"] = 'Permisos de una carpeta nueva';
$_lang["new_permission"] = 'Permiso nuevo';
$_lang["new_htmlsnippet"] = 'Trozo (chunk) nuevo';
$_lang["new_keyword"] = 'Añadir una palabra clave nueva:';
$_lang["new_module"] = 'Módulo nuevo';
$_lang["new_parent"] = 'Padre nuevo';
$_lang["new_plugin"] = 'Extensión (plugin) nueva';
$_lang["new_role"] = 'Crear un rol nuevo';
$_lang["new_snippet"] = 'Fragmento (snippet) nuevo';
$_lang["new_template"] = 'Plantilla nueva';
$_lang["new_tmplvars"] = 'Variable de plantilla (TV) nueva';
$_lang["new_user"] = 'Usuario nuevo';
$_lang["new_web_user"] = 'Usuario web nuevo ';
$_lang["new_resource"] = 'Recurso nuevo';
$_lang["no"] = 'No';
$_lang["no_active_users_found"] = 'No se encontraron los usuarios activos.';
$_lang["no_activity_message"] = 'No ha creado o ha editado ningún recurso todavía.';
$_lang["no_category"] = 'no está categorizado';
$_lang["no_docs_pending_publishing"] = 'No hay recursos con la publicación pendiente.';
$_lang["no_docs_pending_pubunpub"] = 'No se encontraron eventos';
$_lang["no_docs_pending_unpublishing"] = 'No hay recusros con despublicación pendiente.';
$_lang["no_edits_creates"] = 'No se encontraron ediciones o creaciones.';
$_lang["no_groups_found"] = 'No se encontraron los grupos.';
$_lang["no_keywords_found"] = 'Actualmente no hay las palabras clave.';
$_lang["no_records_found"] = 'No se encontraron los registros.';
$_lang["no_results"] = 'No se encontraron loas resultados';
$_lang["nologentries_message"] = 'Ingrese el número de entradas de registros mostradas por página cuando navegue por la auditoría.';
$_lang["nologentries_title"] = 'Cantidad de eventos en registro:';
$_lang["none"] = 'Ninguno';
$_lang["noresults_message"] = 'Ingrese la cantidad de resultados para mostrar en la cuadrícula de datos cuando vea las listas y los resultados de búsqueda.';
$_lang["noresults_title"] = 'Cantidad de resultados:';
$_lang["not_deleted"] = 'no ha sido borrado.';
$_lang["not_set"] = 'No está configurado';
$_lang["offline"] = 'Fuera de línea';
$_lang["online"] = 'En línea';
$_lang["onlineusers_action"] = 'Acción';
$_lang["onlineusers_actionid"] = 'ID-de-acción';
$_lang["onlineusers_ipaddress"] = 'Dirección IP';
$_lang["onlineusers_lasthit"] = 'Última visita';
$_lang["onlineusers_message"] = 'Esta lista muestra todos los usuarios activos durante los últimos 20 minutos (la hora actual es ';
$_lang["onlineusers_title"] = 'Usuarios en línea';
$_lang["onlineusers_user"] = 'Nombre de usuario';
$_lang["onlineusers_userid"] = 'ID de usuario';
$_lang["optimize_table"] = 'Haga clic aquí para optimizar esta tabla';
$_lang["page_data_alias"] = 'Alias URL';
$_lang["page_data_cacheable"] = 'Está cacheable';
$_lang["page_data_cacheable_help"] = 'Esto permite que el recurso se guarde en la memoria caché del sitio y afecta a todos los fragmentos de página.';
$_lang["page_data_cached"] = '<b>Fue obtenido de caché:</b>';
$_lang["page_data_changes"] = 'Cambios';
$_lang["page_data_contentType"] = 'Tipo de contenido';
$_lang["page_data_contentType_help"] = 'Seleccione el tipo de contenido para este documento. Si no está seguro que tipo de contenido debe tener el documento, simplemente déjelo como text/html.';
$_lang["page_data_created"] = 'Creado';
$_lang["page_data_edited"] = 'Editado';
$_lang["page_data_editor"] = 'Editar usando el editor de texto formateado';
$_lang["page_data_folder"] = 'El recurso tiene el tipo de contenedor';
$_lang["page_data_general"] = 'General';
$_lang["page_data_markup"] = 'Marcado/estructura';
$_lang["page_data_mgr_access"] = 'Acceso de administrador';
$_lang["page_data_notcached"] = 'Este recurso (todavía) no ha sido cacheado.';
$_lang["page_data_publishdate"] = 'Fecha de publicación';
$_lang["page_data_publishdate_help"] = 'Si establezca una fecha de publicación, el recurso se publicará tan pronto como se alcance la fecha de publicación. Haga clic en el ícono del calendario para seleccionar una fecha o en el ícono al lado para eliminar la fecha de publicación. Esto significará que el recurso nunca se publicará automáticamente.';
$_lang["page_data_published"] = 'Publicado';
$_lang["page_data_searchable"] = 'Está buscable';
$_lang["page_data_searchable_help"] = 'Checando este campo permitirá al recurso ser buscado. También puede qusar este campo para otros propósitos en sus fragmentos (snippets).';
$_lang["page_data_source"] = 'El fuente';
$_lang["page_data_status"] = 'El estado';
$_lang["page_data_template"] = 'Usa la plantilla (template)';
$_lang["page_data_template_help"] = 'Seleccionar la plantilla (template) para este recurso.';
$_lang["page_data_title"] = 'Datos de página';
$_lang["page_data_unpublishdate"] = 'Fecha de despublicación';
$_lang["page_data_unpublishdate_help"] = 'Si estableza la fecha de anulación de publicación el recurso se anulará de publicación tan pronto como se alcance esta fecha. Haga clic en el ícono de calendario para seleccionar una fecha o en el ícono al lado para eliminar la fecha de anulación de publicación. Esto significará que el recurso nunca se anulará automáticamente.';
$_lang["page_data_unpublished"] = 'Está despublicado';
$_lang["page_data_web_access"] = 'Acceso web';
$_lang["pagetitle"] = 'Título de recurso';
$_lang["pagination_table_first"] = 'Primero';
$_lang["pagination_table_gotopage"] = 'Ir a la página';
$_lang["pagination_table_last"] = 'Último';
$_lang["paging_first"] = 'primero';
$_lang["paging_last"] = 'último';
$_lang["paging_next"] = 'siguiente';
$_lang["paging_prev"] = 'previo';
$_lang["paging_showing"] = 'Está mostrando';
$_lang["paging_to"] = 'a';
$_lang["paging_total"] = 'total';
$_lang["parameter"] = 'El parámetro';
$_lang["parse_docblock"] = 'Analizar el DocBlock';
$_lang["parse_docblock_msg"] = 'Atención (!): <b>Restablece</b> el nombre, la configuración, la descripción y la categoría reales a los valores predeterminados de instalación analizando el código fuente.';
$_lang["password"] = 'Contraseña';
$_lang["password_change_request"] = 'Solicitud de cambio de contraseña';
$_lang["password_gen_gen"] = 'Deje que Evolution CMS genere una contraseña.';
$_lang["password_gen_length"] = 'La contraseña que especifique debe tener al menos 6 caracteres.';
$_lang["password_gen_method"] = 'El método de contraseña nueva';
$_lang["password_gen_specify"] = 'Déjame especificar la contraseña:';
$_lang["password_method"] = 'El método de notificación de contraseña';
$_lang["password_method_email"] = 'Enviar la contraseña nueva por email.';
$_lang["password_method_screen"] = 'Mostrar la contraseña nueva en la pantalla.';
$_lang["password_msg"] = 'La contraseña nueva para <b>:username</b> es <b>:password</b>.';
$_lang["php_version_check"] = 'Evolution CMS es compatible con PHP versión 7.4 y superior. Este servidor está usando la versión %s%. ¡Actualice usted su instalación de PHP!';
$_lang["plugin"] = 'Extensión (plugin)';
$_lang["plugins"] = 'Extensiónes (plugins)';
$_lang["plugin_code"] = 'Código de extensión (plugin) (php)';
$_lang["plugin_config"] = 'Configuración de extensión (plugin)';
$_lang["plugin_desc"] = 'Descripción';
$_lang["plugin_disabled"] = 'Extensión (plugin) está deshabilitado';
$_lang["plugin_event_msg"] = 'Seleccione los eventos que quisiere que esta extensión (plugin) escuchara.';
$_lang["plugin_management_msg"] = 'Elija que extensión (plugin) desea editar.';
$_lang["plugin_msg"] = 'Añadir/editar las extensiónes (plugines). Las extensiónes (plugins) usan el código PHP que se invoca cada vez que se activan eventos específicos de sistema.';
$_lang["plugin_name"] = 'Nombre de la extensión (plugin)';
$_lang["plugin_priority"] = 'Edite el orden de ejecución de extensiónes (plugines) por evento';
$_lang["plugin_priority_instructions"] = 'Arrastre para reordenar las extensiónes (plugines) debajo de cada encabezado de evento. El primer extensión (plugin) para ejecutar debe estar en la parte superior.';
$_lang["plugin_priority_title"] = 'Orden de ejecución de extensiónes (plugins)';
$_lang["purge_plugin"] = 'Purgar las extensiónes (plugins) obsoletos';
$_lang["purge_plugin_confirm"] = '¿Está seguro que quiere purgar las extensiónes (plugins) obsoletos?';
$_lang["plugin_title"] = 'Crear/editar una extensión (plugin)';
$_lang["preview"] = 'Previsualizar';
$_lang["preview_msg"] = 'Este es una previsualización de sus últimos cambios guardados.  Haga clic aquí para <a href="javascript:;" onclick="saveRefreshPreview();">Guardar y Recargar</a> sus cambios actuales';
$_lang["preview_resource"] = 'Previsualizar el recurso';
$_lang["private"] = 'Privado';
$_lang["public"] = 'Público';
$_lang["publish_date"] = 'Fecha de publicación';
$_lang["publish_events"] = 'Publicar eventos';
$_lang["publish_resource"] = 'Publicar el recurso';
$_lang["rb_base_dir_message"] = 'Ingrese la ruta física al directorio del explorador de archivos. Esta configuración generalmente se genera automáticamente. Sin embargo, si está utilizando IIS es posible que Evolution CMS no pueda encontrar la ruta por sí solo, lo que hace que el Explorador de archivos muestre un error. En este caso puede ingresar la ruta al directorio de imágenes aquí (la ruta como la vería en el Explorador de Windows).
<b>Nota:</b> El directorio del explorador de archivos debe contener los subdirectorios de imágenes, archivos, flash y medios para que el explorador de archivos funcione correctamente.';
$_lang["rb_base_dir_title"] = 'Dirección de la base de archivos:';
$_lang["rb_base_url_message"] = 'Ingrese la ruta física al directorio del explorador de archivos. Ingrese la ruta virtual al directorio de archivos. Esta configuración generalmente se genera automáticamente. Sin embargo, si está utilizando IIS es posible que Evolution CMS no pueda calcular la URL por sí solo, lo que hace que el Explorador de archivos muestre un error. En ese caso, puede ingresar la URL del directorio de imágenes aquí (la URL tal como la ingresaría en Internet Explorer).';
$_lang["rb_base_url_title"] = 'URL del navegador de archivos:';
$_lang["rb_message"] = 'Seleccione SÍ para habilitar el navegador de archivos. Esto permitirá a sus usuarios navegar y subir archivos como imágenes, flash y medios al servidor.';
$_lang["rb_title"] = 'Habilitar el navegador de archivos:';
$_lang["rb_webuser_message"] = '¿Quiere permitir a un usuario web la habilidad de usar el navegador de archivos? <b>Advertencia:</b> Permitiendo a los usuarios web el uso del navegador de archivos expone los archivos disponibles a los usuarios administrativos. Sólo usa usted esta opción para usuarios web confiables.';
$_lang["rb_webuser_title"] = '¿Los usuarios web?';
$_lang["recent_docs"] = 'Recursos recientes';
$_lang["recommend_setting_change_title"] = 'El cambio de configuración está recomendada';
$_lang["recommend_setting_change_description"] = 'Su sitio no está configurado para validar el HTTP_REFERER de las solicitudes entrantes al Administrador. Recomendamos enfáticamente habilitar esta configuración para reducir el riesgo de un ataque CSRF (Cross Site Request Forgery).';
$_lang["references"] = 'Referencias';
$_lang["refresh_cache"] = 'Caché: se encontraron <b>%s</b> archivos en el directorio caché y se borraron <b>%d</b> archivos cacheados.<p>Los nuevos archivos cacheados serán creados cuando las páginas sean solicitadas.';
$_lang["refresh_published"] = '<b>%s</b> recursos fueron publicados.';
$_lang["refresh_site"] = 'Limpiar el caché';
$_lang["refresh_title"] = 'Recargar el sitio';
$_lang["refresh_tree"] = 'Recargar el árbol';
$_lang["refresh_unpublished"] = '<b>%s</b> recursos fueron despublicados.';
$_lang["release_date"] = 'Fecha de lanzamiento';
$_lang["remember_last_tab"] = 'Recordar las pestañas';
$_lang["remember_last_tab_message"] = 'Las páginas del administrador con pestañas se cargan con la última pestaña vista en lugar de la primera pestaña por defecto';
$_lang["remember_username"] = 'Acuérdate de mí';
$_lang["remove"] = 'Remover';
$_lang["remove_date"] = 'Remover la fecha';
$_lang["remove_locks"] = 'Remover los bloqueos';
$_lang["rename"] = 'Renombrar';
$_lang["reports"] = 'Los informes';
$_lang["report_issues"] = 'Reportar sobre las problemas';
$_lang["required_field"] = 'El campo :field es obligatorio';
$_lang["require_tagname"] = 'Un nombre de etiqueta es obligatorio';
$_lang["require_tagvalue"] = 'Un valor para la etiqueta es obligatorio';
$_lang["reserved_name_warning"] = 'Ha utilizado un nombre reservado.';
$_lang["reset"] = 'Reiniciar';
$_lang["reset_failedlogins"] = 'reiniciar';
$_lang["reset_sort_order"] = 'Restablecer el orden de clasificación';
$_lang["resource"] = 'Recurso';
$_lang["resource_alias"] = 'Alias URL';
$_lang["resource_alias_help"] = 'Establezca el alias URL para que el recurso sea accesible como http://example.com/weburl. Esto solo funciona si los aliases URL amigables están habilitadas en la configuración del sitio.';
$_lang["resource_content"] = 'Contenido de recurso';
$_lang["resource_description"] = 'Descripción';
$_lang["resource_description_help"] = 'Ingrese la descripción opcional de este recurso.';
$_lang["resource_duplicate"] = 'Duplicar el recurso';
$_lang["resource_long_title_help"] = 'Ingrese un título opcional más largo para su recurso. Esto se puede usado en las etiquetas de encabezado automáticas de recursos para motores de búsqueda y podría ser más descriptivo para su recurso.';
$_lang["resource_metatag_help"] = 'Seleccione las etiquetas META o las palabras clave que desea asignar a este recurso. Mantenga presionada la tecla CTRL para seleccionar varias palabras clave o etiquetas META.';
$_lang["resource_opt_contentdispo"] = 'Disposición de contenido';
$_lang["resource_opt_contentdispo_help"] = 'Utilice el campo de disposición de contenido para especificar cómo el navegador web manejará este recurso. Para descargar archivos, seleccione la opción adjunto.';
$_lang["resource_opt_emptycache"] = '¿Vaciar el caché?';
$_lang["resource_opt_emptycache_help"] = 'Si deja este campo marcado Evolution CMS vaciará la memoria caché después de guardar el recurso. De esta forma los visitantes no verán una versión anterior de recurso.';
$_lang["resource_opt_folder"] = 'Contenedor';
$_lang["resource_opt_folder_help"] = 'Marque esto para que el recurso también actúe como un contenedor para otros recursos. Un "contenedor" es como una carpeta pero también puede tener el contenido.';
$_lang["resource_opt_menu_index"] = 'Índice de menú';
$_lang["resource_opt_menu_index_help"] = 'El índice de menú es un campo que puede controlar la clasificación de recursos, particularmente en fragmentos de menú. También puede usarlo para cualquier otro propósito en sus snippets.';
$_lang["resource_opt_menu_title"] = 'Título de menú';
$_lang["resource_opt_menu_title_help"] = 'El título de menú es un campo opcional que se utiliza para mostrar un título breve en los fragmentos de código o módulos de menú.';
$_lang["resource_opt_published"] = 'Publicado';
$_lang["resource_opt_published_help"] = 'Marque este campo para que el recurso se publique inmediatamente después de guardarlo.';
$_lang["resource_opt_richtext"] = 'Texto formateado';
$_lang["resource_opt_richtext_help"] = 'Deje esto campo marcado para usar el editor de texto enriquecido para editar recursos. Si sus recursos contienen JavaScript y formularios, desmarque esto campo para editar en modo HTML para evitar que el editor cambie incorrectamente sus recursos.';
$_lang["resource_opt_show_menu"] = 'Mostrar en el menú';
$_lang["resource_opt_show_menu_help"] = 'Seleccione esta opción para mostrar el recurso dentro de un menú web. Tenga en cuenta que algunos creadores de menús pueden optar por ignorar esta opción.';
$_lang["resource_opt_trackvisit_help"] = 'Registrar cada visita del visitante a esta página';
$_lang["resource_overview"] = 'Vista general de recurso';
$_lang["resource_parent"] = 'Principal de recurso';
$_lang["resource_parent_help"] = 'Haga clic en el ícono para habilitar la configuración de un elemento principal del recurso, luego haga clic en un recurso en el árbol del sitio para establecer un nuevo elemento principal.';
$_lang["resource_permissions_error"] = 'Asigne este recurso a al menos un grupo de recursos al que tenga acceso.';
$_lang["resource_setting"] = 'Configuración de recurso';
$_lang["resource_summary"] = 'Resumen (introtext)';
$_lang["resource_summary_help"] = 'Escribe un resumen corto de recurso';
$_lang["resource_title"] = 'Título';
$_lang["resource_title_help"] = 'Escriba aquí el nombre/título del documento. ¡Trate de evitar el uso de barras diagonales en el nombre!';
$_lang["resource_to_be_moved"] = 'Recurso para mover';
$_lang["resource_type"] = 'Tipo de recurso';
$_lang["resource_type_message"] = 'Los enlaces web hacen referencias a recursos en Internet incluido otro recurso de Evolution CMS, una página externa o una imagen u otro archivo en Internet. Los enlaces web deben tener un tipo de medio de Internet de texto/html y una disposición de contenido en línea.';
$_lang["resource_type_weblink"] = 'Enlace web';
$_lang["resource_type_webpage"] = 'Página web';
$_lang["resource_weblink_help"] = 'Escriba aquí la dirección del objeto al que desea usted hacer referencia con este enlace web. Alternativamente inserte desde el explorador de archivos o use el icono de selección de enlace y seleccione usted un recurso del árbol del sitio.';
$_lang["resources_in_container"] = 'Recursos en este contenedor';
$_lang["resources_in_container_no"] = 'Este contenedor no tiene recursos secundarios.';
$_lang["role"] = 'Rol';
$_lang["role_about"] = 'Ver la página \'sobre el sistema\'';
$_lang["manager_access_permissions"] = 'Administrar el permiso de acceso';
$_lang["manage_groups"] = 'Administrar los grupos de recursos y los grupos de usuarios';
$_lang["manage_document_permissions"] = 'Administrar los permisos de recurso';
$_lang["manage_module_permissions"] = 'Administrar los permisos de módulo';
$_lang["manage_tv_permissions"] = 'Administrar los permisos de varialbles de plantilla (TV)';
$_lang["role_actionok"] = 'Ver la pantalla de acción completada';
$_lang["role_assets_images"] = 'Administrar assets/images';
$_lang["role_assets_files"] = 'Administrar assets/files';
$_lang["role_bk_manager"] = 'Usar el administrador de copias de seguridad';
$_lang["role_cache_refresh"] = 'Vaciar la caché de sitio';
$_lang["role_category_manager"] = 'Usar el administrador de categorías';
$_lang["role_change_password"] = 'Cambiar la contraseña';
$_lang["role_change_resourcetype"] = 'Cambiar el tipo de recurso';
$_lang["role_chunk_management"] = 'Administración de trozos (chunks)';
$_lang["role_config_management"] = 'Administración de configuración';
$_lang["role_content_management"] = 'Administración de contenido';
$_lang["role_create_chunk"] = 'Crear los trozos (chunks) nuevos';
$_lang["role_create_doc"] = 'Crear los recursos nuevos';
$_lang["role_create_plugin"] = 'Crear las extensiónes (plugins) nuevos';
$_lang["role_create_snippet"] = 'Crear los fragmentos (snippets) nuevos';
$_lang["role_create_template"] = 'Crear las plantillas (templates) de sitio nuevos';
$_lang["role_credits"] = 'Ver los créditos';
$_lang["role_delete_chunk"] = 'Borrar los trozos (chunks)';
$_lang["role_delete_doc"] = 'Borrar los recursos';
$_lang["role_delete_eventlog"] = 'Borrar el archivo de registros';
$_lang["role_delete_module"] = 'Borrar el módulo';
$_lang["role_delete_plugin"] = 'Borrar las extensiónes (plugins)';
$_lang["role_delete_role"] = 'Borrar los roles';
$_lang["role_delete_snippet"] = 'Borrar los fragmentos (snippets)';
$_lang["role_delete_template"] = 'Borrar las plantillas (templates) de sitio';
$_lang["role_delete_user"] = 'Borrar los usuarios';
$_lang["role_delete_web_user"] = 'Borrar los usuarios web';
$_lang["role_edit_chunk"] = 'Editar los trozos (chunks)';
$_lang["role_edit_doc"] = 'Editar un recurso';
$_lang["role_edit_doc_metatags"] = 'Editar las etiquetas META y palabras clave de recurso';
$_lang["role_edit_module"] = 'Editar el módulo';
$_lang["role_edit_plugin"] = 'Editar las extensiónes (plugins)';
$_lang["role_edit_role"] = 'Editar los roles';
$_lang["role_edit_settings"] = 'Cambiar la configuración de sitio';
$_lang["role_edit_snippet"] = 'Editar los fragmentos (snippets)';
$_lang["role_edit_template"] = 'Editar las plantillas (templates) del sitio';
$_lang["role_edit_user"] = 'Editar los usuarios';
$_lang["role_edit_web_user"] = 'Editar los usuarios web';
$_lang["role_empty_trash"] = 'Purgar permanentemente recursos borrados';
$_lang["role_errors"] = 'Ver el diálogo de error';
$_lang["role_eventlog_management"] = 'La administración del archivo de registros';
$_lang["role_export_static"] = 'Exportar HTML estático';
$_lang["role_file_management"] = 'Gestionar lod archivos';
$_lang["role_file_manager"] = 'Usar el administrador de archivos';
$_lang["role_frames"] = 'Solicitar los marcos de administrador';
$_lang["role_help"] = 'Ver las páginas de ayuda';
$_lang["role_home"] = 'Solicitar la página de inicio de administrador';
$_lang["role_import_static"] = 'Importar HTML';
$_lang["role_logout"] = 'Salir de administrador';
$_lang["role_list_module"] = 'Módulo de lista';
$_lang["role_manage_metatags"] = 'Administrar las etiquetas META y las palabras clave de sitio';
$_lang["role_management_msg"] = 'Eliga el rol que desea editar.';
$_lang["role_management_title"] = 'Roles';
$_lang["role_messages"] = 'Ver y enviar los mensajes';
$_lang["role_module_management"] = 'La administración de módulos';
$_lang["role_name"] = 'Nombre de rol';
$_lang["role_new_module"] = 'Crear un módulo nuevo';
$_lang["role_new_role"] = 'Crear unas roles nuevos';
$_lang["role_new_user"] = 'Crear unos usuarios nuevos';
$_lang["role_new_web_user"] = 'Crear unos usuarios web nuevos';
$_lang["role_plugin_management"] = 'Administración de extensiónes (plugins)';
$_lang["role_publish_doc"] = 'Publicar los recursos';
$_lang["role_remove_locks"] = 'Remover los bloqueos';
$_lang["role_role_management"] = 'Roles';
$_lang["role_run_module"] = 'Ejecutar el módulo';
$_lang["role_save_chunk"] = 'Guardar los trozos (chunks)';
$_lang["role_save_doc"] = 'Guardar los recursos';
$_lang["role_save_module"] = 'Guardar el módulo';
$_lang["role_save_password"] = 'Guardar la contraseña';
$_lang["role_save_plugin"] = 'Guardar las extensiónes (plugins)';
$_lang["role_save_role"] = 'Guardar los roles';
$_lang["role_save_snippet"] = 'Guardar los fragmentos (snippets)';
$_lang["role_save_template"] = 'Guardar las plantillas (templates) de sitio';
$_lang["role_save_user"] = 'Guardar los usuarios';
$_lang["role_save_web_user"] = 'Guardar los usuarios web';
$_lang["role_snippet_management"] = 'Administración de fragmentos (snippets)';
$_lang["role_template_management"] = 'Administración de plantillas (templates) de sitio';
$_lang["role_title"] = 'Crear/editar un rol';
$_lang["role_udperms"] = 'Administración de permisos';
$_lang["role_user_management"] = 'Administración de usuarios';
$_lang["role_view_docdata"] = 'Ver los datos de recurso';
$_lang["role_view_eventlog"] = 'Ver el archivo de registros';
$_lang["role_view_logs"] = 'Ver el archivo de registros de sistema';
$_lang["role_view_unpublished"] = 'Ver los recursos dispublicados';
$_lang["role_web_access_persmissions"] = 'Los permisos de acceso web';
$_lang["role_web_user_management"] = 'Administración de usuarios web';
$_lang["rss_url_news_default"] = 'https://github.com/evocms-community/evolution/releases.atom';
$_lang["rss_url_news_message"] = 'Introduzca el URL de la fuente de noticias de Evolution CMS.';
$_lang["rss_url_news_title"] = 'Feed RSS de noticias';
$_lang["rss_url_security_default"] = 'https://github.com/extras-evolution/security-fix/releases.atom';
$_lang["rss_url_security_message"] = 'Introduzca el URL de la fuente de seguridad de Evolution CMS.';
$_lang["rss_url_security_title"] = 'Feed RSS de seguridad';
$_lang["run_module"] = 'Ejecutar el módulo';
$_lang["saturday"] = 'Sábado';
$_lang["save"] = 'Guardar';
$_lang["save_all_changes"] = 'Guardar todos los cambios';
$_lang["save_tag"] = 'Guardar las etiquetas';
$_lang["saving"] = 'Está guardando, espere por favor...';
$_lang["search"] = 'Buscar';
$_lang["search_criteria"] = 'Criterio de búsqueda';
$_lang["search_criteria_content"] = 'Buscar por contenido';
$_lang["search_criteria_content_msg"] = 'Encontrar todos los recursos con el texto ingresado en su contenido.';
$_lang["search_criteria_id"] = 'Buscar por ID';
$_lang["search_criteria_id_msg"] = 'Ingresar el ID de un recurso para encontrar rápidamente este recurso.';
$_lang["search_criteria_top"] = 'Buscar en los campos principales';
$_lang["search_criteria_top_msg"] = 'El título de página, el título largo, el alias, ID';
$_lang["search_criteria_template_id"] = 'Buscar por ID de plantilla de sitio';
$_lang["search_criteria_template_id_msg"] = 'Buscar todos los recursos que usan la plantilla especificada.';
$_lang["search_criteria_url_msg"] = 'Buscar el recurso por URL exacta.';
$_lang["search_criteria_longtitle"] = 'Encontrar por título largo';
$_lang["search_criteria_longtitle_msg"] = 'Buscar todos los recursos con el texto ingresado en su título largo.';
$_lang["search_criteria_title"] = 'Buscar por título';
$_lang["search_criteria_title_msg"] = 'Buscar todos los recursos con el texto ingresado en su título.';
$_lang["search_empty"] = 'Su búsqueda no ha regresado resultados. Por favor amplíe usted sus criterios de búsqueda e inténtelo usted de nuevo.';
$_lang["search_item_deleted"] = 'Este artículo ha sido borrado';
$_lang["search_results"] = 'Resultados de búsqueda';
$_lang["search_results_returned_desc"] = 'Descripción';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Su criterio de búsqueda regresó <b>%s</b> recursos. Si se han encontrado demasiados resultados, intente usted ingresar una búsqueda más especifica.';
$_lang["search_results_returned_title"] = 'Título';
$_lang["search_view_docdata"] = 'Ver este artículo';
$_lang["security"] = 'Usuarios';
$_lang["security_notices_tab"] = 'Notas de seguridad';
$_lang["security_notices_title"] = 'Notas de seguridad';
$_lang["select_date"] = 'Seleccione una fecha';
$_lang["send"] = 'Enviar';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Si su sitio usa las conexión https, por favor especifíquelo usted aquí.';
$_lang["server_protocol_title"] = 'Tipo de servidor:';
$_lang["serveroffset"] = 'Desplazamiento de servidor';
$_lang["serveroffset_message"] = 'Seleccione usted el número de horas de diferencia entre donde se encuentra y donde está el servidor. La hora actual del servidor es <b>[%s]</b>, la hora actual del servidor usando el offset guardado actual es <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Hora desplazamiento del servidor:';
$_lang["servertime"] = 'Hora del servidor';
$_lang["set_automatic"] = 'Establecer automáticamente';
$_lang["set_default"] = 'Establecer por el defecto';
$_lang["set_default_all"] = 'Configurar valores predeterminados';
$_lang["settings_after_install"] = 'Como se trata de una nueva instalación debe revisar estas configuraciones y cambiar las que desee usted. Después de haber revisado la configuración, presione "Guardar" para actualizar la base de datos de configuración.';
$_lang["settings_config"] = 'Configuración';
$_lang["settings_dependencies"] = 'Dependencias';
$_lang["settings_events"] = 'Eventos de sistema';
$_lang["settings_furls"] = 'URLs amigables';
$_lang["settings_general"] = 'General';
$_lang["settings_group_tv_message"] = 'Elija si las variables de plantilla deben agruparse en secciones o pestañas (nombradas por categoría de TV) al editar un recurso';
$_lang["settings_group_tv_options"] = 'No,Secciones en la pestaña General,Pestañas en la pestaña General,Secciones en nueva pestaña,Pestañas en nueva pestaña,Nuevas pestañas';
$_lang["settings_misc"] = 'Administrador de archivos';
$_lang["settings_security"] = 'Seguridad';
$_lang["settings_KC"] = 'Explorador de archivos';
$_lang["settings_page_settings"] = 'Ajustes';
$_lang["settings_photo"] = 'Fotografía';
$_lang["settings_properties"] = 'Opciónes';
$_lang["show_fullscreen_btn_message"] = 'Mostrar el botón de alternancia de pantalla completa en el menú';
$_lang["show_newresource_btn_message"] = 'Mostrar el botón para crear un recurso nuevo en el menú';
$_lang["settings_show_picker_message"] = 'Personalice el tema de administrador y guárdelo en el almacenamiento local';
$_lang["show_fullscreen_btn"] = 'El botón de alternar pantalla completa';
$_lang["show_newresource_btn"] = 'El botón de la creación de un recurso nuevo';
$_lang["settings_site"] = 'Sitio';
$_lang["settings_strip_image_paths_message"] = 'Si se establece en \'NO\', Evolution CMS escribirá los src del explorador de archivos (imágenes, archivos, flash, etc.) como URL absolutas. Las URL relativas son útiles si desea mover su instalación de Evolution CMS, por ejemplo, de un sitio de prueba a un sitio de producción. Si no tiene idea de lo que esto significa, es mejor dejarlo configurado en \'SÍ\'.';
$_lang["settings_strip_image_paths_title"] = '¿Re-escribir las direcciones del navegador?';
$_lang["settings_templvars"] = 'Variables de plantilla (TV)';
$_lang["settings_title"] = 'Configuración de sistema';
$_lang["settings_ui"] = 'Interfaz y Características';
$_lang["settings_users"] = 'Usuario';
$_lang["settings_email_templates"] = 'Correo electrónico y plantillas';
$_lang["show_meta"] = 'Mostrar la pestaña de palabras clave META';
$_lang["show_meta_message"] = 'Mostrar la pestaña de palabras clave META obsoletas al editar recursos en el administrador.';
$_lang["show_tree"] = 'Mostrar el árbol';
$_lang["show_picker"] = 'Mostrar el selector de colores';
$_lang["showing"] = 'Está mostrando';
$_lang["signupemail_message"] = 'Configurar el mensaje de email enviado a los usuarios cuando se les cree una cuenta incluyendo su nombre de usuario y su contraseña. <br />
<b>Nota:</b> Los placeholders siguientes son remplazados por el administrador de contenido cuando el mensaje es enviado: <br /><br />[+sname+] - Nombre de su sitio web, <br />[+saddr+] - La dirección electrónica de su sitio web, <br />[+surl+] - La dirección URL de tu sitio, <br />[+uid+] - El nombre o ID de usuario, <br />[+pwd+] - La contraseña de usuario, <br />[+ufn+] - El nombre completo de usuario. <br /><br /><b>Deja el [+uid+] y [+pwd+] en el email o el nombre de usuario y la contraseña no serán enviados en el email ¡y sus usuarios no los conocerán!</b>';
$_lang["signupemail_title"] = 'Correo electrónico de inicio de sesión:';
$_lang["site"] = 'Sitio';
$_lang["site_schedule"] = 'Horario';
$_lang["sitename_message"] = 'Ingrese usted el nombre de sitio aquí.';
$_lang["sitename_title"] = 'Nombre de sitio:';
$_lang["sitestart_message"] = 'Ingresa el ID de recurso que quiere usted usar como la página principal aquí.
<b>Nota:</b> Asegúrese que el ID ingresado pertenece a un recurso existente ¡y que ha sido publicado!';
$_lang["sitestart_title"] = 'Página de inicio de sitio:';
$_lang["sitestatus_message"] = 'Seleccione \'En Línea\' para publicar su sitio en la red. Si selecciona \'Fuera de línea\' sus visitantes verán el mensaje de \'El sitio no está disponible\' y no podrán navegar por el sitio.';
$_lang["sitestatus_title"] = 'Estado de sitio:';
$_lang["siteunavailable_message"] = 'El mensaje para mostrar cuando el sitio está fuera de línea o si ocurre un error.
<b>Nota:</b> Este mensaje solo se mostrará si la opción de página \'Sitio no está disponible\' no está configurada.';
$_lang["siteunavailable_message_default"] = 'Este sitio no está disponible ahora.';
$_lang["siteunavailable_page_message"] = 'Ingresa el ID de recurso que quiere usar como la página \'Fuera de línea\'.
<b>Nota:</b> Asegúrese que el ID ingresado pertenece a un recurso existente ¡y que ha sido publicado!';
$_lang["siteunavailable_page_title"] = 'La página \'El sitio no está disponible\':';
$_lang["siteunavailable_title"] = 'El mensaje para \'El sitio no está disponible\':';
$_lang["controller_namespace"] = 'El espacio de nombres del controlador';
$_lang["controller_namespace_message"] = 'Especifique el espacio de nombres completo del que vale la pena tomar los controladores, por ejemplo: EvolutionCMS\\Main\\Controllers\\';
$_lang["update_repository"] = 'Ruta del repositorio de GitHub';
$_lang["update_repository_message"] = 'Ingrese la ruta del repositorio de GitHub, por ejemplo: <b>evocms-community/evolution</b>';
$_lang["snippet"] = 'Fragmento (snippet)';
$_lang["snippets"] = 'Fragmentos (snippets)';
$_lang["snippet_code"] = 'Código de fragmento (snippet) (php)';
$_lang["snippet_desc"] = 'Descripción';
$_lang["snippet_execonsave"] = 'Ejecutar el fragmento (snippet) después de guardarlo.';
$_lang["snippet_management_msg"] = 'Elija usted el fragmento (snippet) que desee usted editar.';
$_lang["snippet_msg"] = 'Agregar/editar los fragmentos (snippets). Recuerde usted que el fragmento es el código PHP \'puro\' y si espera que la salida del fragmento se muestre en un punto determinado dentro de la plantilla debe devolver un valor desde el fragmento.';
$_lang["snippet_name"] = '[[nombre_de_fragmento]]';
$_lang["snippet_properties"] = 'Propiedades prefijadas';
$_lang["snippet_title"] = 'Crear/editar el fragmento (snippet)';
$_lang["sort_alphabetically"] = 'Ordenar alfabéticamente';
$_lang["sort_asc"] = 'Ascendente';
$_lang["sort_desc"] = 'Descendente';
$_lang["sort_menuindex"] = 'Ordenar por el índice de menú';
$_lang["sort_tree"] = 'Ordenar el árbol';
$_lang['sort_updating'] = 'Está actualizando...';
$_lang['sort_updated'] = 'Ha actualizado!';
$_lang['sort_nochildren'] = 'El recurso no tiene recursos secundarios';
$_lang["sort_elements_msg"] = 'Arrastre usted para reordenar los elementos de lista.';
$_lang["source"] = 'El fuente';
$_lang["stay"] = 'Continuar la edición';
$_lang["stay_new"] = 'Añadir otro';
$_lang["submit"] = 'Enviar';
$_lang["sunday"] = 'Domingo';
$_lang["sys_alert"] = 'Alerta de sistema';
$_lang["sysinfo_activity_message"] = 'Esta lista muestra que recursos han sido editados recientemente por sus usuarios.';
$_lang["sysinfo_userid"] = 'Usuario';
$_lang["system"] = 'Sistema';
$_lang["system_email_signup"] = '<!doctype html>
<html>
Hola [+uid+]

Aquí tiene usted los detalles de inicio de sesión para el Administrador de Contenido de [+sname+]:

Usuario: [+uid+]
Contraseña: [+pwd+]

Una vez que ha ingresado al Administrador de Contenido de ([+surl+]), puede usted cambiar su contraseña.

Saludos,
El Administrador
</html>';
$_lang["system_email_webreminder"] = 'Hola [+uid+]

Para activar su contraseña nueva haga usted clic en la enlace siguiente:

[+surl+]

Si tiene usted éxito puede usted usar la siguiente contraseña para ingresar:

Contraseña: [+pwd+]

Si no solicitó usted este email entonces por favor ignórelo usted.

Saludos,
El Administrador';
$_lang["system_email_websignup"] = 'Hola [+uid+]

Aquí tiene usted los detalles de ingreso para [+sname+]:

Nombre de usuario: [+uid+]
Contraseña: [+pwd+]

Una vez que ingresa usted a [+sname+] ([+surl+]), puede usted cambiar su contraseña.

Saludos,
El Administrador';
$_lang["table_hoverinfo"] = 'Pase usted el ratón sobre el nombre de la tabla para ver una corta descripción de su función (no todas las tablas tienen <i>comentarios</i> configurados).';
$_lang["table_prefix"] = 'Prefijo de tabla';
$_lang["tag"] = 'Etiqueta';
$_lang["template"] = 'Plantilla (template)';
$_lang["templates"] = 'Plantillas (templates)';
$_lang["template_assignedtv_tab"] = 'Variables de plantilla (TV) asignadas';
$_lang["template_code"] = 'Código de plantilla (html)';
$_lang["template_desc"] = 'Descripción';
$_lang["template_edit_tab"] = 'Editar la plantilla (template)';
$_lang["template_inuse"] = 'This template is in use. Please set the documents using the template to another template. Documents using this template:';
$_lang["template_management_msg"] = 'Eliga usted que plantilla desea usted editar.';
$_lang["template_msg"] = 'Crea y edita las plantillas. Las plantillas nuevas o modificadas no serán visibles en las páginas cacheadas de tu sitio hasta que el caché sea vaciado, sin embargo, puede usted usar la función de previsualización en una página para ver el template en acción.';
$_lang["template_name"] = 'Nombre de plantilla (template)';
$_lang["template_no_tv"] = 'Aún no se han asignado las variables de plantilla a esta plantilla.';
$_lang["template_notassigned_tv"] = 'Estas variables de plantilla están disponibles para la asignación.';
$_lang["template_reset_all"] = 'Restablecer todas las páginas a usar la plantilla predeterminada';
$_lang["template_reset_specific"] = 'Restablecer solamente \'%s\' páginas';
$_lang["template_assigned_blade_file"] = 'Archivo de tipo Blade correspondiente';
$_lang["template_create_blade_file"] = 'Crear el archivo de plantilla al guardar';
$_lang["template_selectable"] = 'La plantilla será seleccionable al crear o editar recursos.';
$_lang["template_title"] = 'Crear/editar la plantilla (template)';
$_lang["template_tv_edit"] = 'Editar el orden de clasificación de las variables de plantilla (TV)';
$_lang["template_tv_edit_message"] = 'Arrastre para reordenar las variables de plantilla (TV) de esta plantilla';
$_lang["template_tv_edit_title"] = 'El orden de clasificación de las variables de plantilla (TV)';
$_lang["template_tv_msg"] = 'Las variables de plantilla (TV) asignadas a esta plantilla están listadas aquí abajo.';
$_lang["thursday"] = 'Jueves';
$_lang["tmplvar_access_msg"] = 'Seleccione los grupos de recursos que tienen el permiso modificar el contenido o el valor de esta variable';
$_lang["tmplvar_change_template_msg"] = 'Cambiar esta plantilla hará que la página vuelva a cargar las variables de plantilla (TV), perdiendo los cambios no guardados. ¿Está seguro que desea cambiar esta plantilla?';
$_lang["tmplvar_inuse"] = 'Los siguientes recursos están utilizando actualmente esta variable de plantilla (TV). Para continuar la operación de eliminación haga usted clic en el botón \'Eliminar\'; al contrario haga usted clic en el botón \'Cancelar\'.';
$_lang["tmplvar_tmpl_access"] = 'Acceso a la plantilla';
$_lang["tmplvar_tmpl_access_msg"] = 'Seleccione las plantillas que tienen el permiso acceder/procesar esta variable';
$_lang["tmplvar"] = 'Variable de plantilla (TV)';
$_lang["tmplvars"] = 'Variables de plantilla (TV)';
$_lang["tmplvars_binding_msg"] = 'Este campo soporta vínculos de fuente de datos usando comandos empezados con @';
$_lang["tmplvars_caption"] = 'Subtítulo';
$_lang["tmplvars_default"] = 'Valor prefijado';
$_lang["tmplvars_description"] = 'Descripción';
$_lang["tmplvars_elements"] = 'Los valores de opción de ingreso';
$_lang["tmplvars_inherited"] = 'Valor heredado';
$_lang["tmplvars_management_msg"] = 'Administrar las variables de plantilla (TV) adicionales para sus recursos.';
$_lang["tmplvars_msg"] = 'Agregue o edite las variables de plantilla (TV) aquí. Las variables de plantilla (TV) deben asignarse a plantillas para poder acceder a ellas desde fragmentos y recursos.';
$_lang["tmplvars_name"] = '[*nombre_de_variable*]';
$_lang["tmplvars_novars"] = 'No se encontraron las variables de plantilla (TV)';
$_lang["tmplvars_rank"] = 'Orden de clasificación';
$_lang["tmplvars_rank_edit_message"] = 'Arrastre para reordenar las variables de plantilla (TV).';
$_lang["tmplvars_reset_params"] = 'Reajustar los parámetros';
$_lang["tmplvars_title"] = 'Crear/editar el variable de plantilla (TV)';
$_lang["tmplvars_type"] = 'Tipo de entrada';
$_lang["tmplvars_widget"] = 'Artilugio (widget)';
$_lang["tmplvars_widget_prop"] = 'Las propiedades de artilugio (widget)';
$_lang["to"] = 'a';
$_lang["toggle_fullscreen"] = 'Alternar la pantalla completa';
$_lang["tools"] = 'Herramientas';
$_lang["top_howmany_message"] = 'Cuando esté viendo ¿cuál debe ser el tamaño de las listas "Principales..."?';
$_lang["top_howmany_title"] = 'Cuántos principales';
$_lang["total"] = 'total';
$_lang["track_visitors_message"] = 'Marque para mostrar los recursos secundarios en el árbol de recursos';
$_lang["track_visitors_title"] = 'Mostrar los recursos secundarios';
$_lang["tree_page_click"] = 'Comportamiento de clics en la página';
$_lang["tree_page_click_message"] = 'El comportamiento por el defecto al hacer clic en una página en el árbol de sitio.';
$_lang["use_breadcrumbs"] = 'Mostrar la navegación';
$_lang["use_breadcrumbs_message"] = 'Mostrar la navegación al crear o editar recursos en el Administrador';
$_lang["tree_show_protected"] = 'Mostrar las páginas protegidas';
$_lang["tree_show_protected_message"] = 'Cuando se establece en \'NO\', los recursos protegidos (y todos sus recursos secundarios) no aparecen en el menú del árbol de sitio. \'NO\' es la configuración heredada de Evolution CMS.';
$_lang["truncate_table"] = 'Haga clic aquí para truncar esta tabla';
$_lang["tuesday"] = 'Martes';
$_lang["tv"] = 'Variable de plantilla (TV)';
$_lang["type"] = 'Tipo';
$_lang["udperms_allowroot_message"] = 'Permitir a los usuarios crear los recursos nuevos en la raíz de sitio.';
$_lang["udperms_allowroot_title"] = 'Permitir la raíz:';
$_lang["udperms_message"] = 'Controlar el acceso a los recursos a través de grupos de usuarios y grupos de recursos.';
$_lang["udperms_title"] = 'Usar los permisos de acceso:';
$_lang["unable_set_link"] = '¡No se puede establecer el enlace!';
$_lang["unable_set_parent"] = '¡No se puede establecer un padre nuevo!';
$_lang["unauthorizedpage_message"] = 'Ingrese un ID de recurso publicado y de acceso público para redirigir a los usuarios cuando soliciten un recurso seguro/no autorizado.';
$_lang["unauthorizedpage_title"] = 'Página para no autorizados:';
$_lang["unblock_message"] = 'Este usuario no será bloqueado después de guardar sus datos.';
$_lang["undelete_resource"] = 'Recuperar el recurso';
$_lang["unpublish_date"] = 'Decha de despublicación';
$_lang["unpublish_events"] = 'Despublicar los eventos';
$_lang["unpublish_resource"] = 'Despublicar el recurso';
$_lang["untitled_resource"] = 'Recurso sin título';
$_lang["untitled_weblink"] = 'Enlace web sin título';
$_lang["update_params"] = 'Actualizar la muestra de parámetros';
$_lang["update_settings_from_language"] = 'Reemplazar el actual con:';
$_lang["upload_maxsize_message"] = 'Ingresa el tamaño máximo de archivo a ser subido por el Administrador de archivos. El tamaño de archivo a subir debe de ser ingresado en bytes. NOTA: ¡Archivos grandes pueden demorar mucho tiempo para subir!
Ingrese usted el tamaño máximo de archivo que se puede cargar a través del administrador de archivos. El tamaño del archivo de carga se debe ingresar en bytes. 
<b>Nota:</b> ¡Los archivos grandes pueden tardar mucho en cargarse!';
$_lang["upload_maxsize_title"] = 'Tamaño máximo de cargar';
$_lang["uploadable_files_message"] = 'Ingrese una lista de archivos que se pueden cargar en \'assets/files/\' utilizando el explorador de archivos. Ingrese las extensiones (separados por comas) para los tipos de archivo.';
$_lang["uploadable_files_title"] = 'Tipos de archivos que se pueden cargar:';
$_lang["uploadable_flash_message"] = 'Ingrese una lista de archivos que se pueden cargar en \'assets/flash/\' utilizando el explorador de archivos. Ingrese las extensiones (separados por comas) para los tipos de flash.';
$_lang["uploadable_flash_title"] = 'Tipos de archivos flash que se pueden cargar:';
$_lang["uploadable_images_message"] = 'Ingrese una lista de archivos que se pueden cargar en \'asstes/images/\' utilizando el explorador de archivos. Ingrese las extensiones (separadas por comas) para los tipos de imágenes.';
$_lang["uploadable_images_title"] = 'Tipos de Imágenes que se pueden cargar:';
$_lang["uploadable_media_message"] = 'Ingrese una lista de archivos que se pueden cargar en \'assets/media/\' utilizando el explorador de archivos. Ingrese las extensiones (separados por comas) para los tipos de medios.';
$_lang["uploadable_media_title"] = 'Tipos de archivo media que se pueden cargar:';
$_lang["use_alias_path_message"] = 'Habilitar esta opción genera una ruta virtual al recurso. Por ejemplo, si un Recurso \'hijo.html\' se encuentra en el recurso de contenedor \'padre\', entonces la URL completa de la ruta del alias de URL será \'/padre/hijo.html\'.';
$_lang["use_alias_path_title"] = 'Usar la dirección alias URL amigable:';
$_lang["use_editor_message"] = 'Permitir la edición con un editor de texto enriquecido (RTE). Esta configuración se aplica a todos los recursos, pero se puede anular en la configuración del usuario.';
$_lang["use_editor_title"] = 'Habilitar el editor:';
$_lang["use_global_tabs"] = 'Usar las pestañas globales';
$_lang["user"] = 'Usuario';
$_lang["user_block"] = 'Está bloqueado';
$_lang["user_blockedafter"] = 'Será bloqueado después';
$_lang["user_blockeduntil"] = 'Está bloqueado antes';
$_lang["user_changeddata"] = 'Sus datos han sido cambiados. Por favor ingresa de nuevo.';
$_lang["user_country"] = 'País';
$_lang["user_dob"] = 'La fecha de nacimiento';
$_lang["user_doesnt_exist"] = 'Usuario no existe';
$_lang["user_edit_self_msg"] = '<b>Es posible que deba cerrar sesión y volver a iniciar sesión después de guardar para actualizar completamente su información.</b> Las contraseñas nuevas se enviarán a su dirección de correo electrónico o se mostrarán en la pantalla.';
$_lang["user_email"] = 'Correo electrónico';
$_lang["user_failedlogincount"] = 'Ingresos fallidos';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Femenino';
$_lang["user_full_name"] = 'Nombre completo';
$_lang["user_first_name"] = 'Nombre de pila';
$_lang["user_last_name"] = 'Apellido';
$_lang["user_middle_name"] = 'Nombre segundo';
$_lang["user_gender"] = 'Género';
$_lang["user_is_blocked"] = '¡Este usuario está bloqueado!';
$_lang["user_logincount"] = 'Número de ingresos';
$_lang["user_male"] = 'Masculino';
$_lang["user_management_msg"] = 'Elija el administrador de contenido para editar. Los usuarios del administrador de contenido son aquellos usuarios que pueden iniciar sesión en el administrador de contenido.';
$_lang["user_management_title"] = 'Los usuarios de administración';
$_lang["user_mobile"] = 'Móvil';
$_lang["user_phone"] = 'Teléfono';
$_lang["user_photo"] = 'Foto de usuario';
$_lang["user_photo_message"] = 'Ingrese la URL de la imagen para este usuario o use el botón "Insertar" para seleccionar o cargar un archivo de imagen en el servidor.';
$_lang["user_prevlogin"] = 'Ingreso último ';
$_lang["user_role"] = 'Rol de usuario';
$_lang["no_user_role"] = 'No hay rol seleccionado';
$_lang["user_state"] = 'El estado o la provincia';
$_lang["user_title"] = 'Crear/editar un usuario';
$_lang["user_upload_message"] = 'Si desea que este usuario deje de cargar cualquier tipo de archivo en esta categoría, asegúrese que la casilla de verificación \'Usar configuración principal\' no esté marcada y deje el campo en blanco.';
$_lang["user_use_config"] = 'Usar la configuración principal';
$_lang["user_verification"] = 'Usuario está verificado';
$_lang["user_zip"] = 'Código postal';
$_lang["username"] = 'Nombre de usuario';
$_lang["username_unique"] = '¡El nombre de usuario ya está en uso!';
$_lang["users"] = 'Usuarios';
$_lang["valid_hostnames_message"] = 'Ayudar a evitar que XSS abuse de la configuración del sistema site_url proporcionando una lista separada por comas de nombres de host válidos para esta instalación. Esto es importante para algunos tipos de hosts compartidos o hosts accesibles directamente a través de una dirección IP. El primer nombre de host de la lista se usa si HTTP_HOST no coincide con ningún nombre de host válido.';
$_lang["valid_hostnames_title"] = 'Nombres de host válidos';
$_lang["validate_referer_message"] = 'Validar los encabezados HTTP_REFERER para reducir el riesgo que sus editores de contenido sean engañados para que realicen acciones no deseadas en el administrador como víctimas de un ataque CSRF (Cross Site Request Forgery). Es posible que algunas configuraciones no puedan usar esta opción si el servidor no envía encabezados HTTP_REFERER.';
$_lang["validate_referer_title"] = 'Validar los encabezados HTTP_REFERER?';
$_lang["value"] = 'El valor';
$_lang["version"] = 'Versión';
$_lang["view"] = 'Ver';
$_lang["view_child_resources_in_container"] = 'Secundarios';
$_lang["view_log"] = 'Ver el registro';
$_lang["view_logging"] = 'Acciones de administración';
$_lang["view_sysinfo"] = 'Información de sistema';
$_lang["warning"] = '¡Advertencia!';
$_lang["warning_not_saved"] = 'Los cambios que ha realizado aún no se han guardados. Puede optar por permanecer en la página actual para guardar los cambios (Cancelar) o puede salir de esta página y perder los cambios que hayan realizados (Aceptar).';
$_lang["warning_visibility"] = 'Las advertencias de configuración visibles para';
$_lang["warning_visibility_message"] = 'Controle la visibilidad de las advertencias de configuración que se muestran en la página de bienvenida de Manager';
$_lang["web_access_permissions"] = 'Permisos de acceso web';
$_lang["web_access_permissions_user_groups"] = 'Grupo de usuarios web:';
$_lang["web_permissions"] = 'Permisos web';
$_lang["web_user_management_msg"] = 'Elija el usuario que desea editar. Los usuarios son los que pueden iniciar sesión en el sitio web y en el administrador.';
$_lang["web_user_management_title"] = 'Usuarios web';
$_lang["web_user_management_select_role"] = 'Todos los roles';
$_lang["web_user_title"] = 'Crear/editar un usuario web';
$_lang["web_users"] = 'Usuarios web';
$_lang["weblink"] = 'Enlace web';
$_lang["webpwdreminder_message"] = 'Ingrese un mensaje a ser enviado a tus usuarios web cuando soliciten una contraseña nueva vía email. El administrador de contenido enviará un email conteniendo su nueva contraseña y la información de activación. <br />
<b>Nota:</b> Los siguientes placeholders son reemplazados por el administrador de contenido cuando el mensaje sea enviado: <br /><br />
[+sname+] - el nombre de tu sitio web, <br />
[+saddr+] - la dirección de correo electrónico de sitio, <br />
[+surl+] - la dirección url de sitio, <br />
[+uid+] - el nombre o ID de ingreso de usuario, <br />
[+pwd+] - la contraseña de usuario, <br />
[+ufn+] - el nombre completo de usuario. <br /><br />
<b>Deje [+uid+] y [+pwd+] en el mensaje, de otro modo el nombre de usuario y la contraseña no serán enviadas en el mensaje ¡y sus usuarios no la conocerán!</b>';
$_lang["webpwdreminder_title"] = 'Correo electrónico de recordatorio';
$_lang["websignupemail_message"] = 'Configure el mensaje de email enviado a los usuarios cuando creen una cuenta incluyendo su nombre de usuario y su contraseña. <br />
<b>Nota:</b> Los siguientes placeholders son reemplazados por el administrador de contenido cuando el mensaje es enviado: <br /><br />
[+sname+] - el nombre de sitio, <br />
[+saddr+] - la dirección de correo electrónico de sitio, <br />
[+surl+] - la dirección URL de sitio, <br />
[+uid+] - el nombre o ID de ingreso de usuario, <br />
[+pwd+] - la contraseña de usuario, <br />
[+ufn+] - el nombre completo de usuario. <br /><br />
<b>Deja [+uid+] y [+pwd+] en el mensaje, de otro modo el nombre de usuario y la contraseña no serán enviadas en el mensaje ¡y tus usuarios no lo conocerán!</b>';
$_lang["websignupemail_title"] = 'Correo electrónico de registración';
$_lang["allow_multiple_emails_title"] = 'Duplicar el correo electrónico de usuario';
$_lang["allow_multiple_emails_message"] = 'Permitir a los usuarios de web compartir la misma dirección de correo electrónico para situaciones en las que un miembro no tiene su propia dirección de correo electrónico o solo hay una dirección de correo electrónico familiar.
<br/>Nota: cualquier recordatorio de contraseña y lógica de registro deberá tener en cuenta esta opción si se establece en sí.';
$_lang["wednesday"] = 'Miércoles';
$_lang["welcome_title"] = 'Bienvenido a su administrador de contenido de Evolution CMS';
$_lang["which_editor_message"] = 'Seleccione el editor de texto enriquecido (RTE). Puede descargar e instalar RTE adicionales desde la página de descarga de Evolution CMS.';
$_lang["which_editor_title"] = 'Editor para usar:';
$_lang["working"] = 'Está trabajando...';
$_lang["wrap_lines"] = 'Encapsular líneas (wrap)';
$_lang["xhtml_urls_message"] = 'Reemplaza los signos & (&amp;) en los URLs generados por EVO con el htmlentity &amp<!-- -->amp; que es válido en XHTML.';
$_lang["xhtml_urls_title"] = 'Los URLs XHTML';
$_lang["yes"] = 'Sí';
$_lang["you_got_mail"] = 'Tiene un mensaje';
$_lang["yourinfo_message"] = 'Esta sección muestra alguna información acerca de su:';
$_lang["yourinfo_previous_login"] = 'Su último ingreso:';
$_lang["yourinfo_role"] = 'Su rol es:';
$_lang["yourinfo_title"] = 'Su información';
$_lang["yourinfo_total_logins"] = 'Número total de ingresos:';
$_lang["yourinfo_username"] = 'Está ingresado como:';

$_lang["a17_error_reporting_title"] = 'Nivel de detección de errores de PHP';
$_lang["a17_error_reporting_msg"] = 'Establezca el nivel de detección de los errores de PHP.';
$_lang["a17_error_reporting_opt0"] = 'Ignorar todo';
$_lang["a17_error_reporting_opt1"] = 'Ignorar las advertencias de un ligero nivel de aviso (<a href="https://www.google.com/search?q=E_DEPRECATED+E_STRICT" target="_blank">E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT</a>)';
$_lang["a17_error_reporting_opt2"] = 'Detectar todos los errores excepto E_NOTICE y E_USER_DEPRECATED';
$_lang["a17_error_reporting_opt99"] = 'Detectar todos los errores excepto E_USER_DEPRECATED';
$_lang["a17_error_reporting_opt199"] = 'Detectar todos';

$_lang["pwd_hash_algo_title"] = 'Algoritmo hash';
$_lang["pwd_hash_algo_message"] = 'Algoritmo hash de contraseña.';

$_lang["enable_bindings_title"] = 'Habilitar los comandos @Bindings';
$_lang["enable_bindings_message"] = 'Impedir la ejecución de funciones de PHP a través de TV @BINDINGS. Útil si tiene usted los usuarios de administración que no deberían poder crear código PHP pero necesitan poder crear o editar las variables de plantilla (TV). La salida de cualquier TV con @Binding será \'@BINDINGS disabled\'.';
$_lang["enable_filter_title"] = 'Habilitar los filtros';
$_lang["enable_filter_message"] = 'Los filtros le permiten manipular la forma en que se presentan o analizan los datos en una etiqueta. Le permiten modificar valores dentro de sus plantillas. Esto es análogo a PHx. <a href="https://github.com/modxcms/evolution/issues/623" target="ext_help">Más información</a>'; // todo: change link to documentation
$_lang["enable_filter_phx_warning"] = 'Cuando está habilitada PHx plugin, incorporado en los filtros están desactivados por defecto. Cuando la extensión (plugin) PHx está habilitado los filtros integrados serán deshabilitados por el defecto';

$_lang["enable_at_syntax_title"] = 'Habilitar @SYNTAX';
$_lang["enable_at_syntax_message"] = '@SYNTAX (sintaxis con @) es una sintaxis de plantilla simple y ligera. Esto está diseñado para considerar la coexistencia con etiquetas HTML y cadenas de contenido.';

$_lang["bkmgr_alert_mkdir"] = 'No se puede crear un archivo en un directorio. Verifique el permiso de [+snapshot_path+]';
$_lang["bkmgr_restore_msg"] = '<p>Las tablas de la base de datos podrían ser restauradas por SQL</p>';
$_lang["bkmgr_restore_title"] = 'Restaurar';
$_lang["bkmgr_import_ok"] = 'La recuperación de SQL se realizó con exito.';
$_lang["bkmgr_snapshot_ok"] = 'La instantánea se guardó normalmente.';
$_lang["bkmgr_run_sql_file_label"] = 'Ejecutar por el archivo SQL';
$_lang["bkmgr_run_sql_direct_label"] = 'La ejecución directa de los comandos SQL';
$_lang["bkmgr_run_sql_submit"] = 'Ejecutar la restauración';
$_lang["bkmgr_run_sql_result"] = 'Resulto';
$_lang["bkmgr_snapshot_title"] = 'La guardación y la recuperación de instantáneas';
$_lang["bkmgr_snapshot_msg"] = 'El contenido de la base de datos se guarda y restaura desde un directorio del servidor.<br />La ubicación: [+snapshot_path+] (evo()->getConfig[\'snapshot_path\'])';
$_lang["bkmgr_snapshot_submit"] = 'Añadir la instantánea';
$_lang["bkmgr_snapshot_list_title"] = 'Lista de instantáneas';
$_lang["bkmgr_restore_submit"] = 'Revertir estos datos';
$_lang["bkmgr_restore_confirm"] = '¿Estás seguro que quiere usted revertir la copia de seguridad [+filename+]?';
$_lang["bkmgr_snapshot_nothing"] = 'No hay instantáneas disponibles';

$_lang["files.dynamic.php1"] = 'Archivo nuevo de texto';
$_lang["files.dynamic.php2"] = 'Este directorio no se puede mostrar.';
$_lang["files.dynamic.php3"] = 'Hay un problema en el nombre de archivo.';
$_lang["files.dynamic.php4"] = 'El archivo de texto fue creado.';
$_lang["files.dynamic.php5"] = 'El archivo no pudo ser duplicado.';
$_lang["files.dynamic.php6"] = 'No se pudo cambiar el nombre del archivo o del directorio.';
$_lang["files_dynamic_new_folder_name"] = 'Introduzca el nombre nuevo de directorio:';
$_lang["files_dynamic_new_file_name"] = 'Introduzca el nombre nuevo de archivo:';
$_lang["not_readable_dir"] = 'No se puede leer este directorio.';
$_lang["confirm_delete_dir"] = '¿Está seguro que quiere usted borrar el directorio?';
$_lang["confirm_delete_dir_recursive"] = '¿Está que desea eliminar este directorio?
Todos los archivos dentro de directorio también se eliminarán.';

$_lang["make_folders_title"] = 'Terminal el URL de contenedor con barra inclinada';
$_lang["make_folders_message"] = 'Añadir una barra inclinada final a los recursos que se configuran como contenedores cuando se usan las direcciones URL amigables.';

$_lang["check_files_onlogin_title"] = 'Verificar los archivos principales al iniciar sesión';
$_lang["check_files_onlogin_message"] = 'Al habilitar esta opción, se verificarán los archivos importantes del sistema en busca de modificaciones típicas de los ataques a sitios web con secuencias de comandos. Si bien no es una garantía infalible, puede alertarlo sobre un archivo y un sitio web de EVO comprometidos.';

$_lang["configcheck_sysfiles_mod"] = 'Se han modificado archivos importantes del sistema.';
$_lang["configcheck_sysfiles_mod_msg"] = 'Configuró EVO para verificar archivos importantes del sistema en busca de posibles ataques de secuencias de comandos de sitios web. Esta advertencia no significa necesariamente que su sitio se haya visto comprometido, sin embargo, debe revisar los archivos observados en su instalación (configurados en Configuración del sistema -> Usuario -> Verificar los archivos principales al iniciar sesión). Si encuentra sus archivos inalterados o los administradores del sitio realizaron cambios, vaya a Configuración del sistema y haga clic para volver a guardar la configuración para descartar este mensaje. Se han encontrado cambios en los siguientes archivos:';

$_lang['email_method_title'] = 'Metodos de sendmail';
$_lang['email_method_mail'] = 'Función mail() de PHP';
$_lang['email_method_smtp'] = 'Servidor SMTP';
$_lang['smtp_auth_title'] = 'SMTP-AUTH';
$_lang['smtp_autotls_title'] = 'SMTPAutoTLS';
$_lang['smtp_host_title'] = 'Hospedador SMTP';
$_lang['smtp_secure_title'] = 'SMTP cifrado';
$_lang['smtp_username_title'] = 'Usuario SMTP';
$_lang['smtp_password_title'] = 'Contraseña SMTP';
$_lang['smtp_port_title'] = 'Puerto SMTP';

$_lang["setting_resource_tree_node_name"] = 'Mostrar el nombre en el árbol de recursos';
$_lang["setting_resource_tree_node_name_desc"] = 'Seleccione el campo de recurso para mostrarlo como el nombre del recurso en el árbol de recursos. La configuración predeterminada es "Título de página".';
$_lang["setting_resource_tree_node_name_desc_add"] = 'Nota: desde la version 1.1 de Evolution CMS puede cambiar este nombre para mostrar dentro de la opción de clasificación del árbol de recursos . Esta configuración se utiliza cuando el nombre para mostrar en el árbol de recursos está configurado como "predeterminada".';

$_lang["resource_opt_alvisibled"] = 'Utilizar el alias actual en la ruta de aliases';
$_lang["resource_opt_alvisibled_help"] = 'El alias de este recurso se insertará en la ruta de alias de URL amigable';
$_lang['resource_opt_is_published'] = 'Oublicado';

$_lang["enable_cache_title"] = 'Caché de recursos';
$_lang["disable_chunk_cache_title"] = 'Deshabilitar el caché de trozos (chunks)';
$_lang["disable_snippet_cache_title"] = 'Deshabilitar el caché de fragmentos (snippets)';
$_lang["disable_plugins_cache_title"] = 'Dehabilitar el caché de extensiónes (plugins)';
$_lang["disabled_at_login"] = 'Deshabilitado al iniciar sesión';

$_lang["cache_type_title"] = 'Tipo de caché de recursos';
$_lang["cache_type_1"] = 'Caché se basa solo en el ID de recurso (estándar)';
$_lang["cache_type_2"] = 'Caché se basa en los parámetros el ID de recurso y $_GET';
$_lang["seostrict_title"] = 'Usar URLs estrictas de SEO';
$_lang["seostrict_message"] = 'Refuerza el uso de URL estrictas para evitar contenido duplicado (si es necesario)';

$_lang["alias_listing_title"] = 'Usar el caché de AliasListing';
$_lang["alias_listing_message"] = '\'Usar el caché de AliasListing\' debe ser deshabilitdo si el sitio tiene una gran cantidad de recursos. Deshabilitado reduce el consumo de memoria cuando el sitio tiene una gran cantidad de recursos.';
$_lang["alias_listing_disabled"] = 'Deshabilitado';
$_lang["alias_listing_folders"] = 'Solo para las carpetas';
$_lang["alias_listing_enabled"] = 'Habilitado';

$_lang["settings_friendlyurls_alert"] = 'Es necesario cambiar el nombre del archivo \'ht.access\' en el directorio de instalación de EVO a \'.htaccess\' para usar la función de URL amigable.';
$_lang["settings_friendlyurls_alert2"] = 'Debido que EVO se instaló en el subdirectorio es necesario cambiar el contenido de ".htaccess".';

$_lang["user_street"] = 'Calle';
$_lang["user_city"] = 'Ciudad';
$_lang["user_other"] = 'Otro';

$_lang["mutate_settings.dynamic.php6"] = 'Enviar el correo de errores de Evolution CMS';
$_lang["mutate_settings.dynamic.php7"] = 'no notificar';
$_lang["mutate_settings.dynamic.php8"] = 'Se enviará un correo con el origen del error a [(emailsender)] ([+emailsender+]) si se produce un error de Evolution CMS. Los detalles del error se pueden ver en el registro de eventos de Evolution CMS.';

$_lang["error_no_privileges"] = "No tiene los privilegios suficientes para esta acción.";
$_lang["error_no_optimise_tablename"] = "¡No se encontró la tabla para optimizar en la solicitud!";
$_lang["error_no_truncate_tablename"] = "¡No se encontró la tabla para truncar en la solicitud!";
$_lang["error_double_action"] = "¡La acción (GET & POST) fue doblada!";
$_lang["error_no_id"] = "¡El ID no ha pasado en la solicitud!";
$_lang["error_id_nan"] = "¡El ID ha pasado en la solicitud es NaN!";
$_lang["error_parent_deleted"] = "¡Error porque fue eliminado el elemento principal del recurso!";
$_lang["error_no_parent"] = "¡No se pudo encontrar el nombre del recurso principal!";
$_lang["error_many_results"] = "¡Demasiados resultados devueltos de la base de datos!";
$_lang["error_no_results"] = "¡No hay suficientes/no se devuelven resultados de la base de datos!";
$_lang["error_no_user_selected"] = "¡Ningún usuario está seleccionado como destinatario de este mensaje!";
$_lang["error_no_group_selected"] = "¡Ningún grupo está seleccionado como destinatario de este mensaje!";
$_lang["error_movedocument1"] = "¡El recurso no puede ser su propio principal!";
$_lang["error_movedocument2"] = "¡No se ha pasado el ID del recurso en la solicitud!";
$_lang["error_movedocument3"] = "El principal nuevo no se envió en la solicitud!";
$_lang["error_internet_connection"] = "El servidor no está disponible. ¡Comprueba tu conexión a Internet!";

$_lang["login_processor_unknown_user"] = "¡Se ha introducido un nombre de usuario o una contraseña incorrectos!";
$_lang["login_processor_wrong_password"] = "¡Se ha introducido un nombre de usuario o una contraseña incorrectos!";
$_lang["login_processor_many_failed_logins"] = "¡Debido a demasiados inicios de sesión fallidos, ha sido bloqueado!";
$_lang["login_processor_verified"] = "¡Se requiere la verificación de usuario!";
$_lang["login_processor_blocked1"] = "¡Está usted bloqueado y no puede usted iniciar la sesión!";
$_lang["login_processor_blocked2"] = "¡Está usted bloqueado y no puede usted iniciar la sesión! Por favor, inténtelo de nuevo más tarde.";
$_lang["login_processor_blocked3"] = "¡Está usted bloqueado automáticamente después de una fecha específica y ya no puede usted iniciar la sesión!";
$_lang["login_processor_bad_code"] = "¡El código de seguridad que ingresó no se validó! Por favor, intente usted iniciar la sesión de nuevo.";
$_lang["login_processor_remotehost_ip"] = "¡El nombre de hospedador no apunta a su IP!";
$_lang["login_processor_remote_ip"] = "No se le permite iniciar sesión desde esta ubicación.";
$_lang["login_processor_date"] = "No tiene usted el permiso para iniciar sesión en este momento. Por favor, inténtelo de nuevo más tarde.";
$_lang["login_processor_captcha_config"] = "Captcha no está configurado correctamente.";

$_lang["dp_dayNames"] = "['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado']";
$_lang["dp_monthNames"] = "['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre']";
$_lang["dp_startDay"] = "1";

$_lang["check_all"] = "Seleccionar todo";
$_lang["check_none"] = "No seleccionar nada";
$_lang["check_toggle"] = "Invertir selección";

$_lang["version_notices"] = "Avisos de la versión";

$_lang["em_button_shift"] = " (Shift-Mouseclick para abrir las ventanas múltiples)";

$_lang["reset_sysfiles_checksum_button"] = "Reconstruir sumas de verificación";
$_lang["reset_sysfiles_checksum_alert"] = "¿Está seguro de que desea restablecer las sumas de verificación de los archivos del sistema?";

$_lang["file_browser_disabled_msg"] = "La función del explorador de archivos no está habilitada.";
$_lang["which_browser_default_title"] = "Explorador de archivos por el defecto";
$_lang["which_browser_default_msg"] = "Elija el explorador de archivos que prefiera como predeterminado. En la configuración de usuario  puede elegir un navegador personalizado por usuario o dejarlo en 'predeterminado'.";
$_lang["which_browser_title"] = "El explorador de archivos";
$_lang["which_browser_msg"] = "Puede elegir el explorador de archivos personalizado para este usuario. Para utilizar el navegador predeterminado del sistema, déjelo en 'Predeterminado'.";
$_lang["option_default"] = "Predeterminado";
$_lang["position"] = "Posición";
$_lang["are_you_sure"] = "¿Está usted seguro?";

$_lang['evo_downloads_title'] = "Las descargas de Evolution CMS";
$_lang['help_translating_title'] = "Ayudar traducir Evolution CMS";
$_lang['download'] = "Descargar";
$_lang['downloads'] = "Descargas";
$_lang["previous_releases"] = "Lanzamientos anteriores";
$_lang["extras"] = "Extras";

$_lang["display_locks"] = "Mostrar los bloqueos";
$_lang["role_display_locks"] = "Mostrarlos bloqueos";
$_lang["session_timeout"] = "Hora de término de la sesión";
$_lang["session_timeout_msg"] = "Evolution CMS hará ping al servidor y si el último ping supera esta configuración la sesión asociada se considerará no válida y todos los bloqueos relacionados se eliminarán automáticamente. Establezca el valor en minutos (> 2 min, predeterminado 15 min).";
$_lang["unlock_element_id_warning"] = "¿Está seguro que quiere desbloquear este [+element_type+] (ID [+id+])?";
$_lang["lock_element_type_1"] = "Plantilla";
$_lang["lock_element_type_2"] = "Variable de plantilla (TV)";
$_lang["lock_element_type_3"] = "Trozo (chunk)";
$_lang["lock_element_type_4"] = "Fragmento (snippet)";
$_lang["lock_element_type_5"] = "Extensión (plugin)";
$_lang["lock_element_type_6"] = "Módulo";
$_lang["lock_element_type_7"] = "Recurso";
$_lang["lock_element_type_8"] = "Rol";
$_lang["lock_element_editing"] = "Está editando este [+element_type+] desde [+lasthit_df+]";
$_lang["lock_element_locked_by"] = "Este [+element_type+] está bloqueado por el usuario [+username+] desde [+lasthit_df+]";

$_lang["minifyphp_incache_title"] = 'Minimizar el código PHP en el caché de sitio';
$_lang["minifyphp_incache_message"] = 'Minimizar el código PHP (los snippets and los plugins) y guárdelo en el archivo de caché del sitio, ref: <a href="https://github.com/modxcms/evolution/issues/938" target="_blank">#938</a>';

$_lang["logout_reminder_msg"] = "Recordatorio: parece que en el [+fecha+] olvido usted cerrar la sesión. Preste atención en el futuro para hacerlo después de que termine su trabajo.";

$_lang["allow_eval_title"] = "Evaluar código PHP en la llamada de fragmento (snippet)";
$_lang["allow_eval_msg"] = "Para el desorallador: por favor usa evo()->safeEval()";
$_lang["allow_eval_with_scan"] = "Ejecutar solo las funciones permitidas";
$_lang["allow_eval_with_scan_at_post"] = "Ejecutar todos. Sin embargo, en POST solo funciones permitidas";
$_lang["allow_eval_everytime_eval"] = "Sin limites (usar solo para depuración)";
$_lang["allow_eval_dont_eval"] = "Todas las funciones son prohibidas";

$_lang["safe_functions_at_eval_title"] = "Funciones permitidas para ejecutar";
$_lang["safe_functions_at_eval_msg"] = "Lista separada por comas";

$_lang["multiple_sessions_msg"] = "Información: las sesiones activas múltiples de usuario (total [+total+]) encontradas para el usuario [+username+].";
$_lang["iconv_not_available"] = "Es importante instalar/habilitar la extensión 'iconv'. Pida usted a su host si no sabe cómo habilitarlo.";

$_lang["cm_create_new_category"] = "Crear la categoría nueva";
$_lang["cm_category_name"] = "Nombre de categoría";
$_lang["cm_category_position"] = "Posición de categoría";
$_lang["cm_no_x_assigned"] = "No %s está assignado";
$_lang["cm_save_categorization"] = "Guardar la categorización";
$_lang["cm_update_categories"] = "Actualizar las categorías";
$_lang["cm_assigned_elements"] = "Elementos asignados";
$_lang["cm_edit_name"] = "Editar el nombre";
$_lang["cm_mark_for_deletion"] = "Marcar para borrar";
$_lang["cm_delete_now"] = "Borrar inmediatamente";
$_lang["cm_delete_element_x_now"] = "Eliminar \"%s\" inmediatamente";
$_lang["cm_select_element_group"] = "Seleccionar el grupo de elementos";
$_lang["cm_global_messages"] = "Messages globales";
$_lang["cm_add_new_category"] = "Agregar una categoría nueva";
$_lang["cm_edit_categories"] = "Editar las categorias";
$_lang["cm_sort_categories"] = "Ordenar las categorías";
$_lang["cm_categorize_elements"] = "Categorizar los elementos";
$_lang["cm_translation"] = "Traducción";
$_lang["cm_translations"] = "Traducciones";
$_lang["cm_categorize_x"] = "Categorizar <span class=\"highlight\">%s</span>";
$_lang["cm_unknown_error"] = "Algo salió mal.";
$_lang["cm_x_assigned_to_category_y"] = "<span class=\"highlight\">%s(%s)</span> fue asignado a la categoría <span class=\"highlight\">%s(%s)</span>";
$_lang["cm_no_categorization"] = "No se ha realizado ninguna categorización.";
$_lang["cm_no_changes"] = "No hay nada que cambiar, por lo que no se realizaron cambios.";
$_lang["cm_x_changes_made"] = "<span class=\"highlight\">%s</span> cambios realizados";
$_lang["cm_enter_name_for_category"] = "Por favor ingrese un nombre para la categoría nueva.";
$_lang["cm_category_x_exists"] = "La categoriá <span class=\"highlight\">%s</span> existe ya.";
$_lang["cm_category_x_saved_at_position_y"] = "La categoría nueva <span class=\"highlight\">%s</span> fue guardada el la posición <span class=\"highlight\">%s</span>.";
$_lang["cm_category_x_moved_to_position_y"] = "La categoría <span class=\"highlight\">%s</span> fue movida a la posición <span class=\"highlight\">%s</span>";
$_lang["cm_category_x_deleted"] = "La categoría <span class=\"highlight\">%s</span> fue eliminada";
$_lang["cm_category_x_renamed_to_y"] = "La categoría <span class=\"highlight\">%s</span> fue renombrada a <span class=\"highlight\">%s</span>";
$_lang["cm_translation_for_x_empty"] = "La traducción de <span class=\"highlight\">%s</span> estaba vacío";
$_lang["cm_translation_for_x_to_y_success"] = "La traducción para <span class=\"highlight\">%s</span> a <span class=\"highlight\">%s</span> fue guardada con éxito";
$_lang["cm_save_new_sorting"] = "Guardar el orden nuevo";
$_lang["cm_translate_phrases"] = "Traducir las frases";
$_lang["cm_translate_module_phrases"] = "Traducir las frases de módulo";
$_lang["cm_native_phrase"] = "Frase nativo";

$_lang["btn_view_options"] = 'Ver las opciones';
$_lang["view_options_msg"] = 'La visualización y la lista de elementos se pueden personalizar a través del botón \'Ver las opciones\'. Las configuraciones se guardan y restauran por navegador utilizando el almacenamiento local de HTML5.';
$_lang["viewopts_title"] = 'Ver las opciones';
$_lang["viewopts_cb_buttons"] = 'Botónes';
$_lang["viewopts_cb_descriptions"] = 'Descripciónes';
$_lang["viewopts_cb_icons"] = 'Íconos';
$_lang["viewopts_radio_list"] = 'Lista';
$_lang["viewopts_radio_inline"] = 'En línea';
$_lang["viewopts_radio_flex"] = 'Flexionar';
$_lang["viewopts_fontsize"] = 'Tamaño de letras';
$_lang["viewopts_cb_alltabs"] = 'Todas las pestañas';

$_lang['email_sender_method'] = 'El remitente de mensaje.';
$_lang['auto'] = 'Detectar automáticamente';
$_lang['use_emailsender'] = 'Usar el valor de [(emailsender)]';
$_lang['email_sender_method_message'] = 'El remitente de mensaje. Por lo general, el receptor lo convertirá en un encabezado Return-Path, y es la dirección a la que se enviarán los rebotes. La detección automática funcionará en la mayoría de los casos.';

$_lang['login_form_position_title'] = 'Posición de formulario de inicio de sesión';
$_lang['login_form_position_left'] = 'izquierda';
$_lang['login_form_position_center'] = 'centro';
$_lang['login_form_position_right'] = 'derecha';
$_lang["login_form_style"] = 'Estilo de formulario de inicio de sesión:';
$_lang["login_form_style_dark"] = 'oscuro';
$_lang["login_form_style_light"] = 'claro';
$_lang['login_logo_title'] = 'Imagen de logo de la página de inicio ';
$_lang['login_logo_message'] = 'El ancho recomendado de la imagen: 360px y de tipo PNG';
$_lang['login_bg_title'] = 'La imagen de fondo de la página de inicio de sesión';
$_lang['login_bg_message'] = 'El ancho recomendado de la imagen de fondo de la página de inicio de sesión: 1920px';

$_lang['manager_menu_position_title'] = 'Posición del menú principal';
$_lang['manager_menu_position_top'] = 'parte superior';
$_lang['manager_menu_position_left'] = 'izquierda';

$_lang['invalid_event_response'] = 'El evento %s tiene una salida no válida';

$_lang['chunk_processor'] = 'Clase de procesamiento de Chunks';

$_lang["permission_title"] = 'Crear/editar el permiso';
$_lang["groups_permission_title"] = 'Crear/editar la categoría';
$_lang["lang_key_desc"] = 'La clave de idioma de la matriz $_lang';
$_lang["key_desc"] = 'La clave del permiso selectado';

$_lang["role_no_tv"] = 'Aún no se han variables asignados para este rol.';
$_lang["role_notassigned_tv"] = 'Estas variables están disponibles para la asignación.';
$_lang["role_tv_msg"] = 'Las variables asignadas a este rol se enumeran a continuación.';
$_lang["tmplvar_roles_access_msg"] = 'Seleccione los roles que pueden acceder/procesar esta variable de plantilla (TV)';

$_lang["setting_from_file"] = '<strong class="text-danger">El valor del parámetro se define en core/custom/confic/cms/settings</strong>';
$_lang['disable'] = 'Deshabilitar';
$_lang['enable'] = 'Habilitar';

return $_lang;
