/*----------------------------------------------------------------------------\
|                               Tab Pane 1.02                                 |
|-----------------------------------------------------------------------------|
|                         Created by Erik Arvidsson                           |
|                  (http://webfx.eae.net/contact.html#erik)                   |
|                      For WebFX (http://webfx.eae.net/)                      |
|-----------------------------------------------------------------------------|
|                  Copyright (c) 1998 - 2003 Erik Arvidsson                   |
|-----------------------------------------------------------------------------|
| This software is provided "as is", without warranty of any kind, express or |
| implied, including  but not limited  to the warranties of  merchantability, |
| fitness for a particular purpose and noninfringement. In no event shall the |
| authors or  copyright  holders be  liable for any claim,  damages or  other |
| liability, whether  in an  action of  contract, tort  or otherwise, arising |
| from,  out of  or in  connection with  the software or  the  use  or  other |
| dealings in the software.                                                   |
| - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - |
| This  software is  available under the  three different licenses  mentioned |
| below.  To use this software you must chose, and qualify, for one of those. |
| - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - |
| The WebFX Non-Commercial License          http://webfx.eae.net/license.html |
| Permits  anyone the right to use the  software in a  non-commercial context |
| free of charge.                                                             |
| - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - |
| The WebFX Commercial license           http://webfx.eae.net/commercial.html |
| Permits the  license holder the right to use  the software in a  commercial |
| context. Such license must be specifically obtained, however it's valid for |
| any number of  implementations of the licensed software.                    |
| - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - |
| GPL - The GNU General Public License    http://www.gnu.org/licenses/gpl.txt |
| Permits anyone the right to use and modify the software without limitations |
| as long as proper  credits are given  and the original  and modified source |
| code are included. Requires  that the final product, software derivate from |
| the original  source or any  software  utilizing a GPL  component, such  as |
| this, is also licensed under the GPL license.                               |
|-----------------------------------------------------------------------------|
| 2002-01-?? | First working version                                          |
| 2002-02-17 | Cleaned up for 1.0 public version                              |
| 2003-02-18 | Changed from javascript uri for anchors to return false        |
| 2003-03-03 | Added dispose methods to release IE memory                     |
|-----------------------------------------------------------------------------|
| Dependencies: *.css           a css file to define the layout               |
|-----------------------------------------------------------------------------|
| Created 2002-01-?? | All changes are in the log above. | Updated 2003-03-03 |
\----------------------------------------------------------------------------*/

// This function is used to define if the browser supports the needed
// features
function hasSupport()
{
  if (typeof hasSupport.support !== 'undefined') {
    return hasSupport.support;
  }
  hasSupport.support = (typeof document.implementation !== 'undefined' && document.implementation.hasFeature('html', '1.0'));

  return hasSupport.support;
}

///////////////////////////////////////////////////////////////////////////////////
// The constructor for tab panes
//
// el : HTMLElement		The html element used to represent the tab pane
// bUseCookie : Boolean	Optional. Default is true. Used to determine whether to us
//						persistance using cookies or not
//
function WebFXTabPane(el, bUseCookie)
{
  if (!hasSupport() || el == null) return;

  this.element = el;
  this.element.tabPane = this;
  this.pages = [];
  this.selectedIndex = null;
  this.useCookie = bUseCookie != null ? bUseCookie : true;

  // add class name tag to class name
  this.element.className = this.classNameTag + ' ' + this.element.className;

  // add tab row
  this.tabRow = document.createElement('div');
  this.tabRow.className = 'tab-row';
  el.insertBefore(this.tabRow, el.firstChild);

  var tabIndex = 0;
  if (this.useCookie) {
    tabIndex = Number(this.getCookie('webfxtab_' + this.element.id));
    if (isNaN(tabIndex)) {
      tabIndex = 0;
    }
  }
  this.selectedIndex = tabIndex;

  // loop through child nodes and add them
  var cs = el.childNodes;
  var n;
  for (var i = 0; i < cs.length; i++) {
    if (cs[i].nodeType === 1 && cs[i].className === 'tab-page') {
      this.addTabPage(cs[i]);
    }
  }
}

WebFXTabPane.prototype = {
  classNameTag: 'dynamic-tab-pane-control',
  setSelectedTab: function(id) {
    var found = null;
    for (const [index, page] of this.pages.entries()) {
      if(page.element.id === id) {
        found = index;
        break;
      }
    }
    if(found !== null) {
      this.setSelectedIndex(found);
    } else {
    }
  },
  setSelectedIndex: function(n) {
    if (this.selectedIndex !== n) {
      if (this.selectedIndex != null && this.pages[this.selectedIndex] != null) {
        this.pages[this.selectedIndex].hide();
      }
      this.selectedIndex = n;
      this.pages[this.selectedIndex].show();

      if (this.useCookie) {
        this.setCookie('webfxtab_' + this.element.id, n);
      }	// session cookie
    }
  },
  getSelectedIndex: function() {
    return this.selectedIndex;
  },
  addTabPage: function(oElement, callBackFnc) { // modifed by Raymond
    if (!hasSupport()) return;

    if (typeof oElement.tabPage === this)	// already added
    {
      return oElement.tabPage;
    }

    var n = this.pages.length;
    var tp = this.pages[n] = new WebFXTabPage(oElement, this, n, callBackFnc); // modified by Raymond
    tp.tabPane = this;

    // move the tab out of the box
    this.tabRow.appendChild(tp.tab);

    if (n === this.selectedIndex) {
      tp.show();
    } else {
      tp.hide();
    }

    return tp;
  },
  dispose: function() {
    this.element.tabPane = null;
    this.element = null;
    this.tabRow = null;

    for (var i = 0; i < this.pages.length; i++) {
      this.pages[i].dispose();
      this.pages[i] = null;
    }
    this.pages = null;
  },
  setCookie: function(sName, sValue, nDays) {
    var expires = '';
    if (nDays) {
      var d = new Date();
      d.setTime(d.getTime() + nDays * 24 * 60 * 60 * 1000);
      expires = '; expires=' + d.toUTCString();
    }

    document.cookie = sName + '=' + sValue + expires + '; path=/';
  },
  getCookie: function(sName) {
    var re = new RegExp('(\;|^)[^;]*(' + sName + ')\=([^;]*)(;|$)');
    var res = re.exec(document.cookie);
    return res != null ? res[3] : null;
  },
  removeCookie: function(name) {
    this.setCookie(name, '', -1);
  }
};

///////////////////////////////////////////////////////////////////////////////////
// The constructor for tab pages. This one should not be used.
// Use WebFXTabPage.addTabPage instead
//
// el : HTMLElement			The html element used to represent the tab pane
// tabPane : WebFXTabPane	The parent tab pane
// nindex :	Number			The index of the page in the parent pane page array
//
function WebFXTabPage(el, tabPane, nIndex, callBackFnc)
{
  if (!hasSupport() || el == null) return;

  this.element = el;
  this.element.tabPage = this;
  this.callBack = callBackFnc;
  this.index = nIndex;

  var cs = el.childNodes;
  for (var i = 0; i < cs.length; i++) {
    if (cs[i].nodeType === 1 && cs[i].className === 'tab') {
      this.tab = cs[i];
      break;
    }
  }

  // insert a tag around content to support keyboard navigation

  var a = document.createElement('SPAN');
  this.aElement = a;
  a.onclick = function() { return false; };
  while (this.tab.hasChildNodes()) {
    a.appendChild(this.tab.firstChild);
  }
  this.tab.dataset.target = '#' + this.element.id;
  this.tab.appendChild(a);

  // hook up events, using DOM0
  var oThis = this;
  this.tab.onclick = function() {
    if (oThis.aElement.firstElementChild && oThis.aElement.firstElementChild.tagName === 'A') {
      document.location.href = oThis.aElement.firstElementChild.href
    } else {
      return oThis.select();
    }
  };
  this.tab.onmouseover = function() { oThis.tabOver(oThis); };
  this.tab.onmouseout = function() { oThis.tabOut(oThis); };
}

WebFXTabPage.prototype = {
  show: function() {
    var el = this.tab;
    var s = el.className + ' selected';
    s = s.replace(/ +/g, ' ');
    el.className = s;

    this.element.style.display = 'block';
  },
  hide: function() {
    var el = this.tab;
    var s = el.className;
    s = s.replace(/ selected/g, '');
    el.className = s;

    this.element.style.display = 'none';
  },
  dispose: function() {
    this.aElement.onclick = null;
    this.aElement = null;
    this.element.tabPage = null;
    this.tab.onclick = null;
    this.tab.onmouseover = null;
    this.tab.onmouseout = null;
    this.tab = null;
    this.tabPane = null;
    this.element = null;
  },
  select: function() {
    this.tabPane.setSelectedIndex(this.index);
    if (this.callBack) this.callBack();
    return false;
  },
  tabOver: function(tabpage) {
    var el = tabpage.tab;
    var s = el.className + ' hover';
    s = s.replace(/ +/g, ' ');
    el.className = s;
  },
  tabOut: function(tabpage) {
    var el = tabpage.tab;
    var s = el.className;
    s = s.replace(/ hover/g, '');
    el.className = s;
  }
};

// This function initializes all uninitialized tab panes and tab pages
function setupAllTabs()
{
  if (!hasSupport()) return;

  var all = document.getElementsByTagName('*');
  var l = all.length;
  var tabPaneRe = /tab\-pane/;
  var tabPageRe = /tab\-page/;
  var cn, el;
  var parentTabPane;

  for (var i = 0; i < l; i++) {
    el = all[i];
    cn = el.className;

    // no className
    if (cn === '') continue;

    // uninitiated tab pane
    if (tabPaneRe.test(cn) && !el.tabPane) {
      new WebFXTabPane(el);
    }// unitiated tab page wit a valid tab pane parent
    else if (tabPageRe.test(cn) && !el.tabPage &&
        tabPaneRe.test(el.parentNode.className)) {
      el.parentNode.tabPane.addTabPage(el);
    }
  }
}

function disposeAllTabs()
{
  if (!hasSupport()) return;

  var all = document.getElementsByTagName('*');
  var l = all.length;
  var tabPaneRe = /tab\-pane/;
  var cn, el;
  var tabPanes = [];

  for (var i = 0; i < l; i++) {
    el = all[i];
    cn = el.className;

    // no className
    if (cn === '') continue;

    // tab pane
    if (tabPaneRe.test(cn) && el.tabPane) {
      tabPanes[tabPanes.length] = el.tabPane;
    }
  }

  for (var i = tabPanes.length - 1; i >= 0; i--) {
    tabPanes[i].dispose();
    tabPanes[i] = null;
  }
}

// initialization hook up

// DOM2
if (typeof window.addEventListener !== 'undefined') {
  window.addEventListener('load', setupAllTabs, false);
}// IE
else if (typeof window.attachEvent !== 'undefined') {
  window.attachEvent('onload', setupAllTabs);
  window.attachEvent('onunload', disposeAllTabs);
}

else {
  if (window.onload != null) {
    var oldOnload = window.onload;
    window.onload = function(e) {
      oldOnload(e);
      setupAllTabs();
    };
  } else {
    window.onload = setupAllTabs;
  }
}
