<?php
/**
 * EVO Manager language file
 *
 * @version 1.0.15
 * @date 2014/02/24
 * @author The EVO Project Team
 *
 * @language German
 * @package modx
 * @subpackage manager
 *
 * Please commit your language changes on Transifex (https://www.transifex.com/projects/p/modx-evolution/) or on GitHub (https://github.com/modxcms/evolution).
 */
//$modx_textdir = 'rtl'; // uncomment this line for RTL languages
$modx_lang_attribute = 'de'; // Manager HTML/XML Language Attribute see http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'UTF-8';

$_lang["about_msg"] = 'EVO ist ein <a href="http://evo.im/" target="_blank">PHP Application Framework und Content Management System</a> lizensiert unter der <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'Über Evolution';
$_lang["access_permission_denied"] = 'Sie haben nicht die notwendige Zugriffsberechtigung für diese Ressource.';
$_lang["access_permission_parent_denied"] = 'Sie haben nicht die notwendige Zugriffsberechtigung, um eine Ressource an dieser Stelle zu erstellen oder hierher zu verschieben.';
$_lang["access_permissions"] = 'Zugriffsberechtigung';
$_lang["access_permissions_add_resource_group"] = 'Eine neue Ressourcen-Gruppe erstellen';
$_lang["access_permissions_add_user_group"] = 'Eine neue Benutzergruppe erstellen';
$_lang["access_permissions_docs_collision"] = 'Durch einen Konflikt zwischen Web-Benutzergruppen und Manager-Benutzergruppen für diese Rolle, ist diese Ressource öffentlich zugänglich. Kontaktieren Sie Ihren Seiten-Administrator für weitere Hilfe.';
$_lang["access_permissions_docs_message"] = 'Wählen Sie aus welchen Ressourcen-Gruppe diese Ressource zugeordnet ist';
$_lang["access_permissions_group_link"] = 'Einen neuen Gruppen-Link erstellen';
$_lang["access_permissions_introtext"] = 'Hier können Sie Benutzer- und Ressourcen-Gruppen für die Zugriffsberechtigung bearbeiten. Um einen Benutzer einer Benutzergruppe zuzuordnen, bearbeiten Sie den Benutzer und wählen die zugehörige(n) Gruppe(n). Um eine Ressource einer Benutzergruppe zuzuordnen, bearbeiten Sie die Ressource und wählen die zugehörige(n) Gruppe(n).';
$_lang["access_permissions_link_to_group"] = 'zur Ressourcen-Gruppe';
$_lang["access_permissions_link_user_group"] = 'Benutzergruppe verlinken';
$_lang["access_permissions_links"] = 'Benutzer- / Ressourcen-Gruppen-Links';
$_lang["access_permissions_links_tab"] = 'Hier legen Sie fest welche Benutzergruppen auf die Ressourcen-Gruppen Zugriffsrechte haben (z.B. Ressourcen bearbeiten oder anlegen). Um eine Ressourcen-Gruppe mit einer Benutzergruppe zu verknüpfen, wählen Sie die entsprechende Gruppe aus dem Dropdown-Menü und klicken anschließend auf „Absenden“. Um einen Link für eine bestimmte Gruppe zu entfernen, klicken Sie auf „Entfernen“. Die Verknüpfung wird sofort gelöscht.';
$_lang["access_permissions_no_resources_in_group"] = 'Keine.';
$_lang["access_permissions_no_users_in_group"] = 'Keine.';
$_lang["access_permissions_off"] = '<span class="warning">Zugriffsberechtigungen wurden nicht aktiviert.</span> Sämtliche Einstellungen, die Sie hier vornehmen bleiben wirkungslos, bis die Zugriffsberechtigungen wieder aktiviert werden.';
$_lang["access_permissions_resource_groups"] = 'Ressourcen-Gruppen';
$_lang["access_permissions_resources_in_group"] = '<b>Ressourcen in Gruppe:</b> ';
$_lang["access_permissions_resources_tab"] = 'Hier sehen Sie die angelegten Ressourcen-Gruppen. Sie können auch neue Gruppen anlegen, Gruppen umbenennen, Gruppen löschen und sehen welche Ressourcen in den unterschiedlichen Gruppen enthalten sind (den Namen der Ressource sehen Sie, in dem Sie mit der Maus über die ID fahren). Um eine Ressource zu einer Gruppe hinzuzufügen oder von einer Gruppe zu entfernen, ändern Sie die entsprechende Ressource direkt.';
$_lang["access_permissions_user_groups"] = 'Benutzergruppen';
$_lang["access_permissions_user_message"] = 'Hier können Sie auswählen welcher Benutzergruppe dieser Benutzer zugeordnet ist:';
$_lang["access_permissions_users_in_group"] = 'Benutzer in Gruppe:';
$_lang["access_permissions_users_tab"] = 'Hier sehen Sie die angelegten Benutzergruppen. Sie können auch neue Gruppen anlegen, Gruppen umbenennen, Gruppen löschen und die Zugehörigkeit der Benutzer zu Gruppen sehen. Um ein Benutzer zu einer Gruppe hinzuzufügen oder zu entfernen, bearbeiten Sie direkt den entsprechenden Benutzer. Administratoren (Benutzer mit der Rollen ID 1) haben immer Zugriff auf alle Ressourcen und müssen keiner speziellen Gruppen angehören.';
$_lang["account_email"] = 'E-Mail-Adresse';
$_lang["actioncomplete"] = '<b>Die Aktion wurde erfolgreich durchgeführt!</b><br /> - Bitte warten Sie während EVO aufräumt.';
$_lang["activity_message"] = 'Diese Liste zeigt alle Ressourcen, die zuletzt bearbeitet oder erstellt wurden:';
$_lang["activity_title"] = 'Kürzlich bearbeitete oder erstellte Ressourcen';
$_lang["add"] = 'Hinzufügen';
$_lang["add_chunk"] = 'Chunk hinzufügen';
$_lang["add_doc"] = 'Ressource hinzufügen';
$_lang["add_folder"] = 'Ordner hinzufügen';
$_lang["add_plugin"] = 'Plugin hinzufügen';
$_lang["add_resource"] = 'Ressource hinzufügen';
$_lang["add_snippet"] = 'Snippet hinzufügen';
$_lang["add_tag"] = 'Tag hinzufügen';
$_lang["add_template"] = 'Template hinzufügen';
$_lang["add_tv"] = 'Template-Variable hinzufügen';
$_lang["add_weblink"] = 'Web-Link hinzufügen';
$_lang["administrator_role_message"] = 'Diese Rolle kann nicht gelöscht oder bearbeitet werden.';
$_lang["administrators"] = 'Administratoren';
$_lang["after_saving"] = 'Nach dem Speichern';
$_lang["alert_delete_self"] = 'Sie können sich nicht selber löschen!';
$_lang["alias"] = 'Alias';
$_lang["all_doc_groups"] = 'Alle Ressourcen-Gruppen (öffentlich)';
$_lang["all_events"] = 'Alle Ereignisse';
$_lang["all_usr_groups"] = 'Alle Benutzergruppen (öffentlich)';
$_lang["allow_mgr_access"] = 'Manager-Zugriff';
$_lang["allow_mgr_access_message"] = 'Wählen Sie diese Option, um den Zugriff auf den Manager aktivieren oder zu deaktivieren. <b>Hinweis:</b> Wenn diese Option gesetzt ist, wird der Benutzer zur Manager-Anmeldung oder auf die Startseite weitergeleitet.';
$_lang["already_deleted"] = 'wurde schon gelöscht.';
$_lang["attachment"] = 'Anhang';
$_lang["author_infos"] = 'Autor(en)';
$_lang["automatic_alias_message"] = 'Wählen Sie „ja“, damit das System beim Sichern automatisch einen eindeutigen Alias basierend auf den Seitentitel der Ressource vergibt.';
$_lang["automatic_alias_title"] = 'Automatisch erstellter Alias';
$_lang["backup"] = 'Backup';
$_lang["bk_manager"] = 'Backup';
$_lang["block_message"] = 'Dieser Benutzer wird gesperrt sein, nachdem Sie die Benutzerdaten gespeichert haben!';
$_lang["blocked_minutes_message"] = 'Hier können Sie einstellen, wie viele Minuten ein Benutzer gesperrt wird, wenn er die maximale Anzahl von fehlgeschlagenen Anmeldeversuchen erreicht hat. Bitte geben Sie nur Zahlen ein, keine Kommas oder Leerstellen.';
$_lang["blocked_minutes_title"] = 'Sperrzeit in Minuten';
$_lang["cache_files_deleted"] = 'Die folgenden Dateien wurden gelöscht:';
$_lang["cancel"] = 'Abbrechen';
$_lang["captcha_code"] = 'Sicherheits-Code';
$_lang["captcha_message"] = 'Aktivieren Sie Captcha-Validierung, um die Sicherheit zu erhöhen.';
$_lang["captcha_title"] = 'Captcha aktivieren';
$_lang["captcha_words_default"] = 'EVO,Access,Better,BitCode,Chunk,Cache,Desc,Design,Excell,Enjoy,URLs,TechView,Gerald,Griff,Humphrey,Holiday,Intel,Integration,Joystick,Join(),Oscope,Genetic,Light,Likeness,Marit,Maaike,Niche,Netherlands,Ordinance,Oscillo,Parser,Phusion,Query,Question,Regalia,Righteous,Snippet,Sentinel,Template,Thespian,Unity,Enterprise,Verily,Tattoo,Veri,Website,WideWeb,Yap,Yellow,Zebra,Zygote';
$_lang["captcha_words_message"] = 'Wenn Captcha aktiviert ist können Sie eine Liste von Captcha-Wörter eingeben. Trennen Sie die Wörter mit Kommas. Das Eingabe Feld ist mit 255 Zeichen beschränkt.';
$_lang["captcha_words_title"] = 'Captcha-Wörter';
$_lang["category_heading"] = 'Kategorie';
$_lang["category_manager"] = 'Kategorie-Manager';
$_lang["category_management"] = 'Kategorie-Verwaltung';
$_lang["manage_categories"] = 'Kategorien verwalten';
$_lang["category_msg"] = 'Hier können Sie alle Elemente nach Kategorien sortiert bearbeiten.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Name ändern';
$_lang["change_password"] = 'Passwort ändern';
$_lang["change_password_confirm"] = 'Passwort bestätigen';
$_lang["change_password_message"] = 'Bitte geben Sie Ihr neues Passwort ein, und wiederholen Sie es zur Sicherheit. Das Passwort muss mindestens 6 Zeichen beinhalten.';
$_lang["change_password_new"] = 'Neues Passwort';
$_lang["charset_message"] = 'Wählen Sie die Zeichenkodierung für die [(modx_charset)]-Systemvariable. Diese Einstellung beeinflusst nicht den Manager.';
$_lang["charset_title"] = 'Zeichenkodierung';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Chunk-Code (HTML)';
$_lang["chunk_multiple_id"] = 'Fehler: Mehrere Chunks benutzen die selbe ID.';
$_lang["chunk_no_exist"] = 'Chunk existiert nicht.';
$_lang["cleaningup"] = 'Aufräumen';
$_lang["clean_uploaded_filename"] = 'Benutzen Sie Transliteration in Datei Uploads';
$_lang["clean_uploaded_filename_message"] = 'Benutzen Sie die Standard- oder Aliaseinstellungen um Umlaute und Sonderzeichen aus dem Dateinamen zu entfernen. Entfernen Sie nicht die Dateiendung!';
$_lang["clear_log"] = 'Protokoll löschen';
$_lang["click_to_context"] = 'Klicken Sie hier, für das Kontextmenü';
$_lang["click_to_edit_title"] = 'Klicken Sie hier, um den Eintrag zu bearbeiten';
$_lang["click_to_view_details"] = 'Klicken Sie hier, um die Details anzuzeigen';
$_lang["close"] = 'Schließen';
$_lang["code"] = 'Code';
$_lang["collapse_tree"] = 'Baum einklappen';
$_lang["comment"] = 'Kommentar';
$_lang["configcheck_admin"] = 'Bitte kontaktieren Sie einen Systemadministrator und informieren Sie Ihn über diese Nachricht!';
$_lang["configcheck_cache"] = 'Das Cache-Verzeichnis ist nicht beschreibbar';
$_lang["configcheck_cache_msg"] = 'EVO kann das Cache-Verzeichnis nicht beschreiben. EVO wird weiterhin wie erwartet funktionieren, jedoch wird die Cache-Funktion nicht genutzt. Um dieses Problem zu lösen, müssen Sie die Schreibrechte des Verzeichnisses /_cache/ entsprechend anpassen.';
$_lang["configcheck_configinc"] = 'Die Konfigurationsdatei ist weiterhin beschreibbar';
$_lang["configcheck_configinc_msg"] = 'Böswillige Menschen könnten möglicherweise verheerende Schäden an Ihrer Website und allem was damit verbunden ist anrichten. <b>Wichtig:</b> Bitte ändern Sie die Zugriffsrechte der Konfigurationsdatei (/[+MGR_DIR+]/includes/config.inc.php) auf nur-lesen!';
$_lang["configcheck_default_msg"] = 'Eine nicht weiter spezifizierte Warnung ist aufgetreten.';
$_lang["configcheck_errorpage_unavailable"] = 'Die Fehlerseite Ihres Webauftrittes ist nicht verfügbar.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Ihre Fehlerseite ist für normale Besucher nicht abrufbar oder existiert nicht. Dies kann zu einer Endlosschleife und vielen Fehlermeldungen in Ihren Webserver-Statistiken führen. Stellen Sie sicher, dass der Seite keine Benutzergruppen zugeordnet sind.';
$_lang["configcheck_errorpage_unpublished"] = 'Die Fehlerseite Ihres Webauftrittes wurde nicht veröffentlicht oder noch nicht erstellt.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Ihre Fehlerseite ist der Allgemeinheit nicht zugänglich. Veröffentlichen Sie die Seite oder stellen Sie sicher, dass in der Konfiguration eine vorhandene Seite aus dem Ressourcen-Baum ausgewählt ist.';
$_lang["configcheck_filemanager_path"] = 'Der aktuelle <a href="index.php?a=17&tab=5">Datei-Manager Pfad</a> scheint nicht korrekt zu sein.';
$_lang["configcheck_filemanager_path_msg"] = 'Dies kann beispielsweise der Fall sein, wenn Sie Ihre Installation in ein anderes Verzeichnis oder auf einen anderen Server umgezogen haben. Bitte prüfen und speichern Sie die System-Konfiguration erneut.';
$_lang["configcheck_hide_warning"] = '<a href="javascript:hideConfigCheckWarning(\'%s\');"><em>Nicht mehr anzeigen.</em></a>';
$_lang["configcheck_images"] = 'Das Bilderverzeichnis ist nicht beschreibbar';
$_lang["configcheck_images_msg"] = 'Das Verzeichnis „images“ ist nicht beschreibbar. Die Funktionen des Bilder-Managers im Editor werden nicht funktionieren!';
$_lang["configcheck_installer"] = 'Installationsverzeichnis ist noch vorhanden';
$_lang["configcheck_installer_msg"] = 'Das Verzeichnis /install beinhaltet die Installationroutine für EVO. Stellen Sie sich nur vor was passieren kann, wenn jemand dieses Verzeichnis ausfindig macht und die Routine startet. Wahrscheinlich würde diese Person nicht allzu weit kommen da sie die Zugangsdaten zur Datenbank eingeben muss. Trotz alledem ist es am sinnvollsten, dieses Verzeichnis zu entfernen.';
$_lang["configcheck_lang_difference"] = 'Die Sprachdatei enthält eine falsche Anzahl an Einträgen';
$_lang["configcheck_lang_difference_msg"] = 'Die zur Zeit ausgewählte Sprache (Deutsch) enthält nicht die gleiche Anzahl an Einträgen wie die Standardsprache (Englisch). Dies stellt kein Problem für die Arbeit mit MODX dar, bedeutet jedoch, dass Sie die Sprachdatei aktualisieren sollten.';
$_lang["configcheck_notok"] = 'Eine oder mehrere Optionen der Konfiguration sind nicht in Ordnung: ';
$_lang["configcheck_ok"] = 'Überprüfung bestanden – keine Warnungen vorhanden.';
$_lang["configcheck_php_gdzip"] = 'PHP-Erweiterungen GD und/oder ZIP wurden nicht gefunden';
$_lang["configcheck_php_gdzip_msg"] = 'EVO benötigt die PHP-Erweiterungen GD und ZIP. Auch wenn EVO auch ohne diese funktioniert, werden Sie ansonsten nicht alle  Dateimanager-, Bildeditor- oder Captcha-Funktionen nutzen können.';
$_lang["configcheck_rb_base_dir"] = 'Der aktuelle <a href="index.php?a=17&tab=6">Dateibasis-Pfad</a> scheint nicht korrekt zu sein.';
$_lang["configcheck_rb_base_dir_msg"] = 'Dies kann beispielsweise der Fall sein, wenn Sie Ihre Installation in ein anderes Verzeichnis oder auf einen anderen Server umgezogen haben. Bitte prüfen und speichern Sie die System-Konfiguration erneut.';
$_lang["configcheck_register_globals"] = 'register_globals ist in Ihrer php.ini Konfigurationsdatei auf ON gesetzt';
$_lang["configcheck_register_globals_msg"] = 'Diese Konfiguration macht Ihre Website wesentlich anfälliger für Cross-Site-Scripting-Attacken (XSS). Sie sollten Ihren Web-Hosting-Provider kontaktieren, um herauszufinden wie Sie diese Einstellung ändern können.';
$_lang["configcheck_title"] = 'Konfigurationsprüfung';
$_lang["configcheck_templateswitcher_present"] = 'TemplateSwitcher Plugin gefunden';
$_lang["configcheck_templateswitcher_present_delete"] = '<a href="javascript:deleteTemplateSwitcher();">TemplateSwitcher entfernen</a>';
$_lang["configcheck_templateswitcher_present_disable"] = '<a href="javascript:disableTemplateSwitcher();">TemplateSwitcher deaktivieren</a>';
$_lang["configcheck_templateswitcher_present_msg"] = 'Das Plugin TemplateSwitcher wurde gefunden. Es kann Cache und Performanceprobleme hervorrufen und sollte nur benutzt werden, wenn die Funktionalität von der Webseite benötigt wird.';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Die Seite für unautorisierte Zugriffe wurde nicht veröffentlicht oder existiert nicht.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Die Seite für unautorisierte Zugriffe ist für normale Besucher nicht abrufbar oder existiert nicht. Dies kann zu einer Endlosschleife und vielen Fehlermeldungen in Ihren Webserver-Statistiken führen. Stellen Sie sicher, dass der Seite keine Benutzergruppen zugeordnet sind.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'Die Seite für unautorisierte Zugriffe aus den Einstellungen Ihrer Konfiguration ist nicht veröffentlicht.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Die Seite unautorisierte Zugriffe ist der Allgemeinheit nicht zugänglich. Veröffentlichen Sie die Seite oder stellen Sie sicher, dass in der Konfiguration eine vorhandene Seite aus dem Ressourcen-Baum ausgewählt ist.';
$_lang["configcheck_validate_referer"] = 'Sicherheitshinweis: HTTP Header Validierung';
$_lang["configcheck_validate_referer_msg"] = 'Die Konfigurationseinstellung <strong>HTTP_REFERER Header validieren?</strong> ist AUSGESCHALTET. Wir empfehlen, diese anzuschalten. <a href="index.php?a=17">Zu den Einstellungen</a>';
$_lang["configcheck_warning"] = 'Konfigurationswarnung:';
$_lang["configcheck_what"] = 'Was bedeutet das?';
$_lang["confirm_block"] = 'Sind Sie sicher, dass Sie diesen Benutzer sperren wollen?';
$_lang["confirm_delete_category"] = 'Sind Sie sicher, dass Sie diese Kategorie löschen möchten?';
$_lang["confirm_delete_eventlog"] = 'Wollen Sie das Ereignisprotokoll wirklich löschen?';
$_lang["confirm_delete_file"] = 'Sind Sie sicher, dass Sie diese Datei löschen wollen?\n\nDas könnte könnte dazu führen, dass Ihre Seite nicht mehr richtig funktioniert. Löschen Sie diese Datei nur, wenn Sie genau wissen was sie tun!';
$_lang["confirm_delete_group"] = 'Sind Sie sicher, dass Sie diese Gruppe löschen möchten?';
$_lang["confirm_delete_htmlsnippet"] = 'Sind Sie sicher, dass Sie diesen Chunk löschen möchten?';
$_lang["confirm_delete_keywords"] = 'Sind Sie sicher dass Sie diese Schlüsselwörter löschen wollen?';
$_lang["confirm_delete_module"] = 'Sind Sie sicher, dass Sie dieses Modul löschen möchten?';
$_lang["confirm_delete_plugin"] = 'Sind Sie sicher, dass Sie dieses Plugin löschen möchten?';
$_lang["confirm_delete_record"] = 'Sind Sie sicher, dass Sie die ausgewählten Einträge löschen möchten?';
$_lang["confirm_delete_resource"] = 'Sind Sie sicher, das Sie diese Ressource löschen möchten?\nAlle Unter-Ressourcen werden ebenfalls gelöscht.';
$_lang["confirm_delete_role"] = 'Sind Sie sicher, dass Sie diese Rolle löschen möchten?';
$_lang["confirm_delete_snippet"] = 'Sind Sie sicher, das Sie dieses Snippet löschen möchten?';
$_lang["confirm_delete_tags"] = 'Sind Sie sicher, dass Sie die ausgewählten Meta-Tags löschen möchten?';
$_lang["confirm_delete_template"] = 'Sind Sie sicher, dass Sie dieses Template löschen möchten?';
$_lang["confirm_delete_tmplvars"] = 'Sind Sie sicher, dass Sie diese Template-Variable inklusive der gespeicherten Inhalte löschen möchten?';
$_lang["confirm_delete_user"] = 'Sind Sie sicher, dass Sie diesen Benutzer löschen möchten?';
$_lang["confirm_duplicate_record"] = 'Sind Sie sicher, dass Sie diesen Eintrag duplizieren möchten?';
$_lang["confirm_empty_trash"] = 'Beim leeren des Mülleimers werden alle gelöschten Ressourcen dauerhaft entfernt.\n\nFortfahren?';
$_lang["confirm_load_depends"] = 'Sind Sie sicher, dass Sie das „Abhängigkeiten-verwalten“-Fenster öffnen wollen ohne Ihre Anpassungen zu sichern?';
$_lang["confirm_name_change"] = 'Die Änderung des Benutzernamens kann möglicherweise Auswirkungen auf die Funktion von Anwendungen Dritter haben, die Daten von MODX verwenden.\n\nSind Sie sicher, dass Sie den Benutzernamen ändern wollen?';
$_lang["confirm_publish"] = '\n\nDie Veröffentlichung der Ressource löscht alle Veröffentlichungsdaten die eventuell gesetzt wurden. Wenn Sie die Daten beibehalten möchten, wählen Sie stattdessen „Ressource bearbeiten“.\n\nFortfahren?';
$_lang["confirm_remove_locks"] = 'Manchmal schließen Benutzer ihren Browser während sie Ressourcen oder Elemente bearbeiten. Dabei bleiben diese dann in einem gesperrten Zustand. Wenn Sie OK klicken werden alle Sperren entfernt.\n\nFortfahren?';
$_lang["confirm_reset_sort_order"] = 'Sind Sie sicher, dass Sie den Sortier-Index aller aufgelisteten Elemente auf 0 zurücksetzen möchten?';
$_lang["confirm_resource_duplicate"] = 'Sind Sie sicher, dass Sie diese Ressource duplizieren möchten?\nAlle enthaltenen Unter-Ressourcen werden ebenfalls dupliziert.';
$_lang["confirm_setting_language_change"] = 'Sie haben den Standardwert verändert, Änderungen werden nicht gesichert. Fortfahren?';
$_lang["confirm_unblock"] = 'Sind Sie sicher, dass Sie diesen Benutzer freischalten möchten?';
$_lang["confirm_undelete"] = '\n\nAlle gelöschten Ressourcen werden wieder hergestellt. Ressourcen die vorher aus dem Papierkorb entfernt wurden, werden nicht wiederhergestellt.';
$_lang["confirm_unpublish"] = '\n\nDas Zurückziehen der Ressource entfernt alle Veröffentlichungsdaten. Wenn Sie die Daten beibehalten möchten, wählen Sie „Ressource bearbeiten“.\n\nFortfahren?';
$_lang["confirm_unzip_file"] = 'Sind Sie sicher, dass Sie diese Datei entpacken möchten?\n\nBestehende Dateien werden überschrieben.';
$_lang["could_not_find_user"] = 'Benutzer konnte nicht gefunden werden.';
$_lang["create_folder_here"] = 'Container hier erstellen';
$_lang["create_resource_here"] = 'Ressource hier erstellen';
$_lang["create_resource_title"] = 'Ressource erstellen';
$_lang["create_weblink_here"] = 'Web-Link hier erstellen';
$_lang["createdon"] = 'Erstellungsdatum';
$_lang["create_new"] = 'Neu anlegen';
$_lang["credits"] = 'Danksagungen';
$_lang["credits_shouts_msg"] = '<p>EVO wird ständig weiterentwickelt und verwaltet unter <a href="http://evo.im/" target="_blank">evo.im</a>.</p>';
$_lang["custom_contenttype_message"] = 'Hier können Sie eigene Inhalts-Typen hinzufügen. Geben Sie hierzu den Typ ein und klicken dann auf hinzufügen.';
$_lang["custom_contenttype_title"] = 'Eigene Inhaltstypen';
$_lang["database_charset"] = 'Datenbank-Zeichensatz';
$_lang["database_collation"] = 'Datenbank-Kollations-Zeichensatz';
$_lang["database_name"] = 'Datenbank-Name';
$_lang["database_overhead"] = '<b>Hinweis:</b> Der Overhead ist von MySQL reservierter Speicher, der nicht verwendet wird. Sie können diesen Speicher freigeben, indem Sie auf die Overhead-Angabe der jeweiligen Tabelle klicken.';
$_lang["database_server"] = 'Datenbank-Server';
$_lang["database_table_clickbackup"] = 'Backup erstellen und die ausgewählten Tabellen herunterladen';
$_lang["database_table_clickhere"] = 'Hier klicken';
$_lang["database_table_datasize"] = 'Datenmenge';
$_lang["database_table_droptablestatements"] = 'Erzeuge DROP TABLE Anweisungen.';
$_lang["database_table_effectivesize"] = 'Effektive Größe';
$_lang["database_table_indexsize"] = 'Index-Größe';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Datensätze';
$_lang["database_table_tablename"] = 'Tabellenname';
$_lang["database_table_totals"] = 'Summen';
$_lang["database_table_totalsize"] = 'Gesamtgröße';
$_lang["database_tables"] = 'Datenbank-Tabellen';
$_lang["database_version"] = 'Datenbank-Version';
$_lang["date"] = 'Datum';
$_lang["datechanged"] = 'Änderungsdatum';
$_lang["datepicker_offset"] = 'Zeitspanne Datumswähler';
$_lang["datepicker_offset_message"] = 'Die Anzahl der vergangenen Jahre die der Datumswähler anzeigen soll.';
$_lang["datetime_format"] = 'Datumsformat';
$_lang["datetime_format_message"] = 'Das Format für Datumsangaben im Manager.';
$_lang["default"] = 'Default:';
$_lang["defaultcache_message"] = 'Wählen Sie „Ja“, um alle neuen Ressourcen voreingestellt als cachebar anzulegen.';
$_lang["defaultcache_title"] = 'Voreinstellung Cache';
$_lang["defaultmenuindex_message"] = 'Wählen Sie „Ja“, um den Menüindex bei neuen Ressourcen automatisch zu erhöhen.';
$_lang["defaultmenuindex_title"] = 'Voreinstellung Menüindex-Inkrementierung';
$_lang["defaultpublish_message"] = 'Wählen Sie „Ja“, um alle neuen Ressourcen voreingestellt als veröffentlicht anzulegen.';
$_lang["defaultpublish_title"] = 'Voreinstellung Veröffentlichung';
$_lang["defaultsearch_message"] = 'Wählen Sie „Ja“, um alle neuen Ressourcen voreingestellt als durchsuchbar anzulegen.';
$_lang["defaultsearch_title"] = 'Voreinstellung Durchsuchbar';
$_lang["defaulttemplate_message"] = 'Wählen Sie das Standard-Template das Sie für neue Ressourcen verwenden möchten. Sie können auch andere Templates im Ressourcen-Editor auswählen, diese Einstellung betrefft nur die Standardeinstellung.';
$_lang["defaulttemplate_title"] = 'Standard-Template';
$_lang["defaulttemplate_logic_title"] = 'automatische Template Zuweisung';
$_lang["defaulttemplate_logic_general_message"] = 'neue Ressourcen erben die folgenden Templates. Wird keins gefunden, wird das nächst Höhere vererbt:';
$_lang["defaulttemplate_logic_system_message"] = '<strong>System</strong>: das Standard System-Template.';
$_lang["defaulttemplate_logic_parent_message"] = '<strong>Eltern</strong>: das gleiche Template wie der Eltern-Container.';
$_lang["defaulttemplate_logic_sibling_message"] = '<strong>Nachbar</strong>: das gleiche Template wie andere Ressourcen im selben Container.';
$_lang["delete"] = 'Löschen';
$_lang["delete_resource"] = 'Ressource Löschen';
$_lang["delete_tags"] = 'Tag löschen';
$_lang["deleting_file"] = 'Löschen der Datei „%s“: ';
$_lang["description"] = 'Beschreibung';
$_lang["deselect_keywords"] = 'Keyword-Auswahl aufheben';
$_lang["deselect_metatags"] = 'Metatag-Auswahl aufheben';
$_lang["disabled"] = 'Deaktiviert';
$_lang["doc_data_title"] = 'Daten der Ressource anzeigen';
$_lang["documentation"] = 'Dokumentation';
$_lang["duplicate"] = 'Duplizieren';
$_lang["duplicate_alias_found"] = 'Die Ressource „%s“ verwendet bereits den Alias „%s“. Bitte geben Sie einen eindeutigen Alias ein.';
$_lang["duplicate_alias_message"] = 'Wählen Sie „ja“, um zweideutige Alias-Namen zu erlauben. <b>Hinweis:</b> Diese Option sollte zusammen mit der Option „Benutzerfreundliche URLs“ verwendet werden, um etwaige Probleme bei der Ressourcen-Referenzierung zu vermeiden.';
$_lang["duplicate_alias_title"] = 'Doppelte Aliase zulassen';
$_lang["duplicate_name_found_general"] = 'Es existiert bereits ein %s mit dem Namen „%s“. Bitte geben Sie einen eindeutigen Namen ein.';
$_lang["duplicate_name_found_module"] = 'Es existiert bereits ein Modul mit dem Namen „%s“. Bitte geben Sie einen eindeutigen Namen ein.';
$_lang["duplicated_el_suffix"] = 'Duplizieren';
$_lang["edit"] = 'Bearbeiten';
$_lang["edit_resource"] = 'Ressource Bearbeiten';
$_lang["edit_resource_title"] = 'Ressource erstellen/bearbeiten';
$_lang["edit_settings"] = 'Konfiguration';
$_lang["editedon"] = 'Änderungsdatum';
$_lang["editing_file"] = 'zu ändernde Datei: ';
$_lang["editor_css_path_message"] = 'Geben Sie hier den Pfad zur CSS-Datei an, die Sie im Editor verwenden möchten. Falls Sie keine CSS-Datei verwenden möchten, lassen Sie das Feld leer.';
$_lang["editor_css_path_title"] = 'Pfad zur CSS-Datei';
$_lang["element"] = 'Element';
$_lang["element_categories"] = 'Alle Elemente';
$_lang["element_filter_msg"] = 'Suchbegriff eingeben';
$_lang["element_management"] = 'Elemente-Verwaltung';
$_lang["element_name"] = 'Element-Namen';
$_lang["element_selector_msg"] = 'Wählen Sie die entsprechenden Elemente aus und klicken anschließend auf „einfügen“.';
$_lang["element_selector_title"] = 'Elemente-Auswahl';
$_lang["elements"] = 'Elemente';
$_lang["email"] = 'E-Mail';
$_lang["email_sent"] = 'E-Mail erfolgreich gesendet.';
$_lang["emailsender_message"] = 'Dies ist die Emailadresse des Administrators, und wird zum Beispiel als Senderadresse für Formulare oder Empfänger für System-Benachrichtigungen benutzt.';
$_lang["emailsender_title"] = 'E-Mail-Adresse';
$_lang["emailsubject_default"] = 'Ihre Anmeldedaten';
$_lang["emailsubject_message"] = 'Hier können Sie den Inhalt des Betreffs eingeben.';
$_lang["emailsubject_title"] = 'E-Mail-Betreff';
$_lang["empty_folder"] = 'Dieser Container ist leer';
$_lang["empty_recycle_bin"] = 'Papierkorb leeren';
$_lang["empty_recycle_bin_empty"] = 'Es sind keine gelöschten Ressourcen zum Entfernen vorhanden.';
$_lang["enable_resource"] = 'Element-Datei aktivieren.';
$_lang["enable_sharedparams"] = 'Gemeinsame Parameter aktivieren';
$_lang["enable_sharedparams_msg"] = '<b>Hinweis:</b> Diese eindeutige Identifikationsnummer (GUID) wird dazu benutzt, um das Modul eindeutig zu identifizieren und entsprechende Verknüpfungen zwischen Modulen und Plugins, Snippets und gemeinsamen Parametern zu gewährleisten. ';
$_lang["enabled"] = 'Aktiviert';
$_lang["error"] = 'Fehler';
$_lang["error_sending_email"] = 'E-Mail konnte nicht gesendet werden';
$_lang["errorpage_message"] = 'Geben Sie die ID der Ressource ein, welche aufgerufen wird, wenn eine Seite angefordert wird die nicht vorhanden ist. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist!';
$_lang["errorpage_title"] = 'Fehlerseite';
$_lang["event_id"] = 'Ereignis-ID';
$_lang["eventlog"] = 'Systemereignisprotokoll';
$_lang["eventlog_msg"] = 'Informations-, Warn- und Fehlermeldungen des MODX-Managers werden im Systemereignisprotokoll gespeichert. Unter „Quelle“ ist das jeweils verursachende Modul angegeben.';
$_lang["eventlog_viewer"] = 'Systemereignisse';
$_lang["everybody"] = 'Jeder';
$_lang["existing_category"] = 'Bestehende Kategorie';
$_lang["expand_tree"] = 'Baum aufklappen';
$_lang["failed_login_message"] = 'Hier können Sie die Anzahl fehlgeschlagener Anmeldeversuche einstellen, die erlaubt sind bevor ein Benutzer gesperrt wird.';
$_lang["failed_login_title"] = 'Fehlgeschlagene Anmeldeversuche';
$_lang["fe_editor_lang_message"] = 'Wählen Sie die Sprache, die für den Frontend-Editor verwendet werden soll.';
$_lang["fe_editor_lang_title"] = 'Sprache des Frontend-Editors';
$_lang["file_delete_file"] = 'Datei löschen';
$_lang["file_delete_folder"] = 'Verzeichnis löschen';
$_lang["file_deleted"] = 'Erfolgreich!';
$_lang["file_download_file"] = 'Datei-Download';
$_lang["file_download_unzip"] = 'Datei entpacken';
$_lang["file_folder_chmod_error"] = 'Die Rechte können nicht verändert werden. Sie müssen die Rechte außerhalb von EVO ändern.';
$_lang["file_folder_created"] = 'Verzeichnis erfolgreich erstellt!';
$_lang["file_folder_deleted"] = 'Verzeichnis erfolgreich gelöscht!';
$_lang["file_folder_not_created"] = 'Verzeichniserstellung nicht möglich';
$_lang["file_folder_not_deleted"] = 'Verzeichnis kann nicht gelöscht werden. Stellen Sie sicher, dass das Verzeichnis leer ist.';
$_lang["file_not_deleted"] = 'Nicht erfolgreich!';
$_lang["file_not_saved"] = 'Datei kann nicht gespeichert werden. Überprüfen Sie den Schreibzugriff im Zielverzeichnis!';
$_lang["file_saved"] = 'Datei erfolgreich aktualisiert!';
$_lang["file_unzip"] = 'Unzip erfolgreich!';
$_lang["file_unzip_fail"] = 'Unzip fehlgeschlagen!';
$_lang["filemanager_path_message"] = 'Unter Umständen erkennt Ihr Webserver (z.B. IIS) den Pfad nicht immer korrekt, überprüfen Sie deshalb diese Einstellung. Wenn Sie Probleme mit der Benutzung des Datei-Managers haben, stellen Sie sicher dass dieser Pfad auf das Root-Verzeichnis Ihrer EVO-Installation verweist.';
$_lang["filemanager_path_title"] = 'Datei-Manager-Pfad';
$_lang["files_access_denied"] = 'Zugriff verweigert!';
$_lang["files_data"] = 'Größe';
$_lang["files_dir_listing"] = 'Verzeichnisübersicht für:';
$_lang["files_directories"] = 'Verzeichnisse';
$_lang["files_directory_is_empty"] = 'Dieses Verzeichnis ist leer.';
$_lang["files_dirwritable"] = 'Verzeichnis beschreibbar?';
$_lang["files_editfile"] = 'Datei bearbeiten';
$_lang["files_file_type"] = 'Dateityp: ';
$_lang["files_filename"] = 'Dateiname';
$_lang["files_fileoptions"] = 'Optionen';
$_lang["files_files"] = 'Dateien';
$_lang["files_filesize"] = 'Dateigröße';
$_lang["files_filetype_notok"] = 'Das Hochladen einer Datei von diesem Typ ist nicht erlaubt!';
$_lang["files_management"] = 'Dateien verwalten';
$_lang["files_management_no_permission"] = 'Sie haben nicht genug Rechte um diese Dateien einzusehen oder zu bearbeiten. Bitten Sie den Administrator Ihnen Zugriff auf <b>%s</b> zu gewähren.';
$_lang["files_modified"] = 'Datum';
$_lang["files_top_level"] = 'Zum Hauptverzeichnis';
$_lang["files_up_level"] = 'Ein Verzeichnis nach oben wechseln';
$_lang["files_upload_copyfailed"] = 'Upload fehlgeschlagen. Das Kopieren der Datei in den Zielordner ist nicht möglich!';
$_lang["files_upload_error"] = 'Fehler';
$_lang["files_upload_error0"] = 'Ein Problem beim Upload ist aufgetreten.';
$_lang["files_upload_error1"] = 'Die Datei ist für einen Upload zu groß.';
$_lang["files_upload_error2"] = 'Die Datei ist für einen Upload zu groß.';
$_lang["files_upload_error3"] = 'Die Datei wurde nur teilweise übertragen.';
$_lang["files_upload_error4"] = 'Sie müssen eine Datei für den Upload auswählen.';
$_lang["files_upload_error5"] = 'Beim Upload ist ein Problem aufgetreten.';
$_lang["files_upload_inhibited_msg"] = '<b>Datei-Upload fehlgeschlagen.</b> Stellen Sie sicher, dass der Upload unterstützt wird und PHP in dieses Verzeichnis schreiben darf.';
$_lang["files_upload_ok"] = 'Upload erfolgreich!';
$_lang["files_upload_permissions_error"] = 'Mögliche Probleme mit den Zugriffsrechten: das Upload-Verzeichnis muss auf dem Web-Server beschreibbar sein.';
$_lang["files_uploadfile"] = 'Datei hochladen';
$_lang["files_uploadfile_msg"] = 'Datei zum Hochladen wählen:';
$_lang["files_uploading"] = 'Upload <b>%s</b> in Verzeichnis <b>%s/</b>';
$_lang["files_viewfile"] = 'Datei anzeigen';
$_lang["folder"] = 'Verzeichnis';
$_lang["forgot_password_email_fine_print"] = '* Die oben angegebene URL verliert nach Änderung Ihres Kennworts oder spätestens nach einem Tag ihre Gültigkeit.';
$_lang["forgot_password_email_instructions"] = 'Anschließend können Sie Ihr Kennwort im Benutzermenü der Zugangsverwaltung ändern.';
$_lang["forgot_password_email_intro"] = 'Es wurde ein neues Kennwort für Ihren Zugang angefordert.';
$_lang["forgot_password_email_link"] = 'Klicken Sie hier, um ein neues Kennwort zu erstellen.';
$_lang["forgot_your_password"] = 'Kennwort vergessen?';
$_lang["friday"] = 'Freitag';
$_lang["friendly_alias_message"] = 'Wenn Sie benutzerfreundliche URLs verwenden, und die Ressource einen Alias-Eintrag hat, wird das Alias als benutzerfreundliche URL verwendet. Falls Sie keine benutzerfreundlichen URLs verwenden, generiert EVO den Link mit einer durchlaufenden Nummerierung.';
$_lang["friendly_alias_title"] = 'Aliasnamen nutzen';
$_lang["friendlyurls_message"] = 'Diese Option erlaubt Ihnen die Benutzung benutzerfreundlicher URLs auf Apache-Webservern mit aktiviertem mod_rewrite oder auf dem IIS-Webserver mit entsprechenden Modulen. Öffnen sie bei MODX enthaltene .htaccess-Datei im Root-Verzeichnis für mehr Informationen.';
$_lang["friendlyurls_title"] = 'Benutzerfreundliche URLs nutzen';
$_lang["friendlyurlsprefix_message"] = 'Hier können Sie ein Präfix für die benutzerfreundlichen URLs angeben. Wenn Sie z.B. „page“ als Präfix angeben, wird die URL /index.php?id=2 in /page2.html umgewandelt (vorausgesetzt das Suffix wurde auf .html gesetzt).';
$_lang["friendlyurlsprefix_title"] = 'Präfix für benutzerfreundliche URLs';
$_lang["friendlyurlsuffix_message"] = 'Hier können Sie ein Suffix angeben.';
$_lang["friendlyurlsuffix_title"] = 'Suffix für benutzerfreundliche URLs';
$_lang["functionnotimpl"] = 'Sorry!';
$_lang["functionnotimpl_message"] = 'Diese Funktion ist noch nicht implementiert';
$_lang["further_info"] = 'Weiterführende Informationen';
$_lang["global_tabs"] = 'Globale Tabs';
$_lang["go"] = 'Los';
$_lang["group_access_permissions"] = 'Benutzergruppenberechtigungen';
$_lang['group_tvs'] = 'TVs gruppieren';
$_lang["guid"] = 'Eindeutige Identifikationsnummer (GUID)';
$_lang["help"] = 'Hilfe';
$_lang["help_msg"] = '<p>Sie können kostenlos Support im <a href="http://forums.modx.com/" target="_blank">EVO Forum</a> erhalten. Zusätzlich werden die <a href="http://evolution-docs.com" target="_blank">EVO Dokumentation und Anleitungen</a> regelmäßig erweitert.</p><p>Desweiteren planen wir auch kostenpflichtigen professionellen Support anzubieten. Bitte <a href="mailto:dmi3yy@evo.im?subject=EVO Commercial Support Inquiry">senden Sie uns bei Interesse eine Email</a>.</p>';
$_lang["help_title"] = 'Hilfe';
$_lang["hide_tree"] = 'Baum verbergern';
$_lang["home"] = 'Dashboard';
$_lang["htmlsnippet"] = 'Chunk';
$_lang["htmlsnippets"] = 'Chunks';
$_lang["htmlsnippet_desc"] = 'Chunk-Beschreibung';
$_lang["htmlsnippet_management_msg"] = 'Hier können Sie das zu bearbeitende Chunk auswählen';
$_lang["htmlsnippet_msg"] = 'Hier können Sie Chunks hinzufügen oder bearbeiten. Achtung, Chunks bestehen aus reinem HTML-Code – PHP-Code wird nicht ausgeführt.';
$_lang["htmlsnippet_name"] = 'Chunk-Name';
$_lang["htmlsnippet_title"] = 'Chunk erstellen/bearbeiten ';
$_lang["icon"] = 'Symbol';
$_lang["icon_description"] = 'CSS Klasse, e.g. fa&nbsp;fa-star';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Container-Zuweisung:\n\nDie Ressource ist dem gewählten Container zugehörig.';
$_lang["illegal_parent_self"] = 'Container-Zuweisung:\n\nDie Ressource kann nicht sich selbst zugewiesen werden.';
$_lang["images_management"] = 'Bilder verwalten';
$_lang["import_files_found"] = '<b>%s Ressourcen für den Import gefunden …</b><p />';
$_lang["import_params"] = 'Importieren von gemeinsamen Parametern';
$_lang["import_params_msg"] = 'Sie können die Parameter und Einstellungen mittels obiger Auswahlliste importieren. <b>Hinweis:</b> Damit Module in dieser Liste erscheinen, muss das jeweilige Plugin/Snippet in der Abhängigkeitsliste des Moduls stehen und das Modul muss die Option „Gemeinsame Parameter“ aktiviert haben. ';
$_lang["import_parent_resource"] = 'Container:';
$_lang["update_tree"] = 'Baue den Baum wieder auf';
$_lang["inbox"] = 'Inbox';
$_lang["info"] = 'Info';
$_lang["information"] = 'Information';
$_lang["inline"] = 'Browser-Fenster';
$_lang["insert"] = 'Einfügen';
$_lang["maxImageWidth"] = 'Maximale Bildbreite';
$_lang["maxImageHeight"] = 'Maximale Bildhöhe';
$_lang["clientResize"] = 'Bildgrößen beim Benutzer berechnen';
$_lang["clientResize_message"] = 'Falls aktiviert werden Bildergrößen vor dem Upload vom Browser berechnet.';
$_lang["noThumbnailsRecreation"] = 'Thumbnails nur beim Upload erstellen';
$_lang["noThumbnailsRecreation_message"] = 'Der Dateibrowser wird Thumbnails nur beim Upload erstellen. Falls für einig Bilder keine Thumbnails existieren, werden diese nicht erstellt.';
$_lang["thumbWidth"] = 'Maximale Vorschaubild-Breite';
$_lang["thumbHeight"] = 'Maximale Vorschaubild-Höhe';
$_lang["thumbsDir"] = 'Thumbnails directory location';
$_lang["jpegQuality"] = 'JPEG Komprimierung';
$_lang["denyZipDownload"] = 'Download von ZIP-Dateien deaktivieren';
$_lang["denyExtensionRename"] = 'Umbenennen von Dateierweiterungen deaktivieren';
$_lang["maxImageWidth_message"] = 'Sobald ein hochgeladenes Bild diese Größe überschreitet, wird es automatisch verkleinert. Auf 0 stellen zum Deaktivieren';
$_lang["maxImageHeight_message"] = 'Sobald ein hochgeladenes Bild diese Größe überschreitet, wird es automatisch verkleinert. Auf 0 stellen zum Deaktivieren';
$_lang["thumbWidth_message"] = 'Maximale Vorschaubild-Breite.';
$_lang["thumbHeight_message"] = 'Maximale Vorschaubild-Höhe.';
$_lang["thumbsDir_message"] = 'Name des Vorschaubild-Verzeichnisses';
$_lang["jpegQuality_message"] = 'JPEG Komprimierungsqualität für Vorschaubilder und verkleinerte Bilder';
$_lang["showHiddenFiles"] = 'Versteckte Dateien im Datei-Browser anzeigen';
$_lang["keyword"] = 'Schlüsselwort';
$_lang["keywords"] = 'Schlüsselwörter';
$_lang["keywords_intro"] = 'Hier legen Sie die Schlüsselwörter fest, die Ihrer Ressource zugewiesen werden können.';
$_lang["language_message"] = 'Wählen Sie die Sprache für den EVO-Manager aus.';
$_lang["language_title"] = 'Manager Sprache';
$_lang["last_update"] = 'Letzte Aktualisierung';
$_lang["launch_site"] = 'Anzeigen';
$_lang["license"] = 'Lizenz';
$_lang["link_attributes"] = 'Link-Attribute';
$_lang["link_attributes_help"] = 'Hier können Sie HTML-Attribute für den Link angeben (z.B. target= oder rel=).';
$_lang["list_mode"] = 'Listenmodus ein/aus – alle Einträge anzeigen.';
$_lang["loading_doc_tree"] = 'Laden des Ressourcen-Baums …';
$_lang["loading_menu"] = 'Laden des Menüs …';
$_lang["loading_page"] = 'Bitte warten Sie während EVO die Seite lädt …';
$_lang["localtime"] = 'Ortszeit';
$_lang["lock_htmlsnippet"] = 'Chunk für Bearbeitung sperren';
$_lang["lock_htmlsnippet_msg"] = 'Nur Administratoren (Rollen-ID 1) können diesen Chunk bearbeiten.';
$_lang["lock_module"] = 'Modul für die Bearbeitung sperren';
$_lang["lock_module_msg"] = 'Nur Administratoren (Rollen-ID 1) können dieses Modul bearbeiten.';
$_lang["lock_msg"] = 'Der Benutzer %s bearbeitet gerade die Ressource %s. Bitte warten Sie bis dieser Benutzer seine Arbeit beendet und die Ressource wieder freigegeben hat.';
$_lang["lock_plugin"] = 'Plugin für die Bearbeitung sperren';
$_lang["lock_plugin_msg"] = 'Nur Administratoren (Rollen-ID 1) können dieses Plugin bearbeiten.';
$_lang["lock_settings_msg"] = 'Der Benutzer %s bearbeitet gerade diese Einstellungen. Bitte warten Sie bis dieser seine Arbeit beendet und die Ressource wieder freigegeben hat.';
$_lang["lock_snippet"] = 'Snippet für die Bearbeitung sperren.';
$_lang["lock_snippet_msg"] = 'Nur Administratoren (Rollen-ID 1) können dieses Snippet bearbeiten.';
$_lang["lock_template"] = 'Template für die Bearbeitung sperren.';
$_lang["lock_template_msg"] = 'Nur Administratoren (Rollen-ID 1) können dieses Template bearbeiten.';
$_lang["lock_tmplvars"] = 'Template-Variable gegen Bearbeitung sperren';
$_lang["lock_tmplvars_msg"] = 'Nur Administratoren (Rollen-ID 1) können diese Template-Variable bearbeiten.';
$_lang["locked"] = 'Gesperrt';
$_lang["login_allowed_days"] = 'Wochentagsbeschränkung';
$_lang["login_allowed_days_message"] = 'Wählen Sie die Wochentage aus, an denen der Benutzer Zugriff erhält.';
$_lang["login_allowed_ip"] = 'IP-Adressbeschränkung';
$_lang["login_allowed_ip_message"] = 'Geben Sie hier die IP-Adressen an, von denen aus der Benutzer eine Zugriffsberechtigung erhält. <b>Hinweis: Mehrere IP-Adressen können mit einem Komma getrennt werden.</b>';
$_lang["login_button"] = 'Anmelden';
$_lang["login_cancelled_install_in_progress"] = 'Installation/Update der Site läuft. <br />Bitte versuchen Sie es in einigen Minuten erneut!<br />';
$_lang["login_cancelled_site_was_updated"] = 'Installation/Update der Site wurde abgeschlossen. Bitte melden Sie sich erneut an!<br />';
$_lang["login_captcha_message"] = ' Der Administrator hat die Captcha-Validierung aktiviert, Sie müssen daher auch den Sicherheits-Code eingeben. \n\nWenn der Sicherheits-Code schlecht lesbar ist, klicken Sie bitte auf den Code, damit ein neuer Code generiert wird.';
$_lang["login_homepage"] = 'Anmeldeseite';
$_lang["login_homepage_message"] = 'Geben Sie die Ressource-ID an, zu welcher der Web-Benutzer nach einer erfolgreichen Anmeldung weitergeleitet wird. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist und der entsprechende Web-Benutzer die notwendigen Zugriffsberechtigungen besitzt um darauf zuzugreifen!';
$_lang["login_message"] = 'Bitte melden Sie sich an, um mit MODX zu arbeiten.<br />Beachten Sie bei Ihrer Eingabe die Groß- und Kleinschreibung.';
$_lang["logo_slogan"] = 'EVO Content Manager - \nCreate and do more with less';
$_lang["logout"] = 'Abmelden';
$_lang["long_title"] = 'Langer Titel';
$_lang["mail_check_timeperiod_message"] = 'Wie oft soll nach neuen Nachrichten im Manager gesucht werden (Angabe in Sekunden)?';
$_lang["mail_check_timeperiod_title"] = 'Nachrichten-Überprüfungsfrequenz';
$_lang["manage_depends"] = 'Abhängigkeiten verwalten';
$_lang["manage_files"] = 'Datei-Manager';
$_lang["manage_htmlsnippets"] = 'Chunks';
$_lang["manage_metatags"] = 'Meta-Angaben verwalten';
$_lang["manage_modules"] = 'Module verwalten';
$_lang["manage_plugins"] = 'Plugins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Template-Verwaltung';
$_lang["manage_documents"] = 'Dokumente';
$_lang["manager"] = 'Manager';
$_lang["manager_lockout_message"] = '<p>Sie sind gegenwärtig im MODX-Manager angemeldet. Wenn Sie Ihre Login-Session beenden wollen, klicken Sie bitte den Abmelden-Button.</p><p>Um zu Ihrer Start- oder Home-Seite zu gelangen, klicken Sie bitte den Start-Button.';
$_lang["manager_permissions"] = 'Manager-Zugriffberechtigungen';
$_lang["manager_theme"] = 'Manager-Template';
$_lang["manager_theme_message"] = 'Wählen Sie das Template für den MODX-Manager aus.';
$_lang["manager_theme_mode"] = 'Farbschema:';
$_lang["manager_theme_mode1"] = 'Helles Farbschema';
$_lang["manager_theme_mode2"] = 'Header dunkel';
$_lang["manager_theme_mode3"] = 'Header und Seitenleiste dunkel';
$_lang["manager_theme_mode4"] = 'Dunkles Farbschema';
$_lang["meta_keywords"] = 'Meta-Angaben';
$_lang["metatag_intro"] = 'In diesem Bereich verwalten Sie Meta-Angaben, die Ihren Ressourcenn beim Bearbeiten zugewiesen werden können.';
$_lang["metatag_notice"] = 'Im HTML-Nachschlagewerk <a href="http://de.selfhtml.org/html/kopfdaten/meta.htm" target="_blank">SELFHTML</a> finden Sie eine Zusammenstellung geläufiger Meta-Angaben, sowie Hinweise zu deren Anwendung.';
$_lang["metatags"] = 'Meta-Angaben';
$_lang["mgr_access_permissions"] = 'Manager-Zugriffsberechtigungen';
$_lang["mgr_login_start"] = 'Benutzer-Startbildschirm';
$_lang["mgr_login_start_message"] = 'Geben Sie die Ressource-ID an, zu welcher der Web-Benutzer nach einer erfolgreichen Anmeldung weitergeleitet werden soll. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist und der entsprechende Web-Benutzer die notwendigen Zugriffsberechtigungen besitzt um darauf zuzugreifen!';
$_lang["mgrlog_action"] = 'Aktion';
$_lang["mgrlog_actionid"] = 'Aktions-ID';
$_lang["mgrlog_anyall"] = 'Einzelne/Alle';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() gibt „false“ zurück.';
$_lang["mgrlog_datefr"] = 'Datum von';
$_lang["mgrlog_dateinvalid"] = 'Ungültiges Datumsformat.';
$_lang["mgrlog_dateto"] = 'Datum bis';
$_lang["mgrlog_emptysrch"] = 'Ihre Suchanfrage ergab keine Treffer.';
$_lang["mgrlog_field"] = 'Feld';
$_lang["mgrlog_itemid"] = 'Element-ID';
$_lang["mgrlog_itemname"] = 'Elementname';
$_lang["mgrlog_msg"] = 'Nachricht';
$_lang["mgrlog_noquery"] = 'Es wurde noch keine Suchanfrage eingegeben.';
$_lang["mgrlog_qresults"] = 'Suchergebnisse';
$_lang["mgrlog_query"] = 'Suchabfragen loggen';
$_lang["mgrlog_query_msg"] = 'Bitte treffen Sie eine Auswahl, um die Protokoll-Einträge anzusehen. Sie können Einträge innerhalb eines bestimmten Zeitraums durchsuchen. Aber berücksichtigen Sie, dass das eingegebene Datum nicht inklusive ist – um alle Einträge für den 01-01-2009 auszuwählen, setzen Sie „Datum von“ auf den 01-01-2009 und „Datum bis“ auf den 02-01-2009.<br /><br />Eine Nachricht und eine Aktion sind üblicherweise dasselbe. Wenn Sie nach einer bestimmten Nachricht suchen, ist es am besten die Aktion „Einzelne/Alle“ auszuwählen.';
$_lang["mgrlog_results"] = 'Anzahl der Ergebnisse';
$_lang["mgrlog_searchlogs"] = 'Such-Protokoll';
$_lang["mgrlog_sortinst"] = 'Sie können die Tabelle sortieren, indem Sie auf die Spaltenüberschriften klicken. Sollten die Protokolldateien zu groß werden, können Sie diese <a href="index.php?a=55">löschen</a>. Dadurch werden alle Protokolleinträge bis zum heutigen Tag entfernt – das Löschen der Protokolleinträge kann nicht rückgängig gemacht werden!';
$_lang["mgrlog_time"] = 'Zeit';
$_lang["mgrlog_user"] = 'Benutzer';
$_lang["mgrlog_username"] = 'Benutzername';
$_lang["mgrlog_value"] = 'Wert';
$_lang["mgrlog_view"] = 'Benutzerprotokolle anzeigen';
$_lang["module_code"] = 'Modul-Code (PHP)';
$_lang["module_config"] = 'Modul Konfiguration';
$_lang["module_desc"] = 'Beschreibung';
$_lang["module_disabled"] = 'Modul deaktivieren';
$_lang["module_edit_click_title"] = 'Klicken Sie hier, um das Modul zu bearbeiten';
$_lang["module_group_access_msg"] = 'Wählen Sie die Benutzergruppen aus, die dieses Modul innerhalb des MODX-Managers ausführen dürfen.';
$_lang["module_management"] = 'Modul-Verwaltung';
$_lang["module_management_msg"] = 'In dieser Übersicht können Sie Module ausführen und bearbeiten. Um ein Modul zu starten, klicken Sie auf das Symbol des Moduls, für die Bearbeitung auf den Namen.';
$_lang["module_msg"] = 'Hier können Sie Module verwalten und bearbeiten. Ein Modul ist eine Zusammenfassung von Elementen wie Plugins, Snippets, usw.';
$_lang["module_name"] = 'Modulname';
$_lang["module_resource_msg"] = 'Hier können Sie die Ressourcen verwalten, die dieses Modul benötigt. Benutzen Sie die entsprechenden Buttons.';
$_lang["module_resource_title"] = 'Modulabhängigkeiten';
$_lang["module_title"] = 'Modul erstellen/bearbeiten';
$_lang["module_viewdepend_msg"] = 'Hier können Sie die Abhängigkeiten dieses Moduls bearbeiten und verwalten.';
$_lang["modules"] = 'Module';
$_lang["modx_news"] = 'EVO Neuigkeiten';
$_lang["modx_news_tab"] = 'EVO Neuigkeiten';
$_lang["modx_news_title"] = 'EVO Neuigkeiten';
$_lang["modx_security_notices"] = 'EVO Sicherheitshinweise';
$_lang["modx_version"] = 'EVO-Version';
$_lang["monday"] = 'Montag';
$_lang["move"] = 'Verschieben';
$_lang["move_resource"] = 'Ressource Verschieben';
$_lang["move_resource_message"] = 'Sie können diese Ressource und alle Unter-Ressourcen durch die Wahl eines neuen Containers verschieben. Wenn Sie eine Ressource wählen, die kein Container ist, wird diese Ressource automatisch in einen Container umgewandelt. Bitte wählen Sie einen neuen Container aus dem Ressourcen-Baum aus.';
$_lang["move_resource_new_parent"] = 'Bitte wählen Sie einen neuen Container aus dem Ressourcen-Baum aus.';
$_lang["move_resource_title"] = 'Ressource verschieben';
$_lang["name"] = 'Name';
$_lang["new_category"] = 'Neue Kategorie';
$_lang["new_file_permissions_message"] = 'Wenn Sie eine neue Datei mit dem Datei-Manager hochladen, wird versucht die Dateirechte wie hier angegeben zu setzen. In manchen Installationen (zum Beispiel in Microsofts IIS), ist dies nicht möglich. In diesem Fall Dann müssen Sie die Rechte der Datei manuell setzen.';
$_lang["new_file_permissions_title"] = 'Neue Dateirechte';
$_lang["new_folder_permissions_message"] = 'Wenn Sie eine neues Verzeichnis mit dem Datei-Manager erstellen, wird versucht die Verzeichnisrechte wie hier angegeben zu setzen. In manchen Installationen (zum Beispiel in Microsofts IIS), ist dies nicht möglich. In diesem Fall Dann müssen Sie die Rechte der Datei manuell setzen.';
$_lang["new_folder_permissions_title"] = 'Neue Verzeichnis-Zugriffsrechte';
$_lang["new_htmlsnippet"] = 'Neues Chunk';
$_lang["new_keyword"] = 'Neues Schlüsselwort:';
$_lang["new_module"] = 'Neues Modul ';
$_lang["new_parent"] = 'Neues Überelement';
$_lang["new_plugin"] = 'Neues Plugin';
$_lang["new_role"] = 'Neue Rolle';
$_lang["new_snippet"] = 'Neues Snippet';
$_lang["new_template"] = 'Neues Template';
$_lang["new_tmplvars"] = 'Neue Template-Variable';
$_lang["new_user"] = 'Neuer Manager-Benutzer';
$_lang["new_web_user"] = 'Neuer Web-Benutzer';
$_lang["new_resource"] = 'Neue Ressource';
$_lang["no"] = 'Nein';
$_lang["no_active_users_found"] = 'Keine aktiven Benutzer gefunden.';
$_lang["no_activity_message"] = 'Sie haben bis jetzt noch keine Ressourcen bearbeitet oder erstellt.';
$_lang["no_category"] = 'nicht kategorisiert';
$_lang["no_docs_pending_publishing"] = 'Es stehen keine Ressourcen zum zeitgesteuerten Veröffentlichen an.';
$_lang["no_docs_pending_pubunpub"] = 'Keine Ereignisse.';
$_lang["no_docs_pending_unpublishing"] = 'Es stehen keine Ressourcen zum zeitgesteuerten Zurückziehen an.';
$_lang["no_edits_creates"] = 'Keine bearbeiteten oder erstellten Ressourcen gefunden.';
$_lang["no_groups_found"] = 'Keine Gruppen gefunden.';
$_lang["no_keywords_found"] = 'Keine Keywords vorhanden.';
$_lang["no_records_found"] = 'Keine Einträge gefunden.';
$_lang["no_results"] = 'Es wurden keine Ergebnisse gefunden';
$_lang["nologentries_message"] = 'Geben Sie die Anzahl der Einträge an, die im Protokoll angezeigt werden sollen.';
$_lang["nologentries_title"] = 'Anzahl der Log-Einträge';
$_lang["nomessages_message"] = 'Geben Sie wie viele Nachrichten im Posteingang angezeigt werden sollen.';
$_lang["nomessages_title"] = 'Anzahl der Nachrichten';
$_lang["none"] = 'Keine';
$_lang["noresults_message"] = 'Anzahl der anzuzeigenden Ergebnisse in Listen und Suchergebnissen.';
$_lang["noresults_title"] = 'Ergebnisse';
$_lang["not_deleted"] = 'wurde nicht gelöscht.';
$_lang["not_set"] = 'Nicht gesetzt';
$_lang["offline"] = 'Offline';
$_lang["online"] = 'Online';
$_lang["onlineusers_action"] = 'Aktion';
$_lang["onlineusers_actionid"] = 'Aktions-ID';
$_lang["onlineusers_ipaddress"] = 'IP-Adresse des Benutzers';
$_lang["onlineusers_lasthit"] = 'Letzte Aktion';
$_lang["onlineusers_message"] = 'Diese Liste zeigt Ihnen die aktiven Benutzer der letzten 20 Minuten an. (Zur Zeit ist es ';
$_lang["onlineusers_title"] = 'Folgende Benutzer sind online';
$_lang["onlineusers_user"] = 'Benutzer';
$_lang["onlineusers_userid"] = 'Benutzer-ID';
$_lang["optimize_table"] = 'Klicken Sie hier, um die Tabelle zu optimieren';
$_lang["page_data_alias"] = 'Alias';
$_lang["page_data_cacheable"] = 'Cache aktiv';
$_lang["page_data_cacheable_help"] = 'Markieren Sie diese Option, falls Ihre Ressource cachebar sein soll. Falls Ihre Ressource Snippets nutzt, muss diese Option deaktiviert sein.';
$_lang["page_data_cached"] = '<b>Quelltext aus dem Cache:</b>';
$_lang["page_data_changes"] = 'Änderungen';
$_lang["page_data_contentType"] = 'Inhaltstyp';
$_lang["page_data_contentType_help"] = 'Wählen Sie den Inhaltstyp für diese Ressource. Wenn Sie sich nicht sicher sind welchen Typ die Ressource haben soll, lassen Sie die Einstellung auf „text/html“.';
$_lang["page_data_created"] = 'Erstellt';
$_lang["page_data_edited"] = 'Bearbeitet';
$_lang["page_data_editor"] = 'Rich-Text-Editor benutzen';
$_lang["page_data_folder"] = 'Ressource ist ein Container';
$_lang["page_data_general"] = 'Allgemein';
$_lang["page_data_markup"] = 'Auszeichnung / Struktur';
$_lang["page_data_mgr_access"] = 'Manager-Zugriff';
$_lang["page_data_notcached"] = 'Diese Ressource wurde noch nicht gecached.';
$_lang["page_data_publishdate"] = 'Veröffentlichen am';
$_lang["page_data_publishdate_help"] = 'Falls Sie ein Datum setzen, wird die Ressource zum angegebenen Zeitpunkt veröffentlicht.';
$_lang["page_data_published"] = 'Veröffentlicht';
$_lang["page_data_searchable"] = 'Durchsuchbar';
$_lang["page_data_searchable_help"] = 'Ist diese Option aktiv, kann die Ressource durchsucht werden. Sie können dieses Feld auch für jede andere Aktion in Ihren Snippets nutzen.';
$_lang["page_data_source"] = 'Quelltext';
$_lang["page_data_status"] = 'Status';
$_lang["page_data_template"] = 'Template';
$_lang["page_data_template_help"] = 'Hier können Sie das Template für die Ressource wählen.';
$_lang["page_data_title"] = 'Daten der Ressource';
$_lang["page_data_unpublishdate"] = 'Zurückziehen am';
$_lang["page_data_unpublishdate_help"] = 'Falls Sie ein Datum setzen, wird die Ressource zum angegebenen Zeitpunkt zurückgezogen.';
$_lang["page_data_unpublished"] = 'Unveröffentlicht';
$_lang["page_data_web_access"] = 'Web-Zugriff';
$_lang["pagetitle"] = 'Ressource-Titel';
$_lang["pagination_table_first"] = 'Anfang';
$_lang["pagination_table_gotopage"] = 'Gehe zu Seite';
$_lang["pagination_table_last"] = 'Ende';
$_lang["paging_first"] = 'Anfang';
$_lang["paging_last"] = 'Ende';
$_lang["paging_next"] = 'Vor';
$_lang["paging_prev"] = 'Zurück';
$_lang["paging_showing"] = 'Zeige';
$_lang["paging_to"] = 'von';
$_lang["paging_total"] = 'insgesamt';
$_lang["parameter"] = 'Parameter';
$_lang["parse_docblock"] = 'DocBlock parsen';
$_lang["parse_docblock_msg"] = 'Achtung (!): Wenn aktiviert, wird durch Analyse des DocBlocks der aktuelle Name, Konfiguration, Beschreibung und Kategorie auf die Standardeinstellungen <b>zurückgesetzt</b>.';
$_lang["password"] = 'Passwort';
$_lang["password_change_request"] = 'Neues Passwort angefordert';
$_lang["password_gen_gen"] = 'EVO soll ein Passwort generieren.';
$_lang["password_gen_length"] = 'Das Passwort muss mindestes 6 Zeichen lang sein.';
$_lang["password_gen_method"] = 'Wie möchten Sie das Passwort erzeugen?';
$_lang["password_gen_specify"] = 'Das Passwort wird von mir eingegeben:';
$_lang["password_method"] = 'Wie möchten Sie den Benutzer über sein neues Passwort benachrichtigen?';
$_lang["password_method_email"] = 'Neues Passwort per E-Mail senden.';
$_lang["password_method_screen"] = 'Neues Passwort am Bildschirm ausgeben.';
$_lang["password_msg"] = 'Das neue Passwort für <b>:username</b> ist <b>:password</b>.';
$_lang["php_version_check"] = 'EVO ist kompatibel mit PHP 5.6.0 und höher. Dieser Server nutzt aktuell die Version %s%. Bitte installieren Sie eine neuere Version von PHP. ';
$_lang["plugin"] = 'Plugin';
$_lang["plugins"] = 'Plugins';
$_lang["plugin_code"] = 'Plugin-Code (PHP)';
$_lang["plugin_config"] = 'Plugin-Konfiguration';
$_lang["plugin_desc"] = 'Beschreibung';
$_lang["plugin_disabled"] = 'Plugin deaktiviert';
$_lang["plugin_event_msg"] = 'Wählen Sie hier die Systemereignisse aus, bei denen dieses Plugin ausgeführt werden soll.';
$_lang["plugin_management_msg"] = 'Hier können Sie auswählen welches Plugin Sie bearbeiten möchten.';
$_lang["plugin_msg"] = 'Hier können Sie Plugins erstellen und bearbeiten. Plugins bestehen aus PHP-Quellcode und werden aufgrund von definierten Systemereignissen ausgeführt.';
$_lang["plugin_name"] = 'Plugin-Name';
$_lang["plugin_priority"] = 'Ausführungsreihenfolge festlegen';
$_lang["plugin_priority_instructions"] = 'Hier können Sie durch Drag & Drop die Plugins unter jedem Event-Titel neu anordnen. Das erste Plugin das ausgeführt werden soll, muss ganz oben platziert werden.';
$_lang["plugin_priority_title"] = 'Reihenfolge der Ausführung der Plugns';
$_lang["purge_plugin"] = 'Veraltete Plugins entfernen';
$_lang["purge_plugin_confirm"] = 'Sind Sie sicher, dass Sie alle veralteten Plugins löschen möchten?';
$_lang["plugin_title"] = 'Plugin erstellen/bearbeiten';
$_lang["preview"] = 'Vorschau';
$_lang["preview_msg"] = 'Dies ist eine Vorschau Ihrer zuletzt gespeicherten Änderungen. Klicken Sie <a href="javascript:;" onclick="saveRefreshPreview();">Speichern und aktualisieren</a> um Ihren aktuellen Änderungen zu speichern.';
$_lang["preview_resource"] = 'Ressource-Vorschau';
$_lang["private"] = 'Privat';
$_lang["public"] = 'Öffentlich';
$_lang["publish_date"] = 'Veröffentlichungstermin';
$_lang["publish_events"] = 'Veröffentlichungen';
$_lang["publish_resource"] = 'Veröffentlichen';
$_lang["rb_base_dir_message"] = 'Geben Sie den physischen Pfad auf dem Web-Server zu Ihrem Datei-Verzeichnis ein. Abhängig von Ihrem Webserver ist diese Einstellung im Normalfall automatisch vorausgefüllt. <b>Hinweis:</b> Für die korrekte Funktion muss das Datei-Verzeichnis die Unterverzeichnisse „images“, „docs“, „flash“ und „media“ beinhalten.';
$_lang["rb_base_dir_title"] = 'Datei-Basispfad';
$_lang["rb_base_url_message"] = 'Geben Sie den virtuellen Pfad zum Datei-Basispfad an. Der virtuelle Pfad ist identisch mit der URL in Ihrem Web-Browser.';
$_lang["rb_base_url_title"] = 'Datei-URL';
$_lang["rb_message"] = 'Wählen Sie „Ja“, um den Datei-Browser zu aktivieren. Der Datei-Browser ermöglicht Benutzern, allgemeine Dateien wie Bilder, Animationen oder Mediendateien auf den Server zu laden und zu verwalten.';
$_lang["rb_title"] = 'Datei-Browser aktivieren';
$_lang["rb_webuser_message"] = 'Soll ein Web-Benutzer den Datei-Browser verwenden dürfen? <b>Hinweis:</b> Wenn Web-Benutzer den Datei-Browser verwenden dürfen, können sie alle Dateien einsehen auf die Manager-Benutzer Zugriff haben. Diese Möglichkeit sollte daher nur vertrauenswürdigen Web-Benutzern eingeräumt werden.';
$_lang["rb_webuser_title"] = 'Web-Benutzer?';
$_lang["recent_docs"] = 'Kürzlich bearbeitete Ressourcen';
$_lang["recommend_setting_change_title"] = 'Empfohlene Änderung der Konfiguration';
$_lang["recommend_setting_change_description"] = 'Ihre Seite überprüft momentan nicht die HTTP_REFERER von eingehenden Requests. Wir empfehlen dringend, diese Einstellung vorzunehmen, um das Risiko von CSRF-Attacken (Cross Site Request Forgery) zu reduzieren.';
$_lang["references"] = 'Referenzen';
$_lang["refresh_cache"] = 'Cache: <b>%s</b> Dateien wurden im Cache-Verzeichnis gefunden. Gelöschte Dateien <b>%d</b>.<p>Der Cache wird erneuert, sobald die Seiten das erste mal aufgerufen werden.';
$_lang["refresh_published"] = '<b>%s</b> Ressourcen wurden veröffentlicht.';
$_lang["refresh_site"] = 'Cache leeren';
$_lang["refresh_title"] = 'Website aktualisieren, Cache leeren';
$_lang["refresh_tree"] = 'Ressourcen-Baum aktualisieren';
$_lang["refresh_unpublished"] = '<b>%s</b> Ressourcen wurden zurückgezogen.';
$_lang["release_date"] = 'Veröffentlichungsdatum';
$_lang["remember_last_tab"] = 'Tabs merken';
$_lang["remember_last_tab_message"] = 'Manager Tabs laden den zuletzt geöffneten anstatt dem ersten Tab.';
$_lang["remember_username"] = 'Benutzername merken';
$_lang["remove"] = 'Entfernen';
$_lang["remove_date"] = 'Datum löschen';
$_lang["remove_locks"] = 'Sperren entfernen';
$_lang["rename"] = 'Umbenennen';
$_lang["reports"] = 'Berichte';
$_lang["report_issues"] = 'Probleme melden';
$_lang["require_tagname"] = 'Ein Tag-Name ist zwingend erforderlich';
$_lang["require_tagvalue"] = 'Ein Tag-Wert ist zwingend erforderlich';
$_lang["reserved_name_warning"] = 'Sie benutzen einen vorreservierten Namen.';
$_lang["reset"] = 'Zurücksetzen';
$_lang["reset_failedlogins"] = 'Zurücksetzen';
$_lang["reset_sort_order"] = 'Sortierung zurücksetzen';
$_lang["resource"] = 'Ressource';
$_lang["resource_alias"] = 'Ressource-Alias';
$_lang["resource_alias_help"] = 'Hier können Sie die URL der Ressource angeben um diese auch über http://beispiel.de/alias verfügbar zu machen. Funktioniert nur bei aktivierten benutzerfreundlichen URLs.';
$_lang["resource_content"] = 'Inhalt der Ressource';
$_lang["resource_description"] = 'Beschreibung';
$_lang["resource_description_help"] = 'Sie können hier eine optionale Beschreibung der Ressource eingeben.';
$_lang["resource_duplicate"] = 'Ressource duplizieren';
$_lang["resource_long_title_help"] = 'Hier können Sie einen längeren Titel für die Ressource eingeben. Der Langtitel kann für Header-Tags verwendet werden, nützlich für die Suchmaschinen-Indizierung sein und aussagekräftig Ihre Seite beschreiben.';
$_lang["resource_metatag_help"] = 'Wählen Sie jene Meta-Tags und Schlüsselwörter aus, die dieser Ressource zugeordnet werden sollen. Für eine Mehrfachauswahl halten Sie die STRG- / CTRL-Taste gedrückt.';
$_lang["resource_opt_contentdispo"] = 'Inhaltstyp';
$_lang["resource_opt_contentdispo_help"] = 'Mit diesem Feld können Sie festlegen, ob der Browser diese Ressource wie üblich im Browser-Fenster darstellt oder als Datei-Download anbietet.';
$_lang["resource_opt_emptycache"] = 'Cache leeren';
$_lang["resource_opt_emptycache_help"] = 'Eine Markierung dieses Feldes löscht den Cache für diese Ressource nach dem Speichern. Dadurch werden Ihre Besucher keine ältere Version der Ressource sehen.';
$_lang["resource_opt_folder"] = 'Container';
$_lang["resource_opt_folder_help"] = 'Markieren Sie diese Einstellung, wenn diese Ressource als Container für andere Ressourcen zur Verfügung stehen soll. Ein Container ist wie ein Ordner für weitere Ressourcen, kann selbst aber auch Inhalte enthalten.';
$_lang["resource_opt_menu_index"] = 'Menüindex';
$_lang["resource_opt_menu_index_help"] = 'Der Menüindex kann in Menü-Snippets die Position der Ressource in Menülisten bestimmen oder auch für jeden anderen Zweck in Snippets verwendet werden.';
$_lang["resource_opt_menu_title"] = 'Menütitel';
$_lang["resource_opt_menu_title_help"] = 'Im Menütitel kann optional ein kurzer Titel angegeben werden, der für Links zu dieser Ressource in Menü-Snippets verwendet wird.';
$_lang["resource_opt_published"] = 'Veröffentlicht';
$_lang["resource_opt_published_help"] = 'Markieren Sie diese Option, wenn Ihr Ressource direkt nach dem speichern veröffentlicht werden soll.';
$_lang["resource_opt_richtext"] = 'Rich-Text';
$_lang["resource_opt_richtext_help"] = 'Markieren Sie diese Option, wenn Sie zum Bearbeiten der Ressource den Rich-Text-Editor nutzen möchten. Fall Ihr Ressource Javascript oder Formulare beinhalten soll, deaktivieren Sie diese Option, damit der HTML-Editor Ihr Ressource nicht zerstört.';
$_lang["resource_opt_show_menu"] = 'Im Menü anzeigen';
$_lang["resource_opt_show_menu_help"] = 'Aktivieren Sie diese Option um die Ressource in Menülisten anzuzeigen. Setzt voraus, dass Ihre Menü-Snippets diese Angabe interpretieren.';
$_lang["resource_opt_trackvisit_help"] = 'Besucherzugriffe auf dieser Seite protokollieren';
$_lang["resource_overview"] = 'Ressourcen-Übersicht';
$_lang["resource_parent"] = 'Container';
$_lang["resource_parent_help"] = 'Klicken Sie auf eine Ressource im Baum, um diese als übergeordnete Ressource zu wählen.';
$_lang["resource_permissions_error"] = 'Weisen Sie diese Resource mindestens einer Ressourcen-Gruppe zu, zu der Sie Zugriff haben.';
$_lang["resource_setting"] = 'Ressourcen-Eigenschaften';
$_lang["resource_summary"] = 'Zusammenfassung';
$_lang["resource_summary_help"] = 'Geben Sie eine kurze inhaltliche Zusammenfassung der Ressource ein.';
$_lang["resource_title"] = 'Titel';
$_lang["resource_title_help"] = 'Geben Sie hier den Namen/Titel der Ressource ein. Vermeiden Sie die Benutzung von Backslashes im Namen!';
$_lang["resource_to_be_moved"] = 'Ressource, die verschoben werden soll';
$_lang["resource_type"] = 'Ressourcentyp';
$_lang["resource_type_message"] = 'Weblinks referenzieren andere Ressourcen im Internet ebenso wie andere EVO-Ressourcen, externe Websites, Bilder oder Dateien. Weblinks sollten vom Medientyp text/html sein und Inline-Content-Disposition haben.';
$_lang["resource_type_weblink"] = 'Weblink';
$_lang["resource_type_webpage"] = 'Website';
$_lang["resource_weblink_help"] = 'Geben Sie hier die Adresse des Objektes ein, welches Sie mit dem Weblink verlinken möchten. Alternativ können Sie den Datei-Browser verwenden, oder klicken Sie auf das Icon und wählen Sie eine Resource aus dem Resourcen-Baum.';
$_lang["resources_in_container"] = 'Ressourcen in diesem Container.';
$_lang["resources_in_container_no"] = 'Dieser Container enthält keine Unter-Ressourcen.';
$_lang["role"] = 'Rolle';
$_lang["role_about"] = 'Anzeige der „Über“-Seite';
$_lang["role_access_persmissions"] = 'Zugriffsberechtigungen';
$_lang["role_actionok"] = 'Ausgeführte Aktionen anzeigen';
$_lang["role_assets_images"] = 'assets/images verwalten';
$_lang["role_assets_files"] = 'assets/files verwalten';
$_lang["role_bk_manager"] = 'Backup-Manager benutzen';
$_lang["role_cache_refresh"] = 'Seitencache leeren';
$_lang["role_category_manager"] = 'Kategorie-Manager benutzen';
$_lang["role_change_password"] = 'Passwort ändern';
$_lang["role_change_resourcetype"] = 'Ressourcentyp ändern';
$_lang["role_chunk_management"] = 'Chunk-Management';
$_lang["role_config_management"] = 'Konfigurations-Verwaltung';
$_lang["role_content_management"] = 'Inhalts-Verwaltung';
$_lang["role_create_chunk"] = 'Neue Chunks erstellen';
$_lang["role_create_doc"] = 'Neue Ressourcen erstellen';
$_lang["role_create_plugin"] = 'Neue Plugins erstellen';
$_lang["role_create_snippet"] = 'Neue Snippets erstellen';
$_lang["role_create_template"] = 'Neue Templates erstellen';
$_lang["role_credits"] = 'Danksagungen';
$_lang["role_delete_chunk"] = 'Chunks löschen';
$_lang["role_delete_doc"] = 'Ressourcen löschen';
$_lang["role_delete_eventlog"] = 'Ereignisprotokoll löschen';
$_lang["role_delete_module"] = 'Module löschen';
$_lang["role_delete_plugin"] = 'Plugins löschen';
$_lang["role_delete_role"] = 'Rollen löschen';
$_lang["role_delete_snippet"] = 'Snippets löschen';
$_lang["role_delete_template"] = 'Templates löschen';
$_lang["role_delete_user"] = 'Manager-Benutzer löschen';
$_lang["role_delete_web_user"] = 'Web-Benutzer löschen';
$_lang["role_edit_chunk"] = 'Chunks bearbeiten';
$_lang["role_edit_doc"] = 'Ressourcen bearbeiten';
$_lang["role_edit_doc_metatags"] = 'Meta-Tags und Schlüsselwörter bearbeiten';
$_lang["role_edit_module"] = 'Module bearbeiten';
$_lang["role_edit_plugin"] = 'Plugins bearbeiten';
$_lang["role_edit_role"] = 'Rollen bearbeiten';
$_lang["role_edit_settings"] = 'Konfiguration bearbeiten';
$_lang["role_edit_snippet"] = 'Snippets bearbeiten';
$_lang["role_edit_template"] = 'Templates bearbeiten';
$_lang["role_edit_user"] = 'Manager-Benutzer bearbeiten';
$_lang["role_edit_web_user"] = 'Web-Benutzer bearbeiten';
$_lang["role_empty_trash"] = 'Gelöschte Ressourcen endgültig entfernen';
$_lang["role_errors"] = 'Fehlerdialoge anzeigen';
$_lang["role_eventlog_management"] = 'Ereignisverwaltung';
$_lang["role_export_static"] = 'Statisches HTML exportieren';
$_lang["role_file_management"] = 'Datei-Manager';
$_lang["role_file_manager"] = 'Datei-Manager (voller Root-Zugriff)';
$_lang["role_frames"] = 'Manager-Frames ermitteln';
$_lang["role_help"] = 'Anzeigen der Hilfeseiten';
$_lang["role_home"] = 'Manager Startseite ermitteln';
$_lang["role_import_static"] = 'HTML importieren';
$_lang["role_logout"] = 'Abmeldung aus dem MODX-Manager';
$_lang["role_manage_metatags"] = 'Meta-Tags und Schlüsselwörter verwalten';
$_lang["role_management_msg"] = 'Hier können Sie eine Rolle zum Bearbeiten wählen.';
$_lang["role_management_title"] = 'Rollen';
$_lang["role_messages"] = 'Nachrichten anzeigen und senden';
$_lang["role_module_management"] = 'Modul-Verwaltung';
$_lang["role_name"] = 'Rollenname';
$_lang["role_new_module"] = 'Neues Modul erstellen';
$_lang["role_new_role"] = 'Neue Rolle erstellen';
$_lang["role_new_user"] = 'Neuen Manager-Benutzer erstellen';
$_lang["role_new_web_user"] = 'Neuen Web-Benutzer erstellen';
$_lang["role_plugin_management"] = 'Plugin-Verwaltung';
$_lang["role_publish_doc"] = 'Ressource veröffentlichen';
$_lang["role_remove_locks"] = 'Sperren entfernen';
$_lang["role_role_management"] = 'Rollenverwaltung';
$_lang["role_run_module"] = 'Module ausführen';
$_lang["role_save_chunk"] = 'Chunks speichern';
$_lang["role_save_doc"] = 'Ressource speichern';
$_lang["role_save_module"] = 'Modul speichern';
$_lang["role_save_password"] = 'Passwort speichern';
$_lang["role_save_plugin"] = 'Plugins speichern';
$_lang["role_save_role"] = 'Rollen speichern';
$_lang["role_save_snippet"] = 'Snippet speichern';
$_lang["role_save_template"] = 'Template speichern';
$_lang["role_save_user"] = 'Manager-Benutzer speichern';
$_lang["role_save_web_user"] = 'Web-Benutzer speichern';
$_lang["role_snippet_management"] = 'Snippet-Verwaltung';
$_lang["role_template_management"] = 'Template-Verwaltung';
$_lang["role_title"] = 'Rolle erzeugen/bearbeiten';
$_lang["role_udperms"] = 'Rechteverwaltung';
$_lang["role_user_management"] = 'Manager-Benutzer verwalten';
$_lang["role_view_docdata"] = 'Ressource-Daten anzeigen';
$_lang["role_view_eventlog"] = 'Ereignisprotokoll anzeigen';
$_lang["role_view_logs"] = 'Systemlogs anzeigen';
$_lang["role_view_unpublished"] = 'Zeige unveröffentlichte Ressourcen';
$_lang["role_web_access_persmissions"] = 'Web-Benutzer-Zugriffskontrolle';
$_lang["role_web_user_management"] = 'Web-Benutzerverwaltung';
$_lang["rss_url_news_default"] = 'http://feeds.feedburner.com/evocms-release-news';
$_lang["rss_url_news_message"] = 'URL des EVO-News-Feeds eintragen.';
$_lang["rss_url_news_title"] = 'RSS-News-Feed';
$_lang["rss_url_security_default"] = 'http://feeds.feedburner.com/evocms-security-news';
$_lang["rss_url_security_message"] = 'URL des EVO-News-Feeds eintragen.';
$_lang["rss_url_security_title"] = 'RSS-Security-Feed';
$_lang["run_module"] = 'Modul starten';
$_lang["saturday"] = 'Samstag';
$_lang["save"] = 'Speichern';
$_lang["save_all_changes"] = 'Änderungen speichern';
$_lang["save_tag"] = 'Tag speichern';
$_lang["saving"] = 'Speichern, bitte warten …';
$_lang["search"] = 'Suchen';
$_lang["search_criteria"] = 'Suchkriterium';
$_lang["search_criteria_content"] = 'Suche im Inhalt';
$_lang["search_criteria_content_msg"] = 'Findet alle Ressource in deren Inhalt der eingegebene Text vorkommt.';
$_lang["search_criteria_id"] = 'Suche nach ID';
$_lang["search_criteria_id_msg"] = 'Findet die Ressource dessen ID mit der eingegebenen übereinstimmt.';
$_lang["search_criteria_top"] = 'Hauptfelder durchsuchen';
$_lang["search_criteria_top_msg"] = 'Titel, langer Title, Alias, ID';
$_lang["search_criteria_template_id"] = 'Suche nach Template ID';
$_lang["search_criteria_template_id_msg"] = 'Findet alle Ressourcen die das Template mit der angegebenen ID benutzen.';
$_lang["search_criteria_url_msg"] = 'Finde Ressource durch exakte URL';
$_lang["search_criteria_longtitle"] = 'Suche nach Langtitel';
$_lang["search_criteria_longtitle_msg"] = 'Findet alle Ressource in deren Langtitel der eingegebene Text vorkommt.';
$_lang["search_criteria_title"] = 'Suche nach Titel';
$_lang["search_criteria_title_msg"] = 'Findet alle Ressourcen in deren Titel der eingegebene Text vorkommt.';
$_lang["search_empty"] = 'Ihre Suche ergab keine Treffer. Bitte ändern Sie Ihre Suchanfrage und versuchen Sie es noch einmal.';
$_lang["search_item_deleted"] = 'Diese Ressource wurde gelöscht';
$_lang["search_results"] = 'Suchergebnisse';
$_lang["search_results_returned_desc"] = 'Beschreibung';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Ihre Suchanfrage ergab <b>%s</b> Treffer. Wenn zu viele Ergebnisse gefunden wurden, versuchen Sie die Suche zu verfeinern. Das erste Symbol in jeder Spalte zeigt Ihnen die Ressource-Postion im Baum an. Ganz rechts können Sie den Ressource-Status ablesen.';
$_lang["search_results_returned_title"] = 'Titel';
$_lang["search_view_docdata"] = 'Diese Ressource anzeigen';
$_lang["security"] = 'Benutzer';
$_lang["security_notices_tab"] = 'Sicherheitsmeldungen';
$_lang["security_notices_title"] = 'Sicherheitsmeldungen';
$_lang["select_date"] = 'Datum auswählen';
$_lang["send"] = 'Senden';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Falls Sie eine https-Verbindung nutzen möchten, geben Sie dies hier an.';
$_lang["server_protocol_title"] = 'Servertyp';
$_lang["serveroffset"] = 'Server-Zeitverschiebung';
$_lang["serveroffset_message"] = 'Wählen Sie die Anzahl der Stunden, die zwischen der Server-Zeit und Ihrer Ortszeit liegen. Die derzeitige Server-Zeit ist <b>[%s]</b>, die derzeitige Server-Zeit bei Nutzung der Zeitverschiebung ist <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Server-Zeitverschiebung';
$_lang["servertime"] = 'Server-Zeit';
$_lang["set_automatic"] = 'Automatisch einstellen';
$_lang["set_default"] = 'Zurücksetzen';
$_lang["set_default_all"] = 'Alle zurücksetzen';
$_lang["settings_after_install"] = 'Da es sich um eine neue Installation handelt, ist es erforderlich dass Sie diese Einstellungen prüfen und gegebenenfalls anpassen. Drücken Sie danach auf \'Speichern\'.';
$_lang["settings_config"] = 'Konfiguration';
$_lang["settings_dependencies"] = 'Abhängigkeiten';
$_lang["settings_events"] = 'Systemereignisse';
$_lang["settings_furls"] = 'Benutzerfreundliche URL';
$_lang["settings_general"] = 'Allgemein';
$_lang["settings_group_tv_message"] = 'Wählen Sie aus ob Template-Variablen in Sektionen oder Tabs (benannt nach TV-Kategorien) gruppiert werden sollen beim Editieren von Ressourcen.';
$_lang["settings_group_tv_options"] = 'Nein,Sektionen im Allgemein-Tab,Tabs im Allgemein-Tab,Sektionen in neuem Tab,Tabs in neuem Tab,Neue Tabs';
$_lang["settings_misc"] = 'Sonstiges';
$_lang["settings_security"] = 'Sicherheit';
$_lang["settings_KC"] = 'Datei-Browser';
$_lang["settings_page_settings"] = 'Seiteneinstellungen';
$_lang["settings_photo"] = 'Foto';
$_lang["settings_properties"] = 'Eigenschaften';
$_lang["show_fullscreen_btn_message"] = 'Button "Vollbild-Modus" anzeigen';
$_lang["show_newresource_btn_message"] = 'Button "Neue Ressource" anzeigen';
$_lang["settings_show_picker_message"] = 'Ermöglicht die Anpassung des Manager-Templates und Speicherung via localStorage.';
$_lang["show_fullscreen_btn"] = 'Vollbild-Modus';
$_lang["show_newresource_btn"] = 'Neue Ressource';
$_lang["settings_site"] = 'Seiten';
$_lang["settings_strip_image_paths_message"] = 'Mit dieser Einstellung werden die Bildpfade relativ statt absolut gesetzt. Das ist sehr empfehlenswert wenn die Installation umgezogen wird (z.B. von der Entwicklungsseite zur Produktionsseite). Wenn Sie nicht wissen was gemeint ist – lassen Sie die Einstellung auf „Nein“.';
$_lang["settings_strip_image_paths_title"] = 'Bild-Pfade zurückschreiben?';
$_lang["settings_templvars"] = 'Template-Variablen';
$_lang["settings_title"] = 'MODX-Konfiguration';
$_lang["settings_ui"] = 'Benutzeroberfläche';
$_lang["settings_users"] = 'Benutzer';
$_lang["show_meta"] = 'META Keywords Tab anzeigen';
$_lang["show_meta_message"] = 'Den (in Zukunft nicht mehr unterstützten) META Keywords Tab beim Ressource bearbeiten anzeigen.';
$_lang["show_tree"] = 'Baum anzeigen';
$_lang["show_picker"] = 'Aktiviere Farbwähler';
$_lang["showing"] = 'Anzeige';
$_lang["signupemail_message"] = 'Hier können Sie die Vorlage der E-Mail eingeben, die das System automatisch an Ihre Benutzer schickt, wenn die entsprechenden Benutzerkonten erstellt werden. Folgende Platzhalter werden vom System ersetzt, wenn die Nachricht versendet wird:<br /> <br />[+sname+] – Name dieser Website<br />[+saddr+] – E-Mail-Adresse des Webmasters<br />[+surl+] – URL der Website<br />[+uid+] – Name des Benutzerkontos<br />[+pwd+] – Passwort des Benutzerkontos<br />[+ufn+] – Name des Benutzers<br /><br /><b>Hinweis:</b>Sie sollten auf jeden Fall [+uid+] und [+pwd+] in der Vorlage anführen, damit Ihre Benutzer auch die entsprechenden Anmeldedaten erhalten.';
$_lang["signupemail_title"] = 'Aktivierungs-E-Mail';
$_lang["site"] = 'Website';
$_lang["site_schedule"] = 'Terminplan';
$_lang["sitename_message"] = 'Geben Sie den Namen Ihrer Website ein.';
$_lang["sitename_title"] = 'Website-Name';
$_lang["sitestart_message"] = 'Geben Sie die ID der Ressource ein, welche die Startseite sein soll. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist!';
$_lang["sitestart_title"] = 'Startseite';
$_lang["sitestatus_message"] = 'Wählen Sie „Online“, um Ihre Seite zu veröffentlichen. Wenn Sie „Offline“ wählen wird den Besuchern Ihrer Seite die „Seite zur Zeit nicht erreichbar“ angezeigt.';
$_lang["sitestatus_title"] = 'Status der Seite';
$_lang["siteunavailable_message"] = 'Diese Nachricht wird angezeigt, wenn Sie Ihre Seite „Offline“ geschaltet haben oder ein Fehler auftritt.';
$_lang["siteunavailable_message_default"] = 'Diese Seite ist derzeit nicht verfügbar.';
$_lang["siteunavailable_page_message"] = 'Geben Sie die Ressource-ID der Ressource ein, die beim Status „Offline“ angezeigt werden soll. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist!';
$_lang["siteunavailable_page_title"] = 'Offline-Seite';
$_lang["siteunavailable_title"] = 'Seite nicht erreichbar';
$_lang["snippet"] = 'Snippet';
$_lang["snippets"] = 'Snippets';
$_lang["snippet_code"] = 'Snippet-Code (PHP)';
$_lang["snippet_desc"] = 'Snippet-Beschreibung';
$_lang["snippet_execonsave"] = 'Snippet nach dem Speichern ausführen.';
$_lang["snippet_management_msg"] = 'Hier können Sie ein Snippet wählen, das Sie bearbeiten möchten.';
$_lang["snippet_msg"] = 'Hier können Sie Snippets anlegen und bearbeiten. Beachten Sie, dass Snippets reiner PHP-Code sind. Wenn das Snippet einen Wert in einem Template oder einer Ressource ausgeben soll, müssen Sie diesen wert innerhalb des Snippets mit PHP ausgeben.';
$_lang["snippet_name"] = 'Snippet-Name';
$_lang["snippet_properties"] = 'Standardeigenschaften';
$_lang["snippet_title"] = 'Snippet erstellen/bearbeiten';
$_lang["sort_alphabetically"] = 'Alphabetisch sortieren';
$_lang["sort_asc"] = 'Aufsteigend';
$_lang["sort_desc"] = 'Absteigend';
$_lang["sort_menuindex"] = 'Menüindex sortieren';
$_lang["sort_tree"] = 'Baum sortieren';
$_lang['sort_updating'] = 'Wird aktualisiert ...';
$_lang['sort_updated'] = 'Aktualisierung beendet!';
$_lang['sort_nochildren'] = 'Dieser Container enthält keine Unter-Ressourcen.';
$_lang["sort_elements_msg"] = 'Reihenfolge der aufgelisteten Elemente durch Drag&Drop sortieren.';
$_lang["source"] = 'Quelle';
$_lang["stay"] = 'Bearbeitung fortsetzen';
$_lang["stay_new"] = 'Weiter hinzufügen';
$_lang["submit"] = 'Absenden';
$_lang["sunday"] = 'Sonntag';
$_lang["sys_alert"] = 'Systemalarm';
$_lang["sysinfo_activity_message"] = 'Die Liste zeigt Ihnen die zuletzt bearbeiteten Dateien.';
$_lang["sysinfo_userid"] = 'Benutzer';
$_lang["system"] = 'System';
$_lang["system_email_signup"] = '<!doctype html>
<html>
Hallo [+uid+]

hier sind Ihren Anmeldedetails für [+sname+] :

Benutzername: [+uid+]
Passwort: [+pwd+]

Sobald Sie sich im Manager ([+surl+]) angemeldet haben, können Sie Ihr Passwort ändern.

Mit freundlichen Grüßen,
Ihr Website-Administrator
</html>';
$_lang["system_email_webreminder"] = 'Hallo [+uid+]!

Um Ihr neues Passwort zu aktivieren, klicken Sie bitte auf folgenden Link

[+surl+]

Wenn alles erfolgreich war, können Sie danach das folgende Passwort zum Anmelden verwenden:

Passwort: [+pwd+]

Wenn Sie diese E-Mail unverlangt bekommen, ignorieren Sie sie bitte einfach.

Mit freundlichen Grüßen
Ihr Website-Administrator';
$_lang["system_email_websignup"] = 'Hallo [+uid+]!

Hier sind Ihre Anmeldendaten für [+sname+]:

Benutzername: [+uid+]
Passwort: [+pwd+]

Sobald Sie sich in Ihrem Account ([+surl+]) angemeldet haben, können Sie Ihr Passwort ändern.

Mit freundlichen Grüßen
Ihr Website-Administrator';
$_lang["table_hoverinfo"] = 'Wenn Sie mit dem Mauszeiger über einen Tabellennamen fahren, wird Ihnen (sofern verfügbar) eine kurze Beschreibung der Funktion dieser Tabelle angezeigt.';
$_lang["table_prefix"] = 'Tabellen-Präfix';
$_lang["tag"] = 'Tag';
$_lang["template"] = 'Template';
$_lang["templates"] = 'Templates';
$_lang["template_assignedtv_tab"] = 'Zugewiesene Template-Variablen';
$_lang["template_code"] = 'Template-Code (HTML)';
$_lang["template_desc"] = 'Template-Beschreibung';
$_lang["template_edit_tab"] = 'Template bearbeiten';
$_lang["template_management_msg"] = 'Hier können Sie ein Template wählen, das Sie bearbeiten möchten.';
$_lang["template_msg"] = 'Hier können Sie Templates anlegen und bearbeiten. Die Änderung an einem Template wird nur angezeigt, wenn Sie den Cache leeren. Sie können aber die Vorschaufunktion nutzen, um das Template anzuzeigen.';
$_lang["template_name"] = 'Template-Name';
$_lang["template_no_tv"] = 'Diesem Template wurden noch keine Template-Variablen zugewiesen.';
$_lang["template_notassigned_tv"] = 'Diese Template-Variablen können zugewiesen werden.';
$_lang["template_reset_all"] = 'Alle Ressourcen auf das Standard-Template zurücksetzen';
$_lang["template_reset_specific"] = 'Template nur bei Ressourcen mit dem aktuellen Template „%s“ setzen';
$_lang["template_assigned_blade_file"] = 'Entsprechende blade-datei';
$_lang["template_create_blade_file"] = 'Erstellen Sie beim Speichern eine Vorlagendatei';
$_lang["template_selectable"] = 'Template ist auswählbar, wenn eine Resource erstellt oder bearbeitet wird.';
$_lang["template_title"] = 'Template erstellen/bearbeiten';
$_lang["template_tv_edit"] = 'Reihenfolge der Template-Variablen bearbeiten';
$_lang["template_tv_edit_message"] = 'Reihenfolge der Template-Variablen für dieses Template durch Drag & Drop sortieren.';
$_lang["template_tv_edit_title"] = 'Reihenfolge Template-Variablen';
$_lang["template_tv_msg"] = 'Liste der Template-Variablen, die diesem Template zugeordnet wurden.';
$_lang["thursday"] = 'Donnerstag';
$_lang["tmplvar_access_msg"] = 'Wählen Sie jene Ressourcen-Gruppen aus, die diese Template-Variable bearbeiten dürfen.';
$_lang["tmplvar_change_template_msg"] = 'Wenn Sie das Template ändern, werden die Template-Variablen neu geladen. Achtung: alle nicht gespeicherten Änderungen gehen hierbei verloren!\n\nSind Sie sicher, dass Sie das Template ändern möchten?';
$_lang["tmplvar_inuse"] = 'Folgende Ressourcen verwenden derzeit diese Template-Variable. Wollen Sie mit dem Löschen fortfahren?';
$_lang["tmplvar_tmpl_access"] = 'Template-Berechtigungen';
$_lang["tmplvar_tmpl_access_msg"] = 'Wählen Sie hier jene Templates aus, die diese Template-Variable verarbeiten dürfen.';
$_lang["tmplvar"] = 'Template-Variable';
$_lang["tmplvars"] = 'Template-Variablen';
$_lang["tmplvars_binding_msg"] = 'Dieses Feld unterstützt Datenbindung mittels des @ Befehls';
$_lang["tmplvars_caption"] = 'Bezeichnung';
$_lang["tmplvars_default"] = 'Standardwert';
$_lang["tmplvars_description"] = 'Beschreibung';
$_lang["tmplvars_elements"] = 'Eingabeoptionswerte';
$_lang["tmplvars_inherited"] = 'Wert geerbt';
$_lang["tmplvars_management_msg"] = 'Hier können Sie Ihre Template-Variablen bearbeiten.';
$_lang["tmplvars_msg"] = 'Hier können Sie Template-Variablen erstellen und bearbeiten. Die Template-Variablen müssen für die jeweiligen Templates aktiviert werden, damit Snippets und Ressourcen darauf wie normale Variablen zugreifen können.';
$_lang["tmplvars_name"] = 'Name der Template-Variable';
$_lang["tmplvars_novars"] = 'Keine Template-Variablen gefunden';
$_lang["tmplvars_rank"] = 'Sortierung';
$_lang["tmplvars_rank_edit_message"] = 'Reihenfolge der aufgelisteten Template-Variablen durch Drag&Drop sortieren.';
$_lang["tmplvars_reset_params"] = 'Parameter zurücksetzen';
$_lang["tmplvars_title"] = 'Template-Variable erstellen/bearbeiten';
$_lang["tmplvars_type"] = 'Eingabetyp';
$_lang["tmplvars_widget"] = 'Objektauswahl';
$_lang["tmplvars_widget_prop"] = 'Objekt Eigenschaften';
$_lang["to"] = 'bis';
$_lang["toggle_fullscreen"] = 'Vollbild-Modus';
$_lang["tools"] = 'Werkzeuge';
$_lang["top_howmany_message"] = 'Die Länge der Top Liste. Zum Beispiel: Top 10 Liste.';
$_lang["top_howmany_title"] = 'Top Liste';
$_lang["total"] = 'insgesamt';
$_lang["track_visitors_message"] = 'Die Protokollierung der Besucher ermöglicht die Erstellung einer Besucherstatistik, es verlangsamt allerdings die Darstellung der Seite ein wenig .';
$_lang["track_visitors_title"] = 'Besucherprotokollierung';
$_lang["tree_page_click"] = 'Klickverhalten';
$_lang["tree_page_click_message"] = 'Standardverhalten beim Klicken im Manager Tree.';
$_lang["use_breadcrumbs"] = 'Brotkrumenpfad anzeigen';
$_lang["use_breadcrumbs_message"] = 'Zeigt einen Brotkrumenpfad an wenn eine Resource erstellt oder bearbeitet wird.';
$_lang["tree_show_protected"] = 'Zeige geschützte Ressourcen';
$_lang["tree_show_protected_message"] = 'Wenn auf „Nein“ gesetzt, erscheinen geschützte Ressourcen (inklusive der Unter-Ressourcen) nicht im Strukturbaum, das heißt Manager-Benutzer ohne Berechtigung diese Ressourcen zu bearbeiten sehen sie nicht. „Nein“ ist die Standardeinstellung.';
$_lang["truncate_table"] = 'Klicken Sie hier, um die Tabelle zu schließen';
$_lang["tuesday"] = 'Dienstag';
$_lang["tv"] = 'TV';
$_lang["type"] = 'Typ';
$_lang["udperms_allowroot_message"] = 'Möchten Sie Ihren Benutzern die Erstellung von Ressourcen im Hauptverzeichnis der Seite erlauben? ';
$_lang["udperms_allowroot_title"] = 'Hauptverzeichnis-Erlaubnis';
$_lang["udperms_message"] = 'Die Zugriffskontrolle erlaubt Ihnen festzulegen, welche Seiten von welchem Benutzer bearbeitet werden können. Die Zugriffskontrolle erlaubt Ihnen mit Hilfe von Benutzergruppen und Ressourcen-Gruppen festzulegen, welche Seiten von welchem Benutzer bearbeitet werden können.';
$_lang["udperms_title"] = 'Benutzerzugriffskontrolle';
$_lang["unable_set_link"] = 'Der Link konnte nicht gesetzt werden!';
$_lang["unable_set_parent"] = 'Setzen des neuen Containers nicht möglich!';
$_lang["unauthorizedpage_message"] = 'Geben Sie die ID der Ressource an, zu welchem Benutzer bei einem unautorisierten Zugriff weitergeleitet werden. <b>Hinweis:</b> Stellen Sie sicher, das diese Ressource vorhanden und veröffentlicht ist!';
$_lang["unauthorizedpage_title"] = 'unautorisierter Zugriff';
$_lang["unblock_message"] = 'Dieser Benutzer wird freigeschaltet sein, nachdem Sie die Benutzerdaten gespeichert haben.';
$_lang["undelete_resource"] = 'Wiederherstellen';
$_lang["unpublish_date"] = 'Termin zum Zurückziehen';
$_lang["unpublish_events"] = 'Zurückziehungen';
$_lang["unpublish_resource"] = 'Zurückziehen';
$_lang["untitled_resource"] = 'Unbenannte Ressource';
$_lang["untitled_weblink"] = 'Unbenannter Web-Link';
$_lang["update_params"] = 'Parameteranzeige aktualisieren';
$_lang["update_settings_from_language"] = 'Aktuelle ersetzen durch:';
$_lang["upload_maxsize_message"] = 'Geben Sie hier die maximale Dateigröße für den Datei-Upload mit dem Datei-Manager an. Die Größenangabe ist in Bytes. <b>Achtung: je größer die Datei desto länger dauert der Upload!</b>';
$_lang["upload_maxsize_title"] = 'Maximale Upload-Dateigröße';
$_lang["uploadable_files_message"] = 'Hier können Sie angeben welche Dateitypen über den Filemanager hochgeladen werden können. Bitte geben Sie die Dateierweiterungen mit Komma getrennt ein.';
$_lang["uploadable_files_title"] = 'Hochladbare Dateitypen';
$_lang["uploadable_flash_message"] = 'Datei-Upload nach „assets/flash/“ mit dem Datei-Browser. Mehrere Dateien bitte mit Komma trennen.';
$_lang["uploadable_flash_title"] = 'Hochladbare Flash-Dateien';
$_lang["uploadable_images_message"] = 'Bilder-Upload nach „assets/images/“ mit dem Datei-Browser. Mehrere Dateien bitte mit Komma trennen.';
$_lang["uploadable_images_title"] = 'Hochladbare Bildformate';
$_lang["uploadable_media_message"] = 'Medien-Upload nach „assets/media/“ mit dem Datei-Browser. Mehrere Dateien bitte mit Komma trennen.';
$_lang["uploadable_media_title"] = 'Hochladbare Medien-Formate';
$_lang["use_alias_path_message"] = 'Wenn Sie diese Option mit „Ja“ einstellen, werden Ihre Ressourcen mit den vollen Pfadangaben angezeigt, falls Ihre Ressourcen ein Alias eingetragen haben. Beispiel: Eine Ressource mit dem Alias „Kind“ ist innerhalb des Containers mit dem Alias „Eltern“ abgelegt. Die URL für diese Ressource würde nun http://beispiel.de/Eltern/Kind.html lauten.';
$_lang["use_alias_path_title"] = 'Benutze benutzerfreundliche Alias-Pfadangaben';
$_lang["use_editor_message"] = 'Möchten Sie den Rich-Text-Editor benutzen? Wenn Sie HTML schreiben möchten, deaktivieren Sie diese Einstellung. Diese Einstellung gilt für alle Benutzer und Ressourcen.';
$_lang["use_editor_title"] = 'Editor aktivieren';
$_lang["use_global_tabs"] = 'Globale Tabs verwenden';
$_lang["user"] = 'Benutzer';
$_lang["user_block"] = 'Deaktiviert';
$_lang["user_blockedafter"] = 'Gesperrt ab';
$_lang["user_blockeduntil"] = 'Gesperrt bis';
$_lang["user_changeddata"] = 'Ihre Daten wurden geändert. Bitte melden Sie sich erneut an.';
$_lang["user_country"] = 'Land';
$_lang["user_dob"] = 'Geburtsdatum';
$_lang["user_doesnt_exist"] = 'Benutzer existiert nicht.';
$_lang["user_edit_self_msg"] = 'Eventuell müssen Sie sich ab- und wieder anmelden, nachdem Sie Ihre Daten geädert haben.';
$_lang["user_email"] = 'E-Mail-Adresse';
$_lang["user_failedlogincount"] = 'Fehlgeschlagene Anmeldungen';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'weiblich';
$_lang["user_full_name"] = 'Name';
$_lang["user_gender"] = 'Geschlecht';
$_lang["user_is_blocked"] = 'Dieser Benutzer ist deaktiviert!';
$_lang["user_logincount"] = 'Anzahl der Logins';
$_lang["user_male"] = 'männlich';
$_lang["user_management_msg"] = 'Hier können Sie einen Benutzer zur Bearbeitung auswählen.';
$_lang["user_management_title"] = 'Manager-Benutzer';
$_lang["user_mobile"] = 'Handynummer';
$_lang["user_phone"] = 'Telefonnummer';
$_lang["user_photo"] = 'Benutzerfoto';
$_lang["user_photo_message"] = 'Geben Sie wahlweise eine URL an oder einen lokalen Pfad für Datei-Upload an.';
$_lang["user_prevlogin"] = 'Letzte Anmeldung';
$_lang["user_role"] = 'Benutzerrolle';
$_lang["user_state"] = 'Region';
$_lang["user_title"] = 'Manager-Benutzer erstellen/bearbeiten';
$_lang["user_upload_message"] = 'Wenn Sie diesem Benutzer das Hochladen jeglicher Dateitypen untersagen wollen, stellen Sie sicher, dass die „Einstellungen der Systemkonfiguration benutzen“-Checkbox nicht ausgewählt ist und lassen Sie das Feld leer.';
$_lang["user_use_config"] = 'Einstellungen der Systemkonfiguration benutzen';
$_lang["user_zip"] = 'PLZ';
$_lang["username"] = 'Benutzername';
$_lang["users"] = 'Benutzer';
$_lang["valid_hostnames_message"] = 'Verhindern Sie den Missbrauch der site_url Systemeinstellung für eine XSS-Attacke (Cross Site Scripting), indem sie eine durch Kommata getrennte Liste von gültigen Hostnamen für diese Installation angeben. Diese Attacken sind bei bestimmten Shared Host Konfiguationen und bei direkt über eine IP zugänglichen Hosts möglich. Es wird der erste Hostname in der Liste verwendet, wenn der HTTP_HOST keinem gültigen Hostnamen entspricht.';
$_lang["valid_hostnames_title"] = 'Gültige Hostnamen';
$_lang["validate_referer_message"] = 'Die HTTP_REFERER-Header können überprüft werden um das Risiko zu verringern, dass Inhaltsredakteure Opfer eines CSRF-Angriffs (Cross Site Request Forgery) werden und unbeabsichtigte Aktionen im Manager durchführen. Einige Konfigurationen unterstützen diese Option nicht, wenn der Server keine HTTP_REFERER-Header sendet.';
$_lang["validate_referer_title"] = 'HTTP_REFERER-Header überprüfen?';
$_lang["value"] = 'Wert';
$_lang["version"] = 'Version';
$_lang["view"] = 'Ansehen';
$_lang["view_child_resources_in_container"] = 'Ressourcen in Container anzeigen';
$_lang["view_log"] = 'Protokoll anzeigen';
$_lang["view_logging"] = 'Benutzerprotokoll';
$_lang["view_sysinfo"] = 'Systeminfo';
$_lang["warning"] = 'Warnung!';
$_lang["warning_not_saved"] = 'Die Änderungen an Ihrer Ressource wurden bis jetzt nicht gespeichert. Sie können zur vorherigen Ansicht zurück wechseln oder die Ansicht verlassen. Ihre geänderten Daten gehen dann verloren.';
$_lang["warning_visibility"] = 'Konfigurationswarnungen sind sichtbar für';
$_lang["warning_visibility_message"] = 'Steuerung der Konfigurationswarnungen auf der Manager-Startseite';
$_lang["web_access_permissions"] = 'Web-Benutzer-Zugriffsberechtigungen';
$_lang["web_access_permissions_user_groups"] = 'Web-Benutzergruppen';
$_lang["web_permissions"] = 'Web-Berechtigungen';
$_lang["web_user_management_msg"] = 'Hier können Sie auswählen, welche Web-Benutzer Sie bearbeiten möchten. Web-Benutzer können sich nur an der Website anmelden, nicht jedoch im MODX-Manager.';
$_lang["web_user_management_title"] = 'Web-Benutzer';
$_lang["web_user_title"] = 'Web-Benutzer erstellen/bearbeiten';
$_lang["web_users"] = 'Web-Benutzer';
$_lang["weblink"] = 'Web-Link';
$_lang["webpwdreminder_message"] = 'Definieren Sie hier die Vorlage der E-Mail, die Ihre Web-Benutzer erhalten wenn sie ein neues Passwort anfordern. Folgende Platzhalter werden vom System ersetzt, wenn die Nachricht versendet wird:<br /><br />[+sname+] – Name dieser Website<br />[+saddr+] – E-Mail-Adresse des Website Verwalters<br />[+surl+] – URL der Website<br />[+uid+] – Name des Benutzerkontos<br />[+pwd+] – Passwort des Benutzerkontos<br />[+ufn+] – Name des Benutzers<br /><br /><b>Hinweis:</b>Sie sollten auf jeden Fall [+uid+] und [+pwd+] in der Vorlage anführen, damit Ihre Web-Benutzer auch die entsprechenden Anmeldedaten erhalten!';
$_lang["webpwdreminder_title"] = 'Erinnerungs-E-Mail';
$_lang["websignupemail_message"] = 'Hier können Sie die Nachricht definieren, die an Ihre Benutzer geschickt wird, wenn sie sich anmelden. Folgende Platzhalter werden vom System ersetzt, wenn die Nachricht versendet wird:<br /><br />[+sname+] – Name dieser Website<br />[+saddr+] – E-Mail-Adresse des Website Verwalters<br />[+surl+] – URL der Website<br />[+uid+] – Name des Benutzerkontos<br />[+pwd+] – Passwort des Benutzerkontos<br />[+ufn+] – Name des Benutzers<br /><br /><b>Hinweis:</b> Sie sollten auf jedenfall [+uid+] und [+pwd+] in der Vorlage anführen, damit Ihre Web-Benutzer auch die entsprechenden Anmeldedaten erhalten!';
$_lang["websignupemail_title"] = 'Registrierungsbestätigung';
$_lang["allow_multiple_emails_title"] = 'Doppelte Emailadressen für Web-Benutzer erlauben';
$_lang["allow_multiple_emails_message"] = 'Erlaubt es Web-Benutzern dieselbe Emailadresse für mehrere Benutzerkonten zu verwenden, zum Beispiel wenn einem Benutzer seine eigene Emailadresse nicht zur Verfügung steht oder es nur eine einzige Familien-Emailadresse gibt.<br/>Achtung: Sämtliche Passwort-Wiederherstellungs- und Registrierungs-Funktionen müssen von vornherein diese Einstellung beachten.';
$_lang["wednesday"] = 'Mittwoch';
$_lang["welcome_messages"] = 'Ihr Posteingang enthält <b>%d</b> Nachricht(en). <b>%s</b> davon sind ungelesen.';
$_lang["welcome_title"] = 'Willkommen im EVO Manager';
$_lang["which_editor_message"] = 'Hier legen Sie fest welchen Rich-Text-Editor Sie verwenden wollen. Sie können weitere RTEs auf der EVO Download-Seite finden.';
$_lang["which_editor_title"] = 'Eingesetzter Editor';
$_lang["working"] = 'Arbeite …';
$_lang["wrap_lines"] = 'Automatischer Zeilenumbruch';
$_lang["xhtml_urls_message"] = 'Ersetzt „&amp;“-Zeichen in URLs, die von EVO erzeugt werden mit validen &<!-- -->amp; HTML-Entities.';
$_lang["xhtml_urls_title"] = 'XHTML-URLs';
$_lang["yes"] = 'Ja';
$_lang["you_got_mail"] = 'Sie haben eine E-Mail erhalten';
$_lang["yourinfo_message"] = 'Dieser Bereich zeigt Ihnen einige Informationen über Sie:';
$_lang["yourinfo_previous_login"] = 'Ihre letzte Anmeldung:';
$_lang["yourinfo_role"] = 'Ihre Rolle ist:';
$_lang["yourinfo_title"] = 'Ihre Informationen';
$_lang["yourinfo_total_logins"] = 'Anzahl der Anmeldungen:';
$_lang["yourinfo_username"] = 'Sie sind angemeldet als:';

$_lang["a17_error_reporting_title"] = 'PHP-Warnungen/Fehler';
$_lang["a17_error_reporting_msg"] = 'PHP-Warnungen/Fehler mit dieser Stufe erkennen.';
$_lang["a17_error_reporting_opt0"] = 'Alle PHP-Warnungen/Fehler ignorieren';
$_lang["a17_error_reporting_opt1"] = 'Geringfügige PHP-Warnungen ignorieren (<a href="https://www.google.com/search?q=E_DEPRECATED+E_STRICT" target="_blank">E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT</a>)';
$_lang["a17_error_reporting_opt2"] = 'Alle PHP-Warnungen/Fehler außer E_NOTICE erkennen';
$_lang["a17_error_reporting_opt99"] = 'Alle PHP-Warnungen/Fehler erkennen';

$_lang["pwd_hash_algo_title"] = 'Hash Algorithmus';
$_lang["pwd_hash_algo_message"] = 'Algorithmus für den Passwort-Hash.';

$_lang["enable_bindings_title"] = '@Bindings aktivieren';
$_lang["enable_bindings_message"] = 'Verhindert die Ausführung von PHP-Code innerhalb von @Bindings in Template-Variablen. Nützlich, wenn Sie Manager-Benutzer haben, die keinen PHP-Code einsetzen dürfen, aber Template-Variablen bearbeiten und erstellen dürfen. Die Ausgabe einer Template-Variable mit @Binding lautet in diesem Fall „@Bindings disabled“.';
$_lang["enable_filter_title"] = 'Filter/Modifier aktivieren';
$_lang["enable_filter_message"] = 'Filter ermöglichen es, Inhalte von MODX-Tags / TVs innerhalb Ihrer Templates dynamisch zu manipulieren, analog zu PHx. <a href="https://github.com/modxcms/evolution/issues/623" target="ext_help">Mehr Informationen</a>'; // todo: change link to documentation
$_lang["enable_filter_phx_warning"] = 'Bei aktiviertem PHx-Plugin sind die nativen MODX-Filter standardmäßig deaktiviert.';

$_lang["enable_filter_phx_warning"] = 'Bei aktiviertem PHx-Plugin sind die nativen MODX-Filter standardmäßig deaktiviert.';

$_lang["enable_at_syntax_title"] = '&lt;@SYNTAX&gt; aktivieren';
$_lang["enable_at_syntax_message"] = '&lt;@SYNTAX&gt;(atmark syntax) ist eine simple Template-Syntax.';

$_lang["bkmgr_alert_mkdir"] = 'Es konnte keine Wiederherstellungs-Datei erstellt werden. Bitte überprüfen Sie die Verzeichnis-Rechte von [+snapshot_path+]';
$_lang["bkmgr_restore_msg"] = '<p>Einzelne Tabellen dieser Installation können mit SQL Befehlen wiederhergestellt werden.</p>';
$_lang["bkmgr_restore_title"] = 'Wiederherstellen';
$_lang["bkmgr_import_ok"] = 'Die Wiederherstellung wurde erfolgreich durchgeführt.';
$_lang["bkmgr_snapshot_ok"] = 'Ein Wiederherstellungspunkt wurde erfolgreich gespeichert.';
$_lang["bkmgr_run_sql_file_label"] = 'SQL Datei hochladen';
$_lang["bkmgr_run_sql_direct_label"] = 'SQL Befehle direkt ausführen';
$_lang["bkmgr_run_sql_submit"] = 'SQL Befehle ausführen';
$_lang["bkmgr_run_sql_result"] = 'Ergebnis';
$_lang["bkmgr_snapshot_title"] = 'Wiederherstellungspunkt speichern und laden';
$_lang["bkmgr_snapshot_msg"] = '<p>Der Inhalt der Datenbank wird in einer Datei gespeichert und kann von dort wiederhergestellt werden.<br />Speicherplatz: [+snapshot_path+] ($modx->config[\'snapshot_path\'])</p>';
$_lang["bkmgr_snapshot_submit"] = 'Wiederherstellungspunkt hinzufügen';
$_lang["bkmgr_snapshot_list_title"] = 'Liste der Wiederherstellungspunkte';
$_lang["bkmgr_restore_submit"] = 'Diesen Wiederherstellungspunkt zurückspielen';
$_lang["bkmgr_restore_confirm"] = 'Sind Sie sicher, dass Sie dieses Backup zurückspielen möchten\n[+filename+] ?';
$_lang["bkmgr_snapshot_nothing"] = 'Keine Wiederherstellungspunkte vorhanden';

$_lang["files.dynamic.php1"] = 'Textdatei erstellen';
$_lang["files.dynamic.php2"] = 'Dieses Verzeichnis kann nicht dargestellt werden.';
$_lang["files.dynamic.php3"] = 'Es ist ein Problem mit einem Dateinamen aufgetreten.';
$_lang["files.dynamic.php4"] = 'Die Textdatei wurde erstellt.';
$_lang["files.dynamic.php5"] = 'Datei konnte nicht dupliziert werden.';
$_lang["files.dynamic.php6"] = 'Datei oder Verzeichnis konnte nicht umbenannt werden.';
$_lang["files_dynamic_new_folder_name"] = 'Name des neuen Verzeichnisses:';
$_lang["files_dynamic_new_file_name"] = 'Name der neuen Datei:';
$_lang["not_readable_dir"] = 'Das Verzeichnis kann nicht gelesen werden.';
$_lang["confirm_delete_dir"] = 'Wollen sie dieses Verzeichnis wirklich löschen?';
$_lang["confirm_delete_dir_recursive"] = 'Wollen sie dieses Verzeichnis wirklich löschen?\n\nAlle Dateien und Verzeichnisse innerhalb dieses Verzeichnisses werden ebenfalls gelöscht.';

$_lang["make_folders_title"] = 'Container URL mit abschließendem Schrägstrich';
$_lang["make_folders_message"] = 'Die URL einer Container-Ressource wird mit einem abschließenden Schrägstrich ausgegeben.';

$_lang["check_files_onlogin_title"] = 'Systemdateien überwachen';
$_lang["check_files_onlogin_message"] = 'Die Dateien in dieser Liste werden bei jedem einloggen auf Veränderungen überprüft. Diese Überprüfung garantiert keine absolute Sicherheit, kann Sie aber nach einem erfolgreichen Angriff auf ein kompromittiertes System aufmerksam machen.';

$_lang["configcheck_sysfiles_mod"] = 'Wichtige Systemdateien wurden geändert.';
$_lang["configcheck_sysfiles_mod_msg"] = 'EVO wurde so konfiguriert, dass wichtige Systemdateien überwacht werden, um mögliche Angriffsversuche frühzeitig zu entdecken. Änderungen an diesen Systemdateien bedeuten nicht zwingend, dass die EVO Installation erfolgreich angegriffen wurde. Aber Sie sollten die überwachten Dateien (siehe in EVO-Konfiguration -> Benutzerverwaltung -> Systemdateien überwachen) überprüfen. Wenn die Dateien unverändert sind oder ein Systemverantwortlicher sie geändert hat, dann speichern Sie die EVO-Konfiguration erneut ab, um diese Meldung zu deaktivieren. Die folgenden Dateien wurden geändert:';

$_lang['email_method_title'] = 'Sendmail Methode';
$_lang['email_method_mail'] = 'PHP mail() Funktion';
$_lang['email_method_smtp'] = 'SMTP Server';
$_lang['smtp_auth_title'] = 'SMTP Auth';
$_lang['smtp_autotls_title'] = 'SMTPAutoTLS';
$_lang['smtp_host_title'] = 'SMTP Host';
$_lang['smtp_secure_title'] = 'SMTP Verschlüsselung';
$_lang['smtp_username_title'] = 'SMTP Benutzername';
$_lang['smtp_password_title'] = 'SMTP Passwort';
$_lang['smtp_port_title'] = 'SMTP Port';

$_lang["setting_resource_tree_node_name"] = 'Titel eines Knotens im Ressourcen-Baum';
$_lang["setting_resource_tree_node_name_desc"] = 'Wählen Sie das Ressourcen-Feld, welches als Titel eines Knotens ausgegeben wird, wenn der Ressourcen-Baum dargestellt wird.';
$_lang["setting_resource_tree_node_name_desc_add"] = 'Hinweis: Ab EVO 1.1 ist es möglich den Anzeigename der einzelnen Ressourcen im Ressourcenbaum selber vorzunehmen. Die o.g. Einstellung wird genutzt, wenn als Anzeigename &quot;Default&quot; ausgewählt wurde.';

$_lang["resource_opt_alvisibled"] = 'Alias im Alias-Pfad ausgeben';
$_lang["resource_opt_alvisibled_help"] = 'Den Alias dieser Ressource im generierten Alias-Pfad ausgeben.';
$_lang['resource_opt_is_published'] = 'Veröffentlicht';
$_lang["docid_incrmnt_method_title"] = 'Vergabe einer neuen Ressourcen-ID ';
$_lang["docid_incrmnt_method_0"] = 'DB Autoinkrement';
$_lang["docid_incrmnt_method_1"] = 'Kleinste fehlende ID';
$_lang["docid_incrmnt_method_2"] = 'Größte ID + 1';

$_lang["enable_cache_title"] = 'Ressourcen-Cache';
$_lang["disabled_at_login"] = 'Deaktiviert wenn eingeloggt';

$_lang["cache_type_title"] = 'Ressourcen-Cache';
$_lang["cache_type_1"] = 'Der Cache basiert nur auf der Ressoucen-ID (Standard)';
$_lang["cache_type_2"] = 'Der Cache basiert auf Ressoucen-ID and $_GET Parametern';
$_lang["seostrict_title"] = 'SEO strikte URLs benutzen';
$_lang["seostrict_message"] = 'Erzwingt die Benutzung von strikten URLs um doppelten Inhalt zu vermeiden.';
$_lang["aliaslistingfolder_title"] = 'AliasListing aktivieren';
$_lang["aliaslistingfolder_message"] = 'Reduziert den Speicherverbrauch bei einer großen Anzahl von Ressourcen (+10.000)';

$_lang["settings_friendlyurls_alert"] = 'Wenn Sie benutzerfreundliche URLs aktivieren wollen, ist es notwendig, die „ht.access“ Datei im Webroot der EVO Installation in „.htaccess“ umzubenennen.';
$_lang["settings_friendlyurls_alert2"] = 'Da EVO in einem Unterverzeichnis installiert worden ist, ist es notwendig, den Inhalt der „.htaccess“ Datei zu verändern.';

$_lang["user_street"] = 'Straße';
$_lang["user_city"] = 'Stadt';
$_lang["user_other"] = 'anders';

$_lang["mutate_settings.dynamic.php6"] = 'E-Mail Benachrichtigung bei EVO Fehlern';
$_lang["mutate_settings.dynamic.php7"] = 'Nicht benachrichtigen';
$_lang["mutate_settings.dynamic.php8"] = '[(emailsender)] ([+emailsender+]) wird bei einem EVO Systemfehler per E-Mail benachrichtigt. Die Details zur jeweiligen Fehlermeldung können im EVO Systemereignisprotokoll angeschaut werden.';

$_lang["error_no_privileges"]         = "Sie haben nicht genügend Rechte, um diese Aktion auszuführen!";
$_lang["error_no_optimise_tablename"] = "Die zu optimierende Tabelle wurde nicht gefunden!";
$_lang["error_no_truncate_tablename"] = "Die zu leerende Tabelle wurde nicht gefunden!";
$_lang["error_double_action"]         = "Doppelte Aktion (GET & POST) angeben!";
$_lang["error_no_id"]                 = "Es wurde keine Ressourcen ID in der Abfrage angegeben!";
$_lang["error_id_nan"]                = "Die übergebene ID ist nicht numerisch!";
$_lang["error_no_parent"]             = "Konnte den Namen der Eltern-Ressource nicht finden!";
$_lang["error_many_results"]          = "Es wurden zu viele Ergebnisse aus der Datenbank zurückgegeben!";
$_lang["error_no_results"]            = "Es wurden zu wenige/keine Ergebnisse aus der Datenbank zurückgegeben!";
$_lang["error_no_user_selected"]      = "Es wurde kein Benutzer als Empfänger der Nachricht ausgewählt!";
$_lang["error_no_group_selected"]     = "Es wurde keine Benutzergruppe als Empfänger der Nachricht ausgewählt!";
$_lang["error_movedocument1"]         = "Eine Ressource kann nicht ihre eigene Elternressource sein!";
$_lang["error_movedocument2"]         = "Es wurde keine Ressourcen ID in der Abfrage angegeben!";
$_lang["error_movedocument3"]         = "Es wurde keine Elternressource in der Abfrage angegeben!";
$_lang["error_internet_connection"]   = "Server nicht verfügbar. Bitte prüfen Sie Ihre Internetverbindung!";

$_lang["login_processor_unknown_user"]       = "Benutzername oder Passwort falsch eingegeben!";
$_lang["login_processor_wrong_password"]     = "Benutzername oder Passwort falsch eingegeben!";
$_lang["login_processor_many_failed_logins"] = "Aufgrund von zu vielen fehlerhaften Anmeldeversuchen wurden Sie gesperrt!";
$_lang["login_processor_blocked1"]           = "Sie wurden gesperrt und können sich nicht anmelden!";
$_lang["login_processor_blocked2"]           = "Sie wurden gesperrt und können sich nicht anmelden! Probieren Sie es später noch einmal!";
$_lang["login_processor_blocked3"]           = "Sie wurden automatisch zu einem bestimmten Datum gesperrt und können sich nicht mehr anmelden!";
$_lang["login_processor_bad_code"]           = "Der Sicherheitscode stimmt nicht überein! Bitte loggen Sie sich erneut ein!";
$_lang["login_processor_remotehost_ip"]      = "Der gespeicherte Hostname ist nicht unter Ihrer IP-Adresse erreichbar!";
$_lang["login_processor_remote_ip"]          = "Sie können sich von dieser IP-Adresse nicht einloggen.";
$_lang["login_processor_date"]               = "Sie wurden gesperrt und können sich nicht anmelden! Probieren Sie es später noch einmal!";
$_lang["login_processor_captcha_config"]     = "Das Captcha ist falsch konfiguriert.";

$_lang["dp_dayNames"]   = "['Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag']";
$_lang["dp_monthNames"] = "['Januar', 'Februar', 'März', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember']";
$_lang["dp_startDay"]   = "1";

$_lang["check_all"] = "Alles auswählen";
$_lang["check_none"] = "Nichts auswählen";
$_lang["check_toggle"] = "Auswahl umkehren";

$_lang["version_notices"] = "Versionshinweise";

$_lang["em_button_shift"] = "(Shift-Mausklick um mehrere Fenster zu öffnen)";

$_lang["reset_sysfiles_checksum_button"] = "Checksummen aktualisieren";
$_lang["reset_sysfiles_checksum_alert"] = "Sind Sie sicher, dass Sie die Checksummen aktualisieren möchten?";

$_lang["file_browser_disabled_msg"] = "Der Datei-Browser ist deaktiviert.";
$_lang["which_browser_default_title"]= "Standard Datei-Browser";
$_lang["which_browser_default_msg"]= "Wählen Sie den bevorzugten Standard Datei-Browser. Falls erforderlich kann der Datei-Browser in den Benutzereinstellungen je Benutzer angepasst werden.";
$_lang["which_browser_title"]= "Datei-Browser";
$_lang["which_browser_msg"]= "Sie können einen Datei-Browser speziell für diesen Nutzer auswählen. &quot;Standard&quot; nutzt den in der MODX-Konfiguration gesetzten Standard Datei-Browser,";
$_lang["option_default"] = "Standard";
$_lang["position"] = "Position";
$_lang["are_you_sure"] = "Sind Sie sicher?";

$_lang['evo_downloads_title'] = "Evolution Downloads";
$_lang['help_translating_title'] = "Helfen Sie, MODX Evolution zu übersetzen";
$_lang['download'] = "Download";
$_lang['downloads'] = "Downloads";
$_lang["previous_releases"] = "Vorgängerversionen";
$_lang["extras"] = "Extras";

$_lang["display_locks"] = "Sperren anzeigen";
$_lang["role_display_locks"] = "Sperren anzeigen";
$_lang["session_timeout"] = "Zeitlimit pro Session";
$_lang["session_timeout_msg"] = "EVO sendet pro Minute eine Anfrage an den Server um das Mailersymbol zu aktualisieren und die Session aufrecht zu erhalten. Wenn die letzte Anfrage diesen Zeitraum überschreitet, wird die entsprechende Session als ungültig erklärt und Recourcen-Sperren automatisch entfernt (in Minuten angeben, >2min, standard 15min)";
$_lang["unlock_element_id_warning"] = "Sind Sie sicher, dass Sie [+element_type+] ID[+id+] entsperren möchten?";
$_lang["lock_element_type_1"] = "Template";
$_lang["lock_element_type_2"] = "Template-Variable";
$_lang["lock_element_type_3"] = "Chunk";
$_lang["lock_element_type_4"] = "Snippet";
$_lang["lock_element_type_5"] = "Plugin";
$_lang["lock_element_type_6"] = "Modul";
$_lang["lock_element_type_7"] = "Ressource";
$_lang["lock_element_type_8"] = "Rolle";
$_lang["lock_element_editing"] = "[+element_type+] in Bearbeitung durch Sie seit\n[+lasthit_df+]";
$_lang["lock_element_locked_by"] = "[+element_type+] in Bearbeitung durch Benutzer\n[+username+] seit [+lasthit_df+]";

$_lang["minifyphp_incache_title"] = 'Reduziere PHP-Code im Site-Cache';
$_lang["minifyphp_incache_message"] = 'Reduziere PHP-Code innerhalb Snippets und Plugins, bevor Sie im Site-Cache gespeichert werden <a href="https://github.com/modxcms/evolution/issues/938" target="_blank">#938</a>';

$_lang["logout_reminder_msg"] = "Erinnerung: Es scheint als haben Sie am [+date+] vergessen sich abzumelden. Bitte beachten Sie in Zukunft, sich nach Beendigung Ihrer Arbeiten abzumelden.";

$_lang["allow_eval_title"]             = "PHP-eval() in Snippet-Aufrufen erlauben";
$_lang["allow_eval_msg"]               = "Für Entwickler: Bitte nutzen Sie bei zukünftigen Entwicklungen \$modx-&gt;safeEval() anstelle von eval().";
$_lang["allow_eval_with_scan"]         = "Nur zulässige Funktionen ausführen";
$_lang["allow_eval_with_scan_at_post"] = "Alle ausführen, jedoch bei POST-Anfragen nur zulässige Funktionen";
$_lang["allow_eval_everytime_eval"]    = "Alle Funktionen ausführen (nur für Fehlersuche / Debugging)";
$_lang["allow_eval_dont_eval"]         = "Keine Funktionen ausführen";

$_lang["safe_functions_at_eval_title"] = "Zulässige Funktionen";
$_lang["safe_functions_at_eval_msg"]   = "Komma-separierte Liste";

$_lang["multiple_sessions_msg"]   = "Information: Es wurden weitere aktive Sessions (insgesamt [+total+]) gefunden für den Benutzer <b>[+username+]</b>.";
$_lang["iconv_not_available"]     = "Es ist wichtig, die Erweiterung iconv zu installieren/aktivieren. Bitte kontaktieren Sie diesbezüglich Ihren Hoster oder Administrator, wenn Sie nicht wissen was zu tun ist.";

$_lang["cm_create_new_category"] = "Neue Kategorie erstellen";
$_lang["cm_category_name"] = "Kategorie-Name";
$_lang["cm_category_position"] = "Kategorie-Position";
$_lang["cm_no_x_assigned"] = "Kein %s zugewiesen";
$_lang["cm_save_categorization"] = "Kategorisierung speichern";
$_lang["cm_update_categories"] = "Kategorien aktualisieren";
$_lang["cm_assigned_elements"] = "Zugewiesene Elemente";
$_lang["cm_edit_name"] = "Name bearbeiten";
$_lang["cm_mark_for_deletion"] = "Markieren zum löschen";
$_lang["cm_delete_now"] = "Sofort löschen";
$_lang["cm_delete_element_x_now"] = "&quot;%s&quot; sofort löschen";
$_lang["cm_select_element_group"] = "Wählen Sie eine Elemente-Gruppe";
$_lang["cm_global_messages"] = "Allgemeine Nachrichten";
$_lang["cm_add_new_category"] = "Neue Kategorie hinzufügen";
$_lang["cm_edit_categories"] = "Kategorien bearbeiten";
$_lang["cm_sort_categories"] = "Kategorien sortieren";
$_lang["cm_categorize_elements"] = "Elemente kategorisieren";
$_lang["cm_translation"] = "Übersetzung";
$_lang["cm_translations"] = "Übersetzungen";
$_lang["cm_categorize_x"] = "Kategorisiere <span class=\"highlight\">%s</span>";
$_lang["cm_unknown_error"] = "Fehler";
$_lang["cm_x_assigned_to_category_y"] = "<span class=\"highlight\">%s(%s)</span> wurde Kategorie <span class=\"highlight\">%s(%s)</span> zugewiesen";
$_lang["cm_no_categorization"] = "Es wurden keine Änderungen vorgenommen.";
$_lang["cm_no_changes"] = "Es wurden keine Änderungen festgestellt.";
$_lang["cm_x_changes_made"] = "<span class=\"highlight\">%s</span> Änderungen gespeichert";
$_lang["cm_enter_name_for_category"] = "Bitte geben Sie den Namen für die neue Kategorie ein.";
$_lang["cm_category_x_exists"] = "Kategorie <span class=\"highlight\">%s</span> existiert bereits.";
$_lang["cm_category_x_saved_at_position_y"] = "Die neue Kategorie <span class=\"highlight\">%s</span> wurde gespeichert an Position <span class=\"highlight\">%s</span>.";
$_lang["cm_category_x_moved_to_position_y"] = "Kategorie <span class=\"highlight\">%s</span> wurde verschoben zu Position <span class=\"highlight\">%s</span>";
$_lang["cm_category_x_deleted"] = "Kategorie <span class=\"highlight\">%s</span> wurde gelöscht";
$_lang["cm_category_x_renamed_to_y"] = "Kategorie <span class=\"highlight\">%s</span> wurde umbenannt zu <span class=\"highlight\">%s</span>";
$_lang["cm_translation_for_x_empty"] = "Übersetzung ist leer für <span class=\"highlight\">%s</span> ";
$_lang["cm_translation_for_x_to_y_success"] = "Übersetzung für <span class=\"highlight\">%s</span> nach <span class=\"highlight\">%s</span> wurde erfolgreich gespeichert";
$_lang["cm_save_new_sorting"] = "Sortierung speichern";
$_lang["cm_translate_phrases"] = "Wortgruppen übersetzen";
$_lang["cm_translate_module_phrases"] = "Modul-Wortgruppen übersetzen";
$_lang["cm_native_phrase"] = "Original-Wortlaut";

$_lang["btn_view_options"] = 'Darstellungs-Optionen';
$_lang["view_options_msg"] = 'Die Art der Darstellung & Auflistung der Elemente kann mittels des Buttons &quot;Ansicht&quot; angepasst werden. Diese Einstellungen werden browserintern mittels HTML5 localStorage gespeichert.';
$_lang["viewopts_title"] = 'Darstellungs-Optionen';
$_lang["viewopts_cb_buttons"] = 'Buttons';
$_lang["viewopts_cb_descriptions"] = 'Beschreibungen';
$_lang["viewopts_cb_icons"] = 'Icons';
$_lang["viewopts_radio_list"] = 'Liste';
$_lang["viewopts_radio_inline"] = 'Reihenweise';
$_lang["viewopts_radio_flex"] = 'Flex';
$_lang["viewopts_fontsize"] = 'Schriftgröße';
$_lang["viewopts_cb_alltabs"] = 'auf alle Tabs anwenden';

$_lang['email_sender_method'] = 'Absender-Adresse';
$_lang['auto'] = 'Automatische Erkennung';
$_lang['use_emailsender'] = 'Benutze [(emailsender)]';
$_lang['email_sender_method_message'] = 'Die Absender-Adresse wird normalerweise als Return-Path Header durch den Versender verwendet, und empfängt daher Mails welche nicht zugestellt werden konnten (Bounces). Die automatische Erkennung ist in der Regel ausreichend.';

$_lang['login_form_position_title'] = 'Position des Login-Formulars';
$_lang['login_form_position_left'] = 'links';
$_lang['login_form_position_center'] = 'zentriert';
$_lang['login_form_position_right'] = 'rechts';
$_lang['login_logo_title'] = 'Logo im Login-Formular';
$_lang['login_logo_message'] = 'Empfehlung für Logos: 360px breit, PNG-Format';
$_lang['login_bg_title'] = 'Hintergrundbild der Login-Seite';
$_lang['login_bg_message'] = 'Empfehlung für Hintergrundbilder: 1920px breit';

$_lang['manager_menu_position_title'] = 'Position des Hauptmenüs';
$_lang['manager_menu_position_top'] = 'Oben';
$_lang['manager_menu_position_left'] = 'links';
$_lang['invalid_event_response'] = 'Der Event "%s" verursachte eine invalide Ausgabe.';

$_lang["role_no_tv"] = 'No Variables have been assigned to this Role yet.';
$_lang["role_notassigned_tv"] = 'These Variables are available for assigning.';
$_lang["role_tv_msg"] = 'The Variables assigned to this Role are listed below.';
$_lang["tmplvar_roles_access_msg"] = 'Select the Roles that are allowed to access/process this Template Variable';

$_lang["setting_from_file"] = '<strong class="text-danger">Parameter value is defined in core/custom/confic/cms/settings</strong>';

return $_lang;
