# Evolution CMS Community Edition

![screenshot_1](https://user-images.githubusercontent.com/523389/105744390-5a720e00-5f3d-11eb-8405-7b0f7e28688a.jpg)

[![CMS Evolution](https://img.shields.io/badge/CMS-Evolution-brightgreen.svg)](https://github.com/evocms-community/evolution) [![GitHub release](https://img.shields.io/github/release/evocms-community/evolution.svg)](https://github.com/evocms-community/evolution/releases) ![PHP version](https://img.shields.io/badge/PHP->=v7.4-green.svg?php=7.4) [![Documentation](https://img.shields.io/badge/Documentation-processed-orange.svg)](https://github.com/evocms-community/docs/)


## What is Evolution CMS

**Evolution CMS** is an open source Content Management System and Application Framework.

## History

Initially inspired by **Etomite 0.6**, then it been **MODX Evolution 0.7 - 1.0.8** is an ongoing project written by *Raymond Irving* and a core team of contributors **MODX**, and now its **Evolution CMS** maintained by a team of contributors at the **Evolution CMS Project**.

## License

**Evolution CMS** is distributed under the **GPL license** and is now run by a professional team of developers from all over the world. Visit the Forums for more information.

## Features

**Evolution CMS** provides a fast, lightweight and powerful framework on which to deploy and secure your website and web applications.

For example, it gives you a true system for registered web users and groups that is separate from administration users. You can grant some web users access to one page and others access to another page.

For content management, you can easily duplicate documents, folders (and all their children!), chunks and snippets.

Most significant, though, is **Evolution CMS's** ability to empower you to quickly and easily create and maintain a rich and dynamic website like never before.

## Install
You can use the single click installer: [Evolution CMS Installer](https://github.com/evocms-community/installer)
Evolution CMS 3.0 requires **PHP >= 7.3**

## Docker

To run **Evolution CMS** using docker make **docker-compose up -d** command in your terminal. Additional configs and access parameters you can find in **docker-compose.yml** file and **docker** folder 

## References

Official Website:
https://evocms.ru/

Telegram group:
https://t.me/evo_cms

Download:
https://github.com/evocms-community/evolution/releases

Documentation:
https://github.com/evocms-community/docs/

Previous Releases:
https://modx.com/download/evolution/previous-releases.html

Extras / Add-ons:
https://extras.evocms.ru

Documentation:
https://github.com/evocms-community/docs
https://evolution-docs.com

Youtube:
https://www.youtube.com/channel/UCS7ZUn62Qln_OhHSVaFTTig
