## Авторизация пользователей

Авторизация пользователей в `FormLister` осуществляется с использованием контроллера `Login`.

### Выбор поля для авторизации

Поле для авторизации задается в параметре `loginField` и должно быть **уникальным** для каждого веб-пользователя.

Авторизация может осуществляться:
* по **базовым** полям средствами класса `modUsers`: `id`, `username` и `email`
* по любому **другому полю** из учетной записи (с помощью плагина для события `OnWebAuthentication`)


Дополнительное использование плагина [userHelper](https://github.com/evolution-cms/evolution/blob/develop/assets/snippets/FormLister/plugin.userHelper.php) позволяет:

* вести учет количества логинов
* определить время последней авторизации
* реализовать автологин и выход из учетной записи
* блокировать пользователей после определенного количества неудачных попыток авторизации

Перед использованием плагина `userHelper` убедитесь что он включен:

![Не забудьте включить userHelper](https://habrastorage.org/web/dbc/1e2/abd/dbc1e2abd8664a548f4eca254187fb60.png)

## Пример вызова FormLister для авторизации веб-пользователей

```javascript
[!FormLister?
&formid=`login`
&controller=`Login`
&loginField=`email`
&passwordField=`password`
&rules=`{
  "email":{
			"required":"Обязательно введите email"
			}
	},
	"password":{
			"required":"Обязательно введите пароль",
			"minLength":{
					"params":6,
					"message":"В пароле должно быть больше 6 символов"
			}
	},
}`
&allowedFields=`email,password`
&formTpl=`@CODE:
<div class="register">
        <form method="post">
                <input type="hidden" name="formid" value="login">
                <div class="form-group[+email.errorClass+][+email.requiredClass+]">
                        <label for="email"><i class="icon-gmail"></i></label>
                                <input type="text" class="form-control" id="email" placeholder="Email" name="email" value="[+email.value+]">
                                [+email.error+]
                </div>
                <div class="form-group[+password.errorClass+][+password.requiredClass+]">
                        <label for="password"><i class="icon-cog"></i></label>
                        <input type="password" class="form-control" id="password" placeholder="Пароль" name="password" value="">
                        [+password.error+]
                </div>
                [+form.messages+]
                <div class="form-group">
                        <button type="submit" class="btn btn-primary"><i class="icon-user"></i> Войти</button>
                </div>
        </form>
</div>
`
&messagesOuterTpl=`@CODE:<div class="alert alert-danger" role="alert">[+messages+]</div>`
&successTpl=`@CODE:<div>Поздравляем с успешной авторизацией, [+fullname.value+]!</div>`
&errorTpl=`@CODE:<div class="alert alert-danger">[+message+]</div>`
&requiredClass=` has-error`
&errorClass=` has-error`
&requiredClass=` has-error`
!]
```

## Параметры контроллера

### model
Класс для работы с пользователями.

Возможные значения - имя класса.

Значение по умолчанию - \modUsers

### modelPath
Путь к файлу класса для работы с пользователями.

Возможные значения - относительный путь к файлу.

Значение по умолчанию - assets/lib/MODxAPI/modUsers.php

### loginField
Поле, содержащее имя пользователя.

Возможные значения - имя поля.

Значение по умолчанию - username.

### passwordField
Поле, содержащее пароль пользователя.

Возможные значения - имя поля.

Значение по умолчанию - password.

### rememberField
Поле для запоминания пользователя. Если значение поля приводится к true, то при успешной авторизации будет установлена кука с параметрами автологина. Имя куки и ее время жизни задаются параметрами cookieName и cookieLifetime.

Можно также задать поле rememberme в параметре defaults, чтобы запоминание происходило без участия пользователя:
```
&defaults=`{"rememberme":1}`
```

Возможные значения - имя поля.

Значение по умолчанию - rememberme.

### checkActivation
Включает проверку активации учетной записи пользователя (см. "Активация учетных записей"). 

Возможные значения - 0 или 1.

Значение по умолчанию - 1.

### context
Контекст авторизации.

Возможные значения - mgr или web.

Значение по умолчанию - web.

### cookieName
Имя куки для хранения параметров автологина.

Значение по умолчанию - WebLoginPE.

### cookieLifetime
Время жизни вышеуказанной куки.

Возможные значения - число секунд с момента последнего логина.

Значение по умолчанию - 157680000 (5 лет).

### redirectTo
Перенаправляет пользователя на страницу c указанным id после авторизации.

Возможные значения - id целевой страницы или массив.

Значение по умолчанию - пусто.

### exitTo
Перенаправляет уже авторизованного пользователя на указанную страницу.

Возможные значения - id целевой страницы или массив.

Значение по умолчанию - пусто.

### successTpl
Шаблон сообщения об успешной авторизации. В шаблоне можно использовать данные пользователя.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Login с ключом [+login.default_successTpl+]

### skipTpl
Шаблон сообщения о том, что пользователь уже авторизован.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Login с ключом [+login.default_skipTpl+]

## Параметры плагина userHelper
### logoutKey
Имя GET-параметра для запуска выхода из учетной записи. Если в ссылке на страницу сайта указан параметр с соответствующим именем (например, http://sitename.ru/page.html?logout), будет произведен выход из учетной записи.

Значение по умолчанию - logout.

### cookieName
Имя куки для хранения параметров автологина.

Значение по умолчанию - WebLoginPE.

### cookieLifetime
Время жизни вышеуказанной куки.

Возможные значения - число секунд с момента последнего логина.

Значение по умолчанию - 157680000 (5 лет).

### maxFails
Количество попыток для ввода учетных данных.

Возможные значения - число больше 0.

Значение по умолчанию - 3.

### blockTime
Время блокировки пользователя.

Возможные значения - число секунд с момента последнего логина.

Значение по умолчанию - 3600 (1 час).

