## Отправка файлов
```
[!FormLister?
&formid=`basic`
&rules=`{
"name":{
	"required":"Обязательно введите имя"
},
"email":{
	"required":"Обязательно введите email",
	"email":"Введите email правильно"
},
"message":{
	"required":"Обязательно введите сообщение"
}
}`
&attachments=`first,second`
&attachFiles=`{"userfile":{"filepath":"assets/images/logo.png","filename":"logo.png"}}`
&fileRules=`{
"first":{
	"required":"Приложите документ",
	"allowed":{
		"params": [ ["doc","docx","pdf"] ],
		"message": "Разрешены только документы Word и Pdf"
	},
	"maxSize" : {
		"params": 100,
		"message": "Размер файла не должен превышать 100 кб"
	}
},
"second":{
	"required":"Приложите 2 картинки",
	"maxSize" : {
		"params": 1024,
		"message": "Размер файла не должен превышать 1 мб"
	},
	"allowed": {
		"params": [ ["jpg","jpeg","png","gif"] ],
		"message" : "Разрешены только картинки"
	},
	"maxCount":{
		"params" : 4,
		"message" : "Не больше 4 картинок"
	},
	"minCount":{
		"params" : 2,
		"message" : "Не меньше 2 картинок"
	}
}
}`
&formTpl=`@CODE:
<div class="row">
	<div class="col-md-8 col-md-offset-2">
		<div class="well">
			<form class="form-horizontal" method="post" enctype="multipart/form-data">
				<input type="hidden" name="formid" value="basic">
				<div class="form-group[+name.errorClass+][+name.requiredClass+]">
					<label for="name" class="col-sm-2 control-label">* Имя</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" id="name" placeholder="Имя" name="name" value="[+name.value+]">
						[+name.error+]
					</div>
				</div>
				<div class="form-group[+email.errorClass+][+email.requiredClass+]">
					<label for="email" class="col-sm-2 control-label">* Email</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" id="email" placeholder="Email" name="email" value="[+email.value+]">
						[+email.error+]
					</div>
				</div>
				<div class="form-group[+message.errorClass+][+message.requiredClass+]">
					<label for="message" class="col-sm-2 control-label">* Сообщение</label>
					<div class="col-sm-10">
						<textarea class="form-control" id="message" placeholder="Ваше сообщение" name="message" rows="10">[+message.value+]</textarea>
						[+message.error+]
					</div>
				</div>
				<div class="form-group[+first.errorClass+][+first.requiredClass+]">
					<label for="first" class="col-sm-2 control-label">* Приложите документ (Word или Pdf)</label>
					<div class="col-sm-10">
						<input type="file" class="form-control" id="first" name="first">
						[+first.error+]
					</div>
				</div>
				<div class="form-group[+second.errorClass+][+second.requiredClass+]">
					<label for="second" class="col-sm-2 control-label">* Приложите 2-4 картинки</label>
					<div class="col-sm-10">
						<input type="file" class="form-control" id="second" name="second[]" multiple>
						[+second.error+]
					</div>
				</div>
				[+form.messages+]
				<div class="form-group">
					<div class="col-sm-offset-2 col-sm-10">
						<button type="submit" class="btn btn-primary"><i class="glyphicon glyphicon-envelope"></i> Отправить</button>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>`
&to=`test@test.com`
&reportTpl=`@CODE:
<p>Имя: [+name.value+]</p>
<p>Email: <a href="mailto:[+email.value+]">[+email.value+]</a></p>
<p>Сообщение: [+message:strip_tags:nl2br+]</p>
<p>Документы:[+first.value+]</p>
<p>Картинки:[+second.value+]</p>
<p>Доп.:[+userfile.value+]
<p>Вложения: [+attachments.value+]</p>
`
&errorClass=` has-error`
&requiredClass=` has-warning`
&subject=`Новое сообщение`
&messagesOuterTpl=`@CODE:<div class="alert alert-danger" role="alert">[+messages+]</div>`
&errorTpl=`@CODE:<span class="help-block">[+message+]</span>`
!]
```
