## Отправка писем

Контроллер Form позволяет отправлять данные формы в письме.

## Параметры отправки почты
### parseMailerParams
Разрешает использовать данные формы в параметрах отправки почты (&to=\`[+user.email.value+]\` и т.п.).

Возможные значения - 1, 0.

Значение по умолчанию - 0.

### isHtml
Разрешает отправлять письмо в формате html. Проверка корректности кода письма возлагается на разработчика.

Возможные значения - 1, 0.

Значение по умолчанию - 1.

### to
Адрес получателя. Если не указан, то письмо не отправляется, но считается успешно отправленным.

Возможные значения - email-адрес.

Значение по умолчанию - пусто.

### from
Возможные значения - email-адрес.

Значение по умолчанию - параметр конфигурации emailsender.

### fromName
Имя отправителя.

Возможное значение - строка.

Значение по умолчанию - параметр конфигурации site_name.

### replyTo
Заголовок replyTo.

Возможные значения - email-адрес.

Значение по умолчанию - пусто.

### cc
Заголовок сс.

Возможные значения - email-адрес.

Значение по умолчанию - пусто.

### bcc
Заголовок bcc.

Возможные значения - email-адрес.

Значение по умолчанию - пусто.

### noemail
Если параметр задан, то письмо не отправляется, но считается успешно отправленным.

Возможные значения - 1, 0.

Значение по умолчанию - 0.

### ignoreMailerResult
Если параметр задан, то письмо отправляется, но результат отправки игнорируется.

Возможные значения - 1, 0.

Значение по умолчанию - 0.

### subject, ccSubject, autoSubject
Тема письма.

Возможные значения - строка.

Значение по умолчанию - пусто.

### subjectTpl, ccSubjectTpl, autoSubjectTpl 
Шаблон темы письма.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - значение параметра subject (ccSubject, autoSubject).

### autosender
Адрес на который отправляется дополнительное письмо.

Возможные значения - email-адрес.

Значение по умолчанию - пусто.

### autosenderFromName
Имя отправителя дополнительного письма.

Возможные значения - строка.

Значение по умолчанию - параметр конфигурации site_name.

### ccSender
Если параметр задан, то на адрес указанный в поле формы отправляется письмо.

Возможные значения - 1, 0.

Значение по умолчанию - 0.

### ccSenderField
Имя поля, в котором хранится адрес получателя.

Возможные значения - имя поля формы.

Значение по умолчанию - email.

### ccSenderFromName
Имя отправителя письма на заданный в поле формы адрес.

Возможные значения - строка.

Значение по умолчанию - не указано.

## ccMailConfig
Позволяет переопределить параметры отправки для писем, отправляемых по адресу из формы (isHtml, from, fromName, subject, replyTo, cc, bcc, noemail).

Возможные значения - json или php массив.
 
Значение по умолчанию - не указано.

## autoMailConfig
Позволяет переопределить параметры отправки для дополнительно отправляемых писем (isHtml, from, fromName, subject, replyTo, cc, bcc, noemail).

Возможные значения - json или php массив.
 
Значение по умолчанию - не указано.

## Защита от повторной отправки
### protectSubmit
Защита от повторной отправки письма.

Возможные значения - 1, 0 или список полей, по которым определяется уникальность письма. Если список не задан, то используются поля, обязательные для заполнения.

Значение по умолчанию - 1.

### submitLimit
Защита от частой отправки писем.

Значение - число секунд между повторной отправкой.

Значение по умолчанию - 60.

## Шаблоны
### reportTpl
Основной шаблон письма.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - список полей и их значений.

### automessageTpl
Шаблон дополнительного письма.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - пусто.

### ccSenderTpl
Шаблон письма на заданный в поле формы адрес.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - пусто.

### successTpl
Шаблон сообщения об успешной отправке писем.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - пусто.

## Отправка файлов
### attachments
Имена полей, в которых хранятся файлы. Поддерживаются только поля с одним файлом (name="field" type="file") и поля с одномерным массивом файлов (name="field[]" type="file" multiple). 

Значение по умолчанию - пусто.

### attachFiles
Позволяет отправить произвольные файлы. 

Возможные значения - массив:
```
&attachFiles=`{
"имя поля1":{
    "filepath":"assets/images/logo.png",
    "filename":"logo.png"
},
"имя поля2":[
    {
    "filepath":"assets/images/file1.jpg",
    "filename":"отчет.jpg"
    },
    {
    "filepath":"assets/images/file2.jpg",
    "filename":"отчет2.jpg"
    }
]
}`
```
### deleteAttachments
Позволяет удалить файлы вложений после успешной отправки.

Возможные значения - 0 или 1.

Значение по умолчанию - 0.

### fileValidator
Имя класса для валидации файлов. Если задано, то класс должен быть загружен заранее.

Значение по умолчанию - \FormLister\FileValidator

### fileRules
Правила валидации (см. раздел "Валидация данных"). Стандартный валидатор поддерживает правила:

- required: файлы успешно отправлены;
- optional: аналогично required, но выполняется и в том случае, если пользователь не загружал файлы (то есть поле с файлами не является обязательным);
- allowed: расширение файла входит в заданный массив;
- images: расширение файла jpg, jpeg, gif, png, bmp;
- minSize: размер файла в килобайтах больше заданного;
- maxSize: размер файла в килобайтах меньше заданного;
- sizeBetween: размер файла в килобайтах входит в диапазон;
- minCount: количество файлов больше заданного;
- maxCount: количество файлов меньше заданного;
- countBetween: количество файлов входит в диапазон.

Использовать конструкцию "!имя поля" в правилах валидации файлов нет смысла, так как значение поля с файлом не будет пустым, даже если файл не загружен. Следует использовать правило optional.

В шаблоне письма reportTpl доступен плейсхолдер [+attachments.value+] со списком всех приложенных к письму файлов. Можно также вывести по отдельности: [+имя поля.value+]. Файлы отправляются только в письме c шаблоном reportTpl.
