## Регистрация пользователей

При регистрации пользователь добавляется в группу opt. Отправляется два письма - менеджеру и пользователю. Пользователь должен подтвердить регистрацию, перейдя по ссылке из письма (см. Активация учетных записей).
 
```
[!FormLister?
&formid=`register`
&controller=`Register`
&userGroups=`opt`
&checkActivation=`1`
&activateTo=`1514`
&rules=`{
"fullname":{
	"required":"Обязательно введите имя"
},
"email":{
	"required":"Обязательно введите email",
	"email":"Введите email правильно"
},
"password":{
	"required":"Обязательно введите пароль",
	"minLength":{
		"params":6,
		"message":"В пароле должно быть больше 6 символов"
	}
},
"repeatPassword":{
	"required":"Повторите пароль",
	"equals":{
		"message":"Пароли не совпадают"
	}
},
"agree":{
	"required":"Для регистрации вы должны принять правила"
}
}`
&allowedFields=`fullname`
&formControls=`agree`
&formTpl=`@CODE:
<div class="row">
	<div class="col-md-6 col-md-offset-3">
		<div class="well">
			<form method="post">
				<input type="hidden" name="formid" value="register">
				<div class="form-group[+fullname.errorClass+][+fullname.requiredClass+]">
					<label for="fullname">* Имя</label>
						<input type="text" class="form-control" id="fullname" placeholder="Имя" name="fullname" value="[+fullname.value+]">
						[+fullname.error+]
				</div>
				<div class="form-group[+email.errorClass+][+email.requiredClass+]">
					<label for="email">* Email</label>
						<input type="text" class="form-control" id="email" placeholder="Email" name="email" value="[+email.value+]">
						[+email.error+]
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group[+password.errorClass+][+password.requiredClass+]">
							<label for="password">* Пароль</label>
								<input type="password" class="form-control" id="password" placeholder="Пароль" name="password" value="">
								[+password.error+]
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group[+repeatPassword.errorClass+][+repeatPassword.requiredClass+]">
							<label for="repeatPassword">* Повторите пароль</label>
								<input type="password" class="form-control" id="repeatPassword" placeholder="Повторите пароль" name="repeatPassword" value="">
								[+repeatPassword.error+]
						</div>
					</div>
				</div>
				<div class="checkbox[+agree.requiredClass+]">
				  <label>
					<input type="checkbox" name="agree" value="Да" [+c.agree.Да+]>
					Я согласен с правилами
				  </label>
					[+agree.error+]
				</div>
				[+form.messages+]
				<div class="form-group">
					<button type="submit" class="btn btn-primary btn-block text-center"><i class="glyphicon glyphicon-user"></i> Зарегистрироваться</button>
				</div>
			</form>
		</div>
	</div>
</div>`
&to=`info@sitename.ru`
&reportTpl=`@CODE:Новый пользователь [+fullname.value+] ([+id.value+])`
&ccSender=`1`
&ccSenderField=`email`
&ccSenderTpl=`@CODE:Привет [+fullname.value+]. Для активации учетной записи нужно перейти по ссылке <a href="[+activate.url+]">[+activate.url+]</a>`
&subject=`Регистрация на сайте [(site_name)]`
&messagesOuterTpl=`@CODE:<div class="alert alert-danger" role="alert">[+messages+]</div>`
&successTpl=`@CODE:<div>Поздравляем с успешной регистрацией, [+fullname.value+]! После активации вы можете <a href="[~11~]">авторизоваться</a> на сайте. Если вы не получили письмо для активации учетной записи, <a href="[~1514~]">запросите его</a> еще раз.</div>`
&errorTpl=`@CODE:<span class="help-block">[+message+]</span>`
&errorClass=` has-error`
&requiredClass=` has-warning`
!]
```
