## Общие параметры

Эти параметры обрабатываются базовым классом FormLister. В контроллерах некоторые общие параметры могут иметь другое назначение.

## Настройки
### controller
Задает класс для обработки данных. 

Возможные значения - имя php-файла с классом без расширения.

Значение по умолчанию - Form.

### dir
Папка в которой находится класс контроллера.

Значение по умолчанию - assets/snippets/FormLister/core/controller/

### formid
Имя формы, обязательный параметр.

В шаблоне формы обязательно должно быть скрытое поле с именем formid и значением, указанным в параметре. Форма считается отправленной, если в массиве $_REQUEST присутствует ключ с именем параметра, а его значение соответствует значению параметра.

### formMethod
Возможные значения - post, get или request.

Значение по умолчанию - post.

### config
Загрузка параметров в формате json из файла.

Возможные значения - имяфайла:папка, несколько значений разделяются точкой с запятой.

#### Пример
myparams:core - загрузить параметры из файла assets/snippets/FormLister/config/core/myparams.json; myparams - загрузить параметры из файла assets/snippets/FormLister/config/custom/myparams.json; myparams:/assets/myfolder - загрузить параметры из файла assets/myfolder/myparams.json.

Значение по умолчанию - пусто.

### api
Определяет, в каком виде будут выводиться данные.

Возможные значения:

- 0: только html;
- 1: json-массив с данными формы;
- 2: json-массив с данными формы и html.

### apiFormat
Формат вывода данных для api-режимов.

Возможные значения - json, array.

Значение по умолчанию - json.

### debug
Режим отладки. Вывод записывается в лог MODX.

Возможные значения - 0, 1.

Значение по умолчанию - 0.

### saveObject
Сохраняет объект класса FormLister в плейсхолдер, который можно использовать в других сниппетах. Объект сохраняется только при успешной обработке формы.

Возможные значения - имя плейсхолдера.

Значение по умолчанию - пусто.

### removeGpc
Убирает экранирование данных, которое выполняет MODX для символов {{, [[ и т.д. При этом экранируются тэги MODX при выводе.

Возножные значения - 0, 1 или имена полей через запятую.

Значение по умолчанию - 0.

## Источники данных
### defaultsSources
Позволяет загружать дополнительные данные из внешних источников, например, для предварительного заполнения полей формы. По умолчанию внешние данные загружаются только при начальном выводе формы и не загружаются после отправки формы Это поведение может быть изменено с помощью параметра keepDefaults.

Возможные значения: список источников, разделенных точкой с запятой. Загрузка данных производится в том порядке, в котором они указаны в списке.

Источник может задаваться в формате "имя:ключ:префикс". Префикс, если указан, добавляется c точкой к имени поля - например, config.site_name.

Возможные значения:

- array: json или php-массив, значения задаются параметром defaults;
- param:имя параметра:префикс - значения задаются значением параметра из вызова сниппета (аналогично array, только значение задается не параметром defaults, а произвольным, также можно указать префикс);
- session:ключ массива:префикс - значения загружаются из массива $_SESSION;
- plh:ключи через запятую:префикс - загружаются значения из массива $modx->placeholders;
- aplh:имя плейсхолдера:префикс - загружаются значения из плейсхолдера, содержащего массив;
- config:префикс - загружаются значения из конфигурации MODX;
- cookie:ключи через запятую:префикс - загружаются значения из массива $_COOKIE;
- имя класса MODxAPI:ключ:префикс - ключ является аргументом метода edit(), класс должен быть заранее загружен;
- document:префикс - загружает данные из модели modResource для документа, в котором вызван сниппет. Ключ не указывается;
- user:ключ:префикс - загружает данные из модели modUsers для авторизованного пользователя. Тип пользователя уточняется в ключе (web или mgr).

Значение по умолчанию - array.

### defaults
Данные для источника array.

Возможные значения: массив значений по умолчанию, в формате json или php.

### keepDefaults
Позволяет повторно загружать данные из внешних источников после отправки формы. Если в параметре указан список полей, то загружены будут только указанные поля.

Возможные значения: 1, 0, имена полей, разделенные запятой.

Значение по умолчанию - 0.

### allowEmptyFields
Разрешает задавать поля с пустыми значениями.

Возможные значения - 0 или 1.

Значение по умолчанию - 1.

## Элементы управления
### formControls
Список полей с управляющими элементами формы (списки, чекбоксы, радио-кнопки). Необходимо для отслеживания состояния элементов.

Возможные значения - имена полей, разделенные запятой.

Значение по умолчанию - пусто.

### emptyFormControls

Этот параметр позволяет решить проблему неотмеченных чекбоксов, которые не включаются в массив полей при отправке формы: если в $_REQUEST отсутствует нужный элемент, то он создается согласно данному параметру. Необходимость в таком параметре возникла в связи с тем, что MODxAPI требует явно указывать изменяемые поля в методе fromArray(). Но можно использовать и в обычных формах, чтобы подставить в шаблон значение неотмеченного чекбокса. 

Возможные значения - массив:
```
&emptyFormControls=`{
    "mycheckbox" : "Нет",
    "published" : 0
}`
```

## Обработка данных
### prepare, prepareProcess, prepareAfterProcess
Аналогично параметру prepare в DocLister. 

Сниппеты из параметра prepare выполняются после загрузки данных в форму, сниппеты из параметра prepareProcess - после прохождения валидации, сниппеты из параметра prepareAfterProcess - после успешного выполнения обработки. В сниппетах через переменную $FormLister доступен объект контроллера, а через массив $data - значения полей формы. Также доступна переменная $name, которая задержит имя параметра из которого взят сниппет (prepare, prepareProcess и т.д.); это позволяет использовать один и тот же сниппет для разных случаев. Для изменения данных следует использовать в prepare-сниппетах методы контроллера (setField, setFields и т.д.)

Возможные значения - имена сниппетов, анонимные функции, статические методы загруженных классов.

Значение по умолчанию - пусто.

## Валидация
### validator
Имя класса для валидации данных. Класс должен быть предварительно загружен.

Значение по умолчанию - \FormLister\Validator.

### rules
Массив с правилами валидации.

Значение по умолчанию - пусто.

## Шаблоны
### formTpl
Шаблон формы. В шаблоне формы обязательно должно быть поле с именем formid и значением, указанным в параметре formid.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - пусто.

### arraySplitter

Разделитель для преобразования массивов в строку. 

Значение по умолчанию - точка с запятой.

### {field}.arraySplitter
Разделитель для преобразования массивов в строку, но для отдельного поля {field}. Например: groups.arraySplitter - разделитель для массива из поля groups.

Если не задано, то используется значение параметра arraySplitter.

### errorTpl
Шаблон для вывода сообщений валидатора.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию:
```
@CODE:<div class="error">[+message+]</div>
```

### requiredClass, errorClass
Имена классов для обозначения незаполненных (required) и неверно заполенных (error) полей.

Значение по умолчанию - required и error соответственно.

### {field}.requiredClass, {field}.errorClass
Позволяет задавать указанные выше классы для конкретных полей.

По умолчанию используются значения параметров requiredClass и errorClass.

### messagesTpl
Шаблон сообщений обработчика формы. В шаблоне выводятся группы сообщений (messages, required, error).

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию:
```
@CODE:<div class="form-messages">[+messages+]</div>
```

### messagesOuterTpl
Шаблон-обертка для группы произвольных сообщений.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию -
```
@CODE: [+messages+]
```

### messagesRequiredOuterTpl
Шаблон-обертка для группы сообщений о незаполненных полях.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию:
```
@CODE: [+messages+]
```

### messagesErrorOuterTpl
Шаблон-обертка для группы сообщений о неверно заполненных полях.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию:
```
@CODE: [+messages+]
```

### messagesSplitter, messagesRequiredSplitter, messagesErrorSplitter
Разделитель сообщений в группе.

Возможные значения - произвольная строка.

Значение по умолчанию:
```
<br>
```

### removeEmptyPlaceholders
Удаляет из шаблонов незаполненные прейслхолдеры.

Возможные значения - 0 или 1.

Значение по умолчанию - 1.

### parseDocumentSource
Обрабатывает чанки MODX-парсером.

Возможные значения - 0 или 1.

Значение по умолчанию - 0.

### rewriteUrls
Если параметр parseDocumentSource отключен, то парсит ссылки в шаблонах.

Возможные значения - 0 или 1.

Значение по умолчанию - 0.

### skipPrerender
Позволяет отключить предварительную обработку полей формы (экранирование значений, преобразование массивов в строки, установка сообщений об ошибках). Можно включить, если для вывода не используется парсер MODX. 

Возможные значения - 0 или 1.

Значение по умолчанию - 0.

### templatePath, templateExtension
Путь к папке с файлами шаблонов и расширение файлов шаблонов. Эти параметры необходимо задавать при использовании плагина EvoTwig.

Значение по умолчанию - пусто.

## Перенаправление после обработки
### redirectTo
Id страницы, на которую нужно выполнить перенаправление после успешной обработки формы. В api-режиме перенаправление не выполняется, но в массиве данных формы сохраняется абсолютная ссылка на целевую страницу (поле "redirectTo").

Вместо числа можно указывать массив:
```
&redirectTo=`{
    "page":10,
    "query":{
        "foo":"bar"
    },
    "header":"HTTP/1.1 307 Temporary Redirect"
}`
```
Ключ page задает id станицы, в массиве query можно передать дополнительные get-параметры, значением ключа header может быть текст заголовка для перенаправления.

Возможные значения - число или массив.

Значение по умолчанию - пусто.
