## Контроллеры
Контроллер представляет собой класс, унаследованный от базового класса \FormLister\Core, который реализует:

- загрузку классов для валидации и генерации капчи;
- работу с данными (под данными здесь и далее подразумеваются значения свойства formData, то есть не только значения массива $_REQUEST);
- работу с шаблоном формы и шаблоном успешной обработки.

Схема работы:

1. Загрузка данных из формы
2. Загрузка данных из внешних источников
3. Вызов сниппетов для обработки данных.
4. Валидация данных - если получены данные из формы;
3. Вызов сниппетов для обработки данных.
6. Итоговая обработка - если получены данные из формы и пройдена валидация.
7. Вывод.

Итоговая обработка формы происходит в методе process() контроллера. После успешной обработки необходимо установить флаг результа обработки формы с помощью метода setFormStatus(), а также и указать в свойстве renderTpl шаблон для вывода информации с результатами обработки.

Ниже перечислены базовые контроллеры.

### Контроллер Form
Отправляет письма с данными формы.

### Контроллер Login
Авторизует пользователя в контексте web.

### Контроллер Register
Создает web-пользователя и отправляет соответствующие письма.

### Контроллер Activate
Обрабатывает ссылку из письма с подтверждением регистрации или отправляет такое письмо.

### Контроллер DeleteUser
Позволяет пользователям удалять свои учетные записи. Для подтверждения запрашивает пароль.

### Контроллер Profile
Предназначен для редактирования данных web-пользователя.

### Контроллер Reminder
Предназначен для восстановления паролей web-пользователями.

### Контроллер Content
Позволяет создавать и изменять записи с помощью классов MODxAPI.

### Контроллер DeleteContent
Позволяет пользователям удалять созданные ими записи.

### Контроллер MailChimp
Добавляет пользователей в список рассылки сервиса MailChimp. Добавлен как пример расширения базового класса \FormLister\Core.
