## Простая форма
```
[!FormLister?
&formid=`basic`
&rules=`
{
	"name":{
		"required":"Обязательно введите имя",
		"matches":{
			"params":"\/^[\\pL\\s\\-']++$\/uD",
			"message":"Введите имя правильно"
		}
	},
	"email":{
		"required":"Обязательно введите email",
		"email":"Введите email правильно"
	},
	"phone":{
		"required":"Обязательно введите номер телефона",
		"phone":"Введите номер правильно"
	},
	"message":{
		"required":"Обязательно введите сообщение",
		"minLength":{
			"params":10,
			"message":"Сообщение должно быть не менее 10 символов"
		}
	}
}`
&formTpl=`@CODE:
<div class="row">
	<div class="col-md-8 col-md-offset-2">
		<div class="well">
			<form class="form-horizontal" method="post">
				<input type="hidden" name="formid" value="basic">
				<div class="form-group[+name.errorClass+][+name.requiredClass+]">
					<label for="name" class="col-sm-2 control-label">* Имя</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" id="name" placeholder="Имя" name="name" value="[+name.value+]">
						[+name.error+]
					</div>
				</div>
				<div class="form-group[+email.errorClass+][+email.requiredClass+]">
					<label for="email" class="col-sm-2 control-label">* Email</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" id="email" placeholder="Email" name="email" value="[+email.value+]">
						[+email.error+]
					</div>
				</div>
				<div class="form-group[+phone.errorClass+][+phone.requiredClass+]">
					<label for="phone" class="col-sm-2 control-label">* Телефон</label>
					<div class="col-sm-10">
						<input type="text" class="form-control" id="phone" placeholder="+375 29 123 45 67" name="phone" value="[+phone.value+]">
						[+phone.error+]
					</div>
				</div>

				<div class="form-group[+message.errorClass+][+message.requiredClass+]">
					<label for="message" class="col-sm-2 control-label">* Сообщение</label>
					<div class="col-sm-10">
						<textarea class="form-control" id="message" placeholder="Ваше сообщение" name="message" rows="10">[+message+]</textarea>
						[+message.error+]
					</div>
				</div>
				[+form.messages+]
				<div class="form-group">
					<div class="col-sm-offset-2 col-sm-10">
						<button type="submit" class="btn btn-primary"><i class="glyphicon glyphicon-envelope"></i> Отправить</button>
					</div>
				</div>
			</form>
		</div>
	</div>
</div>`
&to=`test@test.com`
&ccSender=`1`
&ccSenderField=`email`
&ccSenderTpl=`@CODE:Спасибо за обращение, [+name.value+]`
&reportTpl=`@CODE:
<p>Имя: [+name.value+]</p>
<p>Телефон: [+phone.value+]</p>
<p>Email: <a href="mailto:[+email.value+]">[+email.value+]</a></p>
<p>Сообщение: [+message:strip_tags:nl2br+]</p>
`
&errorClass=` has-error`
&requiredClass=` has-warning`
&subject=`Новое сообщение`
&messagesOuterTpl=`@CODE:<div class="alert alert-danger" role="alert">[+messages+]</div>`
&errorTpl=`@CODE:<span class="help-block">[+message+]</span>`
!]
```
