## Создание и редактирование документов пользователями

Контроллер Content позволяет web-пользователям создавать и редактировать записи в таблицах MODxAPI. Расширяет контроллер Form, что позволяет отправлять письма после создания записи. При редактировании записей отправка почты отключена, при необходимости ее можно реализовать с помощью плагинов на событие сохранения (OnDocFormSave и т.п.).

Данные формы передаются в объект MODxAPI как есть, соответственно разработчику нужно заботиться об их корректности самостоятельно. 

При редактировании записей можно запретить изменение отдельных полей, используя параметр keepDefaults.

При создании новой записи вызывается событие OnMakeDocUrl, в которое передается id записи и массив data со значениями полей записи. Это позволяет вернуть ссылку на созданную запись, она будет доступна через плейсхолдер [+content.url+]. Ссылку можно использовать в письме c уведомлением о создании новой записи.

Также можно использовать данные авторизованного пользователя, доступны через плейсхолдеры [+user.fullname+], [+user.email+] и т.д.

## Параметры
### model
Класс MODxAPI.

Возможные значения - имя класса MODxAPI.

Значение по умолчанию - \modResource.

### modelPath
Путь к файлу класса, если класс не загружается заранее.

Возможные значения - относительный путь к файлу.

Значение по умолчанию - assets/lib/MODxAPI/modResource.php.

### userModel
Класс для работы с пользователями.

Возможные значения - имя класса.

Значение по умолчанию - \modUsers

### userModelPath
Путь к файлу класса для работы с пользователями.

Возможные значения - относительный путь к файлу.

Значение по умолчанию - assets/lib/MODxAPI/modUsers.php

### onlyUsers
Разрешить добавление записей только для зарегистрированных пользователей.

Возможные значения - 0, 1.

Значение по умолчанию - 1.

### userGroups
Группы пользователей, которым разрешено добавлять или изменять записи.

Возможные значения - список групп через точку с запятой.

Значение по умолчанию - пусто (разрешены любые группы).

### onlyOwners
Разрешает редактирование записей только их авторами. Автор определяется по полю, указанному в параметре ownerField.

Возможные значения - 0, 1.

Значение по умолчанию - 1.

### ownerField
Имя поля, определяющего владельца записи. Если работать с документами modResource, то это будет имя tv-параметра (в Evo не предусмотрено создание записей веб-пользователями).

Возможные значения - имя поля.

Значение по умолчанию - aid.

### idField
Имя ключа массива $_REQUEST, по которому определяется id редактируемой записи. Если ключ не задан, то контроллер вызывается в режиме создания записей. Информацию о режиме контроллера можно получить с помощью метода getMode.

В форме редактирования нужно предусмотреть скрытое поле с именем параметра, в котором будет сохраняться id записи.

Значение по умолчанию - id.

### contentFields
Задает сопоставление полей MODxAPI и полей формы. Можно не задавать, если имена полей совпадают. Если параметр не задан, то ограничить список передаваемых в модель полей можно с помощью параметров allowedFields и forbiddenFields.

Возможные значения - массив вида:
```
&contentFields=`{
    "поле MODxAPI":"поле формы",
    "поле MODxAPI":"поле формы"
}
`
```
Значение по умолчанию - пусто.

### clearCache
Очищать кэш после сохранения записи.

Возможные значения - 0, 1.

Значение по умолчанию - 0.

### redirectTo
Перенаправляет пользователя на указанную страницу после сохранения новой записи. В режиме редактирования не используется.

Возможные значения - id целевой страницы или массив.

Значение по умолчанию - пусто.

### editAfterCreate
Переправляет пользователя на страницу для редактирования созданной записи. Страница указывается в параметре redirectTo.

Возможные значения - 1 или 0.

Значение по умолчанию - 0.

### editTpl
Шаблон формы для редактирования документа.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - значение параметра formTpl.

### badOwnerTpl
Шаблон сообщения о том, что пользователь не является автором документа. Только режим редактирования.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Content с ключом [+edit.default_badOwnerTpl+].

### badGroupTpl, badGroupEditTpl
Шаблон сообщения о том, что пользователь не входит в группу пользователей которым разрешено создавать и редактировать документы.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Content с ключом  
[+create.default_badGroupTpl+] или [+edit.default_badGroupTpl+].

### badRecordTpl
Шаблон сообщения о том, что пользователь не может редактировать запись: например, запись не существует. Только режим редактирования.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Content с ключом [+edit.default_badRecordTpl+].

### exitTo
Перенаправляет неавторизованного пользователя на указанную страницу.

Возможные значения - id целевой страницы или массив.

Значение по умолчанию - пусто.

### skipTpl, skipEditTpl
Шаблон сообщения для неавторизованного пользователя. Для режима редактирования - skipEditTpl.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Content с ключом [+create.default_skipTpl+] (edit.default_skipEditTpl).

### successTpl
Шаблон сообщения об успешном сохранении новой записи.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Content с ключом [+create.default_successTpl+]

### editSuccessTpl
Шаблон сообщения об успешном обновлении записи. 

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - пусто.
