<?php
/**
 * EVO Manager language file
 *
 * @version 1.4
 * @date 2018/11/11
 * @author The EVO Project Team
 *
 * @language Spanish
 * @package evo
 * @subpackage manager
 *
 * Please commit your language changes on Transifex (https://www.transifex.com/projects/p/modx-evolution/) or on GitHub (https://github.com/modxcms/evolution).
 */
//$modx_textdir = 'rtl'; // uncomment this line for RTL langauges
$modx_lang_attribute = 'es'; // Manager HTML/XML Language Attribute see http://en.wikipedia.org/wiki/ISO_639-1
$modx_manager_charset = 'UTF-8';

$_lang["about_msg"] = 'EVO es un <a href="http://evo.im/" target="_blank">Sistema de Administración de Contenido y Esquema de PHP</a> bajo licencia <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'Acerca de Evolution';
$_lang["access_permission_denied"] = 'No tienes los permisos correctos para este documento.';
$_lang["access_permission_parent_denied"] = '¡No tienes permiso para crear o mover un documento aquí! Por favor elije otro lugar.';
$_lang["access_permissions"] = 'Permisos de acceso';
$_lang["access_permissions_add_resource_group"] = 'Crear un grupo de documentos nuevo';
$_lang["access_permissions_add_user_group"] = 'Crear un grupo de usuarios nuevo';
$_lang["access_permissions_docs_collision"] = 'Debido a que existe un conflicto entre los Grupos de Usuarios Web y los Grupos de Usuarios del Admin para tu Rol, este documento será público.  Contacta a un admin del sitio para obtener más ayuda.';
$_lang["access_permissions_docs_message"] = 'Aquí puedes seleccionar a qué grupos de documentos pertenece este documento';
$_lang["access_permissions_group_link"] = 'Crear un enlace de grupo nuevo';
$_lang["access_permissions_introtext"] = 'Aquí puedes administrar los grupos de usuarios y documentos usados para los permisos de acceso. Para añadir un usuario a un grupo de usuarios, edita el usuario y selecciona los grupos a los que el usuario debe ser miembro. Para añadir un documento a un grupo de usuarios, edita el documento y selecciona los grupos a los que debe de pertenecer.';
$_lang["access_permissions_link_to_group"] = 'al Grupo de Documentos';
$_lang["access_permissions_link_user_group"] = 'Enlazar Grupo de Usuarios';
$_lang["access_permissions_links"] = 'Enlaces de los grupos de usuarios/documentos';
$_lang["access_permissions_links_tab"] = 'Aquí es donde especificas que grupos de usuarios tienen acceso (por ej. pueden editar o crear hijos) para los grupos de documentos. Para enlazar un grupo de documentos a un grupo de usuarios, selecciona los grupos apropiados del menú desplegable y has clic en \'Enviar\'. Para remover el enlace de cierto grupo, presiona \'Remover\'. Esto removerá el enlace inmediatamente.';
$_lang["access_permissions_no_resources_in_group"] = 'Ninguno.';
$_lang["access_permissions_no_users_in_group"] = 'Ninguno.';
$_lang["access_permissions_off"] = '<span class="warning">Los Permisos de Acceso no están activados.</span> Esto significa que cualquiera de los cambios aquí realizados no tendrán ningún efecto hasta que los Permisos de Acceso estén activados en tu Configuración. ';
$_lang["access_permissions_resource_groups"] = 'Grupos de Documentos';
$_lang["access_permissions_resources_in_group"] = '<b>Documentos en el grupo:</b> ';
$_lang["access_permissions_resources_tab"] = 'Aquí puedes ver qué grupos de documentos han sido configurados. También puedes crear nuevos grupos, renombrarlos, borrarlos y ver qué documentos están en los diferentes grupos (pon el mouse sobre el ID del documento para ver su nombre).  Para añadir un documento a un grupo, o removerlo de un grupo, edita el documento directamente.';
$_lang["access_permissions_user_groups"] = 'Grupos de usuarios';
$_lang["access_permissions_user_message"] = 'Aquí puedes seleccionar a qué grupos de usuarios pertenece este usuario:';
$_lang["access_permissions_users_in_group"] = 'Usuarios en Grupo:';
$_lang["access_permissions_users_tab"] = 'Aquí puedes ver que grupos de usuarios han sido configurados. También puedes crear nuevos grupos, renombrarlos, borrarlos y ver qué usuarios son miembros de los diferentes grupos. Para añadir un nuevo usuario a un grupo, o removerlo de uno, edita el usuario directamente. Los Administradores (usuarios a los que se les ha asignado un rol con ID 1) siempre tienen acceso a todos los documentos, por lo que no necesitan ser añadidos a ningún grupo.';
$_lang["account_email"] = 'Email de la cuenta';
$_lang["actioncomplete"] = '<b>¡La acción fue completada satisfactoriamente!</b><br /> - Por favor, espera mientras EVO hace limpieza.';
$_lang["activity_message"] = 'Esta lista muestra los últimos documentos que creaste o editaste:';
$_lang["activity_title"] = 'Documentos recientemente editados/creados';
$_lang["add"] = 'Añadir';
$_lang["add_chunk"] = 'Añadir Chunk';
$_lang["add_doc"] = 'Añadir documento';
$_lang["add_folder"] = 'Carpeta Nueva';
$_lang["add_plugin"] = 'Añadir Plugin';
$_lang["add_resource"] = 'Documento Nuevo';
$_lang["add_snippet"] = 'Añadir Snippet';
$_lang["add_tag"] = 'Añadir etiqueta';
$_lang["add_template"] = 'Añadir Template';
$_lang["add_tv"] = 'Añadir TV';
$_lang["add_weblink"] = 'Enlace Web Nuevo';
$_lang["administrator_role_message"] = 'Este rol no puede ser editado o borrado.';
$_lang["administrators"] = 'Administrators';
$_lang["after_saving"] = 'Después de guardar';
$_lang["alert_delete_self"] = '¡No lo puedes borrar tú!';
$_lang["alias"] = 'Alias';
$_lang["all_doc_groups"] = 'Todos los Grupos de Documentos (Públicos)';
$_lang["all_events"] = 'Todos los Eventos';
$_lang["all_usr_groups"] = 'Todos los Grupos de Usuarios (Públicos)';
$_lang["allow_mgr_access"] = 'Acceso a la Interfase del Administrador';
$_lang["allow_mgr_access_message"] = 'Selecciona esta opción para habilitar o deshabilitar el acceso a la interfase del Administrador. <b>NOTA: El usuario será redirigido a la pagina de ingreso del Administrador, o al inicio del sitio web, si esta opción es configurada como no.</b>';
$_lang["already_deleted"] = 'ya ha sido borrado.';
$_lang["attachment"] = 'Adjunto';
$_lang["author_infos"] = 'Author information';
$_lang["automatic_alias_message"] = 'Selecciona \'si\' para que el sistema genere automáticamente un alias basado en el título de la página del documento al guardarlo.';
$_lang["automatic_alias_title"] = 'Generar automáticamente un alias:';
$_lang["backup"] = 'Respaldo';
$_lang["bk_manager"] = 'Respaldo';
$_lang["block_message"] = '¡Este usuario será bloqueado después de guardar los datos de usuario!';
$_lang["blocked_minutes_message"] = 'Escribe el número de minutos que un usuario será bloqueado si alcanza su número máximo de ingresos fallidos permitidos. Por favor, ingresa este valor solamente como números (sin comas, espacios, etc.)';
$_lang["blocked_minutes_title"] = 'Minutos de Bloqueo:';
$_lang["cache_files_deleted"] = 'Los siguientes archivos fueron borrados:';
$_lang["cancel"] = 'Cancelar';
$_lang["captcha_code"] = 'Código de seguridad';
$_lang["captcha_message"] = 'Activa esto para aumentar la seguridad al requerir a los usuarios el ingreso de un código no legible por maquinas (y scriptkiddy hacking scripts).';
$_lang["captcha_title"] = 'Usar códigos CAPTCHA:';
$_lang["captcha_words_default"] = 'EVO,Aceso,Mejor,BitCode,Chunk,Cache,Desc,Diseno,Excel,Disfruta,URLs,TechView,Gerald,Griff,Humphrey,Vacacion,Intel,Integracion,Joystick,Join(),Oscope,Genetico,Luz,Parecido,Marit,Maaike,Nicho,Holanda,Ordinancia,Oscillo,Parser,Fusion,Query,Pregunta,Regalia,Correcto,Snippet,Sentinela,Template,Thespian,Unidad,Enterprise,Verily,Tatuaje,Veri,Website,WideWeb,Yap,Amarillo,Zebra,Zigoto';
$_lang["captcha_words_message"] = 'Ingresa una lista de palabras CAPTCHA para  usarse si el CAPTCHA está activado. Separa las palabras con comas. Este campo de entrada está limitado a 255 caracteres.';
$_lang["captcha_words_title"] = 'Palabras CAPTCHA';
$_lang["category_heading"] = 'Categoría';
$_lang["category_manager"] = 'Category Manager';
$_lang["category_management"] = 'Category management';
$_lang["manage_categories"] = 'Manage Categories';
$_lang["category_msg"] = 'Aquí puedes ver y editar todos los Elementos agrupados por categoría.';
$_lang["cfg_base_path"] = 'MODX_BASE_PATH';
$_lang["cfg_base_url"] = 'MODX_BASE_URL';
$_lang["cfg_manager_path"] = 'MODX_MANAGER_PATH';
$_lang["cfg_manager_url"] = 'MODX_MANAGER_URL';
$_lang["cfg_site_url"] = 'MODX_SITE_URL';
$_lang["change_name"] = 'Cambiar nombre';
$_lang["change_password"] = 'Cambiar Contraseña';
$_lang["change_password_confirm"] = 'Confirmar Contraseña';
$_lang["change_password_message"] = 'Por favor, ingresa tu nueva contraseña, e ingrésala nuevamente para confirmarla. Tu contraseña debe de tener entre 6 y 15 caracteres.';
$_lang["change_password_new"] = 'Nueva contraseña';
$_lang["charset_message"] = 'Por favor, selecciona qué codificación de caracteres deseas utilizar en el Admin.  Por favor nota que EVO ha sido probado con un buen número de estas codificación, pero no con todas ellas. Para la mayoría de los idiomas, la configuración prefijada a UTF-8 es la preferible.';
$_lang["charset_title"] = 'Codificación del caracteres:';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Código de Chunk (html)';
$_lang["chunk_multiple_id"] = 'Error: Varios Chunks comparten la misma ID única.';
$_lang["chunk_no_exist"] = 'El Chunk no existe.';
$_lang["cleaningup"] = 'Limpiando';
$_lang["clean_uploaded_filename"] = 'Use Transliteration for File Uploads';
$_lang["clean_uploaded_filename_message"] = 'Use the default or transalias settings for the file name to clean special characters from uploaded file names, preserving dot-characters (periods)';
$_lang["clear_log"] = 'Limpiar Bitácora';
$_lang["click_to_context"] = 'Haz clic para acceder al menú contextual';
$_lang["click_to_edit_title"] = 'Haz clic aquí para editar este registro';
$_lang["click_to_view_details"] = 'Haz clic aquí para ver detalles';
$_lang["close"] = 'Cerrar';
$_lang["code"] = 'Code';
$_lang["collapse_tree"] = 'Colapsar árbol';
$_lang["comment"] = 'Comentario';
$_lang["configcheck_admin"] = 'Por favor ¡Contacta al administrador del sistema y adviértele sobre este mensaje!';
$_lang["configcheck_cache"] = 'el directorio cache no es escribible';
$_lang["configcheck_cache_msg"] = 'EVO no puede escribir en el directorio cache. EVO continuará funcionando como es esperado, pero no realizará ningún cache. Para solucionar esto, haz el directorio /_cache/ escribible.';
$_lang["configcheck_configinc"] = 'El archivo de configuración todavía es escribible';
$_lang["configcheck_configinc_msg"] = 'Personas muy malintencionadas podrían potencialmente probocar algunos problemas en tu sitio y todo lo asociado con él. <strong>En serio.</strong> Por favor ¡Haz tu archivo de configuración  (/[+MGR_DIR+]/includes/config.inc.php) de sólo lectura!';
$_lang["configcheck_default_msg"] = 'Una alerta no especificada ha sido encontrada. Lo cual es extraño.';
$_lang["configcheck_errorpage_unavailable"] = 'La página de error de tu sitio no está disponible.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Esto significa que tu página de Error no es accesible para navegantes normales de internet o que no existe. Esto puede provocar un estado de circulo cerrado y varios errores en la bitácora de tu sitio. Asegúrate de que nohaya grupos de usuarios asignados a la página.';
$_lang["configcheck_errorpage_unpublished"] = 'La página de Error de tu sitio no está publicada o no existe.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Esto significa que tu página de Error no es accesible para el público en general. Publica la página o asegúrate de que esté asignada a un documento existente en el árbol de tu sitio en el menú Herramientas &gt; Configuración.';
$_lang["configcheck_filemanager_path"] = 'The currently set <u>File Manager path</u> seems incorrect.';
$_lang["configcheck_filemanager_path_msg"] = 'This can happen for example by moving your installation to a different directory or server. Please check and update your Evo system configuration.';
$_lang["configcheck_hide_warning"] = '<a href="javascript:hideConfigCheckWarning(\'%s\');"><em>Don\'t show this again.</em></a>';
$_lang["configcheck_images"] = 'El directorio de imágenes no es escribible';
$_lang["configcheck_images_msg"] = 'El directorio de imágenes no es escribible, o no existe. Esto significa que las funciones del Admin de Imágenes en el editor no funcionará.';
$_lang["configcheck_installer"] = 'El instalador todavía está presente';
$_lang["configcheck_installer_msg"] = 'El directorio install/ contiene el instalador de EVO. Sólo imagina lo que puede pasar si una persona maligna encuentra esta carpeta y ¡ejecuta el instalador!  Probablemente no llegue muy lejos, porque deberá ingresar cierta información de usuario para la base de datos, pero es mejor borrar esta carpeta de tu servidor.';
$_lang["configcheck_lang_difference"] = 'Número incorrecto de entradas en el archivo de idioma';
$_lang["configcheck_lang_difference_msg"] = 'El idioma actualmente seleccionado tiene un número diferente de entradas que el idioma prefijado.  Mientras no es necesariamente un problema, esto puede significar que el archivo de idioma necesita ser actualizado.';
$_lang["configcheck_notok"] = 'Uno o más detalles de configuración no están bien: ';
$_lang["configcheck_ok"] = 'El chequeo pasó OK - sin advertencias que reportar.';
$_lang["configcheck_php_gdzip"] = 'GD and/or Zip PHP extensions not found';
$_lang["configcheck_php_gdzip_msg"] = 'EVO needs the GD and Zip extension enabled for PHP. While EVO will work without them, you will not be able to take full advantage of the built-in File Manager, Image Editor or Captcha for logins.';
$_lang["configcheck_rb_base_dir"] = 'The currently set <u>File base path</u> seems incorrect.';
$_lang["configcheck_rb_base_dir_msg"] = 'This can happen for example by moving your installation to a different directory or server. Please check and update your Evo system configuration.';
$_lang["configcheck_register_globals"] = 'register_globals está configurado como ON en tu archivo de configuración php.ini';
$_lang["configcheck_register_globals_msg"] = 'Esta configuración hace tu sitio mucho más propenso a sufrir ataques Cross Site Scripting (XSS). Deberías hablar con tu proveedor de hospedaje acerca de qué puede hacer para deshabilitar esta configuración.';
$_lang["configcheck_title"] = 'Chequeo de configuración';
$_lang["configcheck_templateswitcher_present"] = 'TemplateSwitcher Plugin detected';
$_lang["configcheck_templateswitcher_present_delete"] = '<a href="javascript:deleteTemplateSwitcher();">Delete TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_disable"] = '<a href="javascript:disableTemplateSwitcher();">Disable TemplateSwitcher</a>';
$_lang["configcheck_templateswitcher_present_msg"] = 'The TemplateSwitcher plugin has been found to cause caching and performance problems, and should be used only the functionality is required in your site.';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Tu página de acceso no autorizado no está publicada o no existe.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Esto significa que tu página de acceso no autorizado no es accesible para navegantes normales de internet o que no existe.  Esto puede provocar un estado de círculo cerrado y varios errores en la bitácora de tu sitio.  Asegúrate de que no haya grupos de usuarios web asignados a la página.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'La página de acceso no autorizado definida en la configuración del sitio no está publicada.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Esto significa que tu página de acceso no autorizado no es accesible para el público en general. Publica la página o asegúrate de que esté asignada a un documento existente en el árbol de tu sitio en en menu Herramientas &gt; Configuración.';
$_lang["configcheck_validate_referer"] = 'Security Warning: HTTP Header Validation';
$_lang["configcheck_validate_referer_msg"] = 'The configuration setting <strong>Validate HTTP_REFERER headers?</strong> is Off. We recommend turning it On. <a href="index.php?a=17">Go to Configuration options</a>';
$_lang["configcheck_warning"] = 'Advertencia de configuración:';
$_lang["configcheck_what"] = '¿Qué significa esto?';
$_lang["confirm_block"] = '¿Estás seguro de que quieres bloquear a este usuario?';
$_lang["confirm_delete_category"] = '¿Estás seguro de que quieres borrar esta categoría?';
$_lang["confirm_delete_eventlog"] = '¿Estás seguro de que quieres borrar esta bitácora de eventos?';
$_lang["confirm_delete_file"] = '¿Estás segura de que quieres borrar el archivo?\n\n¡Esto puede hacer que tu sitio deje de funcionar correctamente! Sólo borra este archivo si sabes con seguridad que lo que estás haciendo no va a romper nada.';
$_lang["confirm_delete_group"] = 'Are you sure you want to delete this group?';
$_lang["confirm_delete_htmlsnippet"] = '¿Estás seguro de que quieres borrar este chunk?';
$_lang["confirm_delete_keywords"] = '¿Estás segura de que quieres borrar estas palabras claves?';
$_lang["confirm_delete_module"] = '¿Estás seguro de que quieres borrar este módulo?';
$_lang["confirm_delete_plugin"] = '¿Estás segura de que quieres borrar este plugin?';
$_lang["confirm_delete_record"] = '¿Estás seguro de que quieres borrar los registros seleccionados?';
$_lang["confirm_delete_resource"] = '¿Estás segura de que quieres borrar este documento?\nCualquier documento hijo también será borrado.';
$_lang["confirm_delete_role"] = '¿Estás segura de que quieres borrar este rol?';
$_lang["confirm_delete_snippet"] = '¿Estás seguro de que quieres borrar este snippet?';
$_lang["confirm_delete_tags"] = '¿Estás segura que de desea quieres las etiquetas META seleccionadas?';
$_lang["confirm_delete_template"] = '¿Estás seguro de que quieres borrar este template?';
$_lang["confirm_delete_tmplvars"] = '¿Estás segura de que quieres remover esta variable y todos sus valores guardados?';
$_lang["confirm_delete_user"] = '¿Estás seguro que de quieres borrar este usuario?';
$_lang["confirm_duplicate_record"] = '¿Estás seguro de que quieres duplicar este registro?';
$_lang["confirm_empty_trash"] = 'Esto removerá permanentemente TODOS tus documentos borrados.\n\n¿Deseas continuar?';
$_lang["confirm_load_depends"] = '¿Estás segura que de quieres cargar la pantalla del Administrar Dependencias sin guardar tus modificaciones?';
$_lang["confirm_name_change"] = 'Cambiar el nombre de usuario puede afectar otras aplicaciones que estén relacionadas con el Administrador de Contenidos.\n\n¿Estás seguro de que quieres cambiar este nombre de usuario?';
$_lang["confirm_publish"] = '\n\nLa publicación de este documento removerá cualquier fecha de (des)publicación que haya sido configurada. Si deseas configurar o mantener las fechas de publicación o (des)publicación, por favor selecciona \'editar\' el documento en vez de publicar.\n\n¿Continuar publicación?';
$_lang["confirm_remove_locks"] = 'Los usuarios a veces cierran sus navegadores mientras editan documentos, templates, snippets, o parsers, posiblemente dejando el artículo que estaban editando en estado cerrado. Al presionar OK puedes remover TODOS los estados cerrados que están configurados actualmente.\n\n¿Continuar?';
$_lang["confirm_reset_sort_order"] = 'Are you sure you want to reset the \"sort order/index\" of all listed elements to 0 ?';
$_lang["confirm_resource_duplicate"] = '¿Estás segura de que quieres duplicar este documento? Cualquier artículo que contenga también será duplicado.';
$_lang["confirm_setting_language_change"] = 'Has modificado el valor prefijado y perderás los cambios. ¿Proceder?';
$_lang["confirm_unblock"] = '¿Estás seguro de que quieres desbloquear este usuario?';
$_lang["confirm_undelete"] = '\n\nCualquier documento hijo borrado al mismo tiempo que este documento también será recuperado, pero los documentos hijos borrados con anterioridad se mantendrán borrados.';
$_lang["confirm_unpublish"] = '\n\nDespublicar este documento removerá cualquier fecha de (des)publicación que haya sido configurada. Si deseas configurar o mantener las fechas de (des)publicación, por favor elige \'editar\' el documento.\n\n¿Continuar?';
$_lang["confirm_unzip_file"] = '¿Estás seguro de que quieres descomprimir este archivo?\n\nLos archivos existentes serán sobrescritos.';
$_lang["could_not_find_user"] = 'No se puede encontrar el usuario';
$_lang["create_folder_here"] = 'Crear carpeta aquí';
$_lang["create_resource_here"] = 'Crear documento aquí';
$_lang["create_resource_title"] = 'Crear Recurso';
$_lang["create_weblink_here"] = 'Crear enlace web aquí';
$_lang["createdon"] = 'Fecha de creación';
$_lang["create_new"] = 'Create new';
$_lang["credits"] = 'Créditos';
$_lang["credits_shouts_msg"] = '<p>EVO es administrado y mantenido en <a href="http://evo.im/" target="_blank">evo.im</a>.</p>';
$_lang["custom_contenttype_message"] = 'Aquí puedes añadir tipos de contenido personalizados para ser usados en tus documentos. Para añadir una nueva entrada, ingresa el tipo de contenido y presione el botón de \'Añadir\'.';
$_lang["custom_contenttype_title"] = 'Tipos de contenido personalizados:';
$_lang["database_charset"] = 'Conjunto de Caracteres de la Base de Datos';
$_lang["database_collation"] = 'Conjunto de Caracteres de Colación de la Base de Datos';
$_lang["database_name"] = 'Nombre de la base de datos';
$_lang["database_overhead"] = '<b style="color:#990033;">Nota:</b> Overhead es un espacio no usado reservado por MySQL. Para liberar este espacio, haz clic en la figura overhead de las tablas.';
$_lang["database_server"] = 'Servidor de BD';
$_lang["database_table_clickbackup"] = 'para respaldar &amp; descargar las tablas seleccionadas';
$_lang["database_table_clickhere"] = 'Haz Clic aquí';
$_lang["database_table_datasize"] = 'Tamaño de datos';
$_lang["database_table_droptablestatements"] = 'Generar ordenes DROP TABLE.';
$_lang["database_table_effectivesize"] = 'Tamaño efectivo';
$_lang["database_table_indexsize"] = 'Tamaño de indexado';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Registros';
$_lang["database_table_tablename"] = 'Nombre de la tabla';
$_lang["database_table_totals"] = 'Totales:';
$_lang["database_table_totalsize"] = 'Tamaño total';
$_lang["database_tables"] = 'Tablas de BD';
$_lang["database_version"] = 'Versión de BD:';
$_lang["date"] = 'Fecha';
$_lang["datechanged"] = 'Fecha de cambio';
$_lang["datepicker_offset"] = 'Offset del Selector de Fecha: ';
$_lang["datepicker_offset_message"] = 'El número de años a mostrar en el pasado en el Selector de Fecha.';
$_lang["datetime_format"] = 'Date format';
$_lang["datetime_format_message"] = 'The format for dates in the Manager.';
$_lang["default"] = 'Default:';
$_lang["defaultcache_message"] = 'Selecciona \'Si\' para hacer todos los documentos nuevos cacheables en forma prefijada.';
$_lang["defaultcache_title"] = 'Cacheable prefijado';
$_lang["defaultmenuindex_message"] = 'Selecciona \'Si\' para activar el incremento automático del indexado de menu en forma prefijada.';
$_lang["defaultmenuindex_title"] = 'Indexado de Menú prefijado';
$_lang["defaultpublish_message"] = 'Selecciona \'Si\' para hacer todos los documentos nuevos publicados en forma prefijada.';
$_lang["defaultpublish_title"] = 'Publicado prefijado';
$_lang["defaultsearch_message"] = 'Selecciona \'Si\' para hacer todos los documentos nuevos buscables en forma prefijada.';
$_lang["defaultsearch_title"] = 'Buscable prefijado';
$_lang["defaulttemplate_message"] = 'Selecciona que template prefijado deseas utilizar para los documentos nuevos. Todavía puedes seleccionar uno diferente en el editor de documentos, esta configuración sólo preselecciona uno de tus templates para tí.';
$_lang["defaulttemplate_title"] = 'Template prefijado';
$_lang["defaulttemplate_logic_title"] = 'Automatic Template Assignment';
$_lang["defaulttemplate_logic_general_message"] = 'New Resources will have the following templates, falling back to higher levels if not found:';
$_lang["defaulttemplate_logic_system_message"] = '<strong>System</strong>: the System Default Template.';
$_lang["defaulttemplate_logic_parent_message"] = '<strong>Parent</strong>: the same Template as the parent container.';
$_lang["defaulttemplate_logic_sibling_message"] = '<strong>Sibling</strong>: the same Template as other Resources in the same container.';
$_lang["delete"] = 'Borrar';
$_lang["delete_resource"] = 'Borrar documento';
$_lang["delete_tags"] = 'Borrar etiquetas';
$_lang["deleting_file"] = 'Borrando archivo `%s`: ';
$_lang["description"] = 'Descripción';
$_lang["deselect_keywords"] = 'Limpiar palabras clave';
$_lang["deselect_metatags"] = 'Limpiar etiquetas META';
$_lang["disabled"] = 'Deshabilitado';
$_lang["doc_data_title"] = 'Ver datos del documento';
$_lang["documentation"] = 'Documentation';
$_lang["duplicate"] = 'Duplicar';
$_lang["duplicate_alias_found"] = 'El documento \'%s\' ya está usando el alias \'%s\'. Por favor, ingresa un alias único.';
$_lang["duplicate_alias_message"] = 'Aquí puedes seleccionar \'si\' para permitir guardar alias duplicados. <b>NOTA: Esta opción debe de ser usada con la opción \'Dirección Alias Amigable\' configurada a \'Si\' para así evitar problemas referenciando el documento.</b>';
$_lang["duplicate_alias_title"] = 'Permitir alias duplicados:';
$_lang["duplicate_name_found_general"] = 'Ya existe un %s nombrado \'%s\'. Favor de ingresar un nombre único.';
$_lang["duplicate_name_found_module"] = 'Ya existe un Módulo nombrado \'%s\'. Favor de ingresar un nombre único.';
$_lang["duplicated_el_suffix"] = 'Duplicate';
$_lang["edit"] = 'Editar';
$_lang["edit_resource"] = 'Editar documento';
$_lang["edit_resource_title"] = 'Crear/editar documento';
$_lang["edit_settings"] = 'Configuración';
$_lang["editedon"] = 'Fecha de Edición';
$_lang["editing_file"] = 'Editando el archivo: ';
$_lang["editor_css_path_message"] = 'Ingresa la dirección a tu archivo CSS que deseas utilizar dentro del editor.  La mejor forma de ingresar la dirección es ingresar la dirección desde la raíz de tu servidor, por ejemplo: /assets/site/style.css. Si no deseas cargar una hoja de estilos en el editor, deja este campo en blanco.';
$_lang["editor_css_path_title"] = 'Dirección del archivo CSS:';
$_lang["element"] = 'Elemento';
$_lang["element_categories"] = 'Vista combinada';
$_lang["element_filter_msg"] = 'Type here to filter list';
$_lang["element_management"] = 'Administrar Elementos';
$_lang["element_name"] = 'Nombre de Elemento';
$_lang["element_selector_msg"] = 'Selecciona el o los Elemento(s) de la lista aquí abajo y haz clic en el botón \'Insertar\'.';
$_lang["element_selector_title"] = 'Selector de Elemento';
$_lang["elements"] = 'Elementos';
$_lang["email"] = 'Email';
$_lang["email_sent"] = 'Correo electrónico enviado';
$_lang["emailsender_message"] = 'Aquí puedes especificar el email usado cuando se le envíe los nombres de usuario y las contraseñas a los usuarios.';
$_lang["emailsender_title"] = 'Dirección de correo electrónico:';
$_lang["emailsubject_default"] = 'Tus detalles de entrada';
$_lang["emailsubject_message"] = 'Aquí puedes especificar el valor del Asunto para el correo electrónico de bienvenida.';
$_lang["emailsubject_title"] = 'Asunto del correo electrónico:';
$_lang["empty_folder"] = 'Esta carpeta está vacía';
$_lang["empty_recycle_bin"] = 'Purgar los documentos borrados';
$_lang["empty_recycle_bin_empty"] = 'No hay documentos borrados para purgar.';
$_lang["enable_resource"] = 'Habilitar archivo de Elementos.';
$_lang["enable_sharedparams"] = 'Habilitar compartir parámetros';
$_lang["enable_sharedparams_msg"] = '<b>NOTA:</b> El id global único (GUID) será usado para identificar inequívocamente este modulo y sus parámetros compartidos.  El GUID es usado también como una forma de enlace entre el módulo y los plugins o snippets que acceden a sus parámetros compartidos. ';
$_lang["enabled"] = 'Habilitado';
$_lang["error"] = 'Error';
$_lang["error_sending_email"] = 'Error enviando correo electrónico';
$_lang["errorpage_message"] = 'Ingresa el ID del documento que quieres enviar a los usuarios si solicitan un documento que no existe actualmente. <b>NOTA: asegúrate de que este ID pertenece a un documento existente y ¡que ha sido publicado!</b>';
$_lang["errorpage_title"] = 'Página de error:';
$_lang["event_id"] = 'Id del evento';
$_lang["eventlog"] = 'Bitácora del evento';
$_lang["eventlog_msg"] = 'La bitácora del evento es usada para mostrar información, advertencias y mensajes de error generados por el admin de contenido.  La columna \'fuente\' muestra la sección del admin de contenido donde ocurrió el mensaje.';
$_lang["eventlog_viewer"] = 'Eventos del sistema';
$_lang["everybody"] = 'Everybody';
$_lang["existing_category"] = 'Categoría existente';
$_lang["expand_tree"] = 'Expandir árbol';
$_lang["export_site"] = 'Exportar HTML estático';
$_lang["export_site_cacheable"] = 'Incluir archivos no cacheables:';
$_lang["export_site_exporting_document"] = '[+status+] [+url+] - [+pagetitle+] ([+id+])<br />';
$_lang["export_site_failed"] = '¡Falló!';
$_lang["export_site_failed_no_open"] = 'No se puede abrir el archivo: ';
$_lang["export_site_failed_no_retrieve"] = 'No se puede traer el documento.';
$_lang["export_site_failed_no_write"] = 'No se puede escribir el archivo.';
$_lang["export_site_html"] = 'Exportar sitio a HTML';
$_lang["export_site_maxtime"] = 'Tiempo máximo de exportación:';
$_lang["export_site_maxtime_message"] = 'Aquí puedes especificar el número de segundos que EVO puede tardarse en exportar el sitio (por sobre los valores de PHP).  Ingresa 0 para tiempo ilimitado.  Favor de notar, un valor de 0 o un numero realmente alto pueden hacer cosas extrañas a tu servidor y no es recomendado.';
$_lang["export_site_message"] = '<p>Usando esta función puedes exportar el sitio completo a archivos HTML. Favor de notar, sin embargo, que perderás mucha funcionalidad de EVO si lo haces:</p><ul><li>Las lecturas de los archivos exportados no serán guardadas.</li><li>Snippets interactivos NO funcionarán en archivos exportados</li><li>Sólo documentos normales serán exportados, los enlaces web no serán exportados.</li><li>El proceso de exportación puede fallar si tus documentos contienen snippets que envían cabeceras de redirección.</li><li>Dependiendo de cómo has escrito tus documentos, hojas de estilo e imagenes, el diseño de tu sitio puede estar dañado.  Para arreglar esto, puedes guardar/mover tus archivos exportados al mismo directorio donde se encuentra el archivo principal de EVO index.php.</li></ul><p>Por favor llena la forma y presiona \'Exportar\' para comenzar el proceso de exportación.  Los archivos creados serán guardados en la ubicación que especifiques, usando, cuando sea posible, los alias de documentos como nombres de archivo.  Mientras se exporta tu sitio, es mejor configurar la opción de EVO \'Alias Amigables\' como \'si\'. Dependiendo del tamaño de tu sitio, la exportación puede demorar un tiempo.</p> <p><em>¡Cualquier archivo existente será sobrescrito por los nuevos si sus nombres son identicos!</em></p>';
$_lang["export_site_numberdocs"] = '<p><b>Se encontraron %s documentos para exportar...</b></p>';
$_lang["export_site_prefix"] = 'Prefijo de archivo:';
$_lang["export_site_start"] = 'Comenzar exportación';
$_lang["export_site_success"] = '¡Éxito!';
$_lang["export_site_success_skip_dir"] = 'Saltar este directorio.';
$_lang["export_site_success_skip_doc"] = 'Saltar este documento.';
$_lang["export_site_suffix"] = 'Sufijo de archivo:';
$_lang["export_site_target_unwritable"] = 'El directorio objetivo no es escribible.  Favor de asegurarte que el directorio sea escribible e inténtalo otra vez.';
$_lang["export_site_time"] = 'Exportación finalizada. Ha tomado %s segundos en completarse.';
$_lang["failed_login_message"] = 'Ingresa el número de ingresos fallidos permitidos antes de bloquear a un usuario.';
$_lang["failed_login_title"] = 'Intentos de ingreso fallidos:';
$_lang["fe_editor_lang_message"] = 'Seleccione un idioma para el editor, para cuando sea usado como editor frontal.';
$_lang["fe_editor_lang_title"] = 'Idioma del editor frontal:';
$_lang["file_delete_file"] = 'Borrar archivo';
$_lang["file_delete_folder"] = 'Borrar carpeta';
$_lang["file_deleted"] = '¡Éxito!';
$_lang["file_download_file"] = 'Descargar archivo';
$_lang["file_download_unzip"] = 'Descomprimir archivo';
$_lang["file_folder_chmod_error"] = 'No es posible cambiar los permisos, necesitarás cambiar los permisos fuera de EVO.';
$_lang["file_folder_created"] = '¡Carpeta creada con éxito!';
$_lang["file_folder_deleted"] = '¡La carpeta fue borrada con éxito!';
$_lang["file_folder_not_created"] = 'No es posible crear la carpeta';
$_lang["file_folder_not_deleted"] = 'No es posible borrar la carpeta. Por favor ¡asegúrate de que la carpeta está vacía antes de borrarla!';
$_lang["file_not_deleted"] = '¡Falló!';
$_lang["file_not_saved"] = 'No se puede guardar el archivo, por favor ¡asegúrate de que el directorio objetivo es escribible!';
$_lang["file_saved"] = '¡Archivo actualizado con éxito!';
$_lang["file_unzip"] = '¡La descompresión fue exitosa!';
$_lang["file_unzip_fail"] = '¡La descompresión falló!';
$_lang["filemanager_path_message"] = 'IIS a menudo no actualiza la configuración de document_root correctamente, que es usado por el administrador de archivos para determinar qué puedes ver. Si estás teniendo problemas usando el administrador de archivos, asegúrate de que esta dirección apunta a la raíz de tu instalación EVO.';
$_lang["filemanager_path_title"] = 'Dirección del administrador de archivos:';
$_lang["files_access_denied"] = '¡Acceso denegado!';
$_lang["files_data"] = 'Datos';
$_lang["files_dir_listing"] = 'Listando del directorio para:';
$_lang["files_directories"] = 'Directorios';
$_lang["files_directory_is_empty"] = 'This directory is empty.';
$_lang["files_dirwritable"] = '¿Directorio escribible?';
$_lang["files_editfile"] = 'Editar archivo';
$_lang["files_file_type"] = 'Tipo de archivo: ';
$_lang["files_filename"] = 'Nombre de archivo';
$_lang["files_fileoptions"] = 'Opciones';
$_lang["files_files"] = 'Archivos';
$_lang["files_filesize"] = 'Tamaño de archivo';
$_lang["files_filetype_notok"] = '¡La subida de este tipo de archivo no está permitida!';
$_lang["files_management"] = 'Manage Files';
$_lang["files_management_no_permission"] = 'You do not have enough permissions to view or edit these files. Ask the administrator to grant you access to <b>%s</b>.';
$_lang["files_modified"] = 'Modificado';
$_lang["files_top_level"] = 'Al nivel superior';
$_lang["files_up_level"] = 'Un nivel arriba';
$_lang["files_upload_copyfailed"] = 'Fallo el copiar el archivo al directorio de destino ¡La subida falló!';
$_lang["files_upload_error"] = 'Error';
$_lang["files_upload_error0"] = 'Hubo un problema con tu subida.';
$_lang["files_upload_error1"] = 'El archivo que estás tratando de subir es demasiado grande.';
$_lang["files_upload_error2"] = 'El archivo que estás tratando de subir es demasiado grande.';
$_lang["files_upload_error3"] = 'El archivo que estás tratando de subir fue sólo parcialmente subido.';
$_lang["files_upload_error4"] = 'Debes seleccionar un archivo a subir.';
$_lang["files_upload_error5"] = 'Hubo un problema con tu subida.';
$_lang["files_upload_inhibited_msg"] = '<b>Característica de subida deshabilitada</b> - asegúrate de que las subidas están soportadas y que el directorio es escribible por PHP.<br />';
$_lang["files_upload_ok"] = '¡Archivo subido con éxito!';
$_lang["files_upload_permissions_error"] = 'Posibles problemas de permiso - el directorio al que quieres subir necesita ser escribible por tu servidor web.';
$_lang["files_uploadfile"] = 'Subir archivo';
$_lang["files_uploadfile_msg"] = 'Selecciona archivo a subir:';
$_lang["files_uploading"] = 'Subiendo <b>%s</b> a <b>%s/</b><br />';
$_lang["files_viewfile"] = 'Ver archivo';
$_lang["folder"] = 'Carpeta';
$_lang["forgot_password_email_fine_print"] = '* La URL anterior expirará una vez que cambies tu contraseña o después de hoy.';
$_lang["forgot_password_email_instructions"] = 'Desde allí podrás cambiar tu contraseña desde el menú de Mi Cuenta.';
$_lang["forgot_password_email_intro"] = 'Se ha hecho una solicitud para cambiar la contraseña de su cuenta.';
$_lang["forgot_password_email_link"] = 'Haz clic aquí para completar el proceso.';
$_lang["forgot_your_password"] = '¿Se te olvidó tu contraseña?';
$_lang["friday"] = 'Viernes';
$_lang["friendly_alias_message"] = 'Si estás utilizando URLs amigables, y el documento tiene un alias, el alias siempre tiene preferencia sobre la URL amigable.  Configurando esta opción a \'si\', el prefijo y sufijo de URL amigable también será aplicado al alias.  Por ejemplo, si tu documento con ID 1 tiene un alias de `introducción`, y has configurado un prefijo de `` y un sufijo de `.html`, configurando esta opción a `si` generará `introduccion.html`.  Si no hay un alias, EVO generará `1.html` como enlace.';
$_lang["friendly_alias_title"] = 'Utilizar alias amigables:';
$_lang["friendlyurls_message"] = 'Esto te permite usar URLs amigables para los buscadores con EVO.  Favor de notar, que esto sólo funciona en instalaciones EVO corriendo sobre Apache, y que deberás escribir un archivo .htaccess para que esto funcione.  Ve el archivo .htaccess incluido en la distribución para más información.';
$_lang["friendlyurls_title"] = 'Usar URLs amigas:';
$_lang["friendlyurlsprefix_message"] = 'Aquí puedes especificar  el prefijo a usar por las URLs amigables.  Por ejemplo, una configuración de prefijo \'page\' cambiará el URL /index.php?id=2 al URL amigable /page2.html (asumiendo que el sufijo está configurado a .html).  De esta forma puedes especificar lo qué tus usuarios (y buscadores) ven como enlaces en tu sitio.';
$_lang["friendlyurlsprefix_title"] = 'Prefijo para URLs amigables:';
$_lang["friendlyurlsuffix_message"] = 'Aquí puedes especificar el sufijo para las URLs amigables.  Especificando \'.html\' agregará .html a todas tus URLs amigables.';
$_lang["friendlyurlsuffix_title"] = 'Sufijo para URLs amigables:';
$_lang["functionnotimpl"] = '¡Lo sentimos!';
$_lang["functionnotimpl_message"] = 'Esta función no ha sido implementada todavía.';
$_lang["further_info"] = 'Further information';
$_lang["global_tabs"] = 'Global Tabs';
$_lang["go"] = 'Ir';
$_lang["group_access_permissions"] = 'Acceso de grupo de usuarios';
$_lang['group_tvs'] = 'Group TV';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Ayuda';
$_lang["help_msg"] = '<p>Puede obtener soporte gratuito de la comunidad <a href="http://forums.modx.com" target="_blank">visitando los foros de EVO</a>.  También hay un cumulo creciente de <a href="http://evolution-docs.com" target="_blank">Documentación y Guías EVO</a> que tocan virtualmente todos los aspectos de EVO.</p><p>Estamos planeando ofrecer servicios de soporte comercial para EVO. Por favor, <a href="mailto:hello@modx.com?subject=MODX Commercial Support Inquiry">envíenos un mensaje si está interesado</a>.';
$_lang["help_title"] = 'Ayuda';
$_lang["hide_tree"] = 'Ocultar árbol';
$_lang["home"] = 'Cuadro de Mando';
$_lang["htmlsnippet"] = 'Chunk';
$_lang["htmlsnippets"] = 'Chunks';
$_lang["htmlsnippet_desc"] = 'Descripción';
$_lang["htmlsnippet_management_msg"] = 'Aquí puedes seleccionar qué chunk deseas editar.';
$_lang["htmlsnippet_msg"] = 'Aquí puedes añadir/editar chunks.  Recuerda, los chunks son código HTML \'plano\', por lo que cualquier código PHP no será procesado.';
$_lang["htmlsnippet_name"] = '{{ Nombre del chunk }}';
$_lang["htmlsnippet_title"] = 'Crear/editar chunk';
$_lang["icon"] = 'Icono';
$_lang["icon_description"] = 'CSS class value. e.g. fa&nbsp;fa-star';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Asignación de padre:\n\nEl documento es un hijo del documento seleccionado.';
$_lang["illegal_parent_self"] = 'Asignación de padre:\n\nEl documento seleccionado no puede ser asignado a sí mismo.';
$_lang["images_management"] = 'Manage Images';
$_lang["import_files_found"] = '<b>Se encontraron %s documentos para importar...</b>';
$_lang["import_params"] = 'Parámetros compartidos del modulo de importación';
$_lang["import_params_msg"] = 'Puedes importar los parámetros, o configuraciones de un módulo seleccionando el nombre del módulo en el siguiente menú desplegable. <b>NOTA:</b> Para que los módulos aparezcan dentro del menú, este plugin/snippet debe ser parte del listado de dependencias del módulo y el módulo debe tener habilitado el compartir parametros. ';
$_lang["import_parent_resource"] = 'Documento padre:';
$_lang["import_site"] = 'Importar HTML';
$_lang["import_site_failed"] = '¡Falló!';
$_lang["import_site_failed_db_error"] = 'Un error de base de datos ocurrió mientras se trataba de clonar el documento: ';
$_lang["import_site_failed_no_open_dir"] = 'No se pudo abrir el directorio: ';
$_lang["import_site_failed_no_retrieve_file"] = 'No se pudo traer el archivo: ';
$_lang["import_site_html"] = 'Importar sitio desde HTML';
$_lang["import_site_importing_document"] = 'Importando archivo <b>%s</b> ';
$_lang["import_site_maxtime"] = 'Máximo tiempo de importación:';
$_lang["import_site_maxtime_message"] = 'Aquí puedes especificar el número de segundos permitidos por el Administrador de Contenidos para importar el sitio (sobrepasando la configuración de PHP). Ingresa 0 para un tiempo ilimitado.  Por favor nota, que usar un tiempo 0, o un número realmente grande, pueden provocar cosas extrañas en tu servidor y no es recomendado.';
$_lang["import_site_message"] = 'Usando esta función puedes importar un sitio HTML completo a la base de datos.  Por favor nota que necesitarás copiar tus archivos html y/o carpetas dentro de la carpeta assets/import.<p />Por favor llena la forma y presiona \'Importar\' para comenzar el proceso de importación.  Los archivos importados serán guardados en el lugar seleccionada, utilizando, cuando sea posible, el nombre de archivo como el  alias del documento y el título de página como el título del documento.';
$_lang["import_site_skip"] = '¡Saltado!';
$_lang["import_site_start"] = 'Comenzar importación';
$_lang["import_site_success"] = '¡Éxito!';
$_lang["import_site_time"] = 'Importación finalizada.  Ha tomado %s segundos para completarse.';
$_lang["inbox"] = 'Bandeja de entrada';
$_lang["info"] = 'Info';
$_lang["information"] = 'Información';
$_lang["inline"] = 'En linea';
$_lang["insert"] = 'Insertar';
$_lang["maxImageWidth"] = 'Ancho máximo de la imagen';
$_lang["maxImageHeight"] = 'Altura máxima de la imagen';
$_lang["clientResize"] = 'Resize images on client-side';
$_lang["clientResize_message"] = 'If enabled then images will be resized by browser before upload to the server';
$_lang["noThumbnailsRecreation"] = 'Create thumbnails on upload only';
$_lang["noThumbnailsRecreation_message"] = 'File browser will create thumbnails only on upload; if there\'s no thumbnails for some images, they will not be created';
$_lang["thumbWidth"] = 'Ancho máximo de la miniatura';
$_lang["thumbHeight"] = 'Altura máxima de la miniatura';
$_lang["thumbsDir"] = 'Thumbnails directory location';
$_lang["jpegQuality"] = 'Compresión JPEG';
$_lang["denyZipDownload"] = 'Disable zip-archives downloading';
$_lang["denyExtensionRename"] = 'Deshabilitar el cambio de nombre de las extensiones de archivo';
$_lang["maxImageWidth_message"] = 'If uploaded image resolution exceeds this setting it will be automatically resized. Set 0 to avoid.';
$_lang["maxImageHeight_message"] = 'If uploaded image resolution exceeds this setting it will be automatically resized. Set 0 to avoid.';
$_lang["thumbWidth_message"] = 'Ancho máximo de la miniatura.';
$_lang["thumbHeight_message"] = 'Altura máxima de la miniatura.';
$_lang["thumbsDir_message"] = 'El nombre del directorio de miniaturas.';
$_lang["jpegQuality_message"] = 'JPEG compression quality of thumbnails and resized images';
$_lang["showHiddenFiles"] = 'Mostrar archivos ocultos en el buscador de archivos';
$_lang["keyword"] = 'Palabra clave';
$_lang["keywords"] = 'Palabras clave';
$_lang["keywords_intro"] = 'Para editar una palabra clave, simplemente escribe la nueva palabra clave en el campo de texto adyacente a la palabra clave que desees cambiar.  Para borrar una palabra clave, selecciona la caja \'borrar\' para esa palabra clave.  Si seleccionas la caja de borrar de la palabra clave, y también le cambias su nombre, será borrada ¡y el renombrado de la palabra clave no tendrá efecto!';
$_lang["language_message"] = 'Seleccione el idioma para el Administrador de Contenido de EVO.';
$_lang["language_title"] = 'Idioma:';
$_lang["last_update"] = 'Última actualización';
$_lang["launch_site"] = 'Ver el sitio';
$_lang["license"] = 'Licencia';
$_lang["link_attributes"] = 'Atributos de enlace';
$_lang["link_attributes_help"] = 'Ingresa atributos opcionales para un enlace para esta página, tal como "target=" o "rel=".';
$_lang["list_mode"] = 'Habilitar o deshabilitar el modo de listado - usado para listar todos los registros en el cuadriculado.';
$_lang["loading_doc_tree"] = 'Cargando árbol de documentos...';
$_lang["loading_menu"] = 'Cargando menú...';
$_lang["loading_page"] = 'Por favor espera mientras EVO carga la página...';
$_lang["localtime"] = 'Tiempo local';
$_lang["lock_htmlsnippet"] = 'Bloquear edición de chunk';
$_lang["lock_htmlsnippet_msg"] = 'Solamente administradores (Rol ID 1) pueden editar este chunk.';
$_lang["lock_module"] = 'Bloquear edición de modulo';
$_lang["lock_module_msg"] = 'Solamente administradores (Rol ID 1) pueden editar este modulo.';
$_lang["lock_msg"] = '%s está actualmente editando este %s. Por favor, espera hasta que el otro usuario haya terminado e intenta nuevamente.';
$_lang["lock_plugin"] = 'Bloquear edición del plugin';
$_lang["lock_plugin_msg"] = 'Solamente administradores (Rol ID 1) pueden editar este plugin.';
$_lang["lock_settings_msg"] = '%s está actualmente editando esta configuración. Por favor, espera hasta que el otro usuario haya terminado e intenta nuevamente.';
$_lang["lock_snippet"] = 'Bloquear edición del snippet';
$_lang["lock_snippet_msg"] = 'Solamente administradores (Rol ID 1) pueden editar este snippet.';
$_lang["lock_template"] = 'Bloquear edición del template';
$_lang["lock_template_msg"] = 'Solamente administradores (Rol ID 1) pueden editar este template.';
$_lang["lock_tmplvars"] = 'Bloquear edición de la variable';
$_lang["lock_tmplvars_msg"] = 'Solamente administradores (Rol ID 1) pueden editar esta variable.';
$_lang["locked"] = 'Bloqueado';
$_lang["login_allowed_days"] = 'Días permitidos';
$_lang["login_allowed_days_message"] = 'Selecciona los días en los que este usuario está permitido a iniciar una sesión.';
$_lang["login_allowed_ip"] = 'Dirección IP permitida';
$_lang["login_allowed_ip_message"] = 'Ingresa las direcciones IP con las que este usuario tiene permitido iniciar sesión. <b>NOTA: Separa múltiples direcciones de IP mediante comas (,)</b>';
$_lang["login_button"] = 'Entrar';
$_lang["login_cancelled_install_in_progress"] = 'Este sitio está en el proceso de instalación/actualización. <br />¡Favor de volver a intentarlo en un par de minutos!.<br />';
$_lang["login_cancelled_site_was_updated"] = 'Se acaba de ejecutar una instalación/actualización de este sitio. Favor de volver a entrar.<br />';
$_lang["login_captcha_message"] = 'Por favor, ingresa el código de seguridad mostrado en la gráfica.  Si no puedes leer el código, haz clic en la imagen para generar una nueva o contacta a tu administrador del sitio.';
$_lang["login_homepage"] = 'Página de entrada';
$_lang["login_homepage_message"] = 'Ingresa el ID del documento al que quieres enviar al usuario después que haya entrado. <b>NOTA: asegúrate de que el ID que ingreses pertenezca a un documento existente, que ha sido publicado y que es accesible por el usuario.</b>';
$_lang["login_message"] = 'Por favor ingresa tus credenciales de entrada para comenzar tu sesión en el Administrador.  Tu nombre de usuario y contraseña son sensitivas a las mayúsculas, por favor ingrésalas con cuidado.';
$_lang["logo_slogan"] = 'Administrador de Contenido EVO - \nCrea y haz más con menos';
$_lang["logout"] = 'Salir';
$_lang["long_title"] = 'Título largo';
$_lang["mail_check_timeperiod_message"] = 'Que tan frecuente checar por mensajes de correo nuevos en el Admin, en segundos.';
$_lang["mail_check_timeperiod_title"] = 'Período de chequeo del correo:';
$_lang["manage_depends"] = 'Admin Dependencias';
$_lang["manage_files"] = 'Admin Archivos';
$_lang["manage_htmlsnippets"] = 'Chunks';
$_lang["manage_metatags"] = 'Admin etiquetas META y Palabras claves';
$_lang["manage_modules"] = 'Admin Modulos';
$_lang["manage_plugins"] = 'Plugins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Templates';
$_lang["manage_documents"] = 'Documents';
$_lang["manager"] = 'Administrador';
$_lang["manager_lockout_message"] = 'Estás actualmente dentro del Administrador de Contenido.  Si deseas cerrar tu sesión por favor haz clic en el botón de "Salir". <p />Para ir a tu página de inicio o página principal, haz clic en el botón de "Inicio".';
$_lang["manager_permissions"] = 'Permisos del Administrador';
$_lang["manager_theme"] = 'Tema del Administrador:';
$_lang["manager_theme_message"] = 'Selecciona el tema para el Administrador de Contenido.';
$_lang["manager_theme_mode"] = 'Esquema de colores:';
$_lang["manager_theme_mode1"] = 'todo es claro';
$_lang["manager_theme_mode2"] = 'el encabezado es oscuro';
$_lang["manager_theme_mode3"] = 'el encabezado y la barra lateral son oscuros';
$_lang["manager_theme_mode4"] = 'todo esta oscuro';
$_lang['manager_theme_mode_message'] = 'This setting is used as the "default" and can be overridden by the manager when using the theme color mode switch button in the Resource Tree: <i class="fa fa-lg fa-adjust"></i>';
$_lang['manager_theme_mode_title'] = 'Theme color mode switch';
$_lang["messages"] = 'Mensajes';
$_lang["messages_all"] = 'Todos';
$_lang["messages_compose"] = 'Escribe un mensaje';
$_lang["messages_forward"] = 'Reenviar';
$_lang["messages_from"] = 'Desde';
$_lang["messages_group"] = 'Un grupo';
$_lang["messages_inbox"] = 'Bandeja de entrada';
$_lang["messages_message"] = 'Mensaje';
$_lang["messages_no_messages"] = 'No hay mensajes en la bandeja de entrada.';
$_lang["messages_not_allowed_to_read"] = '¡No tienes permitido leer este mensaje!';
$_lang["messages_private"] = 'Privado';
$_lang["messages_read_message"] = 'Leer mensaje';
$_lang["messages_reply"] = 'Responder';
$_lang["messages_select_group"] = 'Selecciona un grupo';
$_lang["messages_select_user"] = 'Selecciona un usuario';
$_lang["messages_send"] = 'Enviar';
$_lang["messages_send_to"] = 'Enviar a';
$_lang["messages_sent"] = 'Enviar en';
$_lang["messages_subject"] = 'Asunto';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'Mensajes';
$_lang["messages_user"] = 'Un usuario';
$_lang["meta_keywords"] = 'Palabras Clave META';
$_lang["metatag_intro"] = 'En esta página puedes borrar, crear o editar Etiquetas META (METAtags).  Para enlazar etiquetas META a documentos haz clic en la pestaña <u>Palabras Clave META</u> cuando edites el documento y selecciona las etiquetas META y las Palabras Clave deseadas.  Para añadir una etiqueta nueva ingresa el nombre y valor y haz clic en el botón \'Agregar etiqueta\'.  Para editar la etiqueta haz clic en el nombre de la etiqueta dentro de la cuadrícula de datos.';
$_lang["metatag_notice"] = 'Quizá quieras ver la <a href="http://www.html-reference.com/META.asp" target="_blank">Guía de Referencia HTML</a> para más información.  Esta no es una lista completa de posibles etiquetas Meta.</a>';
$_lang["metatags"] = 'Etiquetas META';
$_lang["mgr_access_permissions"] = 'Permisos de acceso al Administrador';
$_lang["mgr_login_start"] = 'Inicio de Entrada al Administrador';
$_lang["mgr_login_start_message"] = 'Ingresa el ID del documento al que quieres enviar al usuario después de que haya salido del Administrador.  <b>NOTA: asegúrate de que el ID ingresado pertenece a un documento existente, y que ha sido publicado ¡y es accesible por el usuario!</b>';
$_lang["mgrlog_action"] = 'Acción';
$_lang["mgrlog_actionid"] = 'ID de acción';
$_lang["mgrlog_anyall"] = 'Cualquiera/Todos';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() regresó falso.';
$_lang["mgrlog_datefr"] = 'Fecha de';
$_lang["mgrlog_dateinvalid"] = 'Formato de fecha no válido.';
$_lang["mgrlog_dateto"] = 'Fecha para';
$_lang["mgrlog_emptysrch"] = 'Tu consulta de búsqueda ha obtenido un conjunto de resultados vacío (por ej. no hay coincidencias de registros encontrados).';
$_lang["mgrlog_field"] = 'Campo';
$_lang["mgrlog_itemid"] = 'ID del Artículo';
$_lang["mgrlog_itemname"] = 'Nombre del Artículo';
$_lang["mgrlog_msg"] = 'Mensaje';
$_lang["mgrlog_noquery"] = 'No se ha ingresado una consulta de búsqueda todavía.';
$_lang["mgrlog_qresults"] = 'Resultados de Consulta';
$_lang["mgrlog_query"] = 'Bitácora de Consultas';
$_lang["mgrlog_query_msg"] = 'Por favor haz una selección para ver la bitácora.  Puedes seleccionar entradas en la bitácora por fecha, pero está alerta de que las fechas que ingreses no sean inclusivas - para seleccionar todos las entradas a la bitácora del 01-01-2004, configura \'fecha de\' como 01-01-2004 y \'fecha a\' como 02-01-2004.<br /><br />El mensaje y la acción son generalmente lo mismo.  Si estás buscando por un mensaje específico, es mejor configurar acción como \'Cualquiera/Todos\'.';
$_lang["mgrlog_results"] = 'No. de resultados';
$_lang["mgrlog_searchlogs"] = 'Registro de búsquedas';
$_lang["mgrlog_sortinst"] = 'Puedes ordenar las tablas haciendo clic en los encabezados de columna. Si las bitácoras están llegando a ser muy grandes, puedes <a href="index.php?a=55">vaciar</a> las bitácoras. Esto removerá todas las entradas de la bitácora hasta ahora y ¡no puede ser deshecho!';
$_lang["mgrlog_time"] = 'Tiempo';
$_lang["mgrlog_user"] = 'Usuario';
$_lang["mgrlog_username"] = 'Nombre de usuario';
$_lang["mgrlog_value"] = 'Valor';
$_lang["mgrlog_view"] = 'Ver registros del Administrador';
$_lang["module_code"] = 'Código de módulo (php)';
$_lang["module_config"] = 'Configuración de modulo';
$_lang["module_desc"] = 'Descripción';
$_lang["module_disabled"] = 'Modulo deshabilitado';
$_lang["module_edit_click_title"] = 'Haz clic aquí para editar este módulo';
$_lang["module_group_access_msg"] = 'Selecciona los grupos de usuarios que tienen permitido ejecutar este módulo desde el Administrador de Contenido.';
$_lang["module_management"] = 'Administrar Módulos';
$_lang["module_management_msg"] = 'Elige el módulo que quisieras ejecutar o modificar. Para correr el módulo haz clic en el icono en la cuadrícula. Para modificarlo ´haz clic en el nombre del módulo.';
$_lang["module_msg"] = 'Añadir/editar Módulos. Un Módulo es una colección de Elementos (ej. plugins, snippets, etc).';
$_lang["module_name"] = 'Nombre del módulo';
$_lang["module_resource_msg"] = 'Añade o remueve Elementos de los que depende este módulo. Para añadir un Elemento nuevo haz clic en uno de los botones de añadir aquí debajo.';
$_lang["module_resource_title"] = 'Dependencias del módulo';
$_lang["module_title"] = 'Crear/editar Módulo';
$_lang["module_viewdepend_msg"] = 'Ve los Elementos asignados de los que depende este módulo.  Haz clic en el botón "Dependencias del Admin" para modificar las dependencias';
$_lang["modules"] = 'Módulos';
$_lang["modx_news"] = 'Noticias de EVO';
$_lang["modx_news_tab"] = 'Noticias de EVO';
$_lang["modx_news_title"] = 'Noticias de EVO';
$_lang["modx_security_notices"] = 'Notas de Seguridad de EVO';
$_lang["modx_version"] = 'Versión de EVO';
$_lang["monday"] = 'Lunes';
$_lang["move"] = 'Mover';
$_lang["move_resource"] = 'Mover documento';
$_lang["move_resource_message"] = 'Puedes mover el documento y todos sus hijos seleccionando un nuevo padre en el árbol.  Si seleccionas un documento que no es un contenedor, será combiado a uno.  Por favor, haz clic en el nuevo padre en el árbol.';
$_lang["move_resource_new_parent"] = 'Por favor selecciona un nuevo padre en el árbol de documentos.';
$_lang["move_resource_title"] = 'Mover documento';
$_lang["name"] = 'Nombre';
$_lang["new_category"] = 'Categoría Nueva';
$_lang["new_file_permissions_message"] = 'Cuando se esté subiendo un  archivo nuevo en el Administrador de Archivos, este intentará cambiar los permisos a los ingresados en esta configuración.  Esto puede que no funcione en algunas configuraciones, tales como en IIS, en cuyo caso necesitarás cambiar manualmente los permisos.';
$_lang["new_file_permissions_title"] = 'Permisos del Archivo Nuevo';
$_lang["new_folder_permissions_message"] = 'Cuando se esté creando una  carpeta nueva en el Administrador de Archivos, este intentará cambiar los permisos a los ingresados en esta configuración.  Esto puede que no funcione en algunas configuraciones, tales como en IIS, en cuyo caso necesitarás cambiar manualmente los permisos.';
$_lang["new_folder_permissions_title"] = 'Permisos de la Carpeta Nueva';
$_lang["new_htmlsnippet"] = 'Chunk nuevo';
$_lang["new_keyword"] = 'Añadir palabra clave nueva:';
$_lang["new_module"] = 'Módulo nuevo';
$_lang["new_parent"] = 'Padre nuevo';
$_lang["new_plugin"] = 'Plugin nuevo';
$_lang["new_role"] = 'Crear un rol nuevo';
$_lang["new_snippet"] = 'Snippet nuevo';
$_lang["new_template"] = 'Template nuevo';
$_lang["new_tmplvars"] = 'Variable de template nueva';
$_lang["new_user"] = 'Usuario nuevo';
$_lang["new_web_user"] = 'Usuario Web nuevo ';
$_lang["new_resource"] = 'Nuevo Recurso';
$_lang["no"] = 'No';
$_lang["no_active_users_found"] = 'No se encontraron usuarios activos.';
$_lang["no_activity_message"] = 'No has creado o editado algún documento todavía.';
$_lang["no_category"] = 'no categorizado';
$_lang["no_docs_pending_publishing"] = 'No hay documentos con publicación pendiente.';
$_lang["no_docs_pending_pubunpub"] = 'No se encontraron Eventos';
$_lang["no_docs_pending_unpublishing"] = 'No hay documentos con despublicación pendiente.';
$_lang["no_edits_creates"] = 'No se encontraron ediciones o creaciones.';
$_lang["no_groups_found"] = 'No se encontraron Grupos.';
$_lang["no_keywords_found"] = 'Actualmente no hay palabras clave.';
$_lang["no_records_found"] = 'No se encontraron registros.';
$_lang["no_results"] = 'No se encontraron resultados';
$_lang["nologentries_message"] = 'Ingresa el número de entradas de bitácora  mostradas por página cuando navegue por la Auditoría.';
$_lang["nologentries_title"] = 'Número de entradas de registro:';
$_lang["nomessages_message"] = 'Ingresa el número de mensajes a mostrar en la bandeja de entrada cuando veas mensajes.';
$_lang["nomessages_title"] = 'Número de mensajes:';
$_lang["none"] = 'Ninguno';
$_lang["noresults_message"] = 'Ingresa el número de resultados a mostrar en la cuadrícula de datos cuando veas listados y resultados de búsqueda.';
$_lang["noresults_title"] = 'Número de Resultados:';
$_lang["not_deleted"] = 'no ha sido borrado.';
$_lang["not_set"] = 'No configurado';
$_lang["offline"] = 'Fuera de línea';
$_lang["online"] = 'En línea';
$_lang["onlineusers_action"] = 'Acción';
$_lang["onlineusers_actionid"] = 'ID-de-Acción';
$_lang["onlineusers_ipaddress"] = 'Dirección IP del usuario';
$_lang["onlineusers_lasthit"] = 'Última visita';
$_lang["onlineusers_message"] = 'Esta lista muestra todos los usuarios activos durante los últimos 20 minutos (la hora actual es ';
$_lang["onlineusers_title"] = 'Usuarios en línea';
$_lang["onlineusers_user"] = 'Usuario';
$_lang["onlineusers_userid"] = 'ID de usuario';
$_lang["optimize_table"] = 'Haz clic aquí para optimizar esta tabla';
$_lang["page_data_alias"] = 'Alias';
$_lang["page_data_cacheable"] = 'Cacheable';
$_lang["page_data_cacheable_help"] = 'Dejando este campo seleccionado permitirá que el documento sea guardado en el cache.  Si tu documento contiene snippets, asegúrate de que este campo no esté seleccionado.';
$_lang["page_data_cached"] = '<b>Fuente obtenida desde el cache:</b>';
$_lang["page_data_changes"] = 'Cambios';
$_lang["page_data_contentType"] = 'Tipo de Contenido';
$_lang["page_data_contentType_help"] = 'Selecciona el tipo de contenido para  este documento.  Si no estás seguro de qué tipo de contenido debe de tener el documento, simplemente déjalo como text/html.';
$_lang["page_data_created"] = 'Creado';
$_lang["page_data_edited"] = 'Editado';
$_lang["page_data_editor"] = 'Editar usando el editor de texto formateado';
$_lang["page_data_folder"] = 'El documento es contenedor';
$_lang["page_data_general"] = 'General';
$_lang["page_data_markup"] = 'Marcado/estructura';
$_lang["page_data_mgr_access"] = 'Acceso del Administrador';
$_lang["page_data_notcached"] = 'Este documento (todavía) no ha sido cacheado.';
$_lang["page_data_publishdate"] = 'Fecha de publicación';
$_lang["page_data_publishdate_help"] = 'Si configuras una fecha de publicación, el documento serpa publicado tan pronto como la fecha de publicación sea efectiva.  Haz clic en el icono de calendario para seleccionar una fecha, o en el icono junto al mismo para remover la fecha de publicación.  Esto significará que el documento nunca será automáticamente publicado.';
$_lang["page_data_published"] = 'Publicado';
$_lang["page_data_searchable"] = 'Buscable';
$_lang["page_data_searchable_help"] = 'Checando este campo permitirá al documento ser buscado.  También puedes usar este campo para otros propósitos en tus snippets.';
$_lang["page_data_source"] = 'Fuente';
$_lang["page_data_status"] = 'Estado';
$_lang["page_data_template"] = 'Usar template';
$_lang["page_data_template_help"] = 'Seleccionar template para este documento.';
$_lang["page_data_title"] = 'Datos de la Página';
$_lang["page_data_unpublishdate"] = 'Fecha de despublicación';
$_lang["page_data_unpublishdate_help"] = 'Si configuras una fecha de despublicación, el documento será despublicado tan pronto como la fecha de despublicacíón sea efectiva.  Haz clic en el icono de calendario para seleccionar una fecha, o en el icono junto al mismo para remover la fecha de despublicación.  Esto significará que el documento nunca será automáticamente despublicado.';
$_lang["page_data_unpublished"] = 'Despublicado';
$_lang["page_data_web_access"] = 'Acceso web';
$_lang["pagetitle"] = 'Título del documento';
$_lang["pagination_table_first"] = 'Primero';
$_lang["pagination_table_gotopage"] = 'Ir a la página';
$_lang["pagination_table_last"] = 'Último';
$_lang["paging_first"] = 'primero';
$_lang["paging_last"] = 'último';
$_lang["paging_next"] = 'siguiente';
$_lang["paging_prev"] = 'previo';
$_lang["paging_showing"] = 'Mostrando';
$_lang["paging_to"] = 'a';
$_lang["paging_total"] = 'total';
$_lang["parameter"] = 'Parámetro';
$_lang["parse_docblock"] = 'Parse DocBlock';
$_lang["parse_docblock_msg"] = 'Attention (!): <b>Resets</b> actual name, configuration, description and category to install-defaults by parsing the source code.';
$_lang["password"] = 'Contraseña';
$_lang["password_change_request"] = 'Solicitud de cambio de contraseña';
$_lang["password_gen_gen"] = 'Deja que EVO genere una contraseña.';
$_lang["password_gen_length"] = 'La contraseña que especificaste necesita  tener al menos 6 caracteres.';
$_lang["password_gen_method"] = 'Método de contraseña nuevo';
$_lang["password_gen_specify"] = 'Déjame especificar la contraseña:';
$_lang["password_method"] = 'Método de notificación de contraseña';
$_lang["password_method_email"] = 'Enviar la contraseña nueva por email.';
$_lang["password_method_screen"] = 'Mostrar la contraseña nueva en la pantalla.';
$_lang["password_msg"] = 'La contraseña nueva para <b>%s</b> es <b>%s</b>.';
$_lang["php_version_check"] = 'EVO es compatible con PHP Versión 5.0.0 y superior.  Por favor ¡actualiza tu instalación de PHP!';
$_lang["plugin"] = 'Plugin';
$_lang["plugins"] = 'Plugins';
$_lang["plugin_code"] = 'Código de plugin(php)';
$_lang["plugin_config"] = 'Configuración de plugin';
$_lang["plugin_desc"] = 'Descripción';
$_lang["plugin_disabled"] = 'Plugin deshabilitado';
$_lang["plugin_event_msg"] = 'Selecciona los eventos que quisieras que este plugin escuchara.';
$_lang["plugin_management_msg"] = 'Elige qué plugin quieres editar.';
$_lang["plugin_msg"] = 'Añadir/editar plugins.  Los plugins usan código PHP que es invocado cuando los dispara un Evento del Sistema específico.';
$_lang["plugin_name"] = 'Nombre del plugin';
$_lang["plugin_priority"] = 'Editar el orden de Ejecución de Plugins por Evento';
$_lang["plugin_priority_instructions"] = 'Arrastra para re-ordenar los Plugins bajo cada encabezado de Eventos.  El primer plugin en ejecutarse deberá ir hasta arriba.';
$_lang["plugin_priority_title"] = 'Orden de Ejecución de Plugins';
$_lang["purge_plugin"] = 'Purge obsolete plugins';
$_lang["purge_plugin_confirm"] = 'Are you sure you want to purge obsolete plugins?';
$_lang["plugin_title"] = 'Crear/editar Plugin';
$_lang["preview"] = 'Previsualizar';
$_lang["preview_msg"] = 'Esta es una previsualización de tus últimos cambios guardados.  Haz clic aquí para <a href="javascript:;" onclick="saveRefreshPreview();">Guardar y Recargar</a> tus cambios actuales';
$_lang["preview_resource"] = 'Previsualizar documento';
$_lang["private"] = 'Privado';
$_lang["public"] = 'Público';
$_lang["publish_date"] = 'Fecha de publicación';
$_lang["publish_events"] = 'Publicar eventos';
$_lang["publish_resource"] = 'Publicar documento';
$_lang["rb_base_dir_message"] = 'Ingresa la dirección física del directorio del Navegador de Archivos.  Esta configuración es normalmente generada automáticamente.  Si estás usando IIS, sin embargo, EVO tal vez no pueda encontrar la dirección por si mismo, causando que el Navegador de Archivos muestre un error.  En este caso, puedes ingresar la dirección al directorio de imágenes aquí (la dirección como la ves en el Explorador de Windows). <b>NOTA:</b> El directorio del Navegador de Archivos debe contener las  imágenes, archivos, flash y medios de los subdirectorios para que el Navegador de Archivos funcione correctamente.';
$_lang["rb_base_dir_title"] = 'Dirección Base de Archivos:';
$_lang["rb_base_url_message"] = 'Ingresa la dirección virtual al directorio de archivos.  Esta configuración es normalmente generada automáticamente.  Si estás usando IIS, EVO tal vez no pueda encontrar la dirección por si mismo, causando que el Navegador de Archivos muestre un error.  En este caso, puede ingresar la dirección al directorio de imágenes aquí (la dirección como la ves en el Explorador de Windows).';
$_lang["rb_base_url_title"] = 'URL del Navegador de Archivos:';
$_lang["rb_message"] = 'Selecciona si para habilitar el Navegador de Archivos.  Esto permitirá a tus usuarios navegar y subir archivos como imágenes, flash y medios al servidor.';
$_lang["rb_title"] = 'Habilitar el Navegador de Archivos:';
$_lang["rb_webuser_message"] = '¿Quieres permitir a un usuario web la habilidad de usar el Navegador de Archivos? <b>ADVERTENCIA:</b> Permitiendo a los usuarios web el uso del navegador de archivos expone los archivos disponibles a los usuarios administrativos.  Sólo usa esta opción para usuarios web confiables.';
$_lang["rb_webuser_title"] = '¿Usuarios Web?';
$_lang["recent_docs"] = 'Documentos recientes';
$_lang["recommend_setting_change_title"] = 'Recommended Setting Change';
$_lang["recommend_setting_change_description"] = 'Your site is not configured to validate the HTTP_REFERER of incoming requests to the Manager. We strongly recommend enabling this setting to reduce the risk of a CSRF (Cross Site Request Forgery) attack.';
$_lang["references"] = 'Referencias';
$_lang["refresh_cache"] = 'Cache: Se encontraron <b>%s</b> archivos en el directorio cache y se borraron <b>%d</b> archivos cacheados.<p>Los nuevos archivos cacheados serán creados cuando las páginas sean solicitadas.';
$_lang["refresh_published"] = '<b>%s</b> documentos fueron publicados.';
$_lang["refresh_site"] = 'Limpiar cache';
$_lang["refresh_title"] = 'Recargar sitio';
$_lang["refresh_tree"] = 'Recargar árbol';
$_lang["refresh_unpublished"] = '<b>%s</b> documentos fueron despublicados.';
$_lang["release_date"] = 'Release date';
$_lang["remember_last_tab"] = 'Remember tabs';
$_lang["remember_last_tab_message"] = 'Tabbed Manager pages load with the last tab viewed instead of defaulting to the first tab';
$_lang["remember_username"] = 'Recordarme';
$_lang["remove"] = 'Remover';
$_lang["remove_date"] = 'Remover fecha';
$_lang["remove_locks"] = 'Remover Bloqueos';
$_lang["rename"] = 'Renombrar';
$_lang["reports"] = 'Reportes';
$_lang["report_issues"] = 'Reportar problemas';
$_lang["require_tagname"] = 'Un nombre de etiqueta es requerido';
$_lang["require_tagvalue"] = 'Un valor para la etiqueta es requeridos';
$_lang["reserved_name_warning"] = 'You have used a reserved name.';
$_lang["reset"] = 'Reajustar';
$_lang["reset_failedlogins"] = 'reajustar';
$_lang["reset_sort_order"] = 'Restablecer el orden de clasificación';
$_lang["resource"] = 'Documento';
$_lang["resource_alias"] = 'Alias del documento';
$_lang["resource_alias_help"] = 'Configura el alias del URL para hacer el documento accesible como http://ejemplo.com/alias.  Esto sólo funciona si los URLs amigables están habilitados en la configuración del sitio.';
$_lang["resource_content"] = 'Contenido del documento';
$_lang["resource_description"] = 'Descripción';
$_lang["resource_description_help"] = 'Puedes escribir una descripción opcional del documento.';
$_lang["resource_duplicate"] = 'Duplicar Documento';
$_lang["resource_long_title_help"] = 'Escribe un título más largo para tu documento.  Esto es bueno para los buscadores, y puede ser más descriptivo para tu documento.';
$_lang["resource_metatag_help"] = 'Selecciona las etiquetas META o palabras clave que desea asignar a este documento. Mantén presionada la tecla CTRL para seleccionar múltiples palabras clave o etiquetas META.';
$_lang["resource_opt_contentdispo"] = 'Disposición del contenido';
$_lang["resource_opt_contentdispo_help"] = 'Usa el campo de disposición del contenido para especificar cómo debe ser manejado este documento por el navegador. Para descarga de archivos selecciona la opción de Adjunto.';
$_lang["resource_opt_emptycache"] = '¿Vaciar Cache?';
$_lang["resource_opt_emptycache_help"] = 'Dejando marcado este campo hará que EVO vacíe el cache después de que guardes el documento. De esta forma tus visitantes no verán una versión vieja del documento.';
$_lang["resource_opt_folder"] = '¿Contenedor?';
$_lang["resource_opt_folder_help"] = 'Selecciona esto para hacer que el documento también actúe como un contenedor de otros documentos. Un \'contenedor\' es como una carpeta, sólo que también puede tener contenido.';
$_lang["resource_opt_menu_index"] = 'Indice del menú';
$_lang["resource_opt_menu_index_help"] = 'El Indice del menú es un campo que puedes usar para ordenar los documentos en tus snippet(s) de menú. También puedes usarlo para cualquier otro propósito en tus snippets.';
$_lang["resource_opt_menu_title"] = 'Título del menú';
$_lang["resource_opt_menu_title_help"] = 'El Título del menú es un campo que puedes usar para mostrar un título corto para el documento dentro de tus snippet(s) de menú o módulos.';
$_lang["resource_opt_published"] = '¿Publicado?';
$_lang["resource_opt_published_help"] = 'Selecciona este campo para publicar el documento inmediatamente después de guardarlo.';
$_lang["resource_opt_richtext"] = '¿Texto Formateado?';
$_lang["resource_opt_richtext_help"] = 'Deja este campo seleccionado para utilizar el editor de texto formateado para editar documentos. Si tus documentos contienen JavaScript y formas, deselecciona esto para editarlos en modo HTML y así el editor no deshace tus documentos.';
$_lang["resource_opt_show_menu"] = 'Mostrar en menú';
$_lang["resource_opt_show_menu_help"] = 'Selecciona esta opción para mostrar el documento dentro de un menú web. Por favor nota que algunos constructores de menús pueden elegir ignorar esta opción.';
$_lang["resource_opt_trackvisit_help"] = 'Registrar cada visita del visitante a esta página';
$_lang["resource_overview"] = 'Vista general del documento';
$_lang["resource_parent"] = 'Padre del documento';
$_lang["resource_parent_help"] = 'Haz clic en el icono de arriba para habilitar (o deshabilitar) seleccionar el padre de este documento. Luego, haz clic en un documento del árbol para seleccionar su nuevo padre.';
$_lang["resource_permissions_error"] = 'Asigna este Documento a por lo menos un Grupo de Documentos al que puedas acceder.';
$_lang["resource_setting"] = 'Configuración de documento';
$_lang["resource_summary"] = 'Resumen (introtext)';
$_lang["resource_summary_help"] = 'Escribe un resumen corto del documento';
$_lang["resource_title"] = 'Título';
$_lang["resource_title_help"] = 'Escribe aquí el nombre/título del documento. ¡Trata de evitar el uso de barras diagonales en el nombre!';
$_lang["resource_to_be_moved"] = 'Documento a mover';
$_lang["resource_type"] = 'Tipo de recurso';
$_lang["resource_type_message"] = 'Weblinks reference Resources on the Internet including another EVO Resource, an external page, or an image or other file on the Internet. Weblinks should have a text/html Internet Media Type and Inline Content-Disposition.';
$_lang["resource_type_weblink"] = 'Weblink';
$_lang["resource_type_webpage"] = 'Página web';
$_lang["resource_weblink_help"] = 'Escribe la dirección del objeto que deseas referenciar con este enlace web aquí.';
$_lang["resources_in_container"] = 'documentos en este contenedor';
$_lang["resources_in_container_no"] = 'Este contenedor no tiene documentos-hijos.';
$_lang["role"] = 'Rol';
$_lang["role_about"] = 'Ver la página Nosotros';
$_lang["role_access_persmissions"] = 'Permisos de acceso';
$_lang["role_actionok"] = 'Ver la pantalla de acción completada';
$_lang["role_assets_images"] = 'Manage assets/images';
$_lang["role_assets_files"] = 'Manage assets/files';
$_lang["role_bk_manager"] = 'Usar el Administrador de Respaldo';
$_lang["role_cache_refresh"] = 'Vaciar la cache del sitio';
$_lang["role_category_manager"] = 'Use the Category Manager';
$_lang["role_change_password"] = 'Cambiar la contraseña';
$_lang["role_change_resourcetype"] = 'Cambio del tipo de recurso';
$_lang["role_chunk_management"] = 'Administración de Chunks';
$_lang["role_config_management"] = 'Administración de la configuración';
$_lang["role_content_management"] = 'Administración de contenido';
$_lang["role_create_chunk"] = 'Crear chunks nuevos';
$_lang["role_create_doc"] = 'Crear documentos nuevos';
$_lang["role_create_plugin"] = 'Crear plugins nuevos';
$_lang["role_create_snippet"] = 'Crear snippets nuevos';
$_lang["role_create_template"] = 'Crear templates del sitio nuevos';
$_lang["role_credits"] = 'Ver los créditos';
$_lang["role_delete_chunk"] = 'Borrar chunks';
$_lang["role_delete_doc"] = 'Borrar documentos';
$_lang["role_delete_eventlog"] = 'Borrar bitácora de eventos';
$_lang["role_delete_module"] = 'Borrar módulo';
$_lang["role_delete_plugin"] = 'Borrar plugins';
$_lang["role_delete_role"] = 'Borrar roles';
$_lang["role_delete_snippet"] = 'Borrar snippets';
$_lang["role_delete_template"] = 'Borrar templates';
$_lang["role_delete_user"] = 'Borrar usuarios';
$_lang["role_delete_web_user"] = 'Borrar usuarios web';
$_lang["role_edit_chunk"] = 'Editar chunks';
$_lang["role_edit_doc"] = 'Editar un documento';
$_lang["role_edit_doc_metatags"] = 'Editar las etiquetas META y palabras clave del documento';
$_lang["role_edit_module"] = 'Editar modulo';
$_lang["role_edit_plugin"] = 'Editar plugins';
$_lang["role_edit_role"] = 'Editar roles';
$_lang["role_edit_settings"] = 'Cambiar la configuración del sitio';
$_lang["role_edit_snippet"] = 'Editar snippets';
$_lang["role_edit_template"] = 'Editar templates del sitio';
$_lang["role_edit_user"] = 'Editar usuarios';
$_lang["role_edit_web_user"] = 'Editar usuarios web';
$_lang["role_empty_trash"] = 'Purgar permanentemente documentos borrados';
$_lang["role_errors"] = 'Ver diálogo de error';
$_lang["role_eventlog_management"] = 'Administración del bitácora de eventos';
$_lang["role_export_static"] = 'Exportar HTML Estático';
$_lang["role_file_management"] = 'Gestión de archivos';
$_lang["role_file_manager"] = 'Usar el administrador de archivos';
$_lang["role_frames"] = 'Solicitar marcos del administrador';
$_lang["role_help"] = 'Ver las páginas de ayuda';
$_lang["role_home"] = 'Solicitar página de inicio del administrador';
$_lang["role_import_static"] = 'Importar HTML';
$_lang["role_logout"] = 'Salir del administrador';
$_lang["role_manage_metatags"] = 'Administrar las etiquetas META y las Palabras clave del sitio';
$_lang["role_management_msg"] = 'Elige el rol que deseas editar.';
$_lang["role_management_title"] = 'Roles';
$_lang["role_messages"] = 'Ver y enviar mensajes';
$_lang["role_module_management"] = 'Administración de Módulos';
$_lang["role_name"] = 'Nombre de rol';
$_lang["role_new_module"] = 'Crear un módulo nuevo';
$_lang["role_new_role"] = 'Crear roles nuevos';
$_lang["role_new_user"] = 'Crear usuarios nuevos';
$_lang["role_new_web_user"] = 'Crear usuarios web nuevos';
$_lang["role_plugin_management"] = 'Administración de Plugins';
$_lang["role_publish_doc"] = 'Publicar documentos';
$_lang["role_remove_locks"] = 'Remove Locks';
$_lang["role_role_management"] = 'Roles';
$_lang["role_run_module"] = 'Correr módulo';
$_lang["role_save_chunk"] = 'Guardar chunks';
$_lang["role_save_doc"] = 'Guardar documentos';
$_lang["role_save_module"] = 'Guardar módulo';
$_lang["role_save_password"] = 'Guardar contraseña';
$_lang["role_save_plugin"] = 'Guardar plugins';
$_lang["role_save_role"] = 'Guardar roles';
$_lang["role_save_snippet"] = 'Guardar snippets';
$_lang["role_save_template"] = 'Guardar templates';
$_lang["role_save_user"] = 'Guardar usuarios';
$_lang["role_save_web_user"] = 'Guardar usuarios web';
$_lang["role_snippet_management"] = 'Administración de snippets';
$_lang["role_template_management"] = 'Administración de templates';
$_lang["role_title"] = 'Crear/editar rol';
$_lang["role_udperms"] = 'Administración de permisos';
$_lang["role_user_management"] = 'Administración de usuarios';
$_lang["role_view_docdata"] = 'Ver los datos de un documento';
$_lang["role_view_eventlog"] = 'Ver la bitácora de eventos';
$_lang["role_view_logs"] = 'Ver la bitácora del sistema';
$_lang["role_view_unpublished"] = 'Ver Documentos No Publicados';
$_lang["role_web_access_persmissions"] = 'Permisos de acceso web';
$_lang["role_web_user_management"] = 'Administración de usuarios web';
$_lang["rss_url_news_default"] = 'https://feeds.feedburner.com/evocms-release-news';
$_lang["rss_url_news_message"] = 'Ingresa el URL del Feed de Noticias de EVO.';
$_lang["rss_url_news_title"] = 'Feed RSS de Noticias';
$_lang["rss_url_security_default"] = 'https://feeds.feedburner.com/evocms-security-news';
$_lang["rss_url_security_message"] = 'Ingresa el URL para el Feed de Seguridad EVO.';
$_lang["rss_url_security_title"] = 'Feed RSS de Seguridad';
$_lang["run_module"] = 'Correr módulo';
$_lang["saturday"] = 'Sábado';
$_lang["save"] = 'Guardar';
$_lang["save_all_changes"] = 'Guardar todos los cambios';
$_lang["save_tag"] = 'Guardar etiquetas';
$_lang["saving"] = 'Guardando,favor de esperar...';
$_lang["search"] = 'Buscar';
$_lang["search_criteria"] = 'Criterio de búsqueda';
$_lang["search_criteria_content"] = 'Buscar por contenido';
$_lang["search_criteria_content_msg"] = 'Encontrar todos los documentos con el texto ingresado en su contenido.';
$_lang["search_criteria_id"] = 'Buscar por ID';
$_lang["search_criteria_id_msg"] = 'Ingresar el ID de un documento para encontrar rápidamente ese documento.';
$_lang["search_criteria_top"] = 'Search in main fields';
$_lang["search_criteria_top_msg"] = 'Pagetitle, Longtitle, Alias, ID';
$_lang["search_criteria_template_id"] = 'Buscar por ID de Plantilla';
$_lang["search_criteria_template_id_msg"] = 'Encontrar todos los Recursos que usan una Plantilla especificada.';
$_lang["search_criteria_url_msg"] = 'Find Resource by exact URL.';
$_lang["search_criteria_longtitle"] = 'Buscar por título largo';
$_lang["search_criteria_longtitle_msg"] = 'Buscar todos los documentos con el texto ingresado en su título largo.';
$_lang["search_criteria_title"] = 'Buscar por título';
$_lang["search_criteria_title_msg"] = 'Encontrar todos los documentos con el texto ingresado en su título.';
$_lang["search_empty"] = 'Tu búsqueda no ha regresado resultados. Por favor  amplía tus criterios de búsqueda e inténtalo nuevamente.';
$_lang["search_item_deleted"] = 'Este artículo ha sido borrado';
$_lang["search_results"] = 'Resultados de la búsqueda';
$_lang["search_results_returned_desc"] = 'Descripción';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Tu criterio de búsqueda regresó <b>%s</b> documentos.  Si se han encontrado demasiados resultados, intenta ingresar una búsqueda más especifica.  Las dos columnas a la izquierda te  permiten encontrar el documento en el árbol o ver el documento. Las dos columnas a la derecha muestran, respectivamente, si un documento ha sido borrado y cuál es su estado de publicación.<p />';
$_lang["search_results_returned_title"] = 'Título';
$_lang["search_view_docdata"] = 'Ver este artículo';
$_lang["security"] = 'Seguridad';
$_lang["security_notices_tab"] = 'Notas de Seguridad';
$_lang["security_notices_title"] = 'Notas de Seguridad';
$_lang["select_date"] = 'Selecciona una fecha';
$_lang["send"] = 'Enviar';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Si tu sitio está en una conexión https, por favor especifícalo aquí.';
$_lang["server_protocol_title"] = 'Tipo de servidor:';
$_lang["serveroffset"] = 'Offset del servidor';
$_lang["serveroffset_message"] = 'Selecciona el número de horas de diferencia entre donde te encuentras y donde está el servidor.  La hora  actual del servidor es <b>[%s]</b>, la hora actual del servidor usando el offset guardado actual es <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Hora offset del servidor:';
$_lang["servertime"] = 'Hora del servidor';
$_lang["set_automatic"] = 'Set automatic';
$_lang["set_default"] = 'Set default';
$_lang["set_default_all"] = 'Set defaults';
$_lang["settings_after_install"] = 'Como esta es una nueva instalación, te requiere que controles estas configuraciones, y cambies cualquiera que desees.  Después de que hayas controlado la configuración, presiona \'Guardar\' para actualizar la base de datos de configuración.<br /><br />';
$_lang["settings_config"] = 'Configuración';
$_lang["settings_dependencies"] = 'Dependencias';
$_lang["settings_events"] = 'Eventos del Sistema';
$_lang["settings_furls"] = 'URLs amigables';
$_lang["settings_general"] = 'General';
$_lang["settings_group_tv_message"] = 'Choose if Template Variables should be grouped in sections or tabs (named by TV category) when editing a Resource';
$_lang["settings_group_tv_options"] = 'No,Sections in General tab,Tabs in General tab,Sections in new tab,Tabs in new tab,New tabs';
$_lang["settings_misc"] = 'Administrador de Archivos';
$_lang["settings_security"] = 'Security';
$_lang["settings_KC"] = 'File Browser';
$_lang["settings_page_settings"] = 'Configuración de Página';
$_lang["settings_photo"] = 'Foto';
$_lang["settings_properties"] = 'Propiedades';
$_lang["show_fullscreen_btn_message"] = 'Show Menu toggle Fullscreen button';
$_lang["show_newresource_btn_message"] = 'Show Menu New Resource button';
$_lang["settings_show_picker_message"] = 'Customize manager theme and save to localstorage';
$_lang["show_fullscreen_btn"] = 'Toggle Fullscreen button';
$_lang["show_newresource_btn"] = 'New Resource button';
$_lang["settings_site"] = 'Sitio';
$_lang["settings_strip_image_paths_message"] = 'Si esto está configurado \'No\', EVO escribirá las fuentes del navegador de archivos (imágenes, archivos, flash, etc.) como URLs absolutas.  Las URLs relativas son de ayuda si deseas mover tu instalación de EVO, p.ej. de un servidor de trabajo a uno de producción.  Si no tienes idea de qué significa esto, será mejor lo dejes seleccionado en \'Si\'.';
$_lang["settings_strip_image_paths_title"] = '¿Re-escribir las direcciones del navegador?';
$_lang["settings_templvars"] = 'Variables de Template';
$_lang["settings_title"] = 'Configuración de sistema';
$_lang["settings_ui"] = 'Interfase y Características';
$_lang["settings_users"] = 'Usuario';
$_lang["show_meta"] = 'Show META Keywords tab';
$_lang["show_meta_message"] = 'Show the deprecated META Keywords tab when editing Resources in the Manager.';
$_lang["show_tree"] = 'Mostrar árbol';
$_lang["show_picker"] = 'Show Color Switcher';
$_lang["showing"] = 'Mostrando';
$_lang["signupemail_message"] = 'Configurar el mensaje de email enviado a los usuarios cuando se les cree una cuenta  incluyendo su nombre de usuario y su contraseña. <br /><b>Nota:</b> Los siguiente placeholders son remplazados por el Administrador de Contenido cuando el mensaje es enviado: <br /><br />[+sname+] - Nombre de tu sitio web, <br />[+saddr+] - La dirección electrónica de tu sitio web, <br />[+surl+] - La dirección url de tu sitio, <br />[+uid+] - El nombre o id del usuario, <br />[+pwd+] - La contraseña del usuario, <br />[+ufn+] - El nombre completo del usuario. <br /><br /><b>Deja el [+uid+] y [+pwd+] en el email, o el nombre de usuario y la contraseña no serán enviados en el email ¡y tus usuarios no los conocerán!</b>';
$_lang["signupemail_title"] = 'Correo electrónico de inicio de sesión:';
$_lang["site"] = 'Sitio';
$_lang["site_schedule"] = 'Horario';
$_lang["sitename_message"] = 'Ingresa el nombre de tu sitio aquí.';
$_lang["sitename_title"] = 'Nombre del sitio:';
$_lang["sitestart_message"] = 'Ingresa el ID del documento que quieres usar como página principal aquí. <b>NOTA: Asegúrate de que el ID ingresado pertenece a un documento existente ¡y de que ha sido publicado!</b>';
$_lang["sitestart_title"] = 'Inicio del sitio:';
$_lang["sitestatus_message"] = 'Selecciona \'En Línea\' para publicar tu sitio en la red.  Si seleccionas \'Fuera de Línea\', tus visitantes verán el mensaje de \'Sitio No Disponible\', y no podrán navegar por el mismo.';
$_lang["sitestatus_title"] = 'Estado del sitio:';
$_lang["siteunavailable_message"] = 'Mensaje a mostrar cuando el sitio esté fuera de línea o cuando ocurra un error. <b>Nota: Este mensaje sólo será mostrado si no está activa la página de Sitio no disponible.</b>';
$_lang["siteunavailable_message_default"] = 'Este sitio no está disponible en este momento.';
$_lang["siteunavailable_page_message"] = 'Ingresa el ID del documento que quieres usar como página fuera de línea. <b>NOTA: Asegúrate de que el ID ingresado pertenece a un documento existente ¡y que ha sido publicado!</b>';
$_lang["siteunavailable_page_title"] = 'Página de sitio no disponible:';
$_lang["siteunavailable_title"] = 'Mensaje de sitio no disponible:';
$_lang["snippet"] = 'Snippet';
$_lang["snippets"] = 'Snippets';
$_lang["snippet_code"] = 'Código de snippet (php)';
$_lang["snippet_desc"] = 'Descripción';
$_lang["snippet_execonsave"] = 'Ejecutar el snippet después de guardarlo.';
$_lang["snippet_management_msg"] = 'Elige el snippet que deseas editar.';
$_lang["snippet_msg"] = 'Añadir/editar snippets. Recuerda, los snippets son código PHP \'plano\', y si esperas que la salida del snippet sea mostrada en algún momento dentro de un template, necesitarás regresar el valor desde dentro del snippet.';
$_lang["snippet_name"] = '[[ Nombre de snippet ]]';
$_lang["snippet_properties"] = 'Propiedades prefijadas';
$_lang["snippet_title"] = 'Crear/editar snippet';
$_lang["sort_alphabetically"] = 'Sort alphabetically';
$_lang["sort_asc"] = 'Ascendente';
$_lang["sort_desc"] = 'Descendente';
$_lang["sort_menuindex"] = 'Sort menu index';
$_lang["sort_tree"] = 'Ordenar el árbol';
$_lang['sort_updating'] = 'Updating ...';
$_lang['sort_updated'] = 'Updated!';
$_lang['sort_nochildren'] = 'Parent does not have any children';
$_lang["sort_elements_msg"] = 'Drag to reorder the listed elements.';
$_lang["source"] = 'Fuente';
$_lang["stay"] = 'Continuar editando';
$_lang["stay_new"] = 'Añadir otro';
$_lang["submit"] = 'Enviar';
$_lang["sunday"] = 'Domingo';
$_lang["sys_alert"] = 'Alerta de Sistema';
$_lang["sysinfo_activity_message"] = 'Esta lista muestra qué documentos han sido editados recientemente por tus usuarios.';
$_lang["sysinfo_userid"] = 'Usuario';
$_lang["system"] = 'System';
$_lang["system_email_signup"] = 'Hola [+uid+] 
<html>
Hello [+uid+] 

Aquí tienes los detalles de inicio de sesión para el Administrador de Contenido de [+sname+]:

Usuario: [+uid+]
Contraseña: [+pwd+]

Una vez que has ingresado al Administrador de Contenido de ([+surl+]), puedes cambiar tu contraseña.

Saludos,
El Administrador
</html>';
$_lang["system_email_webreminder"] = 'Hola [+uid+]

Para activar tu contraseña nueva haz clic en el siguiente enlace:

[+surl+]

Si tienes éxito puedes usar la siguiente contraseña para ingresar:

Contraseña:[+pwd+]

Si no solicitaste este email entonces por favor ignóralo.

Saludos,
El Administrador';
$_lang["system_email_websignup"] = 'Hola [+uid+] 

Aquí tienes los detalles de ingreso para [+sname+]:

Nombre de usuario: [+uid+]
Contraseña: [+pwd+]

Una vez que ingreses a [+sname+] ([+surl+]), puedes cambiar tu contraseña.

Saludos,
El Administrador';
$_lang["table_hoverinfo"] = 'Pasa el ratón sobre el nombre de la tabla para ver una corta descripción de su función (no todas las tablas tienen <i>comentarios</i> configurados).';
$_lang["table_prefix"] = 'Prefijo de tabla';
$_lang["tag"] = 'Etiqueta';
$_lang["template"] = 'Template';
$_lang["templates"] = 'Templates';
$_lang["template_assignedtv_tab"] = 'Variables de Template Asignadas';
$_lang["template_code"] = 'Código de template (html)';
$_lang["template_desc"] = 'Descripción';
$_lang["template_edit_tab"] = 'Editar template';
$_lang["template_management_msg"] = 'Elige qué template deseas editar.';
$_lang["template_msg"] = 'Crea y edita templates.  Los templates nuevos o  modificados no serán visibles en las páginas cacheadas de tu sitio hasta que el cache sea vaciado , sin embargo, puedes usar la función de previsualización en una página para ver el template en acción.';
$_lang["template_name"] = 'Nombre del template';
$_lang["template_no_tv"] = 'Todavía no se han asignado variables de template a este template.';
$_lang["template_notassigned_tv"] = 'These Template Variables are available for assigning.';
$_lang["template_reset_all"] = 'Reajusta todas las páginas a usar el template prefijado';
$_lang["template_reset_specific"] = 'Reajusta solamente \'%s\' páginas';
$_lang["template_selectable"] = 'Template selectable when creating or editing ressources.';
$_lang["template_title"] = 'Crear/editar template';
$_lang["template_tv_edit"] = 'Editar el orden de clasificación de las variables de template';
$_lang["template_tv_edit_message"] = 'Arrastra para re-ordenar las Variables de Template para este template.';
$_lang["template_tv_edit_title"] = 'Orden de Clasificación de las Variables de Template';
$_lang["template_tv_msg"] = 'Las variables de template asignadas a este template están listadas aquí abajo.';
$_lang["thursday"] = 'Jueves';
$_lang["tmplvar_access_msg"] = 'Selecciona los grupos de documentos que tienen permitido modificar el contenido o el valor de esta variable';
$_lang["tmplvar_change_template_msg"] = 'Cambiando este template causará que la página recargue las Variables de Template, perdiendo cualquier cambio que no haya sido guardado.\n\n ¿Estás seguro de que quieres cambiar este template?';
$_lang["tmplvar_inuse"] = 'Los siguientes documentos están usando esta Variable de Template actualmente. Para continuar con la operación de borrado haz clic en el botón de Borrar de otra manera haz clic en el botón de Cancelar.';
$_lang["tmplvar_tmpl_access"] = 'Acceso a Template';
$_lang["tmplvar_tmpl_access_msg"] = 'Selecciona los templates que tienen permitido acceder/procesar esta variable';
$_lang["tmplvar"] = 'Template Variable';
$_lang["tmplvars"] = 'Variables de Template';
$_lang["tmplvars_binding_msg"] = 'Este campo soporta vínculos de fuente de datos usando comandos @';
$_lang["tmplvars_caption"] = 'Subtítulo';
$_lang["tmplvars_default"] = 'Valor Prefijado';
$_lang["tmplvars_description"] = 'Descripción';
$_lang["tmplvars_elements"] = 'Valores de Opción de Ingreso';
$_lang["tmplvars_inherited"] = 'Value inherited';
$_lang["tmplvars_management_msg"] = 'Administrar campos de contenido personalizados adicionales (Variables de Template) para tus documentos.';
$_lang["tmplvars_msg"] = 'Añade o edita variables de template aquí. Las variables de template deben ser asignadas a templates para poder acceder a ellas desde snippets y documentos.';
$_lang["tmplvars_name"] = '[* Nombre de Variable *]';
$_lang["tmplvars_novars"] = 'No se encontraron Variables de Template';
$_lang["tmplvars_rank"] = 'Orden de Clasificación';
$_lang["tmplvars_rank_edit_message"] = 'Drag to reorder the Template Variables.';
$_lang["tmplvars_reset_params"] = 'Reajustar parámetros';
$_lang["tmplvars_title"] = 'Create/edit Template Variable';
$_lang["tmplvars_type"] = 'Tipo de Entrada';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Propiedades de Widget';
$_lang["to"] = 'a';
$_lang["toggle_fullscreen"] = 'Toggle Fullscreen';
$_lang["tools"] = 'Herramientas';
$_lang["top_howmany_message"] = 'Cuando estés viendo reportes ¿qué tan largas deben de ser las listas de \'Mejores...\'?';
$_lang["top_howmany_title"] = 'Cuántos mejores';
$_lang["total"] = 'total';
$_lang["track_visitors_message"] = 'Esta configuración no tendrá efecto hasta que tengas un programa de seguimiento de visitantes o de estadísticas instalado que lo soporte. Registrar a las visitas te permitirá ver las estadísticas de uso de tu sitio web.';
$_lang["track_visitors_title"] = 'Bitácora de visitas (estadísticas)';
$_lang["tree_page_click"] = 'Page Click Behavior';
$_lang["tree_page_click_message"] = 'The default behavior when clicking on a page in the site tree.';
$_lang["use_breadcrumbs"] = 'Mostrar navegación';
$_lang["use_breadcrumbs_message"] = 'Show the navigation when creating or editing Resource in the Manager';
$_lang["tree_show_protected"] = 'Mostrar páginas protegidas';
$_lang["tree_show_protected_message"] = 'Si configurado a "No", las Páginas Protegidas (y todos sus documentos hijos) no aparecen en el árbol de documentos. "No" es la configuración anterior de EVO.';
$_lang["truncate_table"] = 'Haz clic aquí para truncar esta tabla';
$_lang["tuesday"] = 'Martes';
$_lang["tv"] = 'TV';
$_lang["type"] = 'Tipo';
$_lang["udperms_allowroot_message"] = '¿Quieres permitir que tus usuarios puedan crear documentos nuevos en la raíz de tu sitio? ';
$_lang["udperms_allowroot_title"] = 'Permitir raíz:';
$_lang["udperms_message"] = 'Los permisos de acceso te permiten especificar qué páginas tienen permitido editar tus usuarios.  Necesitarás asignar tus usuarios a grupos de usuario, tus documentos a grupos de documento, y después deberás especificar qué grupos de usuarios tienen permitido editar qué grupos de documentos.  Sólo los Administradores tendrán permitido editar documentos cuando actives esto por primera vez.';
$_lang["udperms_title"] = 'Usar permisos de acceso:';
$_lang["unable_set_link"] = '¡No es posible configurar el enlace!';
$_lang["unable_set_parent"] = '¡No es posible configurar padre nuevo!';
$_lang["unauthorizedpage_message"] = 'Ingresa el ID del documento al que quieres enviar a los usuarios si han solicitado un documento seguro o no autorizado. <b>NOTA: asegúrate de que el ID ingresado pertenece a un documento existente ¡y que ha sido publicado y es públicamente accesible!</b>';
$_lang["unauthorizedpage_title"] = 'Página no autorizada:';
$_lang["unblock_message"] = 'Este usuario no será bloqueado después de guardar los datos del usuario.';
$_lang["undelete_resource"] = 'Recuperar documento';
$_lang["unpublish_date"] = 'Fecha de despublicación';
$_lang["unpublish_events"] = 'Despublicar Eventos';
$_lang["unpublish_resource"] = 'Despublicar documento';
$_lang["untitled_resource"] = 'Documento sin título';
$_lang["untitled_weblink"] = 'Enlace web sin título';
$_lang["update_params"] = 'Actualizar la muestra de parámetros';
$_lang["update_settings_from_language"] = 'Reemplazar el actual con:';
$_lang["upload_maxsize_message"] = 'Ingresa el tamaño máximo de archivo a ser subido por el Administrador de archivos. El tamaño de archivo a subir debe de ser ingresado en bytes. <b>NOTA: ¡Archivos grandes pueden demorar mucho tiempo para subir!</b>';
$_lang["upload_maxsize_title"] = 'Tamaño máximo de subida';
$_lang["uploadable_files_message"] = 'Ingresa una lista de archivos que pueden ser subidos a \'assets/files/\' usando el Navegador de Archivos. Por favor ingresa las extensiones para los tipos de archivos, separados por comas.';
$_lang["uploadable_files_title"] = 'Tipos de Archivos subibles:';
$_lang["uploadable_flash_message"] = 'Ingresa la lista de archivos que pueden ser subidos a \'assets/flash/\' usando el Administrador de Archivos. Por favor ingresa las extensiones para tipos de archivos flash, separados por comas.';
$_lang["uploadable_flash_title"] = 'Tipos de Archivos Flash subibles:';
$_lang["uploadable_images_message"] = 'Ingresa una lista de archivos que pueden ser subidos a \'assets/images/\' usando el Administrador de Archivos. Por favor ingresa las extensiones para tipos de imágenes, separados por comas.';
$_lang["uploadable_images_title"] = 'Tipos de Imágenes subibles:';
$_lang["uploadable_media_message"] = 'Ingresa una lista de archivos que pueden ser subidos a \'assets/media/\' usando el Administrador de Archhivos. Por favor ingresa las extensiones para tipos de archivos media, separados por comas.';
$_lang["uploadable_media_title"] = 'Tipos de Archivo Media subibles:';
$_lang["use_alias_path_message"] = 'Configurando esta opción a \'si\' mostrará la dirección completa al documento si el documento tiene un alias. Por ejemplo, si un documento con un alias llamado \'hijo\' está ubicado dentro de un documento contenedor con un alias llamado \'padre\', entonces la dirección alias completa al documento será \'/padre/hijo.html\'.<br /><b>NOTA: Cuando se configura esta opción a \'Si\' (activando dirección alias), referencia a los artículos (como imágenes, css, javascripts, etc) utilizando su dirección absoluta: por ej., \'/assets/images\' en vez de  \'assets/images\'. Haciendo esto prevendrás que el navegador (o servidor web) agregue la dirección relativa al alias.</b>';
$_lang["use_alias_path_title"] = 'Usar dirección alias amigable:';
$_lang["use_editor_message"] = '¿Quieres habilitar el editor de contenido formateado?  Si estás más cómodo escribiendo HTML, entonces puedes deshabilitarlo usando esta configuración. ¡Nota que ésta configuración aplica a todos los documentos y todos los usuarios!';
$_lang["use_editor_title"] = 'Habilitar editor:';
$_lang["use_global_tabs"] = 'Use global Tabs';
$_lang["user"] = 'Usuario';
$_lang["user_block"] = 'Bloqueado';
$_lang["user_blockedafter"] = 'Bloqueado después';
$_lang["user_blockeduntil"] = 'Bloqueado antes';
$_lang["user_changeddata"] = 'Tus datos han sido cambiados. Por favor ingresa nuevamente.';
$_lang["user_country"] = 'País';
$_lang["user_dob"] = 'Fecha de nacimiento';
$_lang["user_doesnt_exist"] = 'El usuario no existe';
$_lang["user_edit_self_msg"] = '<b>Necesitas cerrar la sesión e iniciarla nuevamente después de actualizar completamente tu información.</b><br>También, si eliges generar una contraseña nueva para tí, te será enviada en un email.';
$_lang["user_email"] = 'Dirección de correo electrónico';
$_lang["user_failedlogincount"] = 'Ingresos fallidos';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Femenino';
$_lang["user_full_name"] = 'Nombre completo';
$_lang["user_gender"] = 'Género';
$_lang["user_is_blocked"] = '¡Este usuario está bloqueado!';
$_lang["user_logincount"] = 'Número de ingresos';
$_lang["user_male"] = 'Masculino';
$_lang["user_management_msg"] = 'Elige el Administrador de Contenido a editar. Los usuarios del Administrador de Contenido son esos usuarios que tienen permitido ingresar al Administrador de Contenido';
$_lang["user_management_title"] = 'Usuarios Administradores';
$_lang["user_mobile"] = 'Celular';
$_lang["user_phone"] = 'Teléfono';
$_lang["user_photo"] = 'Foto del usuario';
$_lang["user_photo_message"] = 'Ingresa el url de la imagen para este usuario o usa el botón de insertar para seleccionar o subir una imagen al servidor.';
$_lang["user_prevlogin"] = 'Último ingreso';
$_lang["user_role"] = 'Rol del usuario';
$_lang["user_state"] = 'Estado o Provincia';
$_lang["user_title"] = 'Crear/Editar usuario';
$_lang["user_upload_message"] = ' Si deseas evitar que este usuario suba cualquier tipo de archivos en esta categoría, asegúrate de que la caja de selección \'Usar Configuración Principal\' no está seleccionada y deja vacío el campo.';
$_lang["user_use_config"] = 'Usar Configuración Principal';
$_lang["user_zip"] = 'Código postal';
$_lang["username"] = 'Nombre de usuario';
$_lang["users"] = 'Seguridad';
$_lang["valid_hostnames_message"] = 'Ayudar a prevenir ataques XSS que explota un mal uso de la configuración del sistema site_url al proporcionar una lista separada por comas de nombres de host válidos para esta instalación. Esto es importante para algunos tipos de hosts compartidos o hosts accesible a través de una dirección IP. Se usará en primer lugar el nombre de host de la lista si el HTTP_HOST no coincide con ningún nombre de host válido.';
$_lang["valid_hostnames_title"] = 'Nombres de host válido';
$_lang["validate_referer_message"] = 'Validar el encabezado de HTTP_REFERER para reducir el riesgo de que tus editores de contenido sean engañados a efectuar acciones no intencionadas en el administrador como víctimas de un ataque CSRF (Cross Site Request Forgery -- Solicitud de Sitio Cruzada Falsa).  Algunas configuraciones no podrán usar esta opción si el servidor no está enviando los encabezados HTTP_REFERER.';
$_lang["validate_referer_title"] = 'Validar encabezados HTTP_REFERER?';
$_lang["value"] = 'Valor';
$_lang["version"] = 'Versión';
$_lang["view"] = 'Ver';
$_lang["view_child_resources_in_container"] = 'Ver hijos';
$_lang["view_log"] = 'Ver bitácora';
$_lang["view_logging"] = 'Acciones del Administrador';
$_lang["view_sysinfo"] = 'Información del sistema';
$_lang["warning"] = '¡Advertencia!';
$_lang["warning_not_saved"] = 'Los cambios que has realizado todavía no han sido guardados.  Puedes elegir quedarte en la página actual para guardar los cambios (\'Cancelar\'), o puedes dejar esta página, perdiendo cualquier cambio que hayas realizado (\'OK\').';
$_lang["warning_visibility"] = 'Configuration Warnings visible to';
$_lang["warning_visibility_message"] = 'Control the visibility of the configuration warnings shown on the Manager welcome page';
$_lang["web_access_permissions"] = 'Permisos de acceso web';
$_lang["web_access_permissions_user_groups"] = 'Grupo de Usuarios Web:';
$_lang["web_permissions"] = 'Permisos Web';
$_lang["web_user_management_msg"] = 'Elige qué usuario web deseas editar. Los usuarios web son aquellos usuarios que sólo tienen permitido ingresar en el sitio web';
$_lang["web_user_management_title"] = 'Usuarios Web';
$_lang["web_user_title"] = 'Crear/editar usuario web';
$_lang["web_users"] = 'Usuarios web';
$_lang["weblink"] = 'Enlace web';
$_lang["webpwdreminder_message"] = 'Ingresa un mensaje a ser enviado a tus usuarios web cuando soliciten una contraseña nueva vía email. El Administrador de Contenido enviará un email conteniendo su nueva contraseña y la información de activación. <br /><b>Nota:</b> Los siguientes placeholders son reemplazados por el Administrador de Contenidos cuando el mensaje es enviado: <br /><br />[+sname+] - Nombre de tu sitio web, <br />[+saddr+] - La dirección de correo electrónico de tu sitio, <br />[+surl+] - La dirección url de tu sitio, <br />[+uid+] - El nombre o id de ingreso del usuario, <br />[+pwd+] - Contraseña del usuario, <br />[+ufn+] - Nombre completo del usuario. <br /><br /><b>Deja [+uid+] y [+pwd+] en el mensaje, de otro modo el nombre de usuario y la contraseña no serán enviadas en el mensaje ¡y tus usuarios no la conocerán!</b>';
$_lang["webpwdreminder_title"] = 'Email de Recordatorio Web:';
$_lang["websignupemail_message"] = 'Configura el mensaje de email enviado a los usuarios cuando creen una cuenta incluyendo su nombre de usuario y su contraseña. <br /><b>Nota:</b> Los siguientes placeholders son reemplazados por el Administrador de Contenidos cuando el mensaje es enviado: <br /><br />[+sname+] - Nombre de tu sitio web, <br />[+saddr+] - La dirección de correo electrónico de tu sitio, <br />[+surl+] - La dirección url de tu sitio, <br />[+uid+] - El nombre o id de ingreso del usuario, <br />[+pwd+] - la Contraseña del usuario, <br />[+ufn+] - Nombre completo del usuario. <br /><br /><b>Deja [+uid+] y [+pwd+] en el mensaje, de otro modo el nombre de usuario y la contraseña no serán enviadas en el mensaje ¡y tus usuarios no lo conocerán!</b>';
$_lang["websignupemail_title"] = 'Email de Registro Web:';
$_lang["allow_multiple_emails_title"] = 'Duplicate Web User email address';
$_lang["allow_multiple_emails_message"] = 'Allows Web Users to share the same email address for situations when a member may not have their own email address or there is just one family email address.<br/>Note: Any password reminder and registration logic will need to account for this option if set to yes.';
$_lang["wednesday"] = 'Miércoles';
$_lang["welcome_messages"] = 'Tu Bandeja de Entrada contiene <strong>%d</strong> mensaje(s), de los cuales <strong>%s</strong> no han sido leídos.';
$_lang["welcome_title"] = 'Bienvenido a tu Administrador de Contenido';
$_lang["which_editor_message"] = 'Selecciona el editor de texto formateado.  Puedes descargar e instalar editores de texto formateado adicionales desde la página de descargas de EVO.';
$_lang["which_editor_title"] = 'Editor a usar:';
$_lang["working"] = 'Trabajando...';
$_lang["wrap_lines"] = 'Encapsular líneas (wrap)';
$_lang["xhtml_urls_message"] = 'Reemplaza los signos & (&amp;) en los URLs generados por EVO con el htmlentity &amp<!-- -->amp; que es XHTML válido.';
$_lang["xhtml_urls_title"] = 'URLs XHTML';
$_lang["yes"] = 'Si';
$_lang["you_got_mail"] = 'Tienes Email';
$_lang["yourinfo_message"] = 'Esta sección muestra alguna información acerca de tí:';
$_lang["yourinfo_previous_login"] = 'Tu último ingreso:';
$_lang["yourinfo_role"] = 'Tu rol es:';
$_lang["yourinfo_title"] = 'Tu información';
$_lang["yourinfo_total_logins"] = 'Número total de ingresos:';
$_lang["yourinfo_username"] = 'Estás ingresado como:';

$_lang["a17_error_reporting_title"] = 'Nivel de detección de errores de PHP';
$_lang["a17_error_reporting_msg"] = 'Set the detection level of the PHP errors.';
$_lang["a17_error_reporting_opt0"] = 'Ignora todo';
$_lang["a17_error_reporting_opt1"] = 'Ignore warnings of a slight notice level (<a href="https://www.google.com/search?q=E_DEPRECATED+E_STRICT" target="_blank">E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_STRICT</a>)';
$_lang["a17_error_reporting_opt2"] = 'Detect all errors except E_NOTICE';
$_lang["a17_error_reporting_opt99"] = 'Detectar todo';

$_lang["pwd_hash_algo_title"] = 'Algoritmo hash';
$_lang["pwd_hash_algo_message"] = 'Password hash algorithm.';

$_lang["enable_bindings_title"] = 'Enable @Bindings commands';
$_lang["enable_bindings_message"] = 'Prevents the execution of PHP functions through TV @Bindings. Useful if you have Manager users who should not be able to create PHP code but need to be able to create or edit TVs. The output of any TV with an @Binding will be "@Bindings disabled".';
$_lang["enable_filter_title"] = 'Habilitar filtros';
$_lang["enable_filter_message"] = 'Filters allow you to manipulate the way data is presented or parsed in a tag. They allow you to modify values from inside your templates. This is analogous to PHx. <a href="https://github.com/modxcms/evolution/issues/623" target="ext_help">More info</a>'; // todo: change link to documentation 
$_lang["enable_filter_phx_warning"] = 'Cuando está habilitada PHx plugin, incorporado en los filtros están desactivados por defecto';

$_lang["enable_at_syntax_title"] = 'Habilitar &lt;@SYNTAX&gt;';
$_lang["enable_at_syntax_message"] = '&lt;@SYNTAX&gt;(atmark syntax) is simple and lightweight template syntax. This is designed to consider coexistence with HTML tags and content strings.';

$_lang["bkmgr_alert_mkdir"] = 'A file cannot be created in a directory.  Please check the permission of [+snapshot_path+]';
$_lang["bkmgr_restore_msg"] = '<p>Database tables could be restored by SQL:</p>';
$_lang["bkmgr_restore_title"] = 'Restaurar';
$_lang["bkmgr_import_ok"] = 'SQL recovery was performed normally.';
$_lang["bkmgr_snapshot_ok"] = 'The snapshot was saved normally.';
$_lang["bkmgr_run_sql_file_label"] = 'Execute by sql file';
$_lang["bkmgr_run_sql_direct_label"] = 'Direct execute SQL commands';
$_lang["bkmgr_run_sql_submit"] = 'Ejecutar restaurar';
$_lang["bkmgr_run_sql_result"] = 'Resultado';
$_lang["bkmgr_snapshot_title"] = 'Snapshot save and recovery';
$_lang["bkmgr_snapshot_msg"] = '<p>The contents of the database are saved in and restored from a server directory.<br />Location: [+snapshot_path+] ($modx->config[\'snapshot_path\'])</p>';
$_lang["bkmgr_snapshot_submit"] = 'Add snapshot';
$_lang["bkmgr_snapshot_list_title"] = 'List of snapshots';
$_lang["bkmgr_restore_submit"] = 'Revertir estos datos';
$_lang["bkmgr_restore_confirm"] = 'Está seguro de que desea restaurar la copia de seguridad?\n[+filename+] ?';
$_lang["bkmgr_snapshot_nothing"] = 'No snapshots available';

$_lang["files.dynamic.php1"] = 'Nuevo archivo de texto';
$_lang["files.dynamic.php2"] = 'Este directorio no se puede mostrar.';
$_lang["files.dynamic.php3"] = 'Hay un problema en un nombre de archivo.';
$_lang["files.dynamic.php4"] = 'El archivo de texto fue creado.';
$_lang["files.dynamic.php5"] = 'El archivo no pudo ser duplicado.';
$_lang["files.dynamic.php6"] = 'File or directory could not be renamed.';
$_lang["files_dynamic_new_folder_name"] = 'Introduzca nuevo nombre de directorio:';
$_lang["files_dynamic_new_file_name"] = 'Introduzca nuevo nombre de archivo:';
$_lang["not_readable_dir"] = 'No se puede leer este directorio.';
$_lang["confirm_delete_dir"] = '¿Estás seguro de que quieres borrar el directorio?';
$_lang["confirm_delete_dir_recursive"] = 'Are you sure you want to delete the directory?\n\nAny children files will also be deleted.';

$_lang["make_folders_title"] = 'End Container URL with Slash';
$_lang["make_folders_message"] = 'Append trailing slash to Resources that are set as containers when using Friendly URLs.';

$_lang["check_files_onlogin_title"] = 'Compruebe los archivos principales al iniciar sesión';
$_lang["check_files_onlogin_message"] = 'By enabling this option, important system files will be checked for modification typical of scripted website attacks. While not a foolproof guarantee, it may alert you to a compromised EVO system file and website.';

$_lang["configcheck_sysfiles_mod"] = 'Se han modificado archivos importantes del sistema.';
$_lang["configcheck_sysfiles_mod_msg"] = 'You have configured EVO to check important system files for possible website script attacks. This warning does not necessarily mean your site has been compromised, however, you should review the watched files in your installation (set in System configuration -> User -> Check core files on login). If you find your files unaltered or changes were made by site administrators, go to System Configuration and click to re-save settings to dismiss this message. Changes in the following files have been found:';

$_lang['email_method_title'] = 'Sendmail method';
$_lang['email_method_mail'] = 'PHP mail() function';
$_lang['email_method_smtp'] = 'SMTP Server';
$_lang['smtp_auth_title'] = 'SMTP-AUTH';
$_lang['smtp_host_title'] = 'SMTP host';
$_lang['smtp_secure_title'] = 'Cifrado SMTP';
$_lang['smtp_username_title'] = 'SMTP user name';
$_lang['smtp_password_title'] = 'SMTP password';
$_lang['smtp_port_title'] = 'Puerto SMTP';

$_lang["setting_resource_tree_node_name"] = 'Display Name in Resource Tree';
$_lang["setting_resource_tree_node_name_desc"] = 'Select the Resource field to show as the Resource name in the Resource Tree. The default setting is pagetitle.';
$_lang["setting_resource_tree_node_name_desc_add"] = 'Note: Since EVO 1.1 you can change this Display Name within Resource-TreeÂ´s sorting option. This setting is used when Display Name in Resource Tree is set to &quot;Default&quot;.';

$_lang["resource_opt_alvisibled"] = 'Utilizar alias actual en ruta de alias';
$_lang["resource_opt_alvisibled_help"] = 'El alias de este Recurso se insertará en la ruta de alias de URL amigable';
$_lang['resource_opt_is_published'] = 'Publicado';
$_lang["docid_incrmnt_method_title"] = 'Método de Incremento de la ID de los Recursos';
$_lang["docid_incrmnt_method_0"] = 'DB auto incremental';
$_lang["docid_incrmnt_method_1"] = 'Mínimo ID perdido';
$_lang["docid_incrmnt_method_2"] = 'Máximo ID + 1';

$_lang["enable_cache_title"] = 'Document caching';
$_lang["disabled_at_login"] = 'Deshabilitado al iniciar sesión';

$_lang["cache_type_title"] = 'Tipo de caché de documentos';
$_lang["cache_type_1"] = 'Cache is based only on Resource ID (standard)';
$_lang["cache_type_2"] = 'Cache is based on Resource ID and $_GET parameters';
$_lang["seostrict_title"] = 'Usar URLs estrictas de SEO';
$_lang["seostrict_message"] = 'Enforces the use of strict URLs to prevent duplicate content (if needed)';
$_lang["aliaslistingfolder_title"] = 'Use AliasListing only for Folders';
$_lang["aliaslistingfolder_message"] = 'Reduces memory consumption when a large number of resources';

$_lang["settings_friendlyurls_alert"] = 'It is necessary to rename the ht.access file in the EVO installation directory at .htaccess to use the Friendly URL function.';
$_lang["settings_friendlyurls_alert2"] = 'Since EVO was installed in a subdirectory, it is necessary to change the content of .htaccess.';

$_lang["user_street"] = 'Calle';
$_lang["user_city"] = 'Ciudad';
$_lang["user_other"] = 'Otro';

$_lang["import_site.static.php1"] = 'Inicializa el arbol de recursos';
$_lang["import_site.static.php2"] = 'Inicializa el arbol de recursos y todos las ID\'s de los Recursos';
$_lang["import_site.static.php3"] = 'Objectivo';
$_lang["import_site.static.php4"] = 'Solo partes &lt;body&gt;&lt;/body&gt;';
$_lang["import_site.static.php5"] = 'Contenido del archivo entero';

$_lang["a83_ignore_ids_title"] = 'Ignorar ID\'s (separadas por comas)';
$_lang["export_site.static.php1"] = 'Objectivo';
$_lang["export_site.static.php2"] = 'Sólo editar recursos';
$_lang["export_site.static.php3"] = 'Todos los recursos';
$_lang["export_site.static.php4"] = 'Buscar por';
$_lang["export_site.static.php5"] = 'Reemplazar con';
$_lang["export_site.static.php6"] = 'Objetivo';
$_lang["export_site.static.php7"] = 'Los archivos no se pudieron guardar en [+ rb_base_url +]';

$_lang["mutate_settings.dynamic.php6"] = 'Enviar correo a errores EVO';
$_lang["mutate_settings.dynamic.php7"] = 'No notificar';
$_lang["mutate_settings.dynamic.php8"] = 'Un correo electrónico con el origen del error se enviará a [(emailsender)] ([+ emailsender +]) si se produce un error en EVO. Los detalles del error se podran ver en el sistema de registro de eventos de EVO.';

$_lang["error_no_privileges"]         = "No tienes suficientes privilegios para esta acción.";
$_lang["error_no_optimise_tablename"] = "Tabla a optimizar no se encuentra en la petición!";
$_lang["error_no_truncate_tablename"] = "Tabla a truncar no se encuentra en la petición!";
$_lang["error_double_action"]         = "Doble acción (GET & POST) enviadas!.";
$_lang["error_no_id"]                 = "ID no pasada en la petición!";
$_lang["error_id_nan"]                = "ID pasada en la petición es NaN!";
$_lang["error_no_parent"]             = "No pudo encontrar el nombre del documento padre!";
$_lang["error_many_results"]          = "Demasiados resultados devueltos de la base de datos!.";
$_lang["error_no_results"]            = "Insuficientes ó sin resultados devueltos de la base de datos!.";
$_lang["error_no_user_selected"]      = "Ningún usuario seleccionado como receptor de este mensaje.";
$_lang["error_no_group_selected"]     = "Ningún grupo seleccionado como receptor de este mensaje.";
$_lang["error_movedocument1"]         = "Documento no puede ser es propio padre!";
$_lang["error_movedocument2"]         = "ID del documento no pasada durante una solicitud!";
$_lang["error_movedocument3"]         = "El nuevo padre no se envió en la solicitud!.";
$_lang["error_internet_connection"]   = "El servidor no está disponible. ¡Comprueba tu conexión a Internet!";

$_lang["login_processor_unknown_user"]       = "Incorrecto nombre o password introducido!";
$_lang["login_processor_wrong_password"]     = "Incorrecto nombre o password introducido!";
$_lang["login_processor_many_failed_logins"] = "Debido a muchos inicios de sesión fallidos, usted ha sido bloqueado!";
$_lang["login_processor_blocked1"]           = "¡ Estás bloqueado y no puedo ingresar!";
$_lang["login_processor_blocked2"]           = "¡ Estás bloqueado y no puedo ingresar! Inténtalo de nuevo más tarde.";
$_lang["login_processor_blocked3"]           = "Usted está bloqueado de forma automática después de una fecha determinada y no puede ingresar!";
$_lang["login_processor_bad_code"]           = "El código de seguridad que introdujo no es valido! Por favor, intenta iniciar sesión nuevamente.";
$_lang["login_processor_remotehost_ip"]      = "El nombre de host no apunta a tu IP!";
$_lang["login_processor_remote_ip"]          = "No se le permite iniciar sesión desde esta ubicación.";
$_lang["login_processor_date"]               = "No puedes iniciar sesión en este momento. Por favor, Inténtalo de nuevo más tarde.";
$_lang["login_processor_captcha_config"]     = "Captcha no está configurado correctamente.";

$_lang["dp_dayNames"]   = "['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado']";
$_lang["dp_monthNames"] = "['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre']";
$_lang["dp_startDay"]   = "1";

$_lang["check_all"] = "Selecciona Todo";
$_lang["check_none"] = "No seleccionar nada";
$_lang["check_toggle"] = "Invertir selección";

$_lang["version_notices"] = "Avisos de la versión";

$_lang["em_button_shift"] = " (Shift-Mouseclick to open multiple windows)";

$_lang["reset_sysfiles_checksum_button"] = "Rebuild Checksums";
$_lang["reset_sysfiles_checksum_alert"] = "Are you sure you want to reset the system files checksums?";

$_lang["file_browser_disabled_msg"] = "The File Browser Feature is not enabled.";
$_lang["which_browser_default_title"]= "Explorador de archivos predeterminado";
$_lang["which_browser_default_msg"]= "Choose the File Browser you prefer as default. In User-Settings you can choose a Custom Browser per User, or leave it on &quot;default&quot;.";
$_lang["which_browser_title"]= "Explorador de archivos";
$_lang["which_browser_msg"]= "You can choose a custom File Browser for this user. To use the SystemÂ´s default Browser, leave it on &quot;Default&quot;.";
$_lang["option_default"] = "Predeterminado";
$_lang["position"] = "Posición";
$_lang["are_you_sure"] = "¿Estás seguro?";

$_lang['evo_downloads_title'] = "Evolution Downloads";
$_lang['help_translating_title'] = "Ayuda a traducir Evolution";
$_lang['download'] = "Descargar";
$_lang['downloads'] = "Descargas";
$_lang["previous_releases"] = "Lanzamientos Anteriores";
$_lang["extras"] = "Extras";

$_lang["display_locks"] = "Display Locks";
$_lang["role_display_locks"] = "Display Locks";
$_lang["session_timeout"] = "Session Timeout";
$_lang["session_timeout_msg"] = "EVO will ping the server as per setting &quot;Mail Check Time Period&quot;. If the last ping exceeds this setting, the associated session will be considered invalid and all related locks will be removed automatically. Set value in minutes (>2min, default 15min).";
$_lang["unlock_element_id_warning"] = "Are you sure you want to unlock this [+element_type+] (ID [+id+])?";
$_lang["lock_element_type_1"] = "Plantilla";
$_lang["lock_element_type_2"] = "Template-Variable";
$_lang["lock_element_type_3"] = "Chunk";
$_lang["lock_element_type_4"] = "Snippet";
$_lang["lock_element_type_5"] = "Plugin";
$_lang["lock_element_type_6"] = "Module";
$_lang["lock_element_type_7"] = "Resource";
$_lang["lock_element_type_8"] = "Role";
$_lang["lock_element_editing"] = "You are editing this [+element_type+] since\n[+lasthit_df+]";
$_lang["lock_element_locked_by"] = "This [+element_type+] is locked by user\n[+username+] since [+lasthit_df+]";

$_lang["minifyphp_incache_title"] = 'Minimizar el código php en el caché del sitio';
$_lang["minifyphp_incache_message"] = 'Minify php code (snippets and plugins) and store in the site cache file, ref:<a href="https://github.com/modxcms/evolution/issues/938" target="_blank">#938</a>';

$_lang["logout_reminder_msg"] = "Reminder: It seems on [+date+] you forgot to logout. Please pay attention in future to do so after your work is finished.";

$_lang["allow_eval_title"]             = "Eval php code in snippet call";
$_lang["allow_eval_msg"]               = "For developer : Please use \$modx-&gt;safeEval().";
$_lang["allow_eval_with_scan"]         = "Execute only permitted functions";
$_lang["allow_eval_with_scan_at_post"] = "Execute all. However, at POST, only permitted functions";
$_lang["allow_eval_everytime_eval"]    = "Unlimited (Use only for debugging)";
$_lang["allow_eval_dont_eval"]         = "No permitir todas las funciones.";

$_lang["safe_functions_at_eval_title"] = "Functions to allow eval";
$_lang["safe_functions_at_eval_msg"]   = "Lista separada por comas";

$_lang["multiple_sessions_msg"]   = "Information: Multiple active user sessions (total [+total+]) found for user <b>[+username+]</b>.";
$_lang["iconv_not_available"]     = "It is important to install/enable extension iconv. Please speak to your host if you donÂ´t know how to enable it.";

$_lang["cm_create_new_category"] = "Crear la nueva categoría";
$_lang["cm_category_name"] = "Nombre de la categoría";
$_lang["cm_category_position"] = "Posición de categoría";
$_lang["cm_no_x_assigned"] = "No %s assigned";
$_lang["cm_save_categorization"] = "Save categorization";
$_lang["cm_update_categories"] = "Actualizar categorías";
$_lang["cm_assigned_elements"] = "Assigned elements";
$_lang["cm_edit_name"] = "Editar nombre";
$_lang["cm_mark_for_deletion"] = "Mark for deletion";
$_lang["cm_delete_now"] = "Delete immediately";
$_lang["cm_delete_element_x_now"] = "Eliminar &quot;%s&quot; inmediatamente";
$_lang["cm_select_element_group"] = "Select an element group";
$_lang["cm_global_messages"] = "Global Messages";
$_lang["cm_add_new_category"] = "Agregar una nueva categoría";
$_lang["cm_edit_categories"] = "Editar categorias";
$_lang["cm_sort_categories"] = "Ordenar categorías";
$_lang["cm_categorize_elements"] = "Categorize elements";
$_lang["cm_translation"] = "Traducción";
$_lang["cm_translations"] = "Traducciones";
$_lang["cm_categorize_x"] = "Categorize <span class=\"highlight\">%s</span>";
$_lang["cm_unknown_error"] = "Algo salió mal.";
$_lang["cm_x_assigned_to_category_y"] = "<span class=\"highlight\">%s(%s)</span> has been assigned to category <span class=\"highlight\">%s(%s)</span>";
$_lang["cm_no_categorization"] = "No categorization made.";
$_lang["cm_no_changes"] = "Nothing to change, so no changes made.";
$_lang["cm_x_changes_made"] = "<span class=\"highlight\">%s</span> changes made";
$_lang["cm_enter_name_for_category"] = "Por favor ingrese un nombre para la nueva categoría.";
$_lang["cm_category_x_exists"] = "Category <span class=\"highlight\">%s</span> already exists.";
$_lang["cm_category_x_saved_at_position_y"] = "The new category <span class=\"highlight\">%s</span> was saved at position <span class=\"highlight\">%s</span>.";
$_lang["cm_category_x_moved_to_position_y"] = "Category <span class=\"highlight\">%s</span> was moved to position <span class=\"highlight\">%s</span>";
$_lang["cm_category_x_deleted"] = "Category <span class=\"highlight\">%s</span> has been deleted";
$_lang["cm_category_x_renamed_to_y"] = "Category <span class=\"highlight\">%s</span> was renamed to <span class=\"highlight\">%s</span>";
$_lang["cm_translation_for_x_empty"] = "Translation for <span class=\"highlight\">%s</span> was empty";
$_lang["cm_translation_for_x_to_y_success"] = "Translation for <span class=\"highlight\">%s</span> to <span class=\"highlight\">%s</span> successfully saved";
$_lang["cm_save_new_sorting"] = "Guardar nueva orden";
$_lang["cm_translate_phrases"] = "Translate phrases";
$_lang["cm_translate_module_phrases"] = "Translate module-phrases";
$_lang["cm_native_phrase"] = "Native phrase";

$_lang["btn_view_options"] = 'Ver opciones';
$_lang["view_options_msg"] = 'The display & listing of elements can be customized via &quot;View Options&quot;-button. Settings are saved and restored per Browser using HTML5Â´s localStorage.';
$_lang["viewopts_title"] = 'View Options';
$_lang["viewopts_cb_buttons"] = 'Buttons';
$_lang["viewopts_cb_descriptions"] = 'Descriptions';
$_lang["viewopts_cb_icons"] = 'Iconos';
$_lang["viewopts_radio_list"] = 'Listado';
$_lang["viewopts_radio_inline"] = 'En línea';
$_lang["viewopts_radio_flex"] = 'Flexionar';
$_lang["viewopts_fontsize"] = 'Tamaño de fuente';
$_lang["viewopts_cb_alltabs"] = 'Todas las pestañas';

$_lang['email_sender_method'] = 'The envelope sender of the message';
$_lang['auto'] = 'Auto-detect';
$_lang['use_emailsender'] = 'Use [(emailsender)] value';
$_lang['email_sender_method_message'] = 'The envelope sender of the message. This will usually be turned into a Return-Path header by the receiver, and is the address that bounces will be sent to. Auto-detect will work in most cases.';

$_lang['login_form_position_title'] = 'Posición de formulario de inicio de sesión';
$_lang['login_form_position_left'] = 'izquierda';
$_lang['login_form_position_center'] = 'centro';
$_lang['login_form_position_right'] = 'derecha';
$_lang["login_form_style"] = 'Estilo de formulario de inicio de sesión:';
$_lang["login_form_style_dark"] = 'oscuro';
$_lang["login_form_style_light"] = 'claro';
$_lang['login_logo_title'] = 'Imagen de logo de la página de inicio ';
$_lang['login_logo_message'] = 'Recomended login logo image width: 360px, type .png';
$_lang['login_bg_title'] = 'Login page background image';
$_lang['login_bg_message'] = 'Recomended login page background image width: 1920px  ';

$_lang['manager_menu_position_title'] = 'Posición del menú principal';
$_lang['manager_menu_position_top'] = 'parte superior';
$_lang['manager_menu_position_left'] = 'izquierda';

$_lang['invalid_event_response'] = 'The %s event has ivalid output';

$_lang['chunk_processor'] = 'Clase de procesamiento de Chunks';
$_lang['enable_mootools'] = 'Habilitar Mootools en el administrador';
$_lang['enable_mootools_message'] = 'Cargue Mootools.js en el administrador para compatibilidad con versiones anteriores';
