# EVO Database Script for New/Upgrade Installations
#
# Each sql command is separated by double lines

#
# Dumping data for table `documentgroup_names`
#

REPLACE INTO `{PREFIX}document_groups` VALUES ('1','1','3');

REPLACE INTO `{PREFIX}documentgroup_names` VALUES ('1','Site Admin Pages','0','0');

#
# Dumping data for table `site_content`
#

REPLACE INTO `{PREFIX}site_content` VALUES ('1','document','text/html','Home','Welcome to EVO','Introduction to EVO','index','','1','0','0','0','0','Create and do amazing things with EVO','<h3>Install successful!</h3>\n<p>You have successfully installed and configured EVO. We hope you find this site an adequate starting configuration for many small business, organization or personal websites; just change the template and content, and you\'ll be good to go! This site is preconfigured with a variety of options we hope are helpful, relevant and just plain cool for many marketing or personal sites:</p>\n<ul>\n<li><strong>Simple Blog.</strong> When logged into your site, you\'ll be able to create new entries from the front end. This can also be turned into a News publishing or PR publishing system. <a href=\"blog\">View example blog</a></li>\n<li><strong>Easy Comments.</strong> When logged into your site, your registered site users can comment on your posts. <a href=\"blog/article-1126081344\">View example</a></li>\n<li><strong>RSS Feeds.</strong> Your site visitors can stay up to date using your site feeds. <a href=\"feed.rss\">View RSS feed</a></li>\n<li><strong>Automatic User Registration.</strong> Those that wish to comment on blogs must first create an account. This comes pre-configured with a \"Captcha\" anti-robot registration feature. <a href=\"request-an-account\">View registration form</a></li>\n<li><strong>QuickEdit.</strong> When you\'re logged into the manager, you can edit a page directly from the front end! <a href=\"features/cms\">More about CMS features</a></li>\n<li><strong>Integrated Site Search.</strong> Allows visitors to search only the pages you wish them to search. Uses Ajax to display results without loading a new page.</li>\n<li><strong>Powerful Navigation Builder.</strong> Duplicate or build virtually any navigation system with our dynamic menu builder code. The menu above, for example. <a href=\"features/menus\">More about menu features</a></li>\n<li><strong>Ajax ready.</strong> You\'re on your way to Web 2.0 and AJAX goodness. <a href=\"features/ajax\">More about Ajax features</a></li>\n<li><strong>Custom \"page not found (404)\" page.</strong> Help visitors who go astray to find what they\'re looking for. <a href=\"doc-not-found\">View 404 page</a></li>\n<li><strong>Contact Us form.</strong> A highly configurable contact form you <em>should</em> customize to point to the right email address. Comes pre-configured to prevent mail-form-injection so your site does <em>not</em> become a source for spam. <a href=\"contact-us\">View form</a></li>\n<li><strong>Newest documents list.</strong> Shows your visitor the most recently added pages (configurable).</li>\n<li><strong>Customizable Content Manager.</strong> Preview uploaded images, hide or rename fields and lots more. See <a href=\"http://code.divandesign.biz/modx/managermanager\">ManagerManager\'s documentation</a> for details and instructions. <em>Quick start:</em> ManagerManager by default will look for \"rules\" in a Chunk named \"mm_rules\". Simply copy or rename the Chunk named \"mm_demo_rules\" to \"mm_rules\" and try it out!</li>\n<li><strong>phpThumb.</strong> Examples to use <a href=\"http://i--gu.ru/phpthumb\">phpThumb</a> to crop images.</li>\n</ul>\n<p>Full documentation can be found on the official <a href=\"http://www.evolution-docs.com/extras/\" target=\"_blank\" rel=\"noopener\">documentation site</a>.</p>\n<p><strong>To log into the EVO Control Panel and start customizing this site, point your browser to <a href=\"manager\">/manager/</a>.</strong></p>','1','4','0','1','1','1','1144904400','1','1507728141','0','0','0','0','0','Home','0','0','0','0','0','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('2','document','text/html','Blog','My Blog','','blog','','1','0','0','0','1','','[[DocLister? \n	&jotcount=`1`\n	&parents=`2` \n	&display=`2`\n	&tvPrefix=``\n	&tvList=`image`\n	&prepare=`prepareBlog`\n	&summary=`notags,len:350` \n	&tpl=`@CODE:\n		<div class=\"dl_summaryPost\">\n			[+blog-image+]	\n			<h3><a href=\"[~[+id+]~]\" title=\"[+e.title+]\">[+e.title+]</a></h3>\n			<div class=\"dl_info\">\n				By <strong>[+author+]</strong> on [+date+].\n				<a href=\"[+url+]#commentsAnchor\">Comments <span class=\"badge\">[+jotcount+]</span></a>\n			</div>\n			[+summary+]\n			<p class=\"dl_link\">[+link+]</p>\n		</div>` \n	&paginate=`1` \n]]\n\n<p>Showing <strong>[+current+]</strong> of <strong>[+totalPages+]</strong> Pages</p>\n<div id=\"dl_pages\">[+pages+]</div>\n<p>&nbsp;</p>','0','4','1','0','1','1','1144904400','1','1507727477','0','0','0','0','0','Blog','0','0','0','0','0','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('4','document','text/html','Profile','User profile','','profile','','1','0','0','0','1','','[!FormLister?\n&formid=`login`\n&controller=`Login`\n&loginField=`email`\n&redirectTo=`49`\n&defaults=`{\"rememberme\":1}`\n&formControls=`rememberme`\n&rules=`{\n	\"email\":{\n		\"required\":\"Enter your Email\",\n                \"email\":\"You should enter correct Email\"\n	},\n	\"password\":{\n		\"required\":\"Enter your password\"\n	}\n}`\n&formTpl=`@CODE:\n\n<p>In order to comment on blog entries, you must be a registered user of [(site_name)]. If you haven\'t already registered, you can <a href=\"[~5~]\">request an account</a>.</p>\n\n<form class=\"form-horizontal\" method=\"post\" action=\"[(site_url)][~[*id*]~]\">\n	[+form.messages+]\n	<input type=\"hidden\" name=\"formid\" value=\"login\">\n	<div class=\"form-group [+email.classname+] row\">\n		<div class=\"col-sm-12\">\n			<label for=\"email\">Email:</label>\n			<input class=\"form-control\" name=\"email\" value=\"[+email.value+]\" id=\"email\" placeholder=\"Email\">\n		</div>\n	</div>\n	<div class=\"form-group [+password.classname+]\">\n		<div class=\"col-sm-12\">\n			<label for=\"password\">Password:</label>\n			<input type=\"password\" class=\"form-control\" name=\"password\" id=\"password\" placeholder=\"Password\" value=\"[+password.value+]\">\n		</div>\n	</div>\n	<div class=\"form-group\">\n		<div class=\"col-sm-12\">\n			<div class=\"checkbox\">\n				<label>\n					<input type=\"checkbox\" name=\"rememberme\" value=\"1\" [+c.rememberme.1+]> Remember me\n				</label>\n			</div>\n		</div>\n	</div>\n	<div class=\"form-group\">\n		<div class=\"col-sm-8 col-xs-8 sign-in-block\">\n			<a href=\"[~37~]\">Forgot Password</a>\n		</div>\n		<div class=\"col-sm-4 col-xs-4 login-button\">\n			<button type=\"submit\" class=\"btn btn-primary pull-right\"><i class=\"glyphicon glyphicon-log-in\"></i> Login</button>\n		</div>\n	</div>\n	\n</form>\n`\n&skipTpl=`@CODE:\n	<div class=\"text-center\">Hello!</div>\n	<div class=\"text-center\">\n		<a class=\"btn btn-primary\" href=\"[~49~]\"> Edit profile</a> \n		<a class=\"btn btn-primary\" href=\"?logout\"> Logout</a>\n	</div>`\n&errorTpl=`@CODE:<p>[+message+]</p>`\n&messagesOuterTpl=`@CODE:\n	<div class=\"text-danger\">[+messages+]</div>`\n&errorClass=` has-error` \n&requiredClass=` has-warning`\n!]','0','4','6','0','1','1','1144904400','1','1533412259','0','0','0','0','0','','0','0','0','0','0','0');

REPLACE INTO `{PREFIX}site_content` VALUES ('5','document','text/html','Request an Account','Sign Up for Full Site Privileges','','request-an-account','','1','0','0','4','0','','  [!FormLister?\n	&formid=`registerForm`\n	&controller=`Register`\n	&requiredClass=`has-warning`\n	&errorClass=`has-error`\n	&errorTpl=`@CODE:<small class=\"help-block\">[+message+]</small>`\n	&allowedFields=`email,username,fullname,country`\n	&rules=`{\n		\"username\":{\n			\"required\":\"Enter your username\",\n			\"alphaNumeric\":\"Only letters and numbers\",\n			\"custom\":{\n				\"function\":\"\\\\FormLister\\\\Register::uniqueUsername\",\n				\"message\":\"Name already taken\"\n			}\n		},\n		\"email\":{\n			\"required\":\"Enter email\",\n			\"email\":\"Incorrect email\",\n			\"custom\":{\n				\"function\":\"\\\\FormLister\\\\Register::uniqueEmail\",\n				\"message\":\"This email is already in use by another user\"\n			}\n		},\n		\"password\":{\n			\"required\":\"Enter password\"\n		},\n		\"repeatPassword\":{\n			\"required\":\"Retype password\",\n			\"equals\":{\n				\"message\":\"Passwords do not match\"\n			}\n		}\n	}`\n	&captcha=`modxCaptcha`\n	&formTpl=`@CODE: \n\n<form role=\"form\" id=\"websignupfrm\" method=\"post\" name=\"websignupfrm\" action=\"[+action+]\">\n	<input type=\"hidden\" name=\"formid\" value=\"registerForm\"/>\n    <h3>User Details</h3>\n	<div class=\"alert alert-warning\">\n		<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>\n		Items marked by * are required\n	</div>\n	\n	<div class=\"form-group [+username.classname+]\">\n		<label class=\"control-label\" for=\"su_username\">User name:*</label> \n		<input type=\"text\" name=\"username\" id=\"su_username\" class=\"form-control\" maxlength=\"30\" value=\"[+username.value+]\" placeholder=\"Enter Username\"/>\n		[+username.error+]\n	</div>\n	\n	<div class=\"form-group [+fullname.classname+]\">\n        <label class=\"control-label\" for=\"fullname\">Full name:</label> \n		<input type=\"text\" name=\"fullname\" id=\"fullname\" class=\"form-control\" maxlength=\"100\" value=\"[+fullname.value+]\" placeholder=\"Enter fullname\"/>\n		[+fullname.error+]\n	</div>\n	\n	<div class=\"form-group  [+email.classname+]\">\n		<label class=\"control-label\" for=\"email\">Email address:*</label> \n		<input type=\"text\" name=\"email\" id=\"email\" class=\"form-control\" value=\"[+email.value+]\" placeholder=\"Enter email\"/>\n		[+email.error+]\n	</div>\n\n	<div class=\"form-group [+password.classname+]\">\n	    <h3>Password</h3>\n	    <label class=\"control-label\" for=\"su_password\">Password:*</label> \n		<input type=\"password\" name=\"password\" id=\"su_password\" class=\"form-control\" placeholder=\"Enter password\"/>\n		[+password.error+]\n	</div>\n	<div class=\"form-group [+repeatPassword.classname+]\">\n	    <label class=\"control-label\" for=\"confirmpassword\">Confirm password:*</label> \n		<input type=\"password\" name=\"repeatPassword\" id=\"confirmpassword\" class=\"form-control\" placeholder=\"Confirm password\"/>\n		[+repeatPassword.error+]\n	</div>\n	\n	<div class=\"form-group [+country.classname+]\">\n		<h3>Optional Account Profile Info</h3>\n		<label class=\"control-label\" for=\"country\">Country:</label>\n		<select size=\"1\" name=\"country\" id=\"country\" class=\"form-control\" >\n			<option value=\"\" selected=\"selected\">&nbsp;</option>\n			<option value=\"1\">Afghanistan</option>\n			<option value=\"2\">Albania</option>\n			<option value=\"3\">Algeria</option>\n			<option value=\"4\">American Samoa</option>\n			<option value=\"5\">Andorra</option>\n			<option value=\"6\">Angola</option>\n			<option value=\"7\">Anguilla</option>\n			<option value=\"8\">Antarctica</option>\n			<option value=\"9\">Antigua and Barbuda</option>\n			<option value=\"10\">Argentina</option>\n			<option value=\"11\">Armenia</option>\n			<option value=\"12\">Aruba</option>\n			<option value=\"13\">Australia</option>\n			<option value=\"14\">Austria</option>\n			<option value=\"15\">Azerbaijan</option>\n			<option value=\"16\">Bahamas</option>\n			<option value=\"17\">Bahrain</option>\n			<option value=\"18\">Bangladesh</option>\n			<option value=\"19\">Barbados</option>\n			<option value=\"20\">Belarus</option>\n			<option value=\"21\">Belgium</option>\n			<option value=\"22\">Belize</option>\n			<option value=\"23\">Benin</option>\n			<option value=\"24\">Bermuda</option>\n			<option value=\"25\">Bhutan</option>\n			<option value=\"26\">Bolivia</option>\n			<option value=\"27\">Bosnia and Herzegowina</option>\n			<option value=\"28\">Botswana</option>\n			<option value=\"29\">Bouvet Island</option>\n			<option value=\"30\">Brazil</option>\n			<option value=\"31\">British Indian Ocean Territory</option>\n			<option value=\"32\">Brunei Darussalam</option>\n			<option value=\"33\">Bulgaria</option>\n			<option value=\"34\">Burkina Faso</option>\n			<option value=\"35\">Burundi</option>\n			<option value=\"36\">Cambodia</option>\n			<option value=\"37\">Cameroon</option>\n			<option value=\"38\">Canada</option>\n			<option value=\"39\">Cape Verde</option>\n			<option value=\"40\">Cayman Islands</option>\n			<option value=\"41\">Central African Republic</option>\n			<option value=\"42\">Chad</option>\n			<option value=\"43\">Chile</option>\n			<option value=\"44\">China</option>\n			<option value=\"45\">Christmas Island</option>\n			<option value=\"46\">Cocos (Keeling) Islands</option>\n			<option value=\"47\">Colombia</option>\n			<option value=\"48\">Comoros</option>\n			<option value=\"49\">Congo</option>\n			<option value=\"50\">Cook Islands</option>\n			<option value=\"51\">Costa Rica</option>\n			<option value=\"52\">Cote D&#39;Ivoire</option>\n			<option value=\"53\">Croatia</option>\n			<option value=\"54\">Cuba</option>\n			<option value=\"55\">Cyprus</option>\n			<option value=\"56\">Czech Republic</option>\n			<option value=\"57\">Denmark</option>\n			<option value=\"58\">Djibouti</option>\n			<option value=\"59\">Dominica</option>\n			<option value=\"60\">Dominican Republic</option>\n			<option value=\"61\">East Timor</option>\n			<option value=\"62\">Ecuador</option>\n			<option value=\"63\">Egypt</option>\n			<option value=\"64\">El Salvador</option>\n			<option value=\"65\">Equatorial Guinea</option>\n			<option value=\"66\">Eritrea</option>\n			<option value=\"67\">Estonia</option>\n			<option value=\"68\">Ethiopia</option>\n			<option value=\"69\">Falkland Islands (Malvinas)</option>\n			<option value=\"70\">Faroe Islands</option>\n			<option value=\"71\">Fiji</option>\n			<option value=\"72\">Finland</option>\n			<option value=\"73\">France</option>\n			<option value=\"74\">France, Metropolitan</option>\n			<option value=\"75\">French Guiana</option>\n			<option value=\"76\">French Polynesia</option>\n			<option value=\"77\">French Southern Territories</option>\n			<option value=\"78\">Gabon</option>\n			<option value=\"79\">Gambia</option>\n			<option value=\"80\">Georgia</option>\n			<option value=\"81\">Germany</option>\n			<option value=\"82\">Ghana</option>\n			<option value=\"83\">Gibraltar</option>\n			<option value=\"84\">Greece</option>\n			<option value=\"85\">Greenland</option>\n			<option value=\"86\">Grenada</option>\n			<option value=\"87\">Guadeloupe</option>\n			<option value=\"88\">Guam</option>\n			<option value=\"89\">Guatemala</option>\n			<option value=\"90\">Guinea</option>\n			<option value=\"91\">Guinea-bissau</option>\n			<option value=\"92\">Guyana</option>\n			<option value=\"93\">Haiti</option>\n			<option value=\"94\">Heard and Mc Donald Islands</option>\n			<option value=\"95\">Honduras</option>\n			<option value=\"96\">Hong Kong</option>\n			<option value=\"97\">Hungary</option>\n			<option value=\"98\">Iceland</option>\n			<option value=\"99\">India</option>\n			<option value=\"100\">Indonesia</option>\n			<option value=\"101\">Iran (Islamic Republic of)</option>\n			<option value=\"102\">Iraq</option>\n			<option value=\"103\">Ireland</option>\n			<option value=\"104\">Israel</option>\n			<option value=\"105\">Italy</option>\n			<option value=\"106\">Jamaica</option>\n			<option value=\"107\">Japan</option>\n			<option value=\"108\">Jordan</option>\n			<option value=\"109\">Kazakhstan</option>\n			<option value=\"110\">Kenya</option>\n			<option value=\"111\">Kiribati</option>\n			<option value=\"112\">Korea, Democratic People&#39;s Republic of</option>\n			<option value=\"113\">Korea, Republic of</option>\n			<option value=\"114\">Kuwait</option>\n			<option value=\"115\">Kyrgyzstan</option>\n			<option value=\"116\">Lao People&#39;s Democratic Republic</option>\n			<option value=\"117\">Latvia</option>\n			<option value=\"118\">Lebanon</option>\n			<option value=\"119\">Lesotho</option>\n			<option value=\"120\">Liberia</option>\n			<option value=\"121\">Libyan Arab Jamahiriya</option>\n			<option value=\"122\">Liechtenstein</option>\n			<option value=\"123\">Lithuania</option>\n			<option value=\"124\">Luxembourg</option>\n			<option value=\"125\">Macau</option>\n			<option value=\"126\">Macedonia, The Former Yugoslav Republic of</option>\n			<option value=\"127\">Madagascar</option>\n			<option value=\"128\">Malawi</option>\n			<option value=\"129\">Malaysia</option>\n			<option value=\"130\">Maldives</option>\n			<option value=\"131\">Mali</option>\n			<option value=\"132\">Malta</option>\n			<option value=\"133\">Marshall Islands</option>\n			<option value=\"134\">Martinique</option>\n			<option value=\"135\">Mauritania</option>\n			<option value=\"136\">Mauritius</option>\n			<option value=\"137\">Mayotte</option>\n			<option value=\"138\">Mexico</option>\n			<option value=\"139\">Micronesia, Federated States of</option>\n			<option value=\"140\">Moldova, Republic of</option>\n			<option value=\"141\">Monaco</option>\n			<option value=\"142\">Mongolia</option>\n			<option value=\"143\">Montserrat</option>\n			<option value=\"144\">Morocco</option>\n			<option value=\"145\">Mozambique</option>\n			<option value=\"146\">Myanmar</option>\n			<option value=\"147\">Namibia</option>\n			<option value=\"148\">Nauru</option>\n			<option value=\"149\">Nepal</option>\n			<option value=\"150\">Netherlands</option>\n			<option value=\"151\">Netherlands Antilles</option>\n			<option value=\"152\">New Caledonia</option>\n			<option value=\"153\">New Zealand</option>\n			<option value=\"154\">Nicaragua</option>\n			<option value=\"155\">Niger</option>\n			<option value=\"156\">Nigeria</option>\n			<option value=\"157\">Niue</option>\n			<option value=\"158\">Norfolk Island</option>\n			<option value=\"159\">Northern Mariana Islands</option>\n			<option value=\"160\">Norway</option>\n			<option value=\"161\">Oman</option>\n			<option value=\"162\">Pakistan</option>\n			<option value=\"163\">Palau</option>\n			<option value=\"164\">Panama</option>\n			<option value=\"165\">Papua New Guinea</option>\n			<option value=\"166\">Paraguay</option>\n			<option value=\"167\">Peru</option>\n			<option value=\"168\">Philippines</option>\n			<option value=\"169\">Pitcairn</option>\n			<option value=\"170\">Poland</option>\n			<option value=\"171\">Portugal</option>\n			<option value=\"172\">Puerto Rico</option>\n			<option value=\"173\">Qatar</option>\n			<option value=\"174\">Reunion</option>\n			<option value=\"175\">Romania</option>\n			<option value=\"176\">Russian Federation</option>\n			<option value=\"177\">Rwanda</option>\n			<option value=\"178\">Saint Kitts and Nevis</option>\n			<option value=\"179\">Saint Lucia</option>\n			<option value=\"180\">Saint Vincent and the Grenadines</option>\n			<option value=\"181\">Samoa</option>\n			<option value=\"182\">San Marino</option>\n			<option value=\"183\">Sao Tome and Principe</option>\n			<option value=\"184\">Saudi Arabia</option>\n			<option value=\"185\">Senegal</option>\n			<option value=\"186\">Seychelles</option>\n			<option value=\"187\">Sierra Leone</option>\n			<option value=\"188\">Singapore</option>\n			<option value=\"189\">Slovakia (Slovak Republic)</option>\n			<option value=\"190\">Slovenia</option>\n			<option value=\"191\">Solomon Islands</option>\n			<option value=\"192\">Somalia</option>\n			<option value=\"193\">South Africa</option>\n			<option value=\"194\">South Georgia and the South Sandwich Islands</option>\n			<option value=\"195\">Spain</option>\n			<option value=\"196\">Sri Lanka</option>\n			<option value=\"197\">St. Helena</option>\n			<option value=\"198\">St. Pierre and Miquelon</option>\n			<option value=\"199\">Sudan</option>\n			<option value=\"200\">Suriname</option>\n			<option value=\"201\">Svalbard and Jan Mayen Islands</option>\n			<option value=\"202\">Swaziland</option>\n			<option value=\"203\">Sweden</option>\n			<option value=\"204\">Switzerland</option>\n			<option value=\"205\">Syrian Arab Republic</option>\n			<option value=\"206\">Taiwan</option>\n			<option value=\"207\">Tajikistan</option>\n			<option value=\"208\">Tanzania, United Republic of</option>\n			<option value=\"209\">Thailand</option>\n			<option value=\"210\">Togo</option>\n			<option value=\"211\">Tokelau</option>\n			<option value=\"212\">Tonga</option>\n			<option value=\"213\">Trinidad and Tobago</option>\n			<option value=\"214\">Tunisia</option>\n			<option value=\"215\">Turkey</option>\n			<option value=\"216\">Turkmenistan</option>\n			<option value=\"217\">Turks and Caicos Islands</option>\n			<option value=\"218\">Tuvalu</option>\n			<option value=\"219\">Uganda</option>\n			<option value=\"220\">Ukraine</option>\n			<option value=\"221\">United Arab Emirates</option>\n			<option value=\"222\">United Kingdom</option>\n			<option value=\"223\">United States</option>\n			<option value=\"224\">United States Minor Outlying Islands</option>\n			<option value=\"225\">Uruguay</option>\n			<option value=\"226\">Uzbekistan</option>\n			<option value=\"227\">Vanuatu</option>\n			<option value=\"228\">Vatican City State (Holy See)</option>\n			<option value=\"229\">Venezuela</option>\n			<option value=\"230\">Viet Nam</option>\n			<option value=\"231\">Virgin Islands (British)</option>\n			<option value=\"232\">Virgin Islands (U.S.)</option>\n			<option value=\"233\">Wallis and Futuna Islands</option>\n			<option value=\"234\">Western Sahara</option>\n			<option value=\"235\">Yemen</option>\n			<option value=\"236\">Yugoslavia</option>\n			<option value=\"237\">Zaire</option>\n			<option value=\"238\">Zambia</option>\n			<option value=\"239\">Zimbabwe</option>\n			</select>\n			[+country.error+]\n     </div>\n        \n     <div class=\"form-group [+vericode.classname+]\">\n            <h3>Bot-Patrol</h3>\n            <p>Enter the word/number combination shown in the image below.</p>\n		 	\n            <p><a href=\"[+action+]\"><img align=\"top\" src=\"[+captcha+]\" width=\"148\" height=\"60\" alt=\"If you have trouble reading the code, click on the code itself to generate a new random code.\" style=\"border: 1px solid #039\" /></a></p>\n        <label class=\"control-label\">Form code:* \n        <input type=\"text\" name=\"vericode\" class=\"form-control\" size=\"20\" /></label>\n		 [+vericode.error+]\n     </div>\n        \n     <div class=\"form-group\">\n         <input type=\"submit\" class=\"btn btn-success btn-lg\" value=\"Submit\" name=\"cmdwebsignup\" />\n	 </div>\n\n</form>\n\n<script language=\"javascript\" type=\"text/javascript\"> \n	var id = \"[+country.value+]\";\n	var f = document.websignupfrm;\n	var i = parseInt(id);	\n	if (!isNaN(i)) f.country.options[i].selected = true;\n</script>\n\n	`\n	&successTpl=`@CODE:\n		<p class=\"message\">Signup completed successfully!<br />\n		Your account was created. A copy of your signup information was sent to your email address.</p>\n	`\n	&subject=`New registration, [(site_name)]`\n	&ccSender=`1`\n	&ccSenderTpl=`@CODE:\n		<h3>[+fullname.value+], signup completed successfully!</h3>\n		Login: [+email.value+]<br>\n		Password: [+user.password+]<br>\n	`\n	!]','0','4','1','0','1','1','1144904400','1','1515584252','0','0','0','0','0','','0','0','0','0','1','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('6','document','text/html','Contact Us','Contact [(site_name)]','','contact-us','','1','0','0','0','0','','<iframe src=\"https://www.google.com/maps/embed?pb=!1m16!1m10!1m3!1d3352.3801198226956!2d-96.80891138449205!3d32.8355068809543!2m1!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x864e9eee5c9601d9%3A0x5b1cf098be385cee!2s25+Highland+Park+Village+%23100%2C+Dallas%2C+TX+75205%2C+USA!5e0!3m2!1sde!2sde!4v1457530640363\" width=\"100%\" height=\"240\" frameborder=\"0\" style=\"border:0\" allowfullscreen></iframe>\n\n\n<div id=\"ajaxForm\">\n	{{ContactForm}}\n</div>\n<script type=\"text/javascript\">\n	//see plugin evoAjax\n	 $(document).on(\'submit\',\'#ajaxForm form\',function(ev){\n        var frm = $(\'#ajaxForm form\');\n        $(\'#submit\').prop( \"disabled\", true );\n        $.ajax({\n            type: \'post\',\n            url: \'[(site_url)]feedbackajaxform\', \n            data: frm.serialize(),\n            success: function (data) {\n   				$(\'#ajaxForm\').empty();\n                $(\'#ajaxForm\').html( data ); \n            }\n        });\n        ev.preventDefault();\n    });\n</script>','0','4','5','1','1','1','1144904400','1','1507815490','0','0','0','0','0','Contact us','0','0','0','0','0','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('7','document','text/html','404 - Document Not Found','Uh oh ... it\'s a 404! (Page Not Found)','','doc-not-found','','1','0','0','0','0','','<p>Looks like you tried to go somewhere that does not exist... perhaps you <a>need to login</a> or you\'d like one of the following pages instead:</p>\n<p>[[DLMenu? &amp;parents=`0`]]</p>\n<h3>Want to find it the old fashioned way? Use the site search at the top of this site to find what you seek.</h3>','1','4','10','0','1','1','1144904400','1','1507728168','0','0','0','0','0','','0','0','0','0','1','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('8','document','text/html','Search Results','Your Search Results','','search-results','','1','0','0','0','0','','[!AjaxSearch? &showInputForm=`0` &ajaxSearch=`0`!]','0','4','8','0','1','1','1144904400','1','1507728119','0','0','0','0','0','','1','0','0','0','1','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('9','document','text/html','Mini-Blog HOWTO','How to Start Posting with EVO Mini-Blogs','','article-1126081344','','1','0','0','2','0','','<p>Setting up a mini-blog is relatively simple. Here\'s what you need to do to get started with making new posts:</p>\n<ol>\n<li>Login to the <a href=\"[(site_manager_url)]\">EVO Control Panel</a>.</li>\n<li>Press the plus-sign next to the Blog(2) container resource to see the blog entries posted there.</li>\n<li>To make a new Blog entry, simply right-click the Blog container document and choose the \"Create Resource here\" menu option. To edit an existing blog article, right click the entry and choose the \"Edit Resource\" menu option.</li>\n<!-- splitter -->\n<li>Write or edit the content and press save, making sure the document is published.</li>\n<li>Everything else is automatic; you\'re done!</li>\n</ol>','1','4','0','1','1','-1','1144904400','1','1509818890','0','0','0','0','0','','0','0','0','0','1','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('11','document','application/rss+xml','RSS Feed','[(site_name)] RSS Feed','','feed.rss','','1','0','0','0','0','','<!--<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<rss version=\"2.0\">-->\n\n<channel>\n  <title>[(site_name)]</title>\n  <link>[(site_url)]</link>\n  <description>Evolution CMS demo site Feed</description>\n  [[DocLister? \n	&parents=`2`  \n	&display=`20`\n	&summary=`notags,len:350` \n	&tpl=`@CODE:<item>\n			<title>[+e.title+]</title>\n			<link>[(site_url)][~[+id+]~]</link>\n			<description><! [CDATA[ [+summary+] ] ]></description>\n			<pubDate>[+date+]</pubDate>\n			<guid isPermaLink=\"false\">[(site_url)][~[+id+]~]</guid>\n			<dc:creator>[+author+]</dc:creator>\n		</item>`\n	]]\n</channel>\n</rss>','0','0','9','0','1','1','1144904400','1','1507728107','0','0','0','0','0','','0','0','0','0','1','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('14','document','text/html','Content Management','Ways to manage content','','cms','','1','0','0','15','0','','<h2>Manage your content in the backend</h2>\n<p>The Manager is a skinnable feature-packed tool for admin users. You can add extra users and limit what functions they can access. EVO\'s Manager makes creating content and managing templates and reusable elements easy. Modules can be added to work with other datasets or make management tasks easier.</p>\n<h2>Manage your content in the frontend</h2>\n<p>The QuickEdit bar lets manager users edit content whilst browsing the site. Most content fields and template variables can be edited quickly and easily.</p>\n<h2>Enable web users to add content</h2>\n<p>Custom data entry is easy to code using the EVO API - so you can design forms and collect whatever information you need.</p>','1','4','3','1','1','1','1144904400','1','1378086298','0','0','0','1378086298','1','Manage Content','0','0','0','0','0','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('15','document','text/html','EVO Features','EVO Features','','features','','1','0','0','0','1','','[[Wayfinder?startId=`[*id*]` &outerClass=`topnav`]]','1','4','2','1','1','1','1144904400','1','1158452722','0','0','0','1144777367','1','Features','0','0','0','0','0','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('16','document','text/html','Ajax','Ajax and Web 2.0 ready','','ajax','','1','1159264800','0','15','0','','<p><b>Ajax ready out-of-the-box</b></p>\n<p>EVO empowers users to build engaging sites today, with its pre-integrated <a href=\"http://jquery.com/\" target=\"_blank\" rel=\"noopener\">jQuery</a> javascript library.</p>\n<p>Check out the Ajax-powered search in this example site. The libraries are also used with QuickEdit, our front-end editing tool.</p>\n<p>Smart integration means the scripts are only included in the document head when needed - no unnecessary bloat on simple pages!</p>\n<p><b>Web 2.0 today</b></p>\n<p>EVO makes child\'s play of building content managed sites with validating, accessible CSS layouts - so web standards compliance is easy. (You can create a site with excessively nested tables too, if you really want to).</p>','1','4','1','1','1','1','1144904400','1','1507726420','0','0','0','1159264800','1','Ajax','0','0','0','0','0','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('18','document','text/html','Just a pretend, older post','This post should in fact be archived','','article-1128398162','','1','0','0','2','0','','<p>Not so exciting, after all, eh?</p>','1','4','2','1','1','-1','1144904400','1','1509818884','0','0','0','0','0','','0','0','0','0','1','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('22','document','text/html','Menus and Lists','Flexible Menus and Lists','','menus','','1','1159178400','0','15','0','','<h2>Your documents - listed how you want them</h2>\n<p>EVO\'s document data structure has been designed to allow many different routines to redisplay the information in ways that suit your needs, such as a dynamic menu in your template.</p>\n<p>Since the last release of EVO, the community has produced many great snippets - reusable functions that you can call in your content or template. Two of the most widely useful are Ditto and Wayfinder.</p>\n<h2>Wayfinder - the menu builder</h2>\n<p>Allows you to template every part of the menu. On this site, Wayfinder is being used to generate the drop-down menus, but many types of menus and sitemaps are possible.</p>\n<h2>Ditto - the document lister</h2>\n<p>Uses include listing the most recent blog posts, producing a site map, listing related documents (using a TV filter) and generating an RSS feed. You could even write a menu with it. On this site, Ditto is being used for the blog posts list on the Blog page, and the list on the right of some templates.</p>\n<h2>Unlimited Customization</h2>\n<p>If you can\'t quite get your desired effect using templating and the many options of Ditto and Wayfinder, you can write your own routine, or look for other snippets in <a href=\"htts://extras.evo.im/\">the EVO repository</a>. EVO\'s fields for Menu Title, summaries, menu position etc can be used via the API to produce anything you can imagine.</p>','1','4','2','1','1','1','1144904400','1','1160148522','0','0','0','0','0','Menus and Lists','0','0','0','0','0','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('24','document','text/html','Extendable by design','Extendable by design','','extendable','','1','1159092732','0','15','0','','<p>The EVO community has created many add-ons which can be found in the <a href=\"htts://extras.evo.im/\">Repository</a>, from image galleries and e-commerce to smaller utilities.</p>\n<h2>Template Variables with Bindings</h2>\n<p>TVs - Template Variables - are powerful extra fields that you can use with your documents. As an example of an advanced template element that returns a different thing dependent on code or data, we created an @BINDING for the name of the Login menu item. This changes the menu name from Login to Logout based on your logged in state. The @BINDING as follows was placed in the default value as: <code>@EVAL if ($modx-&gt;getLoginUserID()) return \'Logout\'; else return \'Login\';</code></p>\n<h2>Using jQuery-effects</h2>\n<p>We used some simple effects to highlight various things on the front/home page to demonstrate how easy it is to create a useful way to draw attention to things. To see them in action on the home page, click the Integrated Site Search, Related Links or Newest Documents headers.</p>\n<h2>Custom Forms</h2>\n<p>To demonstrate how to link to custom forms, we customized the calls to the Webuser Registration system and the Login system.</p>\n<h2>And more</h2>\n<p><strong>Rich Text Editor for blog entries.</strong> To make it easier to format blog posts with simple text formatting, we modified the blog to use a custom RTE-enabled Template Variable (TV).</p>\n<p><strong>Smart-Summary logic.</strong> When splitting the full blog/news posts you simply insert a \"&lt;!-- splitter --&gt;\" where you want the break to occur. In addition, if that leaves any important tags open, it will try to match them and close them so it doesn\'t mess up your site layout with unclosed OL, UL or DIV tags.</p>','1','4','4','1','1','2','1144904400','1','1159309971','0','0','0','0','0','Extendability','0','0','0','0','0','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('32','document','text/html','Design','Site Design','','design','','1','0','0','0','0','','<h3>Credits</h3>\n<p>The EVO Starter-theme is&nbsp;based on Bootstrap 3.3.6 and made by graffx.nl and fuseit.de.</p>','1','4','4','1','1','2','1144904400','1','1160112322','0','0','0','1144912754','1','Design','0','0','0','0','0','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('33','document','text/html','Getting Help','Getting Help with EVO','','getting-help','','1','0','0','0','0','','<p>The <a href=\"https://github.com/orgs/evolution-cms/teams/\" target=\"_blank\" rel=\"noopener\">team behind EVO</a> strives to constantly add to and refine the documentation to help you get up to speed with EVO:</p>\n<ul>\n<li>For basic instructions on integrating custom templates into EVO, please see the <a href=\"http://www.evolution-docs.com/documentation/designing/\" target=\"_blank\" rel=\"noopener\">Designer\'s Guide</a>.</li>\n<li>For an introduction to working in EVO from the content editors perspectve, see the <a href=\"http://www.evolution-docs.com/documentation/content-editing/\" target=\"_blank\" rel=\"noopener\">Content Editor\'s Guide</a>.</li>\n<li>For a detailed overview of the backend \"manager\" and setting up Users and Groups, please peruse the <a href=\"http://www.evolution-docs.com/documentation/administration/\" target=\"_blank\" rel=\"noopener\">Administration Guide</a>.</li>\n<li>For developers, architecture and API documentation can be found in the <a href=\"http://www.evolution-docs.com/documentation/developers-guide/\" target=\"_blank\" rel=\"noopener\">Developer\'s Guide</a>.</li>\n<li>And if someone has installed this site for you, but you\'re curious as to the steps they went through, please see the <a href=\"http://www.evolution-docs.com/documentation/getting-started/\" target=\"_blank\" rel=\"noopener\">Getting Started Guide</a>.</li>\n</ul>\n<p>And don\'t forget, you can always learn and ask questions at the <a href=\"http://forum.evolution-cms.com/\" target=\"_blank\" rel=\"noopener\">EVO forums</a>.</p>','1','4','3','1','1','2','1144904400','1','1507728208','0','0','0','0','0','Getting Help','0','0','0','0','0','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('37','document','text/html','Forgot Password','','','forgot-password','','1','0','0','4','0','','[!FormLister?\n&controller=`Reminder`\n&formid=`remind`\n&rules=`{\n	\"email\":{\n		\"required\":\"Be sure to enter email\",\n		\"email\":\"Enter email correctly\"\n	}\n}`\n&resetRules=`{\n	\"password\":{\n		\"required\":\"Be sure to enter the password\",\n		\"minLength\":{\n			\"params\":6,\n			\"message\":\"Password must be longer than 6 characters\"\n		}\n	},\n	\"repeatPassword\":{\n		\"required\":\"Repeat password\",\n		\"equals\":{\n			\"message\":\"Passwords do not match\"\n		}\n	}\n}`\n&formTpl=`@CODE:\n\n<div class=\"form-remind\">\n	[+form.messages+]\n	<h2 class=\"form-signin-heading\">[*pagetitle*]</h2>\n	<form method=\"post\">\n		<input type=\"hidden\" name=\"formid\" value=\"remind\">\n		<div class=\"form-group\">\n			<input type=\"text\" class=\"form-control\" id=\"email\" placeholder=\"Email\" name=\"email\" value=\"[+email.value+]\">\n			[+email.error+]\n		</div>\n\n		<div class=\"form-group\">\n			<button type=\"submit\" class=\"btn btn-primary\"><i class=\"glyphicon glyphicon-ok-sign\"></i> Submit</button>\n		</div>\n	</form>\n</div>`\n\n&resetTpl=`@CODE:\n<div class=\"form-remind\">\n	[+form.messages+]\n	<h2 class=\"form-signin-heading\">[*pagetitle*]</h2>\n	<form method=\"post\" class=\"\">\n		<input type=\"hidden\" name=\"formid\" value=\"remind\">\n		<div class=\"form-group\">\n			<input type=\"password\" class=\"form-control\" id=\"password1\" placeholder=\"New password\" name=\"password\" value=\"\">\n			[+password.error+]\n			<input type=\"password\" class=\"form-control\" id=\"password2\" placeholder=\"Repeat Password\" name=\"repeatPassword\" value=\"\">\n			[+repeatPassword.error+]\n		</div>\n		<div class=\"form-group\">\n			<button type=\"submit\" class=\"btn btn-primary\"><i class=\"glyphicon glyphicon-floppy-disk\"></i> Save</button>\n		</div>\n	</form>\n</div>\n`\n&messagesOuterTpl=`@CODE:<div class=\"alert alert-danger\" role=\"alert\">[+messages+]</div>`\n&successTpl=`@CODE:\n<div class=\"form-reg\">\n	<div class=\"text-center\">An email with the instructions has been sent to the email you specified when registering!</div>\n</div>`\n\n&subject=`Password recovery, [(site_name)]`\n&reportTpl=`@CODE:<p>To recover your password, click on the link <a href=\"[+reset.url+]\">[+reset.url+]</a></p>`\n&resetReportTpl=`@CODE:<p>Hello, [+fullname.value+]!</p><p>Your new password: [+newpassword+]</p>`\n&resetTo=`37`\n&redirectTo=`4`\n&errorTpl=`@CODE:<span class=\"help-block\">[+message+]</span>`\n!]','0','4','2','0','1','1','1144904400','1','1509806093','0','0','0','0','0','','0','0','0','0','1','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('47','document','text/html','New documentation site: docs.evo.im','Multilingual documentation for Evolution CMS ','','new-documentation-site-docs.evo.im','','1','0','0','2','0','You can get documentation here: http://docs.evo.im','<p>You can get documentation here: <a href=\"http://docs.evo.im\">http://docs.evo.im</a></p>\n<h2>Evolution CMS Docs</h2>\n<p><em>Evolution is a professional website development tool that allows you to manage content (and the site itself) absolutely 100%! This system is open source, and therefore free. Unlike most free CMS (English Content Management System) - on EVO you can build a site of any complexity, with almost any set of functions, and the system will not in any way influence your html code.</em></p>\n<h2>How to contribute</h2>\n<ol>\n<li>First of all, you must have an account on GitHub, if not - <a href=\"https://github.com/join\">then it\'s very simple</a>.</li>\n<li>Make a fork <a href=\"https://github.com/evolution-cms/docs/\">https://github.com/evolution-cms/docs/</a> to yourself by clicking the \"Fork\" button on the top right.</li>\n<li>Clone the repository to your disk and work with it locally, like everyone else (if you are a developer)</li>\n<li>If you are not a developer, you can simply edit the * .md files directly on GitHub.</li>\n<li>When you have done everything, you should <a href=\"https://help.github.com/articles/creating-a-pull-request\">make a \"Pull Request\"</a> and send it by sending changes to this repository.</li>\n</ol>','1','4','2','1','1','1','1507724288','1','1509818879','0','0','0','1507724288','1','','0','0','0','0','1','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('48','document','text/xml','sitemap.xml','','','sitemap.xml','','1','0','0','0','0','','[[DLSitemap]]','0','0','11','1','1','1','1507726985','1','1507727020','0','0','0','1507726985','1','','0','0','0','0','1','1');

REPLACE INTO `{PREFIX}site_content` VALUES ('49','document','text/html','Edit profile','User profile','','editprofile','','1','0','0','4','0','','<a class=\"btn btn-primary\" href=\"?logout\"> Logout</a>\n  [!FormLister?\n	&formid=`registerForm`\n	&controller=`Profile`\n	&requiredClass=`has-warning`\n	&errorClass=`has-error`\n	&errorTpl=`@CODE:<small class=\"help-block\">[+message+]</small>`\n	&allowedFields=`email,username,fullname,country`\n	&rules=`{\n		\"username\":{\n			\"required\":\"Enter your username\",\n			\"alphaNumeric\":\"Only letters and numbers\",\n			\"custom\":{\n				\"function\":\"\\\\FormLister\\\\Register::uniqueUsername\",\n				\"message\":\"Name already taken\"\n			}\n		},\n		\"email\":{\n			\"required\":\"Enter email\",\n			\"email\":\"Incorrect email\",\n			\"custom\":{\n				\"function\":\"\\\\FormLister\\\\Register::uniqueEmail\",\n				\"message\":\"This email is already in use by another user\"\n			}\n		},\n		\"password\":{\n			\"required\":\"Enter password\"\n		},\n		\"repeatPassword\":{\n			\"required\":\"Retype password\",\n			\"equals\":{\n				\"message\":\"Passwords do not match\"\n			}\n		}\n	}`\n	&formTpl=`@CODE: \n\n<form role=\"form\" id=\"websignupfrm\" method=\"post\" name=\"websignupfrm\" action=\"[+action+]\">\n	<input type=\"hidden\" name=\"formid\" value=\"registerForm\"/>\n    <h3>User Details</h3>\n	\n	<div class=\"form-group [+username.classname+]\">\n		<label class=\"control-label\" for=\"su_username\">User name:</label> \n		<input type=\"text\" name=\"username\" id=\"su_username\" class=\"form-control\" maxlength=\"30\" value=\"[+username.value+]\" placeholder=\"Enter Username\"/>\n		[+username.error+]\n	</div>\n	\n	<div class=\"form-group [+fullname.classname+]\">\n        <label class=\"control-label\" for=\"fullname\">Full name:</label> \n		<input type=\"text\" name=\"fullname\" id=\"fullname\" class=\"form-control\" maxlength=\"100\" value=\"[+fullname.value+]\" placeholder=\"Enter fullname\"/>\n		[+fullname.error+]\n	</div>\n	\n	<div class=\"form-group  [+email.classname+]\">\n		<label class=\"control-label\" for=\"email\">Email address:</label> \n		<input type=\"text\" name=\"email\" id=\"email\" class=\"form-control\" value=\"[+email.value+]\" placeholder=\"Enter email\"/>\n		[+email.error+]\n	</div>\n\n	<div class=\"form-group [+password.classname+]\">\n	    <h3>Password</h3>\n	    <label class=\"control-label\" for=\"su_password\">Password:</label> \n		<input type=\"password\" name=\"password\" id=\"su_password\" class=\"form-control\" placeholder=\"Enter password\"/>\n		[+password.error+]\n	</div>\n	<div class=\"form-group [+repeatPassword.classname+]\">\n	    <label class=\"control-label\" for=\"confirmpassword\">Confirm password:</label> \n		<input type=\"password\" name=\"repeatPassword\" id=\"confirmpassword\" class=\"form-control\" placeholder=\"Confirm password\"/>\n		[+repeatPassword.error+]\n	</div>\n	\n	<div class=\"form-group [+country.classname+]\">\n		<h3>Optional Account Profile Info</h3>\n		<label class=\"control-label\" for=\"country\">Country:</label>\n		<select size=\"1\" name=\"country\" id=\"country\" class=\"form-control\" >\n			<option value=\"\" selected=\"selected\">&nbsp;</option>\n			<option value=\"1\">Afghanistan</option>\n			<option value=\"2\">Albania</option>\n			<option value=\"3\">Algeria</option>\n			<option value=\"4\">American Samoa</option>\n			<option value=\"5\">Andorra</option>\n			<option value=\"6\">Angola</option>\n			<option value=\"7\">Anguilla</option>\n			<option value=\"8\">Antarctica</option>\n			<option value=\"9\">Antigua and Barbuda</option>\n			<option value=\"10\">Argentina</option>\n			<option value=\"11\">Armenia</option>\n			<option value=\"12\">Aruba</option>\n			<option value=\"13\">Australia</option>\n			<option value=\"14\">Austria</option>\n			<option value=\"15\">Azerbaijan</option>\n			<option value=\"16\">Bahamas</option>\n			<option value=\"17\">Bahrain</option>\n			<option value=\"18\">Bangladesh</option>\n			<option value=\"19\">Barbados</option>\n			<option value=\"20\">Belarus</option>\n			<option value=\"21\">Belgium</option>\n			<option value=\"22\">Belize</option>\n			<option value=\"23\">Benin</option>\n			<option value=\"24\">Bermuda</option>\n			<option value=\"25\">Bhutan</option>\n			<option value=\"26\">Bolivia</option>\n			<option value=\"27\">Bosnia and Herzegowina</option>\n			<option value=\"28\">Botswana</option>\n			<option value=\"29\">Bouvet Island</option>\n			<option value=\"30\">Brazil</option>\n			<option value=\"31\">British Indian Ocean Territory</option>\n			<option value=\"32\">Brunei Darussalam</option>\n			<option value=\"33\">Bulgaria</option>\n			<option value=\"34\">Burkina Faso</option>\n			<option value=\"35\">Burundi</option>\n			<option value=\"36\">Cambodia</option>\n			<option value=\"37\">Cameroon</option>\n			<option value=\"38\">Canada</option>\n			<option value=\"39\">Cape Verde</option>\n			<option value=\"40\">Cayman Islands</option>\n			<option value=\"41\">Central African Republic</option>\n			<option value=\"42\">Chad</option>\n			<option value=\"43\">Chile</option>\n			<option value=\"44\">China</option>\n			<option value=\"45\">Christmas Island</option>\n			<option value=\"46\">Cocos (Keeling) Islands</option>\n			<option value=\"47\">Colombia</option>\n			<option value=\"48\">Comoros</option>\n			<option value=\"49\">Congo</option>\n			<option value=\"50\">Cook Islands</option>\n			<option value=\"51\">Costa Rica</option>\n			<option value=\"52\">Cote D&#39;Ivoire</option>\n			<option value=\"53\">Croatia</option>\n			<option value=\"54\">Cuba</option>\n			<option value=\"55\">Cyprus</option>\n			<option value=\"56\">Czech Republic</option>\n			<option value=\"57\">Denmark</option>\n			<option value=\"58\">Djibouti</option>\n			<option value=\"59\">Dominica</option>\n			<option value=\"60\">Dominican Republic</option>\n			<option value=\"61\">East Timor</option>\n			<option value=\"62\">Ecuador</option>\n			<option value=\"63\">Egypt</option>\n			<option value=\"64\">El Salvador</option>\n			<option value=\"65\">Equatorial Guinea</option>\n			<option value=\"66\">Eritrea</option>\n			<option value=\"67\">Estonia</option>\n			<option value=\"68\">Ethiopia</option>\n			<option value=\"69\">Falkland Islands (Malvinas)</option>\n			<option value=\"70\">Faroe Islands</option>\n			<option value=\"71\">Fiji</option>\n			<option value=\"72\">Finland</option>\n			<option value=\"73\">France</option>\n			<option value=\"74\">France, Metropolitan</option>\n			<option value=\"75\">French Guiana</option>\n			<option value=\"76\">French Polynesia</option>\n			<option value=\"77\">French Southern Territories</option>\n			<option value=\"78\">Gabon</option>\n			<option value=\"79\">Gambia</option>\n			<option value=\"80\">Georgia</option>\n			<option value=\"81\">Germany</option>\n			<option value=\"82\">Ghana</option>\n			<option value=\"83\">Gibraltar</option>\n			<option value=\"84\">Greece</option>\n			<option value=\"85\">Greenland</option>\n			<option value=\"86\">Grenada</option>\n			<option value=\"87\">Guadeloupe</option>\n			<option value=\"88\">Guam</option>\n			<option value=\"89\">Guatemala</option>\n			<option value=\"90\">Guinea</option>\n			<option value=\"91\">Guinea-bissau</option>\n			<option value=\"92\">Guyana</option>\n			<option value=\"93\">Haiti</option>\n			<option value=\"94\">Heard and Mc Donald Islands</option>\n			<option value=\"95\">Honduras</option>\n			<option value=\"96\">Hong Kong</option>\n			<option value=\"97\">Hungary</option>\n			<option value=\"98\">Iceland</option>\n			<option value=\"99\">India</option>\n			<option value=\"100\">Indonesia</option>\n			<option value=\"101\">Iran (Islamic Republic of)</option>\n			<option value=\"102\">Iraq</option>\n			<option value=\"103\">Ireland</option>\n			<option value=\"104\">Israel</option>\n			<option value=\"105\">Italy</option>\n			<option value=\"106\">Jamaica</option>\n			<option value=\"107\">Japan</option>\n			<option value=\"108\">Jordan</option>\n			<option value=\"109\">Kazakhstan</option>\n			<option value=\"110\">Kenya</option>\n			<option value=\"111\">Kiribati</option>\n			<option value=\"112\">Korea, Democratic People&#39;s Republic of</option>\n			<option value=\"113\">Korea, Republic of</option>\n			<option value=\"114\">Kuwait</option>\n			<option value=\"115\">Kyrgyzstan</option>\n			<option value=\"116\">Lao People&#39;s Democratic Republic</option>\n			<option value=\"117\">Latvia</option>\n			<option value=\"118\">Lebanon</option>\n			<option value=\"119\">Lesotho</option>\n			<option value=\"120\">Liberia</option>\n			<option value=\"121\">Libyan Arab Jamahiriya</option>\n			<option value=\"122\">Liechtenstein</option>\n			<option value=\"123\">Lithuania</option>\n			<option value=\"124\">Luxembourg</option>\n			<option value=\"125\">Macau</option>\n			<option value=\"126\">Macedonia, The Former Yugoslav Republic of</option>\n			<option value=\"127\">Madagascar</option>\n			<option value=\"128\">Malawi</option>\n			<option value=\"129\">Malaysia</option>\n			<option value=\"130\">Maldives</option>\n			<option value=\"131\">Mali</option>\n			<option value=\"132\">Malta</option>\n			<option value=\"133\">Marshall Islands</option>\n			<option value=\"134\">Martinique</option>\n			<option value=\"135\">Mauritania</option>\n			<option value=\"136\">Mauritius</option>\n			<option value=\"137\">Mayotte</option>\n			<option value=\"138\">Mexico</option>\n			<option value=\"139\">Micronesia, Federated States of</option>\n			<option value=\"140\">Moldova, Republic of</option>\n			<option value=\"141\">Monaco</option>\n			<option value=\"142\">Mongolia</option>\n			<option value=\"143\">Montserrat</option>\n			<option value=\"144\">Morocco</option>\n			<option value=\"145\">Mozambique</option>\n			<option value=\"146\">Myanmar</option>\n			<option value=\"147\">Namibia</option>\n			<option value=\"148\">Nauru</option>\n			<option value=\"149\">Nepal</option>\n			<option value=\"150\">Netherlands</option>\n			<option value=\"151\">Netherlands Antilles</option>\n			<option value=\"152\">New Caledonia</option>\n			<option value=\"153\">New Zealand</option>\n			<option value=\"154\">Nicaragua</option>\n			<option value=\"155\">Niger</option>\n			<option value=\"156\">Nigeria</option>\n			<option value=\"157\">Niue</option>\n			<option value=\"158\">Norfolk Island</option>\n			<option value=\"159\">Northern Mariana Islands</option>\n			<option value=\"160\">Norway</option>\n			<option value=\"161\">Oman</option>\n			<option value=\"162\">Pakistan</option>\n			<option value=\"163\">Palau</option>\n			<option value=\"164\">Panama</option>\n			<option value=\"165\">Papua New Guinea</option>\n			<option value=\"166\">Paraguay</option>\n			<option value=\"167\">Peru</option>\n			<option value=\"168\">Philippines</option>\n			<option value=\"169\">Pitcairn</option>\n			<option value=\"170\">Poland</option>\n			<option value=\"171\">Portugal</option>\n			<option value=\"172\">Puerto Rico</option>\n			<option value=\"173\">Qatar</option>\n			<option value=\"174\">Reunion</option>\n			<option value=\"175\">Romania</option>\n			<option value=\"176\">Russian Federation</option>\n			<option value=\"177\">Rwanda</option>\n			<option value=\"178\">Saint Kitts and Nevis</option>\n			<option value=\"179\">Saint Lucia</option>\n			<option value=\"180\">Saint Vincent and the Grenadines</option>\n			<option value=\"181\">Samoa</option>\n			<option value=\"182\">San Marino</option>\n			<option value=\"183\">Sao Tome and Principe</option>\n			<option value=\"184\">Saudi Arabia</option>\n			<option value=\"185\">Senegal</option>\n			<option value=\"186\">Seychelles</option>\n			<option value=\"187\">Sierra Leone</option>\n			<option value=\"188\">Singapore</option>\n			<option value=\"189\">Slovakia (Slovak Republic)</option>\n			<option value=\"190\">Slovenia</option>\n			<option value=\"191\">Solomon Islands</option>\n			<option value=\"192\">Somalia</option>\n			<option value=\"193\">South Africa</option>\n			<option value=\"194\">South Georgia and the South Sandwich Islands</option>\n			<option value=\"195\">Spain</option>\n			<option value=\"196\">Sri Lanka</option>\n			<option value=\"197\">St. Helena</option>\n			<option value=\"198\">St. Pierre and Miquelon</option>\n			<option value=\"199\">Sudan</option>\n			<option value=\"200\">Suriname</option>\n			<option value=\"201\">Svalbard and Jan Mayen Islands</option>\n			<option value=\"202\">Swaziland</option>\n			<option value=\"203\">Sweden</option>\n			<option value=\"204\">Switzerland</option>\n			<option value=\"205\">Syrian Arab Republic</option>\n			<option value=\"206\">Taiwan</option>\n			<option value=\"207\">Tajikistan</option>\n			<option value=\"208\">Tanzania, United Republic of</option>\n			<option value=\"209\">Thailand</option>\n			<option value=\"210\">Togo</option>\n			<option value=\"211\">Tokelau</option>\n			<option value=\"212\">Tonga</option>\n			<option value=\"213\">Trinidad and Tobago</option>\n			<option value=\"214\">Tunisia</option>\n			<option value=\"215\">Turkey</option>\n			<option value=\"216\">Turkmenistan</option>\n			<option value=\"217\">Turks and Caicos Islands</option>\n			<option value=\"218\">Tuvalu</option>\n			<option value=\"219\">Uganda</option>\n			<option value=\"220\">Ukraine</option>\n			<option value=\"221\">United Arab Emirates</option>\n			<option value=\"222\">United Kingdom</option>\n			<option value=\"223\">United States</option>\n			<option value=\"224\">United States Minor Outlying Islands</option>\n			<option value=\"225\">Uruguay</option>\n			<option value=\"226\">Uzbekistan</option>\n			<option value=\"227\">Vanuatu</option>\n			<option value=\"228\">Vatican City State (Holy See)</option>\n			<option value=\"229\">Venezuela</option>\n			<option value=\"230\">Viet Nam</option>\n			<option value=\"231\">Virgin Islands (British)</option>\n			<option value=\"232\">Virgin Islands (U.S.)</option>\n			<option value=\"233\">Wallis and Futuna Islands</option>\n			<option value=\"234\">Western Sahara</option>\n			<option value=\"235\">Yemen</option>\n			<option value=\"236\">Yugoslavia</option>\n			<option value=\"237\">Zaire</option>\n			<option value=\"238\">Zambia</option>\n			<option value=\"239\">Zimbabwe</option>\n			</select>\n			[+country.error+]\n     </div>\n      \n     <div class=\"form-group\">\n         <input type=\"submit\" class=\"btn btn-success btn-lg\" value=\"Submit\" name=\"cmdwebsignup\" />\n	 </div>\n\n</form>\n\n<script language=\"javascript\" type=\"text/javascript\"> \n	var id = \"[+country.value+]\";\n	var f = document.websignupfrm;\n	var i = parseInt(id);	\n	if (!isNaN(i)) f.country.options[i].selected = true;\n</script>\n\n	`!]\n','0','4','0','1','1','1','1509808504','1','1509817993','0','0','0','1509808504','1','','0','0','0','0','1','1');


#
# Dumping data for table `site_htmlsnippets`
#

INSERT INTO `{PREFIX}site_htmlsnippets` VALUES ('1','Comments_tplComments','Comments (Jot) Form-Template','0','none','1','0','<a name=\"jc[+jot.link.id+][+comment.id+]\"></a>\n<div class=\"panel panel-[+chunk.rowclass:ne=``:then=`primary`:else=`info`+] [+comment.published:is=`0`:then=`jot-row-up`+]\">\n	<div class=\"panel-heading\"><span class=\"jot-subject\">[+comment.title:limit:esc+]<span class=\"pull-right\">\n		[+phx:userinfo=`lastlogin`:ifempty=`9999999999`:lt=`[+comment.createdon+]`:then=`\n		<i class=\"fa fa-fw fa-comment-o\" aria-hidden=\"true\"></i>\n		`:else=`\n		<i class=\"fa fa-fw fa-commenting-o\" aria-hidden=\"true\"></i>\n		`:strip+]\n		</span></span>\n	</div>\n	<div class=\"panel-body\">\n		<div class=\"jot-comment\">\n			<div class=\"jot-user\">\n				[+comment.createdby:isnt=`0`:then=`<b>`+][+comment.createdby:userinfo=`username`:ifempty=`[+comment.custom.name:ifempty=`[+jot.guestname+]`:esc+]`+]\n				[+comment.createdby:isnt=`0`:then=`</b>`+]\n				<br>Posts: [+comment.userpostcount+]\n			</div>\n			<div class=\"jot-content\">\n				<div class=\"pull-right btn-group\">\n					[+jot.moderation.enabled:is=`1`:then=`\n					<a class=\"btn btn-xs btn-danger\" href=\"[+jot.link.delete:esc+][+jot.querykey.id+]=[+comment.id+]#jotmod[+jot.link.id+]\" onclick=\"return confirm(\'Are you sure you wish to delete this comment?\')\" title=\"Delete Comment\"><i class=\"fa fa-fw fa-trash\" aria-hidden=\"true\"></i></a> \n					[+comment.published:is=`0`:then=`\n					<a class=\"btn btn-xs btn-info\"href=\"[+jot.link.publish:esc+][+jot.querykey.id+]=[+comment.id+]#jotmod[+jot.link.id+]\" onclick=\"return confirm(\'Are you sure you wish to publish this comment?\')\" title=\"Publish Comment\"><i class=\"fa fa-fw fa-check\" aria-hidden=\"true\"></i></a> \n					`+]\n					[+comment.published:is=`1`:then=`\n					<a class=\"btn btn-xs btn-warning\" href=\"[+jot.link.unpublish:esc+][+jot.querykey.id+]=[+comment.id+]#jotmod[+jot.link.id+]\" onclick=\"return confirm(\'Are you sure you wish to unpublish this comment?\')\" title=\"Unpublish Comment\"><i class=\"fa fa-fw fa-close\" aria-hidden=\"true\"></i></a> \n					`+]\n					`:strip+]\n					[+jot.user.canedit:is=`1`:and:if=`[+comment.createdby+]`:is=`[+jot.user.id+]`:or:if=`[+jot.moderation.enabled+]`:is=`1`:then=`\n					<a class=\"btn btn-xs btn-success\" href=\"[+jot.link.edit:esc+][+jot.querykey.id+]=[+comment.id+]#jf[+jot.link.id+]\" onclick=\"return confirm(\'Are you sure you wish to edit this comment?\')\" title=\"Edit Comment\"><i class=\"fa fa-fw fa-pencil-square-o\" aria-hidden=\"true\"></i></a>\n					`:strip+]\n				</div>\n				<span class=\"jot-poster\"><b>Reply #[+comment.postnumber+] on :</b> [+comment.createdon:date=`%a %B %d, %Y, %H:%M:%S`+]</span>\n				<hr>\n				<div class=\"jot-message\">[+comment.content:wordwrap:esc:nl2br+]</div>\n				<div class=\"jot-extra\">\n					[+comment.editedon:isnt=`0`:then=`\n					<span class=\"jot-editby\">Last Edit: [+comment.editedon:date=`%B %d, %Y, %H:%M:%S`+] by [+comment.editedby:userinfo=`username`:ifempty=` * `+]</span>\n					&nbsp;`+] [+jot.moderation.enabled:is=`1`:then=`<a target=\"_blank\" href=\"http://www.ripe.net/perl/whois?searchtext=[+comment.secip+]\">[+comment.secip+]</a>`+]\n				</div>\n			</div>\n		</div>\n	</div>\n</div>','0','0','0','0');

INSERT INTO `{PREFIX}site_htmlsnippets` VALUES ('3','AjaxSearch_tplInput','Input-Form for AjaxSearch','0','none','1','0','[+as.showInputForm:is=`1`:then=`\n<form id=\"[+as.formId+]\" action=\"[+as.formAction+]\" method=\"post\">\n    [+as.showAsId:is=`1`:then=`<input type=\"hidden\" name=\"[+as.asName+]\" value=\"[+as.asId+]\" />`+]\n    <input type=\"hidden\" name=\"advsearch\" value=\"[+as.advSearch+]\" />\n	<div class=\"input-group\">\n		<input id=\"[+as.inputId+]\" class=\"form-control cleardefault\" type=\"text\" name=\"search\" value=\"[+as.inputValue+]\"[+as.inputOptions+] />\n		[+as.liveSearch:is=`0`:then=`\n		<span class=\"input-group-btn\">\n			<button class=\"btn btn-primary\" type=\"submit\"><i class=\"fa fa-search\"></i></button>	\n		</span>\n		`:else=`\n		<div class=\"input-group-addon\"><i class=\"fa fa-search\"></i></div>\n		`+]		\n	</div>\n</form>\n`+]\n[+as.showIntro:is=`1`:then=`\n<p class=\"ajaxSearch_intro\" id=\"ajaxSearch_intro\">[+as.introMessage+]</p>\n`+]','0','0','0','0');

INSERT INTO `{PREFIX}site_htmlsnippets` VALUES ('4','AjaxSearch_tplAjaxResult','Result Tpl for AjaxSearch','0','none','1','0','<div class=\"[+as.resultClass+]\">\n  <strong><a class=\"[+as.resultLinkClass+]\" href=\"[+as.resultLink+]\" title=\"[+as.longtitle+]\">[+as.pagetitle+]</a></strong>\n[+as.descriptionShow:is=`1`:then=`\n  <small><span class=\"[+as.descriptionClass+]\">[+as.description+]</span></small>\n`+]\n[+as.extractShow:is=`1`:then=`\n  <div class=\"[+as.extractClass+]\"><p>[+as.extract+]</p></div>\n`+]\n[+as.breadcrumbsShow:is=`1`:then=`\n  <span class=\"[+as.breadcrumbsClass+]\">[+as.breadcrumbs+]</span>\n`+]\n</div>','0','0','0','0');

INSERT INTO `{PREFIX}site_htmlsnippets` VALUES ('6','AjaxSearch_tplAjaxGrpResult','Grp Result Tpl for AjaxSearch','0','none','1','0','[+as.grpResultsDef:is=`1`:then=`\n<div id=\"[+as.grpResultId+]\" class=\"AS_ajax_grpResult\">\n[+as.headerGrpResult+]\n[+as.listResults+]\n[+as.footerGrpResult+]\n</div>\n`:else=`\n<div class=\"AS_ajax_grpResultName\">[+as.grpResultNameShow:is=`1`:then=`[+as.grpResultName+]`+]\n<span class=\"ajaxSearch_grpResultsDisplayed\">[+as.grpResultsDisplayedText+]</span></div>\n`+]','0','0','0','0');

INSERT INTO `{PREFIX}site_htmlsnippets` VALUES ('8','AjaxSearch_tplAjaxResults','Results Tpl for AjaxSearch','0','none','1','0','<div id=\"search_results\" class=\"modal fade\" tabindex=\"-1\" role=\"dialog\">\n  <div class=\"modal-dialog\">\n    <div class=\"modal-content\">\n      <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-label=\"Close\"><span aria-hidden=\"true\">&times;</span></button>\n        <h3 class=\"modal-title\">Search Results</h3>\n      </div>\n      <div class=\"modal-body\">\n        [+as.noResults:is=`1`:then=`\n		  <div class=\"[+as.noResultClass+]\">\n			[+as.noResultText+]\n		  </div>\n		`:else=`\n		<p class=\"AS_ajax_resultsInfos\">[+as.resultsFoundText+]<span class=\"AS_ajax_resultsDisplayed\">[+as.resultsDisplayedText+]</span></p>\n		[+as.listGrpResults+]\n		`+]\n		[+as.moreResults:is=`1`:then=`\n		  <div class=\"[+as.moreClass+]\">\n			<a href=\"[+as.moreLink+]\" title=\"[+as.moreTitle+]\">[+as.moreText+]</a>\n		  </div>\n		`+]\n		[+as.showCmt:is=`1`:then=`\n		[+as.comment+]\n		`+]\n      </div>\n      <div class=\"modal-footer\">\n        <button type=\"button\" class=\"btn btn-primary\" data-dismiss=\"modal\">Close</button>\n      </div>\n    </div><!-- /.modal-content -->\n  </div><!-- /.modal-dialog -->\n</div><!-- /.modal -->\n<script>$(\'#search_results\').modal(\'show\')</script>','0','0','0','0');

INSERT INTO `{PREFIX}site_htmlsnippets` VALUES ('9','Comments_tplForm','Comments (Jot) Form-Template','0','none','1','0','<a name=\"jf[+jot.link.id+]\"></a>\n<h2>[+form.edit:is=`1`:then=`Edit comment`:else=`Write a comment`+]</h2>\n<div class=\"jot-list\">\n<ul>\n	<li>Required fields are marked with <b>*</b>.</li>\n</ul>\n</div>\n[+form.error:isnt=`0`:then=`\n<div class=\"jot-err\">\n[+form.error:select=`\n&-3=You are trying to re-submit the same post. You have probably clicked the submit button more than once.\n&-2=Your comment has been rejected.\n&-1=Your comment has been saved, it will first be reviewed before it is published.\n&1=You are trying to re-submit the same post. You have probably clicked the submit button more than once.\n&2=The security code you entered was incorrect.\n&3=You can only post once each [+jot.postdelay+] seconds.\n&4=Your comment has been rejected.\n&5=[+form.errormsg:ifempty=`You didn\'t enter all the required fields`+]\n`+]\n</div>\n`:strip+]\n[+form.confirm:isnt=`0`:then=`\n<div class=\"jot-cfm\">\n[+form.confirm:select=`\n&1=Your comment has been published.\n&2=Your comment has been saved, it will first be reviewed before it is published.\n&3=Comment saved.\n`+]\n</div>\n`:strip+]\n<form method=\"post\" action=\"[+form.action:esc+]#jf[+jot.link.id+]\" class=\"jot-form\">\n	<fieldset>\n	<input name=\"JotForm\" type=\"hidden\" value=\"[+jot.id+]\" />\n	<input name=\"JotNow\" type=\"hidden\" value=\"[+jot.seed+]\" />\n	<input name=\"parent\" type=\"hidden\" value=\"[+form.field.parent+]\" />\n	\n	[+form.moderation:is=`1`:then=`\n		<div class=\"jot-row\">\n			<b>Created on:</b> [+form.field.createdon:date=`%a %B %d, %Y at %H:%M`+]<br />\n			<b>Created by:</b> [+form.field.createdby:userinfo=`username`:ifempty=`[+jot.guestname+]`+]<br />\n			<b>IP address:</b> [+form.field.secip+]<br />\n			<b>Published:</b> [+form.field.published:select=`0=No&1=Yes`+]<br />\n			[+form.field.publishedon:gt=`0`:then=`\n				<b>Published on:</b> [+form.field.publishedon:date=`%a %B %d, %Y at %H:%M`+]<br />\n				<b>Published by:</b> [+form.field.publishedby:userinfo=`username`:ifempty=` - `+]<br />\n			`+]\n			[+form.field.editedon:gt=`0`:then=`\n				<b>Edited on:</b> [+form.field.editedon:date=`%a %B %d, %Y at %H:%M`+]<br />\n				<b>Edited by:</b> [+form.field.editedby:userinfo=`username`:ifempty=` -`+]<br />\n			`+]\n		</div>\n	`:strip+]\n	\n	[+form.guest:is=`1`:then=`\n		<div class=\"form-group\">\n			<label for=\"name[+jot.id+]\">Name:</label>\n			<input tabindex=\"[+jot.seed:math=`?+1`+]\" name=\"name\" class=\"form-control\" type=\"text\" size=\"40\" value=\"[+form.field.custom.name:esc+]\" id=\"name[+jot.id+]\" />\n		</div>\n		<div class=\"form-group\">\n			<label for=\"email[+jot.id+]\">Email:</label>\n			<input tabindex=\"[+jot.seed:math=`?+2`+]\" name=\"email\" class=\"form-control\" type=\"text\" size=\"40\" value=\"[+form.field.custom.email:esc+]\" id=\"email[+jot.id+]\"/>\n		</div>\n	`:strip+]\n	<div class=\"form-group\">\n		<label for=\"title[+jot.id+]\">Subject:</label>\n		<input tabindex=\"[+jot.seed:math=`?+3`+]\" name=\"title\" class=\"form-control\" type=\"text\" size=\"40\" value=\"[+form.field.title:esc+]\" id=\"title[+jot.id+]\"/>\n	</div>\n	<div class=\"form-group\">\n		<label for=\"content[+jot.id+]\">Comment: *</label>\n		<textarea tabindex=\"[+jot.seed:math=`?+4`+]\" name=\"content\" class=\"form-control\" rows=\"8\" id=\"content[+jot.id+]\">[+form.field.content:esc+]</textarea>\n	</div>\n	\n[+jot.captcha:is=`1`:then=`\n	<div style=\"width:150px;margin-top: 5px;margin-bottom: 5px;\">\n		<a href=\"[+jot.link.current:esc+]\">\n			<img src=\"[(modx_manager_url)]includes/veriword.php?rand=[+jot.seed+]\" width=\"148\" height=\"60\" alt=\"If you have trouble reading the code, click on the code itself to generate a new random code.\" style=\"border: 1px solid #003399\" />\n		</a>\n	</div>\n	<div class=\"form-group\">\n		<label for=\"vericode[+jot.id+]\">Help prevent spam - enter security code above:</label>\n		<input type=\"text\" name=\"vericode\" style=\"width:150px;\" size=\"20\" id=\"vericode[+jot.id+]\" />\n	</div>\n`:strip+]\n\n	<input tabindex=\"[+jot.seed:math=`?+5`+]\" name=\"submit\" class=\"btn btn-primary\" type=\"submit\" value=\"[+form.edit:is=`1`:then=`Save Comment`:else=`Post Comment`+]\" />\n	[+form.edit:is=`1`:then=`\n		<input tabindex=\"[+jot.seed:math=`?+5`+]\" name=\"submit\" class=\"btn btn-default\" type=\"submit\" value=\"Cancel\" onclick=\"history.go(-1);return false;\" />\n	`+] \n	</fieldset>\n</form>','0','0','0','0');

INSERT INTO `{PREFIX}site_htmlsnippets` VALUES ('13','Comments','Comments (JotX) showing beneath a blog entry.','2','none','1','0','<div id=\"commentsAnchor\">\n[[ifsnippet? &name=`JotX`]]	\n[!JotX? &customfields=`name,email` &subscribe=`1` &pagination=`4` &badwords=`dotNet` &canmoderate=`Site Admins` &tplForm=`Comments_tplForm` &tplComments=`Comments_tplComments`!]\n</div>','0','1507723259','1509825745','0');

INSERT INTO `{PREFIX}site_htmlsnippets` VALUES ('14','ContactForm','eForm-template for showing contact-form','2','none','1','0','<form id=\"EmailForm\">\n	<input type=\"hidden\" name=\"formid\" value=\"ContactForm\">\n	<p>[+form.messages+]</p>\n	<div class=\"form-group [+name.classname+]\">\n		<label for=\"cfName\">Your name:</label>\n		<input type=\"text\" class=\"form-control\" name=\"name\" id=\"cfName\" value=\"[+name.value+]\" placeholder=\"Your Name\"/>\n		<div class=\"invalid-feedback\">[+name.error+]</div>\n	</div>\n	<div class=\"form-group [+email.classname+]\">\n		<label for=\"cfEmail\">Your Email Address:</label>\n		<input type=\"text\" class=\"form-control\" name=\"email\" id=\"cfEmail\" value=\"[+email.value+]\" placeholder=\"Email Address\"/>\n		<div class=\"invalid-feedback\">[+email.error+]</div>\n	</div>\n	\n	<div class=\"form-group [+subject.classname+]\">\n		<label for=\"cfRegarding\">Regarding:</label>\n		<select class=\"form-control\" name=\"subject\" id=\"cfRegarding\">\n			<option value=\"General Inquiries\" [+s.subject.General Inquiries+] >General Inquiries</option>\n			<option value=\"Press\" [+s.subject.Press+] >Press or Interview Request</option>\n			<option value=\"Partnering\" [+s.subject.Partnering+] >Partnering Opportunities</option>\n		</select>\n		<div class=\"invalid-feedback\">[+subject.error+]</div>\n	</div>\n	\n	<div class=\"form-group [+message.classname+]\">\n		<label for=\"cfMessage\">Message:</label>\n		<textarea name=\"message\" id=\"cfMessage\" class=\"form-control\">[+message.value+]</textarea>\n		<div class=\"invalid-feedback\">[+message.error+]</div>\n	</div>\n	\n	<div class=\"form-group\">\n		<input type=\"submit\" name=\"contact\" id=\"submit\" class=\"btn btn-primary\" value=\"Send This Message\" />\n	</div>\n\n</form>','0','1507723259','1507816800','0');

INSERT INTO `{PREFIX}site_htmlsnippets` VALUES ('15','ContactFormReport','eForm-template for sending form-data by mail','0','none','1','0','<p>This is a response sent by <b>[+name+]</b> using the feedback form on the website. The details of the message follow below:</p>\n\n\n<p>Name: [+name+]</p>\n<p>Email: [+email+]</p>\n<p>Regarding: [+subject+]</p>\n<p>comments:<br />[+message+]</p>\n\n<p>You can use this link to reply: <a href=\"mailto:[+email+]?subject=RE: [+subject+]\">[+email+]</a></p>\n','0','1507723259','0','0');

#
# Dumping data for table `site_tmplvar_contentvalues`
#

REPLACE INTO `{PREFIX}site_tmplvar_contentvalues` VALUES ('1','3','9','demo miniblog howto tutorial posting');

REPLACE INTO `{PREFIX}site_tmplvar_contentvalues` VALUES ('2','3','18','demo older posting');

REPLACE INTO `{PREFIX}site_tmplvar_contentvalues` VALUES ('3','8','9','assets/images/evo-logo.png');

#
# Table structure for table `site_snippets`
#

REPLACE INTO `{PREFIX}site_snippets` VALUES ('24','ifsnippet','','0','1','0','\nif (!isset($modx->snippetCache[$name])) {\n	return \'<p class=\"bg-danger\">For work \'.$name.\' in demo site you need install <b>\'.$name.\'</b> from <a href=\"\'.MODX_MANAGER_URL.\'#?a=112&id=2\">Extras</a> module</p>\';\n}','0','{}',' ','1509819147','1509826185','0');

REPLACE INTO `{PREFIX}site_snippets` VALUES ('23','prepareBlog','','0','1','0','\nif ($data[\'image\'] != \'\'){\n	$data[\'blog-image\'] = \'<img src=\"\'.$modx->runSnippet(\'phpthumb\', array(\'input\'=>$data[\'image\'], \'options\'=>\'w=600,h=280,zc=1\')).\'\" alt=\"\'.$data[\'pagetitle\'].\'\">\';\n}else{\n	$data[\'blog-image\'] = \'\';\n}\nreturn $data;','0','{}',' ','1507723822','1509819933','0');

#
# Dumping data for table `site_templates`
#

REPLACE INTO `{PREFIX}site_templates` VALUES ('4','EVO startup - Bootstrap','','<strong>1.0</strong> Sample template in Bootstrap','0','1','','0','<!DOCTYPE html>\n<html lang=\"[(lang_code)]\">\n	<head>\n		<meta http-equiv=\"Content-Type\" content=\"text/html; charset=[(modx_charset)]\" /> \n		<title>[*titl*]</title>\n		[*noIndex*]\n		<meta name=\"keywords\" content=\"[*keyw*]\" />\n		<meta name=\"description\" content=\"[*desc*]\" />\n		<base href=\"[(site_url)]\"/>\n\n		<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n		<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">\n\n		<link href=\"[(site_url)][[if? &is=[(site_start)]:!=:[*id*] &then=`[~[*id*]~]`]]\" rel=\"canonical\">\n		<link href=\"https://fonts.googleapis.com/css?family=Open+Sans:400,700\" rel=\"stylesheet\" type=\"text/css\">	\n		<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css\">\n		<link rel=\"stylesheet\" href=\"https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css\">\n\n		<style> \n			html, body{background:#eee; font-family:\'Open Sans\',sans-serif; line-height:1.8; font-size:14px;}\n			a:focus{outline:none; outline-offset:0;}\n			h1{margin-top:15px;}\n\n			.logo{float:left;}\n			.logo img{ margin-top:10px; display:block; max-width:256px;}\n			\n			.dropdown-menu{border-radius:0; border:0;}\n			.dropdown-menu > li > a{padding-top:5px; padding-bottom:5px;}\n\n			.navbar-collapse.collapse.in{border-bottom:10px solid #eee;}\n			.navbar{min-height:0; background:#fff; margin-bottom:0;}\n			.navbar.nav{margin-left:0;}\n			.navbar.nav ul{padding-left:0;}\n			.navbar-nav{margin:0;}\n			.navbar-toggle{background:#fff; border:2px solid #eee; border-radius:0; position:fixed; z-index:99; right:0; top:7px; padding:12px 10px; margin-right:10px;}\n			.navbar .navbar-toggle .icon-bar{background-color:#333;}\n\n			.nav li a{text-transform:uppercase; color:#333; font-weight:500; font-size:110%;}\n			.nav li li a{text-transform:none; font-weight:normal; font-size:100%;}\n\n			.navbar{border:none; border-radius:0;}\n			#navbar{padding:0;}\n			ul.nav > li > a:hover{background-color:#f5f5f5;}\n\n			.affix{top:0px; width:100%; z-index:1000; background-color:#eee;}\n			.affix + .affspacer{display:block; height:50px;}\n\n			.box-shadow{-webkit-box-shadow:0 6px 12px rgba(0,0,0,.175); box-shadow:0 6px 12px rgba(0,0,0,.175);}\n\n			.container {max-width:970px; margin:0 12px;}\n			.top .col-sm-12{padding-left:0; padding-right:0;}\n\n			#ajaxSearch_input,\n			#username,\n			#password{width:100%!important;}\n			#forgotpsswd{clear:both;}\n			input.button[type=\"submit\"]{display:block;}\n			label.checkbox{display:inline-block; margin-left:10px;}\n			label, legend{font-weight:400;}\n			#ajaxSearch_form { position:relative; }\n			#searchClose { display:none !important; }\n			#indicator { position:absolute; top:9px; right:12px; z-index:10; opacity:.75; }\n\n			h2{font-size:22px;}\n			.bread{padding:1em 0 0 0;}\n			.mem{color:#aaa; text-align:center; padding:1em 0 2em;}\n\n			section.main .container{background-color:#fff; padding-bottom:20px;}\n			footer.footer .container{background-color:#000; color:#fff; line-height:40px;}\n\n			section.main .content ul{list-style:none; margin:0 0 1em 0; padding:0;}\n			section.main .content ul li{padding-left:1em;}\n			section.main .content ul li:before{content:\'\\2022\'; position:absolute; line-height:1.85em; margin-left:-1em;}\n\n			.breadcrumb {padding: 0px 0px;margin-bottom: 0px;list-style: none;background-color:#fff;border-radius: 0px;}	\n\n			.footer{text-align:center;}\n			.footer .text-right{text-align:center;}\n\n			/* JOT */\n			.jot-comment{padding:5px 10px;}\n			.jot-row-author{background-color:#dddddd;}\n			.jot-row-alt{background-color:#f9f9f9;}\n			.jot-row{background-color:#eeeeee;}\n			.jot-row-up{border:1px solid #333!important;}\n			.jot-row-up.panel-primary > .panel-heading{background-color:#333!important; border-color:#333!important;}\n			.jot-extra{font-size:75%;}\n			.jot-poster{font-size:inherit!important;}\n\n			.dl_summaryPost img{max-width:100%; height:auto; margin:10px 0 5px; display:block;}\n			.dl_summaryPost{padding-top:10px; padding-bottom:15px; border-bottom:1px solid #eee;}\n\n			.pagination b, .pagination a {padding: 5px;}	\n\n			div.errors{ color:#F00; }\n			#EmailForm .invalidValue{ background: #FFDFDF; border:1px solid #F00; }\n			#EmailForm .requiredValue{ background: #FFFFDF; border:1px solid #F00; }	\n\n			/* Larger than mobile */\n			@media (min-width:320px) {\n\n			}\n\n			/* Larger than phablet */\n			@media (min-width:480px) {\n\n			}\n\n			/* Larger than tablet */\n			@media (min-width:768px) {\n\n				.container{margin:0 auto;}\n				.logo{padding-left:15px;}\n				.logo img{ margin-top:10px; display:block; max-width:256px;}\n\n				.navbar{background:transparent;}\n				.navbar.affix{background:#eee;}\n				.navbar-collapse.collapse.in{border-bottom:0;}\n\n				.footer{text-align:left;}\n				.footer .text-right{text-align:right;}\n\n				.col-lg-1, .col-lg-10, .col-lg-11, .col-lg-12, .col-lg-2, .col-lg-3, .col-lg-4, .col-lg-5, .col-lg-6, .col-lg-7, .col-lg-8, .col-lg-9, .col-md-1, .col-md-10, .col-md-11, .col-md-12, .col-md-2, .col-md-3, .col-md-4, .col-md-5, .col-md-6, .col-md-7, .col-md-8, .col-md-9, .col-sm-1, .col-sm-10, .col-sm-11, .col-sm-12, .col-sm-2, .col-sm-3, .col-sm-4, .col-sm-5, .col-sm-6, .col-sm-7, .col-sm-8, .col-sm-9, .col-xs-1, .col-xs-10, .col-xs-11, .col-xs-12, .col-xs-2, .col-xs-3, .col-xs-4, .col-xs-5, .col-xs-6, .col-xs-7, .col-xs-8, .col-xs-9 {padding-left:35px; padding-right:35px;}\n\n			}\n		</style>\n\n		<script src=\"https://code.jquery.com/jquery-2.2.3.min.js\"></script>\n	</head>\n	<body>\n		<section class=\"top\">\n			<div class=\"container\">\n				<div class=\"row\">\n					<div class=\"col-sm-12\" itemscope itemtype=\"http://schema.org/Organization\">\n\n						<a class=\"logo\" href=\"[~[(site_start)]~]\" title=\"[(site_name)]\" itemprop=\"url\">\n							<img src=\"[(site_url)]manager/media/style/default/images/misc/login-logo.png\" itemprop=\"logo\" alt=\"[(site_name)]\" />\n						</a>\n\n						<div class=\"clearfix\"></div>\n\n						<nav class=\"navbar\" role=\"navigation\" data-spy=\"affix\" data-offset-top=\"100\">\n\n							<div class=\"navbar-header\">\n								<button type=\"button\" class=\"navbar-toggle collapsed\" data-toggle=\"collapse\" data-target=\"#navbar\" aria-expanded=\"false\" aria-controls=\"navbar\">\n									<span class=\"sr-only\">Toggle navigation</span>\n									<span class=\"icon-bar\"></span>\n									<span class=\"icon-bar\"></span>\n									<span class=\"icon-bar\"></span>\n								</button>\n							</div>\n							<div id=\"navbar\" class=\"navbar-collapse collapse\">\n\n								[[DLMenu? \n								&parents=`0` \n								&maxDepth=`2` \n								&outerClass=`nav navbar-nav`\n								&hereClass=`active`\n								&innerTpl=`@CODE:<ul class=\"dropdown-menu\">[+wrap+]</ul>`\n								&parentRowTpl=`@CODE:<li class=\"dropdown\"><a href=\"#\" class=\"dropdown-toggle\" data-toggle=\"dropdown\" title=\"[+title+]\">[+title+] <b class=\"caret\"></b></a>[+wrap+]</li>`\n								]]\n\n							</div>\n						</nav>\n						<div class=\"affspacer\"></div>\n\n					</div>\n				</div>\n			</div>\n		</section>\n\n		<section class=\"main\">\n			<div class=\"container\">\n\n				<div class=\"row\">\n					<div class=\"col-sm-12\">\n						<div class=\"bread\">\n							[[if? &is=`[*id*]:!=:[(site_start)]` &then=`\n								[[DLCrumbs? &showCurrent=`1`]]\n							`]]\n						</div>\n					</div>\n				</div>\n\n				<div class=\"row content\">\n\n					<div class=\"col-sm-8\">\n						<h1>[*#longtitle*]</h1>\n						[*#content*]\n						\n						[[if? &is=`[*parent*]:=:2` &then=`@TPL:Comments`]]\n					</div>\n\n					<aside class=\"col-sm-4\">\n						<div class=\"search\">\n							<h2>Search</h2>\n							[[ifsnippet? &name=`AjaxSearch`]]\n							[!AjaxSearch? \n							&ajaxSearch=`1` \n							&addJscript=`0` \n							&showIntro=`0` \n							&ajaxMax=`5` \n							&extract=`1`\n							&jscript=`jquery`\n							&tplInput=`AjaxSearch_tplInput`\n							&tplAjaxGrpResult=`AjaxSearch_tplAjaxGrpResult`\n							&tplAjaxResults=`AjaxSearch_tplAjaxResults`\n							&tplAjaxResult=`AjaxSearch_tplAjaxResult`\n							&showResults=`1`\n							&liveSearch=`0`\n							!]\n						</div>\n\n						<h2>News:</h2>\n						[[DocLister? \n						&parents=`2` \n						&display=`2`\n						&total=`20` \n						&tpl=`@CODE:<strong><a href=\"[+url+]\" title=\"[+e.title+]\">[+e.title+]</a></strong><br />\n						[+longtitle+]<br /><br />`\n						]]\n\n						<div>\n							<h2>Most Recent:</h2>\n\n							<ul>\n								[[DocLister? \n								&showInMenuOnly=`1` \n								&parents=`0`\n								&display=`5`\n								&tpl=`@CODE:<li><a href=\"[+url+]\" title=\"[+pagetitle+]\">[+pagetitle+]</a> <span class=\"date\">[+date+]</span></li>`\n								]]\n							</ul>\n\n						</div>\n						\n					</aside>\n				</div>\n			</div>\n\n		</section>\n\n		<footer class=\"footer\">\n			<div class=\"container\">\n				<div class=\"row\">\n					<div class=\"col-sm-6\">\n						<a href=\"https://evo.im\" title=\"Learn more about EVO\">EVO</a> Starter-Template &copy;2006-[[$_SERVER[\'REQUEST_TIME\']:dateFormat=`Y` ]]\n					</div>\n					<div class=\"col-sm-6 text-right\">\n						Built with <a href=\"http://www.getbootstrap.com\" target=\"_blank\">Bootstrap</a> framework.\n					</div>\n				</div>\n			</div>\n		</footer>\n\n		<div class=\"container mem\">\n			<small>Memory: [^m^], MySQL: [^qt^], [^q^] request(s), PHP: [^p^], total: [^t^], document retrieved from [^s^]. </small>\n		</div>\n\n		<!-- Scripts\n–––––––––––––––––––––––––––––––––––––––––––––––––– -->	\n\n		<script src=\"https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js\"></script>\n		<!--[if lt IE 9]>\n<script src=\"https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js\"></script>\n<script src=\"https://oss.maxcdn.com/respond/1.4.2/respond.min.js\"></script>\n<![endif]-->\n\n	</body>\n</html>','0','1','0','1509819347');

#
# Dumping data for table `evo_site_plugins`
#

REPLACE INTO `{PREFIX}site_plugins` VALUES ('12','evoAjax','','0','1','0','switch($_GET[\'q\']){     \n	case \'feedbackajaxform\':\n		echo $modx->runSnippet(\'FormLister\', array(\n			\'formid\' => \'ContactForm\',\n			\'to\' => $modx->config[\'emailsender\'],\n			\'parseMailerParams\'=> \'1\',\n			\'replyTo\'=> \'@CODE:[+user.email.value+]\',\n			\'subjectTpl\' => \'@CODE:[+subject.value+], from: \' . $modx->config[\'site_name\'] ,\n			\'ccSender\'=>\'1\',\n			\'errorClass\'=> \' has-error\',\n			\'requiredClass\'=> \' has-warning\',\n			\'rules\'=> \'{\n               	\"name\":{\n               		\"required\":\"Enter your Name\"\n               	},\n               	\"email\":{\n               		\"required\":\"Enter email\",\n               		\"email\":\"Incorrect email\"\n               	},\n               	\"message\":{\n                	\"required\":\"Enter message\"\n                }\n            }\',\n			\'formControls\'=>\'subject\',\n			\'messagesTpl\' => \'@CODE:<div class=\"form-messages alert alert-danger\">[+required+]<br>[+errors+]</div>\',\n            \'errorTpl\'=>\'@CODE: [+message+]\',\n            \'successTpl\'=> \'@CODE: \n             	<div class=\"alert alert-success mt-3\">\n                 	<h3>Thanks!</h3>\n                 	<p>your message has been sent.</p>\n             	</div>\',\n            \'formTpl\' => \'ContactForm\', \n			\'reportTpl\'=>\'ContactFormReport\',\n            \'ccSenderTpl\'=>\'ContactFormReport\',	\n			));\n			die();\n        break;\n}\n','0','{}','0',' ','1507815395','1507816656');

REPLACE INTO `{PREFIX}site_plugin_events` VALUES ('12','1000','1');

#
# Dumping data for table `system_settings`
#


REPLACE INTO `{PREFIX}system_settings` VALUES('error_page', '7');

REPLACE INTO `{PREFIX}system_settings` VALUES('unauthorized_page', '4');


#
# Dumping data for table `web_groups`
#


REPLACE INTO `{PREFIX}web_groups` VALUES ('1','1','1');


#
# Dumping data for table `web_user_attributes`
#


REPLACE INTO `{PREFIX}web_user_attributes` VALUES ('1','1','Site Admin','0','you@example.com','','','0','0','0','25','1129049624','1129063123','0','f426f3209310abfddf2ee00e929774b4','0','0','','','','','','','','', UNIX_TIMESTAMP(), 0);


#
# Dumping data for table `web_users`
#


REPLACE INTO `{PREFIX}web_users` VALUES ('1','siteadmin','5f4dcc3b5aa765d61d8327deb882cf99','');


#
# Dumping data for table `webgroup_access`
#


REPLACE INTO `{PREFIX}webgroup_access` VALUES ('1','1','1');


#
# Dumping data for table `webgroup_names`
#


REPLACE INTO `{PREFIX}webgroup_names` VALUES ('1','Site Admins');


REPLACE INTO `{PREFIX}webgroup_names` VALUES ('2','Registered Users');



#
# Table structure for table `jot_content`
#


CREATE TABLE IF NOT EXISTS `{PREFIX}jot_content` (`id` int(10) NOT NULL auto_increment, `title` varchar(255) default NULL, `tagid` varchar(50) default NULL, `published` int(1) NOT NULL default '0', `uparent` int(10) NOT NULL default '0', `parent` int(10) NOT NULL default '0', `flags` varchar(25) default NULL, `secip` varchar(32) default NULL, `sechash` varchar(32) default NULL, `content` mediumtext, `customfields` mediumtext, `mode` int(1) NOT NULL default '1', `createdby` int(10) NOT NULL default '0', `createdon` int(20) NOT NULL default '0', `editedby` int(10) NOT NULL default '0', `editedon` int(20) NOT NULL default '0', `deleted` int(1) NOT NULL default '0', `deletedon` int(20) NOT NULL default '0', `deletedby` int(10) NOT NULL default '0', `publishedon` int(20) NOT NULL default '0', `publishedby` int(10) NOT NULL default '0', PRIMARY KEY  (`id`), KEY `parent` (`parent`), KEY `secip` (`secip`), KEY `tagidx` (`tagid`), KEY `uparent` (`uparent`)) ENGINE=MyISAM {TABLEENCODING};


#
# Dumping data for table `jot_content`
#


REPLACE INTO `{PREFIX}jot_content` VALUES ('9','The first comment','','1','9','0','','87.211.130.14','edb75dab198ff302efbf2f60e548c0b3','This is the first comment.','<custom><name></name><email></email></custom>','0','0','1160420310','0','0','0','0','0','0','0');


REPLACE INTO `{PREFIX}jot_content` VALUES ('10','Second comment','','1','9','0','','87.211.130.14','edb75dab198ff302efbf2f60e548c0b3','This is the second comment and uses an alternate row color. I also supplied a name, but i\'m not logged in.','<custom><name>Armand</name><email></email></custom>','0','0','1160420453','0','0','0','0','0','0','0');


REPLACE INTO `{PREFIX}jot_content` VALUES ('11','No abuse','','1','9','0','','87.211.130.14','edb75dab198ff302efbf2f60e548c0b3','Notice that I can\'t abuse <b>html</b>, ,  or [+placeholder+] tags.\r\n\r\nA new line also doesn\'t come unnoticed.','<custom><name>Armand</name><email></email></custom>','0','0','1160420681','0','0','0','0','0','0','0');


REPLACE INTO `{PREFIX}jot_content` VALUES ('12','Posting when logged in','','1','9','0','','87.211.130.14','58fade927c1df50ba6131f2b0e53c120','When you are logged in your own posts have a special color so you can easily spot them from the comment view. \r\n\r\nThe form also does not display any guest fields when logged in.','<custom></custom>','0','-1','1160421310','0','0','0','0','0','0','0');


REPLACE INTO `{PREFIX}jot_content` VALUES ('13','Managers','','1','9','0','','87.211.130.14','91e230cf219e3ade10f32d6a41d0bd4d','Comments posted when only logged in as a manager user will use your manager name.\r\n\r\nModerators options are always shown when you are logged in as manager user.','<custom></custom>','0','1','1160421487','0','0','0','0','0','0','0');


REPLACE INTO `{PREFIX}jot_content` VALUES ('14','Moderation','','1','9','0','','87.211.130.14','58fade927c1df50ba6131f2b0e53c120','In this setup the Site Admins group is defined as being the moderator for this particular comment view. These users will have extra moderation options \r\n\r\nManager users, Moderators or Trusted users can post bad words like: dotNet.','<custom></custom>','0','-1','1160422081','0','0','0','0','0','0','0');


REPLACE INTO `{PREFIX}jot_content` VALUES ('15','I\'m untrusted','','0','9','0','','87.211.130.14','edb75dab198ff302efbf2f60e548c0b3','Untrusted users however can NOT post bad words like: dotNet. When they do the posts will be unpublished.','<custom><name></name><email></email></custom>','0','0','1160422167','0','0','0','0','0','0','0');


#
# Table structure for table `jot_subscriptions`
#


CREATE TABLE IF NOT EXISTS `{PREFIX}jot_subscriptions` (`id` mediumint(10) NOT NULL auto_increment, `uparent` mediumint(10) NOT NULL default '0', `tagid` varchar(50) NOT NULL default '', `userid` mediumint(10) NOT NULL default '0', PRIMARY KEY  (`id`), KEY `uparent` (`uparent`), KEY `tagid` (`tagid`), KEY `userid` (`userid`)) ENGINE=MyISAM {TABLEENCODING};

