## Восстановление паролей
### Вариант 1
Пароль генерируется автоматически и отправляется в письме.
```
[!FormLister?
&controller=`Reminder`
&formid=`remind`
&rules=`{
"email":{
	"required":"Обязательно введите email",
	"email":"Введите email правильно"
}
}`
&formTpl=`@CODE:
<div class="row">
	<div class="col-md-6 col-md-offset-3">
		<div class="well">
			<form method="post">
				<input type="hidden" name="formid" value="remind">
				<div class="form-group[+email.errorClass+][+email.requiredClass+]">
					<label for="email">* Email</label>
						<input type="text" class="form-control" id="email" placeholder="Email" name="email" value="[+email.value+]">
						[+email.error+]
				</div>
				[+form.messages+]
				<div class="form-group">
					<button type="submit" class="btn btn-primary"><i class="glyphicon glyphicon-ok-sign"></i> Далее</button>
				</div>
			</form>
		</div>
	</div>
</div>`
&messagesOuterTpl=`@CODE:<div class="alert alert-danger" role="alert">[+messages+]</div>`
&successTpl=`@CODE:<div class="text-center">На указанный вами при регистрации email отправлено письмо с дальнейшими инструкциями!</div>`
&subject=`Восстановление пароля`
&resetTo=`38`
&reportTpl=`@CODE:<p>Для восстановления пароля перейдите по ссылке <a href="[+reset.url+]">[+reset.url+]</a></p>`
&resetReportTpl=`@CODE:<p>Здравствуйте, [+fullname.value+]!</p><p>Ваш новый пароль: [+newpassword+]</p>`
&resetSuccessTpl=`@CODE:<div class="text-center">На указанный вами при регистрации email отправлено письмо с новым паролем!</div>`
&errorTpl=`@CODE:<span class="help-block">[+message+]</span>`
&errorClass=` has-error`
&requiredClass=` has-warning`
!]
```

### Вариант 2
Пользователь вводит новый пароль.
```
[!FormLister?
&controller=`Reminder`
&formid=`remind`
&rules=`{
"email":{
	"required":"Обязательно введите email",
	"email":"Введите email правильно"
}
}`
&resetRules=`{
"password":{
	"required":"Обязательно введите пароль",
	"minLength":{
		"params":6,
		"message":"В пароле должно быть больше 6 символов"
	}
},
"repeatPassword":{
	"required":"Повторите пароль",
	"equals":{
		"message":"Пароли не совпадают"
	}
}
}`
&formTpl=`@CODE:
<div class="row">
	<div class="col-md-6 col-md-offset-3">
		<div class="well">
			<form method="post">
				<input type="hidden" name="formid" value="remind">
				<div class="form-group[+email.errorClass+][+email.requiredClass+]">
					<label for="email">* Email</label>
						<input type="text" class="form-control" id="email" placeholder="Email" name="email" value="[+email.value+]">
						[+email.error+]
				</div>
				[+form.messages+]
				<div class="form-group">
					<button type="submit" class="btn btn-primary"><i class="glyphicon glyphicon-ok-sign"></i> Далее</button>
				</div>
			</form>
		</div>
	</div>
</div>`
&resetTpl=`@CODE:
<div class="row">
	<div class="col-md-6 col-md-offset-3">
		<div class="well">
			<form method="post">
				<input type="hidden" name="formid" value="remind">
				<input type="hidden" name="hash" value="[+user.hash+]">
				<input type="hidden" name="id" value="[+user.id+]">
				<div class="form-group[+password.errorClass+][+password.requiredClass+]">
					<label for="password">* Новый пароль</label>
						<input type="password" class="form-control" id="password" placeholder="Новый пароль" name="password" value="">
						[+password.error+]
				</div>
				<div class="form-group[+repeatPassword.errorClass+][+repeatPassword.requiredClass+]">
					<label for="password">* Повторите пароль</label>
						<input type="password" class="form-control" id="password" placeholder="Повторите пароль" name="repeatPassword" value="">
						[+repeatPassword.error+]
				</div>
				[+form.messages+]
				<div class="form-group">
					<button type="submit" class="btn btn-primary"><i class="glyphicon glyphicon-floppy-disk"></i> Сохранить</button>
				</div>
			</form>
		</div>
	</div>
</div>
`
&uidName=`uid`
&messagesOuterTpl=`@CODE:<div class="alert alert-danger" role="alert">[+messages+]</div>`
&successTpl=`@CODE:<div class="text-center">На указанный вами при регистрации email отправлено письмо с дальнейшими инструкциями!</div>`
&subject=`Восстановление пароля`
&reportTpl=`@CODE:<p>Для восстановления пароля перейдите по ссылке <a href="[+reset.url+]">[+reset.url+]</a></p>`
&resetReportTpl=`@CODE:<p>Здравствуйте, [+fullname.value+]!</p><p>Ваш новый пароль: [+newpassword+]</p>`
&resetSuccessTpl=`@CODE:Готово!`
&resetTo=`12`
&errorTpl=`@CODE:<span class="help-block">[+message+]</span>`
&errorClass=` has-error`
&requiredClass=` has-warning`
!]
```
