## Форма с элементами управления
```
[!FormLister?
&formid=`advanced`
&rules=`{
"name":{
	"required":"Обязательно введите имя"
},
"email":{
	"required":"Обязательно введите email"
},
"phone":{
	"required":"Обязательно введите номер телефона",
	"phone":"Введите номер правильно"
},
"message":{
	"required":"Обращение не может быть пустым",
	"minLength":{
		"params":100,
		"message":"Должно быть не менее 100 символов"
	}
},
"agree":{
	"required":"Вы не можете отправить обращение, если не согласны с правилами"
},
"products":{
	"minCount":{
		"params": 2,
		"message": "Выберите минимум 2 продукта"
	}
}
}`
&defaults=`{
"topic":"Жалоба"
}`
&formControls=`topic,agree,department,products`
&formTpl=`@CODE:
<div class="row">
	<div class="col-md-8 col-md-offset-2">
		<div class="well">
			<form method="post">
				<input type="hidden" name="formid" value="advanced">
				<div class="form-group[+name.errorClass+][+name.requiredClass+]">
					<label for="name">* Имя</label>
						<input type="text" class="form-control" id="name" placeholder="Имя" name="name" value="[+name.value+]">
						[+name.error+]
				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group[+email.errorClass+][+email.requiredClass+]">
							<label for="email">* Email</label>
								<input type="text" class="form-control" id="email" placeholder="Email" name="email" value="[+email.value+]">
								[+email.error+]
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group[+phone.errorClass+][+phone.requiredClass+]">
							<label for="phone">* Телефон</label>
								<input type="text" class="form-control" id="phone" placeholder="+375 29 123 45 67" name="phone" value="[+phone.value+]">
								[+phone.error+]
						</div>
					</div>
				</div>
				<div class="form-group">
					<label for="department">Обслуживающий вас офис</label>
					<select name="department" class="form-control">
					  <option value="1" [+s.department.1+]>Головной офис</option>
					  <option value="2" [+s.department.2+]>Офис в Западном районе</option>
					  <option value="3" [+s.department.3+]>Офис в пригороде</option>
					</select>
				</div>
				<div>
					<label for="topic">Тема обращения</label>
				</div>
				<div class="form-group">
					<label class="radio-inline">
						<input type="radio" name="topic" value="Жалоба" [+c.topic.Жалоба+]> Жалоба
					</label>
					<label class="radio-inline">
						<input type="radio" name="topic" value="Предложение" [+c.topic.Предложение+]> Предложение
					</label>
				</div>
				<div class="form-group[+products.errorClass+]">
					<label for="products">Какими продуктами вы пользуетесь</label>
					<div class="checkbox">
						<label>
							<input type="checkbox" name="products[]" value="1" [+c.products.1+]>
							Продукт 1
						</label>
					</div>
					<div class="checkbox">
						<label>
							<input type="checkbox" name="products[]" value="2" [+c.products.2+]>
							Продукт 2
					  </label>
					</div>
					<div class="checkbox">
						<label>
							<input type="checkbox" name="products[]" value="3" [+c.products.3+]>
							Продукт 3
					  </label>
					</div>
					[+products.error+]
				</div>
				<div class="form-group[+message.errorClass+][+message.requiredClass+]">
					<label for="message">* Текст обращения</label>
						<textarea class="form-control" id="message" placeholder="Текст обращения" name="message" rows="10">[+message.value+]</textarea>
						[+message.error+]
				</div>
				<div class="checkbox[+agree.requiredClass+]">
				  <label>
					<input type="checkbox" name="agree" value="Да" [+c.agree.Да+]>
					Я согласен с правилами обработки обращений
				  </label>
					[+agree.error+]
				</div>
				[+form.messages+]
				<div class="form-group">
					<button type="submit" class="btn btn-primary"><i class="glyphicon glyphicon-envelope"></i> Отправить</button>
				</div>
			</form>
		</div>
	</div>
</div>`
&to=`test@test.com`
&subjectTpl=`@CODE: [+topic.value+] в [+department.value+]`
&reportTpl=`@CODE:
<p>Имя: [+name.value+]</p>
<p>Телефон: [+phone.value+]</p>
<p>Email: <a href="mailto:[+email.value+]">[+email.value+]</a></p>
<p>Продукты: [+products.value+]</p>
<p>Сообщение: [+message:strip_tags:nl2br+]</p>
`
&errorClass=` has-error`
&requiredClass=` has-warning`
&subject=`Новое сообщение`
&messagesOuterTpl=`@CODE:<div class="alert alert-danger" role="alert">[+messages+]</div>`
&errorTpl=`@CODE:<span class="help-block">[+message+]</span>`
!]
```
