## Два набора полей
В зависимости от значения поля type используются разные правила валидации и шаблоны письма.
 
### Вызов FormLister
```
[!FormLister?
&formid=`basic`
&rules=`{
"name":{
	"required":"Обязательно введите имя"
},
"email":{
	"required":"Обязательно введите email",
	"email":"Введите email правильно"
},
"phone":{
	"required":"Обязательно введите номер телефона",
	"phone":"Введите номер правильно"
}
}`
&entRules=`{
"entname":{
	"required":"Обязательно введите имя"
},
"entemail":{
	"required":"Обязательно введите email",
	"email":"Введите email правильно"
},
"entphone":{
	"required":"Обязательно введите номер телефона",
	"phone":"Введите номер правильно"
},
"entaddress":{
	"required":"Обязательно введите адрес"
}
}`
&formControls=`type`
&defaults=`{"type":"Физическое лицо"}`
&formTpl=`@CODE:
<div class="row">
	<div class="col-md-8 col-md-offset-2">
		<div class="well">
			<form method="post">
				<input type="hidden" name="formid" value="basic">
				<div class="form-group">
					<label class="radio-inline">
						<input type="radio" name="type" value="Физическое лицо" [+c.type.Физическое лицо+]> Физическое лицо
					</label>
					<label class="radio-inline">
						<input type="radio" name="type" value="Юридическое лицо" [+c.type.Юридическое лицо+]> Юридическое лицо
					</label>
				</div>
				<h3>Заполняется только физлицами</h3>
				<div class="form-group[+name.errorClass+][+name.requiredClass+]">
					<label for="name">* Имя</label>

						<input type="text" class="form-control" id="name" placeholder="Имя" name="name" value="[+name.value+]">
						[+name.error+]

				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group[+email.errorClass+][+email.requiredClass+]">
							<label for="email">* Email</label>

								<input type="text" class="form-control" id="email" placeholder="Email" name="email" value="[+email.value+]">
								[+email.error+]

						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group[+phone.errorClass+][+phone.requiredClass+]">
							<label for="phone">* Телефон</label>

								<input type="text" class="form-control" id="phone" placeholder="+375 29 123 45 67" name="phone" value="[+phone.value+]">
								[+phone.error+]

						</div>
					</div>
				</div>
				<h3>Заполняется только юрлицами</h3>
				<div class="form-group[+entname.errorClass+][+entname.requiredClass+]">
					<label for="name">* Название предприятия</label>
						<input type="text" class="form-control" id="entname" placeholder="Название предприятия" name="entname" value="[+entname.value+]">
						[+entname.error+]

				</div>
				<div class="row">
					<div class="col-md-6">
						<div class="form-group[+entemail.errorClass+][+entemail.requiredClass+]">
							<label for="entemail">* Email</label>
								<input type="text" class="form-control" id="entemail" placeholder="Email" name="entemail" value="[+entemail.value+]">
								[+entemail.error+]
						</div>
					</div>
					<div class="col-md-6">
						<div class="form-group[+entphone.errorClass+][+entphone.requiredClass+]">
							<label for="phone">* Телефон</label>
								<input type="text" class="form-control" id="entphone" placeholder="+375 29 123 45 67" name="entphone" value="[+entphone.value+]">
								[+entphone.error+]
						</div>
					</div>
				</div>
				<div class="form-group[+entaddress.errorClass+][+entaddress.requiredClass+]">
					<label for="name">* Юридический адрес</label>
						<input type="text" class="form-control" id="entaddress" placeholder="Юридический адрес" name="entaddress" value="[+entaddress.value+]">
						[+entaddress.error+]

				</div>
				[+form.messages+]
				<div class="form-group">
						<button type="submit" class="btn btn-primary"><i class="glyphicon glyphicon-envelope"></i> Отправить</button>
				</div>
			</form>
		</div>
	</div>
</div>`
&to=`test@test.com`
&subjectTpl=`@CODE:[+type.value+]`
&reportTpl=`@CODE:
<p>Имя: [+name.value+]</p>
<p>Телефон: [+phone.value+]</p>
<p>Email: <a href="mailto:[+email.value+]">[+email.value+]</a></p>
`
&reportEntTpl=`@CODE:
<p>Название предприятия: [+entname.value+]</p>
<p>Телефон: [+entphone.value+]</p>
<p>Email: <a href="mailto:[+entemail.value+]">[+entemail.value+]</a></p>
<p>Юридический адрес: [+entaddress.value+]</p>
`
&prepare=`typeSelector`
&errorClass=` has-error`
&requiredClass=` has-warning`
&messagesOuterTpl=`@CODE:<div class="alert alert-danger" role="alert">[+messages+]</div>`
&errorTpl=`@CODE:<span class="help-block">[+message+]</span>`
!]
```
### Prepare-сниппет typeSelector
```
if ($FormLister->getField('type') == 'Юридическое лицо') {
	$FormLister->config->setConfig(array(
		'rules'=>$FormLister->getCFGDef('entRules'),
		'reportTpl'=>$FormLister->getCFGDef('reportEntTpl')
	));
} else {
	$FormLister->setField('type','Физическое лицо');
}
```
