## Восстановление паролей пользователями

Контроллер Reminder позволяет web-пользователям восстанавливать забытые пароли. Расширяет контроллер Form.

Восстановление паролей происходит по следующей схеме:

- пользователь вводит в форме свой идентификатор (им может быть имя пользователя или email);
- пользователь получает письмо, в котором содержится ссылка для восстановления;
- при переходе по ссылке пользователь получает возможность ввести новый пароль либо пароль будет сгенерирован автоматически;
- пользователю отправляется письмо с новым паролем и показыается сообщение (в сообщении можно также вывести новый пароль).

Параметр to перезаписывается значением email пользователя. Обязательно должен быть задан параметр resetTo.

## Параметры
### model
Класс для работы с пользователями.

Возможные значения - имя класса.

Значение по умолчанию - \modUsers

### modelPath
Путь к файлу класса для работы с пользователями.

Возможные значения - относительный путь к файлу.

Значение по умолчанию - assets/lib/MODxAPI/modUsers.php

### hashField
Имя поля для хранения хэша данных пользователя.

Значение по умолчанию - hash.

### userField
Имя поля для хранения идентификатора пользователя (имя пользователя или email).

Значение по умолчанию - email.

### uidField
Имя поля, которое используется для идентификации пользователя при переходе по ссылке.

Значение по умолчанию - id.

### exitTo
Перенаправляет авторизованного пользователя на указанную страницу.

Возможные значения - id целевой страницы.

Значение по умолчанию - пусто.

### resetTo
Страница, на которую будет указывать ссылка для восстановления паролей. Обязательный параметр.

Возможные значения - id целевой страницы.

Значение по умолчанию - id документа, в котором вызван контроллер.

### redirectTo
Перенаправляет на указанную страницу после успешного восстановления пароля.

Возможные значения - id целевой страницы.

Значение по умолчанию - пусто.

### skipTpl
Шаблон сообщения для авторизованного пользователя.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Reminder с ключом [+reminder.default_skipTpl+].

### formTpl
Шаблон формы для ввода идентификатора пользователя.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - пусто.

### resetTpl
Шаблон формы для ввода нового пароля. Если параметр не задан, то пароль будет сгенерирован автоматически.

Поля для ввода паролей должны называться password и repeatPassword. В форме должны также присутствовать скрытые поля с именами из параметров uidField и hashField. Значение для поля hashField задается через плейсхолдер [+user.hash+].

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - пусто.

### successTpl
Шаблон сообщения об успешной отправке письма со ссылкой для восстановления пароля. В шаблоне можно выводить плейсхолдеры с данными пользователя (username, email и т.д.).

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Reminder с ключом [+reminder.default_successTpl+].

### resetSuccessTpl
Шаблон сообщения об успешном восстановлении пароля. В шаблоне можно выводить плейсхолдеры с данными пользователя (username, email и т.д.), а также новый пароль (newpassword).

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Reminder с ключом [+reminder.default_resetSuccessTpl+].

### reportTpl
Шаблон письма со ссылкой для восстановления пароля. В шаблоне можно выводить плейсхолдеры с данными пользователя (username, email и т.д.), а также новый пароль (newpassword). Ссылка для восстановлени пароля в письме задается через плейсхолдер [+reset.url+]

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - запись из лексикона Reminder с ключом [+reminder.default_reportTpl+]..

### resetReportTpl
Шаблон письма об успешном восстановлении пароля. В шаблоне можно выводить плейсхолдеры с данными пользователя (username, email и т.д.), а также новый пароль (newpassword). Если не задан, то письмо пользователю отправляться не будет.

Возможные значения - имя шаблона, указанное по правилам задания шаблонов в DocLister.

Значение по умолчанию - пусто.

### rules
Правила валидации для формы идентификации пользователя.

Возможные значения - см. раздел "Валидация данных".

Значение по умолчанию - пусто.

### resetRules
Правила валидации для формы установки нового пароля. Если заданы правила валидации для полей password и repeatPassword, то при наличии для поля repeatPassword правила equals, оно будет автоматически скорректировано для проверки равенства значений полей password и repeatPassword:
```
"repeatPassword":{
    "required":"Введите пароль еще раз",
    "equals":{
        "params" : "Этот ключ в описании правила можно не задавать, он будет сформирован контроллером автоматически",
        "message":"Пароли не совпадают"
    }
}
```
Возможные значения - см. раздел "Валидация данных".

Значение по умолчанию - пусто.

### passwordLength
Длина пароля (если создается автоматически).

Возможные значения - число символов больше 6.

Значение по умолчанию - 6.
