/**
 * jQuery ddHTMLCleaner Plugin
 * @version 0.2 (2014-03-06)
 * 
 * @desc Плагин очистки HTML от ненужных атрибутов, стилей и пр.
 * 
 * @uses jQuery 1.10.2
 * 
 * Параметры, передаваемые в метод $.ddHTMLCleaner.clean:
 * @param html {string} - Текст, который нужно очистить. @required.
 * @param params {plain object} - Настройки.
 * @param params.validAttrsForAllTags {array} - Атрибуты, которые можно оставить для всех тегов. Default: ['title', 'class'].
 * @param params.validAttrs {plain object} - Разрешённые атрибуты для тегов. В качестве ключа используется имя тега, в качестве значения — массив разрешённых атрибутов. Default: {'img': ['src', 'alt', 'width', 'height'], 'a': ['href', 'target']}.
 * @param params.validStyles {array} - Стили, которые не нужно удалять из атрибута «style». Default: ['float', 'word-spacing'].
 * 
 * @copyright 2014, DivanDesign
 * http://www.DivanDesign.biz
 */

(function(f){f.ddHTMLCleaner={reg:{tag:/(<([a-z0-9]+))(.*?)\/?\s*>/ig,attr:/(([a-z0-9\-]+)=["\'])(.*?)[\'"](?:\s|$)*/ig,style:/([a-z\-]+)\s*?:.*?(?:;|$)/ig},defaults:{validAttrsForAllTags:["title","class"],validAttrs:{img:["src","alt","width","height"],a:["href","target"]},validStyles:["float","word-spacing"]},substr_replace:function(d,e,b,a){0>b&&(b+=d.length);a=void 0!==a?a:d.length;0>a&&(a=a+d.length-b);return d.slice(0,b)+e.substr(0,a)+e.slice(a)+d.slice(b+a)},clean:function(d,e){if(0==f.trim(d).length)return d;
var b=d,a=0,g,c,h;for(e=f.extend({},this.defaults,e||{});g=this.reg.tag.exec(d);){var l=g.index+g[1].length;if(0<f.trim(g[3]).length)for(;c=this.reg.attr.exec(g[3]);){var k=!1;if(0==f.trim(c[3]).length)k=!0;else if("style"==c[2])for(;h=this.reg.style.exec(c[3]);)-1==f.inArray(h[1],e.validStyles)&&(b=this.substr_replace(b,"",l+c.index+c[1].length+h.index-a,h[0].length),a+=h[0].length);else-1!=f.inArray(c[2],e.validAttrsForAllTags)||e.validAttrs[g[2]]&&-1!=f.inArray(c[2],e.validAttrs[g[2]])||(k=!0);
k&&(b=this.substr_replace(b,"",l+c.index-a,c[0].length),a+=c[0].length)}}return b}}})(jQuery);