<?php 
if(IN_MANAGER_MODE!="true") die("<b>INCLUDE_ORDERING_ERROR</b><br /><br />Please use the MODX Content Manager instead of accessing this file directly.");
if(!$modx->hasPermission('save_module')) {	
	$modx->webAlertAndQuit($_lang["error_no_privileges"]);
}

$id = intval($_POST['id']);
$name = $modx->db->escape(trim($_POST['name']));
$description = $modx->db->escape($_POST['description']);
$resourcefile = $modx->db->escape($_POST['resourcefile']);
$enable_resource = $_POST['enable_resource']=='on' ? 1 : 0 ;
$icon = $modx->db->escape($_POST['icon']);
//$category = intval($_POST['category']);
$disabled = $_POST['disabled']=='on' ? 1 : 0 ;
$wrap = $_POST['wrap']=='on' ? 1 : 0 ;
$locked = $_POST['locked']=='on' ? 1 : 0 ;
$modulecode = $modx->db->escape($_POST['post']);
$properties = $modx->db->escape($_POST['properties']);
$enable_sharedparams = $_POST['enable_sharedparams']=='on' ? 1 : 0 ;
$guid = $modx->db->escape($_POST['guid']);
$parse_docblock = $_POST['parse_docblock']=="1" ? '1' : '0';

//Kyle Jaebker - added category support
if (empty($_POST['newcategory']) && $_POST['categoryid'] > 0) {
    $categoryid = intval($_POST['categoryid']);
} elseif (empty($_POST['newcategory']) && $_POST['categoryid'] <= 0) {
    $categoryid = 0;
} else {
    include_once(MODX_MANAGER_PATH.'includes/categories.inc.php');
    $categoryid = checkCategory($_POST['newcategory']);
    if (!$categoryid) {
        $categoryid = newCategory($_POST['newcategory']);
    }
}

if($name=="") $name = "Untitled module";

if($parse_docblock) {
    $parsed       = $modx->parseDocBlockFromString($modulecode, true);
    $name         = isset($parsed['name']) ? $parsed['name'] : $name;
    $properties   = isset($parsed['properties']) ? $parsed['properties'] : $properties;
    $guid         = isset($parsed['guid']) ? $parsed['guid'] : $guid;
    $enable_sharedparams = isset($parsed['shareparams']) ? intval($parsed['shareparams']) : $enable_sharedparams;
        
    $description  = isset($parsed['description']) ? $parsed['description'] : $description;
    $version      = isset($parsed['version']) ? '<b>'.$parsed['version'].'</b> ' : '';
    if($version) {
        $description = $version . trim(preg_replace('/(<b>.+?)+(<\/b>)/i', '', $description));
    }
    if(isset($parsed['modx_category'])) {
        include_once(MODX_MANAGER_PATH.'includes/categories.inc.php');
        $categoryid = getCategory($parsed['modx_category']);
    }
}

switch ($_POST['mode']) {
    case '107':
		// invoke OnBeforeModFormSave event
		$modx->invokeEvent("OnBeforeModFormSave",
							array(
								"mode"	=> "new",
								"id"	=> $id
							));
								
		// disallow duplicate names for new modules
		$rs = $modx->db->select('count(id)', $modx->getFullTableName('site_modules'), "name='{$name}'");
		$count = $modx->db->getValue($rs);
		if($count > 0) {
			$modx->manager->saveFormValues(107);
			$modx->webAlertAndQuit(sprintf($_lang['duplicate_name_found_module'], $name), "index.php?a=107");
		}

		// save the new module
		$newid = $modx->db->insert(
			array(
				'name'                => $name,
				'description'         => $description,
				'disabled'            => $disabled,
				'wrap'                => $wrap,
				'locked'              => $locked,
				'icon'                => $icon,
				'resourcefile'        => $resourcefile,
				'enable_resource'     => $enable_resource,
				'category'            => $categoryid,
				'enable_sharedparams' => $enable_sharedparams,
				'guid'                => $guid,
				'modulecode'          => $modulecode,
				'properties'          => $properties,
			), $modx->getFullTableName('site_modules'));
			
			// save user group access permissions
			saveUserGroupAccessPermissons();
			
			// invoke OnModFormSave event
			$modx->invokeEvent("OnModFormSave",
								array(
									"mode"	=> "new",
									"id"	=> $newid
								));

		// Set the item name for logger
		$_SESSION['itemname'] = $name;

			// empty cache
			$modx->clearCache('full');

			// finished emptying cache - redirect
			if($_POST['stay']!='') {
				$a = ($_POST['stay']=='2') ? "108&id=$newid":"107";
				$header="Location: index.php?a=".$a."&r=2&stay=".$_POST['stay'];
				header($header);
			} else {
				$header="Location: index.php?a=106&r=2";
				header($header);
			}
        break;
    case '108':
		// invoke OnBeforeModFormSave event
		$modx->invokeEvent("OnBeforeModFormSave",
							array(
								"mode"	=> "upd",
								"id"	=> $id
							));

		// disallow duplicate names for new modules
		$rs = $modx->db->select('count(id)', $modx->getFullTableName('site_modules'), "name='{$name}' AND id!='{$id}'");
		if ($modx->db->getValue($rs) > 0) {
			$modx->manager->saveFormValues(108);
			$modx->webAlertAndQuit(sprintf($_lang['duplicate_name_found_module'], $name), "index.php?a=108&id={$id}");
		}

		// save the edited module	
		$modx->db->update(
			array(
				'name'                => $name,
				'description'         => $description,
				'icon'                => $icon,
				'enable_resource'     => $enable_resource,
				'resourcefile'        => $resourcefile,
				'disabled'            => $disabled,
				'wrap'                => $wrap,
				'locked'              => $locked,
				'category'            => $categoryid,
				'enable_sharedparams' => $enable_sharedparams,
				'guid'                => $guid,
				'modulecode'          => $modulecode,
				'properties'          => $properties,
			), $modx->getFullTableName('site_modules'), "id='{$id}'");

			// save user group access permissions
			saveUserGroupAccessPermissons();
				
			// invoke OnModFormSave event
			$modx->invokeEvent("OnModFormSave",
								array(
									"mode"	=> "upd",
									"id"	=> $id
								));	

		// Set the item name for logger
		$_SESSION['itemname'] = $name;

			// empty cache
			$modx->clearCache('full');

			// finished emptying cache - redirect	
			if($_POST['stay']!='') {
				$a = ($_POST['stay']=='2') ? "108&id=$id":"107";
				$header="Location: index.php?a=".$a."&r=2&stay=".$_POST['stay'];
				header($header);
			} else {
				$modx->unlockElement(6, $id);
				$header="Location: index.php?a=106&r=2";
				header($header);
			}
        break;        
    default:
    	$modx->webAlertAndQuit("No operation set in request.");
}

// saves module user group access
function saveUserGroupAccessPermissons(){
	global $modx;
	global $id,$newid;
	global $use_udperms;

	if($newid) $id = $newid;
	$usrgroups = $_POST['usrgroups'];

	// check for permission update access
	if($use_udperms==1) {
		// delete old permissions on the module
		$modx->db->delete($modx->getFullTableName("site_module_access"), "module='{$id}'");
		if(is_array($usrgroups)) {
			foreach ($usrgroups as $value) {
				$modx->db->insert(
					array(
						'module'    => $id,
						'usergroup' => stripslashes($value),
					), $modx->getFullTableName('site_module_access'));
			}
		}
	}
}
?>
